# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p870 -iterations=1 -instruction-tables=full < %s | FileCheck %s

# Worst case for vsha2ms should be that of LMUL=8 and SEW=64.
vsha2ms.vv v4, v8, v12

# SEW is only e32 or e64

vsetvli zero, zero, e32, m1, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e32, m2, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e32, m4, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e32, m8, tu, mu
vsha2ms.vv v8, v16, v24
vsha2ch.vv v8, v16, v24
vsha2cl.vv v8, v16, v24

vsetvli zero, zero, e64, m1, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e64, m2, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e64, m4, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e64, m8, tu, mu
vsha2ms.vv v8, v16, v24
vsha2ch.vv v8, v16, v24
vsha2cl.vv v8, v16, v24

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Branch:2 SiFiveP800IEXQ4, SiFiveP800IEXQ5
# CHECK-NEXT: [1]   - SiFiveP800Div:1
# CHECK-NEXT: [2]   - SiFiveP800FEXQ0:1
# CHECK-NEXT: [3]   - SiFiveP800FEXQ1:1
# CHECK-NEXT: [4]   - SiFiveP800FloatArith:2 SiFiveP800FEXQ0, SiFiveP800FEXQ1
# CHECK-NEXT: [5]   - SiFiveP800FloatDiv:1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ0:1
# CHECK-NEXT: [7]   - SiFiveP800IEXQ1:1
# CHECK-NEXT: [8]   - SiFiveP800IEXQ2:1
# CHECK-NEXT: [9]   - SiFiveP800IEXQ3:1
# CHECK-NEXT: [10]  - SiFiveP800IEXQ4:1
# CHECK-NEXT: [11]  - SiFiveP800IEXQ5:1
# CHECK-NEXT: [12]  - SiFiveP800IntArith:4 SiFiveP800IEXQ0, SiFiveP800IEXQ1, SiFiveP800IEXQ2, SiFiveP800IEXQ3
# CHECK-NEXT: [13]  - SiFiveP800LD:1
# CHECK-NEXT: [14]  - SiFiveP800LDST:2
# CHECK-NEXT: [15]  - SiFiveP800Load:3 SiFiveP800LDST, SiFiveP800LDST, SiFiveP800LD
# CHECK-NEXT: [16]  - SiFiveP800Mul:2 SiFiveP800IEXQ1, SiFiveP800IEXQ3
# CHECK-NEXT: [17]  - SiFiveP800VDiv:1
# CHECK-NEXT: [18]  - SiFiveP800VEXQ0:1
# CHECK-NEXT: [19]  - SiFiveP800VEXQ1:1
# CHECK-NEXT: [20]  - SiFiveP800VFloatDiv:1
# CHECK-NEXT: [21]  - SiFiveP800VLD:1
# CHECK-NEXT: [22]  - SiFiveP800VST:1
# CHECK-NEXT: [23]  - SiFiveP800VectorArith:2 SiFiveP800VEXQ0, SiFiveP800VEXQ1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      3     8.00                         3     SiFiveP800VEXQ0[8],SiFiveP800VectorArith[8] VSHA2MS_VV                vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      3     1.00                         3     SiFiveP800VEXQ0,SiFiveP800VectorArith      VSHA2MS_VV                 vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                         3     SiFiveP800VEXQ0,SiFiveP800VectorArith      VSHA2CH_VV                 vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                         3     SiFiveP800VEXQ0,SiFiveP800VectorArith      VSHA2CL_VV                 vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      3     2.00                         3     SiFiveP800VEXQ0[2],SiFiveP800VectorArith[2] VSHA2MS_VV                vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  1      3     2.00                         3     SiFiveP800VEXQ0[2],SiFiveP800VectorArith[2] VSHA2CH_VV                vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  1      3     2.00                         3     SiFiveP800VEXQ0[2],SiFiveP800VectorArith[2] VSHA2CL_VV                vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      3     4.00                         3     SiFiveP800VEXQ0[4],SiFiveP800VectorArith[4] VSHA2MS_VV                vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  1      3     4.00                         3     SiFiveP800VEXQ0[4],SiFiveP800VectorArith[4] VSHA2CH_VV                vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  1      3     4.00                         3     SiFiveP800VEXQ0[4],SiFiveP800VectorArith[4] VSHA2CL_VV                vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      3     8.00                         3     SiFiveP800VEXQ0[8],SiFiveP800VectorArith[8] VSHA2MS_VV                vsha2ms.vv	v8, v16, v24
# CHECK-NEXT:  1      3     8.00                         3     SiFiveP800VEXQ0[8],SiFiveP800VectorArith[8] VSHA2CH_VV                vsha2ch.vv	v8, v16, v24
# CHECK-NEXT:  1      3     8.00                         3     SiFiveP800VEXQ0[8],SiFiveP800VectorArith[8] VSHA2CL_VV                vsha2cl.vv	v8, v16, v24
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      3     1.00                         3     SiFiveP800VEXQ0,SiFiveP800VectorArith      VSHA2MS_VV                 vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                         3     SiFiveP800VEXQ0,SiFiveP800VectorArith      VSHA2CH_VV                 vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                         3     SiFiveP800VEXQ0,SiFiveP800VectorArith      VSHA2CL_VV                 vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      3     2.00                         3     SiFiveP800VEXQ0[2],SiFiveP800VectorArith[2] VSHA2MS_VV                vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  1      3     2.00                         3     SiFiveP800VEXQ0[2],SiFiveP800VectorArith[2] VSHA2CH_VV                vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  1      3     2.00                         3     SiFiveP800VEXQ0[2],SiFiveP800VectorArith[2] VSHA2CL_VV                vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      3     4.00                         3     SiFiveP800VEXQ0[4],SiFiveP800VectorArith[4] VSHA2MS_VV                vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  1      3     4.00                         3     SiFiveP800VEXQ0[4],SiFiveP800VectorArith[4] VSHA2CH_VV                vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  1      3     4.00                         3     SiFiveP800VEXQ0[4],SiFiveP800VectorArith[4] VSHA2CL_VV                vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      3     8.00                         3     SiFiveP800VEXQ0[8],SiFiveP800VectorArith[8] VSHA2MS_VV                vsha2ms.vv	v8, v16, v24
# CHECK-NEXT:  1      3     8.00                         3     SiFiveP800VEXQ0[8],SiFiveP800VectorArith[8] VSHA2CH_VV                vsha2ch.vv	v8, v16, v24
# CHECK-NEXT:  1      3     8.00                         3     SiFiveP800VEXQ0[8],SiFiveP800VectorArith[8] VSHA2CL_VV                vsha2cl.vv	v8, v16, v24

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Div
# CHECK-NEXT: [1]   - SiFiveP800FEXQ0
# CHECK-NEXT: [2]   - SiFiveP800FEXQ1
# CHECK-NEXT: [3]   - SiFiveP800FloatDiv
# CHECK-NEXT: [4]   - SiFiveP800IEXQ0
# CHECK-NEXT: [5]   - SiFiveP800IEXQ1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ2
# CHECK-NEXT: [7]   - SiFiveP800IEXQ3
# CHECK-NEXT: [8]   - SiFiveP800IEXQ4
# CHECK-NEXT: [9]   - SiFiveP800IEXQ5
# CHECK-NEXT: [10]  - SiFiveP800LD
# CHECK-NEXT: [11.0] - SiFiveP800LDST
# CHECK-NEXT: [11.1] - SiFiveP800LDST
# CHECK-NEXT: [12]  - SiFiveP800VDiv
# CHECK-NEXT: [13]  - SiFiveP800VEXQ0
# CHECK-NEXT: [14]  - SiFiveP800VEXQ1
# CHECK-NEXT: [15]  - SiFiveP800VFloatDiv
# CHECK-NEXT: [16]  - SiFiveP800VLD
# CHECK-NEXT: [17]  - SiFiveP800VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]
# CHECK-NEXT:  -      -      -      -      -     8.00    -      -      -      -      -      -      -      -     98.00   -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     8.00    -      -      -      -     vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00    -      -      -      -     vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00    -      -      -      -     vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00    -      -      -      -     vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     8.00    -      -      -      -     vsha2ms.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     8.00    -      -      -      -     vsha2ch.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     8.00    -      -      -      -     vsha2cl.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00    -      -      -      -     vsha2ms.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00    -      -      -      -     vsha2ch.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     4.00    -      -      -      -     vsha2cl.vv	v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     8.00    -      -      -      -     vsha2ms.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     8.00    -      -      -      -     vsha2ch.vv	v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     8.00    -      -      -      -     vsha2cl.vv	v8, v16, v24
