; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumb-eabi -mcpu=arm1156t2-s %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-DSP
; RUN: llc -mtriple=thumb-eabi -mcpu=cortex-m3 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-NO-DSP
; RUN: llc -mtriple=thumbv7em-eabi %s -o - | FileCheck %s -check-prefixes=CHECK,CHECK-DSP
; RUN: llc -mtriple=thumbv8m.main-none-eabi %s -o - | FileCheck %s -check-prefixes=CHECK,CHECK-NO-DSP
; RUN: llc -mtriple=thumbv8m.main-none-eabi -mattr=+dsp %s -o - | FileCheck %s -check-prefixes=CHECK,CHECK-DSP

define i32 @test0(i8 %A) {
; CHECK-LABEL: test0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    sxtb r0, r0
; CHECK-NEXT:    bx lr
	%B = sext i8 %A to i32
	ret i32 %B
}

define signext i8 @test1(i32 %A)  {
; CHECK-LABEL: test1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    sbfx r0, r0, #8, #8
; CHECK-NEXT:    bx lr
	%B = lshr i32 %A, 8
	%C = shl i32 %A, 24
	%D = or i32 %B, %C
	%E = trunc i32 %D to i8
	ret i8 %E
}

define signext i32 @test2(i32 %A, i32 %X)  {
; CHECK-DSP-LABEL: test2:
; CHECK-DSP:       @ %bb.0:
; CHECK-DSP-NEXT:    sxtab r0, r1, r0, ror #8
; CHECK-DSP-NEXT:    bx lr
;
; CHECK-NO-DSP-LABEL: test2:
; CHECK-NO-DSP:       @ %bb.0:
; CHECK-NO-DSP-NEXT:    sbfx r0, r0, #8, #8
; CHECK-NO-DSP-NEXT:    add r0, r1
; CHECK-NO-DSP-NEXT:    bx lr
	%B = lshr i32 %A, 8
	%C = shl i32 %A, 24
	%D = or i32 %B, %C
	%E = trunc i32 %D to i8
	%F = sext i8 %E to i32
	%G = add i32 %F, %X
	ret i32 %G
}

define i32 @test3(i32 %A, i32 %X) {
; CHECK-DSP-LABEL: test3:
; CHECK-DSP:       @ %bb.0:
; CHECK-DSP-NEXT:    sxtah r0, r0, r1, ror #8
; CHECK-DSP-NEXT:    bx lr
;
; CHECK-NO-DSP-LABEL: test3:
; CHECK-NO-DSP:       @ %bb.0:
; CHECK-NO-DSP-NEXT:    sbfx r1, r1, #8, #16
; CHECK-NO-DSP-NEXT:    add r0, r1
; CHECK-NO-DSP-NEXT:    bx lr
  %X.hi = lshr i32 %X, 8
  %X.trunc = trunc i32 %X.hi to i16
  %addend = sext i16 %X.trunc to i32
  %sum = add i32 %A, %addend
  ret i32 %sum
}

define signext i32 @test4(i32 %A, i32 %X)  {
; CHECK-DSP-LABEL: test4:
; CHECK-DSP:       @ %bb.0:
; CHECK-DSP-NEXT:    sxtab r0, r1, r0, ror #16
; CHECK-DSP-NEXT:    bx lr
;
; CHECK-NO-DSP-LABEL: test4:
; CHECK-NO-DSP:       @ %bb.0:
; CHECK-NO-DSP-NEXT:    sbfx r0, r0, #16, #8
; CHECK-NO-DSP-NEXT:    add r0, r1
; CHECK-NO-DSP-NEXT:    bx lr
	%B = lshr i32 %A, 16
	%C = shl i32 %A, 16
	%D = or i32 %B, %C
	%E = trunc i32 %D to i8
        %F = sext i8 %E to i32
        %G = add i32 %F, %X
	ret i32 %G
}

define signext i32 @test5(i32 %A, i32 %X)  {
; CHECK-DSP-LABEL: test5:
; CHECK-DSP:       @ %bb.0:
; CHECK-DSP-NEXT:    sxtah r0, r1, r0, ror #24
; CHECK-DSP-NEXT:    bx lr
;
; CHECK-NO-DSP-LABEL: test5:
; CHECK-NO-DSP:       @ %bb.0:
; CHECK-NO-DSP-NEXT:    sxth.w r0, r0, ror #24
; CHECK-NO-DSP-NEXT:    add r0, r1
; CHECK-NO-DSP-NEXT:    bx lr
	%B = lshr i32 %A, 24
	%C = shl i32 %A, 8
	%D = or i32 %B, %C
	%E = trunc i32 %D to i16
	%F = sext i16 %E to i32
	%G = add i32 %F, %X
	ret i32 %G
}
