



#
# In order to have Orochi compiled with CUDA, you need to define OROCHI_ENABLE_CUEW, and add the CUDA include path to your Orochi project.
#
# If your project is using cmake, this script can be included:
# it helps to configure your Orochi project
# for example, with a line looking like that:
#   include(${CMAKE_SOURCE_DIR}/contrib/Orochi/Orochi/enable_cuew.cmake)
#
#


cmake_minimum_required(VERSION 3.10)


# Function to join paths
function(join_paths result basePath additionalPath)
	if(WIN32)
		set(pathSeparator "\\")
	else()
		set(pathSeparator "/")
	endif()

	string(REGEX REPLACE "[/\\]+$" "" basePath "${basePath}")
	set(joinedPath "${basePath}${pathSeparator}${additionalPath}")
	set(${result} "${joinedPath}" PARENT_SCOPE)
endfunction()

# Function to check if a path is valid
function(path_ok result inPath)
	if(EXISTS "${inPath}" AND IS_DIRECTORY "${inPath}")
		set(${result} TRUE PARENT_SCOPE)
	else()
		set(${result} FALSE PARENT_SCOPE)
	endif()
endfunction()

# Region generated by Orochi Summoner
#REGION_PREMAKE_START CudaPath

set(BEST_CUDA_VERSION_NAME "12.2")
set(BEST_CUDA_ENVVAR "CUDA_PATH_V12_2")
set(BEST_CUDA_PATH_LINUX "/usr/local/cuda-12.2")
set(BEST_CUDA_PATH_WINDOWS "C:/Program Files/NVIDIA GPU Computing Toolkit/CUDA/v12.2")
set(BACKUP_CUDA_ENVVAR "CUDA_PATH")
set(BACKUP_CUDA_PATH_LINUX "/usr/local/cuda")

# REGION_PREMAKE_END

# First, try the best CUDA paths
if(DEFINED ENV{${BEST_CUDA_ENVVAR}})
	set(cuda_path $ENV{${BEST_CUDA_ENVVAR}})
endif()

# if not found in envvar, try if path exist ( linux )
if(NOT cuda_path)
	path_ok(cuda_path_ok ${BEST_CUDA_PATH_LINUX})
	if(cuda_path_ok)
		set(cuda_path ${BEST_CUDA_PATH_LINUX})
	endif()
endif()

# try the windows path
if(NOT cuda_path)
	path_ok(cuda_path_ok ${BEST_CUDA_PATH_WINDOWS})
	if(cuda_path_ok)
		set(cuda_path ${BEST_CUDA_PATH_WINDOWS})
	endif()
endif()

if(NOT cuda_path)
	message(WARNING "The required version of CUDA for this Orochi is not found: ${BEST_CUDA_VERSION_NAME}. It's advised that you install this version.")
endif()

# If CUDA still not found, search the "backup" paths
if(NOT cuda_path)
	if(DEFINED ENV{${BACKUP_CUDA_ENVVAR}})
		set(cuda_path $ENV{${BACKUP_CUDA_ENVVAR}})
	endif()
endif()

if(NOT cuda_path)
	path_ok(cuda_path_ok ${BACKUP_CUDA_PATH_LINUX})
	if(cuda_path_ok)
		set(cuda_path ${BACKUP_CUDA_PATH_LINUX})
	endif()
endif()

# Enable CUEW if CUDA is forced or if we find the CUDA SDK folder
option(FORCE_CUDA "Force enable CUDA" OFF)
if(FORCE_CUDA OR cuda_path)
	message(STATUS "CUEW is enabled.")
	add_definitions(-DOROCHI_ENABLE_CUEW)
endif()


# If we find the CUDA SDK folder, add it to the include dir
if(cuda_path)
	message(STATUS "CUDA SDK install folder found: ${cuda_path}")
	join_paths(cuda_include_path ${cuda_path} "include")
	include_directories(${cuda_include_path})
else()
	if(FORCE_CUDA)
		message(WARNING "WARNING: CUEW is enabled but it may not compile because CUDA SDK folder (CUDA_PATH) not found. You should install the CUDA SDK, or set CUDA_PATH.")
	else()
		message(WARNING "WARNING: CUEW is automatically disabled because CUDA SDK folder (CUDA_PATH) not found. You can force CUEW with the --forceCuda argument.")
	endif()
endif()
