// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provision a CIDR to an IPAM pool. You can use this action to provision new
// CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool
// within it.
//
// For more information, see [Provision CIDRs to pools] in the Amazon VPC IPAM User Guide.
//
// [Provision CIDRs to pools]: https://docs.aws.amazon.com/vpc/latest/ipam/prov-cidr-ipam.html
func (c *Client) ProvisionIpamPoolCidr(ctx context.Context, params *ProvisionIpamPoolCidrInput, optFns ...func(*Options)) (*ProvisionIpamPoolCidrOutput, error) {
	if params == nil {
		params = &ProvisionIpamPoolCidrInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ProvisionIpamPoolCidr", params, optFns, c.addOperationProvisionIpamPoolCidrMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ProvisionIpamPoolCidrOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ProvisionIpamPoolCidrInput struct {

	// The ID of the IPAM pool to which you want to assign a CIDR.
	//
	// This member is required.
	IpamPoolId *string

	// The CIDR you want to assign to the IPAM pool. Either "NetmaskLength" or "Cidr"
	// is required. This value will be null if you specify "NetmaskLength" and will be
	// filled in during the provisioning process.
	Cidr *string

	// A signed document that proves that you are authorized to bring a specified IP
	// address range to Amazon using BYOIP. This option only applies to IPv4 and IPv6
	// pools in the public scope.
	CidrAuthorizationContext *types.IpamCidrAuthorizationContext

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
	ClientToken *string

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Verification token ID. This option only applies to IPv4 and IPv6 pools in the
	// public scope.
	IpamExternalResourceVerificationTokenId *string

	// The netmask length of the CIDR you'd like to provision to a pool. Can be used
	// for provisioning Amazon-provided IPv6 CIDRs to top-level pools and for
	// provisioning CIDRs to pools with source pools. Cannot be used to provision BYOIP
	// CIDRs to top-level pools. Either "NetmaskLength" or "Cidr" is required.
	NetmaskLength *int32

	// The method for verifying control of a public IP address range. Defaults to
	// remarks-x509 if not specified. This option only applies to IPv4 and IPv6 pools
	// in the public scope.
	VerificationMethod types.VerificationMethod

	noSmithyDocumentSerde
}

type ProvisionIpamPoolCidrOutput struct {

	// Information about the provisioned CIDR.
	IpamPoolCidr *types.IpamPoolCidr

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationProvisionIpamPoolCidrMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpProvisionIpamPoolCidr{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpProvisionIpamPoolCidr{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ProvisionIpamPoolCidr"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opProvisionIpamPoolCidrMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpProvisionIpamPoolCidrValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opProvisionIpamPoolCidr(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpProvisionIpamPoolCidr struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpProvisionIpamPoolCidr) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpProvisionIpamPoolCidr) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*ProvisionIpamPoolCidrInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *ProvisionIpamPoolCidrInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opProvisionIpamPoolCidrMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpProvisionIpamPoolCidr{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opProvisionIpamPoolCidr(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ProvisionIpamPoolCidr",
	}
}
