/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "../ballistics.h"
#include "../gfx.h"
#include "../log.h"

void wgxDrawLaserShot(struct Projectilepos_bal *prjpos, void* info)
{
    int tx=prjpos->x;
    int ty=prjpos->y;
    int otx=prjpos->ox;
    int oty=prjpos->oy;

    
    int sx=gfxTerrainToScreenXCoord(tx);
    int sy=gfxTerrainToScreenYCoord(ty);
    
    gfxDrawArea(otx-gfxScaleScreenToTerrainXDimen(2),
		oty-gfxScaleScreenToTerrainYDimen(2), 
		gfxScaleScreenToTerrainXDimen(5), 
		gfxScaleScreenToTerrainYDimen(5));
    
    if(tx==-1 && ty==-1) return;
    
    ggiPutPixel(gfx_vis, 
		sx,
		sy,
		gfx_white);
    ggiPutPixel(gfx_vis, 
		sx+1,
		sy,
		gfx_white);
    ggiPutPixel(gfx_vis, 
		sx-1,
		sy,
		gfx_white);
    ggiPutPixel(gfx_vis, 
		sx,
		sy+1,
		gfx_white);
    ggiPutPixel(gfx_vis, 
		sx,
		sy-1,
		gfx_white);
    
    /* we might need to redraw walls */
    gfxDrawWalls(otx-gfxScaleScreenToTerrainXDimen(2),
		 oty-gfxScaleScreenToTerrainYDimen(2), 
		 gfxScaleScreenToTerrainXDimen(5), 
		 gfxScaleScreenToTerrainYDimen(5));
}

void wgxDrawLaserExplosion(void* info)
{
    ggi_color c;
    double tx1=((struct LineExplosion_wep*)info)->x1;
    double ty1=((struct LineExplosion_wep*)info)->y1;
    double tx2=((struct LineExplosion_wep*)info)->x2;
    double ty2=((struct LineExplosion_wep*)info)->y2;
    int duration=((struct LineExplosion_wep*)info)->duration;
    double sx1=gfxTerrainToScreenXCoord(tx1); 
    double sy1=gfxTerrainToScreenYCoord(ty1); 
    double sx2=gfxTerrainToScreenXCoord(tx2); 
    double sy2=gfxTerrainToScreenYCoord(ty2);
	
    if(duration > 0)
    {
        c.r=0x24;
        c.b=0x4000 + ((duration%5)*0x2FFF);
        c.g=0x24;
        c.a=0xFF;
        ggiSetGCForeground(gfx_vis, ggiMapColor(gfx_vis, &c));
        ggiDrawLine(gfx_vis, sx1, sy1, sx2, sy2);
    }
    else
    {
        /* Clear the area */
        if(tx1 < tx2)
        {
            gfxDrawArea(tx1-gfxScaleScreenToTerrainXDimen(2),
				ty1-gfxScaleScreenToTerrainYDimen(2), 
				tx2-tx1+gfxScaleScreenToTerrainXDimen(4), 
				ty2-ty1+gfxScaleScreenToTerrainYDimen(4));
        }
        else
        {
            gfxDrawArea(tx2-gfxScaleScreenToTerrainXDimen(2),
				ty1-gfxScaleScreenToTerrainYDimen(2), 
				tx1-tx2+gfxScaleScreenToTerrainXDimen(4), 
				ty2-ty1+gfxScaleScreenToTerrainYDimen(4));
        }
            
    }
}
