/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.PropertyAccessException;
import org.mvel.UnresolveablePropertyException;
import org.mvel.ast.ContextDeepPropertyNode;
import org.mvel.ast.LiteralDeepPropertyNode;
import org.mvel.ast.LiteralNode;
import org.mvel.ast.ThisValDeepPropertyNode;
import org.mvel.ast.ThisValNode;
import org.mvel.ast.VarPropertyNode;
import org.mvel.ast.VariableDeepPropertyNode;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ThisLiteral;

public class PropertyASTNode
extends ASTNode {
    private ASTNode wrappedNode;

    public PropertyASTNode(char[] expr, int start, int end, int fields) {
        super(expr, start, end, fields);
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        catch (NullPointerException e) {
            if (this.wrappedNode == null) {
                return this.initializePropertyNode(ctx, thisValue, factory);
            }
            throw e;
        }
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return super.getReducedValue(ctx, thisValue, factory);
    }

    private Object initializePropertyNode(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if ((this.fields & 0x10000) != 0) {
            this.wrappedNode = new LiteralNode(new String(this.name));
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        if ((this.fields & 1) != 0) {
            if ((this.fields & 0x4000) != 0) {
                this.wrappedNode = new ThisValNode(this.name, this.fields);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            this.wrappedNode = new LiteralNode(this.literal);
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        if ((this.fields & 2) != 0) {
            String s = this.getAbsoluteRootElement();
            if (AbstractParser.LITERALS.containsKey(s)) {
                Object literal = AbstractParser.LITERALS.get(s);
                if (literal == ThisLiteral.class) {
                    this.wrappedNode = new ThisValDeepPropertyNode(this.name, this.fields);
                    return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
                }
                this.wrappedNode = new LiteralDeepPropertyNode(this.name, this.fields, literal);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            if (factory != null && factory.isResolveable(s)) {
                this.wrappedNode = new VariableDeepPropertyNode(this.name, this.fields);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            if (ctx != null) {
                try {
                    this.wrappedNode = new ContextDeepPropertyNode(this.name, this.fields);
                    return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
                }
                catch (PropertyAccessException e) {
                    Object sa = this.tryStaticAccess(ctx, factory);
                    if (sa == null) {
                        throw e;
                    }
                    this.wrappedNode = new LiteralNode(sa);
                    return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
                }
            }
        } else {
            String s;
            if (factory != null && factory.isResolveable(s = this.getAbsoluteName())) {
                this.wrappedNode = s.length() < this.name.length ? new VariableDeepPropertyNode(this.name, this.fields) : new VarPropertyNode(this.name, this.fields, s);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            if (ctx != null) {
                this.wrappedNode = new ContextDeepPropertyNode(this.name, this.fields);
                try {
                    return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw new UnresolveablePropertyException(this);
                }
            }
            if (this.isOperator()) {
                throw new CompileException("incomplete statement");
            }
            throw new UnresolveablePropertyException(this);
        }
        return null;
    }

    public ASTNode getWrappedNode() {
        return this.wrappedNode;
    }
}

