// SPDX-License-Identifier: GPL-2.0-only

//! The StGit stack data structure.
mod access;
mod iter;
mod serde;
#[allow(clippy::module_inception)]
mod stack;
mod state;
mod transaction;
mod upgrade;

pub(crate) use access::{StackAccess, StackStateAccess};
pub(crate) use stack::{state_refname_from_branch_name, InitializationPolicy, Stack};
pub(crate) use state::{PatchState, StackState};
pub(crate) use transaction::{Error as TransactionError, StackTransaction};
