//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvbufferpropagatedattachmentskey?language=objc)
    pub static kCVBufferPropagatedAttachmentsKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvbuffernonpropagatedattachmentskey?language=objc)
    pub static kCVBufferNonPropagatedAttachmentsKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvbuffermovietimekey?language=objc)
    pub static kCVBufferMovieTimeKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvbuffertimevaluekey?language=objc)
    pub static kCVBufferTimeValueKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvbuffertimescalekey?language=objc)
    pub static kCVBufferTimeScaleKey: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvattachmentmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CVAttachmentMode(pub u32);
impl CVAttachmentMode {
    #[doc(alias = "kCVAttachmentMode_ShouldNotPropagate")]
    pub const ShouldNotPropagate: Self = Self(0);
    #[doc(alias = "kCVAttachmentMode_ShouldPropagate")]
    pub const ShouldPropagate: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVAttachmentMode {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVAttachmentMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Base type for all CoreVideo buffers
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvbuffer?language=objc)
#[doc(alias = "CVBufferRef")]
#[repr(C)]
pub struct CVBuffer {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CVBuffer {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CVBuffer"> for CVBuffer {}
);

impl CVBuffer {
    /// Sets or adds a attachment of a CVBuffer object
    ///
    /// You can attach any CF object to a CVBuffer object to store additional information. CVBufferGetAttachment stores an attachement identified by a key. If the key doesn't exist, the attachment will be added. If the key does exist, the existing attachment will be replaced. In bouth cases the retain count of the attachment will be incremented. The value can be any CFType but nil has no defined behavior.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// Parameter `key`: Key in form of a CFString identifying the desired attachment.
    ///
    /// Parameter `value`: Attachment in form af a CF object.
    ///
    /// Parameter `attachmentMode`: Specifies which attachment mode is desired for this attachment.   A particular attachment key may only exist in
    /// a single mode at a time.
    ///
    /// # Safety
    ///
    /// `value` should be of the correct type.
    #[doc(alias = "CVBufferSetAttachment")]
    #[inline]
    pub unsafe fn set_attachment(
        &self,
        key: &CFString,
        value: &CFType,
        attachment_mode: CVAttachmentMode,
    ) {
        extern "C-unwind" {
            fn CVBufferSetAttachment(
                buffer: &CVBuffer,
                key: &CFString,
                value: &CFType,
                attachment_mode: CVAttachmentMode,
            );
        }
        unsafe { CVBufferSetAttachment(self, key, value, attachment_mode) }
    }

    /// Returns a specific attachment of a CVBuffer object
    ///
    /// You can attach any CF object to a CVBuffer object to store additional information. CVBufferGetAttachment retrieves an attachement identified by a key.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// Parameter `key`: Key in form of a CFString identifying the desired attachment.
    ///
    /// Parameter `attachmentMode`: Returns the mode of the attachment, if desired.  May be NULL.
    ///
    /// Returns: If found the attachment object
    ///
    /// # Safety
    ///
    /// `attachment_mode` must be a valid pointer or null.
    #[doc(alias = "CVBufferGetAttachment")]
    #[deprecated]
    #[inline]
    pub unsafe fn get_attachment(
        &self,
        key: &CFString,
        attachment_mode: *mut CVAttachmentMode,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CVBufferGetAttachment(
                buffer: &CVBuffer,
                key: &CFString,
                attachment_mode: *mut CVAttachmentMode,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CVBufferGetAttachment(self, key, attachment_mode) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Removes a specific attachment of a CVBuffer object
    ///
    /// CVBufferRemoveAttachment removes an attachement identified by a key. If found the attachement is removed and the retain count decremented.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// Parameter `key`: Key in form of a CFString identifying the desired attachment.
    #[doc(alias = "CVBufferRemoveAttachment")]
    #[inline]
    pub fn remove_attachment(&self, key: &CFString) {
        extern "C-unwind" {
            fn CVBufferRemoveAttachment(buffer: &CVBuffer, key: &CFString);
        }
        unsafe { CVBufferRemoveAttachment(self, key) }
    }

    /// Removes all attachments of a CVBuffer object
    ///
    /// While CVBufferRemoveAttachment removes a specific attachement identified by a key CVBufferRemoveAllAttachments removes all attachments of a buffer and decrements their retain counts.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    #[doc(alias = "CVBufferRemoveAllAttachments")]
    #[inline]
    pub fn remove_all_attachments(&self) {
        extern "C-unwind" {
            fn CVBufferRemoveAllAttachments(buffer: &CVBuffer);
        }
        unsafe { CVBufferRemoveAllAttachments(self) }
    }

    /// Returns all attachments of a CVBuffer object
    ///
    /// CVBufferGetAttachments is a convenience call that returns all attachments with their corresponding keys in a CFDictionary.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// Returns: A CFDictionary with all buffer attachments identified by there keys. If no attachment is present, the dictionary is empty.  Returns NULL
    /// for invalid attachment mode.
    #[doc(alias = "CVBufferGetAttachments")]
    #[deprecated]
    #[inline]
    pub fn get_attachments(
        &self,
        attachment_mode: CVAttachmentMode,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CVBufferGetAttachments(
                buffer: &CVBuffer,
                attachment_mode: CVAttachmentMode,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CVBufferGetAttachments(self, attachment_mode) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Sets a set of attachments for a CVBuffer
    ///
    /// CVBufferSetAttachments is a convenience call that in turn calls CVBufferSetAttachment for each key and value in the given dictionary. All key value pairs must be in the root level of the dictionary.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// # Safety
    ///
    /// `the_attachments` generics must be of the correct type.
    #[doc(alias = "CVBufferSetAttachments")]
    #[inline]
    pub unsafe fn set_attachments(
        &self,
        the_attachments: &CFDictionary,
        attachment_mode: CVAttachmentMode,
    ) {
        extern "C-unwind" {
            fn CVBufferSetAttachments(
                buffer: &CVBuffer,
                the_attachments: &CFDictionary,
                attachment_mode: CVAttachmentMode,
            );
        }
        unsafe { CVBufferSetAttachments(self, the_attachments, attachment_mode) }
    }

    /// Copy all propagatable attachments from one buffer to another.
    ///
    /// CVBufferPropagateAttachments is a convenience call that copies all attachments with a mode of kCVAttachmentMode_ShouldPropagate from one
    /// buffer to another.
    ///
    /// Parameter `sourceBuffer`: CVBuffer to copy attachments from.
    ///
    /// Parameter `destinationBuffer`: CVBuffer to copy attachments to.
    #[doc(alias = "CVBufferPropagateAttachments")]
    #[inline]
    pub fn propagate_attachments(&self, destination_buffer: &CVBuffer) {
        extern "C-unwind" {
            fn CVBufferPropagateAttachments(
                source_buffer: &CVBuffer,
                destination_buffer: &CVBuffer,
            );
        }
        unsafe { CVBufferPropagateAttachments(self, destination_buffer) }
    }

    /// Returns a copy of all attachments of a CVBuffer object. It is the caller’s responsibility to release the returned dictionary.
    ///
    /// CVBufferCopyAttachments is a convenience call that returns a copy of all attachments with their corresponding keys in a CFDictionary.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// Returns: A CFDictionary with all buffer attachments identified by their keys. If no attachment is present or invalid attachment mode,   returns NULL
    #[doc(alias = "CVBufferCopyAttachments")]
    #[inline]
    pub fn attachments(
        &self,
        attachment_mode: CVAttachmentMode,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CVBufferCopyAttachments(
                buffer: &CVBuffer,
                attachment_mode: CVAttachmentMode,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CVBufferCopyAttachments(self, attachment_mode) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a retained specific attachment of a CVBuffer object. It is the caller’s responsibility to release the returned value.
    ///
    /// You can attach any CF object to a CVBuffer object to store additional information. CVBufferCopyAttachment retrieves a retained attachment identified by a key.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// Parameter `key`: Key in form of a CFString identifying the desired attachment.
    ///
    /// Parameter `attachmentMode`: Returns the mode of the attachment, if desired.  May be NULL.
    ///
    /// Returns: If found the attachment object, return the value; otherwize, return NULL.
    ///
    /// # Safety
    ///
    /// `attachment_mode` must be a valid pointer or null.
    #[doc(alias = "CVBufferCopyAttachment")]
    #[inline]
    pub unsafe fn attachment(
        &self,
        key: &CFString,
        attachment_mode: *mut CVAttachmentMode,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CVBufferCopyAttachment(
                buffer: &CVBuffer,
                key: &CFString,
                attachment_mode: *mut CVAttachmentMode,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CVBufferCopyAttachment(self, key, attachment_mode) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns true if an attachment with the passed key is present on a CVBuffer object.
    ///
    /// Parameter `buffer`: Target CVBuffer object.
    ///
    /// Parameter `key`: Key in form of a CFString identifying the desired attachment.
    ///
    /// Returns: True if an attachment with this key is present, otherwise false.
    #[doc(alias = "CVBufferHasAttachment")]
    #[inline]
    pub fn has_attachment(&self, key: &CFString) -> bool {
        extern "C-unwind" {
            fn CVBufferHasAttachment(buffer: &CVBuffer, key: &CFString) -> Boolean;
        }
        let ret = unsafe { CVBufferHasAttachment(self, key) };
        ret != 0
    }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CVBuffer::set_attachment`"]
    pub fn CVBufferSetAttachment(
        buffer: &CVBuffer,
        key: &CFString,
        value: &CFType,
        attachment_mode: CVAttachmentMode,
    );
}

#[deprecated = "renamed to `CVBuffer::get_attachment`"]
#[inline]
pub unsafe extern "C-unwind" fn CVBufferGetAttachment(
    buffer: &CVBuffer,
    key: &CFString,
    attachment_mode: *mut CVAttachmentMode,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CVBufferGetAttachment(
            buffer: &CVBuffer,
            key: &CFString,
            attachment_mode: *mut CVAttachmentMode,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CVBufferGetAttachment(buffer, key, attachment_mode) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CVBuffer::remove_attachment`"]
#[inline]
pub extern "C-unwind" fn CVBufferRemoveAttachment(buffer: &CVBuffer, key: &CFString) {
    extern "C-unwind" {
        fn CVBufferRemoveAttachment(buffer: &CVBuffer, key: &CFString);
    }
    unsafe { CVBufferRemoveAttachment(buffer, key) }
}

#[deprecated = "renamed to `CVBuffer::remove_all_attachments`"]
#[inline]
pub extern "C-unwind" fn CVBufferRemoveAllAttachments(buffer: &CVBuffer) {
    extern "C-unwind" {
        fn CVBufferRemoveAllAttachments(buffer: &CVBuffer);
    }
    unsafe { CVBufferRemoveAllAttachments(buffer) }
}

#[deprecated = "renamed to `CVBuffer::get_attachments`"]
#[inline]
pub extern "C-unwind" fn CVBufferGetAttachments(
    buffer: &CVBuffer,
    attachment_mode: CVAttachmentMode,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CVBufferGetAttachments(
            buffer: &CVBuffer,
            attachment_mode: CVAttachmentMode,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CVBufferGetAttachments(buffer, attachment_mode) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CVBuffer::set_attachments`"]
    pub fn CVBufferSetAttachments(
        buffer: &CVBuffer,
        the_attachments: &CFDictionary,
        attachment_mode: CVAttachmentMode,
    );
}

#[deprecated = "renamed to `CVBuffer::propagate_attachments`"]
#[inline]
pub extern "C-unwind" fn CVBufferPropagateAttachments(
    source_buffer: &CVBuffer,
    destination_buffer: &CVBuffer,
) {
    extern "C-unwind" {
        fn CVBufferPropagateAttachments(source_buffer: &CVBuffer, destination_buffer: &CVBuffer);
    }
    unsafe { CVBufferPropagateAttachments(source_buffer, destination_buffer) }
}

#[deprecated = "renamed to `CVBuffer::attachments`"]
#[inline]
pub extern "C-unwind" fn CVBufferCopyAttachments(
    buffer: &CVBuffer,
    attachment_mode: CVAttachmentMode,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CVBufferCopyAttachments(
            buffer: &CVBuffer,
            attachment_mode: CVAttachmentMode,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CVBufferCopyAttachments(buffer, attachment_mode) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CVBuffer::attachment`"]
#[inline]
pub unsafe extern "C-unwind" fn CVBufferCopyAttachment(
    buffer: &CVBuffer,
    key: &CFString,
    attachment_mode: *mut CVAttachmentMode,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CVBufferCopyAttachment(
            buffer: &CVBuffer,
            key: &CFString,
            attachment_mode: *mut CVAttachmentMode,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CVBufferCopyAttachment(buffer, key, attachment_mode) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CVBuffer::has_attachment`"]
#[inline]
pub extern "C-unwind" fn CVBufferHasAttachment(buffer: &CVBuffer, key: &CFString) -> bool {
    extern "C-unwind" {
        fn CVBufferHasAttachment(buffer: &CVBuffer, key: &CFString) -> Boolean;
    }
    let ret = unsafe { CVBufferHasAttachment(buffer, key) };
    ret != 0
}
