\page ExampleDICOM1 Example DICOM1

# DICOM1 Example

The DICOM application has been originally developed by the Geant4 users:
Louis Archambault,(1)Luc Beaulieu, (2)Vincent Hubert-Tremblay.

- (1) Centre Hospitalier Universitaire de Quebec (CHUQ),
Hotel-Dieu de Quebec, departement de Radio-oncologie
11 cote du palais. Quebec, QC, Canada, G1R 2J6
tel (418) 525-4444 #6720
fax (418) 691 5268
web : thomson.phy.ulaval.ca/phys_med 
- (2) Université Laval, Québec (QC) Canada


And it has been deeply reviewed by Pedro Arce in December 2007. \n
Very small changes by Stephane Chauvie in January 2008. \n
Stephane Chauvie, Oct 2009: changed Physics list; changes in DICOM read. \n
Stephane Chauvie and Andrea Armando; June 2010 adapted for reading  whatever DICOM file \n
Jonathan Madsen, Nov 2013: updated DICOM to utilize multithreading now available in Geant4.10 \n
Alexander Howard, Dec 2023: updated scorer to give correct voxel index for both regular and nested geometries

## Introduction

This example serves first to convert a DICOM file to a simple ASCII file, where the Hounsfield numbers are converted to materials and densities so that it can be used by GEANT4. It serves also to create a GEANT4 geometry based on the DICOM file information using the G4PhantomParameterisation. 

You can find the phantom reproduced in the image PhantomCT.jpg.
In the application the phantom is placed on a table.
 
## Run the example:

 - batch mode:
   ```
   ./dicom1 run.mac
   ```
 - interactive mode:
   ```
   ./dicom1
   ```
   the file vis.mac is read in order to visualise the phantom with OpenGL, DAWN or VRML
 
## Metadata file:

The old version of "Data.dat" is found in "Data.dat.old", when the project is configured with DICOM_USE_DCMTK=OFF,
"Data.dat.old" is copied into the binary directory at "Data.dat".
  - i.e. cp ${PROJECT_SOURCE_DIR}/Data.dat.old ${PROJECT_BINARY_DIR}/Data.dat

The new version of "Data.dat" is found in "Data.dat.new", when the project is configured with DICOM_USE_DCMTK=ON,
"Data.dat.new" is copied into the binary directory as "Data.dat".
  - i.e. cp ${PROJECT_SOURCE_DIR}/Data.dat.new ${PROJECT_BINARY_DIR}/Data.dat

### Metadata file, OLD version:

 The file Data.dat has the following information
  - A line with the compression value (used only to create the .g4dcm and .g4dcmb, not to read it)
  - A line with the number of files 
  - A line for each file name (to these names it will be added the suffix .dcm to read the DICOM files in their original format, and the suffix .g4dcm to read the text files that contain the DICOM information where the Hounsfield numbers have been converted to material and densities)

In case you want to convert DICOM files to text files, it must have the following lines:
  - The number of materials you want to use
  - A line for each material describing its name and the upper bound of the density interval. The materials should be described in increasing order of density. The voxels with a density between 0. and the first upper bound will be assigned to the first material, those with a density between the first upper bound and the second upper bound will be assigned to the second material, etc.

### Metadata file, NEW version (based on DCMTK):

As for the previous version, a Data.dat file has to be defined to manage the conversion options. The format of this file is though quite different from the previous version. The format of this file is based on tags (similary to the ASCII geometry files).
The following tags should be used:

:COMPRESSION level 

Where "level" is the number of voxels that will be merged into one in the X and Y dimen-
sions. The Hounsfield numbers of the voxels merged are averaged to give the
resulting value for the new voxel.
Example:
:COMPRESSION 4 // 4 X 4 voxels will be merged, so that the number of voxels in X and Y dimensions will be reduced by a factor 4

:FILE file_name
These are the list of files (one line per file) in DICOM format that will be treated.
They can be of modality CT, RTSTRUCT or RTPLAN (the code will automatically
detect its modality and treat it correspondingly).
Example:
:FILE 1.dcm
:FILE 2.dcm
:FILE 3.dcm

:CT2D  Hounsfield_number density
These sets of value pairs build the calibration curve (linearly interpolating between them). In other words, each Hounsfield number is given a material density using a function that is built interpolating between this list of value pairs.
Example:
:CT2D -5000 0. 
:CT2D -1000 0.01 
:CT2D -400 0.602 
:CT2D  300 1.145 
:CT2D 2000 1.856

:MATE material_name upper_bound_of_material_Hounsfield_number_interval
This serves for the Hounsfield number to material name conversion. The voxels with a Hounsfield number between 0. and the first upper bound will be assigned to the first material, those with a Hounsfiled number between the first upper bound and the second upper bound will be assigned to the second material, etc.
Example:
:MATE G4_AIR -800
:MATE G4_LUNG_ICRP -145
:MATE G4_ADIPOSE_TISSUE_ICRP -60
:MATE G4_WATER 0

Alternatively to the use of :MATE, you can use the :MATE_DENS
:MATE_DENS material_name upper_bound_of_material_density_interval
This serves for the material density to material name conversion. The voxels with a density between 0. and the first upper bound will be assigned to the first material, those with a density between the first upper bound and the second upper bound will be assigned to the second material, etc.
Example:
:MATE_DENS G4_AIR 0.207
:MATE_DENS G4_LUNG_ICRP 0.919
:MATE_DENS G4_ADIPOSE_TISSUE_ICRP 0.979
:MATE_DENS G4_WATER 1.01

We recommend the use of :MATE instead of :MATE_DENS as this is the way is used more often in the literature.

:FILE_OUT file_name
Name of output file containing the DICOM information in ASCII format


## Conversion of Hounsfield numbers to materials:

After reading the name of files from Data.dat, if a file .dcm is found, then it looks for the corresponding .g4dcm file and if not found creates it. 
Each file corresponds to a Z slice. The Z slices will be merged at runtime to form a unique patient volume; therefore the different slices have to be contiguous in Z.

The DICOM images pixel values represent CT (Hounsfield) numbers and they should be converted, first, to a given density and then to a material type.  The relation between CT number and density is more or less linear. 
The file CT2Density.dat contains the calibration curve to convert CT (Hounsfield) number to physical density
The assignment of material densities to materials is done following the information from the file Data.dat (see below). In this case we have used:

           #####################################################
           #     Density Range                   Material      #
           #---------------------------------------------------#
           #       mg/cm3                            -         #
           #---------------------------------------------------#
           #  [ 0.    , 0.207 )                 Air            #
           #  [ 0.207 , 0.481 )                 Lungs (inhale) #
           #  [ 0.481 , 0.919 )                 Lungs (exhale) #
           #  [ 0.919 , 0.979 )                 Adipose        #
           #  [ 0.979 , 1.004 )                 Breast         #
           #  [ 1.004 , 1.043 )                 Phantom        #
           #  [ 1.043 , 1.109 )                 Liver          #
           #  [ 1.109 , 1.113 )                 Muscle         #
           #  [ 1.113 , 1.496 )                 Trabecular Bone#
           #  [ 1.496 , 1.654 ]                 Dense Bone     #
           #####################################################

Data taken from the International Commission on Radiation Units and measurements (ICRU) report 46 was used to build the materials (lung, liver, breast, bones, ...).

When using the Digital Head Phantom, the CT2Density.dat is not used. The conversion is performed directly in the Dicom Handler.cc

## Splitting materials in density intervals:

In the class DicomDetectorConstruction, it is defined a density interval

  G4double densityDiff = 0.1;

This means that the voxels of each material will be grouped in density intervals of 0.1 g/cm3 and a new material will be created for each group of voxels.

## Voxel colouring:

The file Colormap.dat defines the colour that will be assigned to the voxels of each material.

## DICOM file formats:

The DICOM files are converted to a simple text format. You may create your own file with the following format (see e.g. 14196616.g4dcm):

- A line with the number of materials
- A line for each material with its index and name (the same name of materials that you construct as G4Material's)
- A line with the number of voxels in X, Y and Z
- A line with the minimum and maximum extension in X (mm)
- A line with the minimum and maximum extension in Y (mm)
- A line with the minimum and maximum extension in Z (mm)
- A number of lines containing the nVoxelX*nVoxelY*nVoxelZ material indices (one per voxel)
- A number of lines containing the nVoxelX*nVoxelY*nVoxelZ material densities (one per voxel)

As commented before the DICOM files (.dcm) are assumed to describe one Z slice per file, and therefore the GEANT4 text files (.g4dcm) created from them have also one unique Z slice per file. Nevertheless if you create your own .g4dcm file you may include as many Z slices as desired. In any case you have to respect the rule that the Z slices must be contiguous.

The same information is also used to fill a file in binary format, that contains the same information as the text format. Its name ends in .g4dcmb, instead of .g4dcm .

## Choosing different parameterisation/navigation options:

There are four possible ways in GEANT4 to treat the navigation in regular voxelised volumes:

- The 3D optimisation with G4SmartVoxel: a 3D grid is built, so that the location of voxels is fast, but it requires a lot of memory
- Using G4NestedParameterisation. The search is done hierarchically in X, Y and Z. It is fast and does not require big memory
- Using G4PhantomParameterisation/G4RegularNavigation: an special algorithm to navigate in regular voxelised geometries (see GEANT4 doc). This is the fastest way without any extra memory requirement (and it is the default in this example). It includes an option (default) to skip frontiers between voxels when they have the same material. When using this option at each step the energy is all deposited in the last voxel; for properly distribution of the dose (=energy/volume) the G4PSDoseDeposit scorer can be used for regular (see (10) below) and G4PSDoseDeposit3D for nested parameterisation (see (11) below).

Obsolete option:
- Use 1D optimisation in replica. It will be very slow because each time a track exits a voxel it has to loop to all other voxels in a 2D slide in order to locate which one it will enter.

You can select amongst the four options in the following way:

- By default the example will run with G4RegularNavigation

- To use the first option at RegularDicomDetectorConstruction.cc you must set
  ```cpp
  patient_phys->SetRegularStructureId(0);
  ```
- To use the second option (Nested Parameterisation) you must set the enviromental variable DICOM_NESTED_PARAM to 1

- To use the final, obsolete 1D-option, apart from the change above at RegularDicomDetectorConstruction.cc you need to replace (i.e. use kUndefined)
  ```cpp
  G4PVParameterised * patient_phys = new G4PVParameterised("Patient",voxel_logic,container_logic,
			kUndefined, nVoxelX*nVoxelY*nVoxelZ, param);
  ```
by 
  ```cpp
  G4PVParameterised * patient_phys = new G4PVParameterised("Patient",voxel_logic,container_logic,
			kXAxis, nVoxelX*nVoxelY*nVoxelZ, param);
  ```
  Note also you must *not* set the enviromental variable DICOM_NESTED_PARAM.


## Calculating dose in phantom voxels for regular navigation

As mentioned above the regular navigation has the option to keip voxel frontiers when two voxels share the same material, what can make the CPU time several times smaller. But this option makes that all energy deposited is computed in the last voxel, instead of distributing it along the voxels traversed. To properly calculate the dose in each voxel the G4PSDoseDeposit scorer can be used.

It takes into account the fact that,  when the particle travels through the voxels it looses energy and therefore the energy lost per length (dEdx) is bigger and also the effect of the multiple scattering is bigger. 
The algorithm to make this correction is an iterative one, as the step length increase due multiple scattering (that converts the geometrical step length in what we will call the true step length) and the energy loss are correlated.
It works in the folloing way: first the total true step length is distributed among the voxels proportionally to their geometrical step length; with these values it is calculated one voxel after another the value of dEdx and then the value of the kinetic energy at the entrance of each voxel; with these values it is calculated the geometrical to true step corrections due to multiple scattering for each voxel; finally these new values are used to recalculate the energy lost in each voxel. It has been demonstrated for dose in a water phantom and in a real phantom that the two-step iteration described is enough to reproduce the dose calcualted when no skipping of voxel frontiers is done.

This scorer is implemented in this examples if the regular navigation option is 
chosen. It is triggered at the method RegularDicomDetectorConstruction::ConstructPhantom() by the call
```cpp
SetScorer(voxel_logic);
```
## Calculating dose in phantom voxels for nested parameterisation

For the nested parameterisation the geometry comprises replicas in X and Y which are then parameterised in Z. This means that to get the correct voxel idendification the replica depth has to be taken into account. The G4PSDoseDeposit3D scorers uses a fixed algorithm to calculate the voxel ID, according to the number
of voxels in each axes and the associated replica depth. G4PSDoseDeposit3D("DoseDeposit", fNoVoxelsZ, fNoVoxelsY, fNoVoxelsX, 0, 2, 1) contains the number of voxels at the top level (0) and then two daughter levels down for the Y-voxels and one depth down for X.

## Output
dicom.out is produced running the macro file run.mac. It has 2 columns: the first is the number of 
voxel (ordered in x,y,z) and the second the dose there deposited (in Gy)
It is produced, as an example, with a compression value of 32


## Partial phantom 
It is possible to create a partial phantom, that is the intersection of a phantom with a volume. You may define the volume with the command 
```
/dicom/intersectWithUserVolume 0. 0. 0. 45.*deg 0. 0. TUBE 0. 150. 100.
```
where the first three arguments are its position, its second three arguments are the rotation around the global X, Y and Z axis and the rest of the parameters are the same that you use to build a solid using the ASCII geometry format

Alternatively you can intersect the phantom with an existing Geant4 volume with the command
```
/dicom/intersectWithG4Volume VOLUME_NAME
```
The job will create an ASCII file names "phantom.g4pdcm" containing the partial phantom. To read this file all what is needed is to set the enviromental variable DICOM_PARTIAL_PARAM to 1

## Visualisation

The Geant4 drivers are not meant for visualizing millions of voxel and visualising the DICOM geometries can be very computationally demanding.
The users may want to visualise each DICOM slice separately or use higher compression values when visualising a part of DICOM project.



