// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Indicates that the claims are definitively true and logically implied by the premises, with no possible alternative interpretations.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailAutomatedReasoningValidFinding {
    /// <p>The logical translation of the input that this finding validates.</p>
    pub translation: ::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation>,
    /// <p>An example scenario demonstrating how the claims are logically true.</p>
    pub claims_true_scenario: ::std::option::Option<crate::types::GuardrailAutomatedReasoningScenario>,
    /// <p>The automated reasoning policy rules that support why this result is considered valid.</p>
    pub supporting_rules: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>>,
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub logic_warning: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning>,
}
impl GuardrailAutomatedReasoningValidFinding {
    /// <p>The logical translation of the input that this finding validates.</p>
    pub fn translation(&self) -> ::std::option::Option<&crate::types::GuardrailAutomatedReasoningTranslation> {
        self.translation.as_ref()
    }
    /// <p>An example scenario demonstrating how the claims are logically true.</p>
    pub fn claims_true_scenario(&self) -> ::std::option::Option<&crate::types::GuardrailAutomatedReasoningScenario> {
        self.claims_true_scenario.as_ref()
    }
    /// <p>The automated reasoning policy rules that support why this result is considered valid.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.supporting_rules.is_none()`.
    pub fn supporting_rules(&self) -> &[crate::types::GuardrailAutomatedReasoningRule] {
        self.supporting_rules.as_deref().unwrap_or_default()
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn logic_warning(&self) -> ::std::option::Option<&crate::types::GuardrailAutomatedReasoningLogicWarning> {
        self.logic_warning.as_ref()
    }
}
impl GuardrailAutomatedReasoningValidFinding {
    /// Creates a new builder-style object to manufacture [`GuardrailAutomatedReasoningValidFinding`](crate::types::GuardrailAutomatedReasoningValidFinding).
    pub fn builder() -> crate::types::builders::GuardrailAutomatedReasoningValidFindingBuilder {
        crate::types::builders::GuardrailAutomatedReasoningValidFindingBuilder::default()
    }
}

/// A builder for [`GuardrailAutomatedReasoningValidFinding`](crate::types::GuardrailAutomatedReasoningValidFinding).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailAutomatedReasoningValidFindingBuilder {
    pub(crate) translation: ::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation>,
    pub(crate) claims_true_scenario: ::std::option::Option<crate::types::GuardrailAutomatedReasoningScenario>,
    pub(crate) supporting_rules: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>>,
    pub(crate) logic_warning: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning>,
}
impl GuardrailAutomatedReasoningValidFindingBuilder {
    /// <p>The logical translation of the input that this finding validates.</p>
    pub fn translation(mut self, input: crate::types::GuardrailAutomatedReasoningTranslation) -> Self {
        self.translation = ::std::option::Option::Some(input);
        self
    }
    /// <p>The logical translation of the input that this finding validates.</p>
    pub fn set_translation(mut self, input: ::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation>) -> Self {
        self.translation = input;
        self
    }
    /// <p>The logical translation of the input that this finding validates.</p>
    pub fn get_translation(&self) -> &::std::option::Option<crate::types::GuardrailAutomatedReasoningTranslation> {
        &self.translation
    }
    /// <p>An example scenario demonstrating how the claims are logically true.</p>
    pub fn claims_true_scenario(mut self, input: crate::types::GuardrailAutomatedReasoningScenario) -> Self {
        self.claims_true_scenario = ::std::option::Option::Some(input);
        self
    }
    /// <p>An example scenario demonstrating how the claims are logically true.</p>
    pub fn set_claims_true_scenario(mut self, input: ::std::option::Option<crate::types::GuardrailAutomatedReasoningScenario>) -> Self {
        self.claims_true_scenario = input;
        self
    }
    /// <p>An example scenario demonstrating how the claims are logically true.</p>
    pub fn get_claims_true_scenario(&self) -> &::std::option::Option<crate::types::GuardrailAutomatedReasoningScenario> {
        &self.claims_true_scenario
    }
    /// Appends an item to `supporting_rules`.
    ///
    /// To override the contents of this collection use [`set_supporting_rules`](Self::set_supporting_rules).
    ///
    /// <p>The automated reasoning policy rules that support why this result is considered valid.</p>
    pub fn supporting_rules(mut self, input: crate::types::GuardrailAutomatedReasoningRule) -> Self {
        let mut v = self.supporting_rules.unwrap_or_default();
        v.push(input);
        self.supporting_rules = ::std::option::Option::Some(v);
        self
    }
    /// <p>The automated reasoning policy rules that support why this result is considered valid.</p>
    pub fn set_supporting_rules(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>>) -> Self {
        self.supporting_rules = input;
        self
    }
    /// <p>The automated reasoning policy rules that support why this result is considered valid.</p>
    pub fn get_supporting_rules(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningRule>> {
        &self.supporting_rules
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn logic_warning(mut self, input: crate::types::GuardrailAutomatedReasoningLogicWarning) -> Self {
        self.logic_warning = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn set_logic_warning(mut self, input: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning>) -> Self {
        self.logic_warning = input;
        self
    }
    /// <p>Indication of a logic issue with the translation without needing to consider the automated reasoning policy rules.</p>
    pub fn get_logic_warning(&self) -> &::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarning> {
        &self.logic_warning
    }
    /// Consumes the builder and constructs a [`GuardrailAutomatedReasoningValidFinding`](crate::types::GuardrailAutomatedReasoningValidFinding).
    pub fn build(self) -> crate::types::GuardrailAutomatedReasoningValidFinding {
        crate::types::GuardrailAutomatedReasoningValidFinding {
            translation: self.translation,
            claims_true_scenario: self.claims_true_scenario,
            supporting_rules: self.supporting_rules,
            logic_warning: self.logic_warning,
        }
    }
}
