---
title: "rclone archive create"
description: "Archive source file(s) to destination."
versionIntroduced: v1.72
# autogenerated - DO NOT EDIT, instead edit the source code in cmd/archive/create/ and as part of making a release run "make commanddocs"
---
# rclone archive create

Archive source file(s) to destination.

## Synopsis


Creates an archive from the files in source:path and saves the archive to
dest:path. If dest:path is missing, it will write to the console.

The valid formats for the `--format` flag are listed below. If
`--format` is not set rclone will guess it from the extension of dest:path.

| Format | Extensions |
|:-------|:-----------|
| zip    | .zip       |
| tar    | .tar       |
| tar.gz | .tar.gz, .tgz, .taz |
| tar.bz2| .tar.bz2, .tb2, .tbz, .tbz2, .tz2 |
| tar.lz | .tar.lz    |
| tar.lz4| .tar.lz4   |
| tar.xz | .tar.xz, .txz |
| tar.zst| .tar.zst, .tzst |
| tar.br | .tar.br    |
| tar.sz | .tar.sz    |
| tar.mz | .tar.mz    |

The `--prefix` and `--full-path` flags control the prefix for the files
in the archive.

If the flag `--full-path` is set then the files will have the full source
path as the prefix.

If the flag `--prefix=<value>` is set then the files will have
`<value>` as prefix. It's possible to create invalid file names with
`--prefix=<value>` so use with caution. Flag `--prefix` has
priority over `--full-path`.

Given a directory `/sourcedir` with the following:

    file1.txt
    dir1/file2.txt

Running the command `rclone archive create /sourcedir /dest.tar.gz`
will make an archive with the contents:

    file1.txt
    dir1/
    dir1/file2.txt

Running the command `rclone archive create --full-path /sourcedir /dest.tar.gz`
will make an archive with the contents:

    sourcedir/file1.txt
    sourcedir/dir1/
    sourcedir/dir1/file2.txt

Running the command `rclone archive create --prefix=my_new_path /sourcedir /dest.tar.gz`
will make an archive with the contents:

    my_new_path/file1.txt
    my_new_path/dir1/
    my_new_path/dir1/file2.txt


```
rclone archive create [flags] <source> [<destination>]
```

## Options

```
      --format string   Create the archive with format or guess from extension.
      --full-path       Set prefix for files in archive to source path
  -h, --help            help for create
      --prefix string   Set prefix for files in archive to entered value or source path
```

See the [global flags page](/flags/) for global options not listed here.

## See Also

<!-- markdownlint-capture -->
<!-- markdownlint-disable ul-style line-length -->

* [rclone archive](/commands/rclone_archive/)	 - Perform an action on an archive.


<!-- markdownlint-restore -->
