<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/cassandra/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/cassandra/metadata.yaml"
sidebar_label: "Cassandra"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Cassandra


<img src="https://netdata.cloud/img/cassandra.svg" width="150"/>


Plugin: go.d.plugin
Module: cassandra

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector gathers metrics about client requests, cache hits, and many more, while also providing metrics per each thread pool.


The [JMX Exporter](https://github.com/prometheus/jmx_exporter) is used to fetch metrics from a Cassandra instance and make them available at an endpoint like `http://127.0.0.1:7072/metrics`.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This collector discovers instances running on the local host that provide metrics on port 7072.

On startup, it tries to collect metrics from:

- http://127.0.0.1:7072/metrics


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Cassandra instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cassandra.client_requests_rate | read, write | requests/s |
| cassandra.client_request_read_latency_histogram | p50, p75, p95, p98, p99, p999 | seconds |
| cassandra.client_request_write_latency_histogram | p50, p75, p95, p98, p99, p999 | seconds |
| cassandra.client_requests_latency | read, write | seconds |
| cassandra.row_cache_hit_ratio | hit_ratio | percentage |
| cassandra.row_cache_hit_rate | hits, misses | events/s |
| cassandra.row_cache_utilization | used | percentage |
| cassandra.row_cache_size | size | bytes |
| cassandra.key_cache_hit_ratio | hit_ratio | percentage |
| cassandra.key_cache_hit_rate | hits, misses | events/s |
| cassandra.key_cache_utilization | used | percentage |
| cassandra.key_cache_size | size | bytes |
| cassandra.storage_live_disk_space_used | used | bytes |
| cassandra.compaction_completed_tasks_rate | completed | tasks/s |
| cassandra.compaction_pending_tasks_count | pending | tasks |
| cassandra.compaction_compacted_rate | compacted | bytes/s |
| cassandra.jvm_memory_used | heap, nonheap | bytes |
| cassandra.jvm_gc_rate | parnew, cms | gc/s |
| cassandra.jvm_gc_time | parnew, cms | seconds |
| cassandra.dropped_messages_rate | dropped | messages/s |
| cassandra.client_requests_timeouts_rate | read, write | timeout/s |
| cassandra.client_requests_unavailables_rate | read, write | exceptions/s |
| cassandra.client_requests_failures_rate | read, write | failures/s |
| cassandra.storage_exceptions_rate | storage | exceptions/s |

### Per thread pool

Metrics related to Cassandra's thread pools. Each thread pool provides its own set of the following metrics.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| thread_pool | thread pool name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cassandra.thread_pool_active_tasks_count | active | tasks |
| cassandra.thread_pool_pending_tasks_count | pending | tasks |
| cassandra.thread_pool_blocked_tasks_count | blocked | tasks |
| cassandra.thread_pool_blocked_tasks_rate | blocked | tasks/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Configure Cassandra with Prometheus JMX Exporter

To configure Cassandra with the [JMX Exporter](https://github.com/prometheus/jmx_exporter):

> **Note**: paths can differ depends on your setup.

- Download latest [jmx_exporter](https://repo1.maven.org/maven2/io/prometheus/jmx/jmx_prometheus_javaagent/) jar file
  and install it in a directory where Cassandra can access it.
- Add
  the [jmx_exporter.yaml](https://raw.githubusercontent.com/netdata/go.d.plugin/master/modules/cassandra/jmx_exporter.yaml)
  file to `/etc/cassandra`.
- Add the following line to `/etc/cassandra/cassandra-env.sh`
  ```
  JVM_OPTS="$JVM_OPTS $JVM_EXTRA_OPTS -javaagent:/opt/jmx_exporter/jmx_exporter.jar=7072:/etc/cassandra/jmx_exporter.yaml
  ```
- Restart cassandra service.



### Configuration

#### File

The configuration file name for this integration is `go.d/cassandra.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/cassandra.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. | http://127.0.0.1:7072/metrics | yes |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| timeout | HTTP request timeout. | 2 | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

A basic example configuration.

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:7072/metrics

```
##### HTTP authentication

Local server with basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:7072/metrics
    username: foo
    password: bar

```
</details>

##### HTTPS with self-signed certificate

Local server with enabled HTTPS and self-signed certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1:7072/metrics
    tls_skip_verify: yes

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:7072/metrics

  - name: remote
    url: http://192.0.2.1:7072/metrics

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `cassandra` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m cassandra
  ```

### Getting Logs

If you're encountering problems with the `cassandra` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep cassandra
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep cassandra /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep cassandra
```


