/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirDesugaredAssignmentValueReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.UnsafeExpressionUtility;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0005H\u0007\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u0005H\u0007\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\u00052\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0018\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020\u000f\u001a\u0012\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020\u0005H\u0007\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"toReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "Lorg/jetbrains/kotlin/fir/FirElement;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toReferenceUnsafe", "toReferenceImpl", "Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;", "calleeReference", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "getCalleeReference", "(Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;)Lorg/jetbrains/kotlin/fir/references/FirReference;", "toResolvedCallableReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "toResolvedCallableReferenceUnsafe", "toResolvedCallableReferenceImpl", "toResolvedCallableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "toResolvedCallableSymbolUnsafe", "semantics"})
@SourceDebugExtension(value={"SMAP\nReferenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceUtils.kt\norg/jetbrains/kotlin/fir/expressions/ReferenceUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirErrorNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirErrorNamedReferenceBuilderKt\n+ 4 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n*L\n1#1,140:1\n295#2,2:141\n42#3:143\n42#4:144\n*S KotlinDebug\n*F\n+ 1 ReferenceUtils.kt\norg/jetbrains/kotlin/fir/expressions/ReferenceUtilsKt\n*L\n76#1:141,2\n77#1:143\n82#1:144\n*E\n"})
public final class ReferenceUtilsKt {
    @Nullable
    public static final FirReference toReference(@NotNull FirElement $this$toReference, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toReference, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirElement firElement = $this$toReference;
        return firElement instanceof FirExpression ? ReferenceUtilsKt.toReferenceImpl((FirExpression)$this$toReference, session2) : (firElement instanceof FirVariableAssignment ? ReferenceUtilsKt.getCalleeReference((FirVariableAssignment)$this$toReference) : (firElement instanceof FirResolvable ? ((FirResolvable)$this$toReference).getCalleeReference() : null));
    }

    @Nullable
    public static final FirReference toReference(@NotNull FirExpression $this$toReference, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toReference, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return ReferenceUtilsKt.toReferenceImpl($this$toReference, session2);
    }

    @UnsafeExpressionUtility
    @Nullable
    public static final FirReference toReferenceUnsafe(@NotNull FirExpression $this$toReferenceUnsafe) {
        Intrinsics.checkNotNullParameter($this$toReferenceUnsafe, "<this>");
        return ReferenceUtilsKt.toReferenceImpl($this$toReferenceUnsafe, null);
    }

    private static final FirReference toReferenceImpl(FirExpression $this$toReferenceImpl, FirSession session2) {
        FirReference firReference;
        FirExpression firExpression = $this$toReferenceImpl;
        if (firExpression instanceof FirEnumEntryDeserializedAccessExpression) {
            if (session2 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            firReference = ReferenceUtilsKt.toReference((FirEnumEntryDeserializedAccessExpression)$this$toReferenceImpl, session2);
        } else {
            firReference = firExpression instanceof FirWrappedArgumentExpression ? (FirReference)ReferenceUtilsKt.toResolvedCallableReferenceImpl(((FirWrappedArgumentExpression)$this$toReferenceImpl).getExpression(), session2) : (firExpression instanceof FirSmartCastExpression ? ReferenceUtilsKt.toReferenceImpl(((FirSmartCastExpression)$this$toReferenceImpl).getOriginalExpression(), session2) : (firExpression instanceof FirDesugaredAssignmentValueReferenceExpression ? ReferenceUtilsKt.toReferenceImpl(((FirDesugaredAssignmentValueReferenceExpression)$this$toReferenceImpl).getExpressionRef().getValue(), session2) : (firExpression instanceof FirResolvable ? ((FirResolvable)((Object)$this$toReferenceImpl)).getCalleeReference() : null)));
        }
        return firReference;
    }

    private static final FirReference toReference(FirEnumEntryDeserializedAccessExpression $this$toReference, FirSession session2) {
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        Object v2;
        block3: {
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getResolvedType($this$toReference), session2);
            if (firRegularClassSymbol == null) {
                ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$toReference));
                Intrinsics.checkNotNull(classId);
                return FirReferenceUtilsKt.buildErrorNamedReferenceWithNoName$default(new ConeUnresolvedSymbolError(classId), null, 2, null);
            }
            FirRegularClassSymbol enumSymbol = firRegularClassSymbol;
            Iterable $this$firstOrNull$iv = DeclarationUtilsKt.collectEnumEntries(enumSymbol, session2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), $this$toReference.getEnumEntryName())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        FirEnumEntrySymbol firEnumEntrySymbol = v2;
        if (firEnumEntrySymbol == null) {
            FirErrorNamedReferenceBuilder $i$f$firstOrNull;
            boolean $i$f$buildErrorNamedReference = false;
            FirErrorNamedReferenceBuilder $this$toReference_u24lambda_u241 = $i$f$firstOrNull = new FirErrorNamedReferenceBuilder();
            boolean bl = false;
            $this$toReference_u24lambda_u241.setDiagnostic(new ConeUnresolvedNameError($this$toReference.getEnumEntryName(), null, 2, null));
            $this$toReference_u24lambda_u241.setName($this$toReference.getEnumEntryName());
            return $i$f$firstOrNull.build();
        }
        FirEnumEntrySymbol enumEntrySymbol = firEnumEntrySymbol;
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder $this$toReference_u24lambda_u242 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        boolean bl = false;
        $this$toReference_u24lambda_u242.setName($this$toReference.getEnumEntryName());
        $this$toReference_u24lambda_u242.setResolvedSymbol(enumEntrySymbol);
        return firResolvedNamedReferenceBuilder.build();
    }

    @Nullable
    public static final FirReference getCalleeReference(@NotNull FirVariableAssignment $this$calleeReference) {
        Intrinsics.checkNotNullParameter($this$calleeReference, "<this>");
        return ReferenceUtilsKt.toReferenceImpl($this$calleeReference.getLValue(), null);
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReference(@NotNull FirExpression $this$toResolvedCallableReference, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReference, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return ReferenceUtilsKt.toResolvedCallableReferenceImpl($this$toResolvedCallableReference, session2);
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReference(@NotNull FirResolvable $this$toResolvedCallableReference) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReference, "<this>");
        return FirReferenceUtilsKt.getResolved($this$toResolvedCallableReference.getCalleeReference());
    }

    @UnsafeExpressionUtility
    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReferenceUnsafe(@NotNull FirExpression $this$toResolvedCallableReferenceUnsafe) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReferenceUnsafe, "<this>");
        return ReferenceUtilsKt.toResolvedCallableReferenceImpl($this$toResolvedCallableReferenceUnsafe, null);
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReferenceImpl(@NotNull FirExpression $this$toResolvedCallableReferenceImpl, @Nullable FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReferenceImpl, "<this>");
        FirReference firReference = ReferenceUtilsKt.toReferenceImpl($this$toResolvedCallableReferenceImpl, session2);
        return firReference != null ? FirReferenceUtilsKt.getResolved(firReference) : null;
    }

    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbol(@NotNull FirExpression $this$toResolvedCallableSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference($this$toResolvedCallableSymbol, session2);
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        return firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
    }

    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbol(@NotNull FirResolvable $this$toResolvedCallableSymbol) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableSymbol, "<this>");
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference($this$toResolvedCallableSymbol);
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        return firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
    }

    @UnsafeExpressionUtility
    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbolUnsafe(@NotNull FirExpression $this$toResolvedCallableSymbolUnsafe) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableSymbolUnsafe, "<this>");
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReferenceUnsafe($this$toResolvedCallableSymbolUnsafe);
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        return firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
    }
}

