/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/RangeTo;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "mapRangeTypeToPrimitiveType", "Lorg/jetbrains/org/objectweb/asm/Type;", "rangeType", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nRangeTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeTo.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/RangeTo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1563#2:62\n1634#2,3:63\n*S KotlinDebug\n*F\n+ 1 RangeTo.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/RangeTo\n*L\n22#1:62\n22#1:63,3\n*E\n"})
public final class RangeTo
extends IntrinsicMethod {
    @NotNull
    public static final RangeTo INSTANCE = new RangeTo();

    private RangeTo() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature, @NotNull ClassCodegen classCodegen) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(signature, "signature");
        Intrinsics.checkNotNullParameter(classCodegen, "classCodegen");
        Type type = signature.getReturnType();
        Intrinsics.checkNotNullExpressionValue(type, "getReturnType(...)");
        Type argType = this.mapRangeTypeToPrimitiveType(type);
        Collection collection = CollectionsKt.listOf(argType);
        List<JvmMethodParameterSignature> list = signature.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        Iterable iterable = list;
        Collection collection2 = collection;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JvmMethodParameterSignature jvmMethodParameterSignature = (JvmMethodParameterSignature)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(argType);
        }
        List<Type> list2 = CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
        return new IntrinsicFunction(expression2, signature, classCodegen, argType, list2){
            final /* synthetic */ JvmMethodSignature $signature;
            final /* synthetic */ Type $argType;
            {
                this.$signature = $signature;
                this.$argType = $argType;
                super($expression, $signature, $classCodegen, $super_call_param$1);
            }

            public void genInvokeInstruction(InstructionAdapter v2) {
                Intrinsics.checkNotNullParameter(v2, "v");
                Type[] typeArray = new Type[]{this.$argType, this.$argType};
                v2.invokespecial(this.$signature.getReturnType().getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, typeArray), false);
            }

            public void invoke(InstructionAdapter v2, ExpressionCodegen codegen, BlockInfo data, IrFunctionAccessExpression expression2) {
                Intrinsics.checkNotNullParameter(v2, "v");
                Intrinsics.checkNotNullParameter(codegen, "codegen");
                Intrinsics.checkNotNullParameter(data, "data");
                Intrinsics.checkNotNullParameter(expression2, "expression");
                ExpressionCodegen $this$invoke_u24lambda_u240 = codegen;
                boolean bl = false;
                $this$invoke_u24lambda_u240.markLineNumber(expression2, true);
                v2.anew(this.$signature.getReturnType());
                v2.dup();
                super.invoke(v2, codegen, data, expression2);
            }
        };
    }

    private final Type mapRangeTypeToPrimitiveType(Type rangeType) {
        Type type;
        String fqName = rangeType.getInternalName();
        Intrinsics.checkNotNull(fqName);
        switch (StringsKt.substringBefore$default(StringsKt.substringAfter$default(fqName, "kotlin/ranges/", null, 2, null), "Range", null, 2, null)) {
            case "Double": {
                Type type2 = Type.DOUBLE_TYPE;
                type = type2;
                Intrinsics.checkNotNullExpressionValue(type2, "DOUBLE_TYPE");
                break;
            }
            case "Float": {
                Type type3 = Type.FLOAT_TYPE;
                type = type3;
                Intrinsics.checkNotNullExpressionValue(type3, "FLOAT_TYPE");
                break;
            }
            case "Long": {
                Type type4 = Type.LONG_TYPE;
                type = type4;
                Intrinsics.checkNotNullExpressionValue(type4, "LONG_TYPE");
                break;
            }
            case "Int": {
                Type type5 = Type.INT_TYPE;
                type = type5;
                Intrinsics.checkNotNullExpressionValue(type5, "INT_TYPE");
                break;
            }
            case "Short": {
                Type type6 = Type.SHORT_TYPE;
                type = type6;
                Intrinsics.checkNotNullExpressionValue(type6, "SHORT_TYPE");
                break;
            }
            case "Char": {
                Type type7 = Type.CHAR_TYPE;
                type = type7;
                Intrinsics.checkNotNullExpressionValue(type7, "CHAR_TYPE");
                break;
            }
            case "Byte": {
                Type type8 = Type.BYTE_TYPE;
                type = type8;
                Intrinsics.checkNotNullExpressionValue(type8, "BYTE_TYPE");
                break;
            }
            default: {
                throw new IllegalStateException("RangeTo intrinsic can only work for primitive types: " + fqName);
            }
        }
        return type;
    }
}

