/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.function.Function;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicateLambda;
import net.sf.saxon.z.IntPredicateProxy;

public final class MultipleNodeKindTest
extends NodeTest {
    public static final MultipleNodeKindTest PARENT_NODE = new MultipleNodeKindTest(UType.DOCUMENT.union(UType.ELEMENT));
    public static final MultipleNodeKindTest DOC_ELEM_ATTR = new MultipleNodeKindTest(UType.DOCUMENT.union(UType.ELEMENT).union(UType.ATTRIBUTE));
    public static final MultipleNodeKindTest LEAF = new MultipleNodeKindTest(UType.TEXT.union(UType.COMMENT).union(UType.PI).union(UType.NAMESPACE).union(UType.ATTRIBUTE));
    public static final MultipleNodeKindTest CHILD_NODE = new MultipleNodeKindTest(UType.ELEMENT.union(UType.TEXT).union(UType.COMMENT).union(UType.PI));
    UType uType;
    int nodeKindMask;

    public MultipleNodeKindTest(UType u) {
        this.uType = u;
        if (UType.DOCUMENT.overlaps(u)) {
            this.nodeKindMask |= 0x200;
        }
        if (UType.ELEMENT.overlaps(u)) {
            this.nodeKindMask |= 2;
        }
        if (UType.ATTRIBUTE.overlaps(u)) {
            this.nodeKindMask |= 4;
        }
        if (UType.TEXT.overlaps(u)) {
            this.nodeKindMask |= 8;
        }
        if (UType.COMMENT.overlaps(u)) {
            this.nodeKindMask |= 0x100;
        }
        if (UType.PI.overlaps(u)) {
            this.nodeKindMask |= 0x80;
        }
        if (UType.NAMESPACE.overlaps(u)) {
            this.nodeKindMask |= 0x2000;
        }
    }

    @Override
    public UType getUType() {
        return this.uType;
    }

    @Override
    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return (this.nodeKindMask & 1 << nodeKind) != 0;
    }

    @Override
    public IntPredicateProxy getMatcher(NodeVectorTree tree) {
        byte[] nodeKindArray = tree.getNodeKindArray();
        return IntPredicateLambda.of(nodeNr -> {
            int nodeKind = nodeKindArray[nodeNr] & 0xF;
            if (nodeKind == 4) {
                nodeKind = 3;
            }
            return (this.nodeKindMask & 1 << nodeKind) != 0;
        });
    }

    @Override
    public boolean test(NodeInfo node) {
        int nodeKind = node.getNodeKind();
        return (this.nodeKindMask & 1 << nodeKind) != 0;
    }

    @Override
    public double getDefaultPriority() {
        return -0.5;
    }

    public String toString() {
        StringBuilder fsb = new StringBuilder(64);
        LinkedList<PrimitiveUType> types = new LinkedList<PrimitiveUType>(this.uType.decompose());
        this.format(types, fsb, (Function<ItemType, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lnet/sf/saxon/type/ItemType;)Ljava/lang/String;)());
        return fsb.toString();
    }

    @Override
    public String toShortString() {
        if (this.nodeKindMask == MultipleNodeKindTest.CHILD_NODE.nodeKindMask) {
            return "node()";
        }
        StringBuilder fsb = new StringBuilder(64);
        LinkedList<PrimitiveUType> types = new LinkedList<PrimitiveUType>(this.uType.decompose());
        this.format(types, fsb, it -> ((NodeKindTest)it).toShortString());
        return fsb.toString();
    }

    @Override
    public String toExportString() {
        StringBuilder fsb = new StringBuilder(64);
        LinkedList<PrimitiveUType> types = new LinkedList<PrimitiveUType>(this.uType.decompose());
        this.format(types, fsb, ItemType::toExportString);
        return fsb.toString();
    }

    private void format(LinkedList<PrimitiveUType> list, StringBuilder fsb, Function<ItemType, String> show) {
        if (list.size() == 1) {
            fsb.append(show.apply(list.getFirst().toItemType()));
        } else {
            boolean first = true;
            for (PrimitiveUType pu : list) {
                fsb.append(first ? (char)'(' : '|');
                first = false;
                fsb.append(show.apply(pu.toItemType()));
            }
            fsb.append(')');
        }
    }

    public int hashCode() {
        return this.uType.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MultipleNodeKindTest && this.uType.equals(((MultipleNodeKindTest)obj).uType);
    }
}

