/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.TupleType;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class TupleItemType
extends AnyFunctionType
implements TupleType {
    private Map<String, SequenceType> fields = new HashMap<String, SequenceType>();
    private Set<String> optionalFields;
    private boolean extensible;

    public TupleItemType(List<String> names, List<SequenceType> types) {
        for (int i = 0; i < names.size(); ++i) {
            this.fields.put(names.get(i), types.get(i));
        }
        this.optionalFields = Collections.emptySet();
    }

    public TupleItemType(List<String> names, List<SequenceType> types, Set<String> optionalFields, boolean extensible) {
        for (int i = 0; i < names.size(); ++i) {
            this.fields.put(names.get(i), types.get(i));
        }
        this.optionalFields = optionalFields;
        this.extensible = extensible;
    }

    @Override
    public Genre getGenre() {
        return Genre.MAP;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public Iterable<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public SequenceType getFieldType(String field) {
        return this.fields.get(field);
    }

    @Override
    public boolean isOptional(String field) {
        return this.optionalFields.contains(field);
    }

    @Override
    public boolean isExtensible() {
        return this.extensible;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) throws XPathException {
        if (!(item instanceof MapItem)) {
            return false;
        }
        MapItem map = (MapItem)item;
        for (Map.Entry<String, SequenceType> field : this.fields.entrySet()) {
            GroundedValue<?> val = map.get(new StringValue(field.getKey()));
            if (!(val == null ? !this.optionalFields.contains(field.getKey()) : !field.getValue().matches(val, th))) continue;
            return false;
        }
        if (!this.extensible) {
            AtomicValue key;
            AtomicIterator keyIter = map.keys();
            while ((key = keyIter.next()) != null) {
                if (key instanceof StringValue && this.fields.containsKey(key.getStringValue())) continue;
                return false;
            }
        }
        return true;
    }

    public int getArity() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_ATOMIC};
    }

    @Override
    public SequenceType getResultType() {
        if (this.extensible) {
            return SequenceType.ANY_SEQUENCE;
        }
        ItemType resultType = null;
        boolean allowsMany = false;
        for (Map.Entry<String, SequenceType> field : this.fields.entrySet()) {
            resultType = resultType == null ? field.getValue().getPrimaryType() : Type.getCommonSuperType(resultType, field.getValue().getPrimaryType());
            allowsMany = allowsMany || Cardinality.allowsMany(field.getValue().getCardinality());
        }
        return SequenceType.makeSequenceType(resultType, allowsMany ? 57344 : 24576);
    }

    @Override
    public String toString() {
        return this.makeString(SequenceType::toString);
    }

    @Override
    public String toExportString() {
        return this.makeString(SequenceType::toExportString);
    }

    private String makeString(Function<SequenceType, String> show) {
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("tuple(");
        boolean first = true;
        for (Map.Entry<String, SequenceType> field : this.fields.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(field.getKey());
            if (this.isOptional(field.getKey())) {
                sb.append("?");
            }
            sb.append(": ");
            sb.append(show.apply(field.getValue()));
        }
        if (this.isExtensible()) {
            sb.append(", *");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TupleItemType && this.fields.equals(((TupleItemType)other).fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    @Override
    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (other == MapType.ANY_MAP_TYPE) {
            return 2;
        }
        if (other.isArrayType()) {
            return 4;
        }
        if (other instanceof MapType) {
            MapType f2 = (MapType)other;
            int keyRel = th.relationship(BuiltInAtomicType.STRING, f2.getKeyType());
            if (keyRel == 4) {
                return 4;
            }
            if (f2.getValueType().getPrimaryType().equals(AnyItemType.getInstance()) && f2.getValueType().getCardinality() == 57344) {
                return 2;
            }
            for (SequenceType entry : this.fields.values()) {
                int rel = th.sequenceTypeRelationship(entry, f2.getValueType());
                if (rel == 2 || rel == 0) continue;
                return 3;
            }
            return 2;
        }
        int rel = new SpecificFunctionType(this.getArgumentTypes(), this.getResultType()).relationship(other, th);
        return rel;
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        if (item instanceof MapItem) {
            for (Map.Entry<String, SequenceType> entry : this.fields.entrySet()) {
                String key = entry.getKey();
                SequenceType required = entry.getValue();
                GroundedValue<?> value = ((MapItem)item).get(new StringValue(key));
                if (value == null) {
                    if (this.optionalFields.contains(key)) continue;
                    return Optional.of("Field " + key + " is absent, but is not declared optional");
                }
                try {
                    if (required.matches(value, th)) continue;
                    String s2 = "Field " + key + " has value " + Err.depictSequence(value) + " which does not match the required type " + required.toString();
                    Optional<String> more = required.explainMismatch(value, th);
                    if (more.isPresent()) {
                        s2 = s2 + ". " + more.get();
                    }
                    return Optional.of(s2);
                }
                catch (XPathException err) {
                    return Optional.empty();
                }
            }
            if (!this.extensible) {
                AtomicValue key;
                AtomicIterator keyIter = ((MapItem)item).keys();
                while ((key = keyIter.next()) != null) {
                    if (!(key instanceof StringValue)) {
                        return Optional.of("Undeclared field " + key + " is present, but it is not a string, and the tuple type is not extensible");
                    }
                    if (this.fields.containsKey(key.getStringValue())) continue;
                    return Optional.of("Undeclared field " + key + " is present, but the tuple type is not extensible");
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression exp, RoleDiagnostic role) throws XPathException {
        return new SpecificFunctionType(this.getArgumentTypes(), this.getResultType()).makeFunctionSequenceCoercer(exp, role);
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        throw new UnsupportedOperationException();
    }
}

