# Cantera 3.2.0

Published on November 17, 2025 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v3.2.0)

The Cantera development team is pleased to announce the availability of Cantera 3.2.0. There have been nearly [1000 commits](https://github.com/Cantera/cantera/wiki/Cantera-3.2.0-Changelog) to Cantera since the last version, 3.1.0, which was released in December 2024. We have closed or merged [143 pull requests](https://github.com/Cantera/cantera/pulls?q=is%3Apr+merged%3A2024-12-17..2025-11-17+is%3Aclosed) and closed [66 issues](https://github.com/Cantera/cantera/issues?q=is%3Aissue+closed%3A2024-12-17..2025-11-17+is%3Aclosed) and [19 enhancement proposals](https://github.com/Cantera/enhancements/issues?q=is:issue+closed:2024-12-17..2025-11-17+is:closed). Instructions for installing Cantera 3.2 are available on the [Cantera website](/install/index).

## Highlights
- Generate a new version of <a href="../../cxx/d6/d51/CAPImain.html">`CLib`</a> based on the C++ Doxygen documentation, using a significantly updated [`sourcegen`](/develop/sourcegen) tool ([#1835](https://github.com/Cantera/cantera/pull/1835), [#1842](https://github.com/Cantera/cantera/pull/1842), [#1846](https://github.com/Cantera/cantera/pull/1846), [#1863](https://github.com/Cantera/cantera/pull/1863), [#1878](https://github.com/Cantera/cantera/pull/1878), [#1879](https://github.com/Cantera/cantera/pull/1879), [#1888](https://github.com/Cantera/cantera/pull/1888), [#1893](https://github.com/Cantera/cantera/pull/1893), [#1897](https://github.com/Cantera/cantera/pull/1897), [#1903](https://github.com/Cantera/cantera/pull/1903), [#1931](https://github.com/Cantera/cantera/pull/1931), [#1975](https://github.com/Cantera/cantera/pull/1975), [#1977](https://github.com/Cantera/cantera/pull/1977), [#1986](https://github.com/Cantera/cantera/pull/1986), [#1987](https://github.com/Cantera/cantera/pull/1987), [#2009](https://github.com/Cantera/cantera/pull/2009), [#2011](https://github.com/Cantera/cantera/pull/2011))
- Clone Solution objects used by `Reactor` / `ReactorSurface`, ensuring that all `ThermoPhase` objects used within a network are independent and that properties accessed after integration reflect results at the integrator's output time ([#1921](https://github.com/Cantera/cantera/pull/1921))
- Improved plasma kinetics calculations based on electron collision cross sections, including the addition of a two-term Boltzmann equation solver ([#1731](https://github.com/Cantera/cantera/pull/1731), [#1854](https://github.com/Cantera/cantera/pull/1854), [#1887](https://github.com/Cantera/cantera/pull/1887), [#1953](https://github.com/Cantera/cantera/pull/1953), [`nanosecond_pulse_discharge.py`](/examples/python/reactors/nanosecond_pulse_discharge))
- Generalized the hybrid time/stepping steady-state solver used for 1D flames to also be used for reactor networks ([#1836](https://github.com/Cantera/cantera/pull/1836), [#1907](https://github.com/Cantera/cantera/pull/1907), [`combustor.py`](/examples/python/reactors/combustor))
- Major updates to the new Matlab toolbox, including addition of a significant unit test suite ([#1665](https://github.com/Cantera/cantera/pull/1665), [#1881](https://github.com/Cantera/cantera/pull/1881), [#1911](https://github.com/Cantera/cantera/pull/1911), [#1868](https://github.com/Cantera/cantera/pull/1868), [#1997](https://github.com/Cantera/cantera/pull/1997), [#1974](https://github.com/Cantera/cantera/pull/1974), [#2031](https://github.com/Cantera/cantera/pull/2031), [#2036](https://github.com/Cantera/cantera/pull/2036), [#2037](https://github.com/Cantera/cantera/pull/2037), [#2040](https://github.com/Cantera/cantera/pull/2040), [#2047](https://github.com/Cantera/cantera/pull/2047), [Matlab Example Gallery](/examples/matlab/index))


## New features
- Introduce `high-pressure-Chung` model for high pressure gas transport properties, and improve documentation and testing of the existing `high-pressure` transport model ([#1704](https://github.com/Cantera/cantera/pull/1704), [`high_pressure_transport.py`](/examples/python/transport/high_pressure_transport))
- Add type annotations to the Python module using stub (`.pyi`) files ([#1926](https://github.com/Cantera/cantera/pull/1926), [#2019](https://github.com/Cantera/cantera/pull/2019), [#2024](https://github.com/Cantera/cantera/pull/2024))
- Add Soret model for mixture-averaged diffusion ([#1930](https://github.com/Cantera/cantera/pull/1930), [`adiabatic_flame.py`](/examples/python/onedim/adiabatic_flame))
- Enable pickling of `SolutionArray` objects ([#1964](https://github.com/Cantera/cantera/pull/1964), [#1970](https://github.com/Cantera/cantera/pull/1970))
- Allow Unicode volume units (m³) in YAML input ([#1989](https://github.com/Cantera/cantera/pull/1989))
- Add .NET examples to documentation ([#2027](https://github.com/Cantera/cantera/pull/2027), [.NET Example Gallery](/examples/dotnet/index))

## Changes to existing capabilities
- Remove features deprecated in Cantera 3.1 ([#1833](https://github.com/Cantera/cantera/pull/1833))
- Simplify calculation of molar mixture properties ([#1837](https://github.com/Cantera/cantera/pull/1837))
- Make `IndexError` and `ArraySizeError` consistent ([#1851](https://github.com/Cantera/cantera/pull/1851))
- [C++] Provide const access to falloff rate parameters ([#1857](https://github.com/Cantera/cantera/pull/1857))
- Introduce `ConnectorNode` as a common base class for devices connecting zero-D reactors ([#1848](https://github.com/Cantera/cantera/pull/1848))
- Refactor `ReactorSurface` to inherit from `ReactorBase` ([#1864](https://github.com/Cantera/cantera/pull/1864), [#1955](https://github.com/Cantera/cantera/pull/1955))
- Improve `ReactorNet` handling of "advance limits" by using CVODES root function ([#1976](https://github.com/Cantera/cantera/pull/1976), [#2050](https://github.com/Cantera/cantera/pull/2050))
- Simplify logger setup and eliminate per-thread logging ([#1904](https://github.com/Cantera/cantera/pull/1904))
- Improve .NET Interface Interop layer ([#1906](https://github.com/Cantera/cantera/pull/1906))
- Improve support for compiling with MPI compiler wrappers ([#1918](https://github.com/Cantera/cantera/pull/1918), [#1933](https://github.com/Cantera/cantera/pull/1933))
- Make imports of external Python modules private ([#1948](https://github.com/Cantera/cantera/pull/1948))
- Consolidate Gaussian functors used in examples ([#1951](https://github.com/Cantera/cantera/pull/1951))
- Restore previous `ThermoPhase` state after encountering an error setting the state ([#1981](https://github.com/Cantera/cantera/pull/1981))
- Revise methods for accessing state from `Sim1D`/`Domain1D` to be more consistent with `SolutionArray` ([#1995](https://github.com/Cantera/cantera/pull/1995), [#2008](https://github.com/Cantera/cantera/pull/2008))
- Make index lookups more robust ([#2010](https://github.com/Cantera/cantera/pull/2010))
- Use `phase` as name of `Reactor` member variable / getter for accessing the `Solution` object representing its contents ([#2001](https://github.com/Cantera/cantera/pull/2001), [#2002](https://github.com/Cantera/cantera/pull/2002))
- Improve exceptions for `speciesName(index)` and similar methods ([#2014](https://github.com/Cantera/cantera/pull/2014))
- Mark Fortran interface "experimental" in anticipation of a future rewrite ([#2048](https://github.com/Cantera/cantera/pull/2048))
- Deprecate `ReactorBase::addThermo` ([#1966](https://github.com/Cantera/cantera/pull/1966))
- Deprecate `LatticePhase` and `LatticeSolidPhase` ([#1959](https://github.com/Cantera/cantera/pull/1959))
- Deprecate Python `Arrhenius` class in favor of `ArrheniusRate` ([#1978](https://github.com/Cantera/cantera/pull/1978))
- Deprecate legacy convenience headers ([#1984](https://github.com/Cantera/cantera/pull/1984))
- Deprecate legacy `Domain1D` constructors based on raw `ThermoPhase` pointers ([#2003](https://github.com/Cantera/cantera/pull/2003))
- Deprecate various unused / redundant `ThermoPhase` and `Kinetics` functions [#2044](https://github.com/Cantera/cantera/pull/2044)
- Handle removal of `numpy.trapz` ([#2015](https://github.com/Cantera/cantera/pull/2015))
- Expanded automated CI testing and other CI maintenance ([#1844](https://github.com/Cantera/cantera/pull/1844), [#1861](https://github.com/Cantera/cantera/pull/1861), [#1862](https://github.com/Cantera/cantera/pull/1862), [#1875](https://github.com/Cantera/cantera/pull/1875), [#1891](https://github.com/Cantera/cantera/pull/1891), [#1908](https://github.com/Cantera/cantera/pull/1908), [#1909](https://github.com/Cantera/cantera/pull/1909), [#1913](https://github.com/Cantera/cantera/pull/1913), [#1914](https://github.com/Cantera/cantera/pull/1914), [#1952](https://github.com/Cantera/cantera/pull/1952), [#1962](https://github.com/Cantera/cantera/pull/1962), [#1993](https://github.com/Cantera/cantera/pull/1993), [#2012](https://github.com/Cantera/cantera/pull/2012), [#2029](https://github.com/Cantera/cantera/pull/2029))
- Various documentation updates ([#1831](https://github.com/Cantera/cantera/pull/1831), [#1853](https://github.com/Cantera/cantera/pull/1853), [#1866](https://github.com/Cantera/cantera/pull/1866), [#1884](https://github.com/Cantera/cantera/pull/1884), [#1901](https://github.com/Cantera/cantera/pull/1901), [#1939](https://github.com/Cantera/cantera/pull/1939), [#1945](https://github.com/Cantera/cantera/pull/1945), [#1958](https://github.com/Cantera/cantera/pull/1958), [#1969](https://github.com/Cantera/cantera/pull/1969), [#1983](https://github.com/Cantera/cantera/pull/1983), [#2026](https://github.com/Cantera/cantera/pull/2026), [#2028](https://github.com/Cantera/cantera/pull/2028), [#2046](https://github.com/Cantera/cantera/pull/2046))
- Various build system updates ([#1828](https://github.com/Cantera/cantera/pull/1828), [#1890](https://github.com/Cantera/cantera/pull/1890), [#1960](https://github.com/Cantera/cantera/pull/1960), [#1972](https://github.com/Cantera/cantera/pull/1972), [#1973](https://github.com/Cantera/cantera/pull/1973), [#2039](https://github.com/Cantera/cantera/pull/2039))
- Fix some compiler/Python warnings ([#1834](https://github.com/Cantera/cantera/pull/1834), [#1850](https://github.com/Cantera/cantera/pull/1850), [#1946](https://github.com/Cantera/cantera/pull/1946), [#2020](https://github.com/Cantera/cantera/pull/2020))
- Maintenance of the sdist / PyPI packages ([#1915](https://github.com/Cantera/cantera/pull/1915), [#1919](https://github.com/Cantera/cantera/pull/1919), [#1982](https://github.com/Cantera/cantera/pull/1982))

## Bugs fixed
- Fix using Python `SolutionArray.append` with different keyword argument orders ([#1840](https://github.com/Cantera/cantera/pull/1840))
- Fix transport model selection when initializing 1D flame from `SolutionArray` ([#1841](https://github.com/Cantera/cantera/pull/1841))
- Fix `ck2yaml` handling of unnamed surfaces ([#1876](https://github.com/Cantera/cantera/pull/1876))
- Fix isotropic electron energy distribution expression in `PlasmaPhase` ([#1858](https://github.com/Cantera/cantera/pull/1858))
- Fix handles in .NET interface ([#1894](https://github.com/Cantera/cantera/pull/1894))
- Fix layout of `multi_diff_coeffs` matrix in Python ([#1899](https://github.com/Cantera/cantera/pull/1899))
- Fix reaction balance check for elements with negative abundances ([#1917](https://github.com/Cantera/cantera/pull/1917))
- Update duplicate reaction labels when serializing ([#1923](https://github.com/Cantera/cantera/pull/1923))
- Fix inlet initialization in continuous reactor example ([#1944](https://github.com/Cantera/cantera/pull/1944))
- Fix flow reactor visualization for bi-directional mass flows ([#1949](https://github.com/Cantera/cantera/pull/1949))
- Fix `SolutionArray.read_csv` when using Pandas 3.x ([#1956](https://github.com/Cantera/cantera/pull/1956))
- Fix and simplify options for solving electric field/ion diffusion in 1D flames ([#1961](https://github.com/Cantera/cantera/pull/1961))
- Fix handling of falloff reactions with extra apparent third body ([#1965](https://github.com/Cantera/cantera/pull/1965))
- Fix 1D flame auto-solve after restoring from Pandas ([#1967](https://github.com/Cantera/cantera/pull/1967))
- Fix introspection of key names in `AnyMap` generated from Python ([#1979](https://github.com/Cantera/cantera/pull/1979))
- Fix `lxcat2yaml` for empty product case ([#1988](https://github.com/Cantera/cantera/pull/1988))
- Fix surface density/concentration calculation for multi-site species ([#2016](https://github.com/Cantera/cantera/pull/2016))
- Fix conservation of mass fraction sum in FlowReactor ([#2018](https://github.com/Cantera/cantera/pull/2018))
- Fix Python units function that returned `bytes` instead of `str` ([#2017](https://github.com/Cantera/cantera/pull/2017))
- Fix handling of empty SpeciesThermo objects in Python ([#2041](https://github.com/Cantera/cantera/pull/2041))

## Contributors

This release was made possible by the following contributors: [@BangShiuh](https://github.com/BangShiuh), [@bryanwweber](https://github.com/bryanwweber), [@burkenyo](https://github.com/burkenyo), [@cwillits123](https://github.com/cwillits123), [@etsandall](https://github.com/etsandall), [@g3bk47](https://github.com/g3bk47), [@ischoegl](https://github.com/ischoegl), [@itnonaka](https://github.com/itnonaka), [@mquiram](https://github.com/mquiram), [@mruijzendaal](https://github.com/mruijzendaal), [@nicolasbarleon](https://github.com/nicolasbarleon), [@QuentinMale](https://github.com/QuentinMale), [@rwest](https://github.com/rwest), [@speth](https://github.com/speth), [@ssun30](https://github.com/ssun30), [@TimothyEDawson](https://github.com/TimothyEDawson), [@wandadars](https://github.com/wandadars)
