// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllLogTargetPeerOKCode is the HTTP code returned for type GetAllLogTargetPeerOK
const GetAllLogTargetPeerOKCode int = 200

/*
GetAllLogTargetPeerOK Successful operation

swagger:response getAllLogTargetPeerOK
*/
type GetAllLogTargetPeerOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewGetAllLogTargetPeerOK creates GetAllLogTargetPeerOK with default headers values
func NewGetAllLogTargetPeerOK() *GetAllLogTargetPeerOK {

	return &GetAllLogTargetPeerOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all log target peer o k response
func (o *GetAllLogTargetPeerOK) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetPeerOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target peer o k response
func (o *GetAllLogTargetPeerOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target peer o k response
func (o *GetAllLogTargetPeerOK) WithPayload(payload models.LogTargets) *GetAllLogTargetPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target peer o k response
func (o *GetAllLogTargetPeerOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllLogTargetPeerDefault General Error

swagger:response getAllLogTargetPeerDefault
*/
type GetAllLogTargetPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllLogTargetPeerDefault creates GetAllLogTargetPeerDefault with default headers values
func NewGetAllLogTargetPeerDefault(code int) *GetAllLogTargetPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllLogTargetPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all log target peer default response
func (o *GetAllLogTargetPeerDefault) WithStatusCode(code int) *GetAllLogTargetPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all log target peer default response
func (o *GetAllLogTargetPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all log target peer default response
func (o *GetAllLogTargetPeerDefault) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target peer default response
func (o *GetAllLogTargetPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target peer default response
func (o *GetAllLogTargetPeerDefault) WithPayload(payload *models.Error) *GetAllLogTargetPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target peer default response
func (o *GetAllLogTargetPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
