// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteLogTargetLogForwardAcceptedCode is the HTTP code returned for type DeleteLogTargetLogForwardAccepted
const DeleteLogTargetLogForwardAcceptedCode int = 202

/*
DeleteLogTargetLogForwardAccepted Configuration change accepted and reload requested

swagger:response deleteLogTargetLogForwardAccepted
*/
type DeleteLogTargetLogForwardAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteLogTargetLogForwardAccepted creates DeleteLogTargetLogForwardAccepted with default headers values
func NewDeleteLogTargetLogForwardAccepted() *DeleteLogTargetLogForwardAccepted {

	return &DeleteLogTargetLogForwardAccepted{}
}

// WithReloadID adds the reloadId to the delete log target log forward accepted response
func (o *DeleteLogTargetLogForwardAccepted) WithReloadID(reloadID string) *DeleteLogTargetLogForwardAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete log target log forward accepted response
func (o *DeleteLogTargetLogForwardAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteLogTargetLogForwardAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteLogTargetLogForwardNoContentCode is the HTTP code returned for type DeleteLogTargetLogForwardNoContent
const DeleteLogTargetLogForwardNoContentCode int = 204

/*
DeleteLogTargetLogForwardNoContent Log Target deleted

swagger:response deleteLogTargetLogForwardNoContent
*/
type DeleteLogTargetLogForwardNoContent struct {
}

// NewDeleteLogTargetLogForwardNoContent creates DeleteLogTargetLogForwardNoContent with default headers values
func NewDeleteLogTargetLogForwardNoContent() *DeleteLogTargetLogForwardNoContent {

	return &DeleteLogTargetLogForwardNoContent{}
}

// WriteResponse to the client
func (o *DeleteLogTargetLogForwardNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteLogTargetLogForwardNotFoundCode is the HTTP code returned for type DeleteLogTargetLogForwardNotFound
const DeleteLogTargetLogForwardNotFoundCode int = 404

/*
DeleteLogTargetLogForwardNotFound The specified resource was not found

swagger:response deleteLogTargetLogForwardNotFound
*/
type DeleteLogTargetLogForwardNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetLogForwardNotFound creates DeleteLogTargetLogForwardNotFound with default headers values
func NewDeleteLogTargetLogForwardNotFound() *DeleteLogTargetLogForwardNotFound {

	return &DeleteLogTargetLogForwardNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete log target log forward not found response
func (o *DeleteLogTargetLogForwardNotFound) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetLogForwardNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target log forward not found response
func (o *DeleteLogTargetLogForwardNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target log forward not found response
func (o *DeleteLogTargetLogForwardNotFound) WithPayload(payload *models.Error) *DeleteLogTargetLogForwardNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target log forward not found response
func (o *DeleteLogTargetLogForwardNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetLogForwardNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteLogTargetLogForwardDefault General Error

swagger:response deleteLogTargetLogForwardDefault
*/
type DeleteLogTargetLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetLogForwardDefault creates DeleteLogTargetLogForwardDefault with default headers values
func NewDeleteLogTargetLogForwardDefault(code int) *DeleteLogTargetLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteLogTargetLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete log target log forward default response
func (o *DeleteLogTargetLogForwardDefault) WithStatusCode(code int) *DeleteLogTargetLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete log target log forward default response
func (o *DeleteLogTargetLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete log target log forward default response
func (o *DeleteLogTargetLogForwardDefault) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target log forward default response
func (o *DeleteLogTargetLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target log forward default response
func (o *DeleteLogTargetLogForwardDefault) WithPayload(payload *models.Error) *DeleteLogTargetLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target log forward default response
func (o *DeleteLogTargetLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
