// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPErrorRuleFrontendCreatedCode is the HTTP code returned for type CreateHTTPErrorRuleFrontendCreated
const CreateHTTPErrorRuleFrontendCreatedCode int = 201

/*
CreateHTTPErrorRuleFrontendCreated HTTP Error Rule created

swagger:response createHttpErrorRuleFrontendCreated
*/
type CreateHTTPErrorRuleFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleFrontendCreated creates CreateHTTPErrorRuleFrontendCreated with default headers values
func NewCreateHTTPErrorRuleFrontendCreated() *CreateHTTPErrorRuleFrontendCreated {

	return &CreateHTTPErrorRuleFrontendCreated{}
}

// WithPayload adds the payload to the create Http error rule frontend created response
func (o *CreateHTTPErrorRuleFrontendCreated) WithPayload(payload *models.HTTPErrorRule) *CreateHTTPErrorRuleFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule frontend created response
func (o *CreateHTTPErrorRuleFrontendCreated) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleFrontendAcceptedCode is the HTTP code returned for type CreateHTTPErrorRuleFrontendAccepted
const CreateHTTPErrorRuleFrontendAcceptedCode int = 202

/*
CreateHTTPErrorRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response createHttpErrorRuleFrontendAccepted
*/
type CreateHTTPErrorRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleFrontendAccepted creates CreateHTTPErrorRuleFrontendAccepted with default headers values
func NewCreateHTTPErrorRuleFrontendAccepted() *CreateHTTPErrorRuleFrontendAccepted {

	return &CreateHTTPErrorRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create Http error rule frontend accepted response
func (o *CreateHTTPErrorRuleFrontendAccepted) WithReloadID(reloadID string) *CreateHTTPErrorRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http error rule frontend accepted response
func (o *CreateHTTPErrorRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http error rule frontend accepted response
func (o *CreateHTTPErrorRuleFrontendAccepted) WithPayload(payload *models.HTTPErrorRule) *CreateHTTPErrorRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule frontend accepted response
func (o *CreateHTTPErrorRuleFrontendAccepted) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleFrontendBadRequestCode is the HTTP code returned for type CreateHTTPErrorRuleFrontendBadRequest
const CreateHTTPErrorRuleFrontendBadRequestCode int = 400

/*
CreateHTTPErrorRuleFrontendBadRequest Bad request

swagger:response createHttpErrorRuleFrontendBadRequest
*/
type CreateHTTPErrorRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleFrontendBadRequest creates CreateHTTPErrorRuleFrontendBadRequest with default headers values
func NewCreateHTTPErrorRuleFrontendBadRequest() *CreateHTTPErrorRuleFrontendBadRequest {

	return &CreateHTTPErrorRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http error rule frontend bad request response
func (o *CreateHTTPErrorRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http error rule frontend bad request response
func (o *CreateHTTPErrorRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http error rule frontend bad request response
func (o *CreateHTTPErrorRuleFrontendBadRequest) WithPayload(payload *models.Error) *CreateHTTPErrorRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule frontend bad request response
func (o *CreateHTTPErrorRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleFrontendConflictCode is the HTTP code returned for type CreateHTTPErrorRuleFrontendConflict
const CreateHTTPErrorRuleFrontendConflictCode int = 409

/*
CreateHTTPErrorRuleFrontendConflict The specified resource already exists

swagger:response createHttpErrorRuleFrontendConflict
*/
type CreateHTTPErrorRuleFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleFrontendConflict creates CreateHTTPErrorRuleFrontendConflict with default headers values
func NewCreateHTTPErrorRuleFrontendConflict() *CreateHTTPErrorRuleFrontendConflict {

	return &CreateHTTPErrorRuleFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http error rule frontend conflict response
func (o *CreateHTTPErrorRuleFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http error rule frontend conflict response
func (o *CreateHTTPErrorRuleFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http error rule frontend conflict response
func (o *CreateHTTPErrorRuleFrontendConflict) WithPayload(payload *models.Error) *CreateHTTPErrorRuleFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule frontend conflict response
func (o *CreateHTTPErrorRuleFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPErrorRuleFrontendDefault General Error

swagger:response createHttpErrorRuleFrontendDefault
*/
type CreateHTTPErrorRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleFrontendDefault creates CreateHTTPErrorRuleFrontendDefault with default headers values
func NewCreateHTTPErrorRuleFrontendDefault(code int) *CreateHTTPErrorRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPErrorRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP error rule frontend default response
func (o *CreateHTTPErrorRuleFrontendDefault) WithStatusCode(code int) *CreateHTTPErrorRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP error rule frontend default response
func (o *CreateHTTPErrorRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP error rule frontend default response
func (o *CreateHTTPErrorRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP error rule frontend default response
func (o *CreateHTTPErrorRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP error rule frontend default response
func (o *CreateHTTPErrorRuleFrontendDefault) WithPayload(payload *models.Error) *CreateHTTPErrorRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP error rule frontend default response
func (o *CreateHTTPErrorRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
