// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_after_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPAfterResponseRuleBackendOKCode is the HTTP code returned for type GetHTTPAfterResponseRuleBackendOK
const GetHTTPAfterResponseRuleBackendOKCode int = 200

/*
GetHTTPAfterResponseRuleBackendOK Successful operation

swagger:response getHttpAfterResponseRuleBackendOK
*/
type GetHTTPAfterResponseRuleBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPAfterResponseRule `json:"body,omitempty"`
}

// NewGetHTTPAfterResponseRuleBackendOK creates GetHTTPAfterResponseRuleBackendOK with default headers values
func NewGetHTTPAfterResponseRuleBackendOK() *GetHTTPAfterResponseRuleBackendOK {

	return &GetHTTPAfterResponseRuleBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http after response rule backend o k response
func (o *GetHTTPAfterResponseRuleBackendOK) WithConfigurationVersion(configurationVersion string) *GetHTTPAfterResponseRuleBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http after response rule backend o k response
func (o *GetHTTPAfterResponseRuleBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http after response rule backend o k response
func (o *GetHTTPAfterResponseRuleBackendOK) WithPayload(payload *models.HTTPAfterResponseRule) *GetHTTPAfterResponseRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http after response rule backend o k response
func (o *GetHTTPAfterResponseRuleBackendOK) SetPayload(payload *models.HTTPAfterResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPAfterResponseRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPAfterResponseRuleBackendNotFoundCode is the HTTP code returned for type GetHTTPAfterResponseRuleBackendNotFound
const GetHTTPAfterResponseRuleBackendNotFoundCode int = 404

/*
GetHTTPAfterResponseRuleBackendNotFound The specified resource was not found

swagger:response getHttpAfterResponseRuleBackendNotFound
*/
type GetHTTPAfterResponseRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPAfterResponseRuleBackendNotFound creates GetHTTPAfterResponseRuleBackendNotFound with default headers values
func NewGetHTTPAfterResponseRuleBackendNotFound() *GetHTTPAfterResponseRuleBackendNotFound {

	return &GetHTTPAfterResponseRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http after response rule backend not found response
func (o *GetHTTPAfterResponseRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPAfterResponseRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http after response rule backend not found response
func (o *GetHTTPAfterResponseRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http after response rule backend not found response
func (o *GetHTTPAfterResponseRuleBackendNotFound) WithPayload(payload *models.Error) *GetHTTPAfterResponseRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http after response rule backend not found response
func (o *GetHTTPAfterResponseRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPAfterResponseRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPAfterResponseRuleBackendDefault General Error

swagger:response getHttpAfterResponseRuleBackendDefault
*/
type GetHTTPAfterResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPAfterResponseRuleBackendDefault creates GetHTTPAfterResponseRuleBackendDefault with default headers values
func NewGetHTTPAfterResponseRuleBackendDefault(code int) *GetHTTPAfterResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPAfterResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP after response rule backend default response
func (o *GetHTTPAfterResponseRuleBackendDefault) WithStatusCode(code int) *GetHTTPAfterResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP after response rule backend default response
func (o *GetHTTPAfterResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP after response rule backend default response
func (o *GetHTTPAfterResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPAfterResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP after response rule backend default response
func (o *GetHTTPAfterResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP after response rule backend default response
func (o *GetHTTPAfterResponseRuleBackendDefault) WithPayload(payload *models.Error) *GetHTTPAfterResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP after response rule backend default response
func (o *GetHTTPAfterResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPAfterResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
