"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_jupyterlab_completer_lib_index_js"],{

/***/ "../node_modules/@jupyterlab/completer/lib/default/contextprovider.js":
/*!****************************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/default/contextprovider.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CONTEXT_PROVIDER_ID: () => (/* binding */ CONTEXT_PROVIDER_ID),\n/* harmony export */   ContextCompleterProvider: () => (/* binding */ ContextCompleterProvider)\n/* harmony export */ });\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\nconst CONTEXT_PROVIDER_ID = 'CompletionProvider:context';\n/**\n * A context connector for completion handlers.\n */\nclass ContextCompleterProvider {\n    constructor() {\n        this.identifier = CONTEXT_PROVIDER_ID;\n        this.rank = 500;\n        this.renderer = null;\n    }\n    /**\n     * The context completion provider is applicable on all cases.\n     * @param context - additional information about context of completion request\n     */\n    async isApplicable(context) {\n        return true;\n    }\n    /**\n     * Fetch completion requests.\n     *\n     * @param request - The completion request text and details.\n     */\n    fetch(request, context) {\n        const editor = context.editor;\n        if (!editor) {\n            return Promise.reject('No editor');\n        }\n        return new Promise(resolve => {\n            resolve(Private.contextHint(editor));\n        });\n    }\n}\n/**\n * A namespace for Private functionality.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Get a list of completion hints from a tokenization\n     * of the editor.\n     */\n    function contextHint(editor) {\n        // Find the token at the cursor\n        const token = editor.getTokenAtCursor();\n        // Get the list of matching tokens.\n        const tokenList = getCompletionTokens(token, editor);\n        // Only choose the ones that have a non-empty type\n        // field, which are likely to be of interest.\n        const completionList = tokenList.filter(t => t.type).map(t => t.value);\n        // Remove duplicate completions from the list\n        const matches = new Set(completionList);\n        const items = new Array();\n        matches.forEach(label => items.push({ label }));\n        return {\n            start: token.offset,\n            end: token.offset + token.value.length,\n            items\n        };\n    }\n    Private.contextHint = contextHint;\n    /**\n     * Get a list of tokens that match the completion request,\n     * but are not identical to the completion request.\n     */\n    function getCompletionTokens(token, editor) {\n        const candidates = editor.getTokens();\n        // Only get the tokens that have a common start, but\n        // are not identical.\n        return candidates.filter(t => t.value.indexOf(token.value) === 0 && t.value !== token.value);\n    }\n})(Private || (Private = {}));\n//# sourceMappingURL=contextprovider.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/default/contextprovider.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/default/inlinehistoryprovider.js":
/*!**********************************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/default/inlinehistoryprovider.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   HistoryInlineCompletionProvider: () => (/* binding */ HistoryInlineCompletionProvider)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n\n\n/**\n * An example inline completion provider using history to populate suggestions.\n */\nclass HistoryInlineCompletionProvider {\n    constructor(options) {\n        this.options = options;\n        this.identifier = '@jupyterlab/inline-completer:history';\n        this._maxSuggestions = 100;\n        const translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;\n        this._trans = translator.load('jupyterlab');\n    }\n    get name() {\n        return this._trans.__('History');\n    }\n    get icon() {\n        return _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.historyIcon;\n    }\n    get schema() {\n        return {\n            properties: {\n                maxSuggestions: {\n                    title: this._trans.__('Maximum number of suggestions'),\n                    description: this._trans.__('The maximum number of suggestions to retrieve from history.'),\n                    type: 'number'\n                }\n            },\n            default: {\n                // make this provider opt-in\n                enabled: false,\n                maxSuggestions: 100\n            }\n        };\n    }\n    configure(settings) {\n        var _a;\n        this._maxSuggestions = (_a = settings.maxSuggestions) !== null && _a !== void 0 ? _a : 100;\n    }\n    async fetch(request, context, trigger) {\n        var _a;\n        const kernel = (_a = context.session) === null || _a === void 0 ? void 0 : _a.kernel;\n        if (!kernel) {\n            throw new Error('No kernel for completion request.');\n        }\n        const multiLinePrefix = request.text.slice(0, request.offset);\n        const linePrefix = multiLinePrefix.split('\\n').slice(-1)[0];\n        const suffix = request.text.slice(request.offset).split('\\n')[0];\n        let historyRequest;\n        const items = [];\n        if (linePrefix === '') {\n            historyRequest = {\n                output: false,\n                raw: true,\n                hist_access_type: 'tail',\n                n: this._maxSuggestions\n            };\n            const reply = await kernel.requestHistory(historyRequest);\n            if (reply.content.status === 'ok') {\n                let history = reply.content.history;\n                const historyFrequencyMap = new Map();\n                // Count the frequency of each element\n                for (const entry of history.reverse()) {\n                    const sourceLines = entry[2];\n                    historyFrequencyMap.set(sourceLines, (historyFrequencyMap.get(sourceLines) || 0) + 1);\n                }\n                const frequencyHistory = Array.from(historyFrequencyMap.entries());\n                const sortedFrequencyHistory = frequencyHistory.sort((a, b) => {\n                    if (a[1] > b[1]) {\n                        return -1;\n                    }\n                    else if (a[1] < b[1]) {\n                        return 1;\n                    }\n                    else {\n                        return 0;\n                    }\n                });\n                for (const entry of sortedFrequencyHistory) {\n                    items.push({\n                        insertText: entry[0]\n                    });\n                }\n            }\n        }\n        else {\n            historyRequest = {\n                output: false,\n                raw: true,\n                hist_access_type: 'search',\n                pattern: linePrefix + '*' + (suffix ? suffix + '*' : ''),\n                unique: true,\n                n: this._maxSuggestions\n            };\n            const reply = await kernel.requestHistory(historyRequest);\n            if (reply.content.status === 'ok') {\n                for (const entry of reply.content.history) {\n                    const sourceLines = entry[2].split('\\n');\n                    for (let i = 0; i < sourceLines.length; i++) {\n                        const line = sourceLines[i];\n                        if (line.startsWith(linePrefix)) {\n                            let followingLines = line.slice(linePrefix.length);\n                            if (i + 1 < sourceLines.length) {\n                                followingLines += '\\n' + sourceLines.slice(i + 1).join('\\n');\n                            }\n                            if (suffix) {\n                                followingLines = followingLines.slice(0, followingLines.indexOf(suffix));\n                            }\n                            items.push({\n                                insertText: followingLines\n                            });\n                        }\n                    }\n                }\n            }\n        }\n        return { items };\n    }\n}\n//# sourceMappingURL=inlinehistoryprovider.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/default/inlinehistoryprovider.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/default/kernelprovider.js":
/*!***************************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/default/kernelprovider.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   KERNEL_PROVIDER_ID: () => (/* binding */ KERNEL_PROVIDER_ID),\n/* harmony export */   KernelCompleterProvider: () => (/* binding */ KernelCompleterProvider)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils */ \"../node_modules/@jupyterlab/completer/lib/utils.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\nconst KERNEL_PROVIDER_ID = 'CompletionProvider:kernel';\n/**\n * A kernel connector for completion handlers.\n */\nclass KernelCompleterProvider {\n    constructor() {\n        this.identifier = KERNEL_PROVIDER_ID;\n        this.rank = 550;\n        this.renderer = null;\n    }\n    /**\n     * The kernel completion provider is applicable only if the kernel is available.\n     * @param context - additional information about context of completion request\n     */\n    async isApplicable(context) {\n        var _a;\n        const hasKernel = (_a = context.session) === null || _a === void 0 ? void 0 : _a.kernel;\n        if (!hasKernel) {\n            return false;\n        }\n        return true;\n    }\n    /**\n     * Fetch completion requests.\n     *\n     * @param request - The completion request text and details.\n     */\n    async fetch(request, context) {\n        var _a;\n        const kernel = (_a = context.session) === null || _a === void 0 ? void 0 : _a.kernel;\n        if (!kernel) {\n            throw new Error('No kernel for completion request.');\n        }\n        const contents = {\n            code: request.text,\n            cursor_pos: request.offset\n        };\n        const msg = await kernel.requestComplete(contents);\n        const response = msg.content;\n        if (response.status !== 'ok') {\n            throw new Error('Completion fetch failed to return successfully.');\n        }\n        const items = new Array();\n        const metadata = response.metadata._jupyter_types_experimental;\n        response.matches.forEach((label, index) => {\n            if (metadata && metadata[index]) {\n                items.push({\n                    label,\n                    type: metadata[index].type,\n                    insertText: metadata[index].text\n                });\n            }\n            else {\n                items.push({ label });\n            }\n        });\n        return {\n            start: response.cursor_start,\n            end: response.cursor_end,\n            items\n        };\n    }\n    /**\n     * Kernel provider will use the inspect request to lazy-load the content\n     * for document panel.\n     */\n    async resolve(item, context, patch) {\n        const { editor, session } = context;\n        if (session && editor) {\n            let code = editor.model.sharedModel.getSource();\n            const position = editor.getCursorPosition();\n            let offset = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.Text.jsIndexToCharIndex(editor.getOffsetAt(position), code);\n            const kernel = session.kernel;\n            if (!code || !kernel) {\n                return Promise.resolve(item);\n            }\n            if (patch) {\n                const { start, value } = patch;\n                code = code.substring(0, start) + value;\n                offset = offset + value.length;\n            }\n            const contents = {\n                code,\n                cursor_pos: offset,\n                detail_level: 0\n            };\n            const msg = await kernel.requestInspect(contents);\n            const value = msg.content;\n            if (value.status !== 'ok' || !value.found) {\n                return item;\n            }\n            item.documentation = value.data['text/plain'];\n            return item;\n        }\n        return item;\n    }\n    /**\n     * Kernel provider will activate the completer in continuous mode after\n     * the `.` character.\n     */\n    shouldShowContinuousHint(visible, changed, context) {\n        var _a, _b;\n        const mimeType = (_b = (_a = context === null || context === void 0 ? void 0 : context.editor) === null || _a === void 0 ? void 0 : _a.model.mimeType) !== null && _b !== void 0 ? _b : '';\n        if (!(0,_utils__WEBPACK_IMPORTED_MODULE_1__.isHintableMimeType)(mimeType)) {\n            return false;\n        }\n        const sourceChange = changed.sourceChange;\n        if (sourceChange == null) {\n            return true;\n        }\n        if (sourceChange.some(delta => delta.delete != null)) {\n            return false;\n        }\n        return sourceChange.some(delta => delta.insert != null &&\n            (delta.insert === '.' || (!visible && delta.insert.trim().length > 0)));\n    }\n}\n//# sourceMappingURL=kernelprovider.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/default/kernelprovider.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/ghost.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/ghost.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GhostTextManager: () => (/* binding */ GhostTextManager)\n/* harmony export */ });\n/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @codemirror/view */ \"webpack/sharing/consume/default/@codemirror/view/@codemirror/view\");\n/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_codemirror_view__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @codemirror/state */ \"../node_modules/@codemirror/state/dist/index.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\nconst TRANSIENT_LINE_SPACER_CLASS = 'jp-GhostText-lineSpacer';\nconst TRANSIENT_LETTER_SPACER_CLASS = 'jp-GhostText-letterSpacer';\nconst GHOST_TEXT_CLASS = 'jp-GhostText';\nconst STREAMED_TOKEN_CLASS = 'jp-GhostText-streamedToken';\nconst STREAMING_INDICATOR_CLASS = 'jp-GhostText-streamingIndicator';\nconst ERROR_INDICATOR_CLASS = 'jp-GhostText-errorIndicator';\nconst HIDDEN_LINES_CLASS = 'jp-GhostText-hiddenLines';\nclass GhostTextManager {\n    constructor(options) {\n        this.options = options;\n        // no-op\n    }\n    /**\n     * Place ghost text in an editor.\n     */\n    placeGhost(view, text) {\n        const effects = [Private.addMark.of(text)];\n        if (!view.state.field(Private.markField, false)) {\n            effects.push(_codemirror_state__WEBPACK_IMPORTED_MODULE_1__.StateEffect.appendConfig.of([Private.markField]));\n            effects.push(_codemirror_state__WEBPACK_IMPORTED_MODULE_1__.StateEffect.appendConfig.of([\n                _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.EditorView.domEventHandlers({\n                    blur: (event) => {\n                        if (this.options.onBlur(event) === false) {\n                            return true;\n                        }\n                        const effects = [\n                            Private.removeMark.of(null)\n                        ];\n                        // Only execute it after editor update has completed.\n                        setTimeout(() => {\n                            view.dispatch({ effects });\n                        }, 0);\n                    }\n                })\n            ]));\n        }\n        view.dispatch({ effects });\n    }\n    /**\n     * Clear all ghost texts from the editor.\n     */\n    clearGhosts(view) {\n        const effects = [Private.removeMark.of(null)];\n        view.dispatch({ effects });\n    }\n}\n/**\n * Typing animation.\n */\nGhostTextManager.streamingAnimation = 'uncover';\n/**\n * Delay for removal of line spacer.\n */\nGhostTextManager.spacerRemovalDelay = 700;\n/**\n * Duration for line spacer removal.\n */\nGhostTextManager.spacerRemovalDuration = 300;\nclass GhostTextWidget extends _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.WidgetType {\n    constructor(options) {\n        super();\n        this.options = options;\n        this.isSpacer = false;\n        this._clearErrorTimeout = null;\n    }\n    eq(other) {\n        return (other.content == this.content &&\n            other.options.streaming === this.options.streaming &&\n            other.options.error === this.options.error);\n    }\n    get lineBreaks() {\n        return (this.content.match(/\\n/g) || '').length;\n    }\n    updateDOM(dom, _view) {\n        this._updateDOM(dom);\n        return true;\n    }\n    get content() {\n        return this.options.content;\n    }\n    toDOM() {\n        let wrap = document.createElement('span');\n        if (this.options.onPointerOver) {\n            wrap.addEventListener('pointerover', this.options.onPointerOver);\n        }\n        if (this.options.onPointerLeave) {\n            wrap.addEventListener('pointerleave', this.options.onPointerLeave);\n        }\n        wrap.classList.add(GHOST_TEXT_CLASS);\n        wrap.dataset.animation = GhostTextManager.streamingAnimation;\n        wrap.dataset.providedBy = this.options.providerId;\n        this._updateDOM(wrap);\n        return wrap;\n    }\n    _removeErrorAnimation(dom) {\n        const elementsToRemove = dom.querySelectorAll(`.${ERROR_INDICATOR_CLASS}`);\n        elementsToRemove.forEach(element => {\n            element.remove();\n        });\n    }\n    /**\n     * Mount the error animation DOM and remove the streaming indicator if any.\n     */\n    _mountErrorAnimation(dom) {\n        const errorIndicator = document.createElement('span');\n        errorIndicator.className = ERROR_INDICATOR_CLASS;\n        const error = this.options.error;\n        if (error === null || error === void 0 ? void 0 : error.message) {\n            errorIndicator.title = error === null || error === void 0 ? void 0 : error.message;\n        }\n        // Delete stream and previous error animation\n        const elementsToRemove = dom.querySelectorAll(`.${STREAMING_INDICATOR_CLASS}, .${ERROR_INDICATOR_CLASS}`);\n        elementsToRemove.forEach(element => {\n            element.remove();\n        });\n        dom.appendChild(errorIndicator);\n    }\n    _updateDOM(dom) {\n        var _a, _b;\n        if (this.options.error) {\n            this._mountErrorAnimation(dom);\n            this._clearErrorTimeout = setTimeout(() => {\n                this._removeErrorAnimation(dom);\n                this._clearErrorTimeout = null;\n            }, 5000);\n            return;\n        }\n        // If not in an error anymore, clear the error indicator\n        if (this._clearErrorTimeout !== null) {\n            clearTimeout(this._clearErrorTimeout);\n            this._removeErrorAnimation(dom);\n            this._clearErrorTimeout = null;\n        }\n        let content = this.content;\n        let hiddenContent = '';\n        let addition = this.options.addedPart;\n        if (addition) {\n            if (addition.startsWith('\\n')) {\n                // Show the new line straight away to ensure proper positioning.\n                addition = addition.substring(1);\n            }\n            content = content.substring(0, content.length - addition.length);\n        }\n        if (this.options.maxLines) {\n            // Split into content to show immediately and the hidden part\n            const lines = content.split('\\n');\n            content = lines.slice(0, this.options.maxLines).join('\\n');\n            hiddenContent = lines.slice(this.options.maxLines).join('\\n');\n        }\n        const minLines = Math.min((_a = this.options.minLines) !== null && _a !== void 0 ? _a : 0, (_b = this.options.maxLines) !== null && _b !== void 0 ? _b : Infinity);\n        const linesToAdd = Math.max(0, minLines - content.split('\\n').length + 1);\n        const placeHolderLines = new Array(linesToAdd).fill('').join('\\n');\n        if (this.isSpacer) {\n            dom.innerText = content + placeHolderLines;\n            return;\n        }\n        dom.innerText = content;\n        let streamedTokenHost = dom;\n        if (hiddenContent.length > 0) {\n            const hiddenWrapper = document.createElement('span');\n            hiddenWrapper.className = 'jp-GhostText-hiddenWrapper';\n            dom.appendChild(hiddenWrapper);\n            const expandOnHover = document.createElement('span');\n            expandOnHover.className = 'jp-GhostText-expandHidden';\n            expandOnHover.innerText = '⇓';\n            const hiddenPart = document.createElement('span');\n            hiddenWrapper.appendChild(expandOnHover);\n            hiddenPart.className = HIDDEN_LINES_CLASS;\n            hiddenPart.innerText = '\\n' + hiddenContent;\n            hiddenWrapper.appendChild(hiddenPart);\n            streamedTokenHost = hiddenPart;\n        }\n        if (addition) {\n            const addedPart = document.createElement('span');\n            addedPart.className = STREAMED_TOKEN_CLASS;\n            addedPart.innerText = addition;\n            streamedTokenHost.appendChild(addedPart);\n        }\n        // Add \"streaming-in-progress\" indicator\n        if (this.options.streaming) {\n            const streamingIndicator = document.createElement('span');\n            streamingIndicator.className = STREAMING_INDICATOR_CLASS;\n            streamedTokenHost.appendChild(streamingIndicator);\n        }\n        if (placeHolderLines.length > 0) {\n            const placeholderLinesNode = document.createTextNode(placeHolderLines);\n            streamedTokenHost.appendChild(placeholderLinesNode);\n        }\n    }\n    destroy(dom) {\n        if (this.options.onPointerOver) {\n            dom.removeEventListener('pointerover', this.options.onPointerOver);\n        }\n        if (this.options.onPointerLeave) {\n            dom.removeEventListener('pointerleave', this.options.onPointerLeave);\n        }\n        super.destroy(dom);\n    }\n}\n/**\n * Spacers are used to reduce height jitter in the transition between multi-line inline suggestions.\n * In particular, when user removes a letter they will often get a new suggestion in split-second,\n * but without spacer they would see the editor collapse in height and then elongate again.\n */\nclass TransientSpacerWidget extends GhostTextWidget {\n    constructor() {\n        super(...arguments);\n        this.isSpacer = true;\n    }\n}\nclass TransientLineSpacerWidget extends TransientSpacerWidget {\n    toDOM() {\n        const wrap = super.toDOM();\n        wrap.classList.add(TRANSIENT_LINE_SPACER_CLASS);\n        wrap.style.animationDelay = GhostTextManager.spacerRemovalDelay + 'ms';\n        wrap.style.animationDuration =\n            GhostTextManager.spacerRemovalDuration + 'ms';\n        return wrap;\n    }\n}\nclass TransientLetterSpacerWidget extends TransientSpacerWidget {\n    get content() {\n        return this.options.content[0];\n    }\n    toDOM() {\n        const wrap = super.toDOM();\n        wrap.classList.add(TRANSIENT_LETTER_SPACER_CLASS);\n        return wrap;\n    }\n}\nvar Private;\n(function (Private) {\n    let GhostAction;\n    (function (GhostAction) {\n        GhostAction[GhostAction[\"Set\"] = 0] = \"Set\";\n        GhostAction[GhostAction[\"Remove\"] = 1] = \"Remove\";\n        GhostAction[GhostAction[\"FilterAndUpdate\"] = 2] = \"FilterAndUpdate\";\n    })(GhostAction || (GhostAction = {}));\n    Private.addMark = _codemirror_state__WEBPACK_IMPORTED_MODULE_1__.StateEffect.define({\n        map: (old, change) => ({\n            ...old,\n            from: change.mapPos(old.from),\n            to: change.mapPos(old.from + old.content.length)\n        })\n    });\n    Private.removeMark = _codemirror_state__WEBPACK_IMPORTED_MODULE_1__.StateEffect.define();\n    /**\n     * Decide what should be done for transaction effects.\n     */\n    function chooseAction(tr) {\n        // This function can short-circuit because at any time there is no more than one ghost text.\n        for (let e of tr.effects) {\n            if (e.is(Private.addMark)) {\n                return {\n                    action: GhostAction.Set,\n                    spec: e.value\n                };\n            }\n            else if (e.is(Private.removeMark)) {\n                return {\n                    action: GhostAction.Remove\n                };\n            }\n        }\n        if (tr.docChanged || tr.selection) {\n            return {\n                action: GhostAction.FilterAndUpdate\n            };\n        }\n        return null;\n    }\n    function createWidget(spec, tr) {\n        const ghost = _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.Decoration.widget({\n            widget: new GhostTextWidget(spec),\n            side: 1,\n            ghostSpec: spec\n        });\n        // Widget decorations can only have zero-length ranges\n        return ghost.range(Math.min(spec.from, tr.newDoc.length), Math.min(spec.from, tr.newDoc.length));\n    }\n    function createSpacer(spec, tr, timeout = 1000) {\n        // no spacer needed if content is only one character long.\n        if (spec.content.length < 2) {\n            return [];\n        }\n        const timeoutInfo = {\n            elapsed: false\n        };\n        setTimeout(() => {\n            timeoutInfo.elapsed = true;\n        }, timeout);\n        const characterSpacer = _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.Decoration.widget({\n            widget: new TransientLetterSpacerWidget(spec),\n            side: 1,\n            timeoutInfo\n        });\n        const lineSpacer = _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.Decoration.widget({\n            widget: new TransientLineSpacerWidget(spec),\n            side: 1,\n            timeoutInfo\n        });\n        // We add two different spacers: one to temporarily preserve height of as many lines\n        // as there were in the content, and the other (character spacer) to ensure that\n        // cursor is not malformed by the presence of the line spacer.\n        return [\n            characterSpacer.range(Math.min(spec.from, tr.newDoc.length), Math.min(spec.from, tr.newDoc.length)),\n            lineSpacer.range(Math.min(spec.from, tr.newDoc.length), Math.min(spec.from, tr.newDoc.length))\n        ];\n    }\n    Private.markField = _codemirror_state__WEBPACK_IMPORTED_MODULE_1__.StateField.define({\n        create() {\n            return _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.Decoration.none;\n        },\n        update(marks, tr) {\n            const data = chooseAction(tr);\n            // remove spacers after timeout\n            marks = marks.update({\n                filter: (_from, _to, value) => {\n                    if (value.spec.widget instanceof TransientSpacerWidget) {\n                        return !value.spec.timeoutInfo.elapsed;\n                    }\n                    return true;\n                }\n            });\n            if (!data) {\n                return marks.map(tr.changes);\n            }\n            switch (data.action) {\n                case GhostAction.Set: {\n                    const spec = data.spec;\n                    const newWidget = createWidget(spec, tr);\n                    return marks.update({\n                        add: [newWidget],\n                        filter: (_from, _to, value) => value === newWidget.value\n                    });\n                }\n                case GhostAction.Remove:\n                    return marks.update({\n                        filter: () => false\n                    });\n                case GhostAction.FilterAndUpdate: {\n                    let cursor = marks.iter();\n                    // skip over spacer if any\n                    while (cursor.value &&\n                        cursor.value.spec.widget instanceof TransientSpacerWidget) {\n                        cursor.next();\n                    }\n                    if (!cursor.value) {\n                        // short-circuit if no widgets are present, or if only spacer was present\n                        return marks.map(tr.changes);\n                    }\n                    const originalSpec = cursor.value.spec.ghostSpec;\n                    const spec = { ...originalSpec };\n                    let shouldRemoveGhost = false;\n                    tr.changes.iterChanges((fromA, toA, fromB, toB, inserted) => {\n                        if (shouldRemoveGhost) {\n                            return;\n                        }\n                        if (fromA === toA && fromB !== toB) {\n                            // text was inserted without modifying old text\n                            for (let lineNumber = 0; lineNumber < inserted.lines; lineNumber++) {\n                                const lineContent = inserted.lineAt(lineNumber).text;\n                                const line = lineNumber > 0 ? '\\n' + lineContent : lineContent;\n                                if (spec.content.startsWith(line)) {\n                                    spec.content = spec.content.slice(line.length);\n                                    spec.from += line.length;\n                                }\n                                else {\n                                    shouldRemoveGhost = true;\n                                    break;\n                                }\n                            }\n                        }\n                        else if (fromB === toB && fromA !== toA) {\n                            // text was removed\n                            shouldRemoveGhost = true;\n                        }\n                        else {\n                            // text was replaced\n                            shouldRemoveGhost = true;\n                            // TODO: could check if the previous spec matches\n                        }\n                    });\n                    // removing multi-line widget would cause the code cell to jump; instead\n                    // we add a temporary spacer widget(s) which will be removed in a future update\n                    // allowing a slight delay between getting a new suggestion and reducing cell height\n                    const newWidgets = shouldRemoveGhost\n                        ? createSpacer(originalSpec, tr)\n                        : [createWidget(spec, tr)];\n                    const newValues = newWidgets.map(widget => widget.value);\n                    marks = marks.update({\n                        add: newWidgets,\n                        filter: (_from, _to, value) => newValues.includes(value)\n                    });\n                    if (shouldRemoveGhost) {\n                        // TODO this can error out when deleting text, ideally a clean solution would be used.\n                        try {\n                            marks = marks.map(tr.changes);\n                        }\n                        catch (e) {\n                            console.warn(e);\n                            return _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.Decoration.none;\n                        }\n                    }\n                    return marks;\n                }\n            }\n        },\n        provide: f => _codemirror_view__WEBPACK_IMPORTED_MODULE_0__.EditorView.decorations.from(f)\n    });\n})(Private || (Private = {}));\n//# sourceMappingURL=ghost.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/ghost.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/handler.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/handler.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CompletionHandler: () => (/* binding */ CompletionHandler)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/codeeditor */ \"webpack/sharing/consume/default/@jupyterlab/codeeditor/@jupyterlab/codeeditor\");\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/messaging */ \"webpack/sharing/consume/default/@lumino/messaging/@lumino/messaging\");\n/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_messaging__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./tokens */ \"../node_modules/@jupyterlab/completer/lib/tokens.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n/**\n * A completion handler for editors.\n */\nclass CompletionHandler {\n    /**\n     * Construct a new completion handler for a widget.\n     */\n    constructor(options) {\n        this._fetchingInline = 0;\n        this._editor = null;\n        this._enabled = false;\n        this._isDisposed = false;\n        this._autoCompletion = false;\n        this._continuousInline = true;\n        this._tabCompleterActive = false;\n        this.completer = options.completer;\n        this.inlineCompleter = options.inlineCompleter;\n        this.completer.selected.connect(this.onCompletionSelected, this);\n        this.completer.visibilityChanged.connect(this.onVisibilityChanged, this);\n        this._reconciliator = options.reconciliator;\n    }\n    set reconciliator(reconciliator) {\n        this._reconciliator = reconciliator;\n    }\n    /**\n     * The editor used by the completion handler.\n     */\n    get editor() {\n        return this._editor;\n    }\n    set editor(newValue) {\n        if (newValue === this._editor) {\n            return;\n        }\n        let editor = this._editor;\n        // Clean up and disconnect from old editor.\n        if (editor && !editor.isDisposed) {\n            const model = editor.model;\n            editor.host.classList.remove(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_ENABLED_CLASS);\n            editor.host.classList.remove(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_ACTIVE_CLASS);\n            model.selections.changed.disconnect(this.onSelectionsChanged, this);\n            model.sharedModel.changed.disconnect(this._onSharedModelChanged, this);\n        }\n        // Reset completer state.\n        this.completer.reset();\n        this.completer.editor = newValue;\n        // Update the editor and signal connections.\n        editor = this._editor = newValue;\n        if (editor) {\n            const model = editor.model;\n            this._enabled = false;\n            model.selections.changed.connect(this.onSelectionsChanged, this);\n            // We expect the model to be an editor, a file editor, or a cell.\n            const sharedModel = model.sharedModel;\n            // For cells and files the `changed` signal is not limited to text,\n            // but also fires on changes to metadata, outputs, execution count,\n            // and state changes, hence we need to filter the change type.\n            sharedModel.changed.connect(this._onSharedModelChanged, this);\n            // On initial load, manually check the cursor position.\n            this.onSelectionsChanged();\n            if (this.inlineCompleter) {\n                this.inlineCompleter.editor = editor;\n            }\n        }\n    }\n    /**\n     * Get whether the completion handler is disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * Enable/disable continuous hinting mode.\n     */\n    set autoCompletion(value) {\n        this._autoCompletion = value;\n    }\n    get autoCompletion() {\n        return this._autoCompletion;\n    }\n    /**\n     * Dispose of the resources used by the handler.\n     */\n    dispose() {\n        if (this.isDisposed) {\n            return;\n        }\n        this._isDisposed = true;\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal.clearData(this);\n    }\n    /**\n     * Invoke the inline completer on explicit user request.\n     */\n    invokeInline() {\n        const editor = this._editor;\n        if (editor) {\n            this._makeInlineRequest(editor.getCursorPosition(), _tokens__WEBPACK_IMPORTED_MODULE_4__.InlineCompletionTriggerKind.Invoke).catch(reason => {\n                console.warn('Inline invoke request bailed', reason);\n            });\n        }\n    }\n    /**\n     * Invoke the handler and launch a completer.\n     */\n    invoke() {\n        _lumino_messaging__WEBPACK_IMPORTED_MODULE_2__.MessageLoop.sendMessage(this, CompletionHandler.Msg.InvokeRequest);\n    }\n    /**\n     * Process a message sent to the completion handler.\n     */\n    processMessage(msg) {\n        switch (msg.type) {\n            case CompletionHandler.Msg.InvokeRequest.type:\n                this.onInvokeRequest(msg);\n                break;\n            default:\n                break;\n        }\n    }\n    /**\n     * Get the state of the text editor at the given position.\n     */\n    getState(editor, position) {\n        return {\n            text: editor.model.sharedModel.getSource(),\n            line: position.line,\n            column: position.column\n        };\n    }\n    /**\n     * Handle a completion selected signal from the completion widget.\n     */\n    onCompletionSelected(completer, val) {\n        const model = completer.model;\n        const editor = this._editor;\n        if (!editor || !model) {\n            return;\n        }\n        const patch = model.createPatch(val);\n        if (!patch) {\n            return;\n        }\n        const { start, end, value } = patch;\n        const cursorBeforeChange = editor.getOffsetAt(editor.getCursorPosition());\n        // Update the document and the cursor position in the same transaction\n        // to ensure consistency in listeners to document changes.\n        // Note: it also ensures a single change is stored by the undo manager.\n        const transactions = {\n            changes: { from: start, to: end, insert: value }\n        };\n        if (cursorBeforeChange <= end && cursorBeforeChange >= start) {\n            transactions.selection = { anchor: start + value.length };\n        }\n        editor.editor.dispatch(transactions);\n    }\n    /**\n     * Handle `invoke-request` messages.\n     */\n    onInvokeRequest(msg) {\n        // If there is no completer model, bail.\n        if (!this.completer.model) {\n            return;\n        }\n        // If a completer session is already active, bail.\n        if (this.completer.model.original) {\n            return;\n        }\n        const editor = this._editor;\n        if (editor) {\n            this._makeRequest(editor.getCursorPosition(), _tokens__WEBPACK_IMPORTED_MODULE_4__.CompletionTriggerKind.Invoked).catch(reason => {\n                console.warn('Invoke request bailed', reason);\n            });\n        }\n    }\n    /**\n     * Handle selection changed signal from an editor.\n     *\n     * #### Notes\n     * If a sub-class reimplements this method, then that class must either call\n     * its super method or it must take responsibility for adding and removing\n     * the completer completable class to the editor host node.\n     *\n     * Despite the fact that the editor widget adds a class whenever there is a\n     * primary selection, this method checks independently for two reasons:\n     *\n     * 1. The editor widget connects to the same signal to add that class, so\n     *    there is no guarantee that the class will be added before this method\n     *    is invoked so simply checking for the CSS class's existence is not an\n     *    option. Secondarily, checking the editor state should be faster than\n     *    querying the DOM in either case.\n     * 2. Because this method adds a class that indicates whether completer\n     *    functionality ought to be enabled, relying on the behavior of the\n     *    `jp-mod-has-primary-selection` to filter out any editors that have\n     *    a selection means the semantic meaning of `jp-mod-completer-enabled`\n     *    is obscured because there may be cases where the enabled class is added\n     *    even though the completer is not available.\n     */\n    onSelectionsChanged() {\n        var _a;\n        const model = this.completer.model;\n        const editor = this._editor;\n        if (!editor) {\n            return;\n        }\n        const inlineModel = (_a = this.inlineCompleter) === null || _a === void 0 ? void 0 : _a.model;\n        if (inlineModel) {\n            // Dispatch selection change.\n            inlineModel.handleSelectionChange(editor.getSelection());\n        }\n        const host = editor.host;\n        // If there is no model, return.\n        if (!model) {\n            this._enabled = false;\n            host.classList.remove(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_ENABLED_CLASS);\n            return;\n        }\n        // If we are currently performing a subset match,\n        // return without resetting the completer.\n        if (model.subsetMatch) {\n            return;\n        }\n        const position = editor.getCursorPosition();\n        const line = editor.getLine(position.line);\n        const { start, end } = editor.getSelection();\n        // If there is a text selection, return.\n        if (start.column !== end.column || start.line !== end.line) {\n            this._enabled = false;\n            model.reset(true);\n            host.classList.remove(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_ENABLED_CLASS);\n            return;\n        }\n        // If line is empty or the cursor doesn't have any characters before\n        // it besides whitespace, add line beginning class\n        // so that completer can stay enabled, but tab\n        // in codemirror can still be triggered.\n        if (!line || end.column === 0) {\n            host.classList.add(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_LINE_BEGINNING_CLASS);\n        }\n        else if (line && line.slice(0, position.column).match(/^\\s*$/)) {\n            host.classList.add(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_LINE_BEGINNING_CLASS);\n        }\n        else {\n            host.classList.remove(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_LINE_BEGINNING_CLASS);\n        }\n        // Enable completion.\n        if (!this._enabled) {\n            this._enabled = true;\n            host.classList.add(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_ENABLED_CLASS);\n        }\n        // Dispatch the cursor change.\n        model.handleCursorChange(this.getState(editor, editor.getCursorPosition()));\n    }\n    /**\n     * Handle a text changed signal from an editor.\n     */\n    async onTextChanged(str, changed) {\n        var _a;\n        if (!this._enabled) {\n            return;\n        }\n        const model = this.completer.model;\n        const editor = this.editor;\n        if (!editor) {\n            return;\n        }\n        if (model &&\n            this._autoCompletion &&\n            this._reconciliator.shouldShowContinuousHint &&\n            (await this._reconciliator.shouldShowContinuousHint(this.completer.isVisible, changed))) {\n            void this._makeRequest(editor.getCursorPosition(), _tokens__WEBPACK_IMPORTED_MODULE_4__.CompletionTriggerKind.TriggerCharacter);\n        }\n        const inlineModel = (_a = this.inlineCompleter) === null || _a === void 0 ? void 0 : _a.model;\n        if (inlineModel) {\n            // Dispatch the text change to inline completer\n            // (this happens before request is sent)\n            inlineModel.handleTextChange(changed);\n            if (this._continuousInline) {\n                void this._makeInlineRequest(editor.getCursorPosition(), _tokens__WEBPACK_IMPORTED_MODULE_4__.InlineCompletionTriggerKind.Automatic);\n            }\n        }\n        if (model) {\n            // If there is a text selection, no completion is allowed.\n            const { start, end } = editor.getSelection();\n            if (start.column !== end.column || start.line !== end.line) {\n                return;\n            }\n            // Dispatch the text change.\n            model.handleTextChange(this.getState(editor, editor.getCursorPosition()));\n        }\n    }\n    /**\n     * Handle a visibility change signal from a completer widget.\n     */\n    onVisibilityChanged(completer) {\n        var _a;\n        // Completer is not active.\n        if (completer.isDisposed || completer.isHidden) {\n            this._tabCompleterActive = false;\n            if (this._editor) {\n                this._editor.host.classList.remove(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_ACTIVE_CLASS);\n                this._editor.focus();\n            }\n            return;\n        }\n        // Completer is active.\n        this._tabCompleterActive = true;\n        (_a = this._editor) === null || _a === void 0 ? void 0 : _a.host.classList.add(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.COMPLETER_ACTIVE_CLASS);\n    }\n    /**\n     * Handle a text shared model change signal from an editor.\n     */\n    async _onSharedModelChanged(str, changed) {\n        if (changed.sourceChange) {\n            await this.onTextChanged(str, changed);\n        }\n    }\n    /**\n     * Make a completion request.\n     */\n    _makeRequest(position, trigger) {\n        const editor = this.editor;\n        if (!editor) {\n            return Promise.reject(new Error('No active editor'));\n        }\n        const request = this._composeRequest(editor, position);\n        const state = this.getState(editor, position);\n        return this._reconciliator\n            .fetch(request, trigger)\n            .then(reply => {\n            var _a;\n            if (!reply) {\n                return;\n            }\n            const model = this._updateModel(state, reply.start, reply.end);\n            if (!model) {\n                return;\n            }\n            if (this.completer.suppressIfInlineCompleterActive &&\n                ((_a = this.inlineCompleter) === null || _a === void 0 ? void 0 : _a.isActive)) {\n                return;\n            }\n            if (model.setCompletionItems) {\n                model.setCompletionItems(reply.items);\n            }\n        })\n            .catch(p => {\n            /* Fails silently. */\n        });\n    }\n    async _makeInlineRequest(position, trigger) {\n        const editor = this.editor;\n        if (!editor) {\n            return Promise.reject(new Error('No active editor'));\n        }\n        if (!this.inlineCompleter) {\n            return Promise.reject(new Error('No inline completer'));\n        }\n        const line = editor.getLine(position.line);\n        if (trigger === _tokens__WEBPACK_IMPORTED_MODULE_4__.InlineCompletionTriggerKind.Automatic &&\n            (typeof line === 'undefined' ||\n                line.slice(0, position.column).match(/^\\s*$/))) {\n            // In Automatic mode we only auto-trigger on the end of line (and not on the beginning).\n            // Increase the counter to avoid out-of date replies when pressing Backspace quickly.\n            this._fetchingInline += 1;\n            return;\n        }\n        let isMiddleOfLine = false;\n        if (typeof line !== 'undefined' && position.column < line.length) {\n            isMiddleOfLine = true;\n        }\n        const request = this._composeRequest(editor, position);\n        const model = this.inlineCompleter.model;\n        if (!model) {\n            return;\n        }\n        model.cursor = position;\n        const current = ++this._fetchingInline;\n        const promises = this._reconciliator.fetchInline(request, trigger, isMiddleOfLine);\n        let cancelled = false;\n        const completed = new Set();\n        for (const promise of promises) {\n            promise\n                .then(result => {\n                var _a;\n                if (cancelled || !result || !result.items) {\n                    return;\n                }\n                if (current !== this._fetchingInline) {\n                    return;\n                }\n                completed.add(promise);\n                if (completed.size === 1) {\n                    if (((_a = this.inlineCompleter) === null || _a === void 0 ? void 0 : _a.suppressIfTabCompleterActive) &&\n                        this._tabCompleterActive) {\n                        cancelled = true;\n                        return;\n                    }\n                    model.setCompletions(result);\n                }\n                else {\n                    model.appendCompletions(result);\n                }\n            })\n                .catch(e => {\n                // Emit warning for debugging.\n                console.warn(e);\n            })\n                .finally(() => {\n                // Mark the provider promise as completed.\n                completed.add(promise);\n                // Let the model know that we are awaiting for fewer providers now.\n                const remaining = promises.length - completed.size;\n                model.notifyProgress({\n                    pendingProviders: remaining,\n                    totalProviders: promises.length\n                });\n            });\n        }\n    }\n    _composeRequest(editor, position) {\n        const text = editor.model.sharedModel.getSource();\n        const mimeType = editor.model.mimeType;\n        const offset = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Text.jsIndexToCharIndex(editor.getOffsetAt(position), text);\n        return { text, offset, mimeType };\n    }\n    /**\n     * Updates model with text state and current cursor position.\n     */\n    _updateModel(state, start, end) {\n        const model = this.completer.model;\n        const text = state.text;\n        if (!model) {\n            return null;\n        }\n        // Update the original request.\n        model.original = state;\n        // Update the cursor.\n        model.cursor = {\n            start: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Text.charIndexToJsIndex(start, text),\n            end: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Text.charIndexToJsIndex(end, text)\n        };\n        return model;\n    }\n}\n/**\n * A namespace for cell completion handler statics.\n */\n(function (CompletionHandler) {\n    /**\n     * Stream event type.\n     */\n    let StraemEvent;\n    (function (StraemEvent) {\n        StraemEvent[StraemEvent[\"opened\"] = 0] = \"opened\";\n        StraemEvent[StraemEvent[\"update\"] = 1] = \"update\";\n        StraemEvent[StraemEvent[\"closed\"] = 2] = \"closed\";\n    })(StraemEvent = CompletionHandler.StraemEvent || (CompletionHandler.StraemEvent = {}));\n    /**\n     * A namespace for completion handler messages.\n     */\n    let Msg;\n    (function (Msg) {\n        /**\n         * A singleton `'invoke-request'` message.\n         */\n        Msg.InvokeRequest = new _lumino_messaging__WEBPACK_IMPORTED_MODULE_2__.Message('invoke-request');\n    })(Msg = CompletionHandler.Msg || (CompletionHandler.Msg = {}));\n})(CompletionHandler || (CompletionHandler = {}));\n//# sourceMappingURL=handler.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/handler.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/icons.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/icons.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   completerWidgetIcon: () => (/* binding */ completerWidgetIcon),\n/* harmony export */   inlineCompleterIcon: () => (/* binding */ inlineCompleterIcon)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _style_icons_inline_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../style/icons/inline.svg */ \"../node_modules/@jupyterlab/completer/style/icons/inline.svg\");\n/* harmony import */ var _style_icons_widget_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../style/icons/widget.svg */ \"../node_modules/@jupyterlab/completer/style/icons/widget.svg\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\nconst inlineCompleterIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({\n    name: 'completer:inline',\n    svgstr: _style_icons_inline_svg__WEBPACK_IMPORTED_MODULE_1__\n});\nconst completerWidgetIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({\n    name: 'completer:widget',\n    svgstr: _style_icons_widget_svg__WEBPACK_IMPORTED_MODULE_2__\n});\n//# sourceMappingURL=icons.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/icons.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/index.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CONTEXT_PROVIDER_ID: () => (/* reexport safe */ _default_contextprovider__WEBPACK_IMPORTED_MODULE_8__.CONTEXT_PROVIDER_ID),\n/* harmony export */   Completer: () => (/* reexport safe */ _widget__WEBPACK_IMPORTED_MODULE_2__.Completer),\n/* harmony export */   CompleterModel: () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_1__.CompleterModel),\n/* harmony export */   CompletionHandler: () => (/* reexport safe */ _handler__WEBPACK_IMPORTED_MODULE_0__.CompletionHandler),\n/* harmony export */   CompletionProviderManager: () => (/* reexport safe */ _manager__WEBPACK_IMPORTED_MODULE_4__.CompletionProviderManager),\n/* harmony export */   CompletionTriggerKind: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_3__.CompletionTriggerKind),\n/* harmony export */   ContextCompleterProvider: () => (/* reexport safe */ _default_contextprovider__WEBPACK_IMPORTED_MODULE_8__.ContextCompleterProvider),\n/* harmony export */   HistoryInlineCompletionProvider: () => (/* reexport safe */ _default_inlinehistoryprovider__WEBPACK_IMPORTED_MODULE_10__.HistoryInlineCompletionProvider),\n/* harmony export */   ICompletionProviderManager: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_3__.ICompletionProviderManager),\n/* harmony export */   IInlineCompleterFactory: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_3__.IInlineCompleterFactory),\n/* harmony export */   InlineCompleter: () => (/* reexport safe */ _inline__WEBPACK_IMPORTED_MODULE_7__.InlineCompleter),\n/* harmony export */   InlineCompletionTriggerKind: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_3__.InlineCompletionTriggerKind),\n/* harmony export */   KERNEL_PROVIDER_ID: () => (/* reexport safe */ _default_kernelprovider__WEBPACK_IMPORTED_MODULE_9__.KERNEL_PROVIDER_ID),\n/* harmony export */   KernelCompleterProvider: () => (/* reexport safe */ _default_kernelprovider__WEBPACK_IMPORTED_MODULE_9__.KernelCompleterProvider),\n/* harmony export */   ProviderReconciliator: () => (/* reexport safe */ _reconciliator__WEBPACK_IMPORTED_MODULE_5__.ProviderReconciliator),\n/* harmony export */   completerWidgetIcon: () => (/* reexport safe */ _icons__WEBPACK_IMPORTED_MODULE_6__.completerWidgetIcon),\n/* harmony export */   inlineCompleterIcon: () => (/* reexport safe */ _icons__WEBPACK_IMPORTED_MODULE_6__.inlineCompleterIcon)\n/* harmony export */ });\n/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./handler */ \"../node_modules/@jupyterlab/completer/lib/handler.js\");\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./model */ \"../node_modules/@jupyterlab/completer/lib/model.js\");\n/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./widget */ \"../node_modules/@jupyterlab/completer/lib/widget.js\");\n/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./tokens */ \"../node_modules/@jupyterlab/completer/lib/tokens.js\");\n/* harmony import */ var _manager__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./manager */ \"../node_modules/@jupyterlab/completer/lib/manager.js\");\n/* harmony import */ var _reconciliator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./reconciliator */ \"../node_modules/@jupyterlab/completer/lib/reconciliator.js\");\n/* harmony import */ var _icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./icons */ \"../node_modules/@jupyterlab/completer/lib/icons.js\");\n/* harmony import */ var _inline__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./inline */ \"../node_modules/@jupyterlab/completer/lib/inline.js\");\n/* harmony import */ var _default_contextprovider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./default/contextprovider */ \"../node_modules/@jupyterlab/completer/lib/default/contextprovider.js\");\n/* harmony import */ var _default_kernelprovider__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./default/kernelprovider */ \"../node_modules/@jupyterlab/completer/lib/default/kernelprovider.js\");\n/* harmony import */ var _default_inlinehistoryprovider__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./default/inlinehistoryprovider */ \"../node_modules/@jupyterlab/completer/lib/default/inlinehistoryprovider.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/**\n * @packageDocumentation\n * @module completer\n */\n\n\n\n\n\n\n\n\n\n\n\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/inline.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/inline.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   InlineCompleter: () => (/* binding */ InlineCompleter)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _ghost__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ghost */ \"../node_modules/@jupyterlab/completer/lib/ghost.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\nconst INLINE_COMPLETER_CLASS = 'jp-InlineCompleter';\nconst INLINE_COMPLETER_ACTIVE_CLASS = 'jp-mod-inline-completer-active';\nconst HOVER_CLASS = 'jp-InlineCompleter-hover';\nconst PROGRESS_BAR_CLASS = 'jp-InlineCompleter-progressBar';\n/**\n * Widget enabling user to choose among inline completions,\n * typically by pressing next/previous buttons, and showing\n * additional metadata about active completion, such as\n * inline completion provider name.\n */\nclass InlineCompleter extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {\n    constructor(options) {\n        var _a, _b;\n        super({ node: document.createElement('div') });\n        this._clearHoverTimeout = null;\n        this._current = 0;\n        this._editor = null;\n        this._lastItem = null;\n        this._model = null;\n        this._providerWidget = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget();\n        this._showShortcuts = InlineCompleter.defaultSettings.showShortcuts;\n        this._showWidget = InlineCompleter.defaultSettings.showWidget;\n        this._suggestionsCounter = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget();\n        this._toolbar = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.Toolbar();\n        this.model = (_a = options.model) !== null && _a !== void 0 ? _a : null;\n        this.editor = (_b = options.editor) !== null && _b !== void 0 ? _b : null;\n        this.addClass(INLINE_COMPLETER_CLASS);\n        this.addClass('jp-ThemedContainer');\n        this._ghostManager = new _ghost__WEBPACK_IMPORTED_MODULE_3__.GhostTextManager({\n            onBlur: this._onEditorBlur.bind(this)\n        });\n        this._trans = options.trans;\n        const layout = (this.layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.PanelLayout());\n        layout.addWidget(this._suggestionsCounter);\n        layout.addWidget(this.toolbar);\n        layout.addWidget(this._providerWidget);\n        this._progressBar = document.createElement('div');\n        this._progressBar.className = PROGRESS_BAR_CLASS;\n        this.node.appendChild(this._progressBar);\n        this._updateShortcutsVisibility();\n        this._updateDisplay();\n        // Allow the node to receive focus, which prevents removing the ghost text\n        // when user mis-clicks on the tooltip instead of the button in the tooltip.\n        this.node.tabIndex = 0;\n    }\n    /**\n     * Toolbar with buttons such as previous/next/accept.\n     */\n    get toolbar() {\n        return this._toolbar;\n    }\n    /**\n     * The editor used by the completion widget.\n     */\n    get editor() {\n        return this._editor;\n    }\n    set editor(newValue) {\n        var _a;\n        (_a = this.model) === null || _a === void 0 ? void 0 : _a.reset();\n        this._editor = newValue;\n    }\n    /**\n     * The model used by the completer widget.\n     */\n    get model() {\n        return this._model;\n    }\n    set model(model) {\n        if ((!model && !this._model) || model === this._model) {\n            return;\n        }\n        if (this._model) {\n            this._model.suggestionsChanged.disconnect(this._onModelSuggestionsChanged, this);\n            this._model.filterTextChanged.disconnect(this._onModelFilterTextChanged, this);\n            this._model.provisionProgress.disconnect(this._onProvisionProgress, this);\n        }\n        this._model = model;\n        if (this._model) {\n            this._model.suggestionsChanged.connect(this._onModelSuggestionsChanged, this);\n            this._model.filterTextChanged.connect(this._onModelFilterTextChanged, this);\n            this._model.provisionProgress.connect(this._onProvisionProgress, this);\n        }\n    }\n    cycle(direction) {\n        var _a, _b;\n        const items = (_b = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completions) === null || _b === void 0 ? void 0 : _b.items;\n        if (!items) {\n            return;\n        }\n        if (direction === 'next') {\n            const proposed = this._current + 1;\n            this._current = proposed === items.length ? 0 : proposed;\n        }\n        else {\n            const proposed = this._current - 1;\n            this._current = proposed === -1 ? items.length - 1 : proposed;\n        }\n        this._updateStreamTracking();\n        this._render();\n    }\n    accept() {\n        const model = this.model;\n        const candidate = this.current;\n        const editor = this._editor;\n        if (!editor || !model || !candidate) {\n            return;\n        }\n        const position = model.cursor;\n        const value = candidate.insertText;\n        const cursorBeforeChange = editor.getOffsetAt(editor.getCursorPosition());\n        const requestPosition = editor.getOffsetAt(position);\n        const start = requestPosition;\n        const end = cursorBeforeChange;\n        const transactions = {\n            changes: { from: start, to: end, insert: value }\n        };\n        if (cursorBeforeChange <= end && cursorBeforeChange >= start) {\n            transactions.selection = { anchor: start + value.length };\n        }\n        editor.editor.dispatch(transactions);\n        model.reset();\n        this.update();\n    }\n    get current() {\n        var _a;\n        const completions = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completions;\n        if (!completions) {\n            return null;\n        }\n        return completions.items[this._current];\n    }\n    _updateStreamTracking() {\n        if (this._lastItem) {\n            this._lastItem.stream.disconnect(this._onStream, this);\n        }\n        const current = this.current;\n        if (current) {\n            current.stream.connect(this._onStream, this);\n        }\n        this._lastItem = current;\n    }\n    _onStream(_emitter, _change) {\n        var _a;\n        // TODO handle stuck streams, i.e. if we connected and received 'opened'\n        // but then did not receive 'closed' for a long time we should disconnect\n        // and update widget with an 'timed out' status.\n        const completions = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completions;\n        if (!completions || !completions.items || completions.items.length === 0) {\n            return;\n        }\n        if (this.isHidden) {\n            return;\n        }\n        const candidate = completions.items[this._current];\n        this._setText(candidate);\n    }\n    /**\n     * Change user-configurable settings.\n     */\n    configure(settings) {\n        this._showWidget = settings.showWidget;\n        this._updateDisplay();\n        if (settings.showShortcuts !== this._showShortcuts) {\n            this._showShortcuts = settings.showShortcuts;\n            this._updateShortcutsVisibility();\n        }\n        _ghost__WEBPACK_IMPORTED_MODULE_3__.GhostTextManager.streamingAnimation = settings.streamingAnimation;\n        _ghost__WEBPACK_IMPORTED_MODULE_3__.GhostTextManager.spacerRemovalDelay = Math.max(0, settings.editorResizeDelay - 300);\n        _ghost__WEBPACK_IMPORTED_MODULE_3__.GhostTextManager.spacerRemovalDuration = Math.max(0, Math.min(300, settings.editorResizeDelay - 300));\n        this._minLines = settings.minLines;\n        this._maxLines = settings.maxLines;\n        this._reserveSpaceForLongest = settings.reserveSpaceForLongest;\n        this._suppressIfTabCompleterActive = settings.suppressIfTabCompleterActive;\n    }\n    /**\n     * Whether to suppress the inline completer when tab completer is active.\n     */\n    get suppressIfTabCompleterActive() {\n        return this._suppressIfTabCompleterActive;\n    }\n    /**\n     * Whether the inline completer is active.\n     */\n    get isActive() {\n        var _a;\n        return !!((_a = this.editor) === null || _a === void 0 ? void 0 : _a.host.classList.contains(INLINE_COMPLETER_ACTIVE_CLASS));\n    }\n    /**\n     * Handle the DOM events for the widget.\n     *\n     * @param event - The DOM event sent to the widget.\n     *\n     * #### Notes\n     * This method implements the DOM `EventListener` interface and is\n     * called in response to events on the dock panel's node. It should\n     * not be called directly by user code.\n     */\n    handleEvent(event) {\n        if (this.isHidden || !this._editor) {\n            return;\n        }\n        switch (event.type) {\n            case 'pointerdown':\n                this._evtPointerdown(event);\n                break;\n            case 'scroll':\n                this._evtScroll(event);\n                break;\n            default:\n                break;\n        }\n    }\n    /**\n     * Handle `update-request` messages.\n     */\n    onUpdateRequest(msg) {\n        super.onUpdateRequest(msg);\n        const model = this._model;\n        if (!model) {\n            return;\n        }\n        let reply = model.completions;\n        // If there are no items, hide.\n        if (!reply || !reply.items || reply.items.length === 0) {\n            if (!this.isHidden) {\n                this.hide();\n            }\n            return;\n        }\n        if (this.isHidden) {\n            this.show();\n            this._setGeometry();\n        }\n    }\n    /**\n     * Handle `after-attach` messages for the widget.\n     */\n    onAfterAttach(msg) {\n        document.addEventListener('scroll', this, true);\n        document.addEventListener('pointerdown', this, true);\n    }\n    /**\n     * Handle `before-detach` messages for the widget.\n     */\n    onBeforeDetach(msg) {\n        document.removeEventListener('scroll', this, true);\n        document.removeEventListener('pointerdown', this, true);\n    }\n    /**\n     * Handle pointerdown events for the widget.\n     */\n    _evtPointerdown(event) {\n        var _a;\n        if (this.isHidden || !this._editor) {\n            return;\n        }\n        const target = event.target;\n        if (this.node.contains(target)) {\n            return true;\n        }\n        this.hide();\n        (_a = this.model) === null || _a === void 0 ? void 0 : _a.reset();\n    }\n    /**\n     * Handle scroll events for the widget\n     */\n    _evtScroll(event) {\n        if (this.isHidden || !this._editor) {\n            return;\n        }\n        const { node } = this;\n        // All scrolls except scrolls in the actual hover box node may cause the\n        // referent editor that anchors the node to move, so the only scroll events\n        // that can safely be ignored are ones that happen inside the hovering node.\n        if (node.contains(event.target)) {\n            return;\n        }\n        // Set the geometry of the node asynchronously.\n        requestAnimationFrame(() => {\n            this._setGeometry();\n        });\n    }\n    _onEditorBlur(event) {\n        var _a;\n        if (this.node.contains(event.relatedTarget)) {\n            // Cancel removing ghost text if our node is receiving focus\n            return false;\n        }\n        // The ghost text will be removed, so nothing to accept\n        (_a = this._editor) === null || _a === void 0 ? void 0 : _a.host.classList.remove(INLINE_COMPLETER_ACTIVE_CLASS);\n        // Hide the widget if editor was blurred.\n        this.hide();\n    }\n    _onModelSuggestionsChanged(_emitter, args) {\n        var _a;\n        if (!this.isAttached) {\n            this.update();\n            return;\n        }\n        if (args.event === 'set') {\n            this._current = (_a = args.indexMap.get(this._current)) !== null && _a !== void 0 ? _a : 0;\n        }\n        else if (args.event === 'clear') {\n            const editor = this.editor;\n            if (editor) {\n                this._ghostManager.clearGhosts(editor.editor);\n                editor.host.classList.remove(INLINE_COMPLETER_ACTIVE_CLASS);\n            }\n        }\n        this._updateStreamTracking();\n        this.update();\n        this._render();\n    }\n    _onModelFilterTextChanged(_emitter, mapping) {\n        var _a, _b;\n        const completions = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completions;\n        if (!completions || !completions.items || completions.items.length === 0) {\n            return;\n        }\n        this._current = (_b = mapping.get(this._current)) !== null && _b !== void 0 ? _b : 0;\n        this._updateStreamTracking();\n        // Because the signal will be emitted during `EditorView.update` we want to\n        // wait for the update to complete before calling `this._render()`. As there\n        // is no API to check if update is done, we instead defer to next engine tick.\n        setTimeout(() => {\n            this._render();\n            // (reading layout to get coordinate to position hoverbox is not allowed either)\n            this._setGeometry();\n        }, 0);\n    }\n    _onProvisionProgress(_emitter, progress) {\n        requestAnimationFrame(() => {\n            if (progress.pendingProviders === 0) {\n                this._progressBar.style.display = 'none';\n            }\n            else {\n                this._progressBar.style.display = '';\n                this._progressBar.style.width =\n                    (100 * progress.pendingProviders) / progress.totalProviders + '%';\n            }\n        });\n    }\n    _render() {\n        var _a, _b;\n        const completions = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completions;\n        if (!completions || !completions.items || completions.items.length === 0) {\n            return;\n        }\n        const candidate = completions.items[this._current];\n        this._setText(candidate);\n        if (this._showWidget === 'never') {\n            return;\n        }\n        this._suggestionsCounter.node.innerText = this._trans.__('%1/%2', this._current + 1, completions.items.length);\n        this._providerWidget.node.title = this._trans.__('Provider: %1', candidate.provider.name);\n        const icon = (_b = candidate.provider.icon) !== null && _b !== void 0 ? _b : _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.kernelIcon;\n        icon.render(this._providerWidget.node);\n    }\n    _setText(item) {\n        var _a, _b, _c;\n        const text = item.insertText;\n        const editor = this._editor;\n        const model = this._model;\n        if (!model || !editor) {\n            return;\n        }\n        const view = editor.editor;\n        let minLines;\n        if (this._reserveSpaceForLongest) {\n            const items = (_c = (_b = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completions) === null || _b === void 0 ? void 0 : _b.items) !== null && _c !== void 0 ? _c : [];\n            const longest = Math.max(...items.map(i => i.insertText.split('\\n').length));\n            minLines = Math.max(this._minLines, longest);\n        }\n        else {\n            minLines = this._minLines;\n        }\n        this._ghostManager.placeGhost(view, {\n            from: editor.getOffsetAt(model.cursor),\n            content: text,\n            providerId: item.provider.identifier,\n            addedPart: item.lastStreamed,\n            streaming: item.streaming,\n            minLines: minLines,\n            maxLines: this._maxLines,\n            onPointerOver: this._onPointerOverGhost.bind(this),\n            onPointerLeave: this._onPointerLeaveGhost.bind(this),\n            error: item.error\n        });\n        editor.host.classList.add(INLINE_COMPLETER_ACTIVE_CLASS);\n    }\n    _onPointerOverGhost() {\n        if (this._clearHoverTimeout !== null) {\n            window.clearTimeout(this._clearHoverTimeout);\n            this._clearHoverTimeout = null;\n        }\n        this.node.classList.add(HOVER_CLASS);\n    }\n    _onPointerLeaveGhost() {\n        // Remove after a small delay to avoid flicker when moving cursor\n        // between the lines or around the edges of the ghost text.\n        this._clearHoverTimeout = window.setTimeout(() => this.node.classList.remove(HOVER_CLASS), 500);\n    }\n    _setGeometry() {\n        const { node } = this;\n        const model = this._model;\n        const editor = this._editor;\n        if (!editor || !model || !model.cursor) {\n            return;\n        }\n        const host = editor.host.closest('.jp-MainAreaWidget > .lm-Widget') ||\n            editor.host;\n        let anchor;\n        try {\n            const maybeAnchor = editor.getCoordinateForPosition(model.cursor);\n            if (!maybeAnchor) {\n                throw Error('No coordinates for cursor position');\n            }\n            anchor = maybeAnchor;\n        }\n        catch (_a) {\n            // if coordinate is no longer in editor (e.g. after deleting a line), hide widget\n            this.hide();\n            return;\n        }\n        _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.HoverBox.setGeometry({\n            anchor,\n            host: host,\n            maxHeight: 40,\n            minHeight: 20,\n            node: node,\n            privilege: 'forceAbove',\n            outOfViewDisplay: {\n                top: 'stick-outside',\n                bottom: 'stick-inside',\n                left: 'stick-inside',\n                right: 'stick-outside'\n            }\n        });\n    }\n    _updateShortcutsVisibility() {\n        this.node.dataset.showShortcuts = this._showShortcuts + '';\n    }\n    _updateDisplay() {\n        this.node.dataset.display = this._showWidget;\n    }\n}\n/**\n * A namespace for inline completer statics.\n */\n(function (InlineCompleter) {\n    /**\n     * Defaults for runtime user-configurable settings.\n     */\n    InlineCompleter.defaultSettings = {\n        showWidget: 'onHover',\n        showShortcuts: true,\n        streamingAnimation: 'uncover',\n        providers: {},\n        minLines: 2,\n        maxLines: 4,\n        editorResizeDelay: 1000,\n        reserveSpaceForLongest: false,\n        suppressIfTabCompleterActive: true\n    };\n    /**\n     * Model for inline completions.\n     */\n    class Model {\n        constructor() {\n            this.suggestionsChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);\n            this.filterTextChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);\n            this.provisionProgress = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);\n            this._isDisposed = false;\n            this._completions = null;\n        }\n        setCompletions(reply) {\n            var _a, _b;\n            const previousPositions = new Map((_b = (_a = this._completions) === null || _a === void 0 ? void 0 : _a.items) === null || _b === void 0 ? void 0 : _b.map((item, index) => [item.insertText, index]));\n            this._completions = reply;\n            const indexMap = new Map(reply.items.map((item, newIndex) => [\n                previousPositions.get(item.insertText),\n                newIndex\n            ]));\n            this.suggestionsChanged.emit({\n                event: 'set',\n                indexMap\n            });\n        }\n        appendCompletions(reply) {\n            if (!this._completions || !this._completions.items) {\n                console.warn('No completions to append to');\n                return;\n            }\n            this._completions.items.push(...reply.items);\n            this.suggestionsChanged.emit({ event: 'append' });\n        }\n        notifyProgress(progress) {\n            this.provisionProgress.emit(progress);\n        }\n        get cursor() {\n            return this._cursor;\n        }\n        set cursor(value) {\n            this._cursor = value;\n        }\n        get completions() {\n            return this._completions;\n        }\n        reset() {\n            this._completions = null;\n            this.suggestionsChanged.emit({ event: 'clear' });\n        }\n        /**\n         * Get whether the model is disposed.\n         */\n        get isDisposed() {\n            return this._isDisposed;\n        }\n        handleTextChange(sourceChange) {\n            var _a;\n            const completions = this._completions;\n            if (!completions ||\n                !completions.items ||\n                completions.items.length === 0) {\n                return;\n            }\n            const originalPositions = new Map(completions.items.map((item, index) => [item, index]));\n            for (let change of (_a = sourceChange.sourceChange) !== null && _a !== void 0 ? _a : []) {\n                const insert = change.insert;\n                if (insert) {\n                    const items = completions.items.filter(item => {\n                        var _a;\n                        const filterText = (_a = item.filterText) !== null && _a !== void 0 ? _a : item.insertText;\n                        if (!filterText.startsWith(insert)) {\n                            return false;\n                        }\n                        item.filterText = filterText.substring(insert.length);\n                        item.insertText = item.insertText.substring(insert.length);\n                        return true;\n                    });\n                    if (items.length === 0) {\n                        // all items from this provider were filtered out\n                        this._completions = null;\n                    }\n                    completions.items = items;\n                }\n                else {\n                    if (!change.retain) {\n                        this._completions = null;\n                    }\n                }\n            }\n            const indexMap = new Map(completions.items.map((item, newIndex) => [\n                originalPositions.get(item),\n                newIndex\n            ]));\n            this.filterTextChanged.emit(indexMap);\n        }\n        handleSelectionChange(range) {\n            const initialCursor = this.cursor;\n            if (!initialCursor) {\n                return;\n            }\n            const { start, end } = range;\n            if (start.column !== end.column || start.line !== end.line) {\n                // Cancel if user started selecting text.\n                this.reset();\n            }\n            if (start.line !== initialCursor.line ||\n                start.column < initialCursor.column) {\n                // Cancel if user moved cursor to next line or receded to before the origin\n                this.reset();\n            }\n        }\n        /**\n         * Dispose of the resources held by the model.\n         */\n        dispose() {\n            // Do nothing if already disposed.\n            if (this._isDisposed) {\n                return;\n            }\n            this._isDisposed = true;\n            _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);\n        }\n    }\n    InlineCompleter.Model = Model;\n})(InlineCompleter || (InlineCompleter = {}));\n//# sourceMappingURL=inline.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/inline.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/manager.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/manager.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CompletionProviderManager: () => (/* binding */ CompletionProviderManager)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _reconciliator__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./reconciliator */ \"../node_modules/@jupyterlab/completer/lib/reconciliator.js\");\n/* harmony import */ var _default_contextprovider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./default/contextprovider */ \"../node_modules/@jupyterlab/completer/lib/default/contextprovider.js\");\n/* harmony import */ var _default_kernelprovider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./default/kernelprovider */ \"../node_modules/@jupyterlab/completer/lib/default/kernelprovider.js\");\n/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./handler */ \"../node_modules/@jupyterlab/completer/lib/handler.js\");\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./model */ \"../node_modules/@jupyterlab/completer/lib/model.js\");\n/* harmony import */ var _inline__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./inline */ \"../node_modules/@jupyterlab/completer/lib/inline.js\");\n/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./widget */ \"../node_modules/@jupyterlab/completer/lib/widget.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n\n/**\n * A manager for completion providers.\n */\nclass CompletionProviderManager {\n    /**\n     * Construct a new completer manager.\n     */\n    constructor() {\n        /**\n         * The set of activated providers\n         */\n        this._activeProviders = new Set([_default_kernelprovider__WEBPACK_IMPORTED_MODULE_2__.KERNEL_PROVIDER_ID, _default_contextprovider__WEBPACK_IMPORTED_MODULE_3__.CONTEXT_PROVIDER_ID]);\n        this._inlineCompleterSettings = _inline__WEBPACK_IMPORTED_MODULE_4__.InlineCompleter.defaultSettings;\n        this._providers = new Map();\n        this._inlineProviders = new Map();\n        this._panelHandlers = new Map();\n        this._mostRecentContext = new Map();\n        this._activeProvidersChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._selected = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._inlineCompleterFactory = null;\n    }\n    /**\n     * Signal emitted when active providers list is changed.\n     */\n    get activeProvidersChanged() {\n        return this._activeProvidersChanged;\n    }\n    /**\n     * Signal emitted when a selection is made from a completer menu.\n     */\n    get selected() {\n        return this._selected;\n    }\n    /**\n     * Set provider timeout.\n     *\n     * @param {number} timeout - value of timeout in millisecond.\n     */\n    setTimeout(timeout) {\n        this._timeout = timeout;\n    }\n    /**\n     * Enable/disable the document panel.\n     */\n    setShowDocumentationPanel(showDoc) {\n        this._panelHandlers.forEach(handler => (handler.completer.showDocsPanel = showDoc));\n        this._showDoc = showDoc;\n    }\n    /**\n     * Whether to suppress the tab completer when inline completions are presented.\n     */\n    setSuppressIfInlineCompleterActive(suppress) {\n        this._panelHandlers.forEach(handler => (handler.completer.suppressIfInlineCompleterActive = suppress));\n        this._suppressIfInlineCompleterActive = suppress;\n    }\n    /**\n     * Enable/disable continuous hinting mode.\n     */\n    setContinuousHinting(value) {\n        this._panelHandlers.forEach(handler => (handler.autoCompletion = value));\n        this._autoCompletion = value;\n    }\n    /**\n     * Register a completer provider with the manager.\n     *\n     * @param {ICompletionProvider} provider - the provider to be registered.\n     */\n    registerProvider(provider) {\n        const identifier = provider.identifier;\n        if (this._providers.has(identifier)) {\n            console.warn(`Completion provider with identifier ${identifier} is already registered`);\n        }\n        else {\n            this._providers.set(identifier, provider);\n            this._panelHandlers.forEach((handler, id) => {\n                void this.updateCompleter(this._mostRecentContext.get(id));\n            });\n        }\n    }\n    registerInlineProvider(provider) {\n        const identifier = provider.identifier;\n        if (this._inlineProviders.has(identifier)) {\n            console.warn(`Completion provider with identifier ${identifier} is already registered`);\n        }\n        else {\n            this._inlineProviders.set(identifier, provider);\n            this._panelHandlers.forEach((handler, id) => {\n                void this.updateCompleter(this._mostRecentContext.get(id));\n            });\n        }\n    }\n    /**\n     *\n     * Return the map of providers.\n     */\n    getProviders() {\n        return this._providers;\n    }\n    /**\n     * Activate the providers by id, the list of ids is populated from user setting.\n     * The non-existing providers will be discarded.\n     *\n     * @param {Array<string>} providerIds - Array of strings with ids of provider\n     */\n    activateProvider(providerIds) {\n        this._activeProviders = new Set([]);\n        providerIds.forEach(providerId => {\n            if (this._providers.has(providerId)) {\n                this._activeProviders.add(providerId);\n            }\n        });\n        if (this._activeProviders.size === 0) {\n            this._activeProviders.add(_default_kernelprovider__WEBPACK_IMPORTED_MODULE_2__.KERNEL_PROVIDER_ID);\n            this._activeProviders.add(_default_contextprovider__WEBPACK_IMPORTED_MODULE_3__.CONTEXT_PROVIDER_ID);\n        }\n        this._activeProvidersChanged.emit();\n    }\n    /**\n     * Create or update completer handler of a widget with new context.\n     *\n     * @param newCompleterContext - The completion context.\n     */\n    async updateCompleter(newCompleterContext) {\n        var _a, _b;\n        const { widget, editor, sanitizer } = newCompleterContext;\n        const id = widget.id;\n        const handler = this._panelHandlers.get(id);\n        const firstProvider = [...this._activeProviders][0];\n        const provider = this._providers.get(firstProvider);\n        let renderer = (_a = provider === null || provider === void 0 ? void 0 : provider.renderer) !== null && _a !== void 0 ? _a : _widget__WEBPACK_IMPORTED_MODULE_5__.Completer.getDefaultRenderer(sanitizer);\n        const modelFactory = provider === null || provider === void 0 ? void 0 : provider.modelFactory;\n        let model;\n        if (modelFactory) {\n            model = await modelFactory.call(provider, newCompleterContext);\n        }\n        else {\n            model = new _model__WEBPACK_IMPORTED_MODULE_6__.CompleterModel();\n        }\n        this._mostRecentContext.set(widget.id, newCompleterContext);\n        const options = {\n            model,\n            editor,\n            renderer,\n            sanitizer,\n            showDoc: this._showDoc\n        };\n        if (!handler) {\n            // Create a new handler.\n            const handler = await this._generateHandler(newCompleterContext, options);\n            this._panelHandlers.set(widget.id, handler);\n            handler.completer.selected.connect((completer, insertText) => this._selected.emit({ insertText }));\n            widget.disposed.connect(old => {\n                this.disposeHandler(old.id, handler);\n                this._mostRecentContext.delete(id);\n            });\n        }\n        else {\n            // Update existing completer.\n            const completer = handler.completer;\n            (_b = completer.model) === null || _b === void 0 ? void 0 : _b.dispose();\n            completer.model = options.model;\n            completer.renderer = options.renderer;\n            completer.showDocsPanel = options.showDoc;\n            completer.suppressIfInlineCompleterActive =\n                this._suppressIfInlineCompleterActive;\n            // Update other handler attributes.\n            handler.autoCompletion = this._autoCompletion;\n            if (editor) {\n                handler.editor = editor;\n                handler.reconciliator =\n                    await this.generateReconciliator(newCompleterContext);\n            }\n        }\n    }\n    /**\n     * Invoke the completer in the widget with provided id.\n     *\n     * @param id - the id of notebook panel, console panel or code editor.\n     */\n    invoke(id) {\n        const handler = this._panelHandlers.get(id);\n        if (handler) {\n            handler.invoke();\n        }\n    }\n    /**\n     * Activate `select` command in the widget with provided id.\n     *\n     * @param {string} id - the id of notebook panel, console panel or code editor.\n     */\n    select(id) {\n        const handler = this._panelHandlers.get(id);\n        if (handler) {\n            handler.completer.selectActive();\n        }\n    }\n    /**\n     * Set inline completer factory.\n     */\n    setInlineCompleterFactory(factory) {\n        this._inlineCompleterFactory = factory;\n        this._panelHandlers.forEach((handler, id) => {\n            void this.updateCompleter(this._mostRecentContext.get(id));\n        });\n        if (this.inline) {\n            return;\n        }\n        this.inline = {\n            invoke: (id) => {\n                const handler = this._panelHandlers.get(id);\n                if (handler && handler.inlineCompleter) {\n                    handler.invokeInline();\n                }\n            },\n            isActive: (id) => {\n                const handler = this._panelHandlers.get(id);\n                if (handler && handler.inlineCompleter) {\n                    return handler.inlineCompleter.isActive;\n                }\n                return false;\n            },\n            cycle: (id, direction) => {\n                const handler = this._panelHandlers.get(id);\n                if (handler && handler.inlineCompleter) {\n                    handler.inlineCompleter.cycle(direction);\n                }\n            },\n            accept: (id) => {\n                const handler = this._panelHandlers.get(id);\n                if (handler && handler.inlineCompleter) {\n                    handler.inlineCompleter.accept();\n                }\n            },\n            configure: (settings) => {\n                this._inlineCompleterSettings = settings;\n                for (const [providerId, provider] of this._inlineProviders.entries()) {\n                    if (provider.configure) {\n                        provider.configure(settings.providers[providerId]);\n                    }\n                }\n                this._panelHandlers.forEach((handler, handlerId) => {\n                    if (handler.inlineCompleter) {\n                        handler.inlineCompleter.configure(settings);\n                    }\n                    // trigger update to regenerate reconciliator\n                    void this.updateCompleter(this._mostRecentContext.get(handlerId));\n                });\n            }\n        };\n    }\n    /**\n     * Inline providers information.\n     */\n    get inlineProviders() {\n        return [...this._inlineProviders.values()];\n    }\n    /**\n     * Helper function to generate a `ProviderReconciliator` with provided context.\n     * The `isApplicable` method of provider is used to filter out the providers\n     * which can not be used with provided context.\n     *\n     * @param {ICompletionContext} completerContext - the current completer context\n     */\n    async generateReconciliator(completerContext) {\n        const enabledProviders = [];\n        for (const [id, providerSettings] of Object.entries(this._inlineCompleterSettings.providers)) {\n            if (providerSettings.enabled === true) {\n                enabledProviders.push(id);\n            }\n        }\n        const inlineProviders = [...this._inlineProviders.values()].filter(provider => enabledProviders.includes(provider.identifier));\n        const providers = [];\n        for (const id of this._activeProviders) {\n            const provider = this._providers.get(id);\n            if (provider) {\n                providers.push(provider);\n            }\n        }\n        return new _reconciliator__WEBPACK_IMPORTED_MODULE_7__.ProviderReconciliator({\n            context: completerContext,\n            providers,\n            inlineProviders,\n            inlineProvidersSettings: this._inlineCompleterSettings.providers,\n            timeout: this._timeout\n        });\n    }\n    /**\n     * Helper to dispose the completer handler on widget disposed event.\n     *\n     * @param {string} id - id of the widget\n     * @param {CompletionHandler} handler - the handler to be disposed.\n     */\n    disposeHandler(id, handler) {\n        var _a, _b, _c, _d;\n        (_a = handler.completer.model) === null || _a === void 0 ? void 0 : _a.dispose();\n        handler.completer.dispose();\n        (_c = (_b = handler.inlineCompleter) === null || _b === void 0 ? void 0 : _b.model) === null || _c === void 0 ? void 0 : _c.dispose();\n        (_d = handler.inlineCompleter) === null || _d === void 0 ? void 0 : _d.dispose();\n        handler.dispose();\n        this._panelHandlers.delete(id);\n    }\n    /**\n     * Helper to generate a completer handler from provided context.\n     */\n    async _generateHandler(completerContext, options) {\n        const completer = new _widget__WEBPACK_IMPORTED_MODULE_5__.Completer(options);\n        const inlineCompleter = this._inlineCompleterFactory\n            ? this._inlineCompleterFactory.factory({\n                ...options,\n                model: new _inline__WEBPACK_IMPORTED_MODULE_4__.InlineCompleter.Model()\n            })\n            : undefined;\n        completer.hide();\n        _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget.attach(completer, document.body);\n        if (inlineCompleter) {\n            _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget.attach(inlineCompleter, document.body);\n            inlineCompleter.hide();\n            inlineCompleter.configure(this._inlineCompleterSettings);\n        }\n        const reconciliator = await this.generateReconciliator(completerContext);\n        const handler = new _handler__WEBPACK_IMPORTED_MODULE_8__.CompletionHandler({\n            completer,\n            inlineCompleter,\n            reconciliator: reconciliator\n        });\n        handler.editor = completerContext.editor;\n        return handler;\n    }\n}\n//# sourceMappingURL=manager.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/manager.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/model.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/model.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CompleterModel: () => (/* binding */ CompleterModel)\n/* harmony export */ });\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_2__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * Escape HTML by native means of the browser.\n */\nfunction escapeHTML(text) {\n    const node = document.createElement('span');\n    node.textContent = text;\n    return node.innerHTML;\n}\n/**\n * An implementation of a completer model.\n */\nclass CompleterModel {\n    constructor() {\n        this.processedItemsCache = null;\n        this._current = null;\n        this._cursor = null;\n        this._isDisposed = false;\n        this._completionItems = [];\n        this._original = null;\n        this._query = '';\n        this._subsetMatch = false;\n        this._typeMap = {};\n        this._orderedTypes = [];\n        this._stateChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);\n        this._queryChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);\n        /**\n         * The weak map between a processed completion item with the original item.\n         * It's used to keep track of original completion item in case of displaying\n         * the completer with query.\n         */\n        this._processedToOriginalItem = null;\n        /**\n         * A counter to cancel ongoing `resolveItem` call.\n         */\n        this._resolvingItem = 0;\n    }\n    /**\n     * A signal emitted when state of the completer menu changes.\n     */\n    get stateChanged() {\n        return this._stateChanged;\n    }\n    /**\n     * A signal emitted when query string changes (at invocation, or as user types).\n     */\n    get queryChanged() {\n        return this._queryChanged;\n    }\n    /**\n     * The original completion request details.\n     */\n    get original() {\n        return this._original;\n    }\n    set original(newValue) {\n        const unchanged = this._original === newValue ||\n            (this._original &&\n                newValue &&\n                _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(newValue, this._original));\n        if (unchanged) {\n            return;\n        }\n        this._reset();\n        // Set both the current and original to the same value when original is set.\n        this._current = this._original = newValue;\n        this._stateChanged.emit(undefined);\n    }\n    /**\n     * The current text change details.\n     */\n    get current() {\n        return this._current;\n    }\n    set current(newValue) {\n        const unchanged = this._current === newValue ||\n            (this._current && newValue && _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(newValue, this._current));\n        if (unchanged) {\n            return;\n        }\n        const original = this._original;\n        // Original request must always be set before a text change. If it isn't\n        // the model fails silently.\n        if (!original) {\n            return;\n        }\n        const cursor = this._cursor;\n        // Cursor must always be set before a text change. This happens\n        // automatically in the completer handler, but since `current` is a public\n        // attribute, this defensive check is necessary.\n        if (!cursor) {\n            return;\n        }\n        const current = (this._current = newValue);\n        if (!current) {\n            this._stateChanged.emit(undefined);\n            return;\n        }\n        const originalLine = original.text.split('\\n')[original.line];\n        const currentLine = current.text.split('\\n')[current.line];\n        // If the text change means that the original start point has been preceded,\n        // then the completion is no longer valid and should be reset.\n        if (!this._subsetMatch && currentLine.length < originalLine.length) {\n            this.reset(true);\n            return;\n        }\n        const { start, end } = cursor;\n        // Clip the front of the current line.\n        let query = current.text.substring(start);\n        // Clip the back of the current line by calculating the end of the original.\n        const ending = original.text.substring(end);\n        query = query.substring(0, query.lastIndexOf(ending));\n        this._query = query;\n        this.processedItemsCache = null;\n        this._processedToOriginalItem = null;\n        this._queryChanged.emit({ newValue: this._query, origin: 'editorUpdate' });\n        this._stateChanged.emit(undefined);\n    }\n    /**\n     * The cursor details that the API has used to return matching options.\n     */\n    get cursor() {\n        return this._cursor;\n    }\n    set cursor(newValue) {\n        // Original request must always be set before a cursor change. If it isn't\n        // the model fails silently.\n        if (!this.original) {\n            return;\n        }\n        this._cursor = newValue;\n    }\n    /**\n     * The query against which items are filtered.\n     */\n    get query() {\n        return this._query;\n    }\n    set query(newValue) {\n        this._query = newValue;\n        this.processedItemsCache = null;\n        this._processedToOriginalItem = null;\n        this._queryChanged.emit({ newValue: this._query, origin: 'setter' });\n    }\n    /**\n     * A flag that is true when the model value was modified by a subset match.\n     */\n    get subsetMatch() {\n        return this._subsetMatch;\n    }\n    set subsetMatch(newValue) {\n        this._subsetMatch = newValue;\n    }\n    /**\n     * Get whether the model is disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * Dispose of the resources held by the model.\n     */\n    dispose() {\n        // Do nothing if already disposed.\n        if (this._isDisposed) {\n            return;\n        }\n        this._isDisposed = true;\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal.clearData(this);\n    }\n    /**\n     * The list of visible items in the completer menu.\n     *\n     * #### Notes\n     * This is a read-only property.\n     * When overriding it is recommended to cache results in `processedItemsCache`\n     * property which will be automatically nullified when needed.\n     */\n    completionItems() {\n        if (!this.processedItemsCache) {\n            let query = this._query;\n            if (query) {\n                const markedItems = this._markup(query);\n                this.processedItemsCache = markedItems.map(it => it.processedItem);\n                this._processedToOriginalItem = new WeakMap(markedItems.map(it => [it.processedItem, it.originalItem]));\n            }\n            else {\n                this.processedItemsCache = this._completionItems.map(item => {\n                    return this._escapeItemLabel(item);\n                });\n                this._processedToOriginalItem = null;\n            }\n        }\n        return this.processedItemsCache;\n    }\n    /**\n     * Set the list of visible items in the completer menu, and append any\n     * new types to KNOWN_TYPES.\n     */\n    setCompletionItems(newValue) {\n        if (_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(newValue, this._completionItems)) {\n            return;\n        }\n        this._completionItems = newValue;\n        this._orderedTypes = Private.findOrderedCompletionItemTypes(this._completionItems);\n        this.processedItemsCache = null;\n        this._processedToOriginalItem = null;\n        this._stateChanged.emit(undefined);\n    }\n    /**\n     * The map from identifiers (a.b) to types (function, module, class, instance,\n     * etc.).\n     *\n     * #### Notes\n     * A type map is currently only provided by the latest IPython kernel using\n     * the completer reply metadata field `_jupyter_types_experimental`. The\n     * values are completely up to the kernel.\n     *\n     */\n    typeMap() {\n        return this._typeMap;\n    }\n    /**\n     * An ordered list of all the known types in the typeMap.\n     *\n     * #### Notes\n     * To visually encode the types of the completer matches, we assemble an\n     * ordered list. This list begins with:\n     * ```\n     * ['function', 'instance', 'class', 'module', 'keyword']\n     * ```\n     * and then has any remaining types listed alphabetically. This will give\n     * reliable visual encoding for these known types, but allow kernels to\n     * provide new types.\n     */\n    orderedTypes() {\n        return this._orderedTypes;\n    }\n    /**\n     * Handle a cursor change.\n     */\n    handleCursorChange(change) {\n        // If there is no active completion, return.\n        if (!this._original) {\n            return;\n        }\n        const { column, line } = change;\n        const { current, original } = this;\n        if (!original) {\n            return;\n        }\n        // If a cursor change results in a the cursor being on a different line\n        // than the original request, cancel.\n        if (line !== original.line) {\n            this.reset(true);\n            return;\n        }\n        // If a cursor change results in the cursor being set to a position that\n        // precedes the original column, cancel.\n        if (column < original.column) {\n            this.reset(true);\n            return;\n        }\n        const { cursor } = this;\n        if (!cursor || !current) {\n            return;\n        }\n        // If a cursor change results in the cursor being set to a position beyond\n        // the end of the area that would be affected by completion, cancel.\n        const cursorDelta = cursor.end - cursor.start;\n        const originalLine = original.text.split('\\n')[original.line];\n        const currentLine = current.text.split('\\n')[current.line];\n        const inputDelta = currentLine.length - originalLine.length;\n        if (column > original.column + cursorDelta + inputDelta) {\n            this.reset(true);\n            return;\n        }\n    }\n    /**\n     * Handle a text change.\n     */\n    handleTextChange(change) {\n        const original = this._original;\n        // If there is no active completion, return.\n        if (!original) {\n            return;\n        }\n        const { text, column, line } = change;\n        const last = text.split('\\n')[line][column - 1];\n        // If last character entered is not whitespace or if the change column is\n        // greater than or equal to the original column, update completion.\n        if ((last && last.match(/\\S/)) || change.column >= original.column) {\n            this.current = change;\n            return;\n        }\n        // If final character is whitespace, reset completion.\n        this.reset(false);\n    }\n    /**\n     * Create a resolved patch between the original state and a patch string.\n     *\n     * @param patch - The patch string to apply to the original value.\n     *\n     * @returns A patched text change or undefined if original value did not exist.\n     */\n    createPatch(patch) {\n        const original = this._original;\n        const cursor = this._cursor;\n        const current = this._current;\n        if (!original || !cursor || !current) {\n            return undefined;\n        }\n        let { start, end } = cursor;\n        // Also include any filtering/additional-typing that has occurred\n        // since the completion request in the patched length.\n        end = end + (current.text.length - original.text.length);\n        return { start, end, value: patch };\n    }\n    /**\n     * Reset the state of the model and emit a state change signal.\n     *\n     * @param hard - Reset even if a subset match is in progress.\n     */\n    reset(hard = false) {\n        // When the completer detects a common subset prefix for all options,\n        // it updates the model and sets the model source to that value, triggering\n        // a reset. Unless explicitly a hard reset, this should be ignored.\n        if (!hard && this._subsetMatch) {\n            return;\n        }\n        this._reset();\n        this._stateChanged.emit(undefined);\n    }\n    /**\n     * Check if CompletionItem matches against query.\n     * Highlight matching prefix by adding <mark> tags.\n     */\n    _markup(query) {\n        var _a;\n        const items = this._completionItems;\n        let results = [];\n        for (const originalItem of items) {\n            // See if label matches query string\n            // With ICompletionItems, the label may include parameters,\n            // so we exclude them from the matcher.\n            // e.g. Given label `foo(b, a, r)` and query `bar`,\n            // don't count parameters, `b`, `a`, and `r` as matches.\n            const index = originalItem.label.indexOf('(');\n            const text = index > -1\n                ? originalItem.label.substring(0, index)\n                : originalItem.label;\n            const match = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.StringExt.matchSumOfSquares(escapeHTML(text), query);\n            // Filter non-matching items.\n            if (match) {\n                // Highlight label text if there's a match\n                let marked = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.StringExt.highlight(escapeHTML(originalItem.label), match.indices, Private.mark);\n                // Use `Object.assign` to evaluate getters.\n                const highlightedItem = Object.assign({}, originalItem);\n                highlightedItem.label = marked.join('');\n                highlightedItem.insertText =\n                    (_a = originalItem.insertText) !== null && _a !== void 0 ? _a : originalItem.label;\n                results.push({\n                    item: highlightedItem,\n                    score: match.score,\n                    originalItem\n                });\n            }\n        }\n        results.sort(Private.scoreCmp);\n        // Extract only the item (dropping the extra score attribute to not leak\n        // implementation details to JavaScript callers.\n        return results.map(match => ({\n            processedItem: match.item,\n            originalItem: match.originalItem\n        }));\n    }\n    /**\n     * Lazy load missing data of an item.\n     * @param indexOrValue - the item or its index\n     * @remarks\n     * Resolving item by index will be deprecated in\n     * the JupyterLab 5.0 and removed in JupyterLab 6.0.\n     *\n     * @return Return `undefined` if the completion item with `activeIndex` index can not be found.\n     *  Return a promise of `null` if another `resolveItem` is called. Otherwise return the\n     * promise of resolved completion item.\n     */\n    resolveItem(indexOrValue) {\n        let processedItem;\n        if (typeof indexOrValue === 'number') {\n            const completionItems = this.completionItems();\n            if (!completionItems || !completionItems[indexOrValue]) {\n                return undefined;\n            }\n            processedItem = completionItems[indexOrValue];\n        }\n        else {\n            processedItem = indexOrValue;\n        }\n        if (!processedItem) {\n            return undefined;\n        }\n        let originalItem;\n        if (this._processedToOriginalItem) {\n            originalItem = this._processedToOriginalItem.get(processedItem);\n        }\n        else {\n            originalItem = processedItem;\n        }\n        if (!originalItem) {\n            return undefined;\n        }\n        return this._resolveItemByValue(originalItem);\n    }\n    /**\n     * Lazy load missing data of a completion item.\n     *\n     * @param  completionItem - the item to be resolved\n     * @return See `resolveItem` method\n     */\n    _resolveItemByValue(completionItem) {\n        const current = ++this._resolvingItem;\n        let resolvedItem;\n        if (completionItem.resolve) {\n            let patch;\n            if (completionItem.insertText) {\n                patch = this.createPatch(completionItem.insertText);\n            }\n            resolvedItem = completionItem.resolve(patch);\n        }\n        else {\n            resolvedItem = Promise.resolve(completionItem);\n        }\n        return resolvedItem\n            .then(activeItem => {\n            // Escape the label it in place\n            this._escapeItemLabel(activeItem, true);\n            Object.keys(activeItem).forEach((key) => {\n                completionItem[key] = activeItem[key];\n            });\n            completionItem.resolve = undefined;\n            if (current !== this._resolvingItem) {\n                return Promise.resolve(null);\n            }\n            return activeItem;\n        })\n            .catch(e => {\n            console.error(e);\n            // Failed to resolve missing data, return the original item.\n            return Promise.resolve(completionItem);\n        });\n    }\n    /**\n     * Escape item label, storing the original label and adding `insertText` if needed.\n     * If escaping changes label creates a new item unless `inplace` is true.\n     */\n    _escapeItemLabel(item, inplace = false) {\n        var _a;\n        const escapedLabel = escapeHTML(item.label);\n        // If there was no insert text, use the original (unescaped) label.\n        if (escapedLabel !== item.label) {\n            const newItem = inplace ? item : Object.assign({}, item);\n            newItem.insertText = (_a = item.insertText) !== null && _a !== void 0 ? _a : item.label;\n            newItem.label = escapedLabel;\n            return newItem;\n        }\n        return item;\n    }\n    /**\n     * Reset the state of the model.\n     */\n    _reset() {\n        const hadQuery = this._query;\n        this._current = null;\n        this._cursor = null;\n        this._completionItems = [];\n        this._original = null;\n        this._query = '';\n        this.processedItemsCache = null;\n        this._processedToOriginalItem = null;\n        this._subsetMatch = false;\n        this._typeMap = {};\n        this._orderedTypes = [];\n        if (hadQuery) {\n            this._queryChanged.emit({ newValue: this._query, origin: 'reset' });\n        }\n    }\n}\n/**\n * A namespace for completer model private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * The list of known type annotations of completer matches.\n     */\n    const KNOWN_TYPES = ['function', 'instance', 'class', 'module', 'keyword'];\n    /**\n     * The map of known type annotations of completer matches.\n     */\n    const KNOWN_MAP = KNOWN_TYPES.reduce((acc, type) => {\n        acc[type] = null;\n        return acc;\n    }, {});\n    /**\n     * Mark a highlighted chunk of text.\n     */\n    function mark(value) {\n        return `<mark>${value}</mark>`;\n    }\n    Private.mark = mark;\n    /**\n     * A sort comparison function for item match scores.\n     *\n     * #### Notes\n     * This orders the items first based on score (lower is better), then\n     * by locale order of the item text.\n     */\n    function scoreCmp(a, b) {\n        var _a, _b, _c;\n        const delta = a.score - b.score;\n        if (delta !== 0) {\n            return delta;\n        }\n        return (_c = (_a = a.item.insertText) === null || _a === void 0 ? void 0 : _a.localeCompare((_b = b.item.insertText) !== null && _b !== void 0 ? _b : '')) !== null && _c !== void 0 ? _c : 0;\n    }\n    Private.scoreCmp = scoreCmp;\n    /**\n     * Compute a reliably ordered list of types for ICompletionItems.\n     *\n     * #### Notes\n     * The resulting list always begins with the known types:\n     * ```\n     * ['function', 'instance', 'class', 'module', 'keyword']\n     * ```\n     * followed by other types in alphabetical order.\n     *\n     */\n    function findOrderedCompletionItemTypes(items) {\n        const newTypeSet = new Set();\n        items.forEach(item => {\n            if (item.type &&\n                !KNOWN_TYPES.includes(item.type) &&\n                !newTypeSet.has(item.type)) {\n                newTypeSet.add(item.type);\n            }\n        });\n        const newTypes = Array.from(newTypeSet);\n        newTypes.sort((a, b) => a.localeCompare(b));\n        return KNOWN_TYPES.concat(newTypes);\n    }\n    Private.findOrderedCompletionItemTypes = findOrderedCompletionItemTypes;\n    /**\n     * Compute a reliably ordered list of types.\n     *\n     * #### Notes\n     * The resulting list always begins with the known types:\n     * ```\n     * ['function', 'instance', 'class', 'module', 'keyword']\n     * ```\n     * followed by other types in alphabetical order.\n     */\n    function findOrderedTypes(typeMap) {\n        const filtered = Object.keys(typeMap)\n            .map(key => typeMap[key])\n            .filter((value) => !!value && !(value in KNOWN_MAP))\n            .sort((a, b) => a.localeCompare(b));\n        return KNOWN_TYPES.concat(filtered);\n    }\n    Private.findOrderedTypes = findOrderedTypes;\n})(Private || (Private = {}));\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/reconciliator.js":
/*!******************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/reconciliator.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ProviderReconciliator: () => (/* binding */ ProviderReconciliator)\n/* harmony export */ });\n/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./handler */ \"../node_modules/@jupyterlab/completer/lib/handler.js\");\n/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tokens */ \"../node_modules/@jupyterlab/completer/lib/tokens.js\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils */ \"../node_modules/@jupyterlab/completer/lib/utils.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n/**\n * The reconciliator which is used to fetch and merge responses from multiple completion providers.\n */\nclass ProviderReconciliator {\n    /**\n     * Creates an instance of ProviderReconciliator.\n     */\n    constructor(options) {\n        var _a, _b;\n        this._resolveFactory = (provider, el) => provider.resolve\n            ? (patch) => provider.resolve(el, this._context, patch)\n            : undefined;\n        /**\n         * Counter to reject current provider response if a new fetch request is created.\n         */\n        this._fetching = 0;\n        /**\n         * Counter to reject current inline provider response if a new `inlineFetch` request is created.\n         */\n        this._inlineFetching = 0;\n        this._providers = options.providers;\n        this._inlineProviders = (_a = options.inlineProviders) !== null && _a !== void 0 ? _a : [];\n        this._inlineProvidersSettings = (_b = options.inlineProvidersSettings) !== null && _b !== void 0 ? _b : {};\n        this._context = options.context;\n        this._timeout = options.timeout;\n    }\n    /**\n     * Check for the providers which are applicable with the current context\n     *\n     * @return  List of applicable providers\n     */\n    async applicableProviders() {\n        const isApplicablePromises = this._providers.map(p => p.isApplicable(this._context));\n        const applicableProviders = await Promise.all(isApplicablePromises);\n        return this._providers.filter((_, idx) => applicableProviders[idx]);\n    }\n    fetchInline(request, trigger, isMiddleOfLine) {\n        let promises = [];\n        const current = ++this._inlineFetching;\n        for (const provider of this._inlineProviders) {\n            const settings = this._inlineProvidersSettings[provider.identifier];\n            if (trigger !== _tokens__WEBPACK_IMPORTED_MODULE_1__.InlineCompletionTriggerKind.Invoke &&\n                isMiddleOfLine &&\n                !settings.autoFillInMiddle) {\n                // Skip if FIM is disabled\n                continue;\n            }\n            let delay = 0;\n            if (trigger === _tokens__WEBPACK_IMPORTED_MODULE_1__.InlineCompletionTriggerKind.Automatic) {\n                delay = settings.debouncerDelay;\n            }\n            const fetch = () => {\n                const promise = provider\n                    .fetch(request, { ...this._context, triggerKind: trigger })\n                    .then(completionList => {\n                    return {\n                        ...completionList,\n                        items: completionList.items.map(item => {\n                            const newItem = item;\n                            newItem.stream = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(newItem);\n                            newItem.provider = provider;\n                            void this._stream(newItem, provider);\n                            return newItem;\n                        })\n                    };\n                });\n                const timeoutPromise = new Promise(resolve => {\n                    return setTimeout(() => resolve(null), delay + settings.timeout);\n                });\n                return Promise.race([promise, timeoutPromise]);\n            };\n            const promise = delay === 0\n                ? fetch()\n                : new Promise((resolve, reject) => {\n                    return setTimeout(() => {\n                        if (current != this._inlineFetching) {\n                            // User pressed another key or explicitly requested completions since.\n                            return reject(null);\n                        }\n                        else {\n                            return resolve(fetch());\n                        }\n                    }, delay);\n                });\n            // Wrap promise and return error in case of failure.\n            promises.push(promise.catch(p => p));\n        }\n        return promises;\n    }\n    async _stream(item, provider) {\n        if (!item.isIncomplete || !provider.stream || !item.token) {\n            return;\n        }\n        const streamed = item.stream;\n        const token = item.token;\n        item.token = undefined;\n        // Notify that streaming started.\n        item.streaming = true;\n        streamed.emit(_handler__WEBPACK_IMPORTED_MODULE_2__.CompletionHandler.StraemEvent.opened);\n        for await (const reply of provider.stream(token)) {\n            const updated = reply.response;\n            const addition = updated.insertText.substring(item.insertText.length);\n            // Stream an update.\n            item.insertText = updated.insertText;\n            item.lastStreamed = addition;\n            item.error = reply.response.error;\n            streamed.emit(_handler__WEBPACK_IMPORTED_MODULE_2__.CompletionHandler.StraemEvent.update);\n        }\n        // Notify that streaming is no longer in progress.\n        item.isIncomplete = false;\n        item.lastStreamed = undefined;\n        item.streaming = false;\n        streamed.emit(_handler__WEBPACK_IMPORTED_MODULE_2__.CompletionHandler.StraemEvent.closed);\n    }\n    /**\n     * Fetch response from multiple providers, If a provider can not return\n     * the response for a completer request before timeout,\n     * the result of this provider will be ignored.\n     *\n     * @param {CompletionHandler.IRequest} request - The completion request.\n     */\n    async fetch(request, trigger) {\n        const current = ++this._fetching;\n        let promises = [];\n        const applicableProviders = await this.applicableProviders();\n        for (const provider of applicableProviders) {\n            let promise;\n            promise = provider.fetch(request, this._context, trigger).then(reply => {\n                if (current !== this._fetching) {\n                    return Promise.reject(void 0);\n                }\n                const items = reply.items.map(el => ({\n                    ...el,\n                    resolve: this._resolveFactory(provider, el)\n                }));\n                return { ...reply, items };\n            });\n            const timeoutPromise = new Promise(resolve => {\n                return setTimeout(() => resolve(null), this._timeout);\n            });\n            promise = Promise.race([promise, timeoutPromise]);\n            // Wrap promise and return error in case of failure.\n            promises.push(promise.catch(p => p));\n        }\n        // TODO: maybe use `Promise.allSettled` once library is at es2020 instead of adding a catch.\n        const combinedPromise = Promise.all(promises);\n        return this._mergeCompletions(combinedPromise);\n    }\n    /**\n     * Check if completer should make request to fetch completion responses\n     * on user typing. If the provider with highest rank does not have\n     * `shouldShowContinuousHint` method, a default one will be used.\n     *\n     * @param completerIsVisible - The visible status of completer widget.\n     * @param changed - CodeMirror changed argument.\n     */\n    async shouldShowContinuousHint(completerIsVisible, changed) {\n        const applicableProviders = await this.applicableProviders();\n        if (applicableProviders.length === 0) {\n            return false;\n        }\n        if (applicableProviders[0].shouldShowContinuousHint) {\n            return applicableProviders[0].shouldShowContinuousHint(completerIsVisible, changed, this._context);\n        }\n        return this._defaultShouldShowContinuousHint(completerIsVisible, changed);\n    }\n    _alignPrefixes(replies, minStart, maxStart) {\n        if (minStart != maxStart) {\n            const editor = this._context.editor;\n            if (!editor) {\n                return replies;\n            }\n            const cursor = editor.getCursorPosition();\n            const line = editor.getLine(cursor.line);\n            if (!line) {\n                return replies;\n            }\n            const lineOffset = editor.getOffsetAt({ line: cursor.line, column: 0 });\n            return replies.map(reply => {\n                const prefixStart = Math.max(reply.start - lineOffset, 0);\n                const prefixEnd = Math.max(maxStart - lineOffset, 0);\n                // No prefix to strip, return as-is.\n                if (prefixStart == prefixEnd) {\n                    return reply;\n                }\n                const prefix = line.substring(prefixStart, prefixEnd);\n                return {\n                    ...reply,\n                    items: reply.items.map(item => {\n                        let insertText = item.insertText || item.label;\n                        item.insertText = insertText.startsWith(prefix)\n                            ? insertText.slice(prefix.length)\n                            : insertText;\n                        return item;\n                    })\n                };\n            });\n        }\n        return replies;\n    }\n    async _mergeCompletions(promises) {\n        let replies = (await promises).filter(reply => {\n            // Ignore it errors out.\n            if (!reply || reply instanceof Error) {\n                return false;\n            }\n            // Ignore if no matches.\n            if (!reply.items.length) {\n                return false;\n            }\n            // Otherwise keep.\n            return true;\n        });\n        // Fast path for a single reply or no replies.\n        if (replies.length == 0) {\n            return null;\n        }\n        else if (replies.length == 1) {\n            return replies[0];\n        }\n        const minEnd = Math.min(...replies.map(reply => reply.end));\n        // If any of the replies uses a wider range, we need to align them\n        // so that all responses use the same range.\n        const starts = replies.map(reply => reply.start);\n        const minStart = Math.min(...starts);\n        const maxStart = Math.max(...starts);\n        replies = this._alignPrefixes(replies, minStart, maxStart);\n        const insertTextSet = new Set();\n        const mergedItems = new Array();\n        for (const reply of replies) {\n            reply.items.forEach(item => {\n                // IPython returns 'import' and 'import '; while the latter is more useful,\n                // user should not see two suggestions with identical labels and nearly-identical\n                // behaviour as they could not distinguish the two either way.\n                let text = (item.insertText || item.label).trim();\n                if (insertTextSet.has(text)) {\n                    return;\n                }\n                insertTextSet.add(text);\n                mergedItems.push(item);\n            });\n        }\n        return {\n            start: maxStart,\n            end: minEnd,\n            items: mergedItems\n        };\n    }\n    _defaultShouldShowContinuousHint(completerIsVisible, changed) {\n        var _a, _b, _c;\n        const mimeType = (_c = (_b = (_a = this._context) === null || _a === void 0 ? void 0 : _a.editor) === null || _b === void 0 ? void 0 : _b.model.mimeType) !== null && _c !== void 0 ? _c : '';\n        if (!(0,_utils__WEBPACK_IMPORTED_MODULE_3__.isHintableMimeType)(mimeType)) {\n            return false;\n        }\n        return (!completerIsVisible &&\n            (changed.sourceChange == null ||\n                changed.sourceChange.some(delta => delta.insert != null && delta.insert.length > 0)));\n    }\n}\n//# sourceMappingURL=reconciliator.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/reconciliator.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/tokens.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/tokens.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CompletionTriggerKind: () => (/* binding */ CompletionTriggerKind),\n/* harmony export */   ICompletionProviderManager: () => (/* binding */ ICompletionProviderManager),\n/* harmony export */   IInlineCompleterFactory: () => (/* binding */ IInlineCompleterFactory),\n/* harmony export */   InlineCompletionTriggerKind: () => (/* binding */ InlineCompletionTriggerKind)\n/* harmony export */ });\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * The type of completion request.\n */\nvar CompletionTriggerKind;\n(function (CompletionTriggerKind) {\n    CompletionTriggerKind[CompletionTriggerKind[\"Invoked\"] = 1] = \"Invoked\";\n    CompletionTriggerKind[CompletionTriggerKind[\"TriggerCharacter\"] = 2] = \"TriggerCharacter\";\n    CompletionTriggerKind[CompletionTriggerKind[\"TriggerForIncompleteCompletions\"] = 3] = \"TriggerForIncompleteCompletions\";\n})(CompletionTriggerKind || (CompletionTriggerKind = {}));\n/**\n * Describes how an inline completion provider was triggered.\n * @alpha\n */\nvar InlineCompletionTriggerKind;\n(function (InlineCompletionTriggerKind) {\n    /**\n     * Completion was triggered explicitly by a user gesture.\n     * Return multiple completion items to enable cycling through them.\n     */\n    InlineCompletionTriggerKind[InlineCompletionTriggerKind[\"Invoke\"] = 0] = \"Invoke\";\n    /**\n     * Completion was triggered automatically while editing.\n     * It is sufficient to return a single completion item in this case.\n     */\n    InlineCompletionTriggerKind[InlineCompletionTriggerKind[\"Automatic\"] = 1] = \"Automatic\";\n})(InlineCompletionTriggerKind || (InlineCompletionTriggerKind = {}));\n/**\n * Token allowing to override (or disable) inline completer widget factory.\n */\nconst IInlineCompleterFactory = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/completer:IInlineCompleterFactory', 'A factory of inline completer widgets.');\n/**\n * The exported token used to register new provider.\n */\nconst ICompletionProviderManager = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/completer:ICompletionProviderManager', 'A service for the completion providers management.');\n//# sourceMappingURL=tokens.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/tokens.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/utils.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/utils.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   isHintableMimeType: () => (/* binding */ isHintableMimeType)\n/* harmony export */ });\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/**\n * Determines whether the given MIME type is suitable for code completion.\n *\n * @param mimeType - The MIME type of the current editor context.\n * @returns `true` if the MIME type supports code completion; otherwise, `false`.\n */\nfunction isHintableMimeType(mimeType) {\n    const excludedMimeTypes = new Set([\n        'text/plain',\n        'text/markdown',\n        'text/x-ipythongfm',\n        'text/x-rst',\n        'text/latex',\n        'application/json',\n        'text/html',\n        'text/css'\n    ]);\n    return !excludedMimeTypes.has(mimeType);\n}\n//# sourceMappingURL=utils.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/utils.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/lib/widget.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/lib/widget.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Completer: () => (/* binding */ Completer)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/rendermime */ \"webpack/sharing/consume/default/@jupyterlab/rendermime/@jupyterlab/rendermime\");\n/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/domutils */ \"webpack/sharing/consume/default/@lumino/domutils/@lumino/domutils\");\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_domutils__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_5__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n/**\n * The class name added to completer menu items.\n */\nconst ITEM_CLASS = 'jp-Completer-item';\n/**\n * The class name added to an active completer menu item.\n */\nconst ACTIVE_CLASS = 'jp-mod-active';\n/**\n * The class used by item listing which determines the height of the completer.\n */\nconst LIST_CLASS = 'jp-Completer-list';\n/**\n * Class of the documentation panel.\n */\nconst DOC_PANEL_CLASS = 'jp-Completer-docpanel';\n/**\n * A flag to indicate that event handlers are caught in the capture phase.\n */\nconst USE_CAPTURE = true;\n/**\n * The number of colors defined for the completer type annotations.\n * These are listed in completer/style/index.css#102-152.\n */\nconst N_COLORS = 10;\n/**\n * A widget that enables text completion.\n *\n * #### Notes\n * The completer is intended to be absolutely positioned on the\n * page and hover over any other content, so it should be attached directly\n * to `document.body`, or a node that is the full size of `document.body`.\n * Attaching it to other nodes may incorrectly locate the completer.\n */\nclass Completer extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget {\n    /**\n     * Construct a text completer menu widget.\n     */\n    constructor(options) {\n        var _a, _b, _c, _d;\n        super({ node: document.createElement('div') });\n        this._activeIndex = 0;\n        this._editor = null;\n        this._model = null;\n        this._selected = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);\n        this._visibilityChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);\n        this._indexChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);\n        this._lastSubsetMatch = '';\n        this._geometryLock = false;\n        /**\n         * Increasing this counter invalidates previous request to save geometry cache in animation callback.\n         */\n        this._geometryCounter = 0;\n        this._docPanelExpanded = false;\n        this._renderCounter = 0;\n        this.sanitizer = (_a = options.sanitizer) !== null && _a !== void 0 ? _a : new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Sanitizer();\n        this._defaultRenderer = Completer.getDefaultRenderer(this.sanitizer);\n        this._renderer = (_b = options.renderer) !== null && _b !== void 0 ? _b : this._defaultRenderer;\n        this._docPanel = this._createDocPanelNode();\n        this.model = (_c = options.model) !== null && _c !== void 0 ? _c : null;\n        this.editor = (_d = options.editor) !== null && _d !== void 0 ? _d : null;\n        this.addClass('jp-Completer');\n        this.addClass('jp-ThemedContainer');\n        this._updateConstraints();\n    }\n    /**\n     * Cache style constraints from CSS.\n     */\n    _updateConstraints() {\n        const tempNode = document.createElement('div');\n        tempNode.classList.add(LIST_CLASS);\n        tempNode.style.visibility = 'hidden';\n        tempNode.style.overflowY = 'scroll';\n        document.body.appendChild(tempNode);\n        const computedStyle = window.getComputedStyle(tempNode);\n        this._maxHeight = parseInt(computedStyle.maxHeight, 10);\n        this._minHeight = parseInt(computedStyle.minHeight, 10);\n        this._scrollbarWidth = tempNode.offsetWidth - tempNode.clientWidth;\n        document.body.removeChild(tempNode);\n        const tempDocPanel = this._createDocPanelNode();\n        this._docPanelWidth = Private.measureSize(tempDocPanel, 'inline-block').width;\n    }\n    /**\n     * The active index.\n     */\n    get activeIndex() {\n        return this._activeIndex;\n    }\n    /**\n     * The editor used by the completion widget.\n     */\n    get editor() {\n        return this._editor;\n    }\n    set editor(newValue) {\n        this._editor = newValue;\n    }\n    /**\n     * A signal emitted when a selection is made from the completer menu.\n     */\n    get selected() {\n        return this._selected;\n    }\n    /**\n     * A signal emitted when the completer widget's visibility changes.\n     *\n     * #### Notes\n     * This signal is useful when there are multiple floating widgets that may\n     * contend with the same space and ought to be mutually exclusive.\n     */\n    get visibilityChanged() {\n        return this._visibilityChanged;\n    }\n    /**\n     * A signal emitted when the active index changes.\n     */\n    get indexChanged() {\n        return this._indexChanged;\n    }\n    /**\n     * The model used by the completer widget.\n     */\n    get model() {\n        return this._model;\n    }\n    set model(model) {\n        if ((!model && !this._model) || model === this._model) {\n            return;\n        }\n        if (this._model) {\n            this._model.stateChanged.disconnect(this.onModelStateChanged, this);\n            this._model.queryChanged.disconnect(this.onModelQueryChanged, this);\n        }\n        this._model = model;\n        if (this._model) {\n            this._model.stateChanged.connect(this.onModelStateChanged, this);\n            this._model.queryChanged.connect(this.onModelQueryChanged, this);\n        }\n    }\n    /**\n     * The completer used by the completer widget.\n     */\n    get renderer() {\n        return this._renderer;\n    }\n    set renderer(renderer) {\n        this._renderer = renderer;\n    }\n    /**\n     * Enable/disable the document panel.\n     */\n    set showDocsPanel(showDoc) {\n        this._showDoc = showDoc;\n    }\n    get showDocsPanel() {\n        return this._showDoc;\n    }\n    /**\n     * Dispose of the resources held by the completer widget.\n     */\n    dispose() {\n        this._sizeCache = undefined;\n        this._model = null;\n        super.dispose();\n    }\n    /**\n     * Handle the DOM events for the widget.\n     *\n     * @param event - The DOM event sent to the widget.\n     *\n     * #### Notes\n     * This method implements the DOM `EventListener` interface and is\n     * called in response to events on the dock panel's node. It should\n     * not be called directly by user code.\n     */\n    handleEvent(event) {\n        if (this.isHidden || !this._editor) {\n            return;\n        }\n        switch (event.type) {\n            case 'keydown':\n                this._evtKeydown(event);\n                break;\n            case 'pointerdown':\n                this._evtPointerdown(event);\n                break;\n            case 'scroll':\n                this._evtScroll(event);\n                break;\n            default:\n                break;\n        }\n    }\n    /**\n     * Reset the widget.\n     */\n    reset() {\n        this._activeIndex = 0;\n        this._lastSubsetMatch = '';\n        if (this._model) {\n            this._model.reset(true);\n        }\n        this._docPanel.style.display = 'none';\n        // Clear size cache.\n        this._sizeCache = undefined;\n        this.node.scrollTop = 0;\n    }\n    /**\n     * Emit the selected signal for the current active item and reset.\n     */\n    selectActive() {\n        const active = this.node.querySelector(`.${ACTIVE_CLASS}`);\n        if (!active) {\n            this.reset();\n            return;\n        }\n        this._selected.emit(active.getAttribute('data-value'));\n        this.reset();\n    }\n    /**\n     * Handle `after-attach` messages for the widget.\n     */\n    onAfterAttach(msg) {\n        document.addEventListener('keydown', this, USE_CAPTURE);\n        document.addEventListener('pointerdown', this, USE_CAPTURE);\n        document.addEventListener('scroll', this, USE_CAPTURE);\n    }\n    /**\n     * Handle `before-detach` messages for the widget.\n     */\n    onBeforeDetach(msg) {\n        document.removeEventListener('keydown', this, USE_CAPTURE);\n        document.removeEventListener('pointerdown', this, USE_CAPTURE);\n        document.removeEventListener('scroll', this, USE_CAPTURE);\n    }\n    /**\n     * Handle model state changes.\n     */\n    onModelStateChanged() {\n        if (this.isAttached) {\n            this._activeIndex = 0;\n            this._indexChanged.emit(this._activeIndex);\n            this.update();\n        }\n    }\n    /**\n     * Handle model query changes.\n     */\n    onModelQueryChanged(model, queryChange) {\n        // If query was changed by the user typing, the filtered down items\n        // may no longer reach/exceed the maxHeight of the completer widget,\n        // hence size needs to be recalculated.\n        if (this._sizeCache && queryChange.origin === 'editorUpdate') {\n            const newItems = model.completionItems();\n            const oldItems = this._sizeCache.items;\n            // Only reset size if the number of items changed, or the longest item changed.\n            const oldWidest = oldItems[this._findWidestItemIndex(oldItems)];\n            const newWidest = newItems[this._findWidestItemIndex(newItems)];\n            const heuristic = this._getPreferredItemWidthHeuristic();\n            if (newItems.length !== this._sizeCache.items.length ||\n                heuristic(oldWidest) !== heuristic(newWidest)) {\n                this._sizeCache = undefined;\n            }\n        }\n    }\n    /**\n     * Handle `update-request` messages.\n     */\n    onUpdateRequest(msg) {\n        var _a;\n        const model = this._model;\n        if (!model) {\n            return;\n        }\n        // If this is the first time the current completer session has loaded,\n        // populate any initial subset match. This is being done before node\n        // gets rendered to avoid rendering it twice.\n        if (!model.query) {\n            this._populateSubset();\n        }\n        let items = model.completionItems();\n        // If there are no items, reset and bail.\n        if (!items.length) {\n            if (!this.isHidden) {\n                this.reset();\n                this.hide();\n                this._visibilityChanged.emit(undefined);\n            }\n            return;\n        }\n        // Update constraints before any DOM modifications\n        this._updateConstraints();\n        // Do not trigger any geometry updates from async code when in lock.\n        this._geometryLock = true;\n        const node = this._createCompleterNode(model, items);\n        let active = node.querySelectorAll(`.${ITEM_CLASS}`)[this._activeIndex];\n        active.classList.add(ACTIVE_CLASS);\n        const resolvedItem = (_a = this.model) === null || _a === void 0 ? void 0 : _a.resolveItem(items[this._activeIndex]);\n        // Add the documentation panel\n        if (this._showDoc) {\n            this._docPanel.innerText = '';\n            node.appendChild(this._docPanel);\n            this._docPanelExpanded = false;\n            this._docPanel.style.display = 'none';\n            this._updateDocPanel(resolvedItem, active);\n        }\n        if (this.isHidden) {\n            this.show();\n            this._setGeometry();\n            this._visibilityChanged.emit(undefined);\n        }\n        else {\n            this._setGeometry();\n        }\n        this._geometryLock = false;\n    }\n    /**\n     * Get cached dimensions of the completer box.\n     */\n    get sizeCache() {\n        if (!this._sizeCache) {\n            return;\n        }\n        return {\n            width: this._sizeCache.width + this._sizeCache.docPanelWidth,\n            height: Math.max(this._sizeCache.height, this._sizeCache.docPanelHeight)\n        };\n    }\n    _createDocPanelNode() {\n        const docPanel = document.createElement('div');\n        docPanel.className = DOC_PANEL_CLASS;\n        return docPanel;\n    }\n    _createCompleterNode(model, items) {\n        const current = ++this._renderCounter;\n        // Clear the node.\n        let node = this.node;\n        node.textContent = '';\n        // Compute an ordered list of all the types in the typeMap, this is computed\n        // once by the model each time new data arrives for efficiency.\n        let orderedTypes = model.orderedTypes();\n        // Populate the completer items.\n        let ul = document.createElement('ul');\n        ul.className = LIST_CLASS;\n        // Add first N items to fill the first \"page\" assuming that the completer\n        // would reach its maximum allowed height.\n        const first = this._renderer.createCompletionItemNode(items[0], orderedTypes);\n        const renderedItems = [first];\n        const firstItemSize = Private.measureSize(first, 'inline-grid');\n        const pageSize = Math.max(Math.ceil(this._maxHeight / firstItemSize.height), 5);\n        // We add one item in case if height heuristic is inaccurate.\n        const toRenderImmediately = Math.min(pageSize + 1, items.length);\n        const start = performance.now();\n        for (let i = 1; i < toRenderImmediately; i++) {\n            const li = this._renderer.createCompletionItemNode(items[i], orderedTypes);\n            renderedItems.push(li);\n        }\n        for (const li of renderedItems) {\n            ul.appendChild(li);\n        }\n        // Pre-calculate size:\n        //  - height will equal first element height times number of items,\n        //    or maximum allowed height if there are more items than fit on a page,\n        //  - width will be estimated from the widest item.\n        const widestItemIndex = this._findWidestItemIndex(items);\n        const widestItem = widestItemIndex < renderedItems.length\n            ? renderedItems[widestItemIndex]\n            : this._renderer.createCompletionItemNode(items[widestItemIndex], orderedTypes);\n        // The node needs to be cloned to avoid side-effect of detaching it.\n        const widestItemSize = Private.measureSize(widestItem.cloneNode(true), 'inline-grid');\n        this._sizeCache = {\n            height: Math.min(this._maxHeight, firstItemSize.height * items.length),\n            width: widestItemSize.width + this._scrollbarWidth,\n            items: items,\n            docPanelWidth: 0,\n            docPanelHeight: 0\n        };\n        if (toRenderImmediately < items.length) {\n            // Render remaining items on idle in subsequent animation frames,\n            // in chunks of size such that each frame would take about 16ms\n            // allowing for 4ms of overhead, but keep the chunks no smaller\n            // than 5 items at a time.\n            const timePerItem = (performance.now() - start) / toRenderImmediately;\n            const chunkSize = Math.max(5, Math.floor(12 / timePerItem));\n            let alreadyRendered = toRenderImmediately;\n            let previousChunkFinal = renderedItems[renderedItems.length - 1];\n            const renderChunk = () => {\n                if (alreadyRendered >= items.length) {\n                    return;\n                }\n                // Add a filler so that the list with partially rendered items has the total\n                // height equal to the (predicted) final height to avoid scrollbar jitter.\n                const predictedMissingHeight = firstItemSize.height * (items.length - alreadyRendered);\n                previousChunkFinal.style.marginBottom = `${predictedMissingHeight}px`;\n                requestAnimationFrame(() => {\n                    if (current != this._renderCounter) {\n                        // Bail if rendering afresh was requested in the meantime.\n                        return;\n                    }\n                    previousChunkFinal.style.marginBottom = '';\n                    const limit = Math.min(items.length, alreadyRendered + chunkSize);\n                    for (let i = alreadyRendered; i < limit; i++) {\n                        const li = this._renderer.createCompletionItemNode(items[i], orderedTypes);\n                        ul.appendChild(li);\n                        previousChunkFinal = li;\n                    }\n                    alreadyRendered = limit;\n                    renderChunk();\n                });\n            };\n            renderChunk();\n        }\n        node.appendChild(ul);\n        return node;\n    }\n    /**\n     * Use preferred heuristic to find the index of the widest item.\n     */\n    _findWidestItemIndex(items) {\n        const widthHeuristic = this._getPreferredItemWidthHeuristic();\n        const widthHeuristics = items.map(widthHeuristic);\n        return widthHeuristics.indexOf(Math.max(...widthHeuristics));\n    }\n    /**\n     * Get item width heuristic function from renderer if available,\n     * or the default one otherwise.\n     */\n    _getPreferredItemWidthHeuristic() {\n        return this._renderer.itemWidthHeuristic\n            ? this._renderer.itemWidthHeuristic.bind(this._renderer)\n            : this._defaultRenderer.itemWidthHeuristic.bind(this._defaultRenderer);\n    }\n    /**\n     * Cycle through the available completer items.\n     *\n     * #### Notes\n     * When the user cycles all the way `down` to the last index, subsequent\n     * `down` cycles will cycle to the first index. When the user cycles `up` to\n     * the first item, subsequent `up` cycles will cycle to the last index.\n     */\n    _cycle(direction) {\n        var _a, _b;\n        const items = this.node.querySelectorAll(`.${ITEM_CLASS}`);\n        const index = this._activeIndex;\n        const last = items.length - 1;\n        let active = this.node.querySelector(`.${ACTIVE_CLASS}`);\n        active.classList.remove(ACTIVE_CLASS);\n        switch (direction) {\n            case 'up':\n                this._activeIndex = index === 0 ? last : index - 1;\n                break;\n            case 'down':\n                this._activeIndex = index < last ? index + 1 : 0;\n                break;\n            case 'pageUp':\n            case 'pageDown': {\n                // Measure the number of items on a page and clamp to the list length.\n                const container = this.node.getBoundingClientRect();\n                const current = active.getBoundingClientRect();\n                const page = Math.floor(container.height / current.height);\n                const sign = direction === 'pageUp' ? -1 : 1;\n                this._activeIndex = Math.min(Math.max(0, index + sign * page), last);\n                break;\n            }\n        }\n        active = items[this._activeIndex];\n        active.classList.add(ACTIVE_CLASS);\n        let completionList = this.node.querySelector(`.${LIST_CLASS}`);\n        _lumino_domutils__WEBPACK_IMPORTED_MODULE_3__.ElementExt.scrollIntoViewIfNeeded(completionList, active);\n        this._indexChanged.emit(this._activeIndex);\n        const visibleCompletionItems = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completionItems();\n        const activeCompletionItem = visibleCompletionItems === null || visibleCompletionItems === void 0 ? void 0 : visibleCompletionItems[this._activeIndex];\n        if (activeCompletionItem) {\n            const resolvedItem = (_b = this.model) === null || _b === void 0 ? void 0 : _b.resolveItem(activeCompletionItem);\n            if (this._showDoc) {\n                this._updateDocPanel(resolvedItem, active);\n            }\n        }\n    }\n    /**\n     * Handle keydown events for the widget.\n     */\n    _evtKeydown(event) {\n        if (this.isHidden || !this._editor) {\n            return;\n        }\n        if (!this._editor.host.contains(event.target)) {\n            this.reset();\n            return;\n        }\n        switch (event.keyCode) {\n            case 9: {\n                // Tab key\n                event.preventDefault();\n                event.stopPropagation();\n                event.stopImmediatePropagation();\n                const model = this._model;\n                if (!model) {\n                    return;\n                }\n                // Autoinsert single completions on manual request (tab)\n                const items = model.completionItems();\n                if (items && items.length === 1) {\n                    this._selected.emit(items[0].insertText || items[0].label);\n                    this.reset();\n                    return;\n                }\n                const populated = this._populateSubset();\n                // If the common subset was found and set on `query`,\n                // or if there is a `query` in the initialization options,\n                // then emit a completion signal with that `query` (=subset match),\n                // but only if the query has actually changed.\n                // See: https://github.com/jupyterlab/jupyterlab/issues/10439#issuecomment-875189540\n                if (model.query && model.query !== this._lastSubsetMatch) {\n                    model.subsetMatch = true;\n                    this._selected.emit(model.query);\n                    model.subsetMatch = false;\n                    this._lastSubsetMatch = model.query;\n                }\n                // If the query changed, update rendering of the options.\n                if (populated) {\n                    this.update();\n                }\n                this._cycle(event.shiftKey ? 'up' : 'down');\n                return;\n            }\n            case 27: // Esc key\n                event.preventDefault();\n                event.stopPropagation();\n                event.stopImmediatePropagation();\n                this.reset();\n                return;\n            case 33: // PageUp\n            case 34: // PageDown\n            case 38: // Up arrow key\n            case 40: {\n                // Down arrow key\n                event.preventDefault();\n                event.stopPropagation();\n                event.stopImmediatePropagation();\n                const cycle = Private.keyCodeMap[event.keyCode];\n                this._cycle(cycle);\n                return;\n            }\n            default:\n                return;\n        }\n    }\n    /**\n     * Handle mousedown events for the widget.\n     */\n    _evtPointerdown(event) {\n        if (this.isHidden || !this._editor) {\n            return;\n        }\n        if (Private.nonstandardClick(event)) {\n            this.reset();\n            return;\n        }\n        let target = event.target;\n        while (target !== document.documentElement) {\n            // If the user has made a selection, emit its value and reset the widget.\n            if (target.classList.contains(ITEM_CLASS)) {\n                event.preventDefault();\n                event.stopPropagation();\n                event.stopImmediatePropagation();\n                this._selected.emit(target.getAttribute('data-value'));\n                this.reset();\n                return;\n            }\n            // If the mouse event happened anywhere else in the widget, bail.\n            if (target === this.node) {\n                event.preventDefault();\n                event.stopPropagation();\n                event.stopImmediatePropagation();\n                return;\n            }\n            target = target.parentElement;\n        }\n        this.reset();\n    }\n    /**\n     * Handle scroll events for the widget\n     */\n    _evtScroll(event) {\n        if (this.isHidden || !this._editor) {\n            return;\n        }\n        const { node } = this;\n        // All scrolls except scrolls in the actual hover box node may cause the\n        // referent editor that anchors the node to move, so the only scroll events\n        // that can safely be ignored are ones that happen inside the hovering node.\n        if (node.contains(event.target)) {\n            return;\n        }\n        // Set the geometry of the node asynchronously.\n        requestAnimationFrame(() => {\n            this._setGeometry();\n        });\n    }\n    /**\n     * Populate the completer up to the longest initial subset of items.\n     *\n     * @returns `true` if a subset match was found and populated.\n     */\n    _populateSubset() {\n        const { model } = this;\n        if (!model) {\n            return false;\n        }\n        const items = model.completionItems();\n        const subset = Private.commonSubset(items.map(item => item.insertText || item.label));\n        const { query } = model;\n        // If a common subset exists and it is not the current query, highlight it.\n        if (subset && subset !== query && subset.indexOf(query) === 0) {\n            model.query = subset;\n            return true;\n        }\n        return false;\n    }\n    /**\n     * Set the visible dimensions of the widget.\n     */\n    _setGeometry() {\n        const { node } = this;\n        const model = this._model;\n        const editor = this._editor;\n        // This is an overly defensive test: `cursor` will always exist if\n        // `original` exists, except in contrived tests. But since it is possible\n        // to generate a runtime error, the check occurs here.\n        if (!editor || !model || !model.original || !model.cursor) {\n            return;\n        }\n        const start = model.cursor.start;\n        const position = editor.getPositionAt(start);\n        const anchor = editor.getCoordinateForPosition(position);\n        if (!anchor) {\n            return;\n        }\n        const style = window.getComputedStyle(node);\n        const borderLeft = parseInt(style.borderLeftWidth, 10) || 0;\n        const paddingLeft = parseInt(style.paddingLeft, 10) || 0;\n        // When the editor is attached to the main area, contain the completer hover box\n        // to the full area available (rather than to the editor itself); the available\n        // area excludes the toolbar, hence the first Widget child between MainAreaWidget\n        // and editor is preferred. The difference is negligible in File Editor, but\n        // substantial for Notebooks.\n        const host = editor.host.closest('.jp-MainAreaWidget > .lm-Widget') ||\n            editor.host;\n        const items = model.completionItems();\n        // Fast cache invalidation (only checks for length rather than length + width)\n        if (this._sizeCache && this._sizeCache.items.length !== items.length) {\n            this._sizeCache = undefined;\n        }\n        // Calculate the geometry of the completer.\n        _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.HoverBox.setGeometry({\n            anchor,\n            host: host,\n            maxHeight: this._maxHeight,\n            minHeight: this._minHeight,\n            node: node,\n            size: this.sizeCache,\n            offset: { horizontal: borderLeft + paddingLeft },\n            privilege: 'below',\n            style: style,\n            outOfViewDisplay: {\n                top: 'stick-inside',\n                bottom: 'stick-inside',\n                left: 'stick-inside',\n                right: 'stick-outside'\n            }\n        });\n        const current = ++this._geometryCounter;\n        if (!this._sizeCache) {\n            // If size was not pre-calculated using heuristics, save the actual\n            // size into cache once rendered.\n            requestAnimationFrame(() => {\n                if (current != this._geometryCounter) {\n                    // Do not set size to cache if it may already be outdated.\n                    return;\n                }\n                let rect = node.getBoundingClientRect();\n                let panel = this._docPanel.getBoundingClientRect();\n                this._sizeCache = {\n                    width: rect.width - panel.width,\n                    height: rect.height,\n                    items: items,\n                    docPanelWidth: panel.width,\n                    docPanelHeight: panel.height\n                };\n            });\n        }\n    }\n    /**\n     * Update the display-state and contents of the documentation panel\n     */\n    _updateDocPanel(resolvedItem, activeNode) {\n        var _a, _b, _c;\n        let docPanel = this._docPanel;\n        if (!resolvedItem) {\n            this._toggleDocPanel(false);\n            return;\n        }\n        const loadingIndicator = (_c = (_b = (_a = this._renderer).createLoadingDocsIndicator) === null || _b === void 0 ? void 0 : _b.call(_a)) !== null && _c !== void 0 ? _c : this._defaultRenderer.createLoadingDocsIndicator();\n        activeNode.appendChild(loadingIndicator);\n        resolvedItem\n            .then(activeItem => {\n            var _a, _b, _c;\n            if (!activeItem) {\n                return;\n            }\n            if (!docPanel) {\n                return;\n            }\n            if (activeItem.documentation) {\n                const node = (_c = (_b = (_a = this._renderer).createDocumentationNode) === null || _b === void 0 ? void 0 : _b.call(_a, activeItem)) !== null && _c !== void 0 ? _c : this._defaultRenderer.createDocumentationNode(activeItem);\n                docPanel.textContent = '';\n                docPanel.appendChild(node);\n                this._toggleDocPanel(true);\n            }\n            else {\n                this._toggleDocPanel(false);\n            }\n        })\n            .catch(e => console.error(e))\n            .finally(() => {\n            activeNode.removeChild(loadingIndicator);\n        });\n    }\n    _toggleDocPanel(show) {\n        let docPanel = this._docPanel;\n        if (show) {\n            if (this._docPanelExpanded) {\n                return;\n            }\n            docPanel.style.display = '';\n            this._docPanelExpanded = true;\n        }\n        else {\n            if (!this._docPanelExpanded) {\n                return;\n            }\n            docPanel.style.display = 'none';\n            this._docPanelExpanded = false;\n        }\n        const sizeCache = this._sizeCache;\n        if (sizeCache) {\n            sizeCache.docPanelHeight = show ? this._maxHeight : 0;\n            sizeCache.docPanelWidth = show ? this._docPanelWidth : 0;\n            if (!this._geometryLock) {\n                this._setGeometry();\n            }\n        }\n    }\n}\n(function (Completer) {\n    /**\n     * The default implementation of an `IRenderer`.\n     */\n    class Renderer {\n        constructor(options) {\n            this.sanitizer = (options === null || options === void 0 ? void 0 : options.sanitizer) || new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Sanitizer();\n        }\n        /**\n         * Create an item node from an ICompletionItem for a text completer menu.\n         */\n        createCompletionItemNode(item, orderedTypes) {\n            let wrapperNode = this._createWrapperNode(item.insertText || item.label);\n            if (item.deprecated) {\n                wrapperNode.classList.add('jp-Completer-deprecated');\n            }\n            return this._constructNode(wrapperNode, this._createLabelNode(item.label), !!item.type, item.type, orderedTypes, item.icon);\n        }\n        /**\n         * Create a documentation node for documentation panel.\n         */\n        createDocumentationNode(activeItem) {\n            const host = document.createElement('div');\n            host.classList.add('jp-RenderedText');\n            const sanitizer = this.sanitizer;\n            const source = activeItem.documentation || '';\n            (0,_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__.renderText)({ host, sanitizer, source }).catch(console.error);\n            return host;\n        }\n        /**\n         * Get a heuristic for the width of an item.\n         */\n        itemWidthHeuristic(item) {\n            var _a;\n            // Get the label text without HTML markup (`<mark>` is the only markup\n            // that is allowed in processed items, everything else gets escaped).\n            const labelText = item.label.replace(/<(\\/)?mark>/g, '');\n            return labelText.length + (((_a = item.type) === null || _a === void 0 ? void 0 : _a.length) || 0);\n        }\n        /**\n         * Create a loading bar for the documentation panel.\n         */\n        createLoadingDocsIndicator() {\n            const loadingContainer = document.createElement('div');\n            loadingContainer.classList.add('jp-Completer-loading-bar-container');\n            const loadingBar = document.createElement('div');\n            loadingBar.classList.add('jp-Completer-loading-bar');\n            loadingContainer.append(loadingBar);\n            return loadingContainer;\n        }\n        /**\n         * Create base node with the value to be inserted.\n         */\n        _createWrapperNode(value) {\n            const li = document.createElement('li');\n            li.className = ITEM_CLASS;\n            // Set the raw, un-marked up value as a data attribute.\n            li.setAttribute('data-value', value);\n            return li;\n        }\n        /**\n         * Create match node to highlight potential prefix match within result.\n         */\n        _createLabelNode(result) {\n            const matchNode = document.createElement('code');\n            matchNode.className = 'jp-Completer-match';\n            // Use innerHTML because search results include <mark> tags.\n            matchNode.innerHTML = result;\n            return matchNode;\n        }\n        /**\n         * Attaches type and match nodes to base node.\n         */\n        _constructNode(li, matchNode, typesExist, type, orderedTypes, icon) {\n            // Add the icon or type monogram\n            if (icon) {\n                const iconNode = icon.element({\n                    className: 'jp-Completer-type jp-Completer-icon'\n                });\n                li.appendChild(iconNode);\n            }\n            else if (typesExist) {\n                const typeNode = document.createElement('span');\n                typeNode.textContent = (type[0] || '').toLowerCase();\n                const colorIndex = (orderedTypes.indexOf(type) % N_COLORS) + 1;\n                typeNode.className = 'jp-Completer-type jp-Completer-monogram';\n                typeNode.setAttribute(`data-color-index`, colorIndex.toString());\n                li.appendChild(typeNode);\n            }\n            else {\n                // Create empty span to ensure consistent list styling.\n                // Otherwise, in a list of two items,\n                // if one item has an icon, but the other has type,\n                // the icon grows out of its bounds.\n                const dummyNode = document.createElement('span');\n                dummyNode.className = 'jp-Completer-monogram';\n                li.appendChild(dummyNode);\n            }\n            li.appendChild(matchNode);\n            // If there is a type, add the type extension and title\n            if (typesExist) {\n                li.title = type;\n                const typeExtendedNode = document.createElement('code');\n                typeExtendedNode.className = 'jp-Completer-typeExtended';\n                typeExtendedNode.textContent = type.toLocaleLowerCase();\n                li.appendChild(typeExtendedNode);\n            }\n            else {\n                // If no type is present on the right,\n                // the highlighting of the completion item\n                // doesn't cover the entire row.\n                const dummyTypeExtendedNode = document.createElement('span');\n                dummyTypeExtendedNode.className = 'jp-Completer-typeExtended';\n                li.appendChild(dummyTypeExtendedNode);\n            }\n            return li;\n        }\n    }\n    Completer.Renderer = Renderer;\n    /**\n     * Default renderer\n     */\n    let _defaultRenderer;\n    /**\n     * The default `IRenderer` instance.\n     */\n    function getDefaultRenderer(sanitizer) {\n        if (!_defaultRenderer ||\n            (sanitizer && _defaultRenderer.sanitizer !== sanitizer)) {\n            _defaultRenderer = new Renderer({ sanitizer: sanitizer });\n        }\n        return _defaultRenderer;\n    }\n    Completer.getDefaultRenderer = getDefaultRenderer;\n})(Completer || (Completer = {}));\n/**\n * A namespace for completer widget private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Mapping from keyCodes to scrollTypes.\n     */\n    Private.keyCodeMap = {\n        38: 'up',\n        40: 'down',\n        33: 'pageUp',\n        34: 'pageDown'\n    };\n    /**\n     * Returns the common subset string that a list of strings shares.\n     */\n    function commonSubset(values) {\n        const len = values.length;\n        let subset = '';\n        if (len < 2) {\n            return subset;\n        }\n        const strlen = values[0].length;\n        for (let i = 0; i < strlen; i++) {\n            const ch = values[0][i];\n            for (let j = 1; j < len; j++) {\n                if (values[j][i] !== ch) {\n                    return subset;\n                }\n            }\n            subset += ch;\n        }\n        return subset;\n    }\n    Private.commonSubset = commonSubset;\n    /**\n     * Returns true for any modified click event (i.e., not a left-click).\n     */\n    function nonstandardClick(event) {\n        return (event.button !== 0 ||\n            event.altKey ||\n            event.ctrlKey ||\n            event.shiftKey ||\n            event.metaKey);\n    }\n    Private.nonstandardClick = nonstandardClick;\n    /**\n     * Measure size of provided HTML element without painting it.\n     *\n     * #### Notes\n     * The provided element has to be detached (not connected to DOM),\n     * or a side-effect of detaching it will occur.\n     */\n    function measureSize(element, display) {\n        if (element.isConnected) {\n            console.warn('Measuring connected elements with `measureSize` has side-effects');\n        }\n        element.style.visibility = 'hidden';\n        element.style.display = display;\n        document.body.appendChild(element);\n        const size = element.getBoundingClientRect();\n        document.body.removeChild(element);\n        element.removeAttribute('style');\n        return size;\n    }\n    Private.measureSize = measureSize;\n})(Private || (Private = {}));\n//# sourceMappingURL=widget.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/lib/widget.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/style/icons/inline.svg":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/style/icons/inline.svg ***!
  \********************************************************************/
/***/ ((module) => {

eval("module.exports = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" width=\\\"16\\\" viewBox=\\\"0 0 24 24\\\">\\n  <path class=\\\"jp-icon4\\\" fill=\\\"#bbbbbb\\\" d=\\\"M17 15H3v2h14v-2Zm0-8h-6v2h6V7ZM3 13h18v-2H3v2Zm0 8h18v-2H3v2Z\\\"/>\\n  <path class=\\\"jp-icon1\\\" fill=\\\"#616161\\\" d=\\\"M3 3v2h18V3H3ZM3 7v2h8V7H3Z\\\"/>\\n</svg>\\n\";\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/style/icons/inline.svg?");

/***/ }),

/***/ "../node_modules/@jupyterlab/completer/style/icons/widget.svg":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/completer/style/icons/widget.svg ***!
  \********************************************************************/
/***/ ((module) => {

eval("module.exports = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" width=\\\"16\\\" viewBox=\\\"0 0 24 24\\\">\\n<g fill=\\\"#616161\\\" class=\\\"jp-icon2 jp-icon-selectable\\\">\\n  <path d=\\\"M6 8h16v14.3H6z\\\" style=\\\"fill:#eee;stroke:#444;stroke-linejoin:round\\\"/>\\n  <path d=\\\"M3 3v2h10V3H3Z\\\" transform=\\\"matrix(.8 0 0 1 .5 0)\\\"/>\\n</g>\\n<g class=\\\"jp-icon3 jp-icon-selectable\\\">\\n  <path fill=\\\"#616161\\\" d=\\\"M18 14.1H8v2h11v-2ZM8 12.1H20V10.1H8v2Zm0 8H20v-2H8v3Z\\\"/>\\n</g>\\n</svg>\\n\";\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/completer/style/icons/widget.svg?");

/***/ })

}]);