/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.DefaultSWTFontRegistry;
import org.eclipse.swt.internal.SWTFontRegistry;
import org.eclipse.swt.internal.ScalingSWTFontRegistry;
import org.eclipse.swt.widgets.Display;

public class SWTFontProvider {
    private static final Map<Device, SWTFontRegistry> fontRegistries = new ConcurrentHashMap<Device, SWTFontRegistry>();

    private static SWTFontRegistry getFontRegistry(Device device) {
        return fontRegistries.computeIfAbsent(device, SWTFontProvider::newFontRegistry);
    }

    public static Font getSystemFont(Device device, int zoom) {
        return SWTFontProvider.getFontRegistry(device).getSystemFont(zoom);
    }

    public static Font getFont(Device device, FontData fontData, int zoom) {
        return SWTFontProvider.getFontRegistry(device).getFont(fontData, zoom);
    }

    public static void disposeFontRegistry(Device device) {
        SWTFontRegistry fontRegistry = fontRegistries.remove(device);
        if (fontRegistry != null) {
            fontRegistry.dispose();
        }
    }

    private static SWTFontRegistry newFontRegistry(Device device) {
        Display display;
        if (device instanceof Display && (display = (Display)device).isRescalingAtRuntime()) {
            return new ScalingSWTFontRegistry(device);
        }
        return new DefaultSWTFontRegistry(device);
    }
}

