import sys

# sys.platform.startswith("aix"):
if sys.platform != "linux" and sys.platform != "win32" and sys.platform != "darwin":
    from typing import Final

    AF_LINK: Final = 18

    def getpagesize() -> int: ...
    def net_if_addrs(): ...
    def net_if_flags(nic_name: str, /) -> list[str]: ...
    def net_if_is_running(nic_name: str, /) -> bool: ...
    def net_if_mtu(nic_name: str, /) -> int: ...
    def proc_priority_get(pid: int, /) -> int: ...
    def proc_priority_set(pid: int, priority: int, /) -> None: ...

    version: Final[int]
    SIDL: Final[int]
    SZOMB: Final[int]
    SACTIVE: Final[int]
    SSWAP: Final[int]
    SSTOP: Final[int]
    TCPS_CLOSED: Final[int]
    TCPS_CLOSING: Final[int]
    TCPS_CLOSE_WAIT: Final[int]
    TCPS_LISTEN: Final[int]
    TCPS_ESTABLISHED: Final[int]
    TCPS_SYN_SENT: Final[int]
    TCPS_SYN_RCVD: Final[int]
    TCPS_FIN_WAIT_1: Final[int]
    TCPS_FIN_WAIT_2: Final[int]
    TCPS_LAST_ACK: Final[int]
    TCPS_TIME_WAIT: Final[int]
    PSUTIL_CONN_NONE: Final = 128

    def proc_args(pid: int, /) -> list[str]: ...
    def proc_basic_info(pid: int, procfs_path: str, /) -> tuple[int, int, int, float, int, int, int, int]: ...
    def proc_cpu_times(pid: int, procfs_path: str, /) -> tuple[float, float, float, float]: ...
    def proc_cred(pid: int, procfs_path: str, /) -> tuple[int, int, int, int, int, int]: ...
    def proc_environ(pid: int, /) -> dict[str, str]: ...
    def proc_name(pid: int, procfs_path: str, /) -> str: ...
    def proc_threads(pid: int, /) -> list[tuple[int, float, float]]: ...
    def proc_io_counters(pid: int, /) -> tuple[int, int, int, int]: ...
    def proc_num_ctx_switches(requested_pid: int, /) -> tuple[int, int]: ...
    def boot_time() -> float: ...
    def disk_io_counters() -> dict[str, tuple[int, int, int, int, int, int]]: ...
    def disk_partitions() -> list[tuple[str, str, str, str]]: ...
    def per_cpu_times() -> list[tuple[float, float, float, float]]: ...
    def swap_mem() -> tuple[int, int, int, int]: ...
    def virtual_mem() -> tuple[int, int, int, int, int]: ...
    def net_io_counters() -> dict[str, tuple[int, int, int, int, int, int, int, int]]: ...
    def cpu_stats() -> tuple[int, int, int, int]: ...
    def net_connections(
        requested_pid: int, /
    ) -> list[tuple[int, int, int, str | tuple[str, int], str | tuple[str, int] | tuple[()], int, int]]: ...
    def net_if_stats(nic_name: str, /) -> tuple[bool, int]: ...  # It's actually list of 2 elements
    def check_pid_range(pid: int, /) -> None: ...
    def set_debug(value: bool, /) -> None: ...
