// Code generated via go generate from gen_breaktest.go. DO NOT EDIT.

package uniseg

// sentenceBreakTestCases are Grapheme testcases taken from
// https://www.unicode.org/Public/15.0.0/ucd/auxiliary/SentenceBreakTest.txt
// on September 5, 2023. See
// https://www.unicode.org/license.html for the Unicode license agreement.
var sentenceBreakTestCases = []testCase{
	{original: "\u0001\u0001", expected: [][]rune{{0x0001, 0x0001}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0001\u0308\u0001", expected: [][]rune{{0x0001, 0x0308, 0x0001}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0001\u000D", expected: [][]rune{{0x0001, 0x000D}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0001\u0308\u000D", expected: [][]rune{{0x0001, 0x0308, 0x000D}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0001\u000A", expected: [][]rune{{0x0001, 0x000A}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0001\u0308\u000A", expected: [][]rune{{0x0001, 0x0308, 0x000A}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0001\u0085", expected: [][]rune{{0x0001, 0x0085}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0001\u0308\u0085", expected: [][]rune{{0x0001, 0x0308, 0x0085}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0001\u0009", expected: [][]rune{{0x0001, 0x0009}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0001\u0308\u0009", expected: [][]rune{{0x0001, 0x0308, 0x0009}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0001\u0061", expected: [][]rune{{0x0001, 0x0061}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0001\u0308\u0061", expected: [][]rune{{0x0001, 0x0308, 0x0061}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0001\u0041", expected: [][]rune{{0x0001, 0x0041}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0001\u0308\u0041", expected: [][]rune{{0x0001, 0x0308, 0x0041}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0001\u01BB", expected: [][]rune{{0x0001, 0x01BB}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0001\u0308\u01BB", expected: [][]rune{{0x0001, 0x0308, 0x01BB}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0001\u0030", expected: [][]rune{{0x0001, 0x0030}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0001\u0308\u0030", expected: [][]rune{{0x0001, 0x0308, 0x0030}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0001\u002E", expected: [][]rune{{0x0001, 0x002E}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0001\u0308\u002E", expected: [][]rune{{0x0001, 0x0308, 0x002E}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0001\u0021", expected: [][]rune{{0x0001, 0x0021}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0001\u0308\u0021", expected: [][]rune{{0x0001, 0x0308, 0x0021}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0001\u0022", expected: [][]rune{{0x0001, 0x0022}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0001\u0308\u0022", expected: [][]rune{{0x0001, 0x0308, 0x0022}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0001\u002C", expected: [][]rune{{0x0001, 0x002C}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0001\u0308\u002C", expected: [][]rune{{0x0001, 0x0308, 0x002C}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0001\u00AD", expected: [][]rune{{0x0001, 0x00AD}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0001\u0308\u00AD", expected: [][]rune{{0x0001, 0x0308, 0x00AD}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0001\u0300", expected: [][]rune{{0x0001, 0x0300}}},                                               // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0001\u0308\u0300", expected: [][]rune{{0x0001, 0x0308, 0x0300}}},                                 // ÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000D\u0001", expected: [][]rune{{0x000D}, {0x0001}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000D\u0308\u0001", expected: [][]rune{{0x000D}, {0x0308, 0x0001}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000D\u000D", expected: [][]rune{{0x000D}, {0x000D}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u0308\u000D", expected: [][]rune{{0x000D}, {0x0308, 0x000D}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u000A", expected: [][]rune{{0x000D, 0x000A}}},                                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0308\u000A", expected: [][]rune{{0x000D}, {0x0308, 0x000A}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0085", expected: [][]rune{{0x000D}, {0x0085}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u000D\u0308\u0085", expected: [][]rune{{0x000D}, {0x0308, 0x0085}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u000D\u0009", expected: [][]rune{{0x000D}, {0x0009}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u000D\u0308\u0009", expected: [][]rune{{0x000D}, {0x0308, 0x0009}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u000D\u0061", expected: [][]rune{{0x000D}, {0x0061}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u000D\u0308\u0061", expected: [][]rune{{0x000D}, {0x0308, 0x0061}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u000D\u0041", expected: [][]rune{{0x000D}, {0x0041}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u000D\u0308\u0041", expected: [][]rune{{0x000D}, {0x0308, 0x0041}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u000D\u01BB", expected: [][]rune{{0x000D}, {0x01BB}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u000D\u0308\u01BB", expected: [][]rune{{0x000D}, {0x0308, 0x01BB}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u000D\u0030", expected: [][]rune{{0x000D}, {0x0030}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000D\u0308\u0030", expected: [][]rune{{0x000D}, {0x0308, 0x0030}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000D\u002E", expected: [][]rune{{0x000D}, {0x002E}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u000D\u0308\u002E", expected: [][]rune{{0x000D}, {0x0308, 0x002E}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u000D\u0021", expected: [][]rune{{0x000D}, {0x0021}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u000D\u0308\u0021", expected: [][]rune{{0x000D}, {0x0308, 0x0021}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u000D\u0022", expected: [][]rune{{0x000D}, {0x0022}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u000D\u0308\u0022", expected: [][]rune{{0x000D}, {0x0308, 0x0022}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u000D\u002C", expected: [][]rune{{0x000D}, {0x002C}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u000D\u0308\u002C", expected: [][]rune{{0x000D}, {0x0308, 0x002C}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u000D\u00AD", expected: [][]rune{{0x000D}, {0x00AD}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000D\u0308\u00AD", expected: [][]rune{{0x000D}, {0x0308, 0x00AD}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000D\u0300", expected: [][]rune{{0x000D}, {0x0300}}},                                             // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000D\u0308\u0300", expected: [][]rune{{0x000D}, {0x0308, 0x0300}}},                               // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000A\u0001", expected: [][]rune{{0x000A}, {0x0001}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000A\u0308\u0001", expected: [][]rune{{0x000A}, {0x0308, 0x0001}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000A\u000D", expected: [][]rune{{0x000A}, {0x000D}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000A\u0308\u000D", expected: [][]rune{{0x000A}, {0x0308, 0x000D}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000A\u000A", expected: [][]rune{{0x000A}, {0x000A}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000A\u0308\u000A", expected: [][]rune{{0x000A}, {0x0308, 0x000A}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000A\u0085", expected: [][]rune{{0x000A}, {0x0085}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u000A\u0308\u0085", expected: [][]rune{{0x000A}, {0x0308, 0x0085}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u000A\u0009", expected: [][]rune{{0x000A}, {0x0009}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u000A\u0308\u0009", expected: [][]rune{{0x000A}, {0x0308, 0x0009}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u000A\u0061", expected: [][]rune{{0x000A}, {0x0061}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u000A\u0308\u0061", expected: [][]rune{{0x000A}, {0x0308, 0x0061}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u000A\u0041", expected: [][]rune{{0x000A}, {0x0041}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u000A\u0308\u0041", expected: [][]rune{{0x000A}, {0x0308, 0x0041}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u000A\u01BB", expected: [][]rune{{0x000A}, {0x01BB}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u000A\u0308\u01BB", expected: [][]rune{{0x000A}, {0x0308, 0x01BB}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u000A\u0030", expected: [][]rune{{0x000A}, {0x0030}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000A\u0308\u0030", expected: [][]rune{{0x000A}, {0x0308, 0x0030}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000A\u002E", expected: [][]rune{{0x000A}, {0x002E}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u000A\u0308\u002E", expected: [][]rune{{0x000A}, {0x0308, 0x002E}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u000A\u0021", expected: [][]rune{{0x000A}, {0x0021}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u000A\u0308\u0021", expected: [][]rune{{0x000A}, {0x0308, 0x0021}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u000A\u0022", expected: [][]rune{{0x000A}, {0x0022}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u000A\u0308\u0022", expected: [][]rune{{0x000A}, {0x0308, 0x0022}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u000A\u002C", expected: [][]rune{{0x000A}, {0x002C}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u000A\u0308\u002C", expected: [][]rune{{0x000A}, {0x0308, 0x002C}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u000A\u00AD", expected: [][]rune{{0x000A}, {0x00AD}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000A\u0308\u00AD", expected: [][]rune{{0x000A}, {0x0308, 0x00AD}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000A\u0300", expected: [][]rune{{0x000A}, {0x0300}}},                                             // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000A\u0308\u0300", expected: [][]rune{{0x000A}, {0x0308, 0x0300}}},                               // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0085\u0001", expected: [][]rune{{0x0085}, {0x0001}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0085\u0308\u0001", expected: [][]rune{{0x0085}, {0x0308, 0x0001}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0085\u000D", expected: [][]rune{{0x0085}, {0x000D}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0085\u0308\u000D", expected: [][]rune{{0x0085}, {0x0308, 0x000D}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0085\u000A", expected: [][]rune{{0x0085}, {0x000A}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0085\u0308\u000A", expected: [][]rune{{0x0085}, {0x0308, 0x000A}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0085\u0085", expected: [][]rune{{0x0085}, {0x0085}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0085\u0308\u0085", expected: [][]rune{{0x0085}, {0x0308, 0x0085}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0085\u0009", expected: [][]rune{{0x0085}, {0x0009}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0085\u0308\u0009", expected: [][]rune{{0x0085}, {0x0308, 0x0009}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0085\u0061", expected: [][]rune{{0x0085}, {0x0061}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0085\u0308\u0061", expected: [][]rune{{0x0085}, {0x0308, 0x0061}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0085\u0041", expected: [][]rune{{0x0085}, {0x0041}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0085\u0308\u0041", expected: [][]rune{{0x0085}, {0x0308, 0x0041}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0085\u01BB", expected: [][]rune{{0x0085}, {0x01BB}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0085\u0308\u01BB", expected: [][]rune{{0x0085}, {0x0308, 0x01BB}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0085\u0030", expected: [][]rune{{0x0085}, {0x0030}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0085\u0308\u0030", expected: [][]rune{{0x0085}, {0x0308, 0x0030}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0085\u002E", expected: [][]rune{{0x0085}, {0x002E}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0085\u0308\u002E", expected: [][]rune{{0x0085}, {0x0308, 0x002E}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0085\u0021", expected: [][]rune{{0x0085}, {0x0021}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0085\u0308\u0021", expected: [][]rune{{0x0085}, {0x0308, 0x0021}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0085\u0022", expected: [][]rune{{0x0085}, {0x0022}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0085\u0308\u0022", expected: [][]rune{{0x0085}, {0x0308, 0x0022}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0085\u002C", expected: [][]rune{{0x0085}, {0x002C}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0085\u0308\u002C", expected: [][]rune{{0x0085}, {0x0308, 0x002C}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0085\u00AD", expected: [][]rune{{0x0085}, {0x00AD}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0085\u0308\u00AD", expected: [][]rune{{0x0085}, {0x0308, 0x00AD}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0085\u0300", expected: [][]rune{{0x0085}, {0x0300}}},                                             // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0085\u0308\u0300", expected: [][]rune{{0x0085}, {0x0308, 0x0300}}},                               // ÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0009\u0001", expected: [][]rune{{0x0009, 0x0001}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0009\u0308\u0001", expected: [][]rune{{0x0009, 0x0308, 0x0001}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0009\u000D", expected: [][]rune{{0x0009, 0x000D}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0009\u0308\u000D", expected: [][]rune{{0x0009, 0x0308, 0x000D}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0009\u000A", expected: [][]rune{{0x0009, 0x000A}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0009\u0308\u000A", expected: [][]rune{{0x0009, 0x0308, 0x000A}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0009\u0085", expected: [][]rune{{0x0009, 0x0085}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0009\u0308\u0085", expected: [][]rune{{0x0009, 0x0308, 0x0085}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0009\u0009", expected: [][]rune{{0x0009, 0x0009}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0009\u0308\u0009", expected: [][]rune{{0x0009, 0x0308, 0x0009}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0009\u0061", expected: [][]rune{{0x0009, 0x0061}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0009\u0308\u0061", expected: [][]rune{{0x0009, 0x0308, 0x0061}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0009\u0041", expected: [][]rune{{0x0009, 0x0041}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0009\u0308\u0041", expected: [][]rune{{0x0009, 0x0308, 0x0041}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0009\u01BB", expected: [][]rune{{0x0009, 0x01BB}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0009\u0308\u01BB", expected: [][]rune{{0x0009, 0x0308, 0x01BB}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0009\u0030", expected: [][]rune{{0x0009, 0x0030}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0009\u0308\u0030", expected: [][]rune{{0x0009, 0x0308, 0x0030}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0009\u002E", expected: [][]rune{{0x0009, 0x002E}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0009\u0308\u002E", expected: [][]rune{{0x0009, 0x0308, 0x002E}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0009\u0021", expected: [][]rune{{0x0009, 0x0021}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0009\u0308\u0021", expected: [][]rune{{0x0009, 0x0308, 0x0021}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0009\u0022", expected: [][]rune{{0x0009, 0x0022}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0009\u0308\u0022", expected: [][]rune{{0x0009, 0x0308, 0x0022}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0009\u002C", expected: [][]rune{{0x0009, 0x002C}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0009\u0308\u002C", expected: [][]rune{{0x0009, 0x0308, 0x002C}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0009\u00AD", expected: [][]rune{{0x0009, 0x00AD}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0009\u0308\u00AD", expected: [][]rune{{0x0009, 0x0308, 0x00AD}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0009\u0300", expected: [][]rune{{0x0009, 0x0300}}},                                               // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0009\u0308\u0300", expected: [][]rune{{0x0009, 0x0308, 0x0300}}},                                 // ÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0001", expected: [][]rune{{0x0061, 0x0001}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u0308\u0001", expected: [][]rune{{0x0061, 0x0308, 0x0001}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u000D", expected: [][]rune{{0x0061, 0x000D}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u0308\u000D", expected: [][]rune{{0x0061, 0x0308, 0x000D}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u000A", expected: [][]rune{{0x0061, 0x000A}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u0308\u000A", expected: [][]rune{{0x0061, 0x0308, 0x000A}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u0085", expected: [][]rune{{0x0061, 0x0085}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0061\u0308\u0085", expected: [][]rune{{0x0061, 0x0308, 0x0085}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0061\u0009", expected: [][]rune{{0x0061, 0x0009}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0061\u0308\u0009", expected: [][]rune{{0x0061, 0x0308, 0x0009}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0061\u0061", expected: [][]rune{{0x0061, 0x0061}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0061\u0308\u0061", expected: [][]rune{{0x0061, 0x0308, 0x0061}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0061\u0041", expected: [][]rune{{0x0061, 0x0041}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0061\u0308\u0041", expected: [][]rune{{0x0061, 0x0308, 0x0041}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0061\u01BB", expected: [][]rune{{0x0061, 0x01BB}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0061\u0308\u01BB", expected: [][]rune{{0x0061, 0x0308, 0x01BB}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0061\u0030", expected: [][]rune{{0x0061, 0x0030}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u0308\u0030", expected: [][]rune{{0x0061, 0x0308, 0x0030}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u002E", expected: [][]rune{{0x0061, 0x002E}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0061\u0308\u002E", expected: [][]rune{{0x0061, 0x0308, 0x002E}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0061\u0021", expected: [][]rune{{0x0061, 0x0021}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0061\u0308\u0021", expected: [][]rune{{0x0061, 0x0308, 0x0021}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0061\u0022", expected: [][]rune{{0x0061, 0x0022}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0061\u0308\u0022", expected: [][]rune{{0x0061, 0x0308, 0x0022}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0061\u002C", expected: [][]rune{{0x0061, 0x002C}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0061\u0308\u002C", expected: [][]rune{{0x0061, 0x0308, 0x002C}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0061\u00AD", expected: [][]rune{{0x0061, 0x00AD}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u0308\u00AD", expected: [][]rune{{0x0061, 0x0308, 0x00AD}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u0300", expected: [][]rune{{0x0061, 0x0300}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0308\u0300", expected: [][]rune{{0x0061, 0x0308, 0x0300}}},                                 // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0041\u0001", expected: [][]rune{{0x0041, 0x0001}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0041\u0308\u0001", expected: [][]rune{{0x0041, 0x0308, 0x0001}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0041\u000D", expected: [][]rune{{0x0041, 0x000D}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0041\u0308\u000D", expected: [][]rune{{0x0041, 0x0308, 0x000D}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0041\u000A", expected: [][]rune{{0x0041, 0x000A}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0041\u0308\u000A", expected: [][]rune{{0x0041, 0x0308, 0x000A}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0041\u0085", expected: [][]rune{{0x0041, 0x0085}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0041\u0308\u0085", expected: [][]rune{{0x0041, 0x0308, 0x0085}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0041\u0009", expected: [][]rune{{0x0041, 0x0009}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0041\u0308\u0009", expected: [][]rune{{0x0041, 0x0308, 0x0009}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0041\u0061", expected: [][]rune{{0x0041, 0x0061}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0041\u0308\u0061", expected: [][]rune{{0x0041, 0x0308, 0x0061}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0041\u0041", expected: [][]rune{{0x0041, 0x0041}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0041\u0308\u0041", expected: [][]rune{{0x0041, 0x0308, 0x0041}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0041\u01BB", expected: [][]rune{{0x0041, 0x01BB}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0041\u0308\u01BB", expected: [][]rune{{0x0041, 0x0308, 0x01BB}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0041\u0030", expected: [][]rune{{0x0041, 0x0030}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0041\u0308\u0030", expected: [][]rune{{0x0041, 0x0308, 0x0030}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0041\u002E", expected: [][]rune{{0x0041, 0x002E}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0041\u0308\u002E", expected: [][]rune{{0x0041, 0x0308, 0x002E}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0041\u0021", expected: [][]rune{{0x0041, 0x0021}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0041\u0308\u0021", expected: [][]rune{{0x0041, 0x0308, 0x0021}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0041\u0022", expected: [][]rune{{0x0041, 0x0022}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0041\u0308\u0022", expected: [][]rune{{0x0041, 0x0308, 0x0022}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0041\u002C", expected: [][]rune{{0x0041, 0x002C}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0041\u0308\u002C", expected: [][]rune{{0x0041, 0x0308, 0x002C}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0041\u00AD", expected: [][]rune{{0x0041, 0x00AD}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0041\u0308\u00AD", expected: [][]rune{{0x0041, 0x0308, 0x00AD}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0041\u0300", expected: [][]rune{{0x0041, 0x0300}}},                                               // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0041\u0308\u0300", expected: [][]rune{{0x0041, 0x0308, 0x0300}}},                                 // ÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u01BB\u0001", expected: [][]rune{{0x01BB, 0x0001}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u01BB\u0308\u0001", expected: [][]rune{{0x01BB, 0x0308, 0x0001}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u01BB\u000D", expected: [][]rune{{0x01BB, 0x000D}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u01BB\u0308\u000D", expected: [][]rune{{0x01BB, 0x0308, 0x000D}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u01BB\u000A", expected: [][]rune{{0x01BB, 0x000A}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u01BB\u0308\u000A", expected: [][]rune{{0x01BB, 0x0308, 0x000A}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u01BB\u0085", expected: [][]rune{{0x01BB, 0x0085}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u01BB\u0308\u0085", expected: [][]rune{{0x01BB, 0x0308, 0x0085}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u01BB\u0009", expected: [][]rune{{0x01BB, 0x0009}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u01BB\u0308\u0009", expected: [][]rune{{0x01BB, 0x0308, 0x0009}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u01BB\u0061", expected: [][]rune{{0x01BB, 0x0061}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u01BB\u0308\u0061", expected: [][]rune{{0x01BB, 0x0308, 0x0061}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u01BB\u0041", expected: [][]rune{{0x01BB, 0x0041}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u01BB\u0308\u0041", expected: [][]rune{{0x01BB, 0x0308, 0x0041}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u01BB\u01BB", expected: [][]rune{{0x01BB, 0x01BB}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u01BB\u0308\u01BB", expected: [][]rune{{0x01BB, 0x0308, 0x01BB}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u01BB\u0030", expected: [][]rune{{0x01BB, 0x0030}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u01BB\u0308\u0030", expected: [][]rune{{0x01BB, 0x0308, 0x0030}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u01BB\u002E", expected: [][]rune{{0x01BB, 0x002E}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u01BB\u0308\u002E", expected: [][]rune{{0x01BB, 0x0308, 0x002E}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u01BB\u0021", expected: [][]rune{{0x01BB, 0x0021}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u01BB\u0308\u0021", expected: [][]rune{{0x01BB, 0x0308, 0x0021}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u01BB\u0022", expected: [][]rune{{0x01BB, 0x0022}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u01BB\u0308\u0022", expected: [][]rune{{0x01BB, 0x0308, 0x0022}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u01BB\u002C", expected: [][]rune{{0x01BB, 0x002C}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u01BB\u0308\u002C", expected: [][]rune{{0x01BB, 0x0308, 0x002C}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u01BB\u00AD", expected: [][]rune{{0x01BB, 0x00AD}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u01BB\u0308\u00AD", expected: [][]rune{{0x01BB, 0x0308, 0x00AD}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u01BB\u0300", expected: [][]rune{{0x01BB, 0x0300}}},                                               // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u01BB\u0308\u0300", expected: [][]rune{{0x01BB, 0x0308, 0x0300}}},                                 // ÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0030\u0001", expected: [][]rune{{0x0030, 0x0001}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0030\u0308\u0001", expected: [][]rune{{0x0030, 0x0308, 0x0001}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0030\u000D", expected: [][]rune{{0x0030, 0x000D}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0030\u0308\u000D", expected: [][]rune{{0x0030, 0x0308, 0x000D}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0030\u000A", expected: [][]rune{{0x0030, 0x000A}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0030\u0308\u000A", expected: [][]rune{{0x0030, 0x0308, 0x000A}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0030\u0085", expected: [][]rune{{0x0030, 0x0085}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0030\u0308\u0085", expected: [][]rune{{0x0030, 0x0308, 0x0085}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0030\u0009", expected: [][]rune{{0x0030, 0x0009}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0030\u0308\u0009", expected: [][]rune{{0x0030, 0x0308, 0x0009}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0030\u0061", expected: [][]rune{{0x0030, 0x0061}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0030\u0308\u0061", expected: [][]rune{{0x0030, 0x0308, 0x0061}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0030\u0041", expected: [][]rune{{0x0030, 0x0041}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0030\u0308\u0041", expected: [][]rune{{0x0030, 0x0308, 0x0041}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0030\u01BB", expected: [][]rune{{0x0030, 0x01BB}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0030\u0308\u01BB", expected: [][]rune{{0x0030, 0x0308, 0x01BB}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0030\u0030", expected: [][]rune{{0x0030, 0x0030}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0030\u0308\u0030", expected: [][]rune{{0x0030, 0x0308, 0x0030}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0030\u002E", expected: [][]rune{{0x0030, 0x002E}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0030\u0308\u002E", expected: [][]rune{{0x0030, 0x0308, 0x002E}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0030\u0021", expected: [][]rune{{0x0030, 0x0021}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0030\u0308\u0021", expected: [][]rune{{0x0030, 0x0308, 0x0021}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0030\u0022", expected: [][]rune{{0x0030, 0x0022}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0030\u0308\u0022", expected: [][]rune{{0x0030, 0x0308, 0x0022}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0030\u002C", expected: [][]rune{{0x0030, 0x002C}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0030\u0308\u002C", expected: [][]rune{{0x0030, 0x0308, 0x002C}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0030\u00AD", expected: [][]rune{{0x0030, 0x00AD}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0030\u0308\u00AD", expected: [][]rune{{0x0030, 0x0308, 0x00AD}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0030\u0300", expected: [][]rune{{0x0030, 0x0300}}},                                               // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0030\u0308\u0300", expected: [][]rune{{0x0030, 0x0308, 0x0300}}},                                 // ÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002E\u0001", expected: [][]rune{{0x002E}, {0x0001}}},                                             // ÷ [0.2] FULL STOP (ATerm) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002E\u0308\u0001", expected: [][]rune{{0x002E, 0x0308}, {0x0001}}},                               // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002E\u000D", expected: [][]rune{{0x002E, 0x000D}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002E\u0308\u000D", expected: [][]rune{{0x002E, 0x0308, 0x000D}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002E\u000A", expected: [][]rune{{0x002E, 0x000A}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002E\u0308\u000A", expected: [][]rune{{0x002E, 0x0308, 0x000A}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002E\u0085", expected: [][]rune{{0x002E, 0x0085}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u002E\u0308\u0085", expected: [][]rune{{0x002E, 0x0308, 0x0085}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u002E\u0009", expected: [][]rune{{0x002E, 0x0009}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u002E\u0308\u0009", expected: [][]rune{{0x002E, 0x0308, 0x0009}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u002E\u0061", expected: [][]rune{{0x002E, 0x0061}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u002E\u0308\u0061", expected: [][]rune{{0x002E, 0x0308, 0x0061}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u002E\u0041", expected: [][]rune{{0x002E}, {0x0041}}},                                             // ÷ [0.2] FULL STOP (ATerm) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u002E\u0308\u0041", expected: [][]rune{{0x002E, 0x0308}, {0x0041}}},                               // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u002E\u01BB", expected: [][]rune{{0x002E}, {0x01BB}}},                                             // ÷ [0.2] FULL STOP (ATerm) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u002E\u0308\u01BB", expected: [][]rune{{0x002E, 0x0308}, {0x01BB}}},                               // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u002E\u0030", expected: [][]rune{{0x002E, 0x0030}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [6.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002E\u0308\u0030", expected: [][]rune{{0x002E, 0x0308, 0x0030}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [6.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002E\u002E", expected: [][]rune{{0x002E, 0x002E}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [8.1] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u002E\u0308\u002E", expected: [][]rune{{0x002E, 0x0308, 0x002E}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u002E\u0021", expected: [][]rune{{0x002E, 0x0021}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u002E\u0308\u0021", expected: [][]rune{{0x002E, 0x0308, 0x0021}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u002E\u0022", expected: [][]rune{{0x002E, 0x0022}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [9.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u002E\u0308\u0022", expected: [][]rune{{0x002E, 0x0308, 0x0022}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u002E\u002C", expected: [][]rune{{0x002E, 0x002C}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [8.1] COMMA (SContinue) ÷ [0.3]
	{original: "\u002E\u0308\u002C", expected: [][]rune{{0x002E, 0x0308, 0x002C}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] COMMA (SContinue) ÷ [0.3]
	{original: "\u002E\u00AD", expected: [][]rune{{0x002E, 0x00AD}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002E\u0308\u00AD", expected: [][]rune{{0x002E, 0x0308, 0x00AD}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002E\u0300", expected: [][]rune{{0x002E, 0x0300}}},                                               // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002E\u0308\u0300", expected: [][]rune{{0x002E, 0x0308, 0x0300}}},                                 // ÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0021\u0001", expected: [][]rune{{0x0021}, {0x0001}}},                                             // ÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0021\u0308\u0001", expected: [][]rune{{0x0021, 0x0308}, {0x0001}}},                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0021\u000D", expected: [][]rune{{0x0021, 0x000D}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0021\u0308\u000D", expected: [][]rune{{0x0021, 0x0308, 0x000D}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0021\u000A", expected: [][]rune{{0x0021, 0x000A}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0021\u0308\u000A", expected: [][]rune{{0x0021, 0x0308, 0x000A}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0021\u0085", expected: [][]rune{{0x0021, 0x0085}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0021\u0308\u0085", expected: [][]rune{{0x0021, 0x0308, 0x0085}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0021\u0009", expected: [][]rune{{0x0021, 0x0009}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0021\u0308\u0009", expected: [][]rune{{0x0021, 0x0308, 0x0009}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0021\u0061", expected: [][]rune{{0x0021}, {0x0061}}},                                             // ÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0021\u0308\u0061", expected: [][]rune{{0x0021, 0x0308}, {0x0061}}},                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0021\u0041", expected: [][]rune{{0x0021}, {0x0041}}},                                             // ÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0021\u0308\u0041", expected: [][]rune{{0x0021, 0x0308}, {0x0041}}},                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0021\u01BB", expected: [][]rune{{0x0021}, {0x01BB}}},                                             // ÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0021\u0308\u01BB", expected: [][]rune{{0x0021, 0x0308}, {0x01BB}}},                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0021\u0030", expected: [][]rune{{0x0021}, {0x0030}}},                                             // ÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0021\u0308\u0030", expected: [][]rune{{0x0021, 0x0308}, {0x0030}}},                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0021\u002E", expected: [][]rune{{0x0021, 0x002E}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0021\u0308\u002E", expected: [][]rune{{0x0021, 0x0308, 0x002E}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0021\u0021", expected: [][]rune{{0x0021, 0x0021}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0021\u0308\u0021", expected: [][]rune{{0x0021, 0x0308, 0x0021}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0021\u0022", expected: [][]rune{{0x0021, 0x0022}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0021\u0308\u0022", expected: [][]rune{{0x0021, 0x0308, 0x0022}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0021\u002C", expected: [][]rune{{0x0021, 0x002C}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] COMMA (SContinue) ÷ [0.3]
	{original: "\u0021\u0308\u002C", expected: [][]rune{{0x0021, 0x0308, 0x002C}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] COMMA (SContinue) ÷ [0.3]
	{original: "\u0021\u00AD", expected: [][]rune{{0x0021, 0x00AD}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0021\u0308\u00AD", expected: [][]rune{{0x0021, 0x0308, 0x00AD}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0021\u0300", expected: [][]rune{{0x0021, 0x0300}}},                                               // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0021\u0308\u0300", expected: [][]rune{{0x0021, 0x0308, 0x0300}}},                                 // ÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0022\u0001", expected: [][]rune{{0x0022, 0x0001}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0022\u0308\u0001", expected: [][]rune{{0x0022, 0x0308, 0x0001}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0022\u000D", expected: [][]rune{{0x0022, 0x000D}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0022\u0308\u000D", expected: [][]rune{{0x0022, 0x0308, 0x000D}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0022\u000A", expected: [][]rune{{0x0022, 0x000A}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0022\u0308\u000A", expected: [][]rune{{0x0022, 0x0308, 0x000A}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0022\u0085", expected: [][]rune{{0x0022, 0x0085}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0022\u0308\u0085", expected: [][]rune{{0x0022, 0x0308, 0x0085}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0022\u0009", expected: [][]rune{{0x0022, 0x0009}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0022\u0308\u0009", expected: [][]rune{{0x0022, 0x0308, 0x0009}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0022\u0061", expected: [][]rune{{0x0022, 0x0061}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0022\u0308\u0061", expected: [][]rune{{0x0022, 0x0308, 0x0061}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0022\u0041", expected: [][]rune{{0x0022, 0x0041}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0022\u0308\u0041", expected: [][]rune{{0x0022, 0x0308, 0x0041}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0022\u01BB", expected: [][]rune{{0x0022, 0x01BB}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0022\u0308\u01BB", expected: [][]rune{{0x0022, 0x0308, 0x01BB}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0022\u0030", expected: [][]rune{{0x0022, 0x0030}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0022\u0308\u0030", expected: [][]rune{{0x0022, 0x0308, 0x0030}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0022\u002E", expected: [][]rune{{0x0022, 0x002E}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0022\u0308\u002E", expected: [][]rune{{0x0022, 0x0308, 0x002E}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0022\u0021", expected: [][]rune{{0x0022, 0x0021}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0022\u0308\u0021", expected: [][]rune{{0x0022, 0x0308, 0x0021}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0022\u0022", expected: [][]rune{{0x0022, 0x0022}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0022\u0308\u0022", expected: [][]rune{{0x0022, 0x0308, 0x0022}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0022\u002C", expected: [][]rune{{0x0022, 0x002C}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0022\u0308\u002C", expected: [][]rune{{0x0022, 0x0308, 0x002C}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0022\u00AD", expected: [][]rune{{0x0022, 0x00AD}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0022\u0308\u00AD", expected: [][]rune{{0x0022, 0x0308, 0x00AD}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0022\u0300", expected: [][]rune{{0x0022, 0x0300}}},                                               // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0022\u0308\u0300", expected: [][]rune{{0x0022, 0x0308, 0x0300}}},                                 // ÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002C\u0001", expected: [][]rune{{0x002C, 0x0001}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002C\u0308\u0001", expected: [][]rune{{0x002C, 0x0308, 0x0001}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002C\u000D", expected: [][]rune{{0x002C, 0x000D}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u0308\u000D", expected: [][]rune{{0x002C, 0x0308, 0x000D}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u000A", expected: [][]rune{{0x002C, 0x000A}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u0308\u000A", expected: [][]rune{{0x002C, 0x0308, 0x000A}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u0085", expected: [][]rune{{0x002C, 0x0085}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u002C\u0308\u0085", expected: [][]rune{{0x002C, 0x0308, 0x0085}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u002C\u0009", expected: [][]rune{{0x002C, 0x0009}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u002C\u0308\u0009", expected: [][]rune{{0x002C, 0x0308, 0x0009}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u002C\u0061", expected: [][]rune{{0x002C, 0x0061}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u002C\u0308\u0061", expected: [][]rune{{0x002C, 0x0308, 0x0061}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u002C\u0041", expected: [][]rune{{0x002C, 0x0041}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u002C\u0308\u0041", expected: [][]rune{{0x002C, 0x0308, 0x0041}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u002C\u01BB", expected: [][]rune{{0x002C, 0x01BB}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u002C\u0308\u01BB", expected: [][]rune{{0x002C, 0x0308, 0x01BB}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u002C\u0030", expected: [][]rune{{0x002C, 0x0030}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002C\u0308\u0030", expected: [][]rune{{0x002C, 0x0308, 0x0030}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002C\u002E", expected: [][]rune{{0x002C, 0x002E}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u002C\u0308\u002E", expected: [][]rune{{0x002C, 0x0308, 0x002E}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u002C\u0021", expected: [][]rune{{0x002C, 0x0021}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u002C\u0308\u0021", expected: [][]rune{{0x002C, 0x0308, 0x0021}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u002C\u0022", expected: [][]rune{{0x002C, 0x0022}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u002C\u0308\u0022", expected: [][]rune{{0x002C, 0x0308, 0x0022}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u002C\u002C", expected: [][]rune{{0x002C, 0x002C}}},                                               // ÷ [0.2] COMMA (SContinue) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u002C\u0308\u002C", expected: [][]rune{{0x002C, 0x0308, 0x002C}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u002C\u00AD", expected: [][]rune{{0x002C, 0x00AD}}},                                               // ÷ [0.2] COMMA (SContinue) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002C\u0308\u00AD", expected: [][]rune{{0x002C, 0x0308, 0x00AD}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002C\u0300", expected: [][]rune{{0x002C, 0x0300}}},                                               // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002C\u0308\u0300", expected: [][]rune{{0x002C, 0x0308, 0x0300}}},                                 // ÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u00AD\u0001", expected: [][]rune{{0x00AD, 0x0001}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u00AD\u0308\u0001", expected: [][]rune{{0x00AD, 0x0308, 0x0001}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u00AD\u000D", expected: [][]rune{{0x00AD, 0x000D}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00AD\u0308\u000D", expected: [][]rune{{0x00AD, 0x0308, 0x000D}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00AD\u000A", expected: [][]rune{{0x00AD, 0x000A}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00AD\u0308\u000A", expected: [][]rune{{0x00AD, 0x0308, 0x000A}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00AD\u0085", expected: [][]rune{{0x00AD, 0x0085}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u00AD\u0308\u0085", expected: [][]rune{{0x00AD, 0x0308, 0x0085}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u00AD\u0009", expected: [][]rune{{0x00AD, 0x0009}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u00AD\u0308\u0009", expected: [][]rune{{0x00AD, 0x0308, 0x0009}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u00AD\u0061", expected: [][]rune{{0x00AD, 0x0061}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u00AD\u0308\u0061", expected: [][]rune{{0x00AD, 0x0308, 0x0061}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u00AD\u0041", expected: [][]rune{{0x00AD, 0x0041}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u00AD\u0308\u0041", expected: [][]rune{{0x00AD, 0x0308, 0x0041}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u00AD\u01BB", expected: [][]rune{{0x00AD, 0x01BB}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u00AD\u0308\u01BB", expected: [][]rune{{0x00AD, 0x0308, 0x01BB}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u00AD\u0030", expected: [][]rune{{0x00AD, 0x0030}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u00AD\u0308\u0030", expected: [][]rune{{0x00AD, 0x0308, 0x0030}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u00AD\u002E", expected: [][]rune{{0x00AD, 0x002E}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u00AD\u0308\u002E", expected: [][]rune{{0x00AD, 0x0308, 0x002E}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u00AD\u0021", expected: [][]rune{{0x00AD, 0x0021}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u00AD\u0308\u0021", expected: [][]rune{{0x00AD, 0x0308, 0x0021}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u00AD\u0022", expected: [][]rune{{0x00AD, 0x0022}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u00AD\u0308\u0022", expected: [][]rune{{0x00AD, 0x0308, 0x0022}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u00AD\u002C", expected: [][]rune{{0x00AD, 0x002C}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u00AD\u0308\u002C", expected: [][]rune{{0x00AD, 0x0308, 0x002C}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u00AD\u00AD", expected: [][]rune{{0x00AD, 0x00AD}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u00AD", expected: [][]rune{{0x00AD, 0x0308, 0x00AD}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0300", expected: [][]rune{{0x00AD, 0x0300}}},                                               // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u0300", expected: [][]rune{{0x00AD, 0x0308, 0x0300}}},                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0300\u0001", expected: [][]rune{{0x0300, 0x0001}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0300\u0308\u0001", expected: [][]rune{{0x0300, 0x0308, 0x0001}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0300\u000D", expected: [][]rune{{0x0300, 0x000D}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0300\u0308\u000D", expected: [][]rune{{0x0300, 0x0308, 0x000D}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0300\u000A", expected: [][]rune{{0x0300, 0x000A}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0300\u0308\u000A", expected: [][]rune{{0x0300, 0x0308, 0x000A}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0300\u0085", expected: [][]rune{{0x0300, 0x0085}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0300\u0308\u0085", expected: [][]rune{{0x0300, 0x0308, 0x0085}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]
	{original: "\u0300\u0009", expected: [][]rune{{0x0300, 0x0009}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0300\u0308\u0009", expected: [][]rune{{0x0300, 0x0308, 0x0009}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]
	{original: "\u0300\u0061", expected: [][]rune{{0x0300, 0x0061}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0300\u0308\u0061", expected: [][]rune{{0x0300, 0x0308, 0x0061}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]
	{original: "\u0300\u0041", expected: [][]rune{{0x0300, 0x0041}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0300\u0308\u0041", expected: [][]rune{{0x0300, 0x0308, 0x0041}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]
	{original: "\u0300\u01BB", expected: [][]rune{{0x0300, 0x01BB}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0300\u0308\u01BB", expected: [][]rune{{0x0300, 0x0308, 0x01BB}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]
	{original: "\u0300\u0030", expected: [][]rune{{0x0300, 0x0030}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0300\u0308\u0030", expected: [][]rune{{0x0300, 0x0308, 0x0030}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0300\u002E", expected: [][]rune{{0x0300, 0x002E}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0300\u0308\u002E", expected: [][]rune{{0x0300, 0x0308, 0x002E}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0300\u0021", expected: [][]rune{{0x0300, 0x0021}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0300\u0308\u0021", expected: [][]rune{{0x0300, 0x0308, 0x0021}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]
	{original: "\u0300\u0022", expected: [][]rune{{0x0300, 0x0022}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0300\u0308\u0022", expected: [][]rune{{0x0300, 0x0308, 0x0022}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] QUOTATION MARK (Close) ÷ [0.3]
	{original: "\u0300\u002C", expected: [][]rune{{0x0300, 0x002C}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0300\u0308\u002C", expected: [][]rune{{0x0300, 0x0308, 0x002C}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [998.0] COMMA (SContinue) ÷ [0.3]
	{original: "\u0300\u00AD", expected: [][]rune{{0x0300, 0x00AD}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0300\u0308\u00AD", expected: [][]rune{{0x0300, 0x0308, 0x00AD}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0300\u0300", expected: [][]rune{{0x0300, 0x0300}}},                                               // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0300\u0308\u0300", expected: [][]rune{{0x0300, 0x0308, 0x0300}}},                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000D\u000A\u0061\u000A\u0308", expected: [][]rune{{0x000D, 0x000A}, {0x0061, 0x000A}, {0x0308}}}, // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Lower) × [998.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0308", expected: [][]rune{{0x0061, 0x0308}}},                                               // ÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [0.3]
	{original: "\u0020\u200D\u0646", expected: [][]rune{{0x0020, 0x200D, 0x0646}}},                                 // ÷ [0.2] SPACE (Sp) × [5.0] ZERO WIDTH JOINER (Extend_FE) × [998.0] ARABIC LETTER NOON (OLetter) ÷ [0.3]
	{original: "\u0646\u200D\u0020", expected: [][]rune{{0x0646, 0x200D, 0x0020}}},                                 // ÷ [0.2] ARABIC LETTER NOON (OLetter) × [5.0] ZERO WIDTH JOINER (Extend_FE) × [998.0] SPACE (Sp) ÷ [0.3]
	{original: "\u0028\u0022\u0047\u006F\u002E\u0022\u0029\u0020\u0028\u0048\u0065\u0020\u0064\u0069\u0064\u002E\u0029", expected: [][]rune{{0x0028, 0x0022, 0x0047, 0x006F, 0x002E, 0x0022, 0x0029, 0x0020}, {0x0028, 0x0048, 0x0065, 0x0020, 0x0064, 0x0069, 0x0064, 0x002E, 0x0029}}}, // ÷ [0.2] LEFT PARENTHESIS (Close) × [998.0] QUOTATION MARK (Close) × [998.0] LATIN CAPITAL LETTER G (Upper) × [998.0] LATIN SMALL LETTER O (Lower) × [998.0] FULL STOP (ATerm) × [9.0] QUOTATION MARK (Close) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] SPACE (Sp) ÷ [11.0] LEFT PARENTHESIS (Close) × [998.0] LATIN CAPITAL LETTER H (Upper) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] LATIN SMALL LETTER I (Lower) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) ÷ [0.3]
	{original: "\u0028\u201C\u0047\u006F\u003F\u201D\u0029\u0020\u0028\u0048\u0065\u0020\u0064\u0069\u0064\u002E\u0029", expected: [][]rune{{0x0028, 0x201C, 0x0047, 0x006F, 0x003F, 0x201D, 0x0029, 0x0020}, {0x0028, 0x0048, 0x0065, 0x0020, 0x0064, 0x0069, 0x0064, 0x002E, 0x0029}}}, // ÷ [0.2] LEFT PARENTHESIS (Close) × [998.0] LEFT DOUBLE QUOTATION MARK (Close) × [998.0] LATIN CAPITAL LETTER G (Upper) × [998.0] LATIN SMALL LETTER O (Lower) × [998.0] QUESTION MARK (STerm) × [9.0] RIGHT DOUBLE QUOTATION MARK (Close) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] SPACE (Sp) ÷ [11.0] LEFT PARENTHESIS (Close) × [998.0] LATIN CAPITAL LETTER H (Upper) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] LATIN SMALL LETTER I (Lower) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) ÷ [0.3]
	{original: "\u0055\u002E\u0053\u002E\u0041\u0300\u002E\u0020\u0069\u0073", expected: [][]rune{{0x0055, 0x002E, 0x0053, 0x002E, 0x0041, 0x0300, 0x002E, 0x0020, 0x0069, 0x0073}}},                                                                                                     // ÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] FULL STOP (ATerm) × [8.0] SPACE (Sp) × [8.0] LATIN SMALL LETTER I (Lower) × [998.0] LATIN SMALL LETTER S (Lower) ÷ [0.3]
	{original: "\u0055\u002E\u0053\u002E\u0041\u0300\u003F\u0020\u0048\u0065", expected: [][]rune{{0x0055, 0x002E, 0x0053, 0x002E, 0x0041, 0x0300, 0x003F, 0x0020}, {0x0048, 0x0065}}},                                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] QUESTION MARK (STerm) × [9.0] SPACE (Sp) ÷ [11.0] LATIN CAPITAL LETTER H (Upper) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0055\u002E\u0053\u002E\u0041\u0300\u002E", expected: [][]rune{{0x0055, 0x002E, 0x0053, 0x002E, 0x0041, 0x0300, 0x002E}}},                                                                                                                                               // ÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] FULL STOP (ATerm) ÷ [0.3]
	{original: "\u0033\u002E\u0034", expected: [][]rune{{0x0033, 0x002E, 0x0034}}},                                                                                                                                                                                                                                                             // ÷ [0.2] DIGIT THREE (Numeric) × [998.0] FULL STOP (ATerm) × [6.0] DIGIT FOUR (Numeric) ÷ [0.3]
	{original: "\u0063\u002E\u0064", expected: [][]rune{{0x0063, 0x002E, 0x0064}}},                                                                                                                                                                                                                                                             // ÷ [0.2] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER D (Lower) ÷ [0.3]
	{original: "\u0043\u002E\u0064", expected: [][]rune{{0x0043, 0x002E, 0x0064}}},                                                                                                                                                                                                                                                             // ÷ [0.2] LATIN CAPITAL LETTER C (Upper) × [998.0] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER D (Lower) ÷ [0.3]
	{original: "\u0063\u002E\u0044", expected: [][]rune{{0x0063, 0x002E, 0x0044}}},                                                                                                                                                                                                                                                             // ÷ [0.2] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER D (Upper) ÷ [0.3]
	{original: "\u0043\u002E\u0044", expected: [][]rune{{0x0043, 0x002E, 0x0044}}},                                                                                                                                                                                                                                                             // ÷ [0.2] LATIN CAPITAL LETTER C (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER D (Upper) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u2019\u00A0\u0074\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x2019, 0x00A0, 0x0074, 0x0068, 0x0065}}},                                                                                                                                                           // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [8.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u2019\u00A0\u0054\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x2019, 0x00A0}, {0x0054, 0x0068, 0x0065}}},                                                                                                                                                         // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u2019\u00A0\u2018\u0028\u0074\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x2019, 0x00A0, 0x2018, 0x0028, 0x0074, 0x0068, 0x0065}}},                                                                                                                               // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [8.0] LEFT SINGLE QUOTATION MARK (Close) × [998.0] LEFT PARENTHESIS (Close) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u2019\u00A0\u2018\u0028\u0054\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x2019, 0x00A0}, {0x2018, 0x0028, 0x0054, 0x0068, 0x0065}}},                                                                                                                             // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) ÷ [11.0] LEFT SINGLE QUOTATION MARK (Close) × [998.0] LEFT PARENTHESIS (Close) × [998.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u2019\u00A0\u0308\u0074\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x2019, 0x00A0, 0x0308, 0x0074, 0x0068, 0x0065}}},                                                                                                                                             // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u2019\u00A0\u0308\u0054\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x2019, 0x00A0, 0x0308}, {0x0054, 0x0068, 0x0065}}},                                                                                                                                           // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u2019\u0308\u0054\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x2019, 0x0308}, {0x0054, 0x0068, 0x0065}}},                                                                                                                                                         // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u0029\u000A\u0308\u0054\u0068\u0065", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x0029, 0x000A}, {0x0308, 0x0054, 0x0068, 0x0065}}},                                                                                                                                                         // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [998.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u0074\u0068\u0065\u0020\u0072\u0065\u0073\u0070\u002E\u0020\u006C\u0065\u0061\u0064\u0065\u0072\u0073\u0020\u0061\u0072\u0065", expected: [][]rune{{0x0074, 0x0068, 0x0065, 0x0020, 0x0072, 0x0065, 0x0073, 0x0070, 0x002E, 0x0020, 0x006C, 0x0065, 0x0061, 0x0064, 0x0065, 0x0072, 0x0073, 0x0020, 0x0061, 0x0072, 0x0065}}}, // ÷ [0.2] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER R (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER S (Lower) × [998.0] LATIN SMALL LETTER P (Lower) × [998.0] FULL STOP (ATerm) × [8.0] SPACE (Sp) × [8.0] LATIN SMALL LETTER L (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER A (Lower) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER R (Lower) × [998.0] LATIN SMALL LETTER S (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER A (Lower) × [998.0] LATIN SMALL LETTER R (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]
	{original: "\u5B57\u002E\u5B57", expected: [][]rune{{0x5B57, 0x002E}, {0x5B57}}},                                                                                                                                                                                                                                                           // ÷ [0.2] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [998.0] FULL STOP (ATerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u5B83", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E}, {0x5B83}}},                                                                                                                                                                                                                               // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) ÷ [0.3]
	{original: "\u0065\u0074\u0063\u002E\u3002", expected: [][]rune{{0x0065, 0x0074, 0x0063, 0x002E, 0x3002}}},                                                                                                                                                                                                                                 // ÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.1] IDEOGRAPHIC FULL STOP (STerm) ÷ [0.3]
	{original: "\u5B57\u3002\u5B83", expected: [][]rune{{0x5B57, 0x3002}, {0x5B83}}},                                                                                                                                                                                                                                                           // ÷ [0.2] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [998.0] IDEOGRAPHIC FULL STOP (STerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) ÷ [0.3]
	{original: "\u0021\u0020\u0020", expected: [][]rune{{0x0021, 0x0020, 0x0020}}},                                                                                                                                                                                                                                                             // ÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] SPACE (Sp) × [10.0] SPACE (Sp) ÷ [0.3]
	{original: "\u2060\u0028\u2060\u0022\u2060\u0047\u2060\u006F\u2060\u002E\u2060\u0022\u2060\u0029\u2060\u0020\u2060\u0028\u2060\u0048\u2060\u0065\u2060\u0020\u2060\u0064\u2060\u0069\u2060\u0064\u2060\u002E\u2060\u0029\u2060\u2060", expected: [][]rune{{0x2060, 0x0028, 0x2060, 0x0022, 0x2060, 0x0047, 0x2060, 0x006F, 0x2060, 0x002E, 0x2060, 0x0022, 0x2060, 0x0029, 0x2060, 0x0020, 0x2060}, {0x0028, 0x2060, 0x0048, 0x2060, 0x0065, 0x2060, 0x0020, 0x2060, 0x0064, 0x2060, 0x0069, 0x2060, 0x0064, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2060}}}, // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER G (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER O (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0028\u2060\u201C\u2060\u0047\u2060\u006F\u2060\u003F\u2060\u201D\u2060\u0029\u2060\u0020\u2060\u0028\u2060\u0048\u2060\u0065\u2060\u0020\u2060\u0064\u2060\u0069\u2060\u0064\u2060\u002E\u2060\u0029\u2060\u2060", expected: [][]rune{{0x2060, 0x0028, 0x2060, 0x201C, 0x2060, 0x0047, 0x2060, 0x006F, 0x2060, 0x003F, 0x2060, 0x201D, 0x2060, 0x0029, 0x2060, 0x0020, 0x2060}, {0x0028, 0x2060, 0x0048, 0x2060, 0x0065, 0x2060, 0x0020, 0x2060, 0x0064, 0x2060, 0x0069, 0x2060, 0x0064, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2060}}}, // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LEFT DOUBLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER G (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER O (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] QUESTION MARK (STerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT DOUBLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0055\u2060\u002E\u2060\u0053\u2060\u002E\u2060\u0041\u2060\u0300\u002E\u2060\u0020\u2060\u0069\u2060\u0073\u2060\u2060", expected: [][]rune{{0x2060, 0x0055, 0x2060, 0x002E, 0x2060, 0x0053, 0x2060, 0x002E, 0x2060, 0x0041, 0x2060, 0x0300, 0x002E, 0x2060, 0x0020, 0x2060, 0x0069, 0x2060, 0x0073, 0x2060, 0x2060}}},                                                                                                                                                                                                                     // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0055\u2060\u002E\u2060\u0053\u2060\u002E\u2060\u0041\u2060\u0300\u003F\u2060\u0020\u2060\u0048\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0055, 0x2060, 0x002E, 0x2060, 0x0053, 0x2060, 0x002E, 0x2060, 0x0041, 0x2060, 0x0300, 0x003F, 0x2060, 0x0020, 0x2060}, {0x0048, 0x2060, 0x0065, 0x2060, 0x2060}}},                                                                                                                                                                                                                   // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] QUESTION MARK (STerm) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0055\u2060\u002E\u2060\u0053\u2060\u002E\u2060\u0041\u2060\u0300\u002E\u2060\u2060", expected: [][]rune{{0x2060, 0x0055, 0x2060, 0x002E, 0x2060, 0x0053, 0x2060, 0x002E, 0x2060, 0x0041, 0x2060, 0x0300, 0x002E, 0x2060, 0x2060}}},                                                                                                                                                                                                                                                                                                         // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0033\u2060\u002E\u2060\u0034\u2060\u2060", expected: [][]rune{{0x2060, 0x0033, 0x2060, 0x002E, 0x2060, 0x0034, 0x2060, 0x2060}}},                                                                                                                                                                                                                                                               // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] DIGIT THREE (Numeric) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [6.0] DIGIT FOUR (Numeric) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0063\u2060\u002E\u2060\u0064\u2060\u2060", expected: [][]rune{{0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0064, 0x2060, 0x2060}}},                                                                                                                                                                                                                                                               // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0043\u2060\u002E\u2060\u0064\u2060\u2060", expected: [][]rune{{0x2060, 0x0043, 0x2060, 0x002E, 0x2060, 0x0064, 0x2060, 0x2060}}},                                                                                                                                                                                                                                                               // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER C (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0063\u2060\u002E\u2060\u0044\u2060\u2060", expected: [][]rune{{0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0044, 0x2060, 0x2060}}},                                                                                                                                                                                                                                                               // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER D (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0043\u2060\u002E\u2060\u0044\u2060\u2060", expected: [][]rune{{0x2060, 0x0043, 0x2060, 0x002E, 0x2060, 0x0044, 0x2060, 0x2060}}},                                                                                                                                                                                                                                                               // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER C (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER D (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u2019\u2060\u00A0\u2060\u0074\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2019, 0x2060, 0x00A0, 0x2060, 0x0074, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}},                                                           // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u2019\u2060\u00A0\u2060\u0054\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2019, 0x2060, 0x00A0, 0x2060}, {0x0054, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}},                                                         // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u2019\u2060\u00A0\u2060\u2018\u2060\u0028\u2060\u0074\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2019, 0x2060, 0x00A0, 0x2060, 0x2018, 0x2060, 0x0028, 0x2060, 0x0074, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}},   // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LEFT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u2019\u2060\u00A0\u2060\u2018\u2060\u0028\u2060\u0054\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2019, 0x2060, 0x00A0, 0x2060}, {0x2018, 0x2060, 0x0028, 0x2060, 0x0054, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}}, // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LEFT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u2019\u2060\u00A0\u2060\u0308\u0074\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2019, 0x2060, 0x00A0, 0x2060, 0x0308, 0x0074, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}},                                             // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u2019\u2060\u00A0\u2060\u0308\u0054\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2019, 0x2060, 0x00A0, 0x2060, 0x0308}, {0x0054, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}},                                           // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u2019\u2060\u0308\u0054\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x2019, 0x2060, 0x0308}, {0x0054, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}},                                                                       // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u0029\u2060\u000A\u2060\u0308\u2060\u0054\u2060\u0068\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x0029, 0x2060, 0x000A}, {0x2060, 0x0308, 0x2060, 0x0054, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x2060}}},                                                         // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] <LINE FEED (LF)> (LF) ÷ [4.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0074\u2060\u0068\u2060\u0065\u2060\u0020\u2060\u0072\u2060\u0065\u2060\u0073\u2060\u0070\u2060\u002E\u2060\u0020\u2060\u006C\u2060\u0065\u2060\u0061\u2060\u0064\u2060\u0065\u2060\u0072\u2060\u0073\u2060\u0020\u2060\u0061\u2060\u0072\u2060\u0065\u2060\u2060", expected: [][]rune{{0x2060, 0x0074, 0x2060, 0x0068, 0x2060, 0x0065, 0x2060, 0x0020, 0x2060, 0x0072, 0x2060, 0x0065, 0x2060, 0x0073, 0x2060, 0x0070, 0x2060, 0x002E, 0x2060, 0x0020, 0x2060, 0x006C, 0x2060, 0x0065, 0x2060, 0x0061, 0x2060, 0x0064, 0x2060, 0x0065, 0x2060, 0x0072, 0x2060, 0x0073, 0x2060, 0x0020, 0x2060, 0x0061, 0x2060, 0x0072, 0x2060, 0x0065, 0x2060, 0x2060}}}, // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER P (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER L (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u5B57\u2060\u002E\u2060\u5B57\u2060\u2060", expected: [][]rune{{0x2060, 0x5B57, 0x2060, 0x002E, 0x2060}, {0x5B57, 0x2060, 0x2060}}},                                                         // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u5B83\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060}, {0x5B83, 0x2060, 0x2060}}}, // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0065\u2060\u0074\u2060\u0063\u2060\u002E\u2060\u3002\u2060\u2060", expected: [][]rune{{0x2060, 0x0065, 0x2060, 0x0074, 0x2060, 0x0063, 0x2060, 0x002E, 0x2060, 0x3002, 0x2060, 0x2060}}},   // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.1] IDEOGRAPHIC FULL STOP (STerm) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u5B57\u2060\u3002\u2060\u5B83\u2060\u2060", expected: [][]rune{{0x2060, 0x5B57, 0x2060, 0x3002, 0x2060}, {0x5B83, 0x2060, 0x2060}}},                                                         // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format_FE) × [998.0] IDEOGRAPHIC FULL STOP (STerm) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u2060\u0021\u2060\u0020\u2060\u0020\u2060\u2060", expected: [][]rune{{0x2060, 0x0021, 0x2060, 0x0020, 0x2060, 0x0020, 0x2060, 0x2060}}},                                                           // ÷ [0.2] WORD JOINER (Format_FE) × [998.0] EXCLAMATION MARK (STerm) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [10.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]
}
