/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sc extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "àrabu";
        final String metaValue_hy = "armenu";
        final String metaValue_ban = "balinesu";
        final String metaValue_bn = "bengalesu";
        final String metaValue_bug = "buginesu";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "coptu";
        final String metaValue_ka = "georgianu";
        final String metaValue_el = "grecu";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebràicu";
        final String metaValue_jv = "giavanesu";
        final String metaValue_ja = "giaponesu";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreanu";
        final String metaValue_lo = "laotianu";
        final String metaValue_la = "latinu";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mòngolu";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "odia";
        final String metaValue_osa = "osage";
        final String metaValue_si = "singalesu";
        final String metaValue_su = "sundanesu";
        final String metaValue_syr = "sirìacu";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandesu";
        final String metaValue_bo = "tibetanu";
        final String metaValue_kw = "còrnicu";
        final String metaValue_ssy = "saho";
        final String metaValue_Hans = "semplificadu";
        final Object[][] data = new Object[][] {
            { "001", "Mundu" },
            { "002", "Àfrica" },
            { "003", "Amèrica de su Nord" },
            { "005", "Amèrica de su Sud" },
            { "009", "Otzeània" },
            { "011", "Àfrica otzidentale" },
            { "013", "Amèrica tzentrale" },
            { "014", "Àfrica orientale" },
            { "015", "Àfrica setentrionale" },
            { "017", "Àfrica tzentrale" },
            { "018", "Àfrica meridionale" },
            { "019", "Amèricas" },
            { "021", "Amèrica setentrionale" },
            { "029", "Caràibes" },
            { "030", "Àsia orientale" },
            { "034", "Àsia meridionale" },
            { "035", "Sud-est asiàticu" },
            { "039", "Europa meridionale" },
            { "053", "Australàsia" },
            { "054", "Melanèsia" },
            { "057", "Regione micronesiana" },
            { "061", "Polinèsia" },
            { "142", "Àsia" },
            { "143", "Àsia tzentrale" },
            { "145", "Àsia otzidentale" },
            { "150", "Europa" },
            { "151", "Europa orientale" },
            { "154", "Europa setentrionale" },
            { "155", "Europa otzidentale" },
            { "202", "Àfrica sub-sahariana" },
            { "419", "Amèrica latina" },
            { "AC", "Ìsula de s’Ascensione" },
            { "AD", "Andorra" },
            { "AE", "Emirados Àrabos Unidos" },
            { "AF", "Afghànistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armènia" },
            { "AO", "Angola" },
            { "AQ", "Antàrticu" },
            { "AR", "Argentina" },
            { "AS", "Samoa americanas" },
            { "AT", "Àustria" },
            { "AU", "Austràlia" },
            { "AW", "Aruba" },
            { "AX", "Ìsulas Åland" },
            { "AZ", "Azerbaigiàn" },
            { "BA", "Bòsnia e Erzegòvina" },
            { "BB", "Barbados" },
            { "BD", "Bangladèsh" },
            { "BE", "Bèlgiu" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Santu Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bolìvia" },
            { "BQ", "Caràibes olandesas" },
            { "BR", "Brasile" },
            { "BS", "Bahamas" },
            { "BT", "Bhutàn" },
            { "BV", "Ìsula Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorùssia" },
            { "BZ", "Belize" },
            { "CA", "Cànada" },
            { "CC", "Ìsulas Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Repùblica Tzentrafricana" },
            { "CG", "Congo - Bratzaville" },
            { "CH", "Isvìtzera" },
            { "CI", "Costa de Avòriu" },
            { "CK", "Ìsulas Cook" },
            { "CL", "Tzile" },
            { "CM", "Camerùn" },
            { "CN", "Tzina" },
            { "CO", "Colòmbia" },
            { "CP", "Ìsula de Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabu birde" },
            { "CW", "Curaçao" },
            { "CX", "Ìsula de sa Natividade" },
            { "CY", "Tzipru" },
            { "CZ", "Tzèchia" },
            { "DE", "Germània" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarca" },
            { "DM", "Dominica" },
            { "DO", "Repùblica Dominicana" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ècuador" },
            { "EE", "Estònia" },
            { "EG", "Egitu" },
            { "EH", "Sahara otzidentale" },
            { "ER", "Eritrea" },
            { "ES", "Ispagna" },
            { "ET", "Etiòpia" },
            { "EU", "Unione Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlàndia" },
            { "FJ", "Fiji" },
            { "FK", "Ìsulas Falkland" },
            { "FM", "Micronèsia" },
            { "FO", "Ìsulas Føroyar" },
            { "FR", "Frantza" },
            { "GA", "Gabòn" },
            { "GB", "Regnu Unidu" },
            { "GD", "Grenada" },
            { "GE", "Geòrgia" },
            { "GF", "Guiana frantzesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibilterra" },
            { "GL", "Groenlàndia" },
            { "GM", "Gàmbia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinea Ecuadoriale" },
            { "GR", "Grètzia" },
            { "GS", "Geòrgia de su Sud e Ìsulas Sandwich Australes" },
            { "GT", "Guatemala" },
            { "GU", "Guàm" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "RAS tzinesa de Hong Kong" },
            { "HM", "Ìsulas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croàtzia" },
            { "HT", "Haiti" },
            { "HU", "Ungheria" },
            { "IC", "Ìsulas Canàrias" },
            { "ID", "Indonèsia" },
            { "IE", "Irlanda" },
            { "IL", "Israele" },
            { "IM", "Ìsula de Man" },
            { "IN", "Ìndia" },
            { "IO", "Territòriu Britànnicu de s’Otzèanu Indianu" },
            { "IQ", "Iraq" },
            { "IR", "Iràn" },
            { "IS", "Islanda" },
            { "IT", "Itàlia" },
            { "JE", "Jersey" },
            { "JM", "Giamàica" },
            { "JO", "Giordània" },
            { "JP", "Giapone" },
            { "KE", "Kènya" },
            { "KG", "Kirghìzistan" },
            { "KH", "Cambòdia" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "Santu Cristolu e Nevis" },
            { "KP", "Corea de su Nord" },
            { "KR", "Corea de su Sud" },
            { "KW", "Kuwait" },
            { "KY", "Ìsulas Cayman" },
            { "KZ", "Kazàkistan" },
            { "LA", "Laos" },
            { "LB", "Lèbanu" },
            { "LC", "Santa Lughia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Libèria" },
            { "LS", "Lesotho" },
            { "LT", "Lituània" },
            { "LU", "Lussemburgu" },
            { "LV", "Letònia" },
            { "LY", "Lìbia" },
            { "MA", "Marocu" },
            { "MC", "Mònacu" },
            { "MD", "Moldàvia" },
            { "ME", "Montenegro" },
            { "MF", "Santu Martine" },
            { "MG", "Madagascàr" },
            { "MH", "Ìsulas Marshall" },
            { "MK", "Matzedònia de su Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmàr (Birmània)" },
            { "MN", "Mongòlia" },
            { "MO", "RAS tzinesa de Macao" },
            { "MP", "Ìsulas Mariannas setentrionales" },
            { "MQ", "Martinica" },
            { "MR", "Mauritània" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurìtzius" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "Mèssicu" },
            { "MY", "Malèsia" },
            { "MZ", "Mozambicu" },
            { "NA", "Namìbia" },
            { "NC", "Caledònia Noa" },
            { "NE", "Niger" },
            { "NF", "Ìsula Norfolk" },
            { "NG", "Nigèria" },
            { "NI", "Nicaràgua" },
            { "NL", "Paisos Bassos" },
            { "NO", "Norvègia" },
            { "NP", "Nèpal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Zelanda Noa" },
            { "OM", "Omàn" },
            { "PA", "Pànama" },
            { "PE", "Perù" },
            { "PF", "Polinèsia frantzesa" },
            { "PG", "Pàpua Guinea Noa" },
            { "PH", "Filipinas" },
            { "PK", "Pàkistan" },
            { "PL", "Polònia" },
            { "PM", "Santu Predu e Miquelon" },
            { "PN", "Ìsulas Pìtcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territòrios palestinesos" },
            { "PT", "Portogallu" },
            { "PW", "Palau" },
            { "PY", "Paraguày" },
            { "QA", "Catàr" },
            { "QO", "Otzeània perifèrica" },
            { "RE", "Riunione" },
            { "RO", "Romania" },
            { "RS", "Sèrbia" },
            { "RU", "Rùssia" },
            { "RW", "Ruanda" },
            { "SA", "Aràbia Saudita" },
            { "SB", "Ìsulas Salomone" },
            { "SC", "Seychelles" },
            { "SD", "Sudàn" },
            { "SE", "Isvètzia" },
            { "SG", "Singapore" },
            { "SH", "Santa Elene" },
            { "SI", "Islovènia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Islovàchia" },
            { "SL", "Sierra Leone" },
            { "SM", "Santu Marinu" },
            { "SN", "Senegal" },
            { "SO", "Somàlia" },
            { "SR", "Suriname" },
            { "SS", "Sudan de su Sud" },
            { "ST", "São Tomé e Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Sìria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Ìsulas Turks e Caicos" },
            { "TD", "Chad" },
            { "TF", "Terras australes frantzesas" },
            { "TG", "Togo" },
            { "TH", "Tailàndia" },
            { "TJ", "Tagìkistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Est" },
            { "TM", "Turkmènistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwàn" },
            { "TZ", "Tanzània" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "Ìsulas perifèricas de sos Istados Unidos" },
            { "UN", "Natziones Unidas" },
            { "US", "Istados Unidos" },
            { "UY", "Uruguày" },
            { "UZ", "Uzbèkistan" },
            { "VA", "Tzitade de su Vaticanu" },
            { "VC", "Santu Vissente e sas Grenadinas" },
            { "VE", "Venetzuela" },
            { "VG", "Ìsulas Vèrgines Britànnicas" },
            { "VI", "Ìsulas Vèrgines de sos Istados Unidos" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "psèudo-atzentos" },
            { "XB", "psèudo-bidi" },
            { "XK", "Kòssovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sudàfrica" },
            { "ZM", "Zàmbia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "regione disconnota" },
            { "aa", "afar" },
            { "ab", "abcasu" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amàricu" },
            { "an", "aragonesu" },
            { "ar", metaValue_ar },
            { "as", "assamesu" },
            { "av", "avaru" },
            { "ay", "aimara" },
            { "az", "azerbaigianu" },
            { "ba", "baschiru" },
            { "be", "bielorussu" },
            { "bg", "bùlgaru" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "brètone" },
            { "bs", "bosnìacu" },
            { "ca", "catalanu" },
            { "ce", "cecenu" },
            { "ch", "chamorru" },
            { "co", "corsicanu" },
            { "cs", "tzecu" },
            { "cu", "islavu eclesiàsticu" },
            { "cv", "ciuvàsciu" },
            { "cy", "gallesu" },
            { "da", "danesu" },
            { "de", "tedescu" },
            { "dv", "malvidianu" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "inglesu" },
            { "eo", "esperanto" },
            { "es", "ispagnolu" },
            { "et", "èstone" },
            { "eu", "bascu" },
            { "fa", "persianu" },
            { "ff", "fulah" },
            { "fi", "finlandesu" },
            { "fj", "fijianu" },
            { "fo", "faroesu" },
            { "fr", "frantzesu" },
            { "fy", "frisone otzidentale" },
            { "ga", "irlandesu" },
            { "gd", "gaèlicu iscotzesu" },
            { "gl", "galitzianu" },
            { "gn", "guaranì" },
            { "gu", metaValue_gu },
            { "gv", "mannesu" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hr", "croatu" },
            { "ht", "crèolu haitianu" },
            { "hu", "ungheresu" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlìngua" },
            { "id", "indonesianu" },
            { "ie", "interlìngue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "io", "ido" },
            { "is", "islandesu" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazacu" },
            { "kl", "groenlandesu" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "curmangi" },
            { "kv", "komi" },
            { "kw", metaValue_kw },
            { "ky", "chirghisu" },
            { "la", metaValue_la },
            { "lb", "lussemburghesu" },
            { "lg", "ganda" },
            { "li", "limburghesu" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "lètone" },
            { "mg", "malgàsciu" },
            { "mh", "marshallesu" },
            { "mi", "maori" },
            { "mk", "matzèdone" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malesu" },
            { "mt", "maltesu" },
            { "my", "burmesu" },
            { "na", "nauru" },
            { "nb", "norvegesu bokmål" },
            { "nd", "ndebele de su nord" },
            { "ne", "nepalesu" },
            { "ng", "ndonga" },
            { "nl", "olandesu" },
            { "nn", "norvegesu nynorsk" },
            { "no", "norvegesu" },
            { "nr", "ndebele de su sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "otzitanu" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossèticu" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polacu" },
            { "ps", "pashto" },
            { "pt", "portoghesu" },
            { "qu", "quechua" },
            { "rm", "romànciu" },
            { "rn", "rundi" },
            { "ro", "rumenu" },
            { "ru", "russu" },
            { "rw", "kinyarwanda" },
            { "sa", "sànscritu" },
            { "sc", "sardu" },
            { "sd", "sindhi" },
            { "se", "sami setentrionale" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "islovacu" },
            { "sl", "islovenu" },
            { "sm", "samoanu" },
            { "sn", "shona" },
            { "so", "sòmalu" },
            { "sq", "albanesu" },
            { "sr", "serbu" },
            { "ss", "swati" },
            { "st", "sotho meridionale" },
            { "su", metaValue_su },
            { "sv", "isvedesu" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tagicu" },
            { "th", metaValue_th },
            { "ti", "tigrignu" },
            { "tk", "turcmenu" },
            { "tn", "tswana" },
            { "to", "tonganu" },
            { "tr", "turcu" },
            { "ts", "tsonga" },
            { "tt", "tàtaru" },
            { "ty", "taitianu" },
            { "ug", "uiguru" },
            { "uk", "ucrainu" },
            { "ur", "urdu" },
            { "uz", "uzbecu" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapük" },
            { "wa", "vallonu" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "tzinesu" },
            { "zu", "zulu" },
            { "ace", "acehnesu" },
            { "ada", "adangme" },
            { "ady", "adighè" },
            { "agq", "aghem" },
            { "ain", "àinu" },
            { "ale", "aleutinu" },
            { "alt", "altai meridionale" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "àrabu levantinu" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "ars", "àrabu najdi" },
            { "asa", "asu" },
            { "ast", "asturianu" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "baluci" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bgc", "haryanvi" },
            { "bgn", "baluci otzidentale" },
            { "bho", "bhojpuri" },
            { "bin", "bini" },
            { "bla", "pees nieddos" },
            { "blo", "anii" },
            { "blt", "tai dam" },
            { "bqi", "bakhtiari" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", metaValue_bug },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuanu" },
            { "cgg", "chiga" },
            { "chk", "chuukesu" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "cic", "chickasaw" },
            { "ckb", "curdu tzentrale" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crj", "cree sud-orientale" },
            { "crk", "cree de sas campuras" },
            { "crl", "cree nord-orientale" },
            { "crm", "cree moose" },
            { "crr", "algonchinu de sa Carolina" },
            { "csw", "cree de sas paludes" },
            { "dak", "dakota" },
            { "dar", "dargua" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "sòrabu bassu" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipinu" },
            { "fon", "fon" },
            { "frc", "frantzesu cajun" },
            { "frr", "frisone setentrionale" },
            { "fur", "friulanu" },
            { "gaa", "ga" },
            { "gez", "ge’ez" },
            { "gil", "gilbertesu" },
            { "gor", "gorontalo" },
            { "gsw", "tedescu isvìtzeru" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "haw", "hawaianu" },
            { "hax", "haida meridionale" },
            { "hil", "ilongu" },
            { "hmn", "hmong" },
            { "hnj", "hmong njua" },
            { "hsb", "sòrabu artu" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadesu otzidentale" },
            { "ilo", "ilocanu" },
            { "inh", "ingùsciu" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kaa", "kara-kalpak" },
            { "kab", "cabilu" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "cabardianu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "cabubirdianu" },
            { "kek", "qʼeqchiʼ" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "krc", "caraciai-balcaru" },
            { "krl", "carelianu" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "coloniesu" },
            { "kum", "cumucu" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "giudeu-ispagnolu" },
            { "lag", "langi" },
            { "lez", "lezghianu" },
            { "lij", "lìgure" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lld", "ladinu" },
            { "lmo", "lombardu" },
            { "lou", "crèolu de sa Louisiana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrionale" },
            { "lsm", "sàmia" },
            { "ltg", "latgalianu" },
            { "lua", "tshiluba" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "lzz", "laz" },
            { "mad", "maduresu" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makassaresu" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "crèolu mauritzianu" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mhn", "mòchenu" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "moore" },
            { "mua", "mundang" },
            { "mul", "limbas mùltiplas" },
            { "mus", "muscogee" },
            { "mwl", "mirandesu" },
            { "mww", "hmong daw" },
            { "myv", "erzya" },
            { "mzn", "mazandarani" },
            { "nan", "min nan" },
            { "nap", "napoletanu" },
            { "naq", "nama" },
            { "nds", "tedescu bassu" },
            { "new", "nepal bhasa" },
            { "nia", "nias" },
            { "niu", "niueanu" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho setentrionale" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwa nord-otzidentale" },
            { "ojc", "ojibwa tzentrale" },
            { "ojs", "oji-Cree" },
            { "ojw", "ojibwa otzidentale" },
            { "oka", "okanagan" },
            { "osa", metaValue_osa },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiamentu" },
            { "pau", "palauanu" },
            { "pcm", "pidgin nigerianu" },
            { "pis", "pijin" },
            { "pms", "piemontesu" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prussianu" },
            { "quc", "k’iche’" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonganu" },
            { "rhg", "rohingya" },
            { "rif", "rifenu" },
            { "rof", "rombo" },
            { "rup", "arumenu" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakut" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sitzilianu" },
            { "sco", "scots" },
            { "sdh", "curdu meridionale" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "sgs", "samogitianu" },
            { "shi", "tashelhit" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "skr", "saraiki" },
            { "slh", "lushootseed meridionale" },
            { "sma", "sami meridionale" },
            { "smj", "sami de Lule" },
            { "smn", "sami de sos inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "srn", "sranan tongo" },
            { "ssy", metaValue_ssy },
            { "str", "salish de sas astrinturas" },
            { "suk", "sukuma" },
            { "suz", "sunwar" },
            { "swb", "comorianu" },
            { "syr", metaValue_syr },
            { "szl", "silesianu" },
            { "tce", "tutchone meridionale" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigrè" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "trw", "torwali" },
            { "ttm", "tutchone setentrionale" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvanu" },
            { "tzm", "tamazight de s’Atlànte tzentrale" },
            { "udm", "udmurtu" },
            { "umb", "umbundu" },
            { "und", "limba disconnota" },
            { "vec", "vènetu" },
            { "vmw", "macua" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "calmucu" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonesu" },
            { "zgh", "tamazight istandard marochinu" },
            { "zun", "zuni" },
            { "zxx", "perunu cuntenutu linguìsticu" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Aghb", "albanesu caucàsicu" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaʿlīq" },
            { "Armi", "aramàicu imperiale" },
            { "Armn", metaValue_hy },
            { "Avst", "avèsticu" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhaiksuki" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "sillabàriu aborìgenu canadesu unificadu" },
            { "Cari", "carian" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "coràsmiu" },
            { "Copt", metaValue_cop },
            { "Cpmn", "tzipro-minòicu" },
            { "Cprt", "tzipriotu" },
            { "Cyrl", "tzirìllicu" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogra" },
            { "Dsrt", "deseret" },
            { "Dupl", "istenografia duployan" },
            { "Egyp", "geroglìficos egitzianos" },
            { "Elba", "elbasan" },
            { "Elym", "elimàicu" },
            { "Ethi", "etìope" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolìticu" },
            { "Gong", "gunjala gondi" },
            { "Gonm", "gondi de Masaram" },
            { "Goth", "gòticu" },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han cun bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", metaValue_Hans },
            { "Hant", "traditzionale" },
            { "Hatr", "hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "geroglìficos anatòlicos" },
            { "Hmng", "pahawn hmong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "sillabàrios giaponesos" },
            { "Hung", "ungheresu antigu" },
            { "Ital", "itàlicu antigu" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Kawi", "kawi" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Kits", "iscritura khitan minore" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineare A" },
            { "Linb", "lineare B" },
            { "Lisu", "lisu" },
            { "Lyci", "lìtziu" },
            { "Lydi", "lìdiu" },
            { "Mahj", "mahajani" },
            { "Maka", "makasar" },
            { "Mand", "mandàicu" },
            { "Mani", "manicheu" },
            { "Marc", "marchen" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "corsivu meroìticu" },
            { "Mero", "meroìticu" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "mro" },
            { "Mtei", "meitei mayek" },
            { "Mult", "multani" },
            { "Mymr", "birmanu" },
            { "Nagm", "nag mundari" },
            { "Nand", "nandinagari" },
            { "Narb", "àrabu setentrionale antigu" },
            { "Nbat", "nabateu" },
            { "Newa", "newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nüshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "osmanya" },
            { "Ougr", "uiguru antigu" },
            { "Palm", "palmirenu" },
            { "Pauc", "pau cin hau" },
            { "Perm", "pèrmicu antigu" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavi de sas iscritziones" },
            { "Phlp", "psalter pahlavi" },
            { "Phnx", "fenìtziu" },
            { "Plrd", "pollard miao" },
            { "Prti", "pàrticu de sas iscritziones" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi rohingya" },
            { "Runr", "rùnicu" },
            { "Samr", "samaritanu" },
            { "Sarb", "àrabu meridionale antigu" },
            { "Saur", "saurashtra" },
            { "Sgnw", "limba de sos sinnos" },
            { "Shaw", "shavianu" },
            { "Shrd", "sharada" },
            { "Sidd", "siddham" },
            { "Sind", "khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "sogdianu" },
            { "Sogo", "sogdianu antigu" },
            { "Sora", "sora sompeng" },
            { "Soyo", "soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue nou" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalog" },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", "ugarìticu" },
            { "Vaii", "vai" },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancho" },
            { "Xpeo", "persianu antigu" },
            { "Xsux", "cuneiforme sumero-acàdicu" },
            { "Yezi", "yezidi" },
            { "Yiii", "yi" },
            { "Zanb", "zanabar cuadradu" },
            { "Zinh", "eredadu" },
            { "Zmth", "notatzione matemàtica" },
            { "Zsye", "emoji" },
            { "Zsym", "sìmbulos" },
            { "Zxxx", "no iscritu" },
            { "Zyyy", "comune" },
            { "Zzzz", "iscritura disconnota" },
            { "de_AT", "tedescu austrìacu" },
            { "de_CH", "tedescu artu isvìtzeru" },
            { "en_AU", "inglesu australianu" },
            { "en_CA", "inglesu canadesu" },
            { "en_GB", "inglesu britànnicu" },
            { "en_US", "inglesu americanu" },
            { "es_ES", "ispagnolu europeu" },
            { "es_MX", "ispagnolu messicanu" },
            { "fa_AF", "dari" },
            { "fr_CA", "frantzesu canadesu" },
            { "fr_CH", "frantzesu isvìtzeru" },
            { "nl_BE", "fiammingu" },
            { "pt_BR", "portoghesu brasilianu" },
            { "pt_PT", "portoghesu europeu" },
            { "ro_MD", "moldavu" },
            { "sw_CD", "swahili de su Congo" },
            { "%%1901", "ortografia traditzionale tedesca" },
            { "%%1994", "ortografia resiana istandardizada" },
            { "%%1996", "ortografia tedesca de su 1996" },
            { "ar_001", "àrabu modernu istandard" },
            { "es_419", "ispagnolu latinoamericanu" },
            { "key.ca", "calendàriu" },
            { "key.cf", "formadu de valuta" },
            { "key.co", "ordinamentu" },
            { "key.cu", "valuta" },
            { "key.em", "presentatzione emoji" },
            { "key.hc", "sistema oràriu (12 o 24 oras)" },
            { "key.lb", "casta de truncadura de lìnia" },
            { "key.lw", "truncaduras de lìnia a intro de sas paràulas" },
            { "key.ms", "sistema de medida" },
            { "key.nu", "nùmeros" },
            { "key.ss", "truncadura de fràsia a pustis de incurtz." },
            { "nds_NL", "sàssone bassu" },
            { "%%ALUKU", "dialetu aluku" },
            { "%%BARLA", "grupu dialetale barlavento de su cabubirdianu" },
            { "%%BISKE", "dialetu de Santu Giorghi/Bila" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", metaValue_kw },
            { "%%GALLO", "gallu" },
            { "%%JAUER", "dialetu jauer" },
            { "%%KKCOR", "ortografia comuna" },
            { "%%KSCOR", "ortografia istandard" },
            { "%%LIPAW", "su dialetu lipovaz de su resianu" },
            { "%%NEDIS", "dialetu de Natisone" },
            { "%%NJIVA", "dialetu de Gniva/Njiva" },
            { "%%NULIK", "volapük modernu" },
            { "%%OSOJS", "dialetu de Oseacco/Osojane" },
            { "%%PEANO", "interlingua de peano" },
            { "%%POSIX", "informàticu" },
            { "%%PUTER", "puter" },
            { "%%RIGIK", "volapük clàssicu" },
            { "%%ROZAJ", "resianu" },
            { "%%RUMGR", "istandard de sos Grisones" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialetu de Stolvizza/Solbica" },
            { "%%SOTAV", "grupu dialetale sotavento de su cabubirdianu" },
            { "%%UCCOR", "ortografia unificada" },
            { "hi_Latn", "hindi (caràteres latinos)" },
            { "zh_Hans", "tzinesu semplificadu" },
            { "zh_Hant", "tzinesu traditzionale" },
            { "%%AO1990", "acordu ortogràficu de sa limba portoghesa de su 1990" },
            { "%%ARANES", "aranesu" },
            { "%%ASANTE", "asante" },
            { "%%AUVERN", "auvernesu" },
            { "%%CISAUP", "cisalpinu" },
            { "%%CREISS", "creschente" },
            { "%%DAJNKO", "alfabetu Dajnko" },
            { "%%EKAVSK", "serbu cun pronùntzia ekaviana" },
            { "%%FONIPA", "alfabetu fonèticu internatzionale IPA" },
            { "%%FONUPA", "alfabetu fonèticu uràlicu UPA" },
            { "%%GASCON", "gasconu" },
            { "%%GRITAL", "ortografia otzitana italianizada" },
            { "%%NDYUKA", "dialetu ndyuka" },
            { "%%NICARD", "nitzardu" },
            { "%%PAMAKA", "dialetu pamaka" },
            { "%%PINYIN", "romanizatzione pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%SIMPLE", metaValue_Hans },
            { "%%TARASK", "ortografia taraškievica" },
            { "%%UCRCOR", "ortografia revisionada unificada" },
            { "%%ULSTER", "ortografia de s’Ulster" },
            { "%%UNIFON", "alfabetu fonèticu Unifon" },
            { "%%ABL1943", "formulatzione ortogràfica de su 1943" },
            { "%%AKUAPEM", "akuapem" },
            { "%%ALALC97", "romanizatzione de ALA-LC, versione de su 1997" },
            { "%%ARKAIKA", "esperanto arcàicu" },
            { "%%BALANKA", "dialetu balanka de s’anii" },
            { "%%BAUDDHA", "variante ìbrida buddhista" },
            { "%%BOHORIC", "alfabetu Bohorič" },
            { "%%EMODENG", "primu inglesu modernu" },
            { "%%FONNAPA", "alfabetu fonèticu de s’Amèrica setentrionale" },
            { "%%GRCLASS", "ortografia otzitana clàssica" },
            { "%%GRMISTR", "ortografia otzitana mistraliana" },
            { "%%HEPBURN", "romanizatzione Hepburn" },
            { "%%ITIHASA", "variante èpica induista" },
            { "%%LAUKIKA", "variante clàssica" },
            { "%%LEMOSIN", "limosinu" },
            { "%%LTG1929", "ortografia de sa limba latgaliana de su 1929" },
            { "%%LTG2007", "ortografia de sa limba latgaliana de su 2007" },
            { "%%METELKO", "alfabetu Metelko" },
            { "%%MONOTON", "monotònicu" },
            { "%%PAHAWH2", "ortografia reduida pahawh hmong fase 2" },
            { "%%PAHAWH3", "ortografia reduida pahawh hmong fase 3" },
            { "%%PAHAWH4", "ortografia reduida pahawh hmong fase 4" },
            { "%%POLYTON", "politònicu" },
            { "%%PROVENC", "proventzale" },
            { "%%REVISED", "ortografia revisionada" },
            { "%%SURSILV", "sursilvanu" },
            { "%%SUTSILV", "sutsilvanu" },
            { "%%VAIDIKA", "variante vèdica" },
            { "%%1606NICT", "frantzesu mèdiu-tardu finas a su 1606" },
            { "%%1694ACAD", "primu frantzesu modernu" },
            { "%%1959ACAD", "acadèmicu" },
            { "%%BAKU1926", "alfabetu latinu turcu unificadu" },
            { "%%BASICENG", "inglesu bàsicu" },
            { "%%BISCAYAN", "bizcaianu" },
            { "%%BORNHOLM", "bornholmesu" },
            { "%%COLB1945", "cunventzione ortogràfica portoghesa-brasiliana de su 1945" },
            { "%%FONKIRSH", "alfabetu fonèticu de Kirshenbaum" },
            { "%%FONXSAMP", "alfabetu fonèticu X-SAMPA" },
            { "%%HOGNORSK", "variante de norvegesu artu (høgnorsk)" },
            { "%%HSISTEMO", "sistema ortogràficu H de s’esperanto" },
            { "%%IJEKAVSK", "serbu cun pronùntzia ijekaviana" },
            { "%%IVANCHOV", "ortografia bùlgara de Ivanchov de su 1899" },
            { "%%JYUTPING", "romanizatzione jyutping" },
            { "%%KOCIEWIE", "variante kochieviana" },
            { "%%LENGADOC", "languedocianu" },
            { "%%LUNA1918", "ortografia russa riformada de su 1918" },
            { "%%NEWFOUND", "inglesu de Terranova" },
            { "%%OXENDICT", "ortografia inglesa de su ditzionàriu de Oxford" },
            { "%%PETR1708", "ortografia de Perdu I de su 1708" },
            { "%%SCOTLAND", "inglesu istandard iscotzesu" },
            { "%%SPANGLIS", "spanglish" },
            { "%%SURMIRAN", "surmiranu" },
            { "%%SYNNEJYL", "jutlandesu meridionale" },
            { "%%TONGYONG", "romanizatzione pinyin tongyong" },
            { "%%TUNUMIIT", "groenlandesu orientale" },
            { "%%VALENCIA", "valentzianu" },
            { "%%VALLADER", "vallader" },
            { "%%VECDRUKA", "ortografia lètone vecā druka" },
            { "%%VIVARAUP", "vivaro-alpinu" },
            { "%%WADEGILE", "romanizatzione Wale-Giles" },
            { "%%XSISTEMO", "sistema ortogràficu X de s’esperanto" },
            { "type.ca.roc", "calendàriu minguo" },
            { "type.co.eor", "règulas de ordinamentu europeas" },
            { "type.hc.h11", "sistema oràriu a 12 oras (0–11)" },
            { "type.hc.h12", "sistema oràriu a 12 oras (1–12)" },
            { "type.hc.h23", "sistema oràriu a 24 oras (0–23)" },
            { "type.hc.h24", "sistema oràriu a 24 oras (1–24)" },
            { "type.nu.ahom", "tzifras ahom" },
            { "type.nu.arab", "tzifras indo-àrabas" },
            { "type.nu.armn", "nùmeros armenos" },
            { "type.nu.bali", "tzifras balinesas" },
            { "type.nu.beng", "tzifras bengalesas" },
            { "type.nu.brah", "tzifras brahmi" },
            { "type.nu.cakm", "tzifras chakma" },
            { "type.nu.cham", "tzifras cham" },
            { "type.nu.cyrl", "tzifras tzirìllicas" },
            { "type.nu.deva", "tzifras devanagari" },
            { "type.nu.diak", "tzifras dhives akuru" },
            { "type.nu.ethi", "nùmeros etìopes" },
            { "type.nu.gara", "tzifras garay" },
            { "type.nu.geor", "nùmeros georgianos" },
            { "type.nu.gong", "tzifras gondi gunjala" },
            { "type.nu.gonm", "tzifras gondi masaram" },
            { "type.nu.grek", "nùmeros grecos" },
            { "type.nu.gujr", "tzifras gujarati" },
            { "type.nu.gukh", "tzifras gurung khema" },
            { "type.nu.guru", "tzifras gurmukhi" },
            { "type.nu.hans", "nùmeros in tzinesu semplificadu" },
            { "type.nu.hant", "nùmeros in tzinesu traditzionale" },
            { "type.nu.hebr", "nùmeros ebràicos" },
            { "type.nu.hmng", "tzifras pahawh hmong" },
            { "type.nu.hmnp", "tzifras nyiakeng puachue hmong" },
            { "type.nu.java", "tzifras giavanesas" },
            { "type.nu.jpan", "nùmeros giaponesos" },
            { "type.nu.kali", "tzifras kayah li" },
            { "type.nu.kawi", "tzifras kawi" },
            { "type.nu.khmr", "tzifras khmer" },
            { "type.nu.knda", "tzifras kannada" },
            { "type.nu.krai", "tzifras kirat rai" },
            { "type.nu.lana", "tzifras tai tham hora" },
            { "type.nu.laoo", "tzifras laotianas" },
            { "type.nu.latn", "tzifras otzidentales" },
            { "type.nu.lepc", "tzifras lepcha" },
            { "type.nu.limb", "tzifras limbu" },
            { "type.nu.mlym", "tzifras malayam" },
            { "type.nu.modi", "tzifras modi" },
            { "type.nu.mong", "tzifras mòngolas" },
            { "type.nu.mroo", "tzifras mro" },
            { "type.nu.mtei", "tzifras meitei mayek" },
            { "type.nu.mymr", "tzifras birmanas" },
            { "type.nu.nagm", "tzifras nag mundari" },
            { "type.nu.nkoo", "tzifras n’ko" },
            { "type.nu.olck", "tzifras ol chiki" },
            { "type.nu.onao", "tzifras ol onal" },
            { "type.nu.orya", "tzifras odia" },
            { "type.nu.osma", "tzifras osmanya" },
            { "type.nu.rohg", "tzifras rohingya hanifi" },
            { "type.nu.saur", "tzifras saurashtra" },
            { "type.nu.shrd", "tzifras sharada" },
            { "type.nu.sind", "tzifras khudawadi" },
            { "type.nu.sinh", "tzifras lith singalesas" },
            { "type.nu.sora", "tzifras sora sompeng" },
            { "type.nu.sund", "tzifras sundanesas" },
            { "type.nu.sunu", "tzifras sunuwar" },
            { "type.nu.takr", "tzifras takri" },
            { "type.nu.talu", "tzifras tai lue noas" },
            { "type.nu.taml", "nùmeros tamil traditzionales" },
            { "type.nu.telu", "tzifras telugu" },
            { "type.nu.thai", "tzifras tailandesas" },
            { "type.nu.tibt", "tzifras tibetanas" },
            { "type.nu.tirh", "tzifras tirhuta" },
            { "type.nu.tnsa", "tzifras tangsa" },
            { "type.nu.tols", "tzifras tolong siki" },
            { "type.nu.vaii", "tzifras vai" },
            { "type.nu.wara", "tzifras warang citi" },
            { "type.nu.wcho", "tzifras wancho" },
            { "type.ca.dangi", "calendàriu dangi" },
            { "type.co.ducet", "ordinamentu Unicode predefinidu" },
            { "type.co.emoji", "ordinamentu de sas emoji" },
            { "type.lb.loose", "truncadura de lìnia facoltativa" },
            { "type.nu.roman", "nùmeros romanos" },
            { "type.ca.coptic", "calendàriu coptu" },
            { "type.ca.hebrew", "calendàriu ebràicu" },
            { "type.ca.indian", "calendàriu natzionale indianu" },
            { "type.co.compat", "ordinamentu antepostu, pro cumpatibilidade" },
            { "type.co.pinyin", "ordinamentu pinyin" },
            { "type.co.search", "chirca genèrica" },
            { "type.co.stroke", "òrdine de sos tratos" },
            { "type.co.unihan", "ordinamentu in base a sos radicales" },
            { "type.co.zhuyin", "ordinamentu zhuyin" },
            { "type.lb.normal", "truncadura de lìnia normale" },
            { "type.lb.strict", "truncadura de lìnia fortzada" },
            { "type.ms.metric", "sistema mètricu" },
            { "type.ca.chinese", "calendàriu tzinesu" },
            { "type.ca.islamic", "calendàriu egirianu" },
            { "type.ca.iso8601", "calendàriu ISO-8601" },
            { "type.ca.persian", "calendàriu persianu" },
            { "type.cf.account", "formadu de valuta contàbile" },
            { "type.nu.arabext", "tzifras indo-àrabas estèndidas" },
            { "type.nu.armnlow", "nùmeros armenos minùscolos" },
            { "type.nu.greklow", "nùmeros grecos minùscolos" },
            { "type.nu.hanidec", "nùmeros detzimales tzinesos" },
            { "type.nu.hansfin", "nùmeros finantziàrios in tzinesu semplificadu" },
            { "type.nu.hantfin", "nùmeros finantziàrios in tzinesu traditzionale" },
            { "type.nu.jpanfin", "nùmeros finantziàrios giaponesos" },
            { "type.nu.mathdbl", "tzifras matemàticas a tràtu dòpiu" },
            { "type.nu.mymrpao", "tzifras birmanas pao" },
            { "type.nu.tamldec", "tzifras tamil" },
            { "type.ca.buddhist", "calendàriu buddhista" },
            { "type.ca.ethiopic", "calendàriu etìope" },
            { "type.ca.japanese", "calendàriu giaponesu" },
            { "type.cf.standard", "formadu de valuta istandard" },
            { "type.co.searchjl", "chirca pro consonante hangul initziale" },
            { "type.co.standard", "ordinamentu istandard" },
            { "type.ms.uksystem", "sistema imperiale britànnicu" },
            { "type.ms.ussystem", "sistema consuetudinàriu americanu" },
            { "type.nu.fullwide", "tzifras a largària intrea" },
            { "type.nu.lanatham", "tzifras tai tham tham" },
            { "type.nu.mathbold", "tzifras matemàticas in grussitu" },
            { "type.nu.mathmono", "tzifras matemàticas a ispàtziu sìngulu" },
            { "type.nu.mathsanb", "tzifras matemàticas in grussitu chene gràtzias" },
            { "type.nu.mathsans", "tzifras matemàticas chene gràtzias" },
            { "type.nu.mymrepka", "tzifras birmanas de su pwo karen orientale" },
            { "type.nu.mymrshan", "tzifras shan birmanas" },
            { "type.nu.mymrtlng", "tzifras tai lang birmanas" },
            { "type.nu.outlined", "tzifras deliniadas" },
            { "type.nu.romanlow", "nùmeros romanos minùscolos" },
            { "type.ca.gregorian", "calendàriu gregorianu" },
            { "type.co.phonebook", "ordinamentu de s’elencu telefònicu" },
            { "type.co.dictionary", "ordinamentu de su ditzionàriu" },
            { "type.co.traditional", "ordinamentu traditzionale" },
            { "type.ca.islamic-rgsa", "calendàriu islàmicu (Aràbia Saudita, osservatzione)" },
            { "type.ca.islamic-tbla", "calendàriu islàmicu (tabulare, època astronòmica)" },
            { "type.ca.islamic-civil", "calendàriu egirianu (tabulare, època tzivile)" },
            { "type.ca.islamic-umalqura", "calendàriu egirianu (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendàriu etìope Amete Alem" },
        };
        return data;
    }
}
