# Licensed to Elasticsearch B.V. under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Elasticsearch B.V. licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# frozen_string_literal: true

module ElasticAPMExample
  GAMES = [
    { 'id' => 1, 'game_title' => 'Halo: Combat Evolved', 'release_date' => '2003-09-30', 'platform' => 1, 'overview' => "In Halo's twenty-sixth century setting, the player assumes the role of the Master Chief, a cybernetically enhanced super-soldier. The player is accompanied by Cortana, an artificial intelligence who occupies the Master Chief's neural interface. Players battle various aliens on foot and in vehicles as they attempt to uncover the secrets of the eponymous Halo, a ring-shaped artificial planet.", 'youtube' => 'dR3Hm8scbEw', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1389, 3423], 'genres' => [1, 8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 2, 'game_title' => 'Crysis', 'release_date' => '2007-11-13', 'platform' => 1, 'overview' => "From the makers of Far Cry, Crysis offers FPS fans the best-looking, most highly-evolving gameplay, requiring the player to use adaptive tactics and total customization of weapons and armor to survive in dynamic, hostile environments including Zero-G. \r\n\r\nEarth, 2019. A team of US scientists makes a frightening discovery on an island in the South China Sea. All contact with the team is lost when the North Korean Government quickly seals off the area. The United States responds by dispatching an elite team of Delta Force Operators to recon the situation. As tension rises between the two nations, a massive alien ship reveals itself in the middle of the island. The ship generates an immense force sphere that freezes a vast portion of the island and drastically alters the global weather system. Now the US and North Korea must join forces to battle the alien menace. With hope rapidly fading, you must fight epic battles through tropical jungle, frozen landscapes, and finally into the heart of the alien ship itself for the ultimate Zero G showdown.", 'youtube' => 'i3vO01xQ-DM', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1970], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 4, 'game_title' => 'Star Fox 64', 'release_date' => '1997-06-30', 'platform' => 3, 'overview' => "The Lylat system has been invaded!  Join Fox McCloud and his Star Fox team as they fight to save the galaxy from the clutches of the evil Andross.  Travel to many different 3-D worlds.  Battle the enemy in the air and on the ground and listen in as Fox McCloud interacts with a cast of characters.\r\n\r\nSee how it feels to feel what you see!  The N64 Rumble Pak controller accessory instantly transmits all the bumps and blasts during the action.  It’s a new jolt to your game play experience!\r\n\r\n* Four Players compete simultaneously in Vs. mode!\r\n* Game Pak memory saves the top 10 scores!\r\n* Outstanding cinema scenes tell the Star Fox saga!", 'youtube' => 'jsEcmfPwnHo', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 8], 'publishers' => [3], 'alternates' => ['Lylat Wars (EU)', 'Lylat Wars'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 5, 'game_title' => 'Donkey Kong', 'release_date' => '1982-01-01', 'platform' => 7, 'overview' => "Can you save Mario's girl from the clutches of Donkey Kong? Donkey Kong has kidnapped Mario's girlfriend Pauline and taken her to the top of a construction site. It's up to you to help Mario save Pauline before time runs out. But it won't be easy. Donkey Kong will do everything in his power to stop you. He'll throw barrel bombs, flaming fireballs and anything else he can get his hands on. So if you're looking for action, don't monkey around. Get the original Donkey Kong from the Nintendo Arcade Classics Series!", 'youtube' => 'C_PrG8P5W8o', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6037], 'genres' => [1], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 6, 'game_title' => 'Tapper', 'release_date' => '1983-01-01', 'platform' => 23, 'overview' => "The Tapper game screen features four bars. Patrons arrive periodically at the end of the bar opposite the player and demand drinks. The player must draw and serve drinks to the patrons as they slowly advance towards the player. If any customers reach the player's end of the bar, they impatiently grab the player-as-bartender and toss him out the far end of the bar, costing the player a life.[6]\r\n\r\nThe player serves customers by filling a mug at one of the four taps. Once the mug is full, the player releases the tap which automatically slides the mug towards the advancing customer. Customers catch mugs that are slid towards them, as long as they are not already drinking a beer, or otherwise distracted. If a mug is not caught by a customer (whether the customer is already drinking or distracted, or if there is no customer), then it falls off the bar on the other end, resulting in a loss of a life for the player. If a customer does catch the mug, though, then he or she is pushed back some amount towards the opposite end of the screen. The goal is to push the customer completely off the screen, but if they are not then they will stay and consume their drink in place. When a customer finishes his drink, he slides the empty mug back towards the player, after which the customer resumes his advance on the player. The player must collect the empty mugs before they reach the end of the bar and fall to the ground, as a mug falling to the ground costs a life.\r\n\r\nPeriodically, customers will leave tips on the bar for the player. These tips can be left at any place on the bar. The tip will appear after a specific number of empty mugs are released by the customers, and will appear wherever the customer who releases the required mug is standing. For example, in all levels, the first tip is left by the customer who returns the second empty mug, and will be left beside wherever this customer is standing. By collecting the tip, the player earns extra points and initiates \"entertainment\" for that level (dancing girls on the wild-west level, cheerleaders on the sports level, etc.). While the entertainment is active, some fraction of the customers will be distracted and stop advancing towards the player, but they will also stop catching mugs.\r\n\r\nTo complete a level the player must clear the entire bar of customers. Once this is done, the player is presented with a short vignette in which the bartender draws a drink for himself, drinks it, then tosses the empty mug into the air with varying (usually humorous) results, such as kicking it and shattering it or having the mug fall atop his head and cover it.\r\n\r\nAs the game progresses, the customers appear more frequently, move faster along the bar, and are pushed back shorter distances when they catch their drinks. In addition, the maximum number of customers per bar gradually increases until every bar can have up to four customers at a time.\r\n\r\nIn between levels of different settings, the player is presented with a shell game-type round. In this segue, the player is presented with a single bar that has six cans of beer or root beer sitting on top of it. A masked villain shakes every can except one and then pounds on the bar, causing the cans to shuffle their positions. If any other shaken can is picked, it explodes in the bartender/soda jerk's face, after which the right can is revealed. If the player selects the unshaken can, the hero is shown smiling and a message reads \"This Bud's For You\" (on the Budweiser version) or \"This one's for you\" (on Root Beer Tapper), and the player is rewarded with extra points.\r\n\r\nThere are four settings for the game, each setting lasting for two to four levels. The settings of the game are:\r\n\r\n-  A western bar with cowboys (2 levels)\r\n-  A sports bar with athletes (3 levels)\r\n-  A punk rock bar with punk rockers (4 levels)\r\n-  A space bar with aliens (4 levels)\r\n\r\nAfter completing all the levels, 13 in all, the player starts at the first again, harder than the first time through, and with some minor variations.", 'youtube' => 'dqrRKStaN_4', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [5280], 'genres' => [1], 'publishers' => [4], 'alternates' => ['Root Beer Tapper'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 9, 'game_title' => 'Halo 2', 'release_date' => '2007-05-31', 'platform' => 1, 'overview' => 'Halo 2 is the sequel to the highly successful and critically acclaimed Halo®: Combat Evolved. In Halo 2, the saga continues as Master Chief—a genetically enhanced super-soldier—is the only thing standing between the relentless Covenant and the destruction of all humankind.', 'youtube' => 'Zz6FNKawJBc', 'players' => 2, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1389], 'genres' => [1, 8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 10, 'game_title' => 'Ace Combat 6: Fires of Liberation', 'release_date' => '2007-10-23', 'platform' => 15, 'overview' => "Throughout Ace Combat 6, the player must pilot a fighter jet or other aircraft to destroy foes both in the air and on the ground. As an arcade flight game, it simplifies flight controls and gives the player a large amount of bullets, missiles and other weapons, putting them up against a very large amount of enemy forces. In addition to missiles and a vulcan cannon, the player can equip special weapons such as heat-seeking missiles, bombs, rocket launchers, and others. The player can lock on to a number of foes, and assist different tactical squads by switching between their respective HUD readouts.\r\n\r\nThe game includes 4 default multiplayer modes: Battle Royale, Siege Battle, Team Battle, and Co-Op Battle. In Battle Royale, the basic Deathmatch game mode, up to sixteen players shoot each other down to earn the highest points at the time limit. In Team Battle, a basic Team Deathmatch game is created. Points are awarded based on the type of aircraft destroyed. A unique type of multiplayer game, Siege Battle is played with two teams, Attacking and Defending. The Attacking team attempts to destroy the target (usually heavily defended by flak) within the time limit. The Defending team tries to halt their attack. The co-op battle mode consists of two single-player missions without AI that can be played with up to three other players.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5804], 'genres' => [13], 'publishers' => [6], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 11, 'game_title' => 'Army of Two', 'release_date' => '2008-03-06', 'platform' => 15, 'overview' => "Focusing on cooperative strategies, Army of Two's main feature is the necessity to use coordinated teamwork to accomplish the game's goals. While the game is meant to be played with another human as a partner, a \"Partner Artificial Intelligence\" (PAI) is also included and programmed to follow the player's strategies. Dependence on a partner (whether human or PAI) is so pronounced that most objectives are impossible to complete without it.", 'youtube' => '', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [2582], 'genres' => [1, 8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 12, 'game_title' => "Assassin's Creed", 'release_date' => '2008-04-09', 'platform' => 1, 'overview' => "The game centers on the use of a machine named the \"Animus\", which allows the viewing of the protagonist's genetic memories of his ancestors.\r\n\r\nThrough this plot device, details emerge of a struggle between two factions, the Knights Templar and the Assassins (Hashshashin), over an artifact known as a \"Piece of Eden\" and the game primarily takes place during the Third Crusade in the Holy Land in 1191.", 'youtube' => 'cc-ClutaN_I', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9149], 'genres' => [1, 2, 12], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 13, 'game_title' => 'BioShock', 'release_date' => '2007-08-21', 'platform' => 1, 'overview' => 'Set in an alternate history 1960, the game places the player in the role of a plane crash survivor named Jack, who must explore the underwater city of Rapture, and survive attacks by the mutated beings and mechanical drones that populate it. The game incorporates elements found in role-playing and survival games, and is described by the developers and Levine as a "spiritual successor" to their previous titles in the System Shock series.', 'youtube' => 'CoYorK3E4aM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4357], 'genres' => [1, 8], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 14, 'game_title' => 'Dead Space', 'release_date' => '2008-10-14', 'platform' => 1, 'overview' => 'The player takes on the role of an engineer named Isaac Clarke, who battles a polymorphic, virus-like, alien infestation which turns humans into grotesque alien monsters called "Necromorphs", on board a stricken interstellar mining ship named the USG Ishimura.', 'youtube' => 'aE2lPGsvjC4', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9428], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 15, 'game_title' => 'Devil May Cry', 'release_date' => '2001-10-16', 'platform' => 11, 'overview' => "Set in modern times on the fictional Mallet Island, the story centers on the characters Dante and Trish and their quest to confront the demon lord Mundus. The story is told primarily through a mixture of cutscenes, which use the game's engine and several pre-rendered full motion videos.", 'youtube' => 'zZIKeE199Tk', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Devil may cry 1'], 'uids' => [{ 'uid' => 'SLUS-20216', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-74230', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-65038', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 16, 'game_title' => "Devil May Cry 3: Dante's Awakening", 'release_date' => '2005-03-01', 'platform' => 11, 'overview' => "Set in modern times in an enchanted tower named Temen-ni-gru, the story centers on the dysfunctional relationship between Dante and his brother Vergil. The events of the game take place just as Dante has opened up the Devil May Cry agency, and before Dante's demonic heritage has reached its full potential.", 'youtube' => 'Q9UiezHyR8o', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLUS-20964', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-65880', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLES-53038', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 17, 'game_title' => 'Devil May Cry 4', 'release_date' => '2008-02-05', 'platform' => 12, 'overview' => 'In the game, the player controls both Nero and Dante, and fights enemies in close combat using firearms, swords, and other weapons. The characters Lady and Trish from previous games in the series make appearances, along with new characters Nero, Kyrie, Credo, Gloria, and Agnus. The game is set after Devil May Cry but before Devil May Cry 2.', 'youtube' => 'Dp5fobWucds', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1, 4, 18], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 18, 'game_title' => 'Driver: Parallel Lines', 'release_date' => '2007-06-26', 'platform' => 1, 'overview' => 'Diverging from previous Driver games, Parallel Lines takes place in just one city, New York, instead of multiple cities, but in the middle of the story you change to different eras of the city - 1978 and 2006. Due to the underwhelming performance of Driv3r, particularly the often-derided on-foot sections, Parallel Lines returns to the formula used in earlier games in the series, focusing on driving, although shooting remains in the game.', 'youtube' => 'nw1j8zatcEc', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7109], 'genres' => [7], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 19, 'game_title' => 'Final Fantasy X-2', 'release_date' => '2003-11-18', 'platform' => 11, 'overview' => "The game's story follows the character Yuna from Final Fantasy X as she seeks to resolve political conflicts in the fictional world of Spira before it leads to war.\r\n\r\nThe story begins as Yuna, Rikku and Paine recover Yuna's stolen Garment Grid from the Leblanc Syndicate in the first of several encounters in which they vie for spheres. The game is punctuated by a narration of Yuna addressing Tidus, as though she is recounting the events of the game to him as they occur in a style reminiscent of Tidus' own narration in Final Fantasy X. Although Yuna's quest is to find clues that may lead her to Tidus, much of the storyline of the game follows the clash of the factions that have established themselves in the time since the coming of the Eternal Calm in Final Fantasy X, and the uncovering of hidden legacies from Spira's ancient history. A significant portion of the game's events are unnecessary for the completion of the main storyline, but much of the depth of the story—including characterization and background details—are featured in the optional content, which generally follows how each part of Spira is healing in the time since the passing of Sin.", 'youtube' => 'f_T4TF0Id6U', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2808], 'genres' => [4], 'publishers' => [12, 78], 'alternates' => ['ファイナルファンタジーX-2 Fainaru Fantajī Ten Tsū', 'Final Fantasy 10-2', 'FFX-2'], 'uids' => [{ 'uid' => 'SLUS-20672', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPS-25250', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-66125', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 20, 'game_title' => 'Final Fantasy X', 'release_date' => '2001-12-17', 'platform' => 11, 'overview' => "There are seven main playable characters in Final Fantasy X. Tidus is a cheerful young teenager and the star blitzball player for the Zanarkand Abes. He has long resented his father, a renowned blitzball player who disappeared during Tidus's youth. Yuna is the daughter of the High Summoner Braska, who defeated Sin to bring about the Calm, a time of peace. Yuna embarks on a pilgrimage to obtain the final aeon and defeat Sin. Kimahri Ronso is a young warrior of the Ronso tribe who watched over Yuna during her childhood. Wakka is a blitzball player and devout follower of the Yevon order. Lulu is a stoic and self-possessed, but well-meaning Black Mage. Auron is a taciturn former warrior monk, and finally Rikku is a perky Al Bhed girl with extensive knowledge of machinery. The primary antagonists of the game are Maester Seymour Guado and the other maesters of the Yevon religion, while the enormous whale-like monster Sin serves as the primary source of conflict.", 'youtube' => 'tJvGJsXT8Ac', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => ['Final Fantasy 10', 'FFX'], 'uids' => [{ 'uid' => 'SLUS-20312', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-66124', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-66677', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPS-25050', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPS-25088', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SCES-50491', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 21, 'game_title' => 'Final Fantasy XIII', 'release_date' => '2010-03-09', 'platform' => 12, 'overview' => 'Final Fantasy XIII is a console role-playing video game developed and published by Square Enix for the PlayStation 3 and Xbox 360. Released in 2009 in Japan and North America and PAL regions in March 2010, it is the thirteenth major installment in the Final Fantasy series. The game includes fast-paced combat, a new system for the series for determining which abilities are developed for the characters called "Crystarium", and a customizable "Paradigm" system to control which abilities are used by the characters. Final Fantasy XIII includes elements from the previous games in the series, such as summoned monsters, chocobos, and airships.', 'youtube' => 'hDjkGUM7skk', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2808], 'genres' => [4], 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 22, 'game_title' => 'Left 4 Dead', 'release_date' => '2008-11-17', 'platform' => 1, 'overview' => "From Valve (the creators of Counter-Strike, Half-Life and more) comes Left 4 Dead, a co-op action horror game for the PC and Xbox 360 that casts up to four players in an epic struggle for survival against swarming zombie hordes and terrifying mutant monsters.\r\n\r\nSet in the immediate aftermath of the zombie apocalypse, L4D's survival co-op mode lets you blast a path through the infected in four unique “movies,” guiding your survivors across the rooftops of an abandoned metropolis, through rural ghost towns and pitch-black forests in your quest to escape a devastated Ground Zero crawling with infected enemies. Each \"movie\" is comprised of five large maps, and can be played by one to four human players, with an emphasis on team-based strategy and objectives.\r\n\r\nNew technology dubbed \"the AI Director\" is used to generate a unique gameplay experience every time you play. The Director tailors the frequency and ferocity of the zombie attacks to your performance, putting you in the middle of a fast-paced, but not overwhelming, Hollywood horror movie.\r\n\r\nAddictive single player, co-op, and multiplayer action gameplay from the makers of Counter-Strike and Half-Life\r\nVersus Mode lets you compete four-on-four with friends, playing as a human trying to get rescued, or as a zombie boss monster that will stop at nothing to destroy them.\r\nSee how long you and your friends can hold out against the infected horde in the new Survival Mode\r\nAn advanced AI director dynamically creates intense and unique experiences every time the game is played\r\n20 maps, 10 weapons and unlimited possibilities in four sprawling \"movies\"\r\nMatchmaking, stats, rankings, and awards system drive collaborative play\r\nDesigner's Commentary allows gamers to go \"behind the scenes\" of the game\r\nPowered by Source and Steam", 'youtube' => '4_Xz9aJ9yGY?hd=1', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [9289], 'genres' => [8, 18], 'publishers' => [13], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 23, 'game_title' => 'Gears of War', 'release_date' => '2006-11-07', 'platform' => 1, 'overview' => 'The game focuses on the troops of Delta Squad as they fight to save the human inhabitants of the fictional planet Sera from a relentless subterranean enemy known as the Locust Horde. The player assumes the role of Marcus Fenix, a former prisoner and war-hardened soldier. The game is based on the use of cover and strategic fire for the player to advance through the scenarios; a second player can play cooperatively through the main campaign to assist. The game also features several online multiplayer game modes for up to eight players.', 'youtube' => '_D9r8Xm2aDw', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [2833], 'genres' => [8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 24, 'game_title' => 'Gears of War 2', 'release_date' => '2008-11-07', 'platform' => 15, 'overview' => 'In Gears of War 2, The COG continues its fight against the Locust horde, who are attempting to sink all of the cities on the planet Sera by using a big riftworm to eat the ground beneath them. Sergeant Marcus Fenix leads Delta Squad into the depths of the planet to try to stop the worm from eating but instead they discover the true intent of the Locust actions.', 'youtube' => '6yMwniG9NuM', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [2834], 'genres' => [1, 8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 25, 'game_title' => 'God Hand', 'release_date' => '2006-10-10', 'platform' => 11, 'overview' => "THERE AIN'T NO JUSTICE IN THE\r\nWILD, WEIRD WEST. JUST YOU.\r\nThings can't get any worse after demonic thugs cut your arm off, right? Dead wrong, partner. The lady you saved from them has only gone and given you the legendary GOD HAND as a replacement - the ultimate hand-to-hand weapon. Every undead outlaw in a Stetson, rootin' tootin' demon and circus freak in the prairies is going to want to fight you for it. Welcome to the town of Asskickin... have a nice stay y'all.\r\n\r\nBIG HAND - Explosive martial arts and hand-to-hand action get in your face and ugly. No bullets, lots of bruised knuckles.\r\n\r\nSLAP STICKS - Totally customisable fight system. Pull off the most outrageous combo moves ever with awesome God Hand powers - punch your opponent into orbit!\r\n\r\nFIGHTING FORM - Pugilistic adventure from the makers of RESIDENT EVIL, DEVIL MAY CRY and VIEWTIFUL JOE!", 'youtube' => 'xTqzeMSBYFA', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1705], 'genres' => [1, 10], 'publishers' => [9], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLPM-66550', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLUS-21503', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-74241', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 26, 'game_title' => 'God of War', 'release_date' => '2005-03-22', 'platform' => 11, 'overview' => 'This action/adventure/combat game makes powerful use of the darkly imaginative world of Ancient Greek mythology, where the realms of the mortal and the divine collide in a pervasive atmosphere of brute force and violence. Playing as Kratos, throughout the game players will wield double blades bound to his body by long chains, weapons symbolic of this vicious world to which he is bound and the fate from which he seeks to escape. Featuring an hour of cinematic sequences and a deep combat system incorporating context-sensitive actions and an extensive range of combos, GOD OF WAR takes players through various environments that will have them fighting fierce enemies, swinging on ropes, scaling mountain cliffs, swimming through rivers and sliding down zip lines. The result is a unique and thrilling adventure through Greek mythology.', 'youtube' => 'https://www.youtube.com/watch?v=0Qxkd5EHguo', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7435], 'genres' => [1, 15], 'publishers' => [14], 'alternates' => ['GOD OF WAR'], 'uids' => [{ 'uid' => 'SLPM-67010', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-67011', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-67012', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SCES-53133', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 27, 'game_title' => 'Golden Axe: Beast Rider', 'release_date' => '2008-10-14', 'platform' => 15, 'overview' => 'Beast Rider is the first Golden Axe game in 3D as opposed to side scrolling hack and slash. While this is a major shift in game style from the previous games, Beast Rider maintains many of the elements from the originals such as magic and riding beasts, as well as sending the player on a quest to defeat Death Adder.', 'youtube' => 'Bk-9qXCbaBk', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7544], 'genres' => [1, 2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 28, 'game_title' => 'GRID', 'release_date' => '2008-06-03', 'platform' => 1, 'overview' => 'The game begins with the player accepting jobs to drive for other teams to earn money, and once the player gains enough capital they can purchase their own vehicles and drive independently, as well as continuing to drive for other teams should they choose to. GRID features a unique gameplay mechanic known as Flashback which allows the player to rewind gameplay by up to ten seconds and resume from their chosen point. This is a limited-use feature, determined by the difficulty setting.', 'youtube' => 'p_i1HLLo_j0', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1726], 'genres' => [7], 'publishers' => [16], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 29, 'game_title' => 'Grand Theft Auto IV', 'release_date' => '2008-12-02', 'platform' => 1, 'overview' => "For Niko Bellic, fresh off the boat from Europe, it is the hope he can escape his past. For his cousin, Roman, it is the vision that together they can find fortune in Liberty City, gateway to the land of opportunity. As they slip into debt and are dragged into a criminal underworld by a series of shysters, thieves and sociopaths, they discover that the reality is very different from the dream in a city that worships money and status, and is heaven for those who have them and a living nightmare for those who don't.", 'youtube' => 'FS2Aw6vxUPY?hd=1', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7279], 'genres' => [1, 2, 8], 'publishers' => [17], 'alternates' => ['GTA 4'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 30, 'game_title' => 'Guild Wars', 'release_date' => '2005-04-26', 'platform' => 1, 'overview' => "Guild Wars is a a massively multi-player online role-playing game (MMORPG) with an emphasis on tactical combat. In single player, multiplayer and guild-based missions, players will explore a fantasy world while pursuing professions and gaining skills that help them develop and advance their unique character.\r\n\r\nKey members of the creative teams behind the hit games Warcraft, StarCraft, and Diablo, as well as Battle.net founded Guild Wars, the first title from Seattle-based ArenaNet. Guild Wars offers cooperative group combat, single player missions, and large head-to-head guild battles. While each combat experience is different, achievements will be permanent so that the character grows and progresses over time. Unique items, special abilities, and a wide variety of skills add meaningful value for the player and for his or her comrades. Missions are not scripted adventures, but are tactical battlegrounds where victory or loss is determined by skill and teamwork.", 'youtube' => 'H2foBd3NT_s', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [609], 'genres' => [2, 4, 14], 'publishers' => [18], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 31, 'game_title' => 'Heavenly Sword', 'release_date' => '2007-09-12', 'platform' => 12, 'overview' => "The gameplay of Heavenly Sword resembles a martial arts title focused on melee combat while featuring opportunities for ranged attacks. The main character, Nariko, uses a weapon called the \"Heavenly Sword\" which changes into one of three forms depending on what attack stance the player uses as part of a unique fighting style. Speed Stance, the default, provides an even balance between damage and speed, where the sword takes the form of two separate blades. Range Stance allows fast, long-ranging, but weaker attacks, with the sword resembling two blades, chained together. Power Stance is the most powerful, but slowest style, where attacks are made with the Sword in the shape of one large, two-handed blade.\r\nFor exploration and certain battles, the game also makes use of \"Quick Time Events\" (QTE). During a QTE, a symbol for a certain button or for an action such as moving the analog stick to the right or left appears on screen and the player must match what is shown to successfully complete the scene.", 'youtube' => 'djY3_E2Z41M', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6032], 'genres' => [1, 2, 10], 'publishers' => [19], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 34, 'game_title' => 'Killer7', 'release_date' => '2005-07-07', 'platform' => 2, 'overview' => "Step into the mind of an assassin!\r\n\r\nKiller7 is a hard hitting surreal action adventure game starring Harman Smith - a mysterious assassin who can harness the unique power of his seven personalities. Working together these personalities are the Killer7.\r\n\r\nTheir mission: stop the evil Kun Lan and his minions known as the Heaven Smile from taking over the world.", 'youtube' => 'ln7MBdwH3SM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3577], 'genres' => [1, 2], 'publishers' => [9], 'alternates' => ['Killer 7'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 35, 'game_title' => 'Killzone', 'release_date' => '2004-11-02', 'platform' => 11, 'overview' => "The game is set in an era of space colonization where the Helghast Empire has recovered from its defeat in the First Helghan War and launched a blitzkrieg against the outer Interplanetary Strategic Alliance (I.S.A.) colony planet Vekta. Vekta's orbital Strategic Defense (S.D.) platforms failed during the initial assault, allowing the Helghast to land swarms of soldiers onto the surface and making it all the more difficult for the outnumbered I.S.A. forces.\r\n\r\nIn the game, the Helghast are a faction of human descendants who colonized the planet Helghan many generations ago. The planet's harsh environment forced the Helghast to adapt and mutate so much that they can no longer be considered human. They are stronger, faster and more resilient than their human cousins, and possess a burning hatred for humanity. Except for a small number of half-breed Helghast and trained troopers, they require a gas mask and air processing tank that creates air similar to that found on the planet Helghan.\r\n\r\nThe player takes control of I.S.A. Captain Jan Templar, who is fighting off the Helghast invasion. Templar and his squad are called back to the base for reassignment, and are promptly sent to find the I.S.A. operative Gregor Hakha and the information in his possession. During the course of the game, the player also takes control of several other characters, such as Shadow Marshal Luger (a female special operations assassin), a heavy weapons specialist Staff Sergeant Rico Velasquez (a Helghast-hating soldier with an itchy trigger finger), and Colonel Hakha, a half-Helghast, half-Human spy.\r\n\r\nAs the game progresses the player discovers that General Stuart Adams, a high ranking ISA officer, is a traitor and a servant of Joseph Lente (the commanding General of The Third Helghast Special Forces Army) and was responsible for sabotaging the SD platforms, rendering them unable to defend against the Helghast. The Earth Defense Fleet (EDF) go to assist the Vektan Army, however Adams kills General Voughton and receives his security key, allowing him to reboot the platforms, and prepare an ambush for the EDF relief force.\r\n\r\nJan and the others confront Lente, only to find out that Hakha was a commander in chief for him. Lente says that Hakha's family was ashamed to even be related to him, except his brother who talked of his heroism. Because of this, Lente had Hakha's brother shot down. With anger in his eyes, Hakha shoots Lente dead.\r\n\r\nThe team fly to the central SD platform and confront Adams, who is wounded by Templar. The platform begins to break up and Adams is killed by falling debris while trying to escape. Finally, the team restore the SD platform, allowing the EDF fleet to fight off the Helghast.", 'youtube' => 'wYDXFgptR-Q', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3657], 'genres' => [8], 'publishers' => [20], 'alternates' => nil, 'uids' => [{ 'uid' => 'SCUS-97402', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-66151', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 36, 'game_title' => 'Killzone 2', 'release_date' => '2009-02-27', 'platform' => 12, 'overview' => "Killzone 2 is the third game in the Killzone franchise and continues the story two years after the events of the first two games. The game takes place on Helghan, the home-world of the Helghast who assaulted the Interplanetary Strategic Alliance's colony on Vekta. The ISA retaliates on the Helghan's own ground with the aim to secure the Helghast leader, Emperor Visari, and bring the Helghast war machine to a halt. Assuming the role of Sergeant Tomas \"Sev\" Sevchenko, a battle-hardened veteran and a member of the special forces unit known as the Legion. Under his command, players lead a group of highly trained soldiers on a mission to take out the Helghast threat.\r\n\r\nThe gameplay consists of what the developers describe as Hollywood Realism, focusing on scripted, cinematic gameplay. The game is played entirely from the first-person perspective, except for the portions with vehicular combat with a tank and an exoskeleton. A large portion is dedicated to seeking cover and peeking from behind objects to open fire. Next to the single-player campaign, there is squad-based multiplayer called Warzone with five different kinds of missions (Assassination, Search & Retrieve, Search & Destroy, Bodycount and Capture & Hold) based on seven kinds of classes. There is support for up to 32 players, with the addition of bots to fill the remaining spots.", 'youtube' => 'b-4HNmuEAKg', 'players' => 16, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3657], 'genres' => [1, 8], 'publishers' => [21], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 37, 'game_title' => 'Lair', 'release_date' => '2007-08-30', 'platform' => 12, 'overview' => 'In a world ravaged by endless conflict and natural disaster, a call for peace turns into a bloodbath of betrayal and deceit. Playing as a warrior riding a voracious dragon trained for deadly aerial and ground combat, and capable of scorching, clawing and smashing thousands of enemies, gamers must defeat countless armies to save a civilization. Together, the gamer and the beast will attempt to change the destiny of a world on the brink of extinction.', 'youtube' => '467zs7pt0wE', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2976], 'genres' => [1], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 38, 'game_title' => 'The Last Remnant', 'release_date' => '2008-11-20', 'platform' => 15, 'overview' => "The Last Remnant is set in a fictional world featuring a number of distinct humanoid races: the Mitras, human in appearance, the Yamas, strong fish-like people, the Qsitis, small reptilians, and the Sovanis, feline people with four arms. The world itself is broken up into multiple city-states, each with their own unique culture. The story of the game revolves around \"Remnants\", mysterious and coveted ancient artifacts of varying shapes and sizes which possess magic powers and have been the cause of several wars throughout the game's history. Each Remnant is \"bound\" to a specific person, who is the only one who can then use their power; powerful Remnants that remain unbound for too long have the potential to cause a \"collapse\" and spawn monsters. As Remnants come in varying forms, all cities throughout the world have at least one that their ruler is bound to that assist to govern and bring peace to their assigned realm", 'youtube' => 'XUkAsfgP-XQ', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2808], 'genres' => nil, 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 39, 'game_title' => 'Lost Odyssey', 'release_date' => '2008-02-12', 'platform' => 15, 'overview' => "Lost Odyssey is set in a world in which a \"Magic-Industrial Revolution\" is taking place. While magic energy existed in all living creatures beforehand, it suddenly became far more powerful thirty years before the beginning of the game. Because of this, it has affected society greatly, with devices called \"Magic Engines\" harnessing this power for lighting, automobiles, communication, and robots, among other uses. While previously only a select few could wield magic, many magicians gained the ability. However, such progress has also caused two nations to develop new and more powerful weapons of mass destruction. The kingdom of Gohtza and the Republic of Uhra (which recently converted from a monarchy). Uhra is building Grand Staff, a gigantic magic engine, while the heavily industrialized Gohtza actively pursues magic research of their own. A third nation, the Free Ocean State of Numara, remains isolated and neutral, though it is falling into disarray due to a general attempting to stage a coup d'etat. Uhra, at war with Khent, a nation of beastmen, sends its forces to the Highlands of Wohl for a decisive battle at the start of the game.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5624, 10_184], 'genres' => [4], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 40, 'game_title' => 'Super Mario Galaxy', 'release_date' => '2007-11-12', 'platform' => 9, 'overview' => "Experience a gravity-defying adventure!\r\n\r\nBecome Mario as he traverses gravity-bending galaxies, traveling in and out of gravitational fields by blasting from planet to planet. Players experience dizzying perspective shifts as they run upside down through wild alien worlds that need to be seen to be believed. Whether you're surfing on a ray across an ocean in the clouds, rolling on a ball through a treacherous garden, or floating in a bubble over a poisonous swamp, there's no limit to the cosmic challenges you'll encounter!\r\n\r\n* Shake it! Controlling Mario is as simple as can be with the Wii Remote and Nunchuk. Move Mario with the Control Stick and shake the Wii Remote to perform a spin move or cue Ring Stars that launch you to and from planetary objects. You can even point at bits of stardust to collect them or latch onto Beam Stars to blaze a magnetic trail through the heavens.\r\n\r\n* Mario can run, tiptoe, jump, triple-jump, backflip, and long-jump, but what he'll do most is spin. By shaking the Wii Remote, players make Mario spin around with fists outstretched, allowing him to pummel enemies and cue Star Rings that launch him from planet to planet.\r\n\r\n* He can also find plenty of power-ups: A Bee Mushroom turns him into Bee Mario, allowing him to fly for short periods of time and cling to honeycombs. A Boo Mushroom turns him into Boo Mario, allowing him to float and turn invisible to pass through mesh gates.\r\n\r\n* He'll constantly collect bits of stardust. These can be fired at enemies using the B Button. A second player can even take on this role, using a second Wii Remote to stall enemies, fire stardust, or even sweep aside projectiles.", 'youtube' => 'XgVItfrZvOU', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 2, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 41, 'game_title' => 'Super Mario Kart', 'release_date' => '1992-09-01', 'platform' => 6, 'overview' => "The Super Mario GoKart Park is open for tons of racing fun!  Hit the track with Mario, Luigi, Yoshi and the Princess.  Get tough and lock fenders with Donkey Kong, Jr. and Bowser.  Even Toad and Koopa Troopa will mix it up in an all-out quest for the Gold Cup!  Race head-to-head with a friend or challenge the computer in great, split-screen, Mode 7 graphics.\r\n\r\nFeel like a bit less speed and a lot more strategy?  Take a crack at the Battle Mode!  In four different maze-like courses you’ll use Koopa Shells, Banana Peels, Super Stars and other wacky weapons to burst your opponent's target balloons and triumph!\r\n\r\n* 2 games in 1 - Mario Grand Prix and Battle Mode\r\n* 8  Familiar Characters\r\n* 20 Different Tracks\r\n* 3 Different Skill Levels\r\n* Battery-backed memory saves your best times!", 'youtube' => 'vRg-89M665c', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 42, 'game_title' => 'Mario Party', 'release_date' => '1999-02-08', 'platform' => 3, 'overview' => "Every game in the main series has a standard Party Mode in which up to four players play through a board, trying to collect as many stars as possible. In every turn, each player rolls a die and progresses on the board, which usually has branching paths. Coins are primarily earned by performing well in a minigame played at the end of each turn. On most boards, players earn stars by reaching a star space and purchasing a star for a certain amount of coins. The star space appears randomly on one of several pre-determined locations and moves every time a star is purchased, usually occupying a blue space.\r\nEvery Mario Party contains at least 50 to almost 110 minigames with a few different types. Four-player games are a free-for-all in which players compete individually. In 2-on-2 and 1-on-3 minigames, players compete as two groups, cooperating to win, even though they are still competing individually in the main game. Some minigames in Mario Party are 4-player co-op, even though it doesn't say it. In most situations, winners earn ten coins each.", 'youtube' => 'sScj7MwjHBs', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [1, 2, 6, 11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 43, 'game_title' => 'Metal Gear Acid', 'release_date' => '2005-03-24', 'platform' => 13, 'overview' => "The Metal Gear series comes to the PSP offering a new gameplay system and storyline. In Metal Gear Acid, you'll take on the role of Solid Snake, a top-secret agent who's an expert at infiltration. It's up to you to make calculated decisions to plan out your strategy and accomplish missions in a turn-based style of game. Strategic battle cards give you different abilities and stealth tactics that help you achieve mission objectives. Experience a deeper kind of tactical espionage in the palm of your hand.", 'youtube' => 'KR2pfqpj7vo', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4619], 'genres' => [6, 16], 'publishers' => [23], 'alternates' => ['Metal Gear Ac!d'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 44, 'game_title' => 'Metal Gear Solid 3: Snake Eater', 'release_date' => '2004-11-17', 'platform' => 11, 'overview' => "Set in the 60s and using the Cold War as its inspiration, Metal Gear Solid 3: Snake Eater forces the player to adopt a number of new skills to survive in Snake's new jungle environment. Danger lurks everywhere as Snake explores the beautifully-realised forests, encampments and rivers, with guards patrolling key routes, dangerous animals to contend with, and the uneven terrain and noisy foliage making the silent approaches the Metal Gear hero is famed for virtually impossible.\r\n\r\n    Gameplay set in Cold War era 1960's\r\n    Camoflage System: Use different combinations of uniform and face paints to blend into your environment\r\n    Food: Capture and eat animals & plants to sustain Snake's health and abilities\r\n    Close Quarters Combat (CQC): Take on enemies up close and personal with knives and martial arts techniques for silent kills\r\n    Exclusive content for the PAL version includes:\r\n    Duel Mode - Battle through the game's Boss Fights independently\r\n    Demo Theatre - Watch all the cut scenes in sequence\r\n    European Extreme difficulty level\r\n    2 New Levels in Snake Vs Monkey Mode\r\n    New Face Paint and Camoflage Designs not available in US or Japanese versions", 'youtube' => 'hXUono66wxI', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4765], 'genres' => [1, 2, 16], 'publishers' => [23], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLUS-20915', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-65790', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-66794', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLES-82013', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 45, 'game_title' => 'Metal Gear Solid 4: Guns of the Patriots', 'release_date' => '2008-06-12', 'platform' => 12, 'overview' => 'Metal Gear Solid 4 is set in 2014, five years after the Big Shell incident and nine years after Shadow Moses incident. The world economy relies on continuous war, fought by PMCs, which outnumber government military forces. PMC soldiers are outfitted with nanomachines to enhance their abilities and control the stress on the battlefield. The control network created through these nanomachines is called Sons of the Patriots (SOP), and Liquid Ocelot is preparing to hijack the system. Snake accepts a request from Roy Campbell to terminate Liquid, with Otacon and Sunny providing mission support from the Nomad aircraft.', 'youtube' => 'pjYE7GkZg-A', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4760], 'genres' => [1, 2], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 46, 'game_title' => "Mirror's Edge", 'release_date' => '2008-11-11', 'platform' => 12, 'overview' => "Mirror's Edge introduces players to Faith, a \"runner\" in a world where communication channels are highly monitored and the movement of human traffic is closely watched. When Faith's sister gets framed for a murder she did not commit, Faith finds herself on the edge of the city, on the wrong side of the law. \r\n\r\n Mirror's Edge delivers players straight into the shoes of this modern day heroine as she traverses the vertigo-inducing cityscape, engaging in intense combat, fast-paced chases and challenging puzzles. With a never-before-seen sense of movement and perspective, players are drawn into Faith's world.", 'youtube' => '2N1TJP1cxmo', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2576], 'genres' => [1, 2], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 47, 'game_title' => 'Need for Speed: ProStreet', 'release_date' => '2007-11-13', 'platform' => 1, 'overview' => 'The game begins where a former street racer known as Ryan Cooper enters a challenge day and wins it with a Nissan 240SX. Ryan is mocked by Ryo Watanabe, the Showdown King.', 'youtube' => '3YcFDXp4tD8', 'players' => nil, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [2563], 'genres' => [7], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 48, 'game_title' => 'NiGHTS into Dreams...', 'release_date' => '1996-08-31', 'platform' => 17, 'overview' => "Immerse yourself in an unparalleled 3D flying experience. NiGHTS truly delivers an amazing virtual world of dreams -- filled with unbelievable real-time effects, fantastic creatures and nightmarish monsters.\r\n\r\n* Master a showcase of Sega Saturn's Processing Power.\r\n* Face your worst nightmares in a stunning world of 3D gameplay.\r\n* Dozens of camera angles, never-seen-before effects and 3D positional sound.\r\n* Developed exclusively for Sega Saturn by the creators of \"Sonic the Hedgehog.\"", 'youtube' => 'IqMGYy5btJQ', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [7979], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 49, 'game_title' => 'Ninja Gaiden II', 'release_date' => '2008-06-03', 'platform' => 15, 'overview' => 'In "Ninja Gaiden II," gamers must guide Ryu Hayabusa on a mission to avenge his clan and prevent the destruction of the human race. Armed with an assortment of ninja weaponry, players must help Ryu skillfully maneuver through a world fraught with peril. "Ninja Gaiden II" will feature an all-new gameplay engine, a new auto-health regeneration system, levels, adventures, enemies and thrilling combat with an extensive assortment of ninja weaponry, representing a true evolution of the highly popular franchise.', 'youtube' => 'uS-IhxhW4T8', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [8563], 'genres' => [1, 2], 'publishers' => [24], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 50, 'game_title' => 'Ninja Gaiden: Dragon Sword', 'release_date' => '2008-03-25', 'platform' => 8, 'overview' => "This action-adventure title is presented in a third person, pseudo-3D manner, meaning all the game-models are rendered in full 3D, but the world the player travels around in is pre-rendered. When played, the Nintendo DS is held sideways, as in Hotel Dusk: Room 215 and Brain Age: Train Your Brain in Minutes a Day!. The left screen shows the area map, while the right displays the main gameplay, when set for right-handed play, and reverse when set for left-handed play.\r\nSet six months after Ninja Gaiden, Ryu Hayabusa has rebuilt the Hayabusa Village. When fellow villager and kunoichi, Momiji, is kidnapped by the Black Spider Ninja Clan, he is forced to find her, while uncovering the secrets behind the mysterious Dark Dragonstones and their relation to the Dragon Lineage", 'youtube' => 'VbwuQDPwOWo', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8563], 'genres' => [1, 2], 'publishers' => [24], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 51, 'game_title' => 'Okami', 'release_date' => '2006-09-19', 'platform' => 11, 'overview' => "The game is set in Nippon based on Japanese classic history, and begins with a flashback to events 100 years prior to the game's present, and describes how Shiranui, a pure white wolf, and Nagi, a swordsman, together fought the eight-headed demon Orochi to save Kamiki Village and the maiden Nami, Nagi's beloved. Shiranui and Nagi are unable to defeat Orochi but manage to seal the demon away. In the game's present, Susano, a descendant of Nagi and self-proclaimed greatest warrior, breaks Orochi's seal due to the fact that he does not believe in the legend, and Orochi escapes and curses the lands, sapping the life from every living being. Sakuya, the wood sprite and guardian of Kamiki Village, calls forth Amaterasu, the sun goddess, known to the villagers as the reincarnation of the white wolf Shiranui, and pleads her to remove the curse that covers the land. Accompanied by the artist Issun (an inch-high Poncle), Amaterasu is able to restore the land to its former beauty. Throughout the journey, Amaterasu is hounded by Waka, a strange but powerful individual that seems to have the gift of foresight, and further teases Amaterasu and Issun to his own mysterious ends. Additionally, Amaterasu locates several Celestial Gods who have hidden in the constellations that bestow upon the goddess powers of the Celestial Brush to aid in her quest.", 'youtube' => 'K4trRdKm9CA', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1705], 'genres' => [1, 2], 'publishers' => [9], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLPM-66375', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLUS-21115', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLES-54439', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 52, 'game_title' => 'Perfect Dark Zero', 'release_date' => '2005-11-22', 'platform' => 15, 'overview' => "The Xbox 360 prequel to Rare's Nintendo 64 hit, Perfect Dark. Players once again slip into the role of Joanna Dark and fight their way through a twisting sci-fi storyline. The franchise's staple multiplayer mode returns, this time with full online support.\r\n\r\nSet in the year 2020, three years before the original hit game Perfect Dark, Perfect Dark Zero features a gripping story, multiple game scenarios for endless replayability, a massive arsenal of weapons and combat-enabled vehicles. The sci-fi, first-person shooter features a fully interactive world, support for up to 50 players online via Xbox Live, breathtaking high-resolution graphics and spectacular special effects.", 'youtube' => '7lM5kZKnnzM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6991], 'genres' => [1, 8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 53, 'game_title' => 'Prince of Persia', 'release_date' => '2008-12-09', 'platform' => 1, 'overview' => "Escape to experience the new fantasy world of ancient Persia. Masterful storytelling and sprawling environments deliver a brand new adventure that re-opens the Prince of Persia saga. Now you have the freedom to determine how the game evolves in this non-linear adventure. Players will decide how they unfold the storyline by choosing their path in the open-ended world. \r\n\r\n In this strange land, your rogue warrior must utilize all of his skills, along with a whole new combat system, to battle Ahriman’s corrupted lieutenants to heal the land from the dark Corruption and restore the light. Also, history;s greatest ally is revealed in the form of Elika, a dynamic AI companion who joins the Prince in his fight to save the world. Gifted with magical powers, she interacts with the player in combat, acrobatics and puzzle-solving, enabling the Prince to reach new heights of deadly high-flying artistry through special duo acrobatic moves or devastating fighting combo attacks.", 'youtube' => 'https://www.youtube.com/watch?v=WsPTD_2q5u8', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9149], 'genres' => [1, 2], 'publishers' => [7], 'alternates' => ['Prince of Persia (2008)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 54, 'game_title' => "Tom Clancy's Rainbow Six: Vegas", 'release_date' => '2006-11-22', 'platform' => 1, 'overview' => "Rainbow Six Vegas changes the series with multiple new features, such as a new health system where the player regenerates health while not taking fire (it should be noted that the player may sometimes be killed instantly, without a chance to regenerate health; this usually happens from grenades, as well as taking close range fire from very powerful weapons, particularly to the head). \r\nIn the year 2010, Rainbow operatives Logan Keller (Andrew Pifko), Gabriel Nowak (Thomas Michael) and Kan Akahashi (Dennis Akayama) are on a mission in a Mexican border town, assisted by intelligence officer Joanna Torres (Athena Karkanis) and pilot Brody Lukin (Andrew Pifko). Their objective is to arrest Irena Morales (Amanda Martinez), a terrorist ringleader. As the team reaches its landing zone in a helicopter, Logan fast-ropes down first but is separated from his group.", 'youtube' => '9QeNEoEWxqg', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9150], 'genres' => [1, 8], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 55, 'game_title' => 'Command & Conquer: Red Alert 3', 'release_date' => '2008-10-28', 'platform' => 1, 'overview' => "The game is set in a parallel universe in which World War II never happened—in the original Red Alert, Albert Einstein travelled back in time and removed Hitler in the 1920s. After an Allied victory in Red Alert 2, the Soviet leaders travelled back in time and removed Albert Einstein in 1927, preventing the Allies from creating atomic weapons while the Soviet Union rose to power, battling the Allies in the 1950s. In this game, the Empire of the Rising Sun rises to power as a threat as well (an unintentional result of the Soviets' time travelling). All three factions are playable, with the main gameplay involving constructing a base, gathering resources, and training armies composed of land, sea, and airborne units to defeat other players. Each faction has a fully co-operative campaign, playable with an artificial intelligence or with another human player online. These campaigns follow a storyline, with specific mission objectives and unit restrictions applied.", 'youtube' => 'EfmpKq_6nCo', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2579], 'genres' => [6], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 56, 'game_title' => 'Resident Evil 4', 'release_date' => '2005-01-11', 'platform' => 2, 'overview' => "U.S. agent Leon Kennedy has been tasked to look into the abduction of the President's daughter and his investigation has led him to a mysterious location in Europe. As Leon encounters unimaginable horrors, he must find out what is behind the terror.", 'youtube' => '-fGYWQs2WgM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1, 2, 18], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 57, 'game_title' => 'Resident Evil 5', 'release_date' => '2009-09-15', 'platform' => 1, 'overview' => 'Produced by series veteran Jun Takeuchi, this next-generation follow-up to the terrifying series introduces the theme of escape as its core survival instinct. As Chris Redfield (former S.T.A.R.S. member and now part of the BSAA unit), your life is in danger as you strive to complete your most dangerous mission yet in a sweltering desert colony where a new breed of evil has been unleashed. Swarms of marauding evil beings will charge at you when your pulse is racing at a heart-shattering pace. Environments will play a bigger factor than ever here, using the power of next-gen systems to create a world where terror might lurk in any alcove or shadow. Powerful lighting effects overwhelm the player with mirage movement and blinding brilliance, and even in the light of day, there is no safe haven in this Resident Evil.', 'youtube' => 'UX89tmpiuDA', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1, 8], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 58, 'game_title' => 'Resident Evil Archives: Resident Evil Zero', 'release_date' => '2009-12-01', 'platform' => 9, 'overview' => "The game's storyline serves as a prequel to Resident Evil, covering Rebecca Chambers' ordeal a day prior. \r\n\r\nOn July 23, 1998, special police STARS Bravo team is sent in to investigate a series of grisly murders in the Arklay Mountains region outside of Raccoon City. On the way to the scene, Bravo's helicopter malfunctions and is forced to crash land in the forest. The team soon discover an overturned military police transport truck, along with the mutilated corpses of two officers. The team split up and Bravo team's field medic, Rebecca Chambers, finds a train stopped in the middle of the forest.\r\nRebecca soon discovers that the train, the Ecliptic Express, is infested with zombies.", 'youtube' => 's49FPBRsC7c', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1, 8, 18], 'publishers' => [9], 'alternates' => ['Resident Evil Archives: Resident Evil 0'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 59, 'game_title' => 'Ridge Racer 6', 'release_date' => '2005-11-17', 'platform' => 15, 'overview' => "Ridge Racer 6 is the sixth installment in the Ridge Racer series of racing games. It was released on Xbox 360 on 22 November 2005 in North America, 10 December 2005 in Japan, and 20 January 2006 in Europe.\r\n\r\n\r\nLike previous Ridge Racer titles, the focus of gameplay is on placing first out of 14 in numerous 3-lap races across several tracks and numerous cars. In most races, the player can earn up to three nitrous boosts by successfully drifting around corners without crashing, which can then be used to give the player a short burst of speed. Some races are labeled as \"no-nitrous,\" which prevent the player from earning any nitrous during the race, though the player can optionally enable nitrous. If the player wins using this option, the race is considered complete, but noted for breaking the no-nitrous rule. Some races are also Duels between the player and a boss opponent, who is usually equipped with a much better car than the player can select from.\r\n\r\nRidge Racer 6 introduces a career-mode \"World Xplorer,\" a branching-tree arrangement of races in which the player can only attempt races next to a race that has already been successfully completed. The layout of the races in the Xplorer is such that the position of a race will indicate what class of car can be used (horizontal position) and the difficulty of the course (vertical position). Rewards can be obtained by completing certain races or completing all races that enclose an area on the Xplorer, and usually offers new cars but also include additional variations of the tracks (mirroring and reverse) or new branches added to the tree. A player can also engage in quick races and time challenges for any track and car that has been unlocked.\r\n\r\nThere are thirty new circuits available including \"Surfside Resort\" and \"Harborline 765.\" Also, there are around 130 cars (including 10 special). Online multiplayer is possible with up to 14 players racing against each other and downloadable content is available via Microsoft's Xbox Live service. Players can download another player's \"ghost\" replay from Xbox Live and attempt to beat it.\r\n\r\nLike other Ridge Racer games, this iteration goes beyond cars to feature other outlandish vehicles as well, called \"special machines\" in the game. These include a hovercraft (Assoluto Pronzione), a tripod supercar (Himmel 490B) and an oversized SUV that can be very loud (Danver Bass Cruiser).[1] The game, as with all games in the Ridge Racer series, contains copious amount of references to other Namco games, such as Pac-Man, Soulcalibur, and Ace Combat.\r\n\r\nThe game also features a Full Motion Video opening, starring series mascot Reiko Nagase.\r\n\r\nIn Japan, Namco announced that it expected to sell 500,000 copies of Ridge Racer 6 for the Xbox 360, although far fewer copies were actually sold. Ridge Racer 7 for the PlayStation 3 is something of a \"director's cut\"/\"final version\" of Ridge Racer 6, but with major differences such as new vehicles that were not seen in Ridge Racer 6 such as Sinseong, a Korean brand.", 'youtube' => 'g38xo7TEFPI', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5804], 'genres' => [7], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 60, 'game_title' => 'Rumble Roses XX', 'release_date' => '2006-03-28', 'platform' => 15, 'overview' => 'The female wrestling series Rumble Roses returns for another round with Rumble Roses XX. Rumble Roses XX features a range of visual and gameplay enhancements, including new game modes and new wrestlers. You can create your own wrestler and upgrade their abilities by taking down their opponents. The game offers Xbox Live integration, featuring leaderboards, shared photos, and matches with up to four players.', 'youtube' => 'ys8XnKxykUw', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4765], 'genres' => [1, 11], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 61, 'game_title' => 'Sam & Max Hit the Road', 'release_date' => '1993-11-01', 'platform' => 1, 'overview' => "Grab your nightstick, squeal like a siren and Hit the Road with Sam & Max, Freelance Police, as they attempt to crack their toughest case. Sam (a shamus canine) and Max (a hyperkinetic rabbity thing) are hot on the trail of a runaway carnival bigfoot across America's quirky underbelly in this deranged animated adventure!\r\n\r\nHelp our frightening, furry flatfoots find the fugitive freak! Do it now!", 'youtube' => 'OtaCwN6wOAw', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [2], 'publishers' => [25], 'alternates' => ['Sam and Max: Hit the Road'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 62, 'game_title' => 'Shaun White Snowboarding', 'release_date' => '2008-12-03', 'platform' => 1, 'overview' => 'There are six mountains in Shaun White Snowboarding, including Alaska, Park City, Europe and Japan. Each mountain features up to three different sections: peak, back country and park (or resort). There is also a special version of the game only available from Target which costs more. This version gives the player access to Target Mountain, an exclusive mountain with Target branding all over it; this mountain has been described as extremely difficult to find. The last mountain comes in with the "Mile-High pack", downloadable content for the game. It is called B.C. It is set in British Columbia (Canada). While you progress through the game you will earn abilities that will help you throughout the game. Some of the abilities consist of gaining high speeds or the ability to break through obstacles to progress further in the game.', 'youtube' => 'CJZLFm-pgGc', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [11], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 63, 'game_title' => 'Sonic Riders', 'release_date' => '2006-11-17', 'platform' => 1, 'overview' => "The game's got a quite a few modes of play, a few of which support up to two people. There's a story mode, though there isn't much of a story. Its vaguely comprehensible plot points involve Eggman setting up an air-board tournament for Sonic, Tails, Knuckles, and his various cartoonish enemies. The winner gets a bunch of Chaos Emeralds, which unlocks long lost Babylon. Since he's a super villain, it makes sense that Eggman eventually steals all the Chaos Emeralds after the story mode's fifth race, prompting a sixth race amongst Babylon's ruins. In addition to the story for Sonic and friends, there's a separate one for his enemies, though the tracks are quite similar. There's also Free Race, Time Attack, and World Grand Prix modes, a Tag mode, and Race and Battle stage variations of a Survival mode.", 'youtube' => 'MQ6w0jvQSK8', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7979], 'genres' => [7], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 64, 'game_title' => "Tom Clancy's Splinter Cell", 'release_date' => '2002-11-19', 'platform' => 1, 'overview' => "Set in the fall of 2004, the player takes on the role of Sam Fisher, a long-dormant secret agent called back to duty by the American National Security Agency, to work with a secret division dubbed \"Third Echelon\". At this point, Fisher hasn't \"been in the field in years\". Fisher must investigate the disappearance of two CIA agents in the country of Georgia, which soon leads to a larger mission: saving the world from war with Georgia.", 'youtube' => 'Ia1tI12b7tg', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [1, 16], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 65, 'game_title' => 'Tabula Rasa', 'release_date' => '2007-10-30', 'platform' => 1, 'overview' => nil, 'youtube' => '6XsAox0RQ8A', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5850], 'genres' => nil, 'publishers' => [18], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 66, 'game_title' => 'Tomb Raider (1996)', 'release_date' => '1996-11-22', 'platform' => 1, 'overview' => "In Tomb Raider, the player controls the female archaeologist Lara Croft, in search for the three mysterious Scion artefacts across the world. The game is presented in third person perspective. Lara is always visible and the camera follows the action from behind or over her shoulder. The world she inhabits is fully drawn in three dimensions and characterized by its cubic nature. Ledges, walls and ceilings mostly sit at 90 degrees to each other, but sometimes feature sloping planes.\r\nThe object of Tomb Raider is to guide Lara through a series of tombs and other locations in search of treasures and artefacts. On the way, she must kill dangerous animals and other creatures, while collecting objects and solving puzzles to gain access to an ultimate prize, usually a powerful artefact. Gunplay is restricted to the killing of various animals that appear throughout each stage, although occasionally Lara may be faced with a human opponent. Instead the emphasis lies on solving puzzles and performing trick jumps to complete each level.", 'youtube' => 'QNZzji8iShM', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1827], 'genres' => [1, 2], 'publishers' => [26], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 67, 'game_title' => 'Tomb Raider: Underworld', 'release_date' => '2008-11-21', 'platform' => 1, 'overview' => "Tomb Raider: Underworld begins where its predecessor left off, with Lara Croft searching for the mythical resting place of King Arthur, Avalon. Underneath the Mediterranean Sea Lara discovers Thor's gauntlet and then has an encounter with an old enemy, Jacqueline Natla, who has been imprisoned by Legend's antagonist, Amanda Evert. Natla tells Lara that the Norse underworld, Helheim and Avalon are one and the same and that she will need to find Thor's Hammer to open the Underworld. Lara soon discovers to find and wield the hammer she will have to find Thor's other gauntlet and his belt, to retrieve these artefacts she must explore underworlds all around the globe, facing the creatures, traps and puzzles that guard them. However, Lara discovers that Helhiem may contain a powerful weapon that could put the world in danger. Lara also finds herself faced with a doppelgänger of herself created by Natla, who burns down her house and kills one of Lara's assistants, Alister Fletcher. After finally completing her quest to find Mjolnir, taking her from the Mediterranean to Thailand to her own Manor to Central America then finally to Jan Mayan Island, she goes to Natla one more time and threatens to kill her if she doesn't tell her where Helheim is. Natla gives her the coordinates, but states that she knows the sacred Ritual of Odin, which partially opens the gate and allows Mjolnir to finish the job. Here Amanda enters, but before she and Lara can start fighting, the Doppelgänger takes Amanda and throws her down a shaft. Lara almost kills the Atlantean, but stops herself and simply releases her, letting Natla fly ahead to Helheim, beneath the Arctic icecap. With the ritual performed, Lara uses Mjolnir and enters Helheim, battling her way through hoards of Thralls, reanimated corpses of men and yetis protecting the secret at the heart of the city. Along the way, Lara encounters and shoots her mother, who has turned into a Thrall herself, and Natla reveals the true extent of her manipulation of Lara, even going back to when the Atlantean killed Lord Richard Croft when he saw Natla's intentions. Natla goes, saying '[she has] a serpent to raise', leaving the Doppelgänger to kill Lara. Amanda saves Lara's life and Lara pursues Natla, who is activating an ancient doomsday device called the Midgard Serpent, which could cause massive volcanic activity across the whole planet and destroy most of humanity, leaving Natla to be the ruler of what's left. Lara successfully destabilises the device and while Natla desperately tries to repair the damage, Lara throws Mjolnir at Natla, sending her down into the pool of deadly Eitr below and bringing the Midgard Serpent down with it. But this causes the pool to slowly rise and, as Amanda comes round from holding off the Yeti Thralls, she states the legend of Thor and the Serpent, ending 'We'll die here, just like your mother'. Lara suddenly sees a dais like the one that brought her mother to Helheim and together Lara and Amanda repair and use it, teleporting into the temple in Nepal. Lara and Amanda have one final face-off, before Amanda walks away and Lara bids one final farewell to her mother, then too departs", 'youtube' => 'aM1MqQua4hY', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2685], 'genres' => [1, 2], 'publishers' => [27], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 68, 'game_title' => 'Turok: Dinosaur Hunter', 'release_date' => '1997-03-04', 'platform' => 3, 'overview' => "Much like your usual 1st person shooter, although with dinosaurs as your main enemy. Includes 14 high tech weapons, like the Quad Rocket Launcher and the Atomic Fusion Cannon. You control Turok, who must take on the Campaigner and his highly evolved dino's. The objective is to collect pieces of the Chronoscepter, which is the only weapon that can help to destory the Campaigner, and to stop him from using the power of the weapon to destory the Lost Land.", 'youtube' => '3AKbul3ILM0', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4065], 'genres' => [8], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 69, 'game_title' => "Ultimate Ghosts 'n Goblins", 'release_date' => '2006-08-29', 'platform' => 13, 'overview' => "An exclusive PSP edition of Capcom's legendary platforming game, directed by the original's creator Tokurou Fujiwara. The game makes use of a 3D graphics engine, giving depth to the visuals, but plays in a side-scrolling perspective and similar art design to stay true to the original. Your goal is to work your way through side-scrolling stages, defeating enemies and using your best platforming skills. The game lets you build up your skills as you progress. You start off with just a basic jump, but eventually gain a double jump and even the ability to fly. You'll also earn lots of magic spells along the way. The game promises a greater number of spells and weapons than ever before. New for Goku Makaimura is non-linear gameplay. You're no longer on a fixed path from start to end. The levels include branching points and even warp points. By using a warp point, you can warp back to previous levels and collecting items that you might have missed.", 'youtube' => 'TlkRpMvbKfs', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [1436], 'genres' => [1, 15], 'publishers' => [9], 'alternates' => ['Goku Makai-Mura'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 70, 'game_title' => "Uncharted: Drake's Fortune", 'release_date' => '2007-11-19', 'platform' => 12, 'overview' => "A 400-year-old clue in the coffin of Sir Francis Drake sets a modern-day fortune hunter on an exploration for the fabled treasure of El Dorado, leading to the discovery of a forgotten island in the middle of the Pacific Ocean. The search turns deadly when Nathan Drake becomes stranded on the island and hunted by mercenaries. Outnumbered and outgunned, Drake and his companions must fight to survive as they begin to unravel the terrible secrets hidden on the Island.\r\nTaking full advantage of the power of PS3, Uncharted: Drake’s Fortune is developed using proprietary technology that promises to impress players with incredibly realistic characters and lifelike environments. Building on its legacy of extraordinary storytelling, developer Naughty Dog has created an elaborate plot that will have players guessing at every turn. Uncharted: Drake's Fortune, brings players into a world ripe with realism and unexpected juxtapositions.", 'youtube' => '8TxYmAKCXSE', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5839], 'genres' => [1, 2], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 71, 'game_title' => 'Viewtiful Joe', 'release_date' => '2003-10-07', 'platform' => 2, 'overview' => "Joe is no ordinary man and Viewtiful Joe is no ordinary game. Capcom's new superhero action game mixes funky cartoon-style visuals with classic side-scrolling gameplay and introduces the world's quirkiest million dollar action hero. More than just any ordinary dude, Joe must transform into the ultimate superhero. It's up to you to activate the correct view mode like \"slow\" or \"zoom in\" in order to clobber your enemies with beautiful style. You can also speed up or slow down your visual effects for even more \"viewtiful\" moves. Viewtiful Joe mixes an innovative viewpoint with an amazing stunt-filled action movie universe.", 'youtube' => '-Fb-L9tQ_ic', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1705], 'genres' => [1, 10], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 72, 'game_title' => 'Viking: Battle for Asgard', 'release_date' => '2008-03-25', 'platform' => 15, 'overview' => "Viking: Battle for Asgard thrusts players into a twisted mythological world overrun with demonic warriors unleashed by Hel, the Norse goddess of death. As Skarin, a rage-fueled Viking hero, players will wage all-out war to free mankind from the grip of evil and ultimate annihilation. Enemies will suffer graphic dismemberment with disturbing realism from an array of Skarin's melee, range and magic attacks.", 'youtube' => 'rQ6i1KKxVj4', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1891], 'genres' => [1, 2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 73, 'game_title' => 'Age of Conan: Hyborian Adventures', 'release_date' => '2008-05-20', 'platform' => 1, 'overview' => 'Age of Conan is set in a low fantasy pseudo-historical ancient world called the Hyborian Age, created by Robert E. Howard. The warlord Conan has seized the throne of Aquilonia, but ancient evils seek to overthrow him.', 'youtube' => 'GESzNCBnphk', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3233], 'genres' => [4, 14], 'publishers' => [29], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 74, 'game_title' => 'Aliens: Colonial Marines', 'release_date' => '2013-02-12', 'platform' => 1, 'overview' => "Aliens: Colonial Marines is a squad-based first-person shooter in which the player controls four Colonial Marines, each with a different personality and primary weapon. Each player character can carry additional weapons including a flamethrower, pulse rifle, smartgun, pistol, RPG, and many types of grenades.\r\n\r\nThe player controls one marine at a time, issues orders to the others using context-sensitive commands, and may switch between characters at any time.\r\n\r\nThe player will also occasionally be required to control a particular location, using tactical positioning and turrets to fend off attacks. Aliens: Colonial Marines will have no HUD to provide the player with onscreen information.\r\n\r\nThe primary enemies of the game are Aliens which will generally attempt to sneak up on or outflank the player, forcing the player to use tactical combat to confront them. Several different types of Aliens will appear and will attack differently. Facehuggers will attempt to attach themselves to the player character's face, implanting an embryo inside them which will then kill them. \"Warrior\" Aliens are the primary enemies and are based primarily on the appearance of the Alien in Aliens. \"Scouts\" are faster and will spy on the player characters' activities. They will work in small groups or alone. These Aliens will be based on the appearance seen in Alien. \"Drones\" primarily carry and position eggs and work in the heart of the Hive serving the Queen; they were originally going to be in Aliens along with the \"Warriors\". An Alien queen will also appear as a \"boss\" enemy.", 'youtube' => 'GjY7yFMEk-c', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3423], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 75, 'game_title' => 'Alone in the Dark', 'release_date' => '2008-06-23', 'platform' => 1, 'overview' => "It has been 83 years since Edward Carnby investigated the suicide of Jeremy Hartwood. Now he wakes up in an apartment in New York and is moments away from being shot by a group of bad guys. He doesn't remember much and as he looks into a mirror, a man looks back at him that isn't even near the age of 80. But as all hell breaks loose and mysterious forces tear through the building and the city itself, the question about his looks becomes one of many. To make things even worse, an old enemy decides to return in a search for a powerful stone. So for Carnby a race for survival begins and all signs point to Central Park.\r\n\r\nEdward's mysterious journey is divided into eight episodes that can be played in chronological order or can be accessed directly from the main menu. Once in the game, the player controls Edward either in a 1st-person or a 3rd-person manner either by switching manually or depending on the situation and what item he uses. If he picks up a fire extinguisher for example, the player will be able to extinguish fires with it if he is in 1st-person mode. In 3rd-person mode it instead becomes a deadly weapon or a battering ram.\r\n\r\nThis is especially important since Edward won't find much ammunition for the pistols, shotguns and other weapons in the game. Instead he needs to be creative and use the items he finds or the environment for his advantage. Especially since most enemies can only be permanently killed by burning them, igniting a wooden chair at a nearby fire, or using a lighter and a can of hairspray are Edward's best bets to knock them out.\r\n\r\nFire plays an important role in the game at all times. If not extinguished, it will slowly burn through anything in the vicinity and spread until everything burnable has been reduced to a smoking pile of ash. This behavior can of course be useful to Edward if he for instance wants to get through a closed wooden door and has nothing heavy at hand to force his way.", 'youtube' => '_Nn30cqZEQI', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2652], 'genres' => [1, 18], 'publishers' => [506], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 76, 'game_title' => 'Bionic Commando', 'release_date' => '1988-12-06', 'platform' => 7, 'overview' => "Bionic Commando takes place ten years after an unspecified World War between two warring factions. The game follows a commando who must infiltrate an enemy base and foil the enemy's plot to launch missiles.", 'youtube' => 'a0C3E8-u4VM', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 77, 'game_title' => 'Burnout Paradise: The Ultimate Box', 'release_date' => '2009-02-05', 'platform' => 1, 'overview' => "Paradise's gameplay is set in the fictional \"Paradise City\", an open world in which players can compete in several types of races. Players can also compete online, which includes additional game modes, such as \"Cops and Robbers\". Several free game updates introduce new features such as a time-of-day cycle and motorcycles. The game also features paid downloadable content in the form of new cars and the fictional \"Big Surf Island\".", 'youtube' => 'HmQWkoRi5zo', 'players' => 4, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [1932], 'genres' => [1, 7], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 78, 'game_title' => "Clive Barker's Jericho", 'release_date' => '2007-10-23', 'platform' => 1, 'overview' => "Jericho's core gameplay consists of leading the game's eponymous seven-man team, allowing control of all team members by jumping to each character during certain points in the game, through various environments that have been warped by the Firstborn while fighting off a variety of twisted creatures.", 'youtube' => 'https://www.youtube.com/watch?v=wePhq7wNR-Q', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5388], 'genres' => [1], 'publishers' => [16], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 79, 'game_title' => "Command & Conquer 3: Kane's Wrath", 'release_date' => '2008-03-28', 'platform' => 1, 'overview' => 'In the name of Kane! The Command & Conquer™ series continues to thrive with Command & Conquer™ 3: Kane’s Wrath. As the expansion pack to the critically-acclaimed and fan favorite, Command & Conquer 3: Tiberium Wars™, this Real-time Strategy (RTS) game returns to the Tiberium Universe with Kane at the center of an epic new single player campaign spanning 20 years – from the rebirth of the Brotherhood of Nod after the Second Tiberium War through the dramatic events of the Third Tiberium War and beyond. This story will be told through a new set of high-definition, live action video sequences starring a celebrity cast including Joe Kucan, playing the megalomaniac leader of the Brotherhood of Nod, alongside new talent Natasha Henstridge and Carl Lumbly. With your help, Commander, the Dark Messiah may rise again!', 'youtube' => '96LNtvpIjiQ', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2579], 'genres' => [3], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 80, 'game_title' => 'Command & Conquer 3: Tiberium Wars', 'release_date' => '2007-03-26', 'platform' => 1, 'overview' => "Tiberium Wars takes place in the year 2047, at the advent of and during the \"Third Tiberium War\" when the Brotherhood of Nod launches a worldwide offensive against the Global Defense Initiative, abruptly ending 17 years of silence and crippling GDI forces everywhere. With the odds tipped in the Brotherhood's favor this time, GDI field commanders rally their troops and begin to combat Nod's second re-emergence, trying to restore lost hope. In the middle of it all, a new playable faction of extraterrestrials appears: the Scrin.", 'youtube' => 'gCimGS7I1UQ', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2727], 'genres' => [6], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 81, 'game_title' => 'Crisis Core: Final Fantasy VII', 'release_date' => '2008-03-24', 'platform' => 13, 'overview' => "Seven years prior to the events of FINAL FANTASY VII, the Shinra Company is finalizing construction of its base and symbol of prosperity: the enormous city of Midgar. When Genesis, a prominent SOLDIER 1st Class in Shinra's private army disappears with his contingent, young prodigy Zack is given the task of seeking him out. The story continues where it all began in an enthralling prelude to one of gaming's greatest sagas.\r\n\r\n-The exciting prequel to FINAL FANTASY VII uncovers the origin and secrets behind some of the most popular characters in SQUARE ENIX history.\r\n-Home console-quality graphics on a portable platform. Stunning, state-of-the-art visuals bring the FINAL FANTASY VII universe to life on the PSP & reg; system.\r\n-A blend of action and RPG elements provide for a completely new FINAL FANTASY VII experience. The fast-paced real-time battle system is the latest evolution of classic FINAL FANTASY gameplay", 'youtube' => 'PwVf7DAPIBs', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2808], 'genres' => [1, 4], 'publishers' => [12], 'alternates' => ['Crisi Core Final Fantasi VII'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 82, 'game_title' => 'Dark Sector', 'release_date' => '2008-03-25', 'platform' => 15, 'overview' => "Set in the crumbling infrastructure of a fictional Eastern Bloc country in the near future, the game features both single and multiplayer action, with players working their way through a world where biological weapons are a hellish nightmare, let loose on an unsuspecting populace.\r\n\r\nThe game's main character is a man named Hayden Tenno (voiced by Michael Rosenbaum), a morally ambivalent clean-up man employed by the CIA. He has congenital analgesia which renders him unable to feel pain. On a mission in a fictional former Eastern Bloc nation, he is exposed to a biological compound which mutates him, dramatically changing his right arm, and giving him the ability to grow a three-bladed throwable weapon called a glaive at will. The glaive is a part of his body, can be used to generate light, and can be controlled remotely by the player.", 'youtube' => '7nl8890-C2w', 'players' => 10, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2322], 'genres' => [8], 'publishers' => [31], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 83, 'game_title' => 'Final Fantasy III', 'release_date' => '1994-04-02', 'platform' => 6, 'overview' => "MagiTek has been reborn. And the end of the world is near.\r\nAges ago, evil beings created powerful creatures called Espers, and unleashed them against each other. The resulting battles left their world a smoldering rubble. Legend has it, the Espers destroyed themselves and most of humanity. Magic disappeared forever.\r\n\r\nCenturies have passed and a rational world now exists with Espers living only in myths, until one frozen solid since the ancient wars is unearthed. Suddenly, there are reports of magical attacks on civilians. Imperial Commandos launch raids using magic-powered MagiTek weapons. Magic is obviously alive and the world is in danger again.\r\n\r\nWho or what is behind the rediscovery and redeployment of this legendary power? What chaotic plans exists that will wreak havoc on this orderly world?", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => ['ファイナルファンタジーVI (JP)', 'Final Fantasy 3', 'Final Fantasy VI (JP)', 'Final Fantasy 6 (JP)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 84, 'game_title' => 'Empire Earth III', 'release_date' => '2007-11-06', 'platform' => 1, 'overview' => "Empire Earth III is a real-time strategy video game developed by Mad Doc Software and published by Sierra Entertainment, released on November 6, 2007.[1][2][3] It is the latest installment of the Empire Earth series and has generally received widespread negative reviews.[4]\r\n\r\nEmpire Earth III contains five epochs, fewer than other games in the series but covering roughly the same time period. The game features three factions: Middle Eastern, Western, and Far Eastern.[5] Each faction comprises unique buildings, units, and technologies.", 'youtube' => 'F7PS0GLrQ7M', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5130], 'genres' => [3, 6], 'publishers' => [32], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 85, 'game_title' => 'Enemy Territory: Quake Wars', 'release_date' => '2007-09-28', 'platform' => 1, 'overview' => "Quake Wars is a class-based, objective focused, team-oriented game. Teams are based on human (GDF) and alien (Strogg) technology. While the teams are asymmetrical, both sides have the same basic weapons and tools to complete objectives. \r\n\r\nUnlike other team-based online games, the gameplay is much more focused on one or two main objectives at once, rather than spread all over the combat area.", 'youtube' => 'xBm1jWchEqY', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8079], 'genres' => [8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 86, 'game_title' => 'Fallout 3', 'release_date' => '2008-10-28', 'platform' => 1, 'overview' => "Fallout 3 takes place in the year 2277, 36 years after the setting of Fallout 2 and 200 years after the nuclear apocalypse that devastated the game's world in a future where international conflicts culminated in a Sino-American war in the second half of the 21st century. The game places the player in the role of an inhabitant of Vault 101, a survival shelter the size of a village, designed to protect a small number of humans from the nuclear fallout. When the player character's father disappears under mysterious circumstances, the player is forced to escape from the Vault and journey into the ruins of Washington D.C. to track him down. Along the way the player is assisted by a number of human survivors and must battle a myriad of enemies that inhabit the area now known as the \"Capital Wasteland\".", 'youtube' => 'iYZpR51XgW0', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1009], 'genres' => [1, 2, 4, 8], 'publishers' => [34], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 87, 'game_title' => 'Final Fantasy XII', 'release_date' => '2006-10-31', 'platform' => 11, 'overview' => "Final Fantasy XII  takes place in the fictional location of Ivalice, where the empires of Archadia and Rozarria are waging an endless war. Dalmasca, a small kingdom, is caught between the warring nations. When Dalmasca becomes annexed by Archadia, its princess, Ashe, creates a resistance movement. During the struggle, she meets Vaan, a young adventurer who dreams of commanding an airship. They are quickly joined by a band of allies; together, they rally against the tyranny of the Archadian Empire.\r\n\r\nAlso Available:\r\nFinal Fantasy XII: Collector's Edition\r\n\r\nThis edition includes the original game packaged in a metallic case along with a special bonus disc, which contains Final Fantasy XII developer interviews, an art gallery, U.S. and Japanese trailers, and a featurette entitled \"History of Final Fantasy\", which gives a brief overview of most released and upcoming Final Fantasy games.", 'youtube' => 'sEpQ8rmWwRA', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2808], 'genres' => [4], 'publishers' => [12], 'alternates' => ['Final Fantasy 12', 'FFXII', 'FF12'], 'uids' => [{ 'uid' => 'SLPM-66320', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLUS-20963', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLES-54354', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLUS-21475', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLES-54355', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 88, 'game_title' => 'God of War II', 'release_date' => '2007-03-13', 'platform' => 11, 'overview' => 'Kratos is now the God of War, having defeated the Olympian god Ares. Shunned by the other gods and still haunted by nightmares from his past, Kratos decides to join an army of Spartans in an attack on the city of Rhodes. Kratos also ignores a warning from the goddess Athena that his lust for revenge is alienating the other gods.', 'youtube' => 'GjYbK_-w9pM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7435], 'genres' => [1, 15], 'publishers' => [14], 'alternates' => nil, 'uids' => [{ 'uid' => 'SCUS-97481', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-67013', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLUS-97481', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SCES-54206', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 89, 'game_title' => 'God of War: Chains of Olympus', 'release_date' => '2008-03-04', 'platform' => 13, 'overview' => "The game is set in Ancient Greece and loosely based on its mythology. The player controls Kratos, a Spartan warrior in the service of the Olympian Gods. Kratos is guided by the goddess Athena, who instructs him to find the Sun God Helios, as the Dream God Morpheus has caused the remaining gods to slumber in Helios' absence. With the power of the sun, Morpheus and Persephone, the Queen of the Underworld, with the aid of the Titan Atlas, intend to destroy the Pillar of the World and in turn Olympus. God of War: Chains of Olympus is chronologically the second chapter in the series, which focuses on vengeance as its central theme.", 'youtube' => 'TCD_lGhEzPI', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7030], 'genres' => [1, 2], 'publishers' => [14], 'alternates' => ['God-of-War'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 90, 'game_title' => 'Halo 3', 'release_date' => '2007-09-25', 'platform' => 15, 'overview' => "Master Chief returns to a Covenant Dominated Earth on a mission to kill the final alien leader. Meanwhile, the Arbiter, Johnson, and Keyes form a loose alliance and escape from Delta Halo. The Covenant is ripped in civil war, and the Elites along with a handful of other alien races become sympathetic to the human cause. Delta Halo's impromptu dis-activation has brought all of the Halos to a \"remote activation phase\". They can be activated from a facility called the ark, which happens to be on Earth.", 'youtube' => 'xhzJumt6264', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1389], 'genres' => [8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 91, 'game_title' => 'Iron Man', 'release_date' => '2008-05-06', 'platform' => 1, 'overview' => "Iron Man is a 2008 video game based on the film of the same name as well as the classic iterations of the character.[2] It was released on May 2, 2008 to coincide with the release of the film in cinemas. The game is published by Sega, and was released on PlayStation 3, Xbox 360 (developed by Secret Level), PlayStation 2, PlayStation Portable, Nintendo DS, Wii, Microsoft Windows (developed by Artificial Mind and Movement) and Mobile platforms.\r\n\r\nThe enemies are Advanced Idea Mechanics, the Maggia and the Ten Rings terrorist group. The supervillains in the game includes Blacklash, Controller, Titanium Man, Melter, and Iron Monger.[3]\r\n\r\nA significant feature has Robert Downey, Jr., Terrence Howard and Shaun Toub reprising their roles from the film.[4]", 'youtube' => '1WxdJTnn8fA', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [670], 'genres' => [1, 2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 92, 'game_title' => 'Medal of Honor: Airborne', 'release_date' => '2007-09-14', 'platform' => 1, 'overview' => 'The game begins as Boyd Travers, a member of the 82nd Airborne Division of the U.S. Army, begins his first mission in the Invasion of Sicily in 1943. The story begins with a brief training level, but then takes you to the first mission: "Operation Husky". The single player campaign includes six missions, each mission can be easily played in under two hours for a total of about 10-12 hrs of total game play.', 'youtube' => 'rbca7C_ObRc', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2563], 'genres' => [8], 'publishers' => [35], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 93, 'game_title' => 'Monster Hunter 2', 'release_date' => '2006-02-16', 'platform' => 11, 'overview' => "Monster Hunter 2 has an improved weapon tree and upgradeable armors. As in all Monster Hunter games, armor pieces can be worn to obtain skills and abilities. A new feature in Monster Hunter 2 is the use of gems. Gems add skill points to complement those added by armor and weapons. Gems are created by combining ore and/or monster parts. Gems can be attached and detached from armor and weapons that have special gem slots.\r\n\r\nAlong with the various species of monster returning from the first Monster Hunter, Monster Hunter 2 contains many new monsters, such as the metallic wind dragon Kushala Daora, the lion-headed dragon Teo Teskatoru (named Teostra in the North American and PAL versions of Monster Hunter Freedom 2) and his female counterpart Nana Teskatory (named Lunastra in the North American and PAL versions of MHF2), the primates Babakonga and Dodobrango (Congalala and Blangonga in MHF2), the bull or minotaur-like monster Rajang, and the chameleon-like dragon Oonazuchi (Chameleos in MHF2). With new monsters also comes the prospect of new weapons and armor.", 'youtube' => 'j-LuD7MPRXM', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [1436], 'genres' => [1, 4], 'publishers' => [9], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLPM-66280', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLPM-74245', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 94, 'game_title' => 'MotorStorm: Pacific Rift', 'release_date' => '2008-10-28', 'platform' => 12, 'overview' => "The game moves away from the desert environments of the original title and relocates itself in \"a lush island environment, full of interactive vegetation\"; and also includes monster trucks and four-player split-screen capability. Monster trucks are able to ride over cars (except big rigs), break most vegetation, and destroy structures. Bikes also have new capabilities so they can bunny hop and the driver can duck. Custom music tracks using a player's own music stored on their PS3 hard drive are available as are trophies (to unlock more Drivers and Vehicles) and camera angles are improved for crashes; vehicle damage is also improved. Users can now select drivers from the Garage menu, thus not having to rely on picking the vehicles, depending on the Driver's gender. \"Speed\" events are firstly introduced in the game, which consists numerous checkpoints in each tracks that users must pass through to achieve extra times before the timer runs out. Any class that isn't the ATV or Bikes can ram their vehicles left or right. The ATV and Bike ram by their driver throwing punches at the other drivers.", 'youtube' => 'DZyXHESAC5U', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2911], 'genres' => [7], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 95, 'game_title' => 'Project Gotham Racing 4', 'release_date' => '2007-11-18', 'platform' => 15, 'overview' => 'Project Gotham Racing 4 is the fourth title in the main Project Gotham Racing series, developed by Bizarre Creations and published by Microsoft Game Studios.', 'youtube' => 'dhyYj2g8hb0', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1131], 'genres' => [7], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 96, 'game_title' => 'Prototype', 'release_date' => '2009-06-09', 'platform' => 1, 'overview' => "The game is set in New York City, where a virulent plague is spreading through Manhattan. Those infected are mutated into hideous monsters. The United States Marine Corps, under the command of the black ops organization Blackwatch, is dispatched to contain it. At the center of it is the protagonist, Alex Mercer, a shapeshifter with no memory of his past. Alex has the ability to absorb other individuals, taking on their biomass, memories, experiences, and physical forms. Parallel to the game's storyline is the ability to play the game as a sandbox-style video game giving the player freedom to roam Manhattan.", 'youtube' => 'JvsUkUaJjYs', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6942], 'genres' => [1, 2], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 97, 'game_title' => 'Resistance: Fall of Man', 'release_date' => '2006-11-17', 'platform' => 12, 'overview' => "By 1949 an alien race known as the Chimera spread throughout Europe. Originating in Russia, the creatures propagate by infecting humans virally; mutating them into fellow Chimeran breeds. Their rapid infection and warfare overwhelm the continent as nations fall. Within months, the Chimera cross the English Channel by digging tunnels underneath and invade the United Kingdom, which quickly loses the war and has its troops scattered.\r\nIn 1951, the game begins with the protagonist Sgt. Nathan Hale, on his way with a large United States task force, to retrieve a secret weapon that the British claim can be used against the Chimera in exchange for supplies. However, soon after landing in York, the forces are ambushed by the Chimera and the remnants are quickly wiped out by a Chimeran spire attack, which unleashes insect like creatures that infects all of the soldiers. Hale, the only survivor, resists the full effects of infection and does not go into a coma. Instead, he possesses increased strength, health regeneration and gold-coloured irises, somewhat like the Chimera.", 'youtube' => 'nJ8Yuq8qpbM', 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [4232], 'genres' => [8], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 98, 'game_title' => 'SOCOM: U.S. Navy SEALs Confrontation', 'release_date' => '2008-10-14', 'platform' => 12, 'overview' => 'SOCOM: Confrontation focuses on online play and the global community and clans that support it. With support for Tournaments, Clan Ladders, Leader Boards, this latest title in the multi-million unit selling franchise is exactly what SOCOM fans have been clamoring for. Additionally, players will be able to modify their appearance through facial and physical customization. A global-scale experience, SOCOM Confrontation gives players the opportunity to battle against the best and brightest from the U.S., Europe and Asia. SOCOM Confrontation deploys with five new North African themed maps, including a 32-player version of "Crossroads." Additional themed packs for SOCOM Confrontation will be made available for download via the Playstation Store.', 'youtube' => 'GVWQzvfDY18', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [7837], 'genres' => [8], 'publishers' => [21], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 99, 'game_title' => 'SoulCalibur IV', 'release_date' => '2008-07-29', 'platform' => 15, 'overview' => "Soulcalibur IV (ソウルキャリバーIV SōruKyaribā Fō?) is the fifth installment in Namco's Soul series of fighting games, released for the PlayStation 3 and Xbox 360 in 2008. Soulcalibur IV included three characters from the Star Wars franchise as playable fighters.", 'youtube' => 'oHe-AxsB450', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5804], 'genres' => [1, 10], 'publishers' => [6], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 100, 'game_title' => 'Spider-Man 3', 'release_date' => '2007-05-04', 'platform' => 12, 'overview' => "The game's plot expands on the film by including additional characters and elements from the Spider-Man comics and the Marvel Universe. Depending on the platform, different villains from the comics are featured, but all versions of the game feature the film's main villains: Venom, New Goblin, and Sandman.", 'youtube' => 'O4JB4B4RXpg', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9025], 'genres' => [1], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 101, 'game_title' => 'S.T.A.L.K.E.R.: Clear Sky', 'release_date' => '2008-09-05', 'platform' => 1, 'overview' => "S.T.A.L.K.E.R.: Clear Sky is a survival FPS game for PC based on a 'what-if' scenario of the second Chernobyl Nuclear Power Plant accident. The game is set in 2011 and brings forth the events to have preceded the third campaign of Strelok to the Zone center. S.T.A.L.K.E.R.: Clear Sky introduces an alternative look onto the events of the original game and offers the player to try himself out as a mercenary s.t.a.l.k.e.r. in search of his own path in the world of S.T.A.L.K.E.R.", 'youtube' => 'IJzJU1638oc', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3645], 'genres' => [1, 8], 'publishers' => [37], 'alternates' => ['S.T.A.L.K.E.R.: Чистое небо (RU)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 102, 'game_title' => 'Star Wars: The Force Unleashed', 'release_date' => '2009-11-30', 'platform' => 1, 'overview' => "The game bridges the two Star Wars trilogies and introduces a new protagonist, code named \"Starkiller\", as Darth Vader's secret apprentice.", 'youtube' => 'RkBiYpD3SDc', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [1], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 103, 'game_title' => 'Street Fighter IV', 'release_date' => '2008-07-18', 'platform' => 1, 'overview' => 'Street Fighter IV is a 2008 fighting game produced by Capcom. It is the first numbered Street Fighter game released by Capcom for the arcades since 1999.', 'youtube' => 'JWhOsX_LAfw', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [10], 'publishers' => [9], 'alternates' => ['Street Fighter 4'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 104, 'game_title' => 'The Eye of Judgment', 'release_date' => '2007-10-24', 'platform' => 12, 'overview' => "Sony Computer Entertainment introduces a new concept in trading card games with THE EYE OF JUDGMENT™ developed exclusively for PLAYSTATION®3 computer entertainment system. Utilizing Hasbro® and its Wizards of the Coast subsidiary's trading card expertise, the immense power of the PS3® system, and the PLAYSTATION®Eye, Sony's groundbreaking next-generation USB camera for PS3, THE EYE OF JUDGMENT provides a visually stunning experience that adds a third dimension to the trading card game genre.\r\nDeveloped by Sony Computer Entertainment Worldwide Studios, JAPAN Studio, THE EYE OF JUDGMENT presents a new style of gameplay where collectable trading cards, embedded with a CyberCode, are brought to life in the 3D game through use of the innovative PLAYSTATION Eye. Players compete by selecting a card and placing the coded card in front of the PLAYSTATION Eye for their respective creatures to come to life and battle on screen. Players take turns placing cards as they jostle for control; the winner is the first player to conquer five of the nine squares of the \"9 Fields\" battle mat. The gamers task is to conquer the board by deploying their cards more skillfully than their opponent.\r\nPlayers have four ways to play THE EYE OF JUDGMENT, single player against their PS3, against an opponent in two-player mode, against an opponent online, or letting the PS3 play out a round with the cards the player owns. THE EYE OF JUDGMENT comes with a starter deck of 30 character and spell cards manufactured by Hasbro.", 'youtube' => '1OTdOjSfiSs', 'players' => 3, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4441], 'genres' => [6], 'publishers' => [38], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 105, 'game_title' => 'Wheelman', 'release_date' => '2009-03-24', 'platform' => 1, 'overview' => 'The game is set in an open world modeled after Barcelona, full of destructible objects, alleyways, shortcuts through office blocks and a total of 31 story missions and 105 side missions. While most missions are driving-oriented there are also foot missions which are played from a third person and incorporated a crouching system similar to the one used in Goldeneye. A wide variety of guns are preserved for the player including pistols to RPGs.', 'youtube' => 'TxKpYUJQ8cI', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5516], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 106, 'game_title' => "Tom Clancy's Rainbow Six: Vegas 2", 'release_date' => '2008-03-18', 'platform' => 1, 'overview' => "The game, billed as \"part sequel, part prequel\", has events that run both before and concurrently to the story of Logan Keller and continue after where the first game concluded.\r\n\r\nBishop is the main protagonist that the player controls and guides throughout the events of Rainbow Six: Vegas 2. His/her appearance and gender vary, depending on the intended look by the player. Either way, Bishop is still called \"sir\" in the game. He or she is a high-ranking veteran of the Rainbow organization, and is an instructor at the organization's training academy when the game first begins. Bishop is referred five years after the first mission in the French Alps, Bishop returns from retirement as the team leader of Jung and Michael. Bishop and Chavez are old friends and served together in the Army.", 'youtube' => 'ZfG3vjxnQlk', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9150], 'genres' => [8], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 107, 'game_title' => 'Transformers: The Game', 'release_date' => '2007-06-26', 'platform' => 1, 'overview' => "Transformers: The Game is the name of multiple versions of a video game based on the 2007 live action film Transformers, all of which were released in North America in June 2007. Home console and PC versions were developed by Traveller's Tales for the PlayStation 2, Xbox 360, Wii, PlayStation 3 and PC. A different PlayStation Portable version was developed by Savage Entertainment.\r\n\r\nTransformers Autobots and Transformers Decepticons are the Nintendo DS versions of Transfomers: The Game. Vicarious Visions, who was tasked with bringing the adaptation to the Nintendo DS, chose to adapt the DS version into two separate games.[1] Autobots follows the heroes' perspective while Decepticons follows the villains'. Unlike games with multiple SKUs such as Pokémon which feature only minor differences between versions, these are two separate games, sharing some basic similarities, but with unique characters, missions and locations.[2]", 'youtube' => 'WpkBSONusT0', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 108, 'game_title' => 'Wet', 'release_date' => '2009-09-15', 'platform' => 15, 'overview' => "Rubi is a problem fixer. She fixes problems. She's good at it. But when she agrees to fix a wealthy man's problem by finding and bringing back his wayward son, she thinks it's all going to be cut and dry. She thought wrong. The job wasn't so simple. And the man who hired her isn't who he appears to be. Now Rubi's on the run, needing to find the man who left her for dead, leaving a massive body count in her wake. Double-crosses. Enemies. Allies. Guns. Swords. Drugs. Old books. In an adventure that spans three continents, two warring factions, and one very agitated problem fixer, WET keeps the adrenaline pumping from start to finish.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [670], 'genres' => [1, 8], 'publishers' => [34], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 109, 'game_title' => 'The Legend of Zelda: Twilight Princess', 'release_date' => '2006-11-19', 'platform' => 9, 'overview' => "Join Link for an legendary adventure on the Wii console.\r\n\r\nWhen an evil darkness enshrouds the land of Hyrule, a young farm boy named Link must awaken the hero – and the animal – within. When Link travels to the Twilight Realm, he transforms into a wolf and must scour the land with the help of a mysterious girl named Midna. Besides his trusty sword and shield, Link will use his bow and arrows by aiming with the Wii Remote controller, fight while on horseback and use a wealth of other items, both new and old.\r\n\r\nFeatures\r\n\r\n* Arm Link: The Wii Remote and Nunchuk controllers are used for a variety of game activities from fishing to projectile-weapon aiming. The game features incredibly precise aiming control using the Wii Remote controller. Use the controllers for sword swings, spin attacks and shield shoves.\r\n\r\n* Thrilling Adventure: Players ride into battle against troops of foul creatures and wield a sword and shield with the Wii Remote and Nunchuk controllers, then take on massive bosses that must be seen to be believed.\r\n\r\n* Mind & Muscle: Many puzzles stand between Link and the fulfillment of his quest, so players must sharpen their wits as they hunt for weapons and items.", 'youtube' => 'ceCktUEG4jA', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6037], 'genres' => [1, 2, 4, 5, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 110, 'game_title' => 'Warhammer: Mark of Chaos', 'release_date' => '2006-11-14', 'platform' => 1, 'overview' => 'The gameplay is primarily focused on battlefield tactics, thus not featuring RTS gameplay aspects like base-building, resource harvesting or in-battle unit production. Instead, the gameplay is intended to be focused on high fantasy/late medieval battles. Its gameplay is superficially similar to its predecessors and the Total War games; however, the basic game play model is significantly more simplified, and battles are more similar to real-time strategy games like Warcraft III than other real-time tactics titles.', 'youtube' => 'https://www.youtube.com/watch?v=2iO9cGopQq0', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1140], 'genres' => [6], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 111, 'game_title' => 'Warhammer 40,000: Dawn of War II', 'release_date' => '2009-02-18', 'platform' => 1, 'overview' => "Warhammer 40,000: Dawn of War II is set in the grim, war-ravaged world of Games Workshop's Warhammer 40,000 universe - a dark, futuristic, science-fiction setting where armies of technologically advanced warriors, fighting machines and hordes of implacable aliens wage constant war. Dawn of War II ushers in a new chapter in the RTS series, as ancient races - including the dauntless Space Marines and savage Orks - clash across ruined worlds on a mission to claim the galaxy and preserve their own existence. Powered by the re-vamped Essence Engine 2.0, the next evolution of Relic's proprietary game engine made famous in the award winning Company of Heroes, Warhammer 40,000: Dawn of War II delivers fast-paced RTS action with ferocious melee and ranged combat in fully destructible environments. The game immerses players in an in-depth non-linear single-player campaign and a fully-co-operative multiplayer mode.\r\nFAQs, Guides, Cheats, and Secrets", 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7131], 'genres' => [6], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 112, 'game_title' => 'Super Mario Bros. 3', 'release_date' => '1990-02-12', 'platform' => 7, 'overview' => "Fight monsters and mini-bosses, avoid ghosts and the burning sun.  Make your way through water and quicksand.  Dodge cannonballs and bullets and rescue the King’s wand!\r\n\r\nIn Super Mario Bros. 3 there are more warps, more chances at extra lives, and new special suits!  The raccoon suit lets you fly and knock out blocks.  The frog suit helps you out-swim the deadly fish.  There are suits for every occasion!\r\n\r\nStore up flowers and mushrooms to use later on.  Play game-show type bonus rounds!  Go back to that last screen and get a mushroom!  Pause to take a break, then continue where you left off!\r\n\r\nSuper Mario Bros. 3 is fun to play alone, or team up with a buddy to prolong the adventure!\r\n\r\nNote: Turn based Co-op as players work in turn to clear individual levels in a world. There is also a vs. mini-game where players try to steal items from each other.", 'youtube' => 'PKuFlO8FdRA', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6055], 'genres' => [1, 2, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 113, 'game_title' => 'The Legend of Zelda', 'release_date' => '1987-07-01', 'platform' => 7, 'overview' => "Welcome to the Legend of Zelda.  Where the only sound you’ll hear is your own heart pounding as you race through forests, lakes, mountains and dungeonous mazes in an attempt to restore peace to the land of Hyrule.  Along the way you’ll be challenged by Tektites, Wizzrobes and an endless array of ruthless creatures who’ll stop at nothing to prevent you from finding the lost fragments of the Triforce of Wisdom.  But don’t despair.  With a little luck and a lot of courage, you’ll conquer your adversaries, unite the Triforce fragments and unravel the mystery of the Legend of Zelda!\r\n\r\n• Explore the vast Overworld terrain of the land of Hyrule and discover hidden treasures.\r\n• Explore the mystical labyrinths of the Underworld and ward-off ruthless enemies.", 'youtube' => 'uI3rO3PbYOo', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6055], 'genres' => [1, 2], 'publishers' => [3], 'alternates' => ['The Hyrule Fantasy: Zeruda no Densetsu', 'The Hyrule Fantasy: The Legend of Zelda', 'The Legend of Zelda: The Hyrule Fantasy'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 114, 'game_title' => 'Sonic the Hedgehog', 'release_date' => '1991-06-23', 'platform' => 18, 'overview' => "Super Speed! Bust the video game speed barrier wide open with Sonic the Hedgehog. Blaze by in a blur using the super sonic spin attack. Loop the loop by defying gravity. Plummet down tunnels. Then dash to safety with Sonic's power sneakers. All at a frenzied pace. Super Graphics! Help Sonic escape bubbling molten lava. Swim through turbulent waterfalls. Scale glistening green mountains. And soar past shimmering city lights. There's even a 360 degree rotating maze. You've never seen anything like it. Supper Attitude! Sonic has an attitude that just won't quit. He's flip and funny, yet tough as nails as he fights to free his friends from evil. So just wait. Sonic may be the world's next SUPER hero...", 'youtube' => 'TR7r4PlNeOY', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7979], 'genres' => [1, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 115, 'game_title' => 'Castle of Illusion Starring Mickey Mouse', 'release_date' => '1990-11-22', 'platform' => 18, 'overview' => "The search is on! Mickey is on the trail of a wicked Witch named Mizrabel, who has kidnapped Minnie. Mickey must find seven gems hidden in the fantastic chambers of Mizrabel's Castle of Illusion and use them to save Minnie. Can Mickey find them? It's up to you.\r\n\r\nBe on your guard! Behind every door lurks an enchanted land of beauty and danger. You must defeat angry chess knights, overcome the evil haunted trees, and do battle with ghoulish ghosts and a deadly dragon. No place is safe -- even the library is fraught with danger. Playing three levels in the practice mode will prepare you for the challenge you will face. Then, just when you think you've mastered the Illusions, you come face to face with the most dangerous of them all -- Witch Mizrabel!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [2, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 116, 'game_title' => 'Space Invaders', 'release_date' => '1978-06-01', 'platform' => 23, 'overview' => "Space Invaders is a two-dimensional fixed shooter game in which the player controls a laser cannon by moving it horizontally across the bottom of the screen and firing at descending aliens. The aim is to defeat five rows of eleven aliens—some versions feature different numbers—that move horizontally back and forth across the screen as they advance towards the bottom of the screen. The player defeats an alien, and earns points, by shooting it with the laser cannon. As more aliens are defeated, the aliens' movement and the game's music both speed up. Defeating the aliens brings another wave that is more difficult, a loop which can continue indefinitely.", 'youtube' => '437Ld_rKM2s', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8449], 'genres' => [8], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 117, 'game_title' => 'Space Harrier', 'release_date' => '1994-12-03', 'platform' => 33, 'overview' => "Space Harrier is set in the \"Fantasy Zone\", a surreal world composed of bright colors and a checkerboard-styled ground. The enemies are also unique, featuring prehistoric animals, Chinese dragons, and alien pods. The player is forced along the levels, running or flying around enemy fire, while shooting back with fireballs via the character's under-arm cannon (which doubles as a rocket-esque device allowing the character to fly).", 'youtube' => 'https://www.youtube.com/watch?v=Hzgrb-mjLaM', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [7549], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 118, 'game_title' => 'Altered Beast', 'release_date' => '1988-11-27', 'platform' => 18, 'overview' => "Altered Beast is a side scrolling, platform, beat 'em up game that puts the player in control of a centurion who had died in battle. The centurion has been raised from the dead to rescue Zeus' daughter Athena from the demon Neff. The player battles undead and demonic hordes, controlling the shapeshifting hero. He must fight through several levels in order to save the kidnapped goddess. Although 'Centurion' was a rank in the Roman Army, the game takes place in a setting resembling Ancient Greece, complete with gods, temples and ruined Ionic columns.", 'youtube' => 'https://www.youtube.com/watch?v=rG3pMeaqnqw', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [7549], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 119, 'game_title' => 'R-Type', 'release_date' => '1987-07-01', 'platform' => 18, 'overview' => "R-Type is set in the 22nd century, and the player flies a futuristic fighter craft called the R-9a \"Arrowhead\", named for its shape, and because it is the ninth model in the 'R' series of fighter craft (but it is the first of the series to actually be used in combat; the previous models were all prototypes). The mission is to 'blast off and strike the evil Bydo Empire'.", 'youtube' => 'https://www.youtube.com/watch?v=cGFOhrANwts', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4335], 'genres' => [8], 'publishers' => [42], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 120, 'game_title' => 'Shinobi III: Return of the Ninja Master', 'release_date' => '1994-05-18', 'platform' => 18, 'overview' => "The Shinobi master of stealth and the lethal ninja arts is back, bigger and deadlier than ever! Joe Musashi's sworn enemy, the Neo Zeed, grips the city in a vicious crime ring. Shadow Master, a super ninja cloned from Joe's own bloodline, controls the Zeed's savage army of bio-ninja. Musashi has no choice but to annihilate them all!", 'youtube' => 'https://www.youtube.com/watch?v=1wcyaZDG3f4', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [5367], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 121, 'game_title' => "Kirby's Adventure", 'release_date' => '1993-03-26', 'platform' => 7, 'overview' => "What would Dream Land be without dreams? A nightmare! The Dream Spring, source of all dreams, has dried up, taking with it all the blissful dreams of Dream Land. It's up to Kirby, the bombastic blimp, To return happy naps to the inhabitants of Dream Land! Kirby's appetite for adventure is as big as ever as he eats his way through a feast of all-new enemies! In this adventure, he can also steal the abilities of the bad guys he scarfs down! With this new power, Kirby can perform 20 new tricks that will help him make his way through the nightmare infested Dream Land! Kirby's Adventure features brand new worlds to explore with the same fun action-packed feel that made Kirby's Dream Land for Gameboy a hit!", 'youtube' => 'https://www.youtube.com/watch?v=AWbKfgZPguc', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3694], 'genres' => [2], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 122, 'game_title' => 'Contra III: The Alien Wars', 'release_date' => '1992-04-06', 'platform' => 6, 'overview' => "Welcome to 2636, the year the Notorious One gets even, with an unprecedented alien onslaught orchestrated to push 16-bit technology and its commandos to their ultimate reaches.\r\n\r\nPlunge through a molten hot massacre on a high speed voyage to the guts of the archenemy alien. Scope out the side and top perspectives and backgrounds that do a 360 to engulf you in 3-D sensation.\r\n\r\nPick off solar slimedogs like the Mutant Megasquitos and the Psycho Cyclers while you scale over walls, swing from girders and ropes, hitch rides on a missile, whatever it takes. Sweat through six gut splitting stages, including the Battle of the Blazing Sky and the Mucho Grande Badlands.\r\nThe graphics are so real the explosions will nearly knock you off your feet. And the Boss Enemies are so gigantic, your screen can hardly hold them. You'll need to wrap both hands around artillery powerful enough to make today's weapons look like squirt guns. The Contra legacy is alive and dangerous!", 'youtube' => 'https://www.youtube.com/watch?v=P7tvMb19YlE', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E10+ - Everyone 10+', 'developers' => [4765], 'genres' => [1, 8], 'publishers' => [23], 'alternates' => ['Contra Spirits (JP)', '魂斗羅スピリッツ (JP)', 'Kontora Supirittsu (JP)', 'Super Probotector: Alien Rebels (EU)', 'Contra 3', 'Contra Spirits'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 123, 'game_title' => 'Metroid', 'release_date' => '1987-08-15', 'platform' => 7, 'overview' => "It's you against the evil Mother Brain in the thrilling battle of Metroid!\r\n\r\nYou’re inside the fortress planet Zebes.  The planet of endless secret passageways where the Metroid are multiplying.  Left alone the Metroid are harmless.  But in the wrong hands they could destroy the galaxy.  It’s up to you to prevent the Mother Brain that controls Zebes from using the Metroid for evil purposes.  But that won’t be easy.  You’ll have to use your spacesuit to absorb valuable energy for your search to gain the use of power items like the Ice Beam, Wave Beam, High Jump Boots and Varia.  If you survive, it will be you and your acquired powers against the Mother Brain.\r\n\r\nWorth Noting: \r\nMetroid introduced nonlinear, side-scroller, maze-like, gameplay, in a platform, shooter. Metroid required players to discover permanent power-ups to progress further along; while backtracking through previously visited areas. The style is affectionately known as Metroid-vania' (Castlevania: Symphony of the Night being the second half to the term, mirrored the concept).\r\n\r\nMetroid also used a password system to resume progression of the game (Before the addition of battery backups and save files in console cartridges). Additionally the password system could be used for cheat codes: 'JUSTIN BAILEY ------ ------' (Just in Ballet) being famous, would remove Samus' power suit and start the player with many of the power-ups and fairly progressed through the game.\r\n\r\nCompleting the game in time and with enough power-ups revealed different endings. At the end Samus removes the helmet or power suit (depending) to a reveal a shocking suprise that endeared the character and broke new ground in gaming.", 'youtube' => 'D6jOGd0L1Hc', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6051], 'genres' => [1, 2, 8, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 124, 'game_title' => 'Worms', 'release_date' => '1995-11-29', 'platform' => 1, 'overview' => "Worms is a turn-based strategy game. It features up to 4 teams of 4 worms, aiming to destroy the others on a generated terrain. Each worm has 100 hit points, and dies when his hit points fall to 0. Upon death, a worm explodes, causing damage to everyone around.\r\n\r\nGameplay is turn-based. Each turn, the player can control one specific worm from his team. The worm can crawl left and right or jump. However, there is a time limit to make a move; also, if the worm falls from a great height, it loses health and the turn ends immediately; and if a worm falls into water or offscreen, it dies. Each turn, a worm can also make a single attack: the player can aim up and down, choose a weapon and then fire it. After attacking, the turn ends. \r\n\r\nThere's a lot of weapons available - the standard ones as bazookas (which is affected by the (random) wind settings and gravity) and grenades. The others include a Fire Punch, dynamite, air strikes, and utilities such as ropes and girders.\r\n\r\nThere are 10 styles of terrain, ranging from forests and deserts to Candy land and the moon (complete with affected gravity). Shots leave craters in the ground, and complex tunnels can be formed.", 'youtube' => 'https://www.youtube.com/watch?v=08C-ttHHKFs', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8538], 'genres' => [1, 6], 'publishers' => [43], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 125, 'game_title' => 'Mega Man 5', 'release_date' => '1992-12-04', 'platform' => 7, 'overview' => "Protoman has gone berserk! Destroying half the city was not enough. Now, he has snatched Dr. Light and is holding him and the entire city hostage. Speeding to the rescue is Mega Man and his modified Mega Buster, but eight of Protoman's cybernetic soldiers plan to send Mega Man to the scrap heap for good! Feel the weight of the world on your shoulders as you battle Gravity Man! Chip away at the rock-like defenses of Stone Man and bring him crumbling down! Hit the surf and sail up against the tidal power of Wave Man! Help Mega Man defeat all eight of Protoman's robots and then get ready for the fight that pits brother against brother in the battle of the century!", 'youtube' => 'https://www.youtube.com/watch?v=eUWn6X105l4', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Rock Man 5', 'Megaman 5'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 127, 'game_title' => 'Phantasy Star IV - The End of the Millennium', 'release_date' => '1995-02-01', 'platform' => 18, 'overview' => "Launch into the biggest RPG ever on Genesis! This is the explosive magic-and-monster packed FINALE to the incredible Phantasy Star saga. An ancient, hideous Dark Force stalks the Algol star system. You, a young hunter, are destined to become Motavia's greatest warrior and strike the death-blow that destroys evil FOREVER!", 'youtube' => 'https://www.youtube.com/watch?v=niVH43m0_2A', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [4], 'publishers' => [15], 'alternates' => ['Phantasy Star 4 - The End of The Millennium', 'Phantasy Star 4'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 128, 'game_title' => "Michael Jackson's Moonwalker", 'release_date' => '1990-08-24', 'platform' => 18, 'overview' => "\"Michael!\" Katy's voice rings out - you've found her! But more children are still lost! Can you stop the psycho mastermind Mr. Big and his goon squad before they kidnap all the kids? You can, if you're Michael Jackson! Moonwalk on muggers, lean on meanies, and pop the punks! Outfight, outjump, outdance! Move like only Michael can, to the beat of Smooth Criminal, Beat it, Billie Jean, and Bad! No bad guy can last through Michael's Star Magic! Punch down gangsters in Club 30. Rumble in the streets. Swing, spin, and kick past graveyard ghouls. Chill in the caverns, then sizzle 'em with ultra-tech weapons in Mr. Big's hideout. Experience the baddest video game ever. Defy physics with Michael's dancing! You never lose your cool. See it and be it - Michael Jackson's Moonwalker!", 'youtube' => 'Z3SpHXSpM98', 'players' => 2, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [9201], 'genres' => [2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 129, 'game_title' => 'Sonic CD', 'release_date' => '1993-09-23', 'platform' => 21, 'overview' => "Sonic's gameplay remains similar to that of Sonic the Hedgehog but with the addition of the Spin Dash and the Super Peel Out, which lets him zoom into a quick speed from a standing point.The main innovation of this chapter in the Sonic series is the manner in which the player can travel to four different versions of each zone, each a different time period of the same location: Present, Past, Good Future and Bad Future. This is accomplished by speed posts scattered around the level, bearing the labels \"Past\", and \"Future\". After running through one of these posts, the player has to run at top speed for a few seconds without stopping, to travel into the respective time period. Because these teleports are relative, there are no \"Past\" signs in the Past, and no \"Future\" signs in the Future; that is, warping to the past in the future returns the player to the \"present\" time and vice versa.", 'youtube' => 'https://www.youtube.com/watch?v=5uN9_PPOM8Y', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 130, 'game_title' => 'Kid Icarus', 'release_date' => '1986-12-18', 'platform' => 7, 'overview' => "Far away in a kingdom called \"Angel Land,\" the evil goddess Medusa has stolen the Three Sacred Treasures and imprisoned the goddess of light, Palutena. As Kid Icarus, your mission is to find the treasures, destroy Medusa and rescue Palutena from the depths of the Palace in the Sky. To find the treasures you'll travel through ruins collecting weapons and storing power for use in combat against creatures of Medusa's army. Use your bow and arrow to ward off gatekeepers of the Underworld, Overworld and Skyworld as you strive towards your battle against Medusa. Will you survive to restore Palutena's light and return it to \"Angel Land?\" Only you know!", 'youtube' => 'https://www.youtube.com/watch?v=ad2TURb5qp4', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [2], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 131, 'game_title' => 'Donkey Kong Country', 'release_date' => '1994-11-21', 'platform' => 6, 'overview' => "Madness and Mayhem in this 3-D Gorilla Thriller!\r\n\r\nDonkey Kong is back with a new sidekick, Diddy Kong, in a crazy island adventure! Challenged by the crazed tribe of reptilian Kremlings, they endeavor to get back their stolen banana horde! Armed with lightning-quick moves, chest-pounding muscle and awesome aerial acrobatics, our duo is ready to face their cunning adversaries. With the help of Donkey Kong's quirky family and his wild animal mounts, they squabble and scamper their way through the unending monkey mayhem!", 'youtube' => 'SbHL8-XkXMA', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6991], 'genres' => [1, 2, 15], 'publishers' => [3], 'alternates' => ['Super Donkey Kong'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 132, 'game_title' => 'Ecco the Dolphin', 'release_date' => '1992-07-29', 'platform' => 21, 'overview' => "The game begins with Ecco as he and his pod are swimming in their home bay. One podmate challenges him to see how high into the air he can jump. When he is in the air, a waterspout storm forms and sucks up all marine life in the bay except Ecco, leaving him alone in the bay. Upon leaving the bay to search for his pod, he contacts several dolphins from other pods, who tell him the entire sea is in chaos, and that all marine creatures had felt the storm. After talking to an orca, Ecco travels to the Arctic to find a blue whale named The Big Blue. The Big Blue tells him such storms had been occurring every 500 years and directs him to the Asterite, the oldest creature on Earth. He leaves the Arctic and travels to a deep cavern where he finds the Asterite. Although it has the power to aid him, one of its globes is missing, and needs it returned. However, this can only be achieved by traveling back in time using a machine built by the ancient Atlanteans.\r\nEcco travels to the sunken city of Atlantis, where he discovers the time machine and an ancient library. He learns the cause of the storm; it was a harvest of Earth's waters that was conducted every 500 years by an alien species known as the Vortex. The Vortex had lost their ability to make their own food, and so every 500 years, they would harvest from the waters of Earth. Learning this, he activates the time machine and travels 55 million years into Earth's past. Ecco locates the Asterite in the past but is immediately attacked by it. Forced into battle, he manages to dislodge a globe from it. This opens a time portal and he is sent back into the present. After receiving the globe, the Asterite grants him the power to turn his sonar into a deadly weapon against the Vortex, as well as the abilities to breathe underwater and to slowly regenerate lost health. The Asterite instructs him to use the time machine to travel back in time to the hour of the harvest. This time he manages to be sucked into the waterspout with his pod. Once inside the waterspout, Ecco makes his way towards the Vortex Queen, the leader of the Vortex race. Eventually, the Vortex Queen is destroyed and Ecco rescues his pod.", 'youtube' => 'PCPIJy0Rjiw', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6155], 'genres' => [2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 133, 'game_title' => 'Lemmings', 'release_date' => '1991-02-14', 'platform' => 7, 'overview' => "Lemmings was one of the most popular computer games of its time, and several gaming magazines gave it some of their highest review scores at the time.\r\n\r\nThe behavior of the creatures in Lemmings is based on the supposed behavior of real lemmings, who by urban legend are believed to go on migrations en masse that eventually lead to disaster. The basic objective of the game is to guide lemmings through a number of obstacles to a designated exit. In order to save the required number of lemmings to win, one must determine how to assign a limited number of eight different skills to specific lemmings that allow the selected lemming to alter the landscape, to affect the behavior of other lemmings, or to clear obstacles in order to create a safe passage for the rest of the lemmings.", 'youtube' => 'gZwpbu37kCI', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2404], 'genres' => [5], 'publishers' => [43, 75, 135], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 135, 'game_title' => 'Castlevania', 'release_date' => '1987-05-01', 'platform' => 7, 'overview' => "If you think it's scary on the outside, wait'll you see the basement! You're in for the longest night of your life. Ghosts, goblins, demons, wolves, bats - creatures lurking around every corner. As you descend deeper and deeper, they get thicker and thicker. Better stick close to the cavern floor - it's your only chance of finding a weapon or two. You're gonna need 'em. Because when you finally meet the Count, you know he'll be going for the jugular. So keep your courage up and your stake sharp. And say your prayers!", 'youtube' => 'ENSDrPpFp-Y', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [1, 2, 15], 'publishers' => [23], 'alternates' => ['Akumajou Dracula'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 136, 'game_title' => 'Super Mario World', 'release_date' => '1991-08-13', 'platform' => 6, 'overview' => "Mario’s off on his biggest adventure ever, and this time he’s brought along a friend.  Yoshi the dinosaur teams up with Mario to battle Bowser, who has kidnapped Princess Toadstool once again.  Guide Mario and Yoshi through nine peril-filled worlds to the final showdown in Bowser’s castle.\r\n\r\nUse Mario’s new powers and Yoshi’s voracious monster-gobbling appetite as you explore 96 levels filled with dangerous new monsters and traps.  Climb mountains and cross rivers, and descend into subterranean depths.  Destroy the seven Koopa castles and find keys to gain entrance to hidden levels.  Discover more warps and thrilling bonus worlds than ever before!\r\n\r\nMario’s back, and this time he’s better than ever!", 'youtube' => 'https://www.youtube.com/watch?v=3RPYcfgKsNI', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [15], 'publishers' => [3], 'alternates' => ['Super Mario World- Super Mario Bros. 4 (Japan)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 137, 'game_title' => "Super Mario World 2: Yoshi's Island", 'release_date' => '1995-10-04', 'platform' => 6, 'overview' => "Yoshi Returns to Save Baby Mario in this Sequel to Super Mario World!\r\nThe Evil Magikoopa, Kamek, is out to kidnap Baby Mario!  In this sequel to Super Mario World, you play as Yoshi.  Your goal is to successfully carry Baby Mario back to his parents in the Mushroom Kingdom while avoiding all of Kamek’s clever traps and evil minions.  Enjoy the various backgrounds of the rich and vibrant locales of Yoshi’s Island as you race to complete your quest.\r\n\r\nIs Yoshi up to the momentous task at hand?  Help him toss his eggs, manipulate unique objects and solve puzzling situations!  When in doubt, don’t be afraid to try EVERYTHING!!\r\n\r\n* 16 megs of memory provide 6 worlds - each with 8 stages!\r\n* Morphmation delivers powerful special effects - scaling, rotating, and 360 degree scrolling.\r\n* Huge characters and even bigger bosses require quick thinking!\r\n* Battery back-up to save your progress.", 'youtube' => 'https://www.youtube.com/watch?v=Qv-6NzxgObw', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 138, 'game_title' => 'Gunstar Heroes', 'release_date' => '1993-09-09', 'platform' => 18, 'overview' => "Gunstar Heroes is a side scrolling shooter. The player has four weapons to choose from, and they can be combined in various pairs to create a total of 14 unique weapons. In addition to the weapons, the player can engage enemies in close quarters combat. It is possible to grab and toss enemies, perform sliding and jumping attacks and a long-range skid.\r\n\r\nUnlike most games in the genre, the player has a life total calculated in numbers. Death to a player requires multiple hits but just one death will issue the option to continue from the start of the level or to end the game. Players have unlimited continues.\r\n\r\nThe main highlight of the game are its boss encounters, which often feature large enemies made up of multiple sprites allowing for fluid movement.", 'youtube' => 'https://www.youtube.com/watch?v=Y5F7pzPQ24U', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9008], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 139, 'game_title' => 'World of Illusion Starring Mickey Mouse and Donald Duck', 'release_date' => '1992-12-18', 'platform' => 18, 'overview' => "Alakazam! Here's classic Disney fun with your favorites, Mickey Mouse and Donald Duck! Transported into a world of wonder, Mickey and Donald must perform amazing feats of magic to defeat a crafty Sorcerer and find their way back home!", 'youtube' => 'https://www.youtube.com/watch?v=Buvds3POvhM', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [2, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 140, 'game_title' => 'Super Mario Bros.', 'release_date' => '1985-09-13', 'platform' => 7, 'overview' => 'Do you have what it takes to save the Mushroom Princess?  You’ll have to think fast and move even faster to complete this quest!  The Mushroom Princess is being held captive by the evil Koopa tribe of turtles.  It’s up to you to rescue her from the clutches of the Koopa King before time runs out.  But it won’t be easy.  To get to the Princess, you’ll have to climb mountains, cross seas, avoid bottomless pits, fight off turtle soldiers and a host of black magic traps that only a Koopa King can devise.  It’s another non-stop adventure from the Super Mario Bros.!', 'youtube' => 'v74SVzuyOxA', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6042], 'genres' => [1, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 141, 'game_title' => 'Paper Mario', 'release_date' => '2001-02-05', 'platform' => 3, 'overview' => "Mario pals around in an all-new action adventure! Mario's back in his first adventure since Super Mario 64, and this time, Bowser's bent on preventing a storybook ending. When Princess Peach is kidnapped, Mario plots to rescue the seven Star Spirits and rid the Mushroom Kingdom of Koopa's cruel cohorts. As he travels from the tropical jungles of Lavalava Island to the frosty heights of Shiver Mountain, he'll meet up with seven all-new companions... and he'll need help from each one or there'll be no happily ever after.", 'youtube' => 'WoGJd0k_FR8', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4248], 'genres' => [1, 4], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 142, 'game_title' => 'Sonic the Hedgehog 2', 'release_date' => '1992-11-21', 'platform' => 18, 'overview' => "Super Speed! Sonic's back and better than ever. He's a blur in blue! A blaze of action! With his new Super Spin Dash. And a new, fabulous friend, \"Tails\" the Fox. You won't believe it 'til you see it. And when you play, you won't stop. Super Play! Defy gravity in hair-raising loop-de-loops. Grab Power Sneakers and race like lightning through the mazes. Dash in a dizzying whirl across corkscrew speedway. Bounce like a pinball through the bumpers and springs of the amazing Zones. All at break-neck speed! Super Power! Sonic's attitude is can-do. The mad scientist Dr. Robotnik is planning a world takeover. Sonic gets tough in the fight to save his friends and squash Robotnik for good!", 'youtube' => 'https://www.youtube.com/watch?v=UUXFUqJOe38', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7979], 'genres' => [1, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 143, 'game_title' => 'Mega Man X', 'release_date' => '1994-01-21', 'platform' => 6, 'overview' => "Near the end of his life, Dr. Light succeeds in creating the first of a new series of robots which will change the world. Able to think and make decisions, this new robot holds great danger as well as great possibilities. Fearful of the possible consequences of unleashing his creation on the world, Dr. Light decides to seal him in a capsule and test his systems until they are totally reliable. The future will have to decide his fate...\r\n\r\nReleased from the capsule by Dr. Cain, \"X\" is born into the world of the future where the robot rebellions are a thing of the past. But when Dr. Cain tries to implement Dr. Light's designs into a new series of Reploids, something goes hideously wrong. Now the future lies on the brink of destruction and a new Mega Man must emerge to face Sigma and his forces before the human race is wiped from the planet!\r\n\r\n*12 Megs featuring 12 levels of action!\r\n*New Powers, New Abilities!\r\n*For 1 Player only.", 'youtube' => 'https://www.youtube.com/watch?v=F7Zxt7yZ2R4', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Megaman X', 'Rockman X'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 144, 'game_title' => 'The Secret of Monkey Island', 'release_date' => '1990-01-31', 'platform' => 1, 'overview' => "The game begins on the Caribbean island of Mêlée, where a youth named Guybrush Threepwood wants to be a pirate. He seeks out the Pirate Leaders, who set him three challenges to prove himself a pirate: defeat Carla, the island's swordmaster in insult swordfighting, steal a statue from the Governor's mansion, and find buried treasure.\r\nAlong the way he meets several interesting characters, including Stan the used boat salesman, Meathook (a fellow with hooks on both hands), a prisoner named Otis, the three men of low moral fiber and, most significantly, the gorgeous Governor Elaine Marley. The ghost pirate LeChuck, however, has been in love with Elaine since his living days. While Guybrush is busy, LeChuck's ghost crew abduct her, taking her to Monkey Island. Guybrush gathers a crew (Carla, Meathook, and Otis), buys a boat, and sets out to find the mysterious island and free Elaine.\r\nWhen Guybrush finally reaches Monkey Island, he explores it and discovers a band of cannibals and a strange hermit named Herman Toothrot. After he helps the cannibals recover a lost voodoo ingredient (a magical root), they provide him with a seltzer bottle filled with \"voodoo root elixir\" that can destroy ghosts. However, when Guybrush goes after LeChuck, he is told that LeChuck went to Mêlée Island to marry Elaine.\r\nGuybrush returns to Mêlée and goes to the church to prevent the wedding. When he arrives at the church wedding, he realises that Elaine had her own plan to escape. Guybrush loses the elixir and LeChuck starts beating him, until they arrive at the ship emporium where he finds a bottle of root beer. Substituting root beer for the lost ghost-fighting elixir, he sprays LeChuck and the ghost pirate is destroyed. With LeChuck defeated, Guybrush and Elaine enjoy a romantic moment, watching fireworks.", 'youtube' => 'SZHBGVblNJA', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [5068], 'genres' => [2, 5], 'publishers' => [45], 'alternates' => ['The Secret of Monkey Island'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 146, 'game_title' => 'Half-Life 2', 'release_date' => '2004-11-16', 'platform' => 1, 'overview' => "At the start of the game, the G-Man speaks to Gordon Freeman in a hallucination-like vision as he pulls Gordon out of stasis and places him on a train going to City 17. When the train arrives, Gordon gets off and proceeds through the Combine's security checkpoints where he is detained by a civil protection officer. Once in an interrogation room, the officer reveals himself to be Freeman's former co-worker and colleague, Barney Calhoun who is working undercover, and helps Freeman to get to Dr. Isaac Kleiner's laboratory. After meeting Alyx Vance, Freeman is instructed by Kleiner to step into a makeshift teleporter so that he can be safely extracted to the anti-Combine resistance base Black Mesa East along with Alyx, headed by her father, Dr. Eli Vance. However, Kleiner's pet headcrab Lamarr disrupts the machine, and Freeman finds himself — after briefly appearing in several different locations — just outside Kleiner's lab. With the Combine now alerted to his presence, Freeman works his way through the drained canal system, avoiding enemy forces and using the help of human resistance fighters  to safely arrive at Black Mesa East.", 'youtube' => 'UKA7JkV51Jw', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9289], 'genres' => [8], 'publishers' => [13], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 147, 'game_title' => 'LEGO Star Wars: The Video Game', 'release_date' => '2005-03-29', 'platform' => 1, 'overview' => "Gameplay in Lego Star Wars is geared towards family play, and as such does not feature a game over scenario. Given a specific set of characters in each scenario, based on a scene from each of the movies, up to two players can control them, using their different abilities. By walking up to another friendly character, the player can switch control over to that character, which is necessary for using some of their abilities to complete puzzles. \r\nStuds can be found by finding them, smashing or using the force on certain objects, or defeating enemies. Players will lose studs however if their character is destroyed (as opposed to losing lives). These studs can be spent on unlocking new characters for Free Play mode. Certain segments of the game feature players controlling spaceships flying on a flat plane. There are also several minikit canisters hidden throughout each level that, when collected, come together to form a vehicle. Completing certain requirements, such as collecting enough studs in a level, earns Golden Bricks that can be traded for cheats.\r\n\r\nWhen the player first starts the game, he/she must first complete Chapter I of The Phantom Menace. However, once that chapter is completed, the player may choose to play levels from the other two movies, able to play any unlocked levels in their desired order. Completing all the game's levels with full stud bars will unlock an additional chapter based on the opening scene of A New Hope.", 'youtube' => 'QwN2j_WJM-g', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8995], 'genres' => [1], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 148, 'game_title' => 'Hitman: Codename 47', 'release_date' => '2000-11-19', 'platform' => 1, 'overview' => 'The story centers around Agent 47, a bald test subject branded with a barcode tattooed on the back of his head, who is rigorously trained in methods of murder. Upon escaping from a test facility, 47 is hired by the Agency, a European contract killing organization. His mission takes him to several locations—Hong Kong, Colombia, Hungary, and the Netherlands—to assassinate wealthy and decadent criminals.', 'youtube' => 'https://www.youtube.com/watch?v=C8dtYOFPX-g', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4320], 'genres' => [1, 8, 16], 'publishers' => [26], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 149, 'game_title' => 'World of Warcraft', 'release_date' => '2004-11-23', 'platform' => 1, 'overview' => "World of Warcraft, often referred to as WoW, is a massively multiplayer online role-playing game (MMORPG) by Blizzard Entertainment, a subsidiary of Activision Blizzard. It is the fourth released game set in the fantasy Warcraft universe, which was first introduced by Warcraft: Orcs & Humans in 1994.  World of Warcraft takes place within the Warcraft world of Azeroth, approximately four years after the events at the conclusion of Blizzard's previous Warcraft release, Warcraft III: The Frozen Throne.\r\n\r\nAs with other MMORPGs, players control a character avatar within a game world in third- or first-person view, exploring the landscape, fighting various monsters, completing quests, and interacting with non-player characters (NPCs) or other players. Also similar to other MMORPGs, World of Warcraft requires the player to pay for a subscription, either by buying prepaid game cards for a selected amount of playing time, or by using a credit or debit card to pay on a regular basis.", 'youtube' => 'dYK_Gqyf48Y', 'players' => 4, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [1203], 'genres' => [4, 14], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 151, 'game_title' => 'StarCraft II: Wings of Liberty', 'release_date' => '2010-07-27', 'platform' => 1, 'overview' => 'Set in the 26th century in a distant part of the Milky Way galaxy, the game revolves around three species: the Terrans, human exiles from Earth; the Zerg, a race of insectoid genetic assimilators; and the Protoss, a species with vast psionic power. Wings of Liberty focuses on the Terrans, while the expansions Heart of the Swarm and Legacy of the Void will focus on the Zerg and Protoss, respectively. The game is set four years after the events of StarCraft: Brood War, and follows the exploits of Jim Raynor as he leads an insurgent group against the autocratic Terran Dominion. The game includes both new and returning characters and locations from the original game.', 'youtube' => 'https://www.youtube.com/watch?v=FIaEugKWF_E', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1203], 'genres' => [6], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 152, 'game_title' => 'Call of Duty: Modern Warfare 2', 'release_date' => '2009-11-10', 'platform' => 1, 'overview' => "Modern Warfare 2, the much awaited game of the year can be played in single order or in multiple player mode as it's all up to you. During the single player campaign you can control five different characters from a first person perspective and this is what makes the player more excited to play. Check out the following different characters of the game play of Modern Warfare2:\r\n\r\nSergeant Gary Sanderson (Roach) - He is a member of a multinational and elite commando unit called Task Force 141.\r\n\r\nPrivate First Class Josepha Allen (Ranger) - This is the character that is staged in Afghanistan but who works undercover for the CIA in Russia under the name of Alexei Borodini.\r\n\r\nPrivate James Ramirez (Officer of the Ranger Regiment) - He is the first battalion's 75th Ranger Regiment in United States and is an important character that serves in defending the eastern coast of United States from Russian invasion.\r\n\r\nJohn Mac Travis (Soap) - He is an important character in the final three missions of the game play. He also assumes the role of the International Space Station Astronaut.\r\n\r\nThe Plot of the Game:\r\n\r\nThis game starts of in Afghanistan where First class Joseph Allen assists in taking the city from the insurgents. General Shepherd is impressed by Allen's combat abilities and recruits him in the task force 141 which is a multi National Counter Terrorists unit which runs under Shepherds commands. In the meantime, Roach and Soap who are both dominant characters according to the games scale, are taken to a mountain of the Tian Shan to infiltrate an airbase in Kazakhstan.\r\n\r\nAllen is then sent off on an under cover mission to Russia and he works under the CIA and goes under the name of Alexei Borodin. At the Zakhaev international Airport in Moscow, Allen joins Makarov in a massacre of civilians and as the story unfolds it reveals that Marakov was aware of the true identity of Allen and wanted to expose him so that the Russian police would believe that America was responsible for all the killing and the terrorist attacks. As the Russians are to believe the Americans are responsible for the massacre killing, they are angered and ready to retaliate with a massive surprise attack on America.\r\n\r\nIn this sequel of the Call of Duty game play, the non-playable characters play a dominate role. Soap returns as an NPC and serves as the superior officer and mentor to Roach. The other important character is the mysterious Simon Ghost Riley who wears a mask to conceal his face which is actually a skull print Balaclava.", 'youtube' => 'XWIJTydRLt8?hd=1', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4187], 'genres' => [8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 153, 'game_title' => 'StarCraft', 'release_date' => '1998-03-31', 'platform' => 1, 'overview' => 'Set in the 26th century, the game revolves around three species fighting for dominance in a distant part of the Milky Way galaxy: the Terrans, humans exiled from Earth skilled at adapting to any situation; the Zerg, a race of insectoids in pursuit of genetic perfection obsessed with assimilating other races; and the Protoss, a humanoid species with advanced technology and psionic abilities attempting to preserve their civilization and strict philosophical way of living from the Zerg.', 'youtube' => 'H4Z6Rmbtk1k', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1203], 'genres' => [6], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 154, 'game_title' => 'Borderlands', 'release_date' => '2009-10-26', 'platform' => 1, 'overview' => 'Borderlands includes character-building elements found in role-playing games, leading to Gearbox calling the game a "role-playing shooter". At the start of the game, players select one of four characters, each with a unique special skill and with proficiencies with certain weapons. The four characters are: Roland the Soldier, Mordecai the Hunter, Lilith the Siren, and Brick (a Berserker) "as himself".  From then on, players take on quests assigned through non-player characters or from bounty boards, each typically rewarding the player with experience points, money, and sometimes a reward item.  Players earn experience by killing foes and completing in-game challenges (such as getting a certain number of kills using a specific type of weapon). As they gain levels from experience growth, players can then allocate skill points into a skill tree that features three distinct specializations of the base character; for example, Mordecai can become specialized in sniping, gunslinging with revolvers, or using his pet Bloodwing to assist in kills and health boosting. Players can distribute points among any of the specializations, and can also spend a small amount of in-game money to redistribute their skill points.', 'youtube' => 'O3iEuTuKvdU?hd=1', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [3423], 'genres' => [4, 8], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 156, 'game_title' => "Tom Clancy's H.A.W.X", 'release_date' => '2009-03-03', 'platform' => 1, 'overview' => "The story of the game takes place during the time of Tom Clancy's Ghost Recon Advanced Warfighter. H.A.W.X is set in the near future where private military companies have essentially replaced government-run military in many countries. The player is placed in the shoes of David Crenshaw — an ex-military elite pilot who was recruited by one of these corporations to work for them as one of their pilots, fighting whomever and whenever he is told to. Crenshaw later returns to the US Air Force together with his team, trying to prevent a full scale terrorist attack on the United States which was initiated by this military company.", 'youtube' => 'https://www.youtube.com/watch?v=-sx5l9cScOA', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [1, 8, 19], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 157, 'game_title' => "Disney's Aladdin", 'release_date' => '1993-11-26', 'platform' => 18, 'overview' => "Hang onto your carpet for ACTION and FUN! Aladdin slashes his shining scimitar to fight through Agrabah, escape the Sultan's dungeon, survive the fiery Cave of Wonders, snatch the Genie's Lamp and save Princess Jasmine from the evil Jafar! All-new technology creates animation so smooth, it's like watching a real animated film. Aladdin battles thieves and desert warriors, and barely dodges danger on his high-speed carpet. Survive Jafar's troops for a dash through special bonus rounds. Hilarious! Palace Guards drop their drawers and camels spit dirt wads. Aladdin ping-pongs like a pinball INSIDE the Genie's Lamp!", 'youtube' => 'https://www.youtube.com/watch?v=EyZ8kP_kOpw', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2383], 'genres' => [1, 15], 'publishers' => [48], 'alternates' => ['Aladdin'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 158, 'game_title' => 'Portal', 'release_date' => '2007-10-09', 'platform' => 1, 'overview' => "Portal™ is a new single player game from Valve. Set in the mysterious Aperture Science Laboratories, Portal has been called one of the most innovative new games on the horizon and will offer gamers hours of unique gameplay.\r\n\r\nThe game is designed to change the way players approach, manipulate, and surmise the possibilities in a given environment; similar to how Half-Life® 2's Gravity Gun innovated new ways to leverage an object in any given situation.\r\n\r\nPlayers must solve physical puzzles and challenges by opening portals to maneuvering objects, and themselves, through space.", 'youtube' => 'TluRVBhmf8w', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9289], 'genres' => [5], 'publishers' => [13], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 159, 'game_title' => 'Battlefield: Bad Company 2', 'release_date' => '2010-03-02', 'platform' => 1, 'overview' => "In Battlefield: Bad Company 2, the Bad Company crew again find themselves in the heart of the action, where they must use every weapon and vehicle at their disposal to survive. The action unfolds with unprecedented intensity, introducing a level of fervor to vehicular warfare never before experienced in a modern warfare action game.\r\nThe 'B' company fight their way through snowy mountaintops, dense jungles and dusty villages. With a heavy arsenal of deadly weapons and a slew of vehicles to aid them, the crew set off on their mission and they are ready to blow up, shoot down, blast through, wipe out and utterly destroy anything that gets in their way. Total destruction is the name of the game -- either online or offline, enemies will soon learn there is nowhere to hide.", 'youtube' => 'DLYdoodBh5w?hd=1', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2328], 'genres' => [1, 8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 160, 'game_title' => 'GoldenEye 007', 'release_date' => '1997-08-25', 'platform' => 3, 'overview' => "You are Bond, James Bond.\r\n\r\nYou are assigned to covert operations connected with the GoldenEye weapons satellite.  M will brief you on your mission and objectives from London.  Q Branch will support your efforts with a plentiful supply of weapons and gadgets.  Moneypenny offers you light-hearted best wishes and you’re off!\r\n\r\nYour mission begins in the heavily guarded chemical warfare facility at the Byelomorye Dam in the USSR.  Look and shoot in any direction as you navigate 12 interactive 3-D environments.  Use stealth and force as you see fit in matters of international security.  Consider the military personnel expendable.  You are licensed to kill!\r\n\r\n* Exciting 3-D environments.\r\n* Highly intelligent enemies!\r\n* Numerous Q gadgets and weapons!\r\n* Battery-backed memory saves game progress!", 'youtube' => 'VweKfwOnge0', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6991], 'genres' => [1, 2, 8, 16], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 161, 'game_title' => 'The Legend of Zelda: Ocarina of Time', 'release_date' => '1998-11-23', 'platform' => 3, 'overview' => "Ganondorf, the evil King of Thieves, is on the move, threatening the peaceful land of Hyrule.  He is determined to steal his way into the legendary Sacred Realm in hopes of harnessing the power of the mythical Triforce.  As the young hero Link, it is your destiny to thwart Ganondorf’s evil schemes.  Navi, your guardian fairy, will guide you as you venture through the many regions of Hyrule, from the volcanic caves of Death Mountain to the treacherous waters of Zora’s Domain.  Before you complete this epic quest, you’ll delve into deadly dungeons, collect weapons of great power and learn the spells you need to conquer the most irresistible force of all-time.\r\n\r\n• The immersive storyline and environments draw players into an amazing 3D world.\r\n• Time travel allows you to play as Link in different stages of his life.\r\n• New gameplay features include a unique targeting system and 1st and 3rd person perspectives.\r\n• Up to three games can be saved simultaneously to memory!", 'youtube' => 'gw1e2qFhGzY', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6043], 'genres' => [1, 2, 4, 5, 15], 'publishers' => [3], 'alternates' => ['Zelda No Densetsu Toki No Ocarina', 'Legend of Zelda, The - Ocarina of Time'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 162, 'game_title' => 'Banjo-Kazooie', 'release_date' => '1998-06-29', 'platform' => 3, 'overview' => "Action and Puzzles and Bears. Oh My!\r\n\r\nTrouble brews when Gruntilda the witch captures the unbearably beautiful cub, Tooty. But before the grisly hag can steal the bear’s good looks, big brother Banjo and his fine-feathered friend, Kazooie, join forces to stop her. Combining their 24 moves and special powers, Banjo and Kazooie will fend off armies of beasts. Bear and bird must hunt down the 100 puzzle pieces and 900 musical notes that will ultimately lead them to Gruntilda. However, miles of swamp, desert and snow and one bear of an adventure stand in their way.\r\n\r\n• Soar over islands to scout out buried treasure.\r\n• Brave past whirling blades in the belly of a mechanical shark.\r\n• With some voodoo magic, transform into different creatures to gain special powers.\r\n• Solve the puzzles of the ancients to unearth the cursed labyrinths.", 'youtube' => '3wiv-mQPl5M', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6991], 'genres' => [1, 2, 15], 'publishers' => [3], 'alternates' => ['Banjo to Kazooie no Daiboken (JP)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 163, 'game_title' => 'Paradise', 'release_date' => '2006-04-21', 'platform' => 1, 'overview' => "# Paradise PC From the creator of the award-wining series Syberia comes Benoit Sokal s fascinating new work, Paradise. Sokal s latest adventure game masterpiece is set in four different worlds in the heart of darkest Africa. From the arid lands of Madargane to the dense jungle of the Maurane river, the world is both primitive and contemporary. Fraught with political turmoil, the lush landscapes are beautiful and dangerous.You play Ann Smith, a young woman suffering from amnesia struggling to make her way home and avoid the conflict surrounding her. To discover her true identity, she must escort a strange black leopard back to the land where it was born. Follow Ann through her journey as she finds clues to her identity and unravels the truth behind her mysterious past.  A benchmark in art direction: Benoit Sokal, creator of the award-winning Syberia series contributes his unique vision in 4 visually dazzling worlds with over 360 backgrounds and Rembrandt-style lighting.\r\n# Unique Storyline: Ann Smith, estranged daughter of an African dictator, loses her identity and must journey through uncharted Africa to unravel her past and the mysterious existence of her leopard companion.\r\n# Unique Setting: First Adventure game to feature landscapes of Africa as a backdrop.\r\n# Play as the leopard: When day turns to night, players become the leopard and move in real time, climbing trees, leaping boundaries and frightening humans. This option adds a real-time element to the traditional point and click gameplay.\r\n# Puzzle solutions are seamlessly embedded into the story: For example, players must find a way to speak with the well-guarded prince, so they must pose as one of his wives to gain access (no gadgets or levers to pull).", 'youtube' => 'https://www.youtube.com/watch?v=lOTd1PWNMzU', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9601], 'genres' => [2], 'publishers' => [7, 2212], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 164, 'game_title' => 'Metro 2033', 'release_date' => '2010-03-16', 'platform' => 1, 'overview' => "Set in the shattered subway of a post apocalyptic Moscow, Metro 2033 is a story of intensive underground survival where the fate of mankind rests in your hands. In 2013 the world was devastated by an apocalyptic event, annihilating almost all mankind and turning the earth's surface into a poisonous wasteland. A handful of survivors took refuge in the depths of the Moscow underground, and human civilization entered a new Dark Age. The year is 2033. An entire generation has been born and raised underground, and their besieged Metro Station-Cities struggle for survival, with each other, and the mutant horrors that await outside. You are Artyom, born in the last days before the fire, but raised Underground. Having never ventured beyond your Metro Station-City limits, one fateful event sparks a desperate mission to the heart of the Metro system, to warn the remnants of mankind of a terrible impending threat. Your journey takes you from the forgotten catacombs beneath the subway to the desolate wastelands above, where your actions will determine the fate of mankind.", 'youtube' => 'Xc2hhef-Nzo', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [90], 'genres' => [1, 8], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 165, 'game_title' => 'Dynasty Warriors 6', 'release_date' => '2008-02-19', 'platform' => 15, 'overview' => 'Dynasty Warriors 6 (真・三國無双５ Shin Sangoku Musōu 5?) is a hack and slash video game set in Ancient China, during a period called Three Kingdoms (around 200AD). This game is the sixth official installment in the Dynasty Warriors series, developed by Omega Force and published by Koei. The game was released on November 11, 2007 in Japan; the North American release was February 19, 2008 while the Europe release date was March 7, 2008. A version of the game was bundled with the 40GB PlayStation 3 in Japan.[8] Dynasty Warriors 6 was also released for Windows in July 2008.[9] A version for PlayStation 2 was released on October and November 2008 in Japan and North America respectively. An expansion, titled Dynasty Warriors 6: Empires was unveiled at the 2008 Tokyo Game Show[10] and released on May 2009.', 'youtube' => 'QSYchTMF8Go', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6242], 'genres' => [1], 'publishers' => [50], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 166, 'game_title' => 'Mario Kart: Double Dash!!', 'release_date' => '2003-11-17', 'platform' => 2, 'overview' => 'The Mushroom Kingdom just got a whole lot more hectic as Mario and friends double up for furious kart racing. This time around, each kart holds two racers that can switch places at any time, so choose from a huge cast of favorites and pair them up any way you see fit. The character in front handles the driving duties, while the character in the rear doles out damage with six normal items and eight special items that only specific characters can use. Get ready for some intense multiplayer mayhem with your favorite characters, including Mario, Luigi, Donkey Kong, Peach, Bowser, and Koopa.', 'youtube' => 'CRbidBwajBc', 'players' => 4, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 7, 11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 167, 'game_title' => 'Mario Party 4', 'release_date' => '2002-10-21', 'platform' => 2, 'overview' => "Toad, Koopa, and other party-planning pranksters have hidden birthday presents for their closest friends inside the Party Cube. To win the presents, Mario, Yoshi, Peach, and other Mushroom Kingdom favorites will have to plunge into a circus of minigame trickery. As always, keep an eye out for Bowser and his trouble-making goons. Even Whomp and Thwomp have rockin' surprises for you in their Extra Room. Packed with surprises, wild multiplayer action, and zany challenges, Mario Party 4 is your ticket to a good time.", 'youtube' => 'Yjs04Woae98', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [1, 5, 11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 168, 'game_title' => 'Mario Party 8', 'release_date' => '2008-05-29', 'platform' => 9, 'overview' => 'All new features/boards! Mario Party for Wii also includes dozens of new mini-games, six new party boards and many new game modes. In a series first, players can transform their characters into many forms, such as player-smashing boulders and coin-sucking vampires. Mario Party Wii includes "extra large" mini games like Star Carnival Bowling and Table Menace. One to four players can play Mario Party, each with a Wii Remote.', 'youtube' => 'https://www.youtube.com/watch?v=oHfCG0UrezI', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [5], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 169, 'game_title' => 'Mario Kart Wii', 'release_date' => '2008-04-27', 'platform' => 9, 'overview' => 'Mario and friends once again jump into the seat of their go-kart machines for the first Wii installment of this popular franchise. New features this year are an online racing mode, new motorbike vehicle types, a special balancing system for new and veteran players, and (in its initial release) a special Mario Kart wheel packaged with the game.', 'youtube' => 'nWybPOrwzdY', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 170, 'game_title' => 'New Super Mario Bros. Wii', 'release_date' => '2009-11-15', 'platform' => 9, 'overview' => "Run and jump to your way to fun with Mario & friends!\r\n\r\n- Play together with up to 4 friends or family members\r\n\r\n- Rediscover legendary 2D gameplay loved by millions\r\n\r\n- Fun, simple controls—just like classic Mario games\r\n\r\nDevelopers at Nintendo have dreamed of creating a simultaneous multiplayer Super Mario Bros. game for decades. The Wii console finally makes that dream come true for everyone. Now players can navigate the side-scrolling worlds alone as before or invite up to three others to join them at the same time on the same level at any point in the game for competitive and cooperative multiplayer fun. With the multiplayer mode, the newest installment of the most popular video game franchise is designed to bring yet another type of family entertainment into living rooms and engage groups of friends in fast-paced Super Mario Bros. fun.\r\n\r\n- New Super Mario Bros. Wii offers a combination of cooperation and competition. Players can pick each other up to save them from danger or toss them into it.\r\n\r\n- Mario, Luigi and two Toads are all playable characters, while many others from the Mushroom Kingdom make appearances throughout the game. Players can even ride different Yoshi characters and use their tongues to swallow enemies, items and even balls of fire.\r\n\r\n- In some areas, players use the motion abilities of the Wii Remote™ controller. The first player to reach a seesaw might make it tilt to help his or her character reach a higher platform – or might make it tilt incorrectly just to mess with other players.\r\n\r\n- New items include the propeller suit, which will shoot players high into the sky with just a shake of the Wii Remote, and Mario’s new ability to transform into Penguin Mario.\r\n\r\n- At the end of each stage during the coin battle multiplayer mode, players are ranked based on the number of coins they have collected.", 'youtube' => 'ht8r30Vk9P0', 'players' => 4, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 2, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 171, 'game_title' => 'Super Mario Bros. 2', 'release_date' => '1988-10-09', 'platform' => 7, 'overview' => 'Mario’s back!  Bigger and badder than ever before!  This time it’s a fierce action-packed battle to free the land of Subcon from the curse of the evil Wart.  It’s up to you, along with Mario, Luigi, Toad and the Princess, to fight your way through bizarre multi-level worlds and find him!  This time you’ve got a brand new kind of power - plucking power - and now anything you find can be a weapon.  But beware!  You’ve never seen creatures like these!  Shyguys and Tweeters!  Ninji and Beezos!  And you’ve never had an adventure like this!  Only cunning and speed can save you now…', 'youtube' => 'mMFdeYwPEQQ', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6055], 'genres' => [1, 2, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 172, 'game_title' => 'Metroid Prime', 'release_date' => '2002-11-17', 'platform' => 2, 'overview' => "Ten years ago, beneath the surface of Planet Zebes, the mercenaries known as \"Space Pirates\" were defeated by interstellar bounty hunter Samus Aran. Descending to the very core of the pirate stronghold, Samus exterminated the energy based parasites called \"Metroids\" and defeated Mother Brain, the leader of the pirate hoarde.\r\n\r\nBut the Space Pirates were far from finished. Several pirate research vessels were orbiting Zebes when Samus fought on the surface below.\r\n\r\nAfter the fall of Mother Brain, the ships escaped, with the hope of finding enough resources to rebuild their forces and take their revenge.\r\n\r\nAfter discovering a possible pirate colony on planet Talon IV, Samus has once again prepared for war, hoping to end the Pirate threat forever.", 'youtube' => 'https://www.youtube.com/watch?v=kLfkkSD15zQ', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7160], 'genres' => [1, 2, 8, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 173, 'game_title' => 'Perfect Dark', 'release_date' => '2000-05-22', 'platform' => 3, 'overview' => "Step into the Dark... As Carrington Institute's most promising new Agent, Joanna Dark must uncover the truth behind the dataDyne Corporation's recent technological breakthroughs - breakthroughs which could have serious consequences for mankind.", 'youtube' => 'N6VTzPU-yiE', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [6991], 'genres' => [1, 8, 16], 'publishers' => [51], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 174, 'game_title' => 'The Legend of Zelda: The Wind Waker', 'release_date' => '2003-03-24', 'platform' => 2, 'overview' => "The game is set on a group of islands in a vast sea—a first for the series. The player controls Link, the protagonist of the Zelda series. He struggles against his nemesis, Ganondorf, for control of a sacred relic known as the Triforce. Link spends a large portion of the game sailing, traveling between islands, and traversing through dungeons and temples to gain the power necessary to defeat Ganondorf. He also spends time trying to find his little sister.\r\nThe Wind Waker follows in the footsteps of Ocarina of Time and its sequel Majora's Mask, retaining the basic gameplay and control system from the two Nintendo 64 titles. A heavy emphasis is placed on using and controlling wind with a baton called the Wind Waker, which aids sailing and floating in air. Controversial during development for its use of cel shading graphics and younger Link character, The Wind Waker received acclaim on release and is one of the Nintendo GameCube's most popular games.\r\n\r\n* The \"Tingle Tuner\" is a special item allowing a second player to control the character Tingle if the system is connected to a Game Boy Advance by a link cable.", 'youtube' => '', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6043], 'genres' => [1, 2, 4, 5, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 175, 'game_title' => "The Legend of Zelda: Majora's Mask", 'release_date' => '2000-10-26', 'platform' => 3, 'overview' => "Link’s all-new epic adventure lands him in the mystical world of Termina, where ever-present clocks count down the hours until a menacing moon falls from the sky above.  When his horse and Ocarina are stolen by a strange, masked figure, Link embarks on an urgent quest to solve the mystery of the moon, save the world from destruction, and find his way back to the peaceful land of Hyrule!\r\n\r\n* Link transforms before your eyes--Over 20 magical masks give Link powers and abilities he’s never had before!  Watch him transform into a hapless Deku child, a mighty Goron hero and a legendary Zora guitarist.\r\n* Race against time--Characters and events flow with the hours of the day.  Set your own schedule and even alter time itself in a race to stop the moon and save the world!\r\n* Panoramic environments!  Powered-up action battles!  Fully interactive characters and events!  Experience gorgeous rendered landscapes, swarms of attacking enemies and a deep, engrossing world of wonders with the power of the N64 Expansion Pak.\r\n\r\nAlso Available\r\nThe Legend of Zelda: Majora's Mask Collector's Edition", 'youtube' => 'iWkRpOBPW8A', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6043], 'genres' => [1, 2, 4], 'publishers' => [3], 'alternates' => ['Zelda No Densetsu Mujura No Kamen', "Legend of Zelda, The - Majora's Mask"], 'uids' => nil, 'hashes' => nil },
    { 'id' => 176, 'game_title' => 'Banjo-Tooie', 'release_date' => '2000-11-20', 'platform' => 3, 'overview' => "Grunty returns—and that's bad news for Banjo and Kazooie! In this all-new adventure, combine everything you learned in the award-winning prequel, Banjo-Kazooie, with dozens of brand-new moves and abilities. Explore eight original worlds—like a monstrous factory and a dilapidated amusement park. Solve incredible puzzles that link those worlds together—sometimes you'll have to complete tasks in several worlds to solve a single puzzle!\r\n\r\n• Divide and conquer! The bear and bird are back, and this time, they can split up and work alone.\r\n• Play as Mumbo! Now you'll get to take control of the bone-headed shaman himself.\r\n• Meet Humba Wumba! She'll transform Banjo into a number of objects, such as a walkin', talkin' statue or a tightie whitie shootin' washer.\r\n• Four-player mini-games! Play over a dozen mini-games, including five different shootout modes.", 'youtube' => 'dU6wLNrii9Y', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6991], 'genres' => [1, 2, 5, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 178, 'game_title' => 'Diddy Kong Racing', 'release_date' => '1997-11-21', 'platform' => 3, 'overview' => "Timber the Tiger's parents go on vacation and leave their son in charge of the island they live on, leaving him and his friends to race for fun. Their enjoyment is derailed when an evil, intergalactic, pig wizard named Wizpig arrives at peaceful Timber's Island and attempts to take over after he conquered his own planet's racetracks. He turns the four island's guardians: Tricky the Triceratops, Bubbler the Octopus, Bluey the Walrus and Smokey the Dragon into his henchmen. The only solution available to the island's inhabitants is to defeat Wizpig in an elaborate series of races that involves cars, hovercrafts, and airplanes. Drumstick, the best racer on the island, failed this challenge and was transformed into a frog by Wizpig's black magic. Timber recruits a team of 7 racers: Diddy Kong, the first recruit; Conker (Dixie Kong on DS), recruited by Diddy; Banjo (Tiny Kong on DS), also recruited by Diddy; Krunch, Diddy's enemy who follows after him; Tiptup, an inhabitant of Timber's island; Pipsy, another inhabitant of Timber's island; and Bumper, another inhabitant of Timber's island. They eventually complete all of Wizpig's challenges and confront Wizpig himself to a race and defeat him. Shortly afterwards, Wizpig leaves for his home planet, Future Fun Land. Fearing that Wizpig would again attempt to invade Timber's Island, the islanders travel to Future Fun Land for a second challenge. When Wizpig loses the second race, the rocket he rides on malfunctions and blasts him to a distant planet and peace returns to Timber Island for good.", 'youtube' => 'XXvzvNZYOjc', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6991], 'genres' => [2, 7], 'publishers' => [51], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 179, 'game_title' => 'Full Throttle', 'release_date' => '1995-04-30', 'platform' => 1, 'overview' => 'The story is set in a dystopian future where motorized vehicles are giving way to anti-gravitational hovercrafts. A hardened biker named Ben is the leader of a motorcycle gang called the Polecats. As his gang rides down Highway 9, they come across an expensive white hovercraft limousine. Ben, in the lead, unceremoniously drives over the limousine, crushing the hood ornament. Unknown to the gang, the limo belongs to Malcolm Corley, the CEO and founder of the last domestic motorcycle manufacturer in the country, Corley Motors. Intrigued and impressed, Corley demands his driver catch up to the gang.', 'youtube' => 'https://www.youtube.com/watch?v=qj_1s_X3I-0', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [2, 5], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 180, 'game_title' => 'The Dig', 'release_date' => '1995-11-01', 'platform' => 1, 'overview' => "A DEEP SPACE ADVENTURE BY SEAN CLARK IN COLLABORATION WITH FILMMAKER STEVEN SPIELBERG\r\n\r\nAn asteroid the size of a small moon is on a crash course toward Earth, and only NASA veteran Boston Low has the expertise to stop it. Along for the ride are award-winning journalist Maggie Robbins and internationally renowned geologist Ludger Brink.\r\n\r\nOnce the wayward asteroid is nuked into a safe orbit, the trio conducts a routine examination of the rocky surface.\r\n\r\nWhat they uncover is anything but routine.\r\n\r\nLow, Brink and Robbins unwittingly trigger a mechanism that transforms the asteroid into a crystal-like spacecraft. The team is hurtled across the galaxy to a planet so desolate, Brink is moved to name it Cocytus, after the 9th circle of Hell in Dante’s inferno. The bleak landscape was obviously once home to a highly evolved civilization, with remnants of sophisticated architecture, advanced technology and an intricate network of underground tunnels.\r\n\r\nBut no Cocytans.\r\n\r\nWho were the original inhabitants of this once rich empire-turned-wasteland? What are those apparitions that mysteriously appear from time to time? Why have Low, Robbins, and Brink been brought to this place? And how can Low keep his team from unraveling in the face of such uncertainty? To return to Earth, they must dig for answers, both on the planet’s surface and deep within themselves.\r\n\r\nFrom the combined talents of LucasArts and legendary Steven Spielberg comes an epic adventure that plunges headlong into the very core of the unknown. And takes you with it.", 'youtube' => 'https://www.youtube.com/watch?v=jRMGxQCitRU', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5068], 'genres' => [2], 'publishers' => [25], 'alternates' => ['thedig'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 181, 'game_title' => 'Blood Bowl', 'release_date' => '2009-06-26', 'platform' => 1, 'overview' => 'Blood Bowl - the game of fantasy football. Based on the famous Warhammer fantasy world and American football, Blood Bowl is a combination of a classic strategy game and a sports game. It’s also an incredibly brutal game, where you lead your team through bonecrunching leagues to compete in the prestigious Blood Bowl Cup! Create your team from the 8 playable races: Humans, Orcs, Wood Elves, Dwarves, Skaven, Lizardmen, Chaos or Goblins and manage them as they gain experience through the many championships and tournaments taking place in the Old World.', 'youtube' => 'https://www.youtube.com/watch?v=t3xsSN7UEFI', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2005], 'genres' => [6], 'publishers' => [53], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 183, 'game_title' => 'Shining Force', 'release_date' => '1992-03-19', 'platform' => 18, 'overview' => "Shining Force is a turn-based tactical RPG. Battles take place in square grids, and each unit occupies 1 square. Each unit can move up to a fixed amount of squares along the battlefield, determined by its Move statistic. Depending on its location relative to enemies and to allies, a unit can also perform one action: attack, cast a spell, use an item, or search the area. Some commands, such as equipping or dropping items, don't count as actions. The order of turns is determined by the unit's agility score and a random seed.", 'youtube' => 'https://www.youtube.com/watch?v=pewTGCkt4qE', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [1421], 'genres' => [4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 184, 'game_title' => 'Shining Force II', 'release_date' => '1994-10-19', 'platform' => 18, 'overview' => "Shining Force II is a tactical role-playing game. The player assumes the role of the Shining Force leader, Bowie. When not in combat, the player can explore towns and other locales, talk with people, and set the members and equipment of the army. Some towns have a headquarters where the player can inspect and talk with his allies. While roaming through town or moving throughout the world, one can find both visible and hidden treasures and interact with certain objects.\r\nEach ally unit is represented by a character with a background and personality. Some of these characters are hidden, requiring specific events to occur before they will join the force. Each ally unit also has a class, which defines the abilities for that unit. These abilities range from what type of weapons they can use to what kind of spells they can learn. Units can become stronger by fighting enemies and performing various actions which gives them experience points (EXP), which allow them to gain levels. Once a unit reaches level 20, that character has the ability to advance to more powerful class through promotion. Some characters have two different classes they may be promoted to, one of which is only accessible using a special hidden item.\r\nBattles take place on a square grid, and each unit occupies a single square. Battle is turn-based. Each turn, a character can move and perform one action: either attack, cast a spell, or use an item. Some commands, such as equipping or dropping an item during the turn, do not count as actions.\r\nThe battle is won if all enemies are defeated, or if the enemy commander is defeated. If Bowie is defeated in combat or withdraws, the battle is lost and the player is returned to the nearest town, where he can recover his allies and fight the same battle again.", 'youtube' => 'https://www.youtube.com/watch?v=zNXND3tgFfk', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [1421], 'genres' => [4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 185, 'game_title' => 'Shining Force III', 'release_date' => '1998-08-12', 'platform' => 17, 'overview' => "Scenario 1, God Warrior of the Kingdom, features Synbios, a young general from the Republic of Aspinia. Aspinia was once a part of the Empire of Destonia, but seceded after a war of independence spearheaded by some of the more democratic-minded nobles. They opposed Emperor Domaric's totalitarian policies, which disenfranchised a large number of people, creating a huge disparity between the wealthy and the poor. Tensions remained between Aspinia and Destonia after the secession, marked by occasional border disputes.\r\n\r\nAs the game begins, Synbios is part of a military force representing Aspinia at a peace conference in the neutral city of Saraband. Due to manipulation by outside forces - later discovered to be connected with a religious cult known as the \"Bulzome Sect\" - full-scale war breaks out again between Aspinia and Destonia. The majority of the game's storyline covers this conflict as well as Synbios and his team's fight against the Bulzome sect. Throughout the game Synbios has periodic encounters with Medion, Destonia's youngest prince, who also recognizes the truth behind the war. Although on opposite sides of the war, the two work together to identify the real threat.", 'youtube' => 'https://www.youtube.com/watch?v=nYlGQONqczc', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1421], 'genres' => [4, 6], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 186, 'game_title' => 'Mass Effect', 'release_date' => '2007-11-20', 'platform' => 1, 'overview' => "Mass Effect is set in the year 2183 AD. Thirty-five years prior, humankind discovered a cache of technology on Mars, supposedly built by a technologically advanced but long-extinct race called the Protheans. Studying and adapting this technology, humanity has managed to break free of the solar system and has established numerous colonies and encountered various extraterrestrial species within the Milky Way galaxy. Utilizing alien artifacts known as Mass Relays, the various space-faring races are able to travel instantly across vast stretches of the galaxy. Within the game, humanity has formed the Human Systems Alliance, one of many independent bodies that make up the collective of \"Citadel space\".\r\nThe Human Systems Alliance is a rising power in the galactic stage. The only war they have participated in was the \"First Contact War\" in 2157. A human exploration expedition was activating dormant mass relays (which was a practice considered unsafe by citadel races). The turians attacked the small fleet and proceeded to capture the closest human world, Shanxi. The turians proceeded to starve out the remaining humans and occupy the planet. Facing starvation the human garrison surrendered to the Turian Hierarchy. One month later, the human Second Fleet responded by annihilating the turian fleet around Shanxi. In response the turians prepared for full scale war. The citadel council saw that humanity would either be annihilated or annexed by the turians and stepped in. The humans were then given an embassy in the Citadel Council.\r\nCitadel space, as a whole, is ruled by a body of government known as the Council, which is made up of members of the three prominent alien races: the asari, a race of mono-gendered aliens which closely resemble blue-skinned human females; the short-lived salarians; and the raptor-like turians. Other alien species seen in the game include the reptilian krogan, the four-eyed, humanoid batarians, the aquatic hanar, and the methodical and quadrupedal elcor, and the environmental-suited quarians and volus. Dozens of other aliens are asserted to exist throughout the galaxy, but are not seen or mentioned in the game.\r\nThe game takes place primarily in two locations: the prototype frigate SSV Normandy, and the Citadel, a gigantic, ancient space station purportedly built by the Protheans and which currently acts as the center of galactic civilization. Throughout the game, however, the player may navigate the Normandy to various planets, moons and other destinations.", 'youtube' => 'yqJuJTIus7U?rel=0&hd=1', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1086], 'genres' => [1, 4, 8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 187, 'game_title' => 'Mass Effect 2', 'release_date' => '2010-01-26', 'platform' => 1, 'overview' => 'After the events of the original game, Commander Shepard is killed in an ambush by a mysterious alien species called the Collectors. Shepard is revived two years after the attack by an enigmatic organization called Cerberus, and is tasked with finding out more about the Collectors and why they are abducting entire human colonies. Shepard must build a team in order to accomplish what seems to be a suicide mission.', 'youtube' => 'Y2O-0-fQOOs', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1086], 'genres' => [1, 8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 188, 'game_title' => 'Teenage Mutant Ninja Turtles IV: Turtles In Time', 'release_date' => '1992-08-01', 'platform' => 6, 'overview' => "Sunday evening. You're sitting around the sewer watching your main reported, April O'Neil do a live remote from the Statue of Liberty. Then it happens. A humungoso flying android screams out of the sky and rips Lady Liberty from her foundation, sending hundreds of freaked out tourists into the harbor below. \"No way!\" cries Raphael. \"Way,\" replies Donatello. And the crazy quantum chase is on!\r\nJourney through ten levels of enormous arcade graphics, the largest and craziest talking Turtles ever with eons of bodacious battlegrounds, from prehistoric to futuristic galaxies. To prepare for the toughest Shred-heads you've ever seen, try the Versus mode, a Turtle-on-Turtle combat arena that finally proves who's the mightiest mutant of all. Also test your slice-em-up speed in the Time Trials mode to find out how fast you can clear three courses.\r\nGet ready for the 3-D jab and toss that sends enemies flying right in your face. Mondo body slams and pizza power bonuses make you more Turtle than ever before. You better believe you're going to need it. Shredder's out for Turtle hide. And he's got all the time in the world to get it.", 'youtube' => 'https://www.youtube.com/watch?v=NVLkssVwRbY', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4765], 'genres' => [1], 'publishers' => [23], 'alternates' => ['Teenage Mutant Ninja Turtles 4', 'Teenage Mutant Hero Turtles: Turtles in Time', 'TMNT IV Turtles In Time'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 189, 'game_title' => 'Mario Bros.', 'release_date' => '1986-06-01', 'platform' => 7, 'overview' => "Mario and Luigi are doing some underground plumbing when all sorts of weird creatures come flying out of the pipes. Turtles, crabs - even fighterflies - attack the helpless Mario Bros. It's up to you to kick, punch, and knock out these sewer pests before time runs out! But beware. Just when you think you got rid of them, they come back for more! Play against the computer, or with a friend - either way, this is one underground classic you'll want to play time and time again!", 'youtube' => 'https://www.youtube.com/watch?v=ly8DofqCuOs', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 15], 'publishers' => [3], 'alternates' => ['Mario Bros. Classic'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 190, 'game_title' => 'Batman: Arkham Asylum', 'release_date' => '2009-09-15', 'platform' => 1, 'overview' => "The Dark Knight takes on his greatest challenge yet when he becomes trapped with all of his most dangerous villains inside the insane asylum of Gotham City—Arkham Asylum! Batman: Arkham Asylum exposes you to a unique, dark and atmospheric adventure that takes you to the depths of Gotham's psychiatric hospital for the criminally insane. With amazing graphics and a moody, immersive setting, Batman: Arkham Asylum offers diverse gameplay options that push the envelope for all action, adventure, and superhero games.\r\n\r\nSuper villains: Confront Gotham's most notorious lunatics, including The Joker, Harley Quinn, Bane, Poison Ivy, and Killer Croc.\r\n\r\nBatman's arsenal: Utilize Batman's detective skills and cutting-edge forensic tech to gather evidence and clues.\r\n\r\nSilent killer: Move in the shadows and strike fear amongst your enemies.\r\n\r\nMelee combat: Unleash brutal combos with the innovative FreeFlow combat system.", 'youtube' => 'https://www.youtube.com/watch?v=dErlfFt1mUc', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7288], 'genres' => [1, 2], 'publishers' => [26], 'alternates' => ['Batman Arkham Asylum GOTY Edition'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 191, 'game_title' => 'Red Dead Redemption', 'release_date' => '2010-05-18', 'platform' => 15, 'overview' => "From the official webpage:\r\n\r\n\"America, early 1900's. The era of the cowboy is coming to an end.\r\n\r\nWhen federal agents threaten his family, former outlaw John Marston is sent across the American frontier to help bring the rule of law. Experience intense gun battles, dramatic train robberies, bounty hunting and duels during a time of violent change.\r\n\r\nRed Dead Redemption is an epic battle for survival in a beautiful open world as John Marston struggles to bury his blood-stained past, one man at a time.\"", 'youtube' => 'https://www.youtube.com/watch?v=3gBctl1h_2o', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [7273], 'genres' => [1, 2, 8, 12], 'publishers' => [17], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 192, 'game_title' => 'Warhammer 40,000: Dawn of War - Soulstorm', 'release_date' => '2008-03-04', 'platform' => 1, 'overview' => "The Kaurava conflict began after a sudden appearance of a Warp Storm near Kaurava IV. The nine races were drawn to investigate the system with their own fleets and conflicting intentions. However, the Warp Storm wreaked havoc on their navigation interfaces, stranding them on the four planets and three moons of the system. The nine factions are then forced to battle between planets to ultimately conquer the planetary system and discover the reason for the warp storm.\r\n\r\nThe reason for the Warp Storm, as explained after the conquest of Chaos Forces, began with an ignorant Imperial Guardsman with latent psyker genes who was whispered to by the Chaos Gods, telling him to prepare a ritual. His actions unknowingly summoned the Alpha Legion to the Kaurava System, thus starting the conflict.", 'youtube' => 'https://www.youtube.com/watch?v=Uh9W8QIei8A', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7131], 'genres' => [6], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 193, 'game_title' => 'Halo 3: ODST', 'release_date' => '2009-09-22', 'platform' => 15, 'overview' => 'A UNSC Orbital Drop Shock Trooper must locate his missing squad members in New Mombasa following a devastating slip space rupture caused by a Covenant cruiser.', 'youtube' => 'https://www.youtube.com/watch?v=oyZHajCu8GU', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1389], 'genres' => [1], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 194, 'game_title' => "Tom Clancy's Ghost Recon Advanced Warfighter 2", 'release_date' => '2007-03-06', 'platform' => 15, 'overview' => "Tom Clancy's Ghost Recon Advanced Warfighter 2 (GRAW 2) is a tactical shooter video game released for Xbox 360, Microsoft Windows, PlayStation 3 and PlayStation Portable. It is the sequel to Tom Clancy's Ghost Recon Advanced Warfighter.\r\n\r\nThe game takes place in 2014, immediately after the events of Tom Clancy's Ghost Recon Advanced Warfighter (GRAW), just south of the Mexico-United States border, and deals with the conflict between a Mexican rebel group, Mexican loyalists, and the U.S. Army for a time span of 72 hours. A wide array of location types are included, featuring mountains, small towns, urban environments, and a large hydro-electric dam just north of the border.", 'youtube' => 'https://www.youtube.com/watch?v=_nKkrtrOYO0', 'players' => 16, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7097, 9147], 'genres' => [1, 8], 'publishers' => [4566], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 195, 'game_title' => 'Marvel vs. Capcom: Clash of Super Heroes', 'release_date' => '1999-03-25', 'platform' => 16, 'overview' => 'The game takes place within the Marvel comic continuity, as Professor Charles Xavier calls out for heroes to stop him before he merges with the consciousness of Magneto and becomes the being known as Onslaught, the final boss.  While the gameplay was typical of the Marvel vs. Capcom series, Marvel vs. Capcom was distinguishable by two features: the ability to summon assist characters, and the Duo Team Attack.', 'youtube' => 'https://www.youtube.com/watch?v=JN1Lgh-EC4A', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 196, 'game_title' => 'Metal Gear Solid', 'release_date' => '1998-10-21', 'platform' => 10, 'overview' => 'Metal Gear Solid follows Solid Snake, a soldier who infiltrates a nuclear weapons facility to neutralize the terrorist threat from FOXHOUND, a renegade special forces unit. Snake must liberate two hostages, the head of DARPA and the president of a major arms manufacturer, confront the terrorists, and stop them from launching a nuclear strike.', 'youtube' => 'lt2K45vwTM4', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4765], 'genres' => [1], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 197, 'game_title' => 'Warhammer Online: Age of Reckoning', 'release_date' => '2008-09-16', 'platform' => 1, 'overview' => "Warhammer Online: Age of Reckoning features Mythic's Realm versus Realm (RvR) combat system, originally developed in Dark Age of Camelot. This takes place within three different racial pairings: Dwarfs vs. Greenskins, Empire vs. Chaos, and High Elves vs. Dark Elves. Although there are only two races per pairing, players may travel to either of the other two pairings to help fight with their friends and allies. There are four types of RvR combat: Skirmishes (random world encounters), Battlefields (objective-driven battles in RvR-specific areas), Scenarios (instanced, point-based battles against the opposing faction), and Campaigns (invading enemy lands and capital cities). RvR contribution includes both Player vs. Player (PvP) combat and (to a lesser extent) Player vs. Environment (PvE) quests so that you can assist your realm in their victory, regardless of preferred play-style.", 'youtube' => '-68bXPgH9Dk', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5784], 'genres' => [4], 'publishers' => [35], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 198, 'game_title' => 'Classic NES Series: Zelda II: The Adventure of Link', 'release_date' => '2004-10-25', 'platform' => 5, 'overview' => "The Adventure of Link bears little resemblance to the first game in the series. The Adventure of Link features side-scrolling areas within a larger world map rather than the bird's eye view of the previous title. The game incorporates a strategic combat system and more RPG elements, including an experience points (EXP) system, magic spells, and more interaction with non-player characters (NPCs). Link has extra lives; no other game in the series includes this feature.", 'youtube' => 'https://www.youtube.com/watch?v=5NloyMdr2iY', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6043], 'genres' => [4], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 200, 'game_title' => 'Ikaruga', 'release_date' => '2002-09-05', 'platform' => 16, 'overview' => "Several years ago in the small island nation of Horai, the leader of the nation, Tenro Horai, discovered the Ubusunagami Okinokai—the Power of the Gods. This energy emanated from an object she dug up from deep underground and granted her unimaginable powers. Soon after, Tenro and her followers, who called themselves \"The Divine Ones\", began conquering nations one after another. \"The Chosen People\" carried out these conquests in \"the name of peace\".\r\n\r\nMeanwhile, a freedom federation called Tenkaku emerged to challenge Horai. Using fighter planes called Hitekkai, they fought with the hope of freeing the world from the grips of the Horai - but all their efforts were in vain. They were no match for the Horai and were eventually almost completely wiped out. Miraculously, however, one young man survived. His name was Shinra (森羅?).\r\nShot down near a remote village called Ikaruga, inhabited by elderly people who had been exiled by the Horai's conquests, Shinra was dragged from the wreckage and nursed back to health. Shinra regained his health and pledged to defeat the Horai, and the villagers entrusted him with a fighter plane that they had built themselves, called the Ikaruga.\r\n\r\nThe Ikaruga was no ordinary plane, designed by former engineering genius Amanai (天内?) with the help of Kazamori (風守?) and the village leaders. Hidden in a secret underground bunker and launched via the transportation device called the \"Sword of Acala\", it is the first fighter built that integrates both energy polarities, and is capable of successfully switching between the two.", 'youtube' => 'https://www.youtube.com/watch?v=yQwiY56IHwk', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9008], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 201, 'game_title' => 'Uncharted 2: Among Thieves', 'release_date' => '2009-10-13', 'platform' => 12, 'overview' => 'Uncharted 2: Among Thieves is the story of Nathan Drake, a fortune-hunter with a shady reputation and an even shadier past who is lured back into the treacherous world of thieves and mercenary treasure-seekers. The tenth game by premier PlayStation 3 developer Naughty Dog, Uncharted 2: Among Thieves allows players to take control of Drake and embark on a journey that will push him to his physical, emotional and intellectual limits to discover the real truth behind the lost fleet of Marco Polo and the legendary Himalayan valley of Shambhala', 'youtube' => 'tlkkceDkT88', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5839], 'genres' => [1, 2], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 202, 'game_title' => '1942', 'release_date' => '1984-12-01', 'platform' => 23, 'overview' => '1942 is set in the Pacific theater of World War II. The goal is to reach Tokyo and destroy the entire Japanese air fleet. The player pilots a plane dubbed the "Super Ace" (but its appearance is clearly that of a Lockheed P-38 Lightning). The player has to shoot down enemy planes; to avoid enemy fire, the player can perform a roll or "loop-the-loop".', 'youtube' => 'q1kfbflDxpM', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [8], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 203, 'game_title' => 'Aero Fighters', 'release_date' => '1994-01-01', 'platform' => 6, 'overview' => "Aero Fighters (known as Sonic Wings in Japan) is a vertical-scrolling shoot 'em up (\"shmup\") arcade game released in 1992 by Video System, ported to the Super Famicom in 1993 and the Super Nintendo in 1994.\r\n\r\nThere are 8 stages in this game. The beginning stages consists of randomly chosen areas from nations of unselected fighters (assuming those fighters have nations). If Rabio or Lepus is chosen, all 4 rival nation stages become playable. After completing all rival nation stages, there are 4 more stages.", 'youtube' => '7GLM3Ui7Q6w', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9375], 'genres' => [8], 'publishers' => [24], 'alternates' => ['Sonic Wings'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 204, 'game_title' => 'Super Bubble Bobble MD', 'release_date' => '1986-01-01', 'platform' => 18, 'overview' => "Super Bubble Bobble MD is an unlicensed Sega Mega Drive game most likely developed by Gamtec. As the name suggests, it is an unlicensed attempt at mimicking the formula of Taito Bubble Bobble.\r\n\r\nThe game allows the user to play as Bub and Bob, as well as anime characters Crayon Shin-chan and Doraemon.", 'youtube' => 'P_KDc1JEfpE', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [3393], 'genres' => [1], 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 205, 'game_title' => 'BurgerTime', 'release_date' => '1987-01-01', 'platform' => 7, 'overview' => "You play as Chef Pepper and your goal is to make giant hamburgers while evil eggs, sausages and pickles chase you around the game area. \r\n\r\nTo properly make a hamburger you must assemble all of the ingredients together, dropping them from higher up onto the the burger area below. To actually do this you have to let Chef Pepper step all over the burger ingredients. As soon as an ingredient (a piece of lettuce for instance) has been stepped on, it will fall to the next level below. Falling food will squish any enemy following you and will also\"bump\" any other ingredient bellow it farther down. Also, as an emergency defense against the enemy food, you can collect pepper shakers which will allow you to puff out a small pepper cloud which will momentarily stun enemies, allowing you to walk past them.", 'youtube' => 'XGbhhqwRKAc', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2126], 'genres' => [5], 'publishers' => [55], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 206, 'game_title' => 'Commando', 'release_date' => '1988-05-04', 'platform' => 22, 'overview' => 'Super Joe is armed with a sub-machine gun (which has unlimited ammunition) as well as a limited supply of hand grenades. While Joe can fire his gun in any of the eight directions that he faces, his grenades can only be thrown vertically towards the top of the screen, irrespective of the direction Joe is facing. Unlike his SMG bullets, grenades can be thrown to clear obstacles, and explosions from well placed grenades can kill several enemies at once.', 'youtube' => '43rLg3mRX8g', 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [1436], 'genres' => [8], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 207, 'game_title' => 'DigDug', 'release_date' => '1982-01-01', 'platform' => 22, 'overview' => "The objective of Dig Dug is to eliminate underground-dwelling monsters. This can be done by inflating them until they pop or by dropping rocks on them. There are two kinds of enemies in the game: Pookas, round red monsters (said to be modeled after tomatoes) who wear yellow goggles, and Fygars, green dragons who can breathe fire. The player's character is Dig Dug, dressed in white and blue, and able to dig tunnels. Dig Dug is killed if he is caught by either Pooka or Fygar, burned by a Fygar's fire, or crushed by a rock.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [748], 'genres' => [5], 'publishers' => [70], 'alternates' => %w[Dig-Dug digdug], 'uids' => nil, 'hashes' => nil },
    { 'id' => 208, 'game_title' => 'Double Dragon', 'release_date' => '1987-01-01', 'platform' => 7, 'overview' => 'Double Dragon is the story of Billy and Jimmy Lee, twin brothers who learned to fight on the cold, tough streets of the city. Their expert knowledge of the martial arts combined with their street smarts, has made them both formidable fighting machines. But now Billy is faced with his greatest challenge. Marian has been kidnapped by the Black Warriors, the savage street gang of the mysterious Shadow Boss! Using whatever weapons come to hand - knives, whips, bats, rocks, oil drums, even dynamite - Billy must pursue the gang through the slums, factories, and wooded outskirts of the city to reach the hideout for his final confrontation with the Shadow Boss... his brother Jimmy!', 'youtube' => 'Ex22iGhSTQ0', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [8607], 'genres' => [1], 'publishers' => [56], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 209, 'game_title' => 'Golden Axe', 'release_date' => '1989-05-01', 'platform' => 18, 'overview' => "The game takes place in the fictional land of Yuria, a Conan the Barbarian-style high fantasy medieval world. An evil entity known as Death Adder has captured the King and his daughter, and holds them captive in their castle. He also finds the Golden Axe, the magical emblem of Yuria, and threatens to destroy both the axe and the royal family unless the people of Yuria accept him as their ruler. The character of Death Adder and the stolen Golden Axe could well be traced to the historical event of the Acquisition of the True Cross during the Sassanid-Byzantine wars, as the Norse mythology is heavily influenced by Greek and Middle Eastern mythologies.\r\nThe player controls one of three Warriors. The first is a battle axe-wielding dwarf, Gilius Thunderhead, from the mines of Wolud, whose twin brother was killed by the soldiers of Death Adder. Another is a male barbarian, Ax Battler, wielding a two handed broadsword looking for revenge for the murder of his mother. The last is a long-sword-wielding Tyris Flare, an amazon, whose parents were both killed by Death Adder.", 'youtube' => 'hiHjrQlO2RQ', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [7549], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 211, 'game_title' => 'Rad Racer', 'release_date' => '1987-08-17', 'platform' => 7, 'overview' => "This is no ordinary game pak. This is Rad Racer. Nintendo's thrilling 3-D video game Rad Racer comes action-packed with revolutionary 3-D technology and 3-D glasses (they're free inside) that will have you really believing you're in the middle of a cross-country rally race - cruising along at 200 miles per hour! Rad Racer takes you through 8 treacherous race courses including the Los Angeles Nightway, the San Francisco Highway and the Grand Canyon. Choose the Ferrari and you'll enter a Super Machine competition where you'll race against Corvettes and Lamborghinis. Select the F-1 Machine and you'll compete against incredibly fast cars. Whether it's Ferrari or F-1, 3-D or regular mode, Rad Racer's hairpin curves, daredevil turns and realistic action will bring home all the fun and excitement of real rally racing. Think you're up to it? Then drivers, start your engines. It's Rad Racer!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8096], 'genres' => [7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 212, 'game_title' => 'Chubby Cherub', 'release_date' => '1985-01-01', 'platform' => 7, 'overview' => "Q-tarō's friends are kidnapped by several burglars. Q-tarō has to save them, however many dogs are in the way—Q-tarō's one fear as a ghost. Q-tarō the Ghost (Chubby Cherub in the English version) has to cross 12 levels, at the end of each, the protagonist will find his friends. Eating food maintains Chubby Cherub's flight. If the flying meter goes all the way down, the character will have to stay on ground. The character will bark at the dogs before they bark at the character; if a bark hits the character, the character may die.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8959], 'genres' => [1], 'publishers' => [57], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 213, 'game_title' => 'Excitebike', 'release_date' => '1984-11-30', 'platform' => 7, 'overview' => "Whether the player chooses to race solo or against computer-assisted riders, he/she races against a certain time limit. The goal is to qualify for the Excitebike (the championship) race by coming in at third place or above in the challenge race (preliminary race). The times to beat are located on the stadium walls (for first place) and in the lower left corner (for third place). In any race, the best time is 8 seconds ahead of third place. When the player places first, then they get a message: \"It's a new record!\" Additional points are earned by beating the previously-set record time.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6057], 'genres' => [7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 215, 'game_title' => 'DoDonPachi', 'release_date' => '1997-02-05', 'platform' => 24, 'overview' => 'The player takes on the role of a squadron fighter facing a race of mechanized aliens that recently appeared and started causing havoc. There are three different ships to choose between, and each ship can be played in Laser or Shot mode.', 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [1510], 'genres' => [8], 'publishers' => [58], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 216, 'game_title' => 'Super Mario 64', 'release_date' => '1996-09-29', 'platform' => 3, 'overview' => "Mario is super in a whole new way! Combining the finest 3-D graphics ever developed for a video game and an explosive sound track, Super Mario 64 becomes a new standard for video games. It's packed with bruising battles, daunting obstacle courses and underwater adventures. Retrieve the Power Stars from their hidden locations and confront your arch nemesis - Bowser, King of the Koopas!", 'youtube' => 'cx78guiPMP8', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 2, 5, 15], 'publishers' => [3], 'alternates' => ['Super Mario 64: Shindou Edition'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 217, 'game_title' => 'Command & Conquer', 'release_date' => '1995-08-31', 'platform' => 1, 'overview' => 'Command & Conquer was released in 1995 as the first installment of the identically named RTS series developed by Westwood Studios. Set in an alternate history 1995, Command & Conquer tells the story of two globalized factions: the Global Defense Initiative of the United Nations, and the ancient quasi-cult, quasi-state organization, the Brotherhood of Nod. These two factions become locked in a mortal struggle for control over a mysterious resource known as Tiberium that is slowly spreading and infecting the world.', 'youtube' => 'Aui392986EE', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9595], 'genres' => [6], 'publishers' => [48], 'alternates' => ['Command & Conquer - Tiberian Dawn'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 218, 'game_title' => 'Command & Conquer: Tiberian Sun', 'release_date' => '1999-08-27', 'platform' => 1, 'overview' => 'Tiberian Sun is the third part in the Command & Conquer series and was released by Westwood & EA in 1999. Tiberian Sun features three factions, each with its unique strengths and tactics; the Global Defense Initiative GDI, the Brotherhood of NOD and The Forgotten, a non-playable & neutral faction of mutants who have been physically and mentally affected by the Tiberium. The storyline follows the continuing struggle between the GDI and NOD, the latter of which is ready to launch a new set of surprise sneak attacks in an attempt to wipe the Global Defense Initiative off the face of the Earth.', 'youtube' => 'F38Me0tFaLc', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9595], 'genres' => [6], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 219, 'game_title' => 'Command & Conquer: Renegade', 'release_date' => '2002-02-26', 'platform' => 1, 'overview' => "Renegade's story takes place during the final days of the First Tiberium War originally depicted in Command & Conquer. GDI's top three Tiberium research specialists have been abducted by the Brotherhood of Nod. The player assumes the role of GDI commando Captain Nick \"Havoc\" Parker, who is assigned to rescue these experts. He conducts missions which take him all over the world in various countries and climates, both indoor and outdoor, and his actions greatly affect the current state of the war. As the game progresses it is revealed that the specialists have been forced into biochemistry research for the Brotherhood's top secret \"Project Re-Genesis,\" An attempt to create genetically enhanced super-soldiers with the aid of Tiberium.\r\nAs the player plays through a mission, the in-game EVA, or Electronic Video Assistance, periodically updates with mission objectives. EVA logs and updates all objectives and their current status. Objectives are categorized into three categories: primary, secondary and tertiary. The completion of primary objectives are crucial for that mission's success. Secondary objectives are not required for mission completion, but may assist in game play. Tertiary missions, which are usually hidden, do not assist much in game play, but will affect your final \"rank\" at the end of each mission.", 'youtube' => '7ErlZle6Gac', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9595], 'genres' => [8], 'publishers' => [35], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 220, 'game_title' => 'Command & Conquer: Red Alert', 'release_date' => '1996-10-31', 'platform' => 1, 'overview' => "Command & Conquer: Red Alert is the 2nd release in Westwoods Real-Time-Strategy series Command & Conquer and was published in 1996 by Virgin Interactive. Red Alert takes place during an unspecified period in the 1950s of a parallel universe, which was inadvertently created by Albert Einstein in a failed attempt to prevent the horrors of World War II.\r\nStarting off in 1946, at the Trinity site in New Mexico, the opening to Red Alert shows Albert Einstein as he is preparing to travel backwards through space and time. After his experimental \"Chronosphere\" device is activated, he finds himself in Landsberg, Germany, in the year 1924, where he meets a young Adolf Hitler just after the latter's release from Landsberg Prison. Following a brief conversation between the two, Einstein shakes Hitler's hand, and this somehow eliminates Hitler's existence from time and returns Einstein to his point of origin.\r\nWith the threat of Nazi Germany having been successfully removed from history, the Soviet Union began to grow increasingly powerful under the rule of Joseph Stalin. Had Adolf Hitler risen to power, Nazi Germany would have emerged as a force standing in the way of Stalin's own ambitions of conquest. Instead, left unweakened, the USSR proceeds by seizing lands from China and then begins invading Eastern Europe, in order to achieve Joseph Stalin's vision of a Soviet Union stretching across the entire Eurasian landmass. In response, the nations of Europe form into the Alliance, and start a grim and desperate guerrilla war against the invading Soviet army. Over the course of the game's story, the Allies and Soviets fight out a devastating conflict for control over the European mainland, in what has become an alternate World War II.", 'youtube' => 'bSXu_3qtsl4', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9595], 'genres' => [6], 'publishers' => [48], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 221, 'game_title' => 'Command & Conquer: Red Alert 2', 'release_date' => '2000-10-23', 'platform' => 1, 'overview' => "After the attempted conquest of Europe, the Soviet Union is in utter ruin. Joseph Stalin is dead, and the Soviet military has been all but destroyed. The Allies determine that a regime change would cause mass unrest in the Soviet Union, and in order to gain both support and stability in the region, the victorious Allies name Alexander Romanov, a distant relative of Czar Nicholas II, as the puppet Soviet Premier. Romanov acquiesces to the Allies' demands at first, though he builds up the Soviet military for \"defense purposes\" – a cover for an intended invasion of the United States of America.\r\nThe game's story line starts off with the American military being caught completely off guard by the sudden massive Soviet invasion of the USA, with Soviet aircraft, naval vessels, amphibian forces, and paratroopers coming in on both the East Coast and West Coast and with the majority of Soviet ground forces coming in through Mexico, which had recently voted in a communist government. The USA attempts to retaliate with the use of nuclear missiles, but Yuri, leader of the Soviet Psychic Corps and Premier Romanov's top advisor, uses his mind control to manipulate the personnel charged with launching the warheads and leaves them to explode in their silos. Within hours, the USA is overrun with Red Army troops. In response, the US President Michael Dugan establishes an emergency response team headed by General Carville and the Commander (the player).", 'youtube' => '2YlVumsPHx4', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9595], 'genres' => [6], 'publishers' => [35], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 222, 'game_title' => 'Metal Slug', 'release_date' => '1996-05-24', 'platform' => 24, 'overview' => "In 2028, General Donald Morden launches an all-out, global attack against the Regular Army. With superior numbers and equipment, the Rebellion overwhelms the unsuspecting Regular Army troops easily. \r\n\r\nThe attacks could have been countered effectively, or even prevented, should the high-ranking officials have listened to the Regular Army's intelligence community, which had been warning about all sorts of indications that the Rebellion could attack at any moment in decisive force. Unfortunately, the same officials decide to save their own skins and announce that it was the intelligence failure that led to such catastrophe, which the personnel serving in the intelligence community did not appreciate whatsoever. \r\n\r\nMeanwhile, Regular Army is pushed to near annihilation, with cities that it was suppose to be protecting in ruins. General Morden makes an announcement that all of the major cities around the world will be under his control within 170 hours, also adding that any resistance would be futile. \r\n\r\nThe announcement certainly did not discourage a band of Regular Army soldiers attempt to salvage whatever they had left. Shortly after, a group named \"Resistants\" are formed by surviving members of the Regular Army and its researchers, who began to covertly convert the Metal Slug tank prototypes into combat-ready status in a hidden factory, hoping to launch a counter-offensive to regain what they had lost to the Rebellion. Morden just as quickly learns of this fact and attacks the plant, crushing the Resistants and capturing the tanks, putting an end to the counterattack even before it could begin. The vehicles are then scattered to prevent any ragtag Regular Army troops reclaiming them and using them to launch attacks. \r\n\r\nSeeing the Regular Army panic and crumble, 1st Lieutenant Marco Rossi of the Regular Army Peregrine Falcons special forces unit quickly unites remaining Regular Army units and begins a commando operation to reclaim the tanks. Fighting alongside him is Second Lieutenant Tarma Roving from the same unit. Their main objectives were to engage the Rebellion and neutralize its leader, General Morden, while reclaiming the Metal Slug tanks to aid them in battles. If the tanks could not be recaptured, then they would have to destroy them to prevent them from being used by the Rebellion. \r\n\r\nThe player has to constantly shoot at a continual stream of enemies in order to reach the end of a level. At the end of each level, the player might confront a boss who is often considerably larger than regular enemies and takes many shots to defeat. On the way through the level, the player finds weapons upgrades and \"Metal Slug\" tanks that can be used not only as weapons but also as added defense.\r\nThe protagonists can perform melee attacks by using a knife and/or kicking. The player does not die for simply coming into contact with most enemies. Correspondingly, many of the enemy troops have melee attacks. Much of the game's scenery is destructible. Sometimes this reveals extra items or powerups, most of the time it simply results in collateral damage.\r\n\r\nDuring the course of a level, the player encounters prisoners of war. If they are freed, the player can receive bonuses in the form of random items or weapons. The player receives a score bonus for freeing POWs at the end of the level; at this point the game shows the name and rank for each of the prisoners freed. If the player dies before the end of the level, the tally of freed POWs is restarted.\r\nThere are a total of six levels, with themes ranging from forests, garrisoned cities, snowy mountain valleys, canyons, and military bases.", 'youtube' => '_UfHv7jksSo', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [5849], 'genres' => [1, 2, 8], 'publishers' => [60], 'alternates' => ['mslug'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 223, 'game_title' => 'Metal Slug 2', 'release_date' => '1998-04-02', 'platform' => 24, 'overview' => "General Morden, the antagonist from the first game is back once more with his army, bent on taking over the world. It is up to the Peregrine Falcon squad, who are now joined by two new characters: Eri Kasamoto and Fiolina Germi of the Sparrows Intelligence Unit, to save the day.\r\nAs the levels unfold, it turns out that Morden has allied with Martians to help facilitate his plans. In the final level of the game, the tables are turned when Morden comes under attack and is betrayed by his Martian allies and taken prisoner by them. An ad-hoc alliance is formed between the Peregrine Falcon squad and General Morden's army to combat the greater alien threat. After a long battle, they succeed in defeating the Martians' Mothership, driving them off the Earth. Morden seems to have fallen from the ship, strapped to a solid iron plate. While his soldiers celebrate, the plate loses its balance and crushes him.", 'youtube' => 'U1Tt3BQ6pi4', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7885], 'genres' => [1, 2, 8], 'publishers' => [60], 'alternates' => ['mslug2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 224, 'game_title' => 'Metal Slug 3', 'release_date' => '2000-06-01', 'platform' => 24, 'overview' => "The rebellion orchestrated by General Morden to bring about a new global regime is now ancient history, and order and peace has begun to return to the world. Morden, brought back into power, was attempting another coup d'état, but government forces got wind of the plot beforehand and pre-empted the impending assault.\r\nInstrumental in squashing Morden's rebel forces, Marco and Tarma of the Peregrine Falcon Strike Force are ordered to lead the team after their earlier requests for resignation were denied. Although General Morden has been written off as \"missing\" by his followers, they have hidden themselves throughout the world, and Marco and Tarma's abilities and experience are seen as a necessity to destroy remaining rebel strongholds, one by one. Throughout the furious fighting against the holdouts, Marco and Tarma cannot help but suspect Morden's involvement in this new evil plan for world domination.", 'youtube' => 'biFBCq5ouik', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [1, 2, 8], 'publishers' => [60], 'alternates' => ['mslug3'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 225, 'game_title' => 'Metal Slug 4', 'release_date' => '2002-07-19', 'platform' => 24, 'overview' => "One year after the events of Metal Slug 3, the world is trembling under the new threat of a mysterious but deadly cyber virus that threatens to attack and destroy any nation's military computer system. With Tarma and Eri unable to help due to their own assignments in the matter, Marco and Fio are called in to investigate the situation and are joined by two newcomers, Nadia and Trevor. In their investigation, the group discovers that a terrorist organization known as Amadeus is behind the nefarious plot and that they head into battle against Amadeus' forces, hoping to destroy the cyber virus before it gets the chance to wipe out the entire world's military computer system.", 'youtube' => 'Xq3S8kwgURA', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5366], 'genres' => [1, 2, 8], 'publishers' => [61], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 226, 'game_title' => 'Metal Slug 5', 'release_date' => '2003-11-01', 'platform' => 24, 'overview' => 'A special disc that contains deep and intricate secrets about the Metal Slug project is stolen by a mysterious group called the Ptolemaic Army, whose specialty lies from within archaeological excavation and espionage. Marco and Tarma of the Peregrine Falcon Strike Force follow in hot pursuit against the group and in the process are joined by Eri and Fio of SPARROWS. Together once more, the quartet investigate the shrouded objective of the Ptolemaic Army.', 'youtube' => 'FiDEoycsd5A', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7885], 'genres' => [1, 2, 8], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 227, 'game_title' => 'Metal Slug 6', 'release_date' => '2006-02-24', 'platform' => 23, 'overview' => "Metal Slug 6 returns to the Rebel-Martian alliance featured in Metal Slugs 2, X, and 3, but on a much broader scale. Rather than repeating the previous games' events of the Martians breaking the alliance and the Rebels assisting the player in turn, the player now teams up with the Rebels and Martians to combat an even greater threat.\r\n\r\nMetal Slug 6 introduces a new play mechanic dubbed the 'Weapon Stock System'. Two gun power-ups can now be carried at the same time. Players can switch between the two weapons, or simply put them both away in favor of the default weapon. When obtaining a new weapon power-up, it will automatically occupy the inactive slot, or, if both are holstered, replace the less recent weapon of the two.\r\nThe score is now multiplied by powers of 2. The faster the speed at which enemies are killed, the higher the power, as a meter at the bottom of the screen shows. When it says \"Max\" enemies and destructible objects will drop coins for an extra high score.", 'youtube' => 'prOR8pSXC-U', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [7885], 'genres' => [1, 2, 8], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 228, 'game_title' => "Cruis'n USA", 'release_date' => '1996-12-18', 'platform' => 3, 'overview' => "Slam the pedal to the metal and hang on for a wild race across the highways of America. Catch tall the roadside scenery and famous landmarks from three different driving perspectives -- from San Francisco's Golden Gate Bridge, South Dakota's Mount Rushmore to the rolling hills of Appalachia.\r\n\r\nExperience the treacherous turns and famous landmarks as you drive across America!\r\n\r\nSelect one of five difficulty levels and even remove street traffic or rivel racers from the course.\r\n\r\nSelect one of ten short courses or go the distance on an textended 14-stage road race.\r\n\r\nA split screen perspective allows two players to share the action simultaneously.\r\n\r\nWith the N64 Controller as your steering wheel,you have the precision to make the tightest of turns and quickest maneuvers.\r\n\r\nThere's no better way to experience the excitement of cross-country racing!", 'youtube' => '8Dvw6TjwFyw', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5512], 'genres' => [7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 229, 'game_title' => "Cruis'n World", 'release_date' => '1998-06-25', 'platform' => 3, 'overview' => "Wanna see the world the easy way? Cruise it! Race through the deserts of Australia, zip through the streets of Paris or blast through the roadways of China! Play the new Championship mode to earn power-ups and secret cars! Go it alone or challenge up to three friends to see who’s the fastest! Check your passport at the door. With Cruisin’ World, you’ve got the power!\r\n\r\nPlay the new Championship mode to earn power-ups and secret cars!\r\n\r\nTake in scenery from 14 courses around the world!\r\n\r\nChoose from 12 different cars!\r\n\r\nFour-player simultaneous racing!\r\n\r\nCompatible with the Rumble Pak’ accessory!", 'youtube' => '07JnqrE3Cv8', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5512], 'genres' => [7], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 230, 'game_title' => "Cruis'n Exotica", 'release_date' => '1998-01-01', 'platform' => 3, 'overview' => "GET EXOTIC! …from Atlantis to Mars and everywhere in between.\r\n\r\nRace in style! Cruis’n Exotica takes you to fantastic locales in even more fantastic vehicles. Race through steamy Jurassic jungles or on the ocean floor. Midair stunts keep the action nonstop! Valuable shortcuts and nitro boosts speed up the already fast-paced action! Fantastic driving excitement straight from the arcade!\r\n\r\n28 exotic cars to race!\r\n\r\n1 to 4 player non-stop racing action!\r\n\r\nTurbo boosts, stunts, nitros and more!\r\n\r\n60 tracks from around the world!\r\n\r\nThree modes of play to choose from!", 'youtube' => 'K9fZWB24YpA', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5512], 'genres' => [1, 7], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 231, 'game_title' => 'Star Wars: Shadows of the Empire', 'release_date' => '1996-12-03', 'platform' => 3, 'overview' => "A long time ago in a galaxy far, far away... As Luke Skywalker and the Rebel Alliance struggle to defeat Darth Vader and the Empire, a new threat arises. Dark Prince Xizor, head of the Black Sun crime syndicate, aspires to take Darth Vader's place at the Emperor's side. To do that, he must eliminate young Skywalker. As Dash Rendar, it's up to you to protect Luke and help the Alliance defeat the evil Xizor. Watch out for infamous bounty hunters and deadly stormtroopers! May the Force be with you!", 'youtube' => 'scmZKBDOYqM', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [1], 'publishers' => [3], 'alternates' => ['STAR WARS TEIKOKU NO KAGE'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 232, 'game_title' => 'Super Mario RPG: Legend of the Seven Stars', 'release_date' => '1996-05-13', 'platform' => 6, 'overview' => "Mario returns in this incredible new role-playing adventure! His latest rival is Smithy, a menacing creature who causes fear and treachery in the Mushroom Kingdom. Mario must recover seven stars and repair the Star Road before he can make his way to Bowser's castle for a final confrontation with Smithy. Powerful weapons, sinister spells and other useful items help Mario to complete his harrowing journey. New friends and old allies support him along the way. Even Bowser lends a hand!", 'youtube' => '9HDQa3LAGO4', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8096], 'genres' => [4], 'publishers' => [3], 'alternates' => ['Super Mario', 'Mario RPG', 'Super Mario RPG', 'RPG'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 233, 'game_title' => 'Metroid Prime 3: Corruption', 'release_date' => '2007-08-27', 'platform' => 9, 'overview' => "Stop the unstoppable Dark Samus\r\n\r\nIf you think you knew what it felt like to be the bounty hunter behind the visor, think again. The Galactic Federation's network computer, Aurora Unit, is suddenly and completely corrupted with something like a virus. The Federation believes Space Pirates may be behind the problem and are soon attacked. Samus and other hunters leap to their defense only to find that the enemy they face is Dark Samus, armed with immense power that no one can withstand.\r\n\r\n-First-Person Perfect: Players control Samus by moving with the Nunchuk and aiming with the Wii Remote controller, allowing for a level of immersion unlike anything they have ever experienced. It's a quantum leap in first-person control.\r\n\r\n-Wonderful Weapons: Samus employs well-known power-ups like the Grapple Beam and Morph Ball, as well as new surprises, to help her survive. Using the Wii Remote and Nunchuk controllers, players will be able to grasp and pull things by using actual arm movements, as well as execute amazing feats like aiming and blasting in midair or at a full run.\r\n\r\n-Phazon's Powers: The game also incorporates a new system involving Phazon. If you fill Samus' Phazon supply to a certain level, Samus will temporarily go into hyper mode, a state in which she can pull off incredible feats. On the flip side, if she exceeds the maximum Phazon level, she'll perish. Also, for the first time in the Metroid series, Samus' ship will be used in active game play.", 'youtube' => 'lQLIwauAVNU', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7160], 'genres' => [1, 2, 8, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 234, 'game_title' => 'Anno 1404', 'release_date' => '2009-06-23', 'platform' => 1, 'overview' => "In the fascinating world of ANNO™ the player will sink into a unique building strategy game, where he sets sail in a beautiful island world to master the tricks of trade, diplomacy and economy, building up his own monumental cities. Continuous careful and elaborate planning will help fulfil his citizen’s needs and let his empire flourish. The upcoming ANNO 1404™ will bring this award-winning building strategy series to a new level:\r\n\r\nDiscover a strange and wondrous land in the uttermost East: the Orient! This highly civilized land will provide you with endless opportunities, and with the help of your new allies your occidental cities will prosper and become mighty metropolises!", 'youtube' => 'SKu76T0O_Ww', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1216, 7123], 'genres' => [3, 6], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 235, 'game_title' => 'Fallout', 'release_date' => '1997-09-30', 'platform' => 1, 'overview' => 'Gameplay in Fallout consists of traveling around the game world, visiting locations and interacting with the local inhabitants, and is typically in real-time. Occasionally, inhabitants will be immersed in dilemmas which the player may choose to solve in order to acquire karma and experience points. Alternately, the player may choose to ignore requests for help, in which case he or she has the option of acting on behalf of an opposing faction, or purely in self-interest. Experience points may still be rewarded if the player acts for an opposing interest or in self-interest. Ultimately, players will encounter hostile opponents (if such encounters are not avoided using stealth or diplomacy), in which case they and the player will engage in combat.', 'youtube' => 'M_10Zv3k4t0', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1143], 'genres' => [4], 'publishers' => [62], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 237, 'game_title' => '1080: TenEighty Snowboarding', 'release_date' => '1998-04-01', 'platform' => 3, 'overview' => "You’re taking a Tahoe 155 snowboard down a steep, bumpy incline at night and you’re about to top off an Indy Nosebone with a 360° Air, and you haven’t even left your living room!  You’re Playing 1080° (Ten Eighty) Snowboarding, a game so intense you’ll be brushing the snow off your goggles.  With five different boarders, eight different Lamar snowboards, more than 25 tricks, a Half-Pipe and six different courses, this is as close as you’ll get to the real thing without hopping on the next ski lift.\r\n\r\n• Six game modes and courses!\r\n• 2-Player simultaneous play!\r\n• Over 25 different tricks!\r\n• Compatible with Rumble Pak accessory.", 'youtube' => '8hAWCad3IS8', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6043], 'genres' => [11], 'publishers' => [3], 'alternates' => ['1080 Snowboarding'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 238, 'game_title' => '007: The World Is Not Enough', 'release_date' => '2000-10-17', 'platform' => 3, 'overview' => "Bond Is Back\r\n\r\nExperience the intensity of being the world's top secret agent. Equipped with a full arsenal of Q-Lab gadgets and weaponry, you must be suave, resourceful and lethal as you carry out action-packed missions based on the blockbuster movie. Are you cool under pressure? Deadly when necessary? Of course you are - you're Bond... James Bond \r\n\r\n• Bond's Best Missions! Battle through 14 dangerous levels with dynamic objectives based on your skill level.\r\n• Over 40 Q-Lab Gadgets and Weapons! Bond's P2K, X-Ray Glasses, Watch Stunner, and many more.\r\n• Action-packed Multiplayer! Customizable multiplayer modes for 1 to 4 players plus AI controlled bots.\r\n• Authentic Dialogue! Interact with you favorite characters and experience movie-like 3D cinematics with full speech.\r\n• Expansion Pak Support for enhanced graphics and visual effects.", 'youtube' => '-i9Pz6IzBgw', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2886], 'genres' => [1, 8], 'publishers' => [2], 'alternates' => ['World is Not Enough, The'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 239, 'game_title' => "A Bug's Life", 'release_date' => '1998-11-06', 'platform' => 3, 'overview' => "As hopeful hero Flik, you're the colony's last chance against the seed-grubbing grasshoppers. Run, fly, kick, squish, and slide through 15 challenging levels of 3-D animated gameplay. Outmaneuver 13 types of enemies, including The Bird and her deadly beak. Then, throw your weight around with tough antics like the Berry Attack and the Butt-Bounce. Because on this ride, you'll need more than just high hopes.\r\n\r\n• Search for power-ups, tokens and objects to use in the \"Living World.\"\r\n• Get a bug's-eye-view of a magical 3-D world.\r\n• Swing, fly, slide and navigate Flik through immense bug-infested levels.", 'youtube' => 'j0ITQ9h2o4c', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2383], 'genres' => [2], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 240, 'game_title' => "Army Men: Sarge's Heroes", 'release_date' => '2000-11-16', 'platform' => 3, 'overview' => 'CONFIDENTIAL. 0600 hours: Tan forces captured Bravo Company Commandos. General Plastro has new weapons of mass destruction: magnifying glass, M-80 firecrackers and the garbage disposal. This is a job for Sarge. Requisition M-60s, shotguns, bazookas, flame throwers, grenades, sniper rifles, mortars, mine sweepers and plenty of ammo. Good luck, soldier.', 'youtube' => 'V5IbVO1MUbc', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [77], 'genres' => [1, 8], 'publishers' => [63], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 241, 'game_title' => 'BattleTanx', 'release_date' => '1998-12-31', 'platform' => 3, 'overview' => "In the year 2001, a virus has killed 99.99% of the females on Earth. Various countries fight over each other's quarantine zones, and end up engaging in nuclear war, destroying much of civilization. The few remaining females are held by gangs who have taken over small pieces of the world. The main character, Griffin Spade, had his fiancee Madison taken away from Queens, New York by the U.S. Government. Griffin ends up separated from his fiancee, and New York City is destroyed. He claims a tank for his own and sets out to cross America and find her, battling gangs as he reaches his goal. After surviving the ruins of New York City, Griffin heads westward gaining recruits in the countryside, Chicago, Las Vegas, and San Francisco.", 'youtube' => 'qJbjhKCdwpU', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [77], 'genres' => [1], 'publishers' => [63], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 242, 'game_title' => 'BattleTanx: Global Assault', 'release_date' => '1999-10-12', 'platform' => 3, 'overview' => "On January 13, 2006, a Queenlord, Cassandra, is spying on Griffin Spade's family, telling her troops to kidnap Griffin's son Brandon and kill everyone else. Griffin and his army manage to push back the invaders, but Cassandra soon turns the tables by mind-controlling Griffin's own army. Griffin and Madison manage to escape San Francisco and begin chasing Cassandra across the United States, eventually cornering her in Washington, D.C.. Cassandra, however, escapes with Brandon to Great Britain; Griffin and Madison follow. They build a new army in Europe, and chase Cassandra through England, France and Germany. While in Paris, they discover Cassandra released the virus in 2001 to kill every female on Earth who didn't have the power of the Edge.", 'youtube' => 'CbFcc-_tWNQ', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [77], 'genres' => [1], 'publishers' => [63], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 243, 'game_title' => 'Blues Brothers 2000', 'release_date' => '2000-11-16', 'platform' => 3, 'overview' => 'Start out as Elwood in prison and get the band together for the battle of the bands, which is in less than two days. After saving the guitarist, Cab and defeating the warden, Mac and Buster are waiting to be found in Chicago to complete and reunite your crew!', 'youtube' => 'OneO7J5yGlE', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6683], 'genres' => [15, 17], 'publishers' => [64], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 244, 'game_title' => 'Body Harvest', 'release_date' => '1998-10-20', 'platform' => 3, 'overview' => "The year is 2016. Humanity has been reduced to a few survivors inhabiting the orbital space station Omega. Over the course of the history, aliens visited the Earth every twenty-five years, \"harvesting\" humans as an organic material. Eventually, they launch an assault on the last remnants of the human race. But Adam Drake, a genetically engineered soldier, comes into possession of a time-traveling device. He uses it to travel to the time periods of human history when aliens performed their deadly attacks. The fate of humanity is in his hands.\r\n\r\nBody Harvest is an action and driving game with a mission-based structure. The protagonist travels to various locations and eras (e.g. Greece during World War II, Siberia in the 1990s, etc.) with the goal of stopping alien invasions. Missions can be accessed by traveling to specified areas on the map. Adam can move on foot and use his weapons to kill aliens; however, vehicles usually prove to be a more reliable way of tackling most missions. Adam can use most of his weapons while in a vehicle; in addition, some vehicles are outfitted with their own weapons.", 'youtube' => 'bnocQS1maqg', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2404], 'genres' => [1, 8], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 245, 'game_title' => 'Bomberman Hero', 'release_date' => '1998-09-01', 'platform' => 3, 'overview' => "Bomberman's latest adventure takes him across the galaxy! Princess Millian has been kidnapped by the evil Garaden Empire and it's up to Bomberman to save the day. Travel through worlds of ice, fire and water. Use new abilities and get help from friends like Louie the rabbit and Pibol the robot. New vehicles like the Bomber Copter and Bomber Marine will come in handy in your quest to save the Princess and free the universe once again!", 'youtube' => 'HAeQZ3-vSYI', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [1], 'publishers' => [3], 'alternates' => ['Bomberman Hero: Millian Ojosama wo Sukue'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 246, 'game_title' => 'Castlevania: Legacy of Darkness', 'release_date' => '1999-11-30', 'platform' => 3, 'overview' => "Before Reinhardt Schneider and Carrie Fernandez confronted Dracula, a magical warrior embarked on a quest that would ultimately lead him to Dracula's lair. Take control of Cornell, a powerful werewolf, who is seeking out the evil minions responsible for his sister's disappearance. Armed with the power to morph from human to werewolf, Cornell is destined to rescure his sister from a sinister plan and rid the world of Dracula once and for all. Will he succeed or fail? Will the past unravel the future? Discover the legacy in this exciting prequel.", 'youtube' => 'UnOHRdp1GgI', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4765], 'genres' => [1, 15], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 247, 'game_title' => 'Chopper Attack', 'release_date' => '1998-06-17', 'platform' => 3, 'overview' => "Chopper Attack is a helicopter-based third-person shooter game released and published in 1997 by Midway.\r\nThe game features numerous missions in various locations; missions include bombing the enemy's bases, escorting Air Force One through dangerous jungle terrain and rescuing prisoners of war.", 'youtube' => 'BtO7JmcKCDY', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7625], 'genres' => [1, 8], 'publishers' => [41], 'alternates' => ['Wild Choppers'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 249, 'game_title' => "Conker's Bad Fur Day", 'release_date' => '2001-03-04', 'platform' => 3, 'overview' => "The day after his 21st birthday bash, Conker's sporting the worst hangover ever, and he just can't seem to find his way home. Prepare to stagger through randy, raunchy, raucous scenarios crammed full of bad manners, twisted humor, and graphic bodily functions. Unless you're a fan of violence, foul language, and racy innuendo, you'd best steer clear of this one.\r\n\r\nAlthough visually similar to Rare's family-oriented Nintendo 64 platform games Banjo-Kazooie and Donkey Kong 64, Conker's Bad Fur Day was designed for mature audiences and features graphic violence, alcohol and tobacco use, profanity, vulgar humor and pop culture references. It was developed over the course of four years and was originally intended for a family audience, but was ultimately retooled into its current form because previews were criticised for being both too cute and similar to Rare's earlier platform games.", 'youtube' => 'pfq44ETz92Y', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6991], 'genres' => [15], 'publishers' => [51], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 250, 'game_title' => 'Donkey Kong 64', 'release_date' => '1999-11-24', 'platform' => 3, 'overview' => "K. Rool has kidnapped the Kongs! Can Donkey Kong rescue his friends, reclaim the Golden Bananas and save his homeland from certain doom? Take out some Kremlings with Chunky's Pineapple Launcher or Lanky's Trombone. Float through the air using Tiny's Ponytail Twirl. Even rocket to the sky with Diddy's Jetbarrel!", 'youtube' => 'W6mqRCsMKmE', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6991], 'genres' => [1, 2], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 251, 'game_title' => 'Doom 64', 'release_date' => '1997-03-31', 'platform' => 3, 'overview' => 'You killed the Demons once, they were all dead. Or so you thought... A single Demon Entity escaped detection. Systematically it altered decaying, dead carnage back into grotesque living tissue. The Demons have returned - stronger and more vicious than ever before. You mission is clear, there are no options: kill or be killed!', 'youtube' => 'MXgG8NmJUjI', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5507], 'genres' => [8], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 252, 'game_title' => 'Fighter Destiny 2', 'release_date' => '2000-06-22', 'platform' => 3, 'overview' => "Enter the arena and do battle with the toughest, most skilled martial arts experts on the planet. As one of the international fighting elite, you'll vie to become the true authority of hand-to-hand combat. Your destiny awaits. Defeat any of your 11 opponents and gain their abilities. Launch 5 different modes of attack, from Training to Record Attack. Adjust scoring, ring sizes and difficulty settings. Compete in points-based martial arts tournaments. Force your opponent to relive defeat in instant replay. Gain new abilities and skills when you face the Master in the Fighter's Arena.", 'youtube' => '098-xkcuuko', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4093], 'genres' => [10], 'publishers' => [67], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 253, 'game_title' => 'Fighting Force 64', 'release_date' => '1999-04-30', 'platform' => 3, 'overview' => "Fighting Force players control one of four characters. They move through urban and science fiction environments, battling waves of oncoming enemies with weapons ranging from fists and bottles to knives, chairs and guns. The player can make some choices as to which territory to travel through.\r\n\r\nThe four characters have various reasons for taking on Dr. Zeng, a criminal mastermind with an army at his command. The action starts with a police cordon around Zeng's office skyscraper, moving to such locales as a shopping mall, subway and Coast Guard base before finally ending at the top of Zeng's island headquarters.", 'youtube' => 'nEZ9D696Gew', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [1827], 'genres' => [10], 'publishers' => [68], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 254, 'game_title' => 'Forsaken 64', 'release_date' => '1998-04-30', 'platform' => 3, 'overview' => "Forsaken is a first-person shoot 'em up in which you have complete movement freedom in 3 dimensions, as you accelerate, swerve and strafe your craft, making for gameplay resembling Descent. Each level has a defined exit which must be reached within a tight time limit. The surrounding areas are collapsing around you, with spikes and turbine fans among your hazards. Be very aware of other craft out to take all you have, as they alter their approach based on your weaponry (from the 25 featured in the game) and past encounters.", 'youtube' => 'BxUxMMAElXo', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4065], 'genres' => [1, 8], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 255, 'game_title' => 'Gauntlet Legends', 'release_date' => '1999-08-31', 'platform' => 3, 'overview' => "In ages past, a corrupt mage named Garm used a set of Runestones to summon a demon named Skorne (It is not stated what Garm intended to use Skorne for; however, as Gauntlet Legends introduces Garm as a \"greedy young mage\", it can be assumed he wanted Skorne for his own personal gain.) However, Skorne crushed Garm and imprisoned his soul in the Underworld. Skorne, fearing the power of the Runestones, scattered them throughout the four realms, so that they could never be used against him. The player(s) must defeat the end bosses of each of the four realms to obtain the four golden keys which allow access to Skorne's temple. While traveling through each realm, he/she/they must also collect the Thirteen Runestones from where they have been scattered. The complete set of Runestones allows him/her/them to pursue Skorne to the Underworld in order to finally destroy him. The players must find 3 rune stones on each kingdom in order to defeat Skorne in the Underworld, and of course 1 from the battle grounds.", 'youtube' => 'iIR_6QL1CpI', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1], 'genres' => [1], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 256, 'game_title' => 'Hercules: The Legendary Journeys', 'release_date' => '2000-11-17', 'platform' => 3, 'overview' => "Take control of the legendary hero Hercules and his friends Iolaus and Serena as they attempt to stop Ares from completing his diabolical plans. Use each character's unique attributes: Hercules' legendary strength, Iolaus' nimble nature and Serena's accuracy to complete your quest. Travel through 12 unique fully 3D worlds, from the sunny seaside town of Porticus to the snowy mountains of Alpsius. Explore the bandit-overrun forrests of Traycus or heavenly Mount Olympus. Fight mythical terrifying monsters such as the Minotaur, Cyclops, and more!", 'youtube' => 'ONRe6kvHxIc', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6683], 'genres' => [1, 2], 'publishers' => [64], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 257, 'game_title' => 'Hey You, Pikachu!', 'release_date' => '2000-11-05', 'platform' => 3, 'overview' => "For the first time ever, you can actually talk to your favorite Pokemon. Tag along with Pikachu as it goes through its daily routines, taking field trips, going fishing and having picnics, becoming better friends with each passing day. Pikachu will hear and react to the words you say. The more you speak the closer friends you'll be!", 'youtube' => 'WKale4NAgT0', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [423], 'genres' => [9], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 258, 'game_title' => 'Hydro Thunder', 'release_date' => '1999-09-09', 'platform' => 3, 'overview' => 'The gameplay of Hydro Thunder consists of racing high-tech speedboats through treacherous environments, from the cold seas of the Arctic Circle, to a post-apocalyptic, flooded version of New York City.', 'youtube' => 'e59cRHwIX8A', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5512], 'genres' => [19], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 259, 'game_title' => 'Indiana Jones and the Infernal Machine', 'release_date' => '2000-12-15', 'platform' => 3, 'overview' => "1947. The nazis have been crushed, the Cold War has begun and Soviet agents are sniffing around an ancient ruin. Grab your whip and fedora and join Indy in a globespanning race to unearth the mysterious \"Infernal Machine\". Survive the challenges of unusual beasts, half the Red Army and more (including - oh no - snakes!) \r\n\r\nPuzzle your way through 17 chapters of an action-packed story. Travel the world to exotic locales, from the ruins of Babylon to Egyptian deserts. All the weapons you'll need, including firearms, explosives-and of course Indy's trusty whip and revolver.", 'youtube' => 'rRVHxKkeN8I', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [1, 2], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 260, 'game_title' => 'Jet Force Gemini', 'release_date' => '1999-10-11', 'platform' => 3, 'overview' => "The insect invasion has begun.\r\n\r\nThe galaxy is being infested by the evil Mizar and his horde of Drones. Already, the planet of Goldwood has been subjugated and the peaceful Tribals enslaved. With an arsenal of mega-weapons at their disposal, the Jet Force Gemini team must travel in search of Mizar's lair - rescuing Tribals and splattering Drones along the way. But can Juno, Vela and their faithful dog, Lupus, exterminate the deadly threat before it's too late?\r\n\r\n+ \" The game also includes a multiplayer mode where two to four players can compete in traditional deathmatch games. \" -Wikipedia", 'youtube' => 'eHjwPulJdU4', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6991], 'genres' => [1, 2, 8], 'publishers' => [51], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 261, 'game_title' => 'Killer Instinct Gold', 'release_date' => '1996-11-25', 'platform' => 3, 'overview' => "Killer Instinct Gold rocks the gaming world with its earth-shattering moves and unbelievable graphics. Your battles unfold with lightning-fast action and fluid character animation at 60 frames per second. We faithfully duplicated all the features that made Killer Instinct 2 an arcade hit. We've even thrown in a complete training mode to school you on all the moves! The eye-popping graphics, the explosive hits and jaw-dropping combos make Killer Instinct Gold the only fighting game you'll ever want in your house!", 'youtube' => 'B8fph9nhq4k', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6991], 'genres' => [10], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 262, 'game_title' => 'Kirby 64: The Crystal Shards', 'release_date' => '2000-06-26', 'platform' => 3, 'overview' => "Kirby's first 3-D adventure is also his Nintendo 64 debut, and it finds the always-versatile hero battling a new enemy called Dark Matter. Dark Matter is after a distant land's powerful crystal, but a young fairy named Ribbon attempts to save it by escaping with the gem to Dream Land. Now the crystal has been broken, and it's scattered around the world. Take control of Kirby and help him journey across six worlds, battling a wide variety of enemies and challenging bosses, as he tries to collect all 100 pieces of the shattered crystal.", 'youtube' => 'Qf0pwsX73jw', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3694], 'genres' => [2], 'publishers' => [3], 'alternates' => ['Hoshi no Kirby 64'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 264, 'game_title' => 'Knockout Kings 2000', 'release_date' => '1999-10-03', 'platform' => 3, 'overview' => 'Get it on as or against 25 of the greatest boxers of all time! Includes Oscar De La Hoya, Sugar Ray Leonard, Evander Holyfield, and THE GREATEST, Muhammad Ali! Arcade-style Slugfest and Career modes. Super KO punches and hidden moves. Knockdown-dragout battles with the greatest boxers ever. Build a champion and fight to the top in Career mode. Pit current champs vs. legendary superstars, or challenge your created boxer against the greats.', 'youtube' => 'GmEyq6Hsijs', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1154], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 265, 'game_title' => 'Duck Dodgers Starring Daffy Duck', 'release_date' => '2000-12-16', 'platform' => 3, 'overview' => "Marvin The Martian has developed an ultimate weapon that will allow him to finally destroy Earth, which will ultimately allow him to take control of the universe. Upon the demonstration of the weapon, a slight snag hinders Marvin from completing his devious deed. The Weapon is out of Atoms, which it runs on, so he sends his minions (All of which are characters from the Looney Tune universe) to gather Atoms to fuel his weapon.\r\n\r\nDuck Dodgers is informed by his academy of Marvin's deeds and sets out to find the one-hundred Atoms before Marvin can. This ultimately has Dodgers and his sidekick, Cadet, trekking to four different planets, including a large pirate ship, to obtain the upper-hand over Marvin.", 'youtube' => 'nshkM25meWM', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6423], 'genres' => [15], 'publishers' => [72], 'alternates' => ['Duck Dodgers', 'Looney Tunes: Duck Dodgers'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 266, 'game_title' => 'Mario Kart 64', 'release_date' => '1997-02-10', 'platform' => 3, 'overview' => "Three… Two… One… GO!  The signal light changes and you drop the pedal to the metal.  Take on up to three friends in the split-screen VS games, or race solo in the Mario GP.  Tell your friends to bring it on in the highly competitive Battle mode.  Advanced features allow you to race with your “Ghost”.  The driving data from your best run appears as a transparent character on the screen.  No longer must you simply race against the clock -- you can actually race against yourself!\r\n\r\n* Save your hottest Ghost data to a portable N64 Controller Pak!\r\n* Collect multiple power-up items!\r\n* Twenty different courses -- 4 Cups with 4 courses each and 4 special Battle mode courses!\r\n* Everyone’s favorite characters are back and gorgeously rendered, including two new additions, Donkey Kong and Wario!", 'youtube' => 'gHE0QEi6Ldc', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 267, 'game_title' => 'Madden NFL 99', 'release_date' => '1998-09-01', 'platform' => 3, 'overview' => 'This is all-Madden football! Legendary gameplay. One-button simplicity. The ultimate NFL experience. New super hi-res polygon graphics. Monster hits - feel and hear the impact! 250 new motion captured NFL moves. New Arcade Mode - huge hits, more fun! Over 120 past and present NFL teams. Draft, trade, create, sign, and release players.', 'youtube' => 'KzvYTzX6yW8', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 268, 'game_title' => 'Madden NFL 2001', 'release_date' => '2000-09-05', 'platform' => 3, 'overview' => 'Madden NFL 2001 includes several customizable modes. Players have the ability to create a play, create a player, run a franchise, and collect Madden Cards, allowing players to perform certain actions during gameplay (for example, adding 5th downs, or limiting the CPU-controlled team to 3rd downs). The cards can also alter individual player ratings, unlock special stadiums, and unlock Hall of Fame and All-Madden teams.', 'youtube' => 'VutS-9ISO_M', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2590], 'genres' => [11], 'publishers' => [35], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 269, 'game_title' => 'Madden NFL 2002', 'release_date' => '2001-09-12', 'platform' => 3, 'overview' => "#1 for a reason! Return to glory: Relive the golden days of 16-bit Madden gameplay in Madden Classic mode. Kick off the season with the newest NFL team: Take the field with all 32 NFL teams including the expansion Houston Texans. A game within a game: Run or defend an improved 2-Minute Drill, now featuring Head-To-Head Challenge. Bang-Boom-Pow: Perfect the X's and O's with the help of John Madden in Training mode.", 'youtube' => 'kDP24O7-lOw', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1361], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 270, 'game_title' => 'Mario Party 2', 'release_date' => '2000-01-24', 'platform' => 3, 'overview' => "Mario and the gang are back for another round of Bowser-bashin' party action! Watch as your favorite Nintendo characters don different duds for each of the five all-new Adventure Boards! A slew of new tricks and devices bring new levels of challenge and excitement to board game play. New board maps, new Mini-Games, new action and new surprises means a whole new batch of fun! Get ready to unleash your best Hip Drops, hammer swings and high-flying high junks for another round of frenzied multi-player action!", 'youtube' => 'gsfO3t6rJUE', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [1, 2, 6, 11], 'publishers' => [3], 'alternates' => ['Mario Party 2 (JP)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 271, 'game_title' => 'Major League Baseball Featuring Ken Griffey, Jr.', 'release_date' => '1998-05-31', 'platform' => 3, 'overview' => "Make your dreams of becoming a Major Leaguer a reality! Hit a grand slam, pitch a no-hitter, go for the cycle and steal home - all in the same game! If that's not enough, check out the real-time stat tracking in over 30 major categories. Improve your team by making the right trades and picking up the best free agents. Major League Baseball Featuring Ken Griffey Jr. is so real, every pitch counts!", 'youtube' => 'YdYT5TO4ZSY', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [503], 'genres' => [11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 272, 'game_title' => "NBA In the Zone '99", 'release_date' => '1999-04-07', 'platform' => 3, 'overview' => 'The only place for hoops action on the Nintendo 64! All 29 NBA teams and over 300 real NBA players. Eight different camera angles with adjustable zoom. Create a player and customize over 30 different categories. All-new motion captured animations - the most realistic ever! Advanced play-calling techniques. Pin-point passing lets you play like the pros! Three-point shootout and slam dunk contest!', 'youtube' => 'WDIdjk1unmE', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [11], 'publishers' => [23], 'alternates' => ['NBA Pro 99'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 273, 'game_title' => 'Air Cavalry', 'release_date' => '1995-06-20', 'platform' => 6, 'overview' => 'A standard helicopter war-game, featuring the Air Cavalry division. The game is played in a third person view using mode 7 graphics, with the cockpit displayed in splitscreen. There are three campaign areas to fly in: Middle East, Indonesia, and Central America. There are also 2 player versus and co-op split-screen modes.', 'youtube' => 'PzAMqksAmP0', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8399], 'genres' => [1], 'publishers' => [73], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 274, 'game_title' => 'Animaniacs', 'release_date' => '1994-11-01', 'platform' => 6, 'overview' => 'Animaniacs is a video game that is based on the hit animated series of the same name. Unlike regular platform games, the player usually runs from the enemies rather than fighting them. Characters include Yakko, Wakko, and Dot, Pinky and the Brain, most of the supporting cast, as well as Ralph, the Warner Brothers studio guard. Animaniacs was made into two games which bore no relation to each other in terms of gameplay, despite both being made by Konami. One was for the Super Nintendo Entertainment System and the other was for the Sega Mega Drive/Genesis and Game Boy. The SNES and Mega Drive/Genesis version were released in 1994, and the Game Boy version in 1995.', 'youtube' => 'amg49S5W2a0', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [15], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 275, 'game_title' => 'Ardy Lightfoot', 'release_date' => '1993-11-26', 'platform' => 6, 'overview' => "The story of the game is that the sacred rainbow has shattered into seven pieces and it's up to Ardy to obtain them all again. Whoever collects all seven pieces will receive one wish. An evil king named Visconti has already gotten one piece and is searching for the others. To this end he sends out various creatures and henchmen such as Beecroft, Catry and others. These creatures form the opponents for Ardy during the game. Ardy is assisted by friends along the way like the elder (unknown name), Nina, and a mysterious adventurer named Don Jacoby.", 'youtube' => '5qUg1B5SrS0', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [696], 'genres' => [1, 2], 'publishers' => [64], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 276, 'game_title' => 'Battle Clash', 'release_date' => '1993-06-21', 'platform' => 6, 'overview' => 'Battle Clash is a game that uses the Super Scope light gun peripheral. In this game, you fight in a futuristic version of the world as a warrior named Michael Anderson, who takes part in a competition simply known as the "Battle Game". Contestants in the Battle Game fight using mobile Standing Tanks (or STs for short), that come with a variety of weapon systems and forms.', 'youtube' => '', 'players' => 2, 'coop' => 'Yes', 'rating' => 'Not Rated', 'developers' => [6037], 'genres' => [8], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 277, 'game_title' => 'Super Bomberman', 'release_date' => '1993-09-01', 'platform' => 6, 'overview' => 'Super Bomberman is the first video game in the Bomberman series to appear on the Super Nintendo Entertainment System. It is also the first four-player game to be released on the Super NES.', 'youtube' => 'QGfgf4HkNqM', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [1, 6], 'publishers' => [74], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 278, 'game_title' => 'Bugs Bunny Rabbit Rampage', 'release_date' => '1994-02-05', 'platform' => 6, 'overview' => 'Bugs Bunny Rabbit Rampage is a side-scrolling platform game. The player, controlling Bugs Bunny, is able to jump (and squash), high-kick, throw cream pies and use ACME weapons. These weapons are scattered all over the landscape and include such cartoon favorites as bone-shaped dynamite sticks, anvils to drop on heads, Shrink Rays, portable holes and many more. Players will encounter a variety of familiar Looney Tunes characters as enemies and level bosses. At the end of each level (10 in all). players are given a rating based on their gameplay style, which includes how many of these ACME weapons they were willing to use.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9342], 'genres' => [15], 'publishers' => [75], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 279, 'game_title' => 'Cacoma Knight in Bizyland', 'release_date' => '1993-06-01', 'platform' => 6, 'overview' => 'Cacoma Knight is a hybrid of action and puzzle elements. Each level is a single screen. The first image that the player sees is a landscape, for example, a forest or a town. The image will then fade into a "corrupt" version of the landscape, for example, the trees become rotten and buildings become ruined. Each screen has a "Qualify" target that shows how much of the screen must be cleared before the game continues to the next level.', 'youtube' => '', 'players' => 1, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7625], 'genres' => [1], 'publishers' => [76], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 280, 'game_title' => "Congo's Caper", 'release_date' => '1992-12-18', 'platform' => 6, 'overview' => "Congo the monkey and his girl, Congette, were in the jungle minding their own business when a magic ruby dropped out of the sky and turned them both into half-humans. To make matters worse, the ruby also spawned a demon-kid who grabbed Congette and took off. Now you've got to hunt down the kid and find your girl, while adapting to your new form. You'll make your way through ghost towns, pirate ships, ninja castles, and the belly of a Tyrannosaurus on your search. There are 35 levels of side-scrolling action in all, and you'll have your hands full with tons of wild animals that will try to stand in your way. As you run, jump, swim, attack, and dive your way through the game, keep your eyes open for special gems that will give you special powers and open secret levels.", 'youtube' => nil, 'players' => 1, 'coop' => nil, 'rating' => 'E - Everyone', 'developers' => [2126], 'genres' => [1], 'publishers' => [55], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 281, 'game_title' => '3 Ninjas Kick Back', 'release_date' => '1994-06-19', 'platform' => 6, 'overview' => 'You first saw Rocky, Colt and Tum Tum on the silver screen when their martial arts skills and extreme exploits saved the honor of Grandfather Mori and defeated an evil arms dealer.  Now, it’s up to you!  In this action-packed adventure, you become any one of the 3 Ninjas.  And that’s when the fun begins.  Wild animals and even wilder ninjas attack!  A trio of spaced-out heavy metal rockers join forces with the evil Koga in an all-out effort to do you dirty.  But if you rescue Grandfather Mori and his ceremonial dagger, you’ll have the last laugh… and unlock a secret room filled with more gold than Fort Knox!', 'youtube' => '18Hcd8P61Wc', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5215], 'genres' => [1], 'publishers' => [77], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 282, 'game_title' => 'The 7th Saga', 'release_date' => '1993-08-03', 'platform' => 6, 'overview' => "THIS IS NOT YOUR ORDINARY RPG!\r\n\r\nThe graphics are eye-popping, breath-taking, stunning and unbelievable, not to mention incredible. This is no hack-and-slash, rip-your guts-out fighter! This is the future of RPGs, right here in your hands! With music this good, you won’t turn the sound off-you’ll turn it up!\r\n\r\nNo more small elves leading your team! This game contains real, believable figures. You won’t be embarrassed to use your own name; you’ll be proud. It’s just you against six other characters in search of the 7 Sacred Runes. Whoever finds them... Rules the World. It’s that simple, that easy. The only problem is you have some enemies, and I don’t mean a few. I mean an army of things you’ve never seen before ready to raise the hair on the back of your neck and take you out with one swing. This is one powerful RPG. Can you handle it?!", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [6797], 'genres' => [4], 'publishers' => [78], 'alternates' => ['Elnard', 'The 7th Saga'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 283, 'game_title' => 'Daffy Duck: The Marvin Missions', 'release_date' => '1993-10-01', 'platform' => 6, 'overview' => "In this game, Duck Dodgers sets out to stop Marvin the Martian from performing various notorious deeds, including destroying his beloved home-planet, Earth. There seems to be only one way to stop Marvin - and that's to destroy all five of his deadly machines!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4023], 'genres' => [1, 2], 'publishers' => [75], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 284, 'game_title' => 'Advanced Dungeons & Dragons: Eye of the Beholder', 'release_date' => '1994-03-18', 'platform' => 6, 'overview' => 'Something evil is lurking below the city of Waterdeep. The Lords of Waterdeep summon a group of heroes to investigate, but someone or something has been watching the proceedings. After the heroes enter the sewers, the ceiling collapses behind them. The only way out is the way down, into a dungeon filled with monsters, traps and puzzles.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [9596], 'genres' => [4], 'publishers' => [79], 'alternates' => ['Eye of the Beholder', 'AD&D: Eye of the Beholder'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 285, 'game_title' => 'Jeopardy!', 'release_date' => '1992-12-01', 'platform' => 6, 'overview' => 'Jeopardy! is an American quiz show featuring trivia in history, literature, the arts, pop culture, science, sports, geography, wordplay, and more. The show has a unique answer-and-question format in which contestants are presented with clues in the form of answers, and must phrase their responses in question form.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [4107], 'genres' => [5], 'publishers' => [80], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 286, 'game_title' => 'John Madden Football', 'release_date' => '1990-01-01', 'platform' => 18, 'overview' => "Game modes are the usual pre-season, regular season, sudden death and playoffs. A special playoff mode for the 8 greatest teams is also available.\r\n\r\nThe Genesis version features John Madden's digitized commentary speech and a battery-backed RAM for saving playoff results and player stats.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => ['Pro Football', 'John Madden American Football'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 287, 'game_title' => 'Judge Dredd', 'release_date' => '1995-10-27', 'platform' => 6, 'overview' => 'Judge Dredd is a platform action game based on the British comic book character of the same name and the 1995 movie that tarnished that name. The game was a multi system release so it fits the standard console jump/shoot/duck formula although it does add some unique twists such as wounding enemies so that they surrender and can be arrested.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [196], 'genres' => [1], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 288, 'game_title' => 'Ka-Blooey', 'release_date' => '1992-01-01', 'platform' => 6, 'overview' => 'Bombuzal is a computer puzzle game produced by Antony Crowther. The game was released in 1988 for the Amiga, Atari ST and Commodore 64. It was also released in 1989 for MS-DOS and 1990 for the Super NES, with the American version renamed as Kablooey. Among its notable features was the ability to play using either an overhead or isometric view. To complete each level the avatar has to destroy all bombs on a level. Bombs come in different sizes and it is only possible to ignite the smallest kind without dying. The bombs have to be set off using a chain reaction to prevent the avatar being killed in the explosion.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [4641], 'genres' => [6], 'publishers' => [81], 'alternates' => ['Bombuzal'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 289, 'game_title' => "Krusty's Super Fun House", 'release_date' => '1992-06-01', 'platform' => 6, 'overview' => "Krusty the Clown's Fun House has been overrun by rats. You must help him to herd the rats into trap machines to clear them out. In order to do so, Krusty must manipulate his environment to set up pathways so that the rats are headed in the right direction. Objects that Krusty move around include blocks, fans, and pipe pieces.\r\n\r\nThe trap machines are operated by other recognizable Simpson's characters: Bart, Homer, Sideshow Mel, and Corporal Punishment.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [806], 'genres' => [15], 'publishers' => [28], 'alternates' => ['Krusty World'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 290, 'game_title' => 'Madden NFL 96', 'release_date' => '1995-11-30', 'platform' => 6, 'overview' => "Madden NFL '96 is a football video game designed for the 1995 NFL season, licensed by the NFL. It features John Madden on the cover. The AI has been boosted and can now hurry in two-minute drill situations, spike the ball, and cover the receivers with better efficiency. Among the innovations in Madden 96, the Create-a-Player feature was added, which included many position specific mini-games that would determine the ability of the player. The game also was the first in the Madden series to include secret \"classic\" teams, which were unlocked by playing any of the 28 pre-expansion NFL franchises in the playoffs and by winning Super Bowl XXX with that team (a rather easy feat as the playoff tournament system allows a player to abort the game while in the lead and still win). The 28 pre-expansion teams were each represented by a classic era equivalent, which ranged from 1960 (Philadelphia Eagles) to 1986 (New York Giants), although all players identified as number-only. Jacksonville Jaguars and Carolina Panthers, having debuted in 1995, did not have a secret classic team revealed in this manner, nor did the All-Madden team. However, Carolina was attached to the blank slate NFLPA team used for Create-a-Player, and Jacksonville and All-Madden hid the \"superteams\" with players named after the developers; these teams were accessed using unstated cheat codes.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8822], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 291, 'game_title' => 'Madden NFL 97', 'release_date' => '1996-10-01', 'platform' => 6, 'overview' => "Welcome to Madden NFL 97, the game that captures the excitement of a 30 yard touchdown pass, the strategy of a well executed scoring drive, and the atmosphere of a crisp autumn afternoon in the stadium. Madden NFL 97 delivers state of the art graphics and sound -- and with modem and network support, it's ready to put your competitive skills to the test.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 292, 'game_title' => 'Mega Man 7', 'release_date' => '1995-03-24', 'platform' => 6, 'overview' => "Dr. Wily's crusade to rule the world ends abruptly at the hands of Mega Man, so what's a villain to do? Create a diversion and break out of prison! Mega Man has his hands full as 4 gigantic machines exit Dr. Wily's lab to ravage the city, but... who is behind this new plot as Wily sits behind bars?\r\n\r\nDr. Wily knew his diabolical deeds would end an failure one day. So as hiss robots attack by remote control, the sinister doctor breaks out of prison and flies off in his spaceship. The Titanium Titan is tricked!\r\n\r\nWith the help of Rush, Roll and Dr. Light, can Mega Man put the slippery Dr. Wily back in prison where he belongs? The future of the world hangs on Mega Man's every move.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Mega Man VII', 'RockMan VII: Showdown of Destiny!', 'ロックマン7 宿命の対決!', 'Rockman 7: Shukumei no Taiketsu!'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 293, 'game_title' => 'NBA Live 95', 'release_date' => '1994-12-03', 'platform' => 6, 'overview' => "The first of the NBA Live titles on the PC, NBA Live 95 includes all of the basketball players from the '94 - '95 season as well as the All-Star teams from the East and West.\r\n\r\nManage over 300 players using the General Manager feature, new in this edition. Statistics for each player and team are saved. View players and teams side-by-side to compare stats and other information. You can trade any player in the league.\r\n\r\nMultiple in-game settings let you choose the mode of play, the style, and even the length of a quarter or session. Full motion videos bring your plays to life onscreen. Listen to the crowd roar, the noises of the court and hoop, and voices of the players. There is also a soundtrack of modern music.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => nil, 'developers' => [3867], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 294, 'game_title' => 'NFL Quarterback Club 96', 'release_date' => '1995-11-01', 'platform' => 6, 'overview' => "This game is the next-gen update of NFL Quarterback Club.\r\n\r\nEvery team from the 1996 NFL season is shown here, with real player numbers and stats. 32 offensive plays and 16 defensive plays are available as you play. Options include setting quarter lengths, from one to 15 minutes, and selecting your mode of play: Preseason, Playoffs, or a full Season, in which you play 18 games towards the goal of the Super Bowl.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [4065], 'genres' => [11], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 297, 'game_title' => 'Scooby-Doo Mystery', 'release_date' => '1995-01-01', 'platform' => 6, 'overview' => "This version is different from it's Genesis counterpart.  While the gameplay is similar (exploring levels to collect clues and solve the mystery), there are four different episodes for this version.  While visiting the Drabwell Ranch, ghost's interrupt the festivities and the gang must find out who is behind the hauntings and why.  Another adventure takes the gang to Deadman's Cove where a ghostly pirate has been scaring off tourists and it is up to Scooby and the Gang to bring it to a halt. The other two mysteries take place at a fun fair and a haunted mansion.\r\n\r\nPlayers can use Scooby's unique sniffing ability to find clues. Scooby also consume Scooby Snacks to reduce the fright meter.  Additionally there are a series of mini-games that player can participate in such as \"Wac-A-Monster\" or \"Make a Scooby Sandwich\".  The graphics are faithfully recreated to resemble the long-running Hanna Barbara series.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8329], 'genres' => [2], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 298, 'game_title' => 'SkulJagger: Revolt of the Westicans', 'release_date' => '1992-10-01', 'platform' => 6, 'overview' => "Sküljagger: Revolt of the Westicans is a sidescrolling platform game. Players select between a 1 player game, an alternating turn 2 player game or Bubblegum Practice. The player controls Storm Jaxon who is able to run left and right, jump and swing Sküljagger's magic sword. Storm must reach the end of each level before time runs out or risk losing a life. Under normal circumstances, touching an enemy or projectile will cause him to die, though the sword is often able to destroy projectiles. By collecting red jewels, Storm is able to both augment the sword with a projectile attack and be protected from one enemy attack. Green jewels will also protect from one enemy attack, however collecting 25 of them will grant an extra life. Blue jewels add additional time for Storm to complete each level. Finding a mask will make Storm invulnerable for a short time. These power-ups are either floating in the air of each level or hidden away in chests, boxes, rocks and coconuts. However these items which may hide items can also be picked up and thrown at enemies.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [7050], 'genres' => [15], 'publishers' => [83], 'alternates' => ['Sküljagger: Revolt of the Westicans', 'SkulJagger'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 299, 'game_title' => 'Super Metroid', 'release_date' => '1994-04-18', 'platform' => 6, 'overview' => "Take on a legion of Space Pirates and a new Metroid force as you forge into the covert underworld of Planet Zebes!  It’s up to you and Samus to recapture the long-surviving Metroid hatchling before evil hands unleash its energy.\r\n\r\nAn army of ominous creatures are poised for battle at every turn of Zebes’ twisted, threatening passageways… including the menacing Ridley and the great lizard Kraid.  Knock down enemies with a killer somersault and swing on an electric beam through narrow passageways!  They’re no match for you and Samus… but wait!  It seems the Mother Brain has returned…", 'youtube' => 'yu9GiZjFejE', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4248], 'genres' => [1, 2], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 300, 'game_title' => 'Super Probotector: Alien Rebels', 'release_date' => '1992-04-06', 'platform' => 6, 'overview' => "The hideous Red Falcon, thought to have been destroyed long ago by the Earth's greatest commandos, Mad Dog and Scorpian, has risen again, this time pissed off and thirsty for revenge. His armies are marching through the cities, across the lands, and with the intention of exterminating the human race like a bad case of fleas. Two new commandos, Jimbo and Sully, have come forth now to kick Red Falcon's ass and save what remains of the world from his hideous plans!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [1], 'publishers' => [23], 'alternates' => ['Contra III The Alien Wars'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 301, 'game_title' => 'The Great Circus Mystery Starring Mickey & Minnie', 'release_date' => '1994-06-02', 'platform' => 18, 'overview' => "The Great Circus Mystery Starring Mickey and Minnie, later titled Disney's Magical Quest 2 Starring Mickey & Minnie, was released for the Super Nintendo Entertainment System and Sega Genesis/Mega Drive in 1994 and for the Game Boy Advance in 2003. The game features Mickey Mouse and Minnie Mouse trying to figure out why everyone in the circus has disappeared, and includes four different types of outfits and six different levels. While the SNES and Genesis/Mega Drive versions were practically identical, the GBA re-release in 2003 included some new features. As its predecessor, it received praise for its graphics and outfit system and was criticized for not being challenging enough and short. Notably, it was the first game with Minnie Mouse in a video game role.", 'youtube' => '_7Iu_GOxsE0', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [15], 'publishers' => [9], 'alternates' => ['Mickey to Minnie: Magical Adventure 2', 'The Great Circus Mystery'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 302, 'game_title' => 'The Itchy & Scratchy Game', 'release_date' => '1995-03-01', 'platform' => 18, 'overview' => "Itchy & Scratchy is a single player platform side-scroller. The player controls Itchy, the mouse, and must defeat Scratchy, the cat, with a variety of weapons. Itchy caries a default mallet, but can pick up additional weapons on particular levels. Each of the seven levels takes place in a different fictional location and is designed as a maze of doors and platforms. After defeating Scratchy, he usually will return with a special contraption to attack Itchy, and must therefore be defeated again. The game was developed for the Genesis but it was never commercially released. It was planned to be released on 1995 along with the \r\n Super NES and Sega Game Gear versions.", 'youtube' => 'https://www.youtube.com/watch?v=1DBlVpgauuY', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1098], 'genres' => [1], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 303, 'game_title' => '90 Minutes: European Prime Goal', 'release_date' => '1995-08-04', 'platform' => 6, 'overview' => "90 Minutes: European Prime Goal is a Super Nintendo Entertainment System soccer video game. The player(s) get to play in either exhibition, tournament, or in the all-star mode. The view is from a left-right perspective and the national flags of several European countries are used in the game. In the game mode \"You're a Hero,\" the player must make miracle plays that either win and/or change the game. The kick-off is doing using 3D graphics with the camera showing the spectators in the grandstand.\r\n\r\nThis game is a sequel to J.League Soccer Prime Goal 2 and J.League Soccer Prime Goal, which were both developed by Namco.", 'youtube' => 'AZnG1FOj_7w', 'players' => 2, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [5804], 'genres' => [11], 'publishers' => [39], 'alternates' => ['J.League Soccer: Prime Goal 3'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 304, 'game_title' => '2020 Super Baseball', 'release_date' => '1993-03-12', 'platform' => 6, 'overview' => "Welcome to the year 2020, where baseball has evolved into a contest between human and machine! Enter the futuristic Cyber Egg Stadium and test your skill in 2 world-class leagues with a total of 12 different teams! Step up to the plate and play the most mind-blowing baseball game ever seen:\r\n\r\n* Collect money for great plays and use it to boost your player armor or energize your robots!\r\n* Use your Rocket Pack to jump 50 feet into the air and catch that homerun ball!\r\n* Test your batting skill against an eye-popping 200 mph curveball!\r\n* Check out the awesome graphics, exciting sound and realistic gameplay for 1 or 2 players!\r\n* Use the password feature and resume playing at any point during the season! Follow the computer as it tracks all player stats!\r\n\r\nSuper Baseball 2020: You're traveling into the future of baseball and you won’t want to come back!", 'youtube' => 'LZOu7l3kSy8', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7885], 'genres' => [11], 'publishers' => [60], 'alternates' => ['Super Baseball 2020', '2020 Toshi no Super Baseball'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 305, 'game_title' => 'A.S.P. - Air Strike Patrol', 'release_date' => '1995-01-01', 'platform' => 6, 'overview' => 'Zarak has invaded Sweit! You, as Air Force commander, MUST marshall all your resources and defeat them. Using hi-tech intelligence, locate your targets, load your plane, and destroy... chemical weapon plants, radar sites, enemy vehicles, and more. So strap yourself into a cockpit and fly into the challenge of a lifetime.', 'youtube' => '8ivLHu0j_aU', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [7624], 'genres' => [8], 'publishers' => [76], 'alternates' => ['Desert Fighter'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 306, 'game_title' => 'AAAHH!!! Real Monsters', 'release_date' => '1995-08-15', 'platform' => 6, 'overview' => 'In this game, based on popular Nickelodeon comics, you control three monsters: Ickis, Oblina, and Krumm. The Gromble, a headmaster in monster school, needs you to perform the final test - monster Midterm Exam - in order to prove yourselves to be real monsters. You should collect trash, throw it on people, and scare them!', 'youtube' => 'r7oH7-t0EHI', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7050], 'genres' => [1, 2], 'publishers' => [86], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 308, 'game_title' => 'Dead Space 2', 'release_date' => '2011-01-25', 'platform' => 1, 'overview' => 'Engineer Isaac Clarke returns for another blood-curdling adventure in Dead Space 2, the sequel to the critically acclaimed horror adventure. After waking from a coma on a massive space city known as "The Sprawl," the lone survivor of a horrific alien infestation finds himself confronting a catastrophic new nightmare. Battling dementia, hunted by the government and haunted by visions of his dead girlfriend, Isaac will do whatever it takes to save himself and rid the city of the gruesome, relentless Necromorphs. Equipped with a new arsenal of tools to dismember the Necromorphs, Isaac will face the challenge head-on.', 'youtube' => 'https://www.youtube.com/watch?v=z7Qy_4sWs3I', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9428], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 309, 'game_title' => 'Crysis Warhead', 'release_date' => '2008-09-12', 'platform' => 1, 'overview' => "Crysis Warhead, like the original Crysis, is set in 2020, when an ancient alien spacecraft is uncovered on the fictional Lingshan Islands, east of the Philippines. The singleplayer campaign has the player assume the role of a member of Raptor Team, a squad of mostly American soldiers outfitted with cutting-edge technology. Specifically, they play the role of former Delta Force operator Sergeant Michael Sykes, referred to in-game by his callsign, \"Psycho\". \r\nPsycho was a supporting character in Crysis, in which players played one of his Raptor Team squadmates, Jake \"Nomad\" Dunn. Psycho's arsenal of futuristic weapons builds on those showcased in Crysis, with the introduction of Mini-SMGs which can be dual-wielded, a six-shot grenade launcher equipped with EMP grenades, and the destructive, short ranged Plasma Accumulator Cannon (PAX). The highly versatile Nanosuit, which confers various superhuman abilities upon its wearer, returns. In Crysis Warhead, the player follows a \"secret mission\" Psycho was sent on roughly halfway through the original game, to retrieve a mysterious cargo container held by the North Koreans, believed to contain a nuclear warhead. During this mission, Psycho fights North Korean and extraterrestrial enemies in many different locations, such as a tropical island jungle, inside an \"Ice Sphere\", an underground mining complex, and finally, to an airfield.", 'youtube' => 'https://www.youtube.com/watch?v=P3WTQ4_N2mA', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1970], 'genres' => [1, 8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 310, 'game_title' => 'Aliens vs. Predator', 'release_date' => '2010-02-16', 'platform' => 1, 'overview' => "In the all-new Aliens vs. Predator for PC players will have the chance to take the role of the three infamous species; the Colonial Marine, the Predator and the Alien. Each of the three species has its very own distinct story-driven single-player campaign mode that interweaves with the campaigns of the other two species. Aliens vs. Predator on PC will also feature unique 3-way online multiplayer, allowing gamers to pit the three species against each other in the ultimate battle for survival and for the right to be crowned the deadliest species.\r\n\r\nAliens vs Predator for PC features:\r\n\r\n    * On planet BG-386 a colonist mining group discovers an ancient pyramid containing a dark and horrible secret. Across the stars a race of warriors is alerted to the discovery of their pyramid and a hunting party is dispatched to ensure that it remains sealed at all costs, whilst deep inside the ruined pyramid a malevolent intelligence awakes from centuries of dormancy.\r\n\r\n    * The Marine's story is an incredible fight against the odds, and the horrors lurking in the dark. Beset on all sides yet armed to the teeth, the Colonial Marine represents humanity's last stand with the firepower to fight back.\r\n\r\n    * As the Alien, players will discover what it's like to be the most murderous and lethal creature in the universe, with the ability to traverse any surface with awesome agility in order to get close enough to unleash its deadly teeth and claws.\r\n\r\n    * A master of the hunt, the Predator grants the player a suite of exotic weaponry and equipment with which to stalk its unknowing prey. Earn the greatest honour by ambushing prey up-close and butchering them for a gory trophy kill.", 'youtube' => 'https://www.youtube.com/watch?v=12GOiCWuiNs', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7061], 'genres' => [1, 8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 311, 'game_title' => 'Fallout: New Vegas', 'release_date' => '2010-10-19', 'platform' => 1, 'overview' => "Experience all the sights and sounds of fabulous New Vegas, brought to you by Vault-Tec, America's First Choice in Post-Nuclear Simulation. Explore the treacherous wastes of the Great Southwest from the safety and comfort of your very own vault: Meet new people, confront terrifying creatures, and arm yourself with the latest high-tech weaponry as you make a name for yourself on a thrilling new journey across the Mojave wasteland. A word of warning, however - while Vault-Tec engineers have prepared for every contingency, in Vegas, fortunes can change in an instant. Enjoy your stay.", 'youtube' => 'l-x-1fm2cq8', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6195], 'genres' => [1, 2, 4, 8], 'publishers' => [34], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 313, 'game_title' => 'Warhammer 40,000: Dawn of War II - Chaos Rising', 'release_date' => '2010-03-11', 'platform' => 1, 'overview' => "Your Blood Ravens have saved the sector, but can they save themselves? In THQ Inc. and Relic Entertainment's sequel to the acclaimed Dawn of War II real time strategy franchise, you return to sub sector Aurelia where a long lost frozen ice planet has reappeared from the Warp, bringing with it new secrets to uncover and foes to face. In Dawn of War II: Chaos Rising you will take command of the Blood Ravens and defend the sector against the Chaos Space Marines of the Black Legion. Purge the chaos filth and hold the chapter together as traitorous forces work from within to try bring down the Blood Ravens. Upgrade your squads with new legendary wargear and unlock new special abilities, as your squads advance to level 30. Will you remain steadfast to the Emperor or risk heresy to gain new dark and destructive powers? In multiplayer swear loyalty to the Chaos Gods and pit your bloodthirsty warband of Chaos Space Marines against the new units and reinforced armies of the Space Marines, Orks, Eldar, and Tyranids.", 'youtube' => 'https://www.youtube.com/watch?v=U99KPnZd0CA', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7131], 'genres' => [6, 10], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 314, 'game_title' => 'Super Spike V-Ball & Nintendo World Cup', 'release_date' => '1990-02-01', 'platform' => 7, 'overview' => "2 in 1 game. Super Spike V'Ball / Nintendo World Cup was a pack-in game included with the Nintendo Entertainment System Sports Set. The package included a standard NES console, four game controllers, and the Four Score Multiplayer Adapter. The cart included two games developed by Technos: # Super Spike V'Ball, a two-on-two beach volleyball game where you played on a tournament, ending with the world championship. The game supported up to four players on one match at a time; # Nintendo World Cup, a soccer game where you (and a friend) chose to represent a team and played several matches until you won the World Cup. The game featured little to no rules, which means that you could hit your opponents as much as you want, without fear of the Ref getting in the way. Both games were compatible with the included Four Score NES multiplayer adapter.", 'youtube' => 'unbaUXyVymA', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8606], 'genres' => [11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 315, 'game_title' => '3-D WorldRunner', 'release_date' => '1987-09-12', 'platform' => 7, 'overview' => "The battle of a lifetime comes alive in 3-D! The wildest of the space cowboys is out looking for adventure. Now he's got it and he needs your help. A strange world terrorized by Grax, the Alien Serpentbeast, has asked you, Worldrunner, for help. Knowing you can outrun, outjump and outblast anyone or anything, you race into battle. But this is no ordinary fight. These battles will carry you to eight strange planets filled with bottomless pits, shooting stars, and poisonous aliens, all sworn to defend their Serpent King. And each new world is ruled by an Alien Serpentbeast more terrifying and more powerful than anything you've ever seen before. Are you ready, Worldrunner? They're waiting for you!", 'youtube' => 'ETXonCYjSuM', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8096], 'genres' => [8], 'publishers' => [28], 'alternates' => ['The 3-D Battles of WorldRunner', 'Tobidase Daisakusen'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 316, 'game_title' => '8 Eyes', 'release_date' => '1990-01-01', 'platform' => 7, 'overview' => "CONTROL MAN AND BIRD IN A FIGHT FOR THE EIGHT JEWELS OF POWER!\r\n\r\nAfter hundreds of years of chaos, mankind has finally emerged from the ruins of nuclear war. This world of the distant future has once again fluorished under the guidance of the Great King, who harnessed the power of the 8 Eyes to rebuild the planet.\r\n\r\nThese strange jewels of power were formed at the eyes, or centers, of the eight nuclear explosions which nearly destroyed the Earth. In the wrong hands, the 8 Eyes could cause untold destruction...And now, they have been seized by the Great King's eight Dukes, in a desperate bid to gain control of the world for themselves. They have banished the King to the nuclear wastelands, and already their squabbling threatens to plunge the world into war once again!\r\n\r\nThe task of retrieving the 8 Eyes falls to you, Orin the Falconer, the bravest and mightiest of the King's Guardsmen. With your fighting falcon, Cutrus, you must penetrate each of the eight Dukes' castles. There you will face the Dukes' soldiers, and battle strange nuclear mutants such as living skeletons, giant wasps, and mud men. You must defeat the monstrous Boss of each castle to retrieve the Jewel of Power he guards.\r\n\r\nThen, to complete your quest, return the 8 Eyes to the Altar of Peace to await the return on the Great King, so that he may finish the rebuilding of Earth. Your reward will be the the eternal gratitude of all mankind!", 'youtube' => 'Y-jxDeo5JPc', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [8787], 'genres' => [2], 'publishers' => [87], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 317, 'game_title' => '10-Yard Fight', 'release_date' => '1985-10-18', 'platform' => 7, 'overview' => 'The game is viewed in a top-down perspective and is vertical scrolling. The player does not select plays for either offense or defense. On offense, the player simply receives the ball upon the snap and either attempt to run with the quarterback, toss the ball to one of two running backs, or throw the ball to the one long distance receiver - basically the option offense. On defense, the player chooses one of two players to control, and the computer manipulates the others. The ball can also be punted or a field goal can be attempted.', 'youtube' => '90PSN3lEuGY', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [11], 'publishers' => [3], 'alternates' => ['10ヤードファイト'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 318, 'game_title' => "Assassin's Creed II", 'release_date' => '2009-11-17', 'platform' => 1, 'overview' => "Betrayed by the ruling families of Italy, a young man embarks upon an epic quest for vengeance. To eradicate corruption and restore his family's honor, he will study the secrets of an ancient Codex, written by Altair. To his allies, he will become a force for change - fighting for freedom and justice. To his enemies, he will become a dark knight - dedicated to the destruction of the tyrants abusing the people of Italy. His name is Ezio Auditore di Firenze. He is an Assassin.", 'youtube' => 'R20-MOOZPpY', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9149], 'genres' => [1, 2], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 319, 'game_title' => 'Heavy Rain', 'release_date' => '2010-02-23', 'platform' => 12, 'overview' => 'Experience a gripping psychological crime thriller filled with innumerable twists and turns, where even the smallest actions and choices can cause dramatic consequences. The hunt is on for the Origami Killer, named after his calling card of leaving folded paper shapes on victims. Four characters, each with their own motives, take part in a desperate attempt to stop the killer from claiming a new victim.', 'youtube' => 'XsGJOmATjKM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6898], 'genres' => [2], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 320, 'game_title' => 'Minecraft', 'release_date' => '2011-11-18', 'platform' => 1, 'overview' => 'Minecraft is a sandbox building video game which allows players to build constructions out of textured cubes in a 3D world. The gameplay is inspired by Dwarf Fortress, Roller Coaster Tycoon, Dungeon Keeper, and Infiniminer.', 'youtube' => 'm_yqOoUMHPg&hd=1', 'players' => 4, 'coop' => 'Yes', 'rating' => 'E10+ - Everyone 10+', 'developers' => [5658], 'genres' => [1, 2, 3, 12], 'publishers' => [88], 'alternates' => ['MC'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 321, 'game_title' => 'Wrecking Crew', 'release_date' => '1985-06-18', 'platform' => 7, 'overview' => "The player controls Mario and attempts to destroy all of a certain set of objects with a large hammer on each of 100 levels. Mario cannot jump because of the hammer's weight. Each level takes place on a playfield divided into an invisible grid, each space of which can contain one object. Objects include destructible walls, pillars, and ladders, indestructible barrels and ladders, bombs that destroy all connected destructible objects, and various enemies that Mario must avoid. Doors may also exist, which can be opened to cause enemies to move harmlessly into the background.", 'youtube' => 'https://www.youtube.com/watch?v=XClZDdTzo-E', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6037], 'genres' => [1, 5], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 322, 'game_title' => 'Wrath of the Black Manta', 'release_date' => '1990-04-02', 'platform' => 7, 'overview' => "Big Apple crime is rotten to the core. Now, there's only one way to keep the peace. The way of the Ninja! Introducing the deadliest fighting skills the game world has ever seen! Ten awesome powers, including: Art of Invisibility. Disappear and become invulnerable to attack. Art of Fire Ring: incinerate enemies caught in your deadly ring of fire. Art of Teleportation: Freeze time to reposition yourself and surprise attackers.", 'youtube' => 'https://www.youtube.com/watch?v=7DZLNepMAxw', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [296], 'genres' => [1], 'publishers' => [56], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 323, 'game_title' => 'Wolverine', 'release_date' => '1991-10-10', 'platform' => 7, 'overview' => "Stranded on a remote, deserted island by his arch enemies, Sabretooth and Magneto, Marvel Comics' Wolverine must fight the battle of his life. Super-human powers, including regenerative healing abilities, an indestructible Adamantium skeleton and retractable razor sharp claws that slice through anything, make Wolverine a terrifying adversary... but has he finally met his match? Lead Wolverine in this world-class struggle against Sabretooth and the evil genius, Magneto. In the heat of battle, fellow X-Men Havok, Jubilee and Psylocke come to your side helping even out the score. To survive, you must complete 9 missions, including The Battle for the Skies, Trial by Fire, Trial by Water, The Dungeon of Traps, and The Land of Nightmares, until, at long last, you face your ultimate foes. Prepare for the most exciting and unpredictable X-Men adventure of them all!", 'youtube' => 'https://www.youtube.com/watch?v=WN8DnJR5UD8', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [7940], 'genres' => [1, 15], 'publishers' => [89], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 324, 'game_title' => 'Track & Field II', 'release_date' => '1989-06-01', 'platform' => 7, 'overview' => "The greatest athletes from around the world have gathered for the grandest sporting spectacle since the golden age of Greece. This pressure-packed competition is as fierce as a starved lion. Surviving is a matter of sweat and concentration in Taekwondo, pole vaulting, canoeing, skeet shooting, hammer throwing, high diving, archery, hurdles, gymnastics, hang gliding, pistol firing, arm wrestling, fencing, triple jumping and swimming... Whew! Wears you out just to read them all. The odds in Vegas say you don't have enough strength, stamina or skill, but you know better. And as long as you win, you're the crowd favorite. But lose, and you might as well turn in your jockstrap and joystick.", 'youtube' => 'https://www.youtube.com/watch?v=BRayDY9xFRc', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [11], 'publishers' => [23], 'alternates' => ['Track and Field 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 325, 'game_title' => 'Track & Field', 'release_date' => '1987-04-20', 'platform' => 7, 'overview' => "This ain't no 20-minute workout. It's the ultimate in head-to-head competition, in 8 grueling events. 100 meter dash. Long jump. Hurdles. Javelin. Skeet shooting. Triple jump. Archery. And the high jump. No timeouts, no breathers, no water boys. Just you and your own exhaustion. So get psyched. Pick your level of competition and the opening event. Then block out the roar of the crowd and take a deep breath. Because it's not whether you win or lose. It's whether you survive!", 'youtube' => 'https://www.youtube.com/watch?v=Jm0AoAJ3TF0', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [11], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 326, 'game_title' => '720 Degrees', 'release_date' => '1986-12-19', 'platform' => 7, 'overview' => "Hop on and hang ten as you crash around corners, swerve on sidewalks, and leap over the locals at Skate City, a skateboarder's fantasy world where virtually every surface is skateable. Flip and twist around the street fighters, Frisbee throwers, hard bodies and killer bees that jam city streets. Polish your skills and take your act to the skate parks where you'll vie for medals and cash in downhill, jump, ramp, and slalom competition. Shoot the tubes, \"catch air\" as you fly off ramps - master all of the moves including the dangerous 720. You'll need every edge as you try to become champion of the skating world!", 'youtube' => 'MgMCDBQnSlE', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1], 'genres' => [11], 'publishers' => [90], 'alternates' => ['720°'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 327, 'game_title' => 'The Adventures of Bayou Billy', 'release_date' => '1988-08-12', 'platform' => 7, 'overview' => "The player takes control of the title character, Billy West, who must fight save to his girlfriend Annabelle Lane from the gang of Godfather Gordon. There are a total of ten stages in all: six side-scrolling beat-em-up stages (or street fighting stages, as the game actually dubs them), two light gun shooting (shoot-'em-up) stages, and two action driving stages.", 'youtube' => 'CUZcbojyLBs', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [1, 7, 8], 'publishers' => [23], 'alternates' => ['Mad City', 'マッド・シティ'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 328, 'game_title' => 'Adventures of Lolo', 'release_date' => '1989-04-20', 'platform' => 7, 'overview' => "Prince Lolo of Gentryland visited Eden, a country of love and peace, and enjoyed many pleasant days with Princess Lala of Eden. But one day, Egger, the King of Darkness, who had an evil plot to conquer Eden, spirited the Princess away before Lolo's eyes.\r\nAfter a long and difficult journey, Lolo has come to the evil Castle of the Labyrinth. The castle is guarded by an army of evil monsters led by Egger, the King of Darkness.\r\n\r\nCan Lolo solve the seemingly endless series of mazes and save Lala? Lolo is not gifted with strength or agility, but has great courage and patience. Now the battle of wits begins. Good luck, Lolo!", 'youtube' => 'Jsfkf8l3XnA', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [3694], 'genres' => [1, 5], 'publishers' => [91], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 329, 'game_title' => 'Airwolf', 'release_date' => '1989-06-19', 'platform' => 7, 'overview' => "Deep within enemy territory, your fellow countrymen are imprisoned. Only one man in the free world would dare attempt to save them. You, Stringfellow Hawke, commander of Airwolf. And yet, as you strap yourself into the cockpit of your supersonic jet copter, you know this is the most dangerous assignment you have ever flown.\r\n\r\nYour mission is mapped out. Airwolf's heat-seeking missiles and superpowered machine guns are fired up, ready to blow the terrorists away. But can you evade enemy radar time after time? Can you sneak behind the enemy lines, find the captives and bring them to safety before you crash land or worse?\r\n\r\nHeadquarters knows that you have the skill and firepower it takes. You say you've got the guts... now prove it!", 'youtube' => 'https://www.youtube.com/watch?v=WqjGPqU70tw', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [194], 'genres' => [1, 8, 13], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 330, 'game_title' => 'Asterix', 'release_date' => '1993-01-01', 'platform' => 7, 'overview' => "OBELIX has disappeared...\r\n\r\nThe peace and quiet of the small village of indomitable Gauls is broken by a disturbing piece of news: Obelix has failed to return from his wild boar hunt. The village council convenes and Asterix decides to set off to find his friend.\r\n\r\nLeave with him and travel throughout Gaul, across the Roman Empire, taking your search as far afield as the Egyptian Pyramids...\r\n\r\nAnd as you battle with the Roman armies and avoid the traps set by Caesar's spies, perhaps you will find Obelix.\r\n\r\nMagic potion, Romans, fights, punches, catapults, wild boar, not forgetting that fish that's not quite \"fresh\"...\r\n\r\nRELIVE THE ADVENTURES OF ASTERIX THE GAUL!", 'youtube' => 'A1GeF2LBn7s', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [1097], 'genres' => [15], 'publishers' => [72], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 331, 'game_title' => 'Back to the Future Part II & III', 'release_date' => '1990-12-31', 'platform' => 7, 'overview' => "Get ready for a wild romp through time, Marty McFly, 'cause you're about to take off on a double mission to save the past, present and future! Better load up on pizza and soda as you rocket to the year 2015 in Doc's supercharged time machine. Hang on to your hi-speed hoverboard as you teach Biff Tannen a thing or two about stealing your Sports Almanac, and locate the special objects he's hidden throughout time. Then, if your flux capacitor isn't on the fritz, it's off to the Wild West, where sharp shootin' gunslingers want you out of town by sundown. The fate of the world -- not to mention generations of McFly's -- is in your hands... and you're out of time!", 'youtube' => 'https://www.youtube.com/watch?v=IO8ela7UbXQ', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [67], 'genres' => [1, 2, 5], 'publishers' => [89], 'alternates' => ['Back to the Future II & III', 'Back to the Future 2 & 3', 'Back to the Future Part 2 & 3'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 332, 'game_title' => 'Bad Dudes', 'release_date' => '1989-07-14', 'platform' => 7, 'overview' => 'The game starts in New York City, where President Ronnie (based on former U.S. President Ronald Reagan) has been kidnapped by the nefarious DragonNinja. The intro says: "Rampant ninja related crimes these days... Whitehouse is not the exception...". As soon as that occurs, a Secret Service agent (who resembles Arnold Schwarzenegger as he appears in The Terminator) asks two street-smart brawlers, named Blade and Striker: "President Ronnie has been kidnapped by the ninjas. Are you a bad enough dude to rescue Ronnie?", which this quote became an infamous meme and is often lampooned on the Internet. In the Japanese version, however, the words are completely different. After they heard that, the Bad Dudes confirmed it by pursuing the DragonNinja through the city streets, highway, sewers, transport train, forest, cave and into the secret ninja base, in order to save President Ronnie.', 'youtube' => 'https://www.youtube.com/watch?v=gPYJsxeQOMc', 'players' => 2, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [2126], 'genres' => [10], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 333, 'game_title' => 'Balloon Fight', 'release_date' => '1985-01-02', 'platform' => 7, 'overview' => "The player controls the unnamed Balloon Fighter with two balloons attached to his back. Repeatedly pressing the A or B buttons causes the Balloon Fighter to flap his arms and rise into the air. If a balloon is popped, the player's flotation is decreased, making it harder to rise. A life is lost if both balloons are popped by enemy Balloon Fighters, if the player falls in the water, gets eaten by the large fish near the surface of the water, or is hit by lightning.", 'youtube' => 'lAuwf_JiIo4', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6037], 'genres' => [1], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 334, 'game_title' => "The Bard's Tale", 'release_date' => '1991-11-01', 'platform' => 7, 'overview' => 'Long ago, when magic still prevailed, the evil wizard Mangar the Dark threatened a small but harmonious country town called Skara Brae. Evil creatures oozed into Skara Brae and joined his shadow domain. Mangar froze the surrounding lands with a spell of Eternal Winter, totally isolating Skara Brae from any possible help. Then, one night the town militiamen all disappeared. The future of Skara Brae hung in the balance. And who was left to resist? Only a handful of unproven young Warriors, junior Magic Users, a couple of Bards barely old enough to drink, and some out of work Rogues. You are there. You are the leader of this ragtag group of freedom fighters. Luckily you have a Bard with you to sing your glories, if you survive. For this is the stuff of legends. And so the story begins...', 'youtube' => 'R6EkbfgXqWg', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [4287], 'genres' => [4], 'publishers' => [2, 3282], 'alternates' => ["The Bard's Tale - Tales of the Unknown"], 'uids' => nil, 'hashes' => nil },
    { 'id' => 335, 'game_title' => 'Baseball', 'release_date' => '1983-12-07', 'platform' => 7, 'overview' => "Baseball is a simple baseball video game made by Nintendo in 1983 for the Nintendo Family Computer, making it one of the first games released for the Famicom. It was later one of the NES's 18 launch titles when it was released in 1985 in the United States. As in real baseball, the object of the game is to score the most runs. Up to two players are supported. Each player can select from one of six teams. Although there is no difference between them other than uniform color, they are meant to represent the six members of the Japanese Central League.", 'youtube' => '3RxgAJ4qtgY', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6037], 'genres' => [11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 336, 'game_title' => 'Bases Loaded II: Second Season', 'release_date' => '1989-01-01', 'platform' => 7, 'overview' => "The game is the second installment of the Bases Loaded series. The series spanned three generations of consoles and eight total installments. The original Bases Loaded title was an arcade game that Jalelco ported to the NES. Only the original Bases Loaded was an acrade game; the rest of the series were exclusive to their particular consoles. There are four video games in the Bases Loaded NES series, Bases Loaded II: Second Season, Bases Loaded 3 and Bases Loaded 4. There was also a Game Boy version of Bases Loaded. The series continued onto the SNES platform with Super Bases Loaded, Super Bases Loaded 2, and Super Bases Loaded 3. The final entry to the series was Bases Loaded '96: Double Header, released for the fifth generation consoles Sega Saturn and PlayStation.", 'youtube' => 'FaUk0DCgBI4', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [8959], 'genres' => [11], 'publishers' => [94], 'alternates' => ['Bases Loaded 2 Second Season', 'Bases Loaded 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 337, 'game_title' => 'Batman: The Video Game', 'release_date' => '1990-02-01', 'platform' => 7, 'overview' => "He's totally new. Totally tough. And he'll stop at nothing to make sure justice prevails! From the dark streets of GOTHAM CITY to the deepest corners of the criminal underworld comes the CAPED CRUSADER as you've never seen him before. Incredibly strong. Armed to the teeth. And ready to put his life on the line for the sake of all, on a search-and-destroy mission to end the Joker's reign of terror. He leaps, he flies, he dodges enemy fire and delivers it right back... with a vengeance. This is no kid stuff. This is as real as video gaming gets. If you liked what you saw in the movie, you're gonna love what you see here. Because this time around, BATMAN is all business, and he won't let anything stand in his way!", 'youtube' => 'https://www.youtube.com/watch?v=SLV9RHXnceg', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8329], 'genres' => [1], 'publishers' => [75], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 338, 'game_title' => "Castlevania II: Simon's Quest", 'release_date' => '1988-12-01', 'platform' => 7, 'overview' => "Castlevania was a cakewalk compared to this bloody curse. You thought you had the Prince of Darkness defanged - eh, Simon Belmont? Well think again, 'cause according to a damsel in distress, evil Count Dracula has left a horrifying curse in his wake. And the only hope you have of ending the terror is to destroy his missing body parts! Talk about your frightening quest, searching a maze of mansions, graveyards and dark, eerie forests - each guarded by man-eating werewolves, fire-throwing zombies and other devilish demons. Your grim chances are kept alive in Transylvania, where cowardly villagers offer clues to the whereabouts of Dracula's remains. And where you'll purchase magic weapons, including silver knives and flame whips. But beware the night. For when the sun disappears, Dracula's curse grows deadlier. And your chances grow dimmer and dimmer.", 'youtube' => 'KK9Im7YtDz8', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [1, 2, 15], 'publishers' => [23], 'alternates' => ['Castlevania 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 339, 'game_title' => "Castlevania III: Dracula's Curse", 'release_date' => '1990-09-01', 'platform' => 7, 'overview' => "Led by the immortal Count Dracula, the greatest army of evil ever assembled is poised to bury mankind in a Tomb of Terror. Destroying this legion of Swamp Dragons, Slasher Skeletons and Forces of the Undead will be the supreme challenge for the mightiest of warriors. Your place in history is 100 years before Simon Belmont's birth. Dracula is young at heart, and it will take more than a stake to penetrate his evil. Luckily, you command the role of Trevor - Simon's forefather and the origin of the Belmont Warlord Chromosomes. Trevor has a power never before seen by human eyes - the power to transform into three different spirits: Grant DaNasty, the ferocious Ghost Pirate. Sypha, the Mystic Warlord. And Alucard, Dracula's forgotten son. You must perfectly time Trevor's body transformations to match up his different fighting spirits against Ultimate Evils. Trevor also has the strength and wisdom to command the Battle Axe, Invisibility Potion and Mystic Whip. But the most important weapon Trevor has is your cunning to choose the correct Paths of Fate and your bravery to lead him past 17 possible levels of never-ending doom, including the Haunted Ship of Fools, the Sunken City of Poltergeists, the Clock Tower of Untimely Death and Curse Castle. Never before have so many dangers confronted you at one time. And if by some miracle you triumph, you'll no longer be a mere mortal. You'll be a legend who'll live forever!", 'youtube' => 'Bw7D2YKg1T4', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [1, 2, 15], 'publishers' => [23], 'alternates' => ['Castlevania 3', '悪魔城伝説 Akumajō Densetsu', 'Legend of the Demon Castle', 'Akumajō Densetsu'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 340, 'game_title' => 'Clu Clu Land', 'release_date' => '1984-11-22', 'platform' => 7, 'overview' => "Clu Clu Land's story starts with a type of Sea Urchin, the Unira, stealing all of the treasures in the underwater kingdom of Clu Clu Land. Bubbles, the hero, sets out to retrieve the treasure. The object of the game is to uncover all the gold bars in each stage while avoiding the Unira and Black Holes.", 'youtube' => 'https://www.youtube.com/watch?v=SE2BOjengNc', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [5], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 341, 'game_title' => 'Crystalis', 'release_date' => '1990-04-13', 'platform' => 7, 'overview' => "You must save the world from evil magic by finding the four powerful swords that form Crystalis.\r\n\r\nAfter the apocalypse, magic returns to Earth.\r\n\r\nA blessed group of good-intentioned sorcerers have used their new magical powers to rebuild the Earth, but an evil sorcerer named Dragonia has combined his supernatural forces with man-made technology to devastate the rebuilt Earth. It is your mission to recover four mystical swords, and combine them to form the ultimate blade: the Sword of Crystalis. This legendary weapon is the only tool which can put an end to Dragonia's black reign.", 'youtube' => 'https://www.youtube.com/watch?v=8DWu_BVeg5E', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7885], 'genres' => [1, 2, 4], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 342, 'game_title' => 'Double Dragon II: The Revenge', 'release_date' => '1988-12-01', 'platform' => 7, 'overview' => "The Double Dragons - Billy and Jimmy Lee - are back to avenge the loss of Marion! In their quest to defeat the evil Shadow Warriors, the martial arts duo are challenged in 9 incredible missions, facing ruthless street gangs, nunchaku-toting ninja and giant mutant warriors! The non-stop action winds its way through construction sites, alleyways and underwater hideouts complete with secret elevator shafts, spiked ceilings and razor-sharp mechanical claws! And in a bonus mission, never before seen, the duo's worst fear becomes reality as they fight the ultimate battle between good and evil. A battle where not only their lives are at stake, but the fate of the entire world!", 'youtube' => 'https://www.youtube.com/watch?v=NkuB2PWJssY', 'players' => 2, 'coop' => 'Yes', 'rating' => nil, 'developers' => [8607], 'genres' => [1], 'publishers' => [95], 'alternates' => ['Double Dragon 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 343, 'game_title' => 'Double Dribble', 'release_date' => '1987-09-01', 'platform' => 7, 'overview' => "Finally, it's here! The basketball game you've dreamed of. The first home game with 5 on 5, full court, board-banging action. A contest with graphics so real, they'll knock your high-tops off. Ready to captain your team to the title, you bolt into the arena with electricity in your fingers and ice in your veins. Intensity builds. The crowd roars. The game is yours to win or lose. But to win you'll need speed in the lane, touch for three-pointers, muscle to power past picks, and the skill to crash the glass. And, if you break free underneath - watch out! Because now you can power home a rim-rockin' slam! So pull up your shorts and take a deep breath. It's crunch time. Time to show your stuff!", 'youtube' => 'v-PUj1H52ko', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [11], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 344, 'game_title' => 'Dr. Mario', 'release_date' => '1990-10-14', 'platform' => 7, 'overview' => 'A puzzle game similar to Tetris, Dr. Mario features Nintendo mascot Mario as a doctor. Gameplay consists of dropping two-sided vitamin capsules into a playing field 8 blocks wide by 16 blocks high resembling a medicine bottle, populated by viruses of three colors', 'youtube' => 'rSYfo8PwLQU', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6051], 'genres' => [5], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 345, 'game_title' => 'Dragon Warrior', 'release_date' => '1989-08-01', 'platform' => 7, 'overview' => "Dragon Warrior uses console role-playing game mechanics which were described by Kurt Kalata of Gamasutra as archaic in 2008. The player takes the role of a namable Hero. The Hero's name has an effect on his statistical growth over the course of the game. Battles are fought in a turn-based format and experience points and gold are awarded after every battle, allowing the Hero to level-up in ability and allows them to buy better weapons, armor, and items. Progression consists of traveling over an overworld map and through dungeons, fighting monsters encountered via random battles along the journey.\r\n\r\n\" As a whole, Dragon Warrior has been credited with establishing the basic template for the Japanese console RPGs that followed. \" -Wikipedia", 'youtube' => '1qL5_3EhqK8', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1637], 'genres' => [2, 4], 'publishers' => [3], 'alternates' => ['Dragon Quest (JP)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 346, 'game_title' => 'Duck Hunt', 'release_date' => '1984-04-21', 'platform' => 7, 'overview' => 'In Duck Hunt, players use the Nintendo Zapper Light Gun and attempt to shoot down either ducks or clay pigeons in mid-flight.', 'youtube' => '-1NyIsZXeqU', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [8], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 347, 'game_title' => 'Dynowarz: Destruction of Spondylus', 'release_date' => '1989-04-01', 'platform' => 7, 'overview' => "Something was terribly wrong in the distant man-made Spondylus Solar System. One by one the planet's central life support computers had been infected with a life threatening virus while the planet surfaces had been overrun with computerized dinosaurs known as Robosaurs. Under attack in his laboratory on Alpha Planet, Professor Proteus, the mastermind of the Spondylus System and the founder of the Robosaur project suddenly realized that this deadly sabotage could only be the work of his former partner, the deranged Dr. Brainius.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [900], 'genres' => [1, 2], 'publishers' => [57], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 348, 'game_title' => 'Elevator Action', 'release_date' => '1987-08-01', 'platform' => 7, 'overview' => 'The player assumes the role of a spy who infiltrates a building filled with elevators. He must collect secret documents from the building and traverse the 30 levels of the building using an increasingly complex series of elevators. The player is pursued by enemy agents who appear from behind closed doors. The player must outwit them via force or evasion. Successful completion of a level involves collecting all the secret documents and traversing the building from top to bottom. In the lower floors of the building, the elevator systems are so complex that some puzzle-solving skills are needed.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8449], 'genres' => [1], 'publishers' => [56], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 349, 'game_title' => "Ghosts 'n Goblins", 'release_date' => '1986-09-19', 'platform' => 7, 'overview' => "The beautiful princess is kidnapped. Her lover, the Knight in shining armor, armed with five different weapons to fight the enemy, sets out to rescue the beautiful princess. The Knight, aided by your skill, must pass through seven different guarded gates, fighting and destroying demons, dragons, giants and zombies. There are hidden characters, too! Some friends, some foes. Ghosts 'N Goblins is exciting... challenging you and the Knight to rescue the princess, amid great danger, escaping Hades, land of the enemies!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [2], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 350, 'game_title' => 'Golf', 'release_date' => '1984-05-01', 'platform' => 7, 'overview' => "Nintendo GOLF lets you choose your clubs, change your stance, control your swings - even select the angle of impact! You'll view the hole from both close up and far away, judge the changing conditions of the green, and measure the wind velocity. But watch out! When the wind changes, so does the flight of your ball. With Nintendo's state-of-the-art graphics and realistic game play, you'll really believe you're on the fairways. So play Nintendo GOLF, because there's not a video golf game on par with it anywhere!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 351, 'game_title' => 'Gumshoe', 'release_date' => '1986-06-06', 'platform' => 7, 'overview' => "Jennifer's been kidnapped! Now's your chance to prove you're a sharp-shooting detective by helping Jennifer's father find the five diamonds that will pay her ransom. You'll use your Zapper light gun to blow away anything that gets in your way. But even with the Zapper, this case will be hard to crack. Because not only are the diamonds hard to find, but you only have 24 hours to find them! What's more, you'll have to think fast and shoot even faster, because ferocious monsters, diving airplanes and hungry man-eating sharks will stop at nothing to prevent you from getting to the diamonds. Think you're a sharp-shooting detective? Well, you better be. Because if you're not, it's curtains for you in this quick-on-the-trigger Nintendo Light Gun game!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [6037], 'genres' => [1], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 352, 'game_title' => 'Heavy Barrel', 'release_date' => '1990-03-02', 'platform' => 7, 'overview' => 'Heavy Barrel is a shooter with a top-down view similar to Commando and Ikari Warriors. Terrorists have seized the underground control complex of a nuclear missile site. It is up to the player to infiltrate the installation and eliminate the leader of the terrorist army before they can launch the missiles. To stop the terrorists you will need the powerful weapon Heavy Barrel. The problem is that the weapon still is in the installation. Before the fortress fell the weapon was taken apart and locked in six different storage lockers. To defeat the terrorists you must collect all keys and reassemble the weapon. The game supports co-op for two players.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2126], 'genres' => [6], 'publishers' => [55], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 353, 'game_title' => 'Hudson Hawk', 'release_date' => '1992-02-01', 'platform' => 7, 'overview' => 'The player assumes the role of Hudson Hawk, a cat burglar. He is sent on a mission to steal three Da Vinci artifacts. Walking through various levels in this platform game, the player must avoid sounding alarms. In addition, security guards and dogs show up to hamper the mission. Hudson Hawk can pacify the enemies by punching them or throwing a "ball" at them.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8039], 'genres' => [1], 'publishers' => [43], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 354, 'game_title' => 'Jackal', 'release_date' => '1986-06-27', 'platform' => 7, 'overview' => 'The Jackal squad, a four-man team composed of Colonel Decker, Lieutenant Bob, Sergeant Quint and Corporal Grey, is sent to rescue soldiers kept as hostages by the enemy. One or two players control the teams in an armed jeep, which must venture through several enemy strongholds to rescue comrades imprisoned by the enemy. In each of the six levels, the goal is to rescue POWs from various buildings and then transfer them to helicopter dust-off locations. Once the soldiers are secure, the player(s) must then proceed to defeat the boss at the end of each level. In the last level, there are two bosses that must be defeated.', 'youtube' => 'https://www.youtube.com/watch?v=DADsaTZPwmA', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [8], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 355, 'game_title' => "King's Knight", 'release_date' => '1986-09-18', 'platform' => 7, 'overview' => 'Four brave warriors have set out into the Kingdom of Izander to rescue Princess Claire from the grip of a fiendish Dragon. Through five thrilling, fast-action stages, our gallant heroes, a Knight, a Wizard, a Monster, and a Thief, will take on incredible enemies. Join in and help this tough team reach their goal!', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8096], 'genres' => [1], 'publishers' => [11], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 356, 'game_title' => 'Low G Man: The Low Gravity Man', 'release_date' => '1990-09-01', 'platform' => 7, 'overview' => 'You are the Low Gravity Man! When powered up, you can jump one and three quarters screens high. Capture and use enemy vehicles, including the spider vehicle which can crawl on ceilings. Catch and power up enemy weapons, and much, much more. Your mission is to take back the robot-producing exploration planet from the evil aliens before they reprogram all of the robots for the destruction of the human race. Includes password, infinite continue, and multiple quests for long-term enjoyment!', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8529], 'genres' => [15], 'publishers' => [87], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 357, 'game_title' => 'Lunar Pool', 'release_date' => '1985-12-05', 'platform' => 7, 'overview' => 'Lunar Pool is the first advanced home video billiards game ever. Never before has the player been able to choose among 60 different "tables." Jump around to your favorite, or master each stage consecutively. Your score is kept automatically. You set up the electronic cue stick, aim the cue ball, choose the power you need and shoot! Then watch the ball ricochet around the "table" and land in the pocket. Learn to be a "hustler" by mastering all 60 stages!', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [1785], 'genres' => [11], 'publishers' => [96], 'alternates' => ['Lunar Ball'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 358, 'game_title' => 'Mach Rider', 'release_date' => '1985-10-18', 'platform' => 7, 'overview' => "Grip the handles of your futuristic motorcycle. Feel the freezing wind crack against your cheeks. Suddenly you're off! Riding at speeds up to 500 miles per hour in a desperate attempt to save the planet. You'll love every hair pin curve because you've created this daredevil course yourself. Along the way you'll be challenged by an endless array of ruthless villains who will do everything in their power to destroy you and your planet. You'll defend yourself with a specially mounted Power Blaster. But watch out! The action is fast. The danger is imminent. Design your own course or ride one of ours, in this lightning fast Nintendo Programmable game!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [6053], 'genres' => [7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 359, 'game_title' => 'Marble Madness', 'release_date' => '1989-03-01', 'platform' => 7, 'overview' => "The idea is deceptively simple: Guide a marble down a path without hitting any obstacles or straying off the course. The game is viewed from an isometric perspective, which makes it harder to stay focused on the direction the ball is to follow. There are tight corridors to follow and enemies to avoid. There is a 2-player mode in which players must race to the finish; otherwise you're racing against the clock.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6991], 'genres' => [5], 'publishers' => [97], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 360, 'game_title' => 'Mega Man', 'release_date' => '1987-12-17', 'platform' => 7, 'overview' => "It's MEGA MAN versus the powerful leaders and fighting forces of Monsteropolis - that strange multi-layered land of robot-like humanoids created by the wrongly-performed experiments with human beings by Dr. Wily. Mega Man - the chosen defender of the human race. For he dares to single-handedly penetrate Monsteropolis' seven separate societies to stop the rapid expansion of strange misrepresentations of humans.\r\n\r\nMega Man's goal is monumental. He must infiltrate seven separate heavily-guarded empires. By himself, he must break down and destroy the following empire leaders: Cutman, Gutsman, Iceman, Bombman, Fireman, Elecman, and Dr. Wily. The action involves Mega Man armed only with laser beam weapons, encountering strangely-configured humanoids. They're atop, in and out of fortified prison-like structures strengthened with thick walls. Hidden amid gun turrets embedded in concrete uprights, even in subterranean passages below icefields. WOW!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => %w[Rockman Megaman], 'uids' => nil, 'hashes' => nil },
    { 'id' => 361, 'game_title' => 'Mega Man 2', 'release_date' => '1988-11-24', 'platform' => 7, 'overview' => "He's Back! And this time the evil Dr. Wily (once the supreme power in the universe) has created even more sinister robots to mount his attack. But as MegaMan, you've also grown in power and ability. Can you save mankind from the evil desires of Dr. Wily? Each of the eight empires is ruled by a different super-robot. You must defeat each enemy on his own turf, building up weapons as you go. Only after all are destroyed will you go head-on with the mastermind himself, the evil Dr. Wily.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Rock Man 2', 'Megaman 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 362, 'game_title' => 'Mega Man 3', 'release_date' => '1990-09-28', 'platform' => 7, 'overview' => "It's robot rebellion, and nobody's safe! Least of all, Mega Man! This time the superpowerful cyborg takes on a horde of metal maniacs who've had it with being obedient! And they use every android-annihilator ever invented to make you believe it! Mega Man goes berserk, blasting through a galaxy of mining stations in search of energy crystals. But it takes more than guts to battle the phenomenal robot masters who control these worlds. It's a wrenching job, the worst - and the best - that Mega Man's faced so far!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Rock Man 3', 'Megaman 3'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 363, 'game_title' => 'Mega Man 4', 'release_date' => '1991-12-06', 'platform' => 7, 'overview' => "For a year the city has been quiet, but a new robotic terror has gripped the city! That scheming scientist, Dr. Cossack has arrived in town with eight new metal maniacs who are bigger and badder than anything Dr. Wily dreamed of. It's going to be a cybernetic showdown as the streets of the city erupt with the sizzling sounds of molten metal! Armed with the new Mega Buster, Mega Man runs, jumps and dodges his way through mazes of metallic munchkins on his way to the Siberian citadel of Dr. Cossack for the final cataclysmic clash!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Rockman 4: Aratanaru Yabou!!', 'Megaman 4'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 364, 'game_title' => 'Mega Man 6', 'release_date' => '1992-10-06', 'platform' => 7, 'overview' => "From the United States, Canada and Japan they came. The world's premier designers and their finest robotic warriors traveled to do battle in the First Annual Robot Tournament. But what began as a game suddenly took a terrifying twist! On the eve of the Grand Championship, the sponsor of the event announced that the entire tournament was just an elaborate scheme to get his hands on the world's most powerful robots! Now faced with an army of metallic mercenaries, Mega Man must fight a ferocious new foe - The Mysterious Mr. X!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Rockman 6: Shijou Saidai no Tatakai!!', 'Megaman 6'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 365, 'game_title' => 'Metal Gear', 'release_date' => '1987-07-07', 'platform' => 7, 'overview' => "Outer Heaven leader CaTaffy has activated the ultimate super weapon: Metal Gear! Responding to the crisis, covert unit \"Fox Hound\" is called into action, and that's where you come into play. Trained in hand-to-hand combat and skilled in every weapon known to man, you're Fox Hound's lethal fighting machine, code named \"Solid Snake\". But on this mission you better be sly as well, to surprise heavily-armed enemies, busting 'em up quietly and rescuing their hostages before alarms are triggered. Plus you gotta maintain radio contact with Commander South, who'll feed you crucial info on Metal Gear's whereabouts. To survive, capture sub-machine guns, Barettas, grenade launchers, and plastic explosives, until you find and destroy Metal Gear, ending CaTaffy's reign of terror!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [1, 6], 'publishers' => [98], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 366, 'game_title' => "Snake's Revenge", 'release_date' => '1990-04-13', 'platform' => 7, 'overview' => "After his ironclad plan to rule the world rusted away, crazed Colonel Vermon CaTaffy went psycho. Unfortunately, your two best friends took the brunt of his frenzy and lost their fight to live. As nutty as ever, CaTaffy has sought asylum from the world's premiere bad guy - Higharolla Kockamamie. Grateful to this 'Rolla Radical, the Colonel has donated the biggest, baddest Ultra-Sheik Nuclear Attack Tank to his fellow madman's world dominating cause. \r\n\r\nNow your mission is to not only save Earth, but to inflict revenge. It's a job you'll definitely take personally as you infiltrate a nation of armed lunatics. Blow up a battleship. Hijack a train. Locate dozens of weapons and a truth serum that'll force enemy commanders to spill their guts. Then, destroy Vermon, Higharolla and the Earth Threatening Device with one lethal blow. All this, while staying in radio contact with a foxy spy named Jennifer and a Stealth copter pilot who'll be hovering nearby. So whaddaya think, Snake - are you commando enough to handle this Kockamamie scheme?", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [1], 'publishers' => [98], 'alternates' => ["Metal Gear: Snake's Revenge"], 'uids' => nil, 'hashes' => nil },
    { 'id' => 367, 'game_title' => 'Mission: Impossible', 'release_date' => '1990-09-01', 'platform' => 7, 'overview' => "Need we say more?\r\nUltra® Dares you to defy the impossible.  But if you accept, be forewarned.  You and your trio of Impossible Mission Force agents will infiltrate a six level maze of unthinkable danger.  A fortress of international evil designed to sap every ounce of your brains and brawn.  At each turn you must fend off snipers and fire bomb maniacs.  Elude spy cameras and robot sentries.  Escape from countless enemies in hot pursuit.  All in your desperate search for booby-trapped clues, secret ID cards and life-saving switches.\r\n  Any why?  Because the worldwide terrors known as the Sinister Seven have kidnapped Dr. \"O,\" his nuclear military defense system and IMF agent Shannon Reed, and now they threaten to wreak planetary chaos.\r\n  Luckly, your agents are well schooled in the art of espionage and possess their own favored firepower, from rifles to remote control cluster bombs.  But that's no guarantee you'll make it past brutes like Slash Stiletto, Blitz Blizzardski and the Iron Claw.  If by chance you do, there's always the hyper speedboat chases through Venice, hand grenade ski runs down the Swiss Alps, and prison camps in the Pyrenees mountains.\r\n  Remember, should you choose to accept this mission and fail, you, your Nintendo®, and the world will self-destruct in five seconds.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [1, 2, 8], 'publishers' => [98], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 368, 'game_title' => 'MULE', 'release_date' => '1990-09-01', 'platform' => 7, 'overview' => 'IRATA. A New World rich with opportunity. For wealth. And power. And you can become the richest, most powerful inhabitant of the newly discovered planet by owning the most land, mining the most precious metal, and supplying the most food and energy to all the peasants - otherwise known as your opponents. To win you need MULEs (Multiple Use Labor Elements), kind of mechanical donkeys which do your dirty work: growing food, mining, and producing energy. MULEs are critical, so you want to get as many as possible as cheaply as possible. And by the way, treachery is acceptable. So use it when needed. Then sit back and enjoy your wealth and power, OH MIGHTY RULER!', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => nil, 'developers' => [6350], 'genres' => [6], 'publishers' => [90], 'alternates' => ['M.U.L.E.'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 370, 'game_title' => 'Ninja Gaiden II: The Dark Sword of Chaos', 'release_date' => '1990-05-01', 'platform' => 7, 'overview' => 'Dynamic action scenes! Split your body into three, destroy all enemies with the Invincible Fire Wheel and other new Ninja fighting techniques! Ninja Gaiden II gives you the feel of real Ninjutsu! Exciting cinema display format! Ninja Gaiden II uses the same Cinema Display Format as the original. The fiendish plot unfolds in a movie-like sequence. Action, drama, revenge. Just wait till you get to the end!', 'youtube' => '7itFTOXi278', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [8614], 'genres' => [1, 15], 'publishers' => [24], 'alternates' => ['Ninja Ryūkenden II: Ankoku no Jashin Ken (JP)', 'Legend of the Ninja Dragon Sword II: The Demonic Sword of Darkness (JP)', 'Shadow Warriors II: The Dark Sword of Chaos (EU)', 'Shadow Warriors 2', 'Ninja Gaiden Episode II: The Dark Sword of Chaos'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 371, 'game_title' => 'Paperboy', 'release_date' => '1988-12-01', 'platform' => 7, 'overview' => 'Hop on your bike for a free-wheeling ride up the avenues of not-so-typical suburbia. There are papers to be delivered, robbers to be foiled, and fame and fortune to be won as you brave the mean streets. Avoid motorcycles, tricycles, traffic, tires, gratings, curbs, dogs, skateboarders, breakdancers, bad guys, and other hazards as you deliver to your customers. Earn bonus points by hitting targets along the obstacle course at the end of your route. With superb animation and sound effects, Paperboy brings home all the thrills, spills, challenge, and excitement you loved in the arcades.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8654], 'genres' => [1], 'publishers' => [90], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 372, 'game_title' => 'Pinball', 'release_date' => '1985-10-01', 'platform' => 7, 'overview' => "Be a pinball wizard, right in your own home!\r\n   Bank off bumpers, flip double flippers - even win a bonus round - in Nintendo's lightning-fast PINBALL!  You'll have the time of your life as you flip from upper to lower game screens, rack up points to beat your opponent, and, if you're lucky, progress to the bonus round where you'll save the falling maiden in this video version of the real thing!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6037], 'genres' => [1], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 373, 'game_title' => 'Pinball Quest', 'release_date' => '1990-06-30', 'platform' => 7, 'overview' => "Don't let the name fool you - Pinball Quest is much more than video pinball. In fact, it's the first-ever multi-screen fantasy in a pinball format! Every move you make tells a story; every shot takes you another step closer in your quest to rescue the captive princess of the castle. Along the way you'll meet ghosts, goblins, witches and demons, in an endless labyrinth of treacherous passages and deadly doorways. It takes a fearless heart and a fast mind to conquer Pinball Quest. It also takes the skills of a true pinball wizard... which you can hone on the three other video pinball games included on this cartridge! So before you pour any more money into your NES library, get the one title that's a library all by itself! No matter how hard you try, you can't get enough of Pinball Quest!", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => nil, 'developers' => [4411], 'genres' => [1], 'publishers' => [94], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 374, 'game_title' => 'Predator', 'release_date' => '1989-04-01', 'platform' => 7, 'overview' => "Predator is a side-scrolling platformer which uses the imagery and characters from the classic Arnie movie of the same name. The game is not a faithfully conversion of the movie however - your unit has already been killed off when the game starts and you will battle scorpions, enemy soldiers and dodge obstacles etc, before facing the Predator itself a number of times.\r\n\r\nThe game is a fairly standard run-jump-shoot platformer, except that you start with no weapons at all and must collect them as the game goes on.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [234], 'genres' => [1], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 375, 'game_title' => 'RoboCop', 'release_date' => '1989-08-25', 'platform' => 7, 'overview' => "A sadistic crime wave is sweeping through old Detroit. The situation is explosive - in fact, it is so bad, a private corporation, O.C.P., has assumed control of the police force. Then, a research team creates an unstoppable, indestructible law enforcement cyborg - named RoboCop. Using a wild assortment of weapons, including RoboCop's Special Issue Auto-9, you must stop every sleazeball criminal you encounter with deadly, piercing accuracy. But beware, there are forces on the street - and within O.C.P. - that will stop at nothing to see RoboCop eliminated. Make your way past 6 levels of street thugs, Boddicker and the powerful ED-209 to your final battle with Dick Jones. Prepare yourself for non-stop action in one of the most explosive games you will ever play. It's going to take more than a cop to clean up the scum of old Detroit - it's going to take RoboCop. \"Your move, creep.\"", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [10_213, 10_214, 10_215], 'genres' => [8], 'publishers' => [55], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 376, 'game_title' => "Rush'n Attack", 'release_date' => '1989-06-08', 'platform' => 7, 'overview' => "Up for a little guerilla warfare? You asked for it. You're behind enemy lines, armed with only a knife and a mission: to free dozens of POWs hidden in an isolated, well-armored camp. If you're good, you'll pick off the heavily-armed enemy guerillas, one by one, and grab their bazookas and hand grenades. If you're great, you'll turn their weapons against them, to blow away a pack of attack dogs, a fleet of choppers, and a whole battalion of guards. But make one mistake, and it's all over. For you, our POWs... the future of the Free World!", 'youtube' => 'https://www.youtube.com/watch?v=AudtO3Dp8z0', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [15], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 378, 'game_title' => 'Skykid', 'release_date' => '1986-01-01', 'platform' => 7, 'overview' => "You are the legendary Red Baron, flying a plane through a horizontal side-scrolling scenery set during World War I. To complete a mission, you simply need to get to the landing spot on the other side without being shot down, but you can gain extra points by destroying enemy vehicles and planes. For huge points, pick up a bomb hidden in the level (you will be warned by a sound when approaching it) and drop it on a large structure. If you fail to land on the landing strip, you run out of fuel and crash.\r\n\r\nYou can only shoot horizontally and diagonally by tilting the plane's nose. When in trouble, perform an aerial loop with the secondary button, this often destroys other planes and avoids bullets. There is a co-op mode with the character Max as well.", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => nil, 'developers' => [5804], 'genres' => [13], 'publishers' => [75], 'alternates' => ['Sky Kid'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 379, 'game_title' => 'Slalom', 'release_date' => '1987-01-01', 'platform' => 7, 'overview' => 'In Slalom you need to ski down different trails and beat the clock to move on to the next of the 24 trails. Other skiers, trees, snowmen, sledders, and moguls will get in your way and slow you down if you crash into them. Slalom flags are located throughout the trails, and skiing on the wrong side of these will cause your player to snowplow momentarily and lose speed, so to get the best times you need to make sure none of the flags are missed.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [6991], 'genres' => [11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 380, 'game_title' => 'Spider-Man: Return of the Sinister Six', 'release_date' => '1992-10-15', 'platform' => 7, 'overview' => 'Doctor Octopus is plotting the crowning caper of his criminal career... to rule the world. He has reunited the Sinister Six and with these super-villains together again, nothing stands in their way - except Spider-Man!', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [1120], 'genres' => [1], 'publishers' => [89], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 381, 'game_title' => 'Star Wars', 'release_date' => '1991-11-15', 'platform' => 7, 'overview' => 'Only the people who made the movie could bring you this much action and adventure... Control your favorite Star Wars heroes - Luke Skywalker, Han Solo, Princess Leia. Enlist the help of Obi-Wan Kenobi, C-3PO, and R2-D2. Outfight and outsmart the intergalactic bad guys - stormtroopers, jawas, Banthas, bounty hunters, sinister droids, and more. Explore the spectacular worlds of Star Wars - from the Tatooine Desert to the Mos Eisley Spaceport to inside the Death Star. And if you get very, very good... destroy the Death Star and save the Rebel Alliance from Darth Vader!', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [67], 'genres' => [1], 'publishers' => [243, 8192], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 382, 'game_title' => 'Super Spy Hunter', 'release_date' => '1991-01-01', 'platform' => 7, 'overview' => "The Super Spy Hunter has a super spy car. It's actually a well-armed car that can turn into a boat or a plane at opportune times. The action is fast vertical scrolling as the vehicle faces all manner of powerful vehicle threats from a well-funded terrorist enemy -- cars, trucks, helicopters, etc. Luckily, there are many powerups to collect along the way, both defensive and offensive.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [8903], 'genres' => [1], 'publishers' => [104], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 383, 'game_title' => 'Teenage Mutant Ninja Turtles', 'release_date' => '1989-12-31', 'platform' => 7, 'overview' => "Carnivorous robots chow-down in China Town, while brutal Ninjitsu Warriors, blood descendants of the deadly \"Foot\" Clan, bust-up bystanders from the Bronx to Broadway. Police SWAT Teams can't stop them, but the Teenage Mutant Ninja Turtles can! 'Cause, powered by slices of pizza, they're always ready to rumble - with nunchukus, Katana Blades, and a party bus loaded with Anti-Foot Clan Missiles. So team up with the turtles, Raphael, Leonardo, Michaelangelo and Donatello, then switch on the tortoise radar, following your map and sixth sense past savage traps and secret sewage passages. Knock heads with the nasty Ninjitsu and either splatter them senseless or get yourself turned into turtle soup!", 'youtube' => 'https://www.youtube.com/watch?v=IS1TFKuSuzQ', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [1, 2], 'publishers' => [98], 'alternates' => ['Teenage Mutant Hero Turtles'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 384, 'game_title' => 'Tennis', 'release_date' => '1985-10-01', 'platform' => 7, 'overview' => "Whether it's singles or doubles you'll love the non-stop action of this amazingly real tennis game!\r\n\r\n   Slam a serve, fire a blazing backhand, smash a forehand volley - you call the shots in Nintendo TENNIS!  Nintendo lets you choose an opponent from five different skill levels.  So as your game improves, so does your playing partner!  Plus, you can actually gauge the speed of your serve!  The better your timing, the faster it moves across the net.  You'll have hours of fun rushing the net, playing the baseline or roaming the court.  With Nintendo's state-of-the-art graphics and realistic game play, you'll really believe you're at center court!", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => nil, 'developers' => [6037], 'genres' => [11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 385, 'game_title' => 'The Battle of Olympus', 'release_date' => '1990-03-28', 'platform' => 7, 'overview' => "This is an ancient story - a time when men and gods lived together. The peaceful village of Elis was the home of the fairest maiden and a gentle yet brave young man named Orpheus. Helene and Orpheus swore eternal love to each other. But alas, one day, Helene fell victim to the fangs of a venomous serpent and was turned to stone. Your adventure will take you through ancient Greece on a classic mythological quest. It may be easy to defeat the snakes and centaurs that inhabit most of the cities but how will you defeat Hydra? Or the terrible three-headed dog, Cerberus? You'll need to use all of your adventuring skills to find the magic items that will allow you to rescue your beloved Helene.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [4185], 'genres' => [1, 2], 'publishers' => [105], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 386, 'game_title' => 'The Punisher', 'release_date' => '1994-01-01', 'platform' => 18, 'overview' => "Join Frank Castle's crusade for justice and revenge in this port of the arcade beat 'em up. Based on the Marvel comic of the same name, you play as the cold blooded vigilante or his pal Nick Fury (from S.H.I.E.L.D.) with your mission being to tear through the many rackets and underground criminal hotspots to cripple the Kingpin's criminal empire, and finally take down the man himself and bring peace to New York.\r\n\r\nThe game plays as a standard side-scrolling beat 'em up with your objective being to clear all stages of enemies by attacking them with your arsenal of attacks or whatever weapons you can find. Features single and 2-player cooperative gameplay.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 387, 'game_title' => 'Tiger-Heli', 'release_date' => '1987-10-01', 'platform' => 7, 'overview' => "Tiger Heli is the name of your helicopter, according to the box the result of a billion-dollar defense project and forged from ebony metal and glistening chrome. Your goal is to defeat the country of Cantun, which is run by terrorists and has become completely power hungry with an aim to take over the whole world.\r\n\r\nYou're shooting tanks, ships, aircraft carriers and trains while flying towards the impenetrable military base. You shoot crates to get pickups. If you shoot the crate when it is green you get a bomb pickup, if you shoot it when it is red you get a mini helicopter that attaches to one of your sides shooting sideways, and if you shoot it when it is white you get a mini helicopter shooting forward. If you shoot 10 crates with a yellow diamond shape you get an extra life.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6749], 'genres' => [8], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 388, 'game_title' => 'Time Lord', 'release_date' => '1990-09-01', 'platform' => 7, 'overview' => 'It is the year 2999, and warriors from the planet Drakkon are launching a savage attack on Earth. Their weapon: a powerful time travel device. Their objective: to control us by changing the course of our history. To win this war, we must meet the Drakkons on a unique and dangerous battleground: our own past! You are a fearless fortune-hunter, hired by desperate scientists for an experimental journey into the 4th dimension. Your code name is Time Lord. Your mission: blast into the past to save the present from certain doom! Battle the aliens in four historical time zones. Search for weapons sent back by the scientists - and decide when to use them. Solve puzzles to collect the mysterious Orbs that hold the secret of time travel. Be cautious yet quick, Time Lord. You have one short year to free history or be history! And the evil Drakkons have all the time in the world...', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [6991], 'genres' => [1], 'publishers' => [97], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 389, 'game_title' => 'Top Gun', 'release_date' => '1987-11-01', 'platform' => 7, 'overview' => "The sun shimmers on the horizon as your armed-to-the-teeth Navy fighter screams from the carrier deck, accelerating into the danger zone. High above hostile waters your mission is to defend the task force from enemy attack. Suddenly, bogeys flash onto your radar. They're everywhere, diving toward you at Mach 2. Only a second to react, you go to guns and arm missiles. Your heart pounds and palms sweat as you blast into the dogfight with cannons blazing. Tracers zip past your engines. Shells shatter your senses. Now it's just you against them. And to survive you'll need more than speed and firepower. You'll need guts and instinct. You'll need to be a \"TOP GUN\" pilot!", 'youtube' => 'https://youtu.be/rNCxV1ByNgQ', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [4765], 'genres' => [13], 'publishers' => [23], 'alternates' => ['Top Gun (Konami)', 'TOPGUN'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 390, 'game_title' => 'Pokémon Snap', 'release_date' => '1999-06-30', 'platform' => 3, 'overview' => "Professor Oak needs your help!\r\n\r\nThe Professor has asked you to capture the Wild Pokémon of Pokémon Island… on film!  Tour the island in your ZERO-ONE vehicle and snap pictures of Pokémon in their natural habitat.  Wild Pokémon are often camera-shy, so you’ll have to use special items to bring them out in the open.  Only the best shots will do for the Professor’s Pokémon Report, so sharpen your photography skills and get ready to SNAP!\r\n\r\n* The first-ever N64 game to feature the world-famous Pokémon--fully rendered in 3-D!\r\n* Explore the many environments of Pokémon Island, like the sunny beach, the mysterious caves, and even a red-hot volcano!\r\n* Many different types of Pokémon inhabit the island.  See how many you can catch on film!", 'youtube' => '8B1yFwl0Efw', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3694, 6487], 'genres' => [8, 9], 'publishers' => [3], 'alternates' => ['Pokemon Snap Station - Kiosk'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 391, 'game_title' => 'Pokémon Stadium', 'release_date' => '2000-02-29', 'platform' => 3, 'overview' => "The ultimate Pokémon battle is about to begin... At long last, all of your favorite Pokémon are ready to go head-to-head on the N64! Whether you're battling a friend, a Gym Leader or a tournament contestant, you're about to witness some of the most spectacular battle scenes in Pokémon history! Select a team from a huge stable of \"rental\" battlers, or use the included N64 Transfer Pak to upload your own team of Pokémon Red, Blue or Yellow! This Stadium is packed and ready to rock!\r\n\r\n• Awesome 3-D animation on the N64 makes all 151 Pokémon larger than life!\r\n• Use the N64 Transfer Pak to battle using your Pokémon from Red, Blue or Yellow.\r\n• Battle your way to the top of the championships, or have a free-for-all with up to four players!\r\n• Nine Mini-Games add to the multi-player fun!\r\n• Use the power of the Transfer Pak and the N64 to play the Pokémon Game Boy game on your television!", 'youtube' => 'RVfC6ZtDCOA', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6043], 'genres' => [6], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 392, 'game_title' => 'Pokémon Stadium 2', 'release_date' => '2001-03-28', 'platform' => 3, 'overview' => "Hundreds of Pokémon in Three-mendous 3-D! What's sweeter than victory in a Pokémon battle? Victory in a 3-D arena on the N64! Set your strategy, then stand back while your Pokémon battle it out. You can even see the Pokémon you've trained—fully rendered in 3-D and ready for battle!\r\n\r\n• Nearly 250 Pokémon! Transfer Pokémon from the Red, Blue, Yellow - even Silver and Gold--versions of Pokémon for Game Boy. Or play with Rental Pokémon included int he game.\r\n• See them all in glorious 3-D! Ho-oh, Lugia, Entei and Pichu against all-time favorites, like Mewtwo, Charizard, Blastoise and Pikachu.\r\n• Become the Stadium Champion! Take on 21 Pokémon Trainers in the Gym Leader Castle to try to win it all!\r\n• 12 all-new mini-games! Try to bump other Hitmontop out of the arena in Topsy-Turvy--or charge up more energy than anyone else in Pichu's Power Plant.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3694, 6043], 'genres' => [6], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 393, 'game_title' => 'Quake II', 'release_date' => '1999-05-31', 'platform' => 1, 'overview' => "Quake II takes place in a science fiction environment. In the single-player game, the player assumes the role of a Marine named Bitterman taking part in \"Operation Alien Overlord\", a desperate attempt to protect Earth from alien invasion by launching a counter-attack on the home planet of the hostile cybernetic Strogg civilization. Most of the other soldiers are captured or killed almost as soon as they enter the planet's atmosphere, so it falls upon Bitterman to penetrate the Strogg capital city alone and ultimately to assassinate the Strogg leader, Makron.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [8], 'publishers' => [33], 'alternates' => ['Quake 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 394, 'game_title' => 'Rampage: World Tour', 'release_date' => '1998-03-30', 'platform' => 3, 'overview' => "A wild smash-'em-up romp with universal appeal! Simple enough for any player. Plenty of depth and challenge to appeal to serious gamers as well. Bring a friend or two on a non-stop RAMPAGE while you inflict some major damage and destruction. Demolish buildings, swat down aircraft, eat people and rack up points, while destroying entire cities! More than 130 standard levels, 14 bonus levels, 4 grudge match levels and many hidden levels! Special bosses and some tasty humans give Lizzy, George or Ralph a major health boost.", 'youtube' => nil, 'players' => 3, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7381], 'genres' => [1], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 395, 'game_title' => 'Rayman 2: The Great Escape', 'release_date' => '1999-10-29', 'platform' => 3, 'overview' => "Rayman 2 takes place in a world called The Glade of Dreams. An army of Robot Pirates, led by Admiral Razorbeard, invades this world and destroys the Heart of the World, the world core. This greatly weakens the resistance's power and disables Rayman's powers, leading to his capture.\r\n\r\nGlobox, a friend of Rayman, is later also captured and put in the same cell as Rayman aboard the Pirates' prison ship. Globox restores one of his powers through a silver lum given to him by Ly, a fairy. Rayman escapes the prison ship, and is separated from Globox again. He learns that in order to stand a chance against the Pirates, he needs to find 4 ancient, magic masks to awaken Polokus, the spirit of the world.[10] He travels through the Glade of Dreams via the Hall of Doors, a magical place linked to various locations in the world, controlled by the ancient Teensies.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9150], 'genres' => [15], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 396, 'game_title' => 'Ready 2 Rumble Boxing', 'release_date' => '1999-10-31', 'platform' => 3, 'overview' => "Ready 2 Rumble Boxing is a boxing game for the Dreamcast, PlayStation, Game Boy Color, and Nintendo 64 and it was released in 1999 by Midway. The success of the Dreamcast version led to it becoming one of the few Sega All Stars titles.\r\n\r\nLike Nintendo's Punch-Out!! series it features many characters with colorful personalities (i.e. Afro Thunder, Boris \"The Bear\" Knokimov, etc.); however, unlike the Punch-Out!! series, Ready 2 Rumble Boxing is in 3D, thus allowing for more control over your character in the ring, and also enables the players to choose whichever fighters they want.\r\n\r\nThroughout the fights in the game, there is a special RUMBLE meter which fills up, one letter at a time, until the word \"RUMBLE\" is spelled at the bottom of the screen. Letters can be obtained by successfully landing hard blows or taunting the opponent. Once the meter is full, the player can power himself up, enabling access to a special move called \"Rumble Flurry\", which might as well instantly knock the opposite player out cold.\r\n\r\nOne unique graphic feature of the game is the gradual bruises gained by players as the fight progresses (like hematomas and swellings), present in all fifth-generation versions. While this is not necessarily a new feature to games (it had been implemented before in SNK's 1992 game Art of Fighting), it garnered much appraisal from reviewers, because of the added fun factor this element supply to the game", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5507], 'genres' => [10, 11], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 397, 'game_title' => 'Resident Evil 2', 'release_date' => '1998-01-21', 'platform' => 3, 'overview' => "Ready or not, the terror of Resident Evil 2 is here. In chapter one, the case of the disastrous T-virus outbreak--a mutagenic toxin designed for biological weapons--was eventually closed but the experiments were far from over. Control the destiny of Leon Kennedy or Claire Redfield as their nightmare begins when a biotech terror runs rampant in Raccoon City. Relentless zombies and hideous monsters are all out for a taste of your blood. If the suspense doesn't kill you, something else will.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1, 2], 'publishers' => [9], 'alternates' => ['Biohazard 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 398, 'game_title' => 'San Francisco Rush 2049', 'release_date' => '2000-09-06', 'platform' => 3, 'overview' => "San Francisco Rush 2049 is the third game in the Rush series, sequel to San Francisco Rush and Rush 2: Extreme Racing USA.\r\nThe game features a futuristic representation of San Francisco and an arcade-style physics engine. It also features a multiplayer mode for up to four players and Rumble Pak support on the Nintendo 64 port. A major difference in game play compared to predecessors in the series is the ability to extend wings from the cars in midair and glide. As with previous titles in the franchise, Rush 2049 features a stunt mode in which the player scores points for complex mid-air maneuvers and successful landings. There is also a multiplayer deathmatch battle mode. There are six race tracks, four stunt arenas, eight battle arenas, and one unlockable obstacle course named The Gauntlet. The single player race mode places emphasis on outlandish and death-defying shortcuts in each track. The game has a soundtrack mostly comprising techno music.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5507], 'genres' => [7], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 399, 'game_title' => 'South Park Rally', 'release_date' => '2000-03-01', 'platform' => 3, 'overview' => "Choose your character from the cast of the popular 'mature' cartoon South Park, and tear through the streets in this racing game. Your character's vehicle may be a little cart, trike, or box, for example. Weapons include rockets, Salty Balls, Cheesy Poofs, the beloved Cow and even an Anal probe. All of the voices are also included, making it feel more like the real cartoon than a rally game. You can also play an all-on-all 4 player mode.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [8497], 'genres' => [7], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 400, 'game_title' => "South Park: Chef's Luv Shack", 'release_date' => '1999-11-20', 'platform' => 3, 'overview' => "South Park: Chef's Luv Shack is a 2D game-show style video game based on the television show South Park. It gained its popularity by having mini games and the ability to play against friends in a challenge for the most points. It also involves trivia questions about South Park and other topics.\r\nThe game intermittently switches between questions and minigames, with a minigame proceeding every three questions. Players score points by answering questions first (correctly) and based on minigame ranking. Players lose points for questions answered incorrectly. The game is exclusively multiplayer, as when played by one player, there is no AI, so that player always wins, even with a negative score", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [194], 'genres' => [5], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 401, 'game_title' => 'Star Wars: Episode I - Battle for Naboo', 'release_date' => '2000-12-18', 'platform' => 3, 'overview' => "Attention defenders of Naboo! The Trade Federation must be stopped! Storm through more than 15 missions over land, sea and space as your freedom fighters rally against the droid armies. Take control of 7 vehicles: the Naboo starfighter, Gian speeder, and new craft like the heavy STAP, Trade Federation gunboat and more. More than 15 missions: escape from Theed, search & destroy, sabotage, reconnaissance, convoy. Battle against Trade Federation droid starfighters, AATs, destroyer droids, battle droids.\r\nChange vehicles mid-mission through specially designated hangars.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2976], 'genres' => [1], 'publishers' => [3, 25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 402, 'game_title' => 'Star Wars Episode I: Racer', 'release_date' => '1999-05-18', 'platform' => 3, 'overview' => 'Join Jedi-to-be Anakin Skywalker in the Star Wars race of your life! Relive all the thrills and excitement of the Podracer sequence from Star Wars: Episode I. Hang on tight - with afterburners on, Podracers max out at a simulated 600 mph! Race in furious competition against more than 21 opponents! Take on over 21 tracks in 8 unique worlds. Avoid hazards such as methane lakes, meteor showers and Tusken Raiders! Featuring spectacular 3D environments!', 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5068], 'genres' => [7], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 403, 'game_title' => 'Star Wars: Rogue Squadron', 'release_date' => '1998-12-03', 'platform' => 3, 'overview' => "Fly against the evil Empire! As Luke Skywalker, co-founder of the Rebel Alliance's elite Rogue Squadron, you must combat the evil Galactic Empire! Engage in intense, fast-paced planetary air-to-ground and air-to-air missions - dogfights, search and destroy, reconnaissance, bombing runs, rescue assignments and more! Pilot X-wings, Y-wings, A-wings, V-wings and Snowspeeders with powerful weapons in over 15 missions battling TIE fighters, TIE bombers, Imperial shuttles, AT-AT walkers, AT-STs and other challenging foes.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2976], 'genres' => [1, 8], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 404, 'game_title' => 'Super Smash Bros.', 'release_date' => '1999-04-26', 'platform' => 3, 'overview' => "It's a Bumpin', Bruisin', Brawlin' Bash! The many worlds of Nintendo collide in the ultimate showdown of strength and skill! Up to four players can choose their favorite characters - complete with signature attacks - and go at it in Team Battles and Free-For-Alls. Or venture out on your own to conquer the 14 stages in single-player mode. Either way, Super Smash Bros. is a no-holds-barred action-fest that will keep you coming back for more!", 'youtube' => 'K783SDTBKmg', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3694], 'genres' => [10], 'publishers' => [3], 'alternates' => ['Super Smash Bros. 64', 'Nintendo All Star! Dairantō Smash Brothers'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 405, 'game_title' => 'Tetrisphere', 'release_date' => '1997-08-11', 'platform' => 3, 'overview' => "Tetrisphere is a variant on Tetris in which various shapes are shifted across a wrapped three-dimensional grid resembling a sphere, and then destroyed. The objective of the game changes depending on the mode, but generally consists of removing layers of shapes to reach the playing field's core. Despite very little domestic advertising, Tetrisphere enjoyed moderately good sales and a mostly favorable critical reception. Reviewers praised the game's originality and the musical score composed by Neil D. Voss.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3682], 'genres' => [5], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 406, 'game_title' => "Tony Hawk's Pro Skater", 'release_date' => '2000-03-29', 'platform' => 3, 'overview' => 'Go Big, Go Pro! Skate as legendary Tony Hawk, or as one of nine top pros. Work your way up the ranks by landing suicidal tricks in brutal competitions to become the highest ranked skate champ! Great features such as: Signature Pro Moves, fully skateable worlds, head-to-head competition, and Instant Replay Mode.', 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2658], 'genres' => [11], 'publishers' => [33], 'alternates' => ["Tony Hawk's Skateboarding"], 'uids' => nil, 'hashes' => nil },
    { 'id' => 407, 'game_title' => 'Turok 2: Seeds of Evil', 'release_date' => '1998-10-21', 'platform' => 3, 'overview' => "Turok 2: Seeds of Evil is a first-person shooter video game originally released for the Nintendo 64 in late 1998. A port was released for Windows OS shortly afterwards, in 1999. It is the sequel to the successful Turok: Dinosaur Hunter and was followed by the 2000 entry in the series, Turok 3: Shadow of Oblivion. It is one of the first Nintendo 64 games to allow use with the RAM Expansion Pak and it was known as Violence Killer: Turok New Generation in Japan. A separate game, also titled Turok 2: Seeds of Evil, was released for the Game Boy Color in December 1998. Although set in the same fictional universe, it follows a different storyline.\r\n \r\nThe game was well received, garnering an 89% from the review collator Game Rankings for the Nintendo 64 version and labeled as a \"must-buy\" from GameSpot.", 'youtube' => 'xYUmLGDelRE', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4065], 'genres' => [1, 8], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 408, 'game_title' => 'Turok: Rage Wars', 'release_date' => '1999-10-31', 'platform' => 3, 'overview' => 'The Lost Land is an unholy world, born from the death of the universe; a strange world where "time has no meaning". If the Lost Land falls, all the universe falls. Since the dawn of time, the Turok have maintained the balance between good and evil, order and chaos. The Turok control The Light Burden, a sacred vessel that holds the last remnants of the pure energy source that created The Lost Land. Whoever controls The Light Burden controls the power of creation. Fierce Battles waged in an effort to wrestle control of The Light Burden from the line of Turok, and thus conquer the Lost Land. A number of fierce warriors have been selected to participate to fight and win the Rage Wars...', 'youtube' => 'CTfJGdOKtMk', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [194], 'genres' => [8], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 409, 'game_title' => 'Vigilante 8: 2nd Offense', 'release_date' => '1999-10-31', 'platform' => 3, 'overview' => "The story of Vigilante 8: 2nd Offense centers on the international meddlings of an oil conglomerate from the future known as OMAR (Oil Monopoly Alliance Regime).\r\nAfter finding an electronic armband in a service station bathroom, former Vigilante Slick Clyde rose to be controlled by OMAR. Working up through the ranks of command he soon came to be the CEO of OMAR itself and made a complete monopoly on all oil trades with the sole exception of the United States.\r\nWith the help of his student and hitman, Obake, he steals the technology to allow him to travel through time. Taking with him Obake and his cybernetic assassin, Dallas 13, he makes the jump back to 1970s to cripple the United States and bring OMAR to total domination.\r\nAppearing in 1970s, the three vehicles encounter Convoy, the former leader of the Vigilantes. Upon seeing him, the three cars open fire.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5102], 'genres' => [1, 8, 19], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 410, 'game_title' => 'Waialae Country Club', 'release_date' => '1998-07-29', 'platform' => 3, 'overview' => "One of the most beautiful golf courses in the world is now one of the most beautiful N64 games. The true physics of golf take the starring role in this ultra-realistic venture into the popular sport. You can customize the characteristics of up to 10 different golfers, including power, putting, recovery, and ability against the wind. Plan your approach, pick a club, get your stance just right, read the wind, decide whether you're going for spin, draw or fade, read the meter to get your power where you want it then swing! The six modes of play at your disposal are Waialae Open, Tournament, Stroke, Skins, Match, and Practice. A truly comprehensive game, WAIALAE COUNTRY CLUB will even calculate your handicap for you for use in later play. Up to four players can have a go in each game, with all stats and results saved to the game's memory. The graphics and player animations are outstanding, the play is seamless and intuitive, and the location just can't be beat. Spend your next vacation in Waialae, golf fans. Just don't expect it to be easy.", 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8429], 'genres' => [11], 'publishers' => [3], 'alternates' => ['Waialae Country Club: True Golf Classics'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 411, 'game_title' => 'Wave Race 64', 'release_date' => '1996-09-27', 'platform' => 3, 'overview' => "Wave Race 64 is sure to provide some of the most exciting racing you've ever experienced. Feel the pounding and crashing of the waves as you accelerate into straight-aways, whip around the marker buoys and go airborne on the jump ramps. Don't race alone - challenge a friend! Take control in three different modes of play - Championship, Time Trials and Stunt Mode. Nine challenging courses set in exotic locales - race conditions change and the wave action responds to the way both you and your opponents race!", 'youtube' => '4XPjy2ljErU', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [7], 'publishers' => [3], 'alternates' => ['Wave Race 64: Shindou Edition'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 412, 'game_title' => 'WCW Backstage Assault', 'release_date' => '2000-12-12', 'platform' => 3, 'overview' => 'No-Holds-Barred Brawling! Over 50 WCW superstars, including the women of the WCW! 14 playable Backstage Areas, including the new Semi-Trailer Area. Destroy your enemy faster with power-ups! New - First Blood Mode and Torch matches! Use your environment as a weapon!', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 413, 'game_title' => 'WinBack: Covert Operations', 'release_date' => '1999-10-20', 'platform' => 3, 'overview' => "A terrorist group calling itself the Crying Lions is about to take over the world with its mighty satellite and Jean-Luc Cougar is the only one who can stop it. As Jean-Luc, a covert operative working for the Strategic Covert Actions Team, you are responsible for taking back a Lions-controlled base and regaining power of the satellite. Some of the weapons you'll have to acquire and use to defeat the terrorists are handguns, shotguns, and machine guns, though you'll also need to access such materials as explosives, detectors, flashlights and medical kits in order to succeed. A refreshing take on the traditional action game, WINBACK requires as much stealth and strategy as it does reflexes and use of weaponry. The game features six different multiplayer modes, supporting up to four players: Death Match, Lethal Tag, Quick Draw, Cube Hunt, Team Battle, and Point Match. You select your difficulty level and you can even start off in a Tutorial mode to get the controls down.", 'youtube' => nil, 'players' => 1, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [6242], 'genres' => [8], 'publishers' => [50], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 414, 'game_title' => 'World Driver Championship', 'release_date' => '1999-06-16', 'platform' => 3, 'overview' => 'One of the last racing simulations to be released for Nintendo 64, this graphically intensive title used custom microcode optimization and high polygon count modelling. The development team was able to optimize the usage of the various processors within the N64 to allow far draw distance (reducing the need for fog or pop-up), high detail texturing and models, Doppler effect audio, and advanced lighting and fog effects for realistic weather conditions. Impressively the game has a high resolution 640x480 mode that does not require the add-on N64 RAM Expansion Pak. Additionally, unlike many other games of its type on the platform, the game runs high resolution at a sufficiently playable pace, undoubtedly due to the use of a reduced screen area letterbox mode that lessens the number of pixels needing to be displayed.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1292], 'genres' => [7], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 415, 'game_title' => 'WWF Attitude', 'release_date' => '1999-07-31', 'platform' => 3, 'overview' => "Now featuring over 40 of your favorite WWF superstars! Customize your own wrestler's move sets and costumes. Over 20 game modes including all-new specialty matches. Real-life WWF entrances and theme songs. Wrestle your way to the title in an all-new career mode. First ever Create-Your-Own Pay-Per-View Mode! Two-man commentary featuring Shane McMahon and Jerry \"The King\" Lawler.", 'youtube' => 'dh3AhZUuRDM', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4065], 'genres' => [10, 11], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 416, 'game_title' => 'WWF No Mercy', 'release_date' => '2000-11-17', 'platform' => 3, 'overview' => 'Jump into the ring with the biggest, baddest jambronis around and experience brutal WWF action never before seen in a console game! Over 65 WWF superstars, all-new Ladder matches, and all-new Double-Team moves, like the Dudley 3D Deathdrop! Take on the entire Federation in Survival Mode. Take the action out of the ring in 10 different backstage areas!', 'youtube' => 'LhdU0KoXGTk', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [314], 'genres' => [11], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 417, 'game_title' => 'WWF WrestleMania 2000', 'release_date' => '1999-10-31', 'platform' => 3, 'overview' => 'The greatest wrestling game ever created! Tons of game modes, including Cage Match, Road to Wrestlemania, Create a PPV, and more! Create and bet WWF Championship belts with your friends. Over 50 of the top WWF superstars, more than any other WWF game! Thousands of signature moves, taunts, and mannerisms. New Create a Wrestler, with custom moves, costumes, and fighting styles!', 'youtube' => 'hcSx-ABjaMU', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [314], 'genres' => [11], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 418, 'game_title' => 'Xena: Warrior Princess - The Talisman of Fate', 'release_date' => '1998-12-14', 'platform' => 3, 'overview' => "Xena shall choose the defenders of the world. We have seen them in the memories of her exploits. So come together, Earth's greatest heroes and villains. Choose your weapons wisely and let the battles begin! Just remember, each victory only brings you closer to challenging the embodiment of darkness... Despair himself! Each of Xena's 10 characters possess their own unique weapons, attitudes and fighting techniques. Exclusive multi-player feature includes a roster mode, plus team and single battles.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7381], 'genres' => [10], 'publishers' => [64], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 419, 'game_title' => "Yoshi's Story", 'release_date' => '1998-03-01', 'platform' => 3, 'overview' => "Baby Bowser has taken the Super Happy Tree and cast a spell on Yoshi's world, turning it into the pages of a picture book.  The only Yoshis not affected by the spell were six hatchlings that were still protected by their shells.  It's up to them to reclaim the Super Happy Tree and restore happiness to the world.  That is the only thing that can break Baby Bowser's Spell!", 'youtube' => 'byuavpfovHY', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [1, 2], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 420, 'game_title' => 'Dino Crisis', 'release_date' => '2000-11-14', 'platform' => 16, 'overview' => "Dino Crisis is a survival horror video game by Capcom, released in 2000 for Microsoft Windows. It was directed and produced by Resident Evil creator Shinji Mikami, and developed by a team of staff members that would later become part of Capcom Production Studio.\r\n\r\nIn the game, a special forces team must find a way to survive in a secret government facility that has been infested with dinosaurs. It features survival horror gameplay similar to the Resident Evil series and was promoted by Capcom as \"panic horror\".", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [8, 18], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 421, 'game_title' => 'Dynamite Cop', 'release_date' => '1999-11-03', 'platform' => 16, 'overview' => "Pirates have kidnapped the President's daughter and are holding her on a hijacked cruise ship. Now it's up to an elite police force to get them back, using whatever means necessary. The action takes place on both the cruise ship and the pirate's island hideaway.\r\n\r\nYou play as one of three cops, in this beat-em up fighting game from Sega. Dynamite Cop features similar gameplay to Die Hard Arcade. As your character enters an area, you have to beat up everyone there. Once they are gone, you continue to the next area. To help you there are many weapons, such as guns, knives, pepper spray, chairs, and bread. Bread? Yes, you can use pretty much anything as a weapon.", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [7549], 'genres' => [1], 'publishers' => [15], 'alternates' => ['Dynamite Cop!'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 423, 'game_title' => 'Jet Grind Radio', 'release_date' => '2000-11-01', 'platform' => 16, 'overview' => "Tokyo-to, a city not unlike Tokyo, somewhere in Asia, in the near future. This is the story about the GG's, one of three rival teenage gangs who ride motorised inline skates and are tagging the streets with graffiti. There is a turf war going on between the gangs GG's, the Poison Jam, and the high-tech freaks, the Noise Tanks. The evil Rokkaku Corporation has the corrupt police in their grasp, and, headed by Captain Onishima, the cops are hell-bent on subduing the unruly teen protagonists. But there is light in the darkness: the underground DJ, \"Professor K,\" and his Jet Set Radio station keep tabs on what is happening on the streets of Tokyo-to, and soon our teens will have something much darker than the police to worry about.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7871], 'genres' => [1], 'publishers' => [15], 'alternates' => ['Jet Set Radio', 'JetSet Radio'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 424, 'game_title' => 'KISS: Psycho Circus - The Nightmare Child', 'release_date' => '2000-10-29', 'platform' => 16, 'overview' => "Wicked Jester, a band of four, are headed for a Friday night gig at The Coventry, a rundown dive outside of town. They arrive only to find the parking lot deserted, the club seemingly dead. The band's members: Pablo Ramirez, Andy Chang, Gabriel Gordo and Patrick Scott, stepping from their van, are startled by a voice from the shadows. She offers them four tickets to a circus -- tonight's the grand finale! Having nothing better to do, the four accept and the nightmare begins.\r\n\r\nBased on characters from comic book author Todd McFarlane, KISS Psycho Circus: The Nightmare Child brings the horror and carnage of the Psycho Circus to the PC in a shooter format. There are two-dozen creatures to battle with and three classes of weapons to use, each with four specific types: melee (beast claws, thornblade, twister and punisher), common (zero cannon, magma cannon, windblade and scourge) and ultimate (stargaze, galaxion, spirit lance and draco). In addition to the weaponry, temporary power-ups and instant items such as health, attack and defense powers are available.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9018], 'genres' => [1, 8, 18], 'publishers' => [123], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 425, 'game_title' => 'NBA 2K1', 'release_date' => '2000-11-01', 'platform' => 16, 'overview' => 'NBA 2K1 (also known as Sega Sports: NBA 2K1 or NBA2K1) is a basketball video game. It is the second installment in the NBA 2K series of video games. It was developed by Visual Concepts and published by Sega (as Sega Sports). It was the first NBA 2K game to feature online multiplayer and the first game to feature street courses instead of playing a game inside the arena in the first game, famous street courts such as The Cage, Rucker Park, Franklin Park, and Goat Park. It was released on November 1, 2000 in North America with the Dreamcast. Rapper Redman (rapper) appears in the video game', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => nil, 'genres' => [11], 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 426, 'game_title' => 'Phantasy Star Online', 'release_date' => '2001-01-29', 'platform' => 16, 'overview' => "Pioneer 2 finally completed it's long voyage to the new home world. But as the ship entered orbit, an enormous explosion shook the entire planet, and all contact with the thousands of people already there was lost. Now, in the first worldwide online console RPG, players from around the globe must unite to discover what has happened. Phantasy Star Online continues in the tradition of one of the most popular series of all time, and becomes a revolutionary and truly global gaming experience in an online, persistent world.", 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [7979], 'genres' => [1, 2, 4, 14], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 427, 'game_title' => 'Quake III Arena', 'release_date' => '1999-12-02', 'platform' => 1, 'overview' => "Unlike its predecessors, Q3A does not have a plot-based single-player campaign. Instead, it simulates the multiplayer experience with computer controlled players known as bots. The game's story is brief - 'the greatest warriors of all time fight for the amusement of a race called the Vadrigar in the Arena Eternal.'\r\n\r\nThe introduction video shows the abduction of such a warrior, Sarge, while making a last stand. Continuity with prior games in the Quake series and even Doom is maintained by the inclusion of player models related to those earlier games as well as biographical information included on characters in the manual, a familiar mixture of gothic and technological map architecture and specific equipment; for example, the Quad Damage power-up, the infamous rocket launcher and the BFG super-weapon.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [8], 'publishers' => [33], 'alternates' => ['Quake 3 Arena'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 428, 'game_title' => 'Resident Evil Code: Veronica', 'release_date' => '2000-02-29', 'platform' => 16, 'overview' => "The game begins with Claire Redfield raiding an Umbrella Corporation facility in Paris in search of her brother, Chris Redfield. During the infiltration she is captured and imprisoned on Rockfort Island. Soon after arriving, a man named Rodrigo Juan Raval releases her from her cell, since she is not much of a threat considering the outbreak of the T-virus on Rockfort. Trying to escape from the contaminated island, Claire teams up with inmate Steve Burnside, at the same time being confronted with the island's commander Alfred Ashford. Meanwhile, Albert Wesker is on a mission of his own to retrieve a sample of the T-Veronica virus developed by Alfred's twin sister Alexia. His unit is also responsible for the outbreak of the T-virus on Rockfort Island.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [1, 2, 5], 'publishers' => [9], 'alternates' => ['BIOHAZARD CODE: Veronica'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 429, 'game_title' => 'Samba de Amigo', 'release_date' => '2000-10-16', 'platform' => 16, 'overview' => "Samba De Amigo is a highly unique game: a maracas simulation. Game play is based around a special maracas controller that you use to interact with the music. The controller senses which region in space out of a possible 6 that the maracas are in. It also senses when the player shakes the maracas. As the music plays, the player must shake the maracas in the appropriate region with proper timing to progress. A standard controller can also be used if you do not have the maracas controller, which is sold separately.\r\n\r\nThe music in the game comes from a wide variety of sources. Some of the songs are traditional samba music, while others are recognizable pop tunes, like \"Macarena\" and \"Tequila.\"", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7979], 'genres' => [17], 'publishers' => [15], 'alternates' => ['Samba de Amigo 2000'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 430, 'game_title' => 'Shenmue', 'release_date' => '2000-11-06', 'platform' => 16, 'overview' => "The first chapter of Yu Suzuki's epic saga is at hand. Shenmue is an adventure game that transports you to Japan, circa 1986. You are Ryo, a young man trying to solve the mystery of his father's death. Along the way, you'll be treated to the most richly-detailed game world ever conceived. Shenmue offers a true living world, where characters exist on their own timelines and almost all objects can be manipulated and used. Over the course of the adventure, you will learn new hand-to-hand fighting techniques, presented in breathtaking motion-captured animations. You'll also interact with literally hundreds of characters and solve a myriad of puzzles. It's epic storytelling at its best, and it's only on Dreamcast.\r\n\r\nA massive, highly-detailed 3D world featuring hundreds of interactive characters and objects to interact with. Real-time fighting and action scenes with motion capture by real budo experts. In-game arcade features Sega classics such as Hang-On and Space Harrier. \"Magic Weather\" technology brings the world to life with changes to landscapes, climate, and vegetation. Created by Yu Suzuki, the mastermind of arcade hits such as Virtua Fighter.", 'youtube' => 'cf-MK4599A8', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [411], 'genres' => [2, 4], 'publishers' => [15], 'alternates' => ['Shenmue シェンムー', 'シェンムー'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 431, 'game_title' => 'Skies of Arcadia', 'release_date' => '2000-11-13', 'platform' => 16, 'overview' => "The story opens with a young Silvite woman named Fina sailing through the night skies in her tiny Silver airship. Not far behind her, Valuan Admiral Alfonso is in hot pursuit under orders from Lord Galcian to capture her. Alfonso opens fire on and disables Fina's ship long enough to capture her before it plummets into Deep Sky, but just as she is being brought onboard his warship, a Blue Rogue vessel arrives with the intent of robbing the Valuan vessel. Vyse and Aika of the Blue Rogues jump from the Albatross onto Alfonso's flagship and fight their way to the rear cargo hold, prompting Alfonso to flee on a lifeboat while leaving Fina behind along with the war beast Antonio, who is quickly defeated by the Rogues. Vyse and Aika bring Fina back to their clan's ship, which Vyse pilots back to their secret hideout, Pirate Island (disguised as a small village).", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [6334], 'genres' => [1, 2, 4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 432, 'game_title' => 'Sonic Adventure 2', 'release_date' => '2001-06-19', 'platform' => 16, 'overview' => 'After discovering the existence of a secret weapon mentioned in the diary of his grandfather, Gerald Robotnik, Dr. Eggman infiltrates a high-security G.U.N. facility in search of it. This "weapon", a black hedgehog named Shadow who claims that he is the "Ultimate Life Form", offers to help Eggman take over the world, telling him to rendezvous with him at the abandoned Space Colony ARK with more Chaos Emeralds. Shadow proceeds in stealing one of the emeralds, and G.U.N. officials mistake him for Sonic. Sonic is apprehended shortly after he confronts Shadow, who demonstrates to Sonic the Chaos Control technique.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7979], 'genres' => [15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 433, 'game_title' => 'Space Channel 5', 'release_date' => '2000-06-04', 'platform' => 16, 'overview' => "Space Channel 5 (スペースチャンネル5) is a video game for the Sega Dreamcast released in Japan on the 16th of December, 1999, North America on the 6th of June, 2000 and in Europe on the 8th of October, 2000. It was the first game to be developed by the newly opened United Game Artists studio within Sega, spearheadded by Tetsuya Mizuguchi, although the UGA name had not yet been adopted by the original Japanese release.\r\n\r\nThe game stars Space Channel 5 reporter Ulala, tasked with upping the ratings of the channel, and stopping the \"evil\" Morolians, who are forcing the galaxy to dance.\r\n\r\nSpace Channel 5 is a rhythm game built similarly in nature to electronic memorisation games such Simon, and video games such as PaRappa the Rapper. Throughout the game the computer shows a sequence of moves—dance steps in this case—and the player must copy them successfully to advance. Repeated failure will force the show to be cancelled, effectively triggering a game over.", 'youtube' => 'VsMftkM18Yw', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9229], 'genres' => [1, 17], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 434, 'game_title' => 'Street Fighter Alpha 3', 'release_date' => '2000-05-31', 'platform' => 16, 'overview' => "Street Fighter Alpha 3, the third game in the Alpha series, has a total of 31 fighters, the most in the series so far. New characters include old favorites E. Honda, Blanka, Vega, Cammy, T. Hawk, Dee Jay, Juni and Juli. Some of the newest fighters on the block include a former Final Fight character (Cody, who has been in jail since the last Final Fight game, or so his clothing suggests), Karin Kanzuki and Rainbow Mika.\r\n\r\nThe major difference between this Alpha and the last two are the new play modes World Tour, Arcade, VS, Training and Entry.", 'youtube' => '', 'players' => 3, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [10], 'publishers' => [9], 'alternates' => ['Street Fighter Zero 3: Saikyo-ryu Dojo'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 435, 'game_title' => 'Super Magnetic Neo', 'release_date' => '2000-06-12', 'platform' => 16, 'overview' => "In Super Magnetic Neo, a gang lead by evil, foul-mouthed baby Pinki has taken over Pao Pao Park. The professor must stop her, so her sends Super Magnetic Neo, a little boy robot with a powerful electromagnet on his head.\r\n\r\nYou must use all these skills to make it through all four sections of Pao Pao Park and defeat Pinki.", 'youtube' => 'vFUa5zbqngw', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3451], 'genres' => [1], 'publishers' => [109], 'alternates' => ['Super Magnetic NiuNiu'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 436, 'game_title' => 'Virtua Fighter 3tb', 'release_date' => '1999-10-18', 'platform' => 16, 'overview' => "Look out -- Wham! Bam! And a full-body Slam! This Dreamcast version of Sega's revolutionary fighting game packs a one-two-three punch. As one of 12 fierce characters, you have a single deadly goal: to kick some 3D ass 'til you win the World Fighting Tournament. Incredible 3D environments, fluid gameplay, and lifelike graphics enhance the smooth fighting moves you're used to in the mega-hit arcade original. An exclusive feature of the Dreamcast version is Team Battle Mode, in which your custom three-person team goes head-to-head with an opponent's custom team. Virtua Fighter 3tb is so realistic that characters actually watch their opponents' every life-like move, like when they fall forward FROM behind or lose their balance when pushed. Focus your razor-sharp reflexes and take lethal aim as you deliver bone-crunching blows to your reeling opponents. When the dust settles, you'll still be standing.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [411], 'genres' => [10], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 437, 'game_title' => 'Fallen Earth: Welcome to the Apocalypse', 'release_date' => '2009-09-22', 'platform' => 1, 'overview' => "Fallen Earth is a free-to-play MMO developed by Reloaded Productions (formerly by North Carolina-based Icarus Studios and Fallen Earth).[2] The game takes place in a post-apocalyptic wasteland located around the American Grand Canyon. Fallen Earth's gameplay features FPS/RPG hybridization, first-person/third person views, hundreds of items, including improvised equipment and weapons, a variety of functional vehicles, a real-time, in-depth crafting system (which includes vehicles), various skills and abilities, factions and tactical PvP, all existing within 1000 square kilometers of usable terrain based on real-world topographical maps of the area. The game was released on September 22, 2009. Two years later, GamesFirst purchased the intellectual property and made the game free to play.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => nil, 'genres' => [4, 14], 'publishers' => nil, 'alternates' => ['Fallen Earth: Welcome to the Apocalypse', 'Fallen Earth: Blood Sports'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 438, 'game_title' => "Mario & Luigi: Bowser's Inside Story", 'release_date' => '2009-09-14', 'platform' => 8, 'overview' => "Mario & Luigi: Bowser's Inside Story is the third game in the Mario & Luigi series of games. Players control Mario and Luigi simultaneously in the side-scrolling platform environment of Bowser's body, while also controlling the Koopa King himself in the top-down world of the Mushroom Kingdom. Similar to games like Earthbound, enemy encounters are seen as actual enemies that players can avoid or attempt to strike early. The actual battles are a combination of turn-based menu attacks, and timed reactions to enemies during battle. By watching the way an enemy reacts, you can anticipate their attack and avoid it or counterattack.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [389], 'genres' => [4], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 439, 'game_title' => 'Mighty Morphin Power Rangers', 'release_date' => '1995-01-01', 'platform' => 21, 'overview' => "This take on the Power Rangers franchise is different from the many other Power Ranger games as it features FMV with real video of the actual TV show. The footage is spliced from nine different episodes and the gameplay is reminiscent of games such as Dragon's Lair and Space Ace where the player must press a button at a certain time to avoid being punched, kicked, avoid a trap, etc. Failure to miss pressing a button will continue to play the footage, but cause the player to loose a life. After a certain set of lives are lost, the game will be over.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7372], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 440, 'game_title' => 'Ecco: The Tides of Time', 'release_date' => '1994-08-25', 'platform' => 21, 'overview' => "The Tides of Time picked up right where the original Ecco the Dolphin left off. It turned out that the Vortex Queen was far from vanquished, and had, in fact, followed Ecco to Earth to build a new hive for herself. Ecco lost his powers from the Asterite early on, and soon after met a dolphin with unusually long fins. She was his descendant, Trellia, and had come to take him to her present in Ecco's distant future.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6155], 'genres' => [1, 2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 441, 'game_title' => 'Hook', 'release_date' => '1992-04-01', 'platform' => 21, 'overview' => "PETER PAN has now grown up, far away from NEVERLAND, but his old enemy CAPTAIN HOOK has not forgotten, and schemes his revenge. Kidnapping Peter's children, he lures our hero back to the island of PIRATES and \"LOST BOYS\" for a final confrontation. With the help of TINKERBELL, the faithful fairy, you take on the role of PETER PAN in this magic adventure fraught with danger and excitement!", 'youtube' => '3rwtmJKsRP4', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [10_213, 10_214, 10_215], 'genres' => [1, 2], 'publishers' => [77], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 442, 'game_title' => 'Dungeon Explorer', 'release_date' => '1994-01-01', 'platform' => 21, 'overview' => 'Dungeon Explorer is an action role-playing game. It supports up to four players with a choice of six different character classes: monk, knight, elf, mage, beast and ninja. The game starts in the area surrounding a save point. This area functions as a central hub to access all the six dungeons. If a character leaves it, the food counter starts decreasing. If it reaches zero, the life points start diminishing until the character dies. Food can be found as potions or pots around the mazes. Returning the character to the save point area replenishes all the counters and cures all conditions (like poisoning and confusion). The gold collected in the game can be spent on equipment upgrades at the weapons shop. The tavern allows the player to switch characters.', 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [1, 4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 443, 'game_title' => 'Flashback: The Quest for Identity', 'release_date' => '1992-12-02', 'platform' => 21, 'overview' => "You've lost your mind! You're trapped on a distant planet inhabited by aliens plotting to overtake the Earth. The only problem is - you don't even know who you are! To stop the alien attack, you must discover your true identity and fight your way back through the galaxy to warn Earth!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2231], 'genres' => [2], 'publishers' => [110], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 444, 'game_title' => 'Racing Aces', 'release_date' => '1993-01-01', 'platform' => 21, 'overview' => 'Racing Aces puts you behind the stick of World War 1, World War 2, and modern day fighting aircraft. Each competition is a dogfight as much as a race, and you will have to gun down your enemies to win. The tracks are littered with power up balloons to give you extra weapons and speed.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3711], 'genres' => [7], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 445, 'game_title' => 'Robo Aleste', 'release_date' => '1992-11-27', 'platform' => 21, 'overview' => "Pilot your massive mecha Aleste in the name of the Oda clan and seek revenge against the evil Chugoku Army for their atrocities!  Robo Aleste is another title in the Aleste series by famed shoot-'em-up developer Compile where players must collect power-ups to defeat countless waves of enemies and large bosses.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1785], 'genres' => [8], 'publishers' => [111], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 446, 'game_title' => 'After Burner II', 'release_date' => '1990-07-15', 'platform' => 18, 'overview' => "Similar to its predecessor, the premise of After Burner II is to get on the F-14 Tomcat and fly mission after mission of shooting planes out of the sky. At your disposal is a vulcan cannon (basically a machine gun) and a limited number of missiles. In some versions of the game the guns fire automatically all the time. Sometimes you come across a friendly supply plane and if you dock with it you can replenish your missiles.\r\n\r\nThe game is viewed from behind the plane with you fighting wave after wave of enemy fighters. But at heart it offers the usual shooter mechanics, meaning you spend most of your time dodging and shooting. You also can speed up and slow down to deal with enemies which appear behind you.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 447, 'game_title' => 'Aerobiz Supersonic', 'release_date' => '1993-04-02', 'platform' => 18, 'overview' => "LEAD YOUR AIRLINE INTO THE FUTURE!\r\nIt’s the beginning of the 21st century and competition in the airline industry is heating up. As a young, ambitious CEO, it's up to you to make sure your airline is a survivor and not just another casualty. To succeed, you will have to make some tough decisions including where to fly, which planes to purchase and how to attract visitors to the cities you service. Your goal: to differentiate your airline from the rest while still turning a profit.\r\n\r\nln Aerobiz Supersonic, fashion a powerful fleet of aircraft from more than 50 possible choices. organize routes to 89 global destinations and invest your profits in a variety of new services including amusement parks. ski resorts and airport shuttle services. And don’t target as CEO you're still responsible for ings like plane maintenance, advertising and handling those periodic emergencies such as a plane crash or employee strike.\r\n\r\nGet ready to make some tough decisions! If you make the right ones. your planes will dominate the skies of the 21st century.\r\n\r\n*Offer air service to over 80 major and minor cities around the globe\r\n\r\n*Select from four eras in aviation history including two futuristic scenarios Purchase from an extensive list of historical, supersonic and fictitious airplanes\r\n\r\n*Invest in business ventures such as concert halls, golf courses and amusement parks\r\n\r\n*One to four player fun", 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4741], 'genres' => [3, 6], 'publishers' => [50], 'alternates' => ['エアーマネジメントII 航空王をめざせ', 'Air Management II: Kōkū Ō wo Mezase', 'Aerobiz 2', 'Air Management 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 448, 'game_title' => 'Air Diver', 'release_date' => '1990-04-01', 'platform' => 18, 'overview' => 'Your mission is to find and eliminate the enemy terrorists. They are extremely well armed, and central intelligence informs us that they may have the backing of several unfriendly extraterrestrial nations...', 'youtube' => 'hKxMMbK_Jj8', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1823], 'genres' => [1, 8], 'publishers' => [112], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 449, 'game_title' => "Disney's Ariel: The Little Mermaid", 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => "King Triton and his daughter Ariel battle the dangers of the deep to save the kingdom. As Triton, you must rescue Ariel and break Ursula's curse. As Ariel, the little mermaid, you must battle bewitched sea creatures and defeat Ursula to save Triton and the kidnapped merpeople. Dodge angry sharks, sword-wielding skeletons, and falling boulders. Battle the Molten Lava monster and slimy, stinging eels. And if you dare, brave the snake-infested locks of The Medusa. Navigate through undersea mazes, avoiding traps. Pals Sebastian and Flounder rush to the rescue in tight spots. Open sunken treasure chests loaded with booty. Consult maps which lead to your imprisoned friends. Then come face to face with Ursula the Sea Witch, and battle her in a final showdown!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [2], 'publishers' => [15], 'alternates' => ['Ariel: The Little Mermaid'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 450, 'game_title' => 'Art Alive', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "Surprise yourself and impress your friends with astonishing graphics you can make in minutes. Animate them and your TV screen becomes a lively work of art. All with just your television and the 16-bit Genesis system. It's simply the easiest way to be an artist. Create masterpieces that run, jump, and dance! You can even record them on your VCR. It's better than a game... it's ART ALIVE! Turn your imagination loose with the gallery of tools: A rainbow of colors to paint with; 3 different pencil tips for freehand drawing; Circles, rectangles and squares in 3 different outline widths; Spray cans for shading patterns; An eraser and clear feature to make mistakes vanish; Over 50 supplied graphics and animations, including Sonic the Hedgehog and ToeJam & Earl, or create your own; Predrawn backdrops you can color with the fill bucket.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9585], 'genres' => nil, 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 451, 'game_title' => 'Ballz 3D: Fighting at Its Ballziest', 'release_date' => '1994-01-01', 'platform' => 18, 'overview' => "Ballz is a fighting game, but what makes it uniqe is the fact that your player is made out of balls. The game has a detailed 3D engine with a fixed camera. The game plays like your normal beat 'em up game. This game supports 2 players, 3 difficulties and up to 21 matches.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [6543], 'genres' => [10], 'publishers' => [113], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 452, 'game_title' => "Barney's Hide & Seek Game", 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "Barney is a friendly dinosaur who likes playing with children. One day Barney and his little friends decide to play hide-and-seek game. Barney's task is to find the children and the presents they have hidden.\r\n\r\nBarney travels across four different levels. On each one there are five children and five presents to find. You can only jump in the game when there are higher platforms to access. Despite being a platformer, this is not an action game, since Barney can't die and there is no quick reaction required to complete the game. The game is designed for little children and has a very low difficulty level.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [7050], 'genres' => nil, 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 453, 'game_title' => 'Bass Masters Classic: Pro Edition', 'release_date' => '1996-07-01', 'platform' => 18, 'overview' => "Don't miss your chance to compete in the most realistic fishing game for the Genesis. Featuring pro bass anglers George Cochran, Shaw Grigsby Jr., Gary Klein, Tom Mann Jr., Dee Thomas and Kevin VanDam, BASS MASTERS CLASSIC PRO EDITION brings world championship bass fishing indoors! Compete as one of six actual pro fishermen or as an amateur enthusiast in the Bass Masters Classic. Fish the waters in five three-day tournaments at five different lakes. Rich graphics recreate the outdoor fishing experience in vivid detail. Choose your rod, reel, lure, and even boat engine.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [1160], 'genres' => [11], 'publishers' => [114], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 454, 'game_title' => 'Batman Forever', 'release_date' => '1995-09-07', 'platform' => 18, 'overview' => "The Real Game Begins! BATMAN FOREVER! Brace yourself for endless action with BATMAN FOREVER! BATMAN and ROBIN blast into GOTHAM CITY in a duo-player fighting game! Armed with over 125 incredible attacks, fierce combat moves, and an arsenal of gadgets, the DYNAMIC DUO are ready to battle the diabolical minds of TWO-FACE and THE RIDDLER! Without question... it's BATMAN FOREVER! Featuring over 80 unbelieveable stages! Incredible 3-D computer-rendered graphics! Real digitized characters and backgrounds! Team up as Batman and Robin and find tons of secret rooms and hidden surprises!", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [194], 'genres' => [1, 10], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 455, 'game_title' => 'BattleTech: A Game of Armored Combat', 'release_date' => '1994-12-31', 'platform' => 18, 'overview' => "'MECH WAR!!\r\n\r\nThe 31st century is a brutal and violent place. The galaxy is racked by a devastating war waged with gigantic 75-ton BattleMechs teeming with the most ruinous weapons that science can create. MechWarriors like you are needed to pilot the \"Madcat\" Heavy OmniMech on desperate missions against enemy installations. This is the world of BATTLETECH!\r\n\r\nAlone against the relentless onslaught of hordes of enemy defenders, you'll need skill and cunning to knockout your objectives! Steer your lumbering 'Mech into the savage fury of a hornet's nest of attackers, and cut loose with the Madcat's incredible firepower to lay waste to all before you! Fight to the last for a victory that will bring you honor and glory! And if honor isn't motivation enough, it helps to remember that the enemy doesn't take prisoners...\r\n\r\n-Use 9 futuristic and devastating weapons systems to obliterate enemy resistance!\r\n-Battle the ground defenses of the Inner Sphere on five different planets!\r\n-2-Player Cooperative Mode lets one player steer while the other controls the Madcat's weapons systems!", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [5215], 'genres' => [1], 'publishers' => [115], 'alternates' => ['BattleTech'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 456, 'game_title' => "Bill Walsh College Football '95", 'release_date' => '1994-06-01', 'platform' => 18, 'overview' => 'Bill Walsh College Football 95 was one of the many football games released by Electronic Arts back in the day. This one was a bit different as it includes a full season team and player stats, weekly rankings and a windowless passing mode. It has 38 powerhouse teams, such as Florida, Florida State, Texas and Notre Dame to name a few. There are many offensive and defensive plays, over eleven different offensive formations with close to eight options a piece, and six different defensive formations.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [3835], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 457, 'game_title' => 'B.O.B.', 'release_date' => '1993-06-01', 'platform' => 18, 'overview' => "When B.O.B. crashes his dad's space car on the way to pick up his date, he finds himself stranded on a hostile asteroid filled with enemies. By collecting power ups and using fast reflexes B.O.B. tries to find his way off the planet and to his date. B.O.B. fights his way through the forty-five levels, including boss fights and spaceship-racing stages.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [3590], 'genres' => [1], 'publishers' => [2], 'alternates' => ['BOB', 'B.O.B'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 458, 'game_title' => "Bram Stoker's Dracula", 'release_date' => '1993-09-01', 'platform' => 7, 'overview' => "In the game the player takes on the role of Jonathan Harker. Throughout the levels, Abraham Van Helsing will help Jonathan in his quest by providing advanced weapons. With the exception of the MS-DOS version, the game is of the side-scrolling genre. In the game, Jonathan Harker fights Lucy Westenra as a vampiress, Count Dracula's three brides, Dracula's coach driver, Dracula's fire-breathing dragon, Renfield and even Dracula himself and also in some different forms, such as him in his bat form, his young form and his evil wolf form. Levels in the game include the Romanian countryside, a rat-infested old village inn, Dracula's castle, Dracula's cavernous vaults, Dracula's misty catacombs, various locations in London, Lucy's crypt, a graveyard and Carfax Abbey.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7992], 'genres' => [1], 'publishers' => [77], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 459, 'game_title' => 'Bubsy in Claws Encounters of the Furred Kind', 'release_date' => '1990-05-01', 'platform' => 18, 'overview' => "The plot focuses on a race of fabric-stealing aliens called \"Woolies\", who have stolen the world's yarn ball supply (especially Bubsy's, who owns the world's largest collection). Naturally, Bubsy does not take too kindly to the theft and sets out to \"humble\" the Woolies.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [203], 'genres' => [2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 460, 'game_title' => 'Bugs Bunny in Double Trouble', 'release_date' => '1996-06-01', 'platform' => 18, 'overview' => "BUGS BUNNY has dreamed his way into double trouble. A Mad Scientist is after Bugs' brain! To escape, bugs must use the Scientist's Televisor to travel through dreamland and outwit his LOONEY TUNES pals, including DAFFY DUCK, ELMER FUDD, and YOSEMITE SAM. But Bugs' nightmare doesn't end there. Before he can rest, Bugs must rocket to Mars to battle MARVIN THE MARTIAN and his trusty dog K-9. Move fast or... \"That's all Folks!\"", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [778], 'genres' => [15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 461, 'game_title' => 'Bulls Versus Blazers and the NBA Playoffs', 'release_date' => '1993-02-26', 'platform' => 18, 'overview' => "Another update in Electronic Arts' basketball series, this time featuring the teams and players from the 1992 NBA playoffs plus the East and West All-Stars.\r\n\r\nFeatures unchanged from the previous games include detailed stats, instant replay, substitutions, free throw T-meter and signature moves, some of which are new.\r\n\r\nExclusive to the Genesis version is the ability to create your own All-Star teams and to call defensive plays.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 462, 'game_title' => 'Centurion: Defender of Rome', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "Centurion: Defender of Rome is a turn-based strategy game. You start with one province, Rome, and one legion. To complete the game, you have to conquer all the provinces on the map. \r\n\r\nOne part of the game is micro-managing your provinces. You set up tax rates and make people happy by organizing games. In Rome, you can organize a chariot race, a gladiatorial combat or even a simulated naval battle; this starts an action mini-game where you control the chariot rider, gladiator or ship.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [1125], 'genres' => [6], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 463, 'game_title' => 'Chester Cheetah: Wild Wild Quest', 'release_date' => '1994-01-01', 'platform' => 18, 'overview' => "The player may explore the game world in a non-linear fashion. At any time, there are three levels available and the player may tackle them in any order. Each solved level leads to additional two. On each level, the player must find the missing map piece, proceed to the exit, and defeat the level boss. Chester can dash and kill enemies by jumping on their heads. He dies from one hit, unless he has a pack of the cheetahs snack at his disposal. In this case, he'll recover full health.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4598], 'genres' => [1, 2], 'publishers' => [116], 'alternates' => ['wild wild quest'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 464, 'game_title' => 'Chiki Chiki Boys', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "This platform-based action game was converted from a Capcom arcade game, and set in the land of Alurea. The idyllic life of the Alurean people was shattered when the King is killed by a dragon, and a range of nasties inhabit the lands. Fortunately his twin sons have come to the rescue, and you must take control of one or the other to put the world right.\r\n\r\nThe boys have differing skills - one is more skilled in sword-fighting (which you are always armed with), the other in magic (available in limited amounts on each level). You collect coins as the game goes on, and spend these in the shop on extra magic, extra lives and enhanced swords.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [1436], 'genres' => [1, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 465, 'game_title' => 'Columns', 'release_date' => '1990-06-30', 'platform' => 18, 'overview' => "The game takes place inside a tall, rectangular playing area, as in Tetris. Columns of three different symbols (such as differently-colored jewels) appear, one at a time, at the top of the well and fall to the bottom, landing either on the floor or on top of previously-fallen \"Columns\".\r\n\r\nWhile a column is falling, the player can move it left and right, and can also cycle the positions of the symbols within it.\r\n\r\nIf, after a column has fallen, there are three or more of the same symbols connected in a straight line horizontally, vertically, or diagonally, those symbols disappear. The pile of columns then settles under gravity. If this causes three or more other symbols to become aligned, they also disappear and the pile settles again. This process repeats as many times as necessary. It is not uncommon for this to happen three or four times in a row - it often happens by accident when the well is becoming crowded. If the well fills beyond the top of the screen, the game ends.\r\n\r\nOccasionally, a special column called the Magic Jewel appears. The Magic Jewel flashes with different colors and when it lands, it destroys all the jewels with the same color as the one underneath it.\r\n\r\nLike Tetris, the columns fall at a faster rate as the player progresses. The goal of the game is to play for as long as possible before the well fills up with symbols.\r\n\r\nSome ports of the game offer alternate game modes as well. \"Flash columns\" involves mining their way through a set number of lines to get to a flashing jewel at the bottom. \"Doubles\" allows two players work together in the same well. \"Time trial\" involves racking up as many points as possible within the time limit.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [5], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 466, 'game_title' => 'Crue Ball', 'release_date' => '1992-04-26', 'platform' => 18, 'overview' => "ATTENTION HEADBANGERS! The Ultimate Heavy Metal Pinball Concert is about to begin! You just got front row tickets to a no-holds barred, totally rockin' Metalfest. It's up to you to blast the anti-rock forces and crank up the volume to the max. Crue Ball gives you a backstage pass to the ultimate pinball tour. Blistering soundtrack features three Motley Crue hits! Nine rippin' volume levels (that's play levels, dudes)! Special appearance by Motley Crue's Alister Fiend! Loads of skill shots and nasty enemies!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [6178], 'genres' => [11], 'publishers' => [2], 'alternates' => ['Crue Ball: Heavy Metal Pinball'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 467, 'game_title' => "Crystal's Pony Tale", 'release_date' => '1994-01-01', 'platform' => 18, 'overview' => 'You navigate your pony through various locations, collecting horseshoes on your way and "paying" them at level gates to pass to another location. You can explore the locations in any order you wish, traveling directly between them or using teleportation pictures. The game has more adventure than action elements. Crystal Pony cannot die in the game; if an enemy hits her, she merely loses one of her horseshoes. The only battles are against the witch, occurring every time you use a gem at the correct place. The pony would automatically jump over obstacles, but you can also make her jump with a corresponding button. You can get extra items by interacting with various objects and characters, pressing the action button.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [653], 'genres' => [15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 468, 'game_title' => 'Cyber-Cop', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => 'A first person shooter that requires you to think things through rather than just attack anything that moves. This game preceded Wolfenstein 3D by a number of years, and while the walls were not ray cast, but solid fill polygons, it was still one of the earliest simulations to tackle a human viewpoint with complete, 360 degree freedom of movement.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [1827], 'genres' => [8], 'publishers' => [117], 'alternates' => ['Corporation'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 469, 'game_title' => 'Dark Castle', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "The Black Knight has brought misery to the land, and the end way to end this is to enter his haunted house to slay him. You are the brave adventurer taking on this quest through 14 increasingly-tough zones.\r\n\r\nThe bulk of the game is side-viewed, involving single screens to pass through, which incorporate ropes, cages and trapdoor. There are enemies walking, flying and hovering through this, and many of them respawn. Unusually your weapon to take them on (rocks) can be thrown through 360 degrees, which aims to make the gameplay more realistic and methodical. The screens were linked by hub screens, which the player passes through simply by clicking on a door.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [7730], 'genres' => [1], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 470, 'game_title' => 'Desert Strike: Return to the Gulf', 'release_date' => '1992-06-04', 'platform' => 18, 'overview' => "The Scuds Are Back!!!\r\n\r\nWith a fiery blast from your Hellfire missiles you must annihilate a ruthless tyrant's military arsenal. Smoke his private yacht and tear into his air force as you challenge the Madman's forces in a series of surgical strikes. Rip through 27 fiery missions. Force is highly recommended.\r\n\r\n-The Madman's got his finger on the SCUD trigger! Annihilate his Scud launchers before their deadly cargo wreaks havoc on the Western World!\r\n-Battle the Madman's military machine over land, air and sea. One well placed Hellfire could send the tyrant down with his ship.\r\n-Spearhead a rescue assault mission into Embassy City and break out American hostages being used as human shields!\r\n-Check out the on-board computer battle maps and satellite data for locations of enemy MIGs, SCUDs, and dug-in tank encampments.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 471, 'game_title' => 'Double Dragon 3: The Arcade Game', 'release_date' => '1992-04-12', 'platform' => 18, 'overview' => "The original martial arts adventure continues - all the hard-hitting arcade action is at your command! Battle your way across the globe with awesome special moves and lethal weapons straight from the arcade! Whether it's a swirling Hurricane Kick or a staggering One Armed Head Butt, you have what it takes to crush ruthless enemies in the Double Dragon adventure of a lifetime! Battle across America, China, Japan and Italy to your ultimate challenge in Egypt!", 'youtube' => '', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [7940], 'genres' => [1, 2], 'publishers' => [118], 'alternates' => ['Double Dragon III: The Arcade Game'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 472, 'game_title' => 'ESPN National Hockey Night', 'release_date' => '1994-08-01', 'platform' => 18, 'overview' => "ESPN National Hockey Night was one of the many hockey games released back in the day. This one featured all the NHL teams for its time, but lacked an official players license.\r\n\r\nIt had four game modes to choose from: Exhibition, Challenge, Playoff, and Season. The game also features both a horizontal and vertical perspective of the ice, battery backup to save progress and also featured the voice of Bill Clement for play-by-play commentary.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6451], 'genres' => [11], 'publishers' => [77], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 473, 'game_title' => 'Eternal Champions', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "From various time periods of past, present and future, nine fighters killed in an unjust manner find themselves given a second chance for life. An alien being, known only as the Eternal Champion, brings back the fighters into a competition for one reason: to find one among them worthy of being resurrected, giving them a chance to avert their death and tip the balance between good and evil.\r\n\r\nThe fighters range from different eras of Earth's History: Larcen, the cat burglar. Jetta, the circus acrobat. Blade, the futuristic bounty hunter. Midknight, the vampiric bio-chemist. Rax, the cyborg. Shadow, the corporate assassin. Slash, the neanderthal. Trident, a Atlantean warrior. And Xavier, a warlock and alchemist.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7549], 'genres' => [10], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 475, 'game_title' => 'Family Feud', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "The rules conforms to the shows, divided into rounds until a family reaches 300 points and the \"Three Strikes\" rule. It also featured the new \"Bulls Eye Round\" that was introduced to the show at the time.\r\n\r\nTo answer questions, the player uses the D-pad to move a cursor and pressing the required button in order to select that letter and spell out their answer. Players can also battle each other as well as customize their family to their liking, from their appearance, hobbies, intelligence and occupations and customize the rules to suit the player.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4107], 'genres' => [6], 'publishers' => [80], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 476, 'game_title' => 'Fantastic Dizzy', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "The evil wizard Zaks casts a spell on the Yolkfolk and kidnaps Dizzy's girlfriend Daisy. It is up to Dizzy to undo Zak's doings and rescue Daisy from the castle in the clouds.", 'youtube' => 'bQGJWIi2n14', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [1568], 'genres' => [1], 'publishers' => [16], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 477, 'game_title' => 'Fatal Labyrinth', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => 'Dragonia, the castle of doom, has come upon the world and its minions have stolen the Holy Goblet. Without it, the world will be in darkness forever. You play as Trykaar, who must enter the castle and traverse its thirty levels to retrieve the Holy Goblet. There is no other storyline; its dungeons are generated randomly each time you play, like in Rogue-type games.Much like Nethack or other Rogue games, the game is turn-based.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [7549], 'genres' => [4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 478, 'game_title' => 'Fatal Rewind', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => 'This is a vertical platformer with horizontal wrap-around. For the entertainment of the futuristic masses, you play a criminal that has been inserted into a mechanical body with the promise that if you succeed in surviving through all the levels (there are many and they are hard), you will be set free. You start each level at the bottom, near pooling liquid which will soon rise, at your immediate peril. Navigate the level from bottom to the exit at the top before the liquid rises and kills you. There are many other foes that fly around, causing you damage and basically annoying you to spit. Most levels must be navigated through a series of keyed gates, doors, or portals. These shaped keys are scattered around the map and must by picked up and used only on the gates they match individually. Twist: You can only carry one special weapon (triple shot, laser beam, or vertical shot) and one tool (key, liquid-freeze, or a red herring) at a time. This game requires a lot of memorization of enemy movement patterns and optimum routes. A unique feature is that when you die, you can watch a replay and take over at any point to continue your game. You can also hit the HELP button at the start of each level to view a map, helping you plan your route.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [6979], 'genres' => [15], 'publishers' => [2], 'alternates' => ['The Killing Game Show'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 479, 'game_title' => 'Ferrari Grand Prix Challenge', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => "Following F1 Grand Prix Nakajima Satoru, Varie produced another racing simulation using the license. This time the racing is from a first person view aping Super Monaco Grand Prix. The car setup can be modified before you take to the track\r\n\r\nThere is a Time Attack mode, allowing you to go for as fast a laptime as possible on any of the game's 20 circuits (which include the 16 tracks of the 1992 Formula 1 season), as well as a full season mode, with qualifying and the race itself. Weather can be customised in the Time Attack mode but is randomly chosen in Grand Prix mode, while you can only choose one of the D-tier teams (the 4 weakest of the 16) in grand Prix mode, but can drive for McLaren, Williams et al in Time Attack.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [307], 'genres' => [7, 11], 'publishers' => [118], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 480, 'game_title' => 'Final Zone', 'release_date' => '1990-01-01', 'platform' => 18, 'overview' => "It is 100 years into the future. Nuclear weapons, missiles and other weapons of mass destruction are banned, but a new piece of military hardware is about to shape the future. The N.A.P. (New Age Power-Suit), is the newest weapon, a mechanical tank, able to destroy anything in its path. You play as a soldier of the El Shiria Military's \"Undead\" unit named Howie Bowie (no joke) as you are about to go on a urgent mission to destroy your enemies, The Bloody Axis, before they can strike at your nation.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [9678], 'genres' => [1], 'publishers' => [119], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 481, 'game_title' => 'Funny World & Balloon Boy', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "Funny World is an action game where the player must shoot strange animals as they move across the screen. On each stage a set number of \"funnys\" will cross the screen, and the player must shoot a certain number of them before they can safely reach the other side. To make things harder, some will walk, some will run, and some will move erratically; from time to time a female funny will cross the screen, which if shot will cause the player to lose a life. They player also has a certain number of boulders they can drop, which will hit any funny on the screen that may be out of the player's range. If enough funnys are hit, the player moves on to the next stage.\r\n\r\nBalloon Boy is an action game where the player controls a boy at the bottom of the screen who must shoot at balloons floating across the top. When shot, the balloons will release either a trap or an item, and the boy must collect the items while avoiding the traps. If all the balloons are destroyed before the time runs out, the player moves on to the next stage.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [817], 'genres' => [1, 8], 'publishers' => [120], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 483, 'game_title' => "Hard Drivin'", 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "Hard Drivin' is a 3D arcade hit from Atari Games. You are in control of a high-performance sports car. Your objective is to race around the course as fast as possible and hit as many checkpoints as possible. If you hit a checkpoint you gain extra time to go farther. You will see traffic on the road both in your direction and coming down the opposite direction, so be careful when you pass...", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [748], 'genres' => [7], 'publishers' => [111], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 484, 'game_title' => 'Haunting Starring Polterguy', 'release_date' => '1993-04-01', 'platform' => 18, 'overview' => "Scare the evil, greedy Sardinis out of their houses by turning everyday household objects into something scary, funny or just plain gross. Or use your special spells to really send 'em shrieking. But you gotta hurry, 'cause your ectoplasm may run out! 16 megs of cool graphics, gross special effects and blood-curdling sounds. Unique 3/4 view perspective. Over 400 scary, funny or gross fright items, each causing something different to happen. Five special spells: Zom-B-Ize, Supr-Scare, Boo-Doo, Ecto-Xtra and Dog-Off. \"Killer\" dungeon with 12 different paths!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2724], 'genres' => [1], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 485, 'game_title' => 'Hellfire', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => 'In the year 2998, humanity has finally reached the stars, and was able to build a prosperous, peaceful society. However, a space matter known as the Black Nebula began to spread, threatening to engulf the galaxies controlled by humans. It turned out that a robotic dictator named Super Mech was behind this occurrence. The Earth sends Captain Lancer, a skillful pilot navigating the powerful CNCS1 aircraft, equipped with the most powerful weapon: the Hellfire...', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [8503], 'genres' => [1, 8], 'publishers' => [112], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 486, 'game_title' => 'Herzog Zwei', 'release_date' => '1990-01-11', 'platform' => 18, 'overview' => "\"Eins! Zwei! Drei!\" In the murky dawn the tyrant's troops scuffle towards foxholes and tanks. Taking battle position, they quickly check their equipment and load cannons. Then they hunker down, awaiting the cry: \"Attacke!\" \"Hup! Two! Three! Four!\" On your order, rebel soldiers race to their war machines! Jets blast into the dawn, afterburners roaring. Convoys rumble toward the advance bases. Their single purpose: attack! War! You and your opponent face off for control of the world! You're equally matched, man for man, weapon for weapon. You sweat as you order out heavy metal, mobilize troops, and plot the attack! You collide in dogfights, ground frays, and naval clashes! At last, you advance to their home base. Now! Crush the enemy - and become Supreme Commander of the free world!", 'youtube' => 'cJHyfavhI-g', 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [8609], 'genres' => [6], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 487, 'game_title' => 'Home Alone', 'release_date' => '1991-10-31', 'platform' => 18, 'overview' => "As young Kevin McCallister, you have mistakenly been left home alone this Christmas by your family. The big problem here is that a couple of bumbling burglars have set their sights on the McCallister belongings as their ultimate heist. You're the only thing that stands in their way and they're not about to negotiate. Scramble through the house, basement and tree fort while setting incredible traps for the unwanted intruders! Bounce chandeliers and irons off their noggins in an attempt to gain valuable time for yourself as the police race to your rescue. Can you keep out of Marv and Harry's clutches and protect your family's treasures? Find out in this hilarious adaptation of the classic comedy hit of the year!", 'youtube' => nil, 'players' => 1, 'coop' => nil, 'rating' => nil, 'developers' => [1010], 'genres' => [6], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 488, 'game_title' => 'The Humans', 'release_date' => '1992-05-14', 'platform' => 18, 'overview' => 'Your job in this action puzzler is to help prehistoric man to evolve by helping them discover tools, the wheel, weapons, or even fire. Each level in the game will have a given task to help in this, and you are allotted a number of characters who must accomplish the task. The player can switch from person to person while moving the characters around each scrolling puzzle, and teamwork is essential to success.', 'youtube' => 'EeUonNq_-KY', 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [4114], 'genres' => [5, 6], 'publishers' => [80], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 489, 'game_title' => 'The Immortal', 'release_date' => '1993-08-09', 'platform' => 18, 'overview' => "The Immortal is an isometric action-adventure game.\r\n\r\nYour old mentor Mordamir has disappeared. Probably kidnapped. You're not too sure where he might be, but a dungeon is always a good place to look, so you seek out the nearest one and plunge into its depths. Beware: 8 levels of isometric death await.\r\n\r\nThe Immortal is the prototype of a trial-and-error game. Progress is made by encountering a hazard, dying, solving the problem, encountering the next hazard. To solve a level, you have to know its traps and their patterns by heart. As frustrating as this may sound (it is), The Immortal quite cleverly balances annoyance with curiosity and graphical rewards.", 'youtube' => 'YvVFnGYuv_M', 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [2724], 'genres' => [1, 2], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 490, 'game_title' => 'Insector X', 'release_date' => '1990-01-01', 'platform' => 18, 'overview' => "They're gonna bug ya... to DEATH! Compared to these guys, killer bees are about as scary as a butterfly. In this awesome insect Empire you've got to be a fast gun! No can of bug spray will help you here. These giant mechanized insects mean business. Become too enthralled with the beautiful landscape and your daydreams could become a nightmare! Become... Insector X! A moment's delay could be your last!!", 'youtube' => 'https://www.youtube.com/watch?v=dlRPuTnKN1o', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7383], 'genres' => [1], 'publishers' => [56], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 491, 'game_title' => '100 Percent Star', 'release_date' => '2001-12-07', 'platform' => 10, 'overview' => '100% Playstation Star allows players to create a musical group from the beginning. Then you assume various businesses as a producer, manager, composer ... to create the group of your dreams. It all starts with the selection of stars by casting their next look. You will then have the task of composing the music for the album. Finally, a manager with the cap you manage the schedule: rehearsals, photo shoots, studio or concert.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8661], 'genres' => [9], 'publishers' => [26], 'alternates' => ['100% Star', 'Popstar Maker'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 492, 'game_title' => 'Actua Golf 3', 'release_date' => '1999-01-01', 'platform' => 10, 'overview' => "Actua Golf 3 is a golf simulation game featuring eight courses. You can completely customize your own character. With a new character you start with amateur tournaments until you have removed your handicap. Then you can participate in the pro tournaments.\r\n\r\nTo hit the ball in this game the player will have to use his analogue stick and swing that much like a real club.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3620], 'genres' => [11], 'publishers' => [121], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 493, 'game_title' => 'Akuji the Heartless', 'release_date' => '1998-12-31', 'platform' => 10, 'overview' => "In Akuji: The Heartless the player takes the role of Akuji, a voodoo-priest. The title of the game is meant to be taken literally as Akuji's wedding day brought a problem with it: his brother kills him and rips out his heart. Now Akuji has to travel through the underworld to get back to the living and take his revenge.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1963], 'genres' => [1], 'publishers' => [26], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 494, 'game_title' => 'Alone in the Dark: The New Nightmare', 'release_date' => '2001-06-18', 'platform' => 10, 'overview' => "Set on October 31, 2001. Edward Carnby's best friend and partner, Charles Fiske, has been found dead off the coast of Shadow Island, a mysterious island near the coast of Massachusetts. Carnby's investigation quickly leads him to Frederick Johnson, who informs him of Fiske's search for three ancient tablets with the ability to unlock an incredible and dangerous power. Johnson pleads with Carnby to take the place of Fiske and reopen the investigation in order to recover the tablets. Carnby accepts and makes it his mission to find Fiske's killer. Johnson introduces Edward to Aline Cedrac, an intelligent, young university professor. She joins Edward to recover the missing tablets and assist Professor Obed Morton, who she believes to be her father. While flying over the coast of Shadow Island, Edward and Aline's plane comes under attack by an unknown creature. Edward and Aline both jump out of the plane and parachute to the ground, but are separated immediately. Edward lands in the dense forest just outside a manor, while Aline lands on the roof of said manor.", 'youtube' => 'mb6XExJq1p4', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2112], 'genres' => [8, 18], 'publishers' => [72], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLUS-01201', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 495, 'game_title' => 'Alundra', 'release_date' => '1997-12-31', 'platform' => 10, 'overview' => "Between the worlds of light and dark lies the world of dram. A world where the rule of reason loosens its grip. A place where an insidious evil is stealing minds and blackening the hearts of those from the world of light. Grab a weapon and become the dreamwalker Alundra as he struggles to purge the evil Id of an ancient world before it falls to ash.\r\n\r\nExplore dungeons, find monster butt as you weave between tense reality and nightmarish dreams to save the hapless masses. With a wide cast of characters and scores of challenging puzzles created by the people responsible for Landstalker on the Genesis. Alundra will rob you of precious sleep until you finish.", 'youtube' => '6Bk8-Eyu52o', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5302], 'genres' => [1, 2, 4], 'publishers' => [122], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 496, 'game_title' => 'Aqua GT', 'release_date' => '2001-01-26', 'platform' => 10, 'overview' => "Aqua GT is powerboat racing game. It features three modes: Championship, Arcade and Two-player.\r\n\r\nChampionship mode is the main single player game, where you advance through the Bronze, Silver and Gold Championships. In the Arcade gameplay mode you have to beat the clock. In two-player split screen mode you go head to head against another player.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6820], 'genres' => [7], 'publishers' => [123], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 497, 'game_title' => 'Army Men: Air Attack', 'release_date' => '1999-10-13', 'platform' => 10, 'overview' => 'The green and tan armies once again battle, this time in the air via the huey(agile helicopter), chinook(Double rotor heavyweight lifting helicopter), Super Stallion and Apache. The tan army are not the only enemies. Insects also get in the way. You must protect tanks, trucks, other helicopters, a train and even a UFO.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [77], 'genres' => [1], 'publishers' => [63], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 498, 'game_title' => 'Asterix and Obelix Take on Caesar', 'release_date' => '1999-03-01', 'platform' => 10, 'overview' => "- For controller pros and budding tacticians alike!\r\n- Choose your own path through the game\r\n- Intelligent romans (for once...)\r\n- Plenty of punch-ups - in 3D!\r\n- Asterix the \"Intelligent\" action game.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [8013], 'genres' => [1, 6], 'publishers' => [72], 'alternates' => ['Astérix: The Gallic War', 'Astérix'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 499, 'game_title' => 'A-Train', 'release_date' => '1996-01-01', 'platform' => 10, 'overview' => "Although trains are your primary source of income in the beginning of the game, A-Train is not about building trains exclusively. By utilizing the train industry as well as buses and subways, it is up to you to manage an efficient transportation system for passengers and freighting companies. Everything you do must be well thought out because you're out to make a profit.\r\n\r\nAs soon as you've earned the adequate funds, you have to start making investments. With your money you can buy and sell all types of land and businesses. If you think you're lucky enough, you may opt to play the stock market. Purchased land can be developed in a variety of ways, such as in the development of offices, apartments, hotels, factories, golf courses, and so on. It is up to you to build the largest financial empire humanly possible.\r\n\r\nAs the city develops, new businesses will spring up, such as stadiums, high rise office blocks, and ski resorts. You can also build your own businesses, the success of which will depend on the local population, the presence of competing businesses, and even the changes of the seasons, among other factors.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [651], 'genres' => [6], 'publishers' => [124], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 500, 'game_title' => 'Ball Breakers', 'release_date' => '2000-07-26', 'platform' => 10, 'overview' => "The universe is made up of human and synthetic lifeforms. Synthetic lifeforms are considered second class citizens by their human counterparts. The story takes place on the prison planet Alpha Prime, a world completely designed for the holding of criminals. You are a synthetic lifeform sentenced for an eternity for a crime you didn't commit and in order to earn your freedom, you must compete against other prisoners in competitions in 10 different incarceration facilities. To compete in these competitions however, you must undergo a procedure that removes your legs and replaces it with a rolling sphere.\r\n\r\nThere are seven different events to compete in which are Pursuit, Last Man Rolling, Race, King of the Hill, Run the Gauntlet, Tag, and Powerball that pit you not only against your fellow inmates and guards, but against the levels themselves. Run the gauntlet charges you with making it to a goal point within a time limit, all the while avoiding other warriors and obstacles such as flame throwers, spikes, and gun turrets. Pursuit is identical, but it adds the challenge of the arena crumbling away. Powerball has you collecting balls throughout the arena and throwing them at a goalpost before time runs out. Tag has you collecting a set number of tokens that have been scattered throughout the arena within a set time limit.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5057], 'genres' => nil, 'publishers' => [123], 'alternates' => ['Moho'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 501, 'game_title' => "King's Field (Japan)", 'release_date' => '1994-12-16', 'platform' => 10, 'overview' => "The Japan-only release of the first installment in From Software's \"King's Field\" series.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [3192], 'genres' => [2, 4], 'publishers' => [126], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 502, 'game_title' => 'Beyond the Beyond', 'release_date' => '1996-08-31', 'platform' => 10, 'overview' => 'Beyond the Beyond gather warriors, mages, pirates and mystics. Observe as they transform into more powerful classes. Clerks evolve into high clerks monks into master monks and conjurers into mighty summers. Unravel complex secrets in two richly textured views, explore in lush top-down isometric view and battle savage enemies in full 360. Grow stronger and smarter, with each victory your swordsmanship increases in power and your magic will swell with potent energy. Use supreme magic to summon monsters, fatal storms to hurl tormentors into another dimension or drown them in a boiling sea of fire.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1421], 'genres' => [4], 'publishers' => [127], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 503, 'game_title' => 'Big Air', 'release_date' => '1999-02-28', 'platform' => 10, 'overview' => 'Includes several snowboarding events - standard slalom-style, half pipes, races, and more. Also features several licensed riders, 24 courses, and lots of licensed music.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6622], 'genres' => [11], 'publishers' => [113], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 504, 'game_title' => 'Black Dawn', 'release_date' => '1996-09-30', 'platform' => 10, 'overview' => 'Set in 1998, the player controls a helicopter ace recruited into a black ops counterterrorism strike force named Operation Black Dawn. The player pilots the agile AH-69 Mohawk, an advanced combat helicopter with a powerful arsenal of weaponry. The game consists of seven campaigns that take place in different areas, and each campaign has a number of different missions. In addition to search-and-destroy objectives, there are hostages that require saving. The game has drawn comparisons with Soviet Strike, another helicopter simulator released in the same year. However, Black Dawn resembles an arcade game rather than a typical simulator, not least because various power-ups are obtained from destroyed enemies.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1154], 'genres' => [1], 'publishers' => [117], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 505, 'game_title' => 'BRAHMA Force: The Assault on Beltlogger 9', 'release_date' => '1997-03-31', 'platform' => 10, 'overview' => "A mech-based FPS; pilot your Bipedal Robotic Assault Heavy Mechanized Armor (built by Bronx Industries, of course) through the Beltlogger 9 excavation colony...\r\n\r\n...discover what happened to the Beltlogger 9 colony- it may be related to the events on Probe Ship Mina 3, wherein a lone person apparently under the control of an outside intelligence slaughtered his shipmates.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1829], 'genres' => nil, 'publishers' => [109], 'alternates' => ['BRAHMA Force'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 506, 'game_title' => 'Breath of Fire III', 'release_date' => '1997-09-11', 'platform' => 10, 'overview' => "A MYSTERIOUS POWER...AN UNLIKELY HERO...A CLASSIC ADVENTURE...\r\n\r\nThe lone survivor of a legendary dragon clan, a rebellious youth embarks on a great journey. One of discovery... and danger. The classic role-playing game now returns to continue the epic tales of Ryu and the dragon people. An inner power of uncertain origin matures Ryu into a warrior who ponders his purpose as he embarks on a mystical journey. What lies ahead is shrouded in mystery... yet strangely familiar.\r\n\r\nDRAGON GENE SPLICING\r\nLEGENDARY ROLEPLAYING\r\nAN EPIC 3-D ENVIRONMENT\r\nLEARN OR STEAL ADVANCE SKILLS AND TECHNIQUES\r\nPOWERFUL MAGIC\r\n\r\nNOW YOU POSSESS THE POWER TO CONTROL RYU'S DESTINY.", 'youtube' => 'w1PGuMfytHc', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [4], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 507, 'game_title' => 'Breath of Fire IV', 'release_date' => '2000-04-27', 'platform' => 10, 'overview' => "Stunning New and Improved Graphics - High Resolution, Animated Characters in Vast 3-D Worlds\r\n\r\nMore Than 200 Spells to Learn and Master - Unlock New Magic From Opponents\r\n\r\n2 Epic Intertwining Storylines - Follow the Fates of Ryu and Fou-Lu - A Classic RPG Adventure!\r\nOne Princess. Two War-Torn Lands.\r\nAn Epic Quest for Peace\r\n\r\nAfter centuries of war, the two lands bordering an impenetrable swampland have finally reached an armistice. Mysteriously, the noble Princess Elena disappears somewhere near the war-ravaged front lines. Distraught, her sister Nina goes in search of the Princess alone and on her journey, meets a mysterious, young warrior named Ryu. Their destinies soon entwine. The next chapter in the epic tale of magic and mystery now unfolds. The fate of what lies ahead rests in your control.", 'youtube' => 'fTzU3A2I7BU', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [4], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 508, 'game_title' => 'Brigandine', 'release_date' => '1998-04-02', 'platform' => 10, 'overview' => "Brigandine: The Legend of Forsena is a role-playing war simulation title in the fashion of Tactics Ogre, Ogre Battle, and Final Fantasy Tactics. At the beginning of the game, players will select one of five different Knights of the Rune and defend a specific piece of Forsena. Lance is a young fourteen year old prince that has been summoned to protect New Almekia and Late Badostow; Lyonesse must defend her kingdom of Leonia; and the lord-ranked Vaynard will defend the northlands with his White Wolf warriors.\r\n\r\nFrom the Strategy Map, players will organize their party members into effective attack forces, equip newly found weaponry, check statistics, and move around the map in search for enemy soldiers. Battles take place on a hexagonal piece of country land with fixed amounts of character movements and actions. Depending on the class of certain characters, as the commander, you'll order your troops to unleash rune assaults, magical spells, and attacks with bows, blunt objects, and swords.", 'youtube' => 'g9cBs26A_Cs', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3777], 'genres' => [4, 6], 'publishers' => [58], 'alternates' => ['Brigandine: The Legend of Forsena', 'Brigandine - Legend of Forsena'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 509, 'game_title' => 'Bust-A-Move 4', 'release_date' => '2000-01-31', 'platform' => 10, 'overview' => "Puzzle Bobble 4 (also known as Bust-a-Move 4 in North America and Europe) is the third sequel to the video game Puzzle Bobble and is the final appearance of the series on the Arcade, PlayStation and Dreamcast. The game is also the final title to be recognizably similar in presentation to the original.\r\n\r\nBuilding upon the success of Puzzle Bobble 3, the game adds a pulley system that requires two sets of bubbles, attached to either side of a rope hanging across two pulleys. The game contains a story mode for single player play.", 'youtube' => 'og4R3YrvIzk', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8449], 'genres' => [5], 'publishers' => [130], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 510, 'game_title' => 'Casper', 'release_date' => '1996-08-01', 'platform' => 10, 'overview' => "The plot centers around the \"spoiled, grasping inheritor of Whipstaff Manor\" - Carrigan Crittenden. She's after the treasure she thinks is hidden in the walls. Casper will need the help of Dr James Harvey - therapist to the dead - if he has any hope of succeeding in his adventures.", 'youtube' => 'naL_d9nT0XM', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [181], 'genres' => [1, 2], 'publishers' => [130], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 511, 'game_title' => 'Castlevania: Symphony of the Night', 'release_date' => '1997-03-20', 'platform' => 10, 'overview' => "Five years ago, Richter Belmont, the latest in the Belmont lineage and the one destined to be a Vampire Hunter, defeated Dracula in a brutal battle which nearly cost him the love of his life, Annette, and her sister, Maria. Now, Richter has suddenly vanished, CastleVania has mysteriously reappeared, and Maria, now a young woman, sets off to find Richter. Alucard, the son of Dracula, is awakened from his eternal slumber after this large shift in power, and enters into Castlevania to find some answers and perhaps destroy the castle once again.\r\n\r\nSymphony of the Night is a direct sequel to Dracula X: Rondo of Blood. The game is set in a castle which you can explore freely with many different paths, although often items in certain areas need to be found that will allow passage to others. The action-based gameplay incorporates now strong RPG elements. The hero receives experience points for defeating enemies, gains levels and becomes more powerful. There is also money to be found in the game, and various accessories to buy. In a separate screen, players need to equip attack weapons, shields and other items. Magic plays an important role, as well as secondary weapons and a large amount of \"special moves\" that are executed similar to advanced one-on-one fighting games.", 'youtube' => 'd2JsYKbWubY', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4765], 'genres' => [1, 2], 'publishers' => [23], 'alternates' => ['Akumajou Dracula X: Gekka no Yasoukyoku'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 512, 'game_title' => 'Championship Bass', 'release_date' => '2000-02-29', 'platform' => 10, 'overview' => 'Bass fishing reaches new level with Championship Bass! Artificial Intelligence creates the most realistic behavior in simulated bass ever. False strikes, swerves, return attacks, and short-strike lunges will keep you on the edge. Even if you do land a strike, watch these fish go for obstacles in order ot break your line! Multiple difficulty levels, plenty of tricks in your lure box, multiple game modes, multiple lakes, and more. Sit in a boat and go for the fish, or simulate a whole fishing trip. The choice is yours!', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 513, 'game_title' => "Chocobo's Dungeon 2", 'release_date' => '1999-11-30', 'platform' => 10, 'overview' => "FINAL FANTASY's Chocobo stars in an all-new adventure!\r\n\r\nIn search of treasure, Chocobo and Mog find more than they expect. Joined by other FINAL FANTASY characters, Chocobo must defeat foes and unveil a friend's secrets while exploring a series of mysterious dungeons.\r\n\r\nPlayers can combine armor or weapons to form stronger resources in their quest. There are also magic feathers that can aid in your efforts, since they allow gamers to perform magic spells that have an impact on combat. Between your dungeon travels, players are able to explore villages to obtain valuable clues for the journey. In addition, players can use this time to update Chocobo's inventory.", 'youtube' => 'rGwqyWsqc9w', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8096], 'genres' => [1, 4], 'publishers' => [11], 'alternates' => ["Chocobo's Magical Dungeon 2"], 'uids' => nil, 'hashes' => nil },
    { 'id' => 514, 'game_title' => 'Cool Boarders 2', 'release_date' => '1997-10-31', 'platform' => 10, 'overview' => "Cool Boarders 2 features four stock riders and six stock tracks. Many more are available as you progress through the game or unlock them with codes or secrets.\r\n\r\nThis installment of the Cool Boarders series features a split screen \"Vs\" mode, where two human players can race each other. It also features a one person race option, to race against up to six CPU controlled players.\r\n\r\nThe tracks all vary in length and challenge level. There is also a half pipe, Boardpark level and a Trick Master Run with continuous jumps and a tutorial to teach you all the moves. The move list in Cool Boarders 2 is quite extensive, including standard board grabs and various flips and spins. The graphic technology is primarily based on 3D polygonal models. The game also features red book audio.", 'youtube' => 'p7mrFzi-aQA', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9188], 'genres' => [11], 'publishers' => [21], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 515, 'game_title' => 'Crash Bandicoot 3: Warped', 'release_date' => '1998-10-31', 'platform' => 10, 'overview' => "After defeating Dr. Neo Cortex, Crash and his sister, Coco, take a well-deserved vacation. However, their friend, Aku Aku, has a bad feeling, and as usual, he is right. Aku's evil twin, Uka Uka, was the person behind all of Dr. Cortex's schemes. Now Uka and Cortex have hatched a plot to gain control of the powerful crystals they desire. The have hired Dr. N. Tropy to create a time machine, which will allow Uka and Cortex to go back and take the crystals without interference. Take control of Crash and Coco as they travel through 30 levels across five time periods in an effort to stop Uka and Cortex. Use a motorcycle, plane, bazooka, and a baby T-rex to help Crash survive, or destroy the bad guys by using new moves like the super belly flop or the double jump. Will Crash and Coco be able to save the world? Play CRASH BANDICOOT: Warped and find out.", 'youtube' => 'r-bnMlpmkiE', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5839], 'genres' => [2, 15], 'publishers' => [21], 'alternates' => ['Crash Bandicoot 3: Warped', 'Crash 3: Warped'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 516, 'game_title' => 'Crusader: No Remorse', 'release_date' => '1996-12-31', 'platform' => 10, 'overview' => "As No Remorse opens, a trio of Silencers—enigmatic super-soldiers—are returning from a botched mission in which they disobeyed an order to fire upon civilians who were (mistakenly) believed to be rebels. They are ambushed by a WEC mech, and two of the Silencers are killed. The remaining one, a nameless captain, (whom the player plays as), joins the Resistance, where, as a significant symbol of the WEC's military power and political philosophy, he meets with resentment, distrust and outright hatred. However, he uncomplainingly undertakes dangerous missions, often with substandard equipment, and his continued success gradually earns the respect of his fellow Resistance members.\r\n\r\nThe Captain eventually uncovers secret plans for a WEC space station, the Vigilance Platform, which can attack any location on Earth from space, meaning cities with a known Resistance presence can simply be annihilated at the leisure of the WEC. All such cities are threatened with orbital bombardment unless they surrender. Concurrently, the player's Resistance cell is betrayed from within, and almost all the non-player characters are killed. Despite these setbacks, the Captain infiltrates the Vigilance Platform and destroys it. The traitor is also on the station, guarding the lifepods, and challenges the Silencer to a duel over the access card for the last pod. As the Vigilance Platform is exploding, the Captain is contacted by Chairman Draygan, who swears vengeance against the Silencer.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7050], 'genres' => [1, 2, 8], 'publishers' => [131], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 517, 'game_title' => 'Danger Girl', 'release_date' => '2000-09-14', 'platform' => 10, 'overview' => "Danger Never Looked So Good!\r\n\r\n3rd person action-adventure has never been sexier with DANGER GIRL, the only videogame based on on the best-selling comic book series by J. Scott Campbell and Andy Hartnell.\r\n\r\nDare to take control of 3 beautiful yet leathal Danger Girls in an espionage-themed thrill-ride deemed to dangerous for any man to handle!\r\n\r\n* \"I love to unleash my bullwhip, sniper rifle, and grenades on hammer goons!\"\r\n* \"Check out our loading screens, featuring original artwork by our creators!\"\r\n* \"Help me use my high-tech spy gadgets including infra-red goggles, bomb decoders and more...\"\r\n\r\nCOLLECTORS ITEM!\r\nManual features exclusive character sketches, bios and artwork from the creators!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5793], 'genres' => [8], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 518, 'game_title' => 'Destrega', 'release_date' => '1999-01-31', 'platform' => 10, 'overview' => "Thousands of years ago, a people known as the Strega came to the country of Zamuel offering the secrets of peace and understanding. With them they brought great knowledge and power and shared gifts with the people to exercise powers such as those the Strega had. They showed the path towards true enlightenment, but underestimated the overwhelming drive of human greed and ambition.\r\n\r\nNow Lord Zauber has gained the control of the Strega relics. He seeks to wipe out any opposition to him and hunt down descendants of the Strega and eradicate them.\r\n\r\nPossibly one of the most in-depth fighting adventures to date, Destrega melds role playing with fighting. Moving freely within an environment that includes castle ruins, underground caverns and wide open countryside, you must discover the secret of the legendary relics, learn the truth behind the Strega and stop the Zauber's evil ambitions.", 'youtube' => 'q9KDJvJPJgI', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6242], 'genres' => [10], 'publishers' => [50], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 519, 'game_title' => 'Die Hard Trilogy', 'release_date' => '1996-08-20', 'platform' => 10, 'overview' => "You're at the center of three totally different, thrill-packed adventures. Every adventure you choose delivers amazing depth, palm-sweating realism and fully-rendered detail over thirty incredible levels.\r\n\r\n* Die Hard - Full screen 3-D action as you fight to rescue innocent hostages in a skyscraper wired to explode!\r\n\r\n* Die Hard 2: Die Harder - Arcade shooting at its fastest and finest as you eliminate terrorists at Dulles Airport.\r\n\r\n* Die Hard With A Vengeance - Heart-accelerating, simulated driving adventure as you race through New York City to find hidden bombs!", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6787], 'genres' => [1], 'publishers' => [132], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 520, 'game_title' => 'Digimon World', 'release_date' => '2000-05-23', 'platform' => 10, 'overview' => "The PlayStation's answer to the Pokémon series phenomenon from Nintendo, Digimon World lets you raise customized Digimon monsters, training them for battle against other Digimon found in Digimon World. Most Digimon originally called File Island home, but for some unknown reason over time they lost the ability to speak and now live a nomadic lifestyle.\r\n\r\nIt is your goal to roam the dangerous countryside with your trained Digimon battling other lost Digimon. A victorious battle permits them to return home to the abandoned File Island. The main one-player mode on Digimon World is where the mysterious story unfolds as you raise your immature Digimon. Digimon are dependant on you for happiness, food, and parental guidance to guide their behavior (similar to the popular Tamagotchi toy).\r\n\r\nDigimon mature while \"working out\" in the training area and as you battle various Digimon in the surrounding areas. Your pet Digimon can compete against friends' Digimon in Battle Mode that provides an arena for head-to-head combat. A loss against a friend can provide plenty of initiative to return to the main mode to strengthen your Digimon, but you'll need one block of free space on the memory card to save your progress.", 'youtube' => 'CQ8m0HUDG0Y', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3107], 'genres' => [2], 'publishers' => [57], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 521, 'game_title' => 'Driver 2', 'release_date' => '2000-11-13', 'platform' => 10, 'overview' => "You are an undercover driver, trying to survive amidst an international war between American and Brazilian gangs. The action takes you to Chicago, Las Vegas, Rio and Havana, all of which are depicted in detail, with curved roads added from the first game.\r\n\r\nAs before, you have full control over the car as it storms around the streets. A new feature is the ability to get out of the car, and carjack others. This is especially useful when you have fallen victim to the advanced damage modeling.\r\n\r\nThere is a full sequence of missions to complete, as well as some pre-set challenges and a Free Driving mode allowing you to explore at your leisure.", 'youtube' => 'pxyePoT1Su0', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7109], 'genres' => [1, 7], 'publishers' => [72], 'alternates' => ['Driver 2: Back on the Streets', 'Driver 2: The Wheelman is Back'], 'uids' => [{ 'uid' => 'SLES-02994', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 522, 'game_title' => "Sesame Street: Elmo's Number Journey", 'release_date' => '1998-10-16', 'platform' => 10, 'overview' => "In Sesame Street: Elmo's Number Journey you assume the role of the cuddly red Muppet Elmo as you journey and explore three different fantasy worlds. These worlds are Cookie Monster's World, Count Von Count's Castle and Ernie's Carnival in the Park. You will begin your adventure on Sesame Street, where you will meet Sesame Street characters who invite you to visit their fantasy worlds to search for numbers and play games. Before you leave Sesame Street you can interact with the characters around you as well as visit Elmo's Room, where you can practice playing the game. While in Elmo's Room you can also view the game's credits and watch preview videos from Sony Wonder (by pressing the \"down\" directional button).\r\n\r\nEach of the three fantasy worlds you will travel to consist of two different game environments and a bonus world. Once you have acquired the correct amount of numbers required to pass through each fantasy world you will be instantly transported to the bonus world where you will be challenged to solve simple addition and subtraction problems.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'EC - Early Childhood', 'developers' => [7050], 'genres' => nil, 'publishers' => [133], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 523, 'game_title' => 'Evil Zone', 'release_date' => '1999-05-31', 'platform' => 10, 'overview' => "Originally released in Japan a few months ago as the tongue-twistingly titled Eretzvaju, Titus has picked up the projectile-based fighter and released it in the States as the hilariously named Evil Zone. An amalgamation of Psychic Force and Destrega, Evil Zone is a projectile-based 3D fighter that adds a dynamic element lacking from most of today's fighting games. Developed by Yuke's, the team behind the successful (in Japan at least) Toukon Retsuden series, and the not so successful Soukaigi (Square's recent action RPG), Evil Zone is a refreshing surprise from a development team not known for fighting games.\r\n\r\nThe premise in Evil Zone centers around the main character, Danvaizer, a superhero in the mold of classic Japanese afternoon TV shows (a la Power Rangers, Kamen Rider, etc.). While the storyline is truly superfluous, it nevertheless suffices as reason enough to gather Danvaizer and nine other combatants together to do battle in a distinctly different manner than most other fighting games.", 'youtube' => 'HznxJVvMo_k', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9785], 'genres' => [10], 'publishers' => [64], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 524, 'game_title' => 'Fighting Force 2', 'release_date' => '1999-11-30', 'platform' => 10, 'overview' => "Fighting Force 2 is a beat-em-up/adventure game set in the not-to-distant future. Human cloning has become a real possibility, but has been banned by an international treaty. The Knackmiche Corporation has been suspected of researching cloning, and you, Hawk Manson, are sent in on a covert mission to investigate.\r\n\r\nThis game features large levels and both hand-to-hand and weapons combat.", 'youtube' => '7pgzFeaCPJg', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1827], 'genres' => [1, 10], 'publishers' => [26], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 525, 'game_title' => 'Final Fantasy VII', 'release_date' => '1997-06-01', 'platform' => 10, 'overview' => "Set in a dystopian world, Final Fantasy VII's story centers on mercenary Cloud Strife who joins with several others to stop the megacorporation Shinra, which is draining the life of the planet to use as an energy source. As the story progresses, the situation escalates and Cloud and his allies face Sephiroth, the game's main antagonist.", 'youtube' => '1UwO1xgiOUE', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => ['ファイナルファンタジーVII Fainaru Fantajī Sebun', 'Final Fantasy 7'], 'uids' => [{ 'uid' => 'SCES-00867', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 526, 'game_title' => 'Final Fantasy VIII', 'release_date' => '1999-02-11', 'platform' => 10, 'overview' => "A member of an elite military team, Squall is forced into a conflict beyond imagination.  To survive, he must contend with a desperate rival, a powerful sorceress, and his own mysterious dreams.\r\n\r\n* Realistic, detailed characters and background graphics enhanced by a breathtaking musical score\r\n* An epic story based on the theme of love, set in a massive new world\r\n* New Junction System allows characters to be customized with powerful magic spells drawn from enemies\r\n* Nearly an hour of stunning motion-captured CG cinemas seamlessly integrated into gameplay", 'youtube' => '2qH6gPZS1zI', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => ['Final Fantasy 8'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 527, 'game_title' => 'Final Fantasy IX', 'release_date' => '2000-11-13', 'platform' => 10, 'overview' => 'A band of thieves are hired to kidnap Princess Garnet of Alexandria. After they succeed, they end up becoming her guardians. And while protecting the fair Princess from a powerful evil...they hold the fate of the world in their hands. Play along on the epic journey filled with danger, mystery, war and love.', 'youtube' => 'MaJDP5uOV2w', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => ['ファイナルファンタジーIX Fainaru Fantajī Nain', 'Final Fantasy 9'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 528, 'game_title' => 'Final Fantasy Anthology', 'release_date' => '1999-10-05', 'platform' => 10, 'overview' => 'Final Fantasy Anthology combines two titles from the Final Fantasy series and offers PlayStation owners a glimpse into the past. Huge worlds, in-depth storylines, and innovative battle and magic systems, and an incredible cast of characters all make for a deep gaming experience. The inclusion of Final Fantasy V marks the first time this title has appeared on a console in North America. Final Fantasy VI, originally released as Final Fantasy III on the SNES system in the U.S., makes its first appearance on the PlayStation. Both games in this compilation feature never-before-seen CG movies, adding to the appeal of these classics.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 529, 'game_title' => 'Formula One 99', 'release_date' => '1999-10-31', 'platform' => 10, 'overview' => "Formula One 99 is the fourth installment in Psygnosis' FIA-licensed, Formula One series. All the racing teams, drivers, cars, and technical specs have been updated to match changes in the real world of Formula One racing. Even the newly constructed (as of 1999) Sepang International Circuit in Kuala Lumpur, Malaysia has been added to the season.\r\n\r\nPlayers may choose to participate in a Quick Race, an arcade-style game, a Grand Prix, which is a racing simulator, and various two-player racing options. In Quick Race, there is no concern for fuel, damage, pits or penalties. Select a track, set up race options such as weather, and go.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8252], 'genres' => [7], 'publishers' => [135], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 530, 'game_title' => 'Front Mission 3', 'release_date' => '2000-02-29', 'platform' => 10, 'overview' => "Yokosuka, Japan, 2112 AD. The young student Kazuki Takemura works as a test pilot with Kirishima Industries, a production company of military battle wanzers (walking panzers), mechanized walking robots with movement similar to that of a human being. Kazuki has just finished testing the combat capabilities of the new Zeinslev prototype in the lab. Finishing his day's tasks he is asked by his best friend Ryogo to help with a company delivery to the Japanese Defense Force (JDF) military based. This simple choice determines where Kazuki is when strange things begin happening in Japan. A large explosion, a wanzer theft, his sister Alysia being hunted, rumors of a powerful weapon, and accusations of involvement by agents of both the OCU and the USN all make the situation more complicated. Kazuki is swept up in a plot of conflicting loyalties and attacked by various factions. He will need to recruit additional characters and wanzers in order to be victorious in battle and investigate leads to uncover what is going on.", 'youtube' => 'uqkkyC8Jz-s', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4, 6], 'publishers' => [136], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 531, 'game_title' => 'Galerians', 'release_date' => '2000-03-29', 'platform' => 10, 'overview' => "A fleeting memory. A haunting vision. A childhood mystery that can prevent the destruction of mankind. Crave Entertainment, Inc. introduces Galerians, a survival-horror title for the PlayStation that thrusts players into a twisted future.\r\n\r\nRion is a young boy who awakens in a laboratory, unable to remember anything except his name. He soon discovers that he possesses psychic powers, although they come with severe consequences. With only a girl named Lilia, whose voice guides him, Rion must escape his captors and begin putting together the broken shards of his memories.\r\n\r\nPlayers assume the role of Rion and must guide him through four locations in his search for Lilia and the secret of his past. Armed with powerful psychic abilities, Rion must combat human enemies and a variety of frightening genetic experiments. Unfortunately, nothing can prepare him for the confrontation with his own history.\r\n\r\nThe game spans three discs, combining action and puzzle solving in a horrific setting. Galerians utilizes a third-person perspective and features polygonal characters on pre-rendered backgrounds. The shocking truth is gradually revealed through fragmented visions and confessions, building to an epic struggle between man and machine.", 'youtube' => 'Nqm3ai28-lQ', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6733], 'genres' => [18], 'publishers' => [68], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 532, 'game_title' => 'G-Police', 'release_date' => '1997-10-15', 'platform' => 10, 'overview' => "After a violent interstellar resource war, mega-corporations seize power from the remnants of Earth's governments and lead humanity's way into the colonization of space. The last vestige of central authority is in the form of the G-Police (Government Police); an independent agency tasked with keeping order in the colonies. You play as rookie Jeff Slater - a former military pilot going undercover at the G-Police squadron on Callisto, in the hopes of finding the truth behind your sister's sudden death.\r\n\r\nG-Police is an arcade-style helicopter shooter set inside the colony domes on Callisto. You pilot a futuristic close-air-support gunship, and are tasked with engaging ground and air enemies as you uncover a sinister corporate plot. Your ship can hover and turn in a VTOL mode, fire weapons outfitted before each mission, and lock on to objects in the world to both track enemies and scan suspicious cargo. Missions require you to navigate through the skyscrapers and billboards of the various city districts, and complete a number of objectives updated through radio contact with headquarters.", 'youtube' => 'ZTEIh0sLlc0', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6840], 'genres' => [8, 13], 'publishers' => [21], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 534, 'game_title' => 'Joe Montana II: Sports Talk Football', 'release_date' => '1991-04-01', 'platform' => 18, 'overview' => "Joe's back - now with simultaneous non-stop play-by-play announcing. Control the action on the field and listen to the running commentary from the broadcast booth. It's a whole new game of sound and sight! The field zooms to a dazzling 6X close-up when the players cross the scrimmage line. You see every slamming interception, flying tackle and smash through the defensive wall! Up close and personal! Team up with another guy - you're the quarterback, he's the wide receiver. Call your strategy with over 50 plays in rain/snow, on grass/artificial field. Wide view shows all your receivers at once.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [1233], 'genres' => [11], 'publishers' => [15], 'alternates' => ['Joe Montana Football II'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 535, 'game_title' => 'Jordan vs Bird', 'release_date' => '1988-01-01', 'platform' => 18, 'overview' => 'Michael Jordan of the Chicago Bulls and Larry Bird of the Boston Celtics were the only two characters in the game, which allowed the player to participate in a one on one basketball game. Mini-games included a slam dunk contest (utilizing Jordan) and a three point contest (utilizing Bird).', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 536, 'game_title' => 'Jungle Strike', 'release_date' => '1993-12-16', 'platform' => 18, 'overview' => "Some time after Operation Desert Strike, Ibn Kilbaba, son of Kilbaba S.R, threatens to annihilate America. After his father was killed, the people who were under his control, sent his son running off, along with his father's money and nuclear weapons program. Kilbaba, more ruthless than his father, longs for revenge of his father's death and decides to shed the blood of those who killed him, the Americans. Already armed, Kilbaba hires Carlos Ortega to help him set up his Nuclear Weapons program, deep in South America. Carlos Ortega, the world's most notorious druglord, also yearns to seek revenge. With his own private army, armed with the most hi-tech weapons, he's ready to fight America at all costs. \r\n\r\nBecause of this threat, you're hired again to battle these two characters, following their paths in the jungles of South America. Armed with the Commache, numerous other vehicles, and destructive weapons, you must take out their private army. Blow up the enemy with your hellfires, hydras, chain guns. Use the watercraft to launch mines at enemy ships. Pull off a drive-by on the enemy with guns on the side. Take out the evil duo and forever rid this threat.....in the jungle!", 'youtube' => 'fdJ8XtuJBuU', 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [3834], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 537, 'game_title' => 'Jurassic Park', 'release_date' => '1993-08-26', 'platform' => 18, 'overview' => 'Plunge into a heart-wrenching race for survival! On a tropical island, a violent hurricane rips through the dinosaur preserve, trapping the tourists and freeing the most terrifying animals in prehistory! Two bigger-than-life ways to play: Be a dinosaur! As a Raptor, rampage across the island battling other beasts and eluding the traps and weapons of your human enemies. As Grant, the paleontologist, arm yourself with tranquilizer guns, and sleeping-gas grenades. Dodge the slashing jaws of the Tyrannosaurus Rex and the paralyzing spit of the Dilophosaurs! 16 mammoth megs of nerve-shredding action!', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 538, 'game_title' => 'King Salmon: The Big Catch', 'release_date' => '1993-03-21', 'platform' => 18, 'overview' => "King Salmon: The Big Catch is a fishing competition simulator: a player has to spend a day fishing for king salmon. Activities simulated include driving a boat to choose the best place to fish, choice of lures, line lengths, fishing depths, driving a boat to troll for salmon and, finally, pulling the caught fish out. The objective is to overcome some fictional fishermen, played by computer, in terms of the fish caught.\r\n\r\nGame also includes simple role-playing elements, as player's skill improve with time and experience and it's possible to catch bigger and better fish successfully.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [9344], 'genres' => [1, 11], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 539, 'game_title' => 'Klax', 'release_date' => '1990-09-06', 'platform' => 18, 'overview' => 'Klax features a conveyor belt at the top of the screen. It constantly rolls toward the playing area, delivering a steady supply of blocks. The player controls a small device which sits at the interface between the conveyor belt and the playing area, and can be moved left and right to catch the blocks and either deposit them in the playing area or push them back up the conveyor belt. The device can hold up to five blocks. A block which is not caught and placed in the playing area or pushed back up the belt is considered a drop. The blocks are solid colours, but there is also a flashing block which can be used as a wildcard on any colour.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [8654], 'genres' => [5], 'publishers' => [111], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 540, 'game_title' => 'Landstalker', 'release_date' => '1992-10-29', 'platform' => 18, 'overview' => "Eons ago, evil King Nole tyrannized the mythical island of Melcatle. With an insatiable greed for power and wealth, he crushed the people with heavy taxes while destroying their freedom. At last, in fury, the enslaved citizens stormed the palace. But King Nole was gone! And with him, the vast treasure, stolen from his subjects!\r\n\r\nNow Nigel, the Landstalker, journeys to this fantastic realm in search of the legendary fortune and power to reunite a divided kingdom!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1685], 'genres' => [1, 4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 541, 'game_title' => 'Last Action Hero', 'release_date' => '1993-12-10', 'platform' => 18, 'overview' => "Last Action Hero blasts you out of the real world - onto the silver screen - and back again, in a non-stop action-adventure based on the epic fantasy feature starring Arnold Schwarzenegger. As movie hero Jack Slater, you'll team up with your biggest fan, Danny Madigan, who's got a magic movie ticket that's the ticket to serious trouble. Leaping between both the movie world and the real world with this magic ticket, you'll get into wild chases and deadly fights with the most dangerous criminals imaginable. Last Action Hero delivers all the excitement of the Schwarzenegger film with just one difference... you're the star! But this time, you must ultimately defeat the arch henchman Benedict to ensure a happy ending.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [1098], 'genres' => [1], 'publishers' => [77], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 542, 'game_title' => 'Lethal Enforcers II: Gunfighters', 'release_date' => '1994-01-01', 'platform' => 18, 'overview' => "You are the sheriff of a town set in the old Wild West. Using the control pad or Konami's own Justifier lightgun, you'll be taking out outlaws who are robbing banks and kidnapping innocents. You have the opportunity to upgrade and keep you gun, as long as you don't shoot the people you are trying to save.\r\n\r\nThe action is usually shown on a single screen with enemies \"popping out\" from various sections. If you do not shoot them in time they will either shoot or throw various weapons at you. You will lose energy if they hit you or you hit an innocent civilian.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [4765], 'genres' => [8], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 543, 'game_title' => 'Lightening Force: Quest for the Darkstar', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => "You must lead the battle against the evil Lohun Empire. Their computer system is poised to destroy your Galaxy Federation's defenses. Lead the attack on their heavily defended military planet. Knock out the planet's command center to pave the way for the invasion force. Take the fight underwater to destroy massive marine battlecruisers. Launch magnetically-charged photon blasts at alien bio-machines. Twist through the labyrinthine structure of the enemy's Bio-Base. There you'll meet your final objective, the destructive regenerating computer. Cut loose with the Thunder Sword, your most powerful energy beam, as you battle this ultimate weapon!", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [8609], 'genres' => [8], 'publishers' => [137], 'alternates' => ['Thunder Force IV'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 544, 'game_title' => 'The Lost Vikings', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => 'In the game, the three Vikings get kidnapped by Tomator, emperor of the alien Croutonian empire, for an inter-galactic zoo and become lost in various periods of time. The purpose of the game is to control the three characters (who all have separate abilities) in order to solve puzzles to escape and get back home.', 'youtube' => '', 'players' => 3, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7729], 'genres' => [5], 'publishers' => [62], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 545, 'game_title' => 'Lotus II', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "Licensed by the classic British car company, this game featured 2 modes of play - one has you racing against 19 computer rivals (with witty names such as Alain Phosphate and Crash-Hard Banger), and the other pits you against the clock. \r\n\r\nThere are 13 different types of races, ranging from Motorways to night-time to sections punctuated by roadworks, and some are lap-based with others being simple A-B. 2 players could play on a split screen mode.\r\n\r\nThe game's crowning glory, however, was the RECS editor, which allowed you to create courses of your own, with theoretically millions possible.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [5190], 'genres' => [7], 'publishers' => [2], 'alternates' => ['Lotus II: R.E.C.S'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 546, 'game_title' => 'Lotus Turbo Challenge', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => 'This sequel to Lotus Esprit Turbo Challenge is again a behind-the-car viewed racing game. It takes place in eight distinct circuits, adding surface and weather effects such as desert and snow. Later in the game, you must race through two-way motorways with oncoming traffic, (incorporating civilian cars and trucks), and face tough levels aided by speed and time boost pick-ups.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [5190], 'genres' => [7], 'publishers' => [2], 'alternates' => ['Lotus Turbo Challenge 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 547, 'game_title' => 'Vectorman 2', 'release_date' => '1996-11-15', 'platform' => 18, 'overview' => "After saving Earth from Warhead in the previous game, VectorMan's sludge barge is targeted and destroyed by a missile. VectorMan escapes, parachuting down to the planet to battle with the Earth's multitudinous enemy; mutant insects. Now it is up to VectorMan to fight through the mutant bugs and find the most fearsome source infestation; the evil Black Widow Queen.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [1, 8, 15], 'publishers' => [15], 'alternates' => ['VectorMan 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 548, 'game_title' => 'Star Control', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => 'Star Control is a science-fiction wargame which pits the forces of the Alliance of Free Stars against those of the predatory Ur-Quan Hierarchy. The games are designed so that you can ease into play, familiarizing yourself with menus, options and player controls. The Alliance and Hierarchy each possess different types of warships. Each vessel has its own maneuvering and firing characteristics, plus a unique special power that you can employ when circumstances dictate.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [8978], 'genres' => [1, 6], 'publishers' => [139], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 549, 'game_title' => 'Super Battleship', 'release_date' => '1993-02-18', 'platform' => 18, 'overview' => 'Super Battleship is a Board game, developed by Synergistic Software and published by Mindscape Inc., which was released in 1993.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8399], 'genres' => [6], 'publishers' => [90], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 550, 'game_title' => 'The 3rd Birthday', 'release_date' => '2011-03-29', 'platform' => 13, 'overview' => "Hideous creatures descend on Manhattan. Ground reports from the squad tasked with containing the pandemonium refer to these life forms as the Twisted. An investigatory team known as the CTI is formed within the year.\r\nThe Overdive system emerges as a means of opposition, but only one viable candidate exists -- Aya Brea. A gift as she awakens from a lost past on this, the occasion of her third birth.", 'youtube' => 'kJtyPeekYR0', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3809], 'genres' => [1, 2], 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 551, 'game_title' => 'Metal Gear Rising: Revengeance', 'release_date' => '2014-01-09', 'platform' => 1, 'overview' => "METAL GEAR RISING: REVENGEANCE takes the renowned METAL GEAR franchise into exciting new territory by focusing on delivering an all-new action experience unlike anything that has come before. Combining world-class development teams at Kojima Productions and PlatinumGames, METAL GEAR RISING: REVENGEANCE brings two of the world's most respected teams together with a common goal of providing players with a fresh synergetic experience that combines the best elements of pure action and epic storytelling, all within the expansive MG universe. The game introduces Raiden as the central character; a child soldier transformed into a half-man, half-machine cyborg ninja, equipped with a high-frequency katana blade and a soul fueled by revenge.\r\n\r\nIn the near future, cyborg technology has become commonplace throughout society. Three years have passed since the collapse of the Patriots system that had been secretly controlling the global power balance from the shadows. However, peace remains elusive. The dissemination of cybernetic technology has triggered instability and conflict as those who control the trade gain increasing power. Furthermore, large 'Private Military Companies', or PMC's, that had been supported and controlled by the Patriots have collapsed, spawning countless rogue entities with origins to larger criminal organizations. These renegade PMCs employing cyborg technology have become increasingly more disruptive shifting policy and power at will. As a member of the peace-keeping PMC 'Maverick Security', Raiden lives by the mantra of protecting and saving lives. But as the world plunges further into asymmetric warfare, the only path that leads him forward is rooted in resolving his past, and carving through anything that stands in his way.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1829], 'genres' => [1], 'publishers' => [140], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 552, 'game_title' => 'Ninja Gaiden Sigma', 'release_date' => '2007-07-03', 'platform' => 12, 'overview' => "As Ryu Hayabusa you are out to seek revenge after your clan is massacred by the Vigor Empire. Realistic battle actions and acrobatic ninja moves are at your finger-tips. You play with only your wits, your ninja skills, and your deadly sword. Slice down opponents in the Vigor Empire as you attempt to beat the Holy Emperor and reclaim the magic sword \"Ryuken\". Bringing the classic to the PlayStation 3, Ninja Gaiden Sigma is a more \"complete version\" of the Xbox Team Ninja title, with new moves, actions, and weapons for Hayabusa. Also added is a new playable character -- Racheal, one of the series' heroines, will be playable, and when using her, you'll get to experience the storyline from her perspective (with new cutscenes, attack moves and more.)", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [8563], 'genres' => [1, 2], 'publishers' => [24], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 553, 'game_title' => 'Hoshigami: Ruining Blue Earth', 'release_date' => '2001-12-20', 'platform' => 10, 'overview' => "Utilizing a host of new gameplay elements, Hoshigami: Ruining Blue Earth expands upon the formula made popular by the cult classic Final Fantasy Tactics. The continent of Mardias serves as the game's primary world, and is divided into three kingdoms: Nightweld, the Valaimian Empire and Gerauld. The story begins as Valaimian troops advance into Nightweld, a peace-loving kingdom. Lacking the military might to repel the invaders from multiple fronts, Fazz - a mercenary and the game's protagonist - is hired to defend the Tower of Wind. Needless to say, this is just the beginning of a dire and perilous journey for the unwitting Fazz.\r\n\r\nAs you and your party trek across the world map, you'll take part in various battles. Ready-for-Action Points (RAP) determine which, as well as the number of actions that can be performed by a particular character. The more actions performed (and thus, more RAPs expended) during a turn, the longer you'll have to wait for your next chance to act. When attacking, an interactive gauge appears that does damage based upon where the slider is stopped. Stopping it at the very end will result in greater damage dealt to the enemy. Wait too long however and the slider will return to the beginning.", 'youtube' => 'PZFinnczjyI', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5319], 'genres' => [4, 6], 'publishers' => [58], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 554, 'game_title' => 'Iron & Blood: Warriors of Ravenloft', 'release_date' => '1996-10-31', 'platform' => 10, 'overview' => "An axe-wielding medieval mother wants your heart on a stick... An armored killing machine wants his mace in your head... A feracious fiend wants his claws in your charred corpse... Either way, you're facing eternity on the edge of a rusty blade.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8465], 'genres' => [10], 'publishers' => [28], 'alternates' => ['Advanced Dungeons & Dragons: Iron & Blood: Warriors of Ravenloft'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 555, 'game_title' => 'Kartia: The Word of Fate', 'release_date' => '1998-07-31', 'platform' => 10, 'overview' => 'After numerous wars, peace was brought to the land by the power of Kartia... Yet, in this peaceful land, evil desires lived within the hearts of the people. This is the story of a boy and girl who courageously lived through this chaotic era...', 'youtube' => 'PYBwvgKehtA', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [771], 'genres' => [4, 6], 'publishers' => [141], 'alternates' => ['Legend of Kartia', 'Rebus'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 556, 'game_title' => "King's Field II", 'release_date' => '1996-10-31', 'platform' => 10, 'overview' => "King's Field II--the hour of destiny is at hand... Your kingdom is once again under attack by the ruthless minions of evil. This time they have possessed King Alfred himself! As the King's son, Prince Lyle, you must bring forth the tide of change that will effect the universe from now until the end of time. The fate of the world is in your hands!\r\n\r\nRe-enter the realm of King's Field for the most explosive debut on the PlayStation yet... ASCII Entertainment went all out to provide a fully non-linear three dimensional world that even blows away the original! The intense action and powerful storytelling will keep you riveted for months!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [3192], 'genres' => [2, 4], 'publishers' => [142], 'alternates' => ["King's Field III (Japan)"], 'uids' => nil, 'hashes' => nil },
    { 'id' => 557, 'game_title' => 'Klonoa Beach Volleyball', 'release_date' => '2002-04-25', 'platform' => 10, 'overview' => "Invite your friends to join in the fun and play at THE volleyball party!\r\n\r\nGo head-to-head with Klonoa or one of his friends in this exciting seaside sport! Everyone is sure to hae a very good time. But watch out for those super attacks!\r\n\r\n-Play as Klonoa, Popka, Heart Moo, Lolo and even Joka too!\r\n-Lots of fun to pick up and play, on your own or with your friends.\r\n-Perfect your serve, toss and blocking skills", 'youtube' => 'ql3TnobfomA', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5804], 'genres' => [11], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 558, 'game_title' => 'Klonoa: Door to Phantomile', 'release_date' => '1997-03-10', 'platform' => 10, 'overview' => "Explore a magical world of mystery and adventure. Join Klonoa on a fantastic journey in the land of Phantomile, where the mysterious crash of a flying ship starts an epic quest through colorful worlds of thrills and danger.\r\n\r\nYou're never lost in this 3-D world. Klonoa's \"Guided 3-D\" construction gives players a vast 3-D world without the aimless and wandering feel of many other 3-D action games.\r\n\r\nBeautiful graphics and entertaining puzzles add a whole new level of fun & challenge.\r\n\r\nMultiple, forked paths add extra replay value - just remember that shortcuts aren't always what they seem!", 'youtube' => 'h8PsLF8vnzU', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5804], 'genres' => [15], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 559, 'game_title' => 'Legacy of Kain: Soul Reaver', 'release_date' => '1999-08-16', 'platform' => 10, 'overview' => "Soul Reaver is a third-person perspective action game with puzzle-solving and some platforming elements. The game follows Raziel on his quest to purge the land of vampires and take revenge on Kain and his brothers, leaders of the six clans. The player views the environments from behind Raziel's shoulder, moving him in any direction, climbing, attacking, jumping and using specific abilities. Raziel's can grip onto the edge of ledges and his torn wings allow him to glide gently downwards. He can also shift through the \"material\" world into the \"spectral\" realm at will, but must find specific locations in order to shift back. The two realms mirror one another, with distortions which give access to new areas and platforms. Existing in the material world drains Raziel's life energy at a constant rate.", 'youtube' => 'V9CB2RQ1Mec', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1963], 'genres' => [1], 'publishers' => [26], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 560, 'game_title' => 'Legend of Mana', 'release_date' => '2000-06-07', 'platform' => 10, 'overview' => "Create Your World\r\nIn ancient times, the world was saved from destruction by sealing locations and events within magical artifacts. Now, you have the chance to recreate this world as you desire by discovering artifacts, placing them, and exploring the mysteries inside.\r\n\r\n-Construct a unique world map and story by carefully placing artifacts.\r\n-Explore areas in any order, encountering nearly 70 different gameplay scenarios.\r\n-Battle enemies in real-time with special attacks and customizable controls.\r\n-Control every aspect of your new world: raise faithful net monsters, create powerful golems, forge mighty weapons, and refine magical instruments.\r\n-Adventure with a friend by having them import their Legend of Mana character from a MEMORY CARD, or take control of an NPC .", 'youtube' => 'voXZwYb3Xa8', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [1, 4], 'publishers' => [11], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 561, 'game_title' => 'Lethal Enforcers I & II', 'release_date' => '1997-01-01', 'platform' => 10, 'overview' => "Plug in a light gun and dispense justice in LETHAL ENFORCERS I & II. In LETHAL ENFORCERS I, you must put a stop to an evil plot involving organized crime. You’ll blast mafia hit men and explore a modern urban landscape, which includes docks and a Chinatown district.\r\n\r\nIn LETHAL ENFORCERS II, you’re thrust into the Old West and must take on stagecoach thieves and cattle rustlers. Both games feature digitized graphics that make all of the bad guys look as real as possible. If you don’t happen to own a light gun, the standard controller is also supported. If you are looking for old-school shooting action, you should try LETHAL ENFORCERS I & II.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4765], 'genres' => [8], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 562, 'game_title' => 'Marvel Super Heroes', 'release_date' => '1997-01-01', 'platform' => 10, 'overview' => "There are ten playable characters. The heroes are Captain America, The Incredible Hulk, Iron Man, Psylocke, Spider-Man and Wolverine. The villains are Blackheart, Juggernaut, Magneto and Shuma-Gorath. Anita from the Darkstalkers series is a hidden character in the Japanese version. The bosses are Doctor Doom and Thanos. During the boss fight Thanos steals all the player's gems (except for mind) and uses them with new effects.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [10], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 563, 'game_title' => 'Mass Destruction', 'release_date' => '1997-09-30', 'platform' => 10, 'overview' => "Played from an overhead 3D third-person perspective, the game is divided into four areas. Areas consist of a variety of mission objectives that must be completed; in addition to primary missions, some include secondary objectives. While primary objectives (24 in all) must be completed in order to claim victory for the overall mission, secondary objectives act as additional bonus points. There are also bonus and hidden objectives that award the player with bonus points. By completing hidden objectives, you'll be rewarded with new missions!\r\n\r\nMass Destruction requires one memory card block for saving game data and supports analog controls. So get in there and destroy anything that moves!", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6103], 'genres' => nil, 'publishers' => [83], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 564, 'game_title' => 'MDK', 'release_date' => '1998-11-30', 'platform' => 10, 'overview' => "MDK is a 3rd person action/shooter game in which the objective is to basically shoot everything that moves in six massive cities, each with their own sublevels. Because the world is being invaded by aliens, it is up to you and your sidekick Bones to stop the invasion and single handedly save Earth. In order to do so, you must make good use of your special suit, which allows you to do all kinds of things.\r\n\r\nThe super-suit comes equipped with many features you'll need to utilize in your journey, such as the sniper helmet. This allows you to zoom in on unsuspecting enemies and fire off shots with pinpoint accuracy. There is also a built in parachute (a ribbon-like device) that enables you to glide between different platforms as well as drop down on intruders.\r\n\r\nYour suit comes equipped with a chain gun that has an infinite supply of ammunition. You can also pick up special items, like a miniature nuclear bomb and powerful upgrades for your chaingun. In addition to running around and shooting, there are also special means of transportation including a surfboard-like jet and a bomber plane that is used to call in air strikes.", 'youtube' => '1wW4lQgnriQ', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7663], 'genres' => [1, 8], 'publishers' => [144], 'alternates' => ['M.D.K.', 'mdk'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 565, 'game_title' => 'Mega Man 8', 'release_date' => '1996-12-17', 'platform' => 10, 'overview' => "A gigantic space explosion sends two strange meteors crashing to Earth. The call goes out and Mega Man speeds to the site. There he sees his arch-rival, Dr. Wiley, fleeing the scene, clutching one of the mysterious metallic meteors. Now Mega Man must uncover the secret of the second meteor in a race to stay one step ahead of Dr. Wiley and his new deadly breed of super-powered robots.\r\n\r\n• Battle across 14 huge stages to face eight devious new enemies.\r\n• Multiple upgrades for Mega Man - customize to your specifications every game.\r\n• Intense Japanese anime intros, cut scenes and cinema screens.\r\n• Incredibly fluid animation and highly detailed backgrounds.", 'youtube' => 'yFGRDgQpkQk', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Rockman 8: Metal Heroes'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 566, 'game_title' => 'Mega Man Legends', 'release_date' => '1998-08-31', 'platform' => 10, 'overview' => "THE BLUE BOMBER BLASTS INTO A WHOLE NEW DIMENSION\r\n\r\nMega Man blasts his way into the third dimension in an amazing new adventure. Mega Man Legends combines the best of classic Mega Man action with enormous bosses, a riveting storyline and all the depth of the hottest RPG.\r\n\r\nExplore vast 3-D worlds in your quest to find the treasure of all treasures, the Mother Lode. You'll love the new 3-D graphics, deadly weapons and non-stop action... unless of course, you're a boss.\r\n\r\n* Awesome Weapons!\r\n* Diabolical Bosses!\r\n* Legendary Gameplay!\r\n* Non-Stop 3-D Action!", 'youtube' => 'yX5x3zJEWog', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1, 2, 4], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 567, 'game_title' => 'Mega Man X4', 'release_date' => '1997-08-10', 'platform' => 10, 'overview' => "X-PLOSIVE GAMEPLAY.\r\nX-TREME GRAPHICS.\r\nMEGA MAN X4!\r\n\r\nVibrant Animation • Relentless Enemies\r\nUnsurpassed Graphics • Hidden Secrets\r\nMega Man X4 bombards the PlayStation game console and never lets up!\r\n\r\nBattle armies of Maverick Reploid Robots while mastering all-new strategic moves like the Air Hover and Zero's Saber Tactic system. Discover a myriad of power-ups, secret rooms, extra weapons and invincible vehicles to take on 8 all new X-Hunter Bosses. And for the first time, play as Mega Man X or battle with his mighty partner Zero in 2 separate adventures. Mega Man X4 - now you can be a hero, or a Zero!\r\n\r\n* Now, play as Mega Man X or Zero!\r\n* New X-Hunter levels with vivid color, brilliant detail, intricate passages, secret rooms and hard-to-reach items\r\n* Invincible vehicles like the Land Chaser superbike and other robot ride armors", 'youtube' => 'https://www.youtube.com/watch?v=F2JF-jVkLJ0', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['Rockman X4', 'Megaman X4'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 568, 'game_title' => 'Mega Man Battle & Chase', 'release_date' => '1998-11-30', 'platform' => 10, 'overview' => "It's robot mayhem at the Battle & Chase tournament! Dr. Wily is trying to take over the tournament with his army of Robot Masters, and now Mega Man has to enter to try and save the races! Choose your racer and head out on the tracks, and if you win, you'll get to steal parts off your opponent's cars, and eventually, you'll race against the mad Dr. Wily himself!", 'youtube' => '1v3avhAov18', 'players' => 2, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => ['RockMan: Battle & Chase'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 569, 'game_title' => 'MLB 2000', 'release_date' => '1999-02-28', 'platform' => 10, 'overview' => 'This game is basically an update to MLB 99 with a few new features. The game contains depictions of the real teams, stadiums, stats, and players that reflect their real life counterparts. The modes returning from the previous game include quick play, season, playoffs, spring training, and home run derby. One of the new modes is general manager mode. In this mode, players can draft, create, trade, call up, waive, release, and sign players. Another new mode is the manager mode. In this mode, players can check out scouting reports during the game, warm up relievers in the bullpen, and try to get their team to the World Series and hopefully win it.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7986], 'genres' => [11], 'publishers' => [21], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 570, 'game_title' => 'Monkey Magic', 'release_date' => '1997-11-27', 'platform' => 10, 'overview' => "Based on the cartoon series, this 2D side-scrolling action game (with 3D elements) has you seeking out Master Subodye to learn the four magic spells: fire, freeze, shrink and strength. Use these powers in over 30 worlds (five levels featuring 28 scenes and 16 opponents) to gain items like the Power Rod in order to survive the game. Then travel the world to gain other magical items and defend your monkey friends from, well, everybody.\r\n\r\nWith a playful spin on one of the great Asian folk tales, Sunsoft's Monkey Magic is filled with martial arts moves, environments and exotic, Eastern melodies. Can you set a world right when it doesn't want to be corrected? Are you \"monkey\" enough to survive the attacks of gods and monsters? You bet your prehensile tail you are!", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [865], 'genres' => [1], 'publishers' => [75], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 571, 'game_title' => 'Monsterseed', 'release_date' => '1999-03-31', 'platform' => 10, 'overview' => "Monster Seed obviously takes influence from the popular animal raising/fighting genre; specifically games like Pokémon and Monster Rancher. Of course, it does do a few things differently. One major difference is the fantasy setting. No ranches or medical settings here, no sir. Another key difference is in the overall presentation; Monster Seed's gameplay and interface are a lot more simple than most other breeding games.\r\n\r\nSimilar to mother games in the genre, there's a brief tutorial of sorts, and then you're off to gather your own creatures, earning better seeds and other breeding components as you go. Just be careful with your critters, because if they die in battle, they're gone for good. Granted you can always breed more, but it can certainly set you back if your creature hatches at level five, but you lost a level twelve.", 'youtube' => 'VYpblBSbt-c', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6097], 'genres' => nil, 'publishers' => [75], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 572, 'game_title' => 'NASCAR 99', 'release_date' => '1996-09-30', 'platform' => 10, 'overview' => 'NASCAR 99, the arcade-style racing game from EA and Stormfront Studios. In addition to 2-player simultaneous racing the game featured 37 officially licensed cars and 17 tracks, as well as the voices of Bob Jenkins and Benny Parsons commentary. Using the Andretti Racing engine, NASCAR 99 was EAs first entry into NASCAR racing for the Nintendo 64 and and Playstation.', 'youtube' => 'Q3eRDPh_Mso', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8219], 'genres' => [7], 'publishers' => [2], 'alternates' => ['NASCAR 99: Legacy'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 573, 'game_title' => 'NASCAR Racing', 'release_date' => '1996-09-30', 'platform' => 10, 'overview' => "The game presents three different game modes: Arcade Race, Simulation Race, and Simulation Testing. While the Arcade Race mode let's the player jump right into the fray after choosing their difficulty level (either rookie,veteran, or ace), the Simulation Race mode features a lot more customization options for the player to take into consideration.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6417], 'genres' => [7], 'publishers' => [145], 'alternates' => ['NASCAR Racing Season 96'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 574, 'game_title' => 'NBA Basketball 2000', 'release_date' => '1999-10-31', 'platform' => 10, 'overview' => "Updated with stats, rosters and player ratings for the 1999-2000 season, NBA Basketball 2000 features every player from all 29 NBA teams, plus two all-star and rookie teams. You can play an entire NBA season or skip ahead to the playoffs. If you're not ready for team ball, you can go one-on-one with your favorite pros on an outdoor court. Real Fox Sports announcers including former Atlanta Hawks point guard Doc Rivers, call the action.\r\n\r\nUsing one or two Multi Tap adapters, up to eight players can join in a single game of NBA Basketball 2000. Along with the standard head-to-head game, you can play on the same team against the computer with up to five players, each controlling a different hoopster. Or you can play on rival teams with each gamer controlling a different basketball player.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6942], 'genres' => [11], 'publishers' => [132], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 575, 'game_title' => 'NBA In The Zone 2', 'release_date' => '1996-11-30', 'platform' => 10, 'overview' => "Get ready to run the floors with NBA In the Zone 2 from Konami. After last years title, Konami has stepped up and added new features to ITZ2 to make it the best possible basketball game. Featuring different play modes such as exhibition and full season play, as well as containing full rosters for all the NBA teams and the ability to make substitutions, ITZ2 is loaded.\r\n\r\nAlso beefed up is the AI. Not only will it be harder to drive to the basket, gamers have a greater chance of getting fouled-out, with increased foul elements such as offensive fouls and basket-count. So step on the court and get ready for some solid b-ball action.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [11], 'publishers' => [23], 'alternates' => ['NBA Power Dunkers 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 576, 'game_title' => 'NBA Live 98', 'release_date' => '1997-11-30', 'platform' => 10, 'overview' => 'NBA Live 98 is the 1998 installment of the NBA Live video games series. The cover features Tim Hardaway of the Miami Heat. The game was developed by EA Sports and released on November 11, 1997. The PlayStation version has network announcer Ernie Johnson and play-by-play announcer Verne Lundquist.', 'youtube' => '', 'players' => 8, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 577, 'game_title' => 'NBA Live 99', 'release_date' => '1998-10-31', 'platform' => 10, 'overview' => 'NBA Live 99 is the 1999 installment of the NBA Live video games series. The cover features Antoine Walker of the Boston Celtics. The game was developed by EA Sports and released on October 31, 1998 for the Windows and PlayStation, then in November 4, 1998 for the Nintendo 64. Don Poier is the play-by-play announcer. It was the first NBA Live game released for Nintendo 64. NBA Live 99 is followed by NBA Live 2000.', 'youtube' => '', 'players' => 8, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 578, 'game_title' => 'NBA Live 2000', 'release_date' => '1999-10-28', 'platform' => 10, 'overview' => "The NBA Live series of basketball video games, published by EA Sports, is currently one of the leading National Basketball Association simulations on the market.\r\n\r\nStarting from NBA Live 2000, the series featured NBA Live Legend All-Stars Teams, that included some biggest names from five decades (50s to 90s). These teams could be used instantly, but to use the players as regular players (e.g. traded, played on regular NBA Teams) they needed to be unlocked. Along the series, some of the rosters were changed due to many reasons as Michael Jordan was on the 90's team through 2004.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'E - Everyone', 'developers' => [2590], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 579, 'game_title' => 'NBA Showtime: NBA on NBC', 'release_date' => '1999-10-31', 'platform' => 10, 'overview' => "The NBA like you've never seen it before! NBA Showtime: NBA on NBC brings you the top players from each team in a heart-pounding, pulse-racing above-the-rim match-up! You'll see the intensity on their faces and hear it in their voices, you'll feel the power of every pass and every shot! This is what the NBA is all about! Go for rebounds and 3-pointers in all 28 arenas around the league. Choose from over 130 real NBA players plus hidden characters!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2886], 'genres' => [11], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 580, 'game_title' => 'The Next Tetris', 'release_date' => '1999-05-31', 'platform' => 10, 'overview' => "The Next Tetris is not only based on the original Tetris, which was created by Russian designer Alexey Pajitnov back in the mid- to late-1980s, it actually includes a copy of the original game, complete with enhanced graphics and sound. As most people know, Tetris is a game in which you maneuver falling blocks of seven different shapes into unbroken horizontal lines. When a line is created, the blocks in that line (or lines) disappear from the screen. Your job is to keep the pile of blocks from reaching the top of the playfield.\r\n\r\nThe Next Tetris mode of play introduces several new elements to the Tetris universe. The block-maneuvering action remains, but special multi-colored puzzle pieces that can separate and fall when they land enter the mix. Also, blocks above cleared lines will fall to spaces below, possibly setting up a chain reaction, which in this game is called a Cascade.", 'youtube' => 'pAkykYIYVpk', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1229], 'genres' => [5], 'publishers' => [30], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 581, 'game_title' => 'NFL Blitz 2000', 'release_date' => '1999-07-31', 'platform' => 3, 'overview' => "It's back and it's better than ever! NFL Blitz 2000 adds 4-player support, new offensive and defensive plays, realistic weather conditions, new stadiums and a Tournament mode! Customize offensive and defensive plays to your liking. Call audibles at the line of scrimmage. You've got control now! Passing made easy with new \"Blitz Passing\" for one-touch long bombs! \"ON-FIRE\" mode gives super power performance to your players! With non-stop action and a \"pick-it-up-and-play\" learning curve, NFL BLITZ 2000 is THE game for every football fan!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5507], 'genres' => [11], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 582, 'game_title' => 'NFL Blitz 2001', 'release_date' => '2000-09-14', 'platform' => 10, 'overview' => "Who needs rules? This version of the offensively minded NFL BLITZ is even more fast-paced, action-driven, and penalty-free than its ancestors. Using an amazingly intuitive controller configuration, BLITZ keeps it as simple as possible. It's all about excitement, as you choose between 27 effective offensive plays and nine defensive sets for your NFL franchise. The teams are all here, but reality has flown out the window, as you rip off helmets, throw punches, and dive at kickers. New features include individual stats based on NFL performance, new player animations, updated stadiums, multiplayer options in Season mode, better AI, new rants from the BLITZ announcer, and a cool new soundtrack. The highlight of the additions, however, has to be the Party Games mode, which allows up to four players to compete in crazy football challenges. In \"1st and Goal Frenzy,\" you have four downs to score on your opponent; \"Goal Line Stand\" reverses the scenario and has you defending for four downs; and \"Quarterback Challenge\" has you passing at specific targets. Oh, and there's one more thing new cheerleaders.", 'youtube' => 'ivCDDvPt09c', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5512], 'genres' => [11], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 583, 'game_title' => 'NFL GameDay 99', 'release_date' => '1998-07-31', 'platform' => 10, 'overview' => "NFL GameDay 99[edit]\r\nNFL GameDay 99 was the fourth game in the NFL GameDay series. It was released July 31, 1998 on the PlayStation, and August 31, 1998 on the PC, both by 989 Sports. On the cover is Terrell Davis.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => nil, 'genres' => [11], 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 584, 'game_title' => "NFL GameDay '97", 'release_date' => '1996-11-30', 'platform' => 10, 'overview' => "Sony's football franchise carries on with another intense NFL match-up. In addition to all the features you expect from this series, GameDay '97 also includes new options like season-ending injuries, a full-fledged draft, more statistics, and the ability to create players. You'll also get expanded camera control, allowing you to place the camera at any angle. Every NFL team (over 1,500 players) and all stadiums are also included, letting you put your favorite team on the filed for some intense NFL action. But where the game really shines is in the gameplay. The control is deadly accurate, meaning diving catches are a distinct possibility. Making one-handed grabs, diving into the end zone, and even running out of bounds and slamming into the coach are also possible. And with a multitap seven of your friends can get in on the action.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7697], 'genres' => [11], 'publishers' => [520], 'alternates' => ['NFL Game Day 97'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 585, 'game_title' => 'NFL GameDay 98', 'release_date' => '1997-07-31', 'platform' => 10, 'overview' => "NFL GAMEDAY '98 is loaded with features like Preseason, Season, and Training Camp modes. You can also choose to play as a skill player, like wide receiver or fullback. And when you consider that you also get a play editor, a create-a-player feature, over 100 touchdown dances, and accurate player attributes, you'll realize why the GAMEDAY series is one of the best around. You can also take on your friends (up to eight with the multitap) in the Versus mode.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7986], 'genres' => [11], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 586, 'game_title' => 'NFL GameDay 2005', 'release_date' => '2004-08-01', 'platform' => 10, 'overview' => 'NFL GameDay 2005 was the tenth and final game in the NFL GameDay series, and unlike the last few GameDay video games, it was only available on the PlayStation console, and not on the PlayStation 2. It was released on August 1, 2004. On the cover is Derrick Brooks.', 'youtube' => 'Z8Scoq4XILc', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [135], 'genres' => [11], 'publishers' => [879], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 587, 'game_title' => 'No One Can Stop Mr. Domino', 'release_date' => '1998-10-31', 'platform' => 10, 'overview' => "No One Can Stop Mr. Domino is a puzzle game which sees you controlling the titular Mr. Domino (or one of his friends, if you prefer) as he zips around levels which can be best described as a racetrack. As the title suggests, you can't actually stop Mr. Domino - however, you can guide him around the track, speed him up and slow him down. He'll need to dodge obstacles as he aims to activate \"tricks\" which are placed around the board.", 'youtube' => 'xVnNQJOqJJI', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [651], 'genres' => [5], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 588, 'game_title' => 'Omega Boost', 'release_date' => '1999-04-22', 'platform' => 10, 'overview' => "Co-Existence between man and machine is no longer an option. The fate of humankind is hanging by a fiber... time is running out.\r\n\r\n-Pilot Omega Boost in a high-intensity action shooter across 19 diverse zones.\r\n-Multiple mission objectives, lethal ground and air assaults and deadly cyber-drogues.\r\n-Free-float in dizzying 360o combat.\r\n-Scan for targets, fire Vulcan guns and bag those bogeys with laser lock-on in the ultimate space dogfights!\r\n-Customize and upgrade equipment and weaponry with every win.\r\n-Review intense battles with the Replay Mode.", 'youtube' => '5-g-83_emKE', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6739], 'genres' => [1, 8], 'publishers' => [21], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 589, 'game_title' => 'Pandemonium!', 'release_date' => '1996-10-31', 'platform' => 10, 'overview' => "In the land of Lyr, there was a young sorceress called Nikki, a court jester called Fargus, and Fargus' stick-puppet Sid. They had gone to Lancelot Castle to attend a \"Wizards in Training\" seminar. Nikki, a talented acrobat with swift reflexes, had become irritated with her dull carnival life on the high-wire. After forgetting to feed the lions, and the trainer almost having his arm chewed off, she decided it was time to run away and become a wizard! Fargus and Sid had been spending their lives together traveling from fair to festival entertaining and embarrassing people here and there. Their act, however, was as old as the hills and usually turned into a bombardment of fruits and eggs. They, too, were a little tired of same old routine and had heard about the Wizards seminar.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8978], 'genres' => [15], 'publishers' => [27], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 590, 'game_title' => 'Parasite Eve', 'release_date' => '1998-09-09', 'platform' => 10, 'overview' => "THE CINEMATIC RPG\r\n\r\nOne of them is a police officer. The other is possessed by an ancient evil threatening all life on Earth. The horrifying bond between them will continue until something dies.\r\nA chilling adventure that could only come from the creators of Final Fantasy VII\r\nAn epic sci-fi tale told through stunning 3D rendered sequences\r\nBattle mutant monsters in real-time polygon combat\r\nCustomize weapons, armor, and character abilities", 'youtube' => 'BzXUUNpA9jw', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [8096], 'genres' => [4, 18], 'publishers' => [136], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 591, 'game_title' => 'Revelations: Persona', 'release_date' => '1997-10-25', 'platform' => 10, 'overview' => "In the near future, mankind has conquered dimensional travel but the door we have opened swings both ways. The peaceful city you have grown up in has become a haven for dark creatures from another world-Demons! Now it's up to you and your friends to harness the hidden power within you by entering the fantasy game known as Persona.\r\n\r\nYou awaken with incredible abilities that you will need to defeat the scores of Demon invaders and cleanse the land of their forces. Converse with them before doing battle to determine your best course of action. Fight them or enlist their aid in your mission. Either way, you are set for the fantasy adventure of a lifetime!", 'youtube' => 'fgi3V-7Vlow', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [771], 'genres' => [4], 'publishers' => [141], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 592, 'game_title' => 'Persona 2: Eternal Punishment', 'release_date' => '2000-12-22', 'platform' => 10, 'overview' => 'Welcome back to the twisted world of Persona, where nightmares become reality and reality becomes a nightmare... Over 50 hours of dark twisted gameplay, plus stunning anime cinematics that absorb you into the intriguing world of Persona! Enlist the help of the nightmarish denizens of Persona through the use of the unique "Contact System!" Unleash total devastation by combining over 80 Persona to defeat the minions of evil. Change the fate of your characters by employing the revolutionary "Rumor System."', 'youtube' => 'meQmQ7KxPlo', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [767], 'genres' => [4], 'publishers' => [58], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 593, 'game_title' => 'PGA Tour 97', 'release_date' => '1996-09-30', 'platform' => 10, 'overview' => "Players can choose to play as one of fourteen professional golfers such as Fuzzy Zoeller and Jim Gallagher Jr. or choose to create their own golfer by giving them a name and choosing what their golfer looks like from the few portraits that are available.\r\n\r\nPlayers are then able to select what type of game mode they want to play. Game modes include letting the player practice a round of golf, compete in a tournament, have a shoot-out, or compete in a Skins game.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 594, 'game_title' => 'Point Blank 2', 'release_date' => '1999-04-30', 'platform' => 10, 'overview' => "Point Blank 2 is the sequel to the now classic arcade game Point Blank, which was converted to the PlayStation in 1998. Using the Namco built GunCon (an arcade-like light gun), it offers 70 new shooting galleries, different party modes and a new single-player game.\r\n\r\nIf you're playing single-player, you have a few options from which to choose. The arcade mode is simply 16 rounds (of either beginner, advanced or insane difficulty) selected randomly from the 70 different shooting galleries. You'll get to shave sheep by shooting off their wool, test your accuracy in one-shot, one-hit bouts and save Dr. Don and Dr. Dan from wacky situations. There is also an endurance mode in which you climb a tall tower to see how far you can get in three tries.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5804], 'genres' => [8], 'publishers' => [39], 'alternates' => ['GunBarl'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 595, 'game_title' => 'Pong: The Next Level', 'release_date' => '1999-11-01', 'platform' => 10, 'overview' => "The classic videogame PONG is getting a 32-bit update. Players control a long, flat rectangular rod and maneuver it up and down the screen to defend their goal. The opponent is trying to direct the ball past you and into your goal the player who reaches the level's preset point total first wins the match. There are six zones filled with all kinds of PONG challenges, each with three distinct and increasingly difficult variations on that level. Most one-on-one games also include power-ups that you can collect, which will benefit you in some fashion against your opponent.", 'youtube' => '6JXHiWXvj4s', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8360], 'genres' => [1], 'publishers' => [146], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 596, 'game_title' => "PO'ed", 'release_date' => '1997-11-17', 'platform' => 10, 'overview' => "PO'ed is a first-person shooter with two simple objectives: escape the alien homeworld and kick lots of butt! There are 25 levels in all, each with a challenging array of horrific aliens to destroy, switch puzzles to solve, and platforming elements. Ox can either walk throughout the levels or utilize an ultra-powerful jetpack; use the latter in moderation as it's an important, yet limited tool.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [537], 'genres' => [1], 'publishers' => [113], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 597, 'game_title' => 'Powerslave', 'release_date' => '1997-02-28', 'platform' => 10, 'overview' => "An ancient evil force, neither of this time nor of this world, has remained buried since the Egyptians walked the earth. Now it has been exhumed. Of course, you, the hero, must find out what's going on in Egypt. Your helicopter crashes within this danger zone and you must survive on your own. Meet the Egyptian gods and follow their advice.\r\n\r\nExhumed for the Playstation and Saturn consoles was released as Powerslave in the United States.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5017], 'genres' => [8], 'publishers' => [144], 'alternates' => ['Exhumed'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 598, 'game_title' => 'Professional Underground League of Pain', 'release_date' => '1997-02-28', 'platform' => 10, 'overview' => "A combination of ice hockey, basketball, and bare-knuckle fighting, Professional Underground League of Pain is a futuristic sports game with few rules and loads of violence. The object of the game is to throw a plasma ball into a round goal that is suspended above the middle of a hockey-sized arena. Before you or your computer opponent can make a basket, the ball must be charged. Each team's charger is located in their opponents end of the court. Be careful, though: If the ball is charged with your opponent's color and you make a basket, your opponent gets the points. The same rule applies for the opposing team. There are different zones on the court and depending on where a player is standing when he makes a shot, he will score one, two, or three points.\r\n\r\nThere are sixteen different teams to choose from, representing the countries of England, France, the United States, Germany, Japan, Mexico, Australia, and Russia. Each team has four players on the court at once. Most of the action consists of passing, shooting, and stealing the ball, punching and sliding into your opponents, and a whole lot of running.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1016], 'genres' => [1, 11], 'publishers' => [135], 'alternates' => ['Riot'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 599, 'game_title' => 'R4: Ridge Racer Type 4', 'release_date' => '1999-05-04', 'platform' => 10, 'overview' => "\"R4 has to be the best-looking PlayStation racer ever (yes, edging out even Gran Turismo).\" – Official PlayStation Magazine, December 1998\r\n\r\n* 8 tracks, 45 unique car models, and over 300 different car variations.\r\n* Sensational graphics and lighting effects give every race a cinematic feel.\r\n* Battle head-to-head in the 2-player, split screen VS mode.\r\n* Experience all the ups and downs of a full racing season with your team in the Grand Prix Mode.\r\n* New cars awarded based on your performance in every race.\r\n* Design original logos to customize your car.", 'youtube' => 'rTnTnrxws2c', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5804], 'genres' => [7], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 600, 'game_title' => "Tom Clancy's Rainbow Six: Rogue Spear", 'release_date' => '1999-08-31', 'platform' => 10, 'overview' => 'Following the collapse of the Soviet Union in 1991, the economic situation in Russia and the former Eastern Europe falls into chaos. Terrorism in the region is commonplace as people fight a seemingly endless stream of battles for supplies and other necessities. In this power vacuum though a dangerous a situation arises: the Russian mafia has begun buying up surplus military equipment with the assistance of current members of the Russian Army. During one such arms deal Rainbow forces raid the meeting grounds and recover weapons grade plutonium, tracing the fissile material to a nearby naval base.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7097], 'genres' => [8], 'publishers' => [147], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 601, 'game_title' => 'Rampage 2: Universal Tour', 'release_date' => '1999-03-01', 'platform' => 10, 'overview' => "Your 3 favorite human-munching, badly-behaved mutants have been captured! Unfortunately, for the humans inhabiting planet Earth, brand new mutants have been sent to rescue George, Lizzy and Ralph. You'll meet Ruby the Lobster, Boris the Rhino and Curtis the Rate as they destroy cities in North America, Asia and Europe! Get ready for destruction, mayhem, alien exterminations and the best buffet in town - the people of Earth!", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => nil, 'developers' => [819], 'genres' => [1], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 602, 'game_title' => 'RayCrisis: Series Termination', 'release_date' => '2000-10-25', 'platform' => 10, 'overview' => "An ambitious and unethical scientist, a secret experiment gone horribly awry, and an artificially intelligent supercomputer gone mad; all the necessary ingredients for the imminent extinction of mankind. You are humanity's last hope, a hotshot pilot given the unenviable task of flying an experimental fighter into the dark heart of the Con-Human Network. Seize the controls of three Wave Rider spacecraft, each equippped with the WR-01 primary weapon array, WR-02 secondary lock-on laser system, and WR-03 single-use weapon for emergency situations. RayCrisis: Series Termination is the final entry in Taito's acclaimed trilogy of shooters, and it bombards your CRT with an abundance of fourth-generation optical stimulation: multilevel scrolling, transparency and lighting effects, and enough polygons to overload your cerebral cortex. Dodge, weave, and blast through two play modes, disintegrating wave after wave of relentless bogeys, to achieve high scores and unlock hidden bonuses. Prepare your senses, reinforce your nerves, and limber your trigger finger - the final assault has begun!", 'youtube' => 'MO9EelOPEAk', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8449], 'genres' => [1, 8], 'publishers' => [122], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 603, 'game_title' => 'Re-Loaded: The Hardcore Sequel', 'release_date' => '1996-12-01', 'platform' => 10, 'overview' => "MAMMA, BOUNCA, BUTCH, and CAP'N HANDS are back and have been joined by SISTER MAQPIE and THE CONSUMER in the roll-call of shame, blasting their way through huge blood soaked worlds to inflict brutal revenge on C.H.E.B., who is hell bent on universal domination. PREPARE YOURSELF for an even heavier dose of maximum annihilation across 6 enormous 3D levels of terrifying morphing terrain which will leave you shell shocked and powered up with an array of awesome machinery and death sequences. Your bloody path is fraught with enemies to obliterate and riddles to solve in your quest to save the universe - If Loaded was twisted, then Re-Loaded is twisteder!!!", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3620], 'genres' => [1], 'publishers' => [62], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 604, 'game_title' => 'Rhapsody: A Musical Adventure', 'release_date' => '2000-07-03', 'platform' => 10, 'overview' => "Follow the adventures of Cornet as she makes her way through Marl's Kingdom in search or her one true love. With the help of her trusty magical horn she enlists the help of many magical creatures along the way to battle the beautiful but evil Marjoly and her cohorts. Rhapsody is an epic RPG adventure that you'll never forget...\r\n\r\nIntuitive simulation-style battle system!\r\n\r\nUse magic spells such as the hilarious \"Pancake Attack\"!\r\n\r\nWonderfully illustrated anime characters and backgrounds!", 'youtube' => '5xD9ZxaMtbM', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6075], 'genres' => [4, 6], 'publishers' => [58], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 605, 'game_title' => 'Rugrats in Paris: The Movie', 'release_date' => '2000-10-29', 'platform' => 10, 'overview' => "Tommy Pickle's father has been sent to Europe for maintenance work at Euroreptarland. The Rugrats join him on his travel to Europe. There are 16 levels and hidden bonus level to play through.\r\n\r\nThe game consists of various mini-games that have to be completed in order to earn enough tickets to beat the game. Most tickets, however, can just be collected by running around the park and picking them up. Tickets can be used to buy prizes. There are ten mini games including whack-a-ninja, bumper cars and mini-golf.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [819], 'genres' => nil, 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 606, 'game_title' => 'SaGa Frontier 2', 'release_date' => '2000-01-31', 'platform' => 10, 'overview' => "Shape History or Be History\r\n\r\nSelect and control decisive moments during decades of royal conflict. Magic, revenge, and assassination will all play a part in determining who will obtain the country and the crown.\r\n\r\n-Create a unique history with Multi-Scenario System\r\n-Influence a variety of characters in an epic saga\r\n-Experience hand-painted watercolor artwork\r\n-Play Duel, Team, or Strategic battle modes\r\n-Choose from various, realistic sword maneuvers during combat\r\n-Form hundreds of possible combo attacks\r\n-Cast powerful and spectacular magic attacks", 'youtube' => '5kEr6kF2Hmc', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => ['SaGa Frontier II'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 607, 'game_title' => 'Skeleton Warriors', 'release_date' => '1996-01-01', 'platform' => 17, 'overview' => "As Prince Lightstar, players must defeat the Skeleton Warriors and Baron Dark in order to gain control of the Lightstar Crystal and bring balance back to the world. Gamers will explore the environments of 20 different levels as they face hundreds of enemies while riding on their skybike. The game features an original soundtrack composed by Tommy Tallarico.\r\n\r\nThe game is a 2D sidescrolling platform game with 3D pre-rendered graphics, with about 100 types of enemies for you to slay with the weapons you possess. You need to complete 21 levels filled with demonic evil creatures before you can fight the Baron Dark himself, with 3D rendered cutscenes inbetween some levels.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5926], 'genres' => nil, 'publishers' => [144], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 608, 'game_title' => 'Sled Storm', 'release_date' => '1999-07-31', 'platform' => 10, 'overview' => 'Sled Storm is a racing game featuring snowmobiles (referred to as sleds), stunts and fourteen snow-covered courses consisting of slippery slopes, inclement weather and treacherous cliffs. Up to four players can also participate at once, making this title one of the few racing games on the PlayStation (as of 1999) to feature split-screen action with more than two players. Sled Storm also offers two forms of racing for both multi-player and solo competition: Championship and Quick Race.', 'youtube' => 'U-R-zTBbZoY', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [7], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 609, 'game_title' => 'SnoCross Championship Racing', 'release_date' => '2000-08-22', 'platform' => 10, 'overview' => "Sno-Cross Championship Racing provides players with the opportunity to race 12 snowmobiles by Yamaha. In the championship mode snowmobiles can be upgraded with money won by winning races and performing tricks. There are 10 racing circuits set in such locations as Nagano, Aspen, and Munich. A track editor is included as well so that users can modify current tracks or create their own.\r\n\r\nStrap on your goggles and helmet, choose your favorite Yamaha sled, and hit the courses. Gain experience day and night, sun rain or snow, racing on the icy flats of Vladivostok, the slopes of Aspen, and the tunnels of Nagano.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9186], 'genres' => [7], 'publishers' => [68], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 610, 'game_title' => 'Spider: The Video Game', 'release_date' => '1997-02-26', 'platform' => 10, 'overview' => "In Spider: The Video Game you control a spider that has been implanted with a neural transmitter port, cybernetic legs, and weapon accessories. You begin at a sector map which functions as a blueprint of the research laboratory which you must explore. In order to clear a level, you must collect a required number of microchips. You must also find exits in each area in order to advance to the next level.\r\n\r\nThe spider is always equipped with a Slasher leg and webbing, and he is capable of enhancing his fighting ability with weapons by collecting power-ups. The weapons include homing missiles, flame throwers, boomerangs, and electro-beams. You'll need these munitions to defend yourself against other spiders, cyber-rats, toxic green frogs, and other laboratory pests in this 3-D side-scrolling platform contest.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1292], 'genres' => [15], 'publishers' => [123], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 611, 'game_title' => 'Spider-Man', 'release_date' => '1991-10-17', 'platform' => 18, 'overview' => "The city of New York is certainly a great place to be, but not when there's the criminal element running about. Lucky for the NYPD, there's also the heroic Spider-Man on their side!\r\n\r\nBut now one of the biggest criminals in the city, Wilson Fisk, a.k.a. The Kingpin, has pulled of the ultimate plot! He announces to New York that a bomb has been planted somewhere in the city, and that it'll go off in 24 hours! What's worse, he lays the blame on Spider-Man, and now the webslinger is on his own, and on the run from the police. Spidey smells a rat, and he knows what he must do.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8604], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 612, 'game_title' => 'Street Sk8er 2', 'release_date' => '2000-02-29', 'platform' => 10, 'overview' => "This is a skateboarding game very similar in gameplay to Tony Hawk's Pro Skater. You pick a skater and go through different skate parks, selecting either pro or amateur settings. You can also create your own skate park. Multiplayer competition is also provded, including 4 player serial play. Street Sk8er 2's sound track contains music from many well known bands such as Deftones, Ministry, and Static X.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [747], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 613, 'game_title' => 'Starwinder: The Ultimate Space Race', 'release_date' => '1996-10-31', 'platform' => 10, 'overview' => "In Starwinder: The Ultimate Space Race, you assume the role of Conner Rhodes, the first representative of Earth sent to compete in a galaxy-wide race. This isn't an ordinary race, however -- an unknown alien race built magnificent rails/tracks throughout the confines of space. Spanning thousands of miles in length, rails act in such a way that when pilots navigate toward one, it increases the speed of the ship.\r\n\r\nAs Conner, your overall objective is to bring home the ultimate reward -- the globe-like Starsphere. While your mission sounds fairly basic, it won't be easy; there are seven other pilots vying for the same prize. Residing in the far reaches of the Milky Way, competition includes a half man/half machine humanoid named Ko-Axe, the vengeful Tianna Stone, and an overconfident egomaniac that goes by the name of Dextor -- The Terrible. There are also drone pilots that fill in the rest of the playing field.\r\n\r\nBroken into quadrants, there are 44 different rails/tracks in which to race on; there are ten races per quadrant. While the bulk of the game is played against computer-controlled opposition, there are times when you'll race against the clock in a true test of speed and accuracy. Prove yourself worthy and you'll race against an elite group of pilots through Epsilon Indi -- the final railway. If you manage to win this final race, the Starsphere is as good as yours!", 'youtube' => 'peAD7IGCBdU', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5588], 'genres' => [7, 8], 'publishers' => [90], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 614, 'game_title' => 'Street Fighter Collection', 'release_date' => '1997-12-16', 'platform' => 10, 'overview' => "Street Fighter Collection is a 1997 fighting game compilation released for the PlayStation and Sega Saturn. It collects the original Super Street Fighter II and its follow-up Super Street Fighter II Turbo, along with an enhanced version of Street Fighter Alpha 2 titled Street Fighter Alpha 2 Gold exclusive to this compilation.\r\n\r\nThis compilation contains Super Street Fighter II and Super Street Fighter II Turbo (known in Japan as Super Street Fighter II X) in the first disc, with Street Fighter Alpha 2 Gold (Street Fighter Zero 2 Dash in Japan) in the second disc.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [10], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 615, 'game_title' => 'Suikoden II', 'release_date' => '1999-08-31', 'platform' => 10, 'overview' => "Experience An Epic Tale of Warfare, Magic, Friendship And Betrayal\r\n\r\n-New tactical map battles add a whole level of strategy\r\n-Fantastic spells with stunning animation sequences and specialized attacks\r\n-Over 108 different characters can join your party and help you on your quest\r\n-Unlock hidden storylines using your memory card data from the original Suikoden\r\n-Build up your castle during the game to a thriving virtual community", 'youtube' => 'HibuSDMFvyg', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4765], 'genres' => [4], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 616, 'game_title' => 'Super Puzzle Fighter II Turbo', 'release_date' => '1996-11-30', 'platform' => 10, 'overview' => "A Tetris-like puzzle game featuring popular characters from many Capcom games.\r\n\r\nColored gems fall from the top of the screen in pairs, but this time lining up those of the same color is not enough. To break the gems and punish your opponent with counter gems you have to place a crash gem of the same color next to the gems. If you make a block of gems of the same color they'll fuse, forming a power gem. Breaking a power gem sends more counter gems to your opponent than breaking the same amount of gems in some other configuration. But the ultimate attack is breaking power gems in chain.", 'youtube' => 'rnbnMsqBIsg', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [5], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 617, 'game_title' => 'Tactics Ogre: Let Us Cling Together', 'release_date' => '1998-01-01', 'platform' => 10, 'overview' => "After generations of war between the various ethnic groups, King Dogare brought peace to the land of Valeria. When the king dies Valeria is split into three different groups, each claiming the throne. You take the role of a young boy as he embarks on a quest to save the land from turmoil and assume the throne. You will have to journey throughout the land and recruit members for an army. Once recruited, the members will gain experience through the turn-based battles. \r\n\r\nUp to 10 party members can participate in any battle. Eventually, the characters can change classes and learn skills that are specific to each class. However, you will have to make sure your party is balanced or you will face certain doom. Will you be able to save the world from chaos in Tactics Ogre?", 'youtube' => 'ssJlXRqrtUs', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6909], 'genres' => [4, 6], 'publishers' => [58], 'alternates' => ['タクティクスオウガ LET US CLING TOGETHER', 'Tactics Ogre: Let Us Cling Together'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 618, 'game_title' => 'Time Crisis', 'release_date' => '1997-10-31', 'platform' => 10, 'overview' => 'Time Crisis is a rail shooter, originally released for the arcades, similar to Virtua Cop in gameplay style. The player moves automatically, using the light gun to eliminate appearing enemies, after which he can proceed to the next screen. The stages typically culminate in boss battles. The player can also press a button to make Richard dive for cover. However, using this feature too much might result in expiration of the time limit imposed on each screen.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5804], 'genres' => [8], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 619, 'game_title' => 'Tomb Raider II', 'release_date' => '1997-10-31', 'platform' => 10, 'overview' => "The story of Tomb Raider II surrounds the mythical Dagger of Xian, a weapon which was used by an Emperor of China to command his army. By plunging the weapon into its owner's heart, the weapon has the power to turn its bearer into a dragon. A flashback reveals that the last battle which was fought with the Dagger ended in defeat when the warrior monks of Tibet succeeded in removing the knife from the Emperor's heart. The Dagger was then returned to its resting place within the Great Wall.", 'youtube' => 'DdOs1Iz1hKA', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1827], 'genres' => [1, 2], 'publishers' => [26], 'alternates' => ['Tomb Raider 2'], 'uids' => [{ 'uid' => 'SLES-00719', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 620, 'game_title' => 'Uprising-X', 'release_date' => '1998-11-30', 'platform' => 10, 'overview' => "A war has been going on for nearly two hundred years between the cruel Imperium regime and the Rebel forces. The Rebels are beginning to turn the tides of the war to their advantage, and while the Imperium armies are by no means defeated, there is a great deal of hope in the Rebel camp.\r\n\r\nUnfortunately, the Imperium has introduced a new weapon of unspeakable power. When unleashed against a Rebel planet, the damage was absolute. This new \"planet-killing\" weapon will certainly mark the end of the Rebel forces if it continues to operate.\r\n\r\nUprising X, by The 3DO Company, is a blend of action and strategy for the PlayStation. Players take control of a tank-like vehicle known as \"The Wraith,\" which is the most powerful weapon available to the Rebel forces. The majority of the game is spent behind the controls of the Wraith, although some missions will require troop deployment and the construction of Rebel equipment. The game utilizes a first-person view from inside the Wraith or while building in Citadel mode.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2031], 'genres' => [1, 6], 'publishers' => [63], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 621, 'game_title' => 'Vandal Hearts', 'release_date' => '1997-06-01', 'platform' => 10, 'overview' => "You assume the role of Ash Lambert, a hero torn between saving his country and restoring honor to the disgraced Lambert dynasty. As he struggles with his inner demons and personal problems, he will meet various companions throughout his journey. They will help your character fight to overthrow the oppressive regime and ward off an ancient being that threatens the world.\r\n\r\nVandal-Hearts is a 3D turn-based strategy game. Unlike many games of the genre, the various battlefields have sloped surfaces that will either work to your advantage or against you. It will be up to you to accommodate your strategy and amount an appropriate offensive assault against your foes as well as set up defensive measures.", 'youtube' => 'd-e0XcKHPVg', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4765], 'genres' => [4, 6], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 622, 'game_title' => 'Warhammer: Shadow of the Horned Rat', 'release_date' => '1996-11-01', 'platform' => 10, 'overview' => "Warhammer: Shadow of the Horned Rat offers over 25 different troop types, 20 spells and nine characteristics for each regiment: movement, weapon skill, ballistic skill, strength, toughness, wounds, initiative, attack and leadership ability. In order to save campaign progress, players must have a memory card with at least one block free.\r\n\r\nBattles consist of two phases: deployment and real-time fighting. Deployment allows you to position your regiments within an area designated by white flags. This involves turning them to face certain enemies, issuing orders to attack, move (including setting waypoints and patrol loops) or simply hold ground.\r\n\r\nCombat involves charging the enemy, using magical spells (if available) or firing long-range weapons, such as arrows or catapults. Of course, line of sight and terrain will influence how successful your attacks are, and the emotion level (fear, hatred or frenzy) as well as the experience of your troops will also play a significant role. Each battlefield can also hold various magic items that may help in future battles.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3370], 'genres' => [6], 'publishers' => [149], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 623, 'game_title' => 'Warriors of Might and Magic', 'release_date' => '2001-02-07', 'platform' => 10, 'overview' => 'Warriors of Might and Magic is an action game with RPG elements set in the Might and Magic universe. The gameplay style is similar to that of Crusaders of Might and Magic. The player navigates Alleron through predominantly dungeon-like environments, fighting enemies in action-based combat, executing various melee moves (including blocking), and casting spells.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [77], 'genres' => [1], 'publishers' => [63], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 624, 'game_title' => "Wayne Gretzky's 3D Hockey '98", 'release_date' => '1997-12-26', 'platform' => 10, 'overview' => "Gameplay consists of two basic options: Arcade and Simulation. Although the graphics and earlobe vary little between the two, other changes have the effect of changing the chemistry and intensity of gameplay between the two options. The gamer has the ability to customize period length, fatigue (on/off), line changes, fighting (on/off), penalties (simulation only), rink size (arcade only), puck-streak (on/off), and camera angle.\r\n\r\nSimulation Mode:\r\nSimulation mode is designed to emulate the real game of hockey. Players may play five, four, or three to a side, depending on preference. Recognition of penalties, off-sides, and icing are all optional, but two-line pass is not considered. Period length can be selected between 5, 10, 15, and 20 minutes.\r\n\r\nArcade Mode:\r\nDuring the Arcade mode checking, hooking, and tripping are more violent. Fights occur with greater frequency, and penalties are disregarded entirely. Additionally, arcade mode sees the introduction of a \"power shot\", which a player may utilize to light the net on fire after a goal. Arcade mode tends to be more exciting.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7940], 'genres' => [11], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 625, 'game_title' => 'Wipeout XL', 'release_date' => '1996-09-30', 'platform' => 10, 'overview' => "Anti-gravity racing that’s light years ahead of the pack!\r\n\r\nThe original scorched the game world and became an instant classic. Fast-forward now to a brutal new generation of anti gravity racing. Loaded with faster, smoother graphics, more tracks, more crafts, and a range of nasty new weaponry. Wipeout XL will give you the rush of your life. \r\n\r\n-Up to 15 ships on the track as the same time\r\n-Secret racing features for accomplished players\r\n-New range of strategic and more explosive weapons\r\n-Multiple racing classes for a variety of player ability levels\r\n-Cool soundtrack by Future Sound of London, Chemical Brothers, Prodigy, Underworld, Fluke, and Photek", 'youtube' => 'mWo8LjUsego', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6840], 'genres' => [7], 'publishers' => [135], 'alternates' => ['Wipeout 2097'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 626, 'game_title' => 'WWF War Zone', 'release_date' => '1998-07-01', 'platform' => 10, 'overview' => "\"Rock the ring with the fiercest wrestling action ever seen!\" -GamePro\r\nThe top superstars in the World Wrestling Federation including Steve Austin, Shawn Michaels, The Undertaker, Kane, Triple H, and many more! Vince McMhaon and Jim Ross bring you the action from ringside. Training mode: Practice your moves before stepping into the ring!\r\n\r\n- 4 Player Action with Tag Team, Tornado and War Modes!\r\n- Specialized Matches Including Steel Cage Match\r\n- Signature and Finishing Moves Unique To Each Wrestler\r\n- Over 300 Motion Captured Maneuvers\r\n- Create and Save up to 30 Customized Wrestlers", 'youtube' => 'SPwp7JSKxWU', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4065], 'genres' => [10, 11], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 627, 'game_title' => 'Xenogears', 'release_date' => '1998-10-20', 'platform' => 10, 'overview' => "Stand tall, and shake the heavens.\r\n\r\nA mysterious organization is turning the tides of a century-long war with ancient technology - giant combat robots. A failed attempt to steal one of these powerful mechanized weapons places it in the unwilling hands of Fei and his dubious allies. Now he is pursued by military governments, royal pirates, spies, the Emperor, and his own forgotten past.\r\n\r\n* Over 20 minutes of stunning hand-drawn animé tells this complex, futuristic tale.\r\n* Battle in giant robots or hand-to-hand using intuitive combat systems without menus\r\n* Explore detailed, fully-rotatable polygonal environments", 'youtube' => 'QTx8iG52Ruo', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8096], 'genres' => [4], 'publishers' => [11], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 628, 'game_title' => 'X-Men vs. Street Fighter', 'release_date' => '1998-06-30', 'platform' => 10, 'overview' => "X-Men vs. Street Fighter is a fighting game originally released as a coin-operated arcade game in 1996. It is Capcom's third fighting game to feature Marvel Comics characters and the first game to match them against their own, with characters from Marvel's X-Men franchise being matched against the cast from the Street Fighter series.\r\n\r\nIt was the first game to blend a tag team style of combat with the Street Fighter gameplay, as well as incorporating elements from Capcom's previous Marvel-themed fighting games, X-Men: Children of the Atom and Marvel Super Heroes. It was ported to the Sega Saturn in 1997 and PlayStation in 1998. However, the tag team feature was omitted from the PlayStation version due to memory limitations.", 'youtube' => 'NpZDoYifqLk', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [10], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 629, 'game_title' => "John Madden Football '92", 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "This update of the John Madden football series offers several new features over its predecessor: instant replays, different weather conditions, player injuries and the ability to review and overturn pass interference calls.\r\n\r\nPlay modes include Pre-Season, Regular Season, Playoffs and Sudden Death. There are 28 teams plus one All-Madden team.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 630, 'game_title' => "John Madden Football '93", 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => "Another update in the Madden football series. New this time are some graphics and animations, including an animated coin toss and some player moves. New gameplay features are no-huddle offense and a stop clock play.\r\n\r\nThere are 28 teams from the '92-'93 season, two All Madden teams and 8 Greatest Ever teams.\r\n\r\nGame modes are the usual pre-season, regular season, sudden death and playoffs. A special playoff mode for the 8 greatest teams is also available.\r\n\r\nThe Genesis version features John Madden's digitized commentary speech and a battery-backed RAM for saving playoff results and player stats", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 631, 'game_title' => "Madden NFL '94", 'release_date' => '1994-02-18', 'platform' => 18, 'overview' => 'It features 80 teams -- 28 teams from the 1993 season, 38 Super Bowl teams from 1966-1991, 12 All Star franchise teams since 1950, and two "All-Madden" teams: one for the 1993 season and one from a 20-year time span. You can play these teams in a regular exhibition game or sudden death overtime game, or take the 1993 teams through an entire season. You can also enter the playoffs with the 1993 teams, the Super Bowl champions, or the All Star franchise teams. Unlike many other sports games, saving a season is done by password rather than by storing the data into a saved game.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 632, 'game_title' => 'Madden NFL 95', 'release_date' => '1994-09-05', 'platform' => 18, 'overview' => "John Madden's back in the 1995 version of Madden NFL.\r\n\r\nPlay exhibition, Super Bowl, playoffs or full season with any of the 1994 teams or all Madden teams.\r\n\r\nThis time around, you can select whether or not to include weather conditions, new player animations (high steppin', QB slides), a bigger field and over 100 injuries.\r\n\r\nAlso includes windowless passing, all new Madden-designed strategies and team match-up that shows how your players stack up to the other team in their position.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3834], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 633, 'game_title' => 'Marsupilami', 'release_date' => '1995-01-01', 'platform' => 18, 'overview' => "Marsupilami, a small furry marsupial with a tail with as many uses as a swiss army knife, must help his friend, Bonelli the elephant, across the world, returning him safely to his native home.Collecting Marsu's children along the way, you must solve puzzles, fight enemies and avoid traps, all with the aid of Marsu's incredible, ingenious tail!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [1, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 634, 'game_title' => 'Math Blaster: Episode 1', 'release_date' => '1994-09-14', 'platform' => 18, 'overview' => "Oh no! The dreaded Trash Alien has captured Spot and littered the universe with garbage! Join our hero Blasternaut on a daring mission to rescue his robot pal. Blast your way through space junk, chase through dark and dangerous caverns, and fend off nasty alien creatures. Spot's fate is in your hands - good luck!", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9585], 'genres' => nil, 'publishers' => [150], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 635, 'game_title' => 'Mazin Saga: Mutant Fighter', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => 'The story takes place in 1999 where a Bio-Beast by the name of Godkaiser Hell has reigned supreme over Earth, after a nuclear and biological holocaust has disfigured most of the population and formed an army called the Steelmask Force. The survivors have fled underground and are constantly attacked by the Bio-Beast horde until one day a scientist by the name of Dr. Kabuto creates a mech, the Mazinger-Z, that can be used against the monsters. This is where the player takes control of the games protagonist and pilots the suit in an attempt to reclaim the Earth.', 'youtube' => 'https://www.youtube.com/watch?v=qCfG4hxStzc', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [376], 'genres' => [1], 'publishers' => [151], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 636, 'game_title' => "McDonald's Treasure Land Adventure", 'release_date' => '1993-09-23', 'platform' => 18, 'overview' => "McDonald's Treasure Land Adventure is a side-scrolling adventure starring Ronald McDonald.\r\n\r\nAfter finding a piece of a treasure map, the yellow clown travels through four different levels (Forest, Town, Sea and Moon). He's off to find and defeat the baddies who have the other pieces of the map.\r\n\r\nRonald can jump, shoot and use his scarf to grab onto hooks to jump to higher levels.\r\n\r\nJewels and flowers collected in each level can be used to purchase extra lives and power-ups in shops between levels.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9008], 'genres' => [15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 637, 'game_title' => 'Mickey Mania: The Timeless Adventures of Mickey Mouse', 'release_date' => '1994-10-01', 'platform' => 18, 'overview' => 'The player must take on the role of Mickey and progress through each level, defeating enemies along the way and solving the occasional puzzle. Most enemies can be defeated either by stomping on them or tossing marbles at them. Frequently, the player must jump from platform to platform in order to advance, even occasionally within the constrains of a time limit (such as when escaping from a collapsing tower).', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8995], 'genres' => [2], 'publishers' => [77], 'alternates' => ['Mickey Mania Timeless Adventures of Mickey Mouse'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 638, 'game_title' => 'Halo: Reach', 'release_date' => '2010-09-14', 'platform' => 15, 'overview' => '“Halo: Reach” tells the tragic and heroic story of Noble Team, a group of Spartans, who through great sacrifice and courage saved countless lives in the face of impossible odds. The planet Reach is humanity’s last line of defense between the encroaching Covenant and their ultimate goal, the destruction of Earth. If it falls, humanity will be perched on the brink of destruction.', 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1389], 'genres' => [8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 639, 'game_title' => "Dante's Inferno", 'release_date' => '2010-02-09', 'platform' => 15, 'overview' => "Dante's Inferno is an epic single player, third-person action adventure game inspired by \"Inferno\", part one of Dante Alighieri's classic Italian poem, \"The Divine Comedy.\" Featuring nonstop action rendered at 60 frames-per-second, signature and upgradable weapons, attack combos and mana-fueled spells and the choice of punishing or absolving the souls of defeated enemies, it is a classic Medieval tale of the eternal conflict with sin and the resulting horrors of hell, adapted for a new generation and a new medium.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9428], 'genres' => [1, 2], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 640, 'game_title' => 'F.E.A.R. 2: Project Origin', 'release_date' => '2009-02-10', 'platform' => 1, 'overview' => "The sequel to F.E.A.R. continues the supernatural suspense story of the supernatural being, Alma, whose rage against those who wronged her causes an escalating paranormal crisis that threatens to devour and replace reality with her own.  Instead of playing as the Point Man, the game's protagonist is Michael Becket, a Delta Force operator whose squad is sent in to take Genevieve Aristide into protective custody approximately thirty minutes before the ending of F.E.A.R.", 'youtube' => 'bdLv5VGPzRY', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5679], 'genres' => [8], 'publishers' => [152], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 641, 'game_title' => 'Bayonetta', 'release_date' => '2010-01-05', 'platform' => 12, 'overview' => "Bayonetta is a stylish and cinematic action game, directed by Hideki Kamiya.\r\n\r\nA witch with powers beyond the comprehension of mere mortals, Bayonetta faces-off against countless angelic enemies, many reaching epic proportions, in a game of 100% pure, unadulterated all-out action. Outlandish finishing moves are performed with balletic grace as Bayonetta flows from one fight to another. With magnificent over-the-top action taking place in stages that are a veritable theme park of exciting attractions, Bayonetta pushes the limits of the action genre, bringing to life its fast-paced, dynamic climax combat.", 'youtube' => 'qD62SZwhP1M', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1829, 7549], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 642, 'game_title' => 'Mortal Kombat II', 'release_date' => '1994-12-05', 'platform' => 18, 'overview' => "Following his failure to defeat Liu Kang in the first Mortal Kombat game, the evil sorcerer Shang Tsung begs his master, Shao Kahn, to spare his life. He tells Shao Kahn that the invitation for Mortal Kombat cannot be turned down, and if they hold it in Outworld, the Earthrealm warriors must attend. Kahn agrees to this plan, and even restores Tsung's youth. He then extends the invitation to Raiden, who gathers his warriors and takes them into Outworld. The new tournament is much more dangerous, as Shao Kahn has the home field advantage, and an Outworld victory will allow him to subdue Earthrealm.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5507], 'genres' => [10], 'publishers' => [41], 'alternates' => ['Mortal Kombat 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 643, 'game_title' => 'Team Fortress 2', 'release_date' => '2007-10-10', 'platform' => 1, 'overview' => 'Team Fortress 2 is the sequel to the game that put class-based, multiplayer team warfare on the map.This year’s most anticipated online action game, TF2 delivers new gametypes, a signature art style powered by Valve’s next generation animation technology, persistent player statistics, and more.', 'youtube' => 'h_c3iQImXZg', 'players' => 6, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [9289], 'genres' => [8], 'publishers' => [13], 'alternates' => ['TF2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 644, 'game_title' => 'Dungeons & Dragons: Dragonshard', 'release_date' => '2005-10-02', 'platform' => 1, 'overview' => "Dungeons & Dragons: Dragonshard is a real-time strategy role-playing video game, developed for Microsoft Windows by Liquid Entertainment, and published by Atari in 2005. It takes place in Eberron, one of the official Dungeons & Dragons campaign settings. The game combines elements of traditional real-time strategy gameplay with role-playing elements such as hero units, and questing. Dragonshard includes two single-player campaigns, single-player skirmish maps, and multiplayer support. The single-player campaign follows the struggles of three competing factions to gain control of a magical artifact known as the Heart of Siberys.\r\n\r\nAlthough Dragonshard was billed by Atari as \"the first Dungeons & Dragons real-time strategy experience,\"[2] Stronghold (1993) precedes it by over a decade.[3]", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 645, 'game_title' => 'F.E.A.R. Extraction Point', 'release_date' => '2006-10-24', 'platform' => 1, 'overview' => "This expansion owes its name to the game's ultimate goal for the player, to reach the extraction point and leave the city where the adventure takes place.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5678], 'genres' => [8], 'publishers' => [153], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 646, 'game_title' => 'Call of Duty: World at War', 'release_date' => '2008-11-11', 'platform' => 1, 'overview' => 'Call of Duty: World at War throws out the rulebook of war to transform WWII combat through a new enemy, new tactics and an uncensored experience of the climatic battles that gripped a generation. As U.S. Marines and Russian soldiers, players will employ new features like cooperative gameplay, and weapons such as the flamethrower in the most chaotic and cinematically intense experience to date.', 'youtube' => 'Y_Ip_SaJqpg', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9025], 'genres' => [8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 647, 'game_title' => 'Half-Life', 'release_date' => '1998-11-19', 'platform' => 1, 'overview' => 'Half-Life, a First Person Shooter released by Valve & Sierra in 1998, tells the story of a recently graduated theoretical physicist, named Dr. Gordon Freeman, who is working on experiments in relation to teleportation technology with other scientists in the Black Mesa Research Facility. Unfortunately, an experiment goes disastrously wrong and aliens from another dimension, also known as Xen, subsequently enter the facility through a dimensional seam! As Freeman tries to make his way out of the ruined facility, he soon realizes that he is caught between two sides: the hostile aliens and a U.S. Marine Corps special operations unit dispatched to cover up the incident by eliminating all organisms in the facility, including every single survivor. Explore the facility as Gordon Freeman, escape the complex alive and discover both the mysterious Xens as well as their portals to other dimensions!', 'youtube' => 'qobDF0w5qJc', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9289], 'genres' => [8], 'publishers' => [32], 'alternates' => ['Half Life'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 648, 'game_title' => 'Call of Duty 4: Modern Warfare', 'release_date' => '2007-11-05', 'platform' => 1, 'overview' => "The game starts with Sergeant John \"Soap\" MacTavish beginning his career with the British SAS at a training camp in Credenhill, U.K. There, he trains for a cargo ship raid.\r\n\r\nAfter they board the ship, located in the Bering Sea, Soap, Captain Price, Gaz, and several SAS members attempt to find a nuclear device on board. As they clear the ship and kill the Russian soldiers aboard, the ship is attacked by Russian MiGs and begins to sink. The team escapes with the cargo manifest, which provides evidence of ties between the Russian Ultranationalist Party and a rebel faction in the Middle East.\r\n\r\nRussian Ultranationalist leader Imran Zakhaev, who plans to return his motherland to the times of the Soviet Union, draws international attention away from his plans by funding a coup d'état in an unnamed Middle Eastern country, organized by a local separatist leader named Khaled Al-Asad. Discovering the plot, the American government starts a police action to stop the uprising, while the SAS continues to operate in Russia. After President Al-Fulani of the Middle Eastern country is executed on live television and Al-Asad takes control, the SAS rescue their compromised agent, Nikolai, from Russian Ultranationalist forces.\r\n \r\nOne section of the game takes place in Prypiat, Ukraine. Several iconic aspects of the abandoned city, such as this square, were recreated in the game.\r\n\r\nIn the American invasion of the Middle Eastern country, a platoon from the USMC 1st Force Recon, led by Lieutenant Vasquez, deploys to search for Al-Asad, but are too late, and proceed to aid other American units fighting the separatists. During the final stages of the operation, United States Central Command learns of Al-Asad's position in the capital, but is also notified by SEAL Team Six of a Russian nuclear weapon nearby, and sends the Nuclear Emergency Support Team to disarm it. However, the nuclear device suddenly detonates, leveling most of the city, killing his own army, citizens, and the US Invasion Force of 30,000 Marines. Just before the detonation, Vasquez's squad makes a last minute rescue of a pilot from a downed AH-1 Cobra. While fleeing the city, the helicopter is caught in the blast, killing everyone on board..\r\n\r\nThe British learn that Al-Asad fled the country before the American invasion, and is hiding in a safe house in Azerbaijan. With the help of Nikolai's intelligence and assistance from Loyalist Russian soldiers, the SAS clear the village of the Ultranationalist forces and capture and interrogate Al-Asad at his safe house. After listening to the voice calling Al-Asad's phone, Captain Price executes Al-Asad, now knowing that Zakhaev is Al-Asad's backer. Price then has a flashback of his mission to eliminate Zakhaev in Prypiat, Ukraine, 15 years earlier.\r\nIn the aftermath of the Chernobyl disaster and the collapse of the Soviet Union, Zakhaev took advantage of the turmoil to profit from nuclear proliferation and used his new wealth to lure soldiers from the Soviet Army to form his Ultranationalist Party. In 1996, Price was paired with Captain MacMillan, a Scottish SAS captain, to carry out the black op assassination of Zakhaev. After sneaking into Prypiat and taking up a position in an abandoned hotel, MacMillan spotted Zakhaev, and Price hit him with a shot from a Barrett M82, but Zakhaev survived, losing an arm. Price and MacMillan were pursued, but escaped, with MacMillan sustaining an injured leg in the process.\r\nBack in the present day, a joint operation is conducted by Price's SAS unit, a USMC Force Recon unit led by Staff Sergeant Griggs, and Loyalist Russian forces led by Sergeant Kamarov, to stop Zakhaev. They capture his son Victor in an unnamed Russian city, to learn of Zakhaev's whereabouts, but as they corner him, Victor commits suicide to avoid being captured. Zakhaev becomes enraged, blaming Western nations for the death of his son, and plans to retaliate by launching ballistic missiles armed with nuclear warheads at the East Coast of the United States, with predicted losses of over 41 million people. When the Task Force operatives arrive at the facility in Russia, Zakhaev manages to launch ICBMs towards the United States. However, the squad successfully seizes the silo command room and remote detonates the missiles over the Atlantic. They escape the facility in military trucks with Zakhaev's forces in hot pursuit.\r\n\r\nBefore the squad can escape across a nearby bridge, it is destroyed by an Mi-24 Hind, leaving them trapped. Zakhaev's forces arrive and engage the remaining members of the strike force. Gaz receives a call from Kamarov, informing him that his forces are on their way to help. On the bridge, a gas tanker explodes, incapacitating most of the soldiers nearby, except Griggs, who is killed while trying to pull MacTavish to safety. Zakhaev, along with two of his soldiers, begin executing Gaz and other surviving members of the strike force. Before he reaches Soap and Price, he is distracted by the destruction of his gunship and the arrival of the Loyalist helicopters. As Zakhaev looks away, Price slides his pistol to Soap, who shoots and kills Zakhaev and his two guards. When Kamarov and his team arrive, MacTavish is evacuated to safety, while a Russian medic attempts to resuscitate Price.", 'youtube' => 'LhuIjNSg7Gg', 'players' => 1, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [4187], 'genres' => [8], 'publishers' => [33], 'alternates' => ['Call of Duty 4 Modern Warfare'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 649, 'game_title' => 'BioShock 2', 'release_date' => '2010-02-09', 'platform' => 1, 'overview' => "The game is set in the fictional underwater dystopia of Rapture, in a biopunk/dieselpunk 1968, eight years after the events of BioShock. The protagonist and player-controlled character is a Big Daddy, a being that has had its organs and skin grafted into an atmospheric diving suit. Among the first of its kind, the player-controlled Big Daddy, named Delta, reactivates with no recollection of the past decade's events, and scours the city in an attempt to relocate the Little Sister that he was paired with. Fearing this reunion will ruin her plans for the city, Sofia Lamb sends out her spliced up followers she calls The Family and new Big Sisters in an attempt to deter Delta.", 'youtube' => '2hLE4DeHtNE', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [44], 'genres' => [1, 2, 8], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 650, 'game_title' => 'Final Fantasy XIV Online', 'release_date' => '2011-03-01', 'platform' => 12, 'overview' => 'Take up arms with adventurers from around the globe and embark on an epic journey within the unforgettable realm of Eorzea - the stage for a revolutionary new MMORPG designed to fit the lifestyles of players everywhere, from casual users to the most hardcore gamers.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2808], 'genres' => [1, 2, 4], 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 651, 'game_title' => 'Mortal Kombat 3', 'release_date' => '1995-04-01', 'platform' => 18, 'overview' => "Fed up with continuous losses in tournament battle, Shao Kahn, who had lost to Liu Kang in the Outworld tournament, enacts a 10,000 year-old plan. He would have his Shadow Priests, led by Shang Tsung, revive his former Queen Sindel, who unexpectedly died at a young age. However, she wouldn't be revived in the Outworld. She would be resurrected in the Earthrealm. This would allow Shao Kahn to cross the boundary lines and reclaim his queen.\r\nWhen Sindel is reincarnated in Earthrealm, Shao Kahn reaches across the dimensions to reclaim her. As a consequence of his action, the Earthrealm becomes a part of the Outworld, instantly stripping billions of their souls. Only a few are spared, as Raiden protects their souls. He tells them that Shao Kahn must be stopped, but he cannot interfere; due to his status, he has no power in Outworld, and Earthrealm is partially merged with Outworld.\r\nShao Kahn has unleashed extermination squads to roam throughout the Earthrealm and kill any survivors. Also, Raiden's protection only extends to the soul, not to the body, so his chosen warriors have to fight the extermination squads and repel Shao Kahn. Eventually with his final defeat, every human on Earthrealm comes back.\r\nMortal Kombat 3 follows Mortal Kombat II and shares continuity with both Ultimate Mortal Kombat 3 and Mortal Kombat Trilogy which were both updates of this game. The next new game in the series was Mortal Kombat 4.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'M - Mature', 'developers' => [5507], 'genres' => [10], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 653, 'game_title' => 'Mortal Kombat', 'release_date' => '1992-10-01', 'platform' => 18, 'overview' => "In Mortal Kombat, the player receives information concerning the backstories of the characters and their relationships with one another mainly in biographies that are displayed when the start button is not pressed, during attract mode in the title screen. These bios featured short videos of the characters taking their fighting stances and text informing the motives for each character to enter the tournament. The game takes place in a fantasy setting, with most of the game's events occurring on the fictional realms of the Mortal Kombat series. The original game is notably the only title in the series that features only one realm, that being Earthrealm. The tournament featured in the story actually takes place fully at Shang Tsung's Island, located somewhere on Earth, with seven of its locations serving as Kombat Zones.", 'youtube' => 'https://www.youtube.com/watch?v=tbi7Fu6v9Rs', 'players' => 2, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5507], 'genres' => [10], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 654, 'game_title' => 'Muhammad Ali Heavyweight Boxing', 'release_date' => '1992-12-01', 'platform' => 18, 'overview' => "In career mode, the player can choose to fight as any of the game's 10 boxers. They start at rank 10 in the heavyweight division, and fight their way through all the others in order.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6451], 'genres' => [11], 'publishers' => [48], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 655, 'game_title' => 'NBA All-Star Challenge', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => 'NBA All-Star Challenge offers one-on-one basketball featuring NBA players from the 1991-1992 season. Five different playing modes are available: a single one-on-one match, a free throw competition, a 3 point shootout, a H.O.R.S.E. competition and a one-on-one tournament. You can choose from 27 players (one from every NBA team), including Michael Jordan, Larry Bird, Patrick Ewing, Karl Malone and David Robinson. Each mode can also be played by two players.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [67], 'genres' => [11], 'publishers' => [118], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 656, 'game_title' => 'NBA Jam Tournament Edition', 'release_date' => '1995-02-23', 'platform' => 18, 'overview' => "NBA JAM Tournament Edition brings you more senses-shattering slam dunking excitement than ever! More than twice as many NBA superstars, more than double the secret characters, Hot Spots, Super Jam Power-Ups, battery back-up and - OH MY - nine all-new rim-rattling slam dunks plus all the original jams! NBA JAM Tournament Edition... it's on FIRE!", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'E - Everyone', 'developers' => [4065], 'genres' => [11], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 657, 'game_title' => 'NBA Jam', 'release_date' => '1994-03-04', 'platform' => 18, 'overview' => "NBA Jam, which featured 2-on-2 basketball, was one of the first real playable basketball arcade games, and was also one of the first sports games to feature NBA-licensed teams and players, and their real digitized likenesses.\r\n\r\nA key feature of NBA Jam was the exaggerated nature of the play - players jumped many times above their own height, making slam dunks that defied both human capabilities and the laws of physics. There were no fouls, free throws, or violations except goaltending and 24 second violations. This meant the player was able to freely shove or elbow his opponent out of the way. Additionally, the game had an \"on fire\" feature, where if one player made three baskets in a row, he would become \"on fire\" and have unlimited turbo, no goaltending, and increased shooting ability, until the other team scored (or the player had scored four consecutive baskets while \"on fire\").", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5507], 'genres' => [11], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 658, 'game_title' => 'New Horizons', 'release_date' => '1994-01-01', 'platform' => 18, 'overview' => 'In New Horizons, it is the early 16th century and the age of exploration and sea trade is underway. Players choose from any one of six adventurers (scenarios), each with their own distinctive but intertwining plot, to embark on a quest of sailing, seamanship and exploration.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4738], 'genres' => [4], 'publishers' => [50], 'alternates' => ['Uncharted Waters: New Horizons'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 659, 'game_title' => "NFL Football '94 Starring Joe Montana", 'release_date' => '1994-02-04', 'platform' => 18, 'overview' => "NFL Football '94 Starring Joe Montana is a 1993 Sega Mega Drive/Genesis game which has a realistic running commentary that runs while the player engages himself in exhibition, regular season, or playoff action.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [11], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 660, 'game_title' => "NFL Sports Talk Football '93 Starring Joe Montana", 'release_date' => '1992-05-14', 'platform' => 18, 'overview' => 'Players may choose to play an exhibition game, or compete in the league (16 games, then the playoffs and Super Bowl).', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [11], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 661, 'game_title' => "NHL '94", 'release_date' => '1993-03-15', 'platform' => 18, 'overview' => "Over 25 NEW features in HOCKEY '94! 4-Way Play Support - Use the EA Sports 4-Way Play and NHL '94 becomes a 1, 2, 3 or 4 player game! Goalie Control - You control the double pad stacks and kick saves of all the greats. Penalty Shots and Shootout Mode - Take the hottest shooters and go head to head with the greatest goalies in the league. One Timers - New blistering slap shots make offense faster and more challenging. New Expansion Teams - Play with the Mighty Ducks or with the Florida Panthers. Music and Animations - Over 70 new pieces of organ music from arenas around the league. Plus new crowd and player animations!", 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 662, 'game_title' => 'NHL 95', 'release_date' => '1994-07-04', 'platform' => 18, 'overview' => "This is not your ordinary cup! It's the Stanley Cup! And only the victors of the grueling NHL season earn the right to have their name engraved on it. That's a whole season of blistering slap shots, board checks, hot rookies and mid-season trades. NHL '95 drops you into the opening face-off staring down the line at 84 relentless games - trying to carve your name on that Cup!", 'youtube' => '03GLFxsJzG8', 'players' => 4, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [3835], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 663, 'game_title' => 'NHL 96', 'release_date' => '1995-10-26', 'platform' => 18, 'overview' => 'Fighting is reintroduced in NHL 96, as are major and double minor penalties.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3835], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 664, 'game_title' => "NHLPA Hockey '93", 'release_date' => '1993-04-05', 'platform' => 18, 'overview' => "Skate with all the greats! Over 500 real players have skated into the hot sequel to NHL Hockey. Now you can skate, stick and score with all the greats - Robataille, Chelios, Recchi, and Mullen. Rosters of every professional team including expansion teams Ottawa and Tampa Bay! New Signature Moves - Smack a MacInnis glass breaking slap shot a little high and smash the glass behind the net - Awesome power! Track Player Statistics - Follow how many goals you've scored with your favorite players throughout the playoffs - Jagr, Stevens, Oates, Bure and more!", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6451], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 665, 'game_title' => 'X-Men', 'release_date' => '1993-03-30', 'platform' => 18, 'overview' => "The evil mutant Magneto has devised the world's deadliest computer virus. Its sole purpose: To destroy the Uncanny X-Men. Now Wolverine, Gambit, Cyclops and Nightcrawler join Storm, Iceman, Archangel, Jean Grey and Rogue to stop Magneto from carrying out his diabolical plan. Their target is Magneto's secret base on Asteroid M. But lying in ambush are the murderous arch villains Juggernaut, Sabretooth, Mojo and Deathbird. Will Wolverine's adamantium claws and Gambit's energy-charged playing cards be enough to defeat the forces of Magneto? That's up to you.", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [9585], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 666, 'game_title' => 'Primal Rage', 'release_date' => '1995-08-25', 'platform' => 18, 'overview' => "In Primal Rage, a meteor strike has devastated the Earth; technology has ceased to exist, civilization has been utterly reduced to rubble, and humans have regressed into tribes of Stone Age dwellers. Into this new radiation-scarred world, primitively referred to as \"Urth\", primordial rainforest has covered the land and numerous new species have evolved.\r\nOut of their ranks seven creatures emerge who wage war for control over the new world; they are torn between those who wish to keep peace on Urth, and those who attempt to plunge the world into further chaos for their own benefit. These creatures have otherworldly or supernatural abilities. The Primal Rage trading cards that were distributed along with the toyline presented each creature as a god of an aspect of nature, as in life and death, fire and ice. There are four of the good Virtuous Gods and three evil Destructive Gods. The character Sauron, God of Hunger, is marked as a \"Virtuous Beast\" despite the fact that his in-game ending displays an image of him devouring humans. In fact, the creatures eating humans is a basic part of the gameplay.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6787], 'genres' => [10], 'publishers' => [155], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 667, 'game_title' => 'Pitfall: The Mayan Adventure', 'release_date' => '1995-01-01', 'platform' => 18, 'overview' => 'In this game, the player takes the role of Pitfall Harry Jr., son of the hero of the original game, who has to find his kidnapped father.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [234], 'genres' => [2], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 668, 'game_title' => 'Revolution X', 'release_date' => '1994-05-23', 'platform' => 18, 'overview' => "The plot concerns a dystopian version of 1996 where an alliance of corrupt government and corporate military forces have taken control of the world in the guise of the \"New Order Nation\" (NON). The NON, with their vampish commander Mistress Helga (portrayed by Kerri Hoskins), have declared war on youth culture (anyone aged from 13 to 30) and have banned music, television and video games. At a gig in Los Angeles at 'Club X', complete with neon sign, Aerosmith are captured by NON troops once the player reached inside the theater and the game begins.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [5507], 'genres' => [8], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 669, 'game_title' => 'The Lion King', 'release_date' => '1994-12-08', 'platform' => 18, 'overview' => "The game is a side-scrolling platform game, with the controlled character having to leap, climb, run and descend from platform to platform. There is an exception during the level The Stampede, where Simba is running towards (or in the NES and Game Boy versions, running with the camera looking straight down on top of him) the camera dodging wildebeest and leaping over rocks.\r\nIn most versions of the game two bars appear on the HUD. To the left is the roar meter, which must be fully charged for Simba's roar to be effective. To the right is the health bar which decreases when Simba is hurt. At the bottom left of the screen is a counter showing how many lives Simba has remaining. Health can be restored by collecting bugs which come in a variety of shapes and sizes. Some rare health-damaging bugs also exist.\r\nThe player controls Simba (first as a cub, then later as an adult) in the main levels and either Timon or Pumbaa in the bonus levels.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9399], 'genres' => [2], 'publishers' => [48], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 670, 'game_title' => "Olympic Gold: Barcelona '92", 'release_date' => '1992-07-24', 'platform' => 18, 'overview' => 'Each computer athlete has a fictional name and nationality (choosing from UK, France, Germany, Italy, Spain, USA, Japan and the Unified Team, everyone with its own anthem snippet) and actual strengths and weaknesses: J. Balen, for instance, is a frequent 100 m and 110 m hurdles record breaker but only an average hammer thrower. Also, each computer controlled player seems better in a particular event depending on his country: Germans usually take the top spots in archery, Italians on swimming, Russians on pole vault, Americans on sprinting and so on.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9135], 'genres' => [11], 'publishers' => [110], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 671, 'game_title' => 'Operation Europe', 'release_date' => '1993-01-16', 'platform' => 18, 'overview' => "Operation Europe: Path to Victory is a multiplatform war game where one or two players can compete in World War II action. The object of the game is to fulfill any one of the military objectives for either the Axis or the Allied forces. Players engage in modern warfare around Western Europe, Eastern Europe, Central Europe, and North Africa.\r\n\r\nThis game uses abstract numbers and figures in the map view and saves the concrete illustrations of soldiers only when they lock horns on the battlefield or in an urban setting. Urban settings give a traditional 1930s view of housing and office buildings that provide extra protection for units that are guarding them. However, there are massive numbers to crunch and the lack of graphics help enhance the number crunching ability of game's artificial intelligence.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4738], 'genres' => [6], 'publishers' => [50], 'alternates' => ['Operation Europe: Path to Victory 1939-45'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 672, 'game_title' => 'OutRunners', 'release_date' => '1994-05-13', 'platform' => 18, 'overview' => 'Unlike the original Out Run, some stages are accessible on more than one route combination. After the initial starting stage, the player has the option of either turning east or west. West leads through San Francisco, through the Easter Islands, into Asia and either into Africa or Europe. East goes through the Grand Canyon, South America or Niagara Falls, across the Atlantic Ocean, into Europe and either into Asia or Australia.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [410], 'genres' => [7], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 673, 'game_title' => 'Pac-Attack', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "On a Tetris-like board the player drops blocks consisting of Ghosts, Blocks, Pac-Men, and one Fairy (if your Fairy Meter is full) to the ground. The objective is to not let the blocks overflow, let Pac-Man eat the ghosts, and make lines to shorten the amount of blocks on the board. When Pac-Man eats a ghost, the Fairy Meter goes up. Once full, a fairy will eventually be dropped. Once the fairy comes to a stop by landing on anything, it waves its wand and every ghost in the eight lines below it will disappear, often resulting in numerous lines being completed and simplifying the board. Once the fairy disappears, the score bonus is given, and gameplay continues.\r\n\r\nPac-Attack can also be played in 2-player mode. Player 1 must eat Blinky, while Player 2 must eat Sue, the purple ghost from Pac-Mania. As players eat ghosts and complete lines, they will drop ghosts on their opponent's board, messing up their board and bringing them closer to the top. This game can even be played in puzzle mode. The object of this mode is to smash all 100 stages. If you get a Game Over, all the regular blocks appear with red crosses on them, while Blinky and Sue over backwards laughing silently. However, you can try the level again.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5804], 'genres' => [5], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 674, 'game_title' => 'Pac-Man 2: The New Adventures', 'release_date' => '1994-08-26', 'platform' => 18, 'overview' => "In Pac-Man 2, the player plays the role of an observer and assistant that follows Pac-Man as he sets out to accomplish various tasks. Pac-Man himself walks around in a cartoon world and interacts directly with the player, as well as with objects and other characters. The player cannot control Pac-Man directly, but instead can direct his attention in various directions, and is armed with a slingshot that can be used to strike certain objects, including Pac-Man himself.\r\nPac-Man's mood varies throughout the game, usually in response to his environment or the player's actions, and generally his mood affects his actions and his willingness to cooperate with the player; the varieties of \"bad\" moods can at time compromise the player's ability to progress. There are a few instances, however, where Pac Man is required to be angry. Hitting objects with the slingshot can often get Pac-Man to look at that object and piece together parts of the puzzle he is currently trying to solve - for example, hitting a door may cause Pac-Man to go inside a house to discover a clue. But beware - a few objects when hit can also produce disastrous (and humorous) results. Hitting a trash can on a city street at the wrong time, for example, can cause a cat to jump out and attack Pac-Man.\r\nThroughout the game, Pac-Man is occasionally harassed by the four ghosts from the classic Pac-Man games. When this happens, Pac-Man is paralyzed by fear and eventually faints, unless the player gives him a power pellet. Then Pac-Man becomes Super Pac-Man for a brief time and flies around, eating the ghosts. In some cases, the ghosts may leave behind important objects.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5804], 'genres' => [2, 5], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 675, 'game_title' => 'Pebble Beach Golf Links', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => 'Eighteen of the most dramatic and toughest holes in golf. Five exciting golfing options: Practice, Stroke Play, Skins Game, Match Play, and Tournament Play versus 48 top golfers. In-depth Golf features: Caddie Advice, Instant Replays, Complete Shot, Leader Board, and Hole Fly-bys.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8429], 'genres' => [11], 'publishers' => [15], 'alternates' => ['Pebble Beach no Hatou'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 676, 'game_title' => 'PGA Tour Golf II', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => "The sequel to PGA Tour, this game was released solely for the Sega Genesis / Mega Drive along with an alternative version for the Game Gear, as was getting more common for EA sports titles at the time, helping to drive the sales of the 2nd choice console.\r\n\r\nThis update sees the series add ten professional players to the roster (60 in total) and have the ability to play against them on seven courses and across five tournaments. There is also a new graphics engine in place and new sounds to boot. Statistics became more detailed and the ball physics were improved through a Draw and Fade meter. Game data can be backed up through the built-in battery. Other features include different ball lies, dynamic wind conditions, digitized sounds, an improved automatic caddy and special shots such as chips, punches and fringe putts.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6731], 'genres' => [11], 'publishers' => [82], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 677, 'game_title' => 'PGA Tour Golf', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => 'PGA Tour Golf introduced many of the conventions commonly seen in the genre since. The three-click control method (the first to start the swing, the second setting power and over-swing, the third setting draw or fade) allowed for a multitude of different shots, and required a sense of timing.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8186], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 678, 'game_title' => 'Phantasy Star II', 'release_date' => '1989-03-21', 'platform' => 18, 'overview' => "The time: Space Century 3240. The place: The Algol Star System. It began when King Lassic turned evil and let hordes of hideous, magical creatures run amok on the three planets. When her brother was killed, Alis vowed to avenge his death and put an end to Lassic forever.\r\n\r\nJoin her in a journey across time and space to worlds where creatures speak...where magic and science combine to take you on the ultimate video quest.\r\n\r\nThe battle system is turn-based, allowing the player to choose commands for up to four characters. Each of the eight characters has a different set of preferred weapons and armor, as well as techniques, suited to the character's job. The player must defeat enemies in the overworld and in dungeons to advance in the game.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [4], 'publishers' => [15], 'alternates' => ['Phantasy Star 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 679, 'game_title' => 'Phantasy Star III: Generations of Doom', 'release_date' => '1990-04-21', 'platform' => 18, 'overview' => "Vanquish the Dark Forces\r\n\r\nIt's been a millennium since Laya's hordes battled Orakio's cyborg armies. And civilized man was almost destroyed. But the Dark Forces still remain. Conquer these monstrous mutations. Fight them with swords, knives, bows - even your wits. You live and die by them.\r\n\r\nExplore the Planet and Beyond\r\n\r\nTrek through 7 distant lands - some friendly, some not. Transform into an aerojet and fly over snow-capped mountains. Or become a submersible or aquaskimmer and cross vast oceans and raging rivers. Then find and fight your way through danger-laden dungeons.\r\n\r\nCome Forth Now\r\n\r\nEmbark on a journey so vast, it spans the lives of three generations. Begin with Maia, spirited away by a winged dragon on your wedding day. Experience one of our four endings that will surprise new and former Phantasy Star players alike.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [4], 'publishers' => [15], 'alternates' => ['Phantasy Star 3 - Generations of Doom', 'Phantasy Star 3'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 680, 'game_title' => 'Pit-Fighter', 'release_date' => '1990-08-01', 'platform' => 18, 'overview' => "The player begins Pit-Fighter by choosing one of the three playable characters, who all have different moves, speed, and power. As many as three people can play at a time, but there will be extra opponents to fight during any of this game's 15 different matches.\r\nEvery third fight is known as a Grudge Match. In a Grudge Match, the player must fight against a CPU controlled clone of his or her fighter (if playing alone) or the other players in a multiplayer game. Each player has three \"knockdowns\" - getting knocked down three times eliminates them from the Grudge Match, the winner is the last man standing. This match plays more like a bonus round, in that there is only results are gaining or failing to gain bonus money, and losing the Grudge Match does not eliminate a player.\r\nThe final battle, the \"Championship Match\", is between the player and the mysterious entity that taunts between matches every once in a while, the Masked Warrior. If more than one person is playing the game before this match, they must fight each other to the death until only one becomes victorious and can fight him.\r\n\r\n\r\nBuzz posing after taking down the Executioner.\r\nThe player must jump, punch, and kick their opponent until his/her energy runs out. If the player presses all three of the buttons at a time, the character will perform a \"super move\".\r\nSometimes during matches the player will come across foreign objects such as knives, crates, sticks, motorcycles, and bar stools that can be thrown at you or your opponent. The player may also come across a power-up known as the \"power pill\". If the player or the opponent grab this item, one will become temporarily stronger and take less damage from hits.\r\nSometimes even the crowd will interfere in the fights. Two characters, known as Knife Man and Knife Woman, will come out of the crowd and stab the player with their daggers. The player can take these nuisances out with one hit. Sometimes there is also a fat bearded man with a stick. If the player knocks him down, the player can take the stick and use it against the current opponent.\r\nThe audience will also push any fighter that ends up among them, and stays there more than a few seconds. They will be forced back into the fighting area.", 'youtube' => '', 'players' => 3, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [1], 'genres' => [10], 'publishers' => [111], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 681, 'game_title' => 'Ranger X', 'release_date' => '1993-05-27', 'platform' => 18, 'overview' => 'Engage in airborne combat with jump-jets and weapons of incredible power or link up with your cyber cycle for high speed ground attacks. Each step inches you closer to your goal and the fight of your life. You are Ranger X... A mysterious lone warrior who has risen from the ashes to return peace and justice to a failed society. Eight post-apocalyptic levels of high-intensity action! Monstrous mechanical bosses await your every move. Use jump-jets to attack by air or transform into the Super Cyber Cycle and roll to victory!', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3413], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 682, 'game_title' => 'R.B.I. Baseball 4', 'release_date' => '1992-12-18', 'platform' => 18, 'overview' => "R.B.I. Baseball 4 or R.B.I. 4 Baseball (Ｒ.Ｂ.Ｉ.４.ベースボール) is a 1992 baseball game for the Sega Mega Drive by Tengen and the sequel to R.B.I. Baseball 3. It was followed by R.B.I. Baseball '93.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5804, 8654], 'genres' => [11], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 683, 'game_title' => 'Risk', 'release_date' => '1994-04-02', 'platform' => 18, 'overview' => 'Players attempt to capture territories from other players by rolling higher die numbers. The game is won when one player has managed to occupy every territory.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7527], 'genres' => [6], 'publishers' => [156], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 684, 'game_title' => 'Beauty & The Beast: Roar of the Beast', 'release_date' => '1993-10-01', 'platform' => 18, 'overview' => 'As the Beast, the player must successfully complete several levels, based on scenes from the film, in order to protect the castle from invading villagers and forest animals and rescue Belle from the evil Gaston.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8329], 'genres' => [15], 'publishers' => [75], 'alternates' => ['Beauty and the Beast - Roar of the Beast', 'Roar Of The Beast'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 685, 'game_title' => 'Rocket Knight Adventures', 'release_date' => '1993-06-16', 'platform' => 18, 'overview' => "He's courageous! He's clever! He's one good lookin' opossum. It's Sparkster the Rocket Knight, the heroic jet pack jockey with warp speed, quick wits and pumped up personality. After all, who else do you know can get a grip with his tail? Rocket through 7 epic stages of animalistic adventure, home of the hugest, strangest enemy pig creatures imaginable. (In fact, your mission is crammed with more ham than a Hollywood premier.) Destroy the Emperor who's on a porcine power trip that will take him to the Key to the Pig Star. In every stage you'll be moving, flying and riding in a new direction to escape opossum punishment. You're the thrust-meister controlling Sparkster's jet pack and his assault sword. Confront mechanized menaces like the Giant Pigbot, the Drill Of A Lifetime, and the snappy Crab Rangoon. Things take a turn for the worst in the room of rotating gravity where Axle Gear, the Black Knights awaits you. And you've never seen anything like the unreal mirrored lava pools where things will reflect badly on you. The tricks, the traps and challenges never end. But the world as you know it will if you don't grind those pigs for sausage.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [1, 15], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 686, 'game_title' => "Roger Clemens' MVP Baseball", 'release_date' => '1992-09-12', 'platform' => 18, 'overview' => 'The game features 26 teams to use, an exhibition mode and a regular season mode. The game had the ability to "save" your career progress by giving you a password that you could enter at the menu screen, when you wanted to continue the season.', 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7527], 'genres' => [11], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 687, 'game_title' => 'College Slam', 'release_date' => '1996-01-31', 'platform' => 18, 'overview' => "Each team starts out by picking any 2 out of 5 players to play with during the game. During timeouts, and at half-time, the player has a choice to make substitutions. When a player makes 2 baskets in a row, the announcer says \"He's heating up\", and if he makes 3 baskets in a row without the other team scoring, he says \"He's on fire!\", which makes it easier to score.\r\nIn the season mode, the player can pick from 44 teams, and then play a 20 game season against quality competition. In the tournament mode, 16 teams compete for a chance to win the national championship. The player also has the ability to edit teams and players. The game itself is not realistic, as players can easily make full-courts shots and occasionally, players get struck by lightning as they dunk. The final score of the games are usually in the middle to high 100s.", 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4065], 'genres' => [11], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 688, 'game_title' => 'Shadow Blasters', 'release_date' => '1990-08-09', 'platform' => 18, 'overview' => "The evil god Ashura has unleashed hordes of monsters and demons onto Earth, hoping to take control of the planet as well as the hearts of men. The powerful god Hyprion has recruited four of Earth's most powerful warriors and assembled them into a team to fight the encroaching darkness. The player assumes control of this group of warriors in order to defeat the armies and their god, Ashura.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7712], 'genres' => [1], 'publishers' => [157], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 689, 'game_title' => 'Shadow of the Beast', 'release_date' => '1991-11-01', 'platform' => 18, 'overview' => "There Can Only Be One Master. Destroy the dreaded Dracubeast before his fangs rip through your battle armor. Eliminate the Pit Fiend and capture his Fiery Storm. Lobsterjaw and his wicked bosses defend the secrets of the Master's fortress. Beware of Tuskinhead and his evil minions as you assault the Master's castle!", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7109], 'genres' => [1], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 690, 'game_title' => 'Shaq-Fu', 'release_date' => '1994-10-28', 'platform' => 18, 'overview' => "Shaq brings his awesome skill and size to a multiworld fighting game! As Shaq, use your lightning-fast shuriken and other martial art techniques to prevail over 11 intensely evil warriors in the enforcement of justice. Or choose any of the 12 warriors and fight head to head. Summon Voodoo's bone-shattering earthquake, rebound with Rajah's shockwave sword or lash out with Sett's terrifying mummy wrap! Scores of secret power moves to discover and master!", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2231], 'genres' => [10], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 691, 'game_title' => 'Sonic the Hedgehog 3', 'release_date' => '1994-02-02', 'platform' => 18, 'overview' => 'Swing from vines, launch new attacks, survive deadly traps and summon Tails to airlift Sonic out of danger. Discover hidden rooms and passageways in the mega-sized Zones. Transform into Super Sonic and experience the ultimate in speed and ultra-sonic power. Save your progress using the new Game Save Feature.', 'youtube' => 'rijqRjPVd3c', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7979], 'genres' => [2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 692, 'game_title' => 'Sonic Spinball', 'release_date' => '1993-11-23', 'platform' => 18, 'overview' => "Dr. Robotnik has assumed control of Mt. Mobius and turned it into a mechanical base. Utilizing energy produced by the magma flowing under the volcano, this new monstrosity (the Veg-O-Fortress) has the power to transform helpless animals into robot slaves at an astounding rate. Sonic the Hedgehog and Tails fly onto the scene to mount an aerial assault, but Sonic is knocked off the wings of Tails' airplane by a blast from the fortress. He falls into the water, but is rescued and taken to the subterranean levels of the Veg-O-Fortress. The fortress must be destroyed from the inside-out, and the only way to make that happen is to trigger an eruption in the volcano it's built on. Sonic knows this can be done by removing the Chaos Emeralds that keep the volcano stable. Robotnik, however, is also aware of the fragile relationship that exists between the Emeralds and the mountain, and he's set up an elaborate Pinball Defense System to make sure the precious jewels don't go anywhere.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7574], 'genres' => [1, 5], 'publishers' => [15], 'alternates' => ['Sonic the Hedgehog Spinball'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 693, 'game_title' => "Street Fighter II': Special Champion Edition", 'release_date' => '1993-09-27', 'platform' => 18, 'overview' => "From the corners of the globe come twelve of the toughest fighters to ever prowl the streets. Choose your champion and step into the arena as one of the eight original challengers or as one of the four Grand Masters! Pound your opponent as Balrog and knock them out for the count. Tower over your prey as Sagat and daze them with your awesome Tiger Shot. Slash your opponent with Vega's claw and send them running for cover. Or strike fear into your enemies as M. Bison, the greatest Grand Master of them all!", 'youtube' => 'https://www.youtube.com/watch?v=1JKogi5nXCY', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [10], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 694, 'game_title' => 'Streets of Rage 2', 'release_date' => '1992-12-20', 'platform' => 18, 'overview' => "Original rumblers Axel and Blaze slam the asphalt with bigger, better, totally devastating attacks! Skull-crushing ex-wrestler Max Thunder joins up with earth-shattering body slams and spinning fist attacks. New thrasher Skate slices punks with high speed in-line skate attacks and spinning jump kicks. Go maniac with jaw-shattering, bone-busting punches, head-cracking jump kicks and secret weapons. Gangs of dirt bikers dive into you from every side. Smash 'em with a pipe as they speed by. 16 gigantic megs of compound fractures! All new moves, and more of 'em! Bust knuckles with a friend in an all-new 2-player head-to-head mode!", 'youtube' => '', 'players' => 2, 'coop' => 'Yes', 'rating' => 'Not Rated', 'developers' => [7549], 'genres' => [1, 10], 'publishers' => [15], 'alternates' => ['Streets of Rage II'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 695, 'game_title' => 'Sunset Riders', 'release_date' => '1991-09-04', 'platform' => 18, 'overview' => 'The game, which is set in a fanciful version of the American Old West, revolves around four bounty hunters who are out to claim rewards given for eliminating the most wanted outlaws in the West. There is no true "storyline" aside from collecting progressively larger rewards. At the beginning of each level the player is shown a wanted poster, showing the criminal, the reward for stopping them, and the cliché line "Wanted dead or alive".', 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [1, 2], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 696, 'game_title' => 'Shove It! ...The Warehouse Game', 'release_date' => '1990-01-01', 'platform' => 18, 'overview' => "Shove It! follows a burly warehouse worker, whose aspiration is to earn enough money to buy an expensive car and impress the ladies. What must this worker do? Move boxes.\r\n\r\nThe worker is placed in a special grid, and there are only a few different types of blocks: movable crates, locations for crates, and barriers. Crates can only be pushed, not pulled, and only one at a time. The object of each stage is to move each crate to one of the designates spots where crates must be placed. When this is complete, the worker progresses. There is a multitude of stages, grouped in clusters of ten apiece.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2509], 'genres' => [9], 'publishers' => [158], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 697, 'game_title' => 'Shining in the Darkness', 'release_date' => '1991-03-28', 'platform' => 18, 'overview' => "Shining in the Darkness is a \"dungeon-crawler\" RPG. The game puts the player in control of the main character as he and two friends (Pyra and Milo) explore 3-dimensionally rendered dungeon mazes.\r\n\r\nThe game consists of story line interaction, dungeon exploration, random monster fights, and predetermined 'boss' fights. The combat in this game operates similarly to certain RPG games of the same era (e.g. Dragon Quest). Monster encounters happen randomly during dungeon exploration at which point turn-based combat proceeds.\r\nAdditionally, the dungeon contains three characters in need of rescue. Rescuing any or all of the three is optional, and the story changes depending on whether or not the player locates and returns each of these characters to safety.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1685], 'genres' => [4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 698, 'game_title' => "Space Invaders '91", 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "Space Invaders '91 is a port of the the coin-op Space Invaders '91, just like Super Space Invaders for other platforms, but still different from those. This version differs from Super Space Invaders in that there are no cutscenes, there is only one mode of play as opposed to SSI's two, and there is no stage select.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8449], 'genres' => [8], 'publishers' => [56], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 699, 'game_title' => "Spider-Man / X-Men: Arcade's Revenge", 'release_date' => '1994-06-24', 'platform' => 18, 'overview' => "In the first level, the player controls Spider-Man who must use his spider sense to disarm several bombs located throughout the immediate exterior and maze-like entrance to an abandoned building. After the player completes this level Spider-Man learns that the evil Arcade has kidnapped Storm, Cyclops, Wolverine, and Gambit. The player must successfully complete each character's level (each set in Arcade's deadly \"Murderworld\") in order to get to control Spider-Man in a final battle with Arcade.\r\n\r\nAfter completing each stage, the player controls each hero as they fight in similar-designed mini-levels themed after the \"Behind-the-Scenes\" of Murderworld. The only character to have a significant change is Storm, who now walks, shoots multiple bolts of lightning rapidly and calls upon gusts of wind, and jumps about four times the height of the other characters. The last level takes place inside a large room, where Arcade chases Spider-Man back and forth in a large Arcade-shaped robot, which operates like a Matryoshka Doll, until Arcade is finally defeated. The X-Men stand-by at the edges of the room, occasionally attacking on their own.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [7940], 'genres' => [1, 15], 'publishers' => [118], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 700, 'game_title' => 'Sports Talk Baseball', 'release_date' => '1991-08-30', 'platform' => 18, 'overview' => "Players can play either exhibition, regular season, all-star, or playoff games. The game also features authentic Major League Baseball rosters for the 1991 season. Gameplay commonly features double and triple plays, and only the fastest runners in the game are capable of stealing bases. It was one of the first video games to feature individual hitting abilities for each pitcher. Classic match-ups include Texas' Nolan Ryan versus Oakland's lineup with such all-stars as Jose Canseco, Rickey Henderson, Dave Henderson, and Mark McGwire.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => nil, 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 701, 'game_title' => 'Spot Goes To Hollywood', 'release_date' => '1995-11-21', 'platform' => 18, 'overview' => 'The central character in the game is, of course, Spot. Spot has somehow become trapped in a movie projector. As he jumps from film to film, he encounters many classic film genres; these make up the various levels of the game. The main levels are a pirate movie, an adventure movie, and a horror movie, but there are many other bonus films to unlock.', 'youtube' => '', 'players' => 1, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [2886], 'genres' => [2], 'publishers' => [48], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 702, 'game_title' => 'Strider', 'release_date' => '1990-09-29', 'platform' => 18, 'overview' => "Set in the future, the game centers around a secret organization of ninja-like operatives known as \"Striders\", who specializes in various kinds of wetworks such as smuggling, kidnapping, demolitions, and disruption. The player takes control Strider Hiryu, the youngest elite-class Strider in the organization. Hiryu is summoned by the organization's second-in-command, Vice Director Matic, to assassinate his friend Kain, who has been captured by hostile forces and has become a liability to the Striders. Instead of killing him, Hiryu decides to rescue Kain from his captors. With the help of his fellow Strider Sheena, Hiryu uncovers a conspiracy between a certain faction of the Strider organization led by Matic himself and an unknown organization known simply as the \"Enterprise\" (headed by a man named Faceas Clay) which involves the development of a mind-control weapon codenamed \"Zain\". In the course of finding and destroying these Zain units, Hiryu learns that the faction of conspirators is headed by Vice Director Matic himself. Hiryu eventually tracks Matic to an orbiting space station where the two Striders face off; after a brief battle Hiryu bests Matic and kills him. Afterwards Hiryu locates and destroys the last of the Zain units.\r\n\r\nIn the epilogue, it is revealed that though Hiryu was asked to return to the Strider organization he instead opted to retire. The final credits show him sheathing his weapon and walking away.\r\n\r\n\" Sega produced their home version of Strider for the Mega Drive/Genesis, which was released in Japan on September 29, 1990, with subsequent releases in North America and the PAL region. It was advertised as one of the first 8-Megabit cartridges for the system, and went on to be a bestseller. This version was also re-released for the Wii Virtual Console in Japan on November 15, 2011 and later in North America on February 16, 2012. The Genesis/Mega Drive version contains a different ending from the arcade game. This ending shows the destruction of the final stage as the game's protagonist makes good his escape. This is then followed by the main credit sequence that sees Hiryu flying his glider in space and reminiscing about the various encounters he had during his mission as he heads back to earth. The ending theme was an edited combination of two separate pieces of music planned for the arcade game, but replaced with a repeat of the first level music. Computer magazine ACE considered the previous Amiga conversion to be \"as good as this one\". \" -Wikipedia", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [1, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 703, 'game_title' => 'Super High Impact', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => 'Super High Impact was one of the most hard hitting football games before the NFL Blitz series was created, with 18 teams and over 30 plays per team. The console versions are based on the Midway arcade series of the same name. The game has a Hit-O-Meter which often leads to massive brawls. Based on the arcade smash hit back in the days, featuring the three famous words: EAT THIS!!!, FIGHT!!!', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [5507], 'genres' => [11], 'publishers' => [159], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 704, 'game_title' => 'Super Thunder Blade', 'release_date' => '1989-08-14', 'platform' => 18, 'overview' => 'As in its predecessor, the player takes control of an helicopter which is used to attack a group of guerrillas. The helicopter itself uses guns and missiles, and can also air brake. A distinctive feature that also appears in the arcade game is the use of different viewpoints during the entire game; during normal gameplay and when fighting sub-bosses, the game utilizes a third-person perspective from behind the helicopter, similar to Space Harrier, but the camera changes to a top-down perspective when fighting bosses. Super Thunder Blade had four stages of play.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 705, 'game_title' => 'Sword of Vermilion', 'release_date' => '1989-12-15', 'platform' => 18, 'overview' => "Sword of Vermilion is about the son of Erik, king of Excalabria, who takes on a quest of revenge to defeat Tsarkon and free the world of Vermilion from evil.\r\nIn the town of Excalabria the people went about their business, and tended to the fields. One day, vicious fighting broke out everywhere as the army from Cartahena, led by the wizard-king Tsarkon, swarmed all over the town. The townsmen were overwhelmed, and the castle of King Erik V collapsed. Erik V summoned his bravest, strongest and most faithful warrior, Blade, and gave him his infant son and an ancient family heirloom, the Ring of Wisdom. Erik ordered Blade to save himself and the child while the castle burned. Blade traveled to a small village named Wyclif, where he settled down and raised the child as his own son. Eighteen years later, the son of Erik begins his quest.\r\nThe quest consists of travelling to towns and villages, battling creatures to gain experience and finding items such as swords, shields and armour, as well as many other items such as Herbs and Candles. Boss monsters take the form of larger, stronger creatures which are integral to the story. Fighting Boss Monsters takes place on a side on view of the battle where magic cannot be used.\r\nThe titular Sword of Vermilion is the most powerful weapon at the end of the game.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [7549], 'genres' => [4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 706, 'game_title' => 'Syndicate', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "The game puts the player in charge of a self-named corporation in a gritty near-future cyberpunk-style world. Game play involves ordering a four-person team of cyborg agents around cities displayed in a fixed-view isometric style, in pursuit of mission goals such as assassinating executives of a rival syndicate, rescuing captured allies, \"persuading\" civilians and scientists to join the player's company or simply killing all enemy agents.\r\nAs the player progresses through the game, they must manage the research and development of new weaponry and cyborg upgrades. The player has only limited funds, requiring taxation of the conquered territories while ensuring that they are not so over-taxed that they revolt against the player. The player begins the game with simple pistols, progressing through increasingly destructive weaponry that includes Uzis, miniguns, flamethrowers, sniper rifles, time bombs, lasers and the enormously destructive Gauss gun (a rocket launcher). In addition, the player can use items such as medikits to heal his agents, scanners to locate pedestrians/vehicles and the \"Persuadertron\" to brainwash the player's targets into blind obedience.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1383], 'genres' => [6, 8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 707, 'game_title' => 'TaleSpin', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => 'This game involves the adventures of Baloo and Kit, two bears delivering cargo for Rebecca, another bear. However, Shere Khan, the evil tiger tycoon, wants to put Rebecca out of business, so he hires pirates, led by Don Karnage, to do his dirty work.', 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [1, 15], 'publishers' => [9], 'alternates' => ['Tale Spin'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 708, 'game_title' => 'Target Earth', 'release_date' => '1990-03-16', 'platform' => 18, 'overview' => "Target Earth is about Earth's outcasts, who have become Cyborgs, returning from space to attack the civilization that remained behind. The Earth Defense League fights to defend Earth in a galactic war. The battle begins on Ganymede. The game alternates between battles in space, on planets, on the earth and inside enemy outposts.\r\nFighting for the OPTOF (Outer Planet Treaty Organization Force),you pilot the Assault Suit Valken 2. Your enemy is the Daess.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [5851], 'genres' => [1], 'publishers' => [160], 'alternates' => ['Assault Suit Leynos'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 709, 'game_title' => 'Team USA Basketball', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => 'The game could be played in various ways: players could play against each other, or against the computer. Games against the computer were divided into two levels, "exhibition" or "tournament". Players could pick from one of the countries around the world to represent in the Olympics: USA, Yugoslavia, Angola, Australia, Canada, China, the CIS, Croatia, France, Italy, Lithuania, Slovenia, Netherlands, Spain.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 710, 'game_title' => 'Technoclash', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "Long ago, magic was used in everyday life, the world lived in harmony where wizards lived happily among themselves. A mysterious portal appeared in the sky where machines started emerging, causing havoc upon the magical world. Ronaan is a wizard who embarks on a journey after a magical staff is stolen from his homeland. The war between the machines and magic have only just begun, It's up to Ronaan, Farrg and Chaz to prevent the destruction of their world as they travel through Las Vegas, a junkyard, a desert and the heart of the Machine Empire.", 'youtube' => '', 'players' => 0, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [1, 4], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 711, 'game_title' => "Scholastic's The Magic School Bus: Space Exploration Game", 'release_date' => '1995-01-01', 'platform' => 18, 'overview' => 'Based on the PBS kids program, The Magic School Bus along with Ms. Frizzle and her companion Liz takes the player throughout the solar system one planet at a time to learn about them while exploring each one. Along the way, players will be transported on the bus on their way to the next planet where they can take photos of the planets, their moons, stars, among many other things they can see. Along the way they will encounter puzzles they have to solve in order to advance using the facts they have learned through their planetary visit and can also build their own solar system in any way they choose.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6155], 'genres' => nil, 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 712, 'game_title' => 'The Pirates of Dark Water', 'release_date' => '1994-01-01', 'platform' => 18, 'overview' => "The Pirates of Dark Water is a side scrolling hack'n slash platformer with a few adventure elements.\r\n\r\nYou take control of either Ren, Ioz or Tula who can jump, climb, attack and throw enemies. In most levels you are required to find keys to unlock doors and talk to NPCs who will give you hints. You will also find numerous useful items including throwing weapons, food to replenish your health, potions that have different effects such as temporary invincibility, money that is needed to pay certain NPCs and melons that can be fed to Niddler who will take you back to the map screen in turn.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4065], 'genres' => [1, 15], 'publishers' => [104], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 714, 'game_title' => 'Thunder Force II', 'release_date' => '1989-08-14', 'platform' => 18, 'overview' => "Taking place soon after Thunder Force, the ORN Empire creates a powerful new battleship, the Plealos (a.k.a Preareos). Using this battleship, ORN once again attacks the Galaxy Federation. The outcome of the attacks result in the destruction of the Galaxy Federation affiliated planet of Reda, and heavy destruction on the planet Nepura (a.k.a. Nebula), which ORN eventually captures from the Galaxy Federation.\r\nEventually, the Galaxy Federation learns that ORN houses Plealos deep below Nebula's surface when not in use and takes the opportunity to plan an operation to take it down. They send the next iteration of their Fire Leo series of fighter craft, the FIRE LEO-02 Exceliza, to destroy ORN bases on Nepura and eventually find and destroy Plealos. The player controls the Exceliza and travels through a variety of stages to accomplish this goal.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8609], 'genres' => [8], 'publishers' => [137], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 715, 'game_title' => "Tiny Toon Adventures: Buster's Hidden Treasure", 'release_date' => '1993-02-07', 'platform' => 18, 'overview' => "Hit it big when you join Buster Bunny on a 33 stage hunt for treasure. So loaded with hare-raising animation, it's like playing in a whacked-out Tiny Toon cartoon! Do you dare to set paw on this mysterious island? Trip through 7 tangly territories that include an overly-enchanted forest, caverns of bubbling lava-lava, secret underground seas, plains that are just plain crazy, a freaky factory, a mega mountain and a spooky shipwreck rumored to be dripping in 14 carrot gold! Save Babs Bunny and the rest of your pals along the way and you'll really see some kooky island hopping. With Gogo Dodo as your guide, you can be sure this adventure is packed with tricks, traps, and hidden bonus areas!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4765], 'genres' => [1, 15], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 716, 'game_title' => 'ToeJam & Earl in Panic on Funkotron', 'release_date' => '1993-04-01', 'platform' => 18, 'overview' => "The plot of the game follows on from that of its predecessor, which followed the adventures of alien protagonists ToeJam and Earl after they crash landed on Earth. After escaping to their home planet of Funkotron, the characters discover that antagonistic Earthlings have stowed-away on the duo's spacecraft.\r\n\r\nA sub-plot involves ToeJam and Earl's attempt to lure Lamont the Funkapotamus back from the Funk Dimension, where he is hiding from the invading Earthlings.\r\n\r\nToeJam and Earl must hunt down Earthling antagonists, which include a \"pneumatic-drill-crazed construction worker, a camera-wielding tourist, our old friends the bogymen [sic], pea-shooter armed kids and a rather rotund woman with ankle-snapping poodles.\r\n\r\nCapturing Earthlings involves rummaging for them in bushes and trees, before pelting the antagonist with \"jars\" which imprison them. The player completes a level by catching all the at large Earthlings and sending them back to Earth via spacecraft.", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [4506], 'genres' => [1, 15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 717, 'game_title' => 'Toki: Going Ape Spit', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "The hero of the game is a young jungle-man named Toki. One day the evil wizard Dr. Stark kidnaps his girlfriend Wanda. When Toki tries to save her, he is turned into a monkey! Now Toki has to find Dr. Stark in his palace, to rescue Wanda, and to become a human being again!\r\n\r\nIt is a platform game with a lot of various levels: jungle, underwater, volcanic caves, on the ice... Toki's only weapons are spitting on the enemies or jumping on them and crashing them. There are many possibilities to upgrade his spitting \"weapon\"; for example, if he finds an upgrade, he can spit fireballs.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [8442], 'genres' => [1, 15], 'publishers' => [15], 'alternates' => ['JuJu Densetsu'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 718, 'game_title' => 'Tommy Lasorda Baseball', 'release_date' => '1989-08-14', 'platform' => 18, 'overview' => "It's batter-up and time for Tommy Lasorda's version of Pro-Ball. Whether you're infield or outfield, at the plate or on the mound, stealing bases or catching fly-balls, the competition is hot and you're even hotter now that you're playing with a big leaguer like Lasorda. And you've got control. Curve balls, fastballs or sliders are some of the wind-ups you'll pitch to outwit your batter. But be prepared when he connects, you'll have to think fast to make your players perform like a well-oiled machine. Are you up for a single, double, or even triple play? It all depends on how you throw the ball. But don't worry, you'll get your chance at bat. This is a race for the Pennant, so you better hope Tommy's on your side. Now take your pick, choose your line-up and let's play ball!", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [11], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 719, 'game_title' => 'Traysia', 'release_date' => '1992-02-14', 'platform' => 18, 'overview' => 'In Traysia the player controls a young man named Roy, who lives in the town Johanna. All his life Roy has been dreaming about leaving the town and going to explore faraway lands. Now, finally, his chance has come. His uncle, a travelling merchant, is going on a journey, and Roy decides to leave with him. His girlfriend Traysia gives him a pendant, to remind him of her... will Roy be able to escape from all the dangers that await him on his long journey and to see Traysia again?', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [8640], 'genres' => [4], 'publishers' => [119], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 720, 'game_title' => 'Triple Play: Gold Edition', 'release_date' => '1996-02-16', 'platform' => 18, 'overview' => 'Triple Play: Gold Edition is a baseball game released exclusively for the Sega Mega Drive. It is part of the long running Triple Play series.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2952], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 721, 'game_title' => 'Truxton', 'release_date' => '1989-12-09', 'platform' => 18, 'overview' => 'Taking place somewhere in space: an armada of Gidans, led by the evil Dogurava, is invading the planet Borogo aboard five gargantuan asteroids. After surviving an attack on an orbiting Borogo cargo barge, a pilot enters one remaining fighter and challenges the Gidans in a desperate attempt to quell the alien invasion and divert their asteroid fortresses in the process.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [8503], 'genres' => [8], 'publishers' => [15], 'alternates' => ['Tatsujin - Truxton', 'Tatsujin'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 722, 'game_title' => 'Ultimate Qix', 'release_date' => '1991-01-01', 'platform' => 18, 'overview' => "Taking place in another galaxy, a space pilot is returning to his home world of Volfied, only to discover that it is under attack by an unknown alien force. The few remaining Volfied inhabitants are in an underground location of the planet and signal the pilot to their aide. The pilot flies to Volfied using his ship's defensive weapons in order to eliminate the alien threat and save his people.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => [4378], 'genres' => [5], 'publishers' => [56], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 723, 'game_title' => 'Urban Strike', 'release_date' => '1993-03-04', 'platform' => 18, 'overview' => "Home Field Advantage!\r\n\r\nFirst the Desert Madman, then the Jungle Drug Lord... now a new evil challenges the Strike C.O.R.E., right here in America! Ruthless media mogul and political maverick H.R. Malone secretly plans to destabilize the U.S. government. Crust this rebellion at all cost!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8726], 'genres' => [1], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 724, 'game_title' => 'Valis III', 'release_date' => '1991-03-22', 'platform' => 18, 'overview' => "Somewhere in the Dark World, evil rears its ugly head once again...\r\nA black-hearted man named Glames, possessor of a sword named Leethus, threatens the Human World, the Dream World, and the Dark World with complete and utter destruction. A young girl from the Dark World named Cham escapes from Glames, and seeks help to destroy him.\r\n\r\nShe comes to the Human World, searching for the Valis Warrior, Y?ko Asou, and more importantly, the Valis Sword.\r\n\r\nYuko must now help Cham defeat Glames before the three worlds are torn apart!", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8640], 'genres' => [1, 2], 'publishers' => [119], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 725, 'game_title' => 'Virtual Pinball', 'release_date' => '1993-11-01', 'platform' => 18, 'overview' => 'One to four players can choose from either 29 pre-made games or design one using the in-game editor tools. Designing options include ten different backgrounds and six themes. You also get to choose where objects are placed, the style of music, and the ball speed. Up to ten personal games can be saved.', 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1067], 'genres' => [11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 726, 'game_title' => 'Warlock', 'release_date' => '1995-09-01', 'platform' => 18, 'overview' => "Once every thousand years, the sun and the moon align together. When this happens, the Evil One sends his only son, the Warlock, to Earth to gather six ancient runestones. When assembled, the runestones give the possessor ultimate power to undo the Earth's creation. Using sorcery inherited from his ancestors, a modern druid must travel through time to prevent the Warlock from finding all of the runestones.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7050], 'genres' => [1], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 727, 'game_title' => 'Wheel of Fortune', 'release_date' => '1992-01-01', 'platform' => 18, 'overview' => 'A very basic translation of the popular game show Wheel Of Fortune, where you guess letters until you can guess the phrase. This CGA version has three old-school rounds of Wheel of Fortune (where the puzzles are simply "Phrase", "Title", "Person", etc.) and then a bonus round. You can compete against 2 computer players or up to three people can play against each other.', 'youtube' => nil, 'players' => 3, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [4114], 'genres' => [5], 'publishers' => [80], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 728, 'game_title' => "Winter Olympic Games: Lillehammer '94", 'release_date' => '1993-12-07', 'platform' => 18, 'overview' => "This is the official license of Winter Olympics tournament in 1994 at Lillehammer, Norway. You can practice in any event before the tournament. The game offers two modes - Full Olympics and Mini Olympics, which vary in the number of events.\r\n\r\nIt includes 5 different types of sports - biathlon, alpine skiing (downhill, slalom, giant slalom and Super-G), ski jumping (90 m, 120 m), bobsleigh (2/4 men bob, 1/2 men luge) and skating (elimination, pursuit, time trial). The events use 3D views", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [8826], 'genres' => [11], 'publishers' => [110], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 729, 'game_title' => 'Wonder Boy in Monster World', 'release_date' => '1992-12-04', 'platform' => 18, 'overview' => 'Townsfolk cower in fear as legions of deadly monsters invade the planet. Only Wonder Boy can fight smart enough - and tough enough - to wipe out the terrible beasts. Sleuth out secret clues to thwart the undead. Match wits against an evil force of otherwordly dimensions. And prove the awesome strength and courage of the amazing Wonder Boy!', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9590], 'genres' => [15], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 730, 'game_title' => 'World Series Baseball', 'release_date' => '1994-01-04', 'platform' => 18, 'overview' => "World Series Baseball is the first game in the long-running series. With all 28 teams included, it features the 6 division alignment (introduced shortly before its release), and has all 700 players of the league.\r\n\r\nThe game includes a play-by-play feature and the Home Run Derby. Players are able to play a 162-game season and keep full statistics for every player, thanks to a battery backup. The game also allows players to use the first-person perspective view from the batter's box.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [11], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 731, 'game_title' => 'WWF WrestleMania: The Arcade Game', 'release_date' => '1995-08-10', 'platform' => 18, 'overview' => "WrestleMania's one-player mode has the player choose one of eight wrestlers - Bam Bam Bigelow, Bret Hart, Doink the Clown, Lex Luger, Razor Ramon, Shawn Michaels, The Undertaker or Yokozuna. One unique feature is that each character can \"bleed\" his respective objects other than blood upon taking damage from most attacks in the Mortal Kombat sense. Such \"bleeding\" objects include Yokozuna's food and Bam Bam Bigelow's flames.\r\nWWF WrestleMania features two single-player modes: the Intercontinental Championship and the WWF Championship. In the Intercontinental Championship mode, the player must win four one-on-one matches, two two-on-one matches, and one three-on-one match to win the title. In the more difficult WWF Championship mode, the player must win four two-on-one matches, two three-on-one matches, and finally a \"WrestleMania Challenge,\" where the player must defeat every wrestler in the game in a gauntlet, starting with a three-on-one setup, with each eliminated opponent being replaced with another until all eight have been defeated.\r\nThe game also features two multi-player modes; head to head, a one-on-one match between two players, or cooperative, where the two players team up in a tag team version of the WrestleMania Challenge in which they must defeat the game's eight wrestlers in groups of two to become the Tag Team Champions.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5507], 'genres' => [11], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 732, 'game_title' => "The Ren & Stimpy Show Presents: Stimpy's Invention", 'release_date' => '1993-12-31', 'platform' => 18, 'overview' => 'In one player the player controls either Ren or Stimpy and the computer controls the other character who will simply follow; however, the player can swap the character they control at almost any time during game play. In two player, players controls one character each, both within the same screen (no split screen). In one or two player several special moves can be performed by both characters standing close and a player pressing certain buttons simultaneously, the move differs depending on which buttons are pressed and whether the player is controlling Ren or Stimpy. The ability of swapping characters during game play in one player means the player can perform all the special moves not just those available for one character. The moves include: Stimpy throwing Ren to cover long distance such as over a hole.', 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1233], 'genres' => [2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 733, 'game_title' => 'Sonic & Knuckles', 'release_date' => '1994-10-18', 'platform' => 18, 'overview' => "Sonic and Knuckles join forces to defeat rotten Dr. Robotnik's Death Egg invasion! Play Sonic & Knuckles by itself or Lock-on with other Sonic games. This game's revolutionary Lock-on technology adds all new features to your other Sonic games for ultimate replays! Play as Sonic and let loose on Robotnik with amazing new powers. Play as Knuckles and tackle Robotnik and Metal Sonic with bare-fisted attacks, high-speed glides and wall-climbing power! Lock-on with Sonic 3 and transform Floating Island into a huge 34 meg Sonic-epic loaded with new secrets! Play as Sonic, Knuckles, and even Tails - with Game Save! Lock-on with Sonic 2 and play as Knuckles with all his signature moves!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 734, 'game_title' => 'Road Rash II', 'release_date' => '1993-07-22', 'platform' => 18, 'overview' => "Road Rashing isn't just a sport. It's an attitude! Road Rash II is the ultimate 2-player racing game with a radically unique split-screen for distinguishing between racers. Cruising cross-country was never this hairy! Spectacular new body-torquing wipe outs! More obstacles to crash into than ever before. Terrorize your opponents on 5 new tracks, each with 5 different levels. Swing a steel chain for some real heavy metal damage! 15 brand new, lightning-fast cycles, including nitro-equipped Super-Bikes!", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [1], 'publishers' => [2], 'alternates' => ['Road Rash 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 735, 'game_title' => 'Cool Spot', 'release_date' => '1994-02-18', 'platform' => 18, 'overview' => 'Cool Spot is a solid, colorful platform game featuring the 7-up mascot in the hero position. The game objective is fairly simple; you have to collect enough number of bonuses throughout each level in order to find the trapped Spots.', 'youtube' => nil, 'players' => 1, 'coop' => nil, 'rating' => 'E - Everyone', 'developers' => [9399], 'genres' => [2], 'publishers' => [48], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 736, 'game_title' => 'Battletoads', 'release_date' => '1991-01-14', 'platform' => 18, 'overview' => "After her defeat by the Galactic Corporation at the battle of Canis Major, the evil Dark Queen and her renegade space troops retreat to the outer reaches of the universe, hiding out in dark spaces between the stars. Meanwhile, on board the spaceship Vulture, Professor T. Bird and the trio of Battletoads - Rash, Zitz and Pimple - are escorting the Princess Angelica back to her home planet, where her father, the Terran Emperor, awaits her safe arrival. Along the way, Pimple, the biggest Battletoad, takes Angelica out for a cruise in the Toadster to a nearby Leisure Station, but the Dark Queen ambushes them before they can get there, and they are kidnapped and carried away to Ragnarok's World, the Dark Queen's planet. Professor Bird sends remaining Battletoads down on Ragnarok to save Pimple and Angelica, but it will be a hard battle against planet's dangerous environments, traps and Dark Queen's troops. They have to go a long way from the planet's rough surface to deep caves and landed Gargantua and ultimately to the Tower of Shadows, where the Dark Queen awaits.", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6991], 'genres' => [1], 'publishers' => [164], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 737, 'game_title' => 'After Burner III', 'release_date' => '1992-04-17', 'platform' => 21, 'overview' => "You're strapped into the Navy's fiercest jet fighter-the F-14 Tomcat. Kick in the afterburner to outrun deadly cannon fire \"hot on your six.\" Pull up hard...lock and launch! Roll 360 degrees to blow desert tank patrols, radio towers, and missile sites into oblivion.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1923], 'genres' => [8, 19], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 738, 'game_title' => "Dragon's Lair", 'release_date' => '1994-06-19', 'platform' => 21, 'overview' => "Dragon's Lair features the hero, Dirk the Daring, attempting to rescue Princess Daphne from the evil dragon Singe, who has locked Daphne in a wizard's castle. The screen shows animated scenes, and the player executes an action by selecting a direction or pressing the sword button with correct timing. The comedy of the game stemmed not only from the bizarre looking creatures and death scenes, but also the fact that while Dirk was a skilled knight, he was somewhat clumsy in his efforts, as well as being a reluctant hero, prone to shrieking and reacting in horror to the various dangers he encounters.", 'youtube' => 'XXgAfyVYN2c', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [268], 'genres' => [2], 'publishers' => [56], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 739, 'game_title' => 'Sewer Shark', 'release_date' => '1992-10-15', 'platform' => 21, 'overview' => "Sewer Shark takes place sometime in the future, where environmental destruction has forced most of humanity to live underground. The player takes the role of a rookie pilot in a band of \"sewer jockies\", whose job is to exterminate dangerous mutated creatures to keep a vast network of sewers clean for the resort area \"Solar City\", an island paradise ruled by the evil Commissioner Stenchler (Robert Costanzo). The player's co-pilot, Ghost (David Underwood), evaluates the player's performance throughout the game, while a small robot named Catfish scouts ahead and gives directions. The player is later assisted by Falco, a female jockey who believes that there is a hidden route to the surface. Falco is later captured by Stenchler, who threatens to turn her into one of his mindless minions. This plot is thwarted when Ghost and the player reach Solar City.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'E - Everyone', 'developers' => [2348], 'genres' => [8, 19], 'publishers' => [77], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 740, 'game_title' => 'Star Wars: Rebel Assault', 'release_date' => '1993-01-01', 'platform' => 21, 'overview' => "The game follows the adventures of a young pilot known as Rookie One, a farmer from Tatooine in the style of Luke Skywalker. The game largely takes place during the events of Episode IV: A New Hope, however the sequences on Hoth from The Empire Strikes Back are included.\r\nThe game begins with Rookie One's training (you), followed by an attack on the Star Destroyer Devastator, after its capture of the Tantive IV in the events of the film. The story then leads the player to sequences to defend the Rebel Base on Hoth from the attack shown in the Empire Strikes Back, and finally ends in the assault on the Death Star of the film, with the player taking the place of Luke Skywalker in destroying the battle station.", 'youtube' => 'F6yOX2vmxgY', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5068], 'genres' => [1, 8], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 741, 'game_title' => 'Surgical Strike', 'release_date' => '1993-11-16', 'platform' => 21, 'overview' => "The elite Special Forces unit, The Surgical Strike Team, have been called into action. High-tech urban guerrillas are attacking innocent people but once they're done with their carnage they fade back into the landscape. In a very delicate way, the Team must find these hidden enemies and get rid of them without harming innocent citizens. Inside your hovercraft, you can charge at the violent creatures, turn 180 degrees to watch your own back and explore new uncharted areas. You have a choice of weaponry choose the 30MM Gatling gun or the laser-guided rockets. AWACs C-130's hover above and give you pointers, plus on-board mapping allows you to zero in on hidden emplacements.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [1720], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 742, 'game_title' => 'Aero Fighters 3 / Sonic Wings 3', 'release_date' => '1995-01-01', 'platform' => 24, 'overview' => "The world seems to be free from the menace of the evil alien forces. However, they are not willing to give up and launch a surprise attack against the Aero Fighters' base, effectively destroying their aircraft. Unable to counter the attack, they must use old WWII-era warplanes with strange modifications, in a desperate scramble for victory.", 'youtube' => '', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [9375], 'genres' => [1, 8], 'publishers' => [165], 'alternates' => ['sonicwi3'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 743, 'game_title' => 'Aero Fighters 2 / Sonic Wings 2', 'release_date' => '1994-08-26', 'platform' => 24, 'overview' => "The game is played with two buttons, with the A button firing bullets from the plane and the B button launching a special bomb attack which uses a bomb from a limited stock of bombs. Power bullets can be obtained by destroying buildings and armored enemy planes. There are 2 types of Power bullets: \"P\" Power bullets, that increases the plane's firepower by one level, and \"F\" Power bullets, that increases the plane's firepower to the maximum level instantly. The maximum level only lasts for a limited amount of shots.\r\nWhen certain ground enemies and buildings are destroyed, money bonuses appear which give a random amount of points each. When the player reaches the end of the stage, the player has to face a boss ship.", 'youtube' => '', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [9375], 'genres' => [1, 8], 'publishers' => [165], 'alternates' => ['sonicwi2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 744, 'game_title' => 'Samurai Shodown', 'release_date' => '1993-08-11', 'platform' => 24, 'overview' => 'The game is set in the late 18th century and all the characters wield weapons. The game uses comparatively authentic music from the time period, rife with sounds of traditional Japanese instruments, such as the shakuhachi and shamisen, and a refined version of the camera zoom first found in Art of Fighting. True to its use of bladed weapons, the game also included copious amounts of blood.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [10], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 745, 'game_title' => 'Doom', 'release_date' => '1993-12-10', 'platform' => 1, 'overview' => "In Doom, a nameless space marine, gets punitively posted to Mars after assaulting a commanding officer, who ordered his unit to fire upon civilians. The Martian marine base acts as security for the Union Aerospace Corporation UAC, a multi-planetary conglomerate, which is performing secret experiments with teleportation by creating gateways between the two moons of Mars, Phobos and Deimos. Suddenly, one of these UAC experiments goes horribly wrong; computer systems on Phobos malfunction, Deimos disappears entirely and \"something fragging evil\" starts pouring out of the gateways, killing or possessing all UAC personnel! \r\nResponding to a frantic distress call from the overrun scientists, the Martian marine unit is quickly sent to Phobos to investigate, where you, the space marine, are left to guard the hangar with only a pistol while the rest of the group proceeds inside to discover their worst nightmare. As you advance further, terrifying screams echo through the vast halls, followed by a disturbing silence ... it seems, all your buddies are dead and you're all on your own now - fight back, exterminate every evil creature and get your ticket back home to earth!", 'youtube' => 'u2CzxI04qHs', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [1, 8], 'publishers' => [166], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 746, 'game_title' => "Monkey Island II: LeChuck's Revenge", 'release_date' => '1991-01-01', 'platform' => 1, 'overview' => "LeChuck's Revenge is set in the fictional Tri-Island Area of the Caribbean, several months after The Secret of Monkey Island. The game opens in medias res as Guybrush Threepwood hangs on a rope above a hole, narrating to Elaine Marley on a separate rope the events that led to this situation. The flashback sequence starts on Scabb Island and constitutes most of the playable game's setting. During it, Guybrush also visits Phatt Island, Booty Island, and Dinky Island, voyaging on two different pirate ships.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [5068], 'genres' => [2, 4], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 747, 'game_title' => 'Star Wars: Dark Forces', 'release_date' => '1995-02-15', 'platform' => 1, 'overview' => "The storyline in Dark Forces follows Kyle Katarn, a mercenary employed by the Rebel Alliance. Before the events in Dark Forces, Katarn was a student learning the skills required to follow in his father's career of agricultural mechanics. While he was studying at an academy, he was told by officials that rebels had killed his parents. The pain from this caused him to enlist in the Imperial army.\r\n\r\nKatarn met Jan Ors who was undercover as a double agent and they got to know each other. Ors uncovered the real information about Katarn's parents which detailed that the Empire was really behind their deaths. The empire eventually discovered that Ors was working for the rebels and she was taken prisoner. Katarn helped her escape, thus ending his career with the Empire. Katarn soon became a mercenary and, due to his hatred of the Empire for killing his parents, he takes on jobs from the Rebel Alliance.", 'youtube' => 'F5YjJsh6BEk', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [8], 'publishers' => [25], 'alternates' => ['Dark Forces'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 748, 'game_title' => 'Age of Empires', 'release_date' => '1997-10-15', 'platform' => 1, 'overview' => 'Control your tribe with the mouse. Make them build houses, docks, farms, and temples. Advance your civilization through time by learning new skills. The game allows for the player to advance through the ages: stone age, tool age, bronze age. If the player would rather get away from the historical aspect, the game offers a random terrain generator and a custom scenario builder.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2817], 'genres' => [6], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 749, 'game_title' => 'Age of Empires II: The Age of Kings', 'release_date' => '1999-09-30', 'platform' => 1, 'overview' => 'The Age of Kings focuses on building towns, gathering resources, creating armies, and destroying enemy units and buildings. Players conquer rival towns and empires as they advance one of 13 civilizations through four "Ages": the Dark Age, the Feudal Age, the Castle Age (The Middle Ages), and the Imperial Age, reminiscent of the Renaissance—a 1000 year timeframe.', 'youtube' => 'https://VnrtlX0q-b0&hd=1', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2817], 'genres' => [6], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 750, 'game_title' => 'Age of Empires III', 'release_date' => '2005-10-18', 'platform' => 1, 'overview' => "The story-based campaign mode consists of related scenarios with preset objectives, such as destroying a given building. In Age of Empires III, the campaign follows the fictional Black family in a series of three \"Acts\", which divide the story arc into three generations. All three acts are narrated by Amelia Black (Tasia Valenza).\r\n\r\nInstead of playing as one of the standard civilizations, the player takes command of a special civilization that is linked to the character or period that each Act portrays. Most units of the player civilizations speak in English language, with the exception of unique units such as Spanish Rodeleros, Spanish Lancers, German Ulhans and German War Wagons.", 'youtube' => 'GYz2PqB79nI', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2817], 'genres' => [6], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 751, 'game_title' => 'Battlefield 2', 'release_date' => '2005-06-21', 'platform' => 1, 'overview' => "The story takes place in the early 21st century during a fictional world war between various power blocks: China, the European Union (playable as of the 1.50 patch), the fictional Middle Eastern Coalition (MEC), Russia (playable only in the Special Forces expansion) and the United States. In-game, the European Union and the United States fight China and the MEC. It is known that in the game's story, the EU and the US are allies and the EU has negotiated a peace deal with Russia but it is unknown if China and the MEC are allies. The game takes place in different fronts, as the Middle East and China are being invaded by US and EU forces, and the United States is being invaded by Chinese and MEC forces.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2327], 'genres' => [8], 'publishers' => [35], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 752, 'game_title' => 'Battlefield 2142', 'release_date' => '2006-10-17', 'platform' => 1, 'overview' => "In 2006 a climatic catastrophe triggered a new ice age on earth. A hundred years later, everyone gave up on finding a solution to the problem and two superpowers were formed: Europe and on the other side the Pan Asian Coalition - causing an arms race. Now it's 2142 and the war for the few resources left has already been going on for a few years, with no end in sight.", 'youtube' => 'Mk4wEAO07hM', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2328], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 753, 'game_title' => 'Call of Duty 2', 'release_date' => '2005-10-25', 'platform' => 1, 'overview' => 'The game is set during World War II and is experienced through the perspectives of four soldiers, one in the Red Army, one in the United States Army and two in the British Army.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [4187], 'genres' => [8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 754, 'game_title' => 'The Curse of Monkey Island', 'release_date' => '1997-10-31', 'platform' => 1, 'overview' => 'This third installment in the Monkey Island franchise is, like its predecessors, a humorous puzzle-solving adventure game. The game features cartoon-style SVGA graphics and (for the first time in the series) voice-overs for all the conversations. The interface no longer involves a list of verbs that occupies a part of the screen; instead the player chooses first the object to interact with, then the action from a menu that appears. Like the second game, The Curse of Monkey Island has two difficulty levels.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5068], 'genres' => [2], 'publishers' => [25], 'alternates' => ['The Curse of Monkey Island'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 755, 'game_title' => 'Medal of Honor', 'release_date' => '2010-10-12', 'platform' => 1, 'overview' => 'Medal of Honor will feature a single-player campaign that takes place in 2002, in which the player will control multiple characters from both the “Tier 1” and “Big Military” perspectives. The storyline will follow several "Tier One Operators" working under the National Command Authority in Afghanistan during Operation Enduring Freedom. Players will also play as a US Army Ranger and an Apache helicopter gunner, fighting on a larger scale than the "Tier 1 Ops" campaign, as players will then only be a small part of the "war machine". The campaign will be heavily weighted (with regards to playtime) in favor of the Tier 1 operators.', 'youtube' => 'HigXVoGpU24', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2724], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 756, 'game_title' => "Sid Meier's Civilization III", 'release_date' => '2001-10-30', 'platform' => 1, 'overview' => "Civilization III, like the other Civilization games, is based around building an empire, from the ground up, beginning at start of recorded history and continuing beyond the current modern day. The player's civilization is centered around a core of cities that provide the resources necessary to grow the player's cities, construct city improvements, wonders, and units, and advance the player's technological development. The player must balance a good infrastructure, resources, diplomatic and trading skills, technological advancement, city and empire management, culture, and military power to succeed.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'E - Everyone', 'developers' => [3041], 'genres' => [6], 'publishers' => [72], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 757, 'game_title' => "Deus Ex: Human Revolution - Director's Cut", 'release_date' => '2000-06-26', 'platform' => 1, 'overview' => 'Set in a dystopian world during the 2050s, the central plot follows rookie United Nations Anti-Terrorist Coalition agent JC Denton, as he sets out to combat terrorist forces, which have become increasingly prevalent in a world slipping ever further into chaos. As the plot unfolds, Denton becomes entangled in a deep and ancient conspiracy, encountering fictional versions of organizations such as Majestic 12, the Illuminati, and the Hong Kong Triads throughout his journey.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2685], 'genres' => [1, 4], 'publishers' => [26], 'alternates' => ['Deus Ex Game of the Year Edition'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 758, 'game_title' => 'Diablo', 'release_date' => '1996-12-31', 'platform' => 1, 'overview' => 'Set in the fictional Kingdom of Khanduras, located in the world of Sanctuary, Diablo has the player take control of a lone hero battling to rid the world of Diablo, the Lord of Terror. Beneath the town of Tristram, the player journeys through sixteen dungeon levels, ultimately entering Hell itself in order to face Diablo.', 'youtube' => '', 'players' => 1, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1202], 'genres' => [1, 4], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 759, 'game_title' => 'Diablo II', 'release_date' => '2000-06-29', 'platform' => 1, 'overview' => "The story of Diablo II takes place some time after the end of the previous game, Diablo, in the lands of Sanctuary. In Diablo the main body of the story takes place beneath the floors of a cathedral in a small town known as Tristram. It is here that Diablo, the Lord of Terror, is defeated by an unnamed warrior after many previous battles are also won.\r\nThe unnamed warrior that vanquished Diablo drove the demon's soulstone into his forehead, in an attempt to contain the monster's essence within his own body. Later in the canon it is suggested that this is what Diablo intended so that, should he be defeated, he had an \"escape plan\" in place of dying.\r\nThe unnamed warrior is ill fated from the moment he does this and is gradually corrupted over the course of the next few days by the demon's spirit. Deckard Cain recounts the story to the next band of adventurers that pass through the Rogue Encampment in Diablo II. It is one of these adventurers that appears in the wake of the destruction caused by the now possessed unnamed warrior, and attempts to find out the cause of the evil, starting with the corrupted warrior (known as the Dark Wanderer throughout Diablo II).", 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1202], 'genres' => [1, 4], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 760, 'game_title' => 'Doom II', 'release_date' => '1994-09-30', 'platform' => 1, 'overview' => 'Immediately following the events in Doom, the player once again takes the role of the anonymous space marine who has proven too tough to be contained. After being teleported from Phobos, and subsequently fighting on Deimos which is suspended above Hell, the Marine finds himself back home on Earth, only to find that it too has fallen victim to the hellish invasion, leaving billions of people dead.', 'youtube' => 'tt3E7S8me2E', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [1, 8], 'publishers' => [167], 'alternates' => ['Doom II: Hell on Earth'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 761, 'game_title' => 'Dungeon Keeper', 'release_date' => '1997-06-26', 'platform' => 1, 'overview' => "Dungeon Keeper is a strategy video game released for the PC in which the player attempts to build and manage a dungeon or lair while protecting it from (computer-controlled) 'hero' characters intent on stealing the user's accumulated treasures and killing various monsters.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1383], 'genres' => [6], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 762, 'game_title' => 'Dungeon Keeper 2', 'release_date' => '1999-06-30', 'platform' => 1, 'overview' => "Like its predecessor, players take the role of a dungeon keeper, building and defending an underground dungeon from the would-be heroes that invade it, as well as from other keepers. In the game's campaign mode, the player is charged with recovering the portal gems from each area in order to open a portal to the surface.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1383], 'genres' => [6], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 763, 'game_title' => 'The Elder Scrolls IV: Oblivion', 'release_date' => '2006-03-20', 'platform' => 1, 'overview' => "The Emperor has been killed by an unknown assassin and the throne sits empty. With no true Emperor, the gates to Oblivion open, and demons begin to invade Cyrodiil and attack its people and towns. It's up to you to find the lost heir to the throne and unravel the sinister plot that threatens to destroy all of Tamriel.", 'youtube' => 'qJnnPh44Rlo', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1010], 'genres' => [2, 4], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 764, 'game_title' => 'Escape From Monkey Island', 'release_date' => '2000-11-06', 'platform' => 1, 'overview' => 'The game begins with Guybrush Threepwood and Elaine Marley returning to Mêlée Island from their honeymoon, which they embarked on in the epilogue of The Curse of Monkey Island. Here they find that Elaine has been declared officially dead, her position as governor has been revoked and her mansion is scheduled to be demolished. The governorship is up for election, and suddenly a person known as Charles L. Charles presents himself as the lead candidate. As Elaine begins her campaign to recover her position, Guybrush meets again with three of his old "friends", Meathook, Otis and Carla and heads out to recover the Marley family heirlooms and obtain the legal documents to save her mansion. During his trip, Guybrush learns of the Marley family guarding a secret known as the Ultimate Insult, an insult so insidious, it destroys the spirit of those who hear it. He also winds up being framed for bank robbery by crook Peg-Nosed Pete at the hiring of the Australian Ozzie Mandrill, but manages to prove his innocence.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [2, 5], 'publishers' => [25], 'alternates' => ['Escape from Monkey Island'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 765, 'game_title' => 'Homeworld 2', 'release_date' => '2003-09-16', 'platform' => 1, 'overview' => "Homeworld 2 continues the struggle of the Hiigarans and their leader Karan S'jet.\r\nDuring the events of the original game, the Kushan race of the planet Kharak began a quest to discover and reclaim their home planet. The Kushan discovered the wreckage of the Khar-Toba, an interstellar transport, in a desert on Kharak, and inside found a galactic map etched on a piece of stone. From this the Kushan concluded they had been transplanted to Kharak some time ago. To reclaim their home planet—\"Hiigara\"— the Kushan built an enormous self-sufficient Mothership to carry 600,000 people on a crusade to reclaim Hiigara. This led to the engagement and eventual defeat of the Taiidan Empire which exiled them.\r\nThe story continues that some time later, the Khar-Toba was found to contain one of the Three Hyperspace Cores, left behind by a so-called Progenitor race, which eventually allowed hyperspace travel. The First Core was possessed by the Bentusi: a powerful and enigmatic race of traders who assisted the Exiles (the campaign can be played using Kushan or Taiidan craft in the original game) during the first game. The third was lost until approximately one hundred years after the Exiles reclaimed Hiigara, found by a Vaygr Warlord named Makaan, who used it to conquer much of the galaxy and—as of the beginning of Homeworld 2—began attempts to capture Hiigara. The story states that religious beings of the galaxy consider the discovery of the Third Core to announce the End Times, during which Sajuuk, thought to be an immensely powerful being, will return.\r\nThe game begins with the commissioning of a new Mothership, the Pride of Hiigara, similar in shape and design to the original Mothership and commanded by Karan S'jet, as in the original game. The ship is attacked by the Vaygr during the final stages of construction but escapes. The Bentusi inform the Hiigarans that they must find Balcora Gate, left behind by the Progenitors, behind which is something essential for stopping either the Vaygr threat, the End Times, or both. Makaan learns of and reaches the location as well, and the game's penultimate mission takes place on the other side of Balcora Gate, where Hiigarans and Vaygr alike discover an enormous Progenitor starship, named Sajuuk, with sockets for the Three Hyperspace Cores. After defeating Makaan the Hiigarans combine the Vaygr, Hiigaran and Bentusi Cores (recovered from the wreckage of the last of the Bentusi ships) within Sajuuk, and use it to defeat the leaderless-but-still-dangerous Vaygr invasion; Sajuuk is later found to be the key to a galaxy-wide network of hyperspace gates, ushering in a new age of trade and prosperity for all civilized races in the galaxy.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [7131], 'genres' => [6], 'publishers' => [32], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 766, 'game_title' => 'Homeworld', 'release_date' => '1999-09-28', 'platform' => 1, 'overview' => "Beneath the scorching sands of Kharak, the Kushan people have discovered the remains of a long-forgotten titanic spaceship. Buried within the ancient remains, the secret of their lost homeworld.\r\nFor thousands of years, the Kushan have survived on the arid planet Kharak, corralled into the temperate geographical poles by a vast, unforgivingly hot desert. Scarcity of arable land and natural resources has coloured Kushan history with near constant inter-clan (or \"Kiith\") warfare.\r\nAs new technologies emerged, religious and political conflict partially gave way to unified scientific exploration. DNA sequencing of Kharak's native life revealed no genetic resemblance to the Kushan, giving rise to their \"XenoGenesis Theory\" - which stated that they were not native to Kharak at all.\r\nThe first space flights reinforced this idea. Small pieces of metallic debris, the largest no bigger than a hand, were retrieved from low orbit and, when analyzed, were found to be made up of materials totally unknown to Kushan metallurgy. In addition to helping accelerate their space technology research, the debris confirmed that a large advanced spacecraft had once been in orbit. It was an ironic twist of fate occurring later in their history that boosted them even further along their development.\r\nA high-powered satellite designed to scan the planetary system malfunctioned upon deployment and ended up facing entirely the wrong way, scanning the Great Desert around Kharak's equator instead. Despite this error, however, it found something, beneath the sands: a derelict city with a massive central metallic structure. An expedition discovered that the central structure was the spacecraft of which they had earlier found traces in orbit. It carried advanced spaceflight technologies including a Hyperspace Core, one of a few ancient machines that were the Homeworld setting's foundation for all faster-than-light technology.\r\nMore importantly however, a stone with a galactic map bearing two coordinates was found. One was recognized as Kharak. The other bore a name so ancient it was common across all their languages and dialects: Hiigara. \"Home\". The stone would become known as the Guidestone, and confirmed the XenoGenesis Theory. Kharak's people united in building the \"Mothership\", a vast colony ship that would bear 600,000 of them to their destination, made rugged and self-sufficient in order to survive possible problems during the long trip. It is during the Mothership's final testing phase that the single-player game begins.", 'youtube' => 'di4NlkpKaGw', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7131], 'genres' => [6], 'publishers' => [32], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 767, 'game_title' => 'Unreal Tournament', 'release_date' => '1999-11-30', 'platform' => 1, 'overview' => "UT was designed as an arena FPS, with head-to-head multiplayer deathmatches being the primary focus of the game. The game's single-player campaign is essentially a series of arena matches played with bots. For team matches, bots are again used to fill the roles of the player's teammates. Even on dedicated multiplayer servers, bots are sometimes used to pad out teams that are short on players.", 'youtube' => 'sar3_ll2bpM', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2834], 'genres' => [8], 'publishers' => [167], 'alternates' => ['Unreal Tournament Game of the Year Edition'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 768, 'game_title' => 'Lost Planet: Extreme Condition', 'release_date' => '2007-06-26', 'platform' => 1, 'overview' => 'Lost Planet begins in the year of T.C. -80 where the Earth has become too hostile for human life. A company named NEVEC (Neo-Venus Construction) tries to start colonization on the planet E.D.N. III. Upon arriving on the planet, NEVEC discovers an alien race called Akrid and are forced off the planet, momentarily stopping colonization efforts. Returning to E.D.N. III with an army prepared to fight, they find that the Akrid contains an energy source called Thermal Energy (T-ENG) that is needed to survive on the planet. NEVEC builds the first Vital Suit (VS), powered by T-ENG, to fight the Akrid. Meanwhile, civilian colonists and E.D.N. III military personnel continue to seek out a nomadic existence as "snow pirates," harvesting T-ENG from fallen Akrid.', 'youtube' => '', 'players' => 1, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [1, 8], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 769, 'game_title' => 'Far Cry', 'release_date' => '2004-03-23', 'platform' => 1, 'overview' => 'Far Cry is a First-Person Shooter developed by Crytek Studios and published by Ubisoft in 2004. In Far Cry an Ex-U.S. Special Forces operative named Jack Carver runs his own boat charter business in the south pacific after he quit his former job. One day he is contacted to escort a female journalist to a lonesome, tropical archipelago. But shortly after she arrives at the beach, she disappears and Jack nearly gets killed as mercenaries destroy their anchoring boat. Stranded on a remote beach, Jack decides to fight back against the mercenaries and to search for the missing journalist to find some answers. On his vendetta he explores beautiful beaches, dense rain forests, as well as mines, canyons and even volcanic forests to discover disturbing secrets - secrets that were buried in underground complexes and hidden facilities for a long, long time.', 'youtube' => '3pnKAljANsU', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1970], 'genres' => [8], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 770, 'game_title' => 'Far Cry 2', 'release_date' => '2008-10-21', 'platform' => 1, 'overview' => "Far Cry 2 abandons the science fiction aspects of its predecessor in favor of a more realistic setting. The game takes place in late 2008 in a small, failed Central African state, currently embroiled in a civil war. The government has recently collapsed, leaving two factions vying for control. At war are the United Front for Liberation and Labour (UFLL, led by Addi Mbantuwe, a former opposition leader) and the Alliance for Popular Resistance (APR, best far led by Maj. Oliver Tambossa, Chief of Staff for the former government). Both factions have claimed to have the people's interests at heart, but both have shown ruthlessness, warmongering, greed, and a general disregard for the well-being of the people. Both sides have hired many foreign mercenaries to bolster their strength over the course of the conflict. The recent exhaustion of the nation's diamond mines has thrown the nation into further turmoil, leaving many foreign mercenaries without payment and no way out.\r\nThe goal of the player's character is to find and assassinate the Jackal, an arms-dealer who has been selling weapons to both sides of the conflict. The player must accomplish this goal by whatever means necessary, even if he has to reach the level of immorality employed by the warring factions and the Jackal himself.", 'youtube' => 'm-7m4vtn-eM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9150], 'genres' => [8], 'publishers' => [7], 'alternates' => ["Far Cry 2: Fortune's Edition"], 'uids' => nil, 'hashes' => nil },
    { 'id' => 771, 'game_title' => 'SimCity 2000', 'release_date' => '1993-01-01', 'platform' => 1, 'overview' => "SimCity 2000 is the successor to the city simulation game Sim City. You are once again the mayor, but this time you can fully customize the terrain before building your city. The graphics are isometric, whereas the original had graphics displayed in a top-down fashion.\r\n\r\nThis title adds numerous features over the original such as the ability of building \"light\" zones, subways, hospitals, colleges, zoos, and arcos which are actually cities in cities. You can now give names to places, and your city is surrounded by neighboring towns with which you can make trade. Finally, instead of the poll in the first game you now have the option of reading several newspapers to get an idea of your progress.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5322], 'genres' => [3, 6], 'publishers' => [124], 'alternates' => ['SimCity 2000: Special Edition', 'SimCity 2000 CD Collection', 'SimCity 2000: The Ultimate City Simulator'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 772, 'game_title' => 'SimCity (1989)', 'release_date' => '1989-02-01', 'platform' => 1, 'overview' => "The player can mark land as being zoned as commercial, industrial, or residential, add buildings, change the tax rate, build a power grid, build transportation systems and take many other actions, in order to enhance the city.\r\nAlso, the player may face disasters including flooding, tornadoes, fires (often from air disasters or even shipwrecks), earthquakes and attacks by monsters. In addition, monsters and tornadoes can trigger train crashes by running into passing trains. Later disasters in the game's sequels included lightning strikes, volcanoes, meteors and attack by extraterrestrial craft.\r\nIn the SNES version and later, one can also build rewards when they are given to them, such as a mayor's mansion, casino, etc.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5322], 'genres' => [3, 6], 'publishers' => [124], 'alternates' => ['Micropolis'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 773, 'game_title' => 'SimCity 4', 'release_date' => '2003-01-14', 'platform' => 1, 'overview' => 'The game allows players to create a region of land by terraforming, and then to design and build a settlement which can grow into a city. Players can zone different areas of land as commercial, industrial, or residential development, as well as build and maintain public services, transport and utilities. For the success of a city players must manage its finances, environment, and quality of life for its residents. SimCity 4 introduces night and day cycles and other special effects for the first time in the SimCity series. External tools such as the Building Architect Tool (BAT) allow custom third party buildings and content to be added to the gameplay.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5322], 'genres' => [3, 6], 'publishers' => [2], 'alternates' => ['SimCity 4 Deluxe Edition'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 774, 'game_title' => 'SimCity 3000', 'release_date' => '1999-01-31', 'platform' => 1, 'overview' => "SimCity 3000, released in 1999 as the third major installment in the SimCity series, continues its successful course as a city building simulation game. In SimCity 3000 new tools have been introduced to create and control the city build-ups. Recreate the world's greatest cities using predefined landscapes such as San Francisco or Berlin and landmark buildings like the Empire State Building or Big Ben. Negotiate and barter with neighbouring cities to strengthen your metropolis and seal contracts to import water or get rid of huge amounts of waste.", 'youtube' => '_3Cps2AYIK4', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5322], 'genres' => [3], 'publishers' => [2], 'alternates' => ['Sim City 3000', 'SC3K'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 775, 'game_title' => 'Freelancer', 'release_date' => '2003-03-04', 'platform' => 1, 'overview' => 'In the game, players take on the roles of spacecraft pilots. These characters fly single-seater ships, exploring the planets and space stations of 48 known star systems. They also engage in dogfights with other pilots (player- and computer-controlled) to protect traders or engage in piracy themselves. Other player activities include bounty-hunting and commodity trading. The single-player mode puts the player in the role of Edison Trent, who goes through a series of missions to save the Sirius sector from a mysterious alien force. In multiplayer mode, players are free to take on any role and to explore anywhere from the start.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2303], 'genres' => [1, 13], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 776, 'game_title' => 'Ground Control', 'release_date' => '2000-06-01', 'platform' => 1, 'overview' => "Ground Control is set in the 25th century. Mankind emerged from the devastation of the Third World War (known in the game as \"The Sixteen-minutes War\", which almost wiped out the whole of humanity) and managed to colonize several planets across the galaxy. The Earth is ruled by a council called GCC (Global Central Command) that is formed by elected representatives and representatives of the mega corporations which rose to power after the fall of the Terran nations.\r\nThe game's plot revolves around the conflict between the Crayven Corporation and the Order of the New Dawn for the possession of the distant world of Krig 7-B. In the beginning of the game, the player assumes the role of Major Sarah Parker of the Crayven Corporation as she leads the Crayven forces in order to eliminate the presence of the \"Dawnies\" (her derogatory nickname in reference to followers of the Order). In the second campaign, the player assumes control of Deacon Jarred Stone in his attempt to drive the \"Crays\" from the surface of Krig 7-B. During the course of the campaign, however, both characters unravel a dark secret hidden within the depths of the planet, a secret that threatens all mankind, and turns out to be the reason for such interest in what seems to be a desolate fringe world.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [5293], 'genres' => [6], 'publishers' => [145], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 777, 'game_title' => 'Quake', 'release_date' => '1996-06-22', 'platform' => 1, 'overview' => 'The player takes the role of an un-named protagonist sent into a portal in order to stop an enemy code-named "Quake". Previously, the government had been experimenting with teleportation technology, and upon development of a working prototype called a "Slipgate", this enemy has compromised the human connection with their own teleportation system, using it to insert death squads into the "human" dimension, supposedly in order to test the martial capabilities of humanity.', 'youtube' => '5WzyVjx-SXM', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [8], 'publishers' => [167], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 778, 'game_title' => 'Quake 4', 'release_date' => '2005-10-18', 'platform' => 1, 'overview' => "The Quake 4 single player mode continues the story of Quake II by pitting the player against a cyborg alien race known as the Strogg. The game follows the story of a Marine named Matthew Kane who is a member of the fabled Rhino Squad. Following the success of the protagonist of Quake II in destroying the Strogg's leader, the Makron, the Rhinos are tasked with spearheading the mission to finally secure the aliens' home planet Stroggos. In the course of the invasion, the squad ship is shot down and crashes in the middle of a battle zone, separating Kane from his companions. Kane eventually rejoins his scattered team members and partakes in the assault against the Strogg.", 'youtube' => 'HN0PHBXuEw4', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [8], 'publishers' => [33], 'alternates' => ['Quake IV'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 779, 'game_title' => 'Max Payne 2: The Fall of Max Payne', 'release_date' => '2003-10-14', 'platform' => 1, 'overview' => "Two years after the events of the first game, Max Payne has quit his job at the DEA and returned to his former job as an NYPD detective. While investigating a series of murders by a group of contract killers called the Cleaners, Max encounters Mona Sax, who was assumed dead at the end of the previous game. Wanted for the murder of Senator Gates and, despite Max's protests, Mona is arrested and taken to the police station. While at the station, Max overhears his new partner, Detective Valerie Winterson, talking on the phone about Mona. Suddenly, the station is attacked by the Cleaners, who are looking for Mona. Before they reach her, Mona breaks out of her cell and vanishes into the night. After Max meets her again at her residence, where they fight off the Cleaners who followed Max to her place, they begin hunting down the people responsible for the attack. Their search leads them to a construction site, where Max and Mona defend themselves against the Cleaners. After their foes flee, Detective Winterson arrives and holds Mona at gunpoint. Mona claims that Winterson is there to kill her while Winterson claims that she is simply trying to arrest a fleeing fugitive. After several moments of consideration, Max shoots Winterson, allowing Mona to escape. Before she dies, Winterson shoots Max, leading to his hospitalization.", 'youtube' => 'KYT2_Ww6wtM', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7138], 'genres' => [1, 8], 'publishers' => [17], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 780, 'game_title' => 'Max Payne', 'release_date' => '2001-07-23', 'platform' => 1, 'overview' => "The story is told in medias res and consists of three volumes: \"The American Dream\", \"A Cold Day in Hell\", and \"A Bit Closer to Heaven\". The game begins in the winter of 2001, as New York City finishes experiencing the worst blizzard in the history of the city. The intro sequence shows Max Payne, a renegade DEA agent and former NYPD officer, standing at the top of a skyscraper building as police units arrive. He then experiences a flashback from three years ago. Back in 1998, Max returned home to find that a trio of apparent junkies had broken into his house while high on a new designer drug called Valkyr. Max rushed to the aid his family, but was too late and his wife and their newborn daughter had already been brutally murdered. After his family's funeral, Payne transferred to the DEA.\r\nThree years later, Max Payne is employed as an undercover operative inside the Punchinello Mafia family responsible for the trafficking of Valkyr. His DEA colleague B.B. gives Max a message asking him to meet another DEA agent, who is also Max's best friend, Alex Balder, in the NYC Subway station. Max's arrival at the subway results in a shoot-out after he encounters mobsters working for Jack Lupino, a Mafia underboss in the Punchinello crime family, attempting a bank robbery by breaking through from the station. Working his way back to the surface, Max encounters Alex, who is then killed by an unknown assassin and Payne becomes the prime suspect in the murder. Additionally, the Mafia find out that he is a cop and now want him dead.", 'youtube' => 'Pgg3VG7Hug8', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7138], 'genres' => [1, 8], 'publishers' => [168], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 781, 'game_title' => 'Mafia: The City of Lost Heaven', 'release_date' => '2002-08-28', 'platform' => 1, 'overview' => "The game begins with Thomas \"Tommy\" Angelo entering a bar to speak to police Det. Norman. After announcing that he wants to be in the Witness Protection Program, Tommy proceeds to tell the story of how he got involved with a crime family headed by Ennio Salieri, providing the story's main narrative.\r\nWhile working as a cab driver in fictional Lost Heaven in 1930, Tommy picks up two mobsters, Sam and Paulie, who force him to help them lose two mobsters working for Salieri's rival, Don Morello. After losing them and delivering the two to their boss' place, Tommy is rewarded a large amount of money. The next day, while taking a break, Tommy is attacked by the thugs he helped Sam and Paulie escape from. Though he is saved by Salieri's men, he subsequently loses his job. Desperate to make money, Tommy falls in with Salieri's crew and gets involved in all his criminal operations.\r\nOver the next 8 years, Tommy does big jobs for the family, such as murdering other gangsters, entering races, stealing, bootlegging (this is during Prohibition), robbing banks, and property destruction. He slowly rises through the ranks as the jobs get bigger, such as when he has to kill Salieri's double-crossing consigliere. Eventually, the rivalry between Salieri's crew and Morello's crew erupts into a war. This is where Tommy gets his biggest job: assassinating Morello, ending the feud once and for all. During this time, Tommy falls for and marries Sarah, daughter of Salieri's bar's bartender, Luigi, with whom he eventually has a daughter of his own.\r\nTommy's story reaches its climax when, in 1938, he and Paulie (whom, along with Sam, he's become close friends with) learn that Salieri's been smuggling diamonds in secret and keeping the profits for himself. Deciding to get back at him, they rob a bank (Sam refuses). Though the heist is successful, Tommy finds Paulie shot dead the next day. Sam calls Tommy and asks that he meet him at an art gallery. There, he learns that Sam ratted him and Paulie out to Salieri, who ordered their whacking. After a shootout, Tommy manages to kill Sam and several others. He then flees to Europe with his family, but quickly returns to set up the meeting with Norman.\r\nHis story over, Tommy makes his demands: in return for immunity for his past actions and protection, he'll testify against his former comrades. In the trial that ensues, 80 gangsters are tried, most are executed and Salieri gets life in prison. Tommy and his family are put under federal protection and remain safe for 13 years. However, in 1951, his past fatally catches up to him as he is shot dead by two gunman. The game ends with Tommy lamenting in voiceover the mistakes he made, saying that in wanting it all, he eventually lost everything.", 'youtube' => 'qVrLHREBWME', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4078], 'genres' => [4, 8], 'publishers' => [168], 'alternates' => ['Mafia'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 782, 'game_title' => 'Return to Castle Wolfenstein', 'release_date' => '2001-11-19', 'platform' => 1, 'overview' => "While investigating the activities of the SS Paranormal Division in Germany, B.J. Blazkowicz and Agent One have been captured by the Nazis. Agent One dies while being interrogated, but B.J. manages to escape Castle Wolfenstein's dungeon. He then fights his way out of the castle and uses a tram car to leave the area and meet up with a member of the German resistance in a nearby village.\r\nThe SS Paranormal Division under Oberführer Helga von Bulow has been excavating the catacombs and crypts of an ancient church within the village. Their sloppy precautions have led to the awakening of hordes of undead creatures, including Saxon knights, and the entrance had to be sealed off with many soldiers trapped inside. B.J. descends regardless and fights both Nazis and Undead until he arrives at the ancient \"Defiled Church\" where Nazi scientist Professor Zemph is conducting a \"life essence extraction\" on the corpse of a Dark Knight. Shortly before B.J.'s arrival, Zemph tries to talk Helga von Bulow out of retrieving an ancient Thulian dagger, but she shoots him impatiently and proceeds. This awakens a monster which kills her too. Blazkowicz fights the monster and is airlifted out, with Zemph's notes and the dagger.\r\nOne of Germany's leading scientific researchers and Head of the SS \"Special Projects Division\", Wilhelm \"Deathshead\" Strasse, is preparing to launch an attack on London using a V-2 rocket fitted with an experimental germ warhead from his base near Katamarunde in the Baltics. Blazkowicz is parachuted some distance from the missile base and smuggles himself in a supply truck. Inside the base, Blazkowicz destroys the V-2 rocket on its launchpad and fights his way out of the facility towards an airbase filled with experimental jet aircraft. There, he commandeers a \"Kobra\" rocket-plane and flies to safety in Malta.", 'youtube' => '3AedXvBXgHw', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 783, 'game_title' => 'Need for Speed II', 'release_date' => '1997-04-30', 'platform' => 1, 'overview' => 'There are three main game types. The first two are single race and tournament and the last is a knockout race. Single races allow players to become familiar with the circuits and increase their skill of any one of the six tracks. The six tracks are called Mediterranean, Mystic Peaks, Proving Grounds, Outback, North Country, and Pacific Spirit.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2724], 'genres' => [7], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 784, 'game_title' => 'Need for Speed: Undercover', 'release_date' => '2008-11-18', 'platform' => 1, 'overview' => "Undercover features a new open world map consisting of 109 miles (175 km) of road and a large highway system, making it the largest Need for Speed \"world\" EA has created so far. The game's environment consists of four boroughs: Palm Harbor, Port Crescent, Gold Coast Mountains, and Sunset Hills. In the Wii and PS2 versions two boroughs are copied off Need for Speed Most Wanted and put into different positions. These four boroughs make up the city, Tri-City (referring to the real-life city in Tri-City, Oregon), presumably a city located on the Gulf Coast or on the California Coast although the city itself heavily resembles Miami.", 'youtube' => '6gxFZNZPh0E', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2724], 'genres' => [19], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 785, 'game_title' => 'Neverwinter Nights', 'release_date' => '2002-06-18', 'platform' => 1, 'overview' => "Play centers on the development of a character who becomes the ultimate hero of the story. In the original NWN scenario supplied with the game engine, the player is single-handedly responsible for defeating a powerful cult; collecting the four reagents required for stopping an insatiable plague; thwarting an attack on the city of Neverwinter, and many other side quests.\r\nThe first and final chapters of the story in the official campaign deal with the city of Neverwinter itself, but the lengthy mid-story requires the player to venture into the countryside and then northward to the city of Luskan. Neverwinter is a city on the Sword Coast of Faerûn, in the Forgotten Realms campaign setting of Dungeons and Dragons.", 'youtube' => 'aD8BnROvBRc', 'players' => 4, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [1086], 'genres' => [4], 'publishers' => [72], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 786, 'game_title' => 'The Elder Scrolls III: Morrowind', 'release_date' => '2002-05-01', 'platform' => 1, 'overview' => 'Morrowind was released in 2002 by Bethesda as a sequel to Arena & Daggerfall, its much-praised predecessors in the RPG series The Elder Scrolls. While Morrowind contains many quests and storylines, the central plot revolves around the reincarnation of the Dunmer hero Indoril Nerevar. The incarnate of Nerevar, referred to as "The Nerevarine", has been prophesied to oppose and defeat the rise of the malevolent deity Dagoth Ur and the remnants of his followers. These followers are encompassed in a forbidden faction named "The Sixth House", and are mainly located within the volcanic region of Red Mountain in the centre of Vvardenfell, the island on which the game takes place. Dagoth Ur has used the Heart of Lorkhan, an artifact of great power, to make himself immortal and now seeks to drive the Imperial occupiers from Morrowind using his network of spies, as well as an enormous golem, powered by the Heart of Lorkhan, which Dagoth Ur had originally been tasked to guard.', 'youtube' => 'Cr3TCWPlDrw', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1009], 'genres' => [2, 4], 'publishers' => [34], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 787, 'game_title' => 'Empire Earth', 'release_date' => '2001-11-12', 'platform' => 1, 'overview' => 'Epochs are the ages a player passes through in Empire Earth. Each of these epochs represents an age within history. In Empire Earth, the last two ages (Digital and Nano Ages) are set into the moderate future. In the Art of Conquest, a third future age, the Space Age, is available. It deals with space colonization. Each epoch brings new technologies and units. Epoch advancement requires additional buildings to be built and the costs of advancing increases as more epochs are attained, although the ability to gather the required resources greatly increases as well. With new epochs, some new units are available at the cost of having to abandon the ability to produce old units, though any old units still alive are kept. The epochs in Empire Earth are the Prehistoric Age, the Stone Age, the Copper Age, the Bronze age, the Dark Age, the Middle Ages, the Renaissance, the Imperial age, the Industrial age, the Atomic World War I age, the Atomic World War II Age, the Atomic Modern Age, the Digital Age and the Nano Age. An extra epoch, the Space Age, is available in Empire Earth: The Art of Conquest.', 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [8125], 'genres' => [6], 'publishers' => [32], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 788, 'game_title' => 'Grand Theft Auto III', 'release_date' => '2002-05-21', 'platform' => 1, 'overview' => "The player character has robbed the Liberty City Bank with his girlfriend, Catalina, and a male accomplice. While running from the scene, Catalina turns to him and utters, \"Sorry, babe, I'm an ambitious girl and you ... you're just small-time\". She shoots him and leaves him to die in an alley; the accomplice is also seen lying nearby. It soon becomes apparent that the player character has survived but has been arrested and subsequently found guilty and sentenced to jail. While he is being transferred, an attack on the police convoy aimed at kidnapping an unrelated prisoner sets him free.\r\nWith the help of a fellow escaped prisoner, the player character then takes on work as a local thug and rises in power as he works for multiple rival crime gangs, a corrupt police officer and a media mogul. In the process, Maria, the mistress of a local Mafia boss, begins to take a liking to him. The Mafia leader, Salvatore, grows suspicious and lures the player to a death trap; but Maria saves him, remaining close to him throughout the storyline. He later goes to work for others, including the Liberty City Yakuza and media mogul Donald Love. Eventually, his exploits attract the attention of Catalina, now affiliated with a Colombian drug cartel, resulting in the kidnapping of Maria. This gives him the opportunity to face Catalina once more, which results in a large firefight and Catalina's death.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7279, 10_255], 'genres' => [1, 2, 8], 'publishers' => [17], 'alternates' => ['GTA 3'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 789, 'game_title' => 'Grand Theft Auto: Vice City', 'release_date' => '2002-10-27', 'platform' => 1, 'overview' => "The player takes on the role of Tommy Vercetti, a man who was released from prison in 1986 after serving 15 years for killing eleven people. The leader of the organization for whom he used to work, Sonny Forelli, fears that Tommy's presence in Liberty City will heighten tensions and bring unwanted attention upon his organization's criminal activities. To prevent this, Sonny ostensibly \"promotes\" Tommy and sends him to Vice City to act as their buyer for a series of cocaine deals. During Tommy's first meeting with the drug dealers, an ambush by an unknown party results in the death of Tommy's bodyguards, Harry and Lee, and the cocaine dealer. There is another survivor, the pilot of the dealer's helicopter, who flies off and escapes. Tommy narrowly escapes with his life, but he loses both the Forelli's money and the cocaine.", 'youtube' => 'https://www.youtube.com/watch?v=Ag6H1e1rXJ0', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7273], 'genres' => [1, 4, 8, 9], 'publishers' => [17], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 790, 'game_title' => 'Grand Theft Auto: San Andreas', 'release_date' => '2004-10-26', 'platform' => 1, 'overview' => 'Grand Theft Auto: San Andreas is the fifth installment in the GTA series and takes place within the state San Andreas, which is based on sections of California & Nevada. It comprises three major fictional cities: Los Santos corresponds to real-life Los Angeles; San Fierro corresponds to real-life San Francisco; and Las Venturas and the surrounding desert correspond to real-life Las Vegas and the Nevada and Arizona desert.', 'youtube' => 'u_CbHrBbHNQ', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7273], 'genres' => [1, 4, 8, 9], 'publishers' => [17], 'alternates' => ['GTA: San Andreas'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 791, 'game_title' => 'Red Faction', 'release_date' => '2001-09-18', 'platform' => 1, 'overview' => 'Red Faction takes place on Mars around the year 2075. Earth’s minerals are being depleted and humans need more of them to survive. The vast Ultor Corporation runs the mining operation on Mars. The living conditions are deplorable, human rights for the miners are few and a disease called "The Plague" is running rampant throughout the colony with no known antidote available - predominantly within the confines of the mine complex. Parker, a downtrodden miner, came to Mars to make a new start in his life - taken in by the promises and advantages Ultor has to offer in the mines of Mars. After a routine day in the mine with the typical aggression toward miners and cramped living conditions and poor nutrition, he witnesses the spark that starts a rebellion when a security guard abuses a miner at the end of his shift and heartlessly kills him. Parker takes up arms, with the help of Hendrix, a rebellious Ultor security technician who guides Parker through the complex. Hendrix tries to get Parker to join up with a group of miners who are about to steal a supply shuttle and escape the complex, but Parker arrives too late. The shuttle takes off, and is destroyed by missiles moments later.', 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'M - Mature', 'developers' => [9487], 'genres' => [8], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 792, 'game_title' => 'Red Faction II', 'release_date' => '2002-10-15', 'platform' => 1, 'overview' => "In the year 2075, five years after the events of Red Faction, on Mars, the nanotechnology developed by Capek has been claimed by the Earth Defense Force (EDF). With this technology, the EDF commences a reorganization of the Ultor Corporation with a particular focus on enhanced supersoldiers and suitable weaponry. However, the research that was done by Capek in his laboratories has been consequently stolen by other militant groups and assorted terrorist organizations. This has gone on for years; the research has changed hands in the criminal underworld many times. The player is introduced to the role of an explosives expert (codenamed \"Alias\"), as he embarks on a special operations mission to claim the research data for the Republic of the Commonwealth.\r\n\r\nEventually, the research was successfully claimed by the elite forces of Victor Sopot, Chancellor of the dystopic military state known as The Commonwealth. Sopot uses the nanotechnology to enhance his already formidable military forces, and successfully creates the first supersoldiers with the research data. Fearing the potential of his new supersoldiers, he orders them all to be hunted down and executed at once and replaced with far less intelligent, mutated horrors known as \"The Processed\".", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9487], 'genres' => [8], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 793, 'game_title' => 'Serious Sam', 'release_date' => '2001-12-01', 'platform' => 1, 'overview' => "In ancient times, Earth was involved in a conflict between Mental and the Sirians, an alien race that left many of its artifacts to be found by humanity. In the 22nd century Mental's forces return to Earth hell-bent on eradicating humankind: as a last resort the usage of the \"Time Lock\" is decided: this Sirian device can send back through time a single individual who can, hopefully, defeat Mental and alter the course of history. Because of his bravery in fighting the monsters, Sam \"Serious\" Stone is chosen to use the \"Time Lock\".", 'youtube' => 'JTbwOukQlDY', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1948], 'genres' => [8], 'publishers' => [168], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 794, 'game_title' => 'Serious Sam II', 'release_date' => '2005-10-11', 'platform' => 1, 'overview' => "The game's story picks up shortly after the end of Serious Sam: The Second Encounter, with the hero of the series, Sam \"Serious\" Stone, continuing on his goal to defeat the series' nemesis, Mental. The game begins with Serious Sam being summoned before the Sirian Great Council, where the council asks Sam to defeat Mental and provides him with guidance on how to accomplish this feat. The council reveals to Sam that he must collect five pieces of an ancient medallion, each held by various groups on five different planets, and states that once Sam has the entire medallion, Mental will be vulnerable. All the planets (except Kleer) are populated by friendly, big headed humanoids. The problem is that all the planets are under Mental's control. Sam has to visit five planets in order to recreate the medallion.", 'youtube' => '0FZq3wE_FFs', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1948], 'genres' => [8], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 795, 'game_title' => 'S.T.A.L.K.E.R.: Shadow of Chernobyl', 'release_date' => '2007-03-20', 'platform' => 1, 'overview' => 'The game begins with an unconscious, wounded stalker (the player character) being brought to Sidorovich, a black-market trader operating inside the Zone of alienation (or simply "The Zone"). Sid is able to save his life, but the wounded stalker is amnesic; the only clues to his identity are a tattoo on his arm of the acronym "S.T.A.L.K.E.R." and his PDA which contains only one entry in the to-do list: "Kill Strelok." The amnesiac stalker is dubbed "Marked One" by Sid.', 'youtube' => 'exGOtsiS0tw', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3645], 'genres' => [1, 8], 'publishers' => [40], 'alternates' => ['S.T.A.L.K.E.R.: Тень Чернобыля (RU)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 796, 'game_title' => 'Star Wars: Republic Commando', 'release_date' => '2005-03-01', 'platform' => 1, 'overview' => 'The game is set during the events of the Clone Wars that started at the climax of the movie Star Wars Episode II: Attack of the Clones. In the game, the player is expected to take command of a Clone commando team, made up of elite Clone troopers. These "clone commandos" have been specially bred at the clone factories on Kamino. The commando team will travel to various locations in the Star Wars universe, including Kashyyyk, Geonosis, and the derelict spacecraft, The Prosecutor.', 'youtube' => 'rsH8LAb-5qQ', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [8], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 797, 'game_title' => 'Tribes: Vengeance', 'release_date' => nil, 'platform' => 1, 'overview' => "Set hundreds of years before the events of Starsiege: Tribes, Vengeance depicts the birth of the growing Tribal War. It focuses on the events surrounding five different characters over the course of two generations and how they each contribute to the developing war. The story (\"The Past\") begins with a Phoenix sub-clan leader named Daniel abducting the soon to be Queen, Princess Victoria. He takes her to his home world to show her the injustices done to his people and the two eventually fall in love. During this time, a cybrid assassin named Mercury is hired by an unknown contractor to eliminate Daniel, but the contract is canceled moments before the shot is fired. Eventually, Victoria and Daniel try to make amends between the Imperials and the Phoenix, but it all ends disastrously when the Phoenix's enemies, the Blood Eagle tribe, stage a raid on a Phoenix base disguised as Imperial troops. In rage, Daniel kills the Imperial King, Tiberius, whom Victoria avenges by killing Daniel. It turns out that Victoria was pregnant with Daniel's child, who was born female under the name Julia soon afterwards.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [4357], 'genres' => [8], 'publishers' => [169], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 798, 'game_title' => 'Unreal Tournament III', 'release_date' => '2007-11-19', 'platform' => 1, 'overview' => 'Similarly to the previous entries of the series, the game is primarily an online multiplayer title offering several game modes, including large-scale Warfare, Capture-the-Flag, and Death match. It also includes an extensive offline single-player game with an in-depth story, beginning with a simple tournament ladder and including team members with unique personalities.', 'youtube' => 'if6Vv-5AlHs', 'players' => 16, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2834], 'genres' => [1, 8], 'publishers' => [41], 'alternates' => ['Unreal Tournament 3 Black Edition'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 799, 'game_title' => 'Unreal Tournament 2003', 'release_date' => '2002-09-30', 'platform' => 1, 'overview' => "In 2291, consensual murder is legalized, opening the way for a previously underground event. Smaller mining companies have been running smaller matches to channel aggression, but now the Liandri Mining Corporation established a professional league, which quickly proves to be an extremely lucrative way of public entertainment. Liandri entered into the Tournament, as it is officially called, sponsoring their own team, the Corrupt. The Corrupt's leader, Xan Kriegor, quickly achieved champion status and held it for two years. In 2293, a human named Malcolm dethroned him and became champion himself. A huge media figure, Malcolm is hailed as the biggest star in human history and is worshipped as a god. His success nets great rewards for his sponsoring corporation, attracting the attention of jealous rivals both in the arenas of the Tournament and in the corridors of power a galaxy away. Liandri attempted to win back the champion title with Xan MK2 but failed (unknown to the other contestants, each member of the Corrupt is purely robotic, including Xan).\r\nNow it is 2302. The Tournament is undergoing a massive overhaul. The aging Sniper Rifle (a relic of centuries past) is removed from the Tournament as is \"Assault\" - a team-based event that forms a part of the competition. Many fans of the Tournament complain at these changes, with some combatants refusing to participate in the new format. Malcolm, shortly after his victory, hired two of his former opponents (Brock and Lauren, members of the former Iron Guard team) as teammates in his reformed Thunder Crash team. But the Axon Research Corporation, another of the four great corporations, entered the Tournament as well, sponsoring the geneboosted Juggernaut team, led by the brutal and savage Gorge.", 'youtube' => '3vGqfNXV3HM', 'players' => 16, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2834], 'genres' => [8, 14], 'publishers' => [506], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 800, 'game_title' => 'Unreal Tournament 2004', 'release_date' => '2004-03-16', 'platform' => 1, 'overview' => 'Among significant changes to gameplay mechanics and visual presentation, one of the major additions introduced by Unreal Tournament 2004 is the inclusion of vehicles and the Onslaught game type, allowing for large-scale battles.', 'youtube' => '', 'players' => 16, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2834], 'genres' => [8, 14], 'publishers' => [506], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 801, 'game_title' => 'Warcraft II: Tides of Darkness', 'release_date' => '1995-12-09', 'platform' => 1, 'overview' => "Players must collect resources, and produce buildings and units in order to defeat an opponent in combat on the ground, in the air and in some maps at sea. The more advanced combat units are produced at the same buildings as the basic units but also need the assistance of other buildings, or must be produced at buildings that have prerequisite buildings. The majority of the main screen shows the part of the territory on which the gamer is currently operating, and the minimap can select another location to appear in the larger display. The fog of war completely hides all territory which the gamer's has not explored, and shows only terrain but hides opponents' units and buildings if none of the gamer's units are present.", 'youtube' => 'https://www.youtube.com/watch?v=rFCWKRW5HDI', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1203], 'genres' => [6], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 802, 'game_title' => 'Warcraft III: Reign of Chaos', 'release_date' => '2002-07-03', 'platform' => 1, 'overview' => "Warcraft III, released in 2002 as the third installment in Blizzards Warcraft series, takes place in the fictional world of Azeroth. Several years before the events of the games, a demon army known as the Burning Legion intent on Azeroth's destruction corrupted a race called the Orcs, and sent them through a portal to attack Azeroth. After many years of fighting, the Orcs were defeated by a coalition of humans, dwarves and elves known as the Alliance; the surviving combatants were herded into internment camps, where they seemed to lose their lust for battle. With no common enemy, a period of peace followed, but the Alliance began to fracture. The events of Warcraft III occur after a timeskip from Warcraft II. This period was originally intended to have been documented in Warcraft Adventures, but that game was canceled in mid-development.", 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1203], 'genres' => [6], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 803, 'game_title' => 'Warcraft III: The Frozen Throne', 'release_date' => '2003-07-01', 'platform' => 1, 'overview' => "Illidan Stormrage has gained the allegiance of the Naga, former Night Elves who were magically mutated during The Sundering, and became strange, reptilian creatures. The Warden Maiev Shadowsong pursues her former prisoner, Illidan, across the sea, first to the Tomb of Sargeras. However, Illidan gains an artifact known as the 'Eye Of Sargeras' and wipes out some of Maiev's best soldiers. Forced to call for help, she sends a messenger back to the mainland of Kalimdor. She asks the assistance of Malfurion Stormrage and Tyrande Whisperwind, but Maiev holds a grudge against Tyrande for her actions in releasing Illidan. Although they are able to chase Illidan to Lordaeron, while helping the Blood Elven prince Kael'Thas, Tyrande delays the advance on an Undead army that causes her to be swept away downriver: upon their reunion, Maiev lied to Malfurion, claiming Tyrande was killed in order to prevent Illidan's escape. Malfurion and Maiev prevent Illidan from using the artifact called the Eye of Sargeras, defeat his army and condemn him to death. Illidan tries to justify his actions by saying his plan was to use the Eye to destroy the Icecrown Glacier and kill the Lich King, thereby destroying their common enemy in the Undead, but Malfurion accuses Illidan of having indirectly causing Tyrande's death. Kael'thas then informs him Tyrande may have survived; Maiev's treachery comes out, and the brothers Stormrage join forces to save Tyrande. At this point, Kael'Thas supposedly takes a few more days to meet up with the human forces in the city of Dalaran, the exact same city in which they stopped Illidan. Malfurion then pardons Illidan after they save Tyrande, though he does not revoke his exile. Illidan then states that he could not join the Night Elves even if Malfurion did permit it, because his master will be enraged by his failure to use the Eye properly, and will hunt him down. Illidan departs for Outland, followed by Maiev. It seems as though Maiev would chase Illidan to the depths of the world, as she would do so. Malfurion then remarks that she has become 'vengeance itself'.", 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1203], 'genres' => [6], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 804, 'game_title' => 'Warhammer 40,000: Dawn of War', 'release_date' => '2004-09-20', 'platform' => 1, 'overview' => "Warhammer 40,000: Dawn of War is a military science fiction real-time strategy video game developed by Relic Entertainment based on Games Workshop's popular tabletop wargame Warhammer 40,000. It was released by THQ on September 20, 2004 in North America. Since its release, three expansion packs have been released: Winter Assault in 2005, Dark Crusade in 2006, and Soulstorm in 2008. The sequel, Dawn of War II was released in February 2009.\r\n\r\nThe Game of the Year edition was released on September 21, 2005 in the USA and on September 23 in Europe, containing 4 exclusive maps. Later, the Game of the Year edition and Winter Assault were bundled in the Gold Edition in the USA, released in March 2006. In November 2006, Dawn of War and its first two expansions were released together as The Platinum Collection in the USA or as the Dawn of War Anthology in the PAL regions. More recently, in March 2008, all three expansions along with Dawn of War have been released as The Complete Collection.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7131], 'genres' => [6], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 805, 'game_title' => 'Warcraft: Orcs & Humans', 'release_date' => '1994-01-15', 'platform' => 1, 'overview' => "The Orcs originated from another world, where the majority were bloodthirsty warriors driven by strife. However, their Warlocks remained aloof, devoted to the research of magic. The Warlocks noticed a rift between the dimensions and, after many years, opened a small portal to another world. One Warlock explored and found a region, whose Human inhabitants called it \"Azeroth\", from which the Warlock returned with strange plants as evidence of his discovery.\r\n\r\nThe Orcs enlarged the portal until they could transport seven warriors, who massacred a Human village. The platoon brought back samples of good food and fine workmanship, and a report that the Humans were defenseless. The Orcs' raiding parties grew larger and bolder, until they assaulted Azeroth's principal castle. However, the Humans had been training warriors of their own, especially the mounted, heavily-armed Knights. These, assisted by Human Sorcerors, gradually forced the Orcs to retreat through the portal, which the Humans had not discovered.\r\n\r\nFor the next fifteen years, one faction of Orcs demanded that the portal be closed. However a chief of exceptional cunning realized that the Humans, although out-numbered, had prevailed through the use of superior tactics, organization, and by magic. He united the clans, imposed discipline on their army and sought new magics from the Warlocks and Necromancers. Their combined forces were ready to overthrow the Humans.", 'youtube' => 'https://www.youtube.com/watch?v=mPvPT9wDLvQ', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1203], 'genres' => [6], 'publishers' => [47], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 806, 'game_title' => 'Warhammer 40,000: Dawn of War - Dark Crusade', 'release_date' => '2006-10-09', 'platform' => 1, 'overview' => 'As with previous Dawn of War titles, Dark Crusade is focused on the conflict part of gameplay; in order to obtain more resources players must fight over them. Each player starts off with a base and wins by fulfilling mission objectives. There are multiple tiers of technology, with each allowing for more powerful units and upgrades.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7131], 'genres' => [6], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 807, 'game_title' => 'Fable II', 'release_date' => '2008-10-21', 'platform' => 15, 'overview' => 'Fable™ II is the true sequel to the wildly successful original that sold more than 3 million copies, offering even more choices and building on the core gameplay theme of "Fable," where a player’s every decision continually defines whom they become. "Fable II" is an action role-playing game (RPG) that truly allows players to live the life they choose in an unimaginably open world environment. Set 500 years after the original, "Fable II" will provide gamers with an epic story and innovative real-time gameplay, including a massive amount of freedom and choice to explore a vast collection of dungeons, catacombs and caves in the world of Albion.', 'youtube' => '5pouqKKjh_M', 'players' => 1, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [4989], 'genres' => [1, 2, 4], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 808, 'game_title' => 'Empire: Total War', 'release_date' => '2009-03-03', 'platform' => 1, 'overview' => "Empire: Total War is set in the 18th century, a turbulent era that is the most requested by Total War's loyal fan base and a period alive with global conflict, revolutionary fervour and technological advances. The game features themes such as the Industrial Revolution, America's struggle for independence, the race to control Eastern trade routes and the globalisation of war on land and sea. Empire: Total War sees the debut of 3D naval combat within the Total War franchise. PC Gamers intuitively command vast fleets or single ships upon seascapes rich with extraordinary water and weather effects that play a huge role in your eventual glorious success or ignominious defeat. After pummelling your enemy with cannon fire, close in to grapple their ship and prepare to board taking control your men as they fight hand to hand on the decks. Empire: Total War also sees further enhancements to the Total War series signature 3D battles and turn based campaign map. Real time battles pose new challenges with the addition of cannon and musket, challenging players to master new formations and tactics as a result of the increasing role of gunpowder within warfare. And the Campaign Map - for many the heart of Total War - will see new improved systems for Trade, Diplomacy and Espionage with agents, a refined and streamlined UI, improved Advisors and extended scope taking in the riches of India, the turbulence of Europe and the untapped potential of North America.", 'youtube' => nil, 'players' => 4, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [1891], 'genres' => [6], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 809, 'game_title' => 'LittleBigPlanet', 'release_date' => '2008-10-27', 'platform' => 12, 'overview' => "If you were to stand on LittleBigPlanet and try to imagine a more astounding, fantastic, and creative place, full of enthralling adventure, uncanny characters, and brilliant things to do... you couldn’t. All imagination is here, and what you do with it all is entirely up to you.\r\n\r\nBuild new levels and expand the environment, collect the many and varied tools and objects to make your mark on this world, or just simply enjoy the people and puzzles they’ve set.\r\n\r\nLittleBigPlanet is the manifested embodiment of your perfect dream world...", 'youtube' => 'QlRNggZoInE', 'players' => 4, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [5352], 'genres' => [5, 12, 15], 'publishers' => [19], 'alternates' => ['Little Big Planet', 'LBP', 'LittleBIGPlanet', 'Little BIG Planet'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 810, 'game_title' => 'Gran Turismo 5', 'release_date' => '2010-11-24', 'platform' => 12, 'overview' => 'Gran Turismo 5  is the fifth edition of the Gran Turismo sim racing video game series. It is the first game in the franchise to provide a damage model, with variations of damage depending on whether a vehicle is a "Standard" or "Premium" car. The game also features weather effects, however they are only available on certain circuits. Optional Stereoscopic-3D resolution and Karting found a place in the game.Furthermore, new visual effects have been introduced, including dynamic skid marks, dust and the ability for drivers to flash their headlights. A course editor which allows the player to create new circuits by using tools that randomly generate track-parts according to certain player-selected specifications, including the number of corners, the time of day and the number of sectors. There are a variety of themes the player can choose from to act as a base for each circuit design. Themes also have an effect on track length and highest elevation.', 'youtube' => 'l2uQ2ayvvWY', 'players' => 6, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6739], 'genres' => [7], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 811, 'game_title' => 'Kane & Lynch: Dead Men', 'release_date' => '2007-11-14', 'platform' => 1, 'overview' => "In campaign mode the player controls Kane. The player is accompanied by Lynch, and sometimes other hired mercenaries. Co-op mode is available, in which the second player controls Lynch. Though almost identical to Kane's style of gameplay, Lynch has short bursts of aggression in which hallucinates nearly all AI characters are police, some sporting an animal's head. Lynch carries a shotgun and a revolver as side arm, while Kane carries an assault rifle and standard pistol, though it is possible to swap weapons. Additional weapons such as grenades, sniper rifles and carbines can be picked up, which can be swapped between allies. The player can take cover by standing next to a wall, and can blindfire. While having hired mercenaries, the player can issue orders such as follow, move to a specific position, or attack.", 'youtube' => 'tfMBFpPbHDc', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4320], 'genres' => [8], 'publishers' => [26], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 812, 'game_title' => 'Lost Empire: Immortals', 'release_date' => '2008-03-11', 'platform' => 1, 'overview' => 'Developed by the Danish studio Pollux Gamelabs, Lost Empire: Immortals, is an in-depth 4X game with thousands of stars to explore and colonize. 6 playable races battle to dominate a vast empire, either against a challenging AI or in multiplayer over the Internet.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6728], 'genres' => [6], 'publishers' => [170], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 814, 'game_title' => 'Vampire Rain', 'release_date' => '2007-07-03', 'platform' => 15, 'overview' => "Vampire Rain (ヴァンパイアレイン Vanpaia Rein) is a survival horror stealth video game developed by Artoon. It was released for the Xbox 360 in Japan on January 25, 2007 and in North America on July 3, 2007. The game was later ported to the PlayStation 3 under the title Vampire Rain: Altered Species and was released in Japan on August 21, 2008 and in North America on September 2, 2008.\r\nCome face to face with the ultimate, most intense enemies ever seen on the Xbox 360. You are a part of a Special Forces team tasked with removing the Nightwalkers in all their gore and supernatural strength before they overrun the world - and before the public finds out about them.", 'youtube' => '', 'players' => 8, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [681], 'genres' => [1, 2, 16], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 815, 'game_title' => 'inFamous', 'release_date' => '2009-05-26', 'platform' => 12, 'overview' => "In Infamous, the player controls the protagonist Cole MacGrath, a bike messenger caught in the center of an explosion that devastates several city blocks of the fictional Empire City. The explosion sends the city into chaos while Cole finds himself with new electricity-based super powers. Though the game's story follows Cole using his new abilities to restore some semblance of order to Empire City, the player is given several opportunities to use these powers for good or evil purposes in the game's Karma system. These choices ultimately affect character growth, the reaction of the City's populace towards Cole, and finer elements of gameplay and the story.", 'youtube' => 'nJSNJDn4Puc', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8302], 'genres' => [1, 2, 12], 'publishers' => [38], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 816, 'game_title' => 'The Saboteur', 'release_date' => '2009-12-09', 'platform' => 12, 'overview' => "The player is able to explore Nazi-occupied Paris, some of the French countryside and parts of Germany.[3] Color is a key element in the gameplay. Areas which are heavily controlled by the Nazis are represented in black and white, with the exception of the irises of characters' eyes, city lights, blue symbols of the French Resistance, and various German symbols, which are bright red and complete with swastikas. In order to make that district colored (\"inspired\") again, players must weaken the German forces occupying the area. In doing so, that district's citizens regain their hope, visually represented by making the area vibrant and full of color. This also affects gameplay; in black and white areas, German soldiers are present in large numbers, making it far more likely that Sean will be detected in his rebellious activities.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [6398], 'genres' => [1, 2], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 817, 'game_title' => 'Wolfenstein', 'release_date' => '2009-08-18', 'platform' => 1, 'overview' => "Wolfenstein is a story driven first-person shooter. The story is told through cutscenes, scripted events, telegraph messages, and intelligence that the player finds scattered throughout the game. The game involves the main character, B.J. Blazkowicz, going to a fictional German town called Isenstadt, which serves as \"hub\" for the player throughout the game. Isenstadt is where the player can get missions from two different groups, or upgrade their weapons and powers at the Black Market.\r\n\r\nAside from the weapons, the player also finds a medallion called the \"Thule Medallion\". With it, the player can get many abilities. The abilities are Veil Sight (the ability to see secrets, and, once upgraded, through walls), Mire (the ability to slow down time), Shield (the ability to throw up a shield that blocks, and, once upgraded, bounces back bullets), and Empower (the ability to significantly increase the damage of the player's weapons).\r\n\r\nEvery time the player activates the Medallion, the player enters a dimension called the \"Veil\", which is a barrier between this dimension and the fictional \"Black Sun\" dimension, the occult power source the Nazis want to master. Inside the Veil, the player can see floating creatures called \"geists\". Geists can be destroyed, and destroying them releases an energy burst which can kill or stun nearby enemies. Geists are usually passive, but if the player kills one, others can become angry and attack the player in a suicidal explosion.\r\n\r\nVarious items can be collected throughout the game: Gold, Intelligence, and Tomes of Power. Gold is used as currency to buy various upgrades from the Black Market. Intelligence provides some background information about the story, and is used to unlock some of the upgrades for weapons. Tomes of Power are used to upgrade the Veil Powers.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7006], 'genres' => [1, 8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 818, 'game_title' => 'Dynasty Warriors: Gundam', 'release_date' => '2007-08-28', 'platform' => 12, 'overview' => "Dynasty Warriors: Gundam, originally released in Japan as Gundam Musou (ガンダム無双 Gandamu Musō?), is a video game based on the Gundam anime series. It was developed by Omega Force and published by Bandai Namco Games. Its gameplay is derived from Koei's popular Dynasty Warriors and Samurai Warriors series.[1] The \"Official Mode\" of the game is based primarily on the Universal Century timeline, with mecha from Mobile Suit Gundam, Mobile Suit Zeta Gundam, and Mobile Suit Gundam ZZ appearing in the game,[2] as well as a few units from Mobile Suit Variations Mobile Suit Gundam 0080: War in the Pocket and Mobile Suit Gundam 0083: Stardust Memory appearing as non-playable ally and enemy units. The \"Original Mode\" of the game also features mecha from the non-UC series Mobile Fighter G Gundam, Mobile Suit Gundam Wing and ∀ Gundam. A newly designed non-SD Musha Gundam designed by Hajime Katoki is also included.[3]\r\n\r\nThe game was originally released on March 1, 2007 in Japan[4] exclusively for the PlayStation 3 with the name Gundam Musou. A North American version was released on August 28, 2007, for both the PlayStation 3 and the Xbox 360 under the name Dynasty Warriors: Gundam [5] with English localization by AltJapan Co., Ltd.[6] Dynasty Warriors: Gundam is the second next-gen Gundam game released in North America, following Mobile Suit Gundam: Crossfire. A Japanese Xbox 360 version was released in Japan on October 25, 2007 under the name of Gundam Musou International. Unlike the Japanese PlayStation 3 edition, Gundam Musou International features both Japanese and English voice overs.\r\n\r\nAn expanded port for PlayStation 2 called Gundam Musou Special was released on February 28, 2008 in Japan, featuring new scenarios and mobile suits.[7]", 'youtube' => '1SgAWzVny8E', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [4738, 6242], 'genres' => [1, 4, 10], 'publishers' => [6], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 819, 'game_title' => 'Neo Steam: The Shattered Continent', 'release_date' => '2009-06-11', 'platform' => 1, 'overview' => nil, 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 820, 'game_title' => 'Overlord II', 'release_date' => '2009-06-23', 'platform' => 1, 'overview' => "Overlord II is the sequel to the warped fantasy action adventure that had players being delightfully despotic. In Overlord II, a new Overlord and a more powerful army of Minions take on an entire empire in a truly epic adventure, inspired by the rise of the Roman Empire. As the Glorious Empire conquers kingdoms and destroys any sign of magic it finds, it's time to go Minion Maximus and send in the horde. The Minions return smarter, deadlier (and funnier) and are ready to fight in large scale battles that will see their wild pack mentality squaring up to the organised legions of the Glorious Empire. As ever, they'll do anything and everything the Overlord commands of them, especially now that they can run ravage and wreck buildings and scenery. They've also learned how to ride: In Overlord II Minions mount up and ride wolves and other magical creatures around the landscape and take them into battle, making our band of merry fighters faster and fiercer than ever before.", 'youtube' => 'g6fqAKD2DGA', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9065], 'genres' => [1], 'publishers' => [16], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 821, 'game_title' => 'World in Conflict: Soviet Assault', 'release_date' => '2009-03-11', 'platform' => 1, 'overview' => nil, 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5293], 'genres' => [6], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 822, 'game_title' => 'Kingdom Under Fire II', 'release_date' => '2013-06-30', 'platform' => 1, 'overview' => "Kingdom Under Fire II is a video game set in a high fantasy setting developed by Blueside which merge real-time strategy (RTS), role-playing game (RPG) and massively multiplayer online game (MMO) genres - the game is to have a single player, and online multiplayer mode. The game follows on chronologically from Kingdom Under Fire: Circle of Doom, and is the first RTS game set in the Kingdom Under Fire universe to be released since the 2005 Kingdom Under Fire: Heroes.\r\n\r\nThe game was announced in January 2008, and has been subject to delay and changes to release platforms; A closed beta-test began on December 2011 in South Korea.\r\n\r\nIn November 2013, the developers announced that a version for the PlayStation 4 was in development.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 823, 'game_title' => 'Legend of Mir 3', 'release_date' => '2005-01-01', 'platform' => 1, 'overview' => nil, 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 824, 'game_title' => 'Red Steel 2', 'release_date' => '2010-03-23', 'platform' => 9, 'overview' => "The game begins as an unnamed Hero, the last member of the Kusagari Clan, is being dragged across the desert, tied to the back of a motorcycle. He manages to break free, but Payne, the leader of the Jackals - a vast gang of thugs, murderers and thieves - steals the Hero's katana. While running from the Jackals, the Hero rescues his old swordsmaster Jian who was to soon be executed by the Jackals. After the rescue, Jian allows the Hero to borrow his sword until the Hero can recover his own from Payne.", 'youtube' => 'https://www.youtube.com/watch?v=DWutufIWx_4', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [1, 8], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 825, 'game_title' => 'Split/Second', 'release_date' => '2010-05-21', 'platform' => 1, 'overview' => 'You have made the cut to join a group of elite drivers chosen to participate in the global broadcast event known as Split/Second. Racing through a city created specifically for destruction, your goal is to become the season champ where fame, fortune and glory await. But first, you must survive a grueling 24-episode season of races in a variety of explosive locations to crush the competition and become the champion. When speed is not enough, the city is your weapon.', 'youtube' => 'WpnUzI04_1s', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [1161], 'genres' => [7], 'publishers' => [171], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 826, 'game_title' => 'Dead Rising 2', 'release_date' => '2010-09-28', 'platform' => 1, 'overview' => "Several years have passed since the Wilamette incident, and Dead Rising 2 shifts the action from the everyday world of mid-West America to the glitz and glamour of Fortune City, America's latest and greatest entertainment playground. People flock to Fortune City from around the globe to escape from reality and the chance to win big and for some, this means competing in Terror is Reality.\r\n\r\nLike millions of Americans, former national motocross champion Chuck Greene is gripped by the TV sensation that is Terror is Reality. Hosted by the flamboyant Tyrone King, Terror is Reality pits ordinary members of the public against an arena full of zombies with a simple challenge – kill more zombies than your opponents and stay alive with the winner collecting big money and the chance to come back and secure even greater prizes. So, what is it that has forced Chuck to come to Fortune City and risk his life in the modern day gladiatorial contest, is he trying to recapture the fame of his motocross days, does he have a reason to hate zombies, or is it simply the lure of big money?", 'youtube' => 'ZYooJsLi31Y', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1221], 'genres' => [1, 2], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 827, 'game_title' => 'Resident Evil: The Darkside Chronicles', 'release_date' => '2009-11-17', 'platform' => 9, 'overview' => "The Darkside Chronicles is an on-rails shooting game. In the Resident Evil series it is the second title exclusive to the Wii platform. The game's plot revolves around the personal stories and tragedies in the series, with its main focus on retelling the events of Resident Evil 2 and Resident Evil: Code: Veronica.\r\n\r\nA new chapter called Operation Javier fleshes out the plot further and explains the motives of Resident Evil 4 villain Jack Krauser. It takes place in 2002 and is set in the waterside village of Mixcoatl, located in the South American Amparo. It tells the story of Leon S. Kennedy teaming up with Jack Krauser to investigate the connections of crime lord Javier Hidalgo to a former Umbrella researcher.\r\n\r\nJust like The Umbrella Chronicles players do not control the character's movement, but only the shooting aspect, shown from a first-person perspective. The player's partner is also shown on the screen and there is an cooperative option for two players.", 'youtube' => 'WKGUO972E1A', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1436], 'genres' => [8], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 828, 'game_title' => 'R.U.S.E.', 'release_date' => '2010-09-07', 'platform' => 1, 'overview' => "Developed by Eugen Systems, R.U.S.E is the first strategy game where your ability to deceive and manipulate your enemies determines your nation's fate. Lead your army to victory by camouflaging your troops, luring your opponent with decoy units, sabotaging enemy logistics and much more. Strategy has never been so intuitive and deep. R.U.S.E features cutting edge graphics and effects, the incredible IRISZOOM Engine, immersive combat and a simplified interface that allows you to determine your nation's strategy and fight to defeat your enemies.", 'youtube' => nil, 'players' => 4, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [2882], 'genres' => [6], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 829, 'game_title' => 'Damnation', 'release_date' => '2009-05-26', 'platform' => 1, 'overview' => "Damnation is a third-person shooter set in a steampunk-universe with the player taking over the control of Rourke, fighting through hordes and hordes of enemies as well as jumping from roof to roof and other climbing exercises in order to accomplish his objectives like freeing a prisoner or shutting down a factory. On his side the Indian healer Yakecan and the cowboy Ramon Sepherius Zagato. Of course the enemies don't just drop dead by the sight of Rourke and his friends. Instead everyone can carry around three weapons. Two big ones like a shotgun, grenade launcher or sniper rifle and one pistol which also includes gear like the railroad-spike-gun. In addition the players have access to trip-mines that can either be thrown or planted but always have to be triggered manually. Since the levels are huge and traveling on foot sometimes is either not feasible or possible, steampunk bikes stand ready for the players to be used in two different designs. The small version carries two persons with one being the driver and the second one standing on the back shooting everything in sight. The second version allows for two gunners on the back.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1228], 'genres' => [8], 'publishers' => [16], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 830, 'game_title' => 'Medieval II: Total War: Kingdoms', 'release_date' => '2007-08-28', 'platform' => 1, 'overview' => 'Medieval II: Total War Kingdoms is the official expansion to Medieval II: Total War, presenting players with all-new territories to explore, troops to command, and enemies to conquer. Kingdoms features four new entire campaigns centered on expanded maps of the British Isles, Teutonic Northern Europe, the Middle East, and the Americas. All-new factions from the New World are also now fully playable, including the Aztecs, Apaches, and Mayans.', 'youtube' => nil, 'players' => 1, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [1891], 'genres' => [6], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 831, 'game_title' => 'Painkiller: Overdose', 'release_date' => '2007-10-26', 'platform' => 1, 'overview' => nil, 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => nil, 'genres' => [8], 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 832, 'game_title' => 'Pirates of the Caribbean: The Legend of Jack Sparrow', 'release_date' => '2003-06-30', 'platform' => 1, 'overview' => "Pirates of the Caribbean is a 2003 video game for Microsoft Windows and Xbox, developed by Akella and published by Bethesda Softworks. The Xbox version was the first U.S. console game developed in Russia. A PlayStation 2 version was also originally in development, but was later canceled.\r\n\r\nAn unrelated game by the same name was also released for mobile phones, as was a Game Boy Advance game.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 833, 'game_title' => 'Siren: Blood Curse', 'release_date' => '2008-07-24', 'platform' => 12, 'overview' => "A TV crew from America arrive to research and film an exposé on the urban myth of Hanuda, the Vanished Village, where human sacrifices are said to have taken place.\r\n\r\nHanuda is a dark, eerie world, frozen in the 1970s and surrounded by a red sea. An ancient curse has been set upon the town and you, as the visitors, must save the remaining inhabitants including the beautiful Miyako. In order to survive you must defend yourself from the vicious Shibito, or living dead, and other terrifying monsters.\r\n\r\nAcross 12 chapters of horror, gamers will confront the mysteries of Hanuda in this new chapter of the the cult classic horror game. Throughout the game you will play each of the visitors to the village. The game's unique Sight-Jack System enables you to switch seamlessly between the visions of the hunted and the hunters. Blood, guts and gore are super-enhanced by amazing graphic effects, an advanced physics engine and shockingly realistic facial animations.", 'youtube' => 'PRGX5Tbj1WQ', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4441], 'genres' => [18], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 834, 'game_title' => 'Too Human', 'release_date' => '2008-08-19', 'platform' => 15, 'overview' => 'As the Cybernetic God Baldur, you get thrust into the midst of an ongoing battle that threatens the existence of mankind. An ancient machine presence has forced the Gods hand. In the first of a three part trilogy, Baldur is charged with defending mankind from an onslaught of monstrous war machines bent on eradication of human life. It takes more than brawn and raw strength to supplant the machine hordes. Utilize a sophisticated blend of seamless melee and firearms combat to vanquish foes close and far. Feel each punishing blow through advanced visual effects. Intuitive combat provides new level of accessibility: Perform Baldurs elaborate and complex combat maneuvers through the press of a button and chain together rapid-fire combos with ease. Through the use of an intuitive combat system, Too Human provides gameplay that is easy to learn and rewarding to master and introduces combinations of weapons combat on a high level. The story chronicles the ongoing struggle between Cybernetic gods, machine giants and mortal men on a massive scale never before seen. Play the role of a cybernetic god charged with protecting the human race against a relentless onslaught of machines.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7735], 'genres' => [1, 2], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 835, 'game_title' => 'Blur', 'release_date' => '2010-05-25', 'platform' => 1, 'overview' => "In Blur's career mode, the player will encounter numerous characters and many licensed cars ranging from Dodge Vipers to Lotus Exiges to Ford Transit vans fitted with F1 engines, all of which have full damage modeling and separate traits such as Acceleration, Speed, Drift, Grip and Stability. Some special car models have been designed by Bizarre Creations themselves. There are also some heavily altered versions of familiar urban environments, such as the Los Angeles river halfpipe and several parts of London. These areas were altered to make the races more enjoyable instead of the developers having to strictly abide by each twist and turn. Depending on the character(s) the player races against or tags along with in team races, they will have their own racing styles, power-up set ups, match types, locales, cars and will be apart of certain fictional servers. As the player races well, performs stunts and uses power-ups in certain ways during races, the player will gain 'fan points'. These points help the player progress through the career, purchase more cars and parts and earn more fans for the user base. During the career, challenges will take place midrace when the player drives through a fan icon. Completing these short challenges (e.g. find a secret nitro power-up) will reward the player with a fan points boost.\r\n\r\nGame provides split screen for multi player", 'youtube' => 'L88zX6qfj4Y', 'players' => 1, 'coop' => 'Yes', 'rating' => 'E10+ - Everyone 10+', 'developers' => [1131], 'genres' => [7], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 836, 'game_title' => 'Call of Juarez: Bound in Blood', 'release_date' => '2009-06-30', 'platform' => 1, 'overview' => 'The story begins with Ray and Thomas pointing their guns at each other. William laments on how things degenerated between them to the point of them becoming mortal enemies. Flash to several years ago, Ray and Thomas are fighting in the American Civil War. After they defeat the enemy, they are ordered to retreat to Jonesboro. They refuse, deserting their posts to save their home from Union troops. When they arrive, they find their mother dead. Ray promises to rebuild their house, and knowing their superior Colonel Barnsby will not let them off, they flee, taking their young brother, William, with them.', 'youtube' => 'zE4xc124Wjs', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [8593], 'genres' => [8], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 837, 'game_title' => 'Ghostbusters: The Video Game', 'release_date' => '2009-06-16', 'platform' => 1, 'overview' => "Who ya gonna call?\r\nThe game is a third-person shooter, placing players in the role of an original character simply known as \"Rookie\" (also called 'Rook', 'Newbie' and similar names by the Ghostbusters), a new recruit to the Ghostbusters team. Players control Rookie's movements as he explores the environments of each level, seeking out paranormal activities and ghosts, either alone or with up to all four of the other Ghostbusters. Players can switch to a first-person perspective by equipping the Rookie with the PKE Meter and goggles. In this mode, paranormal items are highlighted and the PKE Meter will help direct players to ghosts or haunted artifacts. Players can scan these elements to gain more information about them and receive a monetary reward. Weapons cannot be used in this mode.", 'youtube' => 'LyVGSGynYpg', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8670], 'genres' => [1], 'publishers' => [506], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 838, 'game_title' => 'Forza Motorsport 3', 'release_date' => '2009-10-27', 'platform' => 15, 'overview' => 'Forza Motorsport 3 is a racing video game developed for Xbox 360 by Turn 10 Studios. It was released in October 2009. It is the sequel to Forza Motorsport 2 and the third installment in the Forza Motorsport series. The game includes more than 400 customizable cars (More than 500 cars in the Ultimate Collection version) from 50 manufacturers and more than 100 race track variations with the ability to race up to eight cars on track at a time. These cars vary from production cars to race cars such as those from the American Le Mans Series.[1]', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9106], 'genres' => [7], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 839, 'game_title' => 'Dirge of Cerberus: Final Fantasy VII', 'release_date' => '2006-08-15', 'platform' => 11, 'overview' => "WHEN MIDGAR DIED, SOMETHING SURVIVED.\r\n\r\nFrom the ashes of Meteorfall, a mysterious organisation has arisen. Between it and the domination of this shattered world stands an unlikely champion, the enigmatic Vincent Valentine. Taking place one year after the events of FINAL FANTASY VII ADVENT CHILDREN, this wholly new chapter in the FINAL FANTASY VII saga features familiar faces and cutting edge gunfighting action. The fate of the world will be decided in a storm of bullets!", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2808], 'genres' => [1, 2], 'publishers' => [12], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLPM-66271', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SLUS-21419', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 840, 'game_title' => "Tom Clancy's Splinter Cell: Conviction", 'release_date' => '2010-04-27', 'platform' => 1, 'overview' => 'Taking place three years after the events of Splinter Cell: Double Agent, former Navy SEAL Victor Coste is held in a Black Arrow facility interrogation room as he is interviewed by an unidentified group of men. Victor begins to recount the events of Splinter Cell: Conviction in the past tense. This continues throughout the game, with each level being narrated in the past tense as the player "experiences" what happened.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9150], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 841, 'game_title' => 'The Conduit', 'release_date' => '2009-06-23', 'platform' => 9, 'overview' => "In The Conduit, you'll find yourself at the center of a thrilling battle involving aliens, secret agents and centuries-old government conspiracies, all set against the backdrop of modern-day Washington, D.C. Built from the ground up for the Wii, the game pits you against ruthless, wily enemies who react to your moves and use the environment to their own advantage. Tailor the game to suit your personal style, and see the game's intense visuals burst to life complete with dynamic environment mapping, interactive water with real-time reflection and four-stage texture composition. Gather up to 11 additional players online for brutal multiplayer action, and incorporate the Wii Speak peripheral to enhance the immediacy of the battle.\r\n\r\nAlso Available\r\nSpecial Edition\r\n\r\nUnlockable Secret Agent Multiplayer Skin\r\nUnique All Seeing Eye Device With Custom Detailing\r\nExclusive concept art book with development insights into the world of \"The Conduit\"\r\nCompatible with Wii Speak (Sold separately)", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [3837], 'genres' => [8], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 842, 'game_title' => 'Wanted: Weapons of Fate', 'release_date' => '2009-03-24', 'platform' => 1, 'overview' => 'For centuries, a secret fraternity of assassins has brutally executed kill orders dictated by the Loom of Fate. Your destiny is to become their ultimate weapon. Kicking into action where the hit film, WANTED, left off, you are Wesley Gibson an uber assassin and heir to a legacy of power, hunted by a renegade faction of The Fraternity. Master an arsenal of deadly skills to protect the secrets of your killer coalition ... or blow them all away!', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3630], 'genres' => [1, 8], 'publishers' => [152], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 843, 'game_title' => 'God of War III', 'release_date' => '2010-03-16', 'platform' => 12, 'overview' => "God of War III is a third-person action-adventure video game developed by Santa Monica Studio and published by Sony Computer Entertainment (SCE). First released for the PlayStation 3 (PS3) console on March 16, 2010, the game is the fifth installment in the God of War series, the seventh and final chronologically, and the sequel to God of War and God of War II. Loosely based on Greek mythology, the game is set in Ancient Greece with vengeance as its central motif. The player controls the protagonist, Kratos, the former God of War, after his betrayal by his father Zeus, the King of the Olympian Gods. Reigniting the Great War, Kratos ascends Mount Olympus with his initial allies, the Titans, until he is abandoned by Gaia. Now guided by the spirit of Athena to search for the Flame of Olympus, Kratos battles monsters, gods, and Titans in a search for Pandora, the key to pacifying the Flame surrounding Pandora's Box, and to defeat Zeus. Successful, Kratos kills Zeus and ends the reign of the Olympian God", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7435], 'genres' => [1], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 844, 'game_title' => "Tom Clancy's EndWar", 'release_date' => '2009-02-24', 'platform' => 1, 'overview' => "Tom Clancy's EndWar is a real-time tactics game designed by Ubisoft Shanghai for the PlayStation 3, Xbox 360 and Windows platforms. The Nintendo DS and PlayStation Portable versions feature turn-based tactics instead of the real-time tactics of their console counterparts.[4] It was released on November 4, 2008 in the United States, November 6, 2008 in Canada, and November 8, 2008 in Europe.[2] A Windows version was released on February 24, 2009.[5]", 'youtube' => '8Bd9eZ9Z7Qc', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9176], 'genres' => [6], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 845, 'game_title' => 'Need for Speed: Shift', 'release_date' => '2009-09-15', 'platform' => 1, 'overview' => "Aimed at a hardcore gamer-style audience, Shift reverts to the touring-car simulation style of its 2007 predecessor, NFS ProStreet. Although the gameplay of these two titles are similar, Shift recreates car handling much more realistically than ProStreet, and does not contain a story. Upon starting the career mode, the player must do a lap of the track to decide on car settings. Once completed, the player is welcomed to the 'NFS Live World Series', and must earn stars in races to earn money, and unlock new races.", 'youtube' => 'VfXOAc9xSy8', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7845], 'genres' => [7, 11], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 846, 'game_title' => 'Brütal Legend', 'release_date' => '2009-10-13', 'platform' => 15, 'overview' => 'Brütal Legend is an epic action game from visionary developer Tim Schafer. Jack Black stars as Eddie Riggs, a legendary roadie summoned to a world of Heavy Metal where mountains are made of amplifiers, killer spiders spin guitar strings and Rock Legends roam the landscape. As Eddie, crush skulls with a battle axe, ravage the road in a super-charged Hot Rod and unleash the power of Rock to reign down fire from the sky - all to save humanity and become a Brütal Legend. ', 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2456], 'genres' => [1, 6], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 847, 'game_title' => 'Halo Wars', 'release_date' => '2009-03-03', 'platform' => 15, 'overview' => 'The year is 2531, twenty years prior to the events in Halo: Combat Evolved and the Covenant have found something on the planet Garvest. The UNSC ship "Spirit of Fire" is sent to investigate and stop whatever the enemy is up to. What the crew finds could be the only thing that stands between humanity and certain annihilation by the Covenant. Command large armies, lead them into battle, control their every move and use their abilities to gain the upper hand in combat.', 'youtube' => '', 'players' => 6, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [2817], 'genres' => [6], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 848, 'game_title' => 'Tekken 6', 'release_date' => '2009-10-27', 'platform' => 12, 'overview' => "Tekken 6 features bigger stages with more interactivity than its predecessors, such as walls or floors that can be broken to reveal new fighting areas. The character customization feature has been enhanced, and certain items have implications in some aspects of gameplay.\r\nA new \"rage\" system has been added, giving characters more damage per hit when their vitality is below a certain point. Once activated, a reddish energy aura appears around the character, and their health bar starts to flicker in red. The rage aura can be customized with different colors and effects to appear like fire, electricity, ice, among others. Another gameplay feature added is the \"bound\" system. Every character has several moves that, when used on an opponent that is currently midair in a juggle combo, will cause the opponent to be smashed hard into the ground, bouncing them off the floor in a stunned state and leaving them vulnerable to another combo or additional attack. As of the Bloodline Rebellion update, successfully parrying a low attack will also put a character into a bound state.", 'youtube' => 'cS0O-o9qY9I', 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [902], 'genres' => [10], 'publishers' => [6], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 849, 'game_title' => 'Section 8', 'release_date' => '2009-09-04', 'platform' => 1, 'overview' => 'Section 8 is an intense first-person shooter that gives players unprecedented strategic control over the battlefield, employing tactical assets and on-demand vehicle deliveries to dynamically alter the flow of combat. Set at the crossroads of a growing insurrection among its colonies, Earth dispatches the elite 8th Armored Infantry to turn the tide. Utilizing advanced powered armor suits, these brave volunteers are the only ones crazy enough to smash through enemy defenses and drop directly into the battlefield from 15,000 feet, earning them the nickname "Section 8."', 'youtube' => '8Zxi0PqkbJE', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8858], 'genres' => [8], 'publishers' => [67], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 850, 'game_title' => 'Prince of Persia: Warrior Within', 'release_date' => '2004-11-30', 'platform' => 1, 'overview' => "Seven years after the events of Prince of Persia: The Sands of Time, the Prince finds himself constantly hunted by a terrible beast known as the Dahaka. The Prince seeks counsel from an old wise man who explains that whoever releases the Sands of Time must die. Because the Prince escaped his fate, it is the Dahaka's mission as guardian of the Timeline to ensure that he dies as he was meant to. The old man also tells of the Island of Time, where the Empress of Time first created the Sands. The Prince sets sail for the Island in an attempt to prevent the Sands from ever being created, an act he believes will appease the Dahaka. After a battle at sea with an enemy force led by a mysterious woman in black capsizes the Prince's ship, the Prince washes ashore unconsciously onto the Island of Time.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9150], 'genres' => [1, 2], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 851, 'game_title' => 'Watchmen: The End Is Nigh', 'release_date' => '2009-07-21', 'platform' => 1, 'overview' => "The game allows players to take on the roles of either Rorschach or Nite Owl II in single player or cooperative multiplayer. Rorschach and Nite Owl are the only playable characters in the game's first episode, which comprises six \"chapters.\" Cutscenes that look like animated comic panels, similar to those seen in the Watchmen motion comics released on iTunes, bookend each chapter. Two of the film's actors, Patrick Wilson and Jackie Earle Haley, provide their voices for their characters Nite Owl and Rorschach, respectively. The game features a mix of beat-em-up and puzzle gameplay, with the two characters having different strengths and abilities. Rorschach is faster with unconventional attacks and makes use of improvised weapons like crowbars and baseball bats; Nite Owl is slower but has a solid martial arts method and uses technological devices, such as \"screecher bombs\", and the grappling gun. The characters must work cooperatively to pass puzzles and defeat enemies.", 'youtube' => nil, 'players' => 2, 'coop' => nil, 'rating' => 'M - Mature', 'developers' => [2191], 'genres' => [1, 10], 'publishers' => [152], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 852, 'game_title' => 'DiRT 2', 'release_date' => '2009-12-08', 'platform' => 1, 'overview' => 'Following on the success of the original Dirt as well as a decade of videogame development in partnership with the late Colin McRae, DiRT 2 explores various disciplines of off-road racing. Dirt 2 features a roster of contemporary off-road events, taking players to the most diverse and challenging real-world environments. This World Tour has players competing in aggressive multi-car and intense solo races at extraordinary new locations, from canyon racing and jungle trails to city stadium-based events.', 'youtube' => '', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1726], 'genres' => [7], 'publishers' => [16], 'alternates' => ['Colin McRae: DiRT 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 853, 'game_title' => 'The Witcher', 'release_date' => '2007-10-30', 'platform' => 1, 'overview' => 'Become The Witcher, Geralt, a legendary monster slayer caught in a web of intrigue woven by forces vying for control of the world.  Make difficult decisions and live with the consequences in a game that will immerse you in an extraordinary tale like no other.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1532], 'genres' => [4], 'publishers' => [506], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 854, 'game_title' => "Demon's Souls", 'release_date' => '2009-10-06', 'platform' => 12, 'overview' => "King Allant the XII, the last king of Boletaria, searched tirelessly to expand his might. The Nexus, a great ice shrine nestled in the mountains, bestowed the power of the souls onto him, bringing prosperity to his kingdom. Still unsated, he returned again to the Nexus, where he foolishly awakened the Old One from its eternal slumber. This long forgotten evil, now wrought upon Boletaria, plunged the realm into darkness and fog. A mighty demon horde poured into the kingdom, devouring the souls of men. Champions from other realms learned of Boletaria's fate and sought to deliver the kingdom from evil; none would return from the cursed land. Called upon by a mysterious maiden in black, you go forth, the last hope for humanity in a place lost to demons and darkness...", 'youtube' => 'FRnIyXvonAU', 'players' => 3, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [3192], 'genres' => [1, 4], 'publishers' => [58], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 855, 'game_title' => 'Left 4 Dead 2', 'release_date' => '2009-11-16', 'platform' => 1, 'overview' => "Set in the zombie apocalypse, Left 4 Dead 2 (L4D2) is the highly anticipated sequel to the award-winning Left 4 Dead, the #1 co-op game of 2008.\r\n\r\nThis co-operative action horror FPS takes you and your friends through the cities, swamps and cemeteries of the Deep South, from Savannah to New Orleans across five expansive campaigns.\r\n\r\nYou'll play as one of four new survivors armed with a wide and devastating array of classic and upgraded weapons. In addition to firearms, you'll also get a chance to take out some aggression on infected with a variety of carnage-creating melee weapons, from chainsaws to axes and even the deadly frying pan.\r\n\r\nYou'll be putting these weapons to the test against (or playing as in Versus) three horrific and formidable new Special Infected. You'll also encounter five new “uncommon” common infected, including the terrifying Mudmen.\r\n\r\nHelping to take L4D's frantic, action-packed gameplay to the next level is AI Director 2.0. This improved Director has the ability to procedurally change the weather you'll fight through and the pathways you'll take, in addition to tailoring the enemy population, effects, and sounds to match your performance. L4D2 promises a satisfying and uniquely challenging experience every time the game is played, custom-fitted to your style of play.", 'youtube' => 'y0sJ5s7fUMQ?hd=1', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [9289], 'genres' => [1, 8, 18], 'publishers' => [13], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 856, 'game_title' => 'Combat Arms', 'release_date' => '2008-07-11', 'platform' => 1, 'overview' => "Combat Arms uses a player ranking system based on total experience, using common military ranks that players can obtain. Completing objectives, killing other players, and levelling up one's rank gives the player money in the form of Gear Points (GP), which can be used to purchase new equipment. Equipment includes weaponry, weapon attachments, and accessories for one's character.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2439], 'genres' => [1], 'publishers' => [174], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 857, 'game_title' => 'Silent Hunter 5: Battle of the Atlantic', 'release_date' => '2010-03-02', 'platform' => 1, 'overview' => 'Silent Hunter 5: Battle of the Atlantic is a submarine simulator for Microsoft Windows developed by Ubisoft Romania and published by Ubisoft. It is the fifth and latest installment of the Silent Hunter franchise and the successor of Silent Hunter 4: Wolves of the Pacific. Like Silent Hunter II and Silent Hunter III, it places the player in command of a German U-Boat during World War II, here the Battle of the Atlantic.', 'youtube' => 'I6wvDzClVNc', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 858, 'game_title' => 'MotorStorm: Arctic Edge', 'release_date' => '2009-10-20', 'platform' => 11, 'overview' => "Motorstorm: Arctic Edge is an arcade racer pitting you against 8 other racers, human or AI in a competition to win in The Festival. The backdrop for the game is Alaska where you have to race on icy tracks in mountainous regions. Beside the other racers you have to take into account avalanches, broken ice bridges and a lot of other dangers on the route to victory.\r\n\r\nThe game is very fast-paced and it sees you racing around in cars, snowmobiles and trucks. You can select different wheels, exhausts, spoilers and more for your vehicles.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1058], 'genres' => [7], 'publishers' => [21], 'alternates' => nil, 'uids' => [{ 'uid' => 'SCUS-97654', 'games_uids_patterns_id' => 2 }, { 'uid' => 'SCES-55573', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 859, 'game_title' => 'Prince of Persia: The Two Thrones', 'release_date' => '2005-12-01', 'platform' => 1, 'overview' => "Prince of Persia: The Two Thrones follows the second ending of Prince of Persia: Warrior Within, in which the Prince kills the Dahaka, essentially saving Kaileena. The game opens with the Prince and Kaileena about to sail into Babylon's port. Kaileena offers narration of the events passed and the story following, similar to the Prince's role as both protagonist and narrator in The Sands of Time.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 860, 'game_title' => 'Champions Online', 'release_date' => '2009-09-01', 'platform' => 1, 'overview' => 'Champions Online is a Massively Multiplayer Online game based on the pen & paper role-playing universe of Champions. As such, the world tries to loosely recreate the official HERO System ruleset. Compared to other MMOs, at the beginning of the character creation process you are asked to choose from a series of power frameworks, instead of classes. These will determine what powers you can use. It is even possible to combine them in the Custom Framework option. Your abilities are determined by eight characteristics: Strength, Dexterity, Constitution, Intelligence, Ego, Presence, Recovery and Endurance.', 'youtube' => '', 'players' => 16, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1959], 'genres' => [4, 14], 'publishers' => [506], 'alternates' => ['Champions Online: Free for All'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 861, 'game_title' => 'Guild Wars 2', 'release_date' => '2012-08-28', 'platform' => 1, 'overview' => "For generations, war and chaos raged across the land of Tyria. Five great races competed and warred against each other, struggling to tip the balance of power in their favor.\r\n\r\nThen the dragons woke.\r\n\r\nThe all-powerful beasts stirred from their millennial sleep under earth and sea. With their magical breath the dragons spread destruction and created legions of twisted slaves. A deathless dragon named Zhaitan raised the sunken nation of Orr, triggering earthquakes and tidal waves that destroyed entire cities across the Sea of Sorrows. Zhaitan's undead armies surged from the sea, hungry for the destruction of the five races of Tyria: the charr, a ferocious race of feline warriors; the asura, magical inventors of small size and great intellect; the norn, towering shapeshifters from the frigid northern lands; the sylvari, a mysterious young race of visionary plant folk; and the humans, an embattled but resilient people.\r\n\r\nNow heroes from the five races must set aside ancient rivalries and stand together against their common enemies in the sequel to the hit MMO Guild Wars. Magic, technology, and cold steel will determine the ultimate fate of the world.", 'youtube' => 'o4R5Q0ZOTa8', 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [609], 'genres' => [4, 14], 'publishers' => [18], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 862, 'game_title' => 'Castlevania: Lords of Shadow', 'release_date' => '2010-10-05', 'platform' => 12, 'overview' => "Gabriel Belmont learns of a mask with the power to raise the dead and sets out on a mission to obtain it to bring his recently murdered wife back from the dead.\r\n\r\nLords of Shadow builds upon the combat systems first explored in this series in 2003's Lament of Innocence and adds more violent kills to the mix. Inspiration for these changes seems to have come from 2005's God of War.", 'youtube' => 'RGAy6jrRUaY', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [5388], 'genres' => [1, 2, 18], 'publishers' => [23], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 863, 'game_title' => 'Dissidia: Final Fantasy', 'release_date' => '2009-08-25', 'platform' => 13, 'overview' => "Cosmos, the goddess of harmony. Chaos, the god of discord. Reigning from distant realms, the two gods had gathered warriors from all lands to lead them in savage war. Cosmos and Chaos were of equal strength. It was believed the conflict would last forever. However, the balance is now broken. Those who answered Chaos's call created an inexhaustible force. And under vicious attack without relent, the warriors fighting for Cosmos started to fall one by one. The conflict that has continued for eons is now about to end in Chaos's favor. The world has been torn asunder, sinking into a vortex of disorder. As for the few surviving warriors- their fates have yet to be determined.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2808], 'genres' => [4, 10], 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 864, 'game_title' => 'Singularity', 'release_date' => '2010-06-25', 'platform' => 1, 'overview' => "Singularity takes place on a fictional island known as Katorga-12, where Russian experiments involving Element 99 took place during the height of the Cold War. In 1955, a catastrophe involving experiments attempting to form a \"Singularity\" occurred on the island, causing the island's existence to be covered up by the Russian government.", 'youtube' => 'pNQqY7VznJM', 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7006], 'genres' => [8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 865, 'game_title' => 'Star Wars: Knights of the Old Republic', 'release_date' => '2003-11-19', 'platform' => 1, 'overview' => "The story of this game takes place 4,000 years before the rise of the Galactic Empire. \r\nDarth Malak, a Dark Lord of the Sith and Darth Revan's former apprentice, has unleashed a Sith armada against the Republic. \r\nMalak's aggression has left the Jedi scattered and vulnerable; many Jedi Knights have fallen in battle and others have sworn allegiance to Malak and Revan.", 'youtube' => 'xqUqrv6t4HM', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1086], 'genres' => [4], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 866, 'game_title' => 'Star Wars: Knights of the Old Republic II - The Sith Lords', 'release_date' => '2005-02-08', 'platform' => 1, 'overview' => "The game takes place five years after the events of Knights of the Old Republic, in a time when the Jedi have been nearly exterminated by the Sith. The player's character, a former Jedi Knight exiled from the Jedi Order, is referred to as \"the Exile\" or \"Jedi Exile.\" \r\nThroughout the game, the player's character (canonically a female) restores a connection to the Force while, with the help of non-player character companions, trying to stop the Sith. The player makes choices that turn the Exile to either the dark side or light side of the Force, and travels to six planets to either help or hinder the Republic's efforts to bring peace and stability to the galaxy.", 'youtube' => '2ff0ziipxLg', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6195], 'genres' => [1, 4], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 867, 'game_title' => 'Dragon Age: Origins', 'release_date' => '2009-11-03', 'platform' => 1, 'overview' => "Dragon Age: Origins is an epic story of magic, danger and a fight for survival told by a legendary games company. BioWare, creators of Mass Effect, Baldur's Gate and Star Wars: Knights Of The Old Republic, bring you their best adventure yet. As a Grey Warden, you protect the land of Ferelden from the Darkspawn. When the demons attack the land again, you must embark on an epic quest to save Ferelden. Create your hero with detailed customisation options, make real choices that affect your path and the future of Ferelden itself, and decide how to battle the forces against you. Dragon Age: Origins is a bigger, more beautiful and deeper adventure than any you'll have ever taken before.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1086], 'genres' => [1, 2, 4], 'publishers' => [2], 'alternates' => ['Dragon Age Origins', 'Dragon Age'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 868, 'game_title' => 'Velvet Assassin', 'release_date' => '2009-04-30', 'platform' => 15, 'overview' => "Violette Summer managed to carry out several missions successfully before being gravely wounded by a sniper on a mission to kill Kamm, a Nazi military intelligence officer. Comatose in a hospital in France, Violette relives key moments in a series of flashbacks. \r\nHence the bulk of gameplay will take place during these flashbacks. The missions include blowing up a fuel depot on the Maginot Line, assassination of a colonel in a cathedral in Paris, stealing documents and marking a sub pen for bombers in Hamburg during Operation Gomorrah, and finding three secret agents in Warsaw.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7153], 'genres' => [1, 8], 'publishers' => [67], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 869, 'game_title' => 'Breath of Fire', 'release_date' => '1994-08-01', 'platform' => 6, 'overview' => "NOW YOU'RE PLAYING WITH FIRE!\r\nIn a distant land, peace was maintained for thousands of years by a fearful dragon clan who could transform into powerful monsters. One day they discovered a goddess who could fulfill their every wish. Greed split the clan into Dark and Light Dragons, each battling the other to win her magic.\r\n\r\nOne member of the Light Dragons, along with seven of his companions, emerged to keep the opposing forces from destroying their world. Using six magical keys, they sealed the goddess into another realm.\r\n\r\nCenturies have passed. The Dark Dragons are destroying the land in search of the keys. When they find the keys, they will once again release the magic goddess. Light Dragon... the time has come to draw your sword and fight for the future of your people.", 'youtube' => 'jg9agVIPMhI', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [4], 'publishers' => [11], 'alternates' => ['Breath of Fire Ryuu no Senshi'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 870, 'game_title' => 'Breath of Fire II', 'release_date' => '1995-12-03', 'platform' => 6, 'overview' => "The incredible sequel to the best-selling RPG hit Breath of Fire is here! You are the last member of the Dragon clan, fighting to rid the world of a growing evil. A cast of unusual and exciting companions joins you in your adventures across a wondrous land full of magic and mystery. You'll find strange mystic items, memorable monsters and exotic locations in your quest to conquer evil. There's strategy and spellcasting galore in the hours of compelling action and adventure that awaits you. Breath of Fire II is the ultimate in RPG excitement!", 'youtube' => 'HehkHHMhh3s', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1436], 'genres' => [4], 'publishers' => [9], 'alternates' => ['Breath of Fire 2', 'Breath of Fire II Shimei no Ko', 'Breath of Fire 2 Shimei no Ko'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 871, 'game_title' => 'Trine', 'release_date' => '2009-07-02', 'platform' => 1, 'overview' => "Trine takes place in a forsaken and ruined kingdom. After enjoying a period of great peace, the king died without leaving an heir, plunging the kingdom into political instability. Taking advantage of the chaos, an undead army suddenly appeared and attacked, forcing the inhabitants to abandon the realm.\r\nAfter an unspecified amount of time, Trine begins with a thief searching for a legendary treasure in the Astral Academy, a derelict institution of magical studies. Unknown to her, a wizard remained at the academy to study the skies, while a knight arrived there to protect the academy. The three meet at the chamber of the ancient treasure and, touching the object at the same time, disappear.", 'youtube' => 'https://SgFxIopLANU&feature=player_embedded', 'players' => 3, 'coop' => 'Yes', 'rating' => 'E10+ - Everyone 10+', 'developers' => [3206], 'genres' => [4, 5, 15], 'publishers' => [175], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 872, 'game_title' => 'Fable III', 'release_date' => '2010-10-26', 'platform' => 15, 'overview' => "Set 50 years after the events of Fable II, the continent of Albion (where the Fable series is set) is under the control of Logan, a tyrant king and the Hero's older brother. The player's character, the \"Hero\", is forced into a quest to become a revolutionary leader to defeat Logan after he reveals his true personality to the Hero. Over the course of the first half of the game, the Hero will overthrow Logan and become ruler of Albion themselves. During the second half of the game, a strange force from Aurora, called The Darkness will threaten Albion and the player has to decide how to react to it.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4989], 'genres' => [4], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 873, 'game_title' => "Tom Clancy's Splinter Cell: Chaos Theory", 'release_date' => '2005-03-21', 'platform' => 1, 'overview' => 'The game follows the covert activities of Sam Fisher, an agent working for a black-ops branch within the NSA called "Third Echelon".', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9150], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 874, 'game_title' => 'Afro Samurai', 'release_date' => '2009-01-27', 'platform' => 15, 'overview' => "The quest for #1 comes to the Xbox 360! Afro Samurai is an action-adventure game featuring never before seen combat mechanics, stunning visuals, and an amazing cast of characters creating a brutally fresh entertainment experience. Afro Samurai utilizes a dynamic cross-hatching art style and cut-scene paneling that makes the game look like a comic come to life while its innovative combat system gives players the ability to dynamically cut enemies at any point in the body. Starring Samuel L. Jackson & featuring a hip-hop musical score produced by The RZA of Wu-Tang clan fame, Afro Samurai blends contemporary street and Japanese culture in the stylish world reated by Takashi Okazaki and animated by revered animation studio, Gonzo. Follow the epic tale of Afro Samurai as he seeks vengeance against Justice, who murdered his father. Nothing personal... It's just revenge.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [8371], 'genres' => [1], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 875, 'game_title' => 'Lego Indiana Jones: The Original Adventures', 'release_date' => '2011-05-13', 'platform' => 1, 'overview' => "The game allows players to recreate moments (albeit more humorously) from the first three Indiana Jones films: Indiana Jones and the Raiders of the Lost Ark, Indiana Jones and the Temple of Doom, and Indiana Jones and the Last Crusade.\r\n\r\nHowever, the developers modified the storylines to fit the events into 6 game chapters per movie. Barnett College, Dr. Indiana Jones' teaching location from Last Crusade (Marshall College in Raiders of the Lost Ark and Kingdom of the Crystal Skull), serves as the main hub of the game, and different maps on the walls allow access to each of the missions, extra unlockable content and options are found in the different classrooms. Once a player chooses a mission, a cutscene begins that introduces the section of the movie being played. Notable scenes have been recreated from the movies, such as the memorable boulder escape and the battle on the rope bridge, as well as Walter Donovan choosing the incorrect Holy Grail.", 'youtube' => 'Qix-A8GNPfA', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => nil, 'genres' => [1, 2], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 876, 'game_title' => 'Mortal Kombat vs. DC Universe', 'release_date' => '2008-11-16', 'platform' => 12, 'overview' => "Mortal Kombat vs. DC Universe is a crossover fighting video game between Mortal Kombat and the DC Comics fictional universe, developed by Midway Games and Warner Bros. Games. The game was released on November 16, 2008 and contains characters from both franchises. Its story was written by comic writers Jimmy Palmiotti and Justin Gray. The idea of the game was originally thought of in 2005, but North Korean hackers leaked the concept and subsequently lead to the idea being copied by Marvel to inspire Civil War. Despite being a crossover, the game is considered to be the eighth installment in the main Mortal Kombat series, as confirmed by the naming of the tenth entry by this count: Mortal Kombat X.\r\n\r\nThe game takes place after Raiden, Earthrealm's god of Thunder, and Superman, protector of Earth, repel invasions from both their worlds. An attack by both Raiden and Superman simultaneously in their separate universes causes the merging of the Mortal Kombat and DC villains, Shao Kahn and Darkseid, resulting in the creation of Dark Kahn, whose mere existence causes the two universes to begin merging; if allowed to continue, it would result in the destruction of both. Characters from both universes begin to fluctuate in power, becoming stronger or weaker.\r\n\r\nMortal Kombat vs. DC Universe was developed using Epic Games' Unreal Engine 3 and is available for the PlayStation 3 and Xbox 360 platforms. It is the first Mortal Kombat title developed solely for seventh generation video game consoles. Most reviewers agreed that Mortal Kombat vs. DC Universe was entertaining and made good use of its DC Universe license, but the game's lack of unlockable features as opposed to past installments of Mortal Kombat and toned-down finishing moves garnered some criticism", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5512], 'genres' => [10], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 877, 'game_title' => "James Cameron's Avatar: The Game", 'release_date' => '2009-12-01', 'platform' => 1, 'overview' => "The game will take you deep into the heart of Pandora, an alien planet that is beyond imagination. Gamers will encounter the Na'vi, Pandora's indigenous people and discover creatures and other wildlife the likes of which have never been seen in the world of video games before. When conflict erupts between the RDA Corporation, a space-faring consortium in search of valuable resources, and the Na'vi, players will find themselves thrust into a fight for the heart of a planet and the fate of a civilization.", 'youtube' => nil, 'players' => nil, 'coop' => nil, 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 878, 'game_title' => 'Soul of the Ultimate Nation', 'release_date' => '2009-10-21', 'platform' => 1, 'overview' => nil, 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 879, 'game_title' => 'Ether Saga Online', 'release_date' => '2009-03-17', 'platform' => 1, 'overview' => nil, 'youtube' => '8NldR5ULFSM', 'players' => nil, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 880, 'game_title' => 'Darksiders', 'release_date' => '2010-09-23', 'platform' => 1, 'overview' => 'Penned by legendary comic book artist Joe Madureira (X-Men, Battle Chasers, The Ultimates), Darksiders: Wrath of War is set in a Post-Apocalyptic demon-ravaged world where evil forces have prematurely brought about the end of the time. Originally sent to oversee the destruction of Earth, the Four Horsemen of the Apocalypse have been betrayed by their master, stripped of their powers and cast down to Earth. Players take on the role of WAR -- the first of the Four Horsemen -- as he embarks on a brutal quest of vengeance and revenge against the forces that betrayed him with the help of his phantom steed RUIN. Darksiders: Wrath of War features open-world exploration, a deep combat system and a huge arsenal of modern and mythical weapons.', 'youtube' => 'ArHzEGeiMbg', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9383], 'genres' => [1, 2], 'publishers' => [176], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 881, 'game_title' => 'Jade Dynasty', 'release_date' => '2009-06-15', 'platform' => 1, 'overview' => 'Jade Dynasty is a Fantasy Online Role-Playing game, developed and published by Perfect World Entertainment, which was released in 2009.', 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => nil, 'developers' => [6516], 'genres' => [1, 2, 4, 6, 14], 'publishers' => [177], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 882, 'game_title' => 'Myth II: Soulblighter', 'release_date' => '1998-11-30', 'platform' => 1, 'overview' => 'Take control of squads or individual units in order to accomplish tactically-challenging missions in the epic battle of the Forces of Light versus Dark.', 'youtube' => nil, 'players' => 1, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1389], 'genres' => [6], 'publishers' => [178], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 883, 'game_title' => 'Rappelz', 'release_date' => '2006-10-02', 'platform' => 1, 'overview' => nil, 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => nil, 'developers' => nil, 'genres' => nil, 'publishers' => nil, 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 884, 'game_title' => 'Supreme Commander 2', 'release_date' => '2010-03-02', 'platform' => 1, 'overview' => "The story starts with the newly-elected President's assassination, causing the break up of the coalition formed during the expansion of the first game.\r\n\r\nThe first campaign (dedicated to the UEF (United Earth Federation)) follows Dominic Maddox, a UEF officer who is married to an Illuminate. Maddox fights off Cybran until the UEF Commander he serves declared that all Illuminate are terrorists and orders him on a mission to \"round up\" the Illuminate from his home city. Maddox refuses, goes rogue, and decides to go on his own campaign to remove his old commanding officer from power. Immediately following the defeat of the UEF Commander, he discovers a portal that leads to Seraphim VII, unlocking the second campaign.\r\n\r\nThe second campaign (dedicated to the Illuminate) follows Commander Thalia Kael as she fights to restore the Illuminate to their former glory before realising her mistake and turning against her former comrades.\r\n\r\nThe Cybran campaign follows Ivan Brackman (an experimental genetic composite (clone) of Dr. Brackman and Elite Commander Dostya) who is an old roommate of Maddox, who fights under the direction of Dr. Brackman (who Ivan refers to as \"father\" while attempting to help his friends).\r\n\r\nThe final battle takes place on the surface of an ancient planetary terraformer called Shiva Prime. After the battle, Ivan comes to a realisation about Shiva Prime and despite protests from his father, destroys the terraformer.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [3410], 'genres' => [6], 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 885, 'game_title' => 'Allods Online', 'release_date' => '2010-02-10', 'platform' => 1, 'overview' => "Allods Online has many traditional MMORPG elements such as quests, NPCs, and dungeons. It also has an element that is fairly unique - the ability for players to build ships and sail around in a vast expanse of magical space called \"the Astral\". In the Astral, players can fight each other in ship-to-ship combat as well as discover new zones like the Goblin Republic that cannot be reached any other way. Furthermore, ships have individual crew stations which can be operated by multiple players on the same ship together.\r\n\r\nAnother way for players to test their skills is via PvP on maps such as the Holy Land. The Holy Land tends to be extremely crowded due to its position as one of the primary locations of the war between the two factions - the Empire and the League. Open PvP, utilizing a flagging system found in many traditional MMORPGs, is also available in any area of the game, and gives special bonuses to players who quest and hunt while their Flag of War is raised. There are also special areas where players can engage in large-scale PvP activities to earn unique rewards.\r\nThe game also provides a developed guild system that encourages players to work together to improve their guild ranking and allow them to participate in more content, such as the Astral Confrontation, as well as design custom regalia to look unique in the game and benefit special abilities.", 'youtube' => 'sJDueIirkP8', 'players' => 1, 'coop' => 'No', 'rating' => 'Not Rated', 'developers' => [740], 'genres' => [14], 'publishers' => [179], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 886, 'game_title' => 'Resonance of Fate', 'release_date' => '2010-03-16', 'platform' => 12, 'overview' => "Resonance of Fate uses what is known as the tri-Attack Battle system. The battle system is a mixture of real-time and turn-based controls. The game consists of battle elements such as command battles and action battles. Players start the battle by selecting one of the player's characters to control, following which the player takes direct control over the character. The player can then move the character around and attack targets. The character's turn ends when the player's attack is over or his action points are all used up. Enemies are also able to move while the player's character is moving and will usually attack only the character being controlled by the player. Players can restart any enemy encounter if they are defeated during battle, and for a hefty fee can replenish health or even an important resource called bezel energy. Players are also able to suspend and save the game at any time", 'youtube' => 'HiwWcU47N9E', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9029], 'genres' => [4], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 887, 'game_title' => 'Star Trek Online', 'release_date' => '2010-02-20', 'platform' => 1, 'overview' => 'Star Trek Online, often abbreviated as STO, is a massively multiplayer online role-playing game (MMORPG) developed by Cryptic Studios based on the popular Star Trek series created by Gene Roddenberry. The game is set in the 25th century, 30 years after the events of Star Trek Nemesis.[4] Star Trek Online is the first massively multiplayer online role-playing game within the Star Trek franchise and was released on February 2, 2010', 'youtube' => 'gqed10FOmL4', 'players' => 4, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [1959], 'genres' => [14], 'publishers' => [177], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 888, 'game_title' => 'Star Wars Battlefront: Elite Squadron', 'release_date' => '2009-11-03', 'platform' => 13, 'overview' => "Star Wars Battlefront: Elite Squadron is a third-person shooter video game, part of the Star Wars: Battlefront series released November 3, 2009 on the Nintendo DS and PlayStation Portable.\r\n\r\nGameplay[edit]\r\nElite Squadron allows players to participate in combat on foot, in ground vehicles or in space. Players are also able to enter capital ships and, once the shields are down, fight the enemy inside on foot. The ground-space transitions are accompanied by short cutscenes while the game loads the next area.[2] The same is also true of entering or exiting a capital ship.[3] This is the first Battlefront game to allow players to fly from ground to space battles.[4] The consequences of each battle will depend on the players actions, meaning that each individual enemy killed can affect the outcome of a result.[2] The battlefront will not be one giant, seamless map, but a compilation of inter-connected, smaller size areas, each one capable of affecting the other.[3]\r\n\r\n\r\nElite Squadron features \"Heroes and Villains\" gameplay.\r\nIt includes playable characters such as Luke Skywalker, Boba Fett, Darth Vader, Darth Maul, The Emperor and Kit Fisto, and the Heroes and Villains mode (Assault Mode) last featured in Star Wars: Battlefront II.[1] Pre-release screenshots also show that General Rahm Kota, a character from Star Wars: The Force Unleashed is playable, as well as other characters from Renegade Squadron, such as Col Serra. The Heroes and Villains mode is displayed quite conveniently after a demo had been released on the PlayStation Network. Other game modes have been implied, with a focus on multiplayer, such as a deathmatch mode. Also, the Galactic Conquest mode, has undergone an enhancement on the PSP. In Galactic Conquest, two players are able to share a single PSP, and compete against each other in a strategy based game mode.[2][5] PSP Players are able to mix elements from the Star Wars saga and put them into locations and situations that never happened, allowing for full customization.[6] The story mode has been called \"a huge step up from previous story modes\",[7] and was praised for incorporating the controls into the mission. It was also revealed that making progress in the story, and completing objectives, was the way to unlock customization props.[7]", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5068], 'genres' => [1, 10], 'publishers' => [180], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 889, 'game_title' => 'Rayman Raving Rabbids 2', 'release_date' => '2007-11-13', 'platform' => 9, 'overview' => "The gameplay is similar to the original, using the Wii remote for all kinds of methods, such as flinging the remote upward for the Chili mini-game or holding the remote still to keep simulate balancing certain items such as the Burger Balance game. There are also musical mini-games that require you to time your movements with the remote and Nunchuk to keep with the beat of the music. Another is a driving game that requires you to move the remote left or right to simulate steering among others.\r\n\r\nThere are sixty mini-games, including being able to play in co-op or play head-to-head against a friend. There are five different regions to play in including USA, Europe and Asia and there are 110 different items to customize Rayman and the Rabbids with over 540,000 different combinations.", 'youtube' => 'W6EQiPzedxI', 'players' => nil, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [9150], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 890, 'game_title' => 'Rayman Raving Rabbids: TV Party', 'release_date' => '2008-11-18', 'platform' => 9, 'overview' => "Very much in the same vein as the previous two Rabbids games, Rayman Raving Rabbids TV Party is a collection of party minigames, distinguished by its television theme, 2D artwork, and its compatability with Wii Balance Boards for certain minigames. Multiplayer gameplay consists of a series of randomly selected minigames resembling television shows or movies, each of which can be optionally interrupted by a WarioWare-style advertisement microgame. Single player gameplay has the player unlock new minigames by winning at the available ones.\r\n\r\nMinigames in TV Party include the \"Monster Tractors\" racing game; several lightgun shoot-'em-ups like \"Night of the Zombids\", \"Star Worse\", and \"Rabzilla\"; the burger-cooking- and walrus-feeding-sim \"Flippin' Burgers\"; the coin-collecting platformer \"Mega Balls\"; and a few Guitar Hero-like rhythm games, among others.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [9150], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 891, 'game_title' => 'Prince of Persia: The Forgotten Sands', 'release_date' => '2010-06-08', 'platform' => 1, 'overview' => "Prince of Persia: The Forgotten Sands is the next chapter in the fan-favorite Sands of Time universe. Visiting his brother's kingdom following his adventure in Azad, the Prince finds the royal palace under siege from a mighty army bent on its destruction. When the decision is made to use the ancient power of the Sand in a desperate gamble to save the kingdom from total annihilation, the Prince will embark on an epic adventure in which he will learn to bear the mantle of true leadership, and discover that great power often comes with a great cost.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [1], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 892, 'game_title' => 'Dead to Rights: Retribution', 'release_date' => '2010-04-27', 'platform' => 15, 'overview' => "Dead to Rights: Retribution is a 2010 third-person action video game. It is the reboot of the Dead to Rights franchise featuring Grant City police officer Jack Slate and his canine companion Shadow. Developed by Volatile Games and published by Bandai Namco Games for the Xbox 360 and PlayStation 3, the game was released on April 2010. This marks the series' first outing onto consoles in almost four years.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9486], 'genres' => [1, 8], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 893, 'game_title' => 'Just Cause 2', 'release_date' => '2010-03-23', 'platform' => 1, 'overview' => "Rico returns to action in the sequel to Avalanche Studios' gargantuan action game. Just Cause 2 stars Rico Rodriquez, back to wreak havoc once again, this time with a new destination -- the huge playground of the South East Asian islands of Panau. The sequel features more stunts, vehicles and weapons than ever before and an incredible overhauled grappling hook system. Panau itself is an incredibly detailed and vast 1000 sq km game world of different climates and ultra-realistic weather effects. Leap from your plane and skydive from 10,000 feet down into a tropical jungle, tear across an arid desert in a dune buggy or climb your way up a snowy mountain in a 4x4. The vast open-ended, unique gameplay is back, allowing you full freedom once again to free roam and explore the massive world of Panau and tackle your assignments however you want.", 'youtube' => '8BOtdFUDdFI', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [824, 2685], 'genres' => [1, 12], 'publishers' => [12], 'alternates' => ['Just Cause 2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 894, 'game_title' => 'Lost Planet 2', 'release_date' => '2010-10-12', 'platform' => 1, 'overview' => "A decade has passed since the events of Lost Planet, and the face of E.D.N. III has changed dramatically. Terraforming efforts have been successful and the ice has begun to melt, giving way to lush tropical jungles and harsh unforgiving deserts. Players will enter this new environment and follow the exploits of their own customized snow pirate on their quest to seize control of the changing planet. \r\n\r\nPlayers control their heroes across 6 interconnected episodes, creating a truly unique interactive experience that changes depending upon the actions of the players involved. With this concept, players will have the opportunity to engage in the story in a much more dynamic way as plot threads evolve from different players' perspectives. Beyond the deep single player mode, Lost Planet 2 is loaded with extensive multiplayer modes. The intense and action packed campaign mode comes with the ability to form teams of up to 4 players online to clear mission objectives with friends.", 'youtube' => 'ibuPJpgYAik', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1436], 'genres' => [1], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 895, 'game_title' => 'Rage', 'release_date' => '2011-10-03', 'platform' => 1, 'overview' => "Rage is a groundbreaking first-person shooter set in the not-too-distant future after an asteroid impacts Earth, leaving a ravaged world behind. You emerge into this vast wasteland to discover humanity working to rebuild itself against such forces as raider gangs, mutants, and the Authority -- an oppressive government regime that has a special interest in you in particular.\r\n\r\nFeaturing intense first-person action, vehicle combat, an expansive world and jaw-dropping graphics powered by id's revolutionary idTech 5 technology, Rage continues the legacy of design studio Id Software in delivering an experience like no other.", 'youtube' => 'OVX9V_Uf30Q?hd=1', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3993], 'genres' => [8], 'publishers' => [34], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 896, 'game_title' => 'Brink', 'release_date' => '2011-05-10', 'platform' => 1, 'overview' => 'Brink is an immersive first-person shooter that blends single-player, co-op, and multiplayer gameplay into one seamless experience, allowing you to develop your character whether playing alone, with your friends, or against others online. You decide the combat role you want to assume in the world of Brink as you fight to save yourself and mankind’s last refuge. Brink offers a compelling mix of dynamic battlefields, extensive customization options, and an innovative control system that will keep you coming back for more.', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [8079], 'genres' => [8], 'publishers' => [34], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 897, 'game_title' => 'Venetica', 'release_date' => '2011-01-11', 'platform' => 1, 'overview' => "In the era of Venetica, Death walks among the living as a flesh & blood being, carrying out the deeds of an ancient council known by a few as Corpus. Each generation of the Corpus is set with the task of selecting the next predecessor of the bringer of death. Unfortunately, the most recent council had unwittingly selected a crafty necromancer who is determined on bringing death and destruction to the world.\r\n\r\nThis conniving imposter has managed to transform into an undead fiend, which no mortal man can kill. This power-crazed necromancer is hell-bent on destroying the reinstated Death and the council of Corpus. Only one person stands in his way, Scarlett, the daughter of Death.\r\n\r\nUp to now she has known nothing of her origins, her powers and the capabilities that she possesses – now she is challenged to learn how to develop and use her powers to save her father and curse the necromancer and his henchmen to the eternal hereafter.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2198], 'genres' => [1], 'publishers' => [182], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 898, 'game_title' => 'The Lord of the Rings Online: Shadows of Angmar', 'release_date' => '2007-04-24', 'platform' => 1, 'overview' => "Much of the gameplay is typical of the MMO format: The player controls a character avatar which can be moved around the game world and interacts with other players, non-player (computer-controlled) characters (or \"NPCs\") and other entities in the virtual world. Camera angles can be switched between first-person and third-person options. Characters are improved by gaining levels. A character's level increases after it earns a set amount of experience points through the player versus environment (or \"PvE\") combat and storyline adventures. Characters' abilities are improved by increasing in level, but character skills must be purchased from specified NPCs after gaining a new level.\r\nThe main storyline (also known as the \"Epic Quest Line\") is presented as a series of \"Books\", which consist of series of quests called \"Chapters\". There were initially eight Books when the game was released, with new books added with each free content update.\r\nTolkien's Middle-earth as represented in The Lord of the Rings Online implements magic in a different manner than other MMORPGs such as World of Warcraft. There are only five \"wizards\" in the fictional world, none of which are player-controlled. Instead, there are active skills which require \"power\" (the equivalent of magic points). Some skills behave like magic (like healing or throwing a burning ember at an enemy), but are based on \"lore\". In addition, objects and artifacts are used to create effects similar to magic.\r\nOther features include a fast travel system and a detailed quest log with tracker and history.", 'youtube' => '', 'players' => 4, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [9099], 'genres' => [4], 'publishers' => [183], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 899, 'game_title' => 'S.T.A.L.K.E.R. Call of Pripyat', 'release_date' => '2010-02-02', 'platform' => 1, 'overview' => 'The game takes place soon after the events of S.T.A.L.K.E.R.: Shadow of Chernobyl. After Strelok disables the Brain Scorcher, many Stalkers rush to the center of the Zone, hoping to find artifacts and treasure. The military decides this is the perfect time to take control of the Zone, and launch "Operation Fairway," a large scale helicopter recon mission intended to scout the area by air. Unfortunately, the mission goes horribly wrong, and all five STINGRAY helicopters crash. The player, former stalker Alexander Degtyarev, is sent into the Zone to investigate the crash sites.', 'youtube' => 'vcNylGYq-v4', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3645], 'genres' => [1, 8], 'publishers' => [184], 'alternates' => ['S.T.A.L.K.E.R.: Зов Припяти (RU)'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 900, 'game_title' => 'Transformers: War for Cybertron', 'release_date' => '2010-06-22', 'platform' => 1, 'overview' => "Transformers: War for Cybertron challenges players to become the ultimate weapon as a Transformers character in the final, epic war that will determine the survival of their entire race. Armed with a diverse arsenal of lethal, high-tech weaponry and the ability to instantly convert from robot to vehicle at any time, players will engage in heart-pounding battles on land and in the air in this gripping, 3rd person action shooter set in the Transformers' war-ravaged homeland.\r\n\r\nComplete with several multiplayer modes, Transformers: War for Cybertron allows gamers to play through story missions with their friends in drop in/drop out online co-op, and also create their own Transformers character for competitive head-to-head multiplayer modes, choosing among four distinct character classes, personalizing its look and selecting from a huge variety of weapons, skills and abilities.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [3832], 'genres' => [1], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 901, 'game_title' => 'CABAL Online', 'release_date' => '2008-02-21', 'platform' => 1, 'overview' => "Cabal Online (Korean: 카발 온라인, stylized as CABAL Online) is a free-to-play, 3D massively multiplayer online role-playing game developed by South Korean company ESTsoft. Different localizations of the game exist for various countries and regions. Although free-to-play, the game makes use of the freemium business model by implementing an \"Item Shop\", both in-game and via web, allowing players to purchase special premium coins using real currency, in order to acquire exclusive game enhancements and features, useful items and assorted vanity content.\r\n \r\nCabal Online takes place in a fictional world known as Nevareth, nearly a thousand years after its devastation by a powerful group of idealistic men, the CABAL. Hoping to turn their world into a utopia, they inadvertently fueled the forces and laws of nature to rebel against them, causing the event known as the Apocalypse. After the destruction, only eight members of the CABAL survived, including their leader, Faust.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2878], 'genres' => nil, 'publishers' => [185], 'alternates' => ['CABAL Online PH'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 902, 'game_title' => "Sid Meier's Civilization V", 'release_date' => '2010-09-21', 'platform' => 1, 'overview' => "In Civilization V, the player leads a civilization from prehistoric times into the future on a procedurally-generated map, achieving one of a number of different victory conditions through research, diplomacy, expansion, economic development, government and military conquest. The game is based on an entirely new game engine with hexagonal tiles instead of the square tiles of earlier games in the series. Many elements from Civilization IV and its expansion packs have been removed or changed, such as religion and espionage. The combat system has been overhauled, removing stacking of military units and enabling cities to defend themselves by firing directly on nearby enemies. In addition, the maps contain computer-controlled city-states as non-player characters that are available for trade, diplomacy and conquest. A civilization's borders also expand one tile at a time, favoring more productive tiles, and roads now have a maintenance cost, making them much less common.", 'youtube' => 'l-y99pkS_Vs', 'players' => 4, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [3041], 'genres' => [6], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 903, 'game_title' => 'Crysis 2', 'release_date' => '2011-03-22', 'platform' => 1, 'overview' => "The world has been ravaged by a series of climatic disasters and society is on the verge of total breakdown. Now the aliens have returned, with a full invasion force bent on nothing less than the total annihilation of mankind, starting by trying to rip the heart out of Earth's most iconic city.\r\nIn New York, terrifying alien invaders stalk the streets and a nightmare plague strikes down the city's myriad inhabitants with brutal epidemic speed. The city's systems are in chaos, its streets and skyline are smashed and in flaming ruin. This is New York City like you've never seen it before. Neither paramilitary law enforcement nor the might of the US military machine can stand against the invaders, and all who choose not to flee are dead men walking. Just to survive in this maelstrom of death will require technology beyond anything any modern soldier has ever seen.\r\nYet one man will inherit that means to survive. One supersoldier, wielding the combat enhancement technology of the future with Nanosuit 2, will make the last stand to save humanity from destruction in the urban jungle that is New York City.", 'youtube' => 'Xa1NvpiwqQk', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1971], 'genres' => [1, 8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 904, 'game_title' => 'Indiana Jones and the Staff of Kings', 'release_date' => '2009-06-12', 'platform' => 11, 'overview' => "The plot centers around Indy's search for the Staff of Moses. The game is mostly about a quest which takes you around the world on various quests, fighting Nazis, Panamanian hunters, and Tong thugs, and trying to find artifacts which will unlock other possible things for you to get and do. Although the staff of Moses is never mentioned in the beginning of the game, the plot is set about finding the staff, but the actual part of the story where the quest about finding the staff of Moses first start taking place is a lot further on in the game.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [163], 'genres' => [1], 'publishers' => [25], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLUS-21885', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 905, 'game_title' => 'Marvel: Ultimate Alliance', 'release_date' => '2006-10-24', 'platform' => 1, 'overview' => 'Players can select teams of four from a range of more than twenty-two playable characters (although some characters are not initially available and need to be unlocked), allowing them to create their own superhero teams or recreate famous teams from the publications. Bonuses are also available if forming certain groups (e.g. the Avengers, Defenders, Fantastic Four, Marvel Knights, X-Men). The game also has alternative endings, dictated by the number of optional missions the player completes. Also included are trivia, artwork, and "simulator discs", which unlock non-story related missions for characters. Each character also has a variety of costumes that offer different advantages.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7006], 'genres' => [1, 4], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 907, 'game_title' => "Tom Clancy's Ghost Recon: Future Soldier", 'release_date' => '2012-05-22', 'platform' => 15, 'overview' => "Developed by the award-winning team behind Tom Clancy's Ghost Recon Advanced Warfighter and Tom Clancy's Ghost Recon Advanced Warfighter 2, the game will feature cutting-edge technology, prototype high-tech weaponry, and state-of-the-art single-player and multiplayer modes. Tom Clancy's Ghost Recon: Future Soldier will go beyond the core Ghost Recon franchise and deliver a fresh gameplay experience, with an unparalleled level of quality that will excite long-time fans and newcomers alike.", 'youtube' => nil, 'players' => 1, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [9150], 'genres' => [8], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 908, 'game_title' => 'Super Mario Galaxy 2', 'release_date' => '2010-05-23', 'platform' => 9, 'overview' => "Prepare for liftoff with Mario and Yoshi!\r\n\r\nIn 2007, Super Mario Galaxy took the world of video games by storm. Now this first true Mario sequel in years re-energizes the franchise with new levels and new power-ups. Plus this time Mario gets to team up with his dinosaur buddy Yoshi, who adds new possibilities to the gravity-defying game play. It's everything you love about the first game and more.\r\n\r\n* Mario collects stars as he travels from galaxy to galaxy. Every level is new, but the game retains the charm, sense of wonder and beauty in line with Mario's history. Mario works his way through the various levels, sometimes upside-down, sometimes floating from place to place.\r\n\r\n* On some stages, Mario can find an egg, smash it open and hop onto the back of Yoshi. Yoshi can use his tongue to grab items and shoot them back at enemies, or to snag attach points and swing across chasms.\r\n\r\n* Yoshi has an interesting diet. When he eats a Dash Pepper, he gets so hot and frenzied he can run up steep inclines and vertical walls. When he eats a Blimp Fruit, he inflates like a balloon and floats to new heights.\r\n\r\n* New power-ups include a drill that Mario uses to tunnel through the planet's surface all the way to the other side of a planet.\r\n\r\n* Skilled players will want to collect new Comet Metals, which will unlock harder levels with even more challenges.", 'youtube' => 'tqw4LP2nL64', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [6045], 'genres' => [1, 2, 15], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 909, 'game_title' => 'Bulletstorm', 'release_date' => '2011-02-22', 'platform' => 1, 'overview' => "Bulletstorm takes place in the 26th century, where the Confederation of Planets are protected by a secret black-ops army called Dead Echo, commanded by General Sarrano. One Dead Echo team, led by Grayson Hunt (Steven Blum), having been following Sarrano's orders in assassinating what they believe are drug traffickers and mass murderers, kill a man known as Bryce Novak, but soon discover he was a civilian reporter, having documented other civilian deaths caused by Dead Echo. Grayson and his team realize they have been duped by Sarrano and go AWOL, becoming space pirates on the run from Sarrano's forces, now going by the name Final Echo.\r\n\r\nTen years later, Grayson's team tries to flee from Sarrano's battlecruiser, the Ulysses, while near the planet of Stygia. With their ship's systems failing, Grayson, in a drunken stupor, orders the crew to ram at the Ulysses, hoping to gain revenge on Sarraro. The ships collide, forcing both down and causing them to crash land on the surface of Stygia. One of Grayson's men, Ishi Sato (Andrew Kishino), is critically wounded in the crash and Grayson is forced to find an energy cell to drive the ship's medical equipment. On the planet, a former popular tropical-like resort destination, the population has mutated into feral tribes and carnivorous plants. Grayson fights through to one of the Ulysses escape pods, where a Final Echo soldier succumbs to a horde of mutants. After dispatching the attackers, Grayson retrieves the escape pod's energy cell, as well as an \"instinct leash\" that, when worn, begins to provide him strange tactile information, such as points for each enemy he kills.\r\n\r\nGrayson returns with the cell, and while Ishi is under operation, the mutants attack their ship. The operation is cut short by an explosion during battle, leaving Ishi a disfigured cyborg. Grayson and Ishi, the only survivors, decide to work together to get off the planet, despite Ishi's disapproval of Grayson's thirst for revenge. The instinct leash leads Grayson to another escape pod, where they find Trishka (Jennifer Hale), another Final Echo soldier who agrees to work with Grayson and Ishi, but only after they rescue Sarrano. As they battle through the ravaged city, Trishka explains that Stygia has been used by Final Echo as a sort of training grounds, with the instinct leashes the soldiers wear as a means of ranking those within the test; those that scored kills would be the only ones that could get ammunition and other supplies to survive. When Grayson learns that Trishka was Novak's daughter, he tells her that Sarrano was responsible for her father's death, but claims he does not know who actually killed him.\r\n\r\nThe three make their way to the top of a skyscraper where Sarrano's pod landed. Trishka accuses Sarrano of her father's death, but he simply kicks her off the side of the building. Sarrano then warns Grayson and Ishi that there is an armed DNA bomb on the Ulysses that will wipe out all life on the planet, and that they must go and disarm it, as his rescue ship will not arrive in time. Sarrano leads them through the underground areas of the city, encountering radioactive waste and a giant prison. Sarrano snidely explains that that shields used to protect the planet's surface from its deadly electrical storms created the waste, and in turn, began to mutate the population of the surface; the changes occurred too quickly for most of the surface population to be rescued, and thus many of the feral mutants that Grayson has been fighting were more innocent civilians. Grayson is furious at this revelation, but continues to help Sarrano to reach the remains the Ulysses. Aboard, Sarrano tricks Grayson and Ishi once again, having them actually arm the DNA bomb, while his rescue ship will arrive in time to save him. As fire breaks out aboard the fallen ship, the two are saved by Trishka, who survived the fall by catching a power line on her way down.\r\n\r\nThe three race to where Sarrano's rescue ship is landing and manage to get on board. They make their way through Sarrano's elite troops and eventually face Sarrano alone. Trishka demands to know who actually killed her father, to which Sarrano indicts Grayson. In the confusion, Sarrano hijack's Ishi's computer systems, forcing him to turn on his friends. Grayson manages to break Sarrano's control of Ishi, and Ishi sacrifices himself to prevent Sarrano from killing Grayson. Grayson then impales Sarrano on the wall of a ship. As Grayson and Trishka regroup, Sarrano performs one final act, ejecting Grayson, Trishka and several of his men from the ship back onto the planet. With the DNA bomb soon to detonate, Grayson and Trishka race back to the Ulysses where one escape pod remains unlaunched; they are able to board it and escape into low orbit, out of range of the DNA bomb when it goes off.\r\n\r\nIn the credits, it is revealed that Sarrano was revived, but now a cyborg like Ishi, and Ishi has also been revived now under Sarrano's control.", 'youtube' => 'gVkvS9vcCHI', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [6512], 'genres' => [8], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 910, 'game_title' => 'Alan Wake', 'release_date' => '2010-05-18', 'platform' => 15, 'overview' => "When the wife of best-selling writer Alan Wake disappears on their vacation, his search turns up pages from a thriller he doesn't even remember writing. A dark presence stalks the small town of Bright Falls, pushing Wake to the brink of sanity in his fight to unravel the mystery and save the woman he loves.", 'youtube' => 'auw3_z9EyRg', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7138], 'genres' => [2, 18], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 911, 'game_title' => 'Star Wars: The Force Unleashed II', 'release_date' => '2010-10-26', 'platform' => 1, 'overview' => 'In Star Wars The Force Unleashed, the world was introduced to Darth Vader’s now fugitive apprentice, Starkiller...the unlikely hero who would ignite the flames of rebellion in a galaxy so desperately in need of a champion. In the sequel, Starkiller returns with over-the-top Force powers and embarks on a journey to discover his own identity and to reunite with his one true love, Juno Eclipse. Starkiller is once again the pawn of Darth Vader, but instead of training his protégé as a ruthless assassin, the dark lord is attempting to clone his former apprentice in an attempt to create the Ultimate Sith warrior. The chase is on. Starkiller is in pursuit of Juno and Darth Vader is hunting for Starkiller.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [725], 'genres' => [1], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 912, 'game_title' => 'Diablo III', 'release_date' => '2012-05-15', 'platform' => 1, 'overview' => "The game takes place in Sanctuary, the dark fantasy world of the Diablo series. This world was saved twenty years prior by a handful of unnamed heroes in Diablo II, having survived the onslaught brought by the armies of the Burning Hells, who have gone mad from their ordeals. It is up to a new generation of heroes to face the forces of evil threatening the world of Sanctuary.\r\n\r\nPlayers will have the opportunity to explore familiar settings such as Tristram.\r\n\r\nThe only confirmed NPCs are Deckard Cain, who has appeared in both of the previous games, and his niece, Leah, a new character who accompanies the hero in quests from time to time. The plot will revolve around two surviving Lesser Evils, Azmodan and Belial, and an artifact known as the Black Soulstone. Diablo's world map is composed primarily of two main continents with several small islands in the Northwest region. The world of Sanctuary has been dramatically changed by the destruction of the World Stone in Diablo II: Lord of Destruction.", 'youtube' => 'D-85YBegae4', 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [1203], 'genres' => [1, 2, 4], 'publishers' => [186], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 913, 'game_title' => 'Killzone 3', 'release_date' => '2011-02-22', 'platform' => 12, 'overview' => 'Killzone 3 is a 2011 first-person shooter video game for the PlayStation 3, developed by Guerrilla Games and published by Sony Computer Entertainment. It is the fourth installment in the Killzone series, the first game in the series to be presented in stereoscopic 3D, and the first to include motion controls using the PlayStation Move. It was released worldwide in February 2011.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3657], 'genres' => [8], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 914, 'game_title' => 'Portal 2', 'release_date' => '2011-04-19', 'platform' => 1, 'overview' => "Portal 2 draws from the award-winning formula of innovative gameplay, story, and music that earned the original Portal over 70 industry accolades and created a cult following.\r\n\r\nThe single-player portion of Portal 2 introduces a cast of dynamic new characters, a host of fresh puzzle elements, and a much larger set of devious test chambers. Players will explore never-before-seen areas of the Aperture Science Labs and be reunited with GLaDOS, the occasionally murderous computer companion who guided them through the original game.\r\n\r\nThe game’s two-player cooperative mode features its own entirely separate campaign with a unique story, test chambers, and two new player characters. This new mode forces players to reconsider everything they thought they knew about portals. Success will require them to not just act cooperatively, but to think cooperatively.", 'youtube' => 'uxSo1k2Y1Uk?hd=1', 'players' => 2, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [9289], 'genres' => [5, 8], 'publishers' => [13], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 915, 'game_title' => 'Star Ocean: The Last Hope', 'release_date' => '2009-02-23', 'platform' => 15, 'overview' => "Star Ocean: The Last Hope, known as Star Ocean 4: The Last Hope (スターオーシャン4 THE LAST HOPE Sutā Ōshan Fō Za Lasuto Hōpe?) in Japan, is an action role-playing video game developed by tri-Ace and Square Enix who also published the game, initially only for the Xbox 360, and the fourth installment in the Star Ocean series. Famitsu revealed that the battle system featured four party members, and was more team-oriented. The game also features more of a sci-fi emphasis than past titles with the ability to control your own ship. This ship is quite large, and is able to land on at least 5 planets or other space-based destinations. Players are able to travel through the \"star ocean,\" jumping across planets. The game takes place a few centuries before the original Star Ocean (around S.D. 10, or approximately 2087 AD). The game's plot revolves around Edge and his crew combating a mysterious threat called the \"Grigori\".\r\n\r\nAn international version of the game was released by Square Enix as a worldwide PlayStation 3-exclusive on February 9, 2010. Officially known as Star Ocean: The Last Hope International, the game contains both Japanese and English voices as well as new content that is exclusive to the international version of the game.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9029, 10_315], 'genres' => [1, 4], 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 916, 'game_title' => 'Deus Ex: Human Revolution', 'release_date' => '2011-08-23', 'platform' => 1, 'overview' => "You play Adam Jensen, an ex-SWAT specialist who's been handpicked to oversee the defensive needs of one of America's most experimental biotechnology firms. Your job is to safeguard company secrets, but when a black ops team breaks in and kills the very scientists you were hired to protect, everything you thought you knew about your job changes\r\n\r\nBadly wounded during the attack, you have no choice but to become mechanically augmented and you soon find yourself chasing down leads all over the world, never knowing who you can trust. At a time when scientific advancements are turning athletes, soldiers and spies into super enhanced beings, someone is working very hard to ensure mankind's evolution follows a particular path.\r\n\r\nYou need to discover where that path lies. Because when all is said and done, the decisions you take, and the choices you make, will be the only things that can change it.", 'youtube' => 'vK4k_Ieh8Wg', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [2687], 'genres' => [1, 8, 16], 'publishers' => [12], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 917, 'game_title' => 'From Dust', 'release_date' => '2011-08-17', 'platform' => 1, 'overview' => 'From Dust is the latest original game concept by Eric Chahi, creator of the cult classic, “Another World / Out of this World”. Immerse yourself in a world as exotically beautiful as it is dangerous! You control the destiny of a primitive tribe against the backdrop of a world in constant evolution—a universe where mighty Nature reclaims what is hers; and your mastery of the elements is your people’s only chance of survival...', 'youtube' => 'FT-m-JAs_RU', 'players' => 1, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [9157], 'genres' => [2, 3, 9], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 918, 'game_title' => 'Total War: Shogun 2', 'release_date' => '2011-03-15', 'platform' => 1, 'overview' => 'Shogun 2 is the ultimate refinement of the original formula with a new, cutting-edge AI, more polish and online functionality than ever before. The result is the perfect mix of real-time and turn-based strategy gaming that invites both veterans of Total War and new players to experience the enjoyment and depth of the series.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1891], 'genres' => [6], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 919, 'game_title' => 'Gray Matter', 'release_date' => '2011-02-22', 'platform' => 1, 'overview' => "The opening scene of the game depicts Sam riding her motorcycle in the rain in the countryside. Her bike breaks down, forcing her to take shelter in Dread Hill, a nearby mansion where David resides. She poses as an Oxford student responding to Styles' request for a research assistant.\r\n\r\nEventually, Sam is ordered to recruit six students as test subjects for David's research. Through clever manipulation and magic tricks, Sam manages to find four students willing to volunteer for the experiment. The professor recalls her to Dread Hill, letting her know that he found a fifth candidate and making Sam herself the sixth.\r\n\r\nAs the game progresses, Sam learns about the professor's past, his research on the paranormal, the prestigious members-only Daedalus magic club, a series of bizarre events that take place at Oxford University, and how these elements are connected.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9665], 'genres' => [2], 'publishers' => [182], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 920, 'game_title' => 'Headhunter: Redemption', 'release_date' => '2004-09-21', 'platform' => 11, 'overview' => "In the 21st century, a dreadful virus wiped out millions. The vaccine was found, but at the time the world was engulfed into chaos. A new world order emerged, splitting the world into two distinct yet dependent worlds: Above and Below.\r\n\r\nThe world Above reflects a chrome city, a high-rise, high-tech metropolis served by elevators and elevated freeways. A place for hardworkers and law-abiding people. On the contrary to Above, the world Below, which is the product of earthquake damages, is a subterranean network of labour colonies. Those who are not wanted Above for one reason or another are sent Below.\r\n\r\nOne day, now veteran Headhunter, Jack Wade, took a call to investigate an intrusion to the upper levels. Facing the trespasser, Jack saw a potential in the girl and instead of turning her in, he gave her a second chance... to become his apprentice. Jack is back, but this time, he's not alone but accompanied by his sidekick Leeza X. Together, they will face whatever threat lurks from the world Below.\r\n\r\nThe gameplay is set in 3rd-person view with ability to rotate camera or set it behind your back at the single click. Headhunter's main accessory is IRIS (Intelligent Realtime Information Scanner). Once you get the IRIS, you'll be able to scan every item just by pointing the gun at it, or use the scanner in 1st-person view which will let you examine the surroundings in more detail. Also, IRIS will provide you with a full 3D map info even displaying the enemies so you can avoid them or use stealth if necessary. Enemies will hear you running and shooting, so if you decide to take an action, be aware that they will surround you and launch a team strike at you from all the sides. You only effective aid against them, beside your weapon, of course, is the ability to perform a roll or lean against the walls and fire from the corners, although aiming itself may not be easy as your hand will not be steady while on the move or panicking.", 'youtube' => 'HB8HD5peoNs', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [453], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => [{ 'uid' => 'SLUS-20817', 'games_uids_patterns_id' => 2 }], 'hashes' => nil },
    { 'id' => 921, 'game_title' => 'Sonic and the Black Knight', 'release_date' => '2009-03-03', 'platform' => 9, 'overview' => "A wizard named Merlina, granddaughter of the original Merlin, summons Sonic to help free the mystical realm of King Arthur, who has been possessed by an unknown evil that comes from Excalibur's scabbard, and is now ruling the realm as the tyrannical Black Knight. \r\nSonic's speed alone will not end The Black Knight's reign, so he must take up the talking sword, Caliburn, in order to break Arthur's curse and save the kingdom. \r\nSonic must also collect the blades of King Arthur's Knights of the Round Table and Excalibur itself if he is to restore King Arthur's sanity and return him to a benevolent ruler.", 'youtube' => 'https://www.youtube.com/watch?v=tgRgUpYE9nY', 'players' => 4, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [7979], 'genres' => [1, 2], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 922, 'game_title' => 'LEGO Star Wars III: The Clone Wars', 'release_date' => '2011-03-22', 'platform' => 1, 'overview' => 'Lego Star Wars III: The Clone Wars is similar to the previous titles in the series. Up to two players switch between different characters in order to fight enemies, solve puzzles, and progress through various levels. It introduces a few novelties, including scene swap, where players can switch between teams in separate locations to complete multi-part objectives, and boss battles. The game also features some real-time strategy elements, such as commanding large ground armies across battlefields.', 'youtube' => 'njc9TkwoorM', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E10+ - Everyone 10+', 'developers' => [8995], 'genres' => [2], 'publishers' => [25], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 923, 'game_title' => 'Driver: San Francisco', 'release_date' => '2011-09-27', 'platform' => 1, 'overview' => "The game takes place a few months after the events of Driv3r. It is revealed that both Tanner and Jericho survived the shootout in Istanbul. In the game's trailer, it is revealed that since then, both men have recovered and Jericho has escaped to San Francisco, while Tanner has pursued him there. Jericho is shown being transported in the back of a prison truck, but manages to escape with a vial of acid hidden within his mouth. He overpowers the guards, and hijacks the truck. Tanner and Tobias witness this from Tanner's car, pursuing Jericho as he causes havoc on the streets of the city. Tanner ends up in front of Jericho in an alleyway, and gets pushed in front of a tractor trailer. A hard crash occurs, putting him into a coma. The game will take place in Tanner's coma dream", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9150], 'genres' => [1, 7], 'publishers' => [7], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 924, 'game_title' => 'Sonic Unleashed', 'release_date' => '2008-11-18', 'platform' => 12, 'overview' => "Gameplay in Sonic Unleashed focuses on two modes of platforming play: fast-paced levels that take place during daytime, showcasing Sonic's trademark speed as seen in previous games in the series, and slower, night-time levels, during which Sonic's Werehog form emerges, and gameplay switches to an action-based, brawler style of play, in which Sonic battles Gaia enemies", 'youtube' => 'https://www.youtube.com/watch?v=442r0nMO7Jg', 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7979], 'genres' => nil, 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 925, 'game_title' => 'Trine 2', 'release_date' => '2011-12-07', 'platform' => 1, 'overview' => 'The Trine 2 story trail starts several years after the adventure and the search for an artifact in the original game. Starring three familiar characters: the Knight, Thief, and Magician. The trio join forces and go on a long journey once again to solve puzzles, revolving around physical laws, and fighting hordes of monsters to save the colorful world fenteziny.', 'youtube' => 'rAx9Q9z4Pdo?hd=1', 'players' => 1, 'coop' => 'Yes', 'rating' => nil, 'developers' => [3206], 'genres' => [4, 5, 15], 'publishers' => [58], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 926, 'game_title' => 'Arcania: Gothic 4', 'release_date' => '2010-10-12', 'platform' => 1, 'overview' => "ArcaniA: Gothic 4 is the successor to Gothic 3 and based upon the stories of the previous games, but does not continue it. It is a single-player, role-playing game with a \"back-to-basics\" approach, and features which have been slimmed down.\r\n\r\nTaking place a decade later than the previous game, players take the role of a new hero whose motivation and goal is to destroy the forces who have massacred his loved ones.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => nil, 'developers' => [8048], 'genres' => [4], 'publishers' => [189], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 928, 'game_title' => 'League of Legends', 'release_date' => '2009-10-27', 'platform' => 1, 'overview' => "League of Legends it's a online competitive game that mix the speed and intensity of an RTS with elements of RPG. In the game, two teams with mighty champions, which one with a particular design and unique play style, fight in different battlefields and game modes. League counts with an massive character gallery, where the player can choose and play. The game is also known for a huge competitive scenario and constant updates. ", 'youtube' => 'https://www.youtube.com/watch?v=D4DP-9oMfm4', 'players' => 10, 'coop' => 'Yes', 'rating' => 'T - Teen', 'developers' => [7217], 'genres' => [1, 4, 6], 'publishers' => [190], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 929, 'game_title' => 'Shank', 'release_date' => '2010-08-24', 'platform' => 1, 'overview' => "Shank is a side scrolling beat 'em up with a comic book art style. In the game the player controls Shank, an ex-mob hitman. The game features three main types of weaponry, knives, heavy melee weapons such as a chainsaw and a pair of pistols. Each weapon is assigned to a controller button, and the attacks can be combined to perform various combos. The player can collect temporary-use weaponry from fallen enemies, such as machine guns and rifles, as well as grenades.", 'youtube' => nil, 'players' => 2, 'coop' => nil, 'rating' => 'M - Mature', 'developers' => [4713], 'genres' => [1], 'publishers' => [35], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 930, 'game_title' => 'MotorStorm: Apocalypse', 'release_date' => '2011-05-03', 'platform' => 12, 'overview' => "MotorStorm: Apocalypse (released as MotorStorm 3 in Asia) is a 2011 racing 3D video game by Evolution Studios and published by Sony Computer Entertainment for the PlayStation 3. It is the fourth game in the MotorStorm series and the third for the PlayStation 3. It was announced shortly before the beginning of the Electronic Entertainment Expo 2010 on the PlayStation Blog by Evolution Studios on 10 June 2010.[4]\r\n\r\nMotorStorm: Apocalypse was released in Europe on 16 March 2011[1] but the UK release on 18 March was delayed by Sony Computer Entertainment UK following the 2011 T?hoku earthquake and tsunami in Japan.[5] The Australian launch went ahead as planned on 17 March, but Sony announced further shipments of the game to that country would be halted in the wake of the disaster. The planned North American release date of 12 April 2011[3] was delayed by Sony[6] who later confirmed new releases dates of 31 March 2011 in the UK[2] and 3 May 2011 in North America.[7]", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2911], 'genres' => [7], 'publishers' => [21], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 931, 'game_title' => 'Batman: Arkham City', 'release_date' => '2011-11-25', 'platform' => 1, 'overview' => 'No escape from Arkham City…the sprawling super-prison in the heart of Gotham City, home to its most violent thugs and infamous super villains. With the lives of the innocent at stake, only one man can save them and bring justice to the streets of Gotham City…The Batman.', 'youtube' => '8e_9YKtdg_o', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [7288], 'genres' => [1], 'publishers' => [152], 'alternates' => ['Batman Arkham City', 'BatmanAC'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 932, 'game_title' => 'Mafia II', 'release_date' => '2010-08-23', 'platform' => 1, 'overview' => "Born the son of a poor immigrant, Vito is a beaten down Italian American who is trying to secure his piece of the American Dream. Looking to escape the life of poverty that consumed his childhood, Vito is soon swayed by the lure of power and wealth that a life of Organized Crime can bring.\r\nA petty criminal his whole life, Vito, along with his childhood friend, Joe, will descend into the world of Organized Crime. Together, they will work to prove themselves to the Mob as they try to make their names on the streets of a cold and unforgiving city.\r\nMafia 2 immerses players in the mob underworld of a fictitious late 1940's / early 1950's scenario. The game engages you in a cinematic Hollywood movie experience in a living, breathing city, fusing high octane gunplay with white knuckle driving and an engaging narrative.", 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [47], 'genres' => [1, 2, 8], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 933, 'game_title' => 'F1 2010', 'release_date' => '2010-09-22', 'platform' => 1, 'overview' => "Immerse yourself in the glamour, pressure and exhilaration of the world’s most exciting motorsport as F1 2010 roars onto the track complete with all the official drivers, teams and circuits set to feature in the highly anticipated 2010 FIA FORMULA ONE WORLD CHAMPIONSHIP™.\r\n\r\nCompete against FIA FORMULA ONE WORLD CHAMPIONS™ like Michael Schumacher, Lewis Hamilton, Jenson Button and Fernando Alonso and take on the full 2010 circuit line up featuring the return of the Canadian Grand Prix, Abu Dhabi and Singapore’s dramatic night race realised in glorious high definition for the first time and debut ahead of the drivers on the all-new Korean circuit.\r\n\r\nPowered by Codemasters’ EGO Game Technology Platform, the world of FORMULA ONE comes to life with jaw-dropping visuals, authentic handling, dynamic weather and class-leading damage in a range of game modes including quick race, career mode and online multiplayer.\r\n\r\nF1 2010 will take you to the heart of FORMULA ONE like never before.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1728], 'genres' => [7, 11], 'publishers' => [16], 'alternates' => ['F1 2010'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 934, 'game_title' => 'Sniper: Ghost Warrior', 'release_date' => '2010-06-29', 'platform' => 1, 'overview' => "The game is based around the role of the military sniper, which the developer has noted that the public interest of which has increased thanks in large parts to shows on channels like the History Channel or the Military Channel. The game's objective is to insert players into the role of an elite sniper team sent into a hostile area in an attempt to help the rebels of Isla Trueno, a fictitious Latin American country, fight against the force who has toppled their government in a coup d'état.", 'youtube' => 'C4URFHKeKvU', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1666], 'genres' => [1, 8], 'publishers' => [192], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 935, 'game_title' => 'Gears of War 3', 'release_date' => '2011-09-20', 'platform' => 15, 'overview' => "Microsoft's Gears of War 3 is the spectacular conclusion to one of the most memorable and celebrated sagas in video game history. Developed by Epic Games exclusively for Xbox 360, Gears of War 3 plunges players into a harrowing tale of hope, survival and brotherhood. In Gears of War 3, players fight on as Marcus Fenix, the grizzled war hero and leader of Delta Squad. Eighteen months after the fall of the last human city, the war against the Locust rages on. Meanwhile, deep beneath the surface, a fearsome new threat is infecting the planet from within. With survivors scattered and civilization in ruins, time is running out for Marcus and his comrades as they fight to save the human race.", 'youtube' => '0LxJ1ESkmrs', 'players' => 2, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [10_018], 'genres' => [1, 8], 'publishers' => [1], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 936, 'game_title' => 'BioShock Infinite', 'release_date' => '2013-03-26', 'platform' => 1, 'overview' => "The events of the game take place in 1912. The player assumes the identity of Booker DeWitt, a disgraced former agent of the Pinkerton National Detective Agency. He had witnessed events at the Battle of Wounded Knee that changed him, leading to excessive drinking and gambling; he was subsequently dismissed for behavior beyond the acceptable bounds of the Agency. He is hired by mysterious individuals, aware of Columbia's location, and tasked to infiltrate the air-city and rescue a young woman named Elizabeth, who has been held aboard the air-city for the last twelve years. Completing the task and returning Elizabeth to New York City would clear Booker of \"old debts\", but this would be his last chance to clear them.\r\n\r\nBooker is taken by boat to an island lighthouse near Maine that houses a rocket silo, from which he is taken to Columbia. His arrival there is initially quiet; he is baptized by the population before allowed to explore the city. However, while at a carnival, one citizen notices a tattoo on Booker's wrist, with the letters \"AD\", a sign of a \"false shephard\" that will bring Comstock's downfall by taking away his \"lamb\", purportedly Elizabeth. Booker becomes a target of Comstock's forces from this discovery, and he is forced into the conflict of the city while still seeking Elizabeth. Though Booker finds Elizabeth easily enough, he quickly discovers that Elizabeth is central to the civil war raging in the city, her rescue being the start of the chain of events that ultimately lead to Columbia's down-fall. Elizabeth, when first rescued, is meek and timid, and only just coming to grasp her abilities with her powers, but as she is escorted by Booker, becomes bolder and more confident, shown through both physical appearance and her changes in outfit. Each faction seeks to use Elizabeth to turn the tide of the conflict in their favor; the Founders believe Elizabeth's powers can help end the conflict and place them back in control, while the Vox Populi would rather kill Elizabeth than allow the Founders to get their hands on her, believing a prophecy that if Elizabeth falls, so does Columbia. Booker and Elizabeth are forced to place their trust in one another in order to escape. Elizabeth also seeks to understand the powers that she has been given, believing Comstock to be responsible, and refuses to leave Columbia until she learns the truth. Booker comes to fear the power that Elizabeth possesses; a scene during one of the game's preview trailers shows Booker to be more afraid of Elizabeth than God. To complicate matters, the pair is chased by Songbird, a large, robotic bird-like creature who had been Elizabeth's friend and warden over the last twelve years of her imprisonment. Songbird was designed by its creator to feel betrayal should Elizabeth escape, comparable to an abusive spouse, according to Hilary Goldstein of IGN, and Elizabeth notes she \"would rather be killed than be recaptured by Songbird.\"\r\n\r\nIn addition to the internal strife, Columbia is ravaged by tears in the fabric of space-time. The game begins with a quote from a fictional work Barriers to Trans-dimensional Travel purportly published in 1889. A strange shimmering effect as seen by Booker causes momentary changes to pictures, banners, and people, representing the nearby presence of a tear; in one example, Booker, while watching a Founder give a speech, experiences a brief shimmer where a patriotic button on the Founder's jacket briefly changes to that of the hammer and sickle associated with Communism. The tears have brought seemingly anachronistic elements into the Columbia of 1912; for example, an early gameplay demo footage features a record player in a bar plays a woman singing the lyrics to Tears for Fears' 1985 song \"Everybody Wants to Rule the World\"; a later press reveal included similar covers of 1933's \"Goodnight, Irene\" by Huddie Ledbetter, sung in chorus by a large group of Columbia's citizens, 1966's \"God Only Knows\" by The Beach Boys, sung by a barbershop quartet, and 1983's \"Girls Just Want To Have Fun\" by Cyndi Lauper. 1UP.com's preview of the 2011 E3 game demonstration denotes that at one point, Booker and Elizabeth find themselves in 1983, evident by a movie marquee showing Revenge of the Jedi (the original working name for Return of the Jedi), a result of a misfire of Elizabeth's powers involving tears in the fabric of space-time when she tries to help revive a horse. The scene was part in a media preview event in December 2012, though in this case, the events occurred within a test laboratory, with Elizabeth expressing an interest in going to Paris and opening a rift to see the marquee for the film in French (La Revanche du Jedi).\r\n\r\nLevine has stated that the ending of Infinite is \"like nothing you've experienced in a video game before\"; the story purposely avoids a problem that arose from the original BioShock in which, after the death of Andrew Ryan in the middle of the game, \"the story loses some of its steam\".\r\n\r\nThough the game takes place before the events of the previous two BioShock games (occurring in 1960 and 1968, respectively), Irrational Games has not confirmed if BioShock Infinite shares the same universe with these titles; Ken Levine left the question of the possibility unanswered in an interview stemming from the game's announcement.", 'youtube' => '1WDQ4FhslSk', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4357], 'genres' => [8], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 937, 'game_title' => 'Resistance 3', 'release_date' => '2011-09-06', 'platform' => 12, 'overview' => "The story starts four years after Operation: Black Eden, where the United States is the last nation standing against the Chimera, but leaving most of the states into barren wastelands along with the rest of the world. Joseph Capelli has been dishonorably discharged from SRPA for executing Nathan Hale, while Malikov has discovered a cure for the Chimera virus from Hale's blood as the Chimera begin to exterminate the human race. In an underground outpost in Haven, Oklahoma, Capelli, his wife Susan Farley, son Jack and other survivors have been living in hiding from the Chimera patrols for over 2 years. Their hope to stay hidden from the Chimera is quickly crushed as Capelli notices a Terraformer (a massive, satellite-like weapon that destroys everything on the ground by firing an energy wave from the sky) moving towards Haven.", 'youtube' => 'Px2VThf9D30&feature=fvst', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [4232], 'genres' => [8], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 938, 'game_title' => 'Ratchet & Clank: All 4 One', 'release_date' => '2011-10-18', 'platform' => 12, 'overview' => "We find our heroes in the midst of a dilemma of intergalactic proportions when Dr. Nefarious' latest evil plan goes awry leaving Ratchet, Clank, Qwark and Nefarious himself caught in the snare of a powerful and mysterious machine. Begrudgingly, the Galaxy's biggest do-gooders and its most sinister criminal must work together to discover a means of escape in this action-packed installment of the Ratchet & Clank series.", 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [4232], 'genres' => [1, 15], 'publishers' => [14], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 939, 'game_title' => 'The Witcher 2: Assassins of Kings', 'release_date' => '2011-05-17', 'platform' => 1, 'overview' => 'The second installment in the RPG saga about the Witcher, Geralt of Rivia, features a thoroughly engrossing, mature storyline defining new standards for thought-provoking, non-linear game narration. In addition to an epic story, the game features an original, brutal combat system that uniquely combines tactical elements with dynamic action. A new, modern game engine, responsible for beautiful visuals and sophisticated game mechanics puts players in the most lively and believable world ever created in an RPG game. A captivating story, dynamic combat system, beautiful graphics, and everything else that made the original Witcher such a great game are now executed in a much more advanced and sophisticated way.', 'youtube' => '', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [1532], 'genres' => [1, 4], 'publishers' => [506], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 940, 'game_title' => 'Hellgate: London', 'release_date' => '2007-10-31', 'platform' => 1, 'overview' => "The Hellgate: London setting has six classes to choose from. These are paired up into three main archetypes, or Factions as they are referred to in game. Players need to choose one of these classes for their role playing character before they can start playing the game. The factions are split as follows;\r\n\r\n-Templars are of an order of divine warriors who wish to preserve humanity and smite the Great Dark that has fallen upon the world. Their two classes are Guardians and Blademasters.\r\n-Cabalists are seekers of knowledge who want to control the fate of mankind by studying the Great Dark and using their powers. Their classes are Summoners and Evokers.\r\n-Hunters are highly trained ex-military operatives who have been through almost every warlike scenario imaginable. Marksmen and Engineers are their classes.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [3074], 'genres' => [1, 4], 'publishers' => [2], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 942, 'game_title' => 'Monsters vs. Aliens', 'release_date' => '2009-03-23', 'platform' => 1, 'overview' => 'Monsters vs. Aliens is based on the animated movie of the same name. During the course of the game the player takes control over three characters from the movie which all feature different gameplay elements. Missing Link, a mix between fish and human, has to survive levels which are similar to most licensed games from animated movies: a 3rd person platformer. The sections with B.o.B., a slime monster, are more puzzle oriented. He can swallow enemies or items and use them to spit on other enemies. These are also used to press switches and as safety procedure when crossing bars - if B.o.B. had nothing solid in him he would just slip through them. With B.o.B. the player also has to solve mazes and shooting sequences. The last character is Gigantika, a 15 meters high woman. She uses trucks as inline skates and has to avoid obstacles by jumping or mastering quick time events (pressing a displayed button in a limited time). In co-op mode the second player takes the role of a Dr. Cockroach and supports the main player with appropriate actions, e.g. shooting. The player can unlock a lot of bonus material, e.g. concept art, deleted scenes (in this case: levels) or audio commentaries.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [976], 'genres' => [1, 5], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 943, 'game_title' => 'Guitar Hero III: Legends of Rock', 'release_date' => '2007-11-13', 'platform' => 1, 'overview' => "Rock out to the third entry in in Red Octane's music series for guitar gods! Songs for Guitar Hero III include Barracuda by Heart, Sabotage by Beastie Boys, Rock And Roll All Nite by Kiss, and much more! In addition, players can experience an incredible number of added features and explosive content including a new multiplayer action-inspired battle mode, grueling boss battles, a bevy of exclusive unlockable content and authentic rock venues.\r\n\r\nAlso for the first time ever, Guitar Hero fans can thrash and burn with new wireless guitar controllers available for each platform. The exclusive Gibson guitars include innovative features such as removable faceplates that will allow fans to personalize their guitars and make it their own, and a new button color design that is integrated for an even greater authentic feel and rock experience.", 'youtube' => 'zp4N5yQrfcY', 'players' => nil, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [725], 'genres' => [9], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 944, 'game_title' => 'Pro Evolution Soccer 2011', 'release_date' => '2010-10-08', 'platform' => 1, 'overview' => "Pro Evolution Soccer 2011  is an association football video game in the Pro Evolution Soccer series developed and published by Konami with production assistance from the Blue Sky Team. The game was announced on 9 February 2010 and was released on the PlayStation 3, PC and Xbox 360 on 30 September 2010 in the European Union and 8 October 2010 in the United Kingdom. The versions of Wii, PlayStation 2, and PlayStation Portable were released on 28 October 2010. The UEFA Champions League and UEFA Europa League are featured within the game, and for the first time in the series, UEFA Super Cup and CONMEBOL's Copa Libertadores will be fully licensed", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [4765], 'genres' => [11], 'publishers' => nil, 'alternates' => ['PES 2011'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 947, 'game_title' => 'Enslaved: Odyssey to the West', 'release_date' => '2010-10-05', 'platform' => 15, 'overview' => "Enslaved: Odyssey to the West is an action-adventure platform video game developed by Ninja Theory and published by Namco Bandai Games. It was released on PlayStation 3 and Xbox 360 on October 5, October 7 and October 8, 2010 in North America, Australia, Japan and Europe respectively.[1][2] A premium version, featuring all DLC content, was made for Microsoft Windows and Sony Playstation 3 and was later released on October 25, 2013.\r\n\r\nThe story is a re-imagining of the novel Journey to the West written by Wu Cheng'en. Unlike the original story that was set in a fantastical version of ancient China, the game is set 150 years in a future post-apocalyptic world following a global war, with only remnants of humanity left, along with the still active war machines left over from the conflict. Like the original story however, the plot revolves around someone who forces the help and protection of a warrior, with many characters sharing the same names and roles. The game's story was written by Alex Garland, with voice talent and motion capture from Andy Serkis and Lindsey Shaw.", 'youtube' => 'fIOP6KQ_ugs', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6032], 'genres' => [1, 2, 15], 'publishers' => [39], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 948, 'game_title' => 'DiRT 3', 'release_date' => '2011-05-24', 'platform' => 1, 'overview' => "Get ready for DiRT 3! Race through the snow, rain and dirt and experience dramatic night races with the most amount of rally content in the series yet. \r\nExpress yourself in the stunning new Gymkhana mode, inspired by Ken Block’s incredible freestyle driving event, and upload your best runs direct to YouTube! Compete in iconic rally cars representing 50 years of the sport, from the classic Audi Quattro to the 2011 Ford Fiesta WRC, and take on all game modes in split-screen and competitive online multiplayer. Competing as a professional rally star you’ll enjoy intense racing across three continents – from the forests of Michigan to the infamous roads of Finland and the national parks of Kenya. \r\nPowered by Codemasters’ award-winning EGO Engine, DiRT 3 features Flashback to rewind time and genre-leading damage. DiRT 3 is the ultimate off-road racer", 'youtube' => 'aqRafZz6Y7o?hd=1', 'players' => 2, 'coop' => 'No', 'rating' => 'E10+ - Everyone 10+', 'developers' => [1726], 'genres' => [7, 11], 'publishers' => [16], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 949, 'game_title' => "Asura's Wrath", 'release_date' => '2012-02-21', 'platform' => 15, 'overview' => "The game follows the titular character, the demigod Asura as he seeks revenge on the other pantheon of demigods who betrayed him. The story is presented in the style and format of an episodic series of cinematic shorts, including opening and closing credits, with the gameplay being integrated into the cinematic where players switch between third-person combat and interactive sequences with player input in the form of quick-time even button prompts. Because of its unique style, the game has been decribed in the media as an \"interactive anime\". According to the game's producer Kazuhiro Tsuchiya, \"Asura's Wrath takes elements from Hinduism and Buddhism and blends them with science fiction, with the main and supporting characters based on the ever combative and superiority-seeking beings of the same name that are part of the Hindu and Buddhist cosmology.", 'youtube' => 'https://www.youtube.com/watch?v=Nl3_irB9GMk', 'players' => 1, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [2010], 'genres' => [1], 'publishers' => [9], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 950, 'game_title' => 'Killing Floor', 'release_date' => '2009-05-14', 'platform' => 1, 'overview' => "Killing Floor's Gameplay is comparable to the Invasion gametype. Designed around co-op (Cooperative) play, it puts people against a city of millions of infected people, primarily based in the United Kingdom, with weapons ranging from pistols to explosives. Players must arrange their group to most effectively counter the waves of enemies, including adopting specific strategies such as barricading themselves in, or finding high ground.\r\n\r\nThe objective is to survive as long as possible against continual \"waves\" of enemies. The number of enemies in a given wave is a calculation of how many players are left. The number of enemies that they must defeat before the round ends is displayed on the HUD. Upon defeating the required number of foes, the wave will end, and shortly thereafter the next will begin, bringing more difficult foes.\r\n\r\nIn order to fight off these increasingly challenging enemies, players must acquire money by killing zombies. The amount of money gained per kill depends on the difficulty of the enemy. Money acquired by players can then be spent at the Trader's shop, which opens at the end of each wave.", 'youtube' => nil, 'players' => 4, 'coop' => 'Yes', 'rating' => 'M - Mature', 'developers' => [7648], 'genres' => [1, 8, 18], 'publishers' => [193], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 951, 'game_title' => 'Alien Swarm', 'release_date' => '2010-07-19', 'platform' => 1, 'overview' => 'Alien Swarm is a top-down shoot-em-up set at a 60 degree angle. Four players can join a single co-operative game, the aim of which is to progress through science fiction themed levels while eliminating waves of aliens. Players can choose from 40 different weapons. The game includes persistent statistics, unlockables and achievements.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [9289], 'genres' => [8], 'publishers' => [13], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 952, 'game_title' => 'Call of Duty: Black Ops', 'release_date' => '2010-11-09', 'platform' => 1, 'overview' => 'Call of Duty: Black Ops takes place during the Cold War, in The Sixties. The story focuses on CIA-backed clandestine black operations carried out behind enemy lines. These missions take place in various locations around the globe such as the Ural Mountains in central Russia, Cuba, Laos, and Vietnam. The single-player campaign revolves around an experimental Soviet chemical weapon codenamed "Nova-6".', 'youtube' => 'pB1LzY7smcM', 'players' => 4, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9025], 'genres' => [8], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 953, 'game_title' => 'Duke Nukem Forever', 'release_date' => '2011-06-14', 'platform' => 1, 'overview' => "Put on your shades and prepare to step into the boots of Duke Nukem, whose legend has reached epic proportions in the years since his last adventure. The alien hordes are invading and only Duke can save the world. Pig cops, alien shrink rays and enormous alien bosses can't stop our hero from accomplishing his goal: to save the world, save the babes and to be a bad-ass while doing it. The King arrives with an arsenal of over-the-top weapons, non-stop action, and unprecedented levels of interactivity. This game puts the pedal to the metal and tongue firmly in cheek. Shoot hoops, lift weights, read adult magazines, draw crude messages on whiteboards or ogle the many hot women that occupy Duke's life - that is if you can pull yourself away from destroying alien invaders. With hours and hours of over-the-top single player action, and a range of bodacious multiplayer modes, rest assured knowing the fun will last. Duke Nukem was and will forever be a gaming icon, and this is his legend.", 'youtube' => 'wVuuyRGB_BA?hd=1', 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [74], 'genres' => [8], 'publishers' => [8], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 954, 'game_title' => 'Lady Bug', 'release_date' => '1981-01-01', 'platform' => 23, 'overview' => 'Lady Bug is an insect-themed maze chase arcade game produced by Universal Entertainment Corporation and released in 1981. Its gameplay is similar to Pac-Man, with the primary addition to the formula being gates that change the layout of the maze when used. The arcade original was relatively obscure, but the game found wider recognition and success as a launch title for the ColecoVision console.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [9233], 'genres' => [5], 'publishers' => [194], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 955, 'game_title' => 'Lode Runner', 'release_date' => '1987-09-01', 'platform' => 7, 'overview' => "The player controls a stick figure who must collect all the gold in a level while avoiding guards who try to catch the player. After collecting all the gold, the player must travel to the top of the screen to reach the next level. There are 150 levels in the game which progressively challenge players' problem-solving abilities or reaction times.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [2470], 'genres' => [1, 15], 'publishers' => [105], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 956, 'game_title' => 'Red Faction: Armageddon', 'release_date' => '2011-06-07', 'platform' => 1, 'overview' => 'The game takes place on the planet Mars. It is set in the year 2170, fifty years after the events of Red Faction: Guerrilla. Since the liberation of Mars, the surface of the planet has become uninhabitable. This occurred when the massive Terraformer machine on Mars which supplied it with its Earth-like atmosphere was destroyed by Adam Hale, the games key antagonist, causing super-tornados and violent lightning storms to engulf the planet. In order to survive, the Colonists were forced to flee to the underground mines of Mars built by their ancestors, creating a network of habitable caves under the surface of the planet and setting up colonies there.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [9487], 'genres' => [8], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 957, 'game_title' => 'Extreme-G', 'release_date' => '1997-09-30', 'platform' => 3, 'overview' => 'Extreme-G is set in the distant future where Earth is a mere wasteland.  From their new found planet the human colonists watch with joy as their remote controlled power-bikes wreak havoc through their ancient cities.  There is only one winner, the first to cross the line… or the last to survive.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6787], 'genres' => [1, 7, 8, 11], 'publishers' => [28], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 958, 'game_title' => 'Extreme-G 2', 'release_date' => '1998-11-17', 'platform' => 3, 'overview' => 'This iteration, as with all Extreme-G games, is about futuristic racing: pilots race plasma-powered Tron-like bikes in an intergalactic Grand Prix at speeds that are over 999 mph.  It is possible to break the sound barrier in this game, creating a sonic boom. While travelling at supersonic speeds, all game sounds are muted except the sound of the vehicle travelling.  If the bike slows down to below supersonic speeds, another sonic boom can be heard and all game sounds will resume.  The emphasis is on speed and creative racetrack design, with tracks looping through all three dimensions like roller coasters.', 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6787], 'genres' => [1, 7, 8, 11], 'publishers' => [28], 'alternates' => ['Extreme-G: XG2', 'XG2'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 959, 'game_title' => 'Flying Dragon', 'release_date' => '1998-07-31', 'platform' => 3, 'overview' => 'Two games in one: Flying Dragon is the ONE and ONLY game that will entertain the entire family. Create your ideal fighting game using the most customizable interface yet offered. Choose between RPG-style and "virtual" tournament combat. Flying Dragon is never the same game twice! Over 20 different characters and 200 different items. Save your characters on a Controller Pak and play them against your friends!', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [1981], 'genres' => [10], 'publishers' => [130], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 960, 'game_title' => 'Mario Party 3', 'release_date' => '2001-05-07', 'platform' => 3, 'overview' => "Mario Party 3 is the third and final Mario Party title for the Nintendo 64. A total of eight characters are available to choose from: Mario, Luigi, Princess Peach, Yoshi, Wario, Donkey Kong, and newcomers Waluigi and Princess Daisy. Mario Party 3 features duel maps, in which two players try to lower each other's stamina to zero using non-playable characters such as Chain Chomps. It is the first Mario Party game to feature Luigi's main voice and also it is last Mario game where Princess Daisy appears in a yellow and white dress, and with long hair, as well as the last Mario game (until New Super Mario Bros. Wii) in which Yoshi's \"record-scratching\" voice is used. It is also the first Mario Party game to have multiple save slots.", 'youtube' => '-qsgScPmVfY', 'players' => 4, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [3923], 'genres' => [1, 2, 6, 11], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 961, 'game_title' => 'Pilotwings 64', 'release_date' => '1996-06-23', 'platform' => 3, 'overview' => "Forget about those other flying games.  This is the ultimate flight experience!  Pilotwings 64 carries you off into a vast three-dimensional environment.  Pilot several different vehicles and take in breathtaking sights.  Successfully complete flight tests to earn your flight badge.  Get a high enough score, and you’ll get a chance at bonus games such as Cannonball and Sky Diving!  Soar into a wild blue yonder with Pilotwings 64!\r\n\r\n* Tons of aerial challenges for you to master!\r\n* Hop into the seat of a Gyrocopter and fire off some missiles!\r\n* Strap on a Rocket Belt and check out places like Mt. Rushmore, the Space Needle and the Statue of Liberty!\r\n* Dangle in silent solitude from a Hang GLider as you soar above tropical jungles and frozen ice floes.\r\n* Save your progress in memory.", 'youtube' => '3LY2EKBebvo', 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [6037], 'genres' => [13], 'publishers' => [3], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 962, 'game_title' => 'Road Rash 64', 'release_date' => '1999-09-22', 'platform' => 3, 'overview' => "180 MPH slap in the face, anyone? Multi-player modes for up to four players including Deathmatch, Cop Mode and Tag. New weapons and moves like the dreaded spoke jam. Intense pack brawling, including grudges and alliances. 200 miles of interconnected tracks and environments. Over 25 bikes and characters to choose from. Thrashin' soundtrack featuring Sugar Ray, The Mermen and more!", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [6362], 'genres' => [19], 'publishers' => [40], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 963, 'game_title' => 'Top Gear Rally', 'release_date' => '1997-10-05', 'platform' => 3, 'overview' => "On the Nintendo 64, Top Gear Rally features a realistic physics model with functioning suspension. At the time, this was an impressive new gameplay development. Road surfaces, including their imperfections, were accurately modeled to give the player the feeling of actually driving a car.\r\nThe performance of each vehicle in the game was unique. Not only with respect to engine power, but also areas such as tire grip, suspension stiffness, steering tightness, and between different drive-trains such as front-wheel drive, rear-wheel drive, and four-wheel drive. The game also features the possibility of damaging the vehicles, although the damage does not affect performance. The game features a soundtrack consisting of tunes with a sort of trance-style. The electronic XM music was composed by Barry Leitch, who also worked on Super Nintendo Top Gear releases.", 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [1292], 'genres' => [7, 19], 'publishers' => [41], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 964, 'game_title' => 'Vigilante 8', 'release_date' => '1998-05-31', 'platform' => 3, 'overview' => "The game's storyline is built around an alternate history, in which there was a worldwide oil crisis in the 1970s and the U.S. was on the verge of an economic breakdown. Strikes, riots and crime were rampant, and all available law enforcement were brought to the cities leaving the outlands vulnerable. A foreign multinational oil consortium, Oil Monopoly Alliance Regime (OMAR), was determined to monopolize the world oil trade. The U.S. was the last country that stood in their way and they were prepared to go to any length to bring the U.S. to its knees.\r\nOMAR hired Sid Burn, a professional terrorist, to push the U.S. economy over the edge. Sid began to organize his troops in the remote areas of the southwest. Calling themselves the \"Coyotes,\" they began to target oil refineries, commercial installations and other vital industry throughout the region. With the law enforcement in the cities, some desperate civilians began to take the law into their own hands. Led by a trucker named Convoy and referred to simply as the \"Vigilantes,\" this oddball group soon became a major hindrance to Sid.\r\nMeanwhile, the U.S. government, feeling more vulnerable than ever, was intensifying its research and development of a new military arsenal. The most advanced weaponry, rumored to be based on UFO technology, was located at Site-4, a secret facility at Papoose Lake. This information was not lost on Sid, and the Coyotes ambushed the facility. However the Vigilantes unexpectedly appeared to stop them and as a result, both parties found themselves in possession of the world's most advanced weaponry.\r\nWhat followed were no ordinary skirmishes. Auto clashes ensued all over the land, from Colorado's Rockies to California's farmlands, only to culminate in a battle like no other. To this day the events which took place are only a matter of speculation.", 'youtube' => nil, 'players' => 4, 'coop' => 'No', 'rating' => 'T - Teen', 'developers' => [5102], 'genres' => [1, 8, 19], 'publishers' => [33], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 965, 'game_title' => 'Shadow of the Beast II', 'release_date' => '1994-06-07', 'platform' => 21, 'overview' => 'Combining non-stop battle action with perplexing puzzle solving, Shadow of the Beast II thrusts you into a dark and mysterious world where wits and combat-hardened game playing skills are your only defense. Take the action to the limit as you fight a relentless onslaught of monsters and ogres. Bashing them into submission, you make your way through a labyrinth of adventure and enter final confrontation with the Beast Mage!', 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'M - Mature', 'developers' => [7109], 'genres' => [1], 'publishers' => [135], 'alternates' => ['Beast II'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 966, 'game_title' => 'Exo-Squad', 'release_date' => '1995-05-19', 'platform' => 36, 'overview' => 'The player alternatively assumes the roles of three members of the Able Squad: Lt. J.T. Marsh, Sgt. Rita Torres and Wolf Bronsky.', 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [558], 'genres' => [8], 'publishers' => [144], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 967, 'game_title' => 'Golden Axe II', 'release_date' => '1991-12-26', 'platform' => 18, 'overview' => 'The three playable characters from the first Golden Axe, Ax Battler, Tyris Flare, and Gilius Thunderhead, return in Golden Axe II to fight the new evil forces led by Dark Guild. The game features a total of seven levels: six scrolling levels and a final end of game boss battle against Dark Guild.', 'youtube' => 'LI-jS0iraxo', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 969, 'game_title' => 'Pirates! Gold', 'release_date' => '1993-01-01', 'platform' => 18, 'overview' => "Pirates! is a single-player game. The player receives a letter of marque authorizing service as a privateer for Spain, the Dutch Republic, England, or France in the Caribbean. The player's loyalties may change over the course of the game; he may also hold rank with multiple countries and may turn to piracy at any time. Gameplay is open-ended; the player may choose to attack enemy ships or towns, hunt pirates, seek buried treasure, rescue long-lost family members, or even avoid violence altogether and seek to increase his wealth through trade. The game also has no predetermined end, although as time goes on, it becomes more difficult to recruit crew members. Also, as the player character ages, fighting becomes more difficult, and deteriorating health will eventually force the character into retirement. The game ends when the player retires, at which point he is given a position in his future life, from beggar to King's adviser, based on accumulated wealth, land, rank, marital status, and other accomplishments.", 'youtube' => nil, 'players' => 1, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [5483], 'genres' => [1, 2, 6], 'publishers' => [196], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 970, 'game_title' => 'Smash T.V.', 'release_date' => '1991-09-01', 'platform' => 7, 'overview' => "Moving from one room to the next within the studio/arena, players have to shoot down hordes of enemies as they advance from all sides, while at the same time collecting weapons, power-up items, and assorted bonus prizes until a final show down with the show's host where you are finally granted your prizes, your life and freedom. One of the enemies is fat and is named Mr. Shrapnel who roams aside of the walls of some rooms and after a short period of time he explodes. In the NES version, he is replaced by a giant rolling bomb.", 'youtube' => nil, 'players' => nil, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [9635], 'genres' => [8], 'publishers' => [197], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 971, 'game_title' => 'Streets of Rage', 'release_date' => '1991-08-02', 'platform' => 18, 'overview' => "Axel, Adam and Blaze - ex-cops, the solution to punk pollution. The city's a war zone, and they're going out two at a time to give the gangs a kick in the guts. This is the ultimate in street combat. These city fighters are martial arts maniacs with a battery of 40 individually controllable attacks - including jabs, head butts, and overhead kicks. They're up against a mob of Kung-Fu creeps and axe-hurling fiends. On the streets it's only two of them against hordes of attacking scum. Slam into pipe-wielding weirdos and bash 'em with their own metal. Throw an uppercut or an elbow smash - these goons keep comin'!", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7549], 'genres' => [1, 10], 'publishers' => [15], 'alternates' => ['Bare Knuckle'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 972, 'game_title' => 'X-Men 2: Clone Wars', 'release_date' => '1995-08-17', 'platform' => 18, 'overview' => "The X-Men engage in a battle so world-threatening, even Magneto switches sides! Mutantkind races to the edge of oblivion at the hands of an evil techno-bio cloning organism... the Phalanx! Be Wolverine, Cyclops, Gambit, Nightcrawler, Beast, Psylocke and for the first time ever... play as Magneto! X-Men are at their fiercest with Cyclops' optic blast, Wolverine's slashing adamantium claws and Gambit's hyper-charged cards! Use each mutant's super-powered attack to defend the world!", 'youtube' => nil, 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [3762], 'genres' => [1], 'publishers' => [15], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 973, 'game_title' => 'Metal Slug X', 'release_date' => '1999-03-18', 'platform' => 24, 'overview' => 'A revised version of Metal Slug 2, titled Metal Slug X, was released on March 1999 for the Neo Geo MVS. It fixed problems with slowdown present in Metal Slug 2, and increased the difficulty. Metal Slug X also introduced a few new elements to the Metal Slug 2 game system. New weapons and items were added, such as the "Iron Lizard" and the "Drop Shot". The enemy placement and bosses were re-arranged as well.', 'youtube' => '', 'players' => 2, 'coop' => 'No', 'rating' => 'E - Everyone', 'developers' => [7885], 'genres' => [1, 8], 'publishers' => [60], 'alternates' => ['mslugx'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 974, 'game_title' => 'Fatal Fury', 'release_date' => '1991-12-20', 'platform' => 6, 'overview' => "The plot of Fatal Fury centers around a martial arts tournament known as the \"King of Fighters\" tournament, held in the fictional American city of South Town and sponsored by local crime boss Geese Howard. Ten years prior to the events of the game, Geese murdered a rival martial artist named Jeff Bogard who was on his trail. Now, Jeff's sons, Terry and Andy, along with their friend Joe Higashi, enter the tournament to get their revenge on Geese.", 'youtube' => nil, 'players' => 2, 'coop' => nil, 'rating' => nil, 'developers' => [7885], 'genres' => [10], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 975, 'game_title' => 'Fatal Fury 2', 'release_date' => '1993-03-05', 'platform' => 18, 'overview' => "After Geese Howard's death in the original Fatal Fury, a mysterious nobleman becomes the sponsor of the new \"King of Fighters\" tournament. This time, the tournament is held worldwide with fighters around the globe competing. As the single player mode progresses, the mysterious challenger begins defeating the participants from the previous Fatal Fury game, searching for the man responsible for defeating Geese.", 'youtube' => 'https://www.youtube.com/watch?v=EChzW0Kvd-4', 'players' => 2, 'coop' => 'Yes', 'rating' => 'E - Everyone', 'developers' => [7885], 'genres' => [10], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 976, 'game_title' => 'Ghost Pilots', 'release_date' => '1991-07-01', 'platform' => 24, 'overview' => "The gameplay is straightforward with elements similar to that of Capcom's 19XX games, but it is incredibly difficult even on the easiest difficulty level. Unlike most scrolling shooters, the vehicle is a seaplane instead of spaceship or airplane. As the in-game instructions indicate, move the joystick around to maneuver the seaplane. Press the A Button to fire bullets. The player can also hold the A button for a semi-automatic fire. Press the B Button to launch bombs from the inventory. The player starts with 3 bombs.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [1, 8], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 977, 'game_title' => "The King of Fighters '94", 'release_date' => '1994-10-01', 'platform' => 24, 'overview' => "Rugal Bernstein is an incredibly rich and notorious arms and drug trafficker, as well as an incredibly skilled and ruthless fighter. Having become bored with the lack of competition, Rugal decides to host a new King of Fighters tournament. Rugal has his secretary travel to eight destinations around the world and invite fighters to his new tournament. Unlike the previous KOF tournaments depicted in the Fatal Fury series, the new King of Fighters is a team tournament, with eight teams of three, each representing a different nationality, participating this time. Most characters come from other SNK games, such as Team Italy, which is composed of three heroes from the original Fatal Fury: Terry Bogard, Andy Bogard and Joe Higashi. The two heroes from Art of Fighting (Ryo Sakazaki and Robert Garcia) are featured along with their mentor and Ryo's father (Takuma Sakazaki) make up Team Mexico. Team Korea features Kim Kaphwan from Fatal Fury 2 as the leader of two convicts he's trying to reform Chang Koehan and Choi Bounge, while Team England is a mix of female fighters from Fatal Fury 2 (Mai Shiranui) and the Art of Fighting series (Yuri Sakazaki, King). The two heroes from Psycho Soldier (Athena Asamiya and Sie Kensou) form Team China along with their mentor, Chin Gentsai. Similarly, Team Brazil features the heroes from Ikari Warriors (Ralf and Clark) along with their commanding officer Heidern. Additionally, the game features two teams composed entirely of original characters: Team Japan featuring Kyo Kusanagi, Benimaru Nikaido and Goro Daimon, and Team USA composed of Heavy D!, Lucky Glauber and Brian Battler.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [10], 'publishers' => [60], 'alternates' => ['kof94'], 'uids' => nil, 'hashes' => nil },
    { 'id' => 978, 'game_title' => "The King of Fighters '95", 'release_date' => '1995-09-01', 'platform' => 24, 'overview' => "The King of Fighters '95 marks the beginning of a story arc that later became known as the \"Orochi Saga\". However, the only elements from the Orochi Saga known in this game is the introduction of Kyo's rival, Iori Yagami, and Rugal's use of the Orochi power\r\n\r\nRugal Bernstein, thought to have perished in an explosion in the previous game, had in fact survived and sent out invitations to the teams from the previous game signed simply 'R'. Only one of the previous teams failed to attend the new tournament: the American Sports Team, now replaced by the \"Rival Team\" consisting of Iori Yagami, Billy Kane (from Fatal Fury: King of Fighters), and Eiji Kisaragi (from Art of Fighting 2). Saisyu Kusanagi, Kyo's father, appears as a fighter for the first time (having made a non-playable cameo in KOF '94) as a computer-controlled sub-boss character. After defeating Saisyu in the arcade mode, it is revealed that Saisyu was being brainwashed and that Rugal will fight once again as a boss character, but as an enhanced version named \"Omega Rugal\".", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [10], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 979, 'game_title' => "The King of Fighters '96", 'release_date' => '1996-07-30', 'platform' => 24, 'overview' => "A new King of Fighters tournament was announced, though the letters of invitation sent out to the fighters were no longer sent by Rugal Bernstein. The letters also announced many changes, the first of which being a massive overhaul of the tournament's approach. During the time that had passed between the tournaments since the previous year, the King of Fighters tournament's fame had grown immensely, to the point that it turned into a major international event, which had not happened before. Huge corporations transformed the King of Fighters tournament into something widely televised, commercialized, and celebrated, drawing in many crowds from around the world. The tournament is now held by Chizuru Kagura: a descendant of the ancient Yata Clan responsible for sealing the Orochi demon along with the Kusanagi and Yasanaki clan (the clans from Kyo Kusanagi and Iori Yagami, respectively). Chizuru uses the tournament in hopes of finding and recruiting Kyo and Iori in order to stop the upcoming Orochi threat, but Kyo and Iori aren't exactly willing to work together on friendly terms.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [10], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 980, 'game_title' => "The King of Fighters '97", 'release_date' => '1997-09-25', 'platform' => 24, 'overview' => 'Despite the events at the end of the previous game, the KOF tournament was a huge commercial success and sparked a worldwide fighting craze. Within a few months of the tournament ending, various large corporations had held smaller KOF tournament qualifiers and constructed special KOF stadiums around the world, building the excitement up for the next tournament. News of the tournament spread through every form of media and fans and new fighters from across the globe come to watch the preliminary matches.', 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [10], 'publishers' => [60], 'alternates' => nil, 'uids' => nil, 'hashes' => nil },
    { 'id' => 981, 'game_title' => "The King of Fighters '99: Millennium Battle", 'release_date' => '1999-09-23', 'platform' => 24, 'overview' => "Two years have passed since the last King of Fighters tournament and no-one has seen Kyo Kusanagi or Iori Yagami since they defeated Orochi at the climax of the 1997 tournament, but out of the blue, new invitations are sent out to many characters, inviting them to a brand new tournament, though this competition is more of a secretive affair than the ones in '96 and '97. Unlike in previous games of the series, there are four characters per team instead of three. In total, there are seven teams, each containing four characters, four Team Edit characters and a boss.", 'youtube' => nil, 'players' => 2, 'coop' => 'No', 'rating' => nil, 'developers' => [7885], 'genres' => [10], 'publishers' => [60],