/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.media;

import java.io.IOException;
import java.io.InputStream;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.media.ParseException;
import org.signal.libsignal.media.SanitizedMetadata;
import org.signal.libsignal.media.TrustedSkipInputStream;

public class Mp4Sanitizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SanitizedMetadata sanitize(InputStream input, long length) throws IOException, ParseException {
        long sanitizedMetadataHandle = FilterExceptions.filterExceptions(IOException.class, ParseException.class, () -> Native.Mp4Sanitizer_Sanitize(TrustedSkipInputStream.makeTrusted(input), length));
        try {
            byte[] sanitizedMetadata = Native.SanitizedMetadata_GetMetadata(sanitizedMetadataHandle);
            if (sanitizedMetadata.length == 0) {
                sanitizedMetadata = null;
            }
            long dataOffset = Native.SanitizedMetadata_GetDataOffset(sanitizedMetadataHandle);
            long dataLength = Native.SanitizedMetadata_GetDataLen(sanitizedMetadataHandle);
            SanitizedMetadata sanitizedMetadata2 = new SanitizedMetadata(sanitizedMetadata, dataOffset, dataLength);
            return sanitizedMetadata2;
        }
        finally {
            Native.SanitizedMetadata_Destroy(sanitizedMetadataHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SanitizedMetadata sanitizeFileWithCompoundedMdatBoxes(InputStream input, long length, int cumulativeMdatBoxSize) throws IOException, ParseException {
        long sanitizedMetadataHandle = FilterExceptions.filterExceptions(IOException.class, ParseException.class, () -> Native.Mp4Sanitizer_Sanitize_File_With_Compounded_MDAT_Boxes(TrustedSkipInputStream.makeTrusted(input), length, cumulativeMdatBoxSize));
        try {
            byte[] sanitizedMetadata = Native.SanitizedMetadata_GetMetadata(sanitizedMetadataHandle);
            if (sanitizedMetadata.length == 0) {
                sanitizedMetadata = null;
            }
            long dataOffset = Native.SanitizedMetadata_GetDataOffset(sanitizedMetadataHandle);
            long dataLength = Native.SanitizedMetadata_GetDataLen(sanitizedMetadataHandle);
            SanitizedMetadata sanitizedMetadata2 = new SanitizedMetadata(sanitizedMetadata, dataOffset, dataLength);
            return sanitizedMetadata2;
        }
        finally {
            Native.SanitizedMetadata_Destroy(sanitizedMetadataHandle);
        }
    }
}

