/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.subscriptions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class ActiveSubscription {
    public static final String PAYMENT_METHOD_SEPA_DEBIT = "SEPA_DEBIT";
    public static final ActiveSubscription EMPTY = new ActiveSubscription(null, null);
    private final Subscription activeSubscription;
    private final ChargeFailure chargeFailure;

    @JsonCreator
    public ActiveSubscription(@JsonProperty(value="subscription") Subscription activeSubscription, @JsonProperty(value="chargeFailure") ChargeFailure chargeFailure) {
        this.activeSubscription = activeSubscription;
        this.chargeFailure = chargeFailure;
    }

    public Subscription getActiveSubscription() {
        return this.activeSubscription;
    }

    public ChargeFailure getChargeFailure() {
        return this.chargeFailure;
    }

    public boolean isActive() {
        return this.activeSubscription != null && this.activeSubscription.isActive();
    }

    public boolean isPendingBankTransfer() {
        return this.activeSubscription != null && Objects.equals((Object)this.activeSubscription.paymentMethod, PAYMENT_METHOD_SEPA_DEBIT) && this.activeSubscription.paymentPending;
    }

    public boolean isInProgress() {
        return this.activeSubscription != null && !this.isActive() && (!this.isFailedPayment() || this.isPastDue()) && !this.isCanceled();
    }

    public boolean isPastDue() {
        return this.activeSubscription != null && this.activeSubscription.isPastDue();
    }

    public boolean isFailedPayment() {
        return this.chargeFailure != null || this.activeSubscription != null && !this.isActive() && this.activeSubscription.isFailedPayment();
    }

    public boolean isCanceled() {
        return this.activeSubscription != null && this.activeSubscription.isCanceled();
    }

    public boolean willCancelAtPeriodEnd() {
        return this.activeSubscription == null || this.activeSubscription.willCancelAtPeriodEnd;
    }

    public static final class Subscription {
        private final int level;
        private final String currency;
        private final BigDecimal amount;
        private final long endOfCurrentPeriod;
        private final boolean isActive;
        private final long billingCycleAnchor;
        private final boolean willCancelAtPeriodEnd;
        private final String status;
        private final Processor processor;
        private final PaymentMethod paymentMethod;
        private final boolean paymentPending;

        @JsonCreator
        public Subscription(@JsonProperty(value="level") int level, @JsonProperty(value="currency") String currency, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="endOfCurrentPeriod") long endOfCurrentPeriod, @JsonProperty(value="active") boolean isActive, @JsonProperty(value="billingCycleAnchor") long billingCycleAnchor, @JsonProperty(value="cancelAtPeriodEnd") boolean willCancelAtPeriodEnd, @JsonProperty(value="status") String status, @JsonProperty(value="processor") String processor, @JsonProperty(value="paymentMethod") String paymentMethod, @JsonProperty(value="paymentPending") boolean paymentPending) {
            this.level = level;
            this.currency = currency;
            this.amount = amount;
            this.endOfCurrentPeriod = endOfCurrentPeriod;
            this.isActive = isActive;
            this.billingCycleAnchor = billingCycleAnchor;
            this.willCancelAtPeriodEnd = willCancelAtPeriodEnd;
            this.status = status;
            this.processor = Processor.fromCode(processor);
            this.paymentMethod = PaymentMethod.fromCode(paymentMethod);
            this.paymentPending = paymentPending;
        }

        public int getLevel() {
            return this.level;
        }

        public String getCurrency() {
            return this.currency;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public long getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public long getEndOfCurrentPeriod() {
            return this.endOfCurrentPeriod;
        }

        public boolean willCancelAtPeriodEnd() {
            return this.willCancelAtPeriodEnd;
        }

        public String getStatus() {
            return this.status;
        }

        public Processor getProcessor() {
            return this.processor;
        }

        public PaymentMethod getPaymentMethod() {
            return this.paymentMethod;
        }

        public boolean isPaymentPending() {
            return this.paymentPending;
        }

        public boolean isFailedPayment() {
            return Status.isPaymentFailed(this.getStatus());
        }

        public boolean isPastDue() {
            return Status.getStatus(this.getStatus()) == Status.PAST_DUE;
        }

        public boolean isCanceled() {
            return Status.getStatus(this.getStatus()) == Status.CANCELED;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Subscription that = (Subscription)o;
            return this.level == that.level && this.endOfCurrentPeriod == that.endOfCurrentPeriod && this.isActive == that.isActive && this.billingCycleAnchor == that.billingCycleAnchor && this.willCancelAtPeriodEnd == that.willCancelAtPeriodEnd && this.currency.equals(that.currency) && this.amount.equals(that.amount) && this.status.equals(that.status) && Objects.equals((Object)this.paymentMethod, (Object)that.paymentMethod) && this.paymentPending == that.paymentPending;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.level, this.currency, this.amount, this.endOfCurrentPeriod, this.isActive, this.billingCycleAnchor, this.willCancelAtPeriodEnd, this.status, this.paymentMethod, this.paymentPending});
        }
    }

    public static final class ChargeFailure {
        private final String code;
        private final String message;
        private final String outcomeNetworkStatus;
        private final String outcomeNetworkReason;
        private final String outcomeType;

        @JsonCreator
        public ChargeFailure(@JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="outcomeNetworkStatus") String outcomeNetworkStatus, @JsonProperty(value="outcomeNetworkReason") String outcomeNetworkReason, @JsonProperty(value="outcomeType") String outcomeType) {
            this.code = code;
            this.message = message;
            this.outcomeNetworkStatus = outcomeNetworkStatus;
            this.outcomeNetworkReason = outcomeNetworkReason;
            this.outcomeType = outcomeType;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getOutcomeNetworkStatus() {
            return this.outcomeNetworkStatus;
        }

        @Nullable
        public String getOutcomeNetworkReason() {
            return this.outcomeNetworkReason;
        }

        public String getOutcomeType() {
            return this.outcomeType;
        }

        public String toString() {
            return "ChargeFailure{code='" + this.code + "', outcomeNetworkStatus='" + this.outcomeNetworkStatus + "', outcomeNetworkReason='" + this.outcomeNetworkReason + "', outcomeType='" + this.outcomeType + "'}";
        }
    }

    public static enum PaymentMethod {
        UNKNOWN("UNKNOWN"),
        CARD("CARD"),
        PAYPAL("PAYPAL"),
        SEPA_DEBIT("SEPA_DEBIT"),
        IDEAL("IDEAL"),
        GOOGLE_PLAY_BILLING("GOOGLE_PLAY_BILLING"),
        APPLE_APP_STORE("APPLE_APP_STORE");

        private String code;

        private PaymentMethod(String code) {
            this.code = code;
        }

        static PaymentMethod fromCode(String code) {
            for (PaymentMethod method : PaymentMethod.values()) {
                if (!Objects.equals(method.code, code)) continue;
                return method;
            }
            return UNKNOWN;
        }
    }

    public static enum Status {
        TRIALING("trialing"),
        ACTIVE("active"),
        INCOMPLETE("incomplete"),
        INCOMPLETE_EXPIRED("incomplete_expired"),
        PAST_DUE("past_due"),
        CANCELED("canceled"),
        UNPAID("unpaid");

        private final String status;
        private static final Set<Status> FAILURE_STATUSES;

        private Status(String status) {
            this.status = status;
        }

        public static Status getStatus(String status) {
            for (Status s : Status.values()) {
                if (!Objects.equals(status, s.status)) continue;
                return s;
            }
            throw new IllegalArgumentException("Unknown status " + status);
        }

        static boolean isPaymentFailed(String status) {
            return FAILURE_STATUSES.contains((Object)Status.getStatus(status));
        }

        static {
            FAILURE_STATUSES = new HashSet<Status>(Arrays.asList(INCOMPLETE_EXPIRED, PAST_DUE, UNPAID));
        }
    }

    public static enum Processor {
        STRIPE("STRIPE"),
        BRAINTREE("BRAINTREE"),
        GOOGLE_PLAY_BILLING("GOOGLE_PLAY_BILLING");

        private final String code;

        private Processor(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        static Processor fromCode(String code) {
            for (Processor value : Processor.values()) {
                if (!value.code.equals(code)) continue;
                return value;
            }
            return STRIPE;
        }
    }
}

