/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.UUID;
import org.asamk.signal.json.JsonCallMessage;
import org.asamk.signal.json.JsonDataMessage;
import org.asamk.signal.json.JsonEditMessage;
import org.asamk.signal.json.JsonReceiptMessage;
import org.asamk.signal.json.JsonStoryMessage;
import org.asamk.signal.json.JsonSyncMessage;
import org.asamk.signal.json.JsonTypingMessage;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.UntrustedIdentityException;

public record JsonMessageEnvelope(@Deprecated String source, String sourceNumber, String sourceUuid, String sourceName, Integer sourceDevice, long timestamp, long serverReceivedTimestamp, long serverDeliveredTimestamp, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonDataMessage dataMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonEditMessage editMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonStoryMessage storyMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonSyncMessage syncMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonCallMessage callMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonReceiptMessage receiptMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonTypingMessage typingMessage) {
    public static JsonMessageEnvelope from(MessageEnvelope envelope, Throwable exception, Manager m) {
        String sourceName;
        String sourceUuid;
        String sourceNumber;
        String source;
        Integer sourceDevice;
        RecipientAddress sourceAddress;
        if (envelope.sourceAddress().isPresent()) {
            sourceAddress = (RecipientAddress)envelope.sourceAddress().get();
            sourceDevice = envelope.sourceDevice();
        } else if (exception instanceof UntrustedIdentityException) {
            UntrustedIdentityException e = (UntrustedIdentityException)exception;
            sourceAddress = e.getSender();
            sourceDevice = e.getSenderDevice();
        } else {
            sourceAddress = null;
            sourceDevice = null;
        }
        if (sourceAddress != null) {
            source = sourceAddress.getLegacyIdentifier();
            sourceNumber = sourceAddress.number().orElse(null);
            sourceUuid = sourceAddress.uuid().map(UUID::toString).orElse(null);
            sourceName = m.getContactOrProfileName(RecipientIdentifier.Single.fromAddress((RecipientAddress)sourceAddress));
        } else {
            source = null;
            sourceNumber = null;
            sourceUuid = null;
            sourceName = null;
        }
        long timestamp = envelope.timestamp();
        long serverReceivedTimestamp = envelope.serverReceivedTimestamp();
        long serverDeliveredTimestamp = envelope.serverDeliveredTimestamp();
        JsonReceiptMessage receiptMessage = envelope.receipt().map(JsonReceiptMessage::from).orElse(null);
        JsonTypingMessage typingMessage = envelope.typing().map(JsonTypingMessage::from).orElse(null);
        JsonDataMessage dataMessage = envelope.data().map(data -> JsonDataMessage.from(data, m)).orElse(null);
        JsonEditMessage editMessage = envelope.edit().map(data -> JsonEditMessage.from(data, m)).orElse(null);
        JsonStoryMessage storyMessage = envelope.story().map(JsonStoryMessage::from).orElse(null);
        JsonSyncMessage syncMessage = envelope.sync().map(data -> JsonSyncMessage.from(data, m)).orElse(null);
        JsonCallMessage callMessage = envelope.call().map(JsonCallMessage::from).orElse(null);
        return new JsonMessageEnvelope(source, sourceNumber, sourceUuid, sourceName, sourceDevice, timestamp, serverReceivedTimestamp, serverDeliveredTimestamp, dataMessage, editMessage, storyMessage, syncMessage, callMessage, receiptMessage, typingMessage);
    }
}

