## FAQs
1. [[FAQs]]
1. [[Audits]]
1. [[Supporting upstream development|Supporting-upstream]]

### Troubleshooting
1. [[Logging|Logging]]
1. [[Bitwarden Android troubleshooting|Bitwarden-Android-troubleshooting]]

## Container Image Usage
1. [[Which container image to use|Which-Container-image-to-use]]
1. [[Starting a container|Starting-a-container]]
1. [[Using Docker Compose|Using-Docker-Compose]]
1. [[Using Podman|Using-Podman]]
1. [[Updating the vaultwarden image|Updating-the-vaultwarden-image]]

## Reverse Proxy
1. [[Proxy examples|Proxy-examples]]
1. [[Using an alternate base dir (subdir/subpath)|Using-an-alternate-base-dir]]

### HTTPS
1. [[Enabling HTTPS|Enabling-HTTPS]]
1. [[Running a private vaultwarden instance with Let's Encrypt certs]]

## Configuration
1. [[Overview|Configuration-overview]]
1. [[Enabling admin page|Enabling-admin-page]]
1. [[SMTP configuration|SMTP-configuration]]
1. [[Disable registration of new users|Disable-registration-of-new-users]]
1. [[Disable invitations|Disable-invitations]]
1. [[Enabling WebSocket notifications|Enabling-WebSocket-notifications]]
1. [[Enabling Mobile Client push notification|Enabling-Mobile-Client-push-notification]]
1. [[Enabling SSO support using OpenId Connect|Enabling-SSO-support-using-OpenId-Connect]]
1. [[Other configuration|Other-configuration]]

### Database
1. [[Using the MariaDB (MySQL) Backend]]
1. [[Using the PostgreSQL Backend]]
1. [[Running without WAL enabled|Running-without-WAL-enabled]]
1. [[Migrating from MariaDB (MySQL) to SQLite]]

### Security
1. [[Hardening Guide|Hardening Guide]]
1. [[Password hint display|Password-hint-display]]
1. [[Enabling U2F and FIDO2 WebAuthn authentication|Enabling-U2F-(and-FIDO2-WebAuthn)-authentication]]
1. [[Enabling YubiKey OTP authentication|Enabling-Yubikey-OTP-authentication]]
1. [[Fail2Ban Setup|Fail2Ban-Setup]]
1. [[Fail2Ban + ModSecurity + Traefik + Docker|Docker---Traefik---ModSecurity-Setup]]

### Performance
1. [[Changing the API request size limit|Changing-the-API-request-size-limit]]
1. [[Changing the number of workers|Changing-the-number-of-workers]]

## Customization
1. [[Translating the email templates]]
1. [[Translating admin page]]
1. [[Customize Vaultwarden CSS]]
1. [[Using custom website icons]]
1. [[Disabling or overriding the Vault interface hosting|Disabling-or-overriding-the-Vault-interface-hosting]]

## Backup
1. [[General (not docker)]]
1. [[Backing up your vault|Backing-up-your-vault]]

## Development
1. [[Building binary|Building-binary]]
1. [[Building your own docker image|Building-your-own-docker-image]]
1. [[Git hooks]]
1. [[Differences from the upstream API implementation|Differences-from-the-upstream-API-implementation]]

## Alternative deployments
1. [[Pre-built binaries|Pre-built-binaries]]
1. [[Creating a systemd service|Setup-as-a-systemd-service]]
1. [[Third-party packages|Third-party-packages]]
1. [[Deployment examples|Deployment-examples]]
1. [[Disable the admin token|Disable-admin-token]]

## Other Information
1. [[Importing data from Keepass or KeepassX|Importing-data-from-Keepass-or-KeepassX]]
1. [[Changing persistent data location|Changing-persistent-data-location]]
1. [[Syncing users from LDAP|Syncing-users-from-LDAP]]
1. [[Caddy 2.x with Cloudflare DNS]]
1. [[Logrotate example|Logrotate example]]
