# rizin-shell-parser

This is the parser for rizin shell language.
See https://tree-sitter.github.io/tree-sitter/creating-parsers for more info on
how to create a parser with tree-sitter.

## Sources
- grammar.js: defines the basic grammar
- src/scanner.c: external scanner used to scan some tokens that cannot be parsed
  with the regular js grammar, as that includes only the context-free part of
  the language.
- src/parser.c: this file is auto-generated by tree-sitter based on grammar.js
- corpus/\*: list of test files used to ensure the grammar works well

## How to update grammar
When you update something in grammar.js or src/scanner.c you have to re-generate
the parser. The process works as follows:

1. Do changes as needed to grammar.js and/or src/scanner.c
2. Install npm dependencies with: `cd subprojects/rizin-shell-parser ; npm install`
3. Re-generate the parser files: `npx tree-sitter generate`
4. Check tests still pass: `npx tree-sitter test`. Use `npx tree-sitter parse
   ./example-file` if you want to see the syntax tree of a custom input provided
   in `./example-file`
5. Commit auto-generated files and modified grammar.js and src/scanner.c into git.
