/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;

final class DescendantIterator
extends AxisIteratorImpl {
    private TinyTree tree;
    private TinyNodeImpl startNode;
    private int nextNodeNr;
    private int startDepth;
    private NodeTest test;

    DescendantIterator(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest) {
        this.tree = doc;
        this.startNode = node;
        this.test = nodeTest;
        this.nextNodeNr = node.nodeNr;
        this.startDepth = doc.depth[this.nextNodeNr];
    }

    public NodeInfo next() {
        do {
            ++this.nextNodeNr;
            try {
                if (this.tree.depth[this.nextNodeNr] <= this.startDepth) {
                    this.nextNodeNr = -1;
                    return null;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.nextNodeNr = -1;
                return null;
            }
        } while (!this.test.matches(this.tree, this.nextNodeNr));
        return this.tree.getNode(this.nextNodeNr);
    }

    public AxisIterator getAnother() {
        return new DescendantIterator(this.tree, this.startNode, this.test);
    }
}

