/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class Idref
extends SystemFunctionCall
implements Callable {
    private KeyDefinitionSet idRefKey;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Idref f = (Idref)super.simplify(visitor);
        f.addContextDocumentArgument(1, "idref");
        return f;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.typeCheck(visitor, contextInfo);
        this.idRefKey = visitor.getStaticContext().getKeyManager().getKeyDefinitionSet(StandardNames.getStructuredQName(562));
        return e;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        this.argument[0] = this.argument[0].unordered(false, false);
    }

    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Expression copy() {
        Idref i2 = (Idref)super.copy();
        i2.idRefKey = this.idRefKey;
        return i2;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        target = target.createArc((byte)4, AnyNodeTest.getInstance());
        return target;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        NodeInfo arg2 = (NodeInfo)this.argument[1].evaluateItem(context);
        assert (arg2 != null);
        if ((arg2 = arg2.getRoot()).getNodeKind() != 9) {
            this.dynamicError("In the idref() function, the tree being searched must be one whose root is a document node", "FODC0001", context);
            return EmptyIterator.emptyIterator();
        }
        DocumentInfo doc = (DocumentInfo)arg2;
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            SequenceIterator keys = this.argument[0].iterate(context);
            return Idref.getIdrefMultiple(doc, keys, context);
        }
        AtomicValue keyValue = (AtomicValue)this.argument[0].evaluateItem(context);
        if (keyValue == null) {
            return EmptyIterator.emptyIterator();
        }
        KeyManager keyManager = controller.getKeyManager();
        return keyManager.selectByKey(this.idRefKey, doc, keyValue, context);
    }

    public static SequenceIterator getIdrefMultiple(DocumentInfo doc, SequenceIterator keys, XPathContext context) throws XPathException {
        IdrefMappingFunction map = new IdrefMappingFunction();
        map.document = doc;
        map.keyContext = context;
        map.keyManager = context.getController().getKeyManager();
        map.keySet = map.keyManager.getKeyDefinitionSet(StandardNames.getStructuredQName(562));
        MappingIterator<StringValue, NodeInfo> allValues = new MappingIterator<StringValue, NodeInfo>(keys, map);
        return new DocumentOrderIterator(allValues, LocalOrderComparer.getInstance());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo start = arguments.length == 1 ? this.getContextNode(context) : (NodeInfo)arguments[1].head();
        NodeInfo arg2 = start.getRoot();
        if (arg2.getNodeKind() != 9) {
            this.dynamicError("In the idref() function, the tree being searched must be one whose root is a document node", "FODC0001", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)arg2;
        return SequenceTool.toLazySequence(Idref.getIdrefMultiple(doc, arguments[0].iterate(), context));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdrefMappingFunction
    implements MappingFunction<StringValue, NodeInfo> {
        public DocumentInfo document;
        public XPathContext keyContext;
        public KeyManager keyManager;
        public KeyDefinitionSet keySet;

        private IdrefMappingFunction() {
        }

        @Override
        public SequenceIterator map(StringValue item) throws XPathException {
            KeyManager keyManager = this.keyContext.getController().getKeyManager();
            return keyManager.selectByKey(this.keySet, this.document, item, this.keyContext);
        }
    }
}

