# Goals

There are many conflicting priorities in an open-source project like this
(performance, ergonomics, understandability, portability, ...), but the
following two can be seen as the guiding principles for everything else in
this project.


## 1. Complete Soundness

The non-negotiable goal of these crates is to be completely "sound", meaning
it **must not be possible for safe Rust to cause undefined behaviour**!

As of January 2023, I (`@madsmtm`) have yet to find a single Rust crate or
project calling Objective-C soundly. Issues I have found include:
- Wrong method calling ABI.
- Wrong memory management (in the best cases they just leak a lot).
- Incorrect usage of `&mut`.
- Incorrect main-thread safety.

I don't state this to throw shade at these projects, it is very much
understandable! Objective-C and Rust have vastly different semantics, so
tackling these issues require vigilance and a focus that e.g. a system
clipboard crate just doesn't have!

Rather, I state it to provide reassurance: Rust's fearless concurrency can be
won back! This project's [approach to the issue][layered-safety] _works_,
and leaks, segfaults, race conditions and so on _can_ be completely
eliminated!

Needless to say, nothing is perfect, so if you think you've found a soundness
hole, please don't hesitate to report it on the [issue tracker]. Known
soundness holes (however theoretical) are tracked in the [`I-unsound`] label.

[layered-safety]: crate::topics::layered_safety
[`I-unsound`]: https://github.com/madsmtm/objc2/labels/I-unsound
[issue tracker]: https://github.com/madsmtm/objc2/issues/new


## 2. Idiomatic Rust

Soundness would be easy to achieve if we just marked every API as `unsafe`,
and called it a day (the precursor to this, `objc`, is basically sound).
However, that just pushes the burden onto you, the user, and then we're not
much better off!

As such, we'll try to be as safe and idiomatic as possible; using references
instead of pointers to represent objects and their (interior) mutability, `Option`
instead of `null`, doing memory management automatically instead of manually,
and so on (see again [these notes on "Layered Safety"][layered-safety]). These
abstractions should ideally be zero-cost, but this is of course a balancing
act against being ergonomic.

Some APIs in `objc2` and `block2` will still have to remain `unsafe`, so these
contain thorough `# Safety` sections, to let you know exactly which safety
guarantees you need to uphold.
The framework crates are a bit difficult in this regard, since they are mostly
autogenerated, which means that almost nothing can be safe by default!
However, we can still try to mitigate this problem by marking manually audited
functionality as safe.
