/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SubstringBefore
extends CollatingFunction
implements Callable {
    protected int getCollationArgument() {
        return 2;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        StringValue arg1 = (StringValue)this.argument[1].evaluateItem(context);
        if (arg1 == null || arg1.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        StringValue arg0 = (StringValue)this.argument[0].evaluateItem(context);
        if (arg0 == null || arg0.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        StringCollator collator = this.getCollator(context);
        return this.substringBefore(context, arg0, arg1, collator);
    }

    private StringValue substringBefore(XPathContext context, StringValue arg0, StringValue arg1, StringCollator collator) throws XPathException {
        StringValue result;
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (collator instanceof CodepointCollator) {
            int j = s0.indexOf(s1);
            result = j < 0 ? StringValue.EMPTY_STRING : new StringValue(s0.substring(0, j));
        } else {
            if (collator instanceof SimpleCollation && ((SimpleCollation)collator).getCollation() instanceof RuleBasedCollator) {
                collator = new RuleBasedSubstringMatcher((RuleBasedCollator)((SimpleCollation)collator).getCollation());
            }
            if (collator instanceof SubstringMatcher) {
                result = new StringValue(((SubstringMatcher)collator).substringBefore(s0, s1));
            } else {
                this.dynamicError("The collation requested for " + this.getDisplayName() + " does not support substring matching", "FOCH0004", context);
                return null;
            }
        }
        if (arg0.isKnownToContainNoSurrogates()) {
            result.setContainsNoSurrogates();
        }
        return result;
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg1 = (StringValue)arguments[1].head();
        if (arg1 == null || arg1.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        StringValue arg0 = (StringValue)arguments[0].head();
        if (arg0 == null || arg0.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        StringCollator collator = this.getCollatorFromLastArgument(arguments, 2, context);
        return this.substringBefore(context, arg0, arg1, collator);
    }
}

