// generated by Fast Light User Interface Designer (fluid) version 1.0403

#include "confdialog.h"
#include "gettext.h"
#ifndef gettext_noop
#  define gettext_noop(text) text
#endif
#include <config.h>
#include <FL/Fl_Tooltip.H>
#include <FL/Fl_Box.H>
#include <FL/filename.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/fl_show_colormap.H>
#include <vector>
#include "main.h"
#include "fl_digi.h"
#include "data_io.h"
#include "Viewer.h"
#include "soundconf.h"
#include "waterfall.h"
#include "rigxml.h"
#include "lookupcall.h"
#include "icons.h"
#include "Viewer.h"
#include "pskrep.h"
#include "logsupport.h"
#include "notify.h"
#include "debug.h"
#include "status.h"
#include "rx_extract.h"
#include "kmlserver.h"
#include "macroedit.h"
#include "fileselect.h"
#include "psm/psm.h"
#include "thor.h"
#include "ifkp.h"
#include "dx_cluster.h"
#include "dx_dialog.h"
#include "fsq.h"
#include "network.h"
#include "ui_colors.h"
#include "wefax.h"
#if USE_HAMLIB
  #include "hamlib.h"
#endif
extern void WefaxDestDirSet(Fl_File_Chooser *w, void *userdata);
Fl_Double_Window *dlgConfig;
Mode_Browser* mode_browser;
std::vector<CONFIG_PAGE *> config_pages;
static Fl_Group *current = 0;

void SelectItem_CB(Fl_Widget *w) {
  Fl_Tree *tree = (Fl_Tree*)w;
  Fl_Tree_Item *item = tree->callback_item();
  tree->select_only(item, 0);
    
  if (tree->callback_reason() == FL_TREE_REASON_SELECTED) {
    std::string pname;
    char pn[200];
    tree->item_pathname(pn, 200, item);
    pname = pn;
    size_t pos = std::string::npos;
    for (size_t i = 0; i < config_pages.size(); i++) {
      if ((pos = pname.find(config_pages[i]->label)) != std::string::npos) {
        if (pname.substr(pos) == config_pages[i]->label) {
          if (current) current->hide();
          current = config_pages[i]->grp;
          current->show();
          return;
        }
      }
    }
  }
}

static void cbMenuFontBrowser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
  int size = font_browser->fontSize();

  progdefaults.MenuFontnbr = font;
  progdefaults.MenuFontsize = size;
  //progdefaults.MenuFontcolor = color;

  font_browser->hide();
  change_menu_fonts(font, size);

  progdefaults.changed = true;
}

static void cbRxFontBrowser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
      int size = font_browser->fontSize();
      Fl_Color color = font_browser->fontColor();

      RxText->textfont(font);
      RxText->textsize(size);
      RxText->textcolor(color);
      RxText->redraw();

      progdefaults.RxFontnbr = font;
      progdefaults.RxFontsize = size;
      Fl::get_color( color, ui_colors.RxFontcolor.r, ui_colors.RxFontcolor.g, ui_colors.RxFontcolor.b );

      ReceiveText->setFont(font);
      ReceiveText->setFontSize(size);
      ReceiveText->setFontColor( RGBCOLOR( RxFontcolor ), FTextBase::RECV);

      fsq_rx_text->setFont(font);
      fsq_rx_text->setFontSize(size);
      fsq_rx_text->setFontColor( RGBCOLOR( RxFontcolor ), FTextBase::RECV);

      ifkp_rx_text->setFont(font);
      ifkp_rx_text->setFontSize(size);
      ifkp_rx_text->setFontColor( RGBCOLOR( RxFontcolor ), FTextBase::RECV);

      font_browser->hide();

      progdefaults.changed = true;
}

static void cbTxFontBrowser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
      int size = font_browser->fontSize();
      Fl_Color color = font_browser->fontColor();

      TxText->textfont(font);
      TxText->textsize(size);
      TxText->textcolor(color);
      TxText->redraw();

      progdefaults.TxFontnbr = font;
      progdefaults.TxFontsize = size;
      Fl::get_color( color, ui_colors.TxFontcolor.r, ui_colors.TxFontcolor.g, ui_colors.TxFontcolor.b );

      TransmitText->setFont(font);
      TransmitText->setFontSize(size);
      TransmitText->setFontColor( RGBCOLOR( TxFontcolor ), FTextBase::RECV);

      fsq_tx_text->setFont(font);
      fsq_tx_text->setFontSize(size);
      fsq_tx_text->setFontColor( RGBCOLOR( RxFontcolor ), FTextBase::RECV);

      ifkp_rx_text->setFont(font);
      ifkp_rx_text->setFontSize(size);
      ifkp_rx_text->setFontColor( RGBCOLOR( RxFontcolor ), FTextBase::RECV);

       font_browser->hide();

      progdefaults.changed = true;
}

static void cbDXfont_browser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
  int size = font_browser->fontSize();
  Fl_Color color = font_browser->fontColor();

  Fl::get_color( color, ui_colors.DXfontcolor.r, ui_colors.DXfontcolor.g, ui_colors.DXfontcolor.b );

  progdefaults.DXfontnbr = font;
  progdefaults.DXfontsize = size;

  brws_tcpip_stream->setFont(font);
  brws_tcpip_stream->setFontSize(size);
  brws_tcpip_stream->setFontColor(color, FTextBase::RECV);
  brws_tcpip_stream->redraw();

  ed_telnet_cmds->setFont(font);
  ed_telnet_cmds->setFontSize(size);
  ed_telnet_cmds->setFontColor(color);
  ed_telnet_cmds->redraw();

  StreamText->textcolor(color);
  StreamText->redraw();

  brws_dxc_help->color( RGBCOLOR( DX_Color ) );
  brws_dxc_help->setFont(font);
  brws_dxc_help->setFontSize(size);
  brws_dxc_help->setFontColor(color, FTextBase::RECV);
  brws_dxc_help->redraw();
         
  font_browser->hide();

  dxcluster_hosts_load();

  progdefaults.changed = true;
}

static void cbDXC_FontBrowser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
      int size = font_browser->fontSize();
      Fl_Color color = font_browser->fontColor();

      progdefaults.DXC_textfont = font;
      progdefaults.DXC_textsize = size;

      Fl::get_color( color, ui_colors.DXC_textcolor.r, ui_colors.DXC_textcolor.g, ui_colors.DXC_textcolor.b );

      DXC_display->textsize(size);
      DXC_display->textcolor(color);
      DXC_display->textfont(font);
      DXC_display->redraw();

      font_browser->hide();

      dxc_lines_redraw();

      progdefaults.changed = true;
}

static void cbMacroEditFontBrowser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
      int size = font_browser->fontSize();

      MacroText->textfont(font);
      MacroText->textsize(size);
      MacroText->redraw();

      progdefaults.MacroEditFontnbr = font;
      progdefaults.MacroEditFontsize = size;

      update_macroedit_font();

      MacroText->textfont(font);
      MacroText->textsize(size);

      font_browser->hide();

      progdefaults.changed = true;
}

void cbWaterfallFontBrowser(Fl_Widget*, void*) {
  Fl_Font fnt = font_browser->fontNumber();
      int size = font_browser->fontSize();

      progdefaults.WaterfallFontnbr = fnt;
      progdefaults.WaterfallFontsize = size;
      progdefaults.changed = true;

      font_browser->hide();
}

static void cbMacroBtnFontBrowser(Fl_Widget*, void*) {
  progdefaults.MacroBtnFontnbr = font_browser->fontNumber();
      progdefaults.MacroBtnFontsize = font_browser->fontSize();
      Fl_Color color = font_browser->fontColor();
      Fl::get_color (color , ui_colors.MacroBtnFontcolor.r, ui_colors.MacroBtnFontcolor.g, ui_colors.MacroBtnFontcolor.b );

      font_browser->hide();

      btnGroup1->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      btnGroup1->labelfont(progdefaults.MacroBtnFontnbr);
      btnGroup1->labelsize(progdefaults.MacroBtnFontsize);
      btnGroup1->redraw_label();

      btnGroup2->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      btnGroup2->labelfont(progdefaults.MacroBtnFontnbr);
      btnGroup2->labelsize(progdefaults.MacroBtnFontsize);
      btnGroup2->redraw_label();

      btnGroup3->labelcolor( RGBCOLOR( MacroBtnFontcolor ));
      btnGroup3->labelfont(progdefaults.MacroBtnFontnbr);
      btnGroup3->labelsize(progdefaults.MacroBtnFontsize);
      btnGroup3->redraw_label();

      progdefaults.changed = true;
      colorize_macros();
}

void cbViewerFontBrowser(Fl_Widget*, void*) {
  progdefaults.ViewerFontnbr = font_browser->fontNumber();
      progdefaults.ViewerFontsize = font_browser->fontSize();
      initViewer();
      progdefaults.changed = true;

      font_browser->hide();
}

void cbFreqControlFontBrowser(Fl_Widget*, void*) {
  Fl_Font fnt = font_browser->fontNumber();
      progdefaults.FreqControlFontnbr = fnt;
      progdefaults.changed = true;

      FDdisplay->labelfont(progdefaults.FreqControlFontnbr);
      FDdisplay->redraw();
      qsoFreqDisp1->font(progdefaults.FreqControlFontnbr);
      qsoFreqDisp2->font(progdefaults.FreqControlFontnbr);
      qsoFreqDisp3->font(progdefaults.FreqControlFontnbr);
      qsoFreqDisp1->redraw();
      qsoFreqDisp2->redraw();
      qsoFreqDisp3->redraw();

      font_browser->hide();
}

static void cbLOGGINGFontBrowser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
      int size = font_browser->fontSize();
      Fl_Color color = font_browser->fontColor();

      progdefaults.LOGGINGtextfont = font;
      progdefaults.LOGGINGtextsize = size;

      Fl::get_color( color, ui_colors.LOGGINGtextcolor.r, ui_colors.LOGGINGtextcolor.g, ui_colors.LOGGINGtextcolor.b );

      LOGGINGdisplay->textsize(size);
      LOGGINGdisplay->textcolor(color);
      LOGGINGdisplay->textfont(font);
      LOGGINGdisplay->redraw();

      LOGGING_colors_font();

      font_browser->hide();

      progdefaults.changed = true;
}

static void cbLOGBOOKFontBrowser(Fl_Widget*, void*) {
  Fl_Font font = font_browser->fontNumber();
      int size = font_browser->fontSize();
      Fl_Color color = font_browser->fontColor();

      progdefaults.LOGBOOKtextfont = font;
      progdefaults.LOGBOOKtextsize = size;

      Fl::get_color( color, ui_colors.LOGBOOKtextcolor.r, ui_colors.LOGBOOKtextcolor.g, ui_colors.LOGBOOKtextcolor.b );

      LOGBOOKdisplay->textsize(size);
      LOGBOOKdisplay->textcolor(color);
      LOGBOOKdisplay->textfont(font);
      LOGBOOKdisplay->redraw();

      LOGBOOK_colors_font();

      font_browser->hide();

      progdefaults.changed = true;
}

void set_qrzxml_buttons(Fl_Button* b) {
  Fl_Button* qrzbxml[] = { btnQRZXMLnotavailable, btnQRZcdrom, btnQRZsub,
                           btnHamcall,
                           btnCALLOOK, btnHamQTH};

  for (size_t i = 0; i < sizeof(qrzbxml)/sizeof(*qrzbxml); i++)
  	qrzbxml[i]->value(b == qrzbxml[i]);
}

void set_qrzweb_buttons(Fl_Button* b) {
  Fl_Button* qrzbweb[] = { btnQRZWEBnotavailable, btnQRZonline,
                                btnHAMCALLonline,
                                btnHamQTHonline, btnCallookOnline };

  for (size_t i = 0; i < sizeof(qrzbweb)/sizeof(*qrzbweb); i++)
  	qrzbweb[i]->value(b == qrzbweb[i]);
}

void createConfig() {
  if (!dlgConfig) {
      dlgConfig = ConfigureDialog();
      dlgConfig->xclass(PACKAGE_NAME);
    }
}

Fl_Tree *tab_tree=(Fl_Tree *)0;

Fl_Button *btn_collapse_tab_tree=(Fl_Button *)0;

static void cb_btn_collapse_tab_tree(Fl_Button*, void*) {
  tab_tree->close(_("Colors-Fonts"));
  tab_tree->close(_("Contests"));
  tab_tree->close(_("IDs"));
  tab_tree->close(_("Logging"));
  tab_tree->close(_("Modem"));
  tab_tree->close(_("Misc"));
  tab_tree->close(_("Rig Control"));
  tab_tree->close(_("Soundcard"));
  tab_tree->close(_("UI"));
  tab_tree->close(_("Waterfall"));
  tab_tree->close(_("Web"));
}

Fl_Round_Button *btnQRZWEBnotavailable=(Fl_Round_Button *)0;

static void cb_btnQRZWEBnotavailable(Fl_Round_Button* o, void*) {
  set_qrzweb_buttons(o);
  progdefaults.QRZWEB = QRZWEBNONE;
  progdefaults.changed = true;
}

Fl_Round_Button *btnQRZonline=(Fl_Round_Button *)0;

static void cb_btnQRZonline(Fl_Round_Button* o, void*) {
  set_qrzweb_buttons(o);
  progdefaults.QRZWEB = QRZHTML;
  progdefaults.changed = true;
}

Fl_Round_Button *btnHAMCALLonline=(Fl_Round_Button *)0;

static void cb_btnHAMCALLonline(Fl_Round_Button* o, void*) {
  set_qrzweb_buttons(o);
  progdefaults.QRZWEB = HAMCALLHTML;
  progdefaults.changed = true;
}

Fl_Round_Button *btnHamQTHonline=(Fl_Round_Button *)0;

static void cb_btnHamQTHonline(Fl_Round_Button* o, void*) {
  set_qrzweb_buttons(o);
  progdefaults.QRZWEB = HAMQTHHTML;
  progdefaults.changed = true;
}

Fl_Round_Button *btnCallookOnline=(Fl_Round_Button *)0;

static void cb_btnCallookOnline(Fl_Round_Button* o, void*) {
  set_qrzweb_buttons(o);
  progdefaults.QRZWEB = CALLOOKHTML;
  progdefaults.changed = true;
}

Fl_Input2 *inp_qrzurl=(Fl_Input2 *)0;

static void cb_inp_qrzurl(Fl_Input2* o, void*) {
  progdefaults.qrzurl = o->value();
  progdefaults.changed=true;
}

Fl_Input2 *inp_hamcallurl=(Fl_Input2 *)0;

static void cb_inp_hamcallurl(Fl_Input2* o, void*) {
  progdefaults.hamcallurl = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inp_hamqthurl=(Fl_Input2 *)0;

static void cb_inp_hamqthurl(Fl_Input2* o, void*) {
  progdefaults.hamqthurl = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inp_callook_url=(Fl_Input2 *)0;

static void cb_inp_callook_url(Fl_Input2* o, void*) {
  progdefaults.callookurl = o->value();
  progdefaults.changed = true;
}

Fl_Round_Button *btnQRZXMLnotavailable=(Fl_Round_Button *)0;

static void cb_btnQRZXMLnotavailable(Fl_Round_Button* o, void*) {
  set_qrzxml_buttons(o);
  progdefaults.QRZXML = QRZXMLNONE;
  progdefaults.changed = true;
}

Fl_Round_Button *btnQRZcdrom=(Fl_Round_Button *)0;

static void cb_btnQRZcdrom(Fl_Round_Button* o, void*) {
  set_qrzxml_buttons(o);
  progdefaults.QRZXML = QRZCD;
  progdefaults.changed = true;
}

Fl_Round_Button *btnQRZsub=(Fl_Round_Button *)0;

static void cb_btnQRZsub(Fl_Round_Button* o, void*) {
  set_qrzxml_buttons(o);
  progdefaults.QRZXML = QRZNET;
  progdefaults.changed = true;
}

Fl_Round_Button *btnHamcall=(Fl_Round_Button *)0;

static void cb_btnHamcall(Fl_Round_Button* o, void*) {
  set_qrzxml_buttons(o);
  progdefaults.QRZXML = HAMCALLNET;
  progdefaults.changed = true;
}

Fl_Round_Button *btnHamQTH=(Fl_Round_Button *)0;

static void cb_btnHamQTH(Fl_Round_Button* o, void*) {
  set_qrzxml_buttons(o);
  progdefaults.QRZXML = HAMQTH;
  progdefaults.changed = true;
}

Fl_Round_Button *btnCALLOOK=(Fl_Round_Button *)0;

static void cb_btnCALLOOK(Fl_Round_Button* o, void*) {
  set_qrzxml_buttons(o);
  progdefaults.QRZXML = CALLOOK;
  progdefaults.changed = true;
}

Fl_Input2 *txtQRZpathname=(Fl_Input2 *)0;

static void cb_txtQRZpathname(Fl_Input2* o, void*) {
  progdefaults.QRZpathname = o->value();
  progdefaults.QRZchanged = true;
  progdefaults.changed = true;
}

Fl_Input2 *inpQRZusername=(Fl_Input2 *)0;

static void cb_inpQRZusername(Fl_Input2* o, void*) {
  progdefaults.QRZusername = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpQRZuserpassword=(Fl_Input2 *)0;

static void cb_inpQRZuserpassword(Fl_Input2* o, void*) {
  progdefaults.QRZuserpassword = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnQRZpasswordShow=(Fl_Button *)0;

static void cb_btnQRZpasswordShow(Fl_Button* o, void*) {
  inpQRZuserpassword->type(inpQRZuserpassword->type() ^ FL_SECRET_INPUT);
  inpQRZuserpassword->redraw();
  o->label((inpQRZuserpassword->type() & FL_SECRET_INPUT) ? "Show" : "Hide");
}

Fl_Check_Button *btn_notes_address=(Fl_Check_Button *)0;

static void cb_btn_notes_address(Fl_Check_Button* o, void*) {
  progdefaults.notes_address = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_clear_notes=(Fl_Check_Button *)0;

static void cb_btn_clear_notes(Fl_Check_Button* o, void*) {
  progdefaults.clear_notes = o->value();
  progdefaults.changed= true;
}

Fl_Input2 *txt_cty_dat_pathname=(Fl_Input2 *)0;

static void cb_txt_cty_dat_pathname(Fl_Input2* o, void*) {
  progdefaults.cty_dat_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_cty_dat=(Fl_Button *)0;

static void cb_btn_select_cty_dat(Fl_Button*, void*) {
  select_cty_dat_pathname();
}

Fl_Button *btn_default_cty_dat=(Fl_Button *)0;

static void cb_btn_default_cty_dat(Fl_Button*, void*) {
  default_cty_dat_pathname();
}

Fl_Button *btn_reload_cty_dat=(Fl_Button *)0;

static void cb_btn_reload_cty_dat(Fl_Button*, void*) {
  reload_cty_dat();
}

Fl_Button *btnSpotColor=(Fl_Button *)0;

static void cb_btnSpotColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.SpotColor;
  if (fl_color_chooser("Spot color", clr.r, clr.g, clr.b )) {
    ui_colors.SpotColor = clr;
    spotcolor->color( RGBCOLOR( SpotColor ));
    spotcolor->redraw();
    spot_selection_color();
    progdefaults.changed = true;}
}

Fl_Button *btnRevColor=(Fl_Button *)0;

static void cb_btnRevColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.RevColor;
  if (fl_color_chooser("Rev color", clr.r, clr.g, clr.b )) {
    ui_colors.RevColor = clr;
    revcolor->color( RGBCOLOR( RevColor ) );
    revcolor->redraw();
    rev_selection_color();
    progdefaults.changed = true;}
}

Fl_Button *btnTuneColor=(Fl_Button *)0;

static void cb_btnTuneColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.TuneColor;
  if (fl_color_chooser("Tune color", clr.r, clr.g, clr.b )) {
    ui_colors.TuneColor = clr;
    tunecolor->color( RGBCOLOR( TuneColor ));
    tunecolor->redraw();
    tune_selection_color();
    progdefaults.changed = true;}
}

Fl_Button *btnRxIDColor=(Fl_Button *)0;

static void cb_btnRxIDColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.RxIDColor;
  if (fl_color_chooser("RxID color", clr.r, clr.g, clr.b )) {
    ui_colors.RxIDColor = clr;
    rxidcolor->color( RGBCOLOR( RxIDColor ));
    rxidcolor->redraw();
    rxid_selection_color();
    progdefaults.changed = true;

    clr = progdefaults.rsidWideSearch ? ui_colors.RxIDwideColor : ui_colors.RxIDColor;
    btnRSID->selection_color( fl_rgb_color( clr.r, clr.g, clr.b ));
    btnRSID->redraw();}
}

Fl_Button *btnLkColor=(Fl_Button *)0;

static void cb_btnLkColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.LkColor;
  if (fl_color_chooser("Lock color", clr.r, clr.g, clr.b )) {
    ui_colors.LkColor = clr;
  lockcolor->color( RGBCOLOR( LkColor ) );
  lockcolor->redraw();
  xmtlock_selection_color();
  progdefaults.changed = true;}
}

Fl_Button *btnSql1Color=(Fl_Button *)0;

static void cb_btnSql1Color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.Sql1Color;
  if (fl_color_chooser("SQL1 color", clr.r, clr.g, clr.b )) {
    ui_colors.Sql1Color = clr;
    sql1color->color( RGBCOLOR( Sql1Color ));
    sql1color->redraw();
    sql_selection_color();
    progdefaults.changed = true;}
}

Fl_Button *btnXmtColor=(Fl_Button *)0;

static void cb_btnXmtColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.XmtColor;
  if (fl_color_chooser("XMT color", clr.r, clr.g, clr.b )) {
    ui_colors.XmtColor = clr;
    xmtcolor->color( RGBCOLOR( XmtColor ));
    xmtcolor->redraw();
    xmtrcv_selection_color();
    progdefaults.changed = true;}
}

Fl_Button *btnRxIDwideColor=(Fl_Button *)0;

static void cb_btnRxIDwideColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.RxIDwideColor;
  if (fl_color_chooser("RxID wide", clr.r, clr.g, clr.b )) {
    ui_colors.RxIDwideColor = clr;
    rxidcolorwide->color(RGBCOLOR( RxIDwideColor ));
    rxidcolorwide->redraw();
    rxid_selection_color();
    progdefaults.changed = true;

    clr = progdefaults.rsidWideSearch ? ui_colors.RxIDwideColor : ui_colors.RxIDColor;
    btnRSID->selection_color( fl_rgb_color( clr.r, clr.g, clr.b ) );
    btnRSID->redraw();}
}

Fl_Button *btnAfcColor=(Fl_Button *)0;

static void cb_btnAfcColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.AfcColor;
  if (fl_color_chooser("AFC color", clr.r, clr.g, clr.b )) {
    ui_colors.AfcColor = clr;
    afccolor->color( RGBCOLOR( AfcColor ) );
    afccolor->redraw();
    afc_selection_color();
    progdefaults.changed = true;}
}

Fl_Button *btnSql2Color=(Fl_Button *)0;

static void cb_btnSql2Color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.Sql2Color;
  if (fl_color_chooser("SQL2 color", clr.r, clr.g, clr.b )) {
    ui_colors.Sql2Color = clr;
    sql2color->color(RGBCOLOR( Sql2Color ) );
    sql2color->redraw();
    sql_selection_color();
    progdefaults.changed = true;}
}

Fl_Button *btnTxIDColor=(Fl_Button *)0;

static void cb_btnTxIDColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.TxIDColor;
  if (fl_color_chooser("TxID color", clr.r, clr.g, clr.b )) {
    ui_colors.TxIDColor = clr;
    txidcolor->color( RGBCOLOR( TxIDColor ) );
    txidcolor->redraw();
    txid_selection_color();
    progdefaults.changed = true;

    btnTxRSID->selection_color( RGBCOLOR( TxIDColor ) );
    btnTxRSID->redraw();}
}

Fl_Box *spotcolor=(Fl_Box *)0;

Fl_Box *revcolor=(Fl_Box *)0;

Fl_Box *tunecolor=(Fl_Box *)0;

Fl_Box *rxidcolor=(Fl_Box *)0;

Fl_Box *lockcolor=(Fl_Box *)0;

Fl_Box *sql1color=(Fl_Box *)0;

Fl_Box *rxidcolorwide=(Fl_Box *)0;

Fl_Box *xmtcolor=(Fl_Box *)0;

Fl_Box *afccolor=(Fl_Box *)0;

Fl_Box *sql2color=(Fl_Box *)0;

Fl_Box *txidcolor=(Fl_Box *)0;

Fl_Button *btn_default_btn_color=(Fl_Button *)0;

static void cb_btn_default_btn_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.default_btn_color;
  if (fl_color_chooser("Button color", clr.r, clr.g, clr.b )) {
    ui_colors.default_btn_color = clr;
    default_btn_color->color( RGBCOLOR( default_btn_color ) );
    default_btn_color->redraw();
    set_default_btn_color();
    progdefaults.changed = true;}
}

Fl_Box *default_btn_color=(Fl_Box *)0;

Fl_Button *btn_check_btn_color=(Fl_Button *)0;

static void cb_btn_check_btn_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.default_check_btn_color;
  if (fl_color_chooser("Check button", clr.r, clr.g, clr.b )) {
    ui_colors.default_check_btn_color = clr;
    default_check_btn_color->color( RGBCOLOR( default_check_btn_color ) );
    default_check_btn_color->redraw();
    set_default_btn_color();
    progdefaults.changed = true;}
}

Fl_Box *default_check_btn_color=(Fl_Box *)0;

Fl_Button *btn_default_round_btn_color=(Fl_Button *)0;

static void cb_btn_default_round_btn_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.default_round_btn_color;
  if (fl_color_chooser("Round button", clr.r, clr.g, clr.b )) {
    ui_colors.default_round_btn_color = clr;
    default_round_btn_color->color( RGBCOLOR( default_round_btn_color ));
    default_round_btn_color->redraw();
    set_default_btn_color();
    progdefaults.changed = true;}
}

Fl_Box *default_round_btn_color=(Fl_Box *)0;

Fl_Button *btnMenuFont=(Fl_Button *)0;

static void cb_btnMenuFont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.MenuFontnbr);
  font_browser->fontSize(progdefaults.MenuFontsize);
  font_browser->callback(cbMenuFontBrowser);
  font_browser->show();
}

Fl_ListBox *listboxScheme=(Fl_ListBox *)0;

static void cb_listboxScheme(Fl_ListBox* o, void*) {
  progdefaults.ui_scheme = o->value();

  Fl::scheme(progdefaults.ui_scheme.c_str());

  progdefaults.changed = true;
}

Fl_Button *btn_background_color=(Fl_Button *)0;

static void cb_btn_background_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.background;

   if (!fl_color_chooser("Background", clr.r, clr.g, clr.b))
     return;

   ui_colors.background = clr;
   background_color->color( RGBCOLOR( background ) );
   
   TRIAD fg = ui_colors.foreground;
   TRIAD bg = ui_colors.background;
   TRIAD bg2 = ui_colors.background2;

   Fl::background2(bg2.r, bg2.g, bg2.b);
   Fl::background(bg.r, bg.g, bg.b);
   Fl::foreground(fg.r, fg.g, fg.b);

   redraw_windows();
    
   progdefaults.changed = true;
}

Fl_Box *background_color=(Fl_Box *)0;

Fl_Button *btn_background2_color=(Fl_Button *)0;

static void cb_btn_background2_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.background2;

   if (!fl_color_chooser("Background2", clr.r, clr.g, clr.b))
     return;

   ui_colors.background2 = clr;
   background2_color->color( RGBCOLOR( background2 ) );
   
   TRIAD fg = ui_colors.foreground;
   TRIAD bg = ui_colors.background;
   TRIAD bg2 = ui_colors.background2;

   Fl::background2(bg2.r, bg2.g, bg2.b);
   Fl::background(bg.r, bg.g, bg.b);
   Fl::foreground(fg.r, fg.g, fg.b);

   redraw_windows();
    
   progdefaults.changed = true;
}

Fl_Box *background2_color=(Fl_Box *)0;

Fl_Button *btn_foreground_color=(Fl_Button *)0;

static void cb_btn_foreground_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.foreground;

   if (!fl_color_chooser("Foreground", clr.r, clr.g, clr.b))
     return;

   ui_colors.foreground = clr;
   foreground_color->color( RGBCOLOR( foreground ) );

   TRIAD fg = ui_colors.foreground;
   TRIAD bg = ui_colors.background;
   TRIAD bg2 = ui_colors.background2;

   Fl::background2(bg2.r, bg2.g, bg2.b);
   Fl::background(bg.r, bg.g, bg.b);
   Fl::foreground(fg.r, fg.g, fg.b);

   redraw_windows();
   
   progdefaults.changed = true;
}

Fl_Box *foreground_color=(Fl_Box *)0;

Fl_Box *FDdisplay=(Fl_Box *)0;

Fl_Button *btn_freq_control_font=(Fl_Button *)0;

static void cb_btn_freq_control_font(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.FreqControlFontnbr);
      font_browser->fontSize(14);
      font_browser->fontColor(FL_FOREGROUND_COLOR);
      if (font_browser->fixed_width(progdefaults.FreqControlFontnbr))
      	font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
      else
  	font_browser->fontFilter(Font_Browser::ALL_TYPES);
      font_browser->callback(cbFreqControlFontBrowser);
  font_browser->show();
}

Fl_Button *btnBackgroundColor=(Fl_Button *)0;

static void cb_btnBackgroundColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.FDbackground;

      if (!fl_color_chooser("Background", clr.r, clr.g, clr.b))
          return;

      ui_colors.FDbackground = clr;
      FDdisplay->color( RGBCOLOR( FDbackground ));
      FDdisplay->redraw();

      if (qsoFreqDisp) {
          qsoFreqDisp->SetCOLORS( RGBCOLOR( FDforeground ), RGBCOLOR( FDbackground ) );
          qsoFreqDisp->redraw();
      }
      progdefaults.changed = true;
}

Fl_Button *btnForegroundColor=(Fl_Button *)0;

static void cb_btnForegroundColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.FDforeground;

    if (!fl_color_chooser("Foreground", clr.r, clr.g, clr.b))
      return;

    ui_colors.FDforeground = clr;

    FDdisplay->labelcolor( RGBCOLOR( FDforeground ) );
    FDdisplay->redraw();
    FDdisplay->redraw_label();

    if (qsoFreqDisp) {
        qsoFreqDisp->SetCOLORS( RGBCOLOR( FDforeground ), RGBCOLOR( FDbackground ) );
        qsoFreqDisp->redraw();
    }
    progdefaults.changed = true;
}

Fl_Button *btnFD_SystemColor=(Fl_Button *)0;

static void cb_btnFD_SystemColor(Fl_Button*, void*) {
  TRIAD clr;
    Fl::get_color( FL_BACKGROUND2_COLOR, clr.r, clr.g, clr.b);
      ui_colors.FDbackground = clr;
      FDdisplay->color( RGBCOLOR( FDbackground ) );

    Fl::get_color( FL_FOREGROUND_COLOR, clr.r, clr.g, clr.b);
      ui_colors.FDforeground = clr;
      FDdisplay->labelcolor( RGBCOLOR( FDforeground ) );
      FDdisplay->redraw();
      FDdisplay->redraw_label();

      if (qsoFreqDisp) {
          qsoFreqDisp->SetCOLORS( RGBCOLOR( FDforeground ), RGBCOLOR( FDbackground ) );
          qsoFreqDisp->redraw();
      }
      progdefaults.changed = true;
}

Fl_Button *btnSmeter_bg_color=(Fl_Button *)0;

static void cb_btnSmeter_bg_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.Smeter_bg_color;

      if (!fl_color_chooser("Background", clr.r, clr.g, clr.b))
          return;
      ui_colors.Smeter_bg_color = clr;

      set_smeter_colors();

      progdefaults.changed = true;
}

Fl_Button *btnSmeter_scale_color=(Fl_Button *)0;

static void cb_btnSmeter_scale_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.Smeter_scale_color;

      if (!fl_color_chooser("Scale", clr.r, clr.g, clr.b))
          return;

      ui_colors.Smeter_scale_color = clr;

      set_smeter_colors();

      progdefaults.changed = true;
}

Fl_Button *btnSmeter_meter_color=(Fl_Button *)0;

static void cb_btnSmeter_meter_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.Smeter_meter_color;

      if (!fl_color_chooser("Meter", clr.r, clr.g, clr.b))
          return;

      ui_colors.Smeter_meter_color = clr;

      set_smeter_colors();

      progdefaults.changed = true;
}

Fl_Button *btnPWR_bg_color=(Fl_Button *)0;

static void cb_btnPWR_bg_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.PWRmeter_bg_color;

      if (!fl_color_chooser("Background", clr.r, clr.g, clr.b))
          return;

      ui_colors.PWRmeter_bg_color = clr;

      set_smeter_colors();

      progdefaults.changed = true;
}

Fl_Button *btnPWR_scale_color=(Fl_Button *)0;

static void cb_btnPWR_scale_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.PWRmeter_scale_color;

    if (!fl_color_chooser("Scale", clr.r, clr.g, clr.b))
          return;

      ui_colors.PWRmeter_scale_color = clr;

      set_smeter_colors();

      progdefaults.changed = true;
}

Fl_Button *btnPWR_meter_Color=(Fl_Button *)0;

static void cb_btnPWR_meter_Color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.PWRmeter_meter_color;

    if (!fl_color_chooser("Meter", clr.r, clr.g, clr.b))
          return;
      ui_colors.PWRmeter_meter_color = clr;
      set_smeter_colors();
      progdefaults.changed = true;
}

Fl_ListBox *listboxPWRselect=(Fl_ListBox *)0;

static void cb_listboxPWRselect(Fl_ListBox* o, void*) {
  progdefaults.PWRselect = o->index();
  set_smeter_colors();
  progdefaults.changed = true;
}

Fl_Check_Button *btnUseGroupColors=(Fl_Check_Button *)0;

static void cb_btnUseGroupColors(Fl_Check_Button* o, void*) {
  progdefaults.useGroupColors = o->value();
      colorize_macros();
      progdefaults.changed = true;
}

Fl_Button *btnGroup1=(Fl_Button *)0;

static void cb_btnGroup1(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.btnGroup1;

    if (fl_color_chooser("Group 1", clr.r, clr.g, clr.b) == 0)
          return;
    ui_colors.btnGroup1 = clr;
    o->color( RGBCOLOR( btnGroup1 ));
    colorize_macros();
    progdefaults.changed = true;
}

Fl_Button *btnGroup2=(Fl_Button *)0;

static void cb_btnGroup2(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.btnGroup2;

    if (fl_color_chooser("Group 2", clr.r, clr.g, clr.b) == 0)
          return;
    ui_colors.btnGroup2 = clr;
      o->color( RGBCOLOR( btnGroup2 ) );
      colorize_macros();

      progdefaults.changed = true;
}

Fl_Button *btnGroup3=(Fl_Button *)0;

static void cb_btnGroup3(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.btnGroup3;

    if (fl_color_chooser("Group 3", clr.r, clr.g, clr.b) == 0)
          return;
    ui_colors.btnGroup3 = clr;
    o->color( RGBCOLOR( btnGroup3 ) );

      colorize_macros();
      progdefaults.changed = true;
}

Fl_Button *btnFkeyDEfaults=(Fl_Button *)0;

static void cb_btnFkeyDEfaults(Fl_Button*, void*) {
  TRIAD clr;

      clr.r = 80; clr.g = 144; clr.b = 144;
      btnGroup1->color( fl_rgb_color( clr.r, clr.g, clr.b ) );
      ui_colors.btnGroup1 = clr;

      clr.r = 144; clr.g = 80; clr.b = 80;
      btnGroup2->color( fl_rgb_color( clr.r, clr.g, clr.b ) );
      ui_colors.btnGroup2 = clr;

      clr.r = 80; clr.g = 80; clr.b = 144;
      btnGroup3->color( fl_rgb_color( clr.r, clr.g, clr.b ));
      ui_colors.btnGroup3 = clr;

      Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b );
      ui_colors.MacroBtnFontcolor = clr;
      progdefaults.MacroBtnFontnbr = FL_HELVETICA;
      progdefaults.MacroBtnFontsize = 12;

      btnGroup1->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      btnGroup2->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      btnGroup3->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      btnGroup1->labelfont(progdefaults.MacroBtnFontnbr);
      btnGroup2->labelfont(progdefaults.MacroBtnFontnbr);
      btnGroup3->labelfont(progdefaults.MacroBtnFontnbr);
      btnGroup1->labelsize(progdefaults.MacroBtnFontsize);
      btnGroup2->labelsize(progdefaults.MacroBtnFontsize);
      btnGroup3->labelsize(progdefaults.MacroBtnFontsize);

      btnGroup1->redraw_label();
      btnGroup2->redraw_label();
      btnGroup3->redraw_label();

      colorize_macros();

  progdefaults.changed = true;
}

Fl_Button *btnMacroBtnFont=(Fl_Button *)0;

static void cb_btnMacroBtnFont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.MacroBtnFontnbr);
  font_browser->fontSize(progdefaults.MacroBtnFontsize);
  font_browser->fontColor( RGBCOLOR( MacroBtnFontcolor ) );
  if (font_browser->fixed_width(progdefaults.MacroBtnFontnbr))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbMacroBtnFontBrowser);
  font_browser->show();
}

Fl_Output *LOGGINGdisplay=(Fl_Output *)0;

Fl_Button *btnLOGGING_color=(Fl_Button *)0;

static void cb_btnLOGGING_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.LOGGINGcolor;
    if (!fl_color_chooser("Background", clr.r, clr.g, clr.b))
          return;
      ui_colors.LOGGINGcolor = clr;
      LOGGINGdisplay->color( RGBCOLOR( LOGGINGcolor ));
      LOGGINGdisplay->redraw();
      LOGGING_colors_font();
      progdefaults.changed = true;
}

Fl_Button *btn_LOGGING_font=(Fl_Button *)0;

static void cb_btn_LOGGING_font(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.LOGGINGtextfont);
  font_browser->fontSize(progdefaults.LOGGINGtextsize);
  font_browser->fontColor( RGBCOLOR( LOGGINGtextcolor ) );
  if (font_browser->fixed_width(progdefaults.LOGGINGtextfont))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbLOGGINGFontBrowser);
  font_browser->show();
}

Fl_Button *btnLOGGINGdefault_colors_font=(Fl_Button *)0;

static void cb_btnLOGGINGdefault_colors_font(Fl_Button*, void*) {
  TRIAD clr;
    Fl::get_color( FL_BACKGROUND2_COLOR, clr.r, clr.g, clr.b );
    ui_colors.LOGGINGcolor = clr;
    progdefaults.LOGGINGtextfont = (Fl_Font)0;
    progdefaults.LOGGINGtextsize = 14;

    Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b );
    ui_colors.LOGGINGtextcolor = clr;

    LOGGINGdisplay->color( RGBCOLOR( LOGGINGcolor ) );
    LOGGINGdisplay->textsize(progdefaults.LOGGINGtextsize);
    LOGGINGdisplay->textcolor( RGBCOLOR( LOGGINGtextcolor ) );
    LOGGINGdisplay->textfont(progdefaults.LOGGINGtextfont);
    LOGGINGdisplay->redraw();

    LOGGING_colors_font();

    progdefaults.changed = true;
}

Fl_Output *LOGBOOKdisplay=(Fl_Output *)0;

Fl_Button *btnLOGBOOK_color=(Fl_Button *)0;

static void cb_btnLOGBOOK_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.LOGBOOKcolor;

    if ( !fl_color_chooser("Background", clr.r, clr.g, clr.b ) )
      return;

    ui_colors.LOGBOOKcolor = clr;

    LOGBOOKdisplay->color( RGBCOLOR( LOGBOOKcolor ) );
    LOGBOOKdisplay->redraw();

    LOGBOOK_colors_font();

    progdefaults.changed = true;
}

Fl_Button *btn_LOGBOOK_font=(Fl_Button *)0;

static void cb_btn_LOGBOOK_font(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.LOGBOOKtextfont);
  font_browser->fontSize(progdefaults.LOGBOOKtextsize);
  font_browser->fontColor( RGBCOLOR( LOGBOOKtextcolor ));
  if (font_browser->fixed_width(progdefaults.LOGBOOKtextfont))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbLOGBOOKFontBrowser);
  font_browser->show();
}

Fl_Button *btnLOGBOOKdefault_colors_font=(Fl_Button *)0;

static void cb_btnLOGBOOKdefault_colors_font(Fl_Button*, void*) {
  TRIAD clr;
  Fl::get_color( FL_BACKGROUND2_COLOR, clr.r, clr.g, clr.b );
  ui_colors.LOGBOOKcolor = clr;
  progdefaults.LOGBOOKtextfont = (Fl_Font)0;
  progdefaults.LOGBOOKtextsize = 14;

  Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b );
  ui_colors.LOGBOOKtextcolor = clr;

  LOGBOOKdisplay->color( RGBCOLOR( LOGBOOKcolor ) );
  LOGBOOKdisplay->textsize(progdefaults.LOGBOOKtextsize);
  LOGBOOKdisplay->textcolor( RGBCOLOR( LOGBOOKtextcolor ));
  LOGBOOKdisplay->textfont(progdefaults.LOGBOOKtextfont);
  LOGBOOKdisplay->redraw();

  LOGBOOK_colors_font();

  progdefaults.changed = true;
}

Fl_Output *DXC_display=(Fl_Output *)0;

Fl_Button *btn_DXC_font=(Fl_Button *)0;

static void cb_btn_DXC_font(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.DXC_textfont);
  font_browser->fontSize(progdefaults.DXC_textsize);
  font_browser->fontColor( RGBCOLOR( DXC_textcolor ) );
  if (font_browser->fixed_width(progdefaults.DXC_textfont))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbDXC_FontBrowser);
  font_browser->show();
}

Fl_Button *btnDXCdefault_colors_font=(Fl_Button *)0;

static void cb_btnDXCdefault_colors_font(Fl_Button*, void*) {
  TRIAD clr;
  progdefaults.DXC_textfont = FL_COURIER;
  progdefaults.DXC_textsize = 14;

  Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b );
  ui_colors.DXC_textcolor = clr;

  Fl::get_color ( 7, clr.r, clr.g, clr.b );
  ui_colors.LOGBOOKcolor = clr;

  Fl::get_color ( 246, clr.r, clr.g, clr.b );
  ui_colors.DXC_odd_color = clr;

  DXC_display->textsize(progdefaults.DXC_textsize);
  DXC_display->textcolor( RGBCOLOR( DXC_textcolor ) );
  DXC_display->textfont(progdefaults.DXC_textfont);

  DXC_display->redraw();
}

Fl_Button *btn_DXC_even_lines=(Fl_Button *)0;

static void cb_btn_DXC_even_lines(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.LOGBOOKcolor;
  if (fl_color_chooser("Logbook color", clr.r, clr.g, clr.b )) {
    ui_colors.LOGBOOKcolor = clr;
    o->color( RGBCOLOR( LOGBOOKcolor ) );
    o->redraw();
    dxc_lines_redraw();
    progdefaults.changed = true;}
}

Fl_Button *btn_DXC_odd_lines=(Fl_Button *)0;

static void cb_btn_DXC_odd_lines(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.DXC_odd_color;
  if (fl_color_chooser(" XXXX ", clr.r, clr.g, clr.b )) {
    ui_colors.DXC_odd_color = clr;
    o->color( RGBCOLOR( DXC_odd_color ) );
    o->redraw();
    dxc_lines_redraw();
    progdefaults.changed = true;}
}

Fl_Input *StreamText=(Fl_Input *)0;

Fl_Button *btnDXcolor=(Fl_Button *)0;

static void cb_btnDXcolor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.DX_Color;
  if (!fl_color_chooser("DX Color", clr.r, clr.g, clr.b))
      return;

  ui_colors.DX_Color = clr;

  StreamText->color( RGBCOLOR( DX_Color ) );
  StreamText->redraw();

  brws_tcpip_stream->color( RGBCOLOR( DX_Color ));
  brws_tcpip_stream->redraw();

  brws_dxcluster_hosts->color( RGBCOLOR( DX_Color ) );
  brws_dxcluster_hosts->textcolor( RGBCOLOR( DXfontcolor ) );
  brws_dxcluster_hosts->textfont(progdefaults.DXfontnbr);
  brws_dxcluster_hosts->textsize(progdefaults.DXfontsize);
  brws_dxcluster_hosts->redraw();

  brws_dxc_help->color(  RGBCOLOR( DX_Color ) );
  brws_dxc_help->setFont(progdefaults.DXfontnbr);
  brws_dxc_help->setFontSize(progdefaults.DXfontsize);
  brws_dxc_help->setFontColor( RGBCOLOR( DXfontcolor ), FTextBase::RECV);
  brws_dxc_help->redraw();
      
  ed_telnet_cmds->color(fl_rgb_color( clr.r, clr.g, clr.b));
  ed_telnet_cmds->redraw();

  dxcluster_hosts_load();

  progdefaults.changed = true;
}

Fl_Button *btnDXfont=(Fl_Button *)0;

static void cb_btnDXfont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.DXfontnbr);
  font_browser->fontSize(progdefaults.DXfontsize);
  font_browser->fontColor( RGBCOLOR( DXfontcolor ) );
  if (font_browser->fixed_width(progdefaults.DXfontnbr))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbDXfont_browser);
  font_browser->show();
}

Fl_Button *btnDXalt_color=(Fl_Button *)0;

static void cb_btnDXalt_color(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.DXalt_color;
  if (fl_color_chooser("DX alt color", clr.r, clr.g, clr.b )) {
    ui_colors.DXalt_color = clr;
    o->labelcolor( RGBCOLOR( DXalt_color ));
    o->redraw_label();
    brws_tcpip_stream->setFontColor( RGBCOLOR( DXalt_color ), FTextBase::XMIT);
    brws_tcpip_stream->redraw();
    progdefaults.changed = true;}
}

Fl_Button *btnDXdefault_colors_font=(Fl_Button *)0;

static void cb_btnDXdefault_colors_font(Fl_Button*, void*) {
  TRIAD clr;
  Fl::get_color( FL_WHITE, clr.r, clr.g, clr.b );

  ui_colors.DX_Color = clr;
  progdefaults.DXfontnbr = FL_COURIER;
  progdefaults.DXfontsize = 14;

  Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b );
  ui_colors.DXfontcolor = clr;

  clr.r = 200; clr.g = 0; clr.b = 0;
  ui_colors.DXalt_color = clr;
  btnDXalt_color->labelcolor( RGBCOLOR( DXalt_color ) );
  btnDXalt_color->redraw_label();

  brws_tcpip_stream->color( RGBCOLOR( DX_Color ) );
  brws_tcpip_stream->setFont(progdefaults.DXfontnbr);
  brws_tcpip_stream->setFontSize(progdefaults.DXfontsize);
  brws_tcpip_stream->setFontColor( RGBCOLOR( DXfontcolor ), FTextBase::RECV);
  brws_tcpip_stream->setFontColor( RGBCOLOR( DXalt_color ), FTextBase::XMIT);
  brws_tcpip_stream->redraw();

  ed_telnet_cmds->color( RGBCOLOR( DX_Color ) );
  ed_telnet_cmds->setFont(progdefaults.DXfontnbr);
  ed_telnet_cmds->setFontSize(progdefaults.DXfontsize);
  ed_telnet_cmds->setFontColor( RGBCOLOR( DXfontcolor ) );
  ed_telnet_cmds->redraw();

  brws_dxc_help->color( RGBCOLOR( DX_Color ));
  brws_dxc_help->setFont(progdefaults.DXfontnbr);
  brws_dxc_help->setFontSize(progdefaults.DXfontsize);
  brws_dxc_help->setFontColor( RGBCOLOR( DXfontcolor ), FTextBase::RECV);
  brws_dxc_help->redraw();

  StreamText->color( RGBCOLOR( DX_Color ) );
  StreamText->textcolor( RGBCOLOR( DXfontcolor ) );
  StreamText->redraw();

  dxcluster_hosts_load();

  font_browser->hide();

  progdefaults.changed = true;
}

Fl_ListBox *listbox_charset_status=(Fl_ListBox *)0;

Fl_Input *RxText=(Fl_Input *)0;

Fl_Button *btnRxColor=(Fl_Button *)0;

static void cb_btnRxColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.RxColor;
    if (!fl_color_chooser("Rx Color", clr.r, clr.g, clr.b))
          return;
    ui_colors.RxColor = clr;
    RxText->color( RGBCOLOR( RxColor ) );
    ReceiveText->color( RGBCOLOR( RxColor ) );
    RxText->redraw();
    ReceiveText->redraw();
    progdefaults.changed = true;
}

Fl_Button *btnTxColor=(Fl_Button *)0;

static void cb_btnTxColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.TxColor;
    if (!fl_color_chooser("Tx Color", clr.r, clr.g, clr.b))
       return;
    ui_colors.TxColor = clr;
    TxText->color( RGBCOLOR( TxColor ) );
    TransmitText->color( RGBCOLOR( TxColor ) );
    TxText->redraw();
    TransmitText->redraw();
    progdefaults.changed = true;
}

Fl_Input *TxText=(Fl_Input *)0;

Fl_Button *btnRxFont=(Fl_Button *)0;

static void cb_btnRxFont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.RxFontnbr);
  font_browser->fontSize(progdefaults.RxFontsize);
  font_browser->fontColor( RGBCOLOR( RxFontcolor ) );
  if (font_browser->fixed_width(progdefaults.RxFontnbr))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbRxFontBrowser);
  font_browser->show();
}

Fl_Button *btnTxFont=(Fl_Button *)0;

static void cb_btnTxFont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.TxFontnbr);
  font_browser->fontSize(progdefaults.TxFontsize);
  font_browser->fontColor( RGBCOLOR( TxFontcolor ) );
  if (font_browser->fixed_width(progdefaults.TxFontnbr))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbTxFontBrowser);
  font_browser->show();
}

Fl_Input *MacroText=(Fl_Input *)0;

Fl_Button *btnMacroEditFont=(Fl_Button *)0;

static void cb_btnMacroEditFont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.MacroEditFontnbr);
  font_browser->fontSize(progdefaults.MacroEditFontsize);
  if (font_browser->fixed_width(progdefaults.MacroEditFontnbr))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbMacroEditFontBrowser);
  font_browser->show();
}

Fl_Button *btnXMIT=(Fl_Button *)0;

static void cb_btnXMIT(Fl_Button*, void*) {
  TRIAD clr = ui_colors.XMITcolor;
  if (fl_color_chooser("XMIT color", clr.r, clr.g, clr.b )) {
      btnXMIT->color( RGBCOLOR( XMITcolor ) );
      btnXMIT->redraw();
      TransmitText->setFontColor( RGBCOLOR( XMITcolor ), FTextBase::XMIT);
      ReceiveText->setFontColor( RGBCOLOR( XMITcolor ), FTextBase::XMIT);

      progdefaults.changed = true;}
}

Fl_Button *btnCTRL=(Fl_Button *)0;

static void cb_btnCTRL(Fl_Button*, void*) {
  TRIAD clr = ui_colors.CTRLcolor;
  if (fl_color_chooser("CTRL color", clr.r, clr.g, clr.g )) {
    ui_colors.CTRLcolor = clr;
    btnCTRL->color( RGBCOLOR( CTRLcolor ) );
    btnCTRL->redraw();
    TransmitText->setFontColor( RGBCOLOR( CTRLcolor ), FTextBase::CTRL);
    ReceiveText->setFontColor( RGBCOLOR( CTRLcolor ), FTextBase::CTRL);
    progdefaults.changed = true;}
}

Fl_Button *btnSKIP=(Fl_Button *)0;

static void cb_btnSKIP(Fl_Button*, void*) {
  TRIAD clr = ui_colors.SKIPcolor;
  if (fl_color_chooser("SKIP color", clr.r, clr.g, clr.b )) {
    ui_colors.SKIPcolor = clr;
    btnSKIP->color(  RGBCOLOR( SKIPcolor ) );
    btnSKIP->redraw();
    TransmitText->setFontColor( RGBCOLOR( SKIPcolor ), FTextBase::SKIP);
    ReceiveText->setFontColor( RGBCOLOR( SKIPcolor ), FTextBase::SKIP);
    progdefaults.changed = true;}
}

Fl_Button *btnALTR=(Fl_Button *)0;

static void cb_btnALTR(Fl_Button*, void*) {
  TRIAD clr = ui_colors.ALTRcolor;
  if (fl_color_chooser("ALTR color", clr.r, clr.g, clr.b )) {
    ui_colors.ALTRcolor = clr;
    btnALTR->color( RGBCOLOR( ALTRcolor ) );
    btnALTR->redraw();
    TransmitText->setFontColor( RGBCOLOR( ALTRcolor ), FTextBase::ALTR);
    ReceiveText->setFontColor( RGBCOLOR( ALTRcolor ), FTextBase::ALTR);
    progdefaults.changed = true;}
}

Fl_Button *btnSEL=(Fl_Button *)0;

static void cb_btnSEL(Fl_Button*, void*) {
  TRIAD clr = ui_colors.RxTxSelectcolor;
  if (fl_color_chooser("Select color", clr.r, clr.g, clr.b )) {
    ui_colors.RxTxSelectcolor = clr;
    btnSEL->color( RGBCOLOR( RxTxSelectcolor ) );
    btnSEL->redraw();
    ReceiveText->color( RGBCOLOR( RxColor ), RGBCOLOR( RxTxSelectcolor ) );
    TransmitText->color( RGBCOLOR( TxColor ), RGBCOLOR( RxTxSelectcolor ) );
  progdefaults.changed = true;}
}

Fl_Button *btnNoTextColor=(Fl_Button *)0;

static void cb_btnNoTextColor(Fl_Button*, void*) {
  TRIAD clr;

    Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b);
      ui_colors.TxFontcolor = clr;
      ui_colors.RxFontcolor = clr;
    Fl::get_color( FL_RED, clr.r, clr.g, clr.b);
      ui_colors.XMITcolor = clr;
    Fl::get_color( FL_DARK_GREEN, clr.r, clr.g, clr.b);
      ui_colors.CTRLcolor = clr;
    Fl::get_color( FL_BLUE, clr.r, clr.g, clr.b);
      ui_colors.SKIPcolor = clr;
    Fl::get_color( FL_DARK_MAGENTA, clr.r, clr.g, clr.b);
      ui_colors.ALTRcolor = clr;

      btnXMIT->color( RGBCOLOR( XMITcolor ) );
      btnCTRL->color( RGBCOLOR( CTRLcolor ) );
      btnSKIP->color( RGBCOLOR( SKIPcolor ) );
      btnALTR->color( RGBCOLOR( ALTRcolor ) );
      btnXMIT->redraw();
      btnCTRL->redraw();
      btnSKIP->redraw();
      btnALTR->redraw();

      clr.r = 255; clr.g = 242; clr.b = 190;
      ui_colors.RxColor = clr;

      RxText->color( RGBCOLOR( RxColor ) );
      RxText->textcolor( RGBCOLOR( RxFontcolor ) );
      RxText->redraw();

      ReceiveText->color( RGBCOLOR(RxColor) );
      ReceiveText->setFontColor( RGBCOLOR( RxFontcolor ), FTextBase::RECV);
      ReceiveText->setFontColor( RGBCOLOR( XMITcolor ), FTextBase::XMIT);
      ReceiveText->setFontColor( RGBCOLOR( CTRLcolor ), FTextBase::CTRL);
      ReceiveText->setFontColor( RGBCOLOR( SKIPcolor ), FTextBase::SKIP);
      ReceiveText->setFontColor( RGBCOLOR( ALTRcolor ), FTextBase::ALTR);
      ReceiveText->redraw();

      clr.r = 200; clr.g = 235; clr.b = 235;
      ui_colors.TxColor = clr;

      TxText->color( RGBCOLOR( TxColor ) );
      TxText->textcolor( RGBCOLOR( TxFontcolor ) );
      TxText->redraw();

      TransmitText->color( RGBCOLOR( TxColor ) );
      TransmitText->setFontColor( RGBCOLOR( TxFontcolor ), FTextBase::RECV);
      TransmitText->setFontColor( RGBCOLOR( XMITcolor ), FTextBase::XMIT);
      TransmitText->setFontColor( RGBCOLOR( CTRLcolor ), FTextBase::CTRL);
      TransmitText->setFontColor( RGBCOLOR( SKIPcolor ), FTextBase::SKIP);
      TransmitText->setFontColor( RGBCOLOR( ALTRcolor ), FTextBase::ALTR);
      TransmitText->redraw();

      progdefaults.changed = true;
}

Fl_Button *btnTextDefaults=(Fl_Button *)0;

static void cb_btnTextDefaults(Fl_Button*, void*) {
  TRIAD clr;
  //          uchar r, g, b;
  //    Fl_Color clr;
    Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b );
      ui_colors.TxFontcolor = clr;
      ui_colors.RxFontcolor = clr;
    Fl::get_color( FL_RED, clr.r, clr.g, clr.b );
      ui_colors.XMITcolor = clr;
    Fl::get_color( FL_DARK_GREEN, clr.r, clr.g, clr.b );
      ui_colors.CTRLcolor = clr;
    Fl::get_color( FL_BLUE, clr.r, clr.g, clr.b );
      ui_colors.SKIPcolor = clr;
    Fl::get_color( FL_DARK_MAGENTA, clr.r, clr.g, clr.b );
      ui_colors.ALTRcolor = clr;

      btnXMIT->color(RGBCOLOR(XMITcolor));
      btnCTRL->color(RGBCOLOR(CTRLcolor));
      btnSKIP->color(RGBCOLOR(SKIPcolor));
      btnALTR->color(RGBCOLOR(ALTRcolor));
      btnXMIT->redraw();
      btnCTRL->redraw();
      btnSKIP->redraw();
      btnALTR->redraw();

      clr.r = 255; clr.g = 242; clr.b = 190;
      ui_colors.RxColor = clr;

      RxText->color( RGBCOLOR( RxColor ) );
      RxText->textcolor( RGBCOLOR( RxFontcolor ) );
      RxText->redraw();

      ReceiveText->color( RGBCOLOR( RxColor ) );
      ReceiveText->setFontColor( RGBCOLOR( RxFontcolor ), FTextBase::RECV);
      ReceiveText->setFontColor( RGBCOLOR( XMITcolor ), FTextBase::XMIT);
      ReceiveText->setFontColor( RGBCOLOR( CTRLcolor ), FTextBase::CTRL);
      ReceiveText->setFontColor( RGBCOLOR( SKIPcolor ), FTextBase::SKIP);
      ReceiveText->setFontColor( RGBCOLOR( ALTRcolor ), FTextBase::ALTR);
      ReceiveText->redraw();

      clr.r = 200; clr.g = 235; clr.b = 255;
      ui_colors.TxColor = clr;

      TxText->color( RGBCOLOR( TxColor ) );
      TxText->textcolor( RGBCOLOR( TxFontcolor ));
      TxText->redraw();

      TransmitText->color( RGBCOLOR( TxColor ) );
      TransmitText->setFontColor( RGBCOLOR( TxFontcolor ), FTextBase::RECV);
      TransmitText->setFontColor( RGBCOLOR( XMITcolor ), FTextBase::XMIT);
      TransmitText->setFontColor( RGBCOLOR( CTRLcolor ), FTextBase::CTRL);
      TransmitText->setFontColor( RGBCOLOR( SKIPcolor ), FTextBase::SKIP);
      TransmitText->setFontColor( RGBCOLOR( ALTRcolor ), FTextBase::ALTR);
      TransmitText->redraw();

      progdefaults.changed = true;
}

Fl_Check_Button *btn_show_all_codes=(Fl_Check_Button *)0;

static void cb_btn_show_all_codes(Fl_Check_Button* o, void*) {
  progdefaults.show_all_codes=o->value();
  progdefaults.changed = true;
}

Fl_Button *btnTabColor=(Fl_Button *)0;

static void cb_btnTabColor(Fl_Button*, void*) {
  TRIAD clr = ui_colors.TabsColor;
  if (fl_color_chooser("Tab Color", clr.r, clr.g, clr.b )) {
    ui_colors.TabsColor = clr;
    setTabColors();
    LOGBOOK_colors_font();
    progdefaults.changed = true;}
}

Fl_Button *btnTabDefaultColor=(Fl_Button *)0;

static void cb_btnTabDefaultColor(Fl_Button*, void*) {
  TRIAD clr;
  Fl::get_color( FL_BACKGROUND2_COLOR, clr.r, clr.g, clr.b);
  ui_colors.TabsColor = clr;
  setTabColors();
  LOGBOOK_colors_font();
  progdefaults.changed = true;
}

Fl_Box *lowcolor=(Fl_Box *)0;

Fl_Button *btnLowSignal=(Fl_Button *)0;

static void cb_btnLowSignal(Fl_Button*, void*) {
  TRIAD clr = ui_colors.LowSignal;
  if (fl_color_chooser("Low", clr.r, clr.g, clr.b )) {
    ui_colors.LowSignal = clr;
    lowcolor->color(RGBCOLOR(LowSignal));
    lowcolor->redraw();
    progdefaults.changed = true;}
}

Fl_Box *normalcolor=(Fl_Box *)0;

Fl_Counter *cnt_normal_signal_level=(Fl_Counter *)0;

static void cb_cnt_normal_signal_level(Fl_Counter* o, void*) {
  progdefaults.normal_signal_level = o->value();

  if (progdefaults.normal_signal_level > progdefaults.high_signal_level)
    progdefaults.high_signal_level = progdefaults.normal_signal_level + 0.1;

  if (progdefaults.high_signal_level > progdefaults.over_signal_level)
    progdefaults.over_signal_level = progdefaults.high_signal_level + 0.1;

  if (progdefaults.over_signal_level > 0)
    progdefaults.over_signal_level = 0;

  cnt_normal_signal_level->value(progdefaults.normal_signal_level);
  cnt_high_signal_level->value(progdefaults.high_signal_level);
  cnt_over_signal_level->value(progdefaults.over_signal_level);
}

Fl_Button *btnNormalSignal=(Fl_Button *)0;

static void cb_btnNormalSignal(Fl_Button*, void*) {
  TRIAD clr = ui_colors.NormSignal;
  if (fl_color_chooser(" XXXX ", clr.r, clr.g, clr.b )) {
    ui_colors.NormSignal = clr;
    normalcolor->color(RGBCOLOR(NormSignal));
    normalcolor->redraw();
    progdefaults.changed = true;}
}

Fl_Box *highcolor=(Fl_Box *)0;

Fl_Counter *cnt_high_signal_level=(Fl_Counter *)0;

static void cb_cnt_high_signal_level(Fl_Counter* o, void*) {
  progdefaults.high_signal_level = o->value();

  if (progdefaults.normal_signal_level > progdefaults.high_signal_level)
    progdefaults.high_signal_level = progdefaults.normal_signal_level + 0.1;

  if (progdefaults.high_signal_level > progdefaults.over_signal_level)
    progdefaults.over_signal_level = progdefaults.high_signal_level + 0.1;

  if (progdefaults.over_signal_level > 0)
    progdefaults.over_signal_level = 0;
    
  cnt_normal_signal_level->value(progdefaults.normal_signal_level);
  cnt_high_signal_level->value(progdefaults.high_signal_level);
  cnt_over_signal_level->value(progdefaults.over_signal_level);
}

Fl_Button *btnHighSignal=(Fl_Button *)0;

static void cb_btnHighSignal(Fl_Button*, void*) {
  TRIAD clr = ui_colors.HighSignal;
  if (fl_color_chooser("High", clr.r, clr.g, clr.b )) {
    ui_colors.HighSignal = clr;
    highcolor->color(RGBCOLOR(HighSignal));
    highcolor->redraw();
    progdefaults.changed = true;}
}

Fl_Box *overcolor=(Fl_Box *)0;

Fl_Counter *cnt_over_signal_level=(Fl_Counter *)0;

static void cb_cnt_over_signal_level(Fl_Counter* o, void*) {
  progdefaults.over_signal_level = o->value();

  if (progdefaults.normal_signal_level > progdefaults.high_signal_level)
    progdefaults.high_signal_level = progdefaults.normal_signal_level + 0.1;

  if (progdefaults.high_signal_level > progdefaults.over_signal_level)
    progdefaults.over_signal_level = progdefaults.high_signal_level + 0.1;

  if (progdefaults.over_signal_level > 0)
    progdefaults.over_signal_level = 0;
    
  cnt_normal_signal_level->value(progdefaults.normal_signal_level);
  cnt_high_signal_level->value(progdefaults.high_signal_level);
  cnt_over_signal_level->value(progdefaults.over_signal_level);
}

Fl_Button *btnOverSignal=(Fl_Button *)0;

static void cb_btnOverSignal(Fl_Button*, void*) {
  TRIAD clr = ui_colors.OverSignal;
  if (fl_color_chooser("Over", clr.r, clr.g, clr.b )) {
    ui_colors.OverSignal = clr;
    overcolor->color( RGBCOLOR(OverSignal) );
    overcolor->redraw();
    progdefaults.changed = true;}
}

vumeter *sig_vumeter=(vumeter *)0;

Fl_Button *btn_default_signal_levels=(Fl_Button *)0;

static void cb_btn_default_signal_levels(Fl_Button*, void*) {
  cnt_normal_signal_level->value(
    progdefaults.normal_signal_level = -60.0);
  cnt_high_signal_level->value(
    progdefaults.high_signal_level = -6.0);
  cnt_over_signal_level->value(
    progdefaults.over_signal_level = -3.0);
}

Fl_Check_Button *btn_use_wsjtx_vumeter_scale=(Fl_Check_Button *)0;

static void cb_btn_use_wsjtx_vumeter_scale(Fl_Check_Button* o, void*) {
  progdefaults.use_wsjtx_vumeter_scale=o->value();
  btn_use_wsjtx_vumeter_scale2->value(o->value());
}

Fl_Box *scope_background=(Fl_Box *)0;

Fl_Button *btnScopeBackground=(Fl_Button *)0;

static void cb_btnScopeBackground(Fl_Button*, void*) {
  TRIAD clr = ui_colors.digi_background;
  if (fl_color_chooser("Digi background", clr.r, clr.g, clr.b )) {
    ui_colors.digi_background = clr;
    scope_background->color( RGBCOLOR( digi_background ) );
    scope_background->redraw();
    set_scope_colors();
    progdefaults.changed = true;}
}

Fl_Box *scope_axis=(Fl_Box *)0;

Fl_Button *btnScopeAxis=(Fl_Button *)0;

static void cb_btnScopeAxis(Fl_Button*, void*) {
  TRIAD clr = ui_colors.digi_axis_color;
  if (fl_color_chooser("Digi axis", clr.r, clr.g, clr.b )) {
    ui_colors.digi_axis_color = clr;
    scope_axis->color(RGBCOLOR(digi_axis_color));
    scope_axis->redraw();
    set_scope_colors();
    progdefaults.changed = true;}
}

Fl_Box *scope_color_1=(Fl_Box *)0;

Fl_Button *btnScopeColor_1=(Fl_Button *)0;

static void cb_btnScopeColor_1(Fl_Button*, void*) {
  TRIAD clr = ui_colors.digi_color_1;
  if (fl_color_chooser("Digi color 1", clr.r, clr.g, clr.b )) {
    ui_colors.digi_color_1 = clr;
    scope_color_1->color( RGBCOLOR( digi_color_1 ) );
    scope_color_1->redraw();
    set_scope_colors();
    progdefaults.changed = true;}
}

Fl_Box *scope_color_2=(Fl_Box *)0;

Fl_Button *btnScopeColor_2=(Fl_Button *)0;

static void cb_btnScopeColor_2(Fl_Button*, void*) {
  TRIAD clr = ui_colors.digi_color_2;
  if (fl_color_chooser("Digi color 2", clr.r, clr.g, clr.b )) {
    ui_colors.digi_color_2 = clr;
    scope_color_2->color(RGBCOLOR(digi_color_2));
    scope_color_2->redraw();
    set_scope_colors();
    progdefaults.changed = true;}
}

Fl_Button *btn_default_scope_colors=(Fl_Button *)0;

static void cb_btn_default_scope_colors(Fl_Button*, void*) {
  TRIAD clr;
  Fl::get_color( FL_BLACK, clr.r, clr.g, clr.b);
  ui_colors.digi_background = clr;
  Fl::get_color( FL_WHITE, clr.r, clr.g, clr.b);
  ui_colors.digi_axis_color = clr;
  Fl::get_color( FL_GREEN, clr.r, clr.g, clr.b);
  ui_colors.digi_color_1 = clr;
  Fl::get_color( FL_YELLOW, clr.r, clr.g, clr.b);
  ui_colors.digi_color_2 = clr;
  Fl::get_color( FL_CYAN, clr.r, clr.g, clr.b);
  ui_colors.digi_color_3 = clr;
  Fl::get_color( FL_MAGENTA, clr.r, clr.g, clr.b);
  ui_colors.digi_color_4 = clr;
  scope_background->color(RGBCOLOR(digi_background));
  scope_background->redraw();
  scope_axis->color(RGBCOLOR(digi_axis_color));
  scope_axis->redraw();
  scope_color_1->color(RGBCOLOR(digi_color_1));
  scope_color_1->redraw();
  scope_color_2->color(RGBCOLOR(digi_color_2));
  scope_color_2->redraw();
  scope_color_3->color(RGBCOLOR(digi_color_3));
  scope_color_3->redraw();
  scope_color_4->color(RGBCOLOR(digi_color_4));
  scope_color_4->redraw();
  set_scope_colors();
  progdefaults.changed = true;
}

Fl_Box *scope_color_3=(Fl_Box *)0;

Fl_Button *btnScopeColor_3=(Fl_Button *)0;

static void cb_btnScopeColor_3(Fl_Button*, void*) {
  TRIAD clr = ui_colors.digi_color_3;
  if (fl_color_chooser("Digi Color 3", clr.r, clr.g, clr.b )) {
    ui_colors.digi_color_3 = clr;
    scope_color_3->color(RGBCOLOR(digi_color_3));
    scope_color_3->redraw();
    set_scope_colors();
    progdefaults.changed = true;}
}

Fl_Box *scope_color_4=(Fl_Box *)0;

Fl_Button *btnScopeColor_4=(Fl_Button *)0;

static void cb_btnScopeColor_4(Fl_Button*, void*) {
  TRIAD clr = ui_colors.digi_color_4;
  if (fl_color_chooser("Digi Color 4", clr.r, clr.g, clr.b )) {
  ui_colors.digi_color_4 = clr;
  scope_color_4->color(RGBCOLOR(digi_color_4));
  scope_color_4->redraw();
  set_scope_colors();
  progdefaults.changed = true;}
}

Fl_ListBox *listbox_contest=(Fl_ListBox *)0;

static void cb_listbox_contest(Fl_ListBox* o, void*) {
  progdefaults.logging = o->index();
  if (contests[progdefaults.logging].name == "State QSO parties") {
    progdefaults.CONTESTnotes = QSOparties.qso_parties[progdefaults.SQSOcontest].notes;
    progdefaults.SQSOinstate = (QSOparties.qso_parties[progdefaults.SQSOcontest].instate[0] == 'T');
  } else {
    listbox_QP_contests->index(0);
    progdefaults.CONTESTnotes = contests[progdefaults.logging].notes;
  }
  inp_contest_notes->value(progdefaults.CONTESTnotes.c_str());
  UI_select();
  clear_log_fields();
  clearQSO();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_QP_contests=(Fl_ListBox *)0;

static void cb_listbox_QP_contests(Fl_ListBox* o, void*) {
  int n = o->index();
  progdefaults.SQSOcontest = n;
  progdefaults.SQSOinstate = (QSOparties.qso_parties[n].instate[0] == 'T');
  if (contests[progdefaults.logging].name == "State QSO parties") {
    progdefaults.CONTESTnotes = QSOparties.qso_parties[n].notes;
    inp_contest_notes->value(progdefaults.CONTESTnotes.c_str());
  } else
    inp_contest_notes->value("");
  adjust_for_contest(0);
  UI_select();
  clear_log_fields();
  clearQSO();
  progdefaults.changed = true;
}

Fl_Input2 *inp_contest_notes=(Fl_Input2 *)0;

Fl_Light_Button *btnDupCheckOn=(Fl_Light_Button *)0;

static void cb_btnDupCheckOn(Fl_Light_Button* o, void*) {
  progdefaults.EnableDupCheck = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnDupBand=(Fl_Check_Button *)0;

static void cb_btnDupBand(Fl_Check_Button* o, void*) {
  progdefaults.dupband = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnDupMode=(Fl_Check_Button *)0;

static void cb_btnDupMode(Fl_Check_Button* o, void*) {
  progdefaults.dupmode = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnDupTimeSpan=(Fl_Check_Button *)0;

static void cb_btnDupTimeSpan(Fl_Check_Button* o, void*) {
  progdefaults.duptimespan=(int)o->value();
  progdefaults.changed = true;
}

Fl_Button *btnDupColor=(Fl_Button *)0;

static void cb_btnDupColor(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.dup_color;
    fl_color_chooser("Dup Check", clr.r, clr.g, clr.b);
    ui_colors.dup_color = clr;
  o->color(RGBCOLOR(dup_color));
  o->redraw();
  progdefaults.changed = true;
}

Fl_Button *btnPossibleDupColor=(Fl_Button *)0;

static void cb_btnPossibleDupColor(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.possible_dup_color;
  if (fl_color_chooser("Possible_Dup Check", clr.r, clr.g, clr.b)) {
    ui_colors.possible_dup_color = clr;
    o->color(RGBCOLOR(possible_dup_color));
    o->redraw();
    progdefaults.changed = true;}
}

Fl_Check_Button *btnDupXchg1=(Fl_Check_Button *)0;

static void cb_btnDupXchg1(Fl_Check_Button* o, void*) {
  progdefaults.dupxchg1 = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnDupState=(Fl_Check_Button *)0;

static void cb_btnDupState(Fl_Check_Button* o, void*) {
  progdefaults.dupstate = o->value();
  progdefaults.changed = true;
}

Fl_Value_Input2 *nbrTimeSpan=(Fl_Value_Input2 *)0;

static void cb_nbrTimeSpan(Fl_Value_Input2* o, void*) {
  progdefaults.timespan = (int)o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpSend1=(Fl_Input2 *)0;

static void cb_inpSend1(Fl_Input2* o, void*) {
  progdefaults.myXchg=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn599=(Fl_Check_Button *)0;

static void cb_btn599(Fl_Check_Button* o, void*) {
  progdefaults.fixed599 = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCutNbrs=(Fl_Check_Button *)0;

static void cb_btnCutNbrs(Fl_Check_Button* o, void*) {
  progdefaults.cutnbrs=o->value();
  progdefaults.changed = true;
}

Fl_Value_Input2 *nbrContestStart=(Fl_Value_Input2 *)0;

static void cb_nbrContestStart(Fl_Value_Input2* o, void*) {
  progdefaults.ContestStart = (int)o->value();
  progdefaults.changed = true;
}

Fl_Value_Input2 *nbrContestDigits=(Fl_Value_Input2 *)0;

static void cb_nbrContestDigits(Fl_Value_Input2* o, void*) {
  progdefaults.ContestDigits = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnUseLeadingZeros=(Fl_Check_Button *)0;

static void cb_btnUseLeadingZeros(Fl_Check_Button* o, void*) {
  progdefaults.UseLeadingZeros = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnResetSerNbr=(Fl_Button *)0;

static void cb_btnResetSerNbr(Fl_Button*, void*) {
  cb_ResetSerNbr();
}

Fl_Input2 *inp_my_FD_call=(Fl_Input2 *)0;

static void cb_inp_my_FD_call(Fl_Input2* o, void*) {
  progdefaults.fd_op_call=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inp_my_FD_section=(Fl_Input2 *)0;

static void cb_inp_my_FD_section(Fl_Input2* o, void*) {
  progdefaults.my_FD_section=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inp_my_FD_class=(Fl_Input2 *)0;

static void cb_inp_my_FD_class(Fl_Input2* o, void*) {
  progdefaults.my_FD_class=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inp_my_SCR_class=(Fl_Input2 *)0;

static void cb_inp_my_SCR_class(Fl_Input2* o, void*) {
  progdefaults.my_SCR_class=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inp_my_JOTA_troop=(Fl_Input2 *)0;

static void cb_inp_my_JOTA_troop(Fl_Input2* o, void*) {
  progdefaults.my_JOTA_troop=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inp_my_JOTA_scout=(Fl_Input2 *)0;

static void cb_inp_my_JOTA_scout(Fl_Input2* o, void*) {
  progdefaults.my_JOTA_scout = o->value();
  progdefaults.changed=true;
}

Fl_Group *sld=(Fl_Group *)0;

Fl_Check_Button *btnCWID=(Fl_Check_Button *)0;

static void cb_btnCWID(Fl_Check_Button* o, void*) {
  progdefaults.CWid = o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider2 *sldrCWIDwpm=(Fl_Value_Slider2 *)0;

static void cb_sldrCWIDwpm(Fl_Value_Slider2* o, void*) {
  progdefaults.CWIDwpm = (int)o->value();
  progdefaults.changed = true;
}

Fl_Button *bCWIDModes=(Fl_Button *)0;

static void cb_bCWIDModes(Fl_Button* o, void*) {
  mode_browser->label(o->label());
  mode_browser->callback(0);
  mode_browser->show_(&progdefaults.cwid_modes);
  progdefaults.changed = true;
}

Fl_Check_Button *chkRSidNotifyOnly=(Fl_Check_Button *)0;

static void cb_chkRSidNotifyOnly(Fl_Check_Button* o, void*) {
  progdefaults.rsid_notify_only = o->value();
  notify_create_rsid_event(progdefaults.rsid_notify_only);
  if (progdefaults.rsid_notify_only) {
      chkRetainFreqLock->deactivate();
      chkDisableFreqChange->deactivate();
  }
  else {
      chkRetainFreqLock->activate();
      chkDisableFreqChange->activate();
  }
  progdefaults.changed = true;
}

Fl_Button *bRSIDRxModes=(Fl_Button *)0;

static void cb_bRSIDRxModes(Fl_Button* o, void*) {
  mode_browser->label(o->label());
  mode_browser->callback(0);
  mode_browser->show_(&progdefaults.rsid_rx_modes);
  progdefaults.changed = true;
}

Fl_Check_Button *chkRSidMark=(Fl_Check_Button *)0;

static void cb_chkRSidMark(Fl_Check_Button* o, void*) {
  progdefaults.rsid_mark = o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_rsid_errors=(Fl_ListBox *)0;

static void cb_listbox_rsid_errors(Fl_ListBox* o, void*) {
  progdefaults.RsID_label_type = o->index();
  progdefaults.changed = true;
}

Fl_Check_Button *chkRSidShowAlert=(Fl_Check_Button *)0;

static void cb_chkRSidShowAlert(Fl_Check_Button* o, void*) {
  progdefaults.disable_rsid_warning_dialog_box = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkRSidAutoDisable=(Fl_Check_Button *)0;

static void cb_chkRSidAutoDisable(Fl_Check_Button* o, void*) {
  progdefaults.rsid_auto_disable = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkRetainFreqLock=(Fl_Check_Button *)0;

static void cb_chkRetainFreqLock(Fl_Check_Button* o, void*) {
  progdefaults.retain_freq_lock = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkDisableFreqChange=(Fl_Check_Button *)0;

static void cb_chkDisableFreqChange(Fl_Check_Button* o, void*) {
  progdefaults.disable_rsid_freq_change = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_RSID_EOT=(Fl_Check_Button *)0;

static void cb_chk_RSID_EOT(Fl_Check_Button* o, void*) {
  progdefaults.rsid_eot_squelch = o->value();
  progdefaults.changed = true;
}

Fl_Counter *val_RSIDsquelch=(Fl_Counter *)0;

static void cb_val_RSIDsquelch(Fl_Counter* o, void*) {
  progdefaults.rsid_squelch = (int)o->value();
  progdefaults.changed = true;
}

Fl_Counter *val_pretone=(Fl_Counter *)0;

static void cb_val_pretone(Fl_Counter* o, void*) {
  progdefaults.pretone = o->value();
  progdefaults.changed = true;
}

Fl_Button *bRSIDTxModes=(Fl_Button *)0;

static void cb_bRSIDTxModes(Fl_Button* o, void*) {
  mode_browser->label(o->label());
  mode_browser->callback(0);
  mode_browser->show_(&progdefaults.rsid_tx_modes);
  progdefaults.changed = true;
}

Fl_Check_Button *btn_post_rsid=(Fl_Check_Button *)0;

static void cb_btn_post_rsid(Fl_Check_Button* o, void*) {
  progdefaults.rsid_post=o->value();
  progdefaults.changed = true;
}

Fl_Counter *val_rsid_min_bw=(Fl_Counter *)0;

static void cb_val_rsid_min_bw(Fl_Counter* o, void*) {
  progdefaults.rsid_min_bw = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkRSidWideSearch=(Fl_Check_Button *)0;

static void cb_chkRSidWideSearch(Fl_Check_Button* o, void*) {
  progdefaults.rsidWideSearch=o->value();
  rxid_selection_color();
  progdefaults.changed = true;
}

Fl_Button *btn_rsid_default_bw=(Fl_Button *)0;

static void cb_btn_rsid_default_bw(Fl_Button*, void*) {
  val_rsid_min_bw->value(200);
  progdefaults.rsid_min_bw = 200;
  progdefaults.changed = true;
}

Fl_Check_Button *btnsendid=(Fl_Check_Button *)0;

static void cb_btnsendid(Fl_Check_Button* o, void*) {
  progdefaults.sendid=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnsendvideotext=(Fl_Check_Button *)0;

static void cb_btnsendvideotext(Fl_Check_Button* o, void*) {
  progdefaults.sendtextid=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *valVideotext=(Fl_Input2 *)0;

static void cb_valVideotext(Fl_Input2* o, void*) {
  progdefaults.strTextid = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkID_SMALL=(Fl_Check_Button *)0;

static void cb_chkID_SMALL(Fl_Check_Button* o, void*) {
  progdefaults.ID_SMALL=o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider2 *sldrVideowidth=(Fl_Value_Slider2 *)0;

static void cb_sldrVideowidth(Fl_Value_Slider2* o, void*) {
  progdefaults.videowidth = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_vidlimit=(Fl_Check_Button *)0;

static void cb_btn_vidlimit(Fl_Check_Button* o, void*) {
  progdefaults.vidlimit=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_vidmodelimit=(Fl_Check_Button *)0;

static void cb_btn_vidmodelimit(Fl_Check_Button* o, void*) {
  progdefaults.vidmodelimit=o->value();
  progdefaults.changed=true;
}

Fl_Button *bVideoIDModes=(Fl_Button *)0;

static void cb_bVideoIDModes(Fl_Button* o, void*) {
  mode_browser->label(o->label());
  mode_browser->callback(0);
  mode_browser->show_(&progdefaults.videoid_modes);
  progdefaults.changed = true;
}

Fl_Check_Button *btnConnectToMaclogger=(Fl_Check_Button *)0;

static void cb_btnConnectToMaclogger(Fl_Check_Button* o, void*) {
  progdefaults.connect_to_maclogger = o->value();
  if (progdefaults.connect_to_maclogger == false)
    maclogger_close();
  else
    maclogger_init();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_capture_maclogger_radio=(Fl_Check_Button *)0;

static void cb_btn_capture_maclogger_radio(Fl_Check_Button* o, void*) {
  progdefaults.capture_maclogger_radio = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_capture_maclogger_log=(Fl_Check_Button *)0;

static void cb_btn_capture_maclogger_log(Fl_Check_Button* o, void*) {
  progdefaults.capture_maclogger_log = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_capture_maclogger_lookup=(Fl_Check_Button *)0;

static void cb_btn_capture_maclogger_lookup(Fl_Check_Button* o, void*) {
  progdefaults.capture_maclogger_lookup = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_capture_maclogger_spot_tune=(Fl_Check_Button *)0;

static void cb_btn_capture_maclogger_spot_tune(Fl_Check_Button* o, void*) {
  progdefaults.capture_maclogger_spot_tune = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_capture_maclogger_spot_report=(Fl_Check_Button *)0;

static void cb_btn_capture_maclogger_spot_report(Fl_Check_Button* o, void*) {
  progdefaults.capture_maclogger_spot_report = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_enable_maclogger_log=(Fl_Check_Button *)0;

static void cb_btn_enable_maclogger_log(Fl_Check_Button* o, void*) {
  progdefaults.enable_maclogger_log = o->value();
  progdefaults.changed = true;
}

Fl_Text_Display *txt_UDP_data=(Fl_Text_Display *)0;

Fl_Output *txt_maclogger_log_filename=(Fl_Output *)0;

static void cb_Clear(Fl_Button*, void*) {
  txt_UDP_data->buffer()->text("");
}

Fl_Check_Button *btn_maclogger_spot_rx=(Fl_Check_Button *)0;

static void cb_btn_maclogger_spot_rx(Fl_Check_Button* o, void*) {
  progdefaults.maclogger_spot_rx = o->value();
  progdefaults.changed = true;
}

Fl_Text_Display *txt_N3FJP_data=(Fl_Text_Display *)0;

static void cb_Clear1(Fl_Button*, void*) {
  txt_N3FJP_data->buffer()->text("");
}

Fl_Input2 *txt_N3FJP_ip_address=(Fl_Input2 *)0;

static void cb_txt_N3FJP_ip_address(Fl_Input2* o, void*) {
  progdefaults.N3FJP_address = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txt_N3FJP_ip_port_no=(Fl_Input2 *)0;

static void cb_txt_N3FJP_ip_port_no(Fl_Input2* o, void*) {
  progdefaults.N3FJP_port = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_default_N3FJP_ip=(Fl_Button *)0;

static void cb_btn_default_N3FJP_ip(Fl_Button*, void*) {
  txt_N3FJP_ip_address->value("127.0.0.1");
  progdefaults.N3FJP_address = "127.0.0.1";
  txt_N3FJP_ip_port_no->value("1100");
  progdefaults.N3FJP_port = "1100";
  progdefaults.changed = true;
}

Fl_Check_Button *btn_enable_N3FJP_log=(Fl_Check_Button *)0;

static void cb_btn_enable_N3FJP_log(Fl_Check_Button* o, void*) {
  progdefaults.enable_N3FJP_log = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_connect_to_n3fjp=(Fl_Check_Button *)0;

static void cb_btn_connect_to_n3fjp(Fl_Check_Button* o, void*) {
  progdefaults.connect_to_n3fjp=o->value();
  progdefaults.changed=true;
}

Fl_Box *box_n3fjp_connected=(Fl_Box *)0;

Fl_Check_Button *btn_N3FJP_sweet_spot=(Fl_Check_Button *)0;

static void cb_btn_N3FJP_sweet_spot(Fl_Check_Button* o, void*) {
  progdefaults.N3FJP_sweet_spot = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_N3FJP_modem_carrier=(Fl_Check_Button *)0;

static void cb_btn_N3FJP_modem_carrier(Fl_Check_Button* o, void*) {
  progdefaults.N3FJP_modem_carrier = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_enable_N3FJP_RIGTX=(Fl_Check_Button *)0;

static void cb_btn_enable_N3FJP_RIGTX(Fl_Check_Button* o, void*) {
  progdefaults.enable_N3FJP_RIGTX = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpEQSL_www_url=(Fl_Input2 *)0;

static void cb_inpEQSL_www_url(Fl_Input2* o, void*) {
  progdefaults.eqsl_www_url = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpEQSL_id=(Fl_Input2 *)0;

static void cb_inpEQSL_id(Fl_Input2* o, void*) {
  progdefaults.eqsl_id = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpEQSL_pwd=(Fl_Input2 *)0;

static void cb_inpEQSL_pwd(Fl_Input2* o, void*) {
  progdefaults.eqsl_pwd = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnEQSL_pwd_show=(Fl_Button *)0;

static void cb_btnEQSL_pwd_show(Fl_Button* o, void*) {
  inpEQSL_pwd->type(inpEQSL_pwd->type() ^ FL_SECRET_INPUT);
  inpEQSL_pwd->redraw();
  o->label((inpEQSL_pwd->type() & FL_SECRET_INPUT) ? _("Show") : _("Hide"));
}

Fl_Input2 *inpEQSL_nick=(Fl_Input2 *)0;

static void cb_inpEQSL_nick(Fl_Input2* o, void*) {
  progdefaults.eqsl_nick = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_verify_eqsl=(Fl_Button *)0;

Fl_Check_Button *btn_send_when_logged=(Fl_Check_Button *)0;

static void cb_btn_send_when_logged(Fl_Check_Button* o, void*) {
  progdefaults.eqsl_when_logged = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_send_datetime_off=(Fl_Check_Button *)0;

static void cb_btn_send_datetime_off(Fl_Check_Button* o, void*) {
  progdefaults.eqsl_datetime_off = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_show_eqsl_delivery=(Fl_Check_Button *)0;

static void cb_btn_show_eqsl_delivery(Fl_Check_Button* o, void*) {
  progdefaults.eqsl_show_delivery = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txt_eqsl_default_message=(Fl_Input2 *)0;

static void cb_txt_eqsl_default_message(Fl_Input2* o, void*) {
  progdefaults.eqsl_default_message = o->value();
  progdefaults.changed = true;
}

Fl_Box *eqsl_txt1=(Fl_Box *)0;

Fl_Box *eqsl_txt2=(Fl_Box *)0;

Fl_Box *eqsl_txt3=(Fl_Box *)0;

Fl_Input2 *txt_lotw_pathname=(Fl_Input2 *)0;

static void cb_txt_lotw_pathname(Fl_Input2* o, void*) {
  progdefaults.lotw_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpLOTW_pwd=(Fl_Input2 *)0;

static void cb_inpLOTW_pwd(Fl_Input2* o, void*) {
  progdefaults.lotw_pwd = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_submit_lotw_password=(Fl_Check_Button *)0;

static void cb_btn_submit_lotw_password(Fl_Check_Button* o, void*) {
  progdefaults.submit_lotw_password=o->value();
  progdefaults.changed=true;
}

Fl_Input2 *inpLOTW_location=(Fl_Input2 *)0;

static void cb_inpLOTW_location(Fl_Input2* o, void*) {
  progdefaults.lotw_location = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_lotw=(Fl_Button *)0;

static void cb_btn_select_lotw(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.lotw_pathname);
  txt_lotw_pathname->value(str.c_str());
  progdefaults.lotw_pathname = str;
  progdefaults.changed = true;
}

Fl_Check_Button *btn_lotw_quiet_mode=(Fl_Check_Button *)0;

static void cb_btn_lotw_quiet_mode(Fl_Check_Button* o, void*) {
  progdefaults.lotw_quiet_mode=o->value();
  progdefaults.changed=true;
}

Fl_Check_Button *btn_submit_lotw=(Fl_Check_Button *)0;

static void cb_btn_submit_lotw(Fl_Check_Button* o, void*) {
  progdefaults.submit_lotw=o->value();
  progdefaults.changed=true;
}

Fl_Check_Button *btn_show_lotw_delivery=(Fl_Check_Button *)0;

static void cb_btn_show_lotw_delivery(Fl_Check_Button* o, void*) {
  progdefaults.lotw_show_delivery = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_export_lotw=(Fl_Button *)0;

static void cb_btn_export_lotw(Fl_Button*, void*) {
  cb_btnExportLoTW();
}

Fl_Button *btn_review_lotw=(Fl_Button *)0;

static void cb_btn_review_lotw(Fl_Button*, void*) {
  cb_review_lotw();
}

Fl_Button *btn_send_lotw=(Fl_Button *)0;

static void cb_btn_send_lotw(Fl_Button*, void*) {
  cb_send_lotw();
}

Fl_Button *btnLOTW_pwd_show=(Fl_Button *)0;

static void cb_btnLOTW_pwd_show(Fl_Button* o, void*) {
  inpLOTW_pwd->type(inpLOTW_pwd->type() ^ FL_SECRET_INPUT);
  inpLOTW_pwd->redraw();
  o->label((inpLOTW_pwd->type() & FL_SECRET_INPUT) ? _("Show") : _("Hide"));
}

Fl_Button *btn_verify_lotw=(Fl_Button *)0;

Fl_Button *btn_view_unmatched=(Fl_Button *)0;

Fl_Counter *cnt_tracefile_timeout=(Fl_Counter *)0;

static void cb_cnt_tracefile_timeout(Fl_Counter* o, void*) {
  progdefaults.tracefile_timeout = o->value();
}

Fl_Check_Button *btnEnCloudlog=(Fl_Check_Button *)0;

static void cb_btnEnCloudlog(Fl_Check_Button* o, void*) {
  btnEnCloudlog->value(o->value());
  progdefaults.EnCloudlog=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txt_cloudlog_api_url=(Fl_Input2 *)0;

static void cb_txt_cloudlog_api_url(Fl_Input2* o, void*) {
  progdefaults.cloudlog_api_url = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txt_cloudlog_api_key=(Fl_Input2 *)0;

static void cb_txt_cloudlog_api_key(Fl_Input2* o, void*) {
  progdefaults.cloudlog_api_key = o->value();
  progdefaults.changed = true;
}

Fl_Spinner *sp_cloudlog_station_id=(Fl_Spinner *)0;

static void cb_sp_cloudlog_station_id(Fl_Spinner* o, void*) {
  progdefaults.cloudlog_station_id=o->value();
  progdefaults.changed = true;
}

Fl_Button *btnTestApiKey=(Fl_Button *)0;

static void cb_btnTestApiKey(Fl_Button*, void*) {
  std::string url;
  std::string apiKey;
  url = txt_cloudlog_api_url->value();
  apiKey = txt_cloudlog_api_key->value();
  if (url.empty() || apiKey.empty()) {
    btnTestApiKey->labelcolor(FL_RED);
  } else if (test_api_key(url.c_str(), apiKey.c_str(), 5.0) == 0) {
    btnTestApiKey->color(FL_GREEN);
  } else if (test_api_key(url.c_str(), apiKey.c_str(), 5.0) == 1) {
    btnTestApiKey->color(FL_YELLOW);
  } else {
    btnTestApiKey->color(FL_RED);
  }
  progdefaults.changed = true;
}

Fl_Button *btnCLOUDselect=(Fl_Button *)0;

static void cb_btnCLOUDselect(Fl_Button*, void*) {
  wCLDfields->show();
}

Fl_Input2 *txt_udp_address=(Fl_Input2 *)0;

static void cb_txt_udp_address(Fl_Input2* o, void*) {
  progdefaults.udp_address = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txt_udp_port=(Fl_Input2 *)0;

static void cb_txt_udp_port(Fl_Input2* o, void*) {
  progdefaults.udp_port = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_enable_udp_logging=(Fl_Check_Button *)0;

static void cb_btn_enable_udp_logging(Fl_Check_Button* o, void*) {
  progdefaults.enable_udp_logging = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnUDPselect=(Fl_Button *)0;

static void cb_btnUDPselect(Fl_Button*, void*) {
  wUDPfields->show();
}

static void cb_TEST(Fl_Button*, void*) {
  udp_test();
}

Fl_Check_Button *btnNagMe=(Fl_Check_Button *)0;

static void cb_btnNagMe(Fl_Check_Button* o, void*) {
  btn2NagMe->value(o->value());
  progdefaults.NagMe=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnClearOnSave=(Fl_Check_Button *)0;

static void cb_btnClearOnSave(Fl_Check_Button* o, void*) {
  progdefaults.ClearOnSave=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCallUpperCase=(Fl_Check_Button *)0;

static void cb_btnCallUpperCase(Fl_Check_Button* o, void*) {
  progdefaults.calluppercase = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnAutoFillQSO=(Fl_Check_Button *)0;

static void cb_btnAutoFillQSO(Fl_Check_Button* o, void*) {
  progdefaults.autofill_qso_fields = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnDateTimeSort=(Fl_Check_Button *)0;

static void cb_btnDateTimeSort(Fl_Check_Button* o, void*) {
  progdefaults.sort_date_time_off = o->value();
  progdefaults.changed = true;
  reload_browser();
}

Fl_Check_Button *btndate_time_force=(Fl_Check_Button *)0;

static void cb_btndate_time_force(Fl_Check_Button* o, void*) {
  progdefaults.force_date_time = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnRSTindefault=(Fl_Check_Button *)0;

static void cb_btnRSTindefault(Fl_Check_Button* o, void*) {
  progdefaults.RSTin_default = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnRSTdefault=(Fl_Check_Button *)0;

static void cb_btnRSTdefault(Fl_Check_Button* o, void*) {
  progdefaults.RSTdefault = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpMyPower=(Fl_Input2 *)0;

static void cb_inpMyPower(Fl_Input2* o, void*) {
  progdefaults.mytxpower = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnDisplayLogbookRead=(Fl_Check_Button *)0;

static void cb_btnDisplayLogbookRead(Fl_Check_Button* o, void*) {
  progdefaults.DisplayLogbookRead = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_log_power_meter=(Fl_Check_Button *)0;

static void cb_btn_log_power_meter(Fl_Check_Button* o, void*) {
  progdefaults.log_power_meter=o->value();
  progdefaults.changed = true;
}

Fl_Counter *pwr_set_size=(Fl_Counter *)0;

static void cb_pwr_set_size(Fl_Counter* o, void*) {
  progdefaults.pwr_set_size = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_use_average_power=(Fl_Check_Button *)0;

static void cb_btn_use_average_power(Fl_Check_Button* o, void*) {
  progdefaults.report_average_power = o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntSoftStart=(Fl_Counter *)0;

static void cb_cntSoftStart(Fl_Counter* o, void*) {
  progdefaults.SoftStart = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_softPSK=(Fl_Check_Button *)0;

static void cb_btn_softPSK(Fl_Check_Button* o, void*) {
  progdefaults.softPSK = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_softMFSK=(Fl_Check_Button *)0;

static void cb_btn_softMFSK(Fl_Check_Button* o, void*) {
  progdefaults.softMFSK = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_softRTTY=(Fl_Check_Button *)0;

static void cb_btn_softRTTY(Fl_Check_Button* o, void*) {
  progdefaults.softRTTY = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_softTHOR=(Fl_Check_Button *)0;

static void cb_btn_softTHOR(Fl_Check_Button* o, void*) {
  progdefaults.softTHOR = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_softDOMINOEX=(Fl_Check_Button *)0;

static void cb_btn_softDOMINOEX(Fl_Check_Button* o, void*) {
  progdefaults.softDOMINOEX = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCWuseSOMdecoding=(Fl_Check_Button *)0;

static void cb_btnCWuseSOMdecoding(Fl_Check_Button* o, void*) {
  progdefaults.CWuseSOMdecoding = o->value();
            btncwsuseSOMdecoding->value(o->value());
  progdefaults.changed = true;
}

Fl_Value_Output *valCWrcvWPM=(Fl_Value_Output *)0;

static void cb_valCWrcvWPM(Fl_Value_Output*, void*) {
  progdefaults.changed = true;
}

Fl_Progress *prgsCWrcvWPM=(Fl_Progress *)0;

Fl_Check_Button *btnCWrcvTrack=(Fl_Check_Button *)0;

static void cb_btnCWrcvTrack(Fl_Check_Button* o, void*) {
  progdefaults.CWtrack = o->value();
            btncwsrcvTrack->value(o->value());
  progdefaults.changed = true;
}

Fl_Counter2 *cntCWrange=(Fl_Counter2 *)0;

static void cb_cntCWrange(Fl_Counter2* o, void*) {
  progdefaults.CWrange = (int)o->value();
  if (active_modem == cw_modem)
    cntcwsrange->value(progdefaults.CWrange);
  progdefaults.changed = true;
}

Fl_Choice *mnu_cwrx_attack=(Fl_Choice *)0;

static void cb_mnu_cwrx_attack(Fl_Choice* o, void*) {
  progdefaults.cwrx_attack = o->value();
  progdefaults.changed = true;
}

Fl_Choice *mnu_cwrx_decay=(Fl_Choice *)0;

static void cb_mnu_cwrx_decay(Fl_Choice* o, void*) {
  progdefaults.cwrx_decay = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_cw_tracking_defaults=(Fl_Button *)0;

static void cb_btn_cw_tracking_defaults(Fl_Button*, void*) {
  progdefaults.cwrx_attack = 1;
  progdefaults.cwrx_decay = 0;
  mnu_cwrx_attack->value(progdefaults.cwrx_attack);
  mnu_cwrx_decay->value(progdefaults.cwrx_decay);
  progdefaults.changed = true;
}

Fl_Check_Button *btnCWmfilt=(Fl_Check_Button *)0;

static void cb_btnCWmfilt(Fl_Check_Button* o, void*) {
  progdefaults.CWmfilt = o->value();
              btncwsmfilt->value(o->value());
  if (active_modem == cw_modem)
    active_modem->reset_rx_filter();
  progdefaults.changed = true;
}

Fl_Counter2 *cntCWbandwidth=(Fl_Counter2 *)0;

static void cb_cntCWbandwidth(Fl_Counter2* o, void*) {
  progdefaults.CWbandwidth = (int)o->value();
              cntcwsbandwidth->value(o->value());
  if (active_modem == cw_modem)
    active_modem->reset_rx_filter();
  progdefaults.changed = true;
}

Fl_Choice *mnu_CW_fillen=(Fl_Choice *)0;

static void cb_mnu_CW_fillen(Fl_Choice* o, void*) {
  progdefaults.CW_fillen = o->value();
              mnu_cws_fillen->value(o->value());
  if (active_modem == cw_modem)
    active_modem->reset_rx_filter();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_show_embedded_CW_controls=(Fl_Check_Button *)0;

static void cb_btn_show_embedded_CW_controls(Fl_Check_Button* o, void*) {
  progdefaults.show_CW_controls = o->value();
  UI_select();
  progdefaults.changed = true;
}

Fl_Value_Slider2 *sldrCWxmtWPM=(Fl_Value_Slider2 *)0;

static void cb_sldrCWxmtWPM(Fl_Value_Slider2* o, void*) {
  progdefaults.CWspeed = (int)o->value();
  cntCW_WPM->value(progdefaults.CWspeed);
  cntr_nanoCW_WPM->value(progdefaults.CWspeed);
  progdefaults.changed = true;
  sync_cw_parameters();
}

Fl_Counter2 *cntCWdefWPM=(Fl_Counter2 *)0;

static void cb_cntCWdefWPM(Fl_Counter2* o, void*) {
  progdefaults.defCWspeed = (int)o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntCWlowerlimit=(Fl_Counter *)0;

static void cb_cntCWlowerlimit(Fl_Counter* o, void*) {
  progdefaults.CWlowerlimit = (int)o->value();
  progdefaults.changed = true;
  sldrCWxmtWPM->minimum(progdefaults.CWlowerlimit);
  sldrCWxmtWPM->value(progdefaults.CWspeed);
  sldrCWxmtWPM->redraw();
  cntCWupperlimit->minimum(progdefaults.CWlowerlimit+20);
  cntCW_WPM->minimum(progdefaults.CWlowerlimit);
}

Fl_Counter *cntCWupperlimit=(Fl_Counter *)0;

static void cb_cntCWupperlimit(Fl_Counter* o, void*) {
  progdefaults.CWupperlimit = (int)o->value();
  progdefaults.changed = true;
  sldrCWxmtWPM->maximum(progdefaults.CWupperlimit);
  sldrCWxmtWPM->value(progdefaults.CWspeed);
  sldrCWxmtWPM->redraw();
  cntCWlowerlimit->maximum(progdefaults.CWupperlimit-20);
  cntCW_WPM->maximum(progdefaults.CWupperlimit);
}

Fl_Value_Slider2 *sldrCWfarnsworth=(Fl_Value_Slider2 *)0;

static void cb_sldrCWfarnsworth(Fl_Value_Slider2* o, void*) {
  progdefaults.CWfarnsworth = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCWusefarnsworth=(Fl_Check_Button *)0;

static void cb_btnCWusefarnsworth(Fl_Check_Button* o, void*) {
  progdefaults.CWusefarnsworth=o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider2 *sldrCWwordsworth=(Fl_Value_Slider2 *)0;

static void cb_sldrCWwordsworth(Fl_Value_Slider2* o, void*) {
  progdefaults.CWwordsworth = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCWusewordsworth=(Fl_Check_Button *)0;

static void cb_btnCWusewordsworth(Fl_Check_Button* o, void*) {
  progdefaults.CWusewordsworth=o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntCWdash2dot=(Fl_Counter2 *)0;

static void cb_cntCWdash2dot(Fl_Counter2* o, void*) {
  progdefaults.CWdash2dot=o->value();
  cnt_nanoCWdash2dot->value(progdefaults.CWdash2dot);
  progdefaults.changed = true;
}

Fl_Counter2 *cntCWrisetime=(Fl_Counter2 *)0;

static void cb_cntCWrisetime(Fl_Counter2* o, void*) {
  progdefaults.CWrisetime=o->value();
  progdefaults.changed = true;
}

Fl_ListBox *i_listboxQSKshape=(Fl_ListBox *)0;

static void cb_i_listboxQSKshape(Fl_ListBox* o, void*) {
  progdefaults.QSKshape = o->index();
  progdefaults.changed = true;
}

Fl_Counter2 *cntWeight=(Fl_Counter2 *)0;

static void cb_cntWeight(Fl_Counter2* o, void*) {
  progdefaults.CWweight = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnQSK=(Fl_Check_Button *)0;

static void cb_btnQSK(Fl_Check_Button* o, void*) {
  progdefaults.QSK = o->value();
  btnQSK2->value(o->value());
  progdefaults.changed = true;
  if (o->value()) {
    progdefaults.sig_on_right_channel = false;
    chkAudioStereoOut->value(0);
    progdefaults.PTTrightchannel = false;
    btnPTTrightchannel->value(0);
  }
}

Fl_Counter2 *cntQSKfrequency=(Fl_Counter2 *)0;

static void cb_cntQSKfrequency(Fl_Counter2* o, void*) {
  progdefaults.QSKfrequency=o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntPreTiming=(Fl_Counter2 *)0;

static void cb_cntPreTiming(Fl_Counter2* o, void*) {
  progdefaults.CWpre = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntPostTiming=(Fl_Counter2 *)0;

static void cb_cntPostTiming(Fl_Counter2* o, void*) {
  progdefaults.CWpost = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntQSKamp=(Fl_Counter2 *)0;

static void cb_cntQSKamp(Fl_Counter2* o, void*) {
  progdefaults.QSKamp=o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntQSKrisetime=(Fl_Counter2 *)0;

static void cb_cntQSKrisetime(Fl_Counter2* o, void*) {
  progdefaults.QSKrisetime=o->value();
  progdefaults.changed = true;
}

Fl_ListBox *i_listbox_test_char=(Fl_ListBox *)0;

static void cb_i_listbox_test_char(Fl_ListBox* o, void*) {
  progdefaults.TestChar = o->index();
}

Fl_Check_Button *btnQSKadjust=(Fl_Check_Button *)0;

static void cb_btnQSKadjust(Fl_Check_Button* o, void*) {
  progdefaults.QSKadjust = o->value();
}

static void cb_listbox_prosign(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[0] = ps[c];
  progdefaults.changed = true;
}

static void cb_listbox_prosign1(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[1] = ps[c];
  progdefaults.changed = true;
}

static void cb_listbox_prosign2(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[2] = ps[c];
  progdefaults.changed = true;
}

static void cb_listbox_prosign3(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[3] = ps[c];
  progdefaults.changed = true;
}

static void cb_listbox_prosign4(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[4] = ps[c];
  progdefaults.changed = true;
}

static void cb_listbox_prosign5(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[5] = ps[c];
  progdefaults.changed = true;
}

static void cb_listbox_prosign6(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[6] = ps[c];
  progdefaults.changed = true;
}

static void cb_listbox_prosign7(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[7] = ps[c];
  progdefaults.changed = true;;
}

Fl_ListBox *listbox_prosign[9]={(Fl_ListBox *)0};

static void cb_listbox_prosign8(Fl_ListBox* o, void*) {
  int c = o->index();
  for (int i = 0; i < 9; i++)
    if (listbox_prosign[i]->index() == c) {
      listbox_prosign[i]->index(12);
      progdefaults.CW_prosigns[i] = ' ';
    }
  o->index(c);
  char ps[] = "~%&+={}<>[] ";
  progdefaults.CW_prosigns[8] = ps[c];
  progdefaults.changed = true;
}

Fl_Check_Button *btnCW_use_paren=(Fl_Check_Button *)0;

static void cb_btnCW_use_paren(Fl_Check_Button* o, void*) {
  progdefaults.CW_use_paren=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCW_prosign_display=(Fl_Check_Button *)0;

static void cb_btnCW_prosign_display(Fl_Check_Button* o, void*) {
  progdefaults.CW_prosign_display=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_A_aelig=(Fl_Check_Button *)0;

static void cb_btn_A_aelig(Fl_Check_Button* o, void*) {
  progdefaults.A_aelig = o->value();
  if (progdefaults.A_aelig) {
  	progdefaults.A_umlaut = false;
  	btn_A_umlaut->value(0);
  }
  btn_A_umlaut->redraw();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_A_umlaut=(Fl_Check_Button *)0;

static void cb_btn_A_umlaut(Fl_Check_Button* o, void*) {
  progdefaults.A_umlaut = o->value();
  if (progdefaults.A_umlaut) {
  	progdefaults.A_aelig = false;
  	btn_A_aelig->value(0);
  }
  btn_A_aelig->redraw();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_A_ring=(Fl_Check_Button *)0;

static void cb_btn_A_ring(Fl_Check_Button* o, void*) {
  progdefaults.A_ring = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_O_acute=(Fl_Check_Button *)0;

static void cb_btn_O_acute(Fl_Check_Button* o, void*) {
  progdefaults.O_acute = o->value();
  if (progdefaults.O_acute) {
  	progdefaults.O_umlaut = false;
  	btn_O_umlaut->value(0);
  	progdefaults.O_slash = false;
  	btn_O_slash->value(0);
  }
  btn_O_umlaut->redraw();
  btn_O_slash->redraw();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_O_slash=(Fl_Check_Button *)0;

static void cb_btn_O_slash(Fl_Check_Button* o, void*) {
  progdefaults.O_slash = o->value();
  if (progdefaults.O_slash) {
  	progdefaults.O_umlaut = false;
  	btn_O_umlaut->value(0);
  	progdefaults.O_acute = false;
  	btn_O_acute->value(0);
  }
  btn_O_umlaut->redraw();
  btn_O_acute->redraw();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_O_umlaut=(Fl_Check_Button *)0;

static void cb_btn_O_umlaut(Fl_Check_Button* o, void*) {
  progdefaults.O_umlaut = o->value();
  if (progdefaults.O_umlaut) {
  	progdefaults.O_acute = false;
  	btn_O_acute->value(0);
  	progdefaults.O_slash = false;
  	btn_O_slash->value(0);
  }
  btn_O_acute->redraw();
  btn_O_slash->redraw();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_C_cedilla=(Fl_Check_Button *)0;

static void cb_btn_C_cedilla(Fl_Check_Button* o, void*) {
  progdefaults.C_cedilla = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_E_grave=(Fl_Check_Button *)0;

static void cb_btn_E_grave(Fl_Check_Button* o, void*) {
  progdefaults.E_grave = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_E_acute=(Fl_Check_Button *)0;

static void cb_btn_E_acute(Fl_Check_Button* o, void*) {
  progdefaults.E_acute = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_N_tilde=(Fl_Check_Button *)0;

static void cb_btn_N_tilde(Fl_Check_Button* o, void*) {
  progdefaults.N_tilde = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_U_umlaut=(Fl_Check_Button *)0;

static void cb_btn_U_umlaut(Fl_Check_Button* o, void*) {
  progdefaults.U_umlaut = o->value();
  if (progdefaults.U_umlaut) {
  	progdefaults.U_circ = false;
  	btn_U_circ->value(0);
  }
  btn_U_circ->redraw();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_U_circ=(Fl_Check_Button *)0;

static void cb_btn_U_circ(Fl_Check_Button* o, void*) {
  progdefaults.U_circ = o->value();
  if (progdefaults.U_circ) {
  	progdefaults.U_umlaut = false;
  	btn_U_umlaut->value(0);
  }
  btn_U_umlaut->redraw();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_backslash=(Fl_Check_Button *)0;

static void cb_btn_CW_backslash(Fl_Check_Button* o, void*) {
  progdefaults.CW_backslash = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_apostrophe=(Fl_Check_Button *)0;

static void cb_btn_CW_apostrophe(Fl_Check_Button* o, void*) {
  progdefaults.CW_apostrophe = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_quote=(Fl_Check_Button *)0;

static void cb_btn_CW_quote(Fl_Check_Button* o, void*) {
  progdefaults.CW_quote = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_dollar_sign=(Fl_Check_Button *)0;

static void cb_btn_CW_dollar_sign(Fl_Check_Button* o, void*) {
  progdefaults.CW_dollar_sign = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_open_paren=(Fl_Check_Button *)0;

static void cb_btn_CW_open_paren(Fl_Check_Button* o, void*) {
  progdefaults.CW_open_paren = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_close_paren=(Fl_Check_Button *)0;

static void cb_btn_CW_close_paren(Fl_Check_Button* o, void*) {
  progdefaults.CW_close_paren = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_colon=(Fl_Check_Button *)0;

static void cb_btn_CW_colon(Fl_Check_Button* o, void*) {
  progdefaults.CW_colon = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_semi_colon=(Fl_Check_Button *)0;

static void cb_btn_CW_semi_colon(Fl_Check_Button* o, void*) {
  progdefaults.CW_semi_colon = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_underscore=(Fl_Check_Button *)0;

static void cb_btn_CW_underscore(Fl_Check_Button* o, void*) {
  progdefaults.CW_underscore = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_at_symbol=(Fl_Check_Button *)0;

static void cb_btn_CW_at_symbol(Fl_Check_Button* o, void*) {
  progdefaults.CW_at_symbol = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_exclamation=(Fl_Check_Button *)0;

static void cb_btn_CW_exclamation(Fl_Check_Button* o, void*) {
  progdefaults.CW_exclamation = o->value();
  progdefaults.changed = true;
  CW_table_changed = true;
}

Fl_Check_Button *btn_CW_noise0=(Fl_Check_Button *)0;

static void cb_btn_CW_noise0(Fl_Check_Button* o, void*) {
  progdefaults.CW_noise = 0;
  if (o->value()) {
    btn_CW_noise1->value(0);
    btn_CW_noise2->value(0);
    btn_CW_noise3->value(0);
    }
  else
    progdefaults.CW_noise = 0;
  progdefaults.changed = true;
}

Fl_Check_Button *btn_CW_noise1=(Fl_Check_Button *)0;

static void cb_btn_CW_noise1(Fl_Check_Button* o, void*) {
  progdefaults.CW_noise = '*';
  if (o->value()) {
    btn_CW_noise0->value(0);
    btn_CW_noise2->value(0);
    btn_CW_noise3->value(0);
    }
  else
    progdefaults.CW_noise = 0;
  progdefaults.changed = true;
}

Fl_Check_Button *btn_CW_noise2=(Fl_Check_Button *)0;

static void cb_btn_CW_noise2(Fl_Check_Button* o, void*) {
  progdefaults.CW_noise = o->value();
  if (o->value()) {
    btn_CW_noise0->value(0);
    btn_CW_noise1->value(0);
    btn_CW_noise3->value(0);
    }
  else
    progdefaults.CW_noise = 0;
  progdefaults.changed = true;
}

Fl_Check_Button *btn_CW_noise3=(Fl_Check_Button *)0;

static void cb_btn_CW_noise3(Fl_Check_Button* o, void*) {
  progdefaults.CW_noise = ' ';
  if (o->value()) {
    btn_CW_noise0->value(0);
    btn_CW_noise1->value(0);
    btn_CW_noise2->value(0);
    }
  else
    progdefaults.CW_noise = 0;
  progdefaults.changed = true;
}

Fl_ComboBox *select_WK_CommPort=(Fl_ComboBox *)0;

static void cb_select_WK_CommPort(Fl_ComboBox* o, void*) {
  progStatus.WK_serial_port_name = o->value();
  select_WKFSK_CommPort->value(progStatus.WK_serial_port_name.c_str());
}

Fl_Light_Button *btn_WKCW_connect=(Fl_Light_Button *)0;

static void cb_btn_WKCW_connect(Fl_Light_Button* o, void*) {
  WKCW_connect(o->value());
}

Fl_Box *box_WK_wait=(Fl_Box *)0;

Fl_Box *box_WK_break_in=(Fl_Box *)0;

Fl_Box *box_WK_busy=(Fl_Box *)0;

Fl_Box *box_WK_xoff=(Fl_Box *)0;

Fl_Box *box_WK_keydown=(Fl_Box *)0;

Fl_ComboBox *choice_WK_keyer_mode=(Fl_ComboBox *)0;

static void cb_choice_WK_keyer_mode(Fl_ComboBox*, void*) {
  WK_change_choice_keyer_mode();
}

Fl_ComboBox *choice_WK_hang=(Fl_ComboBox *)0;

static void cb_choice_WK_hang(Fl_ComboBox*, void*) {
  WK_change_choice_hang();
}

Fl_ComboBox *choice_WK_sidetone=(Fl_ComboBox *)0;

static void cb_choice_WK_sidetone(Fl_ComboBox*, void*) {
  WK_change_choice_sidetone();
}

Fl_ComboBox *choice_WK_output_pins=(Fl_ComboBox *)0;

static void cb_choice_WK_output_pins(Fl_ComboBox*, void*) {
  WK_change_choice_output_pins();
}

Fl_Check_Button *btn_WK_use_pot=(Fl_Check_Button *)0;

static void cb_btn_WK_use_pot(Fl_Check_Button*, void*) {
  WK_use_pot_changed();
}

Fl_Output *txt_WK_wpm=(Fl_Output *)0;

Fl_Check_Button *btn_WK_swap=(Fl_Check_Button *)0;

static void cb_btn_WK_swap(Fl_Check_Button*, void*) {
  WK_change_btn_swap();
}

Fl_Check_Button *btn_WK_auto_space=(Fl_Check_Button *)0;

static void cb_btn_WK_auto_space(Fl_Check_Button*, void*) {
  WK_change_btn_auto_space();
}

Fl_Check_Button *btn_WK_ct_space=(Fl_Check_Button *)0;

static void cb_btn_WK_ct_space(Fl_Check_Button*, void*) {
  WK_change_btn_ct_space();
}

Fl_Check_Button *btn_WK_paddledog=(Fl_Check_Button *)0;

static void cb_btn_WK_paddledog(Fl_Check_Button*, void*) {
  WK_change_btn_paddledog();
}

Fl_Check_Button *btn_WK_cut_zeronine=(Fl_Check_Button *)0;

static void cb_btn_WK_cut_zeronine(Fl_Check_Button*, void*) {
  WK_change_btn_cut_zeronine();
}

Fl_Check_Button *btn_WK_paddle_echo=(Fl_Check_Button *)0;

static void cb_btn_WK_paddle_echo(Fl_Check_Button*, void*) {
  WK_change_btn_paddle_echo();
}

Fl_Check_Button *btn_WK_serial_echo=(Fl_Check_Button *)0;

static void cb_btn_WK_serial_echo(Fl_Check_Button*, void*) {
  WK_change_btn_serial_echo();
}

Fl_Check_Button *btn_WK_sidetone_on=(Fl_Check_Button *)0;

static void cb_btn_WK_sidetone_on(Fl_Check_Button*, void*) {
  WK_change_btn_sidetone_on();
}

Fl_Check_Button *btn_WK_tone_on=(Fl_Check_Button *)0;

static void cb_btn_WK_tone_on(Fl_Check_Button*, void*) {
  WK_change_btn_tone_on();
}

Fl_Check_Button *btn_WK_ptt_on=(Fl_Check_Button *)0;

static void cb_btn_WK_ptt_on(Fl_Check_Button*, void*) {
  WK_change_btn_ptt_on();
}

Fl_Counter *cntr_WK_min_wpm=(Fl_Counter *)0;

static void cb_cntr_WK_min_wpm(Fl_Counter* o, void*) {
  WK_change_cntr_min_wpm();
  if ((o->value() + cntr_WK_rng_wpm->value()) > 55)
    cntr_WK_rng_wpm->value(55 - o->value());
}

Fl_Counter *cntr_WK_rng_wpm=(Fl_Counter *)0;

static void cb_cntr_WK_rng_wpm(Fl_Counter* o, void*) {
  WK_change_cntr_rng_wpm();
  if ((cntr_WK_min_wpm->value() + o->value()) > 55)
  o->value(55 - cntr_WK_min_wpm->value());
}

Fl_Counter *cntr_WK_farnsworth=(Fl_Counter *)0;

static void cb_cntr_WK_farnsworth(Fl_Counter*, void*) {
  WK_change_cntr_farnsworth();
}

Fl_Counter *cntr_WK_cmd_wpm=(Fl_Counter *)0;

static void cb_cntr_WK_cmd_wpm(Fl_Counter*, void*) {
  WK_change_cntr_cmd_wpm();
}

Fl_Counter *cntr_WK_ratio=(Fl_Counter *)0;

static void cb_cntr_WK_ratio(Fl_Counter*, void*) {
  WK_change_cntr_ratio();
}

Fl_Counter *cntr_WK_comp=(Fl_Counter *)0;

static void cb_cntr_WK_comp(Fl_Counter*, void*) {
  WK_change_cntr_comp();
}

Fl_Counter *cntr_WK_first_ext=(Fl_Counter *)0;

static void cb_cntr_WK_first_ext(Fl_Counter*, void*) {
  WK_change_cntr_first_ext();
}

Fl_Counter *cntr_WK_sample=(Fl_Counter *)0;

static void cb_cntr_WK_sample(Fl_Counter*, void*) {
  WK_change_cntr_sample();
}

Fl_Counter *cntr_WK_weight=(Fl_Counter *)0;

static void cb_cntr_WK_weight(Fl_Counter*, void*) {
  WK_change_cntr_weight();
}

Fl_Counter *cntr_WK_leadin=(Fl_Counter *)0;

static void cb_cntr_WK_leadin(Fl_Counter*, void*) {
  WK_change_cntr_leadin();
}

Fl_Counter *cntr_WK_tail=(Fl_Counter *)0;

static void cb_cntr_WK_tail(Fl_Counter*, void*) {
  WK_change_cntr_tail();
}

Fl_Check_Button *btnK3NG=(Fl_Check_Button *)0;

static void cb_btnK3NG(Fl_Check_Button* o, void*) {
  progdefaults.WK_K3NGsketch = o->value();
  progdefaults.changed = true;
}

Fl_ComboBox *select_nanoCW_CommPort=(Fl_ComboBox *)0;

static void cb_select_nanoCW_CommPort(Fl_ComboBox* o, void*) {
  progdefaults.nanoIO_serial_port_name = o->value();
}

Fl_Light_Button *btn_nanoCW_connect=(Fl_Light_Button *)0;

static void cb_btn_nanoCW_connect(Fl_Light_Button* o, void*) {
  if (o->value()) {
    if (open_nanoCW()) {
      btn_nanoIO_connect->value(1);
      chk_nanoIO_CW_io->value(1);
    } else {
      o->value(0);
      btn_nanoIO_connect->value(0);
      chk_nanoIO_CW_io->value(0);
      chk_nanoIO_FSK_io->value(0);
    }
  } else {
    close_nanoIO();
    o->value(0);
    btn_nanoIO_connect->value(0);
    chk_nanoIO_FSK_io->value(0);
    chk_nanoIO_CW_io->value(0);
  }
}

Fl_Counter *cntr_nanoCW_paddle_WPM=(Fl_Counter *)0;

static void cb_cntr_nanoCW_paddle_WPM(Fl_Counter* o, void*) {
  progdefaults.CW_keyspeed = (int)o->value();
  set_nano_keyerWPM(progdefaults.CW_keyspeed);
  progdefaults.changed = true;
}

FTextView *txt_nano_CW_io=(FTextView *)0;

Fl_Counter *cntr_nanoCW_WPM=(Fl_Counter *)0;

static void cb_cntr_nanoCW_WPM(Fl_Counter* o, void*) {
  progdefaults.CWspeed = (int)o->value();
  cntCW_WPM->value(progdefaults.CWspeed);
  sldrCWxmtWPM->value(progdefaults.CWspeed);
  progdefaults.changed = true;
  sync_cw_parameters();
}

Fl_Counter2 *cnt_nanoCWdash2dot=(Fl_Counter2 *)0;

static void cb_cnt_nanoCWdash2dot(Fl_Counter2* o, void*) {
  progdefaults.CWdash2dot=o->value();
  cntCWdash2dot->value(progdefaults.CWdash2dot);
  progdefaults.changed = true;
}

Fl_ListBox *listbox_nanoIO_serbaud=(Fl_ListBox *)0;

static void cb_listbox_nanoIO_serbaud(Fl_ListBox* o, void*) {
  progdefaults.nanoIO_serbaud = o->index();
  listbox_nanoIO_serbaud2->index(o->index());
  progdefaults.changed = true;
}

Fl_ListBox *listbox_nano_keyer=(Fl_ListBox *)0;

static void cb_listbox_nano_keyer(Fl_ListBox* o, void*) {
  progdefaults.nanoIO_CW_keyer = o->index();
  set_nanoIO_keyer(o->index());
  progdefaults.changed = true;
}

Fl_ListBox *listbox_incr=(Fl_ListBox *)0;

static void cb_listbox_incr(Fl_ListBox* o, void*) {
  progdefaults.nanoIO_CW_incr = o->index() + '1';
  set_nanoIO_incr();
  progdefaults.changed = true;
}

Fl_Button *btn_cwfsk_save=(Fl_Button *)0;

static void cb_btn_cwfsk_save(Fl_Button*, void*) {
  nano_CW_save();
}

Fl_Button *btn_cwfsk_query=(Fl_Button *)0;

static void cb_btn_cwfsk_query(Fl_Button*, void*) {
  nano_CW_query();
}

Fl_Check_Button *btn_nanoIO_pot=(Fl_Check_Button *)0;

static void cb_btn_nanoIO_pot(Fl_Check_Button* o, void*) {
  progdefaults.nanoIO_speed_pot=o->value();
  progdefaults.changed=true;
  nanoIO_use_pot();
}

Fl_Counter *cntr_nanoIO_min_wpm=(Fl_Counter *)0;

static void cb_cntr_nanoIO_min_wpm(Fl_Counter* o, void*) {
  if ((o->value() + cntr_nanoIO_rng_wpm->value()) > 100)
    cntr_nanoIO_rng_wpm->value(100 - o->value());
  set_nanoIO_min_max();
}

Fl_Counter *cntr_nanoIO_rng_wpm=(Fl_Counter *)0;

static void cb_cntr_nanoIO_rng_wpm(Fl_Counter* o, void*) {
  if ((cntr_nanoIO_min_wpm->value() + o->value()) > 100)
  o->value(100 - cntr_nanoIO_min_wpm->value());
  set_nanoIO_min_max();
}

Fl_Check_Button *btn_disable_CW_PTT=(Fl_Check_Button *)0;

static void cb_btn_disable_CW_PTT(Fl_Check_Button* o, void*) {
  progdefaults.disable_CW_PTT=o->value();
  progdefaults.changed=true;
  nanoIO_set_cw_ptt();
}

Fl_Counter *cntrWPMtest=(Fl_Counter *)0;

static void cb_cntrWPMtest(Fl_Counter* o, void*) {
  progdefaults.nanoCW_test_wpm = o->value();
  progdefaults.changed=true;
}

Fl_Button *btn_cal_variable=(Fl_Button *)0;

static void cb_btn_cal_variable(Fl_Button*, void*) {
  nanoIO_wpm_cal();
}

Fl_Value_Input *corr_var_wpm=(Fl_Value_Input *)0;

Fl_Value_Input *usec_correc=(Fl_Value_Input *)0;

Fl_Button *btn_correction=(Fl_Button *)0;

static void cb_btn_correction(Fl_Button*, void*) {
  nanoIO_correction();
}

Fl_Check_Button *chk_nanoIO_CW_io=(Fl_Check_Button *)0;

static void cb_chk_nanoIO_CW_io(Fl_Check_Button* o, void*) {
  if (o->value() == 0) {
    o->value(1);
    return;
  }
  set_nanoCW();
  chk_nanoIO_FSK_io->value(0);
}

Fl_Check_Button *btn_CW_KEYLINE_flrig=(Fl_Check_Button *)0;

static void cb_btn_CW_KEYLINE_flrig(Fl_Check_Button* o, void*) {
  int val = o->value();
  progdefaults.use_FLRIGkeying = val;
  if (val) {
    progdefaults.CW_KEYLINE_on_cat_port = 0;
    progdefaults.CW_KEYLINE_on_ptt_port = 0;
    btn_CW_KEYLINE_catport->value(0);
    btn_CW_KEYLINE_shared_PTT->value(0);
  }
  progdefaults.CW_KEYLINE_changed = true;
}

Fl_Check_Button *btn_FLRIG_CW_disable_ptt=(Fl_Check_Button *)0;

static void cb_btn_FLRIG_CW_disable_ptt(Fl_Check_Button* o, void*) {
  progdefaults.CATkeying_disable_ptt = o->value();
  btn_CAT_CW_disable_ptt->value(o->value());
  progdefaults.changed = true;
}

Fl_Check_Button *btn_CW_KEYLINE_catport=(Fl_Check_Button *)0;

static void cb_btn_CW_KEYLINE_catport(Fl_Check_Button* o, void*) {
  int val = o->value();
  progdefaults.CW_KEYLINE_on_cat_port = val;
  if (val) {
    progdefaults.CW_KEYLINE_on_ptt_port = 0;
    progdefaults.use_FLRIGkeying = 0;
    btn_CW_KEYLINE_shared_PTT->value(0);
    btn_CW_KEYLINE_flrig->value(0);
  }
  progdefaults.CW_KEYLINE_changed = true;
}

Fl_Check_Button *btn_CW_KEYLINE_shared_PTT=(Fl_Check_Button *)0;

static void cb_btn_CW_KEYLINE_shared_PTT(Fl_Check_Button* o, void*) {
  int val = o->value();
  progdefaults.CW_KEYLINE_on_ptt_port = val;
  if (val) {
    progdefaults.CW_KEYLINE_on_cat_port = 0;
    progdefaults.use_FLRIGkeying = 0;
    btn_CW_KEYLINE_catport->value(0);
    btn_CW_KEYLINE_flrig->value(0);
  }
  progdefaults.CW_KEYLINE_changed = true;
}

Fl_ListBox *listbox_CW_KEYLINE=(Fl_ListBox *)0;

static void cb_listbox_CW_KEYLINE(Fl_ListBox* o, void*) {
  progdefaults.CW_KEYLINE = o->index();
}

Fl_Counter2 *cntCWkeycomp=(Fl_Counter2 *)0;

static void cb_cntCWkeycomp(Fl_Counter2* o, void*) {
  progdefaults.CWkeycomp =o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_PTT_KEYLINE=(Fl_ListBox *)0;

static void cb_listbox_PTT_KEYLINE(Fl_ListBox* o, void*) {
  progdefaults.PTT_KEYLINE = o->index();
  progdefaults.changed = true;
}

Fl_ComboBox *select_CW_KEYLINE_CommPort=(Fl_ComboBox *)0;

static void cb_select_CW_KEYLINE_CommPort(Fl_ComboBox* o, void*) {
  progdefaults.CW_KEYLINE_serial_port_name = o->value();

  if (progStatus.useCW_KEYLINE) {
    close_CW_KEYLINE();
    if (!open_CW_KEYLINE()) {
      btn_CW_KEYLINE_connect->value(0);
      progStatus.useCW_KEYLINE = 0;
    }
      progStatus.useCW_KEYLINE = 1;
  }
  progdefaults.CW_KEYLINE_changed = true;
}

Fl_Light_Button *btn_CW_KEYLINE_connect=(Fl_Light_Button *)0;

static void cb_btn_CW_KEYLINE_connect(Fl_Light_Button* o, void*) {
  if (o->value()) {
    if (!open_CW_KEYLINE())
      o->value(0);
    else {
  	progStatus.useCW_KEYLINE = 1;
  	btn_use_ELCTkeying->value(0);
  	btn_use_KNWDkeying->value(0);
  	btn_use_ICOMkeying->value(0);
  	btn_use_YAESUkeying->value(0);
  	progdefaults.use_ELCTkeying = 0;
  	progdefaults.use_ICOMkeying = 0;
  	progdefaults.use_KNWDkeying = 0;
  	progdefaults.use_YAESUkeying = 0;
    }
  } else {
    close_CW_KEYLINE();
    progStatus.useCW_KEYLINE = 0;
  }
}

Fl_Light_Button *btn_cw_dtr_calibrate=(Fl_Light_Button *)0;

static void cb_btn_cw_dtr_calibrate(Fl_Light_Button*, void*) {
  calibrate_cwio();
}

Fl_Output *cwio_test_result=(Fl_Output *)0;

Fl_Check_Button *btn_use_ICOMkeying=(Fl_Check_Button *)0;

static void cb_btn_use_ICOMkeying(Fl_Check_Button* o, void*) {
  progdefaults.use_ICOMkeying = o->value();
  if (o->value()) {
    btn_use_ELCTkeying->value(0);
    btn_use_KNWDkeying->value(0);
    btn_use_YAESUkeying->value(0);
    progdefaults.use_ELCTkeying = 0;
    progdefaults.use_KNWDkeying = 0;
    progdefaults.use_YAESUkeying = 0;
    close_CW_KEYLINE();
    progStatus.useCW_KEYLINE = 0;
    btn_cw_dtr_calibrate->value(0);
    }
  progdefaults.changed=true;
}

Fl_Input *val_ICOMcivaddr=(Fl_Input *)0;

static void cb_val_ICOMcivaddr(Fl_Input* o, void*) {
  progdefaults.ICOMcivaddr=o->value();
  progdefaults.changed=true;
}

Fl_Check_Button *btn_use_ELCTkeying=(Fl_Check_Button *)0;

static void cb_btn_use_ELCTkeying(Fl_Check_Button* o, void*) {
  progdefaults.use_ELCTkeying = o->value();
  if (o->value()) {
    btn_use_YAESUkeying->value(0);
    btn_use_ICOMkeying->value(0);
    btn_use_KNWDkeying->value(0);
    progdefaults.use_YAESUkeying = 0;
    progdefaults.use_ICOMkeying = 0;
    progdefaults.use_KNWDkeying = 0;
    close_CW_KEYLINE();
    progStatus.useCW_KEYLINE = 0;
    btn_cw_dtr_calibrate->value(0);
    }
  progdefaults.changed=true;
}

Fl_Check_Button *btn_use_KNWDkeying=(Fl_Check_Button *)0;

static void cb_btn_use_KNWDkeying(Fl_Check_Button* o, void*) {
  progdefaults.use_KNWDkeying = o->value();
  if (o->value()) {
    btn_use_YAESUkeying->value(0);
    btn_use_ICOMkeying->value(0);
    btn_use_ELCTkeying->value(0);
    progdefaults.use_YAESUkeying = 0;
    progdefaults.use_ICOMkeying = 0;
    progdefaults.use_ELCTkeying = 0;
    close_CW_KEYLINE();
    progStatus.useCW_KEYLINE = 0;
    btn_cw_dtr_calibrate->value(0);
    }
  progdefaults.changed=true;
}

Fl_Check_Button *btn_use_YAESUkeying=(Fl_Check_Button *)0;

static void cb_btn_use_YAESUkeying(Fl_Check_Button* o, void*) {
  progdefaults.use_YAESUkeying = o->value();
  if (o->value()) {
    btn_use_ELCTkeying->value(0);
    btn_use_KNWDkeying->value(0);
    btn_use_ICOMkeying->value(0);
    progdefaults.use_ELCTkeying = 0;
    progdefaults.use_KNWDkeying = 0;
    progdefaults.use_ICOMkeying = 0;
    close_CW_KEYLINE();
    progStatus.useCW_KEYLINE = 0;
    btn_cw_dtr_calibrate->value(0);
    }
  progdefaults.changed=true;
}

Fl_Check_Button *btn_CAT_CW_disable_ptt=(Fl_Check_Button *)0;

static void cb_btn_CAT_CW_disable_ptt(Fl_Check_Button* o, void*) {
  progdefaults.CATkeying_disable_ptt = o->value();
  btn_FLRIG_CW_disable_ptt->value(o->value());
  progdefaults.changed = true;
}

Fl_Button *btn_CAT_keying_calibrate=(Fl_Button *)0;

static void cb_btn_CAT_keying_calibrate(Fl_Button*, void*) {
  CAT_keying_calibrate();
}

Fl_Value_Input *out_CATkeying_compensation=(Fl_Value_Input *)0;

static void cb_out_CATkeying_compensation(Fl_Value_Input* o, void*) {
  progdefaults.CATkeying_compensation = o->value() * 1000;
  progdefaults.changed=true;
}

Fl_Button *btn_CAT_keying_clear=(Fl_Button *)0;

static void cb_btn_CAT_keying_clear(Fl_Button*, void*) {
  progdefaults.CATkeying_compensation = 0;
  out_CATkeying_compensation->value(0);
  out_CATkeying_test_result->value(0);
}

Fl_Button *btn_CAT_keying_test=(Fl_Button *)0;

static void cb_btn_CAT_keying_test(Fl_Button*, void*) {
  CAT_keying_test();
}

Fl_Value_Input *out_CATkeying_test_result=(Fl_Value_Input *)0;

Fl_Input2 *txtSecondary=(Fl_Input2 *)0;

static void cb_txtSecondary(Fl_Input2* o, void*) {
  progdefaults.secText = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *valDominoEX_FILTER=(Fl_Check_Button *)0;

static void cb_valDominoEX_FILTER(Fl_Check_Button* o, void*) {
  progdefaults.DOMINOEX_FILTER = o->value();
  resetDOMEX();
  progdefaults.changed = true;
}

Fl_Counter2 *valDominoEX_BW=(Fl_Counter2 *)0;

static void cb_valDominoEX_BW(Fl_Counter2* o, void*) {
  progdefaults.DOMINOEX_BW = o->value();
  resetDOMEX();
  progdefaults.changed = true;
}

Fl_Check_Button *chkDominoEX_FEC=(Fl_Check_Button *)0;

static void cb_chkDominoEX_FEC(Fl_Check_Button* o, void*) {
  progdefaults.DOMINOEX_FEC = o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider2 *valDomCWI=(Fl_Value_Slider2 *)0;

static void cb_valDomCWI(Fl_Value_Slider2* o, void*) {
  progdefaults.DomCWI = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *valDominoEX_PATHS=(Fl_Counter2 *)0;

static void cb_valDominoEX_PATHS(Fl_Counter2* o, void*) {
  progdefaults.DOMINOEX_PATHS = (int)o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listboxHellFont=(Fl_ListBox *)0;

static void cb_listboxHellFont(Fl_ListBox* o, void*) {
  progdefaults.feldfontnbr=o->index();
  progdefaults.changed = true;
}

Fl_ListBox *listboxHellPulse=(Fl_ListBox *)0;

static void cb_listboxHellPulse(Fl_ListBox* o, void*) {
  progdefaults.HellPulseFast = o->index();
  progdefaults.changed = true;
}

Fl_Check_Button *btnFeldHellIdle=(Fl_Check_Button *)0;

static void cb_btnFeldHellIdle(Fl_Check_Button* o, void*) {
  progdefaults.HellXmtIdle=o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider *valHellXmtWidth=(Fl_Value_Slider *)0;

static void cb_valHellXmtWidth(Fl_Value_Slider* o, void*) {
  progdefaults.HellXmtWidth=(int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnBlackboard=(Fl_Check_Button *)0;

static void cb_btnBlackboard(Fl_Check_Button* o, void*) {
  progdefaults.HellBlackboard=o->value();
  FHdisp->reverse(progdefaults.HellBlackboard);
  progdefaults.changed = true;
}

Fl_Check_Button *btnHellMarquee=(Fl_Check_Button *)0;

static void cb_btnHellMarquee(Fl_Check_Button* o, void*) {
  progdefaults.HellMarquee=o->value();
  FHdisp->set_marquee(progdefaults.HellMarquee);
  progdefaults.changed = true;
}

Fl_Value_Slider *valHellRcvWidth=(Fl_Value_Slider *)0;

static void cb_valHellRcvWidth(Fl_Value_Slider* o, void*) {
  progdefaults.HellRcvWidth=(int)o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider *valHellRcvHeight=(Fl_Value_Slider *)0;

static void cb_valHellRcvHeight(Fl_Value_Slider*, void*) {
  FHdisp_char_height();
}

Fl_Value_Slider2 *sldrHellBW=(Fl_Value_Slider2 *)0;

static void cb_sldrHellBW(Fl_Value_Slider2*, void*) {
  progdefaults.HELL_BW = sldrHellBW->value();
}

Fl_Value_Slider *val_hellagc=(Fl_Value_Slider *)0;

static void cb_val_hellagc(Fl_Value_Slider* o, void*) {
  progdefaults.hellagc=(int)o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_fmt_sr=(Fl_ListBox *)0;

static void cb_listbox_fmt_sr(Fl_ListBox* o, void*) {
  progdefaults.FMT_sr=o->index();
  progdefaults.changed = true;
}

Fl_Counter *cnt_fmt_rx_ppm=(Fl_Counter *)0;

static void cb_cnt_fmt_rx_ppm(Fl_Counter* o, void*) {
  progdefaults.RX_corr = (int)o->value();
  cntRxRateCorr->value(progdefaults.RX_corr);
  progdefaults.changed = true;
}

Fl_Button *btnFMT_plot_background=(Fl_Button *)0;

static void cb_btnFMT_plot_background(Fl_Button*, void*) {
  TRIAD clr = ui_colors.FMT_background;
  if (!fl_color_chooser("FMT Background", clr.r, clr.g, clr.b))
    return;
  ui_colors.FMT_background = clr;

  fmt_plot->bk_color(RGBCOLOR(FMT_background));
  fmt_plot->redraw();
  progdefaults.changed = true;
}

Fl_Button *btnFMT_unk_color=(Fl_Button *)0;

static void cb_btnFMT_unk_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.FMT_unk_color;
  if (!fl_color_chooser("FMT Background", clr.r, clr.g, clr.b))
    return;
  ui_colors.FMT_unk_color = clr;
  fmt_plot->line_color_1(RGBCOLOR(FMT_unk_color));
  fmt_plot->redraw();
  unk_color->color(RGBCOLOR(FMT_unk_color));
  unk_color->redraw();
  progdefaults.changed = true;
}

Fl_Button *btnFMT_plot_ref_color=(Fl_Button *)0;

static void cb_btnFMT_plot_ref_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.FMT_ref_color;
  if (!fl_color_chooser("FMT Background", clr.r, clr.g, clr.b))
      return;
  ui_colors.FMT_ref_color = clr;
  fmt_plot->line_color_2(RGBCOLOR(FMT_ref_color));
  fmt_plot->redraw();
  ref_color->color(RGBCOLOR(FMT_ref_color));
  ref_color->redraw();
  progdefaults.changed = true;
}

Fl_Button *btnFMT_plot_axis=(Fl_Button *)0;

static void cb_btnFMT_plot_axis(Fl_Button*, void*) {
  TRIAD clr = ui_colors.FMT_axis_color;
  if (!fl_color_chooser("FMT Axis Color", clr.r, clr.g, clr.b))
      return;
  ui_colors.FMT_axis_color = clr;
  fmt_plot->axis_color(RGBCOLOR(FMT_axis_color));
  fmt_plot->redraw();
  progdefaults.changed = true;
}

Fl_Button *btnFMT_legend_color=(Fl_Button *)0;

static void cb_btnFMT_legend_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.FMT_legend_color;
  if (!fl_color_chooser("FMT Legend Color", clr.r, clr.g, clr.b))
      return;
  ui_colors.FMT_legend_color = clr;
  fmt_plot->legend_color(RGBCOLOR(FMT_legend_color));
  fmt_plot->redraw();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_plot_over_axis=(Fl_Check_Button *)0;

static void cb_btn_fmt_plot_over_axis(Fl_Check_Button* o, void*) {
  progdefaults.FMT_plot_over_axis = o->value();
  fmt_plot->plot_over_axis(progdefaults.FMT_plot_over_axis);
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_thick_lines=(Fl_Check_Button *)0;

static void cb_btn_fmt_thick_lines(Fl_Check_Button* o, void*) {
  progdefaults.FMT_thick_lines = o->value();
  fmt_plot->thick_lines(progdefaults.FMT_thick_lines);
  progdefaults.changed = true;
}

Fl_Counter *cnt_fmt_freq_corr=(Fl_Counter *)0;

static void cb_cnt_fmt_freq_corr(Fl_Counter* o, void*) {
  progdefaults.FMT_freq_corr=o->value();
  progdefaults.RIT=progdefaults.FMT_freq_corr;
  cntRIT->value(progdefaults.RIT);
  progdefaults.changed = true;
}

Fl_Button *bnt_FMT_dec_corr=(Fl_Button *)0;

static void cb_bnt_FMT_dec_corr(Fl_Button*, void*) {
  progdefaults.FMT_freq_corr -= 0.1;
  cnt_fmt_freq_corr->value(progdefaults.FMT_freq_corr);
  progdefaults.RIT=progdefaults.FMT_freq_corr;
  cntRIT->value(progdefaults.RIT);
  progdefaults.changed = true;
}

Fl_Button *btn_FMT_incr_corr=(Fl_Button *)0;

static void cb_btn_FMT_incr_corr(Fl_Button*, void*) {
  progdefaults.FMT_freq_corr += 0.1;
  cnt_fmt_freq_corr->value(progdefaults.FMT_freq_corr);
  progdefaults.RIT=progdefaults.FMT_freq_corr;
  cntRIT->value(progdefaults.RIT);
  progdefaults.changed = true;
}

Fl_Counter *cnt_fmt_freq_err=(Fl_Counter *)0;

static void cb_cnt_fmt_freq_err(Fl_Counter* o, void*) {
  progdefaults.FMT_freq_err=o->value();
  progdefaults.changed = true;
}

Fl_Counter *cnt_FMT_movavg_len=(Fl_Counter *)0;

static void cb_cnt_FMT_movavg_len(Fl_Counter* o, void*) {
  progdefaults.FMT_movavg_len = o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_fmt_dft_rate=(Fl_ListBox *)0;

static void cb_listbox_fmt_dft_rate(Fl_ListBox* o, void*) {
  progdefaults.FMT_dft_rate=o->index();
  progdefaults.changed = true;
}

Fl_Counter *cnt_FMT_bpf=(Fl_Counter *)0;

static void cb_cnt_FMT_bpf(Fl_Counter* o, void*) {
  progdefaults.FMT_bpf_width = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_unk_bpf_on=(Fl_Check_Button *)0;

static void cb_btn_fmt_unk_bpf_on(Fl_Check_Button* o, void*) {
  progdefaults.FMT_unk_bpf_on = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_ref_bpf_on=(Fl_Check_Button *)0;

static void cb_btn_fmt_ref_bpf_on(Fl_Check_Button* o, void*) {
  progdefaults.FMT_ref_bpf_on = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_autorecord=(Fl_Check_Button *)0;

Fl_Counter *cnt_fmt_auto_record_time=(Fl_Counter *)0;

Fl_Check_Button *btn_fmt_record_wav=(Fl_Check_Button *)0;

static void cb_btn_fmt_record_wav(Fl_Check_Button* o, void*) {
  cb_fmt_record_wav(o->value());
  if (o->value() == 1)
    btn_fmt_sync_wav->deactivate();
  else
    btn_fmt_sync_wav->activate();
}

Fl_Check_Button *btn_fmt_sync_wav=(Fl_Check_Button *)0;

static void cb_btn_fmt_sync_wav(Fl_Check_Button* o, void*) {
  progdefaults.fmt_sync_wav_file = o->value();
  if (o->value() == 1)
    btn_fmt_record_wav->deactivate();
  else
    btn_fmt_record_wav->activate();
  progdefaults.changed = true;
}

Fl_Output *txt_fmt_wav_filename=(Fl_Output *)0;

Fl_Check_Button *btn_fmt_center_on_unknown=(Fl_Check_Button *)0;

static void cb_btn_fmt_center_on_unknown(Fl_Check_Button* o, void*) {
  progdefaults.fmt_center_on_unknown = o->value();
  if (o->value()) {
    progdefaults.fmt_center_on_median = 0;
    progdefaults.fmt_center_on_reference = 0;
    btn_fmt_center_on_median->value(0);
    btn_fmt_center_on_reference->value(0);
  }
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_center_on_reference=(Fl_Check_Button *)0;

static void cb_btn_fmt_center_on_reference(Fl_Check_Button* o, void*) {
  progdefaults.fmt_center_on_reference = o->value();
  if (o->value()) {
    progdefaults.fmt_center_on_unknown = 0;
    progdefaults.fmt_center_on_median = 0;
    btn_fmt_center_on_median->value(0);
    btn_fmt_center_on_unknown->value(0);
  }
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_center_on_median=(Fl_Check_Button *)0;

static void cb_btn_fmt_center_on_median(Fl_Check_Button* o, void*) {
  progdefaults.fmt_center_on_median = o->value();
  if (o->value()) {
    progdefaults.fmt_center_on_unknown = 0;
    progdefaults.fmt_center_on_reference = 0;
    btn_fmt_center_on_unknown->value(0);
    btn_fmt_center_on_reference->value(0);
  }
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fmt_use_tabs=(Fl_Check_Button *)0;

static void cb_btn_fmt_use_tabs(Fl_Check_Button* o, void*) {
  progdefaults.FMT_use_tabs = o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider *valhits=(Fl_Value_Slider *)0;

static void cb_valhits(Fl_Value_Slider* o, void*) {
  progdefaults.fsqhits=(int)o->value();
  progdefaults.changed = true;
}

Fl_Choice *sel_fsq_lpf=(Fl_Choice *)0;

static void cb_sel_fsq_lpf(Fl_Choice* o, void*) {
  progdefaults.fsq_img_filter=o->value();
  progdefaults.changed = true;
}

Fl_Value_Slider *sldrMovAvg=(Fl_Value_Slider *)0;

static void cb_sldrMovAvg(Fl_Value_Slider* o, void*) {
  progdefaults.fsq_movavg = o->value();
  progdefaults.changed = true;
}

Fl_Choice *sel_fsq_heard_aging=(Fl_Choice *)0;

static void cb_sel_fsq_heard_aging(Fl_Choice* o, void*) {
  progdefaults.fsq_heard_aging=o->value();
  progdefaults.changed = true;
}

static void cb_btn_fsqbaud(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.fsqbaud = 1.5;
  btn_fsqbaud[1]->value(0);
  btn_fsqbaud[2]->value(0);
  btn_fsqbaud[3]->value(0);
  btn_fsqbaud[4]->value(0);
  }
  progdefaults.changed = true;
}

static void cb_btn_fsqbaud1(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.fsqbaud = 2;
  btn_fsqbaud[0]->value(0);
  btn_fsqbaud[2]->value(0);
  btn_fsqbaud[3]->value(0);
  btn_fsqbaud[4]->value(0);
  }
  progdefaults.changed = true;
}

static void cb_btn_fsqbaud2(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.fsqbaud = 3;
  btn_fsqbaud[0]->value(0);
  btn_fsqbaud[1]->value(0);
  btn_fsqbaud[3]->value(0);
  btn_fsqbaud[4]->value(0);
  }
  progdefaults.changed = true;
}

static void cb_btn_fsqbaud3(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.fsqbaud = 4.5;
  btn_fsqbaud[0]->value(0);
  btn_fsqbaud[1]->value(0);
  btn_fsqbaud[2]->value(0);
  btn_fsqbaud[4]->value(0);
  }
  progdefaults.changed = true;
}

Fl_Round_Button *btn_fsqbaud[5]={(Fl_Round_Button *)0};

static void cb_btn_fsqbaud4(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.fsqbaud = 6;
  btn_fsqbaud[0]->value(0);
  btn_fsqbaud[1]->value(0);
  btn_fsqbaud[2]->value(0);
  btn_fsqbaud[3]->value(0);
  }
  progdefaults.changed = true;
}

Fl_Choice *sel_fsq_sounder=(Fl_Choice *)0;

static void cb_sel_fsq_sounder(Fl_Choice* o, void*) {
  progdefaults.fsq_sounder=o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntr_FSQ_time_out=(Fl_Counter *)0;

static void cb_cntr_FSQ_time_out(Fl_Counter* o, void*) {
  progdefaults.fsq_time_out = o->value();
  progdefaults.changed = true;
}

static void cb_QTC(Fl_Input* o, void*) {
  progdefaults.fsqQTCtext = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fsq_lowercase=(Fl_Check_Button *)0;

static void cb_btn_fsq_lowercase(Fl_Check_Button* o, void*) {
  progdefaults.fsq_lowercase=o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpMyFSQQth=(Fl_Input2 *)0;

static void cb_inpMyFSQQth(Fl_Input2* o, void*) {
  progdefaults.myQth = o->value();
  inpMyQth->value(o->value());
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fsq_msg_dt_stamp=(Fl_Check_Button *)0;

static void cb_btn_fsq_msg_dt_stamp(Fl_Check_Button* o, void*) {
  progdefaults.add_fsq_msg_dt=o->value();
  progdefaults.changed=true;
}

Fl_Check_Button *btn_fsq_msg_append=(Fl_Check_Button *)0;

static void cb_btn_fsq_msg_append(Fl_Check_Button* o, void*) {
  progdefaults.always_append=o->value();
  progdefaults.changed=true;
}

Fl_Counter *cntr_FSQ_notify_time_out=(Fl_Counter *)0;

static void cb_cntr_FSQ_notify_time_out(Fl_Counter* o, void*) {
  progdefaults.fsq_notify_time_out = o->value();
  progdefaults.changed = true;
}

Fl_Output *txtAuditLog=(Fl_Output *)0;

Fl_Light_Button *btn_enable_auditlog=(Fl_Light_Button *)0;

static void cb_btn_enable_auditlog(Fl_Light_Button* o, void*) {
  progdefaults.fsq_enable_audit_log = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_auditlog=(Fl_Button *)0;

static void cb_btn_select_auditlog(Fl_Button*, void*) {
  std::string str = std::string(TempDir);
  str.append(progdefaults.fsq_audit_log);
  const char *fname = FSEL::saveas("Audit log", "*.txt\t*", str.c_str());
  if (!fname) return;
  if (!*fname) return;
  progdefaults.fsq_audit_log = fl_filename_name(fname);
  txtAuditLog->value(progdefaults.fsq_audit_log.c_str());
  progdefaults.changed = true;
}

Fl_Output *txtHeardLog=(Fl_Output *)0;

Fl_Light_Button *btn_enable_fsq_heard_log=(Fl_Light_Button *)0;

static void cb_btn_enable_fsq_heard_log(Fl_Light_Button* o, void*) {
  progdefaults.fsq_enable_heard_log = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_fsq_heard_log=(Fl_Button *)0;

static void cb_btn_select_fsq_heard_log(Fl_Button*, void*) {
  std::string str = std::string(TempDir);
  str.append(progdefaults.fsq_heard_log);
  const char *fname = FSEL::saveas("Heard log", "*.txt\t*", str.c_str());
  if (!fname) return;
  if (!*fname) return;
  progdefaults.fsq_heard_log = fl_filename_name(fname);
  txtHeardLog->value(progdefaults.fsq_heard_log.c_str());
  progdefaults.changed = true;
}

Fl_Button *btn_fsq_xmt_color=(Fl_Button *)0;

static void cb_btn_fsq_xmt_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.fsq_xmt_color;
  if (fl_color_chooser("FSQ xmt color", clr.r, clr.g, clr.b )) {
    ui_colors.fsq_xmt_color = clr;
    btn_fsq_xmt_color->color( RGBCOLOR(fsq_xmt_color) );
    btn_fsq_xmt_color->redraw();
    fsq_rx_text->setFontColor(RGBCOLOR(fsq_xmt_color), FTextBase::FSQ_TX);
    progdefaults.changed = true;}
}

Fl_Button *btn_fsq_directed_color=(Fl_Button *)0;

static void cb_btn_fsq_directed_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.fsq_directed_color;
  if (fl_color_chooser("FSQ directed color", clr.r, clr.g, clr.b )) {
    ui_colors.fsq_directed_color = clr;
    btn_fsq_directed_color->color( RGBCOLOR(fsq_directed_color) );
    btn_fsq_directed_color->redraw();
    fsq_rx_text->setFontColor(RGBCOLOR(fsq_directed_color), FTextBase::FSQ_DIR);
    progdefaults.changed = true;}
}

Fl_Button *btn_fsq_undirected_color=(Fl_Button *)0;

static void cb_btn_fsq_undirected_color(Fl_Button*, void*) {
  TRIAD clr = ui_colors.fsq_undirected_color;
  if (fl_color_chooser("FSQ undirected color", clr.r, clr.g, clr.b )) {
    ui_colors.fsq_undirected_color = clr;
    btn_fsq_undirected_color->color( RGBCOLOR(fsq_undirected_color));
    btn_fsq_undirected_color->redraw();
    fsq_rx_text->setFontColor(RGBCOLOR(fsq_undirected_color), FTextBase::FSQ_UND);
    progdefaults.changed = true;}
}

Fl_Button *btn_fsq_color_defaults=(Fl_Button *)0;

static void cb_btn_fsq_color_defaults(Fl_Button*, void*) {
  TRIAD nuclr;

  Fl::get_color( FL_RED, nuclr.r, nuclr.g, nuclr.b );
  ui_colors.fsq_xmt_color = nuclr;
  btn_fsq_xmt_color->color(RGBCOLOR( fsq_xmt_color ) );
  btn_fsq_xmt_color->redraw();

  Fl::get_color( FL_BLUE, nuclr.r, nuclr.g, nuclr.b);
  ui_colors.fsq_directed_color = nuclr;
  btn_fsq_directed_color->color(RGBCOLOR( fsq_directed_color ));
  btn_fsq_directed_color->redraw();

  Fl::get_color( FL_DARK_GREEN, nuclr.r, nuclr.g, nuclr.b);
  ui_colors.fsq_undirected_color = nuclr;
  btn_fsq_undirected_color->color(RGBCOLOR( fsq_undirected_color ) );
  btn_fsq_undirected_color->redraw();

  fsq_rx_text->setFontColor(RGBCOLOR( fsq_xmt_color ), FTextBase::FSQ_TX);
  fsq_rx_text->setFontColor(RGBCOLOR( fsq_directed_color ), FTextBase::FSQ_DIR);
  fsq_rx_text->setFontColor(RGBCOLOR( fsq_undirected_color ), FTextBase::FSQ_UND);

  progdefaults.changed = true;
}

static void cb_btn_ifkpbaud(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.ifkp_baud = 0;
  btn_ifkpbaud[1]->value(0);
  btn_ifkpbaud[2]->value(0);
  }
  progdefaults.changed = true;
}

static void cb_btn_ifkpbaud1(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.ifkp_baud = 1;
  btn_ifkpbaud[0]->value(0);
  btn_ifkpbaud[2]->value(0);
  }
  progdefaults.changed = true;
}

Fl_Round_Button *btn_ifkpbaud[3]={(Fl_Round_Button *)0};

static void cb_btn_ifkpbaud2(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  progdefaults.ifkp_baud = 2;
  btn_ifkpbaud[0]->value(0);
  btn_ifkpbaud[1]->value(0);
  }
  progdefaults.changed = true;
}

Fl_Check_Button *btn_ifkp_lowercase=(Fl_Check_Button *)0;

static void cb_btn_ifkp_lowercase(Fl_Check_Button* o, void*) {
  progdefaults.ifkp_lowercase=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_ifkp_lowercase_call=(Fl_Check_Button *)0;

static void cb_btn_ifkp_lowercase_call(Fl_Check_Button* o, void*) {
  progdefaults.ifkp_lowercase_call=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_ifkp_freqlock=(Fl_Check_Button *)0;

static void cb_btn_ifkp_freqlock(Fl_Check_Button* o, void*) {
  progdefaults.ifkp_freqlock=o->value();
  if (active_modem == ifkp_modem &&
    o->value() )
    active_modem->set_freq(1500);
  progdefaults.changed = true;
}

Fl_Output *txt_ifkp_audit_log=(Fl_Output *)0;

Fl_Light_Button *btn_enable_ifkp_audit_log=(Fl_Light_Button *)0;

static void cb_btn_enable_ifkp_audit_log(Fl_Light_Button* o, void*) {
  progdefaults.ifkp_enable_audit_log = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_ifkp_select_auditlog=(Fl_Button *)0;

static void cb_btn_ifkp_select_auditlog(Fl_Button*, void*) {
  std::string str = std::string(TempDir);
  str.append(progdefaults.ifkp_audit_log);
  const char *fname = FSEL::saveas("Audit log", "*.txt\t*", str.c_str());
  if (!fname) return;
  if (!*fname) return;
  progdefaults.ifkp_audit_log = fl_filename_name(fname);
  txt_ifkp_audit_log->value(progdefaults.ifkp_audit_log.c_str());
  progdefaults.changed = true;
}

Fl_Output *txt_ifkp_heard_log=(Fl_Output *)0;

Fl_Light_Button *btn_enable_ifkp_heard_log=(Fl_Light_Button *)0;

static void cb_btn_enable_ifkp_heard_log(Fl_Light_Button* o, void*) {
  progdefaults.ifkp_enable_heard_log = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_ifkp_heard_log=(Fl_Button *)0;

static void cb_btn_select_ifkp_heard_log(Fl_Button*, void*) {
  std::string str = std::string(TempDir);
  str.append(progdefaults.ifkp_heard_log);
  const char *fname = FSEL::saveas("Heard log", "*.txt\t*", str.c_str());
  if (!fname) return;
  if (!*fname) return;
  progdefaults.ifkp_heard_log = fl_filename_name(fname);
  txt_ifkp_heard_log->value(progdefaults.ifkp_heard_log.c_str());
  progdefaults.changed = true;
}

Fl_Group *ifkp_image_box=(Fl_Group *)0;

Fl_Counter *MFSK_afc_avg=(Fl_Counter *)0;

static void cb_MFSK_afc_avg(Fl_Counter* o, void*) {
  progdefaults.mfsk_avg = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnMT63_8bit=(Fl_Check_Button *)0;

static void cb_btnMT63_8bit(Fl_Check_Button* o, void*) {
  progdefaults.mt63_8bit = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnMT63_rx_integration=(Fl_Check_Button *)0;

static void cb_btnMT63_rx_integration(Fl_Check_Button* o, void*) {
  progdefaults.mt63_rx_integration = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnMT63_usetones=(Fl_Check_Button *)0;

static void cb_btnMT63_usetones(Fl_Check_Button* o, void*) {
  progdefaults.mt63_usetones = o->value();
  if (!o->value()) {
      btnMT63_upper_lower->value(0);
      btnMT63_upper_lower->do_callback();
      btnMT63_upper_lower->deactivate();
  }
  else
      btnMT63_upper_lower->activate();
  progdefaults.changed = true;
}

Fl_Check_Button *btnMT63_upper_lower=(Fl_Check_Button *)0;

static void cb_btnMT63_upper_lower(Fl_Check_Button* o, void*) {
  progdefaults.mt63_twotones = o->value();
  progdefaults.changed = true;
}

Fl_Spinner2 *MT63_tone_duration=(Fl_Spinner2 *)0;

static void cb_MT63_tone_duration(Fl_Spinner2* o, void*) {
  progdefaults.mt63_tone_duration=(int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnMT63_at500=(Fl_Check_Button *)0;

static void cb_btnMT63_at500(Fl_Check_Button* o, void*) {
  o->value(1);
  progdefaults.mt63_at500 = true;
  progdefaults.mt63_centered = false;
  btnMT63_centered->value(0);
  btnMT63_manual->value(0);
  progdefaults.changed = true;
}

Fl_Check_Button *btnMT63_centered=(Fl_Check_Button *)0;

static void cb_btnMT63_centered(Fl_Check_Button* o, void*) {
  o->value(1);
  progdefaults.mt63_centered = true;
  progdefaults.mt63_at500 = false;
  btnMT63_at500->value(0);
  btnMT63_manual->value(0);
  progdefaults.changed = true;
}

Fl_Check_Button *btnMT63_manual=(Fl_Check_Button *)0;

static void cb_btnMT63_manual(Fl_Check_Button* o, void*) {
  o->value(1);
  progdefaults.mt63_centered = false;
  progdefaults.mt63_at500 = false;
  btnMT63_at500->value(0);
  btnMT63_centered->value(0);
  progdefaults.changed = true;
}

Fl_ListBox *i_listbox_contestia_bandwidth=(Fl_ListBox *)0;

static void cb_i_listbox_contestia_bandwidth(Fl_ListBox* o, void*) {
  progdefaults.contestiabw = o->index();
  set_contestia_default_integ();
  resetCONTESTIA();
  progdefaults.changed = true;
}

Fl_ListBox *i_listbox_contestia_tones=(Fl_ListBox *)0;

static void cb_i_listbox_contestia_tones(Fl_ListBox* o, void*) {
  progdefaults.contestiatones = o->index();
  set_contestia_default_integ();
  resetCONTESTIA();
  progdefaults.changed = true;
}

Fl_Counter2 *cntContestia_smargin=(Fl_Counter2 *)0;

static void cb_cntContestia_smargin(Fl_Counter2* o, void*) {
  progdefaults.contestiasmargin = (int)(o->value());
  resetCONTESTIA();
  progdefaults.changed = true;
}

Fl_Counter2 *cntContestia_sinteg=(Fl_Counter2 *)0;

static void cb_cntContestia_sinteg(Fl_Counter2* o, void*) {
  progdefaults.contestiasinteg = (int)(o->value());
  resetCONTESTIA();
  progdefaults.changed = true;
}

Fl_Check_Button *btnContestia_8bit=(Fl_Check_Button *)0;

static void cb_btnContestia_8bit(Fl_Check_Button* o, void*) {
  progdefaults.contestia8bit = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnContestia_start_stop_tones=(Fl_Check_Button *)0;

static void cb_btnContestia_start_stop_tones(Fl_Check_Button* o, void*) {
  progdefaults.contestia_start_tones = o->value();
  progdefaults.changed = true;
}

Fl_ListBox *i_listbox_olivia_bandwidth=(Fl_ListBox *)0;

static void cb_i_listbox_olivia_bandwidth(Fl_ListBox* o, void*) {
  progdefaults.oliviabw = o->index();
  set_olivia_default_integ();
  resetOLIVIA();
  progdefaults.changed = true;
}

Fl_ListBox *i_listbox_olivia_tones=(Fl_ListBox *)0;

static void cb_i_listbox_olivia_tones(Fl_ListBox* o, void*) {
  progdefaults.oliviatones = o->index();
  set_olivia_default_integ();
  resetOLIVIA();
  progdefaults.changed = true;
}

Fl_Counter2 *cntOlivia_smargin=(Fl_Counter2 *)0;

static void cb_cntOlivia_smargin(Fl_Counter2* o, void*) {
  progdefaults.oliviasmargin = (int)(o->value());
  resetOLIVIA();
  progdefaults.changed = true;
}

Fl_Counter2 *cntOlivia_sinteg=(Fl_Counter2 *)0;

static void cb_cntOlivia_sinteg(Fl_Counter2* o, void*) {
  progdefaults.oliviasinteg = (int)(o->value());
  resetOLIVIA();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_olivia_reset_fec=(Fl_Check_Button *)0;

static void cb_btn_olivia_reset_fec(Fl_Check_Button* o, void*) {
  progdefaults.olivia_reset_fec = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnOlivia_8bit=(Fl_Check_Button *)0;

static void cb_btnOlivia_8bit(Fl_Check_Button* o, void*) {
  progdefaults.olivia8bit = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnOlivia_start_stop_tones=(Fl_Check_Button *)0;

static void cb_btnOlivia_start_stop_tones(Fl_Check_Button* o, void*) {
  progdefaults.olivia_start_tones = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntSearchRange=(Fl_Counter2 *)0;

static void cb_cntSearchRange(Fl_Counter2* o, void*) {
  progdefaults.SearchRange = (int)o->value();
  wf->redraw_marker();
  progdefaults.changed = true;
}

Fl_Counter2 *cntACQsn=(Fl_Counter2 *)0;

static void cb_cntACQsn(Fl_Counter2* o, void*) {
  progdefaults.ACQsn = o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_psk_status_timeout=(Fl_ListBox *)0;

static void cb_listbox_psk_status_timeout(Fl_ListBox* o, void*) {
  progdefaults.StatusDim = o->index();
  progdefaults.changed = true;
}

static void cb_seconds(Fl_Counter2* o, void*) {
  progdefaults.StatusTimeout = (int)(o->value());
  progdefaults.changed = true;
}

Fl_Check_Button *btnEnablePSKbrowsing=(Fl_Check_Button *)0;

static void cb_btnEnablePSKbrowsing(Fl_Check_Button* o, void*) {
  progdefaults.pskbrowser_on = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnPSKpilot=(Fl_Check_Button *)0;

static void cb_btnPSKpilot(Fl_Check_Button* o, void*) {
  progdefaults.pskpilot = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cnt_pilot_power=(Fl_Counter2 *)0;

static void cb_cnt_pilot_power(Fl_Counter2* o, void*) {
  progdefaults.pilot_power = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnPSK8Preamble=(Fl_Check_Button *)0;

static void cb_btnPSK8Preamble(Fl_Check_Button* o, void*) {
  progStatus.psk8DCDShortFlag = o->value();
}

Fl_Counter *ScampResync=(Fl_Counter *)0;

static void cb_ScampResync(Fl_Counter* o, void*) {
  progdefaults.ScampResync = o->value(); progdefaults.changed = true;
}

Fl_Counter *ScampRepeat=(Fl_Counter *)0;

static void cb_ScampRepeat(Fl_Counter* o, void*) {
  progdefaults.ScampRepeat = o->value(); progdefaults.changed = true;
}

Fl_ListBox *i_listbox_rtty_afc_speed=(Fl_ListBox *)0;

static void cb_i_listbox_rtty_afc_speed(Fl_ListBox* o, void*) {
  progdefaults.rtty_afcspeed = o->index();
  progdefaults.changed = true;
}

Fl_Check_Button *chkUOSrx=(Fl_Check_Button *)0;

static void cb_chkUOSrx(Fl_Check_Button* o, void*) {
  progdefaults.UOSrx=o->value();
  progdefaults.changed = true;
}

Fl_Value_Input *rtty_rx_shape=(Fl_Value_Input *)0;

static void cb_rtty_rx_shape(Fl_Value_Input* o, void*) {
  progdefaults.rtty_filter = o->value();
  progStatus.rtty_filter_changed = true;
  progdefaults.changed = true;
}

static void cb_btnRxTones(Fl_Check_Button* o, void*) {
  if (o->value()) {
    btnRxTones[1]->value(0);
    btnRxTones[2]->value(0);
    progdefaults.rtty_cwi = 0;
  }
}

static void cb_btnRxTones1(Fl_Check_Button* o, void*) {
  if (o->value()) {
    btnRxTones[0]->value(0);
    btnRxTones[2]->value(0);
    progdefaults.rtty_cwi = 1;
  }
}

Fl_Check_Button *btnRxTones[3]={(Fl_Check_Button *)0};

static void cb_btnRxTones2(Fl_Check_Button* o, void*) {
  if (o->value()) {
    btnRxTones[1]->value(0);
    btnRxTones[0]->value(0);
    progdefaults.rtty_cwi = 2;
  }
}

Fl_Check_Button *btnPreferXhairScope=(Fl_Check_Button *)0;

static void cb_btnPreferXhairScope(Fl_Check_Button* o, void*) {
  progdefaults.PreferXhairScope=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_true_scope=(Fl_Check_Button *)0;

static void cb_chk_true_scope(Fl_Check_Button* o, void*) {
  progdefaults.true_scope=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_useMARKfreq=(Fl_Check_Button *)0;

static void cb_chk_useMARKfreq(Fl_Check_Button* o, void*) {
  progdefaults.useMARKfreq=o->value();
  progdefaults.changed = true;
}

Fl_Button *btnRTTY_mark_color=(Fl_Button *)0;

static void cb_btnRTTY_mark_color(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.rttymark;
  if (fl_color_chooser("MARK freq track", clr.r, clr.g, clr.b )) {
    ui_colors.rttymark = clr;
    o->color(RGBCOLOR(rttymark));
    o->redraw();
    wf->redraw_marker();
    progdefaults.changed = true;
  }
}

Fl_Check_Button *chk_audibleBELL=(Fl_Check_Button *)0;

static void cb_chk_audibleBELL(Fl_Check_Button* o, void*) {
  progdefaults.audibleBELL=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_visibleBELL=(Fl_Check_Button *)0;

static void cb_chk_visibleBELL(Fl_Check_Button* o, void*) {
  progdefaults.visibleBELL=o->value();
  progdefaults.changed = true;
}

Fl_File_Input *inp_wav_fname_bell_ring=(Fl_File_Input *)0;

Fl_Button *btn_select_bell_ring_wav=(Fl_Button *)0;

static void cb_btn_select_bell_ring_wav(Fl_Button*, void*) {
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Pick a file");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.filter("wav files\t*.{mp3,wav}\n");
  fnfc.directory("./");           // default directory to use
  // Show native chooser
  switch ( fnfc.show() ) {
    case -1: break; // ERROR
    case  1: break; // CANCEL
    default: {
    	progdefaults.BELL_RING = fnfc.filename();
    	inp_wav_fname_bell_ring->value(progdefaults.BELL_RING.c_str());
    	progdefaults.BELL_RING_MENU = 0;
    	mnu_bell_ring_menu->value(progdefaults.BELL_RING_MENU);
    	break; // FILE CHOSEN
    }
  }
}

Fl_Choice *mnu_bell_ring_menu=(Fl_Choice *)0;

static void cb_mnu_bell_ring_menu(Fl_Choice* o, void*) {
  if (o->value() > 0) {
    switch (o->value()) {
      case 1 : progdefaults.BELL_RING = "bark"; break;
      case 2 : progdefaults.BELL_RING = "checkout"; break;
      case 3 : progdefaults.BELL_RING = "diesel"; break;
      case 4 : progdefaults.BELL_RING = "steam_train"; break;
      case 5 : progdefaults.BELL_RING = "doesnot"; break;
      case 6 : progdefaults.BELL_RING = "beeboo"; break;
      case 7 : progdefaults.BELL_RING = "phone"; break;
      case 8 : progdefaults.BELL_RING = "dinner_bell"; break;
      case 9 : progdefaults.BELL_RING = "rtty_bell"; break;
      case 10 : progdefaults.BELL_RING = "standard_tone"; break;
    }
    inp_wav_fname_bell_ring->value(progdefaults.BELL_RING.c_str());
  }
  progdefaults.BELL_RING_MENU = o->value();
}

Fl_Button *btn_test_bell_ring_wav=(Fl_Button *)0;

static void cb_btn_test_bell_ring_wav(Fl_Button*, void*) {
  audio_alert->alert(progdefaults.BELL_RING.c_str());
}

Fl_Check_Button *chk_ITA2=(Fl_Check_Button *)0;

static void cb_chk_ITA2(Fl_Check_Button* o, void*) {
  progdefaults.ITA2=o->value();
  progdefaults.changed = true;
}

Fl_ListBox *selShift=(Fl_ListBox *)0;

static void cb_selShift(Fl_ListBox* o, void*) {
  progdefaults.rtty_shift = o->index();
  sel_xcvr_FSK_shift->index(progdefaults.rtty_shift);
  if (progdefaults.rtty_shift == o->lsize() - 1)
      selCustomShift->activate();
  else
      selCustomShift->deactivate();
  selCustomShift->redraw();
  resetRTTY();
  progdefaults.changed = true;
}

Fl_Counter2 *selCustomShift=(Fl_Counter2 *)0;

static void cb_selCustomShift(Fl_Counter2* o, void*) {
  progdefaults.rtty_custom_shift = o->value();
  resetRTTY();
  progdefaults.changed = true;
}

Fl_ListBox *selBaud=(Fl_ListBox *)0;

static void cb_selBaud(Fl_ListBox* o, void*) {
  progdefaults.rtty_baud = o->index();
  resetRTTY();
  progdefaults.changed = true;
}

Fl_ListBox *selBits=(Fl_ListBox *)0;

static void cb_selBits(Fl_ListBox* o, void*) {
  progdefaults.rtty_bits = o->index();
  selParity->do_callback();
}

Fl_ListBox *selParity=(Fl_ListBox *)0;

static void cb_selParity(Fl_ListBox* o, void*) {
  if (progdefaults.rtty_bits == 0) {
    progdefaults.rtty_parity = rtty::RTTY_PARITY_NONE;
    o->index(progdefaults.rtty_parity);
  } else
    progdefaults.rtty_parity = o->index();
  resetRTTY();
  progdefaults.changed = true;
}

Fl_ListBox *selStopBits=(Fl_ListBox *)0;

static void cb_selStopBits(Fl_ListBox* o, void*) {
  progdefaults.rtty_stop = o->index();
  resetRTTY();
  progdefaults.changed = true;
}

Fl_Check_Button *btnAUTOCRLF=(Fl_Check_Button *)0;

static void cb_btnAUTOCRLF(Fl_Check_Button* o, void*) {
  progdefaults.rtty_autocrlf = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntrAUTOCRLF=(Fl_Counter2 *)0;

static void cb_cntrAUTOCRLF(Fl_Counter2* o, void*) {
  progdefaults.rtty_autocount = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCRCRLF=(Fl_Check_Button *)0;

static void cb_btnCRCRLF(Fl_Check_Button* o, void*) {
  progdefaults.rtty_crcrlf = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkUOStx=(Fl_Check_Button *)0;

static void cb_chkUOStx(Fl_Check_Button* o, void*) {
  progdefaults.UOStx=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_shaped_rtty=(Fl_Check_Button *)0;

static void cb_chk_shaped_rtty(Fl_Check_Button* o, void*) {
  progStatus.shaped_rtty = o->value();
}

Fl_Check_Button *chkPseudoFSK=(Fl_Check_Button *)0;

static void cb_chkPseudoFSK(Fl_Check_Button* o, void*) {
  progdefaults.PseudoFSK = o->value();
  chkPseudoFSK2->value(o->value());
  progdefaults.changed = true;
  if (o->value()) {
    progdefaults.sig_on_right_channel = false;
    chkAudioStereoOut->value(0);
    progdefaults.PTTrightchannel = false;
    btnPTTrightchannel->value(0);
  }
}

Fl_Counter *cnt_TTY_LTRS=(Fl_Counter *)0;

static void cb_cnt_TTY_LTRS(Fl_Counter* o, void*) {
  progdefaults.TTY_LTRS = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnFSKenabled=(Fl_Check_Button *)0;

static void cb_btnFSKenabled(Fl_Check_Button* o, void*) {
  progdefaults.useFSK = o->value();

  resetRTTY();
  resetFSK();

  progdefaults.changed = true;
}

Fl_Check_Button *btnFSKshared=(Fl_Check_Button *)0;

static void cb_btnFSKshared(Fl_Check_Button* o, void*) {
  progdefaults.fsk_shares_port = o->value();

  if (progdefaults.useFSK) {
    resetRTTY();
    resetFSK();
  }

  progdefaults.changed = true;
}

Fl_ComboBox *select_FSK_CommPort=(Fl_ComboBox *)0;

static void cb_select_FSK_CommPort(Fl_ComboBox* o, void*) {
  progdefaults.fsk_port = o->value();

  if (progdefaults.useFSK) {
    resetRTTY();
    resetFSK();
  }

  progdefaults.changed = true;
}

Fl_Check_Button *btnFSKreverse=(Fl_Check_Button *)0;

static void cb_btnFSKreverse(Fl_Check_Button* o, void*) {
  progdefaults.fsk_reverse = o->value();

  if (progdefaults.useFSK) {
    resetRTTY();
    resetFSK();
  }

  progdefaults.changed = true;
}

Fl_Check_Button *btnFSKuseDTR=(Fl_Check_Button *)0;

static void cb_btnFSKuseDTR(Fl_Check_Button* o, void*) {
  progdefaults.fsk_on_dtr = o->value();

  if (progdefaults.useFSK) {
    resetRTTY();
    resetFSK();
  }

  progdefaults.changed = true;
}

Fl_Button *btnFSKreset=(Fl_Button *)0;

static void cb_btnFSKreset(Fl_Button*, void*) {
  resetRTTY();
  resetFSK();
}

Fl_Counter *cntr_xcvr_FSK_MARK=(Fl_Counter *)0;

static void cb_cntr_xcvr_FSK_MARK(Fl_Counter* o, void*) {
  progdefaults.xcvr_FSK_MARK = o->value();

  progdefaults.RTTYsweetspot = progdefaults.xcvr_FSK_MARK + rtty::SHIFT[progdefaults.rtty_shift] / 2;
  valRTTYsweetspot->value(progdefaults.RTTYsweetspot);

  if (progdefaults.useFSK) {
    resetRTTY();
    resetFSK();
  }

  progdefaults.changed = true;
}

Fl_ListBox *sel_xcvr_FSK_shift=(Fl_ListBox *)0;

static void cb_sel_xcvr_FSK_shift(Fl_ListBox* o, void*) {
  progdefaults.rtty_shift = o->index();
  selShift->index(progdefaults.rtty_shift);

  progdefaults.RTTYsweetspot = progdefaults.xcvr_FSK_MARK + rtty::SHIFT[progdefaults.rtty_shift] / 2;
  valRTTYsweetspot->value(progdefaults.RTTYsweetspot);

  if (progdefaults.useFSK) {
    resetRTTY();
    resetFSK();
  }

  progdefaults.changed = true;
}

Fl_Check_Button *btnFSK_STOPBITS=(Fl_Check_Button *)0;

static void cb_btnFSK_STOPBITS(Fl_Check_Button* o, void*) {
  progdefaults.fsk_STOPBITS = o->value();

  progdefaults.changed = true;
}

Fl_Check_Button *btn_FSK_KEYLINE_flrig=(Fl_Check_Button *)0;

static void cb_btn_FSK_KEYLINE_flrig(Fl_Check_Button* o, void*) {
  int val = o->value();
  progdefaults.use_FLRIG_FSK = val;
  progdefaults.changed = true;
}

Fl_ComboBox *select_nanoIO_CommPort=(Fl_ComboBox *)0;

static void cb_select_nanoIO_CommPort(Fl_ComboBox* o, void*) {
  progdefaults.nanoIO_serial_port_name = o->value();
}

Fl_Light_Button *btn_nanoIO_connect=(Fl_Light_Button *)0;

static void cb_btn_nanoIO_connect(Fl_Light_Button* o, void*) {
  if (o->value()) {
    if (open_nanoIO()) {
      btn_nanoCW_connect->value(1);
      chk_nanoIO_FSK_io->value(1);
    } else {
      o->value(0);
      btn_nanoCW_connect->value(0);
      chk_nanoIO_CW_io->value(0);
      chk_nanoIO_FSK_io->value(0);
    }
  } else {
    close_nanoIO();
    o->value(0);
    btn_nanoCW_connect->value(0);
    chk_nanoIO_FSK_io->value(0);
    chk_nanoIO_CW_io->value(0);
  }
}

Fl_ListBox *listbox_nanoIO_serbaud2=(Fl_ListBox *)0;

static void cb_listbox_nanoIO_serbaud2(Fl_ListBox* o, void*) {
  progdefaults.nanoIO_serbaud = o->index();
  listbox_nanoIO_serbaud->index(o->index());
  progdefaults.changed = true;
}

FTextView *txt_nano_io=(FTextView *)0;

Fl_Button *btn_nanofsk_save=(Fl_Button *)0;

static void cb_btn_nanofsk_save(Fl_Button*, void*) {
  nano_CW_save();
}

Fl_Button *btn_nanofsk_query=(Fl_Button *)0;

static void cb_btn_nanofsk_query(Fl_Button*, void*) {
  nano_CW_query();
}

Fl_Check_Button *chk_nanoIO_polarity=(Fl_Check_Button *)0;

static void cb_chk_nanoIO_polarity(Fl_Check_Button* o, void*) {
  progdefaults.nanoIO_polarity=o->value();
  nano_mark_polarity(progdefaults.nanoIO_polarity);
  progdefaults.changed = true;
}

Fl_ListBox *sel_nanoIO_baud=(Fl_ListBox *)0;

static void cb_sel_nanoIO_baud(Fl_ListBox* o, void*) {
  progdefaults.nanoIO_baud = o->index();
  nano_set_baud(progdefaults.nanoIO_baud);
  progdefaults.changed = true;
}

Fl_Group *grp_nanoio_debug=(Fl_Group *)0;

Fl_Browser *brws_nanoio_sent=(Fl_Browser *)0;

Fl_Browser *brws_nanoio_rcvd=(Fl_Browser *)0;

Fl_Button *btn_nanoio_clear_sent=(Fl_Button *)0;

static void cb_btn_nanoio_clear_sent(Fl_Button*, void*) {
  brws_nanoio_sent->clear();
}

Fl_Button *btn_nanoio_clear_both=(Fl_Button *)0;

static void cb_btn_nanoio_clear_both(Fl_Button*, void*) {
  brws_nanoio_rcvd->clear();
  brws_nanoio_sent->clear();
}

Fl_Button *btn_nanoio_clear_rcvd=(Fl_Button *)0;

static void cb_btn_nanoio_clear_rcvd(Fl_Button*, void*) {
  brws_nanoio_rcvd->clear();
}

Fl_Light_Button *btn_nanoio_debug=(Fl_Light_Button *)0;

static void cb_btn_nanoio_debug(Fl_Light_Button* o, void*) {
  if (o->value()) {
    grp_nanoio_debug->show();
    txt_nano_io->hide();
  } else {
    grp_nanoio_debug->hide();
    txt_nano_io->show();
  }
}

Fl_Check_Button *chk_nanoIO_FSK_io=(Fl_Check_Button *)0;

static void cb_chk_nanoIO_FSK_io(Fl_Check_Button* o, void*) {
  if (o->value() == 0) {
    o->value(1);
    return;
  }
  set_nanoIO();
  chk_nanoIO_CW_io->value(0);
}

Fl_ComboBox *select_USN_FSK_port=(Fl_ComboBox *)0;

static void cb_select_USN_FSK_port(Fl_ComboBox* o, void*) {
  progdefaults.Nav_FSK_port = o->value();
}

Fl_Light_Button *btn_Nav_connect=(Fl_Light_Button *)0;

static void cb_btn_Nav_connect(Fl_Light_Button* o, void*) {
  if (o->value()) {
    if (!open_NavFSK())
      o->value(0);
  } else {
    close_NavFSK();
  }
}

Fl_ComboBox *select_Nav_config_port=(Fl_ComboBox *)0;

static void cb_select_Nav_config_port(Fl_ComboBox* o, void*) {
  progdefaults.Nav_config_port = o->value();
}

Fl_ListBox *sel_Nav_ch1=(Fl_ListBox *)0;

static void cb_sel_Nav_ch1(Fl_ListBox* o, void*) {
  progdefaults.Nav_channel_1_att = o->index();
  Nav_set_channel_1_att(progdefaults.Nav_channel_1_att);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_ch2=(Fl_ListBox *)0;

static void cb_sel_Nav_ch2(Fl_ListBox* o, void*) {
  progdefaults.Nav_channel_2_att = o->index();
  Nav_set_channel_2_att(progdefaults.Nav_channel_2_att);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_rf_att=(Fl_ListBox *)0;

static void cb_sel_Nav_rf_att(Fl_ListBox* o, void*) {
  progdefaults.Nav_rf_att = o->index();
  Nav_set_rf_att(progdefaults.Nav_rf_att);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_wk_ptt=(Fl_ListBox *)0;

static void cb_sel_Nav_wk_ptt(Fl_ListBox* o, void*) {
  progdefaults.Nav_wk_ptt = o->index();
  Nav_set_wk_ptt(progdefaults.Nav_wk_ptt);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_LED=(Fl_ListBox *)0;

static void cb_sel_Nav_LED(Fl_ListBox* o, void*) {
  progdefaults.Nav_led = o->index();
  Nav_set_led(progdefaults.Nav_led);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_CAT_LED=(Fl_ListBox *)0;

static void cb_sel_Nav_CAT_LED(Fl_ListBox* o, void*) {
  progdefaults.Nav_cat_led = o->index();
  Nav_set_cat_led(progdefaults.Nav_cat_led);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_FSK_baud=(Fl_ListBox *)0;

static void cb_sel_Nav_FSK_baud(Fl_ListBox* o, void*) {
  progdefaults.Nav_FSK_baud = o->index();
  Nav_set_baud(progdefaults.Nav_FSK_baud);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_FSK_stopbits=(Fl_ListBox *)0;

static void cb_sel_Nav_FSK_stopbits(Fl_ListBox* o, void*) {
  progdefaults.Nav_FSK_stopbits = o->index();
  Nav_set_stopbits(progdefaults.Nav_FSK_stopbits);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_FSK_polarity=(Fl_ListBox *)0;

static void cb_sel_Nav_FSK_polarity(Fl_ListBox* o, void*) {
  progdefaults.Nav_FSK_polarity = o->index();
  Nav_set_polarity(progdefaults.Nav_FSK_polarity);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_FSK_sidetone=(Fl_ListBox *)0;

static void cb_sel_Nav_FSK_sidetone(Fl_ListBox* o, void*) {
  progdefaults.Nav_FSK_sidetone = o->index();
  Nav_set_sidetone(progdefaults.Nav_FSK_sidetone);
  progdefaults.changed = true;
}

Fl_ListBox *sel_Nav_FSK_ptt=(Fl_ListBox *)0;

static void cb_sel_Nav_FSK_ptt(Fl_ListBox* o, void*) {
  progdefaults.Nav_FSK_ptt = o->index();
  Nav_set_ptt(progdefaults.Nav_FSK_ptt);
  progdefaults.changed = true;
}

Fl_Light_Button *btn_Nav_config=(Fl_Light_Button *)0;

static void cb_btn_Nav_config(Fl_Light_Button* o, void*) {
  if (o->value()) {
    if (!open_NavConfig())
      o->value(0);
  } else {
    close_NavConfig();
  }
}

Fl_Check_Button *btnSynopAdifDecoding=(Fl_Check_Button *)0;

static void cb_btnSynopAdifDecoding(Fl_Check_Button* o, void*) {
  progdefaults.SynopAdifDecoding=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnSynopKmlDecoding=(Fl_Check_Button *)0;

static void cb_btnSynopKmlDecoding(Fl_Check_Button* o, void*) {
  progdefaults.SynopKmlDecoding=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnSynopInterleaved=(Fl_Check_Button *)0;

static void cb_btnSynopInterleaved(Fl_Check_Button* o, void*) {
  progdefaults.SynopInterleaved=o->value();
  progdefaults.changed = true;
}

Fl_ComboBox *select_WKFSK_CommPort=(Fl_ComboBox *)0;

static void cb_select_WKFSK_CommPort(Fl_ComboBox* o, void*) {
  progStatus.WK_serial_port_name = o->value();
  select_WK_CommPort->value(progStatus.WK_serial_port_name.c_str());
}

Fl_Light_Button *btn_WKFSK_connect=(Fl_Light_Button *)0;

static void cb_btn_WKFSK_connect(Fl_Light_Button* o, void*) {
  WKFSK_connect(o->value());
}

Fl_ListBox *sel_WKFSK_baud=(Fl_ListBox *)0;

static void cb_sel_WKFSK_baud(Fl_ListBox* o, void*) {
  progStatus.WKFSK_baud = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_stopbits=(Fl_ListBox *)0;

static void cb_sel_WKFSK_stopbits(Fl_ListBox* o, void*) {
  progStatus.WKFSK_stopbits = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_ptt=(Fl_ListBox *)0;

static void cb_sel_WKFSK_ptt(Fl_ListBox* o, void*) {
  progStatus.WKFSK_ptt = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_polarity=(Fl_ListBox *)0;

static void cb_sel_WKFSK_polarity(Fl_ListBox* o, void*) {
  progStatus.WKFSK_polarity = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_sidetone=(Fl_ListBox *)0;

static void cb_sel_WKFSK_sidetone(Fl_ListBox* o, void*) {
  progStatus.WKFSK_sidetone = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_auto_crlf=(Fl_ListBox *)0;

static void cb_sel_WKFSK_auto_crlf(Fl_ListBox* o, void*) {
  progStatus.WKFSK_auto_crlf = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_diddle=(Fl_ListBox *)0;

static void cb_sel_WKFSK_diddle(Fl_ListBox* o, void*) {
  progStatus.WKFSK_diddle = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_diddle_char=(Fl_ListBox *)0;

static void cb_sel_WKFSK_diddle_char(Fl_ListBox* o, void*) {
  progStatus.WKFSK_diddle_char = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_usos=(Fl_ListBox *)0;

static void cb_sel_WKFSK_usos(Fl_ListBox* o, void*) {
  progStatus.WKFSK_usos = o->index();
  WKFSK_init();
}

Fl_ListBox *sel_WKFSK_monitor=(Fl_ListBox *)0;

static void cb_sel_WKFSK_monitor(Fl_ListBox* o, void*) {
  progStatus.WKFSK_monitor = o->index();
  WKFSK_init();
}

Fl_Input2 *txtTHORSecondary=(Fl_Input2 *)0;

static void cb_txtTHORSecondary(Fl_Input2* o, void*) {
  progdefaults.THORsecText = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *valTHOR_FILTER=(Fl_Check_Button *)0;

static void cb_valTHOR_FILTER(Fl_Check_Button* o, void*) {
  progdefaults.THOR_FILTER = o->value();
  resetTHOR();
  progdefaults.changed = true;
}

Fl_Counter2 *valTHOR_BW=(Fl_Counter2 *)0;

static void cb_valTHOR_BW(Fl_Counter2* o, void*) {
  progdefaults.THOR_BW = o->value();
  resetTHOR();
  progdefaults.changed = true;
}

Fl_Value_Slider2 *valThorCWI=(Fl_Value_Slider2 *)0;

static void cb_valThorCWI(Fl_Value_Slider2* o, void*) {
  progdefaults.ThorCWI = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *valTHOR_PREAMBLE=(Fl_Check_Button *)0;

static void cb_valTHOR_PREAMBLE(Fl_Check_Button* o, void*) {
  progdefaults.THOR_PREAMBLE = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *valTHOR_SOFTSYMBOLS=(Fl_Check_Button *)0;

static void cb_valTHOR_SOFTSYMBOLS(Fl_Check_Button* o, void*) {
  progdefaults.THOR_SOFTSYMBOLS = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *valTHOR_SOFTBITS=(Fl_Check_Button *)0;

static void cb_valTHOR_SOFTBITS(Fl_Check_Button* o, void*) {
  progdefaults.THOR_SOFTBITS = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnTHOR_DEBUG=(Fl_Check_Button *)0;

static void cb_btnTHOR_DEBUG(Fl_Check_Button* o, void*) {
  progStatus.thordebug = o->value();
}

Fl_Counter2 *valTHOR_PATHS=(Fl_Counter2 *)0;

static void cb_valTHOR_PATHS(Fl_Counter2* o, void*) {
  progdefaults.THOR_PATHS = (int)o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *valTHOR_RISETIME=(Fl_Counter2 *)0;

static void cb_valTHOR_RISETIME(Fl_Counter2* o, void*) {
  progdefaults.THOR_RISETIME = o->value();
  progdefaults.changed = true;
}

Fl_Group *thor_image_box=(Fl_Group *)0;

Fl_Check_Button *btnNvtxAdifLog=(Fl_Check_Button *)0;

static void cb_btnNvtxAdifLog(Fl_Check_Button* o, void*) {
  progdefaults.NVTX_AdifLog=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnNvtxKmlLog=(Fl_Check_Button *)0;

static void cb_btnNvtxKmlLog(Fl_Check_Button* o, void*) {
  progdefaults.NVTX_KmlLog=o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntrWEFAX_Shift=(Fl_Counter *)0;

static void cb_cntrWEFAX_Shift(Fl_Counter* o, void*) {
  progdefaults.WEFAX_Shift=o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntrWEFAX_Center=(Fl_Counter *)0;

static void cb_cntrWEFAX_Center(Fl_Counter* o, void*) {
  progdefaults.WEFAX_Center=o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntrWEFAX_MaxRows=(Fl_Counter *)0;

static void cb_cntrWEFAX_MaxRows(Fl_Counter* o, void*) {
  progdefaults.WEFAX_MaxRows=o->value();
  progdefaults.changed = true;
}

Fl_Input *btnWefaxSaveDir=(Fl_Input *)0;

static void cb_btnWefaxSaveDir(Fl_Input* o, void*) {
  progdefaults.wefax_save_dir=o->value();
  progdefaults.changed = true;
}

Fl_Button *btnSelectFaxDestDir=(Fl_Button *)0;

static void cb_btnSelectFaxDestDir(Fl_Button*, void*) {
  Fl_File_Chooser *fc = new Fl_File_Chooser(".",NULL,Fl_File_Chooser::DIRECTORY,"Input File");
  fc->callback(WefaxDestDirSet);
  fc->show();
}

Fl_Check_Button *btnWefaxAdifLog=(Fl_Check_Button *)0;

static void cb_btnWefaxAdifLog(Fl_Check_Button* o, void*) {
  progdefaults.WEFAX_AdifLog=o->value();
  progdefaults.changed = true;
}

Fl_Choice *wefax_choice_rx_filter=(Fl_Choice *)0;

static void cb_wefax_choice_rx_filter(Fl_Choice* o, void*) {
  progdefaults.wefax_filter=o->value();
}

Fl_Counter *auto_after_nrows=(Fl_Counter *)0;

static void cb_auto_after_nrows(Fl_Counter* o, void*) {
  progdefaults.wefax_auto_after = o->value();
  progdefaults.changed = true;
}

Fl_Counter *align_stop_after=(Fl_Counter *)0;

static void cb_align_stop_after(Fl_Counter* o, void*) {
  progdefaults.wefax_align_stop = o->value();
  progdefaults.changed = true;
}

Fl_Counter *align_every_nrows=(Fl_Counter *)0;

static void cb_align_every_nrows(Fl_Counter* o, void*) {
  progdefaults.wefax_align_rows = o->value();
  if (auto_after_nrows->minimum() < progdefaults.wefax_align_rows) {
    auto_after_nrows->minimum(progdefaults.wefax_align_rows);
    auto_after_nrows->value(progdefaults.wefax_align_rows);
  }
  progdefaults.changed = true;
}

Fl_Counter *wefax_correlation=(Fl_Counter *)0;

static void cb_wefax_correlation(Fl_Counter* o, void*) {
  progdefaults.wefax_correlation = o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntr_correlation_rows=(Fl_Counter *)0;

static void cb_cntr_correlation_rows(Fl_Counter* o, void*) {
  progdefaults.wefax_correlation_rows = o->value();
  progdefaults.changed = true;
}

Fl_Choice *choice_lpm_288=(Fl_Choice *)0;

static void cb_choice_lpm_288(Fl_Choice* o, void*) {
  int idx_lpm = o->value();
  progdefaults.wefax_lpm_288 = idx_lpm;
  return;
}

Fl_Choice *choice_lpm_576=(Fl_Choice *)0;

static void cb_choice_lpm_576(Fl_Choice* o, void*) {
  int idx_lpm = o->value();
  progdefaults.wefax_lpm_576 = idx_lpm;
  return;
}

Fl_Input2 *txt_auto_flrig_pathname=(Fl_Input2 *)0;

static void cb_txt_auto_flrig_pathname(Fl_Input2* o, void*) {
  progdefaults.auto_flrig_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_flrig=(Fl_Button *)0;

static void cb_btn_select_flrig(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.auto_flrig_pathname);
  txt_auto_flrig_pathname->value(str.c_str());
  progdefaults.auto_flrig_pathname = str;
  progdefaults.changed = true;
}

Fl_Input2 *txt_auto_flamp_pathname=(Fl_Input2 *)0;

static void cb_txt_auto_flamp_pathname(Fl_Input2* o, void*) {
  progdefaults.auto_flamp_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_auto_flamp=(Fl_Button *)0;

static void cb_btn_select_auto_flamp(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.auto_flamp_pathname);
  txt_auto_flamp_pathname->value(str.c_str());
  progdefaults.auto_flamp_pathname = str;
  progdefaults.changed = true;
}

Fl_Input2 *txt_auto_flnet_pathname=(Fl_Input2 *)0;

static void cb_txt_auto_flnet_pathname(Fl_Input2* o, void*) {
  progdefaults.auto_flnet_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_auto_flnet=(Fl_Button *)0;

static void cb_btn_select_auto_flnet(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.auto_flnet_pathname);
  txt_auto_flnet_pathname->value(str.c_str());
  progdefaults.auto_flnet_pathname = str;
  progdefaults.changed = true;
}

Fl_Input2 *txt_auto_fllog_pathname=(Fl_Input2 *)0;

static void cb_txt_auto_fllog_pathname(Fl_Input2* o, void*) {
  progdefaults.auto_fllog_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_fllog=(Fl_Button *)0;

static void cb_btn_select_fllog(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.auto_fllog_pathname);
  txt_auto_fllog_pathname->value(str.c_str());
  progdefaults.auto_fllog_pathname = str;
  progdefaults.changed = true;
}

Fl_Input2 *txt_auto_prog1_pathname=(Fl_Input2 *)0;

static void cb_txt_auto_prog1_pathname(Fl_Input2* o, void*) {
  progdefaults.auto_prog1_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_prog1=(Fl_Button *)0;

static void cb_btn_select_prog1(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.auto_prog1_pathname);
  txt_auto_prog1_pathname->value(str.c_str());
  progdefaults.auto_prog1_pathname = str;
  progdefaults.changed = true;
}

Fl_Input2 *txt_auto_prog2_pathname=(Fl_Input2 *)0;

static void cb_txt_auto_prog2_pathname(Fl_Input2* o, void*) {
  progdefaults.auto_prog2_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_prog2=(Fl_Button *)0;

static void cb_btn_select_prog2(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.auto_prog2_pathname);
  txt_auto_prog2_pathname->value(str.c_str());
  progdefaults.auto_prog2_pathname = str;
  progdefaults.changed = true;
}

Fl_Input2 *txt_auto_prog3_pathname=(Fl_Input2 *)0;

static void cb_txt_auto_prog3_pathname(Fl_Input2* o, void*) {
  progdefaults.auto_prog3_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_prog3=(Fl_Button *)0;

static void cb_btn_select_prog3(Fl_Button*, void*) {
  std::string str = select_binary_pathname(progdefaults.auto_prog3_pathname);
  txt_auto_prog3_pathname->value(str.c_str());
  progdefaults.auto_prog3_pathname = str;
  progdefaults.changed = true;
}

Fl_Check_Button *btn_flrig_auto_enable=(Fl_Check_Button *)0;

static void cb_btn_flrig_auto_enable(Fl_Check_Button* o, void*) {
  progdefaults.flrig_auto_enable = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_flamp_auto_enable=(Fl_Check_Button *)0;

static void cb_btn_flamp_auto_enable(Fl_Check_Button* o, void*) {
  progdefaults.flamp_auto_enable = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_flnet_auto_enable=(Fl_Check_Button *)0;

static void cb_btn_flnet_auto_enable(Fl_Check_Button* o, void*) {
  progdefaults.flnet_auto_enable = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_fllog_auto_enable=(Fl_Check_Button *)0;

static void cb_btn_fllog_auto_enable(Fl_Check_Button* o, void*) {
  progdefaults.fllog_auto_enable = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_prog1_auto_enable=(Fl_Check_Button *)0;

static void cb_btn_prog1_auto_enable(Fl_Check_Button* o, void*) {
  progdefaults.prog1_auto_enable = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_prog2_auto_enable=(Fl_Check_Button *)0;

static void cb_btn_prog2_auto_enable(Fl_Check_Button* o, void*) {
  progdefaults.prog2_auto_enable = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_prog3_auto_enable=(Fl_Check_Button *)0;

static void cb_btn_prog3_auto_enable(Fl_Check_Button* o, void*) {
  progdefaults.prog3_auto_enable = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_test_flrig=(Fl_Button *)0;

static void cb_btn_test_flrig(Fl_Button*, void*) {
  start_process(progdefaults.auto_flrig_pathname);
}

Fl_Button *btn_test_flamp=(Fl_Button *)0;

static void cb_btn_test_flamp(Fl_Button*, void*) {
  start_process(progdefaults.auto_flamp_pathname);
}

Fl_Button *btn_test_flnet=(Fl_Button *)0;

static void cb_btn_test_flnet(Fl_Button*, void*) {
  start_process(progdefaults.auto_flnet_pathname);
}

Fl_Button *btn_test_fllog=(Fl_Button *)0;

static void cb_btn_test_fllog(Fl_Button*, void*) {
  start_process(progdefaults.auto_fllog_pathname);
}

Fl_Button *btn_test_prog1=(Fl_Button *)0;

static void cb_btn_test_prog1(Fl_Button*, void*) {
  start_process(progdefaults.auto_prog1_pathname);
}

Fl_Button *btn_test_prog2=(Fl_Button *)0;

static void cb_btn_test_prog2(Fl_Button*, void*) {
  start_process(progdefaults.auto_prog2_pathname);
}

Fl_Button *btn_test_prog3=(Fl_Button *)0;

static void cb_btn_test_prog3(Fl_Button*, void*) {
  start_process(progdefaults.auto_prog3_pathname);
}

Fl_Check_Button *chkSlowCpu=(Fl_Check_Button *)0;

static void cb_chkSlowCpu(Fl_Check_Button* o, void*) {
  progdefaults.slowcpu = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkDTMFdecode=(Fl_Check_Button *)0;

static void cb_chkDTMFdecode(Fl_Check_Button* o, void*) {
  progdefaults.DTMFdecode = o->value();
}

Fl_Input *btnKmlSaveDir=(Fl_Input *)0;

static void cb_btnKmlSaveDir(Fl_Input* o, void*) {
  progdefaults.kml_save_dir=o->value();
  progdefaults.changed = true;
  kml_init();
}

Fl_Input *inputKmlRootFile=(Fl_Input *)0;

Fl_Counter *cntKmlMergeDistance=(Fl_Counter *)0;

static void cb_cntKmlMergeDistance(Fl_Counter* o, void*) {
  progdefaults.kml_merge_distance = o->value();
  progdefaults.changed = true;
  kml_init();
}

Fl_Counter *cntKmlRetentionTime=(Fl_Counter *)0;

static void cb_cntKmlRetentionTime(Fl_Counter* o, void*) {
  progdefaults.kml_retention_time = o->value();
  progdefaults.changed = true;
  kml_init();
}

Fl_Spinner2 *cntKmlRefreshInterval=(Fl_Spinner2 *)0;

static void cb_cntKmlRefreshInterval(Fl_Spinner2* o, void*) {
  progdefaults.kml_refresh_interval = (int)(o->value());
  progdefaults.changed = true;
  kml_init();
}

Fl_ListBox *listbox_kml_balloon_style=(Fl_ListBox *)0;

static void cb_listbox_kml_balloon_style(Fl_ListBox* o, void*) {
  progdefaults.kml_balloon_style = o->index();
  progdefaults.changed = true;
  kml_init();
}

Fl_Input *btnKmlCommand=(Fl_Input *)0;

static void cb_btnKmlCommand(Fl_Input* o, void*) {
  progdefaults.kml_command=o->value();
  progdefaults.changed = true;
  kml_init();
}

Fl_Button *btlTestKmlCommand=(Fl_Button *)0;

static void cb_btlTestKmlCommand(Fl_Button*, void*) {
  KmlServer::SpawnProcess();
}

Fl_Button *btnSelectKmlDestDir=(Fl_Button *)0;

static void cb_btnSelectKmlDestDir(Fl_Button*, void*) {
  Fl_File_Chooser *fc = new Fl_File_Chooser(".",NULL,Fl_File_Chooser::DIRECTORY,"Input File");
  fc->callback(KmlDestDirSet);
  fc->show();
}

Fl_Button *btlPurge=(Fl_Button *)0;

static void cb_btlPurge(Fl_Button*, void*) {
  KmlServer::GetInstance()->Reset();
}

Fl_Check_Button *btnKmlPurgeOnStartup=(Fl_Check_Button *)0;

static void cb_btnKmlPurgeOnStartup(Fl_Check_Button* o, void*) {
  progdefaults.kml_purge_on_startup = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_kml_enabled=(Fl_Check_Button *)0;

static void cb_btn_kml_enabled(Fl_Check_Button* o, void*) {
  progdefaults.kml_enabled = o->value();
  if (progdefaults.kml_enabled) {
    kml_init(true);
    progdefaults.changed = true;
  } else {
    KmlServer::Exit();
  }
}

Fl_Check_Button *chkAutoExtract=(Fl_Check_Button *)0;

static void cb_chkAutoExtract(Fl_Check_Button* o, void*) {
  progdefaults.autoextract = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_open_wrap_folder=(Fl_Check_Button *)0;

static void cb_chk_open_wrap_folder(Fl_Check_Button* o, void*) {
  progdefaults.open_nbems_folder = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_open_flmsg=(Fl_Check_Button *)0;

static void cb_chk_open_flmsg(Fl_Check_Button* o, void*) {
  progdefaults.open_flmsg = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chk_open_flmsg_print=(Fl_Check_Button *)0;

static void cb_chk_open_flmsg_print(Fl_Check_Button* o, void*) {
  progdefaults.open_flmsg_print = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txt_flmsg_pathname=(Fl_Input2 *)0;

static void cb_txt_flmsg_pathname(Fl_Input2* o, void*) {
  progdefaults.flmsg_pathname = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_select_flmsg=(Fl_Button *)0;

static void cb_btn_select_flmsg(Fl_Button*, void*) {
  select_flmsg_pathname();
}

Fl_Value_Slider *sldr_extract_timeout=(Fl_Value_Slider *)0;

static void cb_sldr_extract_timeout(Fl_Value_Slider* o, void*) {
  progdefaults.extract_timeout=o->value();
  progdefaults.changed=true;
}

Fl_Check_Button *chk_transfer__to_open_flmsg=(Fl_Check_Button *)0;

static void cb_chk_transfer__to_open_flmsg(Fl_Check_Button* o, void*) {
  progdefaults.flmsg_transfer_direct = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnPSKRepAuto=(Fl_Check_Button *)0;

static void cb_btnPSKRepAuto(Fl_Check_Button* o, void*) {
  progdefaults.pskrep_auto = o->value();
  btnPSKRepInit->labelcolor(FL_RED);
  btnPSKRepInit->redraw_label();
  progdefaults.changed = true;
}

Fl_Check_Button *btnPSKRepLog=(Fl_Check_Button *)0;

static void cb_btnPSKRepLog(Fl_Check_Button* o, void*) {
  progdefaults.pskrep_log = o->value();
  btnPSKRepInit->labelcolor(FL_RED);
  btnPSKRepInit->redraw_label();
  progdefaults.changed = true;
}

Fl_Check_Button *btnPSKRepQRG=(Fl_Check_Button *)0;

static void cb_btnPSKRepQRG(Fl_Check_Button* o, void*) {
  progdefaults.pskrep_qrg = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_report_when_visible=(Fl_Check_Button *)0;

static void cb_btn_report_when_visible(Fl_Check_Button* o, void*) {
  progdefaults.report_when_visible = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_pskrep_autostart=(Fl_Check_Button *)0;

static void cb_btn_pskrep_autostart(Fl_Check_Button* o, void*) {
  progdefaults.pskrep_autostart = o->value();
  progdefaults.changed = true;
}

Fl_Box *box_connected_to_pskrep=(Fl_Box *)0;

Fl_Input2 *inpPSKRepHost=(Fl_Input2 *)0;

static void cb_inpPSKRepHost(Fl_Input2* o, void*) {
  progdefaults.pskrep_host = o->value();
  btnPSKRepInit->labelcolor(FL_RED);
  btnPSKRepInit->redraw_label();
  progdefaults.changed = true;
}

Fl_Input2 *inpPSKRepPort=(Fl_Input2 *)0;

static void cb_inpPSKRepPort(Fl_Input2* o, void*) {
  progdefaults.pskrep_port = o->value();
  btnPSKRepInit->labelcolor(FL_RED);
  btnPSKRepInit->redraw_label();
  progdefaults.changed = true;
}

Fl_Button *btnPSKRepInit=(Fl_Button *)0;

static void cb_btnPSKRepInit(Fl_Button* o, void*) {
  pskrep_stop();
  if (!pskrep_start()) {
      boxPSKRepMsg->copy_label(pskrep_error());
      progdefaults.usepskrep = false;
      box_connected_to_pskrep->color(FL_WHITE);
      box_connected_to_pskrep->redraw();
  } else {
      boxPSKRepMsg->label(0);
      o->labelcolor(FL_FOREGROUND_COLOR);
      progdefaults.usepskrep = true;
      box_connected_to_pskrep->color(FL_GREEN);
      box_connected_to_pskrep->redraw();
  }
}

Fl_Box *boxPSKRepMsg=(Fl_Box *)0;

Fl_Counter *cntBusyChannelSeconds=(Fl_Counter *)0;

static void cb_cntBusyChannelSeconds(Fl_Counter* o, void*) {
  progStatus.busyChannelSeconds = (int) o->value();
  progdefaults.busyChannelSeconds = (int) o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnEnableBusyChannel=(Fl_Check_Button *)0;

static void cb_btnEnableBusyChannel(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.enableBusyChannel = true;
  	progdefaults.enableBusyChannel = true;
  }
  else {
  	progStatus.enableBusyChannel = false;
  	progdefaults.enableBusyChannel = false;
  }
  progdefaults.changed = true;
}

Fl_Counter *cntPSMTXBufferFlushTimer=(Fl_Counter *)0;

static void cb_cntPSMTXBufferFlushTimer(Fl_Counter* o, void*) {
  progStatus.psm_flush_buffer_timeout = (int) o->value();
  progdefaults.psm_flush_buffer_timeout = (int) o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntPSMBandwidthMargins=(Fl_Counter *)0;

static void cb_cntPSMBandwidthMargins(Fl_Counter* o, void*) {
  progStatus.psm_minimum_bandwidth_margin   = (int) o->value();
  progdefaults.psm_minimum_bandwidth_margin = (int) o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntPSMValidSamplePeriod=(Fl_Counter *)0;

static void cb_cntPSMValidSamplePeriod(Fl_Counter* o, void*) {
  progStatus.psm_hit_time_window   = (int) o->value();
  progdefaults.psm_hit_time_window = (int) o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnEnable_csma=(Fl_Check_Button *)0;

static void cb_btnEnable_csma(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.csma_enabled = true;
  	progdefaults.csma_enabled = true;
  } else {
  	progStatus.csma_enabled = false;
  	progdefaults.csma_enabled = false;
  }
  progdefaults.changed = true;
}

Fl_Counter *cntPersistance=(Fl_Counter *)0;

static void cb_cntPersistance(Fl_Counter* o, void*) {
  progStatus.csma_persistance = (int) o->value();
  progdefaults.csma_persistance = (int) o->value();
  progdefaults.changed = true;
  update_csma_io_config(CSMA_PERSISTANCE);
}

Fl_Counter *cntSlotTime=(Fl_Counter *)0;

static void cb_cntSlotTime(Fl_Counter* o, void*) {
  progStatus.csma_slot_time = (int) o->value();
  progdefaults.csma_slot_time = (int) o->value();
  progdefaults.changed = true;
  update_csma_io_config(CSMA_SLOT_TIME);
}

Fl_Counter *cntTransmitDelay=(Fl_Counter *)0;

static void cb_cntTransmitDelay(Fl_Counter* o, void*) {
  progStatus.csma_transmit_delay = (int) o->value();
  progdefaults.csma_transmit_delay = (int) o->value();
  progdefaults.changed = true;
  update_csma_io_config(CSMA_TX_DELAY);
}

Fl_Output *OutputSlotTimeMS=(Fl_Output *)0;

Fl_Output *OutputTransmitDelayMS=(Fl_Output *)0;

Fl_Output *OutputPersistancePercent=(Fl_Output *)0;

Fl_Check_Button *btnEnable_histogram=(Fl_Check_Button *)0;

static void cb_btnEnable_histogram(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.psm_use_histogram = true;
  	progdefaults.psm_use_histogram = true;
  } else {
  	progStatus.psm_use_histogram = false;
  	progdefaults.psm_use_histogram = false;
  }
  progdefaults.changed = true;
}

Fl_Counter *cntPSMThreshold=(Fl_Counter *)0;

static void cb_cntPSMThreshold(Fl_Counter* o, void*) {
  progStatus.psm_histogram_offset_threshold = (int) o->value();
  progdefaults.psm_histogram_offset_threshold = (int) o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntKPSQLAttenuation=(Fl_Counter *)0;

static void cb_cntKPSQLAttenuation(Fl_Counter* o, void*) {
  progStatus.kpsql_attenuation = (int) o->value();
  progdefaults.kpsql_attenuation = (int) o->value();
  update_kpsql_fractional_gain(progStatus.kpsql_attenuation);
  progdefaults.changed = true;
}

Fl_Check_Button *btn_show_psm_button=(Fl_Check_Button *)0;

static void cb_btn_show_psm_button(Fl_Check_Button* o, void*) {
  progdefaults.show_psm_btn = o->value();
  UI_select();
  progdefaults.changed = true;
}

Fl_Button *btnBuyChannelDefaults=(Fl_Button *)0;

static void cb_btnBuyChannelDefaults(Fl_Button*, void*) {
  psm_set_defaults();
}

Fl_Group *grpTalker=(Fl_Group *)0;

Fl_Light_Button *btnConnectTalker=(Fl_Light_Button *)0;

static void cb_btnConnectTalker(Fl_Light_Button* o, void*) {
  if (o->value()) open_talker();
  else close_talker();
}

Fl_Check_Button *btn_auto_talk=(Fl_Check_Button *)0;

static void cb_btn_auto_talk(Fl_Check_Button* o, void*) {
  progdefaults.auto_talk = o->value();
}

Fl_Check_Button *chkRxStream=(Fl_Check_Button *)0;

static void cb_chkRxStream(Fl_Check_Button* o, void*) {
  progdefaults.speak = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnTXLEVEL_by_mode=(Fl_Check_Button *)0;

static void cb_btnTXLEVEL_by_mode(Fl_Check_Button* o, void*) {
  progdefaults.txlevel_by_mode=o->value();
  modeband.band_mode_change();
  progdefaults.changed = true;
}

Fl_Check_Button *btnSQLCH_by_mode=(Fl_Check_Button *)0;

static void cb_btnSQLCH_by_mode(Fl_Check_Button* o, void*) {
  progdefaults.sqlch_by_mode=o->value();
  modeband.band_mode_change();
  progdefaults.changed = true;
}

Fl_Check_Button *btnAFC_by_mode=(Fl_Check_Button *)0;

static void cb_btnAFC_by_mode(Fl_Check_Button* o, void*) {
  progdefaults.afc_by_mode=o->value();
  modeband.band_mode_change();
  progdefaults.changed = true;
}

Fl_Check_Button *btnREVERSE_by_mode=(Fl_Check_Button *)0;

static void cb_btnREVERSE_by_mode(Fl_Check_Button* o, void*) {
  progdefaults.reverse_by_mode=o->value();
  modeband.band_mode_change();
  progdefaults.changed = true;
}

Fl_Value_Input2 *valCWsweetspot=(Fl_Value_Input2 *)0;

static void cb_valCWsweetspot(Fl_Value_Input2* o, void*) {
  progdefaults.CWsweetspot=o->value();
  progdefaults.changed = true;
}

Fl_Value_Input2 *valRTTYsweetspot=(Fl_Value_Input2 *)0;

static void cb_valRTTYsweetspot(Fl_Value_Input2* o, void*) {
  progdefaults.RTTYsweetspot=o->value();

  cntr_xcvr_FSK_MARK->value(progdefaults.RTTYsweetspot - rtty::SHIFT[progdefaults.rtty_shift] / 2);

  resetRTTY();

  progdefaults.changed = true;
}

Fl_Value_Input2 *valPSKsweetspot=(Fl_Value_Input2 *)0;

static void cb_valPSKsweetspot(Fl_Value_Input2* o, void*) {
  progdefaults.PSKsweetspot=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnStartAtSweetSpot=(Fl_Check_Button *)0;

static void cb_btnStartAtSweetSpot(Fl_Check_Button* o, void*) {
  progdefaults.StartAtSweetSpot = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnCWIsLSB=(Fl_Check_Button *)0;

static void cb_btnCWIsLSB(Fl_Check_Button* o, void*) {
  progdefaults.CWIsLSB=o->value();
  progdefaults.changed=true;
}

static void cb_Misc(Fl_Group*, void*) {
  btnDisable_p2p_io_widgets->value(1);
}

Fl_Check_Button *btnDisable_p2p_io_widgets=(Fl_Check_Button *)0;

static void cb_btnDisable_p2p_io_widgets(Fl_Check_Button* o, long) {
  progStatus.ip_lock = o->value();
  if(o->value())
  	disable_config_p2p_io_widgets();
  else
  	enable_config_p2p_io_widgets();
  kiss_io_set_button_state(0);
}

Fl_Check_Button *btnEnable_arq=(Fl_Check_Button *)0;

static void cb_btnEnable_arq(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	enable_arq();
  }

  progdefaults.changed = true;
}

Fl_Check_Button *btnEnable_kiss=(Fl_Check_Button *)0;

static void cb_btnEnable_kiss(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	enable_kiss();
  }
  progdefaults.changed = true;
}

Fl_Input2 *txtKiss_ip_address=(Fl_Input2 *)0;

static void cb_txtKiss_ip_address(Fl_Input2* o, void*) {
  progStatus.kiss_address = o->value();
  progdefaults.kiss_address = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txtKiss_ip_io_port_no=(Fl_Input2 *)0;

static void cb_txtKiss_ip_io_port_no(Fl_Input2* o, void*) {
  progStatus.kiss_io_port = o->value();
  progdefaults.kiss_io_port = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txtKiss_ip_out_port_no=(Fl_Input2 *)0;

static void cb_txtKiss_ip_out_port_no(Fl_Input2* o, void*) {
  progStatus.kiss_out_port = o->value();
  progdefaults.kiss_out_port = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnEnable_dual_port=(Fl_Check_Button *)0;

static void cb_btnEnable_dual_port(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.kiss_dual_port_enabled = true;
  	progdefaults.kiss_dual_port_enabled = true;
  }
  else {
  	progStatus.kiss_dual_port_enabled = false;
  	progdefaults.kiss_dual_port_enabled = false;
  }

  progdefaults.changed = true;
}

Fl_Button *btn_restart_kiss=(Fl_Button *)0;

static void cb_btn_restart_kiss(Fl_Button*, void*) {
  //restart_kiss_server();
}

Fl_Button *btn_connect_kiss_io=(Fl_Button *)0;

static void cb_btn_connect_kiss_io(Fl_Button*, void*) {
  connect_to_kiss_io(true);
}

Fl_Button *btnDefault_kiss_ip=(Fl_Button *)0;

static void cb_btnDefault_kiss_ip(Fl_Button*, void*) {
  set_ip_to_default(KISS_IO);
  progdefaults.changed = true;
}

Fl_Check_Button *btnKissTCPIO=(Fl_Check_Button *)0;

static void cb_btnKissTCPIO(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.kiss_tcp_io = true;
  	progdefaults.kiss_tcp_io = true;
  } else {
  	progStatus.kiss_tcp_io = false;
  	progdefaults.kiss_tcp_io = false;
  }
  kiss_io_set_button_state(0);
  progdefaults.changed = true;
}

Fl_Check_Button *btnKissUDPIO=(Fl_Check_Button *)0;

static void cb_btnKissUDPIO(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.kiss_tcp_io = false;
  	progdefaults.kiss_tcp_io = false;
  } else {
  	progStatus.kiss_tcp_io = true;
  	progdefaults.kiss_tcp_io = true;
  }

  kiss_io_set_button_state(0);
  progdefaults.changed = true;
}

Fl_Check_Button *btnKissTCPListen=(Fl_Check_Button *)0;

static void cb_btnKissTCPListen(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.kiss_tcp_listen = true;
  	progdefaults.kiss_tcp_listen = true;
  } else {
  	progStatus.kiss_tcp_listen = false;
  	progdefaults.kiss_tcp_listen = false;
  }

  progdefaults.changed = true;
}

Fl_Check_Button *btnEnable_7bit_modem_inhibit=(Fl_Check_Button *)0;

static void cb_btnEnable_7bit_modem_inhibit(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.kiss_io_modem_change_inhibit = true;
  	progdefaults.kiss_io_modem_change_inhibit = true;
  }
  else {
  	progStatus.kiss_io_modem_change_inhibit = false;
  	progdefaults.kiss_io_modem_change_inhibit = false;
  }

  progdefaults.changed = true;
}

Fl_Check_Button *btnEnable_auto_connect=(Fl_Check_Button *)0;

static void cb_btnEnable_auto_connect(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progdefaults.tcp_udp_auto_connect = true;
  }
  else {
  	progdefaults.tcp_udp_auto_connect = false;
  }

  progdefaults.changed = true;
}

Fl_Check_Button *btnEnable_ax25_decode=(Fl_Check_Button *)0;

static void cb_btnEnable_ax25_decode(Fl_Check_Button* o, void*) {
  if(o->value()) {
  	progStatus.ax25_decode_enabled = true;
  	progdefaults.ax25_decode_enabled = true;
  }
  else {
  	progStatus.ax25_decode_enabled = false;
  	progdefaults.ax25_decode_enabled = false;
  }

  progdefaults.changed = true;
}

Fl_Input2 *txtArq_ip_address=(Fl_Input2 *)0;

static void cb_txtArq_ip_address(Fl_Input2* o, void*) {
  progdefaults.arq_address = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txtArq_ip_port_no=(Fl_Input2 *)0;

static void cb_txtArq_ip_port_no(Fl_Input2* o, void*) {
  progdefaults.arq_port = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnDefault_arq_ip=(Fl_Button *)0;

static void cb_btnDefault_arq_ip(Fl_Button*, void*) {
  set_ip_to_default(ARQ_IO);
  progdefaults.changed = true;
}

Fl_Button *btn_restart_arq=(Fl_Button *)0;

static void cb_btn_restart_arq(Fl_Button*, void*) {
  //arq_restart();
}

Fl_Button *btnDefault_xmlrpc_ip=(Fl_Button *)0;

static void cb_btnDefault_xmlrpc_ip(Fl_Button*, void*) {
  set_ip_to_default(XMLRPC_IO);
  progdefaults.changed = true;
}

Fl_Input2 *txtXmlrpc_ip_address=(Fl_Input2 *)0;

static void cb_txtXmlrpc_ip_address(Fl_Input2* o, void*) {
  progdefaults.xmlrpc_address = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txtXmlrpc_ip_port_no=(Fl_Input2 *)0;

static void cb_txtXmlrpc_ip_port_no(Fl_Input2* o, void*) {
  progdefaults.xmlrpc_port = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_restart_xml=(Fl_Button *)0;

static void cb_btn_restart_xml(Fl_Button*, void*) {
  //restart_xml_server();
}

Fl_Button *btnDefault_flrig_ip=(Fl_Button *)0;

static void cb_btnDefault_flrig_ip(Fl_Button*, void*) {
  set_ip_to_default(FLRIG_IO);
  progdefaults.changed = true;
}

Fl_Input2 *txt_flrig_ip_address=(Fl_Input2 *)0;

static void cb_txt_flrig_ip_address(Fl_Input2* o, void*) {
  progdefaults.flrig_ip_address = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *txt_flrig_ip_port=(Fl_Input2 *)0;

static void cb_txt_flrig_ip_port(Fl_Input2* o, void*) {
  progdefaults.flrig_ip_port = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_reconnect_flrig_server=(Fl_Button *)0;

static void cb_btn_reconnect_flrig_server(Fl_Button*, void*) {
  reconnect_to_flrig();
}

Fl_Input *txt_fllog_ip_address=(Fl_Input *)0;

static void cb_txt_fllog_ip_address(Fl_Input* o, void*) {
  progdefaults.xmllog_address = o->value();
}

Fl_Input *txt_fllog_ip_port=(Fl_Input *)0;

static void cb_txt_fllog_ip_port(Fl_Input* o, void*) {
  progdefaults.xmllog_port = o->value();
}

Fl_Button *btn_reconnect_log_server=(Fl_Button *)0;

static void cb_btn_reconnect_log_server(Fl_Button*, void*) {
  progdefaults.xml_logbook = true;
  progdefaults.changed = true;
  connect_to_log_server();
}

Fl_Button *btnDefault_fllog_ip=(Fl_Button *)0;

static void cb_btnDefault_fllog_ip(Fl_Button*, void*) {
  set_ip_to_default(FLLOG_IO);
  progdefaults.changed = true;
}

Fl_Group *grpOperator=(Fl_Group *)0;

Fl_Input2 *inpMyCallsign=(Fl_Input2 *)0;

static void cb_inpMyCallsign(Fl_Input2*, void*) {
  const char *triggers = " !#$%&'()*+,-.;<=>?@[\\]^_{|}~";
  std::string mycall = inpMyCallsign->value();

  bool modified = false;
  for (size_t k = 0; k < mycall.length(); k++) {
    for (size_t n = 0; n < strlen(triggers); n++) {
      if (mycall[k] == triggers[n]) {
        if ( fl_choice2("Replace FSQ trigger character with slash /", _("no"), _("yes"), NULL ) ) {
          mycall[k] = '/';
          modified = true;
        }
      }
    }
  }
  if (modified) {
    int p = inpMyCallsign->position();
    inpMyCallsign->value(mycall.c_str());
    inpMyCallsign->position(p); // causes a redraw
  }

  progdefaults.myCall = mycall;

  if (progdefaults.THORsecText.empty()) {
  progdefaults.THORsecText = mycall;
  progdefaults.THORsecText.append(" ");
  txtTHORSecondary->value(progdefaults.THORsecText.c_str());
  }

  if (progdefaults.secText.empty()) {
  progdefaults.secText = mycall;
  progdefaults.secText.append(" ");
  txtSecondary->value(progdefaults.secText.c_str());
  }

  update_main_title();
  notify_change_callsign();
  progdefaults.changed = true;
}

Fl_Input2 *inpOperCallsign=(Fl_Input2 *)0;

static void cb_inpOperCallsign(Fl_Input2* o, void*) {
  progdefaults.operCall = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpMyName=(Fl_Input2 *)0;

static void cb_inpMyName(Fl_Input2* o, void*) {
  progdefaults.myName = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpMyAntenna=(Fl_Input2 *)0;

static void cb_inpMyAntenna(Fl_Input2* o, void*) {
  progdefaults.myAntenna = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpMyQth=(Fl_Input2 *)0;

static void cb_inpMyQth(Fl_Input2* o, void*) {
  progdefaults.myQth = o->value();
  inpMyFSQQth->value(o->value());
  progdefaults.changed = true;
}

Fl_Input2 *inpMyLocator=(Fl_Input2 *)0;

static void cb_inpMyLocator(Fl_Input2* o, void*) {
  progdefaults.myLocator = o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_states=(Fl_ListBox *)0;

static void cb_listbox_states(Fl_ListBox* o, void*) {
  listbox_counties->clear();
  listbox_counties->add(states.counties(o->value()).c_str());
  listbox_counties->index(0);
  inp_QP_short_county->value(states.cnty_short(listbox_states->value(),listbox_counties->value()).c_str());
  inp_QP_state_short->value(states.state_short(o->value()).c_str());
  progdefaults.SQSOstate = o->index();
  progdefaults.changed = true;
}

Fl_Input2 *inp_QP_state_short=(Fl_Input2 *)0;

Fl_ListBox *listbox_counties=(Fl_ListBox *)0;

static void cb_listbox_counties(Fl_ListBox* o, void*) {
  inp_QP_short_county->value(states.cnty_short(listbox_states->value(),o->value()).c_str());
  progdefaults.SQSOcounty = o->index();
  progdefaults.changed = true;
}

Fl_Input2 *inp_QP_short_county=(Fl_Input2 *)0;

Fl_Group *grpRigFlrig=(Fl_Group *)0;

Fl_Check_Button *chk_flrig_keys_modem=(Fl_Check_Button *)0;

static void cb_chk_flrig_keys_modem(Fl_Check_Button* o, void*) {
  progdefaults.flrig_keys_modem = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnDefault_flrig_ip_mirror=(Fl_Button *)0;

static void cb_btnDefault_flrig_ip_mirror(Fl_Button*, void*) {
  set_ip_to_default(FLRIG_IO);
  txt_flrig_ip_address_mirror->value(progdefaults.flrig_ip_address.c_str());
  txt_flrig_ip_port_mirror->value(progdefaults.flrig_ip_port.c_str());
  progdefaults.changed = true;
}

Fl_Input2 *txt_flrig_ip_address_mirror=(Fl_Input2 *)0;

static void cb_txt_flrig_ip_address_mirror(Fl_Input2* o, void*) {
  progdefaults.flrig_ip_address = o->value();
  txt_flrig_ip_address->value(progdefaults.flrig_ip_address.c_str());
  progdefaults.changed = true;
}

Fl_Input2 *txt_flrig_ip_port_mirror=(Fl_Input2 *)0;

static void cb_txt_flrig_ip_port_mirror(Fl_Input2* o, void*) {
  progdefaults.flrig_ip_port = o->value();
  txt_flrig_ip_port->value(progdefaults.flrig_ip_port.c_str());
  progdefaults.changed = true;
}

Fl_Button *btn_reconnect_flrig_server_mirror=(Fl_Button *)0;

static void cb_btn_reconnect_flrig_server_mirror(Fl_Button*, void*) {
  reconnect_to_flrig();
}

Fl_Check_Button *btn_fldigi_client_to_flrig=(Fl_Check_Button *)0;

static void cb_btn_fldigi_client_to_flrig(Fl_Check_Button* o, void*) {
  progdefaults.fldigi_client_to_flrig=o->value();
  if (o->value()) {
    progdefaults.chkUSEHAMLIBis = false;
    progdefaults.chkUSERIGCATis = false;
    chkUSEHAMLIB->value(0);
    chkUSERIGCAT->value(0);
  }
  progdefaults.changed=true;
}

Fl_Check_Button *btn_flrig_auto_shutdown=(Fl_Check_Button *)0;

static void cb_btn_flrig_auto_shutdown(Fl_Check_Button* o, void*) {
  progdefaults.flrig_auto_shutdown=o->value();
  progdefaults.changed=true;
}

Fl_Counter2 *val_flrig_poll=(Fl_Counter2 *)0;

static void cb_val_flrig_poll(Fl_Counter2* o, void*) {
  progdefaults.flrig_poll = o->value();
}

Fl_Group *grpRigCat=(Fl_Group *)0;

Fl_Check_Button *chkUSERIGCAT=(Fl_Check_Button *)0;

static void cb_chkUSERIGCAT(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
    chkUSEHAMLIB->value(0);
    btn_fldigi_client_to_flrig->value(0);
    progdefaults.chkUSERIGCATis = true;
    progdefaults.fldigi_client_to_flrig = false;
    btnInitRIGCAT->labelcolor(FL_RED);
    btnInitRIGCAT->redraw();
  } else {
    progdefaults.chkUSERIGCATis = false;
    progdefaults.initInterface();
  }
  progdefaults.changed=true;
}

Fl_Group *grpRigCAT=(Fl_Group *)0;

Fl_Output *txtXmlRigFilename=(Fl_Output *)0;

Fl_Button *btnSelectRigXmlFile=(Fl_Button *)0;

static void cb_btnSelectRigXmlFile(Fl_Button*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
  selectRigXmlFilename();
}

Fl_ComboBox *inpXmlRigDevice=(Fl_ComboBox *)0;

static void cb_inpXmlRigDevice(Fl_ComboBox*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Value_Input2 *cntRigCatRetries=(Fl_Value_Input2 *)0;

static void cb_cntRigCatRetries(Fl_Value_Input2*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Value_Input2 *cntRigCatTimeout=(Fl_Value_Input2 *)0;

static void cb_cntRigCatTimeout(Fl_Value_Input2*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Value_Input2 *cntRigCatWait=(Fl_Value_Input2 *)0;

static void cb_cntRigCatWait(Fl_Value_Input2*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_ListBox *listbox_xml_rig_baudrate=(Fl_ListBox *)0;

static void cb_listbox_xml_rig_baudrate(Fl_ListBox*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Counter2 *valRigCatStopbits=(Fl_Counter2 *)0;

static void cb_valRigCatStopbits(Fl_Counter2*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw();
}

Fl_Button *btnInitRIGCAT=(Fl_Button *)0;

static void cb_btnInitRIGCAT(Fl_Button* o, void*) {
  progdefaults.initInterface();
  o->labelcolor(FL_FOREGROUND_COLOR);
  progdefaults.changed = true;
}

Fl_Check_Button *btnRigCatEcho=(Fl_Check_Button *)0;

static void cb_btnRigCatEcho(Fl_Check_Button*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
  progdefaults.changed = true;
}

Fl_Round_Button *btnRigCatCMDptt=(Fl_Round_Button *)0;

static void cb_btnRigCatCMDptt(Fl_Round_Button* o, void*) {
  if (o->value()== 1) {
  btnRigCatRTSptt->value(0);
  btnRigCatDTRptt->value(0);
  progdefaults.RigCatCMDptt = true;
  progdefaults.TTYptt = 
  progdefaults.UsePPortPTT =
  progdefaults.UseUHrouterPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.RigCatCMDptt = false;

  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw();
}

Fl_Round_Button *btnRigCatRTSptt=(Fl_Round_Button *)0;

static void cb_btnRigCatRTSptt(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  btnRigCatCMDptt->value(0);
  progdefaults.RigCatRTSptt = true;
  progdefaults.TTYptt = 
  progdefaults.UsePPortPTT =
  progdefaults.UseUHrouterPTT =
  progdefaults.RigCatCMDptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.RigCatRTSptt = false;

  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Round_Button *btnRigCatDTRptt=(Fl_Round_Button *)0;

static void cb_btnRigCatDTRptt(Fl_Round_Button* o, void*) {
  if (o->value() == 1) {
  btnRigCatCMDptt->value(0);
  progdefaults.RigCatDTRptt = true;
  progdefaults.TTYptt = 
  progdefaults.UsePPortPTT =
  progdefaults.UseUHrouterPTT =
  progdefaults.RigCatCMDptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.RigCatDTRptt = false;

  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Check_Button *btnRigCatRTSplus=(Fl_Check_Button *)0;

static void cb_btnRigCatRTSplus(Fl_Check_Button*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Check_Button *btnRigCatDTRplus=(Fl_Check_Button *)0;

static void cb_btnRigCatDTRplus(Fl_Check_Button*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Check_Button *chkRigCatRTSCTSflow=(Fl_Check_Button *)0;

static void cb_chkRigCatRTSCTSflow(Fl_Check_Button*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Check_Button *chk_restore_tio=(Fl_Check_Button *)0;

static void cb_chk_restore_tio(Fl_Check_Button*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Check_Button *chkRigCatVSP=(Fl_Check_Button *)0;

static void cb_chkRigCatVSP(Fl_Check_Button*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Value_Input2 *cntRigCatInitDelay=(Fl_Value_Input2 *)0;

static void cb_cntRigCatInitDelay(Fl_Value_Input2*, void*) {
  btnInitRIGCAT->labelcolor(FL_RED);
  btnInitRIGCAT->redraw_label();
}

Fl_Group *grpRigGPIO=(Fl_Group *)0;

Fl_Check_Button *btn_gpio_ptt2=(Fl_Check_Button *)0;

static void cb_btn_gpio_ptt2(Fl_Check_Button* o, void*) {
  btnTTYptt->value(0);
  btnUsePPortPTT->value(0);
  btn_gpio_ptt->value(o->value());

  if (o->value()) {
  progdefaults.gpio_ptt = true;
  progdefaults.UseUHrouterPTT =
  progdefaults.TTYptt =
  progdefaults.UsePPortPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.RigCatCMDptt =
  progdefaults.cmedia_ptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.gpio_ptt = false;

  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT2->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  btnInitHWPTT2->redraw();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_gpio_CW=(Fl_Check_Button *)0;

static void cb_btn_gpio_CW(Fl_Check_Button* o, void*) {
  progdefaults.gpio_cw = o->value();
  progdefaults.changed = true;

  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT2->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  btnInitHWPTT2->redraw();
  progdefaults.changed = true;
}

Fl_Button *btnInitHWPTT2=(Fl_Button *)0;

static void cb_btnInitHWPTT2(Fl_Button* o, void*) {
  progdefaults.initInterface();
  o->labelcolor(FL_FOREGROUND_COLOR);
  o->redraw();
  btnInitHWPTT->labelcolor(FL_FOREGROUND_COLOR);
  btnInitHWPTT2->redraw();
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= 1;
    export_gpio(0);
  } else {
    progdefaults.enable_gpio &= ~1;
    unexport_gpio(0);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio1(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<1);
    export_gpio(1);
  } else {
    progdefaults.enable_gpio &= ~(1<<1);
    unexport_gpio(1);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio2(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<2);
    export_gpio(2);
  } else {
    progdefaults.enable_gpio &= ~(1<<2);
    unexport_gpio(2);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio3(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<3);
    export_gpio(3);
  } else {
    progdefaults.enable_gpio &= ~(1<<3);
    unexport_gpio(3);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio4(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<4);
    export_gpio(4);
  } else {
    progdefaults.enable_gpio &= ~(1<<4);
    unexport_gpio(4);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio5(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<5);
    export_gpio(5);
  } else {
    progdefaults.enable_gpio &= ~(1<<5);
    unexport_gpio(5);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio6(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<6);
    export_gpio(6);
  } else {
    progdefaults.enable_gpio &= ~(1<<6);
    unexport_gpio(6);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio7(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<7);
    export_gpio(7);
  } else {
    progdefaults.enable_gpio &= ~(1<<7);
    unexport_gpio(7);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_on(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= 1;
  } else {
    progdefaults.gpio_on &= ~1;
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on1(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<1);
  } else {
    progdefaults.gpio_on &= ~(1<<1);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on2(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<2);
  } else {
    progdefaults.gpio_on &= ~(1<<2);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on3(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<3);
  } else {
    progdefaults.gpio_on &= ~(1<<3);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on4(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<4);
  } else {
    progdefaults.gpio_on &= ~(1<<4);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on5(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<5);
  } else {
    progdefaults.gpio_on &= ~(1<<5);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on6(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<6);
  } else {
    progdefaults.gpio_on &= ~(1<<6);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on7(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<7);
  } else {
    progdefaults.gpio_on &= ~(1<<7);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= 1;
  } else {
    progdefaults.gpio_cw_on &= ~1;
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on1(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<1);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<1);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on2(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<2);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<2);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on3(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<3);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<3);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on4(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<4);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<4);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on5(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<5);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<5);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on6(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<6);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<6);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on7(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<7);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<7);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= 1;
    export_gpio(0);
  } else {
    progdefaults.enable_gpio_cw &= ~1;
    unexport_gpio(0);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw1(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<1);
    export_gpio(1);
  } else {
    progdefaults.enable_gpio &= ~(1<<1);
    unexport_gpio(1);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw2(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<2);
    export_gpio(2);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<2);
    unexport_gpio(2);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw3(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<3);
    export_gpio(3);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<3);
    unexport_gpio(3);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw4(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<4);
    export_gpio(4);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<4);
    unexport_gpio(4);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw5(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<5);
    export_gpio(5);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<5);
    unexport_gpio(5);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw6(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<6);
    export_gpio(6);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<6);
    unexport_gpio(6);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw7(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<7);
    export_gpio(7);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<7);
    unexport_gpio(7);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio8(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<8);
    export_gpio(8);
  } else {
    progdefaults.enable_gpio &= ~(1<<8);
    unexport_gpio(8);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio9(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<9);
    export_gpio(9);
  } else {
    progdefaults.enable_gpio &= ~(1<<9);
    unexport_gpio(9);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpioa(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<10);
    export_gpio(10);
  } else {
    progdefaults.enable_gpio &= ~(1<<10);
    unexport_gpio(10);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpiob(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<11);
    export_gpio(11);
  } else {
    progdefaults.enable_gpio &= ~(1<<11);
    unexport_gpio(11);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpioc(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<12);
    export_gpio(12);
  } else {
    progdefaults.enable_gpio &= ~(1<<12);
    unexport_gpio(12);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpiod(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<13);
    export_gpio(13);
  } else {
    progdefaults.enable_gpio &= ~(1<<13);
    unexport_gpio(13);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpioe(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<14);
    export_gpio(14);
  } else {
    progdefaults.enable_gpio &= ~(1<<14);
    unexport_gpio(14);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpiof(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<15);
    export_gpio(15);
  } else {
    progdefaults.enable_gpio &= ~(1<<15);
    unexport_gpio(15);
  }
  progdefaults.changed = true;
}

Fl_Check_Button *btn_enable_gpio[17]={(Fl_Check_Button *)0};

static void cb_btn_enable_gpio10(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio |= (1<<16);
    export_gpio(16);
  } else {
    progdefaults.enable_gpio &= ~(1<<16);
    unexport_gpio(16);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_on8(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<8);
  } else {
    progdefaults.gpio_on &= ~(1<<8);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_on9(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<9);
  } else {
    progdefaults.gpio_on &= ~(1<<9);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_ona(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<10);
  } else {
    progdefaults.gpio_on &= ~(1<<10);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_onb(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<11);
  } else {
    progdefaults.gpio_on &= ~(1<<11);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_onc(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<12);
  } else {
    progdefaults.gpio_on &= ~(1<<12);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_ond(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<13);
  } else {
    progdefaults.gpio_on &= ~(1<<13);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_one(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<14);
  } else {
    progdefaults.gpio_on &= ~(1<<14);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_onf(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<15);
  } else {
    progdefaults.gpio_on &= ~(1<<15);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

Fl_Check_Button *btn_gpio_on[17]={(Fl_Check_Button *)0};

static void cb_btn_gpio_on10(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_on |= (1<<16);
  } else {
    progdefaults.gpio_on &= ~(1<<16);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on8(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<8);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<8);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_on9(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<1);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<1);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_ona(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<2);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<2);
  }
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_onb(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<3);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<3);
  }wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_onc(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<4);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<4);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_ond(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<13);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<13);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_one(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<14);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<14);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_gpio_cw_onf(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<16);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<15);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

Fl_Check_Button *btn_gpio_cw_on[17]={(Fl_Check_Button *)0};

static void cb_btn_gpio_cw_on10(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.gpio_cw_on |= (1<<16);
  } else {
    progdefaults.gpio_cw_on &= ~(1<<16);
  }
  wf->xmtrcv->value(0);
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw8(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<8);
    export_gpio(8);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<8);
    unexport_gpio(8);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cw9(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<9);
    export_gpio(9);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<9);
    unexport_gpio(9);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cwa(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<10);
    export_gpio(10);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<10);
    unexport_gpio(10);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cwb(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<11);
    export_gpio(11);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<11);
    unexport_gpio(11);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cwc(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<12);
    export_gpio(12);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<12);
    unexport_gpio(12);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cwd(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<13);
    export_gpio(13);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<13);
    unexport_gpio(13);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cwe(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<14);
    export_gpio(14);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<14);
    unexport_gpio(14);
  }
  progdefaults.changed = true;
}

static void cb_btn_enable_gpio_cwf(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<15);
    export_gpio(15);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<15);
    unexport_gpio(15);
  }
  progdefaults.changed = true;
}

Fl_Check_Button *btn_enable_gpio_cw[17]={(Fl_Check_Button *)0};

static void cb_btn_enable_gpio_cw10(Fl_Check_Button* o, void*) {
  if (o->value()){
    progdefaults.enable_gpio_cw |= (1<<16);
    export_gpio(16);
  } else {
    progdefaults.enable_gpio_cw &= ~(1<<16);
    unexport_gpio(16);
  }
  progdefaults.changed = true;
}

Fl_Counter *cnt_gpio_pulse_width=(Fl_Counter *)0;

static void cb_cnt_gpio_pulse_width(Fl_Counter* o, void*) {
  progdefaults.gpio_pulse_width=(int)o->value();
  progdefaults.changed=true;
}

Fl_Group *grpRigHamlib=(Fl_Group *)0;

Fl_Check_Button *chkUSEHAMLIB=(Fl_Check_Button *)0;

static void cb_chkUSEHAMLIB(Fl_Check_Button* o, void*) {
  progdefaults.chkUSEHAMLIBis = o->value();
  if (o->value() == 1) {
    chkUSERIGCAT->value(0);
    btn_fldigi_client_to_flrig->value(0);
    progdefaults.chkUSERIGCATis = false;
    progdefaults.fldigi_client_to_flrig = false;
    btnInitHAMLIB->labelcolor(FL_RED);
    btnInitHAMLIB->activate();
    btnInitHAMLIB->redraw();
  } else {
    progdefaults.initInterface();
  }

  progdefaults.changed = true;
}

Fl_Group *grpHamlib=(Fl_Group *)0;

Fl_ListBox *cboHamlibRig=(Fl_ListBox *)0;

static void cb_cboHamlibRig(Fl_ListBox*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
#if USE_HAMLIB
  hamlib_get_defaults();
#endif
}

Fl_ComboBox *inpRIGdev=(Fl_ComboBox *)0;

static void cb_inpRIGdev(Fl_ComboBox*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Value_Input2 *cntHamlibRetries=(Fl_Value_Input2 *)0;

static void cb_cntHamlibRetries(Fl_Value_Input2*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Value_Input2 *cntHamlibTimeout=(Fl_Value_Input2 *)0;

static void cb_cntHamlibTimeout(Fl_Value_Input2*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Value_Input2 *cntHamlibWriteDelay=(Fl_Value_Input2 *)0;

static void cb_cntHamlibWriteDelay(Fl_Value_Input2*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Value_Input2 *cntHamlibWait=(Fl_Value_Input2 *)0;

static void cb_cntHamlibWait(Fl_Value_Input2*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_ListBox *listbox_baudrate=(Fl_ListBox *)0;

static void cb_listbox_baudrate(Fl_ListBox*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Counter2 *valHamRigStopbits=(Fl_Counter2 *)0;

static void cb_valHamRigStopbits(Fl_Counter2* o, void*) {
  progdefaults.HamRigStopbits = (int)o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *valHamRigPollrate=(Fl_Counter2 *)0;

static void cb_valHamRigPollrate(Fl_Counter2* o, void*) {
  progdefaults.HamRigPollrate = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnHamlibCMDptt=(Fl_Check_Button *)0;

static void cb_btnHamlibCMDptt(Fl_Check_Button* o, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
  if (o->value()) {
  progdefaults.HamlibCMDptt = true;
  progdefaults.TTYptt = 
  progdefaults.UsePPortPTT =
  progdefaults.UseUHrouterPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.RigCatCMDptt = false;
  } else
  progdefaults.HamlibCMDptt = false;

  progdefaults.changed = true;
}

Fl_Check_Button *btnHamlibPTT_ON_DATA=(Fl_Check_Button *)0;

static void cb_btnHamlibPTT_ON_DATA(Fl_Check_Button* o, void*) {
  progdefaults.hamlib_ptt_on_data = o->value();
}

Fl_Check_Button *btnHamlibDTRplus=(Fl_Check_Button *)0;

static void cb_btnHamlibDTRplus(Fl_Check_Button*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Check_Button *chkHamlibRTSplus=(Fl_Check_Button *)0;

static void cb_chkHamlibRTSplus(Fl_Check_Button* o, void*) {
  if (o->value() == 1)
    chkHamlibRTSCTSflow->value(0);
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Check_Button *chkHamlibRTSCTSflow=(Fl_Check_Button *)0;

static void cb_chkHamlibRTSCTSflow(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
    chkHamlibXONXOFFflow->value(0);
    chkHamlibRTSplus->deactivate();
  } else
    chkHamlibRTSplus->activate();
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Check_Button *chkHamlibXONXOFFflow=(Fl_Check_Button *)0;

static void cb_chkHamlibXONXOFFflow(Fl_Check_Button* o, void*) {
  if (o->value() == 1)
    chkHamlibRTSCTSflow->value(0);
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Check_Button *chk_hamlib_cw_is_lsb=(Fl_Check_Button *)0;

static void cb_chk_hamlib_cw_is_lsb(Fl_Check_Button* o, void*) {
  progdefaults.hamlib_cw_islsb = o->value();
}

Fl_Check_Button *chk_hamlib_rtty_is_usb=(Fl_Check_Button *)0;

static void cb_chk_hamlib_rtty_is_usb(Fl_Check_Button* o, void*) {
  progdefaults.hamlib_rtty_isusb = o->value();
}

Fl_Counter2 *val_hamlib_mode_delay=(Fl_Counter2 *)0;

static void cb_val_hamlib_mode_delay(Fl_Counter2* o, void*) {
  progdefaults.hamlib_mode_delay = (int)o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listbox_sideband=(Fl_ListBox *)0;

Fl_Input2 *inpHamlibConfig=(Fl_Input2 *)0;

static void cb_inpHamlibConfig(Fl_Input2*, void*) {
  btnInitHAMLIB->labelcolor(FL_RED);
  btnInitHAMLIB->redraw_label();
}

Fl_Button *btnInitHAMLIB=(Fl_Button *)0;

static void cb_btnInitHAMLIB(Fl_Button* o, void*) {
  progdefaults.initInterface();
  o->labelcolor(FL_FOREGROUND_COLOR);
  progdefaults.changed = true;
}

Fl_Button *btn_hamlib_get_defaults=(Fl_Button *)0;

static void cb_btn_hamlib_get_defaults(Fl_Button*, void*) {
#if USE_HAMLIB
  hamlib_get_defaults();
#endif
}

Fl_Group *grpRigHardware=(Fl_Group *)0;

Fl_Check_Button *btnPTTrightchannel=(Fl_Check_Button *)0;

static void cb_btnPTTrightchannel(Fl_Check_Button* o, void*) {
  progdefaults.PTTrightchannel = o->value();
  btnPTTrightchannel2->value(o->value());

  if (o->value()) {
  progdefaults.QSK = false;
  btnQSK->value(0);
  progdefaults.PseudoFSK = false;
  chkPseudoFSK->value(0);
  progdefaults.sig_on_right_channel = false;
  chkAudioStereoOut->value(0);
  }

  progdefaults.changed = true;
}

Fl_Round_Button *btnTTYptt=(Fl_Round_Button *)0;

static void cb_btnTTYptt(Fl_Round_Button* o, void*) {
  btnUsePPortPTT->value(0);
  btnUseUHrouterPTT->value(0);
  btn_gpio_ptt->value(0);

  if (o->value()) {
  progdefaults.TTYptt = true;
  progdefaults.UsePPortPTT =
  progdefaults.UseUHrouterPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.RigCatCMDptt =
  progdefaults.cmedia_ptt =
  progdefaults.gpio_ptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.TTYptt = false;

  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_ComboBox *inpTTYdev=(Fl_ComboBox *)0;

static void cb_inpTTYdev(Fl_ComboBox* o, void*) {
  progdefaults.PTTdev = o->value();
  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_Round_Button *btnSCU_17=(Fl_Round_Button *)0;

static void cb_btnSCU_17(Fl_Round_Button* o, void*) {
  progdefaults.SCU_17=o->value();
  progdefaults.changed = true;
}

Fl_Round_Button *btnUsePPortPTT=(Fl_Round_Button *)0;

static void cb_btnUsePPortPTT(Fl_Round_Button* o, void*) {
  btnTTYptt->value(0);
  btnUseUHrouterPTT->value(0);
  btn_gpio_ptt->value(0);

  if (o->value()) {
  progdefaults.UsePPortPTT = true;
  progdefaults.TTYptt =
  progdefaults.UseUHrouterPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.RigCatCMDptt =
  progdefaults.cmedia_ptt =
  progdefaults.gpio_ptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.UsePPortPTT = false;

  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_Round_Button *btnUseUHrouterPTT=(Fl_Round_Button *)0;

static void cb_btnUseUHrouterPTT(Fl_Round_Button* o, void*) {
  btnTTYptt->value(0);
  btnUsePPortPTT->value(0);
  btn_gpio_ptt->value(0);

  if (o->value()) {
  progdefaults.UseUHrouterPTT = true;
  progdefaults.TTYptt =
  progdefaults.UsePPortPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.RigCatCMDptt =
  progdefaults.cmedia_ptt =
  progdefaults.gpio_ptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.UseUHrouterPTT = false;

  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_Round_Button *btnRTSptt=(Fl_Round_Button *)0;

static void cb_btnRTSptt(Fl_Round_Button*, void*) {
  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_Round_Button *btnRTSplusV=(Fl_Round_Button *)0;

static void cb_btnRTSplusV(Fl_Round_Button*, void*) {
  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_Round_Button *btnDTRptt=(Fl_Round_Button *)0;

static void cb_btnDTRptt(Fl_Round_Button*, void*) {
  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_Round_Button *btnDTRplusV=(Fl_Round_Button *)0;

static void cb_btnDTRplusV(Fl_Round_Button*, void*) {
  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_gpio_ptt=(Fl_Check_Button *)0;

static void cb_btn_gpio_ptt(Fl_Check_Button* o, void*) {
  btnTTYptt->value(0);
  btnUsePPortPTT->value(0);
  btn_gpio_ptt2->value(o->value());

  if (o->value()) {
  progdefaults.gpio_ptt = true;
  progdefaults.UseUHrouterPTT =
  progdefaults.TTYptt =
  progdefaults.UsePPortPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.RigCatCMDptt =
  progdefaults.cmedia_ptt =
  progdefaults.HamlibCMDptt = false;
  } else
  progdefaults.gpio_ptt = false;

  btnInitHWPTT->labelcolor(FL_RED);
  btnInitHWPTT2->labelcolor(FL_RED);
  btnInitHWPTT->redraw();
  btnInitHWPTT2->redraw();
  progdefaults.changed = true;
}

Fl_Button *btnInitHWPTT=(Fl_Button *)0;

static void cb_btnInitHWPTT(Fl_Button* o, void*) {
  progdefaults.initInterface();
  o->labelcolor(FL_FOREGROUND_COLOR);
  o->redraw();
  btnInitHWPTT2->labelcolor(FL_FOREGROUND_COLOR);
  btnInitHWPTT2->redraw();
  progdefaults.changed = true;
}

Fl_Group *grpPTTdelays=(Fl_Group *)0;

Fl_Counter *cntPTT_on_delay=(Fl_Counter *)0;

static void cb_cntPTT_on_delay(Fl_Counter* o, void*) {
  progdefaults.PTT_on_delay = o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntPTT_off_delay=(Fl_Counter *)0;

static void cb_cntPTT_off_delay(Fl_Counter* o, void*) {
  progdefaults.PTT_off_delay = o->value();
  progdefaults.changed = true;
}

Fl_Group *grp_cmedia_ptt=(Fl_Group *)0;

Fl_Round_Button *btn_use_cmedia_PTT=(Fl_Round_Button *)0;

static void cb_btn_use_cmedia_PTT(Fl_Round_Button* o, void*) {
  if (o->value()) {
  progdefaults.cmedia_ptt = true;
  progdefaults.UsePPortPTT =
  progdefaults.UseUHrouterPTT =
  progdefaults.RigCatRTSptt =
  progdefaults.RigCatDTRptt =
  progdefaults.RigCatCMDptt =
  progdefaults.HamlibCMDptt = false;
  btn_init_cmedia_PTT->labelcolor(FL_RED);
  btn_init_cmedia_PTT->redraw();
  } else {
  progdefaults.cmedia_ptt = false;
  close_cmedia();
  }
  progdefaults.changed = true;
}

Fl_ComboBox *inp_cmedia_dev=(Fl_ComboBox *)0;

static void cb_inp_cmedia_dev(Fl_ComboBox* o, void*) {
  close_cmedia();
  progdefaults.cmedia_device = o->value();
  btn_init_cmedia_PTT->labelcolor(FL_RED);
  btn_init_cmedia_PTT->redraw();
  progdefaults.changed = true;
}

Fl_ComboBox *inp_cmedia_GPIO_line=(Fl_ComboBox *)0;

static void cb_inp_cmedia_GPIO_line(Fl_ComboBox* o, void*) {
  progdefaults.cmedia_gpio_line = o->value();
}

Fl_Button *btn_init_cmedia_PTT=(Fl_Button *)0;

static void cb_btn_init_cmedia_PTT(Fl_Button* o, void*) {
  progdefaults.initInterface();
  o->labelcolor(FL_FOREGROUND_COLOR);
  progdefaults.changed = true;
}

Fl_Button *btn_test_cmedia=(Fl_Button *)0;

static void cb_btn_test_cmedia(Fl_Button*, void*) {
  test_hid_ptt();
}

Fl_File_Input *inp_wav_fname_regex=(Fl_File_Input *)0;

Fl_Button *btn_select_regex_wav=(Fl_Button *)0;

static void cb_btn_select_regex_wav(Fl_Button*, void*) {
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Pick a file");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.filter("wav files\t*.{mp3,wav}\n");
  fnfc.directory("./");           // default directory to use
  // Show native chooser
  switch ( fnfc.show() ) {
    case -1: break; // ERROR
    case  1: break; // CANCEL
    default: {
    	progdefaults.BWSR_REGEX_MATCH = fnfc.filename();
    	inp_wav_fname_regex->value(progdefaults.BWSR_REGEX_MATCH.c_str());
  	progdefaults.REGEX_ALERT_MENU = 0;
  	mnu_regex_alert_menu->value(progdefaults.REGEX_ALERT_MENU);
    	break; // FILE CHOSEN
    }
  }
}

Fl_Choice *mnu_regex_alert_menu=(Fl_Choice *)0;

static void cb_mnu_regex_alert_menu(Fl_Choice* o, void*) {
  if (o->value() > 0) {
    switch (o->value()) {
      case 1 : progdefaults.BWSR_REGEX_MATCH = "bark"; break;
      case 2 : progdefaults.BWSR_REGEX_MATCH = "checkout"; break;
      case 3 : progdefaults.BWSR_REGEX_MATCH = "diesel"; break;
      case 4 : progdefaults.BWSR_REGEX_MATCH = "steam_train"; break;
      case 5 : progdefaults.BWSR_REGEX_MATCH = "doesnot"; break;
      case 6 : progdefaults.BWSR_REGEX_MATCH = "beeboo"; break;
      case 7 : progdefaults.BWSR_REGEX_MATCH = "phone"; break;
      case 8 : progdefaults.BWSR_REGEX_MATCH = "dinner_bell"; break;
      case 9 : progdefaults.BWSR_REGEX_MATCH = "rtty_bell"; break;
      case 10 : progdefaults.BWSR_REGEX_MATCH = "standard_tone"; break;
    }
    inp_wav_fname_regex->value(progdefaults.BWSR_REGEX_MATCH.c_str());
  }
  progdefaults.REGEX_ALERT_MENU = o->value();
}

Fl_Check_Button *btn_enable_regex_match_wa=(Fl_Check_Button *)0;

static void cb_btn_enable_regex_match_wa(Fl_Check_Button* o, void*) {
  progdefaults.ENABLE_BWSR_REGEX_MATCH=o->value();
}

Fl_Button *btn_test_regex_wav=(Fl_Button *)0;

static void cb_btn_test_regex_wav(Fl_Button*, void*) {
  audio_alert->alert(progdefaults.BWSR_REGEX_MATCH.c_str());
}

Fl_File_Input *inp_wav_fname_mycall=(Fl_File_Input *)0;

Fl_Button *btn_select_mycall_wav=(Fl_Button *)0;

static void cb_btn_select_mycall_wav(Fl_Button*, void*) {
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Pick a file");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.filter("wav files\t*.{mp3,wav}\n");
  fnfc.directory("./");           // default directory to use
  // Show native chooser
  switch ( fnfc.show() ) {
    case -1: break; // ERROR
    case  1: break; // CANCEL
    default: {
    	progdefaults.BWSR_MYCALL_MATCH = fnfc.filename();
    	inp_wav_fname_mycall->value(progdefaults.BWSR_MYCALL_MATCH.c_str());
  	progdefaults.MYCALL_ALERT_MENU = 0;
    	mnu_mycall_alert_menu->value(progdefaults.MYCALL_ALERT_MENU);
    	break; // FILE CHOSEN
    }
  }
}

Fl_Choice *mnu_mycall_alert_menu=(Fl_Choice *)0;

static void cb_mnu_mycall_alert_menu(Fl_Choice* o, void*) {
  if (o->value() > 0) {
    switch (o->value()) {
      case 1 : progdefaults.BWSR_MYCALL_MATCH = "bark"; break;
      case 2 : progdefaults.BWSR_MYCALL_MATCH = "checkout"; break;
      case 3 : progdefaults.BWSR_MYCALL_MATCH = "diesel"; break;
      case 4 : progdefaults.BWSR_MYCALL_MATCH = "steam_train"; break;
      case 5 : progdefaults.BWSR_MYCALL_MATCH = "doesnot"; break;
      case 6 : progdefaults.BWSR_MYCALL_MATCH = "beeboo"; break;
      case 7 : progdefaults.BWSR_MYCALL_MATCH = "phone"; break;
      case 8 : progdefaults.BWSR_MYCALL_MATCH = "dinner_bell"; break;
      case 9 : progdefaults.BWSR_MYCALL_MATCH = "rtty_bell"; break;
      case 10 : progdefaults.BWSR_MYCALL_MATCH = "standard_tone"; break;
    }
    inp_wav_fname_mycall->value(progdefaults.BWSR_MYCALL_MATCH.c_str());
  }
  progdefaults.MYCALL_ALERT_MENU = o->value();
}

Fl_Check_Button *btn_enable_mycall_match_wav=(Fl_Check_Button *)0;

static void cb_btn_enable_mycall_match_wav(Fl_Check_Button* o, void*) {
  progdefaults.ENABLE_BWSR_MYCALL_MATCH=o->value();
}

Fl_Button *btn_test_mycall_wav=(Fl_Button *)0;

static void cb_btn_test_mycall_wav(Fl_Button*, void*) {
  audio_alert->alert(progdefaults.BWSR_MYCALL_MATCH.c_str());
}

Fl_File_Input *inp_wav_fname_rsid=(Fl_File_Input *)0;

Fl_Button *btn_select_rsid_wav=(Fl_Button *)0;

static void cb_btn_select_rsid_wav(Fl_Button*, void*) {
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Pick a file");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.filter("wav files\t*.{mp3,wav}\n");
  fnfc.directory("./");           // default directory to use
  // Show native chooser
  switch ( fnfc.show() ) {
    case -1: break; // ERROR
    case  1: break; // CANCEL
    default: {
    	progdefaults.RSID_MATCH = fnfc.filename();
    	inp_wav_fname_rsid->value(progdefaults.RSID_MATCH.c_str());
    	progdefaults.RSID_ALERT_MENU = 0;
    	mnu_rsid_alert_menu->value(progdefaults.RSID_ALERT_MENU);
    	break; // FILE CHOSEN
    }
  }
}

Fl_Choice *mnu_rsid_alert_menu=(Fl_Choice *)0;

static void cb_mnu_rsid_alert_menu(Fl_Choice* o, void*) {
  if (o->value() > 0) {
    switch (o->value()) {
      case 1 : progdefaults.RSID_MATCH = "bark"; break;
      case 2 : progdefaults.RSID_MATCH = "checkout"; break;
      case 3 : progdefaults.RSID_MATCH = "diesel"; break;
      case 4 : progdefaults.RSID_MATCH = "steam_train"; break;
      case 5 : progdefaults.RSID_MATCH = "doesnot"; break;
      case 6 : progdefaults.RSID_MATCH = "beeboo"; break;
      case 7 : progdefaults.RSID_MATCH = "phone"; break;
      case 8 : progdefaults.RSID_MATCH = "dinner_bell"; break;
      case 9 : progdefaults.RSID_MATCH = "rtty_bell"; break;
      case 10 : progdefaults.RSID_MATCH = "standard_tone"; break;
    }
    inp_wav_fname_rsid->value(progdefaults.RSID_MATCH.c_str());
  }
  progdefaults.RSID_ALERT_MENU = o->value();
}

Fl_Check_Button *btn_enable_rsid_match_wav=(Fl_Check_Button *)0;

static void cb_btn_enable_rsid_match_wav(Fl_Check_Button* o, void*) {
  progdefaults.ENABLE_RSID_MATCH=o->value();
}

Fl_Button *btn_test_rsid_wav=(Fl_Button *)0;

static void cb_btn_test_rsid_wav(Fl_Button*, void*) {
  audio_alert->alert(progdefaults.RSID_MATCH.c_str());
}

Fl_File_Input *inp_wav_flmsg_rcvd=(Fl_File_Input *)0;

Fl_Button *btn_select_rx_extract_msg=(Fl_Button *)0;

static void cb_btn_select_rx_extract_msg(Fl_Button*, void*) {
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Pick a file");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.filter("wav files\t*.{mp3,wav}\n");
  fnfc.directory("./");           // default directory to use
  // Show native chooser
  switch ( fnfc.show() ) {
    case -1: break; // ERROR
    case  1: break; // CANCEL
    default: {
    	progdefaults.RX_EXTRACT_MSG_RCVD = fnfc.filename();
    	inp_wav_flmsg_rcvd->value(progdefaults.RX_EXTRACT_MSG_RCVD.c_str());
    	progdefaults.RX_EXTRACT_ALERT_MENU = 0;
    	mnu_rx_extract_alert_menu->value(progdefaults.RX_EXTRACT_ALERT_MENU);
    	break; // FILE CHOSEN
    }
  }
}

Fl_Choice *mnu_rx_extract_alert_menu=(Fl_Choice *)0;

static void cb_mnu_rx_extract_alert_menu(Fl_Choice* o, void*) {
  if (o->value() > 0) {
    switch (o->value()) {
      case 1 : progdefaults.RX_EXTRACT_MSG_RCVD = "bark"; break;
      case 2 : progdefaults.RX_EXTRACT_MSG_RCVD = "checkout"; break;
      case 3 : progdefaults.RX_EXTRACT_MSG_RCVD = "diesel"; break;
      case 4 : progdefaults.RX_EXTRACT_MSG_RCVD = "steam_train"; break;
      case 5 : progdefaults.RX_EXTRACT_MSG_RCVD = "doesnot"; break;
      case 6 : progdefaults.RX_EXTRACT_MSG_RCVD = "beeboo"; break;
      case 7 : progdefaults.RX_EXTRACT_MSG_RCVD = "phone"; break;
      case 8 : progdefaults.RX_EXTRACT_MSG_RCVD = "dinner_bell"; break;
      case 9 : progdefaults.RX_EXTRACT_MSG_RCVD = "rtty_bell"; break;
      case 10 : progdefaults.RX_EXTRACT_MSG_RCVD = "standard_tone"; break;
    }
    inp_wav_flmsg_rcvd->value(progdefaults.RX_EXTRACT_MSG_RCVD.c_str());
  }
  progdefaults.RX_EXTRACT_ALERT_MENU = o->value();
}

Fl_Check_Button *btn_enable_flmsg_wav=(Fl_Check_Button *)0;

static void cb_btn_enable_flmsg_wav(Fl_Check_Button* o, void*) {
  progdefaults.ENABLE_RX_EXTRACT_MSG_RCVD=o->value();
}

Fl_Button *btn_test_flmsg_extract_wav=(Fl_Button *)0;

static void cb_btn_test_flmsg_extract_wav(Fl_Button*, void*) {
  audio_alert->alert(progdefaults.RX_EXTRACT_MSG_RCVD.c_str());
}

Fl_File_Input *inp_wav_flmsg_timed_out=(Fl_File_Input *)0;

Fl_Button *btn_select_rx_extract_timed_out=(Fl_Button *)0;

static void cb_btn_select_rx_extract_timed_out(Fl_Button*, void*) {
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Pick a file");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.filter("wav files\t*.{mp3,wav}\n");
  fnfc.directory("./");           // default directory to use
  // Show native chooser
  switch ( fnfc.show() ) {
    case -1: break; // ERROR
    case  1: break; // CANCEL
    default: {
    	progdefaults.RX_EXTRACT_TIMED_OUT = fnfc.filename();
    	inp_wav_flmsg_timed_out->value(progdefaults.RX_EXTRACT_TIMED_OUT.c_str());
    	progdefaults.TIMED_OUT_ALERT_MENU = 0;
    	mnu_rx_timed_out_alert_menu->value(progdefaults.TIMED_OUT_ALERT_MENU);
    	break; // FILE CHOSEN
    }
  }
}

Fl_Choice *mnu_rx_timed_out_alert_menu=(Fl_Choice *)0;

static void cb_mnu_rx_timed_out_alert_menu(Fl_Choice* o, void*) {
  if (o->value() > 0) {
    switch (o->value()) {
      case 1 : progdefaults.RX_EXTRACT_TIMED_OUT = "bark"; break;
      case 2 : progdefaults.RX_EXTRACT_TIMED_OUT = "checkout"; break;
      case 3 : progdefaults.RX_EXTRACT_TIMED_OUT = "diesel"; break;
      case 4 : progdefaults.RX_EXTRACT_TIMED_OUT = "steam_train"; break;
      case 5 : progdefaults.RX_EXTRACT_TIMED_OUT = "doesnot"; break;
      case 6 : progdefaults.RX_EXTRACT_TIMED_OUT = "beeboo"; break;
      case 7 : progdefaults.RX_EXTRACT_TIMED_OUT = "phone"; break;
      case 8 : progdefaults.RX_EXTRACT_TIMED_OUT = "dinner_bell"; break;
      case 9 : progdefaults.RX_EXTRACT_TIMED_OUT = "rtty_bell"; break;
      case 10 : progdefaults.RX_EXTRACT_TIMED_OUT = "standard_tone"; break;
    }
    inp_wav_flmsg_timed_out->value(progdefaults.RX_EXTRACT_TIMED_OUT.c_str());
  }
  progdefaults.TIMED_OUT_ALERT_MENU = o->value();
}

Fl_Button *btn_test_rx_extract_timed_out=(Fl_Button *)0;

static void cb_btn_test_rx_extract_timed_out(Fl_Button*, void*) {
  audio_alert->alert(progdefaults.RX_EXTRACT_TIMED_OUT.c_str());
}

Fl_Check_Button *btn_enable_flmsg_time_out_wav=(Fl_Check_Button *)0;

static void cb_btn_enable_flmsg_time_out_wav(Fl_Check_Button* o, void*) {
  progdefaults.ENABLE_RX_EXTRACT_TIMED_OUT=o->value();
}

Fl_Value_Slider2 *sldrAlertVolume=(Fl_Value_Slider2 *)0;

static void cb_sldrAlertVolume(Fl_Value_Slider2* o, void*) {
  progdefaults.alert_volume = (int)o->value();
  progdefaults.changed = true;
}

Fl_Group *grpSoundDevices=(Fl_Group *)0;

Fl_Group *AudioOSS=(Fl_Group *)0;

static void cb_btnAudioIO(Fl_Round_Button*, void*) {
  sound_update(SND_IDX_OSS);
  progdefaults.changed = true;
  resetSoundCard();
}

Fl_Input_Choice *menuOSSDev=(Fl_Input_Choice *)0;

static void cb_menuOSSDev(Fl_Input_Choice* o, void*) {
  scDevice[0] = scDevice[1] = progdefaults.OSSdevice = o->value();
  resetSoundCard();
  progdefaults.changed = true;
}

Fl_Group *AudioPort=(Fl_Group *)0;

static void cb_btnAudioIO1(Fl_Round_Button*, void*) {
  sound_update(SND_IDX_PORT);
  progdefaults.changed = true;
  resetSoundCard();
}

Fl_Choice *menuPortInDev=(Fl_Choice *)0;

static void cb_menuPortInDev(Fl_Choice* o, void*) {
  scDevice[0] = progdefaults.PortInDevice = o->text();
  progdefaults.PortInIndex = reinterpret_cast<intptr_t>(o->mvalue()->user_data());
  resetSoundCard();
  progdefaults.changed = true;
}

Fl_Choice *menuPortOutDev=(Fl_Choice *)0;

static void cb_menuPortOutDev(Fl_Choice* o, void*) {
  scDevice[1] = progdefaults.PortOutDevice = o->text();
  progdefaults.PortOutIndex = reinterpret_cast<intptr_t>(o->mvalue()->user_data());
  resetSoundCard();
  progdefaults.changed = true;
}

Fl_Group *AudioPulse=(Fl_Group *)0;

static void cb_btnAudioIO2(Fl_Round_Button*, void*) {
  sound_update(SND_IDX_PULSE);
  progdefaults.changed = true;
  resetSoundCard();
}

Fl_Input2 *inpPulseServer=(Fl_Input2 *)0;

static void cb_inpPulseServer(Fl_Input2* o, void*) {
  scDevice[0] = scDevice[1] = progdefaults.PulseServer = o->value();
  resetSoundCard();
  progdefaults.changed = true;
}

Fl_Group *AudioNull=(Fl_Group *)0;

Fl_Round_Button *btnAudioIO[4]={(Fl_Round_Button *)0};

static void cb_btnAudioIO3(Fl_Round_Button*, void*) {
  sound_update(SND_IDX_NULL);
  progdefaults.changed = true;
  resetSoundCard();
}

Fl_Group *AudioDuplex=(Fl_Group *)0;

Fl_Round_Button *btn_is_full_duplex=(Fl_Round_Button *)0;

static void cb_btn_is_full_duplex(Fl_Round_Button* o, void*) {
  progdefaults.is_full_duplex = o->value();
  progdefaults.changed = true;
  resetSoundCard();
}

Fl_Group *AudioAlerts=(Fl_Group *)0;

Fl_Choice *menuAlertsDev=(Fl_Choice *)0;

static void cb_menuAlertsDev(Fl_Choice* o, void*) {
  progdefaults.AlertDevice = o->text();
  progdefaults.AlertIndex = reinterpret_cast<intptr_t>(o->mvalue()->user_data());
  progdefaults.changed = true;
}

Fl_Round_Button *btn_enable_audio_alerts=(Fl_Round_Button *)0;

static void cb_btn_enable_audio_alerts(Fl_Round_Button* o, void*) {
  progdefaults.enable_audio_alerts = o->value();
  progdefaults.changed = true;
  reset_audio_alerts();
}

Fl_Check_Button *chkAudioStereoOut=(Fl_Check_Button *)0;

static void cb_chkAudioStereoOut(Fl_Check_Button* o, void*) {
  progdefaults.sig_on_right_channel = o->value();
  progdefaults.changed = true;
  if (o->value()) {
    progdefaults.QSK = false;
    btnQSK->value(0);
    btnQSK2->value(0);
    progdefaults.PseudoFSK = false;
    chkPseudoFSK->value(0);
    chkPseudoFSK2->value(0);
    progdefaults.PTTrightchannel = false;
    btnPTTrightchannel->value(0);
    btnPTTrightchannel2->value(0);
  }
}

Fl_Check_Button *chkReverseAudio=(Fl_Check_Button *)0;

static void cb_chkReverseAudio(Fl_Check_Button* o, void*) {
  progdefaults.ReverseAudio = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnPTTrightchannel2=(Fl_Check_Button *)0;

static void cb_btnPTTrightchannel2(Fl_Check_Button* o, void*) {
  progdefaults.PTTrightchannel = o->value();
  btnPTTrightchannel->value(o->value());
  progdefaults.changed = true;
  if (o->value()) {
    progdefaults.QSK = false;
    btnQSK->value(0);
    btnQSK2->value(0);
    progdefaults.PseudoFSK = false;
    chkPseudoFSK->value(0);
    chkPseudoFSK2->value(0);
    progdefaults.sig_on_right_channel = false;
    chkAudioStereoOut->value(0);
  }
}

Fl_Check_Button *btnQSK2=(Fl_Check_Button *)0;

static void cb_btnQSK2(Fl_Check_Button* o, void*) {
  progdefaults.QSK = o->value();
  btnQSK->value(o->value());
  progdefaults.changed = true;
  if (o->value()) {
    progdefaults.sig_on_right_channel = false;
    chkAudioStereoOut->value(0);
    progdefaults.PTTrightchannel = false;
    btnPTTrightchannel->value(0);
    btnPTTrightchannel2->value(0);
  }
}

Fl_Check_Button *chkPseudoFSK2=(Fl_Check_Button *)0;

static void cb_chkPseudoFSK2(Fl_Check_Button* o, void*) {
  progdefaults.PseudoFSK = o->value();
  chkPseudoFSK->value(o->value());
  progdefaults.changed = true;
  if (o->value()) {
    progdefaults.sig_on_right_channel = false;
    chkAudioStereoOut->value(0);
    progdefaults.PTTrightchannel = false;
    btnPTTrightchannel->value(0);
    btnPTTrightchannel2->value(0);
  }
}

Fl_Check_Button *chkReverseRxAudio=(Fl_Check_Button *)0;

static void cb_chkReverseRxAudio(Fl_Check_Button* o, void*) {
  progdefaults.ReverseRxAudio = o->value();
  progdefaults.changed = true;
}

Fl_Group *grpAudioSampleRate=(Fl_Group *)0;

Fl_ListBox *menuInSampleRate=(Fl_ListBox *)0;

static void cb_menuInSampleRate(Fl_ListBox* o, void*) {
  progdefaults.in_sample_rate = o->index() > 1 ? strtol(o->value(), 0, 10) : o->index();
  resetSoundCard();
  progdefaults.changed = true;
}

Fl_ListBox *menuOutSampleRate=(Fl_ListBox *)0;

static void cb_menuOutSampleRate(Fl_ListBox* o, void*) {
  progdefaults.out_sample_rate = o->index() > 1 ? strtol(o->value(), 0, 10) : o->index();
  resetSoundCard();
  progdefaults.changed = true;
}

Fl_ListBox *menuSampleConverter=(Fl_ListBox *)0;

static void cb_menuSampleConverter(Fl_ListBox* o, void*) {
  if ((o->index()) == FLDIGI_SRC_BEST)
      fl_alert2("The best quality SINC interpolator has very high CPU overhead");
  progdefaults.sample_converter = sample_rate_converters[o->index()];
  resetSoundCard();
  progdefaults.changed = true;
  o->tooltip(src_get_description(progdefaults.sample_converter));
}

Fl_Spinner2 *cntRxRateCorr=(Fl_Spinner2 *)0;

static void cb_cntRxRateCorr(Fl_Spinner2* o, void*) {
  progdefaults.RX_corr = (int)o->value();
  cnt_fmt_rx_ppm->value(progdefaults.RX_corr);
  progdefaults.changed = true;
}

Fl_Spinner2 *cntTxRateCorr=(Fl_Spinner2 *)0;

static void cb_cntTxRateCorr(Fl_Spinner2* o, void*) {
  progdefaults.TX_corr = (int)o->value();
  progdefaults.changed = true;
}

Fl_Spinner2 *cntTxOffset=(Fl_Spinner2 *)0;

static void cb_cntTxOffset(Fl_Spinner2* o, void*) {
  progdefaults.TxOffset = (int)o->value();
  progdefaults.changed = true;
}

Fl_Button *bnt_dec_rit=(Fl_Button *)0;

static void cb_bnt_dec_rit(Fl_Button* o, void*) {
  progdefaults.RIT -= 0.1;
  cntRIT->value(progdefaults.RIT);
  progdefaults.FMT_freq_corr=o->value();
  cnt_fmt_freq_corr->value(progdefaults.FMT_freq_corr);
  progdefaults.changed = true;
}

Fl_Counter *cntRIT=(Fl_Counter *)0;

static void cb_cntRIT(Fl_Counter* o, void*) {
  progdefaults.RIT=o->value();
  progdefaults.FMT_freq_corr=o->value();
  cnt_fmt_freq_corr->value(progdefaults.FMT_freq_corr);
}

Fl_Button *btn_incr_rit=(Fl_Button *)0;

static void cb_btn_incr_rit(Fl_Button* o, void*) {
  progdefaults.RIT += 0.1;
  cntRIT->value(progdefaults.RIT);
  progdefaults.FMT_freq_corr=o->value();
  cnt_fmt_freq_corr->value(progdefaults.FMT_freq_corr);
  progdefaults.changed = true;
}

Fl_Box *lowcolor2=(Fl_Box *)0;

Fl_Button *btnLowSignal2=(Fl_Button *)0;

static void cb_btnLowSignal2(Fl_Button*, void*) {
  TRIAD clr = ui_colors.LowSignal;
  if (fl_color_chooser("Low Signal", clr.r, clr.g, clr.b )) {
  ui_colors.LowSignal = clr;
  lowcolor->color(RGBCOLOR(LowSignal));
  lowcolor->redraw();
  lowcolor2->color(RGBCOLOR(LowSignal));
  lowcolor2->redraw();
  progdefaults.changed = true;}
}

Fl_Box *normalcolor2=(Fl_Box *)0;

Fl_Counter *cnt_normal_signal_level2=(Fl_Counter *)0;

static void cb_cnt_normal_signal_level2(Fl_Counter* o, void*) {
  progdefaults.normal_signal_level = o->value();

  if (progdefaults.normal_signal_level > progdefaults.high_signal_level)
    progdefaults.high_signal_level = progdefaults.normal_signal_level + 0.1;

  if (progdefaults.high_signal_level > progdefaults.over_signal_level)
    progdefaults.over_signal_level = progdefaults.high_signal_level + 0.1;

  if (progdefaults.over_signal_level > 0)
    progdefaults.over_signal_level = 0;

  cnt_normal_signal_level->value(progdefaults.normal_signal_level);
  cnt_high_signal_level->value(progdefaults.high_signal_level);
  cnt_over_signal_level->value(progdefaults.over_signal_level);

  cnt_normal_signal_level2->value(progdefaults.normal_signal_level);
  cnt_high_signal_level2->value(progdefaults.high_signal_level);
  cnt_over_signal_level2->value(progdefaults.over_signal_level);
}

Fl_Button *btnNormalSignal2=(Fl_Button *)0;

static void cb_btnNormalSignal2(Fl_Button*, void*) {
  TRIAD clr = ui_colors.NormSignal;
  if (fl_color_chooser("Normal Signal", clr.r, clr.g, clr.b )) {
    ui_colors.NormSignal = clr;
    normalcolor->color( RGBCOLOR( NormSignal ) );
    normalcolor->redraw();

    normalcolor2->color( RGBCOLOR( NormSignal ) );
    normalcolor2->redraw();

    progdefaults.changed = true;}
}

Fl_Box *highcolor2=(Fl_Box *)0;

Fl_Counter *cnt_high_signal_level2=(Fl_Counter *)0;

static void cb_cnt_high_signal_level2(Fl_Counter* o, void*) {
  progdefaults.high_signal_level = o->value();

  if (progdefaults.normal_signal_level > progdefaults.high_signal_level)
    progdefaults.high_signal_level = progdefaults.normal_signal_level + 0.1;

  if (progdefaults.high_signal_level > progdefaults.over_signal_level)
    progdefaults.over_signal_level = progdefaults.high_signal_level + 0.1;

  if (progdefaults.over_signal_level > 0)
    progdefaults.over_signal_level = 0;
    
  cnt_normal_signal_level->value(progdefaults.normal_signal_level);
  cnt_high_signal_level->value(progdefaults.high_signal_level);
  cnt_over_signal_level->value(progdefaults.over_signal_level);

  cnt_normal_signal_level2->value(progdefaults.normal_signal_level);
  cnt_high_signal_level2->value(progdefaults.high_signal_level);
  cnt_over_signal_level2->value(progdefaults.over_signal_level);
}

Fl_Button *btnHighSignal2=(Fl_Button *)0;

static void cb_btnHighSignal2(Fl_Button*, void*) {
  TRIAD clr = ui_colors.HighSignal;
  if (fl_color_chooser("High Signal", clr.r, clr.g, clr.b )) {
    ui_colors.HighSignal = clr;
    highcolor->color(RGBCOLOR(HighSignal));
    highcolor->redraw();

    highcolor2->color(RGBCOLOR(HighSignal));
    highcolor2->redraw();

    progdefaults.changed = true;}
}

Fl_Box *overcolor2=(Fl_Box *)0;

Fl_Counter *cnt_over_signal_level2=(Fl_Counter *)0;

static void cb_cnt_over_signal_level2(Fl_Counter* o, void*) {
  progdefaults.over_signal_level = o->value();

  if (progdefaults.normal_signal_level > progdefaults.high_signal_level)
    progdefaults.high_signal_level = progdefaults.normal_signal_level + 0.1;

  if (progdefaults.high_signal_level > progdefaults.over_signal_level)
    progdefaults.over_signal_level = progdefaults.high_signal_level + 0.1;

  if (progdefaults.over_signal_level > 0)
    progdefaults.over_signal_level = 0;
    
  cnt_normal_signal_level->value(progdefaults.normal_signal_level);
  cnt_high_signal_level->value(progdefaults.high_signal_level);
  cnt_over_signal_level->value(progdefaults.over_signal_level);

  cnt_normal_signal_level2->value(progdefaults.normal_signal_level);
  cnt_high_signal_level2->value(progdefaults.high_signal_level);
  cnt_over_signal_level2->value(progdefaults.over_signal_level);
}

Fl_Button *btnOverSignal2=(Fl_Button *)0;

static void cb_btnOverSignal2(Fl_Button*, void*) {
  TRIAD clr = ui_colors.OverSignal;
  if (fl_color_chooser("Notch Indicator", clr.r, clr.g, clr.b )) {
    ui_colors.OverSignal = clr;
    overcolor->color(RGBCOLOR(OverSignal));
    overcolor->redraw();
    overcolor2->color(RGBCOLOR(OverSignal));
    overcolor2->redraw();
  progdefaults.changed = true;
  }
}

vumeter *sig_vumeter2=(vumeter *)0;

Fl_Button *btn_default_signal_levels2=(Fl_Button *)0;

static void cb_btn_default_signal_levels2(Fl_Button*, void*) {
  cnt_normal_signal_level->value(
    progdefaults.normal_signal_level = -60.0);
  cnt_high_signal_level->value(
    progdefaults.high_signal_level = -6.0);
  cnt_over_signal_level->value(
    progdefaults.over_signal_level = -3.0);
    
  cnt_normal_signal_level2->value(progdefaults.normal_signal_level);
  cnt_high_signal_level2->value(progdefaults.high_signal_level);
  cnt_over_signal_level2->value(progdefaults.over_signal_level);
}

Fl_Check_Button *btn_use_wsjtx_vumeter_scale2=(Fl_Check_Button *)0;

static void cb_btn_use_wsjtx_vumeter_scale2(Fl_Check_Button* o, void*) {
  progdefaults.use_wsjtx_vumeter_scale=o->value();
  btn_use_wsjtx_vumeter_scale->value(o->value());
}

Fl_ListBox *listbox_wav_samplerate=(Fl_ListBox *)0;

static void cb_listbox_wav_samplerate(Fl_ListBox* o, void*) {
  progdefaults.wavSampleRate = o->index();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_record_both=(Fl_Check_Button *)0;

static void cb_btn_record_both(Fl_Check_Button* o, void*) {
  progdefaults.record_both_channels=o->value();
  progdefaults.changed=true;
}

Fl_Spinner2 *cntChannels=(Fl_Spinner2 *)0;

static void cb_cntChannels(Fl_Spinner2* o, void*) {
  progdefaults.VIEWERchannels = (int)(o->value());
  initViewer();
}

Fl_Spinner2 *cntTimeout=(Fl_Spinner2 *)0;

static void cb_cntTimeout(Fl_Spinner2* o, void*) {
  progdefaults.VIEWERtimeout = (int)(o->value());
  progdefaults.changed = true;
}

Fl_ListBox *listboxViewerLabel=(Fl_ListBox *)0;

static void cb_listboxViewerLabel(Fl_ListBox* o, void*) {
  progdefaults.VIEWERlabeltype = o->index();
  initViewer();
  progdefaults.changed = true;
}

Fl_Button *btnViewerFont=(Fl_Button *)0;

static void cb_btnViewerFont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.ViewerFontnbr);
  font_browser->fontSize(progdefaults.ViewerFontsize);
  font_browser->fontColor(FL_FOREGROUND_COLOR);
  if (font_browser->fixed_width(progdefaults.ViewerFontnbr))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback(cbViewerFontBrowser);
  font_browser->show();
}

Fl_Check_Button *btnFixedIntervals=(Fl_Check_Button *)0;

static void cb_btnFixedIntervals(Fl_Check_Button* o, void*) {
  progdefaults.VIEWERfixed = o->value();
  progdefaults.changed = true;
  initViewer();
}

Fl_Check_Button *btnMarquee=(Fl_Check_Button *)0;

static void cb_btnMarquee(Fl_Check_Button* o, void*) {
  progdefaults.VIEWERmarquee = o->value();
  progdefaults.changed = true;
  initViewer();
}

Fl_Check_Button *btnAscend=(Fl_Check_Button *)0;

static void cb_btnAscend(Fl_Check_Button* o, void*) {
  progdefaults.VIEWERascend = o->value();
  progdefaults.changed = true;
  initViewer();
}

Fl_Check_Button *btnBrowserHistory=(Fl_Check_Button *)0;

static void cb_btnBrowserHistory(Fl_Check_Button* o, void*) {
  progdefaults.VIEWERhistory = o->value();
  progdefaults.changed = true;
}

Fl_Button *bwsrHiLite_1_color=(Fl_Button *)0;

static void cb_bwsrHiLite_1_color(Fl_Button*, void*) {
  progdefaults.bwsrHiLight1 = fl_show_colormap((Fl_Color)progdefaults.bwsrHiLight1);
  bwsrHiLite_1_color->color((Fl_Color)progdefaults.bwsrHiLight1);
  viewer_redraw();
  progdefaults.changed = true;
}

Fl_Button *bwsrHiLite_2_color=(Fl_Button *)0;

static void cb_bwsrHiLite_2_color(Fl_Button*, void*) {
  progdefaults.bwsrHiLight2 = fl_show_colormap((Fl_Color)progdefaults.bwsrHiLight2);
  bwsrHiLite_2_color->color((Fl_Color)progdefaults.bwsrHiLight2);
  viewer_redraw();
  progdefaults.changed = true;
}

Fl_Button *bwsrHiLite_even_lines=(Fl_Button *)0;

static void cb_bwsrHiLite_even_lines(Fl_Button*, void*) {
  progdefaults.bwsrBackgnd2 = fl_show_colormap((Fl_Color)progdefaults.bwsrBackgnd2);
  bwsrHiLite_even_lines->color((Fl_Color)progdefaults.bwsrBackgnd2);
  viewer_redraw();
  progdefaults.changed = true;;
}

Fl_Button *bwsrHiLite_odd_lines=(Fl_Button *)0;

static void cb_bwsrHiLite_odd_lines(Fl_Button*, void*) {
  progdefaults.bwsrBackgnd1 = fl_show_colormap((Fl_Color)progdefaults.bwsrBackgnd1);
  bwsrHiLite_odd_lines->color((Fl_Color)progdefaults.bwsrBackgnd1);
  viewer_redraw();
  progdefaults.changed = true;
}

Fl_Button *bwsrHiLite_select=(Fl_Button *)0;

static void cb_bwsrHiLite_select(Fl_Button*, void*) {
  progdefaults.bwsrSelect = fl_show_colormap((Fl_Color)progdefaults.bwsrSelect);
  bwsrHiLite_select->color((Fl_Color)progdefaults.bwsrSelect);
  viewer_redraw();
  progdefaults.changed = true;
}

Fl_Button *bwsrSliderColor=(Fl_Button *)0;

static void cb_bwsrSliderColor(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.bwsrSliderColor;
  if (fl_color_chooser("Slider Color", clr.r, clr.g, clr.b) == 0)
          return;
  ui_colors.bwsrSliderColor = clr;
  o->color(RGBCOLOR(bwsrSliderColor));
  o->redraw();
  sldrViewerSquelch->color(RGBCOLOR(bwsrSliderColor));
  sldrViewerSquelch->redraw();
  mvsquelch->color(RGBCOLOR(bwsrSliderColor));
  mvsquelch->redraw();

      progdefaults.changed = true;
}

Fl_Button *bwsrSldrSelColor=(Fl_Button *)0;

static void cb_bwsrSldrSelColor(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.bwsrSldrSelColor;
  if (fl_color_chooser("Button Color", clr.r, clr.g, clr.b) == 0)
          return;
   ui_colors.bwsrSldrSelColor = clr;
   o->color(RGBCOLOR(bwsrSldrSelColor));
      o->redraw();
      sldrViewerSquelch->selection_color(RGBCOLOR(bwsrSldrSelColor));
      sldrViewerSquelch->redraw();
      mvsquelch->selection_color(RGBCOLOR(bwsrSldrSelColor));
      mvsquelch->redraw();

      progdefaults.changed = true;
}

Fl_Check_Button *btnShowTooltips=(Fl_Check_Button *)0;

static void cb_btnShowTooltips(Fl_Check_Button* o, void*) {
  progdefaults.tooltips = o->value();
  Fl_Tooltip::enable(progdefaults.tooltips);
  progdefaults.changed = true;
}

Fl_Check_Button *chkMenuIcons=(Fl_Check_Button *)0;

static void cb_chkMenuIcons(Fl_Check_Button* o, void*) {
  progdefaults.menuicons = o->value();
  icons::toggle_icon_labels();
  progdefaults.changed = true;
}

Fl_Button *bVisibleModes=(Fl_Button *)0;

static void cb_bVisibleModes(Fl_Button* o, void*) {
  mode_browser->label(o->label());
  mode_browser->callback(toggle_visible_modes);
  mode_browser->show_(&progdefaults.visible_modes);
  progdefaults.changed = true;
}

Fl_ListBox *listbox_language=(Fl_ListBox *)0;

static void cb_listbox_language(Fl_ListBox* o, void*) {
  progdefaults.ui_language = o->index();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_rx_lowercase=(Fl_Check_Button *)0;

static void cb_btn_rx_lowercase(Fl_Check_Button* o, void*) {
  progdefaults.rx_lowercase = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_tx_lowercase=(Fl_Check_Button *)0;

static void cb_btn_tx_lowercase(Fl_Check_Button* o, void*) {
  progdefaults.tx_lowercase = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_save_config_on_exit=(Fl_Check_Button *)0;

static void cb_btn_save_config_on_exit(Fl_Check_Button* o, void*) {
  progdefaults.SaveConfig = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn2_save_macros_on_exit=(Fl_Check_Button *)0;

static void cb_btn2_save_macros_on_exit(Fl_Check_Button* o, void*) {
  btn_save_macros_on_exit->value(o->value());
  progdefaults.SaveMacros = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn2NagMe=(Fl_Check_Button *)0;

static void cb_btn2NagMe(Fl_Check_Button* o, void*) {
  btnNagMe->value(o->value());
  progdefaults.NagMe=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn2_confirm_exit=(Fl_Check_Button *)0;

static void cb_btn2_confirm_exit(Fl_Check_Button* o, void*) {
  btn2_confirm_exit->value(o->value());
  progdefaults.confirmExit=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_check_for_updates=(Fl_Check_Button *)0;

static void cb_btn_check_for_updates(Fl_Check_Button* o, void*) {
  progdefaults.check_for_updates = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_tx_show_timer=(Fl_Check_Button *)0;

static void cb_btn_tx_show_timer(Fl_Check_Button* o, void*) {
  progdefaults.show_tx_timer = o->value();
  progdefaults.changed = true;
}

Fl_Spinner *val_tx_timeout=(Fl_Spinner *)0;

static void cb_val_tx_timeout(Fl_Spinner* o, void*) {
  progdefaults.tx_timeout=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnMacroMouseWheel=(Fl_Check_Button *)0;

static void cb_btnMacroMouseWheel(Fl_Check_Button* o, void*) {
  progdefaults.macro_wheel = o->value();
  progdefaults.changed = true;
}

Fl_Counter *cnt_macro_height=(Fl_Counter *)0;

static void cb_cnt_macro_height(Fl_Counter* o, void*) {
  progdefaults.macro_height = (int)o->value();
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_0=(Fl_Round_Button *)0;

static void cb_btn_scheme_0(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 0;
  set_macroLabels();
  UI_select();
  progdefaults.changed = true;
}

Fl_Round_Button *btn_scheme_1=(Fl_Round_Button *)0;

static void cb_btn_scheme_1(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 1;
  set_macroLabels();
  UI_select();
  progdefaults.changed = true;
}

Fl_Round_Button *btn_scheme_2=(Fl_Round_Button *)0;

static void cb_btn_scheme_2(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 2;
  set_macroLabels();
  UI_select();
  progdefaults.changed = true;
}

Fl_Round_Button *btn_scheme_3=(Fl_Round_Button *)0;

static void cb_btn_scheme_3(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 3;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_4=(Fl_Round_Button *)0;

static void cb_btn_scheme_4(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 4;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_5=(Fl_Round_Button *)0;

static void cb_btn_scheme_5(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 5;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_6=(Fl_Round_Button *)0;

static void cb_btn_scheme_6(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 6;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_7=(Fl_Round_Button *)0;

static void cb_btn_scheme_7(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 7;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_8=(Fl_Round_Button *)0;

static void cb_btn_scheme_8(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 8;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_9=(Fl_Round_Button *)0;

static void cb_btn_scheme_9(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 9;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_10=(Fl_Round_Button *)0;

static void cb_btn_scheme_10(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 10;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_11=(Fl_Round_Button *)0;

static void cb_btn_scheme_11(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 11;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Round_Button *btn_scheme_12=(Fl_Round_Button *)0;

static void cb_btn_scheme_12(Fl_Round_Button*, void*) {
  progdefaults.mbar_scheme = 12;
  progdefaults.changed = true;
  set_macroLabels();
  UI_select();
}

Fl_Check_Button *btnUseLastMacro=(Fl_Check_Button *)0;

static void cb_btnUseLastMacro(Fl_Check_Button* o, void*) {
  progdefaults.UseLastMacro = o->value();
  update_main_title();
  progdefaults.changed = true;
}

Fl_Check_Button *btnDisplayMacroFilename=(Fl_Check_Button *)0;

static void cb_btnDisplayMacroFilename(Fl_Check_Button* o, void*) {
  progdefaults.DisplayMacroFilename = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_save_macros_on_exit=(Fl_Check_Button *)0;

static void cb_btn_save_macros_on_exit(Fl_Check_Button* o, void*) {
  btn2_save_macros_on_exit->value(o->value());
  progdefaults.SaveMacros = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_macro_post=(Fl_Check_Button *)0;

static void cb_btn_macro_post(Fl_Check_Button* o, void*) {
  progdefaults.macro_post = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_4bar_position=(Fl_Check_Button *)0;

static void cb_btn_4bar_position(Fl_Check_Button* o, void*) {
  progdefaults.four_bar_position = o->value();
  UI_select();
  progdefaults.changed = true;
}

Fl_Check_Button *btnRXClicks=(Fl_Check_Button *)0;

static void cb_btnRXClicks(Fl_Check_Button* o, void*) {
  progdefaults.rxtext_clicks_qso_data = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnRXTooltips=(Fl_Check_Button *)0;

static void cb_btnRXTooltips(Fl_Check_Button* o, void*) {
  progdefaults.rxtext_tooltips = o->value();
  progdefaults.changed = true;
}

Fl_Input2 *inpNonword=(Fl_Input2 *)0;

static void cb_inpNonword(Fl_Input2* o, void*) {
  progdefaults.nonwordchars = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnUSunits=(Fl_Check_Button *)0;

static void cb_btnUSunits(Fl_Check_Button* o, void*) {
  progdefaults.us_units = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_clear_fields=(Fl_Check_Button *)0;

static void cb_btn_clear_fields(Fl_Check_Button* o, void*) {
  progdefaults.clear_fields=o->value();
  progdefaults.changed = true;
}

Fl_Choice *sel_lsd=(Fl_Choice *)0;

static void cb_sel_lsd(Fl_Choice* o, void*) {
  progdefaults.sel_lsd = o->value();
  set_freq_control_lsd();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_rxtx_swap=(Fl_Check_Button *)0;

static void cb_btn_rxtx_swap(Fl_Check_Button* o, void*) {
  progdefaults.rxtx_swap = o->value();
  progdefaults.changed = true;
  UI_select();
}

Fl_Check_Button *btnWF_UIrev=(Fl_Check_Button *)0;

static void cb_btnWF_UIrev(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIrev = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIx1=(Fl_Check_Button *)0;

static void cb_btnWF_UIx1(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIx1 = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIwfcarrier=(Fl_Check_Button *)0;

static void cb_btnWF_UIwfcarrier(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIwfcarrier = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIwfshift=(Fl_Check_Button *)0;

static void cb_btnWF_UIwfshift(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIwfshift = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIwfreflevel=(Fl_Check_Button *)0;

static void cb_btnWF_UIwfreflevel(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIwfreflevel = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIwfdrop=(Fl_Check_Button *)0;

static void cb_btnWF_UIwfdrop(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIwfdrop = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIwfampspan=(Fl_Check_Button *)0;

static void cb_btnWF_UIwfampspan(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIwfampspan = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIwfstore=(Fl_Check_Button *)0;

static void cb_btnWF_UIwfstore(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIwfstore = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIwfmode=(Fl_Check_Button *)0;

static void cb_btnWF_UIwfmode(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIwfmode = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIqsy=(Fl_Check_Button *)0;

static void cb_btnWF_UIqsy(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIqsy = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Check_Button *btnWF_UIxmtlock=(Fl_Check_Button *)0;

static void cb_btnWF_UIxmtlock(Fl_Check_Button* o, void*) {
  progdefaults.WF_UIxmtlock = o->value();
  progdefaults.changed = true;
  WF_UI();
}

Fl_Button *btn_wf_enable_all=(Fl_Button *)0;

static void cb_btn_wf_enable_all(Fl_Button*, void*) {
  btnWF_UIrev->value(progdefaults.WF_UIrev = 1);
  btnWF_UIwfcarrier->value(progdefaults.WF_UIwfcarrier = 1);
  btnWF_UIwfreflevel->value(progdefaults.WF_UIwfreflevel = 1);
  btnWF_UIwfampspan->value(progdefaults.WF_UIwfampspan = 1);
  btnWF_UIwfmode->value(progdefaults.WF_UIwfmode = 1);

  btnWF_UIx1->value(progdefaults.WF_UIx1 = 1);
  btnWF_UIwfshift->value(progdefaults.WF_UIwfshift = 1);
  btnWF_UIwfdrop->value(progdefaults.WF_UIwfdrop = 1);
  btnWF_UIwfstore->value(progdefaults.WF_UIwfstore = 1);
  btnWF_UIqsy->value(progdefaults.WF_UIqsy = 1);
  btnWF_UIxmtlock->value(progdefaults.WF_UIxmtlock = 1);

  progdefaults.changed = true;
  WF_UI();
}

Fl_Button *btn_wf_disable_all=(Fl_Button *)0;

static void cb_btn_wf_disable_all(Fl_Button*, void*) {
  btnWF_UIrev->value(progdefaults.WF_UIrev = 0);
  btnWF_UIwfcarrier->value(progdefaults.WF_UIwfcarrier = 0);
  btnWF_UIwfreflevel->value(progdefaults.WF_UIwfreflevel = 0);
  btnWF_UIwfampspan->value(progdefaults.WF_UIwfampspan = 0);
  btnWF_UIwfmode->value(progdefaults.WF_UIwfmode = 0);

  btnWF_UIx1->value(progdefaults.WF_UIx1 = 0);
  btnWF_UIwfshift->value(progdefaults.WF_UIwfshift = 0);
  btnWF_UIwfdrop->value(progdefaults.WF_UIwfdrop = 0);
  btnWF_UIwfstore->value(progdefaults.WF_UIwfstore = 0);
  btnWF_UIqsy->value(progdefaults.WF_UIqsy = 0);
  btnWF_UIxmtlock->value(progdefaults.WF_UIxmtlock = 0);

  progdefaults.changed = true;
  WF_UI();
}

colorbox *WF_Palette=(colorbox *)0;

static void cb_WF_Palette(colorbox*, void*) {
  progdefaults.changed = true;
}

static void cb_btnColor(Fl_Button*, void*) {
  selectColor(0);
  progdefaults.changed = true;
}

static void cb_btnColor1(Fl_Button*, void*) {
  selectColor(1);
  progdefaults.changed = true;
}

static void cb_btnColor2(Fl_Button*, void*) {
  selectColor(2);
  progdefaults.changed = true;
}

static void cb_btnColor3(Fl_Button*, void*) {
  selectColor(3);
  progdefaults.changed = true;
}

static void cb_btnColor4(Fl_Button*, void*) {
  selectColor(4);
  progdefaults.changed = true;
}

static void cb_btnColor5(Fl_Button*, void*) {
  selectColor(5);
  progdefaults.changed = true;
}

static void cb_btnColor6(Fl_Button*, void*) {
  selectColor(6);
  progdefaults.changed = true;
}

static void cb_btnColor7(Fl_Button*, void*) {
  selectColor(7);
  progdefaults.changed = true;
}

Fl_Button *btnColor[9]={(Fl_Button *)0};

static void cb_btnColor8(Fl_Button*, void*) {
  selectColor(8);
  progdefaults.changed = true;
}

Fl_Button *btnLoadPalette=(Fl_Button *)0;

static void cb_btnLoadPalette(Fl_Button*, void*) {
  loadPalette();
  progdefaults.changed = true;
}

Fl_Button *btnSavePalette=(Fl_Button *)0;

static void cb_btnSavePalette(Fl_Button*, void*) {
  savePalette();
}

Fl_Check_Button *btnUseCursorLines=(Fl_Check_Button *)0;

static void cb_btnUseCursorLines(Fl_Check_Button* o, void*) {
  progdefaults.UseCursorLines = o->value();
  if (o->value())
      btnCursorBWcolor->activate();
  else
      btnCursorBWcolor->deactivate();
  progdefaults.changed = true;
}

Fl_Button *btnCursorBWcolor=(Fl_Button *)0;

static void cb_btnCursorBWcolor(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.cursorLine;
  if (fl_color_chooser("Cursor BW Lines", clr.r, clr.g, clr.b ) ) {
  ui_colors.cursorLine = clr;
  o->color(RGBCOLOR(cursorLine));
  o->redraw();
  progdefaults.changed = true;
  }
}

Fl_Check_Button *btnUseWideCursor=(Fl_Check_Button *)0;

static void cb_btnUseWideCursor(Fl_Check_Button* o, void*) {
  progdefaults.UseWideCursor = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnUseCursorCenterLine=(Fl_Check_Button *)0;

static void cb_btnUseCursorCenterLine(Fl_Check_Button* o, void*) {
  progdefaults.UseCursorCenterLine = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnCursorCenterLineColor=(Fl_Button *)0;

static void cb_btnCursorCenterLineColor(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.cursorCenter;
  if (fl_color_chooser("Cursor Center Line", clr.r, clr.g, clr.b) ) {
  ui_colors.cursorCenter = clr;
  o->color(RGBCOLOR(cursorCenter));
  o->redraw();
  progdefaults.changed = true;
  }
}

Fl_Check_Button *btnUseWideCenter=(Fl_Check_Button *)0;

static void cb_btnUseWideCenter(Fl_Check_Button* o, void*) {
  progdefaults.UseWideCenter = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnUseBWTracks=(Fl_Check_Button *)0;

static void cb_btnUseBWTracks(Fl_Check_Button* o, void*) {
  progdefaults.UseBWTracks = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnBwTracksColor=(Fl_Button *)0;

static void cb_btnBwTracksColor(Fl_Button* o, void*) {
  TRIAD clr;
  clr = ui_colors.bwTrack;
  if (fl_color_chooser("Track Lines", clr.r, clr.g, clr.b ) ) {
    ui_colors.bwTrack = clr;
    o->color(RGBCOLOR(bwTrack));
    o->redraw();
    wf->redraw_marker();
    progdefaults.changed = true;
  }
}

Fl_Check_Button *btnUseWideTracks=(Fl_Check_Button *)0;

static void cb_btnUseWideTracks(Fl_Check_Button* o, void*) {
  progdefaults.UseWideTracks = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnNotchColor=(Fl_Button *)0;

static void cb_btnNotchColor(Fl_Button* o, void*) {
  TRIAD clr;
  clr = ui_colors.notch;
  if (fl_color_chooser("Notch Indicator", clr.r, clr.g, clr.b ) ) {
  ui_colors.notch = clr;
  o->color(RGBCOLOR(notch));
  o->redraw();
  wf->redraw_marker();
  progdefaults.changed = true;
  }
}

Fl_Button *btnRsIDZoneColor=(Fl_Button *)0;

static void cb_btnRsIDZoneColor(Fl_Button* o, void*) {
  TRIAD clr;
  clr = ui_colors.rsid;
  if (fl_color_chooser("RsID Zone Lines", clr.r, clr.g, clr.b ) ) {
  ui_colors.rsid = clr;
  o->color(RGBCOLOR(rsid));
  o->redraw();
  wf->redraw_marker();
  progdefaults.changed = true;
  }
}

Fl_Button *btnMonitorColor=(Fl_Button *)0;

static void cb_btnMonitorColor(Fl_Button* o, void*) {
  TRIAD clr = ui_colors.monitor;
  if (fl_color_chooser("Notch Indicator", clr.r, clr.g, clr.b )) {
    o->color(fl_rgb_color( clr.r, clr.g, clr.b) );
    ui_colors.monitor = clr;
    o->redraw();
    wf->redraw_marker();
    progdefaults.changed = true;
  }
}

Fl_Check_Button *btnUseWideMonitor=(Fl_Check_Button *)0;

static void cb_btnUseWideMonitor(Fl_Check_Button* o, void*) {
  progdefaults.mon_wide_tracks = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *chkShowAudioScale=(Fl_Check_Button *)0;

static void cb_chkShowAudioScale(Fl_Check_Button* o, void*) {
  progdefaults.wf_audioscale = o->value();
  progdefaults.changed = true;
}

Fl_Button *btnWaterfallFont=(Fl_Button *)0;

static void cb_btnWaterfallFont(Fl_Button*, void*) {
  font_browser->fontNumber(progdefaults.WaterfallFontnbr);
  font_browser->fontSize(progdefaults.WaterfallFontsize);
  font_browser->fontColor(FL_FOREGROUND_COLOR);
  if (font_browser->fixed_width(progdefaults.WaterfallFontnbr))
      font_browser->fontFilter(Font_Browser::FIXED_WIDTH);
  else
      font_browser->fontFilter(Font_Browser::ALL_TYPES);
  font_browser->callback((Fl_Callback*)cbWaterfallFontBrowser);
  font_browser->show();
}

Fl_Check_Button *btnViewXmtSignal=(Fl_Check_Button *)0;

static void cb_btnViewXmtSignal(Fl_Check_Button* o, void*) {
  progdefaults.viewXmtSignal=o->value();
  progdefaults.changed = true;
}

Fl_Counter *valTxMonitorLevel=(Fl_Counter *)0;

static void cb_valTxMonitorLevel(Fl_Counter* o, void*) {
  progdefaults.TxMonitorLevel = pow(10.0, o->value()/20);
  progdefaults.changed = true;
}

Fl_Counter2 *cntLowFreqCutoff=(Fl_Counter2 *)0;

static void cb_cntLowFreqCutoff(Fl_Counter2* o, void*) {
  progdefaults.LowFreqCutoff=(int)(o->value());
  progdefaults.changed = true;
  setwfrange();
}

Fl_Check_Button *btnWFaveraging=(Fl_Check_Button *)0;

static void cb_btnWFaveraging(Fl_Check_Button* o, void*) {
  progdefaults.WFaveraging = o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listboxFFTPrefilter=(Fl_ListBox *)0;

static void cb_listboxFFTPrefilter(Fl_ListBox* o, void*) {
  progdefaults.wfPreFilter = o->index();
  progdefaults.changed = true;
}

Fl_Counter2 *cntrWfwidth=(Fl_Counter2 *)0;

static void cb_cntrWfwidth(Fl_Counter2* o, void*) {
  progdefaults.HighFreqCutoff = (int)o->value();
  progdefaults.changed = true;
  setwfrange();
}

Fl_Counter2 *wf_latency=(Fl_Counter2 *)0;

static void cb_wf_latency(Fl_Counter2* o, void*) {
  progdefaults.wf_latency = (int)o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntr_drop_speed=(Fl_Counter *)0;

static void cb_cntr_drop_speed(Fl_Counter* o, void*) {
  progdefaults.drop_speed=(int)o->value();
  progdefaults.changed=true;
}

Fl_Counter2 *cntrWfheight=(Fl_Counter2 *)0;

static void cb_cntrWfheight(Fl_Counter2* o, void*) {
  progdefaults.wfheight = (int)o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnWaterfallHistoryDefault=(Fl_Check_Button *)0;

static void cb_btnWaterfallHistoryDefault(Fl_Check_Button* o, void*) {
  progdefaults.WaterfallHistoryDefault = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnWaterfallQSY=(Fl_Check_Button *)0;

static void cb_btnWaterfallQSY(Fl_Check_Button* o, void*) {
  progdefaults.WaterfallQSY = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnWaterfallClickInsert=(Fl_Check_Button *)0;

static void cb_btnWaterfallClickInsert(Fl_Check_Button* o, void*) {
  progdefaults.WaterfallClickInsert = o->value();
  if (progdefaults.WaterfallClickInsert)
      inpWaterfallClickText->activate();
  else
      inpWaterfallClickText->deactivate();
  progdefaults.changed = true;
}

Fl_Input2 *inpWaterfallClickText=(Fl_Input2 *)0;

static void cb_inpWaterfallClickText(Fl_Input2* o, void*) {
  progdefaults.WaterfallClickText = o->value();
  progdefaults.changed = true;
}

Fl_ListBox *listboxWaterfallWheelAction=(Fl_ListBox *)0;

static void cb_listboxWaterfallWheelAction(Fl_ListBox* o, void*) {
  progdefaults.WaterfallWheelAction = o->index();
  progdefaults.changed = true;
}

Fl_Check_Button *btnWFspectrum_center=(Fl_Check_Button *)0;

static void cb_btnWFspectrum_center(Fl_Check_Button* o, void*) {
  progdefaults.wf_spectrum_center = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btnWFspectrum_dbvals=(Fl_Check_Button *)0;

static void cb_btnWFspectrum_dbvals(Fl_Check_Button* o, void*) {
  progdefaults.wf_spectrum_dbvals = o->value();
  progdefaults.changed = true;
}

Fl_Counter *cntr_spectrum_freq_scale=(Fl_Counter *)0;

static void cb_cntr_spectrum_freq_scale(Fl_Counter* o, void*) {
  progdefaults.wf_spectrum_scale_factor = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_spectrum_modem_scale=(Fl_Check_Button *)0;

static void cb_btn_spectrum_modem_scale(Fl_Check_Button* o, void*) {
  progdefaults.wf_spectrum_modem_scale = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntServerCarrier=(Fl_Counter2 *)0;

static void cb_cntServerCarrier(Fl_Counter2* o, void*) {
  progdefaults.ServerCarrier = (int)o->value();
  wf->redraw_marker();
  progdefaults.changed = true;
}

Fl_Counter2 *cntServerOffset=(Fl_Counter2 *)0;

static void cb_cntServerOffset(Fl_Counter2* o, void*) {
  progdefaults.ServerOffset = (int)o->value();
  wf->redraw_marker();
  progdefaults.changed = true;
}

Fl_Counter2 *cntServerACQsn=(Fl_Counter2 *)0;

static void cb_cntServerACQsn(Fl_Counter2* o, void*) {
  progdefaults.ServerACQsn = o->value();
  progdefaults.changed = true;
}

Fl_Counter2 *cntServerAFCrange=(Fl_Counter2 *)0;

static void cb_cntServerAFCrange(Fl_Counter2* o, void*) {
  progdefaults.ServerAFCrange = (int)o->value();
  wf->redraw_marker();
  progdefaults.changed = true;
}

Fl_Check_Button *btnPSKmailSweetSpot=(Fl_Check_Button *)0;

static void cb_btnPSKmailSweetSpot(Fl_Check_Button* o, void*) {
  progdefaults.PSKmailSweetSpot = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_arq_s2n_report=(Fl_Check_Button *)0;

static void cb_btn_arq_s2n_report(Fl_Check_Button* o, void*) {
  progdefaults.Pskmails2nreport=o->value();
}

Fl_Input *txt_wx_url=(Fl_Input *)0;

static void cb_txt_wx_url(Fl_Input* o, void*) {
  progdefaults.wx_url = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_default_wx_url=(Fl_Button *)0;

static void cb_btn_default_wx_url(Fl_Button*, void*) {
  txt_wx_url->value(
  "https://tgftp.nws.noaa.gov/data/observations/metar/decoded");
  progdefaults.wx_url=txt_wx_url->value();
  progdefaults.changed=true;
}

Fl_Input *inpWXsta=(Fl_Input *)0;

static void cb_inpWXsta(Fl_Input* o, void*) {
  progdefaults.wx_sta = o->value();
  progdefaults.changed = true;
}

Fl_Button *btn_metar_search=(Fl_Button *)0;

static void cb_btn_metar_search(Fl_Button*, void*) {
  get_METAR_station();
}

Fl_Check_Button *btn_wx_full=(Fl_Check_Button *)0;

static void cb_btn_wx_full(Fl_Check_Button* o, void*) {
  progdefaults.wx_full=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_station_name=(Fl_Check_Button *)0;

static void cb_btn_wx_station_name(Fl_Check_Button* o, void*) {
  progdefaults.wx_station_name = o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_condx=(Fl_Check_Button *)0;

static void cb_btn_wx_condx(Fl_Check_Button* o, void*) {
  progdefaults.wx_condx=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_fahrenheit=(Fl_Check_Button *)0;

static void cb_btn_wx_fahrenheit(Fl_Check_Button* o, void*) {
  progdefaults.wx_fahrenheit=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_celsius=(Fl_Check_Button *)0;

static void cb_btn_wx_celsius(Fl_Check_Button* o, void*) {
  progdefaults.wx_celsius=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_mph=(Fl_Check_Button *)0;

static void cb_btn_wx_mph(Fl_Check_Button* o, void*) {
  progdefaults.wx_mph=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_kph=(Fl_Check_Button *)0;

static void cb_btn_wx_kph(Fl_Check_Button* o, void*) {
  progdefaults.wx_kph=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_inches=(Fl_Check_Button *)0;

static void cb_btn_wx_inches(Fl_Check_Button* o, void*) {
  progdefaults.wx_inches=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_mbars=(Fl_Check_Button *)0;

static void cb_btn_wx_mbars(Fl_Check_Button* o, void*) {
  progdefaults.wx_mbars=o->value();
  progdefaults.changed = true;
}

Fl_Check_Button *btn_wx_raw=(Fl_Check_Button *)0;

static void cb_btn_wx_raw(Fl_Check_Button* o, void*) {
  progdefaults.wx_raw=o->value();
  progdefaults.changed = true;
}

Fl_Button *btnSaveConfig=(Fl_Button *)0;

static void cb_btnSaveConfig(Fl_Button*, void*) {
  progdefaults.saveDefaults();
}

Fl_Return_Button *btnCloseConfig=(Fl_Return_Button *)0;

static void cb_btnCloseConfig(Fl_Return_Button*, void*) {
  closeDialog();
}

Fl_Button *btnResetConfig=(Fl_Button *)0;

static void cb_btnResetConfig(Fl_Button*, void*) {
  if (fl_choice2("This will effect every configuration item!\nConfirm", "Yes", "No", NULL)) {
  	progdefaults.resetDefaults();
  	progdefaults.changed = false;
  }
}

Fl_Double_Window* ConfigureDialog() {
  Fl_Double_Window* w;
  static const char szShifts[]  = "23|85|160|170|182|200|240|350|425|850|Custom";
  static const char szBauds[]  = "45|45.45|50|56|75|100|110|150|200|300";
  static const char szSelBits[] = "5 (baudot)|7 (ascii)|8 (ascii)";
  static const char szParity[]  = "none|even|odd|zero|one";
  static const char szStopBits[] = "1|1.5|2";
  static const char szOliviaTones[] = "2|4|8|16|32|64|128|256";
  static const char szOliviaBandwidth[] = "125|250|500|1000|2000";
  static const char szContestiaTones[] = "2|4|8|16|32|64|128|256";
  static const char szContestiaBandwidth[] = "125|250|500|1000|2000";
  static const char szBaudRates[] = "300|600|1200|2400|4800|9600|19200|38400|57600|115200|230400|460800";
  static const char szProsigns[] = "~|%|&|+|=|{|}|<|>|[|]| ";
  { Fl_Double_Window* o = new Fl_Double_Window(801, 380, gettext("Fldigi configuration"));
    w = o; (void)w;
    o->color(FL_DARK2);
    o->selection_color((Fl_Color)51);
    o->labelsize(18);
    o->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { Fl_Group* o = new Fl_Group(0, 0, 201, 380);
      { Fl_Tree* o = tab_tree = new Fl_Tree(0, 0, 200, 350);
        tab_tree->callback((Fl_Callback*)SelectItem_CB);
        Fl_Group::current()->resizable(tab_tree);
        o->root_label(_("Configure"));
        o->selectmode(FL_TREE_SELECT_SINGLE);
        o->connectorstyle(FL_TREE_CONNECTOR_DOTTED); // default is NONE on Mac
        o->connectorwidth(15); // default is 17
      } // Fl_Tree* tab_tree
      { Fl_Group* o = new Fl_Group(0, 350, 201, 30);
        { Fl_Group* o = new Fl_Group(0, 350, 100, 30);
          o->end();
          Fl_Group::current()->resizable(o);
        } // Fl_Group* o
        { btn_collapse_tab_tree = new Fl_Button(95, 353, 105, 22, gettext("Collapse Tree"));
          btn_collapse_tab_tree->callback((Fl_Callback*)cb_btn_collapse_tab_tree);
        } // Fl_Button* btn_collapse_tab_tree
        o->end();
      } // Fl_Group* o
      o->end();
      Fl_Group::current()->resizable(o);
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Call/Lookup"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(208, 24, 585, 131, gettext("Web Browser lookup"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Round_Button* o = btnQRZWEBnotavailable = new Fl_Round_Button(248, 43, 61, 20, gettext("None"));
          btnQRZWEBnotavailable->tooltip(gettext("Do not use callsign lookup via web browser"));
          btnQRZWEBnotavailable->down_box(FL_DOWN_BOX);
          btnQRZWEBnotavailable->value(1);
          btnQRZWEBnotavailable->callback((Fl_Callback*)cb_btnQRZWEBnotavailable);
          o->value(progdefaults.QRZWEB == QRZWEBNONE);
        } // Fl_Round_Button* btnQRZWEBnotavailable
        { Fl_Round_Button* o = btnQRZonline = new Fl_Round_Button(248, 63, 83, 20, gettext("QRZ on line"));
          btnQRZonline->tooltip(gettext("Visit QRZ web site"));
          btnQRZonline->down_box(FL_DOWN_BOX);
          btnQRZonline->callback((Fl_Callback*)cb_btnQRZonline);
          o->value(progdefaults.QRZWEB == QRZHTML);
        } // Fl_Round_Button* btnQRZonline
        { Fl_Round_Button* o = btnHAMCALLonline = new Fl_Round_Button(248, 84, 83, 20, gettext("HamCall online"));
          btnHAMCALLonline->tooltip(gettext("Visit Hamcall web site"));
          btnHAMCALLonline->down_box(FL_DOWN_BOX);
          btnHAMCALLonline->callback((Fl_Callback*)cb_btnHAMCALLonline);
          o->value(progdefaults.QRZWEB == HAMCALLHTML);
        } // Fl_Round_Button* btnHAMCALLonline
        { Fl_Round_Button* o = btnHamQTHonline = new Fl_Round_Button(248, 105, 20, 20, gettext("HamQTH online"));
          btnHamQTHonline->tooltip(gettext("Visit hamQTH web site"));
          btnHamQTHonline->down_box(FL_DOWN_BOX);
          btnHamQTHonline->callback((Fl_Callback*)cb_btnHamQTHonline);
          o->value(progdefaults.QRZWEB == HAMQTHHTML);
        } // Fl_Round_Button* btnHamQTHonline
        { Fl_Round_Button* o = btnCallookOnline = new Fl_Round_Button(248, 126, 20, 20, gettext("Callook online"));
          btnCallookOnline->tooltip(gettext("Visit hamQTH web site"));
          btnCallookOnline->down_box(FL_DOWN_BOX);
          btnCallookOnline->callback((Fl_Callback*)cb_btnCallookOnline);
          o->value(progdefaults.QRZWEB == CALLOOKHTML);
        } // Fl_Round_Button* btnCallookOnline
        { Fl_Input2* o = inp_qrzurl = new Fl_Input2(502, 37, 270, 22, gettext("QRZ"));
          inp_qrzurl->box(FL_DOWN_BOX);
          inp_qrzurl->color(FL_BACKGROUND2_COLOR);
          inp_qrzurl->selection_color(FL_SELECTION_COLOR);
          inp_qrzurl->labeltype(FL_NORMAL_LABEL);
          inp_qrzurl->labelfont(0);
          inp_qrzurl->labelsize(14);
          inp_qrzurl->labelcolor(FL_FOREGROUND_COLOR);
          inp_qrzurl->callback((Fl_Callback*)cb_inp_qrzurl);
          inp_qrzurl->align(Fl_Align(FL_ALIGN_LEFT));
          inp_qrzurl->when(FL_WHEN_RELEASE);
          o->value(progdefaults.qrzurl.c_str());
        } // Fl_Input2* inp_qrzurl
        { Fl_Input2* o = inp_hamcallurl = new Fl_Input2(502, 64, 270, 22, gettext("Hamcall"));
          inp_hamcallurl->box(FL_DOWN_BOX);
          inp_hamcallurl->color(FL_BACKGROUND2_COLOR);
          inp_hamcallurl->selection_color(FL_SELECTION_COLOR);
          inp_hamcallurl->labeltype(FL_NORMAL_LABEL);
          inp_hamcallurl->labelfont(0);
          inp_hamcallurl->labelsize(14);
          inp_hamcallurl->labelcolor(FL_FOREGROUND_COLOR);
          inp_hamcallurl->callback((Fl_Callback*)cb_inp_hamcallurl);
          inp_hamcallurl->align(Fl_Align(FL_ALIGN_LEFT));
          inp_hamcallurl->when(FL_WHEN_RELEASE);
          o->value(progdefaults.hamcallurl.c_str());
        } // Fl_Input2* inp_hamcallurl
        { Fl_Input2* o = inp_hamqthurl = new Fl_Input2(502, 92, 270, 22, gettext("HamQTH"));
          inp_hamqthurl->box(FL_DOWN_BOX);
          inp_hamqthurl->color(FL_BACKGROUND2_COLOR);
          inp_hamqthurl->selection_color(FL_SELECTION_COLOR);
          inp_hamqthurl->labeltype(FL_NORMAL_LABEL);
          inp_hamqthurl->labelfont(0);
          inp_hamqthurl->labelsize(14);
          inp_hamqthurl->labelcolor(FL_FOREGROUND_COLOR);
          inp_hamqthurl->callback((Fl_Callback*)cb_inp_hamqthurl);
          inp_hamqthurl->align(Fl_Align(FL_ALIGN_LEFT));
          inp_hamqthurl->when(FL_WHEN_RELEASE);
          o->value(progdefaults.hamqthurl.c_str());
        } // Fl_Input2* inp_hamqthurl
        { Fl_Input2* o = inp_callook_url = new Fl_Input2(502, 121, 270, 22, gettext("Callook"));
          inp_callook_url->tooltip(gettext("Callook.info web site"));
          inp_callook_url->box(FL_DOWN_BOX);
          inp_callook_url->color(FL_BACKGROUND2_COLOR);
          inp_callook_url->selection_color(FL_SELECTION_COLOR);
          inp_callook_url->labeltype(FL_NORMAL_LABEL);
          inp_callook_url->labelfont(0);
          inp_callook_url->labelsize(14);
          inp_callook_url->labelcolor(FL_FOREGROUND_COLOR);
          inp_callook_url->callback((Fl_Callback*)cb_inp_callook_url);
          inp_callook_url->align(Fl_Align(FL_ALIGN_LEFT));
          inp_callook_url->when(FL_WHEN_RELEASE);
          o->value(progdefaults.callookurl.c_str());
        } // Fl_Input2* inp_callook_url
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(208, 156, 585, 185, gettext("Data base lookup"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Round_Button* o = btnQRZXMLnotavailable = new Fl_Round_Button(255, 179, 69, 20, gettext("None"));
          btnQRZXMLnotavailable->tooltip(gettext("Do not use callsign database"));
          btnQRZXMLnotavailable->down_box(FL_DOWN_BOX);
          btnQRZXMLnotavailable->value(1);
          btnQRZXMLnotavailable->callback((Fl_Callback*)cb_btnQRZXMLnotavailable);
          o->value(progdefaults.QRZXML == QRZXMLNONE);
        } // Fl_Round_Button* btnQRZXMLnotavailable
        { Fl_Round_Button* o = btnQRZcdrom = new Fl_Round_Button(255, 205, 76, 20, gettext("QRZ cdrom"));
          btnQRZcdrom->tooltip(gettext("Use CD or hard drive CD image"));
          btnQRZcdrom->down_box(FL_DOWN_BOX);
          btnQRZcdrom->callback((Fl_Callback*)cb_btnQRZcdrom);
          o->value(progdefaults.QRZXML == QRZCD);
        } // Fl_Round_Button* btnQRZcdrom
        { Fl_Round_Button* o = btnQRZsub = new Fl_Round_Button(255, 231, 137, 20, gettext("QRZ.com"));
          btnQRZsub->tooltip(gettext("You need a paid QRZ online\nsubscription to access"));
          btnQRZsub->down_box(FL_DOWN_BOX);
          btnQRZsub->callback((Fl_Callback*)cb_btnQRZsub);
          o->value(progdefaults.QRZXML == QRZNET);
        } // Fl_Round_Button* btnQRZsub
        { Fl_Round_Button* o = btnHamcall = new Fl_Round_Button(255, 258, 137, 20, gettext("Hamcall.net"));
          btnHamcall->tooltip(gettext("You need a paid Hamcall online\nsubscription to access"));
          btnHamcall->down_box(FL_DOWN_BOX);
          btnHamcall->callback((Fl_Callback*)cb_btnHamcall);
          o->value(progdefaults.QRZXML == HAMCALLNET);
        } // Fl_Round_Button* btnHamcall
        { Fl_Round_Button* o = btnHamQTH = new Fl_Round_Button(255, 284, 137, 20, gettext("HamQTH.com"));
          btnHamQTH->tooltip(gettext("Free service courtesy of OK"));
          btnHamQTH->down_box(FL_DOWN_BOX);
          btnHamQTH->callback((Fl_Callback*)cb_btnHamQTH);
          o->value(progdefaults.QRZXML == HAMQTH);
        } // Fl_Round_Button* btnHamQTH
        { Fl_Round_Button* o = btnCALLOOK = new Fl_Round_Button(255, 311, 113, 20, gettext("Callook.info"));
          btnCALLOOK->tooltip(gettext("Callook.info lookup (free service US callsigns only)"));
          btnCALLOOK->down_box(FL_DOWN_BOX);
          btnCALLOOK->callback((Fl_Callback*)cb_btnCALLOOK);
          o->value(progdefaults.QRZXML == CALLOOK);
        } // Fl_Round_Button* btnCALLOOK
        { Fl_Input2* o = txtQRZpathname = new Fl_Input2(372, 204, 401, 22);
          txtQRZpathname->tooltip(gettext("ie: /home/dave/CALLBK/ or C:/CALLBK/\nLeave blank to search for database"));
          txtQRZpathname->box(FL_DOWN_BOX);
          txtQRZpathname->color(FL_BACKGROUND2_COLOR);
          txtQRZpathname->selection_color(FL_SELECTION_COLOR);
          txtQRZpathname->labeltype(FL_NORMAL_LABEL);
          txtQRZpathname->labelfont(0);
          txtQRZpathname->labelsize(14);
          txtQRZpathname->labelcolor(FL_FOREGROUND_COLOR);
          txtQRZpathname->callback((Fl_Callback*)cb_txtQRZpathname);
          txtQRZpathname->align(Fl_Align(FL_ALIGN_LEFT));
          txtQRZpathname->when(FL_WHEN_RELEASE);
          o->value(progdefaults.QRZpathname.c_str());
          txtQRZpathname->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* txtQRZpathname
        { Fl_Input2* o = inpQRZusername = new Fl_Input2(482, 230, 163, 22, gettext("User name"));
          inpQRZusername->tooltip(gettext("Login name for QRZ / Hamcall / HamQTH"));
          inpQRZusername->box(FL_DOWN_BOX);
          inpQRZusername->color(FL_BACKGROUND2_COLOR);
          inpQRZusername->selection_color(FL_SELECTION_COLOR);
          inpQRZusername->labeltype(FL_NORMAL_LABEL);
          inpQRZusername->labelfont(0);
          inpQRZusername->labelsize(14);
          inpQRZusername->labelcolor(FL_FOREGROUND_COLOR);
          inpQRZusername->callback((Fl_Callback*)cb_inpQRZusername);
          inpQRZusername->align(Fl_Align(FL_ALIGN_LEFT));
          inpQRZusername->when(FL_WHEN_RELEASE);
          o->value(progdefaults.QRZusername.c_str());
          inpQRZusername->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inpQRZusername
        { Fl_Input2* o = inpQRZuserpassword = new Fl_Input2(482, 257, 163, 22, gettext("Password"));
          inpQRZuserpassword->tooltip(gettext("Password for QRZ / Hamcall / HamQTH"));
          inpQRZuserpassword->box(FL_DOWN_BOX);
          inpQRZuserpassword->color(FL_BACKGROUND2_COLOR);
          inpQRZuserpassword->selection_color(FL_SELECTION_COLOR);
          inpQRZuserpassword->labeltype(FL_NORMAL_LABEL);
          inpQRZuserpassword->labelfont(0);
          inpQRZuserpassword->labelsize(14);
          inpQRZuserpassword->labelcolor(FL_FOREGROUND_COLOR);
          inpQRZuserpassword->callback((Fl_Callback*)cb_inpQRZuserpassword);
          inpQRZuserpassword->align(Fl_Align(FL_ALIGN_LEFT));
          inpQRZuserpassword->when(FL_WHEN_RELEASE);
          o->value(progdefaults.QRZuserpassword.c_str());
          o->type(FL_SECRET_INPUT);
          inpQRZuserpassword->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inpQRZuserpassword
        { btnQRZpasswordShow = new Fl_Button(657, 257, 76, 22, gettext("Show"));
          btnQRZpasswordShow->tooltip(gettext("Show password in plain text"));
          btnQRZpasswordShow->callback((Fl_Callback*)cb_btnQRZpasswordShow);
        } // Fl_Button* btnQRZpasswordShow
        { Fl_Group* o = new Fl_Group(377, 307, 403, 27);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Check_Button* o = btn_notes_address = new Fl_Check_Button(401, 313, 207, 15, gettext("Add address to notes field"));
            btn_notes_address->down_box(FL_DOWN_BOX);
            btn_notes_address->callback((Fl_Callback*)cb_btn_notes_address);
            o->value(progdefaults.notes_address);
          } // Fl_Check_Button* btn_notes_address
          { Fl_Check_Button* o = btn_clear_notes = new Fl_Check_Button(628, 313, 122, 15, gettext("clear old data"));
            btn_clear_notes->down_box(FL_DOWN_BOX);
            btn_clear_notes->callback((Fl_Callback*)cb_btn_clear_notes);
            o->value(progdefaults.clear_notes);
          } // Fl_Check_Button* btn_clear_notes
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Call/Lookup"));
      config_pages.push_back(p);
      tab_tree->add(_("Call/Lookup"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Call/cty.dat"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Input2* o = txt_cty_dat_pathname = new Fl_Input2(330, 56, 346, 24, gettext("cty.dat folder"));
        txt_cty_dat_pathname->tooltip(gettext("Enter full path-name for cty.dat folder"));
        txt_cty_dat_pathname->box(FL_DOWN_BOX);
        txt_cty_dat_pathname->color(FL_BACKGROUND2_COLOR);
        txt_cty_dat_pathname->selection_color(FL_SELECTION_COLOR);
        txt_cty_dat_pathname->labeltype(FL_NORMAL_LABEL);
        txt_cty_dat_pathname->labelfont(0);
        txt_cty_dat_pathname->labelsize(14);
        txt_cty_dat_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_cty_dat_pathname->callback((Fl_Callback*)cb_txt_cty_dat_pathname);
        txt_cty_dat_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_cty_dat_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.cty_dat_pathname.c_str());
      } // Fl_Input2* txt_cty_dat_pathname
      { btn_select_cty_dat = new Fl_Button(235, 101, 75, 24, gettext("Browse"));
        btn_select_cty_dat->tooltip(gettext("Locate cty.dat file"));
        btn_select_cty_dat->callback((Fl_Callback*)cb_btn_select_cty_dat);
      } // Fl_Button* btn_select_cty_dat
      { btn_default_cty_dat = new Fl_Button(330, 101, 75, 24, gettext("Default"));
        btn_default_cty_dat->tooltip(gettext("Restore cty.dat default folder"));
        btn_default_cty_dat->callback((Fl_Callback*)cb_btn_default_cty_dat);
      } // Fl_Button* btn_default_cty_dat
      { btn_reload_cty_dat = new Fl_Button(425, 101, 75, 24, gettext("Reload"));
        btn_reload_cty_dat->tooltip(gettext("Reload cty.dat"));
        btn_reload_cty_dat->callback((Fl_Callback*)cb_btn_reload_cty_dat);
      } // Fl_Button* btn_reload_cty_dat
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Call/Cty.dat"));
      config_pages.push_back(p);
      tab_tree->add(_("Call/Cty.dat"));
      tab_tree->close(_("Call"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/Buttons-Menus"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { btnSpotColor = new Fl_Button(284, 66, 110, 21, gettext("Spot"));
        btnSpotColor->callback((Fl_Callback*)cb_btnSpotColor);
      } // Fl_Button* btnSpotColor
      { btnRevColor = new Fl_Button(284, 103, 110, 21, gettext("Rev"));
        btnRevColor->callback((Fl_Callback*)cb_btnRevColor);
      } // Fl_Button* btnRevColor
      { btnTuneColor = new Fl_Button(284, 141, 110, 21, gettext("Tune"));
        btnTuneColor->callback((Fl_Callback*)cb_btnTuneColor);
      } // Fl_Button* btnTuneColor
      { btnRxIDColor = new Fl_Button(284, 179, 110, 21, gettext("RxID nar"));
        btnRxIDColor->callback((Fl_Callback*)cb_btnRxIDColor);
      } // Fl_Button* btnRxIDColor
      { btnLkColor = new Fl_Button(473, 66, 110, 21, gettext("Lk"));
        btnLkColor->callback((Fl_Callback*)cb_btnLkColor);
      } // Fl_Button* btnLkColor
      { btnSql1Color = new Fl_Button(473, 103, 110, 21, gettext("SQL-1"));
        btnSql1Color->callback((Fl_Callback*)cb_btnSql1Color);
      } // Fl_Button* btnSql1Color
      { btnXmtColor = new Fl_Button(473, 141, 110, 20, gettext("T/R"));
        btnXmtColor->callback((Fl_Callback*)cb_btnXmtColor);
      } // Fl_Button* btnXmtColor
      { btnRxIDwideColor = new Fl_Button(473, 179, 110, 21, gettext("RxID wide"));
        btnRxIDwideColor->callback((Fl_Callback*)cb_btnRxIDwideColor);
      } // Fl_Button* btnRxIDwideColor
      { btnAfcColor = new Fl_Button(663, 66, 110, 21, gettext("AFC"));
        btnAfcColor->callback((Fl_Callback*)cb_btnAfcColor);
      } // Fl_Button* btnAfcColor
      { btnSql2Color = new Fl_Button(663, 103, 110, 20, gettext("SQL-2"));
        btnSql2Color->callback((Fl_Callback*)cb_btnSql2Color);
      } // Fl_Button* btnSql2Color
      { btnTxIDColor = new Fl_Button(662, 179, 110, 20, gettext("TxID"));
        btnTxIDColor->callback((Fl_Callback*)cb_btnTxIDColor);
      } // Fl_Button* btnTxIDColor
      { Fl_Box* o = spotcolor = new Fl_Box(254, 67, 18, 19);
        spotcolor->box(FL_THIN_DOWN_BOX);
        spotcolor->color((Fl_Color)3);
        o->color( RGBCOLOR( SpotColor ) );
      } // Fl_Box* spotcolor
      { Fl_Box* o = revcolor = new Fl_Box(254, 104, 18, 19);
        revcolor->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( RevColor ) );
      } // Fl_Box* revcolor
      { Fl_Box* o = tunecolor = new Fl_Box(254, 142, 18, 19);
        tunecolor->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( TuneColor ) );
      } // Fl_Box* tunecolor
      { Fl_Box* o = rxidcolor = new Fl_Box(254, 180, 18, 19);
        rxidcolor->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( RxIDColor ) );
      } // Fl_Box* rxidcolor
      { Fl_Box* o = lockcolor = new Fl_Box(442, 67, 18, 19);
        lockcolor->box(FL_THIN_DOWN_BOX);
        lockcolor->color((Fl_Color)3);
        o->color( RGBCOLOR( LkColor ) );
      } // Fl_Box* lockcolor
      { Fl_Box* o = sql1color = new Fl_Box(442, 104, 18, 19);
        sql1color->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( Sql1Color ) );
      } // Fl_Box* sql1color
      { Fl_Box* o = rxidcolorwide = new Fl_Box(442, 180, 18, 19);
        rxidcolorwide->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( RxIDwideColor ) );
      } // Fl_Box* rxidcolorwide
      { Fl_Box* o = xmtcolor = new Fl_Box(442, 142, 18, 18);
        xmtcolor->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( XmtColor ) );
      } // Fl_Box* xmtcolor
      { Fl_Box* o = afccolor = new Fl_Box(630, 76, 18, 19);
        afccolor->box(FL_THIN_DOWN_BOX);
        afccolor->color((Fl_Color)3);
        o->color( RGBCOLOR( AfcColor ) );
      } // Fl_Box* afccolor
      { Fl_Box* o = sql2color = new Fl_Box(630, 104, 18, 18);
        sql2color->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( Sql2Color ) );
      } // Fl_Box* sql2color
      { Fl_Box* o = txidcolor = new Fl_Box(630, 180, 18, 18);
        txidcolor->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( TxIDColor ) );
      } // Fl_Box* txidcolor
      { btn_default_btn_color = new Fl_Button(284, 217, 110, 21, gettext("Lighted Btns"));
        btn_default_btn_color->callback((Fl_Callback*)cb_btn_default_btn_color);
      } // Fl_Button* btn_default_btn_color
      { Fl_Box* o = default_btn_color = new Fl_Box(254, 218, 18, 19);
        default_btn_color->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( default_btn_color ) );
      } // Fl_Box* default_btn_color
      { btn_check_btn_color = new Fl_Button(473, 217, 110, 21, gettext("Check Btns"));
        btn_check_btn_color->callback((Fl_Callback*)cb_btn_check_btn_color);
      } // Fl_Button* btn_check_btn_color
      { Fl_Box* o = default_check_btn_color = new Fl_Box(442, 220, 18, 19);
        default_check_btn_color->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( default_check_btn_color ) );
      } // Fl_Box* default_check_btn_color
      { btn_default_round_btn_color = new Fl_Button(662, 217, 110, 21, gettext("Round Btns"));
        btn_default_round_btn_color->callback((Fl_Callback*)cb_btn_default_round_btn_color);
      } // Fl_Button* btn_default_round_btn_color
      { Fl_Box* o = default_round_btn_color = new Fl_Box(630, 218, 18, 19);
        default_round_btn_color->box(FL_ROUND_DOWN_BOX);
        o->color( RGBCOLOR( default_round_btn_color ) );
      } // Fl_Box* default_round_btn_color
      { btnMenuFont = new Fl_Button(284, 255, 110, 21, gettext("Menu font"));
        btnMenuFont->callback((Fl_Callback*)cb_btnMenuFont);
      } // Fl_Button* btnMenuFont
      { listboxScheme = new Fl_ListBox(314, 293, 80, 20, gettext("UI scheme"));
        listboxScheme->tooltip(gettext("Change application look and feel"));
        listboxScheme->box(FL_DOWN_BOX);
        listboxScheme->color(FL_BACKGROUND2_COLOR);
        listboxScheme->selection_color(FL_BACKGROUND_COLOR);
        listboxScheme->labeltype(FL_NORMAL_LABEL);
        listboxScheme->labelfont(0);
        listboxScheme->labelsize(14);
        listboxScheme->labelcolor(FL_FOREGROUND_COLOR);
        listboxScheme->callback((Fl_Callback*)cb_listboxScheme);
        listboxScheme->align(Fl_Align(FL_ALIGN_LEFT));
        listboxScheme->when(FL_WHEN_RELEASE);
        listboxScheme->add("base"); listboxScheme->add("gtk+");
        listboxScheme->add("plastic"); listboxScheme->add("gleam");
        listboxScheme->value(progdefaults.ui_scheme.c_str());
        listboxScheme->labelsize(FL_NORMAL_SIZE);
        listboxScheme->end();
      } // Fl_ListBox* listboxScheme
      { btn_background_color = new Fl_Button(473, 255, 110, 21, gettext("Background"));
        btn_background_color->callback((Fl_Callback*)cb_btn_background_color);
      } // Fl_Button* btn_background_color
      { Fl_Box* o = background_color = new Fl_Box(442, 256, 18, 19);
        background_color->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( background ) );
      } // Fl_Box* background_color
      { btn_background2_color = new Fl_Button(473, 292, 110, 21, gettext("Background2"));
        btn_background2_color->callback((Fl_Callback*)cb_btn_background2_color);
      } // Fl_Button* btn_background2_color
      { Fl_Box* o = background2_color = new Fl_Box(442, 293, 18, 19);
        background2_color->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( background2 ) );
      } // Fl_Box* background2_color
      { btn_foreground_color = new Fl_Button(662, 255, 110, 21, gettext("Foreground"));
        btn_foreground_color->callback((Fl_Callback*)cb_btn_foreground_color);
      } // Fl_Button* btn_foreground_color
      { Fl_Box* o = foreground_color = new Fl_Box(630, 256, 18, 19);
        foreground_color->box(FL_THIN_DOWN_BOX);
        o->color( RGBCOLOR( foreground ) );
      } // Fl_Box* foreground_color
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/Buttons-Menus"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/Buttons-Menus"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/FreqDisp - Meters"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(304, 51, 395, 87);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Box* o = FDdisplay = new Fl_Box(384, 55, 235, 45, gettext("14070.150"));
          FDdisplay->box(FL_DOWN_BOX);
          FDdisplay->color((Fl_Color)55);
          FDdisplay->labelfont(4);
          FDdisplay->labelsize(40);
          o->color( RGBCOLOR( FDbackground ) );
          o->labelcolor( RGBCOLOR( FDforeground ) );
          o->labelfont(progdefaults.FreqControlFontnbr);
        } // Fl_Box* FDdisplay
        { btn_freq_control_font = new Fl_Button(311, 106, 90, 24, gettext("Font"));
          btn_freq_control_font->callback((Fl_Callback*)cb_btn_freq_control_font);
        } // Fl_Button* btn_freq_control_font
        { btnBackgroundColor = new Fl_Button(407, 106, 90, 24, gettext("Bg Color"));
          btnBackgroundColor->callback((Fl_Callback*)cb_btnBackgroundColor);
        } // Fl_Button* btnBackgroundColor
        { btnForegroundColor = new Fl_Button(503, 106, 90, 24, gettext("Digit Color"));
          btnForegroundColor->callback((Fl_Callback*)cb_btnForegroundColor);
        } // Fl_Button* btnForegroundColor
        { btnFD_SystemColor = new Fl_Button(599, 106, 90, 24, gettext("Sys Colors"));
          btnFD_SystemColor->callback((Fl_Callback*)cb_btnFD_SystemColor);
        } // Fl_Button* btnFD_SystemColor
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(304, 142, 395, 62, gettext("S-meter"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btnSmeter_bg_color = new Fl_Button(311, 169, 90, 24, gettext("Bg Color"));
          btnSmeter_bg_color->callback((Fl_Callback*)cb_btnSmeter_bg_color);
        } // Fl_Button* btnSmeter_bg_color
        { btnSmeter_scale_color = new Fl_Button(407, 169, 90, 24, gettext("Scale Color"));
          btnSmeter_scale_color->callback((Fl_Callback*)cb_btnSmeter_scale_color);
        } // Fl_Button* btnSmeter_scale_color
        { btnSmeter_meter_color = new Fl_Button(503, 169, 90, 24, gettext("Meter Color"));
          btnSmeter_meter_color->callback((Fl_Callback*)cb_btnSmeter_meter_color);
        } // Fl_Button* btnSmeter_meter_color
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(304, 211, 395, 67, gettext("PWR-meter"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btnPWR_bg_color = new Fl_Button(311, 238, 90, 24, gettext("Bg Color"));
          btnPWR_bg_color->callback((Fl_Callback*)cb_btnPWR_bg_color);
        } // Fl_Button* btnPWR_bg_color
        { btnPWR_scale_color = new Fl_Button(407, 238, 90, 24, gettext("Scale Color"));
          btnPWR_scale_color->callback((Fl_Callback*)cb_btnPWR_scale_color);
        } // Fl_Button* btnPWR_scale_color
        { btnPWR_meter_Color = new Fl_Button(503, 238, 90, 24, gettext("Meter Color"));
          btnPWR_meter_Color->callback((Fl_Callback*)cb_btnPWR_meter_Color);
        } // Fl_Button* btnPWR_meter_Color
        { Fl_ListBox* o = listboxPWRselect = new Fl_ListBox(599, 238, 80, 24, gettext("Power scale"));
          listboxPWRselect->tooltip(gettext("Select the type of FFT prefilter"));
          listboxPWRselect->box(FL_DOWN_BOX);
          listboxPWRselect->color(FL_BACKGROUND2_COLOR);
          listboxPWRselect->selection_color(FL_BACKGROUND_COLOR);
          listboxPWRselect->labeltype(FL_NORMAL_LABEL);
          listboxPWRselect->labelfont(0);
          listboxPWRselect->labelsize(14);
          listboxPWRselect->labelcolor(FL_FOREGROUND_COLOR);
          listboxPWRselect->callback((Fl_Callback*)cb_listboxPWRselect);
          listboxPWRselect->align(Fl_Align(FL_ALIGN_TOP));
          listboxPWRselect->when(FL_WHEN_RELEASE);
          o->add(_("25 W")); o->add("50 W");
          o->add("100 W"); o->add("200 W"); o->add("AUTO");
          o->index(progdefaults.PWRselect);o->labelsize(FL_NORMAL_SIZE);
          listboxPWRselect->end();
        } // Fl_ListBox* listboxPWRselect
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/FreqDisp - Meters"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/FreqDisp - Meters"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/Function keys"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { btnUseGroupColors = new Fl_Check_Button(337, 92, 165, 21, gettext("Use colored buttons"));
        btnUseGroupColors->down_box(FL_DOWN_BOX);
        btnUseGroupColors->callback((Fl_Callback*)cb_btnUseGroupColors);
        btnUseGroupColors->value(progdefaults.useGroupColors);
      } // Fl_Check_Button* btnUseGroupColors
      { btnGroup1 = new Fl_Button(305, 140, 90, 30, gettext("Group 1"));
        btnGroup1->tooltip(gettext("Background color for Function key group 1"));
        btnGroup1->callback((Fl_Callback*)cb_btnGroup1);
        btnGroup1->color( RGBCOLOR( btnGroup1 ) );
        btnGroup1->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      } // Fl_Button* btnGroup1
      { btnGroup2 = new Fl_Button(407, 140, 90, 30, gettext("Group 2"));
        btnGroup2->tooltip(gettext("Background color for Function key group 2"));
        btnGroup2->callback((Fl_Callback*)cb_btnGroup2);
        btnGroup2->color( RGBCOLOR( btnGroup2 ) );
        btnGroup2->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      } // Fl_Button* btnGroup2
      { btnGroup3 = new Fl_Button(509, 140, 90, 30, gettext("Group 3"));
        btnGroup3->tooltip(gettext("Background color for Function key group 3"));
        btnGroup3->callback((Fl_Callback*)cb_btnGroup3);
        btnGroup3->color( RGBCOLOR( btnGroup3 ) );
        btnGroup3->labelcolor( RGBCOLOR( MacroBtnFontcolor ) );
      } // Fl_Button* btnGroup3
      { btnFkeyDEfaults = new Fl_Button(612, 140, 90, 30, gettext("Defaults"));
        btnFkeyDEfaults->callback((Fl_Callback*)cb_btnFkeyDEfaults);
      } // Fl_Button* btnFkeyDEfaults
      { btnMacroBtnFont = new Fl_Button(509, 87, 90, 30, gettext("Font/Color"));
        btnMacroBtnFont->callback((Fl_Callback*)cb_btnMacroBtnFont);
      } // Fl_Button* btnMacroBtnFont
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/Function keys"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/Function keys"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/Logging controls"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 33, 590, 65, gettext("Logging Panel Controls"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Output* o = LOGGINGdisplay = new Fl_Output(233, 57, 184, 25);
          o->textfont(progdefaults.LOGGINGtextfont);o->textsize(progdefaults.LOGGINGtextsize);o->textcolor( RGBCOLOR( LOGGINGtextcolor ) );
          o->color( RGBCOLOR( LOGGINGcolor ) );
          o->value("W1HKJ");
          o->redraw();
        } // Fl_Output* LOGGINGdisplay
        { btnLOGGING_color = new Fl_Button(476, 57, 80, 25, gettext("Bg Color"));
          btnLOGGING_color->callback((Fl_Callback*)cb_btnLOGGING_color);
        } // Fl_Button* btnLOGGING_color
        { btn_LOGGING_font = new Fl_Button(566, 57, 55, 25, gettext("Font"));
          btn_LOGGING_font->callback((Fl_Callback*)cb_btn_LOGGING_font);
        } // Fl_Button* btn_LOGGING_font
        { btnLOGGINGdefault_colors_font = new Fl_Button(632, 57, 80, 25, gettext("Default"));
          btnLOGGINGdefault_colors_font->callback((Fl_Callback*)cb_btnLOGGINGdefault_colors_font);
        } // Fl_Button* btnLOGGINGdefault_colors_font
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 99, 590, 65, gettext("Logbook Dialog"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Output* o = LOGBOOKdisplay = new Fl_Output(233, 123, 184, 25);
          o->textfont(progdefaults.LOGGINGtextfont);o->textsize(progdefaults.LOGGINGtextsize);o->textcolor( RGBCOLOR( LOGBOOKtextcolor ));
          o->color( RGBCOLOR( LOGBOOKcolor ) );
          o->value("14.070000");
          o->redraw();
        } // Fl_Output* LOGBOOKdisplay
        { btnLOGBOOK_color = new Fl_Button(475, 123, 80, 25, gettext("Bg Color"));
          btnLOGBOOK_color->callback((Fl_Callback*)cb_btnLOGBOOK_color);
        } // Fl_Button* btnLOGBOOK_color
        { btn_LOGBOOK_font = new Fl_Button(565, 123, 55, 25, gettext("Font"));
          btn_LOGBOOK_font->callback((Fl_Callback*)cb_btn_LOGBOOK_font);
        } // Fl_Button* btn_LOGBOOK_font
        { btnLOGBOOKdefault_colors_font = new Fl_Button(631, 123, 80, 25, gettext("Default"));
          btnLOGBOOKdefault_colors_font->callback((Fl_Callback*)cb_btnLOGBOOKdefault_colors_font);
        } // Fl_Button* btnLOGBOOKdefault_colors_font
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 168, 590, 147, gettext("DX Cluster Dialog"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Output* o = DXC_display = new Fl_Output(233, 203, 184, 25, gettext("Report Browser"));
          DXC_display->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->textfont(progdefaults.LOGGINGtextfont);o->textsize(progdefaults.LOGGINGtextsize);
          o->value("DX de W1HKJ-1");
          o->redraw();
        } // Fl_Output* DXC_display
        { btn_DXC_font = new Fl_Button(422, 203, 86, 25, gettext("Font"));
          btn_DXC_font->callback((Fl_Callback*)cb_btn_DXC_font);
        } // Fl_Button* btn_DXC_font
        { btnDXCdefault_colors_font = new Fl_Button(514, 203, 86, 25, gettext("Default"));
          btnDXCdefault_colors_font->callback((Fl_Callback*)cb_btnDXCdefault_colors_font);
        } // Fl_Button* btnDXCdefault_colors_font
        { Fl_Button* o = btn_DXC_even_lines = new Fl_Button(422, 234, 86, 25, gettext("Even Lines"));
          btn_DXC_even_lines->color((Fl_Color)55);
          btn_DXC_even_lines->callback((Fl_Callback*)cb_btn_DXC_even_lines);
          o->color( RGBCOLOR( LOGBOOKcolor ) );
        } // Fl_Button* btn_DXC_even_lines
        { Fl_Button* o = btn_DXC_odd_lines = new Fl_Button(514, 234, 86, 25, gettext("Odd Lines"));
          btn_DXC_odd_lines->color((Fl_Color)246);
          btn_DXC_odd_lines->callback((Fl_Callback*)cb_btn_DXC_odd_lines);
          o->color( RGBCOLOR( DXC_odd_color ) );
        } // Fl_Button* btn_DXC_odd_lines
        { Fl_Input* o = StreamText = new Fl_Input(233, 273, 184, 25, gettext("Stream Text"));
          StreamText->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value("DX de W1HKJ...");
          o->color( RGBCOLOR( DX_Color ));
          o->textfont(progdefaults.DXfontnbr); o->textsize(progdefaults.DXfontsize); o->textcolor( RGBCOLOR( DXfontcolor ) );
        } // Fl_Input* StreamText
        { btnDXcolor = new Fl_Button(422, 273, 86, 25, gettext("Bg color"));
          btnDXcolor->callback((Fl_Callback*)cb_btnDXcolor);
        } // Fl_Button* btnDXcolor
        { btnDXfont = new Fl_Button(514, 273, 86, 25, gettext("Font"));
          btnDXfont->callback((Fl_Callback*)cb_btnDXfont);
        } // Fl_Button* btnDXfont
        { Fl_Button* o = btnDXalt_color = new Fl_Button(606, 272, 86, 25, gettext("Alt Color"));
          btnDXalt_color->tooltip(gettext("Color for outgoing telnet text"));
          btnDXalt_color->callback((Fl_Callback*)cb_btnDXalt_color);
          o->labelcolor( RGBCOLOR( DXalt_color ) );
        } // Fl_Button* btnDXalt_color
        { btnDXdefault_colors_font = new Fl_Button(700, 272, 86, 25, gettext("Default"));
          btnDXdefault_colors_font->callback((Fl_Callback*)cb_btnDXdefault_colors_font);
        } // Fl_Button* btnDXdefault_colors_font
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/Logging controls"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/Logging controls"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/Rx-Tx"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_ListBox* o = listbox_charset_status = new Fl_ListBox(293, 40, 165, 24, gettext("Rx/Tx Character set"));
        listbox_charset_status->tooltip(gettext("Select Rx/Tx Character Set"));
        listbox_charset_status->box(FL_BORDER_BOX);
        listbox_charset_status->color((Fl_Color)55);
        listbox_charset_status->selection_color(FL_BACKGROUND_COLOR);
        listbox_charset_status->labeltype(FL_NORMAL_LABEL);
        listbox_charset_status->labelfont(0);
        listbox_charset_status->labelsize(14);
        listbox_charset_status->labelcolor(FL_FOREGROUND_COLOR);
        listbox_charset_status->align(Fl_Align(FL_ALIGN_RIGHT));
        listbox_charset_status->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
                  listbox_charset_status->callback(cb_listbox_charset, 0);
        listbox_charset_status->end();
      } // Fl_ListBox* listbox_charset_status
      { RxText = new Fl_Input(293, 71, 220, 36);
        RxText->value("Receive Text");
        RxText->color( RGBCOLOR( RxColor ) );
        RxText->textfont(progdefaults.RxFontnbr); RxText->textsize(progdefaults.RxFontsize); RxText->textcolor( RGBCOLOR( RxFontcolor ) );
        RxText->type(FL_MULTILINE_INPUT_WRAP);
      } // Fl_Input* RxText
      { btnRxColor = new Fl_Button(523, 78, 75, 21, gettext("Rx bkgnd"));
        btnRxColor->callback((Fl_Callback*)cb_btnRxColor);
      } // Fl_Button* btnRxColor
      { btnTxColor = new Fl_Button(523, 121, 75, 21, gettext("Tx bkgnd"));
        btnTxColor->callback((Fl_Callback*)cb_btnTxColor);
      } // Fl_Button* btnTxColor
      { TxText = new Fl_Input(293, 113, 220, 37);
        TxText->value("Transmit Text");
        TxText->color( RGBCOLOR( TxColor ) );
        TxText->textfont(progdefaults.TxFontnbr); TxText->textsize(progdefaults.TxFontsize); TxText->textcolor( RGBCOLOR( TxFontcolor ));
        TxText->type(FL_MULTILINE_INPUT_WRAP);
      } // Fl_Input* TxText
      { btnRxFont = new Fl_Button(608, 78, 75, 21, gettext("Rx font"));
        btnRxFont->callback((Fl_Callback*)cb_btnRxFont);
      } // Fl_Button* btnRxFont
      { btnTxFont = new Fl_Button(608, 121, 75, 21, gettext("Tx font"));
        btnTxFont->callback((Fl_Callback*)cb_btnTxFont);
      } // Fl_Button* btnTxFont
      { MacroText = new Fl_Input(293, 156, 220, 37);
        MacroText->value("Macro editor text");
        MacroText->textfont(progdefaults.MacroEditFontnbr);
        MacroText->textsize(progdefaults.MacroEditFontsize);
        MacroText->type(FL_MULTILINE_INPUT_WRAP);
      } // Fl_Input* MacroText
      { btnMacroEditFont = new Fl_Button(523, 164, 120, 21, gettext("Macro Edit Font"));
        btnMacroEditFont->callback((Fl_Callback*)cb_btnMacroEditFont);
      } // Fl_Button* btnMacroEditFont
      { Fl_Group* o = new Fl_Group(283, 203, 404, 81, gettext("Text Highlighting"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { btnXMIT = new Fl_Button(301, 231, 40, 21, gettext("XMIT"));
          btnXMIT->tooltip(gettext("Sent chars in Rx/Tx pane"));
          btnXMIT->callback((Fl_Callback*)cb_btnXMIT);
          btnXMIT->align(Fl_Align(FL_ALIGN_BOTTOM));
          btnXMIT->color( RGBCOLOR( XMITcolor ) );
        } // Fl_Button* btnXMIT
        { btnCTRL = new Fl_Button(344, 231, 40, 21, gettext("CTRL"));
          btnCTRL->tooltip(gettext("Control chars in Rx/Tx pane"));
          btnCTRL->callback((Fl_Callback*)cb_btnCTRL);
          btnCTRL->align(Fl_Align(FL_ALIGN_BOTTOM));
          btnCTRL->color( RGBCOLOR( CTRLcolor ) );
        } // Fl_Button* btnCTRL
        { btnSKIP = new Fl_Button(388, 231, 40, 21, gettext("SKIP"));
          btnSKIP->tooltip(gettext("Skipped chars in Tx pane\n(Tx on/off in CW)"));
          btnSKIP->callback((Fl_Callback*)cb_btnSKIP);
          btnSKIP->align(Fl_Align(FL_ALIGN_BOTTOM));
          btnSKIP->color( RGBCOLOR( SKIPcolor ) );
        } // Fl_Button* btnSKIP
        { btnALTR = new Fl_Button(431, 231, 40, 21, gettext("ALTR"));
          btnALTR->tooltip(gettext("Alternate character color in Rx panelr"));
          btnALTR->callback((Fl_Callback*)cb_btnALTR);
          btnALTR->align(Fl_Align(FL_ALIGN_BOTTOM));
          btnALTR->color( RGBCOLOR( ALTRcolor ));
        } // Fl_Button* btnALTR
        { btnSEL = new Fl_Button(475, 231, 39, 21, gettext("SEL"));
          btnSEL->tooltip(gettext("Selection background color in Rx Tx panels"));
          btnSEL->callback((Fl_Callback*)cb_btnSEL);
          btnSEL->align(Fl_Align(FL_ALIGN_BOTTOM));
          btnSEL->color( RGBCOLOR( RxTxSelectcolor ) );
        } // Fl_Button* btnSEL
        { btnNoTextColor = new Fl_Button(522, 231, 70, 21, gettext("System"));
          btnNoTextColor->callback((Fl_Callback*)cb_btnNoTextColor);
        } // Fl_Button* btnNoTextColor
        { btnTextDefaults = new Fl_Button(596, 231, 70, 21, gettext("Defaults"));
          btnTextDefaults->callback((Fl_Callback*)cb_btnTextDefaults);
        } // Fl_Button* btnTextDefaults
        o->end();
      } // Fl_Group* o
      { Fl_Check_Button* o = btn_show_all_codes = new Fl_Check_Button(307, 295, 25, 25, gettext("display Rx control chars as ascii string"));
        btn_show_all_codes->down_box(FL_DOWN_BOX);
        btn_show_all_codes->callback((Fl_Callback*)cb_btn_show_all_codes);
        o->value(progdefaults.show_all_codes);
      } // Fl_Check_Button* btn_show_all_codes
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/Rx-Tx"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/Rx-Tx"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/Tabs"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { btnTabColor = new Fl_Button(396, 69, 75, 21, gettext("Tab Color"));
        btnTabColor->callback((Fl_Callback*)cb_btnTabColor);
      } // Fl_Button* btnTabColor
      { btnTabDefaultColor = new Fl_Button(526, 69, 75, 21, gettext("System"));
        btnTabDefaultColor->callback((Fl_Callback*)cb_btnTabDefaultColor);
      } // Fl_Button* btnTabDefaultColor
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/Tabs"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/Tabs"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/Signal Level"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { new Fl_Box(340, 39, 316, 21, gettext("Signal Level Indicator"));
      } // Fl_Box* o
      { Fl_Box* o = lowcolor = new Fl_Box(365, 96, 21, 21);
        lowcolor->box(FL_DIAMOND_DOWN_BOX);
        lowcolor->color(FL_FOREGROUND_COLOR);
        o->color( RGBCOLOR( LowSignal ) );
      } // Fl_Box* lowcolor
      { btnLowSignal = new Fl_Button(402, 75, 70, 22, gettext("Low"));
        btnLowSignal->callback((Fl_Callback*)cb_btnLowSignal);
      } // Fl_Button* btnLowSignal
      { Fl_Box* o = normalcolor = new Fl_Box(365, 142, 21, 21);
        normalcolor->box(FL_DIAMOND_DOWN_BOX);
        normalcolor->color((Fl_Color)2);
        o->color(RGBCOLOR(NormSignal));
      } // Fl_Box* normalcolor
      { Fl_Counter* o = cnt_normal_signal_level = new Fl_Counter(480, 99, 114, 21, gettext("Transition\nLevel (dB)"));
        cnt_normal_signal_level->minimum(-90);
        cnt_normal_signal_level->maximum(0);
        cnt_normal_signal_level->callback((Fl_Callback*)cb_cnt_normal_signal_level);
        cnt_normal_signal_level->align(Fl_Align(FL_ALIGN_TOP));
        o->value(progdefaults.normal_signal_level);
        o->lstep(1.0);
      } // Fl_Counter* cnt_normal_signal_level
      { btnNormalSignal = new Fl_Button(402, 122, 70, 21, gettext("Normal"));
        btnNormalSignal->callback((Fl_Callback*)cb_btnNormalSignal);
      } // Fl_Button* btnNormalSignal
      { Fl_Box* o = highcolor = new Fl_Box(365, 189, 21, 21);
        highcolor->box(FL_DIAMOND_DOWN_BOX);
        highcolor->color((Fl_Color)3);
        o->color(RGBCOLOR(HighSignal));
      } // Fl_Box* highcolor
      { Fl_Counter* o = cnt_high_signal_level = new Fl_Counter(480, 145, 114, 21);
        cnt_high_signal_level->minimum(-90);
        cnt_high_signal_level->maximum(0);
        cnt_high_signal_level->callback((Fl_Callback*)cb_cnt_high_signal_level);
        o->value(progdefaults.high_signal_level);
        o->lstep(1.0);
      } // Fl_Counter* cnt_high_signal_level
      { btnHighSignal = new Fl_Button(402, 169, 70, 21, gettext("High"));
        btnHighSignal->callback((Fl_Callback*)cb_btnHighSignal);
      } // Fl_Button* btnHighSignal
      { Fl_Box* o = overcolor = new Fl_Box(365, 236, 21, 21);
        overcolor->box(FL_DIAMOND_DOWN_BOX);
        overcolor->color((Fl_Color)1);
        o->color(RGBCOLOR(OverSignal));
      } // Fl_Box* overcolor
      { Fl_Counter* o = cnt_over_signal_level = new Fl_Counter(480, 192, 114, 21);
        cnt_over_signal_level->minimum(-90);
        cnt_over_signal_level->maximum(0);
        cnt_over_signal_level->callback((Fl_Callback*)cb_cnt_over_signal_level);
        o->value(progdefaults.over_signal_level);
        o->lstep(1.0);
      } // Fl_Counter* cnt_over_signal_level
      { btnOverSignal = new Fl_Button(402, 216, 70, 21, gettext("Over"));
        btnOverSignal->callback((Fl_Callback*)cb_btnOverSignal);
      } // Fl_Button* btnOverSignal
      { Fl_Progress* o = new Fl_Progress(295, 289, 416, 25, gettext("label"));
        o->hide();
      } // Fl_Progress* o
      { sig_vumeter = new vumeter(322, 260, 360, 24, gettext("label"));
        sig_vumeter->box(FL_DOWN_BOX);
        sig_vumeter->color(FL_BACKGROUND2_COLOR);
        sig_vumeter->selection_color(FL_YELLOW);
        sig_vumeter->labeltype(FL_NORMAL_LABEL);
        sig_vumeter->labelfont(0);
        sig_vumeter->labelsize(14);
        sig_vumeter->labelcolor(FL_FOREGROUND_COLOR);
        sig_vumeter->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        sig_vumeter->when(FL_WHEN_RELEASE);
      } // vumeter* sig_vumeter
      { new Fl_Box(375, 287, 237, 17, gettext("Input signal level"));
      } // Fl_Box* o
      { btn_default_signal_levels = new Fl_Button(618, 146, 70, 20, gettext("Default"));
        btn_default_signal_levels->callback((Fl_Callback*)cb_btn_default_signal_levels);
      } // Fl_Button* btn_default_signal_levels
      { Fl_Check_Button* o = btn_use_wsjtx_vumeter_scale = new Fl_Check_Button(332, 315, 70, 18, gettext("Use wsjtx scale"));
        btn_use_wsjtx_vumeter_scale->tooltip(gettext("default scale is audo \"Vu Meter\"\nenable to emulate wsjtx scale"));
        btn_use_wsjtx_vumeter_scale->down_box(FL_DOWN_BOX);
        btn_use_wsjtx_vumeter_scale->callback((Fl_Callback*)cb_btn_use_wsjtx_vumeter_scale);
        o->value(progdefaults.use_wsjtx_vumeter_scale);
      } // Fl_Check_Button* btn_use_wsjtx_vumeter_scale
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/Signal Level"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/Signal Level"));
      tab_tree->close(_("Colors-Fonts"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Colors-Fonts/Digiscope"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { new Fl_Box(340, 39, 316, 21, gettext("Digital Scope Colors"));
      } // Fl_Box* o
      { Fl_Box* o = scope_background = new Fl_Box(365, 80, 21, 21);
        scope_background->box(FL_DOWN_BOX);
        scope_background->color(FL_FOREGROUND_COLOR);
        o->color(RGBCOLOR(digi_background));
      } // Fl_Box* scope_background
      { btnScopeBackground = new Fl_Button(402, 79, 104, 22, gettext("Background"));
        btnScopeBackground->callback((Fl_Callback*)cb_btnScopeBackground);
      } // Fl_Button* btnScopeBackground
      { Fl_Box* o = scope_axis = new Fl_Box(365, 121, 21, 21);
        scope_axis->box(FL_DOWN_BOX);
        scope_axis->color((Fl_Color)2);
        o->color(RGBCOLOR(digi_axis_color));
      } // Fl_Box* scope_axis
      { btnScopeAxis = new Fl_Button(402, 120, 104, 22, gettext("Axis"));
        btnScopeAxis->callback((Fl_Callback*)cb_btnScopeAxis);
      } // Fl_Button* btnScopeAxis
      { Fl_Box* o = scope_color_1 = new Fl_Box(365, 163, 21, 21);
        scope_color_1->box(FL_DOWN_BOX);
        scope_color_1->color((Fl_Color)3);
        o->color( RGBCOLOR( digi_color_1 ) );
      } // Fl_Box* scope_color_1
      { btnScopeColor_1 = new Fl_Button(402, 162, 104, 22, gettext("Color 1"));
        btnScopeColor_1->callback((Fl_Callback*)cb_btnScopeColor_1);
      } // Fl_Button* btnScopeColor_1
      { Fl_Box* o = scope_color_2 = new Fl_Box(365, 205, 21, 21);
        scope_color_2->box(FL_DOWN_BOX);
        scope_color_2->color((Fl_Color)1);
        o->color(RGBCOLOR(digi_color_2));
      } // Fl_Box* scope_color_2
      { btnScopeColor_2 = new Fl_Button(402, 204, 104, 22, gettext("Color 2"));
        btnScopeColor_2->callback((Fl_Callback*)cb_btnScopeColor_2);
      } // Fl_Button* btnScopeColor_2
      { Fl_Progress* o = new Fl_Progress(295, 289, 416, 25, gettext("label"));
        o->hide();
      } // Fl_Progress* o
      { btn_default_scope_colors = new Fl_Button(618, 146, 70, 20, gettext("Default"));
        btn_default_scope_colors->callback((Fl_Callback*)cb_btn_default_scope_colors);
      } // Fl_Button* btn_default_scope_colors
      { Fl_Box* o = scope_color_3 = new Fl_Box(365, 247, 21, 21);
        scope_color_3->box(FL_DOWN_BOX);
        scope_color_3->color((Fl_Color)1);
        o->color(RGBCOLOR(digi_color_3));
      } // Fl_Box* scope_color_3
      { btnScopeColor_3 = new Fl_Button(402, 246, 104, 22, gettext("Color 3"));
        btnScopeColor_3->callback((Fl_Callback*)cb_btnScopeColor_3);
      } // Fl_Button* btnScopeColor_3
      { Fl_Box* o = scope_color_4 = new Fl_Box(365, 289, 21, 21);
        scope_color_4->box(FL_DOWN_BOX);
        scope_color_4->color((Fl_Color)1);
        o->color(RGBCOLOR(digi_color_4));
      } // Fl_Box* scope_color_4
      { btnScopeColor_4 = new Fl_Button(402, 288, 104, 22, gettext("Color 4"));
        btnScopeColor_4->callback((Fl_Callback*)cb_btnScopeColor_4);
      } // Fl_Button* btnScopeColor_4
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Colors-Fonts/Digiscope"));
      config_pages.push_back(p);
      tab_tree->add(_("Colors-Fonts/Digiscope"));
      tab_tree->close(_("Colors-Fonts"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Contests/General"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_ListBox* o = listbox_contest = new Fl_ListBox(287, 41, 500, 24, gettext("Contest"));
        listbox_contest->tooltip(gettext("Select Logging as QSO or Contest"));
        listbox_contest->box(FL_DOWN_BOX);
        listbox_contest->color(FL_BACKGROUND2_COLOR);
        listbox_contest->selection_color(FL_BACKGROUND_COLOR);
        listbox_contest->labeltype(FL_NORMAL_LABEL);
        listbox_contest->labelfont(0);
        listbox_contest->labelsize(14);
        listbox_contest->labelcolor(FL_FOREGROUND_COLOR);
        listbox_contest->callback((Fl_Callback*)cb_listbox_contest);
        listbox_contest->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_contest->when(FL_WHEN_RELEASE);
        o->add(contest_names().c_str());
        o->index(progdefaults.logging);
        listbox_contest->end();
      } // Fl_ListBox* listbox_contest
      { Fl_ListBox* o = listbox_QP_contests = new Fl_ListBox(367, 75, 420, 24, gettext("State QSO Party"));
        listbox_QP_contests->box(FL_DOWN_BOX);
        listbox_QP_contests->color(FL_BACKGROUND2_COLOR);
        listbox_QP_contests->selection_color(FL_BACKGROUND_COLOR);
        listbox_QP_contests->labeltype(FL_NORMAL_LABEL);
        listbox_QP_contests->labelfont(0);
        listbox_QP_contests->labelsize(14);
        listbox_QP_contests->labelcolor(FL_FOREGROUND_COLOR);
        listbox_QP_contests->callback((Fl_Callback*)cb_listbox_QP_contests);
        listbox_QP_contests->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_QP_contests->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
        o->add(QSOparties.names().c_str());
        o->index(progdefaults.SQSOcontest);
        listbox_QP_contests->end();
      } // Fl_ListBox* listbox_QP_contests
      { Fl_Input2* o = inp_contest_notes = new Fl_Input2(367, 110, 420, 24, gettext("Text capture order"));
        inp_contest_notes->tooltip(gettext("Context Notes"));
        inp_contest_notes->box(FL_DOWN_BOX);
        inp_contest_notes->color(FL_BACKGROUND2_COLOR);
        inp_contest_notes->selection_color(FL_SELECTION_COLOR);
        inp_contest_notes->labeltype(FL_NORMAL_LABEL);
        inp_contest_notes->labelfont(0);
        inp_contest_notes->labelsize(14);
        inp_contest_notes->labelcolor(FL_FOREGROUND_COLOR);
        inp_contest_notes->align(Fl_Align(FL_ALIGN_LEFT));
        inp_contest_notes->when(FL_WHEN_RELEASE);
        o->value(progdefaults.CONTESTnotes.c_str());
      } // Fl_Input2* inp_contest_notes
      { Fl_Group* o = new Fl_Group(204, 149, 590, 86, gettext("Duplicate check, CALL plus"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Light_Button* o = btnDupCheckOn = new Fl_Light_Button(221, 174, 74, 20, gettext("On/Off"));
          btnDupCheckOn->tooltip(gettext("Check for duplicates"));
          btnDupCheckOn->selection_color((Fl_Color)2);
          btnDupCheckOn->callback((Fl_Callback*)cb_btnDupCheckOn);
          o->value(progdefaults.EnableDupCheck);
        } // Fl_Light_Button* btnDupCheckOn
        { Fl_Check_Button* o = btnDupBand = new Fl_Check_Button(333, 174, 70, 20, gettext("Band"));
          btnDupBand->tooltip(gettext("Bands must match"));
          btnDupBand->down_box(FL_DOWN_BOX);
          btnDupBand->callback((Fl_Callback*)cb_btnDupBand);
          o->value(progdefaults.dupband);
        } // Fl_Check_Button* btnDupBand
        { Fl_Check_Button* o = btnDupMode = new Fl_Check_Button(446, 174, 70, 20, gettext("Mode"));
          btnDupMode->tooltip(gettext("Mode must match"));
          btnDupMode->down_box(FL_DOWN_BOX);
          btnDupMode->callback((Fl_Callback*)cb_btnDupMode);
          o->value(progdefaults.dupmode);
        } // Fl_Check_Button* btnDupMode
        { Fl_Check_Button* o = btnDupTimeSpan = new Fl_Check_Button(571, 174, 129, 20, gettext("Time span over"));
          btnDupTimeSpan->tooltip(gettext("QSO must not occur within a time period of"));
          btnDupTimeSpan->down_box(FL_DOWN_BOX);
          btnDupTimeSpan->callback((Fl_Callback*)cb_btnDupTimeSpan);
          o->value(progdefaults.duptimespan);
        } // Fl_Check_Button* btnDupTimeSpan
        { Fl_Button* o = btnDupColor = new Fl_Button(221, 201, 90, 24, gettext("Dup Color"));
          btnDupColor->tooltip(gettext("Left click to select dup color"));
          btnDupColor->box(FL_DOWN_BOX);
          btnDupColor->down_box(FL_DOWN_BOX);
          btnDupColor->color(FL_BACKGROUND2_COLOR);
          btnDupColor->selection_color(FL_BACKGROUND2_COLOR);
          btnDupColor->callback((Fl_Callback*)cb_btnDupColor);
          o->color(RGBCOLOR(dup_color));
        } // Fl_Button* btnDupColor
        { Fl_Button* o = btnPossibleDupColor = new Fl_Button(333, 201, 90, 24, gettext("? Dup Color"));
          btnPossibleDupColor->tooltip(gettext("Left click to select possible dup color"));
          btnPossibleDupColor->box(FL_DOWN_BOX);
          btnPossibleDupColor->down_box(FL_DOWN_BOX);
          btnPossibleDupColor->color(FL_BACKGROUND2_COLOR);
          btnPossibleDupColor->selection_color(FL_BACKGROUND2_COLOR);
          btnPossibleDupColor->callback((Fl_Callback*)cb_btnPossibleDupColor);
          o->color(RGBCOLOR(possible_dup_color));
        } // Fl_Button* btnPossibleDupColor
        { Fl_Check_Button* o = btnDupXchg1 = new Fl_Check_Button(446, 203, 105, 20, gettext("Exchange In"));
          btnDupXchg1->tooltip(gettext("free form 1 must match"));
          btnDupXchg1->down_box(FL_DOWN_BOX);
          btnDupXchg1->callback((Fl_Callback*)cb_btnDupXchg1);
          o->value(progdefaults.dupxchg1);
        } // Fl_Check_Button* btnDupXchg1
        { Fl_Check_Button* o = btnDupState = new Fl_Check_Button(571, 203, 70, 20, gettext("State"));
          btnDupState->tooltip(gettext("State must match"));
          btnDupState->down_box(FL_DOWN_BOX);
          btnDupState->callback((Fl_Callback*)cb_btnDupState);
          o->value(progdefaults.dupstate);
        } // Fl_Check_Button* btnDupState
        { Fl_Value_Input2* o = nbrTimeSpan = new Fl_Value_Input2(664, 201, 53, 24, gettext("minutes"));
          nbrTimeSpan->tooltip(gettext("Enter time span in minutes"));
          nbrTimeSpan->box(FL_DOWN_BOX);
          nbrTimeSpan->color(FL_BACKGROUND2_COLOR);
          nbrTimeSpan->selection_color(FL_SELECTION_COLOR);
          nbrTimeSpan->labeltype(FL_NORMAL_LABEL);
          nbrTimeSpan->labelfont(0);
          nbrTimeSpan->labelsize(14);
          nbrTimeSpan->labelcolor(FL_FOREGROUND_COLOR);
          nbrTimeSpan->maximum(1440);
          nbrTimeSpan->step(1);
          nbrTimeSpan->value(120);
          nbrTimeSpan->callback((Fl_Callback*)cb_nbrTimeSpan);
          nbrTimeSpan->align(Fl_Align(FL_ALIGN_RIGHT));
          nbrTimeSpan->when(FL_WHEN_CHANGED);
          o->value(progdefaults.timespan);
        } // Fl_Value_Input2* nbrTimeSpan
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(204, 233, 590, 100, gettext("Contest Exchange / Serial #"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Input2* o = inpSend1 = new Fl_Input2(269, 257, 200, 24, gettext("Send"));
          inpSend1->tooltip(gettext("free form exchange"));
          inpSend1->box(FL_DOWN_BOX);
          inpSend1->color(FL_BACKGROUND2_COLOR);
          inpSend1->selection_color(FL_SELECTION_COLOR);
          inpSend1->labeltype(FL_NORMAL_LABEL);
          inpSend1->labelfont(0);
          inpSend1->labelsize(14);
          inpSend1->labelcolor(FL_FOREGROUND_COLOR);
          inpSend1->callback((Fl_Callback*)cb_inpSend1);
          inpSend1->align(Fl_Align(FL_ALIGN_LEFT));
          inpSend1->when(FL_WHEN_RELEASE);
          o->value(progdefaults.myXchg.c_str());
          inpSend1->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inpSend1
        { Fl_Check_Button* o = btn599 = new Fl_Check_Button(484, 259, 130, 20, gettext("RST always 599/59"));
          btn599->tooltip(gettext("Force RST in/out to 599/59"));
          btn599->down_box(FL_DOWN_BOX);
          btn599->callback((Fl_Callback*)cb_btn599);
          o->value(progdefaults.fixed599);
        } // Fl_Check_Button* btn599
        { Fl_Check_Button* o = btnCutNbrs = new Fl_Check_Button(644, 259, 139, 20, gettext("Send CW cut #\'s"));
          btnCutNbrs->tooltip(gettext("0 = T; 9 = N"));
          btnCutNbrs->down_box(FL_DOWN_BOX);
          btnCutNbrs->callback((Fl_Callback*)cb_btnCutNbrs);
          o->value(progdefaults.cutnbrs);
        } // Fl_Check_Button* btnCutNbrs
        { Fl_Group* o = new Fl_Group(211, 286, 576, 42);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Value_Input2* o = nbrContestStart = new Fl_Value_Input2(298, 295, 45, 24, gettext("Start Nbr"));
            nbrContestStart->tooltip(gettext("Starting number"));
            nbrContestStart->box(FL_DOWN_BOX);
            nbrContestStart->color(FL_BACKGROUND2_COLOR);
            nbrContestStart->selection_color(FL_SELECTION_COLOR);
            nbrContestStart->labeltype(FL_NORMAL_LABEL);
            nbrContestStart->labelfont(0);
            nbrContestStart->labelsize(14);
            nbrContestStart->labelcolor(FL_FOREGROUND_COLOR);
            nbrContestStart->maximum(10000);
            nbrContestStart->step(1);
            nbrContestStart->callback((Fl_Callback*)cb_nbrContestStart);
            nbrContestStart->align(Fl_Align(FL_ALIGN_LEFT));
            nbrContestStart->when(FL_WHEN_CHANGED);
            o->value(progdefaults.ContestStart);
          } // Fl_Value_Input2* nbrContestStart
          { nbrContestDigits = new Fl_Value_Input2(420, 295, 46, 24, gettext("Digits"));
            nbrContestDigits->tooltip(gettext("Number of digits in serial number"));
            nbrContestDigits->box(FL_DOWN_BOX);
            nbrContestDigits->color(FL_BACKGROUND2_COLOR);
            nbrContestDigits->selection_color(FL_SELECTION_COLOR);
            nbrContestDigits->labeltype(FL_NORMAL_LABEL);
            nbrContestDigits->labelfont(0);
            nbrContestDigits->labelsize(14);
            nbrContestDigits->labelcolor(FL_FOREGROUND_COLOR);
            nbrContestDigits->minimum(1);
            nbrContestDigits->maximum(5);
            nbrContestDigits->step(1);
            nbrContestDigits->value(3);
            nbrContestDigits->callback((Fl_Callback*)cb_nbrContestDigits);
            nbrContestDigits->align(Fl_Align(FL_ALIGN_LEFT));
            nbrContestDigits->when(FL_WHEN_CHANGED);
          } // Fl_Value_Input2* nbrContestDigits
          { btnUseLeadingZeros = new Fl_Check_Button(485, 297, 157, 20, gettext("Use leading zeros"));
            btnUseLeadingZeros->tooltip(gettext("Insert leading zeros into Xmtd serial number"));
            btnUseLeadingZeros->down_box(FL_DOWN_BOX);
            btnUseLeadingZeros->value(1);
            btnUseLeadingZeros->callback((Fl_Callback*)cb_btnUseLeadingZeros);
          } // Fl_Check_Button* btnUseLeadingZeros
          { btnResetSerNbr = new Fl_Button(682, 295, 71, 24, gettext("Reset"));
            btnResetSerNbr->tooltip(gettext("Initialize the QSO logging fields"));
            btnResetSerNbr->callback((Fl_Callback*)cb_btnResetSerNbr);
          } // Fl_Button* btnResetSerNbr
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Contests/General"));
      config_pages.push_back(p);
      tab_tree->add(_("Contests/General"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Contests/Field Day"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Input2* o = inp_my_FD_call = new Fl_Input2(346, 73, 80, 24, gettext("Operator Call"));
        inp_my_FD_call->tooltip(gettext("Field Day Callsign\nMay be same as OP callsign"));
        inp_my_FD_call->box(FL_DOWN_BOX);
        inp_my_FD_call->color(FL_BACKGROUND2_COLOR);
        inp_my_FD_call->selection_color(FL_SELECTION_COLOR);
        inp_my_FD_call->labeltype(FL_NORMAL_LABEL);
        inp_my_FD_call->labelfont(0);
        inp_my_FD_call->labelsize(14);
        inp_my_FD_call->labelcolor(FL_FOREGROUND_COLOR);
        inp_my_FD_call->callback((Fl_Callback*)cb_inp_my_FD_call);
        inp_my_FD_call->align(Fl_Align(FL_ALIGN_LEFT));
        inp_my_FD_call->when(FL_WHEN_RELEASE);
        o->value(progdefaults.fd_op_call.c_str());
        inpSend1->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inp_my_FD_call
      { Fl_Input2* o = inp_my_FD_section = new Fl_Input2(654, 73, 45, 24, gettext("My Section"));
        inp_my_FD_section->tooltip(gettext("Field Day Section"));
        inp_my_FD_section->box(FL_DOWN_BOX);
        inp_my_FD_section->color(FL_BACKGROUND2_COLOR);
        inp_my_FD_section->selection_color(FL_SELECTION_COLOR);
        inp_my_FD_section->labeltype(FL_NORMAL_LABEL);
        inp_my_FD_section->labelfont(0);
        inp_my_FD_section->labelsize(14);
        inp_my_FD_section->labelcolor(FL_FOREGROUND_COLOR);
        inp_my_FD_section->callback((Fl_Callback*)cb_inp_my_FD_section);
        inp_my_FD_section->align(Fl_Align(FL_ALIGN_LEFT));
        inp_my_FD_section->when(FL_WHEN_RELEASE);
        o->value(progdefaults.my_FD_section.c_str());
        inpSend1->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inp_my_FD_section
      { Fl_Input2* o = inp_my_FD_class = new Fl_Input2(507, 73, 50, 24, gettext("My Class"));
        inp_my_FD_class->tooltip(gettext("Field Day Class"));
        inp_my_FD_class->box(FL_DOWN_BOX);
        inp_my_FD_class->color(FL_BACKGROUND2_COLOR);
        inp_my_FD_class->selection_color(FL_SELECTION_COLOR);
        inp_my_FD_class->labeltype(FL_NORMAL_LABEL);
        inp_my_FD_class->labelfont(0);
        inp_my_FD_class->labelsize(14);
        inp_my_FD_class->labelcolor(FL_FOREGROUND_COLOR);
        inp_my_FD_class->callback((Fl_Callback*)cb_inp_my_FD_class);
        inp_my_FD_class->align(Fl_Align(FL_ALIGN_LEFT));
        inp_my_FD_class->when(FL_WHEN_RELEASE);
        o->value(progdefaults.my_FD_class.c_str());
        inpSend1->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inp_my_FD_class
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Contests/Field Day"));
      config_pages.push_back(p);
      tab_tree->add(_("Contests/Field Day"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Contests/JOTA School"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(211, 137, 580, 53, gettext("School Round Up"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Input2* o = inp_my_SCR_class = new Fl_Input2(397, 159, 69, 24, gettext("My Class"));
          inp_my_SCR_class->tooltip(gettext("School Round Up - allowable I, H, O - see rules"));
          inp_my_SCR_class->box(FL_DOWN_BOX);
          inp_my_SCR_class->color(FL_BACKGROUND2_COLOR);
          inp_my_SCR_class->selection_color(FL_SELECTION_COLOR);
          inp_my_SCR_class->labeltype(FL_NORMAL_LABEL);
          inp_my_SCR_class->labelfont(0);
          inp_my_SCR_class->labelsize(14);
          inp_my_SCR_class->labelcolor(FL_FOREGROUND_COLOR);
          inp_my_SCR_class->callback((Fl_Callback*)cb_inp_my_SCR_class);
          inp_my_SCR_class->align(Fl_Align(FL_ALIGN_LEFT));
          inp_my_SCR_class->when(FL_WHEN_RELEASE);
          o->value(progdefaults.my_SCR_class.c_str());
          inpSend1->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inp_my_SCR_class
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(211, 44, 580, 89, gettext("Jamboree OTA"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Input2* o = inp_my_JOTA_troop = new Fl_Input2(396, 67, 200, 24, gettext("My Troop"));
          inp_my_JOTA_troop->tooltip(gettext("My JOTA Troop"));
          inp_my_JOTA_troop->box(FL_DOWN_BOX);
          inp_my_JOTA_troop->color(FL_BACKGROUND2_COLOR);
          inp_my_JOTA_troop->selection_color(FL_SELECTION_COLOR);
          inp_my_JOTA_troop->labeltype(FL_NORMAL_LABEL);
          inp_my_JOTA_troop->labelfont(0);
          inp_my_JOTA_troop->labelsize(14);
          inp_my_JOTA_troop->labelcolor(FL_FOREGROUND_COLOR);
          inp_my_JOTA_troop->callback((Fl_Callback*)cb_inp_my_JOTA_troop);
          inp_my_JOTA_troop->align(Fl_Align(FL_ALIGN_LEFT));
          inp_my_JOTA_troop->when(FL_WHEN_RELEASE);
          o->value(progdefaults.my_JOTA_troop.c_str());
          inpSend1->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inp_my_JOTA_troop
        { Fl_Input2* o = inp_my_JOTA_scout = new Fl_Input2(396, 98, 200, 24, gettext("Scout Op\'"));
          inp_my_JOTA_scout->tooltip(gettext("Scout Operator Name"));
          inp_my_JOTA_scout->box(FL_DOWN_BOX);
          inp_my_JOTA_scout->color(FL_BACKGROUND2_COLOR);
          inp_my_JOTA_scout->selection_color(FL_SELECTION_COLOR);
          inp_my_JOTA_scout->labeltype(FL_NORMAL_LABEL);
          inp_my_JOTA_scout->labelfont(0);
          inp_my_JOTA_scout->labelsize(14);
          inp_my_JOTA_scout->labelcolor(FL_FOREGROUND_COLOR);
          inp_my_JOTA_scout->callback((Fl_Callback*)cb_inp_my_JOTA_scout);
          inp_my_JOTA_scout->align(Fl_Align(FL_ALIGN_LEFT));
          inp_my_JOTA_scout->when(FL_WHEN_RELEASE);
          o->value(progdefaults.my_JOTA_scout.c_str());
          inpSend1->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inp_my_JOTA_scout
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Contests/JOTA School"));
      config_pages.push_back(p);
      tab_tree->add(_("Contests/JOTA School"));
      tab_tree->close(_("Contests"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("IDs/CW"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { sld = new Fl_Group(234, 83, 536, 127, gettext("CW Postamble ID"));
        sld->box(FL_ENGRAVED_FRAME);
        sld->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnCWID = new Fl_Check_Button(287, 121, 140, 24, gettext("Transmit callsign"));
          btnCWID->tooltip(gettext("Send Callsign in CW at end of every transmission"));
          btnCWID->down_box(FL_DOWN_BOX);
          btnCWID->callback((Fl_Callback*)cb_btnCWID);
          o->value(progdefaults.CWid);
        } // Fl_Check_Button* btnCWID
        { Fl_Value_Slider2* o = sldrCWIDwpm = new Fl_Value_Slider2(287, 164, 180, 20, gettext("Speed (WPM):"));
          sldrCWIDwpm->tooltip(gettext("Send at this WPM"));
          sldrCWIDwpm->type(1);
          sldrCWIDwpm->box(FL_DOWN_BOX);
          sldrCWIDwpm->color(FL_BACKGROUND_COLOR);
          sldrCWIDwpm->selection_color(FL_BACKGROUND_COLOR);
          sldrCWIDwpm->labeltype(FL_NORMAL_LABEL);
          sldrCWIDwpm->labelfont(0);
          sldrCWIDwpm->labelsize(14);
          sldrCWIDwpm->labelcolor(FL_FOREGROUND_COLOR);
          sldrCWIDwpm->minimum(15);
          sldrCWIDwpm->maximum(40);
          sldrCWIDwpm->step(1);
          sldrCWIDwpm->value(18);
          sldrCWIDwpm->textsize(14);
          sldrCWIDwpm->callback((Fl_Callback*)cb_sldrCWIDwpm);
          sldrCWIDwpm->align(Fl_Align(FL_ALIGN_TOP));
          sldrCWIDwpm->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWIDwpm);
          o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
        } // Fl_Value_Slider2* sldrCWIDwpm
        { bCWIDModes = new Fl_Button(485, 121, 120, 24, gettext("CW ID modes"));
          bCWIDModes->callback((Fl_Callback*)cb_bCWIDModes);
        } // Fl_Button* bCWIDModes
        sld->end();
      } // Fl_Group* sld
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("IDs/CW"));
      config_pages.push_back(p);
      tab_tree->add(_("IDs/CW"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("IDs/RsID"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(216, 20, 560, 220, gettext("Reed-Solomon ID (Rx)"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { chkRSidNotifyOnly = new Fl_Check_Button(241, 87, 168, 20, gettext("Notify only"));
          chkRSidNotifyOnly->tooltip(gettext("Check this to be notified when an RSID is received\nwithout changing modem an"
"d frequency"));
          chkRSidNotifyOnly->down_box(FL_DOWN_BOX);
          chkRSidNotifyOnly->callback((Fl_Callback*)cb_chkRSidNotifyOnly);
          chkRSidNotifyOnly->value(progdefaults.rsid_notify_only);
        } // Fl_Check_Button* chkRSidNotifyOnly
        { bRSIDRxModes = new Fl_Button(224, 46, 87, 24, gettext("Rx modes"));
          bRSIDRxModes->callback((Fl_Callback*)cb_bRSIDRxModes);
        } // Fl_Button* bRSIDRxModes
        { chkRSidMark = new Fl_Check_Button(241, 147, 203, 20, gettext("Mark prev freq/mode"));
          chkRSidMark->tooltip(gettext("Insert RX text marker before\nchanging frequency and modem"));
          chkRSidMark->down_box(FL_DOWN_BOX);
          chkRSidMark->callback((Fl_Callback*)cb_chkRSidMark);
          chkRSidMark->value(progdefaults.rsid_mark);
        } // Fl_Check_Button* chkRSidMark
        { Fl_ListBox* o = listbox_rsid_errors = new Fl_ListBox(224, 208, 100, 22, gettext("Allow errors"));
          listbox_rsid_errors->tooltip(gettext("Low = zero errors\nMedium = 1 error\nHigh = 2 errors"));
          listbox_rsid_errors->box(FL_DOWN_BOX);
          listbox_rsid_errors->color(FL_BACKGROUND2_COLOR);
          listbox_rsid_errors->selection_color(FL_BACKGROUND_COLOR);
          listbox_rsid_errors->labeltype(FL_NORMAL_LABEL);
          listbox_rsid_errors->labelfont(0);
          listbox_rsid_errors->labelsize(14);
          listbox_rsid_errors->labelcolor(FL_FOREGROUND_COLOR);
          listbox_rsid_errors->callback((Fl_Callback*)cb_listbox_rsid_errors);
          listbox_rsid_errors->align(Fl_Align(FL_ALIGN_RIGHT));
          listbox_rsid_errors->when(FL_WHEN_RELEASE);
          listbox_rsid_errors->add(_("Low")); listbox_rsid_errors->add(_("Medium")); listbox_rsid_errors->add(_("High"));
          listbox_rsid_errors->index(progdefaults.RsID_label_type);
          o->labelsize(FL_NORMAL_SIZE);
          listbox_rsid_errors->end();
        } // Fl_ListBox* listbox_rsid_errors
        { Fl_Check_Button* o = chkRSidShowAlert = new Fl_Check_Button(464, 87, 203, 20, gettext("Disable alert dialog"));
          chkRSidShowAlert->tooltip(gettext("Do not show RsID alert dialog box"));
          chkRSidShowAlert->down_box(FL_DOWN_BOX);
          chkRSidShowAlert->callback((Fl_Callback*)cb_chkRSidShowAlert);
          o->value(progdefaults.disable_rsid_warning_dialog_box);
        } // Fl_Check_Button* chkRSidShowAlert
        { chkRSidAutoDisable = new Fl_Check_Button(464, 113, 203, 20, gettext("Disables detector"));
          chkRSidAutoDisable->tooltip(gettext("Disable further detection when RSID is received"));
          chkRSidAutoDisable->down_box(FL_DOWN_BOX);
          chkRSidAutoDisable->callback((Fl_Callback*)cb_chkRSidAutoDisable);
          if (progdefaults.rsid_notify_only) progdefaults.rsid_auto_disable = false;
          chkRSidAutoDisable->value(progdefaults.rsid_auto_disable);
          if (progdefaults.rsid_notify_only) chkRSidAutoDisable->deactivate();
        } // Fl_Check_Button* chkRSidAutoDisable
        { Fl_Check_Button* o = chkRetainFreqLock = new Fl_Check_Button(241, 117, 203, 20, gettext("Retain tx freq lock"));
          chkRetainFreqLock->tooltip(gettext("Retain TX lock frequency (Lk) when changing to RX RsID frequency"));
          chkRetainFreqLock->down_box(FL_DOWN_BOX);
          chkRetainFreqLock->callback((Fl_Callback*)cb_chkRetainFreqLock);
          o->value(progdefaults.retain_freq_lock);
        } // Fl_Check_Button* chkRetainFreqLock
        { Fl_Check_Button* o = chkDisableFreqChange = new Fl_Check_Button(464, 147, 203, 20, gettext("Disable freq change"));
          chkDisableFreqChange->tooltip(gettext("Do not automatically change to RX RsID frequency"));
          chkDisableFreqChange->down_box(FL_DOWN_BOX);
          chkDisableFreqChange->callback((Fl_Callback*)cb_chkDisableFreqChange);
          o->value(progdefaults.disable_rsid_freq_change);
        } // Fl_Check_Button* chkDisableFreqChange
        { Fl_Check_Button* o = chk_RSID_EOT = new Fl_Check_Button(464, 177, 232, 20, gettext("Rx/Tx RsID EOT"));
          chk_RSID_EOT->tooltip(gettext("Do not automatically change to RX RsID frequency"));
          chk_RSID_EOT->down_box(FL_DOWN_BOX);
          chk_RSID_EOT->callback((Fl_Callback*)cb_chk_RSID_EOT);
          o->value(progdefaults.rsid_eot_squelch);
        } // Fl_Check_Button* chk_RSID_EOT
        { Fl_Counter* o = val_RSIDsquelch = new Fl_Counter(444, 208, 140, 21, gettext("Squelch open (sec)"));
          val_RSIDsquelch->tooltip(gettext("Use for triggering amplifier carrier detect"));
          val_RSIDsquelch->minimum(0);
          val_RSIDsquelch->maximum(300);
          val_RSIDsquelch->step(1);
          val_RSIDsquelch->callback((Fl_Callback*)cb_val_RSIDsquelch);
          val_RSIDsquelch->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.rsid_squelch);
          o->lstep(10.0);
        } // Fl_Counter* val_RSIDsquelch
        { Fl_Group* o = new Fl_Group(336, 43, 406, 38, gettext("The RsID notification message contents and display\ncharacteristics are confi"
"gured on the \"Notifications\" tab."));
          o->box(FL_BORDER_BOX);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(216, 243, 180, 100, gettext("Pre-Signal Tone"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = val_pretone = new Fl_Counter(228, 281, 120, 21, gettext("Seconds"));
          val_pretone->tooltip(gettext("Use for triggering amplifier carrier detect"));
          val_pretone->minimum(0);
          val_pretone->maximum(10);
          val_pretone->callback((Fl_Callback*)cb_val_pretone);
          o->value(progdefaults.pretone);
        } // Fl_Counter* val_pretone
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(406, 243, 180, 100, gettext("Reed-Solomon ID (Tx)"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { bRSIDTxModes = new Fl_Button(412, 269, 130, 26, gettext("Transmit modes"));
          bRSIDTxModes->callback((Fl_Callback*)cb_bRSIDTxModes);
        } // Fl_Button* bRSIDTxModes
        { Fl_Check_Button* o = btn_post_rsid = new Fl_Check_Button(426, 306, 97, 18, gettext("End of xmt ID"));
          btn_post_rsid->tooltip(gettext("Add RsID signal to end of transmission"));
          btn_post_rsid->down_box(FL_DOWN_BOX);
          btn_post_rsid->callback((Fl_Callback*)cb_btn_post_rsid);
          o->value(progdefaults.rsid_post);
        } // Fl_Check_Button* btn_post_rsid
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(596, 243, 180, 100, gettext("Min BW Detection"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = val_rsid_min_bw = new Fl_Counter(635, 271, 100, 21, gettext("Hertz"));
          val_rsid_min_bw->tooltip(gettext("Minimum bandwidth"));
          val_rsid_min_bw->type(1);
          val_rsid_min_bw->minimum(180);
          val_rsid_min_bw->maximum(1000);
          val_rsid_min_bw->step(10);
          val_rsid_min_bw->value(200);
          val_rsid_min_bw->callback((Fl_Callback*)cb_val_rsid_min_bw);
          o->value(progdefaults.rsid_min_bw);
        } // Fl_Counter* val_rsid_min_bw
        { Fl_Check_Button* o = chkRSidWideSearch = new Fl_Check_Button(601, 316, 93, 20, gettext("Passband"));
          chkRSidWideSearch->tooltip(gettext("ON - search over entire waterfall\nOFF - limit search to BW selector"));
          chkRSidWideSearch->down_box(FL_DOWN_BOX);
          chkRSidWideSearch->callback((Fl_Callback*)cb_chkRSidWideSearch);
          o->value(progdefaults.rsidWideSearch);
        } // Fl_Check_Button* chkRSidWideSearch
        { btn_rsid_default_bw = new Fl_Button(696, 315, 70, 20, gettext("Default"));
          btn_rsid_default_bw->callback((Fl_Callback*)cb_btn_rsid_default_bw);
        } // Fl_Button* btn_rsid_default_bw
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("IDs/RsID"));
      config_pages.push_back(p);
      tab_tree->add(_("IDs/RsID"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("IDs/Video"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(237, 47, 536, 189, gettext("Video Preamble ID"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btnsendid = new Fl_Check_Button(255, 81, 150, 20, gettext("Transmit mode ID"));
          btnsendid->tooltip(gettext("Waterfall video ID"));
          btnsendid->down_box(FL_DOWN_BOX);
          btnsendid->callback((Fl_Callback*)cb_btnsendid);
        } // Fl_Check_Button* btnsendid
        { Fl_Check_Button* o = btnsendvideotext = new Fl_Check_Button(255, 113, 155, 20, gettext("Transmit video text"));
          btnsendvideotext->tooltip(gettext("Waterfall video text"));
          btnsendvideotext->down_box(FL_DOWN_BOX);
          btnsendvideotext->callback((Fl_Callback*)cb_btnsendvideotext);
          o->value(progdefaults.sendtextid);
        } // Fl_Check_Button* btnsendvideotext
        { Fl_Input2* o = valVideotext = new Fl_Input2(422, 111, 323, 24, gettext(":"));
          valVideotext->tooltip(gettext("Limit to a few characters,\nas in CQEM or IOTA etc."));
          valVideotext->box(FL_DOWN_BOX);
          valVideotext->color(FL_BACKGROUND2_COLOR);
          valVideotext->selection_color(FL_SELECTION_COLOR);
          valVideotext->labeltype(FL_NORMAL_LABEL);
          valVideotext->labelfont(0);
          valVideotext->labelsize(14);
          valVideotext->labelcolor(FL_FOREGROUND_COLOR);
          valVideotext->callback((Fl_Callback*)cb_valVideotext);
          valVideotext->align(Fl_Align(FL_ALIGN_LEFT));
          valVideotext->when(FL_WHEN_RELEASE);
          o->value(progdefaults.strTextid.c_str());
          valVideotext->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* valVideotext
        { Fl_Check_Button* o = chkID_SMALL = new Fl_Check_Button(255, 145, 120, 20, gettext("Use small font"));
          chkID_SMALL->tooltip(gettext("ON - small font\nOFF - large font"));
          chkID_SMALL->down_box(FL_DOWN_BOX);
          chkID_SMALL->value(1);
          chkID_SMALL->callback((Fl_Callback*)cb_chkID_SMALL);
          o->value(progdefaults.ID_SMALL);
        } // Fl_Check_Button* chkID_SMALL
        { Fl_Value_Slider2* o = sldrVideowidth = new Fl_Value_Slider2(495, 143, 125, 24, gettext("Chars/Row:"));
          sldrVideowidth->tooltip(gettext("Set the number of characters per row"));
          sldrVideowidth->type(1);
          sldrVideowidth->box(FL_DOWN_BOX);
          sldrVideowidth->color(FL_BACKGROUND_COLOR);
          sldrVideowidth->selection_color(FL_BACKGROUND_COLOR);
          sldrVideowidth->labeltype(FL_NORMAL_LABEL);
          sldrVideowidth->labelfont(0);
          sldrVideowidth->labelsize(14);
          sldrVideowidth->labelcolor(FL_FOREGROUND_COLOR);
          sldrVideowidth->minimum(1);
          sldrVideowidth->maximum(8);
          sldrVideowidth->step(1);
          sldrVideowidth->value(4);
          sldrVideowidth->textsize(14);
          sldrVideowidth->callback((Fl_Callback*)cb_sldrVideowidth);
          sldrVideowidth->align(Fl_Align(FL_ALIGN_LEFT));
          sldrVideowidth->when(FL_WHEN_CHANGED);
          o->value(progdefaults.videowidth);
          o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
        } // Fl_Value_Slider2* sldrVideowidth
        { Fl_Check_Button* o = btn_vidlimit = new Fl_Check_Button(255, 177, 110, 15, gettext("500 Hz limit"));
          btn_vidlimit->down_box(FL_DOWN_BOX);
          btn_vidlimit->callback((Fl_Callback*)cb_btn_vidlimit);
          o->value(progdefaults.vidlimit);
        } // Fl_Check_Button* btn_vidlimit
        { Fl_Check_Button* o = btn_vidmodelimit = new Fl_Check_Button(255, 205, 110, 15, gettext("Mode width limit"));
          btn_vidmodelimit->down_box(FL_DOWN_BOX);
          btn_vidmodelimit->callback((Fl_Callback*)cb_btn_vidmodelimit);
          o->value(progdefaults.vidmodelimit);
        } // Fl_Check_Button* btn_vidmodelimit
        { bVideoIDModes = new Fl_Button(625, 78, 120, 24, gettext("Video ID modes"));
          bVideoIDModes->callback((Fl_Callback*)cb_bVideoIDModes);
        } // Fl_Button* bVideoIDModes
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("IDs/Video"));
      config_pages.push_back(p);
      tab_tree->add(_("IDs/Video"));
      tab_tree->close(_("IDs"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Logging/MacLogger"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Check_Button* o = btnConnectToMaclogger = new Fl_Check_Button(211, 35, 186, 20, gettext("Connect to MacLogger"));
        btnConnectToMaclogger->down_box(FL_DOWN_BOX);
        btnConnectToMaclogger->callback((Fl_Callback*)cb_btnConnectToMaclogger);
        o->value(progdefaults.connect_to_maclogger);
      } // Fl_Check_Button* btnConnectToMaclogger
      { Fl_Check_Button* o = btn_capture_maclogger_radio = new Fl_Check_Button(406, 35, 186, 20, gettext("Capture Radio Report"));
        btn_capture_maclogger_radio->down_box(FL_DOWN_BOX);
        btn_capture_maclogger_radio->value(1);
        btn_capture_maclogger_radio->callback((Fl_Callback*)cb_btn_capture_maclogger_radio);
        o->value(progdefaults.capture_maclogger_radio);
      } // Fl_Check_Button* btn_capture_maclogger_radio
      { Fl_Check_Button* o = btn_capture_maclogger_log = new Fl_Check_Button(406, 60, 186, 21, gettext("Capture Log Report"));
        btn_capture_maclogger_log->down_box(FL_DOWN_BOX);
        btn_capture_maclogger_log->callback((Fl_Callback*)cb_btn_capture_maclogger_log);
        o->value(progdefaults.capture_maclogger_log);
      } // Fl_Check_Button* btn_capture_maclogger_log
      { Fl_Check_Button* o = btn_capture_maclogger_lookup = new Fl_Check_Button(606, 35, 186, 20, gettext("Capture Lookup "));
        btn_capture_maclogger_lookup->down_box(FL_DOWN_BOX);
        btn_capture_maclogger_lookup->callback((Fl_Callback*)cb_btn_capture_maclogger_lookup);
        o->value(progdefaults.capture_maclogger_lookup);
      } // Fl_Check_Button* btn_capture_maclogger_lookup
      { Fl_Check_Button* o = btn_capture_maclogger_spot_tune = new Fl_Check_Button(606, 60, 186, 21, gettext("Capture Spot Tune"));
        btn_capture_maclogger_spot_tune->down_box(FL_DOWN_BOX);
        btn_capture_maclogger_spot_tune->callback((Fl_Callback*)cb_btn_capture_maclogger_spot_tune);
        o->value(progdefaults.capture_maclogger_spot_tune);
      } // Fl_Check_Button* btn_capture_maclogger_spot_tune
      { Fl_Check_Button* o = btn_capture_maclogger_spot_report = new Fl_Check_Button(606, 88, 186, 21, gettext("Capture Spot Report"));
        btn_capture_maclogger_spot_report->down_box(FL_DOWN_BOX);
        btn_capture_maclogger_spot_report->callback((Fl_Callback*)cb_btn_capture_maclogger_spot_report);
        o->value(progdefaults.capture_maclogger_spot_report);
      } // Fl_Check_Button* btn_capture_maclogger_spot_report
      { Fl_Check_Button* o = btn_enable_maclogger_log = new Fl_Check_Button(211, 117, 165, 26, gettext("Enable UDP log file"));
        btn_enable_maclogger_log->down_box(FL_DOWN_BOX);
        btn_enable_maclogger_log->callback((Fl_Callback*)cb_btn_enable_maclogger_log);
        o->value(progdefaults.enable_maclogger_log);
      } // Fl_Check_Button* btn_enable_maclogger_log
      { Fl_Text_Display* o = txt_UDP_data = new Fl_Text_Display(210, 164, 580, 161, gettext("UDP data stream"));
        txt_UDP_data->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        Fl_Text_Buffer *txtbuffer = new Fl_Text_Buffer();
        o->buffer(txtbuffer);
      } // Fl_Text_Display* txt_UDP_data
      { Fl_Output* o = txt_maclogger_log_filename = new Fl_Output(379, 117, 272, 26);
        o->value(progdefaults.maclogger_log_filename.c_str());
      } // Fl_Output* txt_maclogger_log_filename
      { Fl_Button* o = new Fl_Button(661, 117, 129, 26, gettext("Clear UDP text"));
        o->callback((Fl_Callback*)cb_Clear);
      } // Fl_Button* o
      { Fl_Check_Button* o = btn_maclogger_spot_rx = new Fl_Check_Button(406, 88, 186, 21, gettext("Tune to Rx Spot"));
        btn_maclogger_spot_rx->tooltip(gettext("ON - use Rx spot freq\nOFF - use Tx spot freq"));
        btn_maclogger_spot_rx->down_box(FL_DOWN_BOX);
        btn_maclogger_spot_rx->callback((Fl_Callback*)cb_btn_maclogger_spot_rx);
        o->value(progdefaults.maclogger_spot_rx);
      } // Fl_Check_Button* btn_maclogger_spot_rx
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Logging/MacLogger"));
      config_pages.push_back(p);
      tab_tree->add(_("Logging/MacLogger"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Logging/N3FJP logs"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Text_Display* o = txt_N3FJP_data = new Fl_Text_Display(205, 94, 590, 150, gettext("TCP/IP Data Stream"));
        txt_N3FJP_data->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        Fl_Text_Buffer *txtbuffer = new Fl_Text_Buffer();
        o->buffer(txtbuffer);
      } // Fl_Text_Display* txt_N3FJP_data
      { Fl_Button* o = new Fl_Button(701, 247, 90, 24, gettext("Clear text"));
        o->callback((Fl_Callback*)cb_Clear1);
      } // Fl_Button* o
      { Fl_Input2* o = txt_N3FJP_ip_address = new Fl_Input2(205, 49, 350, 25, gettext("Address"));
        txt_N3FJP_ip_address->tooltip(gettext("N3FJP Server IP Address"));
        txt_N3FJP_ip_address->box(FL_DOWN_BOX);
        txt_N3FJP_ip_address->color(FL_BACKGROUND2_COLOR);
        txt_N3FJP_ip_address->selection_color(FL_SELECTION_COLOR);
        txt_N3FJP_ip_address->labeltype(FL_NORMAL_LABEL);
        txt_N3FJP_ip_address->labelfont(0);
        txt_N3FJP_ip_address->labelsize(14);
        txt_N3FJP_ip_address->labelcolor(FL_FOREGROUND_COLOR);
        txt_N3FJP_ip_address->callback((Fl_Callback*)cb_txt_N3FJP_ip_address);
        txt_N3FJP_ip_address->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        txt_N3FJP_ip_address->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
        o->value(progdefaults.N3FJP_address.c_str());
      } // Fl_Input2* txt_N3FJP_ip_address
      { Fl_Input2* o = txt_N3FJP_ip_port_no = new Fl_Input2(565, 49, 55, 25, gettext("Port"));
        txt_N3FJP_ip_port_no->tooltip(gettext("N3FJP Server IP Port"));
        txt_N3FJP_ip_port_no->box(FL_DOWN_BOX);
        txt_N3FJP_ip_port_no->color(FL_BACKGROUND2_COLOR);
        txt_N3FJP_ip_port_no->selection_color(FL_SELECTION_COLOR);
        txt_N3FJP_ip_port_no->labeltype(FL_NORMAL_LABEL);
        txt_N3FJP_ip_port_no->labelfont(0);
        txt_N3FJP_ip_port_no->labelsize(14);
        txt_N3FJP_ip_port_no->labelcolor(FL_FOREGROUND_COLOR);
        txt_N3FJP_ip_port_no->callback((Fl_Callback*)cb_txt_N3FJP_ip_port_no);
        txt_N3FJP_ip_port_no->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        txt_N3FJP_ip_port_no->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
        o->value(progdefaults.N3FJP_port.c_str());
      } // Fl_Input2* txt_N3FJP_ip_port_no
      { btn_default_N3FJP_ip = new Fl_Button(623, 49, 67, 25, gettext("Default"));
        btn_default_N3FJP_ip->tooltip(gettext("Returns IP Address and port\nnumber to the default value."));
        btn_default_N3FJP_ip->callback((Fl_Callback*)cb_btn_default_N3FJP_ip);
      } // Fl_Button* btn_default_N3FJP_ip
      { Fl_Check_Button* o = btn_enable_N3FJP_log = new Fl_Check_Button(210, 246, 165, 26, gettext("Enable Data Stream"));
        btn_enable_N3FJP_log->down_box(FL_DOWN_BOX);
        btn_enable_N3FJP_log->callback((Fl_Callback*)cb_btn_enable_N3FJP_log);
        o->value(progdefaults.enable_N3FJP_log);
      } // Fl_Check_Button* btn_enable_N3FJP_log
      { Fl_Check_Button* o = btn_connect_to_n3fjp = new Fl_Check_Button(695, 39, 70, 15, gettext("Connect"));
        btn_connect_to_n3fjp->down_box(FL_DOWN_BOX);
        btn_connect_to_n3fjp->callback((Fl_Callback*)cb_btn_connect_to_n3fjp);
        o->value(progdefaults.connect_to_n3fjp);
      } // Fl_Check_Button* btn_connect_to_n3fjp
      { box_n3fjp_connected = new Fl_Box(695, 66, 16, 16, gettext("Connected"));
        box_n3fjp_connected->box(FL_DIAMOND_DOWN_BOX);
        box_n3fjp_connected->color(FL_LIGHT2);
        box_n3fjp_connected->selection_color((Fl_Color)58);
        box_n3fjp_connected->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Box* box_n3fjp_connected
      { Fl_Check_Button* o = btn_N3FJP_sweet_spot = new Fl_Check_Button(210, 299, 255, 26, gettext("Center DXspot freq at sweet spot"));
        btn_N3FJP_sweet_spot->tooltip(gettext("N3FJP DX spots centered on mode sweet spot"));
        btn_N3FJP_sweet_spot->down_box(FL_DOWN_BOX);
        btn_N3FJP_sweet_spot->callback((Fl_Callback*)cb_btn_N3FJP_sweet_spot);
        o->value(progdefaults.N3FJP_sweet_spot);
      } // Fl_Check_Button* btn_N3FJP_sweet_spot
      { Fl_Check_Button* o = btn_N3FJP_modem_carrier = new Fl_Check_Button(475, 299, 255, 26, gettext("Report actual modem RF frequency"));
        btn_N3FJP_modem_carrier->tooltip(gettext("Suppressed carrier +/- AF injection frequency"));
        btn_N3FJP_modem_carrier->down_box(FL_DOWN_BOX);
        btn_N3FJP_modem_carrier->callback((Fl_Callback*)cb_btn_N3FJP_modem_carrier);
        o->value(progdefaults.N3FJP_modem_carrier);
      } // Fl_Check_Button* btn_N3FJP_modem_carrier
      { Fl_Check_Button* o = btn_enable_N3FJP_RIGTX = new Fl_Check_Button(210, 273, 165, 26, gettext("PTT via <RIGTX> and <RIGRX>"));
        btn_enable_N3FJP_RIGTX->down_box(FL_DOWN_BOX);
        btn_enable_N3FJP_RIGTX->callback((Fl_Callback*)cb_btn_enable_N3FJP_RIGTX);
        o->value(progdefaults.enable_N3FJP_RIGTX);
      } // Fl_Check_Button* btn_enable_N3FJP_RIGTX
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Logging/N3FJP logs"));
      config_pages.push_back(p);
      tab_tree->add(_("Logging/N3FJP logs"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Logging/eQSL"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Input2* o = inpEQSL_www_url = new Fl_Input2(355, 20, 390, 22, gettext("www url"));
        inpEQSL_www_url->tooltip(gettext("Your login name"));
        inpEQSL_www_url->box(FL_DOWN_BOX);
        inpEQSL_www_url->color(FL_BACKGROUND2_COLOR);
        inpEQSL_www_url->selection_color(FL_SELECTION_COLOR);
        inpEQSL_www_url->labeltype(FL_NORMAL_LABEL);
        inpEQSL_www_url->labelfont(0);
        inpEQSL_www_url->labelsize(14);
        inpEQSL_www_url->labelcolor(FL_FOREGROUND_COLOR);
        inpEQSL_www_url->callback((Fl_Callback*)cb_inpEQSL_www_url);
        inpEQSL_www_url->align(Fl_Align(FL_ALIGN_LEFT));
        inpEQSL_www_url->when(FL_WHEN_RELEASE);
        o->value(progdefaults.eqsl_www_url.c_str());
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpEQSL_www_url
      { Fl_Input2* o = inpEQSL_id = new Fl_Input2(354, 43, 150, 22, gettext("User ID"));
        inpEQSL_id->tooltip(gettext("Your login name"));
        inpEQSL_id->box(FL_DOWN_BOX);
        inpEQSL_id->color(FL_BACKGROUND2_COLOR);
        inpEQSL_id->selection_color(FL_SELECTION_COLOR);
        inpEQSL_id->labeltype(FL_NORMAL_LABEL);
        inpEQSL_id->labelfont(0);
        inpEQSL_id->labelsize(14);
        inpEQSL_id->labelcolor(FL_FOREGROUND_COLOR);
        inpEQSL_id->callback((Fl_Callback*)cb_inpEQSL_id);
        inpEQSL_id->align(Fl_Align(FL_ALIGN_LEFT));
        inpEQSL_id->when(FL_WHEN_RELEASE);
        o->value(progdefaults.eqsl_id.c_str());
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpEQSL_id
      { Fl_Input2* o = inpEQSL_pwd = new Fl_Input2(354, 66, 150, 22, gettext("Password"));
        inpEQSL_pwd->tooltip(gettext("Your login password"));
        inpEQSL_pwd->box(FL_DOWN_BOX);
        inpEQSL_pwd->color(FL_BACKGROUND2_COLOR);
        inpEQSL_pwd->selection_color(FL_SELECTION_COLOR);
        inpEQSL_pwd->labeltype(FL_NORMAL_LABEL);
        inpEQSL_pwd->labelfont(0);
        inpEQSL_pwd->labelsize(14);
        inpEQSL_pwd->labelcolor(FL_FOREGROUND_COLOR);
        inpEQSL_pwd->callback((Fl_Callback*)cb_inpEQSL_pwd);
        inpEQSL_pwd->align(Fl_Align(FL_ALIGN_LEFT));
        inpEQSL_pwd->when(FL_WHEN_RELEASE);
        o->value(progdefaults.eqsl_pwd.c_str());
        o->type(FL_SECRET_INPUT);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpEQSL_pwd
      { btnEQSL_pwd_show = new Fl_Button(510, 66, 70, 22, gettext("Show"));
        btnEQSL_pwd_show->tooltip(gettext("Show password in plain text"));
        btnEQSL_pwd_show->callback((Fl_Callback*)cb_btnEQSL_pwd_show);
      } // Fl_Button* btnEQSL_pwd_show
      { Fl_Input2* o = inpEQSL_nick = new Fl_Input2(354, 90, 150, 22, gettext("QTH Nickname"));
        inpEQSL_nick->tooltip(gettext("Your login name"));
        inpEQSL_nick->box(FL_DOWN_BOX);
        inpEQSL_nick->color(FL_BACKGROUND2_COLOR);
        inpEQSL_nick->selection_color(FL_SELECTION_COLOR);
        inpEQSL_nick->labeltype(FL_NORMAL_LABEL);
        inpEQSL_nick->labelfont(0);
        inpEQSL_nick->labelsize(14);
        inpEQSL_nick->labelcolor(FL_FOREGROUND_COLOR);
        inpEQSL_nick->callback((Fl_Callback*)cb_inpEQSL_nick);
        inpEQSL_nick->align(Fl_Align(FL_ALIGN_LEFT));
        inpEQSL_nick->when(FL_WHEN_RELEASE);
        o->value(progdefaults.eqsl_nick.c_str());
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpEQSL_nick
      { btn_verify_eqsl = new Fl_Button(675, 90, 70, 22, gettext("Verify"));
        btn_verify_eqsl->tooltip(gettext("Verify database with eQSL download file"));
        btn_verify_eqsl->callback((Fl_Callback*)cb_btn_verify_eqsl);
      } // Fl_Button* btn_verify_eqsl
      { Fl_Group* o = new Fl_Group(242, 118, 516, 223, gettext("Options"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_send_when_logged = new Fl_Check_Button(326, 127, 70, 15, gettext("send when logged (log button, <LOG>, <LNW>)"));
          btn_send_when_logged->tooltip(gettext("automatic data upload"));
          btn_send_when_logged->down_box(FL_DOWN_BOX);
          btn_send_when_logged->callback((Fl_Callback*)cb_btn_send_when_logged);
          o->value(progdefaults.eqsl_when_logged);
        } // Fl_Check_Button* btn_send_when_logged
        { Fl_Check_Button* o = btn_send_datetime_off = new Fl_Check_Button(326, 147, 70, 15, gettext("Use date/time off for log entry"));
          btn_send_datetime_off->tooltip(gettext("default uses date/time on"));
          btn_send_datetime_off->down_box(FL_DOWN_BOX);
          btn_send_datetime_off->callback((Fl_Callback*)cb_btn_send_datetime_off);
          o->value(progdefaults.eqsl_datetime_off);
        } // Fl_Check_Button* btn_send_datetime_off
        { Fl_Check_Button* o = btn_show_eqsl_delivery = new Fl_Check_Button(326, 167, 70, 15, gettext("Show delivery message"));
          btn_show_eqsl_delivery->tooltip(gettext("Display timed delivery message if enabled"));
          btn_show_eqsl_delivery->down_box(FL_DOWN_BOX);
          btn_show_eqsl_delivery->callback((Fl_Callback*)cb_btn_show_eqsl_delivery);
          o->value(progdefaults.eqsl_show_delivery);
        } // Fl_Check_Button* btn_show_eqsl_delivery
        { Fl_Input2* o = txt_eqsl_default_message = new Fl_Input2(295, 208, 451, 40, gettext("Default message"));
          txt_eqsl_default_message->tooltip(gettext("default text to send with <LOG> etc"));
          txt_eqsl_default_message->type(4);
          txt_eqsl_default_message->box(FL_DOWN_BOX);
          txt_eqsl_default_message->color(FL_BACKGROUND2_COLOR);
          txt_eqsl_default_message->selection_color(FL_SELECTION_COLOR);
          txt_eqsl_default_message->labeltype(FL_NORMAL_LABEL);
          txt_eqsl_default_message->labelfont(0);
          txt_eqsl_default_message->labelsize(14);
          txt_eqsl_default_message->labelcolor(FL_FOREGROUND_COLOR);
          txt_eqsl_default_message->callback((Fl_Callback*)cb_txt_eqsl_default_message);
          txt_eqsl_default_message->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          txt_eqsl_default_message->when(FL_WHEN_CHANGED);
          o->value(progdefaults.eqsl_default_message.c_str());
        } // Fl_Input2* txt_eqsl_default_message
        { Fl_Group* o = new Fl_Group(258, 254, 481, 81, gettext("Text Tags (tags use {} delimiters)"));
          o->box(FL_FLAT_BOX);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { eqsl_txt1 = new Fl_Box(264, 294, 220, 17, gettext("  {CALL} other ops call sign"));
            eqsl_txt1->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          } // Fl_Box* eqsl_txt1
          { eqsl_txt2 = new Fl_Box(262, 313, 220, 17, gettext("  {MODE} full mode / submode"));
            eqsl_txt2->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          } // Fl_Box* eqsl_txt2
          { eqsl_txt3 = new Fl_Box(510, 294, 220, 17, gettext("{NAME} other ops name"));
            eqsl_txt3->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          } // Fl_Box* eqsl_txt3
          { new Fl_Box(280, 273, 440, 17, gettext("These tags can also be used in <EQSL:[message]>"));
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Logging/eQSL"));
      config_pages.push_back(p);
      tab_tree->add(_("Logging/eQSL"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Logging/LoTW"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Input2* o = txt_lotw_pathname = new Fl_Input2(283, 50, 422, 24, gettext("tqsl:"));
        txt_lotw_pathname->tooltip(gettext("Enter full path-filename for tqsl executable"));
        txt_lotw_pathname->box(FL_DOWN_BOX);
        txt_lotw_pathname->color(FL_BACKGROUND2_COLOR);
        txt_lotw_pathname->selection_color(FL_SELECTION_COLOR);
        txt_lotw_pathname->labeltype(FL_NORMAL_LABEL);
        txt_lotw_pathname->labelfont(0);
        txt_lotw_pathname->labelsize(14);
        txt_lotw_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_lotw_pathname->callback((Fl_Callback*)cb_txt_lotw_pathname);
        txt_lotw_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_lotw_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.lotw_pathname.c_str());
      } // Fl_Input2* txt_lotw_pathname
      { Fl_Input2* o = inpLOTW_pwd = new Fl_Input2(283, 85, 225, 24, gettext("Password"));
        inpLOTW_pwd->tooltip(gettext("Your tqsl login password"));
        inpLOTW_pwd->box(FL_DOWN_BOX);
        inpLOTW_pwd->color(FL_BACKGROUND2_COLOR);
        inpLOTW_pwd->selection_color(FL_SELECTION_COLOR);
        inpLOTW_pwd->labeltype(FL_NORMAL_LABEL);
        inpLOTW_pwd->labelfont(0);
        inpLOTW_pwd->labelsize(14);
        inpLOTW_pwd->labelcolor(FL_FOREGROUND_COLOR);
        inpLOTW_pwd->callback((Fl_Callback*)cb_inpLOTW_pwd);
        inpLOTW_pwd->align(Fl_Align(FL_ALIGN_LEFT));
        inpLOTW_pwd->when(FL_WHEN_RELEASE);
        o->value(progdefaults.lotw_pwd.c_str());
        o->type(FL_SECRET_INPUT);
        inpLOTW_pwd->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpLOTW_pwd
      { Fl_Check_Button* o = btn_submit_lotw_password = new Fl_Check_Button(605, 89, 162, 16, gettext("Password required"));
        btn_submit_lotw_password->tooltip(gettext("Submit password with each upload"));
        btn_submit_lotw_password->down_box(FL_DOWN_BOX);
        btn_submit_lotw_password->callback((Fl_Callback*)cb_btn_submit_lotw_password);
        o->value(progdefaults.submit_lotw_password);
      } // Fl_Check_Button* btn_submit_lotw_password
      { Fl_Input2* o = inpLOTW_location = new Fl_Input2(283, 116, 250, 24, gettext("Location"));
        inpLOTW_location->tooltip(gettext("tqsl station location"));
        inpLOTW_location->box(FL_DOWN_BOX);
        inpLOTW_location->color(FL_BACKGROUND2_COLOR);
        inpLOTW_location->selection_color(FL_SELECTION_COLOR);
        inpLOTW_location->labeltype(FL_NORMAL_LABEL);
        inpLOTW_location->labelfont(0);
        inpLOTW_location->labelsize(14);
        inpLOTW_location->labelcolor(FL_FOREGROUND_COLOR);
        inpLOTW_location->callback((Fl_Callback*)cb_inpLOTW_location);
        inpLOTW_location->align(Fl_Align(FL_ALIGN_LEFT));
        inpLOTW_location->when(FL_WHEN_RELEASE);
        o->value(progdefaults.lotw_location.c_str());
        inpLOTW_pwd->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpLOTW_location
      { btn_select_lotw = new Fl_Button(710, 50, 70, 24, gettext("Locate"));
        btn_select_lotw->tooltip(gettext("Locate tqsl executable"));
        btn_select_lotw->callback((Fl_Callback*)cb_btn_select_lotw);
      } // Fl_Button* btn_select_lotw
      { Fl_Check_Button* o = btn_lotw_quiet_mode = new Fl_Check_Button(243, 149, 309, 16, gettext("Quiet mode [-q], do not open tqsl dialog"));
        btn_lotw_quiet_mode->tooltip(gettext("Operate tqsl in batch mode (no dialog)"));
        btn_lotw_quiet_mode->down_box(FL_DOWN_BOX);
        btn_lotw_quiet_mode->callback((Fl_Callback*)cb_btn_lotw_quiet_mode);
        o->value(progdefaults.lotw_quiet_mode);
      } // Fl_Check_Button* btn_lotw_quiet_mode
      { Fl_Check_Button* o = btn_submit_lotw = new Fl_Check_Button(243, 176, 289, 16, gettext("Send QSO data to LoTW when logged"));
        btn_submit_lotw->tooltip(gettext("Submit each QSO as logged"));
        btn_submit_lotw->down_box(FL_DOWN_BOX);
        btn_submit_lotw->callback((Fl_Callback*)cb_btn_submit_lotw);
        o->value(progdefaults.submit_lotw);
      } // Fl_Check_Button* btn_submit_lotw
      { Fl_Check_Button* o = btn_show_lotw_delivery = new Fl_Check_Button(243, 203, 70, 15, gettext("Show delivery message"));
        btn_show_lotw_delivery->tooltip(gettext("Display timed delivery message if enabled"));
        btn_show_lotw_delivery->down_box(FL_DOWN_BOX);
        btn_show_lotw_delivery->callback((Fl_Callback*)cb_btn_show_lotw_delivery);
        o->value(progdefaults.lotw_show_delivery);
      } // Fl_Check_Button* btn_show_lotw_delivery
      { btn_export_lotw = new Fl_Button(216, 232, 70, 24, gettext("Export"));
        btn_export_lotw->tooltip(gettext("Export records for LoTW upload"));
        btn_export_lotw->callback((Fl_Callback*)cb_btn_export_lotw);
      } // Fl_Button* btn_export_lotw
      { btn_review_lotw = new Fl_Button(216, 259, 70, 24, gettext("Check"));
        btn_review_lotw->tooltip(gettext("Review lotw.adif file before sending with tqsl"));
        btn_review_lotw->callback((Fl_Callback*)cb_btn_review_lotw);
      } // Fl_Button* btn_review_lotw
      { btn_send_lotw = new Fl_Button(216, 287, 70, 24, gettext("Send"));
        btn_send_lotw->tooltip(gettext("Send lotw.adif via tqsl"));
        btn_send_lotw->callback((Fl_Callback*)cb_btn_send_lotw);
      } // Fl_Button* btn_send_lotw
      { Fl_Box* o = new Fl_Box(291, 232, 346, 24, gettext("Export logbook records for LoTW upload"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(291, 259, 346, 24, gettext("Review / edit the exported LoTW upload adif file"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(291, 287, 346, 24, gettext("Submit the upload adif file to LoTW"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(212, 22, 574, 24, gettext("You must have tqsl installed and it\'s location recorded for LoTW updates to "
"work!"));
        o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { btnLOTW_pwd_show = new Fl_Button(516, 85, 70, 24, gettext("Show"));
        btnLOTW_pwd_show->tooltip(gettext("Show password in plain text"));
        btnLOTW_pwd_show->callback((Fl_Callback*)cb_btnLOTW_pwd_show);
      } // Fl_Button* btnLOTW_pwd_show
      { Fl_Box* o = new Fl_Box(540, 116, 211, 24, gettext("Use this tqsl station location"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { btn_verify_lotw = new Fl_Button(216, 315, 70, 24, gettext("Match"));
        btn_verify_lotw->tooltip(gettext("Verify database with LoTW download file"));
        btn_verify_lotw->callback((Fl_Callback*)cb_btn_verify_lotw);
      } // Fl_Button* btn_verify_lotw
      { Fl_Box* o = new Fl_Box(291, 315, 346, 24, gettext("Match logbook records with LoTW download file"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { btn_view_unmatched = new Fl_Button(645, 313, 139, 24, gettext("View Unmatched"));
        btn_view_unmatched->tooltip(gettext("Verify database with LoTW download file"));
        btn_view_unmatched->callback((Fl_Callback*)cb_btn_view_unmatched);
        btn_view_unmatched->deactivate();
      } // Fl_Button* btn_view_unmatched
      { Fl_Counter* o = cnt_tracefile_timeout = new Fl_Counter(647, 146, 79, 21, gettext("Timeout"));
        cnt_tracefile_timeout->tooltip(gettext("Wait NN seconds for LoTW response"));
        cnt_tracefile_timeout->type(1);
        cnt_tracefile_timeout->minimum(4);
        cnt_tracefile_timeout->maximum(60);
        cnt_tracefile_timeout->step(1);
        cnt_tracefile_timeout->value(5);
        cnt_tracefile_timeout->callback((Fl_Callback*)cb_cnt_tracefile_timeout);
        cnt_tracefile_timeout->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.tracefile_timeout);
      } // Fl_Counter* cnt_tracefile_timeout
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Logging/LoTW"));
      config_pages.push_back(p);
      tab_tree->add(_("Logging/LoTW"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Logging/Cloud-UDP"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(210, 29, 580, 165, gettext("Log QSO record to a Cloudlog instance."));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnEnCloudlog = new Fl_Check_Button(232, 153, 70, 15, gettext("Enable Cloudlog API logging"));
          btnEnCloudlog->tooltip(gettext("This enables logging of QSOs to Cloudlog via API"));
          btnEnCloudlog->down_box(FL_DOWN_BOX);
          btnEnCloudlog->callback((Fl_Callback*)cb_btnEnCloudlog);
          o->value(progdefaults.EnCloudlog);
        } // Fl_Check_Button* btnEnCloudlog
        { Fl_Input2* o = txt_cloudlog_api_url = new Fl_Input2(286, 70, 400, 24, gettext("API URL:"));
          txt_cloudlog_api_url->tooltip(gettext("Enter the URL of your Cloudlog API"));
          txt_cloudlog_api_url->box(FL_DOWN_BOX);
          txt_cloudlog_api_url->color(FL_BACKGROUND2_COLOR);
          txt_cloudlog_api_url->selection_color(FL_SELECTION_COLOR);
          txt_cloudlog_api_url->labeltype(FL_NORMAL_LABEL);
          txt_cloudlog_api_url->labelfont(0);
          txt_cloudlog_api_url->labelsize(14);
          txt_cloudlog_api_url->labelcolor(FL_FOREGROUND_COLOR);
          txt_cloudlog_api_url->callback((Fl_Callback*)cb_txt_cloudlog_api_url);
          txt_cloudlog_api_url->align(Fl_Align(FL_ALIGN_LEFT));
          txt_cloudlog_api_url->when(FL_WHEN_RELEASE);
          o->value(progdefaults.cloudlog_api_url.c_str());
        } // Fl_Input2* txt_cloudlog_api_url
        { Fl_Input2* o = txt_cloudlog_api_key = new Fl_Input2(286, 110, 400, 24, gettext("API Key:"));
          txt_cloudlog_api_key->tooltip(gettext("Enter the API key for your Cloudlog instance"));
          txt_cloudlog_api_key->box(FL_DOWN_BOX);
          txt_cloudlog_api_key->color(FL_BACKGROUND2_COLOR);
          txt_cloudlog_api_key->selection_color(FL_SELECTION_COLOR);
          txt_cloudlog_api_key->labeltype(FL_NORMAL_LABEL);
          txt_cloudlog_api_key->labelfont(0);
          txt_cloudlog_api_key->labelsize(14);
          txt_cloudlog_api_key->labelcolor(FL_FOREGROUND_COLOR);
          txt_cloudlog_api_key->callback((Fl_Callback*)cb_txt_cloudlog_api_key);
          txt_cloudlog_api_key->align(Fl_Align(FL_ALIGN_LEFT));
          txt_cloudlog_api_key->when(FL_WHEN_RELEASE);
          o->value(progdefaults.cloudlog_api_key.c_str());
        } // Fl_Input2* txt_cloudlog_api_key
        { Fl_Spinner* o = sp_cloudlog_station_id = new Fl_Spinner(710, 109, 60, 25, gettext("Station ID:"));
          sp_cloudlog_station_id->maximum(9999);
          sp_cloudlog_station_id->callback((Fl_Callback*)cb_sp_cloudlog_station_id);
          sp_cloudlog_station_id->align(Fl_Align(FL_ALIGN_TOP));
          o->value(progdefaults.cloudlog_station_id);
        } // Fl_Spinner* sp_cloudlog_station_id
        { btnTestApiKey = new Fl_Button(690, 148, 80, 24, gettext("Initialize"));
          btnTestApiKey->tooltip(gettext("Test API Key"));
          btnTestApiKey->callback((Fl_Callback*)cb_btnTestApiKey);
        } // Fl_Button* btnTestApiKey
        { btnCLOUDselect = new Fl_Button(488, 150, 118, 20, gettext("Select Fields"));
          btnCLOUDselect->tooltip(gettext("Open field selection dialog"));
          btnCLOUDselect->callback((Fl_Callback*)cb_btnCLOUDselect);
        } // Fl_Button* btnCLOUDselect
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(210, 200, 580, 141, gettext("Broadcast UDP ADIF record"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Input2* o = txt_udp_address = new Fl_Input2(286, 248, 486, 22, gettext("Address"));
          txt_udp_address->tooltip(gettext("IP Address for ARQ interface\nIP Address format: nnn.nnn.nnn.nnn\nor name: i."
"e. localhost"));
          txt_udp_address->box(FL_DOWN_BOX);
          txt_udp_address->color(FL_BACKGROUND2_COLOR);
          txt_udp_address->selection_color(FL_SELECTION_COLOR);
          txt_udp_address->labeltype(FL_NORMAL_LABEL);
          txt_udp_address->labelfont(0);
          txt_udp_address->labelsize(14);
          txt_udp_address->labelcolor(FL_FOREGROUND_COLOR);
          txt_udp_address->callback((Fl_Callback*)cb_txt_udp_address);
          txt_udp_address->align(Fl_Align(FL_ALIGN_LEFT));
          txt_udp_address->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.udp_address.c_str());
        } // Fl_Input2* txt_udp_address
        { Fl_Input2* o = txt_udp_port = new Fl_Input2(286, 282, 76, 22, gettext("Port"));
          txt_udp_port->tooltip(gettext("IP Address Port Number"));
          txt_udp_port->box(FL_DOWN_BOX);
          txt_udp_port->color(FL_BACKGROUND2_COLOR);
          txt_udp_port->selection_color(FL_SELECTION_COLOR);
          txt_udp_port->labeltype(FL_NORMAL_LABEL);
          txt_udp_port->labelfont(0);
          txt_udp_port->labelsize(14);
          txt_udp_port->labelcolor(FL_FOREGROUND_COLOR);
          txt_udp_port->callback((Fl_Callback*)cb_txt_udp_port);
          txt_udp_port->align(Fl_Align(FL_ALIGN_LEFT));
          txt_udp_port->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.udp_port.c_str());
        } // Fl_Input2* txt_udp_port
        { Fl_Check_Button* o = btn_enable_udp_logging = new Fl_Check_Button(412, 285, 71, 15, gettext("Enable"));
          btn_enable_udp_logging->down_box(FL_DOWN_BOX);
          btn_enable_udp_logging->callback((Fl_Callback*)cb_btn_enable_udp_logging);
          o->value(progdefaults.enable_udp_logging);
        } // Fl_Check_Button* btn_enable_udp_logging
        { btnUDPselect = new Fl_Button(533, 283, 119, 20, gettext("Select Fields"));
          btnUDPselect->tooltip(gettext("Open field selection dialog"));
          btnUDPselect->callback((Fl_Callback*)cb_btnUDPselect);
        } // Fl_Button* btnUDPselect
        { Fl_Button* o = new Fl_Button(700, 283, 70, 20, gettext("TEST"));
          o->callback((Fl_Callback*)cb_TEST);
        } // Fl_Button* o
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Logging/Cloud-UDP"));
      config_pages.push_back(p);
      tab_tree->add(_("Logging/Cloud-UDP"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Logging/QSO logging"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Check_Button* o = btnNagMe = new Fl_Check_Button(255, 63, 236, 20, gettext("Prompt to save log on exit"));
        btnNagMe->tooltip(gettext("Bug me about saving log entries"));
        btnNagMe->down_box(FL_DOWN_BOX);
        btnNagMe->callback((Fl_Callback*)cb_btnNagMe);
        o->value(progdefaults.NagMe);
      } // Fl_Check_Button* btnNagMe
      { Fl_Check_Button* o = btnClearOnSave = new Fl_Check_Button(255, 92, 236, 20, gettext("Clear on save"));
        btnClearOnSave->tooltip(gettext("Clear log entries after saving or using macro <LOG>"));
        btnClearOnSave->down_box(FL_DOWN_BOX);
        btnClearOnSave->callback((Fl_Callback*)cb_btnClearOnSave);
        o->value(progdefaults.ClearOnSave);
      } // Fl_Check_Button* btnClearOnSave
      { Fl_Check_Button* o = btnCallUpperCase = new Fl_Check_Button(255, 121, 236, 20, gettext("Convert callsign to upper case"));
        btnCallUpperCase->tooltip(gettext("Force callsign field to UPPERCASE"));
        btnCallUpperCase->down_box(FL_DOWN_BOX);
        btnCallUpperCase->callback((Fl_Callback*)cb_btnCallUpperCase);
        o->value(progdefaults.calluppercase);
      } // Fl_Check_Button* btnCallUpperCase
      { Fl_Check_Button* o = btnAutoFillQSO = new Fl_Check_Button(255, 151, 236, 20, gettext("Auto-fill Country and Azimuth"));
        btnAutoFillQSO->tooltip(gettext("Fill in Country / Azimuth using cty.dat information"));
        btnAutoFillQSO->down_box(FL_DOWN_BOX);
        btnAutoFillQSO->callback((Fl_Callback*)cb_btnAutoFillQSO);
        o->value(progdefaults.autofill_qso_fields);
      } // Fl_Check_Button* btnAutoFillQSO
      { Fl_Check_Button* o = btnDateTimeSort = new Fl_Check_Button(508, 63, 190, 20, gettext("Sort by Date/Time OFF"));
        btnDateTimeSort->tooltip(gettext("Sort by date/time OFF - effects all ADIF/Cabrillo reports"));
        btnDateTimeSort->down_box(FL_DOWN_BOX);
        btnDateTimeSort->callback((Fl_Callback*)cb_btnDateTimeSort);
        o->value(progdefaults.sort_date_time_off);
      } // Fl_Check_Button* btnDateTimeSort
      { Fl_Check_Button* o = btndate_time_force = new Fl_Check_Button(508, 92, 190, 20, gettext("Date time ON == OFF"));
        btndate_time_force->tooltip(gettext("Force date/time ON == date/time OFF"));
        btndate_time_force->down_box(FL_DOWN_BOX);
        btndate_time_force->callback((Fl_Callback*)cb_btndate_time_force);
        o->value(progdefaults.force_date_time);
      } // Fl_Check_Button* btndate_time_force
      { Fl_Check_Button* o = btnRSTindefault = new Fl_Check_Button(508, 121, 213, 20, gettext("Default RST in to 599/59"));
        btnRSTindefault->tooltip(gettext("Clear log controls sets RST in to 599/59"));
        btnRSTindefault->down_box(FL_DOWN_BOX);
        btnRSTindefault->callback((Fl_Callback*)cb_btnRSTindefault);
        o->value(progdefaults.RSTin_default);
      } // Fl_Check_Button* btnRSTindefault
      { Fl_Check_Button* o = btnRSTdefault = new Fl_Check_Button(508, 151, 216, 20, gettext("Default RST out to 599/59"));
        btnRSTdefault->tooltip(gettext("Clear log controls sets RST out to 599/59"));
        btnRSTdefault->down_box(FL_DOWN_BOX);
        btnRSTdefault->callback((Fl_Callback*)cb_btnRSTdefault);
        o->value(progdefaults.RSTdefault);
      } // Fl_Check_Button* btnRSTdefault
      { Fl_Input2* o = inpMyPower = new Fl_Input2(368, 219, 50, 24, gettext("Transmit Power"));
        inpMyPower->tooltip(gettext("Tx power used for logbook entries"));
        inpMyPower->box(FL_DOWN_BOX);
        inpMyPower->color(FL_BACKGROUND2_COLOR);
        inpMyPower->selection_color(FL_SELECTION_COLOR);
        inpMyPower->labeltype(FL_NORMAL_LABEL);
        inpMyPower->labelfont(0);
        inpMyPower->labelsize(14);
        inpMyPower->labelcolor(FL_FOREGROUND_COLOR);
        inpMyPower->callback((Fl_Callback*)cb_inpMyPower);
        inpMyPower->align(Fl_Align(FL_ALIGN_LEFT));
        inpMyPower->when(FL_WHEN_RELEASE);
        o->value(progdefaults.mytxpower.c_str());
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpMyPower
      { Fl_Check_Button* o = btnDisplayLogbookRead = new Fl_Check_Button(255, 181, 277, 20, gettext("Display logbook read datum at start"));
        btnDisplayLogbookRead->tooltip(gettext("The filename is written to the RX text area"));
        btnDisplayLogbookRead->down_box(FL_DOWN_BOX);
        btnDisplayLogbookRead->callback((Fl_Callback*)cb_btnDisplayLogbookRead);
        o->value(progdefaults.DisplayLogbookRead);
      } // Fl_Check_Button* btnDisplayLogbookRead
      { Fl_Group* o = new Fl_Group(432, 220, 260, 120, gettext("Logbook Recorded Power"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_log_power_meter = new Fl_Check_Button(442, 250, 155, 20, gettext("Log power meter "));
          btn_log_power_meter->tooltip(gettext("Bug me about saving log entries"));
          btn_log_power_meter->down_box(FL_DOWN_BOX);
          btn_log_power_meter->value(1);
          btn_log_power_meter->callback((Fl_Callback*)cb_btn_log_power_meter);
          o->value(progdefaults.log_power_meter);
        } // Fl_Check_Button* btn_log_power_meter
        { Fl_Counter* o = pwr_set_size = new Fl_Counter(442, 280, 60, 22, gettext("sample set size"));
          pwr_set_size->tooltip(gettext("average / peak over number of samples"));
          pwr_set_size->type(1);
          pwr_set_size->minimum(1);
          pwr_set_size->maximum(50);
          pwr_set_size->step(1);
          pwr_set_size->value(20);
          pwr_set_size->callback((Fl_Callback*)cb_pwr_set_size);
          pwr_set_size->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.pwr_set_size);
        } // Fl_Counter* pwr_set_size
        { Fl_Check_Button* o = btn_use_average_power = new Fl_Check_Button(442, 312, 78, 22, gettext("Use Average powef"));
          btn_use_average_power->tooltip(gettext("Report average power if selected; peak otherwise"));
          btn_use_average_power->down_box(FL_DOWN_BOX);
          btn_use_average_power->value(1);
          btn_use_average_power->callback((Fl_Callback*)cb_btn_use_average_power);
          o->value(progdefaults.report_average_power);
        } // Fl_Check_Button* btn_use_average_power
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Logging/QSO logging"));
      config_pages.push_back(p);
      tab_tree->add(_("Logging/QSO logging"));
      tab_tree->close(_("Logging"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/General"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Counter* o = cntSoftStart = new Fl_Counter(375, 89, 150, 22, gettext("Raised cosine start up shape"));
        cntSoftStart->tooltip(gettext("Shape leading edge of modem signal using raised cosine shap\nValue in millise"
"conds."));
        cntSoftStart->minimum(0);
        cntSoftStart->maximum(500);
        cntSoftStart->step(1);
        cntSoftStart->value(100);
        cntSoftStart->callback((Fl_Callback*)cb_cntSoftStart);
        cntSoftStart->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.SoftStart);
        o->labelsize(FL_NORMAL_SIZE);
        o->lstep(10);
      } // Fl_Counter* cntSoftStart
      { Fl_Group* o = new Fl_Group(239, 164, 501, 134, gettext("Enable for Respective Modes"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_softPSK = new Fl_Check_Button(330, 206, 70, 15, gettext("PSK"));
          btn_softPSK->tooltip(gettext("Enable for leading edge only!"));
          btn_softPSK->down_box(FL_DOWN_BOX);
          btn_softPSK->callback((Fl_Callback*)cb_btn_softPSK);
          o->value(progdefaults.softPSK);
        } // Fl_Check_Button* btn_softPSK
        { Fl_Check_Button* o = btn_softMFSK = new Fl_Check_Button(450, 206, 70, 15, gettext("MFSK"));
          btn_softMFSK->tooltip(gettext("Enable for leading and trailing edge."));
          btn_softMFSK->down_box(FL_DOWN_BOX);
          btn_softMFSK->callback((Fl_Callback*)cb_btn_softMFSK);
          o->value(progdefaults.softMFSK);
        } // Fl_Check_Button* btn_softMFSK
        { Fl_Check_Button* o = btn_softRTTY = new Fl_Check_Button(571, 206, 70, 15, gettext("RTTY"));
          btn_softRTTY->tooltip(gettext("Enable for leading and trailing edge."));
          btn_softRTTY->down_box(FL_DOWN_BOX);
          btn_softRTTY->callback((Fl_Callback*)cb_btn_softRTTY);
          o->value(progdefaults.softRTTY);
        } // Fl_Check_Button* btn_softRTTY
        { Fl_Check_Button* o = btn_softTHOR = new Fl_Check_Button(450, 240, 70, 15, gettext("THOR"));
          btn_softTHOR->tooltip(gettext("Enable for leading and trailing edge."));
          btn_softTHOR->down_box(FL_DOWN_BOX);
          btn_softTHOR->callback((Fl_Callback*)cb_btn_softTHOR);
          o->value(progdefaults.softTHOR);
        } // Fl_Check_Button* btn_softTHOR
        { Fl_Check_Button* o = btn_softDOMINOEX = new Fl_Check_Button(330, 240, 70, 15, gettext("DOMINOEX"));
          btn_softDOMINOEX->tooltip(gettext("Enable for leading and trailing  edge"));
          btn_softDOMINOEX->down_box(FL_DOWN_BOX);
          btn_softDOMINOEX->callback((Fl_Callback*)cb_btn_softDOMINOEX);
          o->value(progdefaults.softDOMINOEX);
        } // Fl_Check_Button* btn_softDOMINOEX
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/General"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/General"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/General"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(225, 23, 560, 147, gettext("Receive"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnCWuseSOMdecoding = new Fl_Check_Button(233, 50, 125, 20, gettext("SOM decoding"));
          btnCWuseSOMdecoding->tooltip(gettext("Self Organizing Map Decoder"));
          btnCWuseSOMdecoding->down_box(FL_DOWN_BOX);
          btnCWuseSOMdecoding->value(1);
          btnCWuseSOMdecoding->callback((Fl_Callback*)cb_btnCWuseSOMdecoding);
          o->value(progdefaults.CWuseSOMdecoding);
        } // Fl_Check_Button* btnCWuseSOMdecoding
        { valCWrcvWPM = new Fl_Value_Output(233, 79, 40, 20);
          valCWrcvWPM->color(FL_BACKGROUND2_COLOR);
          valCWrcvWPM->callback((Fl_Callback*)cb_valCWrcvWPM);
          valCWrcvWPM->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Output* valCWrcvWPM
        { prgsCWrcvWPM = new Fl_Progress(275, 79, 200, 19, gettext("Rx WPM"));
          prgsCWrcvWPM->tooltip(gettext("Tracked CW speed in WPM"));
          prgsCWrcvWPM->color(FL_BACKGROUND_COLOR);
          prgsCWrcvWPM->selection_color(FL_SELECTION_COLOR);
        } // Fl_Progress* prgsCWrcvWPM
        { Fl_Check_Button* o = btnCWrcvTrack = new Fl_Check_Button(233, 108, 80, 20, gettext("Track WPM"));
          btnCWrcvTrack->tooltip(gettext("Automatic Rx speed tracking"));
          btnCWrcvTrack->down_box(FL_DOWN_BOX);
          btnCWrcvTrack->value(1);
          btnCWrcvTrack->callback((Fl_Callback*)cb_btnCWrcvTrack);
          o->value(progdefaults.CWtrack);
        } // Fl_Check_Button* btnCWrcvTrack
        { Fl_Counter2* o = cntCWrange = new Fl_Counter2(342, 107, 65, 20, gettext("Range"));
          cntCWrange->tooltip(gettext("Range +/- wpm"));
          cntCWrange->type(1);
          cntCWrange->box(FL_UP_BOX);
          cntCWrange->color(FL_BACKGROUND_COLOR);
          cntCWrange->selection_color(FL_INACTIVE_COLOR);
          cntCWrange->labeltype(FL_NORMAL_LABEL);
          cntCWrange->labelfont(0);
          cntCWrange->labelsize(14);
          cntCWrange->labelcolor(FL_FOREGROUND_COLOR);
          cntCWrange->minimum(5);
          cntCWrange->maximum(25);
          cntCWrange->step(1);
          cntCWrange->value(10);
          cntCWrange->callback((Fl_Callback*)cb_cntCWrange);
          cntCWrange->align(Fl_Align(FL_ALIGN_RIGHT));
          cntCWrange->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWrange);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntCWrange
        { Fl_Group* o = new Fl_Group(643, 30, 135, 135, gettext("Signal tracking"));
          o->box(FL_ENGRAVED_BOX);
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { Fl_Choice* o = mnu_cwrx_attack = new Fl_Choice(698, 56, 72, 20, gettext("Attack"));
            mnu_cwrx_attack->tooltip(gettext("amplitude tracking"));
            mnu_cwrx_attack->down_box(FL_BORDER_BOX);
            mnu_cwrx_attack->callback((Fl_Callback*)cb_mnu_cwrx_attack);
            o->add("Slow|Med|Fast");
            o->value(progdefaults.cwrx_attack);
          } // Fl_Choice* mnu_cwrx_attack
          { Fl_Choice* o = mnu_cwrx_decay = new Fl_Choice(698, 95, 72, 20, gettext("Decay"));
            mnu_cwrx_decay->tooltip(gettext("amplitude tracking"));
            mnu_cwrx_decay->down_box(FL_BORDER_BOX);
            mnu_cwrx_decay->callback((Fl_Callback*)cb_mnu_cwrx_decay);
            o->add("Slow|Med|Fast");
            o->value(progdefaults.cwrx_decay);
          } // Fl_Choice* mnu_cwrx_decay
          { btn_cw_tracking_defaults = new Fl_Button(698, 134, 70, 20, gettext("Defaults"));
            btn_cw_tracking_defaults->callback((Fl_Callback*)cb_btn_cw_tracking_defaults);
          } // Fl_Button* btn_cw_tracking_defaults
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(486, 30, 155, 135, gettext("Modem Filter"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { Fl_Check_Button* o = btnCWmfilt = new Fl_Check_Button(503, 57, 80, 20, gettext("Matched Filter"));
            btnCWmfilt->tooltip(gettext("Matched Filter bandwidth"));
            btnCWmfilt->down_box(FL_DOWN_BOX);
            btnCWmfilt->value(1);
            btnCWmfilt->callback((Fl_Callback*)cb_btnCWmfilt);
            o->value(progdefaults.CWmfilt);
          } // Fl_Check_Button* btnCWmfilt
          { Fl_Counter2* o = cntCWbandwidth = new Fl_Counter2(503, 100, 120, 20, gettext("Bandwidth"));
            cntCWbandwidth->tooltip(gettext("Range +/- wpm"));
            cntCWbandwidth->box(FL_UP_BOX);
            cntCWbandwidth->color(FL_BACKGROUND_COLOR);
            cntCWbandwidth->selection_color(FL_INACTIVE_COLOR);
            cntCWbandwidth->labeltype(FL_NORMAL_LABEL);
            cntCWbandwidth->labelfont(0);
            cntCWbandwidth->labelsize(14);
            cntCWbandwidth->labelcolor(FL_FOREGROUND_COLOR);
            cntCWbandwidth->minimum(10);
            cntCWbandwidth->maximum(800);
            cntCWbandwidth->step(5);
            cntCWbandwidth->value(200);
            cntCWbandwidth->callback((Fl_Callback*)cb_cntCWbandwidth);
            cntCWbandwidth->align(Fl_Align(FL_ALIGN_TOP));
            cntCWbandwidth->when(FL_WHEN_CHANGED);
            o->value(progdefaults.CWbandwidth);
            o->labelsize(FL_NORMAL_SIZE);
            o->lstep(50);
          } // Fl_Counter2* cntCWbandwidth
          { Fl_Choice* o = mnu_CW_fillen = new Fl_Choice(503, 133, 72, 20, gettext("Fil\' Len\'"));
            mnu_CW_fillen->tooltip(gettext("Filter length in samples"));
            mnu_CW_fillen->down_box(FL_BORDER_BOX);
            mnu_CW_fillen->callback((Fl_Callback*)cb_mnu_CW_fillen);
            mnu_CW_fillen->align(Fl_Align(FL_ALIGN_RIGHT));
            o->add("128|256|512|1024");
            o->value(progdefaults.CW_fillen);
          } // Fl_Choice* mnu_CW_fillen
          o->end();
        } // Fl_Group* o
        { Fl_Check_Button* o = btn_show_embedded_CW_controls = new Fl_Check_Button(233, 137, 78, 22, gettext("Show embedded controls"));
          btn_show_embedded_CW_controls->down_box(FL_DOWN_BOX);
          btn_show_embedded_CW_controls->callback((Fl_Callback*)cb_btn_show_embedded_CW_controls);
          o->value(progdefaults.show_CW_controls);
        } // Fl_Check_Button* btn_show_embedded_CW_controls
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(225, 170, 560, 174, gettext("Transmit"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Value_Slider2* o = sldrCWxmtWPM = new Fl_Value_Slider2(250, 195, 440, 20, gettext("char WPM"));
          sldrCWxmtWPM->tooltip(gettext("My transmit CW WPM"));
          sldrCWxmtWPM->type(1);
          sldrCWxmtWPM->box(FL_DOWN_BOX);
          sldrCWxmtWPM->color(FL_BACKGROUND_COLOR);
          sldrCWxmtWPM->selection_color(FL_BACKGROUND_COLOR);
          sldrCWxmtWPM->labeltype(FL_NORMAL_LABEL);
          sldrCWxmtWPM->labelfont(0);
          sldrCWxmtWPM->labelsize(14);
          sldrCWxmtWPM->labelcolor(FL_FOREGROUND_COLOR);
          sldrCWxmtWPM->minimum(5);
          sldrCWxmtWPM->maximum(100);
          sldrCWxmtWPM->step(1);
          sldrCWxmtWPM->value(20);
          sldrCWxmtWPM->textsize(14);
          sldrCWxmtWPM->callback((Fl_Callback*)cb_sldrCWxmtWPM);
          sldrCWxmtWPM->align(Fl_Align(FL_ALIGN_RIGHT));
          sldrCWxmtWPM->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWspeed);
          o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
        } // Fl_Value_Slider2* sldrCWxmtWPM
        { Fl_Counter2* o = cntCWdefWPM = new Fl_Counter2(307, 224, 64, 20, gettext("Default"));
          cntCWdefWPM->tooltip(gettext("The default CW speed"));
          cntCWdefWPM->type(1);
          cntCWdefWPM->box(FL_UP_BOX);
          cntCWdefWPM->color(FL_BACKGROUND_COLOR);
          cntCWdefWPM->selection_color(FL_INACTIVE_COLOR);
          cntCWdefWPM->labeltype(FL_NORMAL_LABEL);
          cntCWdefWPM->labelfont(0);
          cntCWdefWPM->labelsize(14);
          cntCWdefWPM->labelcolor(FL_FOREGROUND_COLOR);
          cntCWdefWPM->minimum(5);
          cntCWdefWPM->maximum(200);
          cntCWdefWPM->step(1);
          cntCWdefWPM->value(18);
          cntCWdefWPM->callback((Fl_Callback*)cb_cntCWdefWPM);
          cntCWdefWPM->align(Fl_Align(FL_ALIGN_LEFT));
          cntCWdefWPM->when(FL_WHEN_CHANGED);
          o->value(progdefaults.defCWspeed);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntCWdefWPM
        { Fl_Counter* o = cntCWlowerlimit = new Fl_Counter(497, 224, 65, 20, gettext("Lower limit"));
          cntCWlowerlimit->tooltip(gettext("No slower than this"));
          cntCWlowerlimit->type(1);
          cntCWlowerlimit->minimum(5);
          cntCWlowerlimit->maximum(20);
          cntCWlowerlimit->step(5);
          cntCWlowerlimit->value(10);
          cntCWlowerlimit->callback((Fl_Callback*)cb_cntCWlowerlimit);
          cntCWlowerlimit->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(progdefaults.CWlowerlimit);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter* cntCWlowerlimit
        { Fl_Counter* o = cntCWupperlimit = new Fl_Counter(688, 224, 65, 20, gettext("Upper limit"));
          cntCWupperlimit->tooltip(gettext("No faster than this"));
          cntCWupperlimit->type(1);
          cntCWupperlimit->minimum(25);
          cntCWupperlimit->maximum(200);
          cntCWupperlimit->step(5);
          cntCWupperlimit->value(100);
          cntCWupperlimit->callback((Fl_Callback*)cb_cntCWupperlimit);
          cntCWupperlimit->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(progdefaults.CWupperlimit);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter* cntCWupperlimit
        { Fl_Value_Slider2* o = sldrCWfarnsworth = new Fl_Value_Slider2(250, 271, 400, 20, gettext("text WPM"));
          sldrCWfarnsworth->tooltip(gettext("My transmit CW WPM"));
          sldrCWfarnsworth->type(1);
          sldrCWfarnsworth->box(FL_DOWN_BOX);
          sldrCWfarnsworth->color(FL_BACKGROUND_COLOR);
          sldrCWfarnsworth->selection_color(FL_BACKGROUND_COLOR);
          sldrCWfarnsworth->labeltype(FL_NORMAL_LABEL);
          sldrCWfarnsworth->labelfont(0);
          sldrCWfarnsworth->labelsize(14);
          sldrCWfarnsworth->labelcolor(FL_FOREGROUND_COLOR);
          sldrCWfarnsworth->minimum(5);
          sldrCWfarnsworth->maximum(50);
          sldrCWfarnsworth->step(1);
          sldrCWfarnsworth->value(15);
          sldrCWfarnsworth->textsize(14);
          sldrCWfarnsworth->callback((Fl_Callback*)cb_sldrCWfarnsworth);
          sldrCWfarnsworth->align(Fl_Align(FL_ALIGN_RIGHT));
          sldrCWfarnsworth->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWfarnsworth);
          o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
        } // Fl_Value_Slider2* sldrCWfarnsworth
        { Fl_Check_Button* o = btnCWusefarnsworth = new Fl_Check_Button(270, 252, 180, 15, gettext("Use Farnsworth timing"));
          btnCWusefarnsworth->tooltip(gettext("text WPM <= char WPM"));
          btnCWusefarnsworth->down_box(FL_DOWN_BOX);
          btnCWusefarnsworth->callback((Fl_Callback*)cb_btnCWusefarnsworth);
          o->value(progdefaults.CWusefarnsworth);
        } // Fl_Check_Button* btnCWusefarnsworth
        { Fl_Value_Slider2* o = sldrCWwordsworth = new Fl_Value_Slider2(251, 319, 400, 20, gettext("Spacing WPM"));
          sldrCWwordsworth->tooltip(gettext("My transmit CW WPM"));
          sldrCWwordsworth->type(1);
          sldrCWwordsworth->box(FL_DOWN_BOX);
          sldrCWwordsworth->color(FL_BACKGROUND_COLOR);
          sldrCWwordsworth->selection_color(FL_BACKGROUND_COLOR);
          sldrCWwordsworth->labeltype(FL_NORMAL_LABEL);
          sldrCWwordsworth->labelfont(0);
          sldrCWwordsworth->labelsize(14);
          sldrCWwordsworth->labelcolor(FL_FOREGROUND_COLOR);
          sldrCWwordsworth->minimum(5);
          sldrCWwordsworth->maximum(50);
          sldrCWwordsworth->step(1);
          sldrCWwordsworth->value(15);
          sldrCWwordsworth->textsize(14);
          sldrCWwordsworth->callback((Fl_Callback*)cb_sldrCWwordsworth);
          sldrCWwordsworth->align(Fl_Align(FL_ALIGN_RIGHT));
          sldrCWwordsworth->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWwordsworth);
          o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
        } // Fl_Value_Slider2* sldrCWwordsworth
        { Fl_Check_Button* o = btnCWusewordsworth = new Fl_Check_Button(271, 300, 180, 15, gettext("Use Wordsworth timing"));
          btnCWusewordsworth->tooltip(gettext("text WPM <= char WPM"));
          btnCWusewordsworth->down_box(FL_DOWN_BOX);
          btnCWusewordsworth->callback((Fl_Callback*)cb_btnCWusewordsworth);
          o->value(progdefaults.CWusewordsworth);
        } // Fl_Check_Button* btnCWusewordsworth
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/General"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/General"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/Timing and QSK"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 31, 590, 124, gettext("Timing"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter2* o = cntCWdash2dot = new Fl_Counter2(267, 47, 125, 24, gettext("Dash/Dot"));
          cntCWdash2dot->tooltip(gettext("Dash to dot ratio"));
          cntCWdash2dot->box(FL_UP_BOX);
          cntCWdash2dot->color(FL_BACKGROUND_COLOR);
          cntCWdash2dot->selection_color(FL_INACTIVE_COLOR);
          cntCWdash2dot->labeltype(FL_NORMAL_LABEL);
          cntCWdash2dot->labelfont(0);
          cntCWdash2dot->labelsize(14);
          cntCWdash2dot->labelcolor(FL_FOREGROUND_COLOR);
          cntCWdash2dot->minimum(2.5);
          cntCWdash2dot->maximum(4);
          cntCWdash2dot->value(3);
          cntCWdash2dot->callback((Fl_Callback*)cb_cntCWdash2dot);
          cntCWdash2dot->align(Fl_Align(FL_ALIGN_RIGHT));
          cntCWdash2dot->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWdash2dot);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(1);
        } // Fl_Counter2* cntCWdash2dot
        { Fl_Counter2* o = cntCWrisetime = new Fl_Counter2(267, 78, 125, 24, gettext("Edge timing"));
          cntCWrisetime->tooltip(gettext("Leading and Trailing edge risetimes (msec)"));
          cntCWrisetime->box(FL_UP_BOX);
          cntCWrisetime->color(FL_BACKGROUND_COLOR);
          cntCWrisetime->selection_color(FL_INACTIVE_COLOR);
          cntCWrisetime->labeltype(FL_NORMAL_LABEL);
          cntCWrisetime->labelfont(0);
          cntCWrisetime->labelsize(14);
          cntCWrisetime->labelcolor(FL_FOREGROUND_COLOR);
          cntCWrisetime->minimum(0);
          cntCWrisetime->maximum(15);
          cntCWrisetime->value(4);
          cntCWrisetime->callback((Fl_Callback*)cb_cntCWrisetime);
          cntCWrisetime->align(Fl_Align(FL_ALIGN_RIGHT));
          cntCWrisetime->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWrisetime);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(1);
        } // Fl_Counter2* cntCWrisetime
        { Fl_ListBox* o = i_listboxQSKshape = new Fl_ListBox(267, 111, 125, 24, gettext("Edge shape"));
          i_listboxQSKshape->tooltip(gettext("Hanning/Blackman - use edge timing\nBPF - use BPF bandwidth"));
          i_listboxQSKshape->box(FL_DOWN_BOX);
          i_listboxQSKshape->color(FL_BACKGROUND2_COLOR);
          i_listboxQSKshape->selection_color(FL_BACKGROUND_COLOR);
          i_listboxQSKshape->labeltype(FL_NORMAL_LABEL);
          i_listboxQSKshape->labelfont(0);
          i_listboxQSKshape->labelsize(14);
          i_listboxQSKshape->labelcolor(FL_FOREGROUND_COLOR);
          i_listboxQSKshape->callback((Fl_Callback*)cb_i_listboxQSKshape);
          i_listboxQSKshape->align(Fl_Align(FL_ALIGN_RIGHT));
          i_listboxQSKshape->when(FL_WHEN_RELEASE);
          o->add("Hanning|Blackman");
          o->index(progdefaults.QSKshape);
          o->labelsize(FL_NORMAL_SIZE);
          i_listboxQSKshape->end();
        } // Fl_ListBox* i_listboxQSKshape
        { Fl_Counter2* o = cntWeight = new Fl_Counter2(520, 47, 100, 24, gettext("% weight"));
          cntWeight->tooltip(gettext("Add pr sibtract key down weightJsubtracts from key up interval."));
          cntWeight->box(FL_UP_BOX);
          cntWeight->color(FL_BACKGROUND_COLOR);
          cntWeight->selection_color(FL_INACTIVE_COLOR);
          cntWeight->labeltype(FL_NORMAL_LABEL);
          cntWeight->labelfont(0);
          cntWeight->labelsize(14);
          cntWeight->labelcolor(FL_FOREGROUND_COLOR);
          cntWeight->minimum(-0.25);
          cntWeight->maximum(0.25);
          cntWeight->step(0.01);
          cntWeight->callback((Fl_Callback*)cb_cntWeight);
          cntWeight->align(Fl_Align(FL_ALIGN_RIGHT));
          cntWeight->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWweight);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(.05);
        } // Fl_Counter2* cntWeight
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 155, 590, 153, gettext("QSK"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnQSK = new Fl_Check_Button(267, 172, 217, 20, gettext("QSK on right audio channel"));
          btnQSK->tooltip(gettext("Generate square wave signal on right channel"));
          btnQSK->down_box(FL_DOWN_BOX);
          btnQSK->callback((Fl_Callback*)cb_btnQSK);
          o->value(progdefaults.QSK);
        } // Fl_Check_Button* btnQSK
        { Fl_Counter2* o = cntQSKfrequency = new Fl_Counter2(215, 206, 125, 24, gettext("QSK frequency"));
          cntQSKfrequency->tooltip(gettext("Fundamental frequency of QSK square wave signal"));
          cntQSKfrequency->box(FL_UP_BOX);
          cntQSKfrequency->color(FL_BACKGROUND_COLOR);
          cntQSKfrequency->selection_color(FL_INACTIVE_COLOR);
          cntQSKfrequency->labeltype(FL_NORMAL_LABEL);
          cntQSKfrequency->labelfont(0);
          cntQSKfrequency->labelsize(14);
          cntQSKfrequency->labelcolor(FL_FOREGROUND_COLOR);
          cntQSKfrequency->minimum(800);
          cntQSKfrequency->maximum(8000);
          cntQSKfrequency->step(5);
          cntQSKfrequency->value(3200);
          cntQSKfrequency->callback((Fl_Callback*)cb_cntQSKfrequency);
          cntQSKfrequency->align(Fl_Align(FL_ALIGN_RIGHT));
          cntQSKfrequency->when(FL_WHEN_CHANGED);
          o->value(progdefaults.QSKfrequency);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(100);
        } // Fl_Counter2* cntQSKfrequency
        { Fl_Counter2* o = cntPreTiming = new Fl_Counter2(476, 206, 125, 24, gettext("Pre-keydown timing (ms)"));
          cntPreTiming->tooltip(gettext("Msec pre-keydown"));
          cntPreTiming->box(FL_UP_BOX);
          cntPreTiming->color(FL_BACKGROUND_COLOR);
          cntPreTiming->selection_color(FL_INACTIVE_COLOR);
          cntPreTiming->labeltype(FL_NORMAL_LABEL);
          cntPreTiming->labelfont(0);
          cntPreTiming->labelsize(14);
          cntPreTiming->labelcolor(FL_FOREGROUND_COLOR);
          cntPreTiming->minimum(0);
          cntPreTiming->maximum(100);
          cntPreTiming->callback((Fl_Callback*)cb_cntPreTiming);
          cntPreTiming->align(Fl_Align(FL_ALIGN_RIGHT));
          cntPreTiming->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWpre);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(1);
        } // Fl_Counter2* cntPreTiming
        { Fl_Counter2* o = cntPostTiming = new Fl_Counter2(476, 237, 125, 24, gettext("Post-keydown timing (ms)"));
          cntPostTiming->tooltip(gettext("Msec post-keydown"));
          cntPostTiming->box(FL_UP_BOX);
          cntPostTiming->color(FL_BACKGROUND_COLOR);
          cntPostTiming->selection_color(FL_INACTIVE_COLOR);
          cntPostTiming->labeltype(FL_NORMAL_LABEL);
          cntPostTiming->labelfont(0);
          cntPostTiming->labelsize(14);
          cntPostTiming->labelcolor(FL_FOREGROUND_COLOR);
          cntPostTiming->minimum(0);
          cntPostTiming->maximum(100);
          cntPostTiming->callback((Fl_Callback*)cb_cntPostTiming);
          cntPostTiming->align(Fl_Align(FL_ALIGN_RIGHT));
          cntPostTiming->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWpost);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(1);
        } // Fl_Counter2* cntPostTiming
        { Fl_Counter2* o = cntQSKamp = new Fl_Counter2(215, 237, 125, 24, gettext("QSK amplitude"));
          cntQSKamp->tooltip(gettext("Amplitude of right channel QSK signal"));
          cntQSKamp->box(FL_UP_BOX);
          cntQSKamp->color(FL_BACKGROUND_COLOR);
          cntQSKamp->selection_color(FL_INACTIVE_COLOR);
          cntQSKamp->labeltype(FL_NORMAL_LABEL);
          cntQSKamp->labelfont(0);
          cntQSKamp->labelsize(14);
          cntQSKamp->labelcolor(FL_FOREGROUND_COLOR);
          cntQSKamp->minimum(0);
          cntQSKamp->maximum(1);
          cntQSKamp->step(0.01);
          cntQSKamp->value(0.8);
          cntQSKamp->callback((Fl_Callback*)cb_cntQSKamp);
          cntQSKamp->align(Fl_Align(FL_ALIGN_RIGHT));
          cntQSKamp->when(FL_WHEN_CHANGED);
          o->value(progdefaults.QSKamp);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(0.1);
        } // Fl_Counter2* cntQSKamp
        { Fl_Counter2* o = cntQSKrisetime = new Fl_Counter2(215, 270, 125, 24, gettext("Edge timing"));
          cntQSKrisetime->tooltip(gettext("Leading and Trailing edge risetimes (msec)"));
          cntQSKrisetime->box(FL_UP_BOX);
          cntQSKrisetime->color(FL_BACKGROUND_COLOR);
          cntQSKrisetime->selection_color(FL_INACTIVE_COLOR);
          cntQSKrisetime->labeltype(FL_NORMAL_LABEL);
          cntQSKrisetime->labelfont(0);
          cntQSKrisetime->labelsize(14);
          cntQSKrisetime->labelcolor(FL_FOREGROUND_COLOR);
          cntQSKrisetime->minimum(0);
          cntQSKrisetime->maximum(15);
          cntQSKrisetime->value(4);
          cntQSKrisetime->callback((Fl_Callback*)cb_cntQSKrisetime);
          cntQSKrisetime->align(Fl_Align(FL_ALIGN_RIGHT));
          cntQSKrisetime->when(FL_WHEN_CHANGED);
          o->value(progdefaults.QSKrisetime);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(1);
        } // Fl_Counter2* cntQSKrisetime
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 310, 590, 40, gettext("Send Test character"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = i_listbox_test_char = new Fl_ListBox(391, 319, 112, 22, gettext("Test char"));
          i_listbox_test_char->tooltip(gettext("Test character for QSK adjustment"));
          i_listbox_test_char->box(FL_DOWN_BOX);
          i_listbox_test_char->color(FL_BACKGROUND2_COLOR);
          i_listbox_test_char->selection_color(FL_BACKGROUND_COLOR);
          i_listbox_test_char->labeltype(FL_NORMAL_LABEL);
          i_listbox_test_char->labelfont(0);
          i_listbox_test_char->labelsize(14);
          i_listbox_test_char->labelcolor(FL_FOREGROUND_COLOR);
          i_listbox_test_char->callback((Fl_Callback*)cb_i_listbox_test_char);
          i_listbox_test_char->align(Fl_Align(FL_ALIGN_RIGHT));
          i_listbox_test_char->when(FL_WHEN_RELEASE);
          o->add(szTestChar);
          o->index(progdefaults.TestChar);
          o->labelsize(FL_NORMAL_SIZE);
          i_listbox_test_char->end();
        } // Fl_ListBox* i_listbox_test_char
        { Fl_Check_Button* o = btnQSKadjust = new Fl_Check_Button(585, 321, 152, 18, gettext("Send continuously"));
          btnQSKadjust->tooltip(gettext("Send a continuous stream of test characters"));
          btnQSKadjust->down_box(FL_DOWN_BOX);
          btnQSKadjust->callback((Fl_Callback*)cb_btnQSKadjust);
          o->value(progdefaults.QSKadjust);
        } // Fl_Check_Button* btnQSKadjust
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/Timing and QSK"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/Timing and QSK"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/Prosigns"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(555, 39, 182, 262, gettext("Use these for WinKeyer\nand nanoCW"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Box* o = new Fl_Box(615, 70, 59, 22, gettext("\" RR"));
          o->tooltip(gettext(".-..-."));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 90, 59, 22, gettext("$ SX"));
          o->tooltip(gettext("...-..-"));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 109, 59, 22, gettext("\' WG"));
          o->tooltip(gettext(".----."));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 128, 59, 22, gettext("( KN"));
          o->tooltip(gettext("-.--."));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 147, 59, 22, gettext(") KK"));
          o->tooltip(gettext("-.--.-"));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 166, 59, 22, gettext("+ AR"));
          o->tooltip(gettext(".-.-."));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 185, 59, 22, gettext("< AR"));
          o->tooltip(gettext(".-.-."));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 204, 59, 22, gettext("> SK"));
          o->tooltip(gettext("...-.-"));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 223, 59, 22, gettext("= BT"));
          o->tooltip(gettext("-...-"));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 242, 59, 22, gettext("- DU"));
          o->tooltip(gettext("-....-"));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(615, 263, 59, 22, gettext("@@ AC"));
          o->tooltip(gettext(".--.-."));
        } // Fl_Box* o
        o->end();
      } // Fl_Group* o
      { Fl_ListBox* o = listbox_prosign[0] = new Fl_ListBox(304, 50, 47, 22, gettext("<BT>"));
        listbox_prosign[0]->box(FL_DOWN_BOX);
        listbox_prosign[0]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[0]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[0]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[0]->labelfont(0);
        listbox_prosign[0]->labelsize(14);
        listbox_prosign[0]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[0]->callback((Fl_Callback*)cb_listbox_prosign);
        listbox_prosign[0]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[0]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[0];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[0]->end();
      } // Fl_ListBox* listbox_prosign[0]
      { Fl_ListBox* o = listbox_prosign[1] = new Fl_ListBox(304, 77, 47, 22, gettext("<AA>"));
        listbox_prosign[1]->box(FL_DOWN_BOX);
        listbox_prosign[1]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[1]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[1]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[1]->labelfont(0);
        listbox_prosign[1]->labelsize(14);
        listbox_prosign[1]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[1]->callback((Fl_Callback*)cb_listbox_prosign1);
        listbox_prosign[1]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[1]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[1];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[1]->end();
      } // Fl_ListBox* listbox_prosign[1]
      { Fl_ListBox* o = listbox_prosign[2] = new Fl_ListBox(304, 105, 47, 22, gettext("<AS>"));
        listbox_prosign[2]->box(FL_DOWN_BOX);
        listbox_prosign[2]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[2]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[2]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[2]->labelfont(0);
        listbox_prosign[2]->labelsize(14);
        listbox_prosign[2]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[2]->callback((Fl_Callback*)cb_listbox_prosign2);
        listbox_prosign[2]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[2]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[2];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[2]->end();
      } // Fl_ListBox* listbox_prosign[2]
      { Fl_ListBox* o = listbox_prosign[3] = new Fl_ListBox(304, 132, 47, 22, gettext("<AR>"));
        listbox_prosign[3]->box(FL_DOWN_BOX);
        listbox_prosign[3]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[3]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[3]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[3]->labelfont(0);
        listbox_prosign[3]->labelsize(14);
        listbox_prosign[3]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[3]->callback((Fl_Callback*)cb_listbox_prosign3);
        listbox_prosign[3]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[3]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[3];
        o->value(s);
        listbox_prosign[3]->end();
      } // Fl_ListBox* listbox_prosign[3]
      { Fl_ListBox* o = listbox_prosign[4] = new Fl_ListBox(304, 160, 47, 22, gettext("<SK>"));
        listbox_prosign[4]->box(FL_DOWN_BOX);
        listbox_prosign[4]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[4]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[4]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[4]->labelfont(0);
        listbox_prosign[4]->labelsize(14);
        listbox_prosign[4]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[4]->callback((Fl_Callback*)cb_listbox_prosign4);
        listbox_prosign[4]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[4]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[4];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[4]->end();
      } // Fl_ListBox* listbox_prosign[4]
      { Fl_ListBox* o = listbox_prosign[5] = new Fl_ListBox(304, 188, 47, 22, gettext("<KN>"));
        listbox_prosign[5]->box(FL_DOWN_BOX);
        listbox_prosign[5]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[5]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[5]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[5]->labelfont(0);
        listbox_prosign[5]->labelsize(14);
        listbox_prosign[5]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[5]->callback((Fl_Callback*)cb_listbox_prosign5);
        listbox_prosign[5]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[5]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[5];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[5]->end();
      } // Fl_ListBox* listbox_prosign[5]
      { Fl_ListBox* o = listbox_prosign[6] = new Fl_ListBox(304, 215, 47, 22, gettext("<INT>"));
        listbox_prosign[6]->box(FL_DOWN_BOX);
        listbox_prosign[6]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[6]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[6]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[6]->labelfont(0);
        listbox_prosign[6]->labelsize(14);
        listbox_prosign[6]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[6]->callback((Fl_Callback*)cb_listbox_prosign6);
        listbox_prosign[6]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[6]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[6];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[6]->end();
      } // Fl_ListBox* listbox_prosign[6]
      { Fl_ListBox* o = listbox_prosign[7] = new Fl_ListBox(304, 243, 47, 22, gettext("<HM>"));
        listbox_prosign[7]->box(FL_DOWN_BOX);
        listbox_prosign[7]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[7]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[7]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[7]->labelfont(0);
        listbox_prosign[7]->labelsize(14);
        listbox_prosign[7]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[7]->callback((Fl_Callback*)cb_listbox_prosign7);
        listbox_prosign[7]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[7]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[7];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[7]->end();
      } // Fl_ListBox* listbox_prosign[7]
      { Fl_ListBox* o = listbox_prosign[8] = new Fl_ListBox(304, 271, 47, 22, gettext("<VE>"));
        listbox_prosign[8]->box(FL_DOWN_BOX);
        listbox_prosign[8]->color(FL_BACKGROUND2_COLOR);
        listbox_prosign[8]->selection_color(FL_BACKGROUND_COLOR);
        listbox_prosign[8]->labeltype(FL_NORMAL_LABEL);
        listbox_prosign[8]->labelfont(0);
        listbox_prosign[8]->labelsize(14);
        listbox_prosign[8]->labelcolor(FL_FOREGROUND_COLOR);
        listbox_prosign[8]->callback((Fl_Callback*)cb_listbox_prosign8);
        listbox_prosign[8]->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_prosign[8]->when(FL_WHEN_RELEASE);
        o->add(szProsigns);
        char s[2] = " "; s[0] = progdefaults.CW_prosigns[8];
        o->value(s);
                       o->labelsize(FL_NORMAL_SIZE);
        listbox_prosign[8]->end();
      } // Fl_ListBox* listbox_prosign[8]
      { Fl_Check_Button* o = btnCW_use_paren = new Fl_Check_Button(354, 187, 68, 15, gettext("Use \'(\' paren not KN"));
        btnCW_use_paren->down_box(FL_DOWN_BOX);
        btnCW_use_paren->callback((Fl_Callback*)cb_btnCW_use_paren);
        o->value(progdefaults.CW_use_paren);
      } // Fl_Check_Button* btnCW_use_paren
      { Fl_Check_Button* o = btnCW_prosign_display = new Fl_Check_Button(304, 301, 68, 15, gettext("Display decoded as assigned key"));
        btnCW_prosign_display->tooltip(gettext("Display the decoded prosign in the RX text using the short cut key"));
        btnCW_prosign_display->down_box(FL_DOWN_BOX);
        btnCW_prosign_display->callback((Fl_Callback*)cb_btnCW_prosign_display);
        o->value(progdefaults.CW_prosign_display);
      } // Fl_Check_Button* btnCW_prosign_display
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/Prosigns"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/Prosigns"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/Extended Chars."));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 30, 590, 286, gettext("Check to enable character encode/decode\nSelect one character from each group"));
        o->box(FL_FLAT_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Group* o = new Fl_Group(210, 109, 99, 80);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Check_Button* o = btn_A_aelig = new Fl_Check_Button(216, 125, 70, 15, gettext("A aelig"));
            btn_A_aelig->tooltip(gettext("Swap left/right keyer contacts"));
            btn_A_aelig->down_box(FL_DOWN_BOX);
            btn_A_aelig->callback((Fl_Callback*)cb_btn_A_aelig);
            o->value(progdefaults.A_aelig);
          } // Fl_Check_Button* btn_A_aelig
          { Fl_Check_Button* o = btn_A_umlaut = new Fl_Check_Button(216, 162, 70, 15, gettext(" A umlaut"));
            btn_A_umlaut->tooltip(gettext("Swap left/right keyer contacts"));
            btn_A_umlaut->down_box(FL_DOWN_BOX);
            btn_A_umlaut->callback((Fl_Callback*)cb_btn_A_umlaut);
            o->value(progdefaults.A_umlaut);
          } // Fl_Check_Button* btn_A_umlaut
          o->end();
        } // Fl_Group* o
        { Fl_Check_Button* o = btn_A_ring = new Fl_Check_Button(216, 199, 70, 15, gettext(" A ring"));
          btn_A_ring->tooltip(gettext("Swap left/right keyer contacts"));
          btn_A_ring->down_box(FL_DOWN_BOX);
          btn_A_ring->callback((Fl_Callback*)cb_btn_A_ring);
          o->value(progdefaults.A_ring);
        } // Fl_Check_Button* btn_A_ring
        { Fl_Group* o = new Fl_Group(311, 109, 99, 120);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Check_Button* o = btn_O_acute = new Fl_Check_Button(316, 125, 70, 15, gettext(" O acute"));
            btn_O_acute->tooltip(gettext("Swap left/right keyer contacts"));
            btn_O_acute->down_box(FL_DOWN_BOX);
            btn_O_acute->callback((Fl_Callback*)cb_btn_O_acute);
            o->value(progdefaults.O_acute);
          } // Fl_Check_Button* btn_O_acute
          { Fl_Check_Button* o = btn_O_slash = new Fl_Check_Button(316, 199, 70, 15, gettext(" O slash"));
            btn_O_slash->tooltip(gettext("Swap left/right keyer contacts"));
            btn_O_slash->down_box(FL_DOWN_BOX);
            btn_O_slash->callback((Fl_Callback*)cb_btn_O_slash);
            o->value(progdefaults.O_slash);
          } // Fl_Check_Button* btn_O_slash
          { Fl_Check_Button* o = btn_O_umlaut = new Fl_Check_Button(316, 162, 70, 15, gettext(" O umlaut"));
            btn_O_umlaut->tooltip(gettext("Swap left/right keyer contacts"));
            btn_O_umlaut->down_box(FL_DOWN_BOX);
            btn_O_umlaut->callback((Fl_Callback*)cb_btn_O_umlaut);
            o->value(progdefaults.O_umlaut);
          } // Fl_Check_Button* btn_O_umlaut
          o->end();
        } // Fl_Group* o
        { Fl_Check_Button* o = btn_C_cedilla = new Fl_Check_Button(413, 125, 70, 15, gettext(" C cedilla"));
          btn_C_cedilla->tooltip(gettext("Swap left/right keyer contacts"));
          btn_C_cedilla->down_box(FL_DOWN_BOX);
          btn_C_cedilla->callback((Fl_Callback*)cb_btn_C_cedilla);
          o->value(progdefaults.C_cedilla);
        } // Fl_Check_Button* btn_C_cedilla
        { Fl_Check_Button* o = btn_E_grave = new Fl_Check_Button(511, 125, 70, 15, gettext(" E grave"));
          btn_E_grave->tooltip(gettext("Swap left/right keyer contacts"));
          btn_E_grave->down_box(FL_DOWN_BOX);
          btn_E_grave->callback((Fl_Callback*)cb_btn_E_grave);
          o->value(progdefaults.E_grave);
        } // Fl_Check_Button* btn_E_grave
        { Fl_Check_Button* o = btn_E_acute = new Fl_Check_Button(511, 162, 70, 15, gettext(" E acute"));
          btn_E_acute->tooltip(gettext("Swap left/right keyer contacts"));
          btn_E_acute->down_box(FL_DOWN_BOX);
          btn_E_acute->callback((Fl_Callback*)cb_btn_E_acute);
          o->value(progdefaults.E_acute);
        } // Fl_Check_Button* btn_E_acute
        { Fl_Check_Button* o = btn_N_tilde = new Fl_Check_Button(604, 125, 70, 15, gettext(" N tilde"));
          btn_N_tilde->tooltip(gettext("Swap left/right keyer contacts"));
          btn_N_tilde->down_box(FL_DOWN_BOX);
          btn_N_tilde->callback((Fl_Callback*)cb_btn_N_tilde);
          o->value(progdefaults.N_tilde);
        } // Fl_Check_Button* btn_N_tilde
        { Fl_Group* o = new Fl_Group(690, 109, 99, 80);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Check_Button* o = btn_U_umlaut = new Fl_Check_Button(695, 125, 70, 15, gettext(" U umlaut"));
            btn_U_umlaut->tooltip(gettext("Swap left/right keyer contacts"));
            btn_U_umlaut->down_box(FL_DOWN_BOX);
            btn_U_umlaut->callback((Fl_Callback*)cb_btn_U_umlaut);
            o->value(progdefaults.U_umlaut);
          } // Fl_Check_Button* btn_U_umlaut
          { Fl_Check_Button* o = btn_U_circ = new Fl_Check_Button(695, 162, 70, 15, gettext(" U circ"));
            btn_U_circ->tooltip(gettext("Swap left/right keyer contacts"));
            btn_U_circ->down_box(FL_DOWN_BOX);
            btn_U_circ->callback((Fl_Callback*)cb_btn_U_circ);
            o->value(progdefaults.U_circ);
          } // Fl_Check_Button* btn_U_circ
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(310, 249, 403, 45, gettext("See https://en.wikipedia.org/wiki/Morse_code\nfor information regarding exten"
"ded Morse characters."));
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/Extended Chars."));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/Extended Chars."));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Punctuation/Noise Processing"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 30, 590, 190, gettext("Check to enable character encode/decode"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_CW_backslash = new Fl_Check_Button(265, 65, 70, 15, gettext(" backslash \\     \".-..-.\""));
          btn_CW_backslash->tooltip(gettext("disable for no printed character"));
          btn_CW_backslash->down_box(FL_DOWN_BOX);
          btn_CW_backslash->value(1);
          btn_CW_backslash->labelfont(4);
          btn_CW_backslash->callback((Fl_Callback*)cb_btn_CW_backslash);
          o->value(progdefaults.CW_backslash);
        } // Fl_Check_Button* btn_CW_backslash
        { Fl_Check_Button* o = btn_CW_apostrophe = new Fl_Check_Button(265, 90, 70, 15, gettext(" apostrophe \'    \".----.\""));
          btn_CW_apostrophe->tooltip(gettext("disable for no printed character"));
          btn_CW_apostrophe->down_box(FL_DOWN_BOX);
          btn_CW_apostrophe->value(1);
          btn_CW_apostrophe->labelfont(4);
          btn_CW_apostrophe->callback((Fl_Callback*)cb_btn_CW_apostrophe);
          o->value(progdefaults.CW_apostrophe);
        } // Fl_Check_Button* btn_CW_apostrophe
        { Fl_Check_Button* o = btn_CW_quote = new Fl_Check_Button(265, 115, 70, 15, gettext(" quote \"         \".-..-.\""));
          btn_CW_quote->tooltip(gettext("disable for no printed character"));
          btn_CW_quote->down_box(FL_DOWN_BOX);
          btn_CW_quote->value(1);
          btn_CW_quote->labelfont(4);
          btn_CW_quote->callback((Fl_Callback*)cb_btn_CW_quote);
          o->value(progdefaults.CW_quote);
        } // Fl_Check_Button* btn_CW_quote
        { Fl_Check_Button* o = btn_CW_dollar_sign = new Fl_Check_Button(265, 140, 70, 15, gettext(" dollar sign $   \"...-..-\""));
          btn_CW_dollar_sign->tooltip(gettext("disable for no printed character"));
          btn_CW_dollar_sign->down_box(FL_DOWN_BOX);
          btn_CW_dollar_sign->value(1);
          btn_CW_dollar_sign->labelfont(4);
          btn_CW_dollar_sign->callback((Fl_Callback*)cb_btn_CW_dollar_sign);
          o->value(progdefaults.CW_dollar_sign);
        } // Fl_Check_Button* btn_CW_dollar_sign
        { Fl_Check_Button* o = btn_CW_open_paren = new Fl_Check_Button(265, 165, 70, 15, gettext(" open_paren (    \"-.--.\""));
          btn_CW_open_paren->tooltip(gettext("disable for no printed character"));
          btn_CW_open_paren->down_box(FL_DOWN_BOX);
          btn_CW_open_paren->value(1);
          btn_CW_open_paren->labelfont(4);
          btn_CW_open_paren->callback((Fl_Callback*)cb_btn_CW_open_paren);
          o->value(progdefaults.CW_open_paren);
        } // Fl_Check_Button* btn_CW_open_paren
        { Fl_Check_Button* o = btn_CW_close_paren = new Fl_Check_Button(265, 190, 70, 15, gettext(" close paren )   \"-.--.-\""));
          btn_CW_close_paren->tooltip(gettext("disable for no printed character"));
          btn_CW_close_paren->down_box(FL_DOWN_BOX);
          btn_CW_close_paren->value(1);
          btn_CW_close_paren->labelfont(4);
          btn_CW_close_paren->callback((Fl_Callback*)cb_btn_CW_close_paren);
          o->value(progdefaults.CW_close_paren);
        } // Fl_Check_Button* btn_CW_close_paren
        { Fl_Check_Button* o = btn_CW_colon = new Fl_Check_Button(535, 65, 70, 15, gettext(" colon :        \"---...\""));
          btn_CW_colon->tooltip(gettext("disable for no printed character"));
          btn_CW_colon->down_box(FL_DOWN_BOX);
          btn_CW_colon->value(1);
          btn_CW_colon->labelfont(4);
          btn_CW_colon->callback((Fl_Callback*)cb_btn_CW_colon);
          o->value(progdefaults.CW_colon);
        } // Fl_Check_Button* btn_CW_colon
        { Fl_Check_Button* o = btn_CW_semi_colon = new Fl_Check_Button(535, 90, 70, 15, gettext(" semi colon ;   \"-.-.-.\""));
          btn_CW_semi_colon->tooltip(gettext("disable for no printed character"));
          btn_CW_semi_colon->down_box(FL_DOWN_BOX);
          btn_CW_semi_colon->value(1);
          btn_CW_semi_colon->labelfont(4);
          btn_CW_semi_colon->callback((Fl_Callback*)cb_btn_CW_semi_colon);
          o->value(progdefaults.CW_semi_colon);
        } // Fl_Check_Button* btn_CW_semi_colon
        { Fl_Check_Button* o = btn_CW_underscore = new Fl_Check_Button(535, 115, 70, 15, gettext(" underscore _   \"..--.-\""));
          btn_CW_underscore->tooltip(gettext("disable for no printed character"));
          btn_CW_underscore->down_box(FL_DOWN_BOX);
          btn_CW_underscore->value(1);
          btn_CW_underscore->labelfont(4);
          btn_CW_underscore->callback((Fl_Callback*)cb_btn_CW_underscore);
          o->value(progdefaults.CW_underscore);
        } // Fl_Check_Button* btn_CW_underscore
        { Fl_Check_Button* o = btn_CW_at_symbol = new Fl_Check_Button(535, 140, 70, 15, gettext(" at symbol @@    \".--.-.\""));
          btn_CW_at_symbol->tooltip(gettext("disable for no printed character"));
          btn_CW_at_symbol->down_box(FL_DOWN_BOX);
          btn_CW_at_symbol->value(1);
          btn_CW_at_symbol->labelfont(4);
          btn_CW_at_symbol->callback((Fl_Callback*)cb_btn_CW_at_symbol);
          o->value(progdefaults.CW_at_symbol);
        } // Fl_Check_Button* btn_CW_at_symbol
        { Fl_Check_Button* o = btn_CW_exclamation = new Fl_Check_Button(535, 165, 70, 15, gettext(" exclamation !  \"-.-.--\""));
          btn_CW_exclamation->tooltip(gettext("disable for no printed character"));
          btn_CW_exclamation->down_box(FL_DOWN_BOX);
          btn_CW_exclamation->value(1);
          btn_CW_exclamation->labelfont(4);
          btn_CW_exclamation->callback((Fl_Callback*)cb_btn_CW_exclamation);
          o->value(progdefaults.CW_exclamation);
        } // Fl_Check_Button* btn_CW_exclamation
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 224, 590, 120, gettext("Unknown character decode (noise)"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_CW_noise0 = new Fl_Check_Button(265, 248, 193, 15, gettext(" Do not display unknown MORSE symbol"));
          btn_CW_noise0->tooltip(gettext("disable \'*\'or no printed character"));
          btn_CW_noise0->down_box(FL_DOWN_BOX);
          btn_CW_noise0->labelfont(4);
          btn_CW_noise0->callback((Fl_Callback*)cb_btn_CW_noise0);
          o->value(progdefaults.CW_noise == 0);
        } // Fl_Check_Button* btn_CW_noise0
        { Fl_Check_Button* o = btn_CW_noise1 = new Fl_Check_Button(265, 264, 193, 24, gettext(" Display \'*\' character for unknown MORSE symbol"));
          btn_CW_noise1->tooltip(gettext("disable \'*\'or no printed character"));
          btn_CW_noise1->down_box(FL_DOWN_BOX);
          btn_CW_noise1->labelfont(4);
          btn_CW_noise1->callback((Fl_Callback*)cb_btn_CW_noise1);
          o->value(progdefaults.CW_noise == '*');
        } // Fl_Check_Button* btn_CW_noise1
        { Fl_Check_Button* o = btn_CW_noise2 = new Fl_Check_Button(265, 289, 193, 24, gettext(" Display \'_\' character for unknown MORSE symbol"));
          btn_CW_noise2->tooltip(gettext("disable \'_\' for no printed character"));
          btn_CW_noise2->down_box(FL_DOWN_BOX);
          btn_CW_noise2->labelfont(4);
          btn_CW_noise2->callback((Fl_Callback*)cb_btn_CW_noise2);
          o->value(progdefaults.CW_noise == '_');
        } // Fl_Check_Button* btn_CW_noise2
        { Fl_Check_Button* o = btn_CW_noise3 = new Fl_Check_Button(265, 314, 193, 24, gettext(" Display \' \' character for unknown MORSE symbol"));
          btn_CW_noise3->tooltip(gettext("disable \' \' for no printed character"));
          btn_CW_noise3->down_box(FL_DOWN_BOX);
          btn_CW_noise3->labelfont(4);
          btn_CW_noise3->callback((Fl_Callback*)cb_btn_CW_noise3);
          o->value(progdefaults.CW_noise == ' ');
        } // Fl_Check_Button* btn_CW_noise3
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/Punctuation-Noise"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/Punctuation-Noise"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/WinKeyer"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_ComboBox* o = select_WK_CommPort = new Fl_ComboBox(274, 30, 405, 25, gettext("Ser. Port"));
        select_WK_CommPort->tooltip(gettext("Xcvr serial port"));
        select_WK_CommPort->box(FL_DOWN_BOX);
        select_WK_CommPort->color((Fl_Color)55);
        select_WK_CommPort->selection_color(FL_BACKGROUND_COLOR);
        select_WK_CommPort->labeltype(FL_NORMAL_LABEL);
        select_WK_CommPort->labelfont(0);
        select_WK_CommPort->labelsize(14);
        select_WK_CommPort->labelcolor(FL_FOREGROUND_COLOR);
        select_WK_CommPort->callback((Fl_Callback*)cb_select_WK_CommPort);
        select_WK_CommPort->align(Fl_Align(FL_ALIGN_LEFT));
        select_WK_CommPort->when(FL_WHEN_RELEASE);
        o->value(progStatus.WK_serial_port_name.c_str());
        select_WK_CommPort->end();
      } // Fl_ComboBox* select_WK_CommPort
      { Fl_Light_Button* o = btn_WKCW_connect = new Fl_Light_Button(705, 30, 80, 25, gettext("Connect"));
        btn_WKCW_connect->tooltip(gettext("Connect / Disconnect from WinKeyer"));
        btn_WKCW_connect->callback((Fl_Callback*)cb_btn_WKCW_connect);
        o->value(progStatus.WK_online);
      } // Fl_Light_Button* btn_WKCW_connect
      { box_WK_wait = new Fl_Box(269, 66, 16, 16, gettext("Wait"));
        box_WK_wait->box(FL_DIAMOND_DOWN_BOX);
        box_WK_wait->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Box* box_WK_wait
      { box_WK_break_in = new Fl_Box(344, 66, 16, 16, gettext("Bk"));
        box_WK_break_in->box(FL_DIAMOND_DOWN_BOX);
        box_WK_break_in->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Box* box_WK_break_in
      { box_WK_busy = new Fl_Box(419, 66, 16, 16, gettext("Busy"));
        box_WK_busy->box(FL_DIAMOND_DOWN_BOX);
        box_WK_busy->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Box* box_WK_busy
      { box_WK_xoff = new Fl_Box(494, 66, 16, 16, gettext("Bfr"));
        box_WK_xoff->box(FL_DIAMOND_DOWN_BOX);
        box_WK_xoff->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Box* box_WK_xoff
      { box_WK_keydown = new Fl_Box(570, 66, 16, 16, gettext("Key"));
        box_WK_keydown->box(FL_DIAMOND_DOWN_BOX);
        box_WK_keydown->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Box* box_WK_keydown
      { choice_WK_keyer_mode = new Fl_ComboBox(237, 104, 90, 22, gettext("Keyer Mode"));
        choice_WK_keyer_mode->box(FL_BORDER_BOX);
        choice_WK_keyer_mode->color((Fl_Color)55);
        choice_WK_keyer_mode->selection_color(FL_BACKGROUND_COLOR);
        choice_WK_keyer_mode->labeltype(FL_NORMAL_LABEL);
        choice_WK_keyer_mode->labelfont(0);
        choice_WK_keyer_mode->labelsize(14);
        choice_WK_keyer_mode->labelcolor(FL_FOREGROUND_COLOR);
        choice_WK_keyer_mode->callback((Fl_Callback*)cb_choice_WK_keyer_mode);
        choice_WK_keyer_mode->align(Fl_Align(FL_ALIGN_TOP));
        choice_WK_keyer_mode->when(FL_WHEN_RELEASE);
        choice_WK_keyer_mode->end();
      } // Fl_ComboBox* choice_WK_keyer_mode
      { choice_WK_hang = new Fl_ComboBox(383, 104, 90, 22, gettext("Hang"));
        choice_WK_hang->box(FL_BORDER_BOX);
        choice_WK_hang->color((Fl_Color)55);
        choice_WK_hang->selection_color(FL_BACKGROUND_COLOR);
        choice_WK_hang->labeltype(FL_NORMAL_LABEL);
        choice_WK_hang->labelfont(0);
        choice_WK_hang->labelsize(14);
        choice_WK_hang->labelcolor(FL_FOREGROUND_COLOR);
        choice_WK_hang->callback((Fl_Callback*)cb_choice_WK_hang);
        choice_WK_hang->align(Fl_Align(FL_ALIGN_TOP));
        choice_WK_hang->when(FL_WHEN_RELEASE);
        choice_WK_hang->end();
      } // Fl_ComboBox* choice_WK_hang
      { choice_WK_sidetone = new Fl_ComboBox(530, 104, 90, 22, gettext("Sidetone"));
        choice_WK_sidetone->box(FL_BORDER_BOX);
        choice_WK_sidetone->color((Fl_Color)55);
        choice_WK_sidetone->selection_color(FL_BACKGROUND_COLOR);
        choice_WK_sidetone->labeltype(FL_NORMAL_LABEL);
        choice_WK_sidetone->labelfont(0);
        choice_WK_sidetone->labelsize(14);
        choice_WK_sidetone->labelcolor(FL_FOREGROUND_COLOR);
        choice_WK_sidetone->callback((Fl_Callback*)cb_choice_WK_sidetone);
        choice_WK_sidetone->align(Fl_Align(FL_ALIGN_TOP));
        choice_WK_sidetone->when(FL_WHEN_RELEASE);
        choice_WK_sidetone->end();
      } // Fl_ComboBox* choice_WK_sidetone
      { choice_WK_output_pins = new Fl_ComboBox(677, 104, 90, 22, gettext("Output PIns"));
        choice_WK_output_pins->box(FL_BORDER_BOX);
        choice_WK_output_pins->color((Fl_Color)55);
        choice_WK_output_pins->selection_color(FL_BACKGROUND_COLOR);
        choice_WK_output_pins->labeltype(FL_NORMAL_LABEL);
        choice_WK_output_pins->labelfont(0);
        choice_WK_output_pins->labelsize(14);
        choice_WK_output_pins->labelcolor(FL_FOREGROUND_COLOR);
        choice_WK_output_pins->callback((Fl_Callback*)cb_choice_WK_output_pins);
        choice_WK_output_pins->align(Fl_Align(FL_ALIGN_TOP));
        choice_WK_output_pins->when(FL_WHEN_RELEASE);
        choice_WK_output_pins->end();
      } // Fl_ComboBox* choice_WK_output_pins
      { btn_WK_use_pot = new Fl_Check_Button(623, 64, 20, 16, gettext("Use Pot"));
        btn_WK_use_pot->tooltip(gettext("Winkeyer pot controls WPM"));
        btn_WK_use_pot->down_box(FL_DOWN_BOX);
        btn_WK_use_pot->callback((Fl_Callback*)cb_btn_WK_use_pot);
        btn_WK_use_pot->align(Fl_Align(FL_ALIGN_RIGHT));
        btn_WK_use_pot->when(FL_WHEN_CHANGED);
      } // Fl_Check_Button* btn_WK_use_pot
      { txt_WK_wpm = new Fl_Output(710, 61, 50, 24);
        txt_WK_wpm->tooltip(gettext("WPM setting"));
      } // Fl_Output* txt_WK_wpm
      { Fl_Group* o = new Fl_Group(210, 132, 134, 184, gettext("ModeReg"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { btn_WK_swap = new Fl_Check_Button(220, 174, 70, 15, gettext("Swap"));
          btn_WK_swap->tooltip(gettext("Swap left/right keyer contacts"));
          btn_WK_swap->down_box(FL_DOWN_BOX);
          btn_WK_swap->callback((Fl_Callback*)cb_btn_WK_swap);
        } // Fl_Check_Button* btn_WK_swap
        { btn_WK_auto_space = new Fl_Check_Button(220, 204, 70, 15, gettext("Auto Space"));
          btn_WK_auto_space->tooltip(gettext("Enable paddle auto spacing of characters"));
          btn_WK_auto_space->down_box(FL_DOWN_BOX);
          btn_WK_auto_space->callback((Fl_Callback*)cb_btn_WK_auto_space);
        } // Fl_Check_Button* btn_WK_auto_space
        { btn_WK_ct_space = new Fl_Check_Button(220, 234, 70, 15, gettext("CT space"));
          btn_WK_ct_space->tooltip(gettext("Enable contest character spacing"));
          btn_WK_ct_space->down_box(FL_DOWN_BOX);
          btn_WK_ct_space->callback((Fl_Callback*)cb_btn_WK_ct_space);
        } // Fl_Check_Button* btn_WK_ct_space
        { btn_WK_paddledog = new Fl_Check_Button(220, 264, 70, 15, gettext("Paddle Dog"));
          btn_WK_paddledog->down_box(FL_DOWN_BOX);
          btn_WK_paddledog->callback((Fl_Callback*)cb_btn_WK_paddledog);
        } // Fl_Check_Button* btn_WK_paddledog
        { btn_WK_cut_zeronine = new Fl_Check_Button(220, 294, 70, 15, gettext("Cut 0/9"));
          btn_WK_cut_zeronine->tooltip(gettext("Use T/N for 0/9"));
          btn_WK_cut_zeronine->down_box(FL_DOWN_BOX);
          btn_WK_cut_zeronine->callback((Fl_Callback*)cb_btn_WK_cut_zeronine);
        } // Fl_Check_Button* btn_WK_cut_zeronine
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(367, 132, 134, 184, gettext("ModeReg"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { btn_WK_paddle_echo = new Fl_Check_Button(373, 174, 70, 16, gettext("Paddle echo"));
          btn_WK_paddle_echo->tooltip(gettext("Echo paddle chars to Rx Panel"));
          btn_WK_paddle_echo->down_box(FL_DOWN_BOX);
          btn_WK_paddle_echo->callback((Fl_Callback*)cb_btn_WK_paddle_echo);
        } // Fl_Check_Button* btn_WK_paddle_echo
        { btn_WK_serial_echo = new Fl_Check_Button(373, 204, 70, 16, gettext("Serial echo"));
          btn_WK_serial_echo->down_box(FL_DOWN_BOX);
          btn_WK_serial_echo->value(1);
          btn_WK_serial_echo->callback((Fl_Callback*)cb_btn_WK_serial_echo);
        } // Fl_Check_Button* btn_WK_serial_echo
        { btn_WK_sidetone_on = new Fl_Check_Button(373, 234, 103, 16, gettext("Tone Keyer"));
          btn_WK_sidetone_on->tooltip(gettext("Enable Winkeyer tone keying"));
          btn_WK_sidetone_on->down_box(FL_DOWN_BOX);
          btn_WK_sidetone_on->callback((Fl_Callback*)cb_btn_WK_sidetone_on);
        } // Fl_Check_Button* btn_WK_sidetone_on
        { btn_WK_tone_on = new Fl_Check_Button(373, 264, 87, 16, gettext("Tone ON"));
          btn_WK_tone_on->tooltip(gettext("Enable Winkeyer audio tone"));
          btn_WK_tone_on->down_box(FL_DOWN_BOX);
          btn_WK_tone_on->callback((Fl_Callback*)cb_btn_WK_tone_on);
        } // Fl_Check_Button* btn_WK_tone_on
        { btn_WK_ptt_on = new Fl_Check_Button(373, 294, 87, 16, gettext("PTT ON"));
          btn_WK_ptt_on->tooltip(gettext("Enable Winkeyer PTT output"));
          btn_WK_ptt_on->down_box(FL_DOWN_BOX);
          btn_WK_ptt_on->callback((Fl_Callback*)cb_btn_WK_ptt_on);
        } // Fl_Check_Button* btn_WK_ptt_on
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(510, 132, 112, 209, gettext("WPM Settings"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { cntr_WK_min_wpm = new Fl_Counter(531, 172, 64, 22, gettext("Min WPM"));
          cntr_WK_min_wpm->tooltip(gettext("Minimum WPM setting\ndefault = 10"));
          cntr_WK_min_wpm->type(1);
          cntr_WK_min_wpm->minimum(10);
          cntr_WK_min_wpm->maximum(30);
          cntr_WK_min_wpm->step(1);
          cntr_WK_min_wpm->value(10);
          cntr_WK_min_wpm->callback((Fl_Callback*)cb_cntr_WK_min_wpm);
        } // Fl_Counter* cntr_WK_min_wpm
        { cntr_WK_rng_wpm = new Fl_Counter(531, 215, 64, 21, gettext("Rng WPM"));
          cntr_WK_rng_wpm->tooltip(gettext("Range WPM setting\ndefault = 25"));
          cntr_WK_rng_wpm->type(1);
          cntr_WK_rng_wpm->callback((Fl_Callback*)cb_cntr_WK_rng_wpm);
        } // Fl_Counter* cntr_WK_rng_wpm
        { cntr_WK_farnsworth = new Fl_Counter(531, 257, 64, 22, gettext("Farsnworth"));
          cntr_WK_farnsworth->tooltip(gettext("Farnsworth keying (0 = none)\ndefault = 0"));
          cntr_WK_farnsworth->type(1);
          cntr_WK_farnsworth->callback((Fl_Callback*)cb_cntr_WK_farnsworth);
        } // Fl_Counter* cntr_WK_farnsworth
        { cntr_WK_cmd_wpm = new Fl_Counter(531, 300, 64, 22, gettext("Cmd WPM"));
          cntr_WK_cmd_wpm->tooltip(gettext("WPM speed for Winkeyer Command strings\ndefault = 18"));
          cntr_WK_cmd_wpm->type(1);
          cntr_WK_cmd_wpm->callback((Fl_Callback*)cb_cntr_WK_cmd_wpm);
        } // Fl_Counter* cntr_WK_cmd_wpm
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(630, 132, 160, 209, gettext("Timing/Settings"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { cntr_WK_ratio = new Fl_Counter(642, 172, 64, 22, gettext("Ratio"));
          cntr_WK_ratio->tooltip(gettext("Keying ratio\ndefault = 3.0"));
          cntr_WK_ratio->type(1);
          cntr_WK_ratio->callback((Fl_Callback*)cb_cntr_WK_ratio);
        } // Fl_Counter* cntr_WK_ratio
        { cntr_WK_comp = new Fl_Counter(642, 215, 64, 21, gettext("Comp"));
          cntr_WK_comp->tooltip(gettext("Compensation in msec\ndefault = 0"));
          cntr_WK_comp->type(1);
          cntr_WK_comp->callback((Fl_Callback*)cb_cntr_WK_comp);
        } // Fl_Counter* cntr_WK_comp
        { cntr_WK_first_ext = new Fl_Counter(642, 257, 64, 22, gettext("1st Ext"));
          cntr_WK_first_ext->tooltip(gettext("Extra duration to first dit/dot in msec\ndefault = 0"));
          cntr_WK_first_ext->type(1);
          cntr_WK_first_ext->callback((Fl_Callback*)cb_cntr_WK_first_ext);
        } // Fl_Counter* cntr_WK_first_ext
        { cntr_WK_sample = new Fl_Counter(642, 300, 64, 22, gettext("Sample"));
          cntr_WK_sample->tooltip(gettext("Paddle sampling (see Winkeyer manual)\ndefault = 50"));
          cntr_WK_sample->type(1);
          cntr_WK_sample->callback((Fl_Callback*)cb_cntr_WK_sample);
        } // Fl_Counter* cntr_WK_sample
        { cntr_WK_weight = new Fl_Counter(713, 172, 64, 22, gettext("Weight"));
          cntr_WK_weight->tooltip(gettext("Keying weight\ndefault = 50"));
          cntr_WK_weight->type(1);
          cntr_WK_weight->callback((Fl_Callback*)cb_cntr_WK_weight);
        } // Fl_Counter* cntr_WK_weight
        { cntr_WK_leadin = new Fl_Counter(713, 215, 64, 21, gettext("Leadin"));
          cntr_WK_leadin->tooltip(gettext("Leadin in msec\ndefault = 0"));
          cntr_WK_leadin->type(1);
          cntr_WK_leadin->callback((Fl_Callback*)cb_cntr_WK_leadin);
        } // Fl_Counter* cntr_WK_leadin
        { cntr_WK_tail = new Fl_Counter(713, 257, 64, 22, gettext("Tail"));
          cntr_WK_tail->tooltip(gettext("Extend last dit/dot in msec\ndefault = 0"));
          cntr_WK_tail->type(1);
          cntr_WK_tail->callback((Fl_Callback*)cb_cntr_WK_tail);
        } // Fl_Counter* cntr_WK_tail
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(210, 317, 291, 25);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btnK3NG = new Fl_Check_Button(220, 324, 223, 15, gettext("K3NG sketch / microHAM"));
          btnK3NG->tooltip(gettext("Enable to bypass keyer echo test"));
          btnK3NG->down_box(FL_DOWN_BOX);
          btnK3NG->callback((Fl_Callback*)cb_btnK3NG);
          o->value(progdefaults.WK_K3NGsketch);
        } // Fl_Check_Button* btnK3NG
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/WinKeyer"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/WinKeyer"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/nanoIO"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_ComboBox* o = select_nanoCW_CommPort = new Fl_ComboBox(270, 21, 435, 23, gettext("Ser. Port"));
        select_nanoCW_CommPort->tooltip(gettext("nanoIO serial port"));
        select_nanoCW_CommPort->box(FL_DOWN_BOX);
        select_nanoCW_CommPort->color((Fl_Color)55);
        select_nanoCW_CommPort->selection_color(FL_BACKGROUND_COLOR);
        select_nanoCW_CommPort->labeltype(FL_NORMAL_LABEL);
        select_nanoCW_CommPort->labelfont(0);
        select_nanoCW_CommPort->labelsize(14);
        select_nanoCW_CommPort->labelcolor(FL_FOREGROUND_COLOR);
        select_nanoCW_CommPort->callback((Fl_Callback*)cb_select_nanoCW_CommPort);
        select_nanoCW_CommPort->align(Fl_Align(FL_ALIGN_LEFT));
        select_nanoCW_CommPort->when(FL_WHEN_RELEASE);
        o->value(progdefaults.nanoIO_serial_port_name.c_str());
        select_nanoCW_CommPort->end();
      } // Fl_ComboBox* select_nanoCW_CommPort
      { btn_nanoCW_connect = new Fl_Light_Button(711, 21, 80, 22, gettext("Connect"));
        btn_nanoCW_connect->tooltip(gettext("Connect / Disconnect from nanoIO"));
        btn_nanoCW_connect->callback((Fl_Callback*)cb_btn_nanoCW_connect);
      } // Fl_Light_Button* btn_nanoCW_connect
      { Fl_Counter* o = cntr_nanoCW_paddle_WPM = new Fl_Counter(260, 48, 110, 22, gettext("Paddle"));
        cntr_nanoCW_paddle_WPM->tooltip(gettext("CW wpm using paddle keyer"));
        cntr_nanoCW_paddle_WPM->minimum(5);
        cntr_nanoCW_paddle_WPM->maximum(100);
        cntr_nanoCW_paddle_WPM->step(1);
        cntr_nanoCW_paddle_WPM->value(20);
        cntr_nanoCW_paddle_WPM->callback((Fl_Callback*)cb_cntr_nanoCW_paddle_WPM);
        cntr_nanoCW_paddle_WPM->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.CW_keyspeed);
        o->lstep(5);
      } // Fl_Counter* cntr_nanoCW_paddle_WPM
      { FTextView* o = txt_nano_CW_io = new FTextView(204, 155, 590, 189);
        txt_nano_CW_io->box(FL_DOWN_FRAME);
        txt_nano_CW_io->color(FL_BACKGROUND2_COLOR);
        txt_nano_CW_io->selection_color(FL_SELECTION_COLOR);
        txt_nano_CW_io->labeltype(FL_NORMAL_LABEL);
        txt_nano_CW_io->labelfont(0);
        txt_nano_CW_io->labelsize(14);
        txt_nano_CW_io->labelcolor(FL_FOREGROUND_COLOR);
        txt_nano_CW_io->align(Fl_Align(FL_ALIGN_TOP_RIGHT|FL_ALIGN_INSIDE));
        txt_nano_CW_io->when(FL_WHEN_RELEASE);
        o->setFont(progdefaults.RxFontnbr);
        o->setFontSize(12);
      } // FTextView* txt_nano_CW_io
      { Fl_Counter* o = cntr_nanoCW_WPM = new Fl_Counter(260, 74, 110, 22, gettext("Comp\'"));
        cntr_nanoCW_WPM->tooltip(gettext("CW wpm keyboard strings"));
        cntr_nanoCW_WPM->minimum(5);
        cntr_nanoCW_WPM->maximum(100);
        cntr_nanoCW_WPM->step(1);
        cntr_nanoCW_WPM->value(20);
        cntr_nanoCW_WPM->callback((Fl_Callback*)cb_cntr_nanoCW_WPM);
        cntr_nanoCW_WPM->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.CWspeed);
        o->lstep(5);
      } // Fl_Counter* cntr_nanoCW_WPM
      { Fl_Counter2* o = cnt_nanoCWdash2dot = new Fl_Counter2(292, 100, 78, 22, gettext("Dash/Dot"));
        cnt_nanoCWdash2dot->tooltip(gettext("Dash to dot ratio"));
        cnt_nanoCWdash2dot->type(1);
        cnt_nanoCWdash2dot->box(FL_UP_BOX);
        cnt_nanoCWdash2dot->color(FL_BACKGROUND_COLOR);
        cnt_nanoCWdash2dot->selection_color(FL_INACTIVE_COLOR);
        cnt_nanoCWdash2dot->labeltype(FL_NORMAL_LABEL);
        cnt_nanoCWdash2dot->labelfont(0);
        cnt_nanoCWdash2dot->labelsize(14);
        cnt_nanoCWdash2dot->labelcolor(FL_FOREGROUND_COLOR);
        cnt_nanoCWdash2dot->minimum(2.5);
        cnt_nanoCWdash2dot->maximum(3.5);
        cnt_nanoCWdash2dot->value(3);
        cnt_nanoCWdash2dot->callback((Fl_Callback*)cb_cnt_nanoCWdash2dot);
        cnt_nanoCWdash2dot->align(Fl_Align(FL_ALIGN_LEFT));
        cnt_nanoCWdash2dot->when(FL_WHEN_CHANGED);
        o->value(progdefaults.CWdash2dot);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Counter2* cnt_nanoCWdash2dot
      { Fl_ListBox* o = listbox_nanoIO_serbaud = new Fl_ListBox(594, 47, 110, 24, gettext("Baud"));
        listbox_nanoIO_serbaud->box(FL_DOWN_BOX);
        listbox_nanoIO_serbaud->color(FL_BACKGROUND2_COLOR);
        listbox_nanoIO_serbaud->selection_color(FL_BACKGROUND_COLOR);
        listbox_nanoIO_serbaud->labeltype(FL_NORMAL_LABEL);
        listbox_nanoIO_serbaud->labelfont(0);
        listbox_nanoIO_serbaud->labelsize(14);
        listbox_nanoIO_serbaud->labelcolor(FL_FOREGROUND_COLOR);
        listbox_nanoIO_serbaud->callback((Fl_Callback*)cb_listbox_nanoIO_serbaud);
        listbox_nanoIO_serbaud->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_nanoIO_serbaud->when(FL_WHEN_RELEASE);
        o->add("1200|4800|9600|19200|38400|57600|115200");
        o->index(progdefaults.nanoIO_serbaud);
        listbox_nanoIO_serbaud->end();
      } // Fl_ListBox* listbox_nanoIO_serbaud
      { Fl_ListBox* o = listbox_nano_keyer = new Fl_ListBox(595, 73, 110, 24, gettext("Keyer"));
        listbox_nano_keyer->box(FL_DOWN_BOX);
        listbox_nano_keyer->color(FL_BACKGROUND2_COLOR);
        listbox_nano_keyer->selection_color(FL_BACKGROUND_COLOR);
        listbox_nano_keyer->labeltype(FL_NORMAL_LABEL);
        listbox_nano_keyer->labelfont(0);
        listbox_nano_keyer->labelsize(14);
        listbox_nano_keyer->labelcolor(FL_FOREGROUND_COLOR);
        listbox_nano_keyer->callback((Fl_Callback*)cb_listbox_nano_keyer);
        listbox_nano_keyer->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_nano_keyer->when(FL_WHEN_RELEASE);
        o->add("Iambic-A|Iambic-B|Straight");
        o->index(progdefaults.nanoIO_CW_keyer);
        listbox_nano_keyer->end();
      } // Fl_ListBox* listbox_nano_keyer
      { Fl_ListBox* o = listbox_incr = new Fl_ListBox(645, 99, 60, 24, gettext("Incr\'"));
        listbox_incr->box(FL_DOWN_BOX);
        listbox_incr->color(FL_BACKGROUND2_COLOR);
        listbox_incr->selection_color(FL_BACKGROUND_COLOR);
        listbox_incr->labeltype(FL_NORMAL_LABEL);
        listbox_incr->labelfont(0);
        listbox_incr->labelsize(14);
        listbox_incr->labelcolor(FL_FOREGROUND_COLOR);
        listbox_incr->callback((Fl_Callback*)cb_listbox_incr);
        listbox_incr->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_incr->when(FL_WHEN_RELEASE);
        o->add("1|2|3|4|5");
        o->index(progdefaults.nanoIO_CW_incr - '1');
        listbox_incr->end();
      } // Fl_ListBox* listbox_incr
      { btn_cwfsk_save = new Fl_Button(711, 74, 80, 22, gettext("Save"));
        btn_cwfsk_save->tooltip(gettext("Write state of nanoIO to Arduino EEPROM"));
        btn_cwfsk_save->callback((Fl_Callback*)cb_btn_cwfsk_save);
      } // Fl_Button* btn_cwfsk_save
      { btn_cwfsk_query = new Fl_Button(711, 100, 80, 22, gettext("Status"));
        btn_cwfsk_query->tooltip(gettext("Query state of nanoIO"));
        btn_cwfsk_query->callback((Fl_Callback*)cb_btn_cwfsk_query);
      } // Fl_Button* btn_cwfsk_query
      { Fl_Group* o = new Fl_Group(375, 45, 154, 80);
        o->box(FL_FLAT_BOX);
        { Fl_Check_Button* o = btn_nanoIO_pot = new Fl_Check_Button(502, 48, 21, 22, gettext("Use WPM pot\'"));
          btn_nanoIO_pot->tooltip(gettext("WPM pot update to nanoIO required"));
          btn_nanoIO_pot->down_box(FL_DOWN_BOX);
          btn_nanoIO_pot->callback((Fl_Callback*)cb_btn_nanoIO_pot);
          btn_nanoIO_pot->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(progdefaults.nanoIO_speed_pot);
        } // Fl_Check_Button* btn_nanoIO_pot
        { cntr_nanoIO_min_wpm = new Fl_Counter(447, 74, 75, 22, gettext("Min WPM"));
          cntr_nanoIO_min_wpm->tooltip(gettext("Minimum WPM setting\ndefault = 10"));
          cntr_nanoIO_min_wpm->type(1);
          cntr_nanoIO_min_wpm->minimum(10);
          cntr_nanoIO_min_wpm->maximum(30);
          cntr_nanoIO_min_wpm->step(1);
          cntr_nanoIO_min_wpm->value(10);
          cntr_nanoIO_min_wpm->callback((Fl_Callback*)cb_cntr_nanoIO_min_wpm);
          cntr_nanoIO_min_wpm->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Counter* cntr_nanoIO_min_wpm
        { cntr_nanoIO_rng_wpm = new Fl_Counter(447, 100, 75, 22, gettext("Rng WPM"));
          cntr_nanoIO_rng_wpm->tooltip(gettext("Range WPM setting\ndefault = 20"));
          cntr_nanoIO_rng_wpm->type(1);
          cntr_nanoIO_rng_wpm->minimum(10);
          cntr_nanoIO_rng_wpm->maximum(40);
          cntr_nanoIO_rng_wpm->step(1);
          cntr_nanoIO_rng_wpm->value(20);
          cntr_nanoIO_rng_wpm->callback((Fl_Callback*)cb_cntr_nanoIO_rng_wpm);
          cntr_nanoIO_rng_wpm->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Counter* cntr_nanoIO_rng_wpm
        o->end();
      } // Fl_Group* o
      { Fl_Check_Button* o = btn_disable_CW_PTT = new Fl_Check_Button(531, 99, 70, 24, gettext("PTT off"));
        btn_disable_CW_PTT->tooltip(gettext("Disable PTT"));
        btn_disable_CW_PTT->down_box(FL_DOWN_BOX);
        btn_disable_CW_PTT->callback((Fl_Callback*)cb_btn_disable_CW_PTT);
        o->value(progdefaults.disable_CW_PTT);
      } // Fl_Check_Button* btn_disable_CW_PTT
      { Fl_Group* o = new Fl_Group(204, 125, 590, 30, gettext("Comp\'"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cntrWPMtest = new Fl_Counter(302, 129, 78, 22, gettext("WPM"));
          cntrWPMtest->type(1);
          cntrWPMtest->minimum(5);
          cntrWPMtest->maximum(50);
          cntrWPMtest->step(1);
          cntrWPMtest->value(30);
          cntrWPMtest->callback((Fl_Callback*)cb_cntrWPMtest);
          cntrWPMtest->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(progdefaults.nanoCW_test_wpm);
        } // Fl_Counter* cntrWPMtest
        { btn_cal_variable = new Fl_Button(384, 129, 70, 22, gettext("Test =>"));
          btn_cal_variable->tooltip(gettext("Send \"paris \" WPM times"));
          btn_cal_variable->callback((Fl_Callback*)cb_btn_cal_variable);
        } // Fl_Button* btn_cal_variable
        { corr_var_wpm = new Fl_Value_Input(458, 129, 70, 22, gettext("secs\' =>"));
          corr_var_wpm->tooltip(gettext("Test duration (60 seconds)"));
          corr_var_wpm->color(FL_WHITE);
          corr_var_wpm->align(Fl_Align(FL_ALIGN_RIGHT));
        } // Fl_Value_Input* corr_var_wpm
        { Fl_Value_Input* o = usec_correc = new Fl_Value_Input(645, 129, 60, 22, gettext("Comp\'"));
          usec_correc->tooltip(gettext("Compensationin microseconds"));
          usec_correc->color(FL_WHITE);
          o->value(progdefaults.usec_correc);
        } // Fl_Value_Input* usec_correc
        { btn_correction = new Fl_Button(711, 129, 80, 22, gettext("Adjust"));
          btn_correction->tooltip(gettext("send compensation to nanoIO"));
          btn_correction->callback((Fl_Callback*)cb_btn_correction);
        } // Fl_Button* btn_correction
        o->end();
      } // Fl_Group* o
      { chk_nanoIO_CW_io = new Fl_Check_Button(711, 47, 70, 24, gettext("CW i/o"));
        chk_nanoIO_CW_io->tooltip(gettext("Enable CW operation"));
        chk_nanoIO_CW_io->down_box(FL_DOWN_BOX);
        chk_nanoIO_CW_io->callback((Fl_Callback*)cb_chk_nanoIO_CW_io);
      } // Fl_Check_Button* chk_nanoIO_CW_io
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/nanoIO"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/nanoIO"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/DTR-RTS keying"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 25, 590, 79);
        o->box(FL_ENGRAVED_BOX);
        { Fl_Box* o = new Fl_Box(208, 27, 580, 72, gettext("DTR/RTS keying may be assigned to flrig, share the RigCat serial port,\nshare"
" the Separate PTT serial port, or be assigned to separate serial port.\n\nNo s"
"ettings for baud, stops bits, etc are needed."));
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 107, 590, 40);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btn_CW_KEYLINE_flrig = new Fl_Check_Button(215, 120, 23, 15, gettext("Use flrig DTR/RTS keying"));
          btn_CW_KEYLINE_flrig->down_box(FL_DOWN_BOX);
          btn_CW_KEYLINE_flrig->callback((Fl_Callback*)cb_btn_CW_KEYLINE_flrig);
          btn_CW_KEYLINE_flrig->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.use_FLRIGkeying);
        } // Fl_Check_Button* btn_CW_KEYLINE_flrig
        { Fl_Check_Button* o = btn_FLRIG_CW_disable_ptt = new Fl_Check_Button(475, 120, 70, 14, gettext("Disable flrig CW PTT"));
          btn_FLRIG_CW_disable_ptt->tooltip(gettext("Required for some transceivers\ne.g. TS-480"));
          btn_FLRIG_CW_disable_ptt->down_box(FL_DOWN_BOX);
          btn_FLRIG_CW_disable_ptt->callback((Fl_Callback*)cb_btn_FLRIG_CW_disable_ptt);
          o->value(progdefaults.CATkeying_disable_ptt);
        } // Fl_Check_Button* btn_FLRIG_CW_disable_ptt
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 151, 590, 195);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btn_CW_KEYLINE_catport = new Fl_Check_Button(215, 167, 23, 15, gettext("Share RIGCAT port"));
          btn_CW_KEYLINE_catport->down_box(FL_DOWN_BOX);
          btn_CW_KEYLINE_catport->callback((Fl_Callback*)cb_btn_CW_KEYLINE_catport);
          btn_CW_KEYLINE_catport->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.CW_KEYLINE_on_cat_port);
        } // Fl_Check_Button* btn_CW_KEYLINE_catport
        { Fl_Check_Button* o = btn_CW_KEYLINE_shared_PTT = new Fl_Check_Button(215, 199, 23, 15, gettext("Share Separate PTT port"));
          btn_CW_KEYLINE_shared_PTT->down_box(FL_DOWN_BOX);
          btn_CW_KEYLINE_shared_PTT->callback((Fl_Callback*)cb_btn_CW_KEYLINE_shared_PTT);
          btn_CW_KEYLINE_shared_PTT->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.CW_KEYLINE_on_ptt_port);
        } // Fl_Check_Button* btn_CW_KEYLINE_shared_PTT
        { Fl_ListBox* o = listbox_CW_KEYLINE = new Fl_ListBox(454, 162, 90, 24, gettext("CW Keyline"));
          listbox_CW_KEYLINE->box(FL_DOWN_BOX);
          listbox_CW_KEYLINE->color(FL_BACKGROUND2_COLOR);
          listbox_CW_KEYLINE->selection_color(FL_BACKGROUND_COLOR);
          listbox_CW_KEYLINE->labeltype(FL_NORMAL_LABEL);
          listbox_CW_KEYLINE->labelfont(0);
          listbox_CW_KEYLINE->labelsize(14);
          listbox_CW_KEYLINE->labelcolor(FL_FOREGROUND_COLOR);
          listbox_CW_KEYLINE->callback((Fl_Callback*)cb_listbox_CW_KEYLINE);
          listbox_CW_KEYLINE->align(Fl_Align(FL_ALIGN_RIGHT));
          listbox_CW_KEYLINE->when(FL_WHEN_RELEASE);
          o->add("None|RTS|DTR");
          o->index(progdefaults.CW_KEYLINE);
          listbox_CW_KEYLINE->end();
        } // Fl_ListBox* listbox_CW_KEYLINE
        { Fl_Counter2* o = cntCWkeycomp = new Fl_Counter2(454, 194, 125, 24, gettext("Keying compensation (msec)"));
          cntCWkeycomp->tooltip(gettext("Dot / Space timing increment"));
          cntCWkeycomp->box(FL_UP_BOX);
          cntCWkeycomp->color(FL_BACKGROUND_COLOR);
          cntCWkeycomp->selection_color(FL_INACTIVE_COLOR);
          cntCWkeycomp->labeltype(FL_NORMAL_LABEL);
          cntCWkeycomp->labelfont(0);
          cntCWkeycomp->labelsize(14);
          cntCWkeycomp->labelcolor(FL_FOREGROUND_COLOR);
          cntCWkeycomp->minimum(-10);
          cntCWkeycomp->maximum(10);
          cntCWkeycomp->step(0.01);
          cntCWkeycomp->callback((Fl_Callback*)cb_cntCWkeycomp);
          cntCWkeycomp->align(Fl_Align(FL_ALIGN_RIGHT));
          cntCWkeycomp->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWkeycomp);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(1.0);
        } // Fl_Counter2* cntCWkeycomp
        { Fl_ListBox* o = listbox_PTT_KEYLINE = new Fl_ListBox(693, 162, 90, 24, gettext("PTT keyline"));
          listbox_PTT_KEYLINE->box(FL_DOWN_BOX);
          listbox_PTT_KEYLINE->color(FL_BACKGROUND2_COLOR);
          listbox_PTT_KEYLINE->selection_color(FL_BACKGROUND_COLOR);
          listbox_PTT_KEYLINE->labeltype(FL_NORMAL_LABEL);
          listbox_PTT_KEYLINE->labelfont(0);
          listbox_PTT_KEYLINE->labelsize(14);
          listbox_PTT_KEYLINE->labelcolor(FL_FOREGROUND_COLOR);
          listbox_PTT_KEYLINE->callback((Fl_Callback*)cb_listbox_PTT_KEYLINE);
          listbox_PTT_KEYLINE->align(Fl_Align(FL_ALIGN_LEFT));
          listbox_PTT_KEYLINE->when(FL_WHEN_RELEASE);
          listbox_PTT_KEYLINE->hide();
          o->add("None|RTS|DTR");
          o->index(0);//progdefaults.PTT_KEYLINE);
          listbox_PTT_KEYLINE->end();
        } // Fl_ListBox* listbox_PTT_KEYLINE
        { Fl_ComboBox* o = select_CW_KEYLINE_CommPort = new Fl_ComboBox(215, 241, 470, 24, gettext("Use Separate Keying Serial Port"));
          select_CW_KEYLINE_CommPort->tooltip(gettext("nanoIO serial port"));
          select_CW_KEYLINE_CommPort->box(FL_DOWN_BOX);
          select_CW_KEYLINE_CommPort->color((Fl_Color)55);
          select_CW_KEYLINE_CommPort->selection_color(FL_BACKGROUND_COLOR);
          select_CW_KEYLINE_CommPort->labeltype(FL_NORMAL_LABEL);
          select_CW_KEYLINE_CommPort->labelfont(0);
          select_CW_KEYLINE_CommPort->labelsize(14);
          select_CW_KEYLINE_CommPort->labelcolor(FL_FOREGROUND_COLOR);
          select_CW_KEYLINE_CommPort->callback((Fl_Callback*)cb_select_CW_KEYLINE_CommPort);
          select_CW_KEYLINE_CommPort->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          select_CW_KEYLINE_CommPort->when(FL_WHEN_RELEASE);
          o->value(progdefaults.CW_KEYLINE_serial_port_name.c_str());
          select_CW_KEYLINE_CommPort->end();
        } // Fl_ComboBox* select_CW_KEYLINE_CommPort
        { Fl_Light_Button* o = btn_CW_KEYLINE_connect = new Fl_Light_Button(698, 241, 90, 24, gettext("Connect"));
          btn_CW_KEYLINE_connect->tooltip(gettext("Connect / Disconnect from nanoIO"));
          btn_CW_KEYLINE_connect->callback((Fl_Callback*)cb_btn_CW_KEYLINE_connect);
          o->value(progStatus.useCW_KEYLINE);
        } // Fl_Light_Button* btn_CW_KEYLINE_connect
        { btn_cw_dtr_calibrate = new Fl_Light_Button(215, 305, 100, 24, gettext("Speed test"));
          btn_cw_dtr_calibrate->tooltip(gettext("1 minute \'PARIS \'"));
          btn_cw_dtr_calibrate->selection_color((Fl_Color)6);
          btn_cw_dtr_calibrate->callback((Fl_Callback*)cb_btn_cw_dtr_calibrate);
        } // Fl_Light_Button* btn_cw_dtr_calibrate
        { cwio_test_result = new Fl_Output(376, 305, 300, 24, gettext("Result"));
        } // Fl_Output* cwio_test_result
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/DTR-RTS keying"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/DTR-RTS keying"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/CAT Keying"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Box* o = new Fl_Box(213, 23, 575, 140, gettext("CW keying using CAT command strings.  Available for supported transceivers.\n"
"Use with RigCAT or flrig transceiver control.  A separate serial port is NOT n"
"eeded.\n\nDisable CAT PTT if transceiver interprets that as a keydown command "
"(e.g. TS480).\nRecommend setting transceiver to either semi or full break-in."
"\n\nEnter correct CIV address for Icom transceivers."));
        o->box(FL_THIN_DOWN_BOX);
        o->color(FL_LIGHT3);
        o->selection_color(FL_LIGHT3);
        o->labelsize(13);
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Check_Button* o = btn_use_ICOMkeying = new Fl_Check_Button(273, 192, 70, 15, gettext("Icom"));
        btn_use_ICOMkeying->down_box(FL_DOWN_BOX);
        btn_use_ICOMkeying->callback((Fl_Callback*)cb_btn_use_ICOMkeying);
        o->value(progdefaults.use_ICOMkeying);
      } // Fl_Check_Button* btn_use_ICOMkeying
      { Fl_Input* o = val_ICOMcivaddr = new Fl_Input(343, 188, 58, 22, gettext("Hex CIV addr"));
        val_ICOMcivaddr->tooltip(gettext("Enter transceiver HEX CIV address"));
        val_ICOMcivaddr->callback((Fl_Callback*)cb_val_ICOMcivaddr);
        val_ICOMcivaddr->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.ICOMcivaddr.c_str());
      } // Fl_Input* val_ICOMcivaddr
      { Fl_Check_Button* o = btn_use_ELCTkeying = new Fl_Check_Button(273, 216, 70, 15, gettext("Elecraft"));
        btn_use_ELCTkeying->down_box(FL_DOWN_BOX);
        btn_use_ELCTkeying->callback((Fl_Callback*)cb_btn_use_ELCTkeying);
        o->value(progdefaults.use_ELCTkeying);
      } // Fl_Check_Button* btn_use_ELCTkeying
      { Fl_Check_Button* o = btn_use_KNWDkeying = new Fl_Check_Button(455, 216, 70, 15, gettext("Kenwood"));
        btn_use_KNWDkeying->down_box(FL_DOWN_BOX);
        btn_use_KNWDkeying->callback((Fl_Callback*)cb_btn_use_KNWDkeying);
        o->value(progdefaults.use_KNWDkeying);
      } // Fl_Check_Button* btn_use_KNWDkeying
      { Fl_Check_Button* o = btn_use_YAESUkeying = new Fl_Check_Button(637, 216, 70, 15, gettext("Yaesu"));
        btn_use_YAESUkeying->down_box(FL_DOWN_BOX);
        btn_use_YAESUkeying->callback((Fl_Callback*)cb_btn_use_YAESUkeying);
        o->value(progdefaults.use_YAESUkeying);
      } // Fl_Check_Button* btn_use_YAESUkeying
      { Fl_Check_Button* o = btn_CAT_CW_disable_ptt = new Fl_Check_Button(273, 240, 70, 15, gettext("Disable CAT PTT"));
        btn_CAT_CW_disable_ptt->tooltip(gettext("Required for some transceivers\ne.g. TS-480"));
        btn_CAT_CW_disable_ptt->down_box(FL_DOWN_BOX);
        btn_CAT_CW_disable_ptt->callback((Fl_Callback*)cb_btn_CAT_CW_disable_ptt);
        o->value(progdefaults.CATkeying_disable_ptt);
      } // Fl_Check_Button* btn_CAT_CW_disable_ptt
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/CAT keying"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/CAT keying"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/CW/Compensation"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Box* o = new Fl_Box(210, 33, 575, 118, gettext("Compute timing compensation for CAT CW and WinKeyer CW.  Computation at curre"
"nt\nWPM .  Set WPM to nominal (suggest 20 WPM).\n\nCompensation will be good o"
"ver a +/- 10 WPM range.  Calibration/Test is 1 minute of\n\'PARIS \'."));
        o->box(FL_ENGRAVED_BOX);
        o->color((Fl_Color)53);
        o->labelsize(13);
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { btn_CAT_keying_calibrate = new Fl_Button(245, 184, 80, 22, gettext("Calibrate"));
        btn_CAT_keying_calibrate->tooltip(gettext("Send WPM \'PARIS \' words"));
        btn_CAT_keying_calibrate->callback((Fl_Callback*)cb_btn_CAT_keying_calibrate);
      } // Fl_Button* btn_CAT_keying_calibrate
      { Fl_Value_Input* o = out_CATkeying_compensation = new Fl_Value_Input(329, 184, 50, 22, gettext("Compensate (secs)"));
        out_CATkeying_compensation->maximum(10);
        out_CATkeying_compensation->step(0.01);
        out_CATkeying_compensation->callback((Fl_Callback*)cb_out_CATkeying_compensation);
        out_CATkeying_compensation->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.CATkeying_compensation / 1000.0);
      } // Fl_Value_Input* out_CATkeying_compensation
      { btn_CAT_keying_clear = new Fl_Button(525, 184, 50, 22, gettext("Clear"));
        btn_CAT_keying_clear->tooltip(gettext("Clear compensation"));
        btn_CAT_keying_clear->callback((Fl_Callback*)cb_btn_CAT_keying_clear);
      } // Fl_Button* btn_CAT_keying_clear
      { btn_CAT_keying_test = new Fl_Button(589, 184, 50, 22, gettext("Test"));
        btn_CAT_keying_test->tooltip(gettext("Send WPM \'PARIS \' words"));
        btn_CAT_keying_test->callback((Fl_Callback*)cb_btn_CAT_keying_test);
      } // Fl_Button* btn_CAT_keying_test
      { Fl_Value_Input* o = out_CATkeying_test_result = new Fl_Value_Input(645, 184, 50, 22, gettext("secs"));
        out_CATkeying_test_result->maximum(10);
        out_CATkeying_test_result->step(0.01);
        out_CATkeying_test_result->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(0);
      } // Fl_Value_Input* out_CATkeying_test_result
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/CW/Compensation"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/CW/Compensation"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/DominoEX"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { txtSecondary = new Fl_Input2(310, 88, 360, 40, gettext("Secondary Text"));
        txtSecondary->tooltip(gettext("Text to send during keyboard idle times"));
        txtSecondary->type(4);
        txtSecondary->box(FL_DOWN_BOX);
        txtSecondary->color(FL_BACKGROUND2_COLOR);
        txtSecondary->selection_color(FL_SELECTION_COLOR);
        txtSecondary->labeltype(FL_NORMAL_LABEL);
        txtSecondary->labelfont(0);
        txtSecondary->labelsize(14);
        txtSecondary->labelcolor(FL_FOREGROUND_COLOR);
        txtSecondary->callback((Fl_Callback*)cb_txtSecondary);
        txtSecondary->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        txtSecondary->when(FL_WHEN_CHANGED);
        txtSecondary->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* txtSecondary
      { Fl_Check_Button* o = valDominoEX_FILTER = new Fl_Check_Button(310, 142, 80, 20, gettext("Filtering"));
        valDominoEX_FILTER->tooltip(gettext("Use DSP filter before decoder"));
        valDominoEX_FILTER->down_box(FL_DOWN_BOX);
        valDominoEX_FILTER->value(1);
        valDominoEX_FILTER->callback((Fl_Callback*)cb_valDominoEX_FILTER);
        o->value(progdefaults.DOMINOEX_FILTER);
      } // Fl_Check_Button* valDominoEX_FILTER
      { Fl_Counter2* o = valDominoEX_BW = new Fl_Counter2(451, 142, 63, 20, gettext("Filter bandwidth factor"));
        valDominoEX_BW->tooltip(gettext("Filter bandwidth relative to signal width"));
        valDominoEX_BW->type(1);
        valDominoEX_BW->box(FL_UP_BOX);
        valDominoEX_BW->color(FL_BACKGROUND_COLOR);
        valDominoEX_BW->selection_color(FL_INACTIVE_COLOR);
        valDominoEX_BW->labeltype(FL_NORMAL_LABEL);
        valDominoEX_BW->labelfont(0);
        valDominoEX_BW->labelsize(14);
        valDominoEX_BW->labelcolor(FL_FOREGROUND_COLOR);
        valDominoEX_BW->minimum(1);
        valDominoEX_BW->maximum(2);
        valDominoEX_BW->value(1.5);
        valDominoEX_BW->callback((Fl_Callback*)cb_valDominoEX_BW);
        valDominoEX_BW->align(Fl_Align(FL_ALIGN_RIGHT));
        valDominoEX_BW->when(FL_WHEN_CHANGED);
        o->value(progdefaults.DOMINOEX_BW);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Counter2* valDominoEX_BW
      { Fl_Check_Button* o = chkDominoEX_FEC = new Fl_Check_Button(310, 172, 51, 20, gettext("FEC"));
        chkDominoEX_FEC->tooltip(gettext("Enable MultiPSK-compatible FEC"));
        chkDominoEX_FEC->down_box(FL_DOWN_BOX);
        chkDominoEX_FEC->callback((Fl_Callback*)cb_chkDominoEX_FEC);
        o->value(progdefaults.DOMINOEX_FEC);
      } // Fl_Check_Button* chkDominoEX_FEC
      { Fl_Value_Slider2* o = valDomCWI = new Fl_Value_Slider2(310, 208, 260, 20, gettext("CWI threshold"));
        valDomCWI->tooltip(gettext("CWI detection and suppression"));
        valDomCWI->type(1);
        valDomCWI->box(FL_DOWN_BOX);
        valDomCWI->color(FL_BACKGROUND_COLOR);
        valDomCWI->selection_color(FL_BACKGROUND_COLOR);
        valDomCWI->labeltype(FL_NORMAL_LABEL);
        valDomCWI->labelfont(0);
        valDomCWI->labelsize(14);
        valDomCWI->labelcolor(FL_FOREGROUND_COLOR);
        valDomCWI->textsize(14);
        valDomCWI->callback((Fl_Callback*)cb_valDomCWI);
        valDomCWI->align(Fl_Align(FL_ALIGN_TOP));
        valDomCWI->when(FL_WHEN_CHANGED);
        o->value(progdefaults.DomCWI);
        o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
      } // Fl_Value_Slider2* valDomCWI
      { Fl_Counter2* o = valDominoEX_PATHS = new Fl_Counter2(634, 195, 63, 20, gettext("Paths (hidden)"));
        valDominoEX_PATHS->type(1);
        valDominoEX_PATHS->box(FL_UP_BOX);
        valDominoEX_PATHS->color(FL_BACKGROUND_COLOR);
        valDominoEX_PATHS->selection_color(FL_INACTIVE_COLOR);
        valDominoEX_PATHS->labeltype(FL_NORMAL_LABEL);
        valDominoEX_PATHS->labelfont(0);
        valDominoEX_PATHS->labelsize(14);
        valDominoEX_PATHS->labelcolor(FL_FOREGROUND_COLOR);
        valDominoEX_PATHS->minimum(4);
        valDominoEX_PATHS->maximum(8);
        valDominoEX_PATHS->step(1);
        valDominoEX_PATHS->value(5);
        valDominoEX_PATHS->callback((Fl_Callback*)cb_valDominoEX_PATHS);
        valDominoEX_PATHS->align(Fl_Align(FL_ALIGN_BOTTOM));
        valDominoEX_PATHS->when(FL_WHEN_CHANGED);
        o->value(progdefaults.DOMINOEX_PATHS);
        o->labelsize(FL_NORMAL_SIZE);
        o->hide();
      } // Fl_Counter2* valDominoEX_PATHS
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/DominoEX"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/DominoEX"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/Feld Hell"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(247, 31, 500, 133, gettext("Hell Transmit Parameters"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = listboxHellFont = new Fl_ListBox(262, 56, 225, 22, gettext("Transmit font"));
          listboxHellFont->tooltip(gettext("Select TX raster font"));
          listboxHellFont->box(FL_DOWN_BOX);
          listboxHellFont->color(FL_BACKGROUND2_COLOR);
          listboxHellFont->selection_color(FL_BACKGROUND_COLOR);
          listboxHellFont->labeltype(FL_NORMAL_LABEL);
          listboxHellFont->labelfont(0);
          listboxHellFont->labelsize(14);
          listboxHellFont->labelcolor(FL_FOREGROUND_COLOR);
          listboxHellFont->callback((Fl_Callback*)cb_listboxHellFont);
          listboxHellFont->align(Fl_Align(FL_ALIGN_RIGHT));
          listboxHellFont->when(FL_WHEN_RELEASE);
          o->add(szFeldFonts);
          o->index(progdefaults.feldfontnbr);
                       o->labelsize(FL_NORMAL_SIZE);
          listboxHellFont->end();
        } // Fl_ListBox* listboxHellFont
        { Fl_ListBox* o = listboxHellPulse = new Fl_ListBox(262, 104, 150, 22, gettext("Pulse shape"));
          listboxHellPulse->tooltip(gettext("Raised cosine pulse shape factor"));
          listboxHellPulse->box(FL_DOWN_BOX);
          listboxHellPulse->color(FL_BACKGROUND2_COLOR);
          listboxHellPulse->selection_color(FL_BACKGROUND_COLOR);
          listboxHellPulse->labeltype(FL_NORMAL_LABEL);
          listboxHellPulse->labelfont(0);
          listboxHellPulse->labelsize(14);
          listboxHellPulse->labelcolor(FL_FOREGROUND_COLOR);
          listboxHellPulse->callback((Fl_Callback*)cb_listboxHellPulse);
          listboxHellPulse->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          listboxHellPulse->when(FL_WHEN_RELEASE);
          o->add(_("Slow (4 msec)|Med (2 msec)|Fast (1 msec)|Hard Keying"));
          o->index(progdefaults.HellPulseFast);
                       o->labelsize(FL_NORMAL_SIZE);
          listboxHellPulse->end();
        } // Fl_ListBox* listboxHellPulse
        { Fl_Check_Button* o = btnFeldHellIdle = new Fl_Check_Button(262, 139, 230, 20, gettext("Transmit periods (.) when idle"));
          btnFeldHellIdle->tooltip(gettext("Transmits a diddle dot when no keyboard activity"));
          btnFeldHellIdle->down_box(FL_DOWN_BOX);
          btnFeldHellIdle->value(1);
          btnFeldHellIdle->callback((Fl_Callback*)cb_btnFeldHellIdle);
          o->value(progdefaults.HellXmtIdle);
        } // Fl_Check_Button* btnFeldHellIdle
        { Fl_Value_Slider* o = valHellXmtWidth = new Fl_Value_Slider(443, 104, 150, 22, gettext("Tx Width Multiplier"));
          valHellXmtWidth->tooltip(gettext("Range 1...3"));
          valHellXmtWidth->type(5);
          valHellXmtWidth->color(FL_LIGHT3);
          valHellXmtWidth->minimum(1);
          valHellXmtWidth->maximum(3);
          valHellXmtWidth->step(1);
          valHellXmtWidth->value(1);
          valHellXmtWidth->textsize(14);
          valHellXmtWidth->callback((Fl_Callback*)cb_valHellXmtWidth);
          valHellXmtWidth->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.HellXmtWidth);
        } // Fl_Value_Slider* valHellXmtWidth
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(247, 167, 500, 173, gettext("Hell Receive Parameters"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnBlackboard = new Fl_Check_Button(262, 191, 125, 20, gettext("Reverse video"));
          btnBlackboard->tooltip(gettext("Display RX in reverse video"));
          btnBlackboard->down_box(FL_DOWN_BOX);
          btnBlackboard->callback((Fl_Callback*)cb_btnBlackboard);
          o->value(progdefaults.HellBlackboard);
        } // Fl_Check_Button* btnBlackboard
        { Fl_Check_Button* o = btnHellMarquee = new Fl_Check_Button(447, 191, 125, 20, gettext("Marquee text"));
          btnHellMarquee->tooltip(gettext("Display RX as a scrolling marquee"));
          btnHellMarquee->down_box(FL_DOWN_BOX);
          btnHellMarquee->callback((Fl_Callback*)cb_btnHellMarquee);
          o->value(progdefaults.HellMarquee);
        } // Fl_Check_Button* btnHellMarquee
        { Fl_Value_Slider* o = valHellRcvWidth = new Fl_Value_Slider(262, 227, 120, 22, gettext("Rx Width Multiplier"));
          valHellRcvWidth->tooltip(gettext("Range 1...4"));
          valHellRcvWidth->type(5);
          valHellRcvWidth->color(FL_LIGHT3);
          valHellRcvWidth->minimum(1);
          valHellRcvWidth->maximum(4);
          valHellRcvWidth->step(1);
          valHellRcvWidth->value(1);
          valHellRcvWidth->textsize(14);
          valHellRcvWidth->callback((Fl_Callback*)cb_valHellRcvWidth);
          valHellRcvWidth->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.HellRcvWidth);
        } // Fl_Value_Slider* valHellRcvWidth
        { Fl_Value_Slider* o = valHellRcvHeight = new Fl_Value_Slider(262, 266, 250, 22, gettext("Rx Height in pixels"));
          valHellRcvHeight->tooltip(gettext("May require resizing the Rx/Tx panel"));
          valHellRcvHeight->type(5);
          valHellRcvHeight->color(FL_LIGHT3);
          valHellRcvHeight->minimum(14);
          valHellRcvHeight->maximum(42);
          valHellRcvHeight->step(2);
          valHellRcvHeight->value(20);
          valHellRcvHeight->textsize(14);
          valHellRcvHeight->callback((Fl_Callback*)cb_valHellRcvHeight);
          valHellRcvHeight->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.HellRcvHeight);
        } // Fl_Value_Slider* valHellRcvHeight
        { Fl_Value_Slider2* o = sldrHellBW = new Fl_Value_Slider2(262, 305, 250, 22, gettext("Receive filter bandwidth"));
          sldrHellBW->tooltip(gettext("Adjust the DSP bandwidth"));
          sldrHellBW->type(1);
          sldrHellBW->box(FL_DOWN_BOX);
          sldrHellBW->color(FL_LIGHT3);
          sldrHellBW->selection_color(FL_BACKGROUND_COLOR);
          sldrHellBW->labeltype(FL_NORMAL_LABEL);
          sldrHellBW->labelfont(0);
          sldrHellBW->labelsize(14);
          sldrHellBW->labelcolor(FL_FOREGROUND_COLOR);
          sldrHellBW->minimum(10);
          sldrHellBW->maximum(2400);
          sldrHellBW->step(5);
          sldrHellBW->value(400);
          sldrHellBW->textsize(14);
          sldrHellBW->callback((Fl_Callback*)cb_sldrHellBW);
          sldrHellBW->align(Fl_Align(FL_ALIGN_RIGHT));
          sldrHellBW->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HELL_BW);
          o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
        } // Fl_Value_Slider2* sldrHellBW
        { Fl_Value_Slider* o = val_hellagc = new Fl_Value_Slider(527, 227, 120, 22, gettext("Rx AGC"));
          val_hellagc->tooltip(gettext("1 - Slow, 2 - Medium, 3 - Fast"));
          val_hellagc->type(5);
          val_hellagc->color(FL_LIGHT3);
          val_hellagc->minimum(1);
          val_hellagc->maximum(3);
          val_hellagc->step(1);
          val_hellagc->value(2);
          val_hellagc->textsize(14);
          val_hellagc->callback((Fl_Callback*)cb_val_hellagc);
          val_hellagc->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.hellagc);
        } // Fl_Value_Slider* val_hellagc
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/Feld Hell"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/Feld Hell"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/FMT"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(203, 24, 412, 75, gettext("Audio Stream Procesing"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = listbox_fmt_sr = new Fl_ListBox(276, 66, 100, 22, gettext("Sample rate"));
          listbox_fmt_sr->tooltip(gettext("FMT sample rate"));
          listbox_fmt_sr->box(FL_DOWN_BOX);
          listbox_fmt_sr->color(FL_BACKGROUND2_COLOR);
          listbox_fmt_sr->selection_color(FL_BACKGROUND_COLOR);
          listbox_fmt_sr->labeltype(FL_NORMAL_LABEL);
          listbox_fmt_sr->labelfont(0);
          listbox_fmt_sr->labelsize(14);
          listbox_fmt_sr->labelcolor(FL_FOREGROUND_COLOR);
          listbox_fmt_sr->callback((Fl_Callback*)cb_listbox_fmt_sr);
          listbox_fmt_sr->align(Fl_Align(FL_ALIGN_TOP));
          listbox_fmt_sr->when(FL_WHEN_RELEASE);
          o->add("8000|11025|12000|16000|22050|24000|44100|48000");
          o->index(progdefaults.FMT_sr);
          listbox_fmt_sr->end();
        } // Fl_ListBox* listbox_fmt_sr
        { Fl_Counter* o = cnt_fmt_rx_ppm = new Fl_Counter(419, 66, 120, 22, gettext("Rx Codec PPM"));
          cnt_fmt_rx_ppm->tooltip(gettext("Audio Codec ppm correction"));
          cnt_fmt_rx_ppm->minimum(-500);
          cnt_fmt_rx_ppm->maximum(500);
          cnt_fmt_rx_ppm->step(1);
          cnt_fmt_rx_ppm->callback((Fl_Callback*)cb_cnt_fmt_rx_ppm);
          cnt_fmt_rx_ppm->align(Fl_Align(FL_ALIGN_TOP));
          o->value(progdefaults.RX_corr);
          o->lstep(10);
        } // Fl_Counter* cnt_fmt_rx_ppm
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(203, 99, 412, 90, gettext("Tracking"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btnFMT_plot_background = new Fl_Button(209, 122, 60, 22, gettext("Bgnd"));
          btnFMT_plot_background->tooltip(gettext("Change plot background color"));
          btnFMT_plot_background->callback((Fl_Callback*)cb_btnFMT_plot_background);
          btnFMT_plot_background->hide();
        } // Fl_Button* btnFMT_plot_background
        { btnFMT_unk_color = new Fl_Button(209, 153, 60, 22, gettext("Unkn"));
          btnFMT_unk_color->tooltip(gettext("Change plot unknown track color"));
          btnFMT_unk_color->callback((Fl_Callback*)cb_btnFMT_unk_color);
        } // Fl_Button* btnFMT_unk_color
        { btnFMT_plot_ref_color = new Fl_Button(274, 153, 60, 22, gettext("Ref"));
          btnFMT_plot_ref_color->tooltip(gettext("Change plot reference track color"));
          btnFMT_plot_ref_color->callback((Fl_Callback*)cb_btnFMT_plot_ref_color);
        } // Fl_Button* btnFMT_plot_ref_color
        { btnFMT_plot_axis = new Fl_Button(274, 122, 60, 22, gettext("Axis"));
          btnFMT_plot_axis->tooltip(gettext("Change Axis\' color"));
          btnFMT_plot_axis->callback((Fl_Callback*)cb_btnFMT_plot_axis);
        } // Fl_Button* btnFMT_plot_axis
        { btnFMT_legend_color = new Fl_Button(339, 107, 60, 22, gettext("Lgnd"));
          btnFMT_legend_color->tooltip(gettext("Change legend color"));
          btnFMT_legend_color->callback((Fl_Callback*)cb_btnFMT_legend_color);
        } // Fl_Button* btnFMT_legend_color
        { Fl_Check_Button* o = btn_fmt_plot_over_axis = new Fl_Check_Button(341, 135, 31, 18, gettext("Line/Axis"));
          btn_fmt_plot_over_axis->tooltip(gettext("Enable to always plot data over axis"));
          btn_fmt_plot_over_axis->down_box(FL_DOWN_BOX);
          btn_fmt_plot_over_axis->callback((Fl_Callback*)cb_btn_fmt_plot_over_axis);
          o->value(progdefaults.FMT_plot_over_axis);
        } // Fl_Check_Button* btn_fmt_plot_over_axis
        { Fl_Check_Button* o = btn_fmt_thick_lines = new Fl_Check_Button(341, 160, 31, 18, gettext("Thick lines"));
          btn_fmt_thick_lines->tooltip(gettext("Enable to plot track lines 3 pixels wide"));
          btn_fmt_thick_lines->down_box(FL_DOWN_BOX);
          btn_fmt_thick_lines->callback((Fl_Callback*)cb_btn_fmt_thick_lines);
          o->value(progdefaults.FMT_thick_lines);
        } // Fl_Check_Button* btn_fmt_thick_lines
        { Fl_Counter* o = cnt_fmt_freq_corr = new Fl_Counter(465, 118, 123, 24, gettext("Freq Correction"));
          cnt_fmt_freq_corr->tooltip(gettext("Offset plot lines on vertical scale"));
          cnt_fmt_freq_corr->minimum(-5);
          cnt_fmt_freq_corr->maximum(5);
          cnt_fmt_freq_corr->step(0.001);
          cnt_fmt_freq_corr->callback((Fl_Callback*)cb_cnt_fmt_freq_corr);
          cnt_fmt_freq_corr->align(Fl_Align(FL_ALIGN_TOP));
          o->value(progdefaults.FMT_freq_corr);
          o->lstep(0.01);
        } // Fl_Counter* cnt_fmt_freq_corr
        { bnt_FMT_dec_corr = new Fl_Button(446, 119, 19, 24, gettext("@|<"));
          bnt_FMT_dec_corr->labelsize(10);
          bnt_FMT_dec_corr->callback((Fl_Callback*)cb_bnt_FMT_dec_corr);
        } // Fl_Button* bnt_FMT_dec_corr
        { btn_FMT_incr_corr = new Fl_Button(588, 119, 18, 24, gettext("@>|"));
          btn_FMT_incr_corr->labelsize(10);
          btn_FMT_incr_corr->callback((Fl_Callback*)cb_btn_FMT_incr_corr);
        } // Fl_Button* btn_FMT_incr_corr
        { Fl_Counter* o = cnt_fmt_freq_err = new Fl_Counter(470, 160, 123, 24, gettext("Max Error"));
          cnt_fmt_freq_err->tooltip(gettext("Limit freq estimate error to this value"));
          cnt_fmt_freq_err->minimum(0.5);
          cnt_fmt_freq_err->maximum(10);
          cnt_fmt_freq_err->value(2);
          cnt_fmt_freq_err->callback((Fl_Callback*)cb_cnt_fmt_freq_err);
          cnt_fmt_freq_err->align(Fl_Align(FL_ALIGN_TOP));
          o->value(progdefaults.FMT_freq_err);
          o->lstep(1.0);
        } // Fl_Counter* cnt_fmt_freq_err
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(203, 190, 207, 86, gettext("DFT Estimator"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cnt_FMT_movavg_len = new Fl_Counter(214, 232, 110, 24, gettext("Data Filter"));
          cnt_FMT_movavg_len->tooltip(gettext("Moving average - average over NN seconds^0 - no averaging"));
          cnt_FMT_movavg_len->minimum(0);
          cnt_FMT_movavg_len->maximum(10);
          cnt_FMT_movavg_len->value(1);
          cnt_FMT_movavg_len->callback((Fl_Callback*)cb_cnt_FMT_movavg_len);
          cnt_FMT_movavg_len->align(Fl_Align(FL_ALIGN_TOP));
          o->value(progdefaults.FMT_movavg_len);
          o->lstep(1.0);
        } // Fl_Counter* cnt_FMT_movavg_len
        { Fl_ListBox* o = listbox_fmt_dft_rate = new Fl_ListBox(334, 232, 60, 24, gettext("DFT rate"));
          listbox_fmt_dft_rate->tooltip(gettext("# DFT computations / second"));
          listbox_fmt_dft_rate->box(FL_DOWN_BOX);
          listbox_fmt_dft_rate->color(FL_BACKGROUND2_COLOR);
          listbox_fmt_dft_rate->selection_color(FL_BACKGROUND_COLOR);
          listbox_fmt_dft_rate->labeltype(FL_NORMAL_LABEL);
          listbox_fmt_dft_rate->labelfont(0);
          listbox_fmt_dft_rate->labelsize(14);
          listbox_fmt_dft_rate->labelcolor(FL_FOREGROUND_COLOR);
          listbox_fmt_dft_rate->callback((Fl_Callback*)cb_listbox_fmt_dft_rate);
          listbox_fmt_dft_rate->align(Fl_Align(FL_ALIGN_TOP));
          listbox_fmt_dft_rate->when(FL_WHEN_RELEASE);
          o->add("1|2|3|4|5|6|7|8");
          o->index(progdefaults.FMT_dft_rate);
          listbox_fmt_dft_rate->end();
        } // Fl_ListBox* listbox_fmt_dft_rate
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(411, 190, 205, 86, gettext("FIR Filter"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cnt_FMT_bpf = new Fl_Counter(457, 218, 100, 24, gettext("Width"));
          cnt_FMT_bpf->tooltip(gettext("Band pass filter / unknown / reference"));
          cnt_FMT_bpf->minimum(5);
          cnt_FMT_bpf->maximum(200);
          cnt_FMT_bpf->step(5);
          cnt_FMT_bpf->value(100);
          cnt_FMT_bpf->callback((Fl_Callback*)cb_cnt_FMT_bpf);
          cnt_FMT_bpf->align(Fl_Align(FL_ALIGN_TOP));
          o->value(progdefaults.FMT_bpf_width);
          o->lstep(50.0);
        } // Fl_Counter* cnt_FMT_bpf
        { Fl_Check_Button* o = btn_fmt_unk_bpf_on = new Fl_Check_Button(429, 246, 70, 18, gettext("bpf Unk\'"));
          btn_fmt_unk_bpf_on->tooltip(gettext("ON  - band pass filter unknown signal"));
          btn_fmt_unk_bpf_on->down_box(FL_DOWN_BOX);
          btn_fmt_unk_bpf_on->callback((Fl_Callback*)cb_btn_fmt_unk_bpf_on);
          o->value(progdefaults.FMT_unk_bpf_on);
        } // Fl_Check_Button* btn_fmt_unk_bpf_on
        { Fl_Check_Button* o = btn_fmt_ref_bpf_on = new Fl_Check_Button(526, 246, 70, 18, gettext("bpf Ref\'"));
          btn_fmt_ref_bpf_on->tooltip(gettext("ON  - band pass filter reference signal"));
          btn_fmt_ref_bpf_on->down_box(FL_DOWN_BOX);
          btn_fmt_ref_bpf_on->callback((Fl_Callback*)cb_btn_fmt_ref_bpf_on);
          o->value(progdefaults.FMT_ref_bpf_on);
        } // Fl_Check_Button* btn_fmt_ref_bpf_on
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(617, 190, 178, 86, gettext("CSV Data Recording"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btn_fmt_autorecord = new Fl_Check_Button(658, 246, 107, 18, gettext("Auto record"));
          btn_fmt_autorecord->tooltip(gettext("Automatically start csv data file recording with wav playback"));
          btn_fmt_autorecord->down_box(FL_DOWN_BOX);
        } // Fl_Check_Button* btn_fmt_autorecord
        { cnt_fmt_auto_record_time = new Fl_Counter(672, 218, 66, 24);
          cnt_fmt_auto_record_time->tooltip(gettext("Record data for NN minutes after auto start"));
          cnt_fmt_auto_record_time->type(1);
          cnt_fmt_auto_record_time->minimum(2);
          cnt_fmt_auto_record_time->maximum(60);
          cnt_fmt_auto_record_time->step(2);
          cnt_fmt_auto_record_time->value(2);
          cnt_fmt_auto_record_time->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        } // Fl_Counter* cnt_fmt_auto_record_time
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(203, 277, 592, 66, gettext("Wav file recording"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_fmt_record_wav = new Fl_Check_Button(464, 288, 118, 18, gettext("Record Audio"));
          btn_fmt_record_wav->tooltip(gettext("Wav file recording - START IMMEDIATELY"));
          btn_fmt_record_wav->down_box(FL_DOWN_BOX);
          btn_fmt_record_wav->callback((Fl_Callback*)cb_btn_fmt_record_wav);
          if (progdefaults.fmt_sync_wav_file) o->deactivate();
        } // Fl_Check_Button* btn_fmt_record_wav
        { Fl_Check_Button* o = btn_fmt_sync_wav = new Fl_Check_Button(599, 288, 118, 18, gettext("Sync to data record"));
          btn_fmt_sync_wav->tooltip(gettext("Wav file recording - SYNCHRONIZE with data recording"));
          btn_fmt_sync_wav->down_box(FL_DOWN_BOX);
          btn_fmt_sync_wav->callback((Fl_Callback*)cb_btn_fmt_sync_wav);
          o->value(progdefaults.fmt_sync_wav_file);
        } // Fl_Check_Button* btn_fmt_sync_wav
        { txt_fmt_wav_filename = new Fl_Output(213, 314, 570, 24, gettext("File pathname:"));
          txt_fmt_wav_filename->tooltip(gettext("Computer generated file name"));
          txt_fmt_wav_filename->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Output* txt_fmt_wav_filename
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(616, 24, 180, 131, gettext("Waterfall"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Box* o = new Fl_Box(626, 44, 168, 35, gettext("Shft-click: select unknown\nCtrl-click: select reference"));
          o->labelsize(12);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Check_Button* o = btn_fmt_center_on_unknown = new Fl_Check_Button(626, 85, 70, 18, gettext("Center on Unknown"));
          btn_fmt_center_on_unknown->tooltip(gettext("Waterfall Centered on unknown signal"));
          btn_fmt_center_on_unknown->down_box(FL_DOWN_BOX);
          btn_fmt_center_on_unknown->callback((Fl_Callback*)cb_btn_fmt_center_on_unknown);
          o->value(progdefaults.fmt_center_on_unknown);
        } // Fl_Check_Button* btn_fmt_center_on_unknown
        { Fl_Check_Button* o = btn_fmt_center_on_reference = new Fl_Check_Button(626, 109, 70, 18, gettext("Center on Reference"));
          btn_fmt_center_on_reference->tooltip(gettext("Waterfall centered on reference signal"));
          btn_fmt_center_on_reference->down_box(FL_DOWN_BOX);
          btn_fmt_center_on_reference->callback((Fl_Callback*)cb_btn_fmt_center_on_reference);
          o->value(progdefaults.fmt_center_on_reference);
        } // Fl_Check_Button* btn_fmt_center_on_reference
        { Fl_Check_Button* o = btn_fmt_center_on_median = new Fl_Check_Button(627, 133, 70, 17, gettext("Center on median"));
          btn_fmt_center_on_median->tooltip(gettext("Waterfall centered 1/2 way between unknown & reference"));
          btn_fmt_center_on_median->down_box(FL_DOWN_BOX);
          btn_fmt_center_on_median->callback((Fl_Callback*)cb_btn_fmt_center_on_median);
          o->value(progdefaults.fmt_center_on_median);
        } // Fl_Check_Button* btn_fmt_center_on_median
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(616, 156, 180, 32);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btn_fmt_use_tabs = new Fl_Check_Button(627, 165, 70, 18, gettext("Use TAB delimiters"));
          btn_fmt_use_tabs->tooltip(gettext("Use tab delimiters between columns on csv export file."));
          btn_fmt_use_tabs->down_box(FL_DOWN_BOX);
          btn_fmt_use_tabs->callback((Fl_Callback*)cb_btn_fmt_use_tabs);
          o->value(progdefaults.FMT_use_tabs);
        } // Fl_Check_Button* btn_fmt_use_tabs
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/FMT"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/FMT"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/FSQ"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(208, 23, 585, 60, gettext("Rx Parameters"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Value_Slider* o = valhits = new Fl_Value_Slider(343, 28, 125, 22, gettext("Min Hits"));
          valhits->tooltip(gettext("Minimum # hits in tone detector"));
          valhits->type(5);
          valhits->minimum(3);
          valhits->maximum(6);
          valhits->step(1);
          valhits->value(3);
          valhits->textsize(14);
          valhits->callback((Fl_Callback*)cb_valhits);
          valhits->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.fsqhits);
        } // Fl_Value_Slider* valhits
        { Fl_Choice* o = sel_fsq_lpf = new Fl_Choice(366, 53, 102, 22, gettext("Image LPF"));
          sel_fsq_lpf->tooltip(gettext("Narrow LPF if image noisy"));
          sel_fsq_lpf->down_box(FL_BORDER_BOX);
          sel_fsq_lpf->callback((Fl_Callback*)cb_sel_fsq_lpf);
          o->add("None"); o->add("300 Hz"); o->add("400 Hz"); o->add("500 Hz");
          o->value(progdefaults.fsq_img_filter);
        } // Fl_Choice* sel_fsq_lpf
        { Fl_Value_Slider* o = sldrMovAvg = new Fl_Value_Slider(613, 28, 125, 22, gettext("MovAvg:"));
          sldrMovAvg->tooltip(gettext("Filter FFT output"));
          sldrMovAvg->type(1);
          sldrMovAvg->minimum(1);
          sldrMovAvg->maximum(15);
          sldrMovAvg->step(1);
          sldrMovAvg->value(4);
          sldrMovAvg->textsize(14);
          sldrMovAvg->callback((Fl_Callback*)cb_sldrMovAvg);
          sldrMovAvg->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(progdefaults.fsq_movavg);
          o->maximum(MOVAVGLIMIT);
        } // Fl_Value_Slider* sldrMovAvg
        { Fl_Choice* o = sel_fsq_heard_aging = new Fl_Choice(636, 53, 102, 22, gettext("Heard aging"));
          sel_fsq_heard_aging->tooltip(gettext("Remove call after ..."));
          sel_fsq_heard_aging->down_box(FL_BORDER_BOX);
          sel_fsq_heard_aging->callback((Fl_Callback*)cb_sel_fsq_heard_aging);
          o->add("Never"); o->add("1 min"); o->add("5 min");o->add("10 min"); o->add("20 min"); o->add("20 min"); o->add("30 min"); o->add("60 min"); o->add("90 min"); o->add("120 min");
          o->value(progdefaults.fsq_heard_aging);
        } // Fl_Choice* sel_fsq_heard_aging
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(208, 83, 585, 100, gettext("Tx Parameters"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Round_Button* o = btn_fsqbaud[0] = new Fl_Round_Button(340, 90, 55, 15, gettext("1.5 baud"));
          btn_fsqbaud[0]->down_box(FL_ROUND_DOWN_BOX);
          btn_fsqbaud[0]->callback((Fl_Callback*)cb_btn_fsqbaud);
          o->value(progdefaults.fsqbaud == 1.5);
        } // Fl_Round_Button* btn_fsqbaud[0]
        { Fl_Round_Button* o = btn_fsqbaud[1] = new Fl_Round_Button(430, 90, 55, 15, gettext("2 baud"));
          btn_fsqbaud[1]->down_box(FL_ROUND_DOWN_BOX);
          btn_fsqbaud[1]->callback((Fl_Callback*)cb_btn_fsqbaud1);
          o->value(progdefaults.fsqbaud == 2);
        } // Fl_Round_Button* btn_fsqbaud[1]
        { Fl_Round_Button* o = btn_fsqbaud[2] = new Fl_Round_Button(520, 90, 55, 15, gettext("3 baud"));
          btn_fsqbaud[2]->down_box(FL_ROUND_DOWN_BOX);
          btn_fsqbaud[2]->callback((Fl_Callback*)cb_btn_fsqbaud2);
          o->value(progdefaults.fsqbaud == 3);
        } // Fl_Round_Button* btn_fsqbaud[2]
        { Fl_Round_Button* o = btn_fsqbaud[3] = new Fl_Round_Button(610, 90, 55, 15, gettext("4.5 baud"));
          btn_fsqbaud[3]->down_box(FL_ROUND_DOWN_BOX);
          btn_fsqbaud[3]->callback((Fl_Callback*)cb_btn_fsqbaud3);
          o->value(progdefaults.fsqbaud == 4.5);
        } // Fl_Round_Button* btn_fsqbaud[3]
        { Fl_Round_Button* o = btn_fsqbaud[4] = new Fl_Round_Button(700, 90, 55, 15, gettext("6 baud"));
          btn_fsqbaud[4]->down_box(FL_ROUND_DOWN_BOX);
          btn_fsqbaud[4]->callback((Fl_Callback*)cb_btn_fsqbaud4);
          o->value(progdefaults.fsqbaud == 6);
        } // Fl_Round_Button* btn_fsqbaud[4]
        { Fl_Choice* o = sel_fsq_sounder = new Fl_Choice(283, 110, 100, 22, gettext("Sounder"));
          sel_fsq_sounder->tooltip(gettext("Send beacon every ..."));
          sel_fsq_sounder->down_box(FL_BORDER_BOX);
          sel_fsq_sounder->callback((Fl_Callback*)cb_sel_fsq_sounder);
          o->add("OFF"); o->add("1 min"); o->add("10 min"); o->add("30 min"); o->add("60 min");
          o->value(progdefaults.fsq_sounder);
        } // Fl_Choice* sel_fsq_sounder
        { Fl_Counter* o = cntr_FSQ_time_out = new Fl_Counter(457, 110, 80, 22, gettext("Time out"));
          cntr_FSQ_time_out->tooltip(gettext("Time out xmt attempt in XX seconds"));
          cntr_FSQ_time_out->type(1);
          cntr_FSQ_time_out->minimum(2);
          cntr_FSQ_time_out->maximum(20);
          cntr_FSQ_time_out->step(1);
          cntr_FSQ_time_out->value(6);
          cntr_FSQ_time_out->callback((Fl_Callback*)cb_cntr_FSQ_time_out);
          cntr_FSQ_time_out->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(progdefaults.fsq_time_out);
        } // Fl_Counter* cntr_FSQ_time_out
        { Fl_Input* o = new Fl_Input(284, 135, 456, 22, gettext("QTC:"));
          o->tooltip(gettext("Enter QTC text"));
          o->callback((Fl_Callback*)cb_QTC);
          o->value(progdefaults.fsqQTCtext.c_str());
        } // Fl_Input* o
        { Fl_Check_Button* o = btn_fsq_lowercase = new Fl_Check_Button(214, 162, 214, 15, gettext("MYCALL lower case"));
          btn_fsq_lowercase->tooltip(gettext("convert operator callsign to lower case"));
          btn_fsq_lowercase->down_box(FL_DOWN_BOX);
          btn_fsq_lowercase->callback((Fl_Callback*)cb_btn_fsq_lowercase);
          o->value(progdefaults.fsq_lowercase);
        } // Fl_Check_Button* btn_fsq_lowercase
        { Fl_Input2* o = inpMyFSQQth = new Fl_Input2(420, 158, 320, 22, gettext("QTH:"));
          inpMyFSQQth->tooltip(gettext("Operators QTH"));
          inpMyFSQQth->box(FL_DOWN_BOX);
          inpMyFSQQth->color(FL_BACKGROUND2_COLOR);
          inpMyFSQQth->selection_color(FL_SELECTION_COLOR);
          inpMyFSQQth->labeltype(FL_NORMAL_LABEL);
          inpMyFSQQth->labelfont(0);
          inpMyFSQQth->labelsize(14);
          inpMyFSQQth->labelcolor(FL_FOREGROUND_COLOR);
          inpMyFSQQth->callback((Fl_Callback*)cb_inpMyFSQQth);
          inpMyFSQQth->align(Fl_Align(FL_ALIGN_LEFT));
          inpMyFSQQth->when(FL_WHEN_RELEASE);
          inpMyFSQQth->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.myQth.c_str());
        } // Fl_Input2* inpMyFSQQth
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(208, 184, 585, 44, gettext("Message Logging"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_fsq_msg_dt_stamp = new Fl_Check_Button(238, 205, 135, 15, gettext("Add date/time"));
          btn_fsq_msg_dt_stamp->tooltip(gettext("Add date/time stamp to each # received message"));
          btn_fsq_msg_dt_stamp->down_box(FL_DOWN_BOX);
          btn_fsq_msg_dt_stamp->value(1);
          btn_fsq_msg_dt_stamp->callback((Fl_Callback*)cb_btn_fsq_msg_dt_stamp);
          o->value(progdefaults.add_fsq_msg_dt);
        } // Fl_Check_Button* btn_fsq_msg_dt_stamp
        { Fl_Check_Button* o = btn_fsq_msg_append = new Fl_Check_Button(385, 205, 210, 15, gettext("always append to file(s)"));
          btn_fsq_msg_append->tooltip(gettext("append # directive msgs to named file"));
          btn_fsq_msg_append->down_box(FL_DOWN_BOX);
          btn_fsq_msg_append->value(1);
          btn_fsq_msg_append->callback((Fl_Callback*)cb_btn_fsq_msg_append);
          o->value(progdefaults.always_append);
        } // Fl_Check_Button* btn_fsq_msg_append
        { Fl_Counter* o = cntr_FSQ_notify_time_out = new Fl_Counter(698, 201, 80, 22, gettext("Notify time out"));
          cntr_FSQ_notify_time_out->tooltip(gettext("Notification dialog closes after XX seconds;^j0 == dialog remains open"));
          cntr_FSQ_notify_time_out->type(1);
          cntr_FSQ_notify_time_out->minimum(0);
          cntr_FSQ_notify_time_out->maximum(30);
          cntr_FSQ_notify_time_out->step(1);
          cntr_FSQ_notify_time_out->value(10);
          cntr_FSQ_notify_time_out->callback((Fl_Callback*)cb_cntr_FSQ_notify_time_out);
          cntr_FSQ_notify_time_out->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(progdefaults.fsq_notify_time_out);
        } // Fl_Counter* cntr_FSQ_notify_time_out
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(208, 228, 585, 80, gettext("Logging"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Output* o = txtAuditLog = new Fl_Output(285, 248, 325, 22, gettext("Audit log"));
          o->value(progdefaults.fsq_audit_log.c_str());
        } // Fl_Output* txtAuditLog
        { Fl_Light_Button* o = btn_enable_auditlog = new Fl_Light_Button(624, 249, 74, 20, gettext("Enable"));
          btn_enable_auditlog->selection_color((Fl_Color)2);
          btn_enable_auditlog->callback((Fl_Callback*)cb_btn_enable_auditlog);
          o->value(progdefaults.fsq_enable_audit_log);
        } // Fl_Light_Button* btn_enable_auditlog
        { btn_select_auditlog = new Fl_Button(712, 249, 70, 20, gettext("Select"));
          btn_select_auditlog->callback((Fl_Callback*)cb_btn_select_auditlog);
        } // Fl_Button* btn_select_auditlog
        { Fl_Output* o = txtHeardLog = new Fl_Output(285, 276, 325, 22, gettext("Heard log"));
          o->value(progdefaults.fsq_heard_log.c_str());
        } // Fl_Output* txtHeardLog
        { Fl_Light_Button* o = btn_enable_fsq_heard_log = new Fl_Light_Button(624, 277, 74, 20, gettext("Enable"));
          btn_enable_fsq_heard_log->selection_color((Fl_Color)2);
          btn_enable_fsq_heard_log->callback((Fl_Callback*)cb_btn_enable_fsq_heard_log);
          o->value(progdefaults.fsq_enable_heard_log);
        } // Fl_Light_Button* btn_enable_fsq_heard_log
        { btn_select_fsq_heard_log = new Fl_Button(712, 277, 70, 20, gettext("Select"));
          btn_select_fsq_heard_log->callback((Fl_Callback*)cb_btn_select_fsq_heard_log);
        } // Fl_Button* btn_select_fsq_heard_log
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(208, 308, 585, 35, gettext("Text Colors"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btn_fsq_xmt_color = new Fl_Button(348, 315, 40, 20, gettext("XMIT"));
          btn_fsq_xmt_color->tooltip(gettext("Transmit text"));
          btn_fsq_xmt_color->callback((Fl_Callback*)cb_btn_fsq_xmt_color);
          btn_fsq_xmt_color->align(Fl_Align(FL_ALIGN_LEFT));
          btn_fsq_xmt_color->color(RGBCOLOR(fsq_xmt_color));
        } // Fl_Button* btn_fsq_xmt_color
        { btn_fsq_directed_color = new Fl_Button(478, 315, 40, 20, gettext("DIRECTED"));
          btn_fsq_directed_color->tooltip(gettext("Directed received text"));
          btn_fsq_directed_color->callback((Fl_Callback*)cb_btn_fsq_directed_color);
          btn_fsq_directed_color->align(Fl_Align(FL_ALIGN_LEFT));
          btn_fsq_directed_color->color(RGBCOLOR(fsq_directed_color));
        } // Fl_Button* btn_fsq_directed_color
        { btn_fsq_undirected_color = new Fl_Button(628, 315, 40, 20, gettext("UNDIRECTED"));
          btn_fsq_undirected_color->tooltip(gettext("Undirected received text"));
          btn_fsq_undirected_color->callback((Fl_Callback*)cb_btn_fsq_undirected_color);
          btn_fsq_undirected_color->align(Fl_Align(FL_ALIGN_LEFT));
          btn_fsq_undirected_color->color(RGBCOLOR(fsq_undirected_color));
        } // Fl_Button* btn_fsq_undirected_color
        { btn_fsq_color_defaults = new Fl_Button(710, 315, 74, 20, gettext("Defaults"));
          btn_fsq_color_defaults->callback((Fl_Callback*)cb_btn_fsq_color_defaults);
        } // Fl_Button* btn_fsq_color_defaults
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/FSQ"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/FSQ"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/IFKP"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(208, 25, 587, 110, gettext("Tx Parameters"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Round_Button* o = btn_ifkpbaud[0] = new Fl_Round_Button(303, 53, 100, 17, gettext("1/2 speed"));
          btn_ifkpbaud[0]->down_box(FL_ROUND_DOWN_BOX);
          btn_ifkpbaud[0]->callback((Fl_Callback*)cb_btn_ifkpbaud);
          o->value(progdefaults.ifkp_baud == 0);
        } // Fl_Round_Button* btn_ifkpbaud[0]
        { Fl_Round_Button* o = btn_ifkpbaud[1] = new Fl_Round_Button(411, 53, 100, 17, gettext("1x speed"));
          btn_ifkpbaud[1]->tooltip(gettext("default"));
          btn_ifkpbaud[1]->down_box(FL_ROUND_DOWN_BOX);
          btn_ifkpbaud[1]->callback((Fl_Callback*)cb_btn_ifkpbaud1);
          o->value(progdefaults.ifkp_baud == 1);
        } // Fl_Round_Button* btn_ifkpbaud[1]
        { Fl_Round_Button* o = btn_ifkpbaud[2] = new Fl_Round_Button(519, 53, 100, 17, gettext("2x speed"));
          btn_ifkpbaud[2]->down_box(FL_ROUND_DOWN_BOX);
          btn_ifkpbaud[2]->callback((Fl_Callback*)cb_btn_ifkpbaud2);
          o->value(progdefaults.ifkp_baud == 2);
        } // Fl_Round_Button* btn_ifkpbaud[2]
        { Fl_Check_Button* o = btn_ifkp_lowercase = new Fl_Check_Button(303, 82, 220, 15, gettext("MYCALL always lower case"));
          btn_ifkp_lowercase->tooltip(gettext("convert operator callsign to lower case"));
          btn_ifkp_lowercase->down_box(FL_DOWN_BOX);
          btn_ifkp_lowercase->callback((Fl_Callback*)cb_btn_ifkp_lowercase);
          o->value(progdefaults.ifkp_lowercase);
        } // Fl_Check_Button* btn_ifkp_lowercase
        { Fl_Check_Button* o = btn_ifkp_lowercase_call = new Fl_Check_Button(528, 82, 220, 15, gettext("CALLSIGN always lower case"));
          btn_ifkp_lowercase_call->tooltip(gettext("convert other callsign to lower case"));
          btn_ifkp_lowercase_call->down_box(FL_DOWN_BOX);
          btn_ifkp_lowercase_call->callback((Fl_Callback*)cb_btn_ifkp_lowercase_call);
          o->value(progdefaults.ifkp_lowercase_call);
        } // Fl_Check_Button* btn_ifkp_lowercase_call
        { Fl_Check_Button* o = btn_ifkp_freqlock = new Fl_Check_Button(303, 109, 220, 15, gettext("lock WF at 1500 Hz"));
          btn_ifkp_freqlock->tooltip(gettext("Always transmit at 1500 Hertz center freq."));
          btn_ifkp_freqlock->down_box(FL_DOWN_BOX);
          btn_ifkp_freqlock->callback((Fl_Callback*)cb_btn_ifkp_freqlock);
          o->value(progdefaults.ifkp_freqlock);
        } // Fl_Check_Button* btn_ifkp_freqlock
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(208, 138, 587, 92, gettext("Logging"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Output* o = txt_ifkp_audit_log = new Fl_Output(295, 164, 323, 25, gettext("Audit log"));
          o->value(progdefaults.ifkp_audit_log.c_str());
        } // Fl_Output* txt_ifkp_audit_log
        { Fl_Light_Button* o = btn_enable_ifkp_audit_log = new Fl_Light_Button(632, 164, 73, 25, gettext("Enable"));
          btn_enable_ifkp_audit_log->selection_color((Fl_Color)2);
          btn_enable_ifkp_audit_log->callback((Fl_Callback*)cb_btn_enable_ifkp_audit_log);
          o->value(progdefaults.ifkp_enable_audit_log);
        } // Fl_Light_Button* btn_enable_ifkp_audit_log
        { btn_ifkp_select_auditlog = new Fl_Button(713, 164, 70, 25, gettext("Select"));
          btn_ifkp_select_auditlog->callback((Fl_Callback*)cb_btn_ifkp_select_auditlog);
        } // Fl_Button* btn_ifkp_select_auditlog
        { Fl_Output* o = txt_ifkp_heard_log = new Fl_Output(295, 193, 323, 25, gettext("Heard log"));
          o->value(progdefaults.ifkp_heard_log.c_str());
        } // Fl_Output* txt_ifkp_heard_log
        { Fl_Light_Button* o = btn_enable_ifkp_heard_log = new Fl_Light_Button(632, 193, 73, 25, gettext("Enable"));
          btn_enable_ifkp_heard_log->selection_color((Fl_Color)2);
          btn_enable_ifkp_heard_log->callback((Fl_Callback*)cb_btn_enable_ifkp_heard_log);
          o->value(progdefaults.ifkp_enable_heard_log);
        } // Fl_Light_Button* btn_enable_ifkp_heard_log
        { btn_select_ifkp_heard_log = new Fl_Button(713, 193, 70, 25, gettext("Select"));
          btn_select_ifkp_heard_log->callback((Fl_Callback*)cb_btn_select_ifkp_heard_log);
        } // Fl_Button* btn_select_ifkp_heard_log
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = ifkp_image_box = new Fl_Group(295, 236, 59, 74, gettext("\nOperator avatar"));
        ifkp_image_box->box(FL_FLAT_BOX);
        ifkp_image_box->color(FL_BLACK);
        ifkp_image_box->selection_color(FL_BACKGROUND_COLOR);
        ifkp_image_box->labeltype(FL_NORMAL_LABEL);
        ifkp_image_box->labelfont(0);
        ifkp_image_box->labelsize(14);
        ifkp_image_box->labelcolor(FL_FOREGROUND_COLOR);
        ifkp_image_box->align(Fl_Align(FL_ALIGN_BOTTOM));
        ifkp_image_box->when(FL_WHEN_RELEASE);
        init_def_ifkp_avatar(o);
      } // Fl_Group* ifkp_image_box
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/IFKP"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/IFKP"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/MFSK"));
      o->box(FL_FLAT_BOX);
      o->hide();
      { Fl_Counter* o = MFSK_afc_avg = new Fl_Counter(360, 160, 100, 22, gettext("AFC low pass filter"));
        MFSK_afc_avg->tooltip(gettext("Higher values result in slower AFC response\nand greater noise immunity"));
        MFSK_afc_avg->minimum(2);
        MFSK_afc_avg->maximum(500);
        MFSK_afc_avg->step(1);
        MFSK_afc_avg->value(32);
        MFSK_afc_avg->callback((Fl_Callback*)cb_MFSK_afc_avg);
        MFSK_afc_avg->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.mfsk_avg);
        o->labelsize(FL_NORMAL_SIZE);
        o->lstep(10);
      } // Fl_Counter* MFSK_afc_avg
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/MFSK"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/MFSK"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/MT-63"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(249, 36, 490, 84);
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnMT63_8bit = new Fl_Check_Button(394, 50, 205, 20, gettext("8-bit extended characters (UTF-8)"));
          btnMT63_8bit->tooltip(gettext("Enable this for UTF-8 characters"));
          btnMT63_8bit->down_box(FL_DOWN_BOX);
          btnMT63_8bit->value(1);
          btnMT63_8bit->callback((Fl_Callback*)cb_btnMT63_8bit);
          o->value(progdefaults.mt63_8bit);
        } // Fl_Check_Button* btnMT63_8bit
        { Fl_Check_Button* o = btnMT63_rx_integration = new Fl_Check_Button(394, 80, 190, 20, gettext("Long receive integration"));
          btnMT63_rx_integration->tooltip(gettext("Enable for very weak signals"));
          btnMT63_rx_integration->down_box(FL_DOWN_BOX);
          btnMT63_rx_integration->value(1);
          btnMT63_rx_integration->callback((Fl_Callback*)cb_btnMT63_rx_integration);
          o->value(progdefaults.mt63_rx_integration);
        } // Fl_Check_Button* btnMT63_rx_integration
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(249, 132, 490, 178);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btnMT63_usetones = new Fl_Check_Button(393, 140, 200, 20, gettext("Transmit lower start tone"));
          btnMT63_usetones->down_box(FL_DOWN_BOX);
          btnMT63_usetones->callback((Fl_Callback*)cb_btnMT63_usetones);
          o->value(progdefaults.mt63_usetones);
        } // Fl_Check_Button* btnMT63_usetones
        { Fl_Check_Button* o = btnMT63_upper_lower = new Fl_Check_Button(393, 170, 200, 20, gettext("Transmit upper start tone"));
          btnMT63_upper_lower->down_box(FL_DOWN_BOX);
          btnMT63_upper_lower->callback((Fl_Callback*)cb_btnMT63_upper_lower);
          o->value(progdefaults.mt63_twotones);
          if (!btnMT63_usetones->value()) o->deactivate();
        } // Fl_Check_Button* btnMT63_upper_lower
        { Fl_Spinner2* o = MT63_tone_duration = new Fl_Spinner2(393, 196, 40, 20, gettext("Tone Duration (secs)"));
          MT63_tone_duration->box(FL_NO_BOX);
          MT63_tone_duration->color(FL_BACKGROUND_COLOR);
          MT63_tone_duration->selection_color(FL_BACKGROUND_COLOR);
          MT63_tone_duration->labeltype(FL_NORMAL_LABEL);
          MT63_tone_duration->labelfont(0);
          MT63_tone_duration->labelsize(14);
          MT63_tone_duration->labelcolor(FL_FOREGROUND_COLOR);
          MT63_tone_duration->maximum(10);
          MT63_tone_duration->value(4);
          MT63_tone_duration->callback((Fl_Callback*)cb_MT63_tone_duration);
          MT63_tone_duration->align(Fl_Align(FL_ALIGN_RIGHT));
          MT63_tone_duration->when(FL_WHEN_RELEASE);
          o->value(progdefaults.mt63_tone_duration);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Spinner2* MT63_tone_duration
        { Fl_Check_Button* o = btnMT63_at500 = new Fl_Check_Button(393, 225, 200, 20, gettext("Low tone at 500 Hz"));
          btnMT63_at500->down_box(FL_DOWN_BOX);
          btnMT63_at500->callback((Fl_Callback*)cb_btnMT63_at500);
          o->value(progdefaults.mt63_at500);
        } // Fl_Check_Button* btnMT63_at500
        { Fl_Check_Button* o = btnMT63_centered = new Fl_Check_Button(393, 250, 248, 20, gettext("Centered at 1500 Hz (SHARES)"));
          btnMT63_centered->down_box(FL_DOWN_BOX);
          btnMT63_centered->callback((Fl_Callback*)cb_btnMT63_centered);
          o->value(progdefaults.mt63_centered);
        } // Fl_Check_Button* btnMT63_centered
        { Fl_Check_Button* o = btnMT63_manual = new Fl_Check_Button(393, 275, 200, 20, gettext("Manual tuning"));
          btnMT63_manual->down_box(FL_DOWN_BOX);
          btnMT63_manual->callback((Fl_Callback*)cb_btnMT63_manual);
          o->value(!progdefaults.mt63_at500 && !progdefaults.mt63_centered);
        } // Fl_Check_Button* btnMT63_manual
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/MT-63"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/MT-63"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/Contestia"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(257, 40, 490, 240);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_ListBox* o = i_listbox_contestia_bandwidth = new Fl_ListBox(312, 60, 85, 22, gettext("Bandwidth"));
          i_listbox_contestia_bandwidth->tooltip(gettext("Select bandwidth"));
          i_listbox_contestia_bandwidth->box(FL_DOWN_BOX);
          i_listbox_contestia_bandwidth->color(FL_BACKGROUND2_COLOR);
          i_listbox_contestia_bandwidth->selection_color(FL_BACKGROUND_COLOR);
          i_listbox_contestia_bandwidth->labeltype(FL_NORMAL_LABEL);
          i_listbox_contestia_bandwidth->labelfont(0);
          i_listbox_contestia_bandwidth->labelsize(14);
          i_listbox_contestia_bandwidth->labelcolor(FL_FOREGROUND_COLOR);
          i_listbox_contestia_bandwidth->callback((Fl_Callback*)cb_i_listbox_contestia_bandwidth);
          i_listbox_contestia_bandwidth->align(Fl_Align(FL_ALIGN_RIGHT));
          i_listbox_contestia_bandwidth->when(FL_WHEN_RELEASE);
          o->add(szContestiaBandwidth);
          o->index(progdefaults.contestiabw);
          o->labelsize(FL_NORMAL_SIZE);
          i_listbox_contestia_bandwidth->end();
        } // Fl_ListBox* i_listbox_contestia_bandwidth
        { Fl_ListBox* o = i_listbox_contestia_tones = new Fl_ListBox(573, 60, 70, 22, gettext("Tones"));
          i_listbox_contestia_tones->tooltip(gettext("Select number of tones"));
          i_listbox_contestia_tones->box(FL_DOWN_BOX);
          i_listbox_contestia_tones->color(FL_BACKGROUND2_COLOR);
          i_listbox_contestia_tones->selection_color(FL_BACKGROUND_COLOR);
          i_listbox_contestia_tones->labeltype(FL_NORMAL_LABEL);
          i_listbox_contestia_tones->labelfont(0);
          i_listbox_contestia_tones->labelsize(14);
          i_listbox_contestia_tones->labelcolor(FL_FOREGROUND_COLOR);
          i_listbox_contestia_tones->callback((Fl_Callback*)cb_i_listbox_contestia_tones);
          i_listbox_contestia_tones->align(Fl_Align(FL_ALIGN_RIGHT));
          i_listbox_contestia_tones->when(FL_WHEN_RELEASE);
          o->add(szContestiaTones);
          o->index(progdefaults.contestiatones);
          o->labelsize(FL_NORMAL_SIZE);
          i_listbox_contestia_tones->end();
        } // Fl_ListBox* i_listbox_contestia_tones
        { Fl_Group* o = new Fl_Group(295, 99, 414, 101, gettext("Receive synchronizer"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Counter2* o = cntContestia_smargin = new Fl_Counter2(314, 130, 70, 22, gettext("Tune margin (tone frequency spacing)"));
            cntContestia_smargin->tooltip(gettext("Change ONLY to experiment"));
            cntContestia_smargin->type(1);
            cntContestia_smargin->box(FL_UP_BOX);
            cntContestia_smargin->color(FL_BACKGROUND_COLOR);
            cntContestia_smargin->selection_color(FL_INACTIVE_COLOR);
            cntContestia_smargin->labeltype(FL_NORMAL_LABEL);
            cntContestia_smargin->labelfont(0);
            cntContestia_smargin->labelsize(14);
            cntContestia_smargin->labelcolor(FL_FOREGROUND_COLOR);
            cntContestia_smargin->minimum(2);
            cntContestia_smargin->maximum(128);
            cntContestia_smargin->step(1);
            cntContestia_smargin->value(8);
            cntContestia_smargin->callback((Fl_Callback*)cb_cntContestia_smargin);
            cntContestia_smargin->align(Fl_Align(FL_ALIGN_RIGHT));
            cntContestia_smargin->when(FL_WHEN_CHANGED);
            o->labelsize(FL_NORMAL_SIZE);
          } // Fl_Counter2* cntContestia_smargin
          { Fl_Counter2* o = cntContestia_sinteg = new Fl_Counter2(314, 162, 70, 22, gettext("Integration period (FEC blocks)"));
            cntContestia_sinteg->tooltip(gettext("Change ONLY to experiment"));
            cntContestia_sinteg->type(1);
            cntContestia_sinteg->box(FL_UP_BOX);
            cntContestia_sinteg->color(FL_BACKGROUND_COLOR);
            cntContestia_sinteg->selection_color(FL_INACTIVE_COLOR);
            cntContestia_sinteg->labeltype(FL_NORMAL_LABEL);
            cntContestia_sinteg->labelfont(0);
            cntContestia_sinteg->labelsize(14);
            cntContestia_sinteg->labelcolor(FL_FOREGROUND_COLOR);
            cntContestia_sinteg->minimum(2);
            cntContestia_sinteg->maximum(128);
            cntContestia_sinteg->step(1);
            cntContestia_sinteg->value(4);
            cntContestia_sinteg->callback((Fl_Callback*)cb_cntContestia_sinteg);
            cntContestia_sinteg->align(Fl_Align(FL_ALIGN_RIGHT));
            cntContestia_sinteg->when(FL_WHEN_CHANGED);
            o->labelsize(FL_NORMAL_SIZE);
          } // Fl_Counter2* cntContestia_sinteg
          o->end();
        } // Fl_Group* o
        { btnContestia_8bit = new Fl_Check_Button(312, 209, 200, 20, gettext("8-bit extended characters"));
          btnContestia_8bit->tooltip(gettext("Enable this for Latin-1 accented characters"));
          btnContestia_8bit->down_box(FL_DOWN_BOX);
          btnContestia_8bit->callback((Fl_Callback*)cb_btnContestia_8bit);
        } // Fl_Check_Button* btnContestia_8bit
        { Fl_Check_Button* o = btnContestia_start_stop_tones = new Fl_Check_Button(312, 240, 265, 20, gettext("xmt start/stop tones"));
          btnContestia_start_stop_tones->tooltip(gettext("Enable this to send start/stop tones"));
          btnContestia_start_stop_tones->down_box(FL_DOWN_BOX);
          btnContestia_start_stop_tones->callback((Fl_Callback*)cb_btnContestia_start_stop_tones);
          o->value(progdefaults.contestia_start_tones);
        } // Fl_Check_Button* btnContestia_start_stop_tones
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/Contestia"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/Contestia"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/Olivia"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(253, 40, 490, 280);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_ListBox* o = i_listbox_olivia_bandwidth = new Fl_ListBox(308, 60, 85, 22, gettext("Bandwidth"));
          i_listbox_olivia_bandwidth->tooltip(gettext("Select bandwidth"));
          i_listbox_olivia_bandwidth->box(FL_DOWN_BOX);
          i_listbox_olivia_bandwidth->color(FL_BACKGROUND2_COLOR);
          i_listbox_olivia_bandwidth->selection_color(FL_BACKGROUND_COLOR);
          i_listbox_olivia_bandwidth->labeltype(FL_NORMAL_LABEL);
          i_listbox_olivia_bandwidth->labelfont(0);
          i_listbox_olivia_bandwidth->labelsize(14);
          i_listbox_olivia_bandwidth->labelcolor(FL_FOREGROUND_COLOR);
          i_listbox_olivia_bandwidth->callback((Fl_Callback*)cb_i_listbox_olivia_bandwidth);
          i_listbox_olivia_bandwidth->align(Fl_Align(FL_ALIGN_RIGHT));
          i_listbox_olivia_bandwidth->when(FL_WHEN_RELEASE);
          o->add(szOliviaBandwidth);
          o->index(progdefaults.oliviabw);
          o->labelsize(FL_NORMAL_SIZE);
          i_listbox_olivia_bandwidth->end();
        } // Fl_ListBox* i_listbox_olivia_bandwidth
        { Fl_ListBox* o = i_listbox_olivia_tones = new Fl_ListBox(569, 60, 70, 22, gettext("Tones"));
          i_listbox_olivia_tones->tooltip(gettext("Select number of tones"));
          i_listbox_olivia_tones->box(FL_DOWN_BOX);
          i_listbox_olivia_tones->color(FL_BACKGROUND2_COLOR);
          i_listbox_olivia_tones->selection_color(FL_BACKGROUND_COLOR);
          i_listbox_olivia_tones->labeltype(FL_NORMAL_LABEL);
          i_listbox_olivia_tones->labelfont(0);
          i_listbox_olivia_tones->labelsize(14);
          i_listbox_olivia_tones->labelcolor(FL_FOREGROUND_COLOR);
          i_listbox_olivia_tones->callback((Fl_Callback*)cb_i_listbox_olivia_tones);
          i_listbox_olivia_tones->align(Fl_Align(FL_ALIGN_RIGHT));
          i_listbox_olivia_tones->when(FL_WHEN_RELEASE);
          o->add(szOliviaTones);
          o->index(progdefaults.oliviatones);
          o->labelsize(FL_NORMAL_SIZE);
          i_listbox_olivia_tones->end();
        } // Fl_ListBox* i_listbox_olivia_tones
        { Fl_Group* o = new Fl_Group(308, 99, 379, 133, gettext("Receive synchronizer"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Counter2* o = cntOlivia_smargin = new Fl_Counter2(323, 130, 70, 22, gettext("Tune margin (tone frequency spacing)"));
            cntOlivia_smargin->tooltip(gettext("Change ONLY to experiment"));
            cntOlivia_smargin->type(1);
            cntOlivia_smargin->box(FL_UP_BOX);
            cntOlivia_smargin->color(FL_BACKGROUND_COLOR);
            cntOlivia_smargin->selection_color(FL_INACTIVE_COLOR);
            cntOlivia_smargin->labeltype(FL_NORMAL_LABEL);
            cntOlivia_smargin->labelfont(0);
            cntOlivia_smargin->labelsize(14);
            cntOlivia_smargin->labelcolor(FL_FOREGROUND_COLOR);
            cntOlivia_smargin->minimum(2);
            cntOlivia_smargin->maximum(128);
            cntOlivia_smargin->step(1);
            cntOlivia_smargin->value(8);
            cntOlivia_smargin->callback((Fl_Callback*)cb_cntOlivia_smargin);
            cntOlivia_smargin->align(Fl_Align(FL_ALIGN_RIGHT));
            cntOlivia_smargin->when(FL_WHEN_CHANGED);
            o->labelsize(FL_NORMAL_SIZE);
            o->value(progdefaults.oliviasmargin);
          } // Fl_Counter2* cntOlivia_smargin
          { Fl_Counter2* o = cntOlivia_sinteg = new Fl_Counter2(323, 162, 70, 22, gettext("Integration period (FEC blocks)"));
            cntOlivia_sinteg->tooltip(gettext("Change ONLY to experiment"));
            cntOlivia_sinteg->type(1);
            cntOlivia_sinteg->box(FL_UP_BOX);
            cntOlivia_sinteg->color(FL_BACKGROUND_COLOR);
            cntOlivia_sinteg->selection_color(FL_INACTIVE_COLOR);
            cntOlivia_sinteg->labeltype(FL_NORMAL_LABEL);
            cntOlivia_sinteg->labelfont(0);
            cntOlivia_sinteg->labelsize(14);
            cntOlivia_sinteg->labelcolor(FL_FOREGROUND_COLOR);
            cntOlivia_sinteg->minimum(2);
            cntOlivia_sinteg->maximum(128);
            cntOlivia_sinteg->step(1);
            cntOlivia_sinteg->value(4);
            cntOlivia_sinteg->callback((Fl_Callback*)cb_cntOlivia_sinteg);
            cntOlivia_sinteg->align(Fl_Align(FL_ALIGN_RIGHT));
            cntOlivia_sinteg->when(FL_WHEN_CHANGED);
            o->labelsize(FL_NORMAL_SIZE);
            o->value(progdefaults.oliviasinteg);
          } // Fl_Counter2* cntOlivia_sinteg
          { Fl_Check_Button* o = btn_olivia_reset_fec = new Fl_Check_Button(324, 194, 349, 20, gettext("Reset FEC blocks when changing BW or Tones"));
            btn_olivia_reset_fec->tooltip(gettext("Enable this for UTF-8 character transmission"));
            btn_olivia_reset_fec->down_box(FL_DOWN_BOX);
            btn_olivia_reset_fec->callback((Fl_Callback*)cb_btn_olivia_reset_fec);
            o->value(progdefaults.olivia_reset_fec);
          } // Fl_Check_Button* btn_olivia_reset_fec
          o->end();
        } // Fl_Group* o
        { Fl_Check_Button* o = btnOlivia_8bit = new Fl_Check_Button(329, 255, 265, 20, gettext("8-bit extended characters (UTF-8)"));
          btnOlivia_8bit->tooltip(gettext("Enable this for UTF-8 character transmission"));
          btnOlivia_8bit->down_box(FL_DOWN_BOX);
          btnOlivia_8bit->callback((Fl_Callback*)cb_btnOlivia_8bit);
          o->value(progdefaults.olivia8bit);
        } // Fl_Check_Button* btnOlivia_8bit
        { Fl_Check_Button* o = btnOlivia_start_stop_tones = new Fl_Check_Button(329, 279, 265, 20, gettext("xmt start/stop tones"));
          btnOlivia_start_stop_tones->tooltip(gettext("Enable this to send start/stop tones"));
          btnOlivia_start_stop_tones->down_box(FL_DOWN_BOX);
          btnOlivia_start_stop_tones->callback((Fl_Callback*)cb_btnOlivia_start_stop_tones);
          o->value(progdefaults.olivia_start_tones);
        } // Fl_Check_Button* btnOlivia_start_stop_tones
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/Olivia"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/Olivia"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/Psk"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(255, 33, 490, 86, gettext("AFC behavior"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter2* o = cntSearchRange = new Fl_Counter2(400, 57, 75, 20, gettext("Acquisition search range (Hz)"));
          cntSearchRange->tooltip(gettext("Capture signals within this frequency range"));
          cntSearchRange->type(1);
          cntSearchRange->box(FL_UP_BOX);
          cntSearchRange->color(FL_BACKGROUND_COLOR);
          cntSearchRange->selection_color(FL_INACTIVE_COLOR);
          cntSearchRange->labeltype(FL_NORMAL_LABEL);
          cntSearchRange->labelfont(0);
          cntSearchRange->labelsize(14);
          cntSearchRange->labelcolor(FL_FOREGROUND_COLOR);
          cntSearchRange->minimum(10);
          cntSearchRange->maximum(500);
          cntSearchRange->step(10);
          cntSearchRange->value(200);
          cntSearchRange->callback((Fl_Callback*)cb_cntSearchRange);
          cntSearchRange->align(Fl_Align(FL_ALIGN_RIGHT));
          cntSearchRange->when(FL_WHEN_CHANGED);
          o->value(progdefaults.SearchRange);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntSearchRange
        { Fl_Counter2* o = cntACQsn = new Fl_Counter2(400, 86, 75, 20, gettext("Acquisition S/N (dB)"));
          cntACQsn->tooltip(gettext("Capture signals over this threshold"));
          cntACQsn->type(1);
          cntACQsn->box(FL_UP_BOX);
          cntACQsn->color(FL_BACKGROUND_COLOR);
          cntACQsn->selection_color(FL_INACTIVE_COLOR);
          cntACQsn->labeltype(FL_NORMAL_LABEL);
          cntACQsn->labelfont(0);
          cntACQsn->labelsize(14);
          cntACQsn->labelcolor(FL_FOREGROUND_COLOR);
          cntACQsn->minimum(3);
          cntACQsn->maximum(20);
          cntACQsn->step(1);
          cntACQsn->value(6);
          cntACQsn->callback((Fl_Callback*)cb_cntACQsn);
          cntACQsn->align(Fl_Align(FL_ALIGN_RIGHT));
          cntACQsn->when(FL_WHEN_CHANGED);
          o->value(progdefaults.ACQsn);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntACQsn
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(255, 121, 490, 65, gettext("S/N and IMD behavior"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = listbox_psk_status_timeout = new Fl_ListBox(380, 152, 80, 20, gettext("after"));
          listbox_psk_status_timeout->tooltip(gettext("Behavior of s/n imd"));
          listbox_psk_status_timeout->box(FL_DOWN_BOX);
          listbox_psk_status_timeout->color(FL_BACKGROUND2_COLOR);
          listbox_psk_status_timeout->selection_color(FL_BACKGROUND_COLOR);
          listbox_psk_status_timeout->labeltype(FL_NORMAL_LABEL);
          listbox_psk_status_timeout->labelfont(0);
          listbox_psk_status_timeout->labelsize(14);
          listbox_psk_status_timeout->labelcolor(FL_FOREGROUND_COLOR);
          listbox_psk_status_timeout->callback((Fl_Callback*)cb_listbox_psk_status_timeout);
          listbox_psk_status_timeout->align(Fl_Align(FL_ALIGN_RIGHT));
          listbox_psk_status_timeout->when(FL_WHEN_RELEASE);
          o->add(_("Clear")); o->add(_("Dim"));
          o->index(progdefaults.StatusDim);
                       o->labelsize(FL_NORMAL_SIZE);
          listbox_psk_status_timeout->end();
        } // Fl_ListBox* listbox_psk_status_timeout
        { Fl_Counter2* o = new Fl_Counter2(521, 152, 75, 20, gettext("seconds"));
          o->tooltip(gettext("Will occur after this time in seconds"));
          o->type(1);
          o->box(FL_UP_BOX);
          o->color(FL_BACKGROUND_COLOR);
          o->selection_color(FL_INACTIVE_COLOR);
          o->labeltype(FL_NORMAL_LABEL);
          o->labelfont(0);
          o->labelsize(14);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->minimum(0);
          o->maximum(30);
          o->step(1);
          o->callback((Fl_Callback*)cb_seconds);
          o->align(Fl_Align(FL_ALIGN_RIGHT));
          o->when(FL_WHEN_CHANGED);
          o->value(progdefaults.StatusTimeout);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(255, 191, 490, 80, gettext("Multi-Channel Signal Processing"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnEnablePSKbrowsing = new Fl_Check_Button(425, 241, 180, 20, gettext("Multi-channel detector"));
          btnEnablePSKbrowsing->down_box(FL_DOWN_BOX);
          btnEnablePSKbrowsing->callback((Fl_Callback*)cb_btnEnablePSKbrowsing);
          o->value(progdefaults.pskbrowser_on);
        } // Fl_Check_Button* btnEnablePSKbrowsing
        { Fl_Box* o = new Fl_Box(265, 218, 440, 20, gettext("Disable on very slow CPUs or if signal browser is not used"));
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(255, 273, 490, 47, gettext("8 psk"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnPSKpilot = new Fl_Check_Button(300, 286, 113, 20, gettext("Pilot tone"));
          btnPSKpilot->tooltip(gettext("Enable encode/decode vestigial pilot tone"));
          btnPSKpilot->down_box(FL_DOWN_BOX);
          btnPSKpilot->callback((Fl_Callback*)cb_btnPSKpilot);
          o->value(progdefaults.pskpilot);
        } // Fl_Check_Button* btnPSKpilot
        { Fl_Counter2* o = cnt_pilot_power = new Fl_Counter2(405, 286, 75, 20, gettext("pilot power (dB)"));
          cnt_pilot_power->tooltip(gettext("Pilot tone power relative to signal"));
          cnt_pilot_power->type(1);
          cnt_pilot_power->box(FL_UP_BOX);
          cnt_pilot_power->color(FL_BACKGROUND_COLOR);
          cnt_pilot_power->selection_color(FL_INACTIVE_COLOR);
          cnt_pilot_power->labeltype(FL_NORMAL_LABEL);
          cnt_pilot_power->labelfont(0);
          cnt_pilot_power->labelsize(14);
          cnt_pilot_power->labelcolor(FL_FOREGROUND_COLOR);
          cnt_pilot_power->minimum(-60);
          cnt_pilot_power->maximum(-20);
          cnt_pilot_power->step(1);
          cnt_pilot_power->value(-30);
          cnt_pilot_power->callback((Fl_Callback*)cb_cnt_pilot_power);
          cnt_pilot_power->align(Fl_Align(FL_ALIGN_RIGHT));
          cnt_pilot_power->when(FL_WHEN_CHANGED);
          o->value(progdefaults.pilot_power);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cnt_pilot_power
        { Fl_Check_Button* o = btnPSK8Preamble = new Fl_Check_Button(610, 286, 113, 20, gettext("Short Preamble"));
          btnPSK8Preamble->tooltip(gettext("Enable short preamble for 8PSK transmission"));
          btnPSK8Preamble->down_box(FL_DOWN_BOX);
          btnPSK8Preamble->callback((Fl_Callback*)cb_btnPSK8Preamble);
          o->value(progStatus.psk8DCDShortFlag);
        } // Fl_Check_Button* btnPSK8Preamble
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/Psk"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/Psk"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/SCAMP"));
      o->box(FL_FLAT_BOX);
      o->hide();
      { Fl_Counter* o = ScampResync = new Fl_Counter(399, 152, 75, 22, gettext("Scamp Resync Frames"));
        ScampResync->tooltip(gettext("Number of Frames to Resync 0 to 9"));
        ScampResync->minimum(0);
        ScampResync->maximum(9);
        ScampResync->step(1);
        ScampResync->callback((Fl_Callback*)cb_ScampResync);
        ScampResync->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value(progdefaults.ScampResync);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Counter* ScampResync
      { Fl_Counter* o = ScampRepeat = new Fl_Counter(399, 203, 75, 22, gettext("Scamp Repeat Frames"));
        ScampRepeat->tooltip(gettext("Number of times to repeat frames 1 to 9"));
        ScampRepeat->minimum(1);
        ScampRepeat->maximum(9);
        ScampRepeat->step(1);
        ScampRepeat->value(1);
        ScampRepeat->callback((Fl_Callback*)cb_ScampRepeat);
        ScampRepeat->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value(progdefaults.ScampRepeat);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Counter* ScampRepeat
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/SCAMP"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/SCAMP"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/TTY/Rx"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(202, 22, 595, 50, gettext("Receive"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = i_listbox_rtty_afc_speed = new Fl_ListBox(296, 43, 90, 22, gettext("AFC speed"));
          i_listbox_rtty_afc_speed->tooltip(gettext("AFC tracking speed"));
          i_listbox_rtty_afc_speed->box(FL_DOWN_BOX);
          i_listbox_rtty_afc_speed->color(FL_BACKGROUND2_COLOR);
          i_listbox_rtty_afc_speed->selection_color(FL_BACKGROUND_COLOR);
          i_listbox_rtty_afc_speed->labeltype(FL_NORMAL_LABEL);
          i_listbox_rtty_afc_speed->labelfont(0);
          i_listbox_rtty_afc_speed->labelsize(14);
          i_listbox_rtty_afc_speed->labelcolor(FL_FOREGROUND_COLOR);
          i_listbox_rtty_afc_speed->callback((Fl_Callback*)cb_i_listbox_rtty_afc_speed);
          i_listbox_rtty_afc_speed->align(Fl_Align(FL_ALIGN_LEFT));
          i_listbox_rtty_afc_speed->when(FL_WHEN_RELEASE);
          o->add("Slow"); o->add("Normal"); o->add("Fast");
          o->index(progdefaults.rtty_afcspeed);
          o->labelsize(FL_NORMAL_SIZE);
          i_listbox_rtty_afc_speed->end();
        } // Fl_ListBox* i_listbox_rtty_afc_speed
        { Fl_Check_Button* o = chkUOSrx = new Fl_Check_Button(400, 45, 63, 18, gettext("RX - unshift on space"));
          chkUOSrx->tooltip(gettext("Revert to unshifted char\'s on a space"));
          chkUOSrx->down_box(FL_DOWN_BOX);
          chkUOSrx->callback((Fl_Callback*)cb_chkUOSrx);
          o->value(progdefaults.UOSrx);
        } // Fl_Check_Button* chkUOSrx
        { Fl_Value_Input* o = rtty_rx_shape = new Fl_Value_Input(745, 42, 48, 25, gettext("Filter Shape Factor"));
          rtty_rx_shape->tooltip(gettext("rcos timing coefficient:\n1.0 ... 2.0\nW1HKJ best 1.275\nDO2SMF best 1.500"));
          rtty_rx_shape->minimum(1);
          rtty_rx_shape->maximum(2);
          rtty_rx_shape->step(0.001);
          rtty_rx_shape->value(1.25);
          rtty_rx_shape->callback((Fl_Callback*)cb_rtty_rx_shape);
          o->value(progdefaults.rtty_filter);
        } // Fl_Value_Input* rtty_rx_shape
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(202, 72, 595, 55, gettext("Decode (CWI suppression)"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnRxTones[0] = new Fl_Check_Button(308, 98, 77, 13, gettext("Mark-Space"));
          btnRxTones[0]->down_box(FL_DOWN_BOX);
          btnRxTones[0]->callback((Fl_Callback*)cb_btnRxTones);
          o->value(progdefaults.rtty_cwi == 0);
        } // Fl_Check_Button* btnRxTones[0]
        { Fl_Check_Button* o = btnRxTones[1] = new Fl_Check_Button(455, 98, 77, 13, gettext("Mark only"));
          btnRxTones[1]->down_box(FL_DOWN_BOX);
          btnRxTones[1]->callback((Fl_Callback*)cb_btnRxTones1);
          o->value(progdefaults.rtty_cwi == 1);
        } // Fl_Check_Button* btnRxTones[1]
        { Fl_Check_Button* o = btnRxTones[2] = new Fl_Check_Button(602, 98, 78, 13, gettext("Space only"));
          btnRxTones[2]->down_box(FL_DOWN_BOX);
          btnRxTones[2]->callback((Fl_Callback*)cb_btnRxTones2);
          o->value(progdefaults.rtty_cwi == 2);
        } // Fl_Check_Button* btnRxTones[2]
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(202, 128, 595, 55, gettext("RTTY Scope Display"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnPreferXhairScope = new Fl_Check_Button(308, 150, 182, 20, gettext("Use cross hair scope"));
          btnPreferXhairScope->tooltip(gettext("Default to cross hair digiscope"));
          btnPreferXhairScope->down_box(FL_DOWN_BOX);
          btnPreferXhairScope->callback((Fl_Callback*)cb_btnPreferXhairScope);
          o->value(progdefaults.PreferXhairScope);
        } // Fl_Check_Button* btnPreferXhairScope
        { Fl_Check_Button* o = chk_true_scope = new Fl_Check_Button(551, 150, 77, 20, gettext("XY - classic scope"));
          chk_true_scope->tooltip(gettext("Enabled - use Mark/Space filter outputs\nDisabled - use pseudo signals"));
          chk_true_scope->down_box(FL_DOWN_BOX);
          chk_true_scope->callback((Fl_Callback*)cb_chk_true_scope);
          o->value(progdefaults.true_scope);
        } // Fl_Check_Button* chk_true_scope
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(202, 184, 595, 54, gettext("Log RTTY frequency"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chk_useMARKfreq = new Fl_Check_Button(308, 208, 161, 17, gettext("Use MARK freq\'"));
          chk_useMARKfreq->tooltip(gettext("Enabled - log QSO using Mark frequency\nDisabled - log QSO using center frequ"
"ency"));
          chk_useMARKfreq->down_box(FL_DOWN_BOX);
          chk_useMARKfreq->value(1);
          chk_useMARKfreq->callback((Fl_Callback*)cb_chk_useMARKfreq);
          o->value(progdefaults.useMARKfreq);
        } // Fl_Check_Button* chk_useMARKfreq
        { Fl_Button* o = btnRTTY_mark_color = new Fl_Button(551, 205, 45, 20, gettext("track color"));
          btnRTTY_mark_color->tooltip(gettext("Color of Mark Track"));
          btnRTTY_mark_color->color((Fl_Color)2);
          btnRTTY_mark_color->callback((Fl_Callback*)cb_btnRTTY_mark_color);
          btnRTTY_mark_color->align(Fl_Align(FL_ALIGN_RIGHT));
          o->color(RGBCOLOR(rttymark));
        } // Fl_Button* btnRTTY_mark_color
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(202, 240, 595, 104, gettext("RTTY Bell"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chk_audibleBELL = new Fl_Check_Button(264, 259, 161, 22, gettext("Audible BELL"));
          chk_audibleBELL->tooltip(gettext("Enabled - log QSO using Mark frequency\nDisabled - log QSO using center frequ"
"ency"));
          chk_audibleBELL->down_box(FL_DOWN_BOX);
          chk_audibleBELL->value(1);
          chk_audibleBELL->callback((Fl_Callback*)cb_chk_audibleBELL);
          o->value(progdefaults.audibleBELL);
        } // Fl_Check_Button* chk_audibleBELL
        { Fl_Check_Button* o = chk_visibleBELL = new Fl_Check_Button(388, 259, 132, 22, gettext("Visible BELL"));
          chk_visibleBELL->tooltip(gettext("Enabled - log QSO using Mark frequency\nDisabled - log QSO using center frequ"
"ency"));
          chk_visibleBELL->down_box(FL_DOWN_BOX);
          chk_visibleBELL->value(1);
          chk_visibleBELL->callback((Fl_Callback*)cb_chk_visibleBELL);
          o->value(progdefaults.visibleBELL);
        } // Fl_Check_Button* chk_visibleBELL
        { Fl_File_Input* o = inp_wav_fname_bell_ring = new Fl_File_Input(223, 301, 301, 35, gettext("RTTY Bell audio wav"));
          inp_wav_fname_bell_ring->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(progdefaults.BELL_RING.c_str());
        } // Fl_File_Input* inp_wav_fname_bell_ring
        { btn_select_bell_ring_wav = new Fl_Button(526, 312, 59, 24, gettext("Select"));
          btn_select_bell_ring_wav->callback((Fl_Callback*)cb_btn_select_bell_ring_wav);
        } // Fl_Button* btn_select_bell_ring_wav
        { Fl_Choice* o = mnu_bell_ring_menu = new Fl_Choice(589, 312, 134, 24, gettext("Sound:"));
          mnu_bell_ring_menu->box(FL_DOWN_BOX);
          mnu_bell_ring_menu->down_box(FL_BORDER_BOX);
          mnu_bell_ring_menu->color((Fl_Color)53);
          mnu_bell_ring_menu->callback((Fl_Callback*)cb_mnu_bell_ring_menu);
          mnu_bell_ring_menu->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("wav file|bark|checkout|diesel|steam_train|doesnot|beeboo|phone|dinner_bell|rtty_bell|standard_tone");
          o->value(progdefaults.BELL_RING_MENU);
        } // Fl_Choice* mnu_bell_ring_menu
        { btn_test_bell_ring_wav = new Fl_Button(728, 312, 59, 24, gettext("Test"));
          btn_test_bell_ring_wav->callback((Fl_Callback*)cb_btn_test_bell_ring_wav);
        } // Fl_Button* btn_test_bell_ring_wav
        { Fl_Check_Button* o = chk_ITA2 = new Fl_Check_Button(538, 259, 132, 22, gettext("ITA-2 encode"));
          chk_ITA2->tooltip(gettext("Baudot bell and single quote reversal"));
          chk_ITA2->down_box(FL_DOWN_BOX);
          chk_ITA2->callback((Fl_Callback*)cb_chk_ITA2);
          o->value(progdefaults.ITA2);
        } // Fl_Check_Button* chk_ITA2
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/TTY/Rx"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/TTY/Rx"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/TTY/Tx"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 21, 590, 200, gettext("Sound Card FSK"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = selShift = new Fl_ListBox(281, 43, 100, 22, gettext("Carrier shift"));
          selShift->tooltip(gettext("Select carrier shift"));
          selShift->box(FL_DOWN_BOX);
          selShift->color(FL_BACKGROUND2_COLOR);
          selShift->selection_color(FL_BACKGROUND_COLOR);
          selShift->labeltype(FL_NORMAL_LABEL);
          selShift->labelfont(0);
          selShift->labelsize(14);
          selShift->labelcolor(FL_FOREGROUND_COLOR);
          selShift->callback((Fl_Callback*)cb_selShift);
          selShift->align(Fl_Align(FL_ALIGN_RIGHT));
          selShift->when(FL_WHEN_CHANGED);
          o->add(szShifts);o->index(progdefaults.rtty_shift);
                       o->labelsize(FL_NORMAL_SIZE);
          selShift->end();
        } // Fl_ListBox* selShift
        { Fl_Counter2* o = selCustomShift = new Fl_Counter2(281, 73, 100, 22, gettext("Custom shift"));
          selCustomShift->tooltip(gettext("Input carrier shift"));
          selCustomShift->box(FL_UP_BOX);
          selCustomShift->color(FL_BACKGROUND_COLOR);
          selCustomShift->selection_color(FL_INACTIVE_COLOR);
          selCustomShift->labeltype(FL_NORMAL_LABEL);
          selCustomShift->labelfont(0);
          selCustomShift->labelsize(14);
          selCustomShift->labelcolor(FL_FOREGROUND_COLOR);
          selCustomShift->minimum(10);
          selCustomShift->maximum(1200);
          selCustomShift->step(10);
          selCustomShift->value(450);
          selCustomShift->callback((Fl_Callback*)cb_selCustomShift);
          selCustomShift->align(Fl_Align(FL_ALIGN_RIGHT));
          selCustomShift->when(FL_WHEN_CHANGED);
          o->lstep(100.0);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* selCustomShift
        { Fl_ListBox* o = selBaud = new Fl_ListBox(281, 103, 100, 22, gettext("Baud rate"));
          selBaud->tooltip(gettext("Select carrier baudrate"));
          selBaud->box(FL_DOWN_BOX);
          selBaud->color(FL_BACKGROUND2_COLOR);
          selBaud->selection_color(FL_BACKGROUND_COLOR);
          selBaud->labeltype(FL_NORMAL_LABEL);
          selBaud->labelfont(0);
          selBaud->labelsize(14);
          selBaud->labelcolor(FL_FOREGROUND_COLOR);
          selBaud->callback((Fl_Callback*)cb_selBaud);
          selBaud->align(Fl_Align(FL_ALIGN_RIGHT));
          selBaud->when(FL_WHEN_CHANGED);
          o->add(szBauds);
          o->index(progdefaults.rtty_baud);
          o->labelsize(FL_NORMAL_SIZE);
          selBaud->end();
        } // Fl_ListBox* selBaud
        { Fl_ListBox* o = selBits = new Fl_ListBox(281, 133, 100, 22, gettext("Bits per character"));
          selBits->tooltip(gettext("Select # bits / char"));
          selBits->box(FL_DOWN_BOX);
          selBits->color(FL_BACKGROUND2_COLOR);
          selBits->selection_color(FL_BACKGROUND_COLOR);
          selBits->labeltype(FL_NORMAL_LABEL);
          selBits->labelfont(0);
          selBits->labelsize(14);
          selBits->labelcolor(FL_FOREGROUND_COLOR);
          selBits->callback((Fl_Callback*)cb_selBits);
          selBits->align(Fl_Align(FL_ALIGN_RIGHT));
          selBits->when(FL_WHEN_CHANGED);
          o->add(szSelBits);o->index(progdefaults.rtty_bits);
                       o->labelsize(FL_NORMAL_SIZE);
          selBits->end();
        } // Fl_ListBox* selBits
        { Fl_ListBox* o = selParity = new Fl_ListBox(281, 163, 100, 22, gettext("Parity"));
          selParity->tooltip(gettext("Select parity"));
          selParity->box(FL_DOWN_BOX);
          selParity->color(FL_BACKGROUND2_COLOR);
          selParity->selection_color(FL_BACKGROUND_COLOR);
          selParity->labeltype(FL_NORMAL_LABEL);
          selParity->labelfont(0);
          selParity->labelsize(14);
          selParity->labelcolor(FL_FOREGROUND_COLOR);
          selParity->callback((Fl_Callback*)cb_selParity);
          selParity->align(Fl_Align(FL_ALIGN_RIGHT));
          selParity->when(FL_WHEN_CHANGED);
          o->add(szParity);o->index(progdefaults.rtty_parity);
                       o->labelsize(FL_NORMAL_SIZE);
          selParity->end();
        } // Fl_ListBox* selParity
        { Fl_ListBox* o = selStopBits = new Fl_ListBox(281, 193, 100, 22, gettext("Stop bits"));
          selStopBits->tooltip(gettext("Select # stop bits"));
          selStopBits->box(FL_DOWN_BOX);
          selStopBits->color(FL_BACKGROUND2_COLOR);
          selStopBits->selection_color(FL_BACKGROUND_COLOR);
          selStopBits->labeltype(FL_NORMAL_LABEL);
          selStopBits->labelfont(0);
          selStopBits->labelsize(14);
          selStopBits->labelcolor(FL_FOREGROUND_COLOR);
          selStopBits->callback((Fl_Callback*)cb_selStopBits);
          selStopBits->align(Fl_Align(FL_ALIGN_RIGHT));
          selStopBits->when(FL_WHEN_CHANGED);
          o->add(szStopBits);o->index(progdefaults.rtty_stop);
                       o->labelsize(FL_NORMAL_SIZE);
          selStopBits->end();
        } // Fl_ListBox* selStopBits
        { Fl_Check_Button* o = btnAUTOCRLF = new Fl_Check_Button(532, 43, 90, 22, gettext("AutoCRLF"));
          btnAUTOCRLF->tooltip(gettext("Add CRLF after page width characters"));
          btnAUTOCRLF->down_box(FL_DOWN_BOX);
          btnAUTOCRLF->callback((Fl_Callback*)cb_btnAUTOCRLF);
          o->value(progdefaults.rtty_autocrlf);
        } // Fl_Check_Button* btnAUTOCRLF
        { Fl_Counter2* o = cntrAUTOCRLF = new Fl_Counter2(643, 43, 75, 22, gettext("chars"));
          cntrAUTOCRLF->tooltip(gettext("Auto CRLF line length"));
          cntrAUTOCRLF->type(1);
          cntrAUTOCRLF->box(FL_UP_BOX);
          cntrAUTOCRLF->color(FL_BACKGROUND_COLOR);
          cntrAUTOCRLF->selection_color(FL_INACTIVE_COLOR);
          cntrAUTOCRLF->labeltype(FL_NORMAL_LABEL);
          cntrAUTOCRLF->labelfont(0);
          cntrAUTOCRLF->labelsize(14);
          cntrAUTOCRLF->labelcolor(FL_FOREGROUND_COLOR);
          cntrAUTOCRLF->minimum(68);
          cntrAUTOCRLF->maximum(80);
          cntrAUTOCRLF->step(1);
          cntrAUTOCRLF->value(72);
          cntrAUTOCRLF->callback((Fl_Callback*)cb_cntrAUTOCRLF);
          cntrAUTOCRLF->align(Fl_Align(FL_ALIGN_RIGHT));
          cntrAUTOCRLF->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntrAUTOCRLF
        { Fl_Check_Button* o = btnCRCRLF = new Fl_Check_Button(532, 73, 90, 22, gettext("CR-CR-LF"));
          btnCRCRLF->tooltip(gettext("Use \"cr cr lf\" for \"cr lf\""));
          btnCRCRLF->down_box(FL_DOWN_BOX);
          btnCRCRLF->callback((Fl_Callback*)cb_btnCRCRLF);
          btnCRCRLF->when(FL_WHEN_RELEASE_ALWAYS);
          o->value(progdefaults.rtty_crcrlf);
        } // Fl_Check_Button* btnCRCRLF
        { Fl_Check_Button* o = chkUOStx = new Fl_Check_Button(532, 103, 63, 22, gettext("TX - unshift on space"));
          chkUOStx->tooltip(gettext("Revert to Unsifted char\'s on a space"));
          chkUOStx->down_box(FL_DOWN_BOX);
          chkUOStx->callback((Fl_Callback*)cb_chkUOStx);
          o->value(progdefaults.UOStx);
        } // Fl_Check_Button* chkUOStx
        { Fl_Check_Button* o = chk_shaped_rtty = new Fl_Check_Button(532, 133, 212, 22, gettext("Shaped Tx"));
          chk_shaped_rtty->tooltip(gettext("Use wave shaping on Tx signal"));
          chk_shaped_rtty->down_box(FL_DOWN_BOX);
          chk_shaped_rtty->value(1);
          chk_shaped_rtty->callback((Fl_Callback*)cb_chk_shaped_rtty);
          o->value(progStatus.shaped_rtty);
        } // Fl_Check_Button* chk_shaped_rtty
        { Fl_Check_Button* o = chkPseudoFSK = new Fl_Check_Button(532, 163, 212, 22, gettext("Pseudo-FSK - right channel"));
          chkPseudoFSK->tooltip(gettext("Create keyed square wave on right audio channel"));
          chkPseudoFSK->down_box(FL_DOWN_BOX);
          chkPseudoFSK->callback((Fl_Callback*)cb_chkPseudoFSK);
          o->value(progdefaults.PseudoFSK);
        } // Fl_Check_Button* chkPseudoFSK
        { Fl_Counter* o = cnt_TTY_LTRS = new Fl_Counter(532, 193, 75, 22, gettext("LTRS at start"));
          cnt_TTY_LTRS->tooltip(gettext("Insert NN LTRS bytes at start of each transmission"));
          cnt_TTY_LTRS->type(1);
          cnt_TTY_LTRS->minimum(0);
          cnt_TTY_LTRS->maximum(10);
          cnt_TTY_LTRS->step(1);
          cnt_TTY_LTRS->value(1);
          cnt_TTY_LTRS->callback((Fl_Callback*)cb_cnt_TTY_LTRS);
          cnt_TTY_LTRS->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.TTY_LTRS);
        } // Fl_Counter* cnt_TTY_LTRS
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/TTY/Tx"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/TTY/Tx"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/TTY/FSK"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 21, 590, 165, gettext("DTR/RTS signal line FSK"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnFSKenabled = new Fl_Check_Button(224, 56, 90, 22, gettext("Enabled"));
          btnFSKenabled->tooltip(gettext("Enable FSK on serial port"));
          btnFSKenabled->down_box(FL_DOWN_BOX);
          btnFSKenabled->callback((Fl_Callback*)cb_btnFSKenabled);
          btnFSKenabled->when(FL_WHEN_RELEASE_ALWAYS);
          o->value(progdefaults.useFSK);
        } // Fl_Check_Button* btnFSKenabled
        { Fl_Check_Button* o = btnFSKshared = new Fl_Check_Button(333, 56, 90, 22, gettext("Shares RIGIO serial port, or uses"));
          btnFSKshared->tooltip(gettext("Share the RIGIO port"));
          btnFSKshared->down_box(FL_DOWN_BOX);
          btnFSKshared->callback((Fl_Callback*)cb_btnFSKshared);
          btnFSKshared->when(FL_WHEN_RELEASE_ALWAYS);
          o->value(progdefaults.fsk_shares_port);
        } // Fl_Check_Button* btnFSKshared
        { Fl_ComboBox* o = select_FSK_CommPort = new Fl_ComboBox(314, 88, 470, 24, gettext("Serial Port"));
          select_FSK_CommPort->tooltip(gettext("FSK independent serial port"));
          select_FSK_CommPort->box(FL_DOWN_BOX);
          select_FSK_CommPort->color((Fl_Color)55);
          select_FSK_CommPort->selection_color(FL_BACKGROUND_COLOR);
          select_FSK_CommPort->labeltype(FL_NORMAL_LABEL);
          select_FSK_CommPort->labelfont(0);
          select_FSK_CommPort->labelsize(14);
          select_FSK_CommPort->labelcolor(FL_FOREGROUND_COLOR);
          select_FSK_CommPort->callback((Fl_Callback*)cb_select_FSK_CommPort);
          select_FSK_CommPort->align(Fl_Align(FL_ALIGN_LEFT));
          select_FSK_CommPort->when(FL_WHEN_RELEASE);
          o->value(progdefaults.fsk_port.c_str());
          select_FSK_CommPort->end();
        } // Fl_ComboBox* select_FSK_CommPort
        { Fl_Check_Button* o = btnFSKreverse = new Fl_Check_Button(225, 120, 90, 22, gettext("MARK/SPACE reversed"));
          btnFSKreverse->tooltip(gettext("Reverse Mark/Space"));
          btnFSKreverse->down_box(FL_DOWN_BOX);
          btnFSKreverse->callback((Fl_Callback*)cb_btnFSKreverse);
          btnFSKreverse->when(FL_WHEN_RELEASE_ALWAYS);
          o->value(progdefaults.fsk_reverse);
        } // Fl_Check_Button* btnFSKreverse
        { Fl_Check_Button* o = btnFSKuseDTR = new Fl_Check_Button(460, 120, 90, 22, gettext("Use DTR"));
          btnFSKuseDTR->tooltip(gettext("Enable DTR signal line, default is RTS"));
          btnFSKuseDTR->down_box(FL_DOWN_BOX);
          btnFSKuseDTR->callback((Fl_Callback*)cb_btnFSKuseDTR);
          btnFSKuseDTR->when(FL_WHEN_RELEASE_ALWAYS);
          o->value(progdefaults.fsk_on_dtr);
        } // Fl_Check_Button* btnFSKuseDTR
        { btnFSKreset = new Fl_Button(714, 152, 70, 24, gettext("Reset"));
          btnFSKreset->tooltip(gettext("Restart the FSK interface\nNecessary if changes made to configuration"));
          btnFSKreset->callback((Fl_Callback*)cb_btnFSKreset);
          btnFSKreset->hide();
        } // Fl_Button* btnFSKreset
        { Fl_Counter* o = cntr_xcvr_FSK_MARK = new Fl_Counter(225, 152, 126, 24, gettext("Mark"));
          cntr_xcvr_FSK_MARK->tooltip(gettext("Mark frequency in Hertz"));
          cntr_xcvr_FSK_MARK->minimum(500);
          cntr_xcvr_FSK_MARK->maximum(3000);
          cntr_xcvr_FSK_MARK->step(1);
          cntr_xcvr_FSK_MARK->value(1275);
          cntr_xcvr_FSK_MARK->callback((Fl_Callback*)cb_cntr_xcvr_FSK_MARK);
          cntr_xcvr_FSK_MARK->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.xcvr_FSK_MARK);
          o->lstep(10);
        } // Fl_Counter* cntr_xcvr_FSK_MARK
        { Fl_ListBox* o = sel_xcvr_FSK_shift = new Fl_ListBox(460, 152, 100, 24, gettext("Carrier shift"));
          sel_xcvr_FSK_shift->tooltip(gettext("Carrier shift in Hertz"));
          sel_xcvr_FSK_shift->box(FL_DOWN_BOX);
          sel_xcvr_FSK_shift->color(FL_BACKGROUND2_COLOR);
          sel_xcvr_FSK_shift->selection_color(FL_BACKGROUND_COLOR);
          sel_xcvr_FSK_shift->labeltype(FL_NORMAL_LABEL);
          sel_xcvr_FSK_shift->labelfont(0);
          sel_xcvr_FSK_shift->labelsize(14);
          sel_xcvr_FSK_shift->labelcolor(FL_FOREGROUND_COLOR);
          sel_xcvr_FSK_shift->callback((Fl_Callback*)cb_sel_xcvr_FSK_shift);
          sel_xcvr_FSK_shift->align(Fl_Align(FL_ALIGN_RIGHT));
          sel_xcvr_FSK_shift->when(FL_WHEN_CHANGED);
          o->add(szShifts);
          o->index(progdefaults.rtty_shift);
          sel_xcvr_FSK_shift->end();
        } // Fl_ListBox* sel_xcvr_FSK_shift
        { Fl_Check_Button* o = btnFSK_STOPBITS = new Fl_Check_Button(640, 120, 111, 22, gettext("1.5 stop bits"));
          btnFSK_STOPBITS->tooltip(gettext("Enabled - 1.5 stop bits\nDisabled - 2 stop bits"));
          btnFSK_STOPBITS->down_box(FL_DOWN_BOX);
          btnFSK_STOPBITS->callback((Fl_Callback*)cb_btnFSK_STOPBITS);
          btnFSK_STOPBITS->when(FL_WHEN_RELEASE_ALWAYS);
          o->value(progdefaults.fsk_STOPBITS);
        } // Fl_Check_Button* btnFSK_STOPBITS
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 193, 590, 39);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btn_FSK_KEYLINE_flrig = new Fl_Check_Button(225, 205, 23, 15, gettext("Use flrig FSK keying"));
          btn_FSK_KEYLINE_flrig->tooltip(gettext("Enable to use flrig FSK keyer"));
          btn_FSK_KEYLINE_flrig->down_box(FL_DOWN_BOX);
          btn_FSK_KEYLINE_flrig->callback((Fl_Callback*)cb_btn_FSK_KEYLINE_flrig);
          btn_FSK_KEYLINE_flrig->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.use_FLRIG_FSK);
        } // Fl_Check_Button* btn_FSK_KEYLINE_flrig
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/TTY/FSK"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/TTY/FSK"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/TTY/nanoIO"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_ComboBox* o = select_nanoIO_CommPort = new Fl_ComboBox(290, 23, 420, 25, gettext("Ser. Port"));
        select_nanoIO_CommPort->tooltip(gettext("nanoIO serial port"));
        select_nanoIO_CommPort->box(FL_DOWN_BOX);
        select_nanoIO_CommPort->color((Fl_Color)55);
        select_nanoIO_CommPort->selection_color(FL_BACKGROUND_COLOR);
        select_nanoIO_CommPort->labeltype(FL_NORMAL_LABEL);
        select_nanoIO_CommPort->labelfont(0);
        select_nanoIO_CommPort->labelsize(14);
        select_nanoIO_CommPort->labelcolor(FL_FOREGROUND_COLOR);
        select_nanoIO_CommPort->callback((Fl_Callback*)cb_select_nanoIO_CommPort);
        select_nanoIO_CommPort->align(Fl_Align(FL_ALIGN_LEFT));
        select_nanoIO_CommPort->when(FL_WHEN_RELEASE);
        o->value(progdefaults.nanoIO_serial_port_name.c_str());
        select_nanoIO_CommPort->end();
      } // Fl_ComboBox* select_nanoIO_CommPort
      { btn_nanoIO_connect = new Fl_Light_Button(715, 23, 80, 25, gettext("Connect"));
        btn_nanoIO_connect->tooltip(gettext("Connect / Disconnect from nanoIO"));
        btn_nanoIO_connect->callback((Fl_Callback*)cb_btn_nanoIO_connect);
      } // Fl_Light_Button* btn_nanoIO_connect
      { Fl_ListBox* o = listbox_nanoIO_serbaud2 = new Fl_ListBox(293, 57, 92, 24, gettext("Serial Baud"));
        listbox_nanoIO_serbaud2->box(FL_DOWN_BOX);
        listbox_nanoIO_serbaud2->color(FL_BACKGROUND2_COLOR);
        listbox_nanoIO_serbaud2->selection_color(FL_BACKGROUND_COLOR);
        listbox_nanoIO_serbaud2->labeltype(FL_NORMAL_LABEL);
        listbox_nanoIO_serbaud2->labelfont(0);
        listbox_nanoIO_serbaud2->labelsize(14);
        listbox_nanoIO_serbaud2->labelcolor(FL_FOREGROUND_COLOR);
        listbox_nanoIO_serbaud2->callback((Fl_Callback*)cb_listbox_nanoIO_serbaud2);
        listbox_nanoIO_serbaud2->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_nanoIO_serbaud2->when(FL_WHEN_RELEASE);
        o->add("1200|4800|9600|19200|38400|57600|115200");
        o->index(progdefaults.nanoIO_serbaud);
        listbox_nanoIO_serbaud2->end();
      } // Fl_ListBox* listbox_nanoIO_serbaud2
      { FTextView* o = txt_nano_io = new FTextView(202, 126, 596, 220, gettext("USB serial I/O"));
        txt_nano_io->box(FL_DOWN_FRAME);
        txt_nano_io->color(FL_BACKGROUND2_COLOR);
        txt_nano_io->selection_color(FL_SELECTION_COLOR);
        txt_nano_io->labeltype(FL_NORMAL_LABEL);
        txt_nano_io->labelfont(0);
        txt_nano_io->labelsize(14);
        txt_nano_io->labelcolor(FL_FOREGROUND_COLOR);
        txt_nano_io->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        txt_nano_io->when(FL_WHEN_RELEASE);
        o->setFont(progdefaults.RxFontnbr);
        o->setFontSize(12);
      } // FTextView* txt_nano_io
      { btn_nanofsk_save = new Fl_Button(715, 90, 80, 25, gettext("Save"));
        btn_nanofsk_save->tooltip(gettext("Write state of nanoIO to Arduino EEPROM"));
        btn_nanofsk_save->callback((Fl_Callback*)cb_btn_nanofsk_save);
      } // Fl_Button* btn_nanofsk_save
      { btn_nanofsk_query = new Fl_Button(630, 57, 80, 25, gettext("Status"));
        btn_nanofsk_query->tooltip(gettext("Query state of nanoIO"));
        btn_nanofsk_query->callback((Fl_Callback*)cb_btn_nanofsk_query);
      } // Fl_Button* btn_nanofsk_query
      { Fl_Check_Button* o = chk_nanoIO_polarity = new Fl_Check_Button(323, 90, 53, 24, gettext("MARK polarity"));
        chk_nanoIO_polarity->tooltip(gettext("Set - mark logical HIGH\nRead from nanoIO"));
        chk_nanoIO_polarity->down_box(FL_DOWN_BOX);
        chk_nanoIO_polarity->callback((Fl_Callback*)cb_chk_nanoIO_polarity);
        o->value(progdefaults.nanoIO_polarity);
      } // Fl_Check_Button* chk_nanoIO_polarity
      { Fl_ListBox* o = sel_nanoIO_baud = new Fl_ListBox(447, 90, 84, 25, gettext("TTY Baud"));
        sel_nanoIO_baud->tooltip(gettext("nanoIO - TTY baud"));
        sel_nanoIO_baud->box(FL_DOWN_BOX);
        sel_nanoIO_baud->color(FL_BACKGROUND2_COLOR);
        sel_nanoIO_baud->selection_color(FL_BACKGROUND_COLOR);
        sel_nanoIO_baud->labeltype(FL_NORMAL_LABEL);
        sel_nanoIO_baud->labelfont(0);
        sel_nanoIO_baud->labelsize(14);
        sel_nanoIO_baud->labelcolor(FL_FOREGROUND_COLOR);
        sel_nanoIO_baud->callback((Fl_Callback*)cb_sel_nanoIO_baud);
        sel_nanoIO_baud->align(Fl_Align(FL_ALIGN_RIGHT));
        sel_nanoIO_baud->when(FL_WHEN_CHANGED);
        o->add("45.45|50.0|75.0|100.0");
        o->index(progdefaults.nanoIO_baud);
        o->labelsize(FL_NORMAL_SIZE);
        sel_nanoIO_baud->end();
      } // Fl_ListBox* sel_nanoIO_baud
      { grp_nanoio_debug = new Fl_Group(202, 126, 596, 220, gettext("Debug Output"));
        grp_nanoio_debug->box(FL_ENGRAVED_FRAME);
        grp_nanoio_debug->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        grp_nanoio_debug->hide();
        { brws_nanoio_sent = new Fl_Browser(202, 126, 298, 190);
          brws_nanoio_sent->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
        } // Fl_Browser* brws_nanoio_sent
        { brws_nanoio_rcvd = new Fl_Browser(500, 126, 298, 190);
          brws_nanoio_rcvd->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
        } // Fl_Browser* brws_nanoio_rcvd
        { btn_nanoio_clear_sent = new Fl_Button(309, 319, 85, 20, gettext("Clear Sent"));
          btn_nanoio_clear_sent->callback((Fl_Callback*)cb_btn_nanoio_clear_sent);
        } // Fl_Button* btn_nanoio_clear_sent
        { btn_nanoio_clear_both = new Fl_Button(457, 319, 85, 20, gettext("Clear Both"));
          btn_nanoio_clear_both->callback((Fl_Callback*)cb_btn_nanoio_clear_both);
        } // Fl_Button* btn_nanoio_clear_both
        { btn_nanoio_clear_rcvd = new Fl_Button(605, 319, 85, 20, gettext("Clear Rcvd"));
          btn_nanoio_clear_rcvd->callback((Fl_Callback*)cb_btn_nanoio_clear_rcvd);
        } // Fl_Button* btn_nanoio_clear_rcvd
        grp_nanoio_debug->end();
        Fl_Group::current()->resizable(grp_nanoio_debug);
      } // Fl_Group* grp_nanoio_debug
      { btn_nanoio_debug = new Fl_Light_Button(630, 90, 80, 25, gettext("Debug"));
        btn_nanoio_debug->callback((Fl_Callback*)cb_btn_nanoio_debug);
      } // Fl_Light_Button* btn_nanoio_debug
      { chk_nanoIO_FSK_io = new Fl_Check_Button(715, 57, 70, 24, gettext("TTY i/o"));
        chk_nanoIO_FSK_io->tooltip(gettext("Enable TTY operation"));
        chk_nanoIO_FSK_io->down_box(FL_DOWN_BOX);
        chk_nanoIO_FSK_io->callback((Fl_Callback*)cb_chk_nanoIO_FSK_io);
      } // Fl_Check_Button* chk_nanoIO_FSK_io
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/TTY/nanoIO"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/TTY/nanoIO"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/TTY/Navigator"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(206, 36, 591, 70, gettext("FSK Interface"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ComboBox* o = select_USN_FSK_port = new Fl_ComboBox(249, 65, 455, 23, gettext("Port"));
          select_USN_FSK_port->tooltip(gettext("Navigator serial port"));
          select_USN_FSK_port->box(FL_DOWN_BOX);
          select_USN_FSK_port->color((Fl_Color)55);
          select_USN_FSK_port->selection_color(FL_BACKGROUND_COLOR);
          select_USN_FSK_port->labeltype(FL_NORMAL_LABEL);
          select_USN_FSK_port->labelfont(0);
          select_USN_FSK_port->labelsize(14);
          select_USN_FSK_port->labelcolor(FL_FOREGROUND_COLOR);
          select_USN_FSK_port->callback((Fl_Callback*)cb_select_USN_FSK_port);
          select_USN_FSK_port->align(Fl_Align(FL_ALIGN_LEFT));
          select_USN_FSK_port->when(FL_WHEN_RELEASE);
          o->value(progdefaults.Nav_FSK_port.c_str());
          select_USN_FSK_port->end();
        } // Fl_ComboBox* select_USN_FSK_port
        { btn_Nav_connect = new Fl_Light_Button(711, 65, 80, 23, gettext("FSK"));
          btn_Nav_connect->tooltip(gettext("Connect / Disconnect from Nav FSK port"));
          btn_Nav_connect->callback((Fl_Callback*)cb_btn_Nav_connect);
        } // Fl_Light_Button* btn_Nav_connect
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(206, 107, 591, 239, gettext("Configuration Interface"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ComboBox* o = select_Nav_config_port = new Fl_ComboBox(250, 137, 455, 23, gettext("Port"));
          select_Nav_config_port->tooltip(gettext("Navigator configuration port"));
          select_Nav_config_port->box(FL_DOWN_BOX);
          select_Nav_config_port->color((Fl_Color)55);
          select_Nav_config_port->selection_color(FL_BACKGROUND_COLOR);
          select_Nav_config_port->labeltype(FL_NORMAL_LABEL);
          select_Nav_config_port->labelfont(0);
          select_Nav_config_port->labelsize(14);
          select_Nav_config_port->labelcolor(FL_FOREGROUND_COLOR);
          select_Nav_config_port->callback((Fl_Callback*)cb_select_Nav_config_port);
          select_Nav_config_port->align(Fl_Align(FL_ALIGN_LEFT));
          select_Nav_config_port->when(FL_WHEN_RELEASE);
          o->value(progdefaults.Nav_config_port.c_str());
          select_Nav_config_port->end();
        } // Fl_ComboBox* select_Nav_config_port
        { Fl_ListBox* o = sel_Nav_ch1 = new Fl_ListBox(378, 164, 80, 23, gettext("Channel 1 Attenuator"));
          sel_Nav_ch1->tooltip(gettext("Nav Channel 1 attenuator"));
          sel_Nav_ch1->box(FL_DOWN_BOX);
          sel_Nav_ch1->color(FL_BACKGROUND2_COLOR);
          sel_Nav_ch1->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_ch1->labeltype(FL_NORMAL_LABEL);
          sel_Nav_ch1->labelfont(0);
          sel_Nav_ch1->labelsize(14);
          sel_Nav_ch1->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_ch1->callback((Fl_Callback*)cb_sel_Nav_ch1);
          sel_Nav_ch1->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_ch1->when(FL_WHEN_CHANGED);
          o->add("15 db|Normal");
          o->index(progdefaults.Nav_channel_1_att);
          sel_Nav_ch1->end();
        } // Fl_ListBox* sel_Nav_ch1
        { Fl_ListBox* o = sel_Nav_ch2 = new Fl_ListBox(378, 193, 80, 23, gettext("Channel 2 attenuator"));
          sel_Nav_ch2->tooltip(gettext("NavChannel 2 Attenuator"));
          sel_Nav_ch2->box(FL_DOWN_BOX);
          sel_Nav_ch2->color(FL_BACKGROUND2_COLOR);
          sel_Nav_ch2->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_ch2->labeltype(FL_NORMAL_LABEL);
          sel_Nav_ch2->labelfont(0);
          sel_Nav_ch2->labelsize(14);
          sel_Nav_ch2->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_ch2->callback((Fl_Callback*)cb_sel_Nav_ch2);
          sel_Nav_ch2->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_ch2->when(FL_WHEN_CHANGED);
          o->add("15 db|Normal");
          o->index(progdefaults.Nav_channel_2_att);
          sel_Nav_ch2->end();
        } // Fl_ListBox* sel_Nav_ch2
        { Fl_ListBox* o = sel_Nav_rf_att = new Fl_ListBox(378, 223, 80, 23, gettext("RF attenuator"));
          sel_Nav_rf_att->tooltip(gettext("NavRF Attenuator"));
          sel_Nav_rf_att->box(FL_DOWN_BOX);
          sel_Nav_rf_att->color(FL_BACKGROUND2_COLOR);
          sel_Nav_rf_att->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_rf_att->labeltype(FL_NORMAL_LABEL);
          sel_Nav_rf_att->labelfont(0);
          sel_Nav_rf_att->labelsize(14);
          sel_Nav_rf_att->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_rf_att->callback((Fl_Callback*)cb_sel_Nav_rf_att);
          sel_Nav_rf_att->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_rf_att->when(FL_WHEN_CHANGED);
          o->add("20 db|Normal");
          o->index(progdefaults.Nav_rf_att);
          sel_Nav_rf_att->end();
        } // Fl_ListBox* sel_Nav_rf_att
        { Fl_ListBox* o = sel_Nav_wk_ptt = new Fl_ListBox(378, 253, 80, 23, gettext("WinKey PTT"));
          sel_Nav_wk_ptt->tooltip(gettext("NavWinkey PTT"));
          sel_Nav_wk_ptt->box(FL_DOWN_BOX);
          sel_Nav_wk_ptt->color(FL_BACKGROUND2_COLOR);
          sel_Nav_wk_ptt->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_wk_ptt->labeltype(FL_NORMAL_LABEL);
          sel_Nav_wk_ptt->labelfont(0);
          sel_Nav_wk_ptt->labelsize(14);
          sel_Nav_wk_ptt->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_wk_ptt->callback((Fl_Callback*)cb_sel_Nav_wk_ptt);
          sel_Nav_wk_ptt->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_wk_ptt->when(FL_WHEN_CHANGED);
          o->index(progdefaults.Nav_wk_ptt);
          o->add("On|Off");
          sel_Nav_wk_ptt->end();
        } // Fl_ListBox* sel_Nav_wk_ptt
        { Fl_ListBox* o = sel_Nav_LED = new Fl_ListBox(378, 283, 80, 23, gettext("LED brightness"));
          sel_Nav_LED->tooltip(gettext("NavLED brightness"));
          sel_Nav_LED->box(FL_DOWN_BOX);
          sel_Nav_LED->color(FL_BACKGROUND2_COLOR);
          sel_Nav_LED->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_LED->labeltype(FL_NORMAL_LABEL);
          sel_Nav_LED->labelfont(0);
          sel_Nav_LED->labelsize(14);
          sel_Nav_LED->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_LED->callback((Fl_Callback*)cb_sel_Nav_LED);
          sel_Nav_LED->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_LED->when(FL_WHEN_CHANGED);
          o->index(progdefaults.Nav_led);
          o->add("Dim|Normal");
          sel_Nav_LED->end();
        } // Fl_ListBox* sel_Nav_LED
        { Fl_ListBox* o = sel_Nav_CAT_LED = new Fl_ListBox(378, 313, 80, 23, gettext("CAT LED state"));
          sel_Nav_CAT_LED->tooltip(gettext("NavCAT state LED"));
          sel_Nav_CAT_LED->box(FL_DOWN_BOX);
          sel_Nav_CAT_LED->color(FL_BACKGROUND2_COLOR);
          sel_Nav_CAT_LED->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_CAT_LED->labeltype(FL_NORMAL_LABEL);
          sel_Nav_CAT_LED->labelfont(0);
          sel_Nav_CAT_LED->labelsize(14);
          sel_Nav_CAT_LED->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_CAT_LED->callback((Fl_Callback*)cb_sel_Nav_CAT_LED);
          sel_Nav_CAT_LED->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_CAT_LED->when(FL_WHEN_CHANGED);
          o->index(progdefaults.Nav_cat_led);
          o->add("Steady|Polling");
          sel_Nav_CAT_LED->end();
        } // Fl_ListBox* sel_Nav_CAT_LED
        { Fl_ListBox* o = sel_Nav_FSK_baud = new Fl_ListBox(586, 164, 80, 23, gettext("Baud rate"));
          sel_Nav_FSK_baud->tooltip(gettext("Nav FSK baud rate"));
          sel_Nav_FSK_baud->box(FL_DOWN_BOX);
          sel_Nav_FSK_baud->color(FL_BACKGROUND2_COLOR);
          sel_Nav_FSK_baud->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_FSK_baud->labeltype(FL_NORMAL_LABEL);
          sel_Nav_FSK_baud->labelfont(0);
          sel_Nav_FSK_baud->labelsize(14);
          sel_Nav_FSK_baud->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_FSK_baud->callback((Fl_Callback*)cb_sel_Nav_FSK_baud);
          sel_Nav_FSK_baud->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_FSK_baud->when(FL_WHEN_CHANGED);
          o->add("45.45|75|100");
          o->index(progdefaults.Nav_FSK_baud);
          sel_Nav_FSK_baud->end();
        } // Fl_ListBox* sel_Nav_FSK_baud
        { Fl_ListBox* o = sel_Nav_FSK_stopbits = new Fl_ListBox(585, 193, 80, 23, gettext("Stop bits"));
          sel_Nav_FSK_stopbits->tooltip(gettext("Nav FSK Stop bits"));
          sel_Nav_FSK_stopbits->box(FL_DOWN_BOX);
          sel_Nav_FSK_stopbits->color(FL_BACKGROUND2_COLOR);
          sel_Nav_FSK_stopbits->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_FSK_stopbits->labeltype(FL_NORMAL_LABEL);
          sel_Nav_FSK_stopbits->labelfont(0);
          sel_Nav_FSK_stopbits->labelsize(14);
          sel_Nav_FSK_stopbits->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_FSK_stopbits->callback((Fl_Callback*)cb_sel_Nav_FSK_stopbits);
          sel_Nav_FSK_stopbits->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_FSK_stopbits->when(FL_WHEN_CHANGED);
          o->add("1|1.5|2");
          o->index(progdefaults.Nav_FSK_stopbits);
          sel_Nav_FSK_stopbits->end();
        } // Fl_ListBox* sel_Nav_FSK_stopbits
        { Fl_ListBox* o = sel_Nav_FSK_polarity = new Fl_ListBox(585, 223, 80, 23, gettext("Mark Polarity"));
          sel_Nav_FSK_polarity->tooltip(gettext("Nav FSK MARK Polarity"));
          sel_Nav_FSK_polarity->box(FL_DOWN_BOX);
          sel_Nav_FSK_polarity->color(FL_BACKGROUND2_COLOR);
          sel_Nav_FSK_polarity->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_FSK_polarity->labeltype(FL_NORMAL_LABEL);
          sel_Nav_FSK_polarity->labelfont(0);
          sel_Nav_FSK_polarity->labelsize(14);
          sel_Nav_FSK_polarity->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_FSK_polarity->callback((Fl_Callback*)cb_sel_Nav_FSK_polarity);
          sel_Nav_FSK_polarity->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_FSK_polarity->when(FL_WHEN_CHANGED);
          o->add("Normal|Reverse");
          o->index(progdefaults.Nav_FSK_polarity);
          sel_Nav_FSK_polarity->end();
        } // Fl_ListBox* sel_Nav_FSK_polarity
        { Fl_ListBox* o = sel_Nav_FSK_sidetone = new Fl_ListBox(585, 253, 80, 23, gettext("Side tone"));
          sel_Nav_FSK_sidetone->tooltip(gettext("Nav FSK side tone"));
          sel_Nav_FSK_sidetone->box(FL_DOWN_BOX);
          sel_Nav_FSK_sidetone->color(FL_BACKGROUND2_COLOR);
          sel_Nav_FSK_sidetone->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_FSK_sidetone->labeltype(FL_NORMAL_LABEL);
          sel_Nav_FSK_sidetone->labelfont(0);
          sel_Nav_FSK_sidetone->labelsize(14);
          sel_Nav_FSK_sidetone->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_FSK_sidetone->callback((Fl_Callback*)cb_sel_Nav_FSK_sidetone);
          sel_Nav_FSK_sidetone->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_FSK_sidetone->when(FL_WHEN_CHANGED);
          o->add("On|Off");
          o->index(progdefaults.Nav_FSK_sidetone);
          sel_Nav_FSK_sidetone->end();
        } // Fl_ListBox* sel_Nav_FSK_sidetone
        { Fl_ListBox* o = sel_Nav_FSK_ptt = new Fl_ListBox(585, 283, 80, 23, gettext("FSK PTT"));
          sel_Nav_FSK_ptt->tooltip(gettext("Nav FSK PTT - should always be on"));
          sel_Nav_FSK_ptt->box(FL_DOWN_BOX);
          sel_Nav_FSK_ptt->color(FL_BACKGROUND2_COLOR);
          sel_Nav_FSK_ptt->selection_color(FL_BACKGROUND_COLOR);
          sel_Nav_FSK_ptt->labeltype(FL_NORMAL_LABEL);
          sel_Nav_FSK_ptt->labelfont(0);
          sel_Nav_FSK_ptt->labelsize(14);
          sel_Nav_FSK_ptt->labelcolor(FL_FOREGROUND_COLOR);
          sel_Nav_FSK_ptt->callback((Fl_Callback*)cb_sel_Nav_FSK_ptt);
          sel_Nav_FSK_ptt->align(Fl_Align(FL_ALIGN_LEFT));
          sel_Nav_FSK_ptt->when(FL_WHEN_CHANGED);
          o->add("On|Off");
          o->index(progdefaults.Nav_FSK_ptt);
          sel_Nav_FSK_ptt->end();
        } // Fl_ListBox* sel_Nav_FSK_ptt
        { btn_Nav_config = new Fl_Light_Button(710, 137, 80, 23, gettext("Config"));
          btn_Nav_config->tooltip(gettext("Connect / Disconnect from Nav Config port"));
          btn_Nav_config->callback((Fl_Callback*)cb_btn_Nav_config);
        } // Fl_Light_Button* btn_Nav_config
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/TTY/Navigator"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/TTY/Navigator"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/TTY/Synop"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Check_Button* o = btnSynopAdifDecoding = new Fl_Check_Button(406, 71, 127, 24, gettext("SYNOP to ADIF"));
        btnSynopAdifDecoding->tooltip(gettext("Decodes SYNOP messages (Ex: Deutsche Wetterdienst) to ADIF log file"));
        btnSynopAdifDecoding->down_box(FL_DOWN_BOX);
        btnSynopAdifDecoding->callback((Fl_Callback*)cb_btnSynopAdifDecoding);
        btnSynopAdifDecoding->align(Fl_Align(132|FL_ALIGN_INSIDE));
        o->value(progdefaults.SynopAdifDecoding);
      } // Fl_Check_Button* btnSynopAdifDecoding
      { Fl_Check_Button* o = btnSynopKmlDecoding = new Fl_Check_Button(406, 112, 120, 24, gettext("SYNOP to KML"));
        btnSynopKmlDecoding->tooltip(gettext("Decodes SYNOP messages (Ex: Deutsche Wetterdienst) to KML documents (Ex: Goog"
"le Earth)"));
        btnSynopKmlDecoding->down_box(FL_DOWN_BOX);
        btnSynopKmlDecoding->callback((Fl_Callback*)cb_btnSynopKmlDecoding);
        btnSynopKmlDecoding->align(Fl_Align(132|FL_ALIGN_INSIDE));
        o->value(progdefaults.SynopKmlDecoding);
      } // Fl_Check_Button* btnSynopKmlDecoding
      { Fl_Check_Button* o = btnSynopInterleaved = new Fl_Check_Button(406, 154, 211, 24, gettext("Interleave SYNOP and text"));
        btnSynopInterleaved->tooltip(gettext("Interleave text with decoded SYNOP messages, or replacement."));
        btnSynopInterleaved->down_box(FL_DOWN_BOX);
        btnSynopInterleaved->callback((Fl_Callback*)cb_btnSynopInterleaved);
        btnSynopInterleaved->align(Fl_Align(132|FL_ALIGN_INSIDE));
        o->value(progdefaults.SynopInterleaved);
      } // Fl_Check_Button* btnSynopInterleaved
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/TTY/Synop"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/TTY/Synop"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/TTY/Winkeyer 3"));
      o->box(FL_FLAT_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(206, 43, 591, 72, gettext("Serial Interface"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ComboBox* o = select_WKFSK_CommPort = new Fl_ComboBox(274, 71, 405, 23, gettext("Port"));
          select_WKFSK_CommPort->tooltip(gettext("Xcvr serial port"));
          select_WKFSK_CommPort->box(FL_DOWN_BOX);
          select_WKFSK_CommPort->color((Fl_Color)55);
          select_WKFSK_CommPort->selection_color(FL_BACKGROUND_COLOR);
          select_WKFSK_CommPort->labeltype(FL_NORMAL_LABEL);
          select_WKFSK_CommPort->labelfont(0);
          select_WKFSK_CommPort->labelsize(14);
          select_WKFSK_CommPort->labelcolor(FL_FOREGROUND_COLOR);
          select_WKFSK_CommPort->callback((Fl_Callback*)cb_select_WKFSK_CommPort);
          select_WKFSK_CommPort->align(Fl_Align(FL_ALIGN_LEFT));
          select_WKFSK_CommPort->when(FL_WHEN_RELEASE);
          o->value(progStatus.WK_serial_port_name.c_str());
          select_WKFSK_CommPort->end();
        } // Fl_ComboBox* select_WKFSK_CommPort
        { Fl_Light_Button* o = btn_WKFSK_connect = new Fl_Light_Button(705, 71, 80, 23, gettext("Connect"));
          btn_WKFSK_connect->tooltip(gettext("Connect / Disconnect from WinKeyer"));
          btn_WKFSK_connect->callback((Fl_Callback*)cb_btn_WKFSK_connect);
          o->value(progStatus.WK_online);
        } // Fl_Light_Button* btn_WKFSK_connect
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(206, 116, 591, 231, gettext("Configuration Interface"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = sel_WKFSK_baud = new Fl_ListBox(391, 148, 78, 23, gettext("Baud rate"));
          sel_WKFSK_baud->tooltip(gettext("Nav FSK baud rate"));
          sel_WKFSK_baud->box(FL_DOWN_BOX);
          sel_WKFSK_baud->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_baud->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_baud->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_baud->labelfont(0);
          sel_WKFSK_baud->labelsize(14);
          sel_WKFSK_baud->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_baud->callback((Fl_Callback*)cb_sel_WKFSK_baud);
          sel_WKFSK_baud->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_baud->when(FL_WHEN_CHANGED);
          o->add("45.45|50|75|100");
          o->index(progStatus.WKFSK_baud);
          sel_WKFSK_baud->end();
        } // Fl_ListBox* sel_WKFSK_baud
        { Fl_ListBox* o = sel_WKFSK_stopbits = new Fl_ListBox(391, 177, 78, 23, gettext("Stop bits"));
          sel_WKFSK_stopbits->tooltip(gettext("Nav FSK Stop bits"));
          sel_WKFSK_stopbits->box(FL_DOWN_BOX);
          sel_WKFSK_stopbits->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_stopbits->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_stopbits->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_stopbits->labelfont(0);
          sel_WKFSK_stopbits->labelsize(14);
          sel_WKFSK_stopbits->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_stopbits->callback((Fl_Callback*)cb_sel_WKFSK_stopbits);
          sel_WKFSK_stopbits->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_stopbits->when(FL_WHEN_CHANGED);
          o->add("2|1.5");
          o->index(progStatus.WKFSK_stopbits);
          sel_WKFSK_stopbits->end();
        } // Fl_ListBox* sel_WKFSK_stopbits
        { Fl_ListBox* o = sel_WKFSK_ptt = new Fl_ListBox(391, 206, 78, 23, gettext("FSK port"));
          sel_WKFSK_ptt->tooltip(gettext("NavWinkey PTT"));
          sel_WKFSK_ptt->box(FL_DOWN_BOX);
          sel_WKFSK_ptt->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_ptt->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_ptt->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_ptt->labelfont(0);
          sel_WKFSK_ptt->labelsize(14);
          sel_WKFSK_ptt->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_ptt->callback((Fl_Callback*)cb_sel_WKFSK_ptt);
          sel_WKFSK_ptt->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_ptt->when(FL_WHEN_CHANGED);
          o->add("On PTT|On KEY");
          o->index(progStatus.WKFSK_ptt);
          sel_WKFSK_ptt->end();
        } // Fl_ListBox* sel_WKFSK_ptt
        { Fl_ListBox* o = sel_WKFSK_polarity = new Fl_ListBox(391, 236, 78, 23, gettext("Mark Polarity"));
          sel_WKFSK_polarity->tooltip(gettext("Nav FSK MARK Polarity"));
          sel_WKFSK_polarity->box(FL_DOWN_BOX);
          sel_WKFSK_polarity->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_polarity->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_polarity->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_polarity->labelfont(0);
          sel_WKFSK_polarity->labelsize(14);
          sel_WKFSK_polarity->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_polarity->callback((Fl_Callback*)cb_sel_WKFSK_polarity);
          sel_WKFSK_polarity->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_polarity->when(FL_WHEN_CHANGED);
          o->add("Normal|Reverse");
          o->index(progStatus.WKFSK_polarity);
          sel_WKFSK_polarity->end();
        } // Fl_ListBox* sel_WKFSK_polarity
        { Fl_ListBox* o = sel_WKFSK_sidetone = new Fl_ListBox(391, 265, 78, 23, gettext("Sidetone"));
          sel_WKFSK_sidetone->tooltip(gettext("Nav FSK side tone"));
          sel_WKFSK_sidetone->box(FL_DOWN_BOX);
          sel_WKFSK_sidetone->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_sidetone->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_sidetone->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_sidetone->labelfont(0);
          sel_WKFSK_sidetone->labelsize(14);
          sel_WKFSK_sidetone->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_sidetone->callback((Fl_Callback*)cb_sel_WKFSK_sidetone);
          sel_WKFSK_sidetone->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_sidetone->when(FL_WHEN_CHANGED);
          o->add("Off|On");
          o->index(progStatus.WKFSK_sidetone);
          sel_WKFSK_sidetone->end();
        } // Fl_ListBox* sel_WKFSK_sidetone
        { Fl_ListBox* o = sel_WKFSK_auto_crlf = new Fl_ListBox(391, 295, 78, 23, gettext("Auto CRLF"));
          sel_WKFSK_auto_crlf->tooltip(gettext("Nav FSK side tone"));
          sel_WKFSK_auto_crlf->box(FL_DOWN_BOX);
          sel_WKFSK_auto_crlf->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_auto_crlf->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_auto_crlf->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_auto_crlf->labelfont(0);
          sel_WKFSK_auto_crlf->labelsize(14);
          sel_WKFSK_auto_crlf->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_auto_crlf->callback((Fl_Callback*)cb_sel_WKFSK_auto_crlf);
          sel_WKFSK_auto_crlf->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_auto_crlf->when(FL_WHEN_CHANGED);
          o->add("Off|On");
          o->index(progStatus.WKFSK_auto_crlf);
          sel_WKFSK_auto_crlf->end();
        } // Fl_ListBox* sel_WKFSK_auto_crlf
        { Fl_ListBox* o = sel_WKFSK_diddle = new Fl_ListBox(581, 148, 78, 23, gettext("Diddle"));
          sel_WKFSK_diddle->tooltip(gettext("Diddle On/OFF"));
          sel_WKFSK_diddle->box(FL_DOWN_BOX);
          sel_WKFSK_diddle->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_diddle->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_diddle->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_diddle->labelfont(0);
          sel_WKFSK_diddle->labelsize(14);
          sel_WKFSK_diddle->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_diddle->callback((Fl_Callback*)cb_sel_WKFSK_diddle);
          sel_WKFSK_diddle->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_diddle->when(FL_WHEN_CHANGED);
          o->add("Off|On");
          o->index(progStatus.WKFSK_diddle);
          sel_WKFSK_diddle->end();
        } // Fl_ListBox* sel_WKFSK_diddle
        { Fl_ListBox* o = sel_WKFSK_diddle_char = new Fl_ListBox(581, 177, 78, 23, gettext("Diddle char"));
          sel_WKFSK_diddle_char->tooltip(gettext("Diddle character"));
          sel_WKFSK_diddle_char->box(FL_DOWN_BOX);
          sel_WKFSK_diddle_char->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_diddle_char->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_diddle_char->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_diddle_char->labelfont(0);
          sel_WKFSK_diddle_char->labelsize(14);
          sel_WKFSK_diddle_char->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_diddle_char->callback((Fl_Callback*)cb_sel_WKFSK_diddle_char);
          sel_WKFSK_diddle_char->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_diddle_char->when(FL_WHEN_CHANGED);
          o->add("BLANK|LTRS");
          o->index(progStatus.WKFSK_diddle_char);
          sel_WKFSK_diddle_char->end();
        } // Fl_ListBox* sel_WKFSK_diddle_char
        { Fl_ListBox* o = sel_WKFSK_usos = new Fl_ListBox(581, 206, 78, 23, gettext("USOS"));
          sel_WKFSK_usos->tooltip(gettext("Unshift on space"));
          sel_WKFSK_usos->box(FL_DOWN_BOX);
          sel_WKFSK_usos->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_usos->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_usos->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_usos->labelfont(0);
          sel_WKFSK_usos->labelsize(14);
          sel_WKFSK_usos->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_usos->callback((Fl_Callback*)cb_sel_WKFSK_usos);
          sel_WKFSK_usos->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_usos->when(FL_WHEN_CHANGED);
          o->add("Off|On");
          o->index(progStatus.WKFSK_usos);
          sel_WKFSK_usos->end();
        } // Fl_ListBox* sel_WKFSK_usos
        { Fl_ListBox* o = sel_WKFSK_monitor = new Fl_ListBox(581, 236, 78, 23, gettext("Echo"));
          sel_WKFSK_monitor->tooltip(gettext("Unshift on space"));
          sel_WKFSK_monitor->box(FL_DOWN_BOX);
          sel_WKFSK_monitor->color(FL_BACKGROUND2_COLOR);
          sel_WKFSK_monitor->selection_color(FL_BACKGROUND_COLOR);
          sel_WKFSK_monitor->labeltype(FL_NORMAL_LABEL);
          sel_WKFSK_monitor->labelfont(0);
          sel_WKFSK_monitor->labelsize(14);
          sel_WKFSK_monitor->labelcolor(FL_FOREGROUND_COLOR);
          sel_WKFSK_monitor->callback((Fl_Callback*)cb_sel_WKFSK_monitor);
          sel_WKFSK_monitor->align(Fl_Align(FL_ALIGN_LEFT));
          sel_WKFSK_monitor->when(FL_WHEN_CHANGED);
          o->add("Off|On");
          o->index(progStatus.WKFSK_monitor);
          sel_WKFSK_monitor->end();
        } // Fl_ListBox* sel_WKFSK_monitor
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/TTY/Winkeyer 3"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/TTY/Winkeyer 3"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/Thor"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { txtTHORSecondary = new Fl_Input2(245, 43, 430, 40, gettext("Secondary Text"));
        txtTHORSecondary->tooltip(gettext("Text to send during keyboard idle times"));
        txtTHORSecondary->type(4);
        txtTHORSecondary->box(FL_DOWN_BOX);
        txtTHORSecondary->color(FL_BACKGROUND2_COLOR);
        txtTHORSecondary->selection_color(FL_SELECTION_COLOR);
        txtTHORSecondary->labeltype(FL_NORMAL_LABEL);
        txtTHORSecondary->labelfont(0);
        txtTHORSecondary->labelsize(14);
        txtTHORSecondary->labelcolor(FL_FOREGROUND_COLOR);
        txtTHORSecondary->callback((Fl_Callback*)cb_txtTHORSecondary);
        txtTHORSecondary->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        txtTHORSecondary->when(FL_WHEN_CHANGED);
        txtTHORSecondary->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* txtTHORSecondary
      { Fl_Check_Button* o = valTHOR_FILTER = new Fl_Check_Button(245, 96, 81, 20, gettext("Filtering"));
        valTHOR_FILTER->tooltip(gettext("Enable DSP prior to decoder"));
        valTHOR_FILTER->down_box(FL_DOWN_BOX);
        valTHOR_FILTER->value(1);
        valTHOR_FILTER->callback((Fl_Callback*)cb_valTHOR_FILTER);
        o->value(progdefaults.THOR_FILTER);
      } // Fl_Check_Button* valTHOR_FILTER
      { Fl_Counter2* o = valTHOR_BW = new Fl_Counter2(345, 96, 63, 20, gettext("Filter bandwidth factor"));
        valTHOR_BW->tooltip(gettext("Filter bandwidth relative to signal width"));
        valTHOR_BW->type(1);
        valTHOR_BW->box(FL_UP_BOX);
        valTHOR_BW->color(FL_BACKGROUND_COLOR);
        valTHOR_BW->selection_color(FL_INACTIVE_COLOR);
        valTHOR_BW->labeltype(FL_NORMAL_LABEL);
        valTHOR_BW->labelfont(0);
        valTHOR_BW->labelsize(14);
        valTHOR_BW->labelcolor(FL_FOREGROUND_COLOR);
        valTHOR_BW->minimum(1);
        valTHOR_BW->maximum(2);
        valTHOR_BW->value(1.5);
        valTHOR_BW->callback((Fl_Callback*)cb_valTHOR_BW);
        valTHOR_BW->align(Fl_Align(FL_ALIGN_RIGHT));
        valTHOR_BW->when(FL_WHEN_CHANGED);
        o->value(progdefaults.THOR_BW);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Counter2* valTHOR_BW
      { Fl_Value_Slider2* o = valThorCWI = new Fl_Value_Slider2(245, 126, 260, 20, gettext("CWI threshold"));
        valThorCWI->tooltip(gettext("CWI detection and suppression"));
        valThorCWI->type(1);
        valThorCWI->box(FL_DOWN_BOX);
        valThorCWI->color(FL_BACKGROUND_COLOR);
        valThorCWI->selection_color(FL_BACKGROUND_COLOR);
        valThorCWI->labeltype(FL_NORMAL_LABEL);
        valThorCWI->labelfont(0);
        valThorCWI->labelsize(14);
        valThorCWI->labelcolor(FL_FOREGROUND_COLOR);
        valThorCWI->textsize(14);
        valThorCWI->callback((Fl_Callback*)cb_valThorCWI);
        valThorCWI->align(Fl_Align(FL_ALIGN_RIGHT));
        valThorCWI->when(FL_WHEN_CHANGED);
        o->value(progdefaults.ThorCWI);
        o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
      } // Fl_Value_Slider2* valThorCWI
      { Fl_Check_Button* o = valTHOR_PREAMBLE = new Fl_Check_Button(245, 157, 190, 20, gettext("Preamble Detection"));
        valTHOR_PREAMBLE->tooltip(gettext("Detect the THOR preamble\nClear the Rx pipeline"));
        valTHOR_PREAMBLE->down_box(FL_DOWN_BOX);
        valTHOR_PREAMBLE->callback((Fl_Callback*)cb_valTHOR_PREAMBLE);
        o->value(progdefaults.THOR_PREAMBLE);
      } // Fl_Check_Button* valTHOR_PREAMBLE
      { Fl_Check_Button* o = valTHOR_SOFTSYMBOLS = new Fl_Check_Button(245, 188, 190, 20, gettext("Soft-symbol decoding"));
        valTHOR_SOFTSYMBOLS->tooltip(gettext("Use soft-decision decoding for symbol detection\nAssists soft-bit decoding"));
        valTHOR_SOFTSYMBOLS->down_box(FL_DOWN_BOX);
        valTHOR_SOFTSYMBOLS->callback((Fl_Callback*)cb_valTHOR_SOFTSYMBOLS);
        o->value(progdefaults.THOR_SOFTSYMBOLS);
      } // Fl_Check_Button* valTHOR_SOFTSYMBOLS
      { Fl_Check_Button* o = valTHOR_SOFTBITS = new Fl_Check_Button(245, 218, 190, 20, gettext("Soft-bit decoding"));
        valTHOR_SOFTBITS->tooltip(gettext("Use soft-bit viterbi decoding for better Forward Error Correction\nWorks best"
" with soft-symbol decoding enabled"));
        valTHOR_SOFTBITS->down_box(FL_DOWN_BOX);
        valTHOR_SOFTBITS->callback((Fl_Callback*)cb_valTHOR_SOFTBITS);
        o->value(progdefaults.THOR_SOFTBITS);
      } // Fl_Check_Button* valTHOR_SOFTBITS
      { Fl_Check_Button* o = btnTHOR_DEBUG = new Fl_Check_Button(245, 249, 190, 20, gettext("Enable debug events"));
        btnTHOR_DEBUG->down_box(FL_DOWN_BOX);
        btnTHOR_DEBUG->callback((Fl_Callback*)cb_btnTHOR_DEBUG);
        o->value(progStatus.thordebug);
      } // Fl_Check_Button* btnTHOR_DEBUG
      { Fl_Counter2* o = valTHOR_PATHS = new Fl_Counter2(245, 280, 75, 21, gettext("Rx Paths"));
        valTHOR_PATHS->tooltip(gettext("Larger number provides wider capture range.\nSmaller gives reduced cpu usage "
"and improves CWI capture."));
        valTHOR_PATHS->type(1);
        valTHOR_PATHS->box(FL_UP_BOX);
        valTHOR_PATHS->color(FL_BACKGROUND_COLOR);
        valTHOR_PATHS->selection_color(FL_INACTIVE_COLOR);
        valTHOR_PATHS->labeltype(FL_NORMAL_LABEL);
        valTHOR_PATHS->labelfont(0);
        valTHOR_PATHS->labelsize(14);
        valTHOR_PATHS->labelcolor(FL_FOREGROUND_COLOR);
        valTHOR_PATHS->minimum(1);
        valTHOR_PATHS->maximum(8);
        valTHOR_PATHS->step(1);
        valTHOR_PATHS->value(5);
        valTHOR_PATHS->callback((Fl_Callback*)cb_valTHOR_PATHS);
        valTHOR_PATHS->align(Fl_Align(FL_ALIGN_RIGHT));
        valTHOR_PATHS->when(FL_WHEN_CHANGED);
        o->value(progdefaults.THOR_PATHS);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Counter2* valTHOR_PATHS
      { Fl_Counter2* o = valTHOR_RISETIME = new Fl_Counter2(245, 312, 100, 21, gettext("Tx tone risetime (msec)"));
        valTHOR_RISETIME->tooltip(gettext("Tone shaping with raised cosine waveform\nSimilar to CW shaping."));
        valTHOR_RISETIME->box(FL_UP_BOX);
        valTHOR_RISETIME->color(FL_BACKGROUND_COLOR);
        valTHOR_RISETIME->selection_color(FL_INACTIVE_COLOR);
        valTHOR_RISETIME->labeltype(FL_NORMAL_LABEL);
        valTHOR_RISETIME->labelfont(0);
        valTHOR_RISETIME->labelsize(14);
        valTHOR_RISETIME->labelcolor(FL_FOREGROUND_COLOR);
        valTHOR_RISETIME->minimum(0);
        valTHOR_RISETIME->maximum(8);
        valTHOR_RISETIME->value(4);
        valTHOR_RISETIME->callback((Fl_Callback*)cb_valTHOR_RISETIME);
        valTHOR_RISETIME->align(Fl_Align(FL_ALIGN_RIGHT));
        valTHOR_RISETIME->when(FL_WHEN_CHANGED);
        o->value(progdefaults.THOR_RISETIME);
        o->labelsize(FL_NORMAL_SIZE);
        o->lstep(1.0);
      } // Fl_Counter2* valTHOR_RISETIME
      { Fl_Group* o = thor_image_box = new Fl_Group(668, 151, 59, 74, gettext("\nOperator Avatar"));
        thor_image_box->box(FL_FLAT_BOX);
        thor_image_box->color(FL_GRAY0);
        thor_image_box->selection_color(FL_BACKGROUND_COLOR);
        thor_image_box->labeltype(FL_NORMAL_LABEL);
        thor_image_box->labelfont(0);
        thor_image_box->labelsize(14);
        thor_image_box->labelcolor(FL_FOREGROUND_COLOR);
        thor_image_box->align(Fl_Align(FL_ALIGN_BOTTOM));
        thor_image_box->when(FL_WHEN_RELEASE);
        init_def_thor_avatar(o);
        thor_image_box->end();
      } // Fl_Group* thor_image_box
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/Thor"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/Thor"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/Navtex"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Check_Button* o = btnNvtxAdifLog = new Fl_Check_Button(316, 84, 235, 30, gettext("Log Navtex messages to Adif file"));
        btnNvtxAdifLog->down_box(FL_DOWN_BOX);
        btnNvtxAdifLog->callback((Fl_Callback*)cb_btnNvtxAdifLog);
        o->value(progdefaults.NVTX_AdifLog);
      } // Fl_Check_Button* btnNvtxAdifLog
      { Fl_Check_Button* o = btnNvtxKmlLog = new Fl_Check_Button(315, 130, 270, 30, gettext("Log Navtex messages to KML"));
        btnNvtxKmlLog->tooltip(gettext("Logs messages to Keyhole Markup Language (Google Earth, Marble, Gaia, etc...)"));
        btnNvtxKmlLog->down_box(FL_DOWN_BOX);
        btnNvtxKmlLog->callback((Fl_Callback*)cb_btnNvtxKmlLog);
        o->value(progdefaults.NVTX_KmlLog);
      } // Fl_Check_Button* btnNvtxKmlLog
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/Navtex"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/Navtex"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Modem/Wefax"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Counter* o = cntrWEFAX_Shift = new Fl_Counter(262, 50, 150, 24, gettext("Frequency shift"));
        cntrWEFAX_Shift->tooltip(gettext("Frequency shift of WEFAX signal\nNominal 800 Hz"));
        cntrWEFAX_Shift->minimum(700);
        cntrWEFAX_Shift->maximum(1000);
        cntrWEFAX_Shift->step(10);
        cntrWEFAX_Shift->value(800);
        cntrWEFAX_Shift->callback((Fl_Callback*)cb_cntrWEFAX_Shift);
        cntrWEFAX_Shift->align(Fl_Align(FL_ALIGN_TOP));
        o->value(progdefaults.WEFAX_Shift);
        o->lstep(100.0);
      } // Fl_Counter* cntrWEFAX_Shift
      { Fl_Counter* o = cntrWEFAX_Center = new Fl_Counter(262, 99, 150, 24, gettext("Center freq"));
        cntrWEFAX_Center->tooltip(gettext("Center of WEFAX signal\nNominal 1900 Hz"));
        cntrWEFAX_Center->minimum(1000);
        cntrWEFAX_Center->maximum(2000);
        cntrWEFAX_Center->step(10);
        cntrWEFAX_Center->value(1900);
        cntrWEFAX_Center->callback((Fl_Callback*)cb_cntrWEFAX_Center);
        cntrWEFAX_Center->align(Fl_Align(FL_ALIGN_TOP));
        o->value(progdefaults.WEFAX_Center);
        o->lstep(100.0);
      } // Fl_Counter* cntrWEFAX_Center
      { Fl_Counter* o = cntrWEFAX_MaxRows = new Fl_Counter(588, 50, 150, 24, gettext("Max Image Rows"));
        cntrWEFAX_MaxRows->tooltip(gettext("Force save split image"));
        cntrWEFAX_MaxRows->minimum(1000);
        cntrWEFAX_MaxRows->maximum(10000);
        cntrWEFAX_MaxRows->step(100);
        cntrWEFAX_MaxRows->value(1500);
        cntrWEFAX_MaxRows->callback((Fl_Callback*)cb_cntrWEFAX_MaxRows);
        cntrWEFAX_MaxRows->align(Fl_Align(FL_ALIGN_TOP));
        o->value(progdefaults.WEFAX_MaxRows);
        o->lstep(1000.0);
      } // Fl_Counter* cntrWEFAX_MaxRows
      { Fl_Input* o = btnWefaxSaveDir = new Fl_Input(216, 267, 470, 24, gettext("Fax images destination directory"));
        btnWefaxSaveDir->tooltip(gettext("Store images in this directory"));
        btnWefaxSaveDir->callback((Fl_Callback*)cb_btnWefaxSaveDir);
        btnWefaxSaveDir->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value(progdefaults.wefax_save_dir.c_str());
      } // Fl_Input* btnWefaxSaveDir
      { btnSelectFaxDestDir = new Fl_Button(695, 267, 90, 24, gettext("Directory..."));
        btnSelectFaxDestDir->tooltip(gettext("Select destination directory"));
        btnSelectFaxDestDir->callback((Fl_Callback*)cb_btnSelectFaxDestDir);
      } // Fl_Button* btnSelectFaxDestDir
      { Fl_Check_Button* o = btnWefaxAdifLog = new Fl_Check_Button(216, 298, 235, 30, gettext("Log Wefax messages to Adif file"));
        btnWefaxAdifLog->tooltip(gettext("Sent and received faxes are logged to Adif file."));
        btnWefaxAdifLog->down_box(FL_DOWN_BOX);
        btnWefaxAdifLog->callback((Fl_Callback*)cb_btnWefaxAdifLog);
        o->value(progdefaults.WEFAX_AdifLog);
      } // Fl_Check_Button* btnWefaxAdifLog
      { Fl_Choice* o = wefax_choice_rx_filter = new Fl_Choice(302, 147, 110, 24, gettext("Filter"));
        wefax_choice_rx_filter->down_box(FL_BORDER_BOX);
        wefax_choice_rx_filter->callback((Fl_Callback*)cb_wefax_choice_rx_filter);
        o->add("Narrow|Medium|Wide");
        o->value(progdefaults.wefax_filter < 3 ? progdefaults.wefax_filter : 0);
      } // Fl_Choice* wefax_choice_rx_filter
      { Fl_Counter* o = auto_after_nrows = new Fl_Counter(588, 82, 150, 24, gettext("Enable Auto-align after"));
        auto_after_nrows->minimum(5);
        auto_after_nrows->maximum(100);
        auto_after_nrows->step(5);
        auto_after_nrows->value(50);
        auto_after_nrows->callback((Fl_Callback*)cb_auto_after_nrows);
        auto_after_nrows->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.wefax_auto_after);
        o->lstep(50);
      } // Fl_Counter* auto_after_nrows
      { Fl_Counter* o = align_stop_after = new Fl_Counter(588, 115, 150, 24, gettext("Stop Auto-align after"));
        align_stop_after->minimum(50);
        align_stop_after->maximum(500);
        align_stop_after->step(5);
        align_stop_after->value(500);
        align_stop_after->callback((Fl_Callback*)cb_align_stop_after);
        align_stop_after->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.wefax_align_stop);
        o->lstep(50);
      } // Fl_Counter* align_stop_after
      { Fl_Counter* o = align_every_nrows = new Fl_Counter(624, 147, 80, 24, gettext("Auto-align every"));
        align_every_nrows->type(1);
        align_every_nrows->minimum(5);
        align_every_nrows->maximum(100);
        align_every_nrows->step(5);
        align_every_nrows->value(25);
        align_every_nrows->callback((Fl_Callback*)cb_align_every_nrows);
        align_every_nrows->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.wefax_align_rows);
      } // Fl_Counter* align_every_nrows
      { Fl_Box* o = new Fl_Box(743, 81, 42, 22, gettext("rows"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(743, 113, 42, 22, gettext("rows"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(706, 146, 42, 22, gettext("rows"));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Counter* o = wefax_correlation = new Fl_Counter(589, 180, 150, 24, gettext("Correlation"));
        wefax_correlation->tooltip(gettext("Row-to-row correlation\nUsed to detect presence of WEFAX signal\nLower: more "
"false detections"));
        wefax_correlation->minimum(0.01);
        wefax_correlation->maximum(0.1);
        wefax_correlation->step(0.001);
        wefax_correlation->value(0.05);
        wefax_correlation->callback((Fl_Callback*)cb_wefax_correlation);
        wefax_correlation->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.wefax_correlation);
        o->lstep (0.01);
      } // Fl_Counter* wefax_correlation
      { Fl_Counter* o = cntr_correlation_rows = new Fl_Counter(624, 213, 80, 24, gettext("# Correlation rows"));
        cntr_correlation_rows->tooltip(gettext("Compute correlation factor over this # rows"));
        cntr_correlation_rows->type(1);
        cntr_correlation_rows->minimum(2);
        cntr_correlation_rows->maximum(50);
        cntr_correlation_rows->step(1);
        cntr_correlation_rows->value(10);
        cntr_correlation_rows->callback((Fl_Callback*)cb_cntr_correlation_rows);
        cntr_correlation_rows->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(progdefaults.wefax_correlation_rows);
      } // Fl_Counter* cntr_correlation_rows
      { Fl_Choice* o = choice_lpm_288 = new Fl_Choice(302, 180, 110, 24, gettext("LPM-288"));
        choice_lpm_288->tooltip(gettext("Set the 288 LPM value"));
        choice_lpm_288->down_box(FL_BORDER_BOX);
        choice_lpm_288->callback((Fl_Callback*)cb_choice_lpm_288);
        o->add("240");o->add("120");o->add("90");o->add("60");
        o->value(progdefaults.wefax_lpm_288);
      } // Fl_Choice* choice_lpm_288
      { Fl_Choice* o = choice_lpm_576 = new Fl_Choice(302, 213, 110, 24, gettext("LPM-576"));
        choice_lpm_576->tooltip(gettext("Set the 576 LPM value"));
        choice_lpm_576->down_box(FL_BORDER_BOX);
        choice_lpm_576->callback((Fl_Callback*)cb_choice_lpm_576);
        o->add("240");o->add("120");o->add("90");o->add("60");
        o->value(progdefaults.wefax_lpm_576);
      } // Fl_Choice* choice_lpm_576
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Modem/Wefax"));
      config_pages.push_back(p);
      tab_tree->add(_("Modem/Wefax"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/Autostart"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Input2* o = txt_auto_flrig_pathname = new Fl_Input2(267, 56, 310, 24, gettext("flrig:"));
        txt_auto_flrig_pathname->tooltip(gettext("Enter full path-filename for flrig"));
        txt_auto_flrig_pathname->box(FL_DOWN_BOX);
        txt_auto_flrig_pathname->color(FL_BACKGROUND2_COLOR);
        txt_auto_flrig_pathname->selection_color(FL_SELECTION_COLOR);
        txt_auto_flrig_pathname->labeltype(FL_NORMAL_LABEL);
        txt_auto_flrig_pathname->labelfont(0);
        txt_auto_flrig_pathname->labelsize(14);
        txt_auto_flrig_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_auto_flrig_pathname->callback((Fl_Callback*)cb_txt_auto_flrig_pathname);
        txt_auto_flrig_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_auto_flrig_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.auto_flrig_pathname.c_str());
      } // Fl_Input2* txt_auto_flrig_pathname
      { btn_select_flrig = new Fl_Button(599, 56, 70, 24, gettext("Locate"));
        btn_select_flrig->tooltip(gettext("Locate flrig executable"));
        btn_select_flrig->callback((Fl_Callback*)cb_btn_select_flrig);
      } // Fl_Button* btn_select_flrig
      { Fl_Input2* o = txt_auto_flamp_pathname = new Fl_Input2(267, 94, 310, 24, gettext("flamp:"));
        txt_auto_flamp_pathname->tooltip(gettext("Enter full path-filename for flamp"));
        txt_auto_flamp_pathname->box(FL_DOWN_BOX);
        txt_auto_flamp_pathname->color(FL_BACKGROUND2_COLOR);
        txt_auto_flamp_pathname->selection_color(FL_SELECTION_COLOR);
        txt_auto_flamp_pathname->labeltype(FL_NORMAL_LABEL);
        txt_auto_flamp_pathname->labelfont(0);
        txt_auto_flamp_pathname->labelsize(14);
        txt_auto_flamp_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_auto_flamp_pathname->callback((Fl_Callback*)cb_txt_auto_flamp_pathname);
        txt_auto_flamp_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_auto_flamp_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.auto_flamp_pathname.c_str());
      } // Fl_Input2* txt_auto_flamp_pathname
      { btn_select_auto_flamp = new Fl_Button(599, 94, 70, 24, gettext("Locate"));
        btn_select_auto_flamp->tooltip(gettext("Locate flamp executable"));
        btn_select_auto_flamp->callback((Fl_Callback*)cb_btn_select_auto_flamp);
      } // Fl_Button* btn_select_auto_flamp
      { Fl_Input2* o = txt_auto_flnet_pathname = new Fl_Input2(267, 132, 310, 24, gettext("flnet:"));
        txt_auto_flnet_pathname->tooltip(gettext("Enter full path-filename for flnet"));
        txt_auto_flnet_pathname->box(FL_DOWN_BOX);
        txt_auto_flnet_pathname->color(FL_BACKGROUND2_COLOR);
        txt_auto_flnet_pathname->selection_color(FL_SELECTION_COLOR);
        txt_auto_flnet_pathname->labeltype(FL_NORMAL_LABEL);
        txt_auto_flnet_pathname->labelfont(0);
        txt_auto_flnet_pathname->labelsize(14);
        txt_auto_flnet_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_auto_flnet_pathname->callback((Fl_Callback*)cb_txt_auto_flnet_pathname);
        txt_auto_flnet_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_auto_flnet_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.auto_flnet_pathname.c_str());
      } // Fl_Input2* txt_auto_flnet_pathname
      { btn_select_auto_flnet = new Fl_Button(599, 132, 70, 24, gettext("Locate"));
        btn_select_auto_flnet->tooltip(gettext("Locate flnet executable"));
        btn_select_auto_flnet->callback((Fl_Callback*)cb_btn_select_auto_flnet);
      } // Fl_Button* btn_select_auto_flnet
      { Fl_Input2* o = txt_auto_fllog_pathname = new Fl_Input2(267, 171, 310, 24, gettext("fllog:"));
        txt_auto_fllog_pathname->tooltip(gettext("Enter full path-filename for fllog"));
        txt_auto_fllog_pathname->box(FL_DOWN_BOX);
        txt_auto_fllog_pathname->color(FL_BACKGROUND2_COLOR);
        txt_auto_fllog_pathname->selection_color(FL_SELECTION_COLOR);
        txt_auto_fllog_pathname->labeltype(FL_NORMAL_LABEL);
        txt_auto_fllog_pathname->labelfont(0);
        txt_auto_fllog_pathname->labelsize(14);
        txt_auto_fllog_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_auto_fllog_pathname->callback((Fl_Callback*)cb_txt_auto_fllog_pathname);
        txt_auto_fllog_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_auto_fllog_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.auto_fllog_pathname.c_str());
      } // Fl_Input2* txt_auto_fllog_pathname
      { btn_select_fllog = new Fl_Button(599, 171, 70, 24, gettext("Locate"));
        btn_select_fllog->tooltip(gettext("Locate fllog executable"));
        btn_select_fllog->callback((Fl_Callback*)cb_btn_select_fllog);
      } // Fl_Button* btn_select_fllog
      { Fl_Input2* o = txt_auto_prog1_pathname = new Fl_Input2(267, 209, 310, 24, gettext("Prog 1:"));
        txt_auto_prog1_pathname->tooltip(gettext("Enter full path-filename for external program"));
        txt_auto_prog1_pathname->box(FL_DOWN_BOX);
        txt_auto_prog1_pathname->color(FL_BACKGROUND2_COLOR);
        txt_auto_prog1_pathname->selection_color(FL_SELECTION_COLOR);
        txt_auto_prog1_pathname->labeltype(FL_NORMAL_LABEL);
        txt_auto_prog1_pathname->labelfont(0);
        txt_auto_prog1_pathname->labelsize(14);
        txt_auto_prog1_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_auto_prog1_pathname->callback((Fl_Callback*)cb_txt_auto_prog1_pathname);
        txt_auto_prog1_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_auto_prog1_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.auto_prog1_pathname.c_str());
      } // Fl_Input2* txt_auto_prog1_pathname
      { btn_select_prog1 = new Fl_Button(599, 209, 70, 24, gettext("Locate"));
        btn_select_prog1->tooltip(gettext("Locate program #1 executable"));
        btn_select_prog1->callback((Fl_Callback*)cb_btn_select_prog1);
      } // Fl_Button* btn_select_prog1
      { Fl_Input2* o = txt_auto_prog2_pathname = new Fl_Input2(267, 247, 310, 24, gettext("Prog 2:"));
        txt_auto_prog2_pathname->tooltip(gettext("Enter full path-filename for external program"));
        txt_auto_prog2_pathname->box(FL_DOWN_BOX);
        txt_auto_prog2_pathname->color(FL_BACKGROUND2_COLOR);
        txt_auto_prog2_pathname->selection_color(FL_SELECTION_COLOR);
        txt_auto_prog2_pathname->labeltype(FL_NORMAL_LABEL);
        txt_auto_prog2_pathname->labelfont(0);
        txt_auto_prog2_pathname->labelsize(14);
        txt_auto_prog2_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_auto_prog2_pathname->callback((Fl_Callback*)cb_txt_auto_prog2_pathname);
        txt_auto_prog2_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_auto_prog2_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.auto_prog2_pathname.c_str());
      } // Fl_Input2* txt_auto_prog2_pathname
      { btn_select_prog2 = new Fl_Button(599, 247, 70, 24, gettext("Locate"));
        btn_select_prog2->tooltip(gettext("Locate program #2 executable"));
        btn_select_prog2->callback((Fl_Callback*)cb_btn_select_prog2);
      } // Fl_Button* btn_select_prog2
      { Fl_Input2* o = txt_auto_prog3_pathname = new Fl_Input2(267, 286, 310, 24, gettext("Prog 3:"));
        txt_auto_prog3_pathname->tooltip(gettext("Enter full path-filename for external program"));
        txt_auto_prog3_pathname->box(FL_DOWN_BOX);
        txt_auto_prog3_pathname->color(FL_BACKGROUND2_COLOR);
        txt_auto_prog3_pathname->selection_color(FL_SELECTION_COLOR);
        txt_auto_prog3_pathname->labeltype(FL_NORMAL_LABEL);
        txt_auto_prog3_pathname->labelfont(0);
        txt_auto_prog3_pathname->labelsize(14);
        txt_auto_prog3_pathname->labelcolor(FL_FOREGROUND_COLOR);
        txt_auto_prog3_pathname->callback((Fl_Callback*)cb_txt_auto_prog3_pathname);
        txt_auto_prog3_pathname->align(Fl_Align(FL_ALIGN_LEFT));
        txt_auto_prog3_pathname->when(FL_WHEN_CHANGED);
        o->value(progdefaults.auto_prog3_pathname.c_str());
      } // Fl_Input2* txt_auto_prog3_pathname
      { btn_select_prog3 = new Fl_Button(599, 286, 70, 24, gettext("Locate"));
        btn_select_prog3->tooltip(gettext("Locate program #3 executable"));
        btn_select_prog3->callback((Fl_Callback*)cb_btn_select_prog3);
      } // Fl_Button* btn_select_prog3
      { Fl_Check_Button* o = btn_flrig_auto_enable = new Fl_Check_Button(679, 60, 19, 15, gettext("Enable\n-"));
        btn_flrig_auto_enable->tooltip(gettext("Enable this entry when fldigi first starts"));
        btn_flrig_auto_enable->down_box(FL_DOWN_BOX);
        btn_flrig_auto_enable->callback((Fl_Callback*)cb_btn_flrig_auto_enable);
        btn_flrig_auto_enable->align(Fl_Align(FL_ALIGN_TOP));
        o->value(progdefaults.flrig_auto_enable);
      } // Fl_Check_Button* btn_flrig_auto_enable
      { Fl_Check_Button* o = btn_flamp_auto_enable = new Fl_Check_Button(679, 98, 23, 15);
        btn_flamp_auto_enable->tooltip(gettext("Enable this entry when fldigi first starts"));
        btn_flamp_auto_enable->down_box(FL_DOWN_BOX);
        btn_flamp_auto_enable->callback((Fl_Callback*)cb_btn_flamp_auto_enable);
        o->value(progdefaults.flamp_auto_enable);
      } // Fl_Check_Button* btn_flamp_auto_enable
      { Fl_Check_Button* o = btn_flnet_auto_enable = new Fl_Check_Button(679, 136, 23, 15);
        btn_flnet_auto_enable->tooltip(gettext("Enable this entry when fldigi first starts"));
        btn_flnet_auto_enable->down_box(FL_DOWN_BOX);
        btn_flnet_auto_enable->callback((Fl_Callback*)cb_btn_flnet_auto_enable);
        o->value(progdefaults.flnet_auto_enable);
      } // Fl_Check_Button* btn_flnet_auto_enable
      { Fl_Check_Button* o = btn_fllog_auto_enable = new Fl_Check_Button(679, 175, 23, 15);
        btn_fllog_auto_enable->tooltip(gettext("Enable this entry when fldigi first starts"));
        btn_fllog_auto_enable->down_box(FL_DOWN_BOX);
        btn_fllog_auto_enable->callback((Fl_Callback*)cb_btn_fllog_auto_enable);
        o->value(progdefaults.fllog_auto_enable);
      } // Fl_Check_Button* btn_fllog_auto_enable
      { Fl_Check_Button* o = btn_prog1_auto_enable = new Fl_Check_Button(679, 213, 23, 15);
        btn_prog1_auto_enable->tooltip(gettext("Enable this entry when fldigi first starts"));
        btn_prog1_auto_enable->down_box(FL_DOWN_BOX);
        btn_prog1_auto_enable->callback((Fl_Callback*)cb_btn_prog1_auto_enable);
        o->value(progdefaults.prog1_auto_enable);
      } // Fl_Check_Button* btn_prog1_auto_enable
      { Fl_Check_Button* o = btn_prog2_auto_enable = new Fl_Check_Button(679, 251, 23, 15);
        btn_prog2_auto_enable->tooltip(gettext("Enable this entry when fldigi first starts"));
        btn_prog2_auto_enable->down_box(FL_DOWN_BOX);
        btn_prog2_auto_enable->callback((Fl_Callback*)cb_btn_prog2_auto_enable);
        o->value(progdefaults.prog2_auto_enable);
      } // Fl_Check_Button* btn_prog2_auto_enable
      { Fl_Check_Button* o = btn_prog3_auto_enable = new Fl_Check_Button(679, 290, 23, 15);
        btn_prog3_auto_enable->tooltip(gettext("Enable this entry when fldigi first starts"));
        btn_prog3_auto_enable->down_box(FL_DOWN_BOX);
        btn_prog3_auto_enable->callback((Fl_Callback*)cb_btn_prog3_auto_enable);
        o->value(progdefaults.prog3_auto_enable);
      } // Fl_Check_Button* btn_prog3_auto_enable
      { btn_test_flrig = new Fl_Button(709, 56, 70, 24, gettext("Test"));
        btn_test_flrig->tooltip(gettext("Start flrig"));
        btn_test_flrig->callback((Fl_Callback*)cb_btn_test_flrig);
      } // Fl_Button* btn_test_flrig
      { btn_test_flamp = new Fl_Button(709, 94, 70, 24, gettext("Test"));
        btn_test_flamp->tooltip(gettext("Start flamp"));
        btn_test_flamp->callback((Fl_Callback*)cb_btn_test_flamp);
      } // Fl_Button* btn_test_flamp
      { btn_test_flnet = new Fl_Button(709, 132, 70, 24, gettext("Test"));
        btn_test_flnet->tooltip(gettext("Start flnet"));
        btn_test_flnet->callback((Fl_Callback*)cb_btn_test_flnet);
      } // Fl_Button* btn_test_flnet
      { btn_test_fllog = new Fl_Button(709, 171, 70, 24, gettext("Test"));
        btn_test_fllog->tooltip(gettext("Start fllog"));
        btn_test_fllog->callback((Fl_Callback*)cb_btn_test_fllog);
      } // Fl_Button* btn_test_fllog
      { btn_test_prog1 = new Fl_Button(709, 209, 70, 24, gettext("Test"));
        btn_test_prog1->tooltip(gettext("Start prog1"));
        btn_test_prog1->callback((Fl_Callback*)cb_btn_test_prog1);
      } // Fl_Button* btn_test_prog1
      { btn_test_prog2 = new Fl_Button(709, 247, 70, 24, gettext("Test"));
        btn_test_prog2->tooltip(gettext("Start prog2"));
        btn_test_prog2->callback((Fl_Callback*)cb_btn_test_prog2);
      } // Fl_Button* btn_test_prog2
      { btn_test_prog3 = new Fl_Button(709, 286, 70, 24, gettext("Test"));
        btn_test_prog3->tooltip(gettext("Start prog3"));
        btn_test_prog3->callback((Fl_Callback*)cb_btn_test_prog3);
      } // Fl_Button* btn_test_prog3
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/Autostart"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/Autostart"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/CPU"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Check_Button* o = chkSlowCpu = new Fl_Check_Button(305, 65, 225, 20, gettext("Slow CPU (less than 700MHz)"));
        chkSlowCpu->tooltip(gettext("Enable if you\'re computer does not decode properly"));
        chkSlowCpu->down_box(FL_DOWN_BOX);
        chkSlowCpu->callback((Fl_Callback*)cb_chkSlowCpu);
        o->value(progdefaults.slowcpu);
      } // Fl_Check_Button* chkSlowCpu
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/CPU"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/CPU"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/DTMF"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Check_Button* o = chkDTMFdecode = new Fl_Check_Button(372, 79, 175, 20, gettext("Decode DTMF tones"));
        chkDTMFdecode->tooltip(gettext("Decode received DTMF tones"));
        chkDTMFdecode->down_box(FL_DOWN_BOX);
        chkDTMFdecode->callback((Fl_Callback*)cb_chkDTMFdecode);
        o->value(progdefaults.DTMFdecode);
      } // Fl_Check_Button* chkDTMFdecode
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/DTMF"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/DTMF"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/KML"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Input* o = btnKmlSaveDir = new Fl_Input(232, 47, 390, 24, gettext("KML files directory"));
        btnKmlSaveDir->tooltip(gettext("Where generated KML documents are stored."));
        btnKmlSaveDir->callback((Fl_Callback*)cb_btnKmlSaveDir);
        btnKmlSaveDir->align(Fl_Align(69));
        o->value(progdefaults.kml_save_dir.c_str());
      } // Fl_Input* btnKmlSaveDir
      { Fl_Input* o = inputKmlRootFile = new Fl_Input(231, 91, 300, 24, gettext("KML root file"));
        inputKmlRootFile->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value("fldigi.kml");
      } // Fl_Input* inputKmlRootFile
      { Fl_Counter* o = cntKmlMergeDistance = new Fl_Counter(232, 127, 100, 24, gettext("Minimum distance for splitting aliases (Meters)"));
        cntKmlMergeDistance->tooltip(gettext("Minimum distance for splitting alias nodes (Meters)"));
        cntKmlMergeDistance->minimum(0);
        cntKmlMergeDistance->maximum(100000);
        cntKmlMergeDistance->step(10);
        cntKmlMergeDistance->value(1000);
        cntKmlMergeDistance->callback((Fl_Callback*)cb_cntKmlMergeDistance);
        cntKmlMergeDistance->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.kml_merge_distance);
        o->lstep(1000);
      } // Fl_Counter* cntKmlMergeDistance
      { Fl_Counter* o = cntKmlRetentionTime = new Fl_Counter(231, 163, 100, 24, gettext("Data retention time, in hours (0 for no limit)"));
        cntKmlRetentionTime->tooltip(gettext("Number of hours data is kept for each node. Zero means keeping everything."));
        cntKmlRetentionTime->minimum(0);
        cntKmlRetentionTime->maximum(500);
        cntKmlRetentionTime->step(1);
        cntKmlRetentionTime->callback((Fl_Callback*)cb_cntKmlRetentionTime);
        cntKmlRetentionTime->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.kml_retention_time);
        o->lstep(24);
      } // Fl_Counter* cntKmlRetentionTime
      { Fl_Spinner2* o = cntKmlRefreshInterval = new Fl_Spinner2(230, 199, 50, 24, gettext("KML refresh interval (seconds)"));
        cntKmlRefreshInterval->tooltip(gettext("Refresh time interval written in KML file (Seconds)"));
        cntKmlRefreshInterval->box(FL_NO_BOX);
        cntKmlRefreshInterval->color(FL_BACKGROUND_COLOR);
        cntKmlRefreshInterval->selection_color(FL_BACKGROUND_COLOR);
        cntKmlRefreshInterval->labeltype(FL_NORMAL_LABEL);
        cntKmlRefreshInterval->labelfont(0);
        cntKmlRefreshInterval->labelsize(14);
        cntKmlRefreshInterval->labelcolor(FL_FOREGROUND_COLOR);
        cntKmlRefreshInterval->value(10);
        cntKmlRefreshInterval->callback((Fl_Callback*)cb_cntKmlRefreshInterval);
        cntKmlRefreshInterval->align(Fl_Align(FL_ALIGN_RIGHT));
        cntKmlRefreshInterval->when(FL_WHEN_RELEASE);
        o->minimum(1); o->maximum(3600); o->step(1);
        o->value(progdefaults.kml_refresh_interval);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Spinner2* cntKmlRefreshInterval
      { Fl_ListBox* o = listbox_kml_balloon_style = new Fl_ListBox(230, 235, 201, 24, gettext("KML balloon display style"));
        listbox_kml_balloon_style->tooltip(gettext("KML balloon in plain text, or HTML, in plain tables or matrices."));
        listbox_kml_balloon_style->box(FL_DOWN_BOX);
        listbox_kml_balloon_style->color(FL_BACKGROUND2_COLOR);
        listbox_kml_balloon_style->selection_color(FL_BACKGROUND_COLOR);
        listbox_kml_balloon_style->labeltype(FL_NORMAL_LABEL);
        listbox_kml_balloon_style->labelfont(0);
        listbox_kml_balloon_style->labelsize(14);
        listbox_kml_balloon_style->labelcolor(FL_FOREGROUND_COLOR);
        listbox_kml_balloon_style->callback((Fl_Callback*)cb_listbox_kml_balloon_style);
        listbox_kml_balloon_style->align(Fl_Align(FL_ALIGN_RIGHT));
        listbox_kml_balloon_style->when(FL_WHEN_CHANGED);
        o->add("Plain text|HTML tables|Single HTML matrix");o->index(progdefaults.kml_balloon_style);
        o->labelsize(FL_NORMAL_SIZE);
        listbox_kml_balloon_style->end();
      } // Fl_ListBox* listbox_kml_balloon_style
      { Fl_Input* o = btnKmlCommand = new Fl_Input(230, 271, 246, 24, gettext("Command run on KML creation"));
        btnKmlCommand->tooltip(gettext("Command started when KML files are generated. Subprocesses are started once, "
"and restarted if needed."));
        btnKmlCommand->callback((Fl_Callback*)cb_btnKmlCommand);
        btnKmlCommand->align(Fl_Align(72));
        o->value(progdefaults.kml_command.c_str());
      } // Fl_Input* btnKmlCommand
      { btlTestKmlCommand = new Fl_Button(230, 307, 191, 24, gettext("Test command"));
        btlTestKmlCommand->tooltip(gettext("Execute command on KML files."));
        btlTestKmlCommand->callback((Fl_Callback*)cb_btlTestKmlCommand);
      } // Fl_Button* btlTestKmlCommand
      { btnSelectKmlDestDir = new Fl_Button(631, 47, 101, 24, gettext("Change dir..."));
        btnSelectKmlDestDir->tooltip(gettext("Choose directory to store KML documents"));
        btnSelectKmlDestDir->callback((Fl_Callback*)cb_btnSelectKmlDestDir);
      } // Fl_Button* btnSelectKmlDestDir
      { btlPurge = new Fl_Button(542, 91, 190, 24, gettext("Cleanup KML data now !"));
        btlPurge->tooltip(gettext("Cleanups KML documents, empties Google Earth display."));
        btlPurge->callback((Fl_Callback*)cb_btlPurge);
      } // Fl_Button* btlPurge
      { Fl_Check_Button* o = btnKmlPurgeOnStartup = new Fl_Check_Button(528, 203, 172, 15, gettext("Cleanup on startup"));
        btnKmlPurgeOnStartup->tooltip(gettext("Empties KML documents when starting program."));
        btnKmlPurgeOnStartup->down_box(FL_DOWN_BOX);
        btnKmlPurgeOnStartup->callback((Fl_Callback*)cb_btnKmlPurgeOnStartup);
        o->value(progdefaults.kml_purge_on_startup);
      } // Fl_Check_Button* btnKmlPurgeOnStartup
      { Fl_Group* o = new Fl_Group(475, 301, 310, 40);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btn_kml_enabled = new Fl_Check_Button(497, 311, 242, 19, gettext("KML server enabled (On / Off)"));
          btn_kml_enabled->tooltip(gettext("Uncheck if KML is never used"));
          btn_kml_enabled->down_box(FL_DOWN_BOX);
          btn_kml_enabled->callback((Fl_Callback*)cb_btn_kml_enabled);
          o->value(progdefaults.kml_enabled);
        } // Fl_Check_Button* btn_kml_enabled
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/KML"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/KML"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/NBEMS interface"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(251, 35, 500, 75, gettext("NBEMS data file interface"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chkAutoExtract = new Fl_Check_Button(305, 66, 75, 20, gettext("Enable"));
          chkAutoExtract->tooltip(gettext("Extract files for use with external \"wrap / flmsg\" program"));
          chkAutoExtract->down_box(FL_DOWN_BOX);
          chkAutoExtract->callback((Fl_Callback*)cb_chkAutoExtract);
          o->value(progdefaults.autoextract);
        } // Fl_Check_Button* chkAutoExtract
        { Fl_Check_Button* o = chk_open_wrap_folder = new Fl_Check_Button(511, 66, 146, 20, gettext("Open message folder"));
          chk_open_wrap_folder->tooltip(gettext("Opens NBEMS file folder upon successful capture"));
          chk_open_wrap_folder->down_box(FL_DOWN_BOX);
          chk_open_wrap_folder->callback((Fl_Callback*)cb_chk_open_wrap_folder);
          o->value(progdefaults.open_nbems_folder);
        } // Fl_Check_Button* chk_open_wrap_folder
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(251, 111, 500, 199, gettext("Reception of flmsg files"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chk_open_flmsg = new Fl_Check_Button(305, 211, 136, 20, gettext("Open with flmsg"));
          chk_open_flmsg->tooltip(gettext("Open message with flmsg"));
          chk_open_flmsg->down_box(FL_DOWN_BOX);
          chk_open_flmsg->callback((Fl_Callback*)cb_chk_open_flmsg);
          o->value(progdefaults.open_flmsg);
        } // Fl_Check_Button* chk_open_flmsg
        { Fl_Check_Button* o = chk_open_flmsg_print = new Fl_Check_Button(511, 211, 136, 20, gettext("Open in browser"));
          chk_open_flmsg_print->tooltip(gettext("Open file with default browser"));
          chk_open_flmsg_print->down_box(FL_DOWN_BOX);
          chk_open_flmsg_print->callback((Fl_Callback*)cb_chk_open_flmsg_print);
          o->value(progdefaults.open_flmsg_print);
        } // Fl_Check_Button* chk_open_flmsg_print
        { Fl_Input2* o = txt_flmsg_pathname = new Fl_Input2(305, 241, 330, 24, gettext("flmsg:"));
          txt_flmsg_pathname->tooltip(gettext("Enter full path-filename for flmsg"));
          txt_flmsg_pathname->box(FL_DOWN_BOX);
          txt_flmsg_pathname->color(FL_BACKGROUND2_COLOR);
          txt_flmsg_pathname->selection_color(FL_SELECTION_COLOR);
          txt_flmsg_pathname->labeltype(FL_NORMAL_LABEL);
          txt_flmsg_pathname->labelfont(0);
          txt_flmsg_pathname->labelsize(14);
          txt_flmsg_pathname->labelcolor(FL_FOREGROUND_COLOR);
          txt_flmsg_pathname->callback((Fl_Callback*)cb_txt_flmsg_pathname);
          txt_flmsg_pathname->align(Fl_Align(FL_ALIGN_LEFT));
          txt_flmsg_pathname->when(FL_WHEN_CHANGED);
          o->value(progdefaults.flmsg_pathname.c_str());
        } // Fl_Input2* txt_flmsg_pathname
        { btn_select_flmsg = new Fl_Button(642, 241, 100, 24, gettext("Locate flmsg"));
          btn_select_flmsg->tooltip(gettext("Locate flmsg executable"));
          btn_select_flmsg->callback((Fl_Callback*)cb_btn_select_flmsg);
        } // Fl_Button* btn_select_flmsg
        { Fl_Value_Slider* o = sldr_extract_timeout = new Fl_Value_Slider(271, 279, 364, 21, gettext("Timeout (secs)"));
          sldr_extract_timeout->tooltip(gettext("Extract times out after NN seconds of inactivity."));
          sldr_extract_timeout->type(5);
          sldr_extract_timeout->color(FL_LIGHT3);
          sldr_extract_timeout->selection_color(FL_FOREGROUND_COLOR);
          sldr_extract_timeout->minimum(1);
          sldr_extract_timeout->maximum(20);
          sldr_extract_timeout->step(0.5);
          sldr_extract_timeout->value(10);
          sldr_extract_timeout->textsize(14);
          sldr_extract_timeout->callback((Fl_Callback*)cb_sldr_extract_timeout);
          sldr_extract_timeout->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.extract_timeout);
        } // Fl_Value_Slider* sldr_extract_timeout
        { Fl_Group* o = new Fl_Group(256, 130, 490, 76, gettext("Selection of transfer direct takes precedence\nover all other flmsg reception"
" settings"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { Fl_Check_Button* o = chk_transfer__to_open_flmsg = new Fl_Check_Button(361, 174, 271, 20, gettext("Transfer direct to executing flmsg"));
            chk_transfer__to_open_flmsg->tooltip(gettext("Send data stream directly to executing flmsg"));
            chk_transfer__to_open_flmsg->down_box(FL_DOWN_BOX);
            chk_transfer__to_open_flmsg->callback((Fl_Callback*)cb_chk_transfer__to_open_flmsg);
            o->value(progdefaults.flmsg_transfer_direct);
          } // Fl_Check_Button* chk_transfer__to_open_flmsg
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/NBEMS interface"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/NBEMS interface"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/PSK reporter"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { btnPSKRepAuto = new Fl_Check_Button(252, 65, 324, 20, gettext("Automatically spot callsigns in decoded text"));
        btnPSKRepAuto->tooltip(gettext("Parse all incoming text"));
        btnPSKRepAuto->down_box(FL_DOWN_BOX);
        btnPSKRepAuto->callback((Fl_Callback*)cb_btnPSKRepAuto);
        btnPSKRepAuto->value(progdefaults.pskrep_auto);
      } // Fl_Check_Button* btnPSKRepAuto
      { btnPSKRepLog = new Fl_Check_Button(252, 96, 327, 20, gettext("Send reception report when logging a QSO"));
        btnPSKRepLog->tooltip(gettext("Send report only when QSO is logged"));
        btnPSKRepLog->down_box(FL_DOWN_BOX);
        btnPSKRepLog->callback((Fl_Callback*)cb_btnPSKRepLog);
        btnPSKRepLog->value(progdefaults.pskrep_log);
      } // Fl_Check_Button* btnPSKRepLog
      { btnPSKRepQRG = new Fl_Check_Button(252, 128, 416, 20, gettext("Report rig frequency (enable only if you have rig control!)"));
        btnPSKRepQRG->tooltip(gettext("Include the transmit frequency"));
        btnPSKRepQRG->down_box(FL_DOWN_BOX);
        btnPSKRepQRG->callback((Fl_Callback*)cb_btnPSKRepQRG);
        btnPSKRepQRG->value(progdefaults.pskrep_qrg);
      } // Fl_Check_Button* btnPSKRepQRG
      { Fl_Check_Button* o = btn_report_when_visible = new Fl_Check_Button(252, 160, 416, 20, gettext("Disable spotting when signal browser(s) are not visible."));
        btn_report_when_visible->tooltip(gettext("Check to reduce CPU load in PSK and RTTY modes."));
        btn_report_when_visible->down_box(FL_DOWN_BOX);
        btn_report_when_visible->value(1);
        btn_report_when_visible->callback((Fl_Callback*)cb_btn_report_when_visible);
        o->value(progdefaults.report_when_visible);
      } // Fl_Check_Button* btn_report_when_visible
      { Fl_Check_Button* o = btn_pskrep_autostart = new Fl_Check_Button(252, 192, 291, 20, gettext("Log on to pskrep when starting fldigi"));
        btn_pskrep_autostart->tooltip(gettext("Automatically start psk reporter socket connection"));
        btn_pskrep_autostart->down_box(FL_DOWN_BOX);
        btn_pskrep_autostart->callback((Fl_Callback*)cb_btn_pskrep_autostart);
        o->value(progdefaults.pskrep_autostart);
      } // Fl_Check_Button* btn_pskrep_autostart
      { box_connected_to_pskrep = new Fl_Box(562, 193, 18, 18, gettext("Connected"));
        box_connected_to_pskrep->box(FL_DIAMOND_DOWN_BOX);
        box_connected_to_pskrep->color(FL_BACKGROUND2_COLOR);
        box_connected_to_pskrep->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Box* box_connected_to_pskrep
      { inpPSKRepHost = new Fl_Input2(295, 230, 220, 24, gettext("Host:"));
        inpPSKRepHost->tooltip(gettext("To whom the connection is made"));
        inpPSKRepHost->box(FL_DOWN_BOX);
        inpPSKRepHost->color(FL_BACKGROUND2_COLOR);
        inpPSKRepHost->selection_color(FL_SELECTION_COLOR);
        inpPSKRepHost->labeltype(FL_NORMAL_LABEL);
        inpPSKRepHost->labelfont(0);
        inpPSKRepHost->labelsize(14);
        inpPSKRepHost->labelcolor(FL_FOREGROUND_COLOR);
        inpPSKRepHost->callback((Fl_Callback*)cb_inpPSKRepHost);
        inpPSKRepHost->align(Fl_Align(FL_ALIGN_LEFT));
        inpPSKRepHost->when(FL_WHEN_CHANGED);
        inpPSKRepHost->value(progdefaults.pskrep_host.c_str());
        inpPSKRepHost->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpPSKRepHost
      { inpPSKRepPort = new Fl_Input2(664, 230, 60, 24, gettext("Port:"));
        inpPSKRepPort->tooltip(gettext("Using UDP port #"));
        inpPSKRepPort->box(FL_DOWN_BOX);
        inpPSKRepPort->color(FL_BACKGROUND2_COLOR);
        inpPSKRepPort->selection_color(FL_SELECTION_COLOR);
        inpPSKRepPort->labeltype(FL_NORMAL_LABEL);
        inpPSKRepPort->labelfont(0);
        inpPSKRepPort->labelsize(14);
        inpPSKRepPort->labelcolor(FL_FOREGROUND_COLOR);
        inpPSKRepPort->callback((Fl_Callback*)cb_inpPSKRepPort);
        inpPSKRepPort->align(Fl_Align(FL_ALIGN_LEFT));
        inpPSKRepPort->when(FL_WHEN_CHANGED);
        inpPSKRepPort->value(progdefaults.pskrep_port.c_str());
        inpPSKRepPort->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpPSKRepPort
      { btnPSKRepInit = new Fl_Button(644, 275, 80, 24, gettext("Initialize"));
        btnPSKRepInit->tooltip(gettext("Initialize the socket client"));
        btnPSKRepInit->callback((Fl_Callback*)cb_btnPSKRepInit);
      } // Fl_Button* btnPSKRepInit
      { boxPSKRepMsg = new Fl_Box(254, 259, 300, 48, gettext("<PSK Reporter error message>"));
        boxPSKRepMsg->labelfont(2);
        boxPSKRepMsg->label(0);
      } // Fl_Box* boxPSKRepMsg
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/PSK reporter"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/PSK reporter"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/PSM"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(204, 32, 590, 108);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cntBusyChannelSeconds = new Fl_Counter(380, 38, 110, 20, gettext("Allow TX After Signal Detection (Secs)"));
          cntBusyChannelSeconds->tooltip(gettext("Allow transmits after \'N\' seconds of a signal detection."));
          cntBusyChannelSeconds->minimum(1);
          cntBusyChannelSeconds->maximum(999);
          cntBusyChannelSeconds->step(1);
          cntBusyChannelSeconds->value(1);
          cntBusyChannelSeconds->callback((Fl_Callback*)cb_cntBusyChannelSeconds);
          cntBusyChannelSeconds->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.busyChannelSeconds);
          o->step(1,10);
        } // Fl_Counter* cntBusyChannelSeconds
        { Fl_Check_Button* o = btnEnableBusyChannel = new Fl_Check_Button(210, 40, 115, 20, gettext("Enable Busy Channel"));
          btnEnableBusyChannel->tooltip(gettext("Enable to inhibit TX on signal Detections"));
          btnEnableBusyChannel->down_box(FL_DOWN_BOX);
          btnEnableBusyChannel->callback((Fl_Callback*)cb_btnEnableBusyChannel);
          if(progdefaults.enableBusyChannel) o->value(true);
          else o->value(false);
        } // Fl_Check_Button* btnEnableBusyChannel
        { Fl_Counter* o = cntPSMTXBufferFlushTimer = new Fl_Counter(380, 63, 110, 20, gettext("TX Buffer Flush Timer (Mins, 0=Disable)"));
          cntPSMTXBufferFlushTimer->tooltip(gettext("Flushes the TX buffer after x period when Busy Channel remains on (TX inhibit"
"ed)"));
          cntPSMTXBufferFlushTimer->minimum(1);
          cntPSMTXBufferFlushTimer->maximum(999);
          cntPSMTXBufferFlushTimer->step(1);
          cntPSMTXBufferFlushTimer->value(1);
          cntPSMTXBufferFlushTimer->callback((Fl_Callback*)cb_cntPSMTXBufferFlushTimer);
          cntPSMTXBufferFlushTimer->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.psm_flush_buffer_timeout);
          o->step(1,10); o->minimum(0); o->maximum(999);
        } // Fl_Counter* cntPSMTXBufferFlushTimer
        { Fl_Counter* o = cntPSMBandwidthMargins = new Fl_Counter(380, 88, 110, 20, gettext("Modem Bandwidth Margins "));
          cntPSMBandwidthMargins->tooltip(gettext("Monitor signals in modem bandwitdh plus margins."));
          cntPSMBandwidthMargins->minimum(1);
          cntPSMBandwidthMargins->maximum(999);
          cntPSMBandwidthMargins->step(1);
          cntPSMBandwidthMargins->value(1);
          cntPSMBandwidthMargins->callback((Fl_Callback*)cb_cntPSMBandwidthMargins);
          cntPSMBandwidthMargins->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.psm_minimum_bandwidth_margin);
          o->step(1,10);
        } // Fl_Counter* cntPSMBandwidthMargins
        { Fl_Counter* o = cntPSMValidSamplePeriod = new Fl_Counter(380, 114, 110, 20, gettext("Valid Signal Sample Period (msecs)"));
          cntPSMValidSamplePeriod->tooltip(gettext("Valid signal sample period in Milliseconds"));
          cntPSMValidSamplePeriod->minimum(1);
          cntPSMValidSamplePeriod->maximum(999);
          cntPSMValidSamplePeriod->step(1);
          cntPSMValidSamplePeriod->value(1);
          cntPSMValidSamplePeriod->callback((Fl_Callback*)cb_cntPSMValidSamplePeriod);
          cntPSMValidSamplePeriod->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.psm_hit_time_window);
          o->step(1,10);
        } // Fl_Counter* cntPSMValidSamplePeriod
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(204, 140, 590, 84);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnEnable_csma = new Fl_Check_Button(214, 148, 114, 20, gettext("Enable CSMA"));
          btnEnable_csma->tooltip(gettext("Carrier Sense Mulitiple Access"));
          btnEnable_csma->down_box(FL_DOWN_BOX);
          btnEnable_csma->callback((Fl_Callback*)cb_btnEnable_csma);
          if(progdefaults.csma_enabled) o->value(true);
        } // Fl_Check_Button* btnEnable_csma
        { Fl_Counter* o = cntPersistance = new Fl_Counter(333, 148, 110, 20, gettext("Persistance"));
          cntPersistance->tooltip(gettext("Used to adjust the aggressiveness of TX"));
          cntPersistance->minimum(1);
          cntPersistance->maximum(999);
          cntPersistance->step(1);
          cntPersistance->value(1);
          cntPersistance->callback((Fl_Callback*)cb_cntPersistance);
          cntPersistance->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.csma_persistance);
          o->step(1,10); o->minimum(0); o->maximum(255);
        } // Fl_Counter* cntPersistance
        { Fl_Counter* o = cntSlotTime = new Fl_Counter(333, 173, 110, 20, gettext("Slot Time"));
          cntSlotTime->tooltip(gettext("Non transmit window after a transmit period"));
          cntSlotTime->minimum(1);
          cntSlotTime->maximum(999);
          cntSlotTime->step(1);
          cntSlotTime->value(1);
          cntSlotTime->callback((Fl_Callback*)cb_cntSlotTime);
          cntSlotTime->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.csma_slot_time);
          o->step(1,10); o->minimum(1); o->maximum(255);
        } // Fl_Counter* cntSlotTime
        { Fl_Counter* o = cntTransmitDelay = new Fl_Counter(333, 198, 110, 20, gettext("Transmit Data Delay"));
          cntTransmitDelay->tooltip(gettext("Idle transmit before data sent"));
          cntTransmitDelay->minimum(1);
          cntTransmitDelay->maximum(999);
          cntTransmitDelay->step(1);
          cntTransmitDelay->value(1);
          cntTransmitDelay->callback((Fl_Callback*)cb_cntTransmitDelay);
          cntTransmitDelay->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.csma_transmit_delay);
          o->step(1,10); o->minimum(1); o->maximum(255);
        } // Fl_Counter* cntTransmitDelay
        { OutputSlotTimeMS = new Fl_Output(599, 173, 95, 20, gettext("MilliSeconds"));
          OutputSlotTimeMS->tooltip(gettext("Displays the Slot Time in Milliseconds"));
          OutputSlotTimeMS->align(Fl_Align(FL_ALIGN_RIGHT));
        } // Fl_Output* OutputSlotTimeMS
        { OutputTransmitDelayMS = new Fl_Output(599, 198, 95, 20, gettext("MilliSeconds"));
          OutputTransmitDelayMS->tooltip(gettext("Displays the Transmit Delay in Milliseconds"));
          OutputTransmitDelayMS->align(Fl_Align(FL_ALIGN_RIGHT));
        } // Fl_Output* OutputTransmitDelayMS
        { OutputPersistancePercent = new Fl_Output(599, 147, 95, 20, gettext("Percent (%)"));
          OutputPersistancePercent->tooltip(gettext("Displays the Slot Time in Milliseconds"));
          OutputPersistancePercent->align(Fl_Align(FL_ALIGN_RIGHT));
        } // Fl_Output* OutputPersistancePercent
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(204, 223, 590, 31);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnEnable_histogram = new Fl_Check_Button(216, 230, 139, 20, gettext("Enable Histogram"));
          btnEnable_histogram->tooltip(gettext("Enable Histogram threshold signal monitoring"));
          btnEnable_histogram->down_box(FL_DOWN_BOX);
          btnEnable_histogram->callback((Fl_Callback*)cb_btnEnable_histogram);
          if(progdefaults.psm_use_histogram) o->value(true);
        } // Fl_Check_Button* btnEnable_histogram
        { Fl_Counter* o = cntPSMThreshold = new Fl_Counter(380, 230, 110, 20, gettext("PSM Histogram Threshold"));
          cntPSMThreshold->tooltip(gettext("Sets the theshold level to x value above the noise level"));
          cntPSMThreshold->minimum(1);
          cntPSMThreshold->maximum(999);
          cntPSMThreshold->step(1);
          cntPSMThreshold->value(1);
          cntPSMThreshold->callback((Fl_Callback*)cb_cntPSMThreshold);
          cntPSMThreshold->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.psm_histogram_offset_threshold);
          o->step(1,10); o->minimum(1); o->maximum(20);
        } // Fl_Counter* cntPSMThreshold
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(204, 254, 590, 34);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cntKPSQLAttenuation = new Fl_Counter(380, 261, 110, 20, gettext("PSM Attenuate"));
          cntKPSQLAttenuation->tooltip(gettext("Adjust sensitivity by 1/N fractional values."));
          cntKPSQLAttenuation->minimum(1);
          cntKPSQLAttenuation->maximum(999);
          cntKPSQLAttenuation->step(1);
          cntKPSQLAttenuation->value(1);
          cntKPSQLAttenuation->callback((Fl_Callback*)cb_cntKPSQLAttenuation);
          cntKPSQLAttenuation->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.kpsql_attenuation);
          o->step(1,10); o->minimum(1); o->maximum(999);
          update_kpsql_fractional_gain(progdefaults.kpsql_attenuation);
        } // Fl_Counter* cntKPSQLAttenuation
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(204, 287, 590, 28);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_show_psm_button = new Fl_Check_Button(214, 291, 150, 20, gettext("Show and enable Power Signal Monitor button (PSM)"));
          btn_show_psm_button->tooltip(gettext("display PSM button on main dialog"));
          btn_show_psm_button->down_box(FL_DOWN_BOX);
          btn_show_psm_button->callback((Fl_Callback*)cb_btn_show_psm_button);
          o->value(progdefaults.show_psm_btn);
        } // Fl_Check_Button* btn_show_psm_button
        o->end();
      } // Fl_Group* o
      { btnBuyChannelDefaults = new Fl_Button(669, 320, 126, 22, gettext("Default Settings"));
        btnBuyChannelDefaults->callback((Fl_Callback*)cb_btnBuyChannelDefaults);
      } // Fl_Button* btnBuyChannelDefaults
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/PSM"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/PSM"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/Rx text capture"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { grpTalker = new Fl_Group(252, 107, 490, 73, gettext("Talker Socket (MS only)"));
        grpTalker->box(FL_ENGRAVED_FRAME);
        grpTalker->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btnConnectTalker = new Fl_Light_Button(278, 127, 74, 20, gettext("Talker"));
          btnConnectTalker->selection_color(FL_DARK_GREEN);
          btnConnectTalker->callback((Fl_Callback*)cb_btnConnectTalker);
        } // Fl_Light_Button* btnConnectTalker
        { Fl_Box* o = new Fl_Box(357, 127, 345, 20, gettext("Connect/disconnect to Talker socket server"));
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Check_Button* o = btn_auto_talk = new Fl_Check_Button(278, 155, 391, 15, gettext("Auto connect when fldigi opens (server must be up)"));
          btn_auto_talk->down_box(FL_DOWN_BOX);
          btn_auto_talk->callback((Fl_Callback*)cb_btn_auto_talk);
          o->value(progdefaults.auto_talk);
        } // Fl_Check_Button* btn_auto_talk
        grpTalker->end();
      } // Fl_Group* grpTalker
      { Fl_Group* o = new Fl_Group(252, 47, 490, 56, gettext("Capture rx text to external file"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chkRxStream = new Fl_Check_Button(278, 74, 175, 20, gettext("Enable rx text stream"));
          chkRxStream->tooltip(gettext("Send rx text to file: textout.txt"));
          chkRxStream->down_box(FL_DOWN_BOX);
          chkRxStream->callback((Fl_Callback*)cb_chkRxStream);
          o->value(progdefaults.speak);
        } // Fl_Check_Button* chkRxStream
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/Rx text capture"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/Rx text capture"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/Save Parameters"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Box* o = new Fl_Box(211, 28, 575, 39, gettext("Enable specific parameter to Save & Restore on a per mode/band basis."));
        o->box(FL_ENGRAVED_BOX);
        o->color((Fl_Color)53);
        o->labelsize(13);
        o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Check_Button* o = btnTXLEVEL_by_mode = new Fl_Check_Button(360, 96, 235, 30, gettext("Transmit level control"));
        btnTXLEVEL_by_mode->tooltip(gettext("Save transmit level control by mode"));
        btnTXLEVEL_by_mode->down_box(FL_DOWN_BOX);
        btnTXLEVEL_by_mode->value(1);
        btnTXLEVEL_by_mode->callback((Fl_Callback*)cb_btnTXLEVEL_by_mode);
        o->value(progdefaults.txlevel_by_mode);
      } // Fl_Check_Button* btnTXLEVEL_by_mode
      { Fl_Check_Button* o = btnSQLCH_by_mode = new Fl_Check_Button(360, 140, 270, 30, gettext("Squelch level/activated control(s)"));
        btnSQLCH_by_mode->tooltip(gettext("Save Squelch level and state by mode"));
        btnSQLCH_by_mode->down_box(FL_DOWN_BOX);
        btnSQLCH_by_mode->value(1);
        btnSQLCH_by_mode->callback((Fl_Callback*)cb_btnSQLCH_by_mode);
        o->value(progdefaults.sqlch_by_mode);
      } // Fl_Check_Button* btnSQLCH_by_mode
      { Fl_Check_Button* o = btnAFC_by_mode = new Fl_Check_Button(360, 184, 270, 30, gettext("AFC control"));
        btnAFC_by_mode->tooltip(gettext("Save AFC state by mode"));
        btnAFC_by_mode->down_box(FL_DOWN_BOX);
        btnAFC_by_mode->value(1);
        btnAFC_by_mode->callback((Fl_Callback*)cb_btnAFC_by_mode);
        o->value(progdefaults.afc_by_mode);
      } // Fl_Check_Button* btnAFC_by_mode
      { Fl_Check_Button* o = btnREVERSE_by_mode = new Fl_Check_Button(360, 228, 270, 30, gettext("Reverse (Rv) control"));
        btnREVERSE_by_mode->tooltip(gettext("Save Reverse state by mode"));
        btnREVERSE_by_mode->down_box(FL_DOWN_BOX);
        btnREVERSE_by_mode->value(1);
        btnREVERSE_by_mode->callback((Fl_Callback*)cb_btnREVERSE_by_mode);
        o->value(progdefaults.reverse_by_mode);
      } // Fl_Check_Button* btnREVERSE_by_mode
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/Save Parameters"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/Save Parameters"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/Sweet Spot"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(253, 70, 490, 75);
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Value_Input2* o = valCWsweetspot = new Fl_Value_Input2(290, 81, 65, 20, gettext("CW"));
          valCWsweetspot->tooltip(gettext("Default CW tracking point"));
          valCWsweetspot->box(FL_DOWN_BOX);
          valCWsweetspot->color(FL_BACKGROUND2_COLOR);
          valCWsweetspot->selection_color(FL_SELECTION_COLOR);
          valCWsweetspot->labeltype(FL_NORMAL_LABEL);
          valCWsweetspot->labelfont(0);
          valCWsweetspot->labelsize(14);
          valCWsweetspot->labelcolor(FL_FOREGROUND_COLOR);
          valCWsweetspot->minimum(200);
          valCWsweetspot->maximum(4000);
          valCWsweetspot->step(1);
          valCWsweetspot->value(1000);
          valCWsweetspot->callback((Fl_Callback*)cb_valCWsweetspot);
          valCWsweetspot->align(Fl_Align(FL_ALIGN_LEFT));
          valCWsweetspot->when(FL_WHEN_CHANGED);
          o->value(progdefaults.CWsweetspot);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* valCWsweetspot
        { Fl_Value_Input2* o = valRTTYsweetspot = new Fl_Value_Input2(468, 81, 65, 20, gettext("RTTY"));
          valRTTYsweetspot->tooltip(gettext("Default RTTY tracking point"));
          valRTTYsweetspot->box(FL_DOWN_BOX);
          valRTTYsweetspot->color(FL_BACKGROUND2_COLOR);
          valRTTYsweetspot->selection_color(FL_SELECTION_COLOR);
          valRTTYsweetspot->labeltype(FL_NORMAL_LABEL);
          valRTTYsweetspot->labelfont(0);
          valRTTYsweetspot->labelsize(14);
          valRTTYsweetspot->labelcolor(FL_FOREGROUND_COLOR);
          valRTTYsweetspot->minimum(200);
          valRTTYsweetspot->maximum(4000);
          valRTTYsweetspot->step(1);
          valRTTYsweetspot->value(1000);
          valRTTYsweetspot->callback((Fl_Callback*)cb_valRTTYsweetspot);
          valRTTYsweetspot->align(Fl_Align(FL_ALIGN_LEFT));
          valRTTYsweetspot->when(FL_WHEN_CHANGED);
          o->value(progdefaults.RTTYsweetspot);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* valRTTYsweetspot
        { Fl_Value_Input2* o = valPSKsweetspot = new Fl_Value_Input2(668, 81, 65, 20, gettext("PSK et al."));
          valPSKsweetspot->tooltip(gettext("Default for all other modems"));
          valPSKsweetspot->box(FL_DOWN_BOX);
          valPSKsweetspot->color(FL_BACKGROUND2_COLOR);
          valPSKsweetspot->selection_color(FL_SELECTION_COLOR);
          valPSKsweetspot->labeltype(FL_NORMAL_LABEL);
          valPSKsweetspot->labelfont(0);
          valPSKsweetspot->labelsize(14);
          valPSKsweetspot->labelcolor(FL_FOREGROUND_COLOR);
          valPSKsweetspot->minimum(200);
          valPSKsweetspot->maximum(4000);
          valPSKsweetspot->step(1);
          valPSKsweetspot->value(1000);
          valPSKsweetspot->callback((Fl_Callback*)cb_valPSKsweetspot);
          valPSKsweetspot->align(Fl_Align(FL_ALIGN_LEFT));
          valPSKsweetspot->when(FL_WHEN_CHANGED);
          o->value(progdefaults.PSKsweetspot);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* valPSKsweetspot
        { Fl_Check_Button* o = btnStartAtSweetSpot = new Fl_Check_Button(263, 111, 348, 20, gettext("Always start new modems at these frequencies"));
          btnStartAtSweetSpot->tooltip(gettext("ON - start at default\nOFF - keep current wf cursor position"));
          btnStartAtSweetSpot->down_box(FL_DOWN_BOX);
          btnStartAtSweetSpot->value(1);
          btnStartAtSweetSpot->callback((Fl_Callback*)cb_btnStartAtSweetSpot);
          o->value(progdefaults.StartAtSweetSpot);
        } // Fl_Check_Button* btnStartAtSweetSpot
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(253, 150, 490, 60, gettext("K3 A1A configuation"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnCWIsLSB = new Fl_Check_Button(468, 171, 70, 15, gettext("CW is LSB"));
          btnCWIsLSB->tooltip(gettext("Select this for Elecraft K3\nOther radios should not need it."));
          btnCWIsLSB->down_box(FL_DOWN_BOX);
          btnCWIsLSB->callback((Fl_Callback*)cb_btnCWIsLSB);
          o->value(progdefaults.CWIsLSB);
        } // Fl_Check_Button* btnCWIsLSB
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/Sweet Spot"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/Sweet Spot"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Misc/TCP-IP sessions"));
      o->box(FL_ENGRAVED_BOX);
      o->callback((Fl_Callback*)cb_Misc);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 18, 588, 102);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnDisable_p2p_io_widgets = new Fl_Check_Button(211, 96, 85, 20, gettext("Lock"));
          btnDisable_p2p_io_widgets->tooltip(gettext("Allow/Disallow Changes"));
          btnDisable_p2p_io_widgets->down_box(FL_DOWN_BOX);
          btnDisable_p2p_io_widgets->callback((Fl_Callback*)cb_btnDisable_p2p_io_widgets);
          o->value(progStatus.ip_lock);
        } // Fl_Check_Button* btnDisable_p2p_io_widgets
        { Fl_Check_Button* o = btnEnable_arq = new Fl_Check_Button(295, 96, 115, 20, gettext("Enable ARQ"));
          btnEnable_arq->tooltip(gettext("Used For PSKMail and FLDIGI Suite of Programs"));
          btnEnable_arq->type(102);
          btnEnable_arq->down_box(FL_DOWN_BOX);
          btnEnable_arq->callback((Fl_Callback*)cb_btnEnable_arq);
          if(progStatus.data_io_enabled == ARQ_IO) o->value(true);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnEnable_arq
        { Fl_Check_Button* o = btnEnable_kiss = new Fl_Check_Button(420, 96, 115, 20, gettext("Enable KISS"));
          btnEnable_kiss->tooltip(gettext("Used for BPQ32"));
          btnEnable_kiss->type(102);
          btnEnable_kiss->down_box(FL_DOWN_BOX);
          btnEnable_kiss->callback((Fl_Callback*)cb_btnEnable_kiss);
          if(progStatus.data_io_enabled == KISS_IO) o->value(true);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnEnable_kiss
        { new Fl_Box(207, 21, 582, 72, gettext("Enable ARQ for programs that support TCP and FLDIGI ARQ protocol.\nEnable KIS"
"S for programs that supports TCP/UDP and TNC-2 KISS protocol.\nOnly one interf"
"ace (ARQ/KISS) can be active at any given time.\nKISS/ARQ/XML Addr/Port change"
"s require program restart."));
        } // Fl_Box* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 122, 588, 80, gettext("KISS"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Input2* o = txtKiss_ip_address = new Fl_Input2(254, 175, 230, 22, gettext("Addr"));
          txtKiss_ip_address->tooltip(gettext("IP Address for KISS interface\nIP Address format: nnn.nnn.nnn.nnn\nor name: i"
".e. localhost"));
          txtKiss_ip_address->box(FL_DOWN_BOX);
          txtKiss_ip_address->color(FL_BACKGROUND2_COLOR);
          txtKiss_ip_address->selection_color(FL_SELECTION_COLOR);
          txtKiss_ip_address->labeltype(FL_NORMAL_LABEL);
          txtKiss_ip_address->labelfont(0);
          txtKiss_ip_address->labelsize(14);
          txtKiss_ip_address->labelcolor(FL_FOREGROUND_COLOR);
          txtKiss_ip_address->callback((Fl_Callback*)cb_txtKiss_ip_address);
          txtKiss_ip_address->align(Fl_Align(FL_ALIGN_RIGHT));
          txtKiss_ip_address->when(FL_WHEN_CHANGED);
          txtKiss_ip_address->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.kiss_address.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txtKiss_ip_address
        { Fl_Input2* o = txtKiss_ip_io_port_no = new Fl_Input2(529, 175, 55, 22, gettext("I/O"));
          txtKiss_ip_io_port_no->tooltip(gettext("IP Address Port Number"));
          txtKiss_ip_io_port_no->box(FL_DOWN_BOX);
          txtKiss_ip_io_port_no->color(FL_BACKGROUND2_COLOR);
          txtKiss_ip_io_port_no->selection_color(FL_SELECTION_COLOR);
          txtKiss_ip_io_port_no->labeltype(FL_NORMAL_LABEL);
          txtKiss_ip_io_port_no->labelfont(0);
          txtKiss_ip_io_port_no->labelsize(14);
          txtKiss_ip_io_port_no->labelcolor(FL_FOREGROUND_COLOR);
          txtKiss_ip_io_port_no->callback((Fl_Callback*)cb_txtKiss_ip_io_port_no);
          txtKiss_ip_io_port_no->align(Fl_Align(FL_ALIGN_RIGHT));
          txtKiss_ip_io_port_no->when(FL_WHEN_CHANGED);
          txtKiss_ip_io_port_no->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.kiss_io_port.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txtKiss_ip_io_port_no
        { Fl_Input2* o = txtKiss_ip_out_port_no = new Fl_Input2(621, 175, 55, 22, gettext("O"));
          txtKiss_ip_out_port_no->tooltip(gettext("Output port number when same IP address used"));
          txtKiss_ip_out_port_no->box(FL_DOWN_BOX);
          txtKiss_ip_out_port_no->color(FL_BACKGROUND2_COLOR);
          txtKiss_ip_out_port_no->selection_color(FL_SELECTION_COLOR);
          txtKiss_ip_out_port_no->labeltype(FL_NORMAL_LABEL);
          txtKiss_ip_out_port_no->labelfont(0);
          txtKiss_ip_out_port_no->labelsize(14);
          txtKiss_ip_out_port_no->labelcolor(FL_FOREGROUND_COLOR);
          txtKiss_ip_out_port_no->callback((Fl_Callback*)cb_txtKiss_ip_out_port_no);
          txtKiss_ip_out_port_no->align(Fl_Align(FL_ALIGN_RIGHT));
          txtKiss_ip_out_port_no->when(FL_WHEN_CHANGED);
          txtKiss_ip_out_port_no->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.kiss_out_port.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txtKiss_ip_out_port_no
        { Fl_Check_Button* o = btnEnable_dual_port = new Fl_Check_Button(330, 126, 140, 20, gettext("DP"));
          btnEnable_dual_port->tooltip(gettext("Enable when both programs are using the same IP address"));
          btnEnable_dual_port->down_box(FL_DOWN_BOX);
          btnEnable_dual_port->callback((Fl_Callback*)cb_btnEnable_dual_port);
          if(progdefaults.kiss_dual_port_enabled) o->value(true); else o->value(false);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnEnable_dual_port
        { Fl_Button* o = btn_restart_kiss = new Fl_Button(705, 149, 82, 22, gettext("Restart"));
          btn_restart_kiss->callback((Fl_Callback*)cb_btn_restart_kiss);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btn_restart_kiss
        { Fl_Button* o = btn_connect_kiss_io = new Fl_Button(617, 149, 82, 22, gettext("Start"));
          btn_connect_kiss_io->tooltip(gettext("Return KISS TCP IO connection to a Listening state"));
          btn_connect_kiss_io->callback((Fl_Callback*)cb_btn_connect_kiss_io);
          (progStatus.ip_lock || !progdefaults.kiss_tcp_io) ? o->deactivate() : o->activate();
        } // Fl_Button* btn_connect_kiss_io
        { Fl_Button* o = btnDefault_kiss_ip = new Fl_Button(705, 175, 82, 22, gettext("Default"));
          btnDefault_kiss_ip->tooltip(gettext("Returns IP Address and port\nnumber to the default value."));
          btnDefault_kiss_ip->callback((Fl_Callback*)cb_btnDefault_kiss_ip);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btnDefault_kiss_ip
        { Fl_Check_Button* o = btnKissTCPIO = new Fl_Check_Button(416, 126, 70, 20, gettext("TCP/IP"));
          btnKissTCPIO->tooltip(gettext("Check to enable TCP/IP IO Connection"));
          btnKissTCPIO->down_box(FL_DOWN_BOX);
          btnKissTCPIO->callback((Fl_Callback*)cb_btnKissTCPIO);
          if(progdefaults.kiss_tcp_io) o->value(true); else o->value(false);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnKissTCPIO
        { Fl_Check_Button* o = btnKissUDPIO = new Fl_Check_Button(254, 126, 70, 20, gettext("UDP/IP"));
          btnKissUDPIO->tooltip(gettext("Check to enable UDP/IP IO"));
          btnKissUDPIO->down_box(FL_DOWN_BOX);
          btnKissUDPIO->callback((Fl_Callback*)cb_btnKissUDPIO);
          if(progdefaults.kiss_tcp_io) o->value(true); else o->value(false);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnKissUDPIO
        { Fl_Check_Button* o = btnKissTCPListen = new Fl_Check_Button(500, 126, 95, 20, gettext("Listen / Bind"));
          btnKissTCPListen->tooltip(gettext("Monitor for TCP connection."));
          btnKissTCPListen->down_box(FL_DOWN_BOX);
          btnKissTCPListen->callback((Fl_Callback*)cb_btnKissTCPListen);
          if(progStatus.kiss_tcp_listen) o->value(true); else o->value(false);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnKissTCPListen
        { Fl_Check_Button* o = btnEnable_7bit_modem_inhibit = new Fl_Check_Button(254, 149, 140, 20, gettext("Inhibit 7bit Modem"));
          btnEnable_7bit_modem_inhibit->tooltip(gettext("Inhibit 7 bit modem change notice on user or RSID reception"));
          btnEnable_7bit_modem_inhibit->down_box(FL_DOWN_BOX);
          btnEnable_7bit_modem_inhibit->callback((Fl_Callback*)cb_btnEnable_7bit_modem_inhibit);
          if(progdefaults.kiss_io_modem_change_inhibit) o->value(true); else o->value(false);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnEnable_7bit_modem_inhibit
        { Fl_Check_Button* o = btnEnable_auto_connect = new Fl_Check_Button(416, 149, 155, 20, gettext("Auto Connect / Retry"));
          btnEnable_auto_connect->tooltip(gettext("Connect to host program on FLDIGI start up"));
          btnEnable_auto_connect->down_box(FL_DOWN_BOX);
          btnEnable_auto_connect->callback((Fl_Callback*)cb_btnEnable_auto_connect);
          if(progdefaults.tcp_udp_auto_connect) o->value(true); else o->value(false);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnEnable_auto_connect
        { Fl_Check_Button* o = btnEnable_ax25_decode = new Fl_Check_Button(610, 126, 115, 20, gettext("AX25 Decode"));
          btnEnable_ax25_decode->tooltip(gettext("Decode AX25 Packets into human readable form"));
          btnEnable_ax25_decode->down_box(FL_DOWN_BOX);
          btnEnable_ax25_decode->callback((Fl_Callback*)cb_btnEnable_ax25_decode);
          if(progdefaults.ax25_decode_enabled) o->value(true); else o->value(false);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Check_Button* btnEnable_ax25_decode
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 203, 588, 35, gettext("ARQ"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Input2* o = txtArq_ip_address = new Fl_Input2(255, 207, 230, 22, gettext("Addr"));
          txtArq_ip_address->tooltip(gettext("IP Address for ARQ interface\nIP Address format: nnn.nnn.nnn.nnn\nor name: i."
"e. localhost"));
          txtArq_ip_address->box(FL_DOWN_BOX);
          txtArq_ip_address->color(FL_BACKGROUND2_COLOR);
          txtArq_ip_address->selection_color(FL_SELECTION_COLOR);
          txtArq_ip_address->labeltype(FL_NORMAL_LABEL);
          txtArq_ip_address->labelfont(0);
          txtArq_ip_address->labelsize(14);
          txtArq_ip_address->labelcolor(FL_FOREGROUND_COLOR);
          txtArq_ip_address->callback((Fl_Callback*)cb_txtArq_ip_address);
          txtArq_ip_address->align(Fl_Align(FL_ALIGN_RIGHT));
          txtArq_ip_address->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.arq_address.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txtArq_ip_address
        { Fl_Input2* o = txtArq_ip_port_no = new Fl_Input2(529, 207, 55, 22, gettext("Port"));
          txtArq_ip_port_no->tooltip(gettext("IP Address Port Number"));
          txtArq_ip_port_no->box(FL_DOWN_BOX);
          txtArq_ip_port_no->color(FL_BACKGROUND2_COLOR);
          txtArq_ip_port_no->selection_color(FL_SELECTION_COLOR);
          txtArq_ip_port_no->labeltype(FL_NORMAL_LABEL);
          txtArq_ip_port_no->labelfont(0);
          txtArq_ip_port_no->labelsize(14);
          txtArq_ip_port_no->labelcolor(FL_FOREGROUND_COLOR);
          txtArq_ip_port_no->callback((Fl_Callback*)cb_txtArq_ip_port_no);
          txtArq_ip_port_no->align(Fl_Align(FL_ALIGN_RIGHT));
          txtArq_ip_port_no->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.arq_port.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txtArq_ip_port_no
        { Fl_Button* o = btnDefault_arq_ip = new Fl_Button(624, 207, 73, 22, gettext("Default"));
          btnDefault_arq_ip->tooltip(gettext("Returns IP Address and port\nnumber to the default value."));
          btnDefault_arq_ip->callback((Fl_Callback*)cb_btnDefault_arq_ip);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btnDefault_arq_ip
        { Fl_Button* o = btn_restart_arq = new Fl_Button(704, 207, 82, 22, gettext("Restart"));
          btn_restart_arq->callback((Fl_Callback*)cb_btn_restart_arq);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btn_restart_arq
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 239, 588, 35, gettext("XML"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Button* o = btnDefault_xmlrpc_ip = new Fl_Button(624, 243, 73, 22, gettext("Default"));
          btnDefault_xmlrpc_ip->tooltip(gettext("Returns IP Address and port\nnumber to the default value."));
          btnDefault_xmlrpc_ip->callback((Fl_Callback*)cb_btnDefault_xmlrpc_ip);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btnDefault_xmlrpc_ip
        { Fl_Input2* o = txtXmlrpc_ip_address = new Fl_Input2(255, 243, 230, 22, gettext("Addr"));
          txtXmlrpc_ip_address->tooltip(gettext("IP Address for XMLRPC interface\nIP Address format: nnn.nnn.nnn.nnn\nor name:"
" i.e. localhost"));
          txtXmlrpc_ip_address->box(FL_DOWN_BOX);
          txtXmlrpc_ip_address->color(FL_BACKGROUND2_COLOR);
          txtXmlrpc_ip_address->selection_color(FL_SELECTION_COLOR);
          txtXmlrpc_ip_address->labeltype(FL_NORMAL_LABEL);
          txtXmlrpc_ip_address->labelfont(0);
          txtXmlrpc_ip_address->labelsize(14);
          txtXmlrpc_ip_address->labelcolor(FL_FOREGROUND_COLOR);
          txtXmlrpc_ip_address->callback((Fl_Callback*)cb_txtXmlrpc_ip_address);
          txtXmlrpc_ip_address->align(Fl_Align(FL_ALIGN_RIGHT));
          txtXmlrpc_ip_address->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.xmlrpc_address.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txtXmlrpc_ip_address
        { Fl_Input2* o = txtXmlrpc_ip_port_no = new Fl_Input2(529, 243, 55, 22, gettext("Port"));
          txtXmlrpc_ip_port_no->tooltip(gettext("IP Address Port Number"));
          txtXmlrpc_ip_port_no->box(FL_DOWN_BOX);
          txtXmlrpc_ip_port_no->color(FL_BACKGROUND2_COLOR);
          txtXmlrpc_ip_port_no->selection_color(FL_SELECTION_COLOR);
          txtXmlrpc_ip_port_no->labeltype(FL_NORMAL_LABEL);
          txtXmlrpc_ip_port_no->labelfont(0);
          txtXmlrpc_ip_port_no->labelsize(14);
          txtXmlrpc_ip_port_no->labelcolor(FL_FOREGROUND_COLOR);
          txtXmlrpc_ip_port_no->callback((Fl_Callback*)cb_txtXmlrpc_ip_port_no);
          txtXmlrpc_ip_port_no->align(Fl_Align(FL_ALIGN_RIGHT));
          txtXmlrpc_ip_port_no->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.xmlrpc_port.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txtXmlrpc_ip_port_no
        { Fl_Button* o = btn_restart_xml = new Fl_Button(704, 243, 82, 22, gettext("Restart"));
          btn_restart_xml->callback((Fl_Callback*)cb_btn_restart_xml);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btn_restart_xml
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 277, 588, 30, gettext("flrig"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Button* o = btnDefault_flrig_ip = new Fl_Button(624, 282, 73, 25, gettext("Default"));
          btnDefault_flrig_ip->tooltip(gettext("Returns IP Address and port\nnumber to the default value."));
          btnDefault_flrig_ip->callback((Fl_Callback*)cb_btnDefault_flrig_ip);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btnDefault_flrig_ip
        { Fl_Input2* o = txt_flrig_ip_address = new Fl_Input2(255, 282, 230, 22, gettext("Addr"));
          txt_flrig_ip_address->tooltip(gettext("IP Address for flrig interface\nIP Address format: nnn.nnn.nnn.nnn\nor name: "
"i.e. localhost"));
          txt_flrig_ip_address->box(FL_DOWN_BOX);
          txt_flrig_ip_address->color(FL_BACKGROUND2_COLOR);
          txt_flrig_ip_address->selection_color(FL_SELECTION_COLOR);
          txt_flrig_ip_address->labeltype(FL_NORMAL_LABEL);
          txt_flrig_ip_address->labelfont(0);
          txt_flrig_ip_address->labelsize(14);
          txt_flrig_ip_address->labelcolor(FL_FOREGROUND_COLOR);
          txt_flrig_ip_address->callback((Fl_Callback*)cb_txt_flrig_ip_address);
          txt_flrig_ip_address->align(Fl_Align(FL_ALIGN_RIGHT));
          txt_flrig_ip_address->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.flrig_ip_address.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txt_flrig_ip_address
        { Fl_Input2* o = txt_flrig_ip_port = new Fl_Input2(529, 282, 55, 22, gettext("Port"));
          txt_flrig_ip_port->tooltip(gettext("IP Address Port Number"));
          txt_flrig_ip_port->box(FL_DOWN_BOX);
          txt_flrig_ip_port->color(FL_BACKGROUND2_COLOR);
          txt_flrig_ip_port->selection_color(FL_SELECTION_COLOR);
          txt_flrig_ip_port->labeltype(FL_NORMAL_LABEL);
          txt_flrig_ip_port->labelfont(0);
          txt_flrig_ip_port->labelsize(14);
          txt_flrig_ip_port->labelcolor(FL_FOREGROUND_COLOR);
          txt_flrig_ip_port->callback((Fl_Callback*)cb_txt_flrig_ip_port);
          txt_flrig_ip_port->align(Fl_Align(FL_ALIGN_RIGHT));
          txt_flrig_ip_port->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.flrig_ip_port.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input2* txt_flrig_ip_port
        { Fl_Button* o = btn_reconnect_flrig_server = new Fl_Button(704, 282, 82, 22, gettext("Reconnect"));
          btn_reconnect_flrig_server->callback((Fl_Callback*)cb_btn_reconnect_flrig_server);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btn_reconnect_flrig_server
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 308, 588, 36, gettext("fllog"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Input* o = txt_fllog_ip_address = new Fl_Input(255, 313, 230, 22, gettext("Addr"));
          txt_fllog_ip_address->tooltip(gettext("IP Address for fllog interface\nIP Address format: nnn.nnn.nnn.nnn\nor name: "
"i.e. localhost"));
          txt_fllog_ip_address->callback((Fl_Callback*)cb_txt_fllog_ip_address);
          txt_fllog_ip_address->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.xmllog_address.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input* txt_fllog_ip_address
        { Fl_Input* o = txt_fllog_ip_port = new Fl_Input(529, 313, 55, 22, gettext("Port"));
          txt_fllog_ip_port->tooltip(gettext("IP Address Port Number"));
          txt_fllog_ip_port->callback((Fl_Callback*)cb_txt_fllog_ip_port);
          txt_fllog_ip_port->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.xmllog_port.c_str());
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Input* txt_fllog_ip_port
        { Fl_Button* o = btn_reconnect_log_server = new Fl_Button(704, 313, 82, 22, gettext("Reconnect"));
          btn_reconnect_log_server->callback((Fl_Callback*)cb_btn_reconnect_log_server);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btn_reconnect_log_server
        { Fl_Button* o = btnDefault_fllog_ip = new Fl_Button(624, 313, 73, 22, gettext("Default"));
          btnDefault_fllog_ip->tooltip(gettext("Returns IP Address and port\nnumber to the default value."));
          btnDefault_fllog_ip->callback((Fl_Callback*)cb_btnDefault_fllog_ip);
          progStatus.ip_lock ? o->deactivate() : o->activate();
        } // Fl_Button* btnDefault_fllog_ip
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Misc/TCP-IP sessions"));
      config_pages.push_back(p);
      tab_tree->add(_("Misc/TCP-IP sessions"));
      tab_tree->close(_("Misc"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = grpOperator = new Fl_Group(200, 0, 600, 350, gettext("Operator-Station"));
      grpOperator->box(FL_ENGRAVED_BOX);
      grpOperator->color(FL_LIGHT1);
      grpOperator->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grpOperator->hide();
      { inpMyCallsign = new Fl_Input2(386, 54, 110, 24, gettext("Station Callsign:"));
        inpMyCallsign->tooltip(gettext("Station callsign"));
        inpMyCallsign->box(FL_DOWN_BOX);
        inpMyCallsign->color(FL_BACKGROUND2_COLOR);
        inpMyCallsign->selection_color(FL_SELECTION_COLOR);
        inpMyCallsign->labeltype(FL_NORMAL_LABEL);
        inpMyCallsign->labelfont(0);
        inpMyCallsign->labelsize(14);
        inpMyCallsign->labelcolor(FL_FOREGROUND_COLOR);
        inpMyCallsign->callback((Fl_Callback*)cb_inpMyCallsign);
        inpMyCallsign->align(Fl_Align(FL_ALIGN_LEFT));
        inpMyCallsign->when(FL_WHEN_CHANGED);
        inpMyCallsign->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpMyCallsign
      { Fl_Input2* o = inpOperCallsign = new Fl_Input2(386, 84, 110, 24, gettext("Operator Callsign:"));
        inpOperCallsign->tooltip(gettext("Operator callsign (if different than station callsign)"));
        inpOperCallsign->box(FL_DOWN_BOX);
        inpOperCallsign->color(FL_BACKGROUND2_COLOR);
        inpOperCallsign->selection_color(FL_SELECTION_COLOR);
        inpOperCallsign->labeltype(FL_NORMAL_LABEL);
        inpOperCallsign->labelfont(0);
        inpOperCallsign->labelsize(14);
        inpOperCallsign->labelcolor(FL_FOREGROUND_COLOR);
        inpOperCallsign->callback((Fl_Callback*)cb_inpOperCallsign);
        inpOperCallsign->align(Fl_Align(FL_ALIGN_LEFT));
        inpOperCallsign->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
        o->value(progdefaults.operCall.c_str());
      } // Fl_Input2* inpOperCallsign
      { inpMyName = new Fl_Input2(386, 115, 140, 24, gettext("Operator Name:"));
        inpMyName->tooltip(gettext("Operators name"));
        inpMyName->box(FL_DOWN_BOX);
        inpMyName->color(FL_BACKGROUND2_COLOR);
        inpMyName->selection_color(FL_SELECTION_COLOR);
        inpMyName->labeltype(FL_NORMAL_LABEL);
        inpMyName->labelfont(0);
        inpMyName->labelsize(14);
        inpMyName->labelcolor(FL_FOREGROUND_COLOR);
        inpMyName->callback((Fl_Callback*)cb_inpMyName);
        inpMyName->align(Fl_Align(FL_ALIGN_LEFT));
        inpMyName->when(FL_WHEN_RELEASE);
        inpMyName->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpMyName
      { inpMyAntenna = new Fl_Input2(386, 145, 320, 24, gettext("Antenna:"));
        inpMyAntenna->tooltip(gettext("Short description of antenna"));
        inpMyAntenna->box(FL_DOWN_BOX);
        inpMyAntenna->color(FL_BACKGROUND2_COLOR);
        inpMyAntenna->selection_color(FL_SELECTION_COLOR);
        inpMyAntenna->labeltype(FL_NORMAL_LABEL);
        inpMyAntenna->labelfont(0);
        inpMyAntenna->labelsize(14);
        inpMyAntenna->labelcolor(FL_FOREGROUND_COLOR);
        inpMyAntenna->callback((Fl_Callback*)cb_inpMyAntenna);
        inpMyAntenna->align(Fl_Align(FL_ALIGN_LEFT));
        inpMyAntenna->when(FL_WHEN_RELEASE);
        inpMyAntenna->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpMyAntenna
      { Fl_Input2* o = inpMyQth = new Fl_Input2(386, 176, 320, 24, gettext("Station City:"));
        inpMyQth->tooltip(gettext("Operators QTH"));
        inpMyQth->box(FL_DOWN_BOX);
        inpMyQth->color(FL_BACKGROUND2_COLOR);
        inpMyQth->selection_color(FL_SELECTION_COLOR);
        inpMyQth->labeltype(FL_NORMAL_LABEL);
        inpMyQth->labelfont(0);
        inpMyQth->labelsize(14);
        inpMyQth->labelcolor(FL_FOREGROUND_COLOR);
        inpMyQth->callback((Fl_Callback*)cb_inpMyQth);
        inpMyQth->align(Fl_Align(FL_ALIGN_LEFT));
        inpMyQth->when(FL_WHEN_RELEASE);
        inpMyQth->labelsize(FL_NORMAL_SIZE);
        o->value(progdefaults.myQth.c_str());
      } // Fl_Input2* inpMyQth
      { inpMyLocator = new Fl_Input2(386, 206, 85, 24, gettext("Station Locator:"));
        inpMyLocator->tooltip(gettext("Maidenhead locator as in EM64qv"));
        inpMyLocator->box(FL_DOWN_BOX);
        inpMyLocator->color(FL_BACKGROUND2_COLOR);
        inpMyLocator->selection_color(FL_SELECTION_COLOR);
        inpMyLocator->labeltype(FL_NORMAL_LABEL);
        inpMyLocator->labelfont(0);
        inpMyLocator->labelsize(14);
        inpMyLocator->labelcolor(FL_FOREGROUND_COLOR);
        inpMyLocator->callback((Fl_Callback*)cb_inpMyLocator);
        inpMyLocator->align(Fl_Align(FL_ALIGN_LEFT));
        inpMyLocator->when(FL_WHEN_RELEASE);
        inpMyLocator->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpMyLocator
      { Fl_ListBox* o = listbox_states = new Fl_ListBox(386, 237, 319, 24, gettext("State/Prov./Country"));
        listbox_states->tooltip(gettext("US States / Canadian Provinces"));
        listbox_states->box(FL_DOWN_BOX);
        listbox_states->color(FL_BACKGROUND2_COLOR);
        listbox_states->selection_color(FL_BACKGROUND_COLOR);
        listbox_states->labeltype(FL_NORMAL_LABEL);
        listbox_states->labelfont(0);
        listbox_states->labelsize(14);
        listbox_states->labelcolor(FL_FOREGROUND_COLOR);
        listbox_states->callback((Fl_Callback*)cb_listbox_states);
        listbox_states->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_states->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
        o->add(states.names().c_str());
        o->index(progdefaults.SQSOstate);
        listbox_states->end();
      } // Fl_ListBox* listbox_states
      { Fl_Input2* o = inp_QP_state_short = new Fl_Input2(710, 237, 60, 24);
        inp_QP_state_short->tooltip(gettext("Abbreviation for State/Province"));
        inp_QP_state_short->box(FL_DOWN_BOX);
        inp_QP_state_short->color(FL_BACKGROUND2_COLOR);
        inp_QP_state_short->selection_color(FL_SELECTION_COLOR);
        inp_QP_state_short->labeltype(FL_NORMAL_LABEL);
        inp_QP_state_short->labelfont(0);
        inp_QP_state_short->labelsize(14);
        inp_QP_state_short->labelcolor(FL_FOREGROUND_COLOR);
        inp_QP_state_short->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        inp_QP_state_short->when(FL_WHEN_RELEASE);
        o->value(states.state_short(listbox_states->value()).c_str());
      } // Fl_Input2* inp_QP_state_short
      { Fl_ListBox* o = listbox_counties = new Fl_ListBox(386, 268, 319, 24, gettext("Counties / Regions"));
        listbox_counties->tooltip(gettext("US/Canadian Counties / Regions"));
        listbox_counties->box(FL_DOWN_BOX);
        listbox_counties->color(FL_BACKGROUND2_COLOR);
        listbox_counties->selection_color(FL_BACKGROUND_COLOR);
        listbox_counties->labeltype(FL_NORMAL_LABEL);
        listbox_counties->labelfont(0);
        listbox_counties->labelsize(14);
        listbox_counties->labelcolor(FL_FOREGROUND_COLOR);
        listbox_counties->callback((Fl_Callback*)cb_listbox_counties);
        listbox_counties->align(Fl_Align(FL_ALIGN_LEFT));
        listbox_counties->when(FL_WHEN_RELEASE);
        o->clear(); o->add(states.counties(listbox_states->value()).c_str());
        o->index(progdefaults.SQSOcounty);
        o->labelsize(FL_NORMAL_SIZE);
        listbox_counties->end();
      } // Fl_ListBox* listbox_counties
      { inp_QP_short_county = new Fl_Input2(710, 268, 60, 24);
        inp_QP_short_county->tooltip(gettext("Abbreviation for County/Region"));
        inp_QP_short_county->box(FL_DOWN_BOX);
        inp_QP_short_county->color(FL_BACKGROUND2_COLOR);
        inp_QP_short_county->selection_color(FL_SELECTION_COLOR);
        inp_QP_short_county->labeltype(FL_NORMAL_LABEL);
        inp_QP_short_county->labelfont(0);
        inp_QP_short_county->labelsize(14);
        inp_QP_short_county->labelcolor(FL_FOREGROUND_COLOR);
        inp_QP_short_county->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        inp_QP_short_county->when(FL_WHEN_RELEASE);
        inp_QP_short_county->value(states.cnty_short(listbox_states->value(),listbox_counties->value()).c_str());
      } // Fl_Input2* inp_QP_short_county
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Operator-Station"));
      config_pages.push_back(p);
      tab_tree->add(_("Operator-Station"));
      grpOperator->end();
    } // Fl_Group* grpOperator
    { Fl_Group* o = grpRigFlrig = new Fl_Group(200, 0, 600, 350, gettext("Rig Control/flrig"));
      grpRigFlrig->box(FL_ENGRAVED_BOX);
      grpRigFlrig->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grpRigFlrig->hide();
      { Fl_Group* o = new Fl_Group(209, 233, 580, 90, gettext("\"Disable PTT keys modem if multiple instances of fldigi (client)\nare connec"
"ted to a single flrig (server)."));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chk_flrig_keys_modem = new Fl_Check_Button(439, 281, 183, 20, gettext("Flrig PTT keys modem"));
          chk_flrig_keys_modem->tooltip(gettext("\" \""));
          chk_flrig_keys_modem->down_box(FL_DOWN_BOX);
          chk_flrig_keys_modem->callback((Fl_Callback*)cb_chk_flrig_keys_modem);
          o->value(progdefaults.flrig_keys_modem);
        } // Fl_Check_Button* chk_flrig_keys_modem
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(209, 148, 580, 81, gettext("flrig xmlrpc server parameters\nthese controls are mirrored on the IO configu"
"ration tab"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btnDefault_flrig_ip_mirror = new Fl_Button(613, 194, 73, 24, gettext("Default"));
          btnDefault_flrig_ip_mirror->tooltip(gettext("Returns IP Address and port\nnumber to the default value."));
          btnDefault_flrig_ip_mirror->callback((Fl_Callback*)cb_btnDefault_flrig_ip_mirror);
        } // Fl_Button* btnDefault_flrig_ip_mirror
        { Fl_Input2* o = txt_flrig_ip_address_mirror = new Fl_Input2(244, 194, 230, 24, gettext("Addr"));
          txt_flrig_ip_address_mirror->tooltip(gettext("IP Address for flrig interface\nIP Address format: nnn.nnn.nnn.nnn\nor name: "
"i.e. localhost"));
          txt_flrig_ip_address_mirror->box(FL_DOWN_BOX);
          txt_flrig_ip_address_mirror->color(FL_BACKGROUND2_COLOR);
          txt_flrig_ip_address_mirror->selection_color(FL_SELECTION_COLOR);
          txt_flrig_ip_address_mirror->labeltype(FL_NORMAL_LABEL);
          txt_flrig_ip_address_mirror->labelfont(0);
          txt_flrig_ip_address_mirror->labelsize(14);
          txt_flrig_ip_address_mirror->labelcolor(FL_FOREGROUND_COLOR);
          txt_flrig_ip_address_mirror->callback((Fl_Callback*)cb_txt_flrig_ip_address_mirror);
          txt_flrig_ip_address_mirror->align(Fl_Align(FL_ALIGN_RIGHT));
          txt_flrig_ip_address_mirror->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.flrig_ip_address.c_str());
        } // Fl_Input2* txt_flrig_ip_address_mirror
        { Fl_Input2* o = txt_flrig_ip_port_mirror = new Fl_Input2(518, 194, 55, 24, gettext("Port"));
          txt_flrig_ip_port_mirror->tooltip(gettext("IP Address Port Number"));
          txt_flrig_ip_port_mirror->box(FL_DOWN_BOX);
          txt_flrig_ip_port_mirror->color(FL_BACKGROUND2_COLOR);
          txt_flrig_ip_port_mirror->selection_color(FL_SELECTION_COLOR);
          txt_flrig_ip_port_mirror->labeltype(FL_NORMAL_LABEL);
          txt_flrig_ip_port_mirror->labelfont(0);
          txt_flrig_ip_port_mirror->labelsize(14);
          txt_flrig_ip_port_mirror->labelcolor(FL_FOREGROUND_COLOR);
          txt_flrig_ip_port_mirror->callback((Fl_Callback*)cb_txt_flrig_ip_port_mirror);
          txt_flrig_ip_port_mirror->align(Fl_Align(FL_ALIGN_RIGHT));
          txt_flrig_ip_port_mirror->when(FL_WHEN_CHANGED);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.flrig_ip_port.c_str());
        } // Fl_Input2* txt_flrig_ip_port_mirror
        { btn_reconnect_flrig_server_mirror = new Fl_Button(693, 194, 82, 24, gettext("Reconnect"));
          btn_reconnect_flrig_server_mirror->tooltip(gettext("Press only if you change the address/port"));
          btn_reconnect_flrig_server_mirror->callback((Fl_Callback*)cb_btn_reconnect_flrig_server_mirror);
        } // Fl_Button* btn_reconnect_flrig_server_mirror
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(209, 54, 580, 90, gettext("flrig is the preferred method of tranceiver control"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_fldigi_client_to_flrig = new Fl_Check_Button(234, 81, 70, 15, gettext("Enable flrig xcvr control with fldigi as client"));
          btn_fldigi_client_to_flrig->tooltip(gettext("Disable if flrig not used."));
          btn_fldigi_client_to_flrig->down_box(FL_DOWN_BOX);
          btn_fldigi_client_to_flrig->callback((Fl_Callback*)cb_btn_fldigi_client_to_flrig);
          o->value(progdefaults.fldigi_client_to_flrig);
        } // Fl_Check_Button* btn_fldigi_client_to_flrig
        { Fl_Check_Button* o = btn_flrig_auto_shutdown = new Fl_Check_Button(234, 112, 70, 15, gettext("Shutdown flrig with fldigi"));
          btn_flrig_auto_shutdown->tooltip(gettext("Disable if flrig not used."));
          btn_flrig_auto_shutdown->down_box(FL_DOWN_BOX);
          btn_flrig_auto_shutdown->callback((Fl_Callback*)cb_btn_flrig_auto_shutdown);
          o->value(progdefaults.flrig_auto_shutdown);
        } // Fl_Check_Button* btn_flrig_auto_shutdown
        { Fl_Counter2* o = val_flrig_poll = new Fl_Counter2(620, 107, 130, 24, gettext("Poll Interval (msec)"));
          val_flrig_poll->tooltip(gettext("Request updates every \'poll interval\' milliseconds"));
          val_flrig_poll->box(FL_UP_BOX);
          val_flrig_poll->color(FL_BACKGROUND_COLOR);
          val_flrig_poll->selection_color(FL_INACTIVE_COLOR);
          val_flrig_poll->labeltype(FL_NORMAL_LABEL);
          val_flrig_poll->labelfont(0);
          val_flrig_poll->labelsize(14);
          val_flrig_poll->labelcolor(FL_FOREGROUND_COLOR);
          val_flrig_poll->minimum(50);
          val_flrig_poll->maximum(5000);
          val_flrig_poll->step(10);
          val_flrig_poll->value(1);
          val_flrig_poll->callback((Fl_Callback*)cb_val_flrig_poll);
          val_flrig_poll->align(Fl_Align(FL_ALIGN_LEFT));
          val_flrig_poll->when(FL_WHEN_CHANGED);
          o->value(progdefaults.flrig_poll);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(100);
        } // Fl_Counter2* val_flrig_poll
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Rig Control/flrig"));
      config_pages.push_back(p);
      tab_tree->add(_("Rig Control/flrig"));
      grpRigFlrig->end();
    } // Fl_Group* grpRigFlrig
    { Fl_Group* o = grpRigCat = new Fl_Group(200, 0, 600, 350, gettext("Rig Control/CAT (rigcat)"));
      grpRigCat->box(FL_ENGRAVED_BOX);
      grpRigCat->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grpRigCat->hide();
      { chkUSERIGCAT = new Fl_Check_Button(434, 32, 110, 20, gettext("Use RigCAT"));
        chkUSERIGCAT->tooltip(gettext("RigCAT used for rig control"));
        chkUSERIGCAT->down_box(FL_DOWN_BOX);
        chkUSERIGCAT->callback((Fl_Callback*)cb_chkUSERIGCAT);
      } // Fl_Check_Button* chkUSERIGCAT
      { grpRigCAT = new Fl_Group(244, 55, 490, 279);
        grpRigCAT->box(FL_ENGRAVED_FRAME);
        grpRigCAT->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Output* o = txtXmlRigFilename = new Fl_Output(254, 79, 130, 22, gettext("Rig description file:"));
          txtXmlRigFilename->tooltip(gettext("Use Open to select descriptor file"));
          txtXmlRigFilename->color(FL_LIGHT2);
          txtXmlRigFilename->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(fl_filename_name(progdefaults.XmlRigFilename.c_str()));
        } // Fl_Output* txtXmlRigFilename
        { btnSelectRigXmlFile = new Fl_Button(387, 79, 60, 22, gettext("Open..."));
          btnSelectRigXmlFile->tooltip(gettext("Select rig descriptor file"));
          btnSelectRigXmlFile->callback((Fl_Callback*)cb_btnSelectRigXmlFile);
          btnSelectRigXmlFile->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Button* btnSelectRigXmlFile
        { Fl_ComboBox* o = inpXmlRigDevice = new Fl_ComboBox(580, 79, 144, 22, gettext("Device:"));
          inpXmlRigDevice->box(FL_DOWN_BOX);
          inpXmlRigDevice->color(FL_BACKGROUND2_COLOR);
          inpXmlRigDevice->selection_color(FL_BACKGROUND_COLOR);
          inpXmlRigDevice->labeltype(FL_NORMAL_LABEL);
          inpXmlRigDevice->labelfont(0);
          inpXmlRigDevice->labelsize(14);
          inpXmlRigDevice->labelcolor(FL_FOREGROUND_COLOR);
          inpXmlRigDevice->callback((Fl_Callback*)cb_inpXmlRigDevice);
          inpXmlRigDevice->align(Fl_Align(FL_ALIGN_LEFT));
          inpXmlRigDevice->when(FL_WHEN_RELEASE);
          o->value(progdefaults.XmlRigDevice.c_str());
                       o->labelsize(FL_NORMAL_SIZE);
          inpXmlRigDevice->end();
        } // Fl_ComboBox* inpXmlRigDevice
        { Fl_Value_Input2* o = cntRigCatRetries = new Fl_Value_Input2(269, 122, 60, 22, gettext("Retries"));
          cntRigCatRetries->tooltip(gettext("# retries before giving up"));
          cntRigCatRetries->box(FL_DOWN_BOX);
          cntRigCatRetries->color(FL_BACKGROUND2_COLOR);
          cntRigCatRetries->selection_color(FL_SELECTION_COLOR);
          cntRigCatRetries->labeltype(FL_NORMAL_LABEL);
          cntRigCatRetries->labelfont(0);
          cntRigCatRetries->labelsize(14);
          cntRigCatRetries->labelcolor(FL_FOREGROUND_COLOR);
          cntRigCatRetries->maximum(1000);
          cntRigCatRetries->step(1);
          cntRigCatRetries->callback((Fl_Callback*)cb_cntRigCatRetries);
          cntRigCatRetries->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntRigCatRetries->when(FL_WHEN_CHANGED);
          o->value(progdefaults.RigCatRetries);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntRigCatRetries
        { Fl_Value_Input2* o = cntRigCatTimeout = new Fl_Value_Input2(399, 122, 60, 22, gettext("Retry interval (ms)"));
          cntRigCatTimeout->tooltip(gettext("Time between retires in msec"));
          cntRigCatTimeout->box(FL_DOWN_BOX);
          cntRigCatTimeout->color(FL_BACKGROUND2_COLOR);
          cntRigCatTimeout->selection_color(FL_SELECTION_COLOR);
          cntRigCatTimeout->labeltype(FL_NORMAL_LABEL);
          cntRigCatTimeout->labelfont(0);
          cntRigCatTimeout->labelsize(14);
          cntRigCatTimeout->labelcolor(FL_FOREGROUND_COLOR);
          cntRigCatTimeout->maximum(10000);
          cntRigCatTimeout->step(1);
          cntRigCatTimeout->callback((Fl_Callback*)cb_cntRigCatTimeout);
          cntRigCatTimeout->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntRigCatTimeout->when(FL_WHEN_CHANGED);
          o->value(progdefaults.RigCatTimeout);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntRigCatTimeout
        { Fl_Value_Input2* o = cntRigCatWait = new Fl_Value_Input2(269, 162, 60, 22, gettext("Write delay (ms)"));
          cntRigCatWait->tooltip(gettext("Wait for response to subsequent command"));
          cntRigCatWait->box(FL_DOWN_BOX);
          cntRigCatWait->color(FL_BACKGROUND2_COLOR);
          cntRigCatWait->selection_color(FL_SELECTION_COLOR);
          cntRigCatWait->labeltype(FL_NORMAL_LABEL);
          cntRigCatWait->labelfont(0);
          cntRigCatWait->labelsize(14);
          cntRigCatWait->labelcolor(FL_FOREGROUND_COLOR);
          cntRigCatWait->maximum(10000);
          cntRigCatWait->step(1);
          cntRigCatWait->callback((Fl_Callback*)cb_cntRigCatWait);
          cntRigCatWait->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntRigCatWait->when(FL_WHEN_CHANGED);
          o->value(progdefaults.RigCatWait);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntRigCatWait
        { Fl_ListBox* o = listbox_xml_rig_baudrate = new Fl_ListBox(625, 122, 99, 22, gettext("Baud rate:"));
          listbox_xml_rig_baudrate->box(FL_DOWN_BOX);
          listbox_xml_rig_baudrate->color(FL_BACKGROUND2_COLOR);
          listbox_xml_rig_baudrate->selection_color(FL_BACKGROUND_COLOR);
          listbox_xml_rig_baudrate->labeltype(FL_NORMAL_LABEL);
          listbox_xml_rig_baudrate->labelfont(0);
          listbox_xml_rig_baudrate->labelsize(14);
          listbox_xml_rig_baudrate->labelcolor(FL_FOREGROUND_COLOR);
          listbox_xml_rig_baudrate->callback((Fl_Callback*)cb_listbox_xml_rig_baudrate);
          listbox_xml_rig_baudrate->align(Fl_Align(FL_ALIGN_LEFT));
          listbox_xml_rig_baudrate->when(FL_WHEN_RELEASE);
          o->add(szBaudRates);
          o->index(progdefaults.XmlRigBaudrate);
                       o->labelsize(FL_NORMAL_SIZE);
          listbox_xml_rig_baudrate->end();
        } // Fl_ListBox* listbox_xml_rig_baudrate
        { Fl_Counter2* o = valRigCatStopbits = new Fl_Counter2(627, 156, 95, 21, gettext("Stopbits"));
          valRigCatStopbits->type(1);
          valRigCatStopbits->box(FL_UP_BOX);
          valRigCatStopbits->color(FL_BACKGROUND_COLOR);
          valRigCatStopbits->selection_color(FL_INACTIVE_COLOR);
          valRigCatStopbits->labeltype(FL_NORMAL_LABEL);
          valRigCatStopbits->labelfont(0);
          valRigCatStopbits->labelsize(14);
          valRigCatStopbits->labelcolor(FL_FOREGROUND_COLOR);
          valRigCatStopbits->minimum(1);
          valRigCatStopbits->maximum(2);
          valRigCatStopbits->step(1);
          valRigCatStopbits->value(1);
          valRigCatStopbits->callback((Fl_Callback*)cb_valRigCatStopbits);
          valRigCatStopbits->align(Fl_Align(FL_ALIGN_LEFT));
          valRigCatStopbits->when(FL_WHEN_CHANGED);
          o->value(progdefaults.RigCatStopbits);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* valRigCatStopbits
        { btnInitRIGCAT = new Fl_Button(604, 293, 113, 24, gettext("Initialize"));
          btnInitRIGCAT->tooltip(gettext("Initialize RigCAT interface"));
          btnInitRIGCAT->callback((Fl_Callback*)cb_btnInitRIGCAT);
          btnInitRIGCAT->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Button* btnInitRIGCAT
        { Fl_Check_Button* o = btnRigCatEcho = new Fl_Check_Button(289, 188, 192, 22, gettext("Commands are echoed"));
          btnRigCatEcho->tooltip(gettext("Rig or interface echos serial data"));
          btnRigCatEcho->down_box(FL_DOWN_BOX);
          btnRigCatEcho->callback((Fl_Callback*)cb_btnRigCatEcho);
          o->value(progdefaults.RigCatECHO);
        } // Fl_Check_Button* btnRigCatEcho
        { Fl_Round_Button* o = btnRigCatCMDptt = new Fl_Round_Button(495, 189, 207, 20, gettext("CAT command for PTT"));
          btnRigCatCMDptt->tooltip(gettext("PTT is a CAT command (not hardware)"));
          btnRigCatCMDptt->down_box(FL_DOWN_BOX);
          btnRigCatCMDptt->selection_color((Fl_Color)1);
          btnRigCatCMDptt->callback((Fl_Callback*)cb_btnRigCatCMDptt);
          o->value(progdefaults.RigCatCMDptt);
        } // Fl_Round_Button* btnRigCatCMDptt
        { Fl_Round_Button* o = btnRigCatRTSptt = new Fl_Round_Button(289, 218, 160, 20, gettext("Toggle RTS for PTT"));
          btnRigCatRTSptt->tooltip(gettext("RTS is ptt line"));
          btnRigCatRTSptt->down_box(FL_DOWN_BOX);
          btnRigCatRTSptt->callback((Fl_Callback*)cb_btnRigCatRTSptt);
          o->value(progdefaults.RigCatRTSptt);
        } // Fl_Round_Button* btnRigCatRTSptt
        { Fl_Round_Button* o = btnRigCatDTRptt = new Fl_Round_Button(495, 216, 160, 20, gettext("Toggle DTR for PTT"));
          btnRigCatDTRptt->tooltip(gettext("DTR is ptt line"));
          btnRigCatDTRptt->down_box(FL_DOWN_BOX);
          btnRigCatDTRptt->callback((Fl_Callback*)cb_btnRigCatDTRptt);
          o->value(progdefaults.RigCatDTRptt);
        } // Fl_Round_Button* btnRigCatDTRptt
        { Fl_Check_Button* o = btnRigCatRTSplus = new Fl_Check_Button(289, 247, 100, 20, gettext("RTS +12 v"));
          btnRigCatRTSplus->tooltip(gettext("Initial state of RTS"));
          btnRigCatRTSplus->down_box(FL_DOWN_BOX);
          btnRigCatRTSplus->callback((Fl_Callback*)cb_btnRigCatRTSplus);
          o->value(progdefaults.RigCatRTSplus);
        } // Fl_Check_Button* btnRigCatRTSplus
        { Fl_Check_Button* o = btnRigCatDTRplus = new Fl_Check_Button(495, 244, 100, 20, gettext("DTR +12 v"));
          btnRigCatDTRplus->tooltip(gettext("Initial state of DTR"));
          btnRigCatDTRplus->down_box(FL_DOWN_BOX);
          btnRigCatDTRplus->callback((Fl_Callback*)cb_btnRigCatDTRplus);
          o->value(progdefaults.RigCatDTRplus);
        } // Fl_Check_Button* btnRigCatDTRplus
        { Fl_Check_Button* o = chkRigCatRTSCTSflow = new Fl_Check_Button(289, 275, 170, 20, gettext("RTS/CTS flow control"));
          chkRigCatRTSCTSflow->tooltip(gettext("Rig uses RTS/CTS handshake"));
          chkRigCatRTSCTSflow->down_box(FL_DOWN_BOX);
          chkRigCatRTSCTSflow->callback((Fl_Callback*)cb_chkRigCatRTSCTSflow);
          o->value(progdefaults.RigCatRTSCTSflow);
        } // Fl_Check_Button* chkRigCatRTSCTSflow
        { Fl_Check_Button* o = chk_restore_tio = new Fl_Check_Button(289, 304, 205, 20, gettext("Restore UART Settings on Close"));
          chk_restore_tio->tooltip(gettext("Restore the serial (COM) port settings"));
          chk_restore_tio->down_box(FL_DOWN_BOX);
          chk_restore_tio->callback((Fl_Callback*)cb_chk_restore_tio);
          o->value(progdefaults.RigCatRestoreTIO);
        } // Fl_Check_Button* chk_restore_tio
        { Fl_Check_Button* o = chkRigCatVSP = new Fl_Check_Button(495, 272, 100, 25, gettext("VSP Enable"));
          chkRigCatVSP->tooltip(gettext("Virtual Serial Port Emulator - suppress WARNINGS"));
          chkRigCatVSP->down_box(FL_DOWN_BOX);
          chkRigCatVSP->callback((Fl_Callback*)cb_chkRigCatVSP);
          o->value(progdefaults.RigCatVSP);
        } // Fl_Check_Button* chkRigCatVSP
        { Fl_Value_Input2* o = cntRigCatInitDelay = new Fl_Value_Input2(399, 162, 75, 22, gettext("Init delay (ms)"));
          cntRigCatInitDelay->tooltip(gettext("Wait for response to first CAT command"));
          cntRigCatInitDelay->box(FL_DOWN_BOX);
          cntRigCatInitDelay->color(FL_BACKGROUND2_COLOR);
          cntRigCatInitDelay->selection_color(FL_SELECTION_COLOR);
          cntRigCatInitDelay->labeltype(FL_NORMAL_LABEL);
          cntRigCatInitDelay->labelfont(0);
          cntRigCatInitDelay->labelsize(14);
          cntRigCatInitDelay->labelcolor(FL_FOREGROUND_COLOR);
          cntRigCatInitDelay->maximum(10000);
          cntRigCatInitDelay->step(1);
          cntRigCatInitDelay->callback((Fl_Callback*)cb_cntRigCatInitDelay);
          cntRigCatInitDelay->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntRigCatInitDelay->when(FL_WHEN_CHANGED);
          o->value(progdefaults.RigCatInitDelay);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntRigCatInitDelay
        grpRigCAT->end();
      } // Fl_Group* grpRigCAT
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Rig Control/CAT (rigcat)"));
      config_pages.push_back(p);
      tab_tree->add(_("Rig Control/CAT (rigcat)"));
      grpRigCat->end();
    } // Fl_Group* grpRigCat
    { Fl_Group* o = grpRigGPIO = new Fl_Group(201, 0, 600, 350, gettext("Rig Control/GPIO PTT/CW"));
      grpRigGPIO->box(FL_ENGRAVED_BOX);
      grpRigGPIO->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grpRigGPIO->hide();
      { Fl_Check_Button* o = btn_gpio_ptt2 = new Fl_Check_Button(257, 25, 60, 15, gettext("Enable GPIO PTT"));
        btn_gpio_ptt2->tooltip(gettext("Select PTT on state"));
        btn_gpio_ptt2->down_box(FL_DOWN_BOX);
        btn_gpio_ptt2->labelfont(4);
        btn_gpio_ptt2->callback((Fl_Callback*)cb_btn_gpio_ptt2);
        o->value(progdefaults.gpio_ptt);
      } // Fl_Check_Button* btn_gpio_ptt2
      { Fl_Check_Button* o = btn_gpio_CW = new Fl_Check_Button(449, 23, 60, 15, gettext("Enable GPIO CW"));
        btn_gpio_CW->tooltip(gettext("Select CW using GPIO"));
        btn_gpio_CW->down_box(FL_DOWN_BOX);
        btn_gpio_CW->labelfont(4);
        btn_gpio_CW->callback((Fl_Callback*)cb_btn_gpio_CW);
        o->value(progdefaults.gpio_cw);
      } // Fl_Check_Button* btn_gpio_CW
      { btnInitHWPTT2 = new Fl_Button(641, 20, 113, 24, gettext("Initialize"));
        btnInitHWPTT2->tooltip(gettext("Initialize the H/W PTT interface"));
        btnInitHWPTT2->callback((Fl_Callback*)cb_btnInitHWPTT2);
      } // Fl_Button* btnInitHWPTT2
      { Fl_Group* o = new Fl_Group(210, 50, 176, 260, gettext(" BCM GPIO PIN    PTT"));
        o->box(FL_THIN_DOWN_BOX);
        o->selection_color(FL_SELECTION_COLOR);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_enable_gpio[0] = new Fl_Check_Button(320, 78, 15, 15, gettext("17  00  11 "));
          btn_enable_gpio[0]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[0]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[0]->labelfont(4);
          btn_enable_gpio[0]->callback((Fl_Callback*)cb_btn_enable_gpio);
          btn_enable_gpio[0]->align(Fl_Align(292));
          o->value(progdefaults.enable_gpio & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[0]
        { Fl_Check_Button* o = btn_enable_gpio[1] = new Fl_Check_Button(320, 107, 15, 15, gettext("18  01  12 "));
          btn_enable_gpio[1]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[1]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[1]->labelfont(4);
          btn_enable_gpio[1]->callback((Fl_Callback*)cb_btn_enable_gpio1);
          btn_enable_gpio[1]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 1) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[1]
        { Fl_Check_Button* o = btn_enable_gpio[2] = new Fl_Check_Button(320, 137, 15, 15, gettext("27  02  13 "));
          btn_enable_gpio[2]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[2]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[2]->labelfont(4);
          btn_enable_gpio[2]->callback((Fl_Callback*)cb_btn_enable_gpio2);
          btn_enable_gpio[2]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 2) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[2]
        { Fl_Check_Button* o = btn_enable_gpio[3] = new Fl_Check_Button(320, 167, 15, 15, gettext("22  03  15 "));
          btn_enable_gpio[3]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[3]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[3]->labelfont(4);
          btn_enable_gpio[3]->callback((Fl_Callback*)cb_btn_enable_gpio3);
          btn_enable_gpio[3]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 3) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[3]
        { Fl_Check_Button* o = btn_enable_gpio[4] = new Fl_Check_Button(320, 197, 15, 15, gettext("23  04  16 "));
          btn_enable_gpio[4]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[4]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[4]->labelfont(4);
          btn_enable_gpio[4]->callback((Fl_Callback*)cb_btn_enable_gpio4);
          btn_enable_gpio[4]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 4) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[4]
        { Fl_Check_Button* o = btn_enable_gpio[5] = new Fl_Check_Button(320, 227, 15, 15, gettext("24  05  18 "));
          btn_enable_gpio[5]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[5]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[5]->labelfont(4);
          btn_enable_gpio[5]->callback((Fl_Callback*)cb_btn_enable_gpio5);
          btn_enable_gpio[5]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 5) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[5]
        { Fl_Check_Button* o = btn_enable_gpio[6] = new Fl_Check_Button(320, 257, 15, 15, gettext("25  06  22 "));
          btn_enable_gpio[6]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[6]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[6]->labelfont(4);
          btn_enable_gpio[6]->callback((Fl_Callback*)cb_btn_enable_gpio6);
          btn_enable_gpio[6]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 6) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[6]
        { Fl_Check_Button* o = btn_enable_gpio[7] = new Fl_Check_Button(320, 287, 15, 15, gettext(" 4  07   7 "));
          btn_enable_gpio[7]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[7]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[7]->labelfont(4);
          btn_enable_gpio[7]->callback((Fl_Callback*)cb_btn_enable_gpio7);
          btn_enable_gpio[7]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 7) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[7]
        { Fl_Check_Button* o = btn_gpio_on[0] = new Fl_Check_Button(346, 78, 40, 15, gettext("ON"));
          btn_gpio_on[0]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[0]->down_box(FL_DOWN_BOX);
          btn_gpio_on[0]->labelfont(4);
          btn_gpio_on[0]->callback((Fl_Callback*)cb_btn_gpio_on);
          o->value((progdefaults.gpio_on) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[0]
        { Fl_Check_Button* o = btn_gpio_on[1] = new Fl_Check_Button(346, 107, 40, 15, gettext("ON"));
          btn_gpio_on[1]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[1]->down_box(FL_DOWN_BOX);
          btn_gpio_on[1]->labelfont(4);
          btn_gpio_on[1]->callback((Fl_Callback*)cb_btn_gpio_on1);
          o->value((progdefaults.gpio_on >> 1) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[1]
        { Fl_Check_Button* o = btn_gpio_on[2] = new Fl_Check_Button(346, 137, 40, 15, gettext("ON"));
          btn_gpio_on[2]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[2]->down_box(FL_DOWN_BOX);
          btn_gpio_on[2]->labelfont(4);
          btn_gpio_on[2]->callback((Fl_Callback*)cb_btn_gpio_on2);
          o->value((progdefaults.gpio_on >> 2) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[2]
        { Fl_Check_Button* o = btn_gpio_on[3] = new Fl_Check_Button(346, 167, 40, 15, gettext("ON"));
          btn_gpio_on[3]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[3]->down_box(FL_DOWN_BOX);
          btn_gpio_on[3]->labelfont(4);
          btn_gpio_on[3]->callback((Fl_Callback*)cb_btn_gpio_on3);
          o->value((progdefaults.gpio_on >> 3) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[3]
        { Fl_Check_Button* o = btn_gpio_on[4] = new Fl_Check_Button(346, 197, 40, 15, gettext("ON"));
          btn_gpio_on[4]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[4]->down_box(FL_DOWN_BOX);
          btn_gpio_on[4]->labelfont(4);
          btn_gpio_on[4]->callback((Fl_Callback*)cb_btn_gpio_on4);
          o->value((progdefaults.gpio_on >> 4) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[4]
        { Fl_Check_Button* o = btn_gpio_on[5] = new Fl_Check_Button(346, 227, 40, 15, gettext("ON"));
          btn_gpio_on[5]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[5]->down_box(FL_DOWN_BOX);
          btn_gpio_on[5]->labelfont(4);
          btn_gpio_on[5]->callback((Fl_Callback*)cb_btn_gpio_on5);
          o->value((progdefaults.gpio_on >> 5) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[5]
        { Fl_Check_Button* o = btn_gpio_on[6] = new Fl_Check_Button(346, 257, 40, 15, gettext("ON"));
          btn_gpio_on[6]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[6]->down_box(FL_DOWN_BOX);
          btn_gpio_on[6]->labelfont(4);
          btn_gpio_on[6]->callback((Fl_Callback*)cb_btn_gpio_on6);
          o->value((progdefaults.gpio_on >> 6) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[6]
        { Fl_Check_Button* o = btn_gpio_on[7] = new Fl_Check_Button(346, 287, 40, 15, gettext("ON"));
          btn_gpio_on[7]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[7]->down_box(FL_DOWN_BOX);
          btn_gpio_on[7]->labelfont(4);
          btn_gpio_on[7]->callback((Fl_Callback*)cb_btn_gpio_on7);
          o->value((progdefaults.gpio_on >> 7) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[7]
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(386, 50, 80, 260, gettext("KEY"));
        o->box(FL_THIN_DOWN_FRAME);
        o->selection_color(FL_SELECTION_COLOR);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_gpio_cw_on[0] = new Fl_Check_Button(422, 80, 40, 15, gettext("ON"));
          btn_gpio_cw_on[0]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[0]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[0]->labelfont(4);
          btn_gpio_cw_on[0]->callback((Fl_Callback*)cb_btn_gpio_cw_on);
          o->value((progdefaults.gpio_cw_on) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[0]
        { Fl_Check_Button* o = btn_gpio_cw_on[1] = new Fl_Check_Button(422, 109, 40, 15, gettext("ON"));
          btn_gpio_cw_on[1]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[1]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[1]->labelfont(4);
          btn_gpio_cw_on[1]->callback((Fl_Callback*)cb_btn_gpio_cw_on1);
          o->value((progdefaults.gpio_cw_on >> 1) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[1]
        { Fl_Check_Button* o = btn_gpio_cw_on[2] = new Fl_Check_Button(422, 139, 40, 15, gettext("ON"));
          btn_gpio_cw_on[2]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[2]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[2]->labelfont(4);
          btn_gpio_cw_on[2]->callback((Fl_Callback*)cb_btn_gpio_cw_on2);
          o->value((progdefaults.gpio_cw_on >> 2) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[2]
        { Fl_Check_Button* o = btn_gpio_cw_on[3] = new Fl_Check_Button(422, 169, 40, 15, gettext("ON"));
          btn_gpio_cw_on[3]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[3]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[3]->labelfont(4);
          btn_gpio_cw_on[3]->callback((Fl_Callback*)cb_btn_gpio_cw_on3);
          o->value((progdefaults.gpio_cw_on >> 3) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[3]
        { Fl_Check_Button* o = btn_gpio_cw_on[4] = new Fl_Check_Button(422, 199, 40, 15, gettext("ON"));
          btn_gpio_cw_on[4]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[4]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[4]->labelfont(4);
          btn_gpio_cw_on[4]->callback((Fl_Callback*)cb_btn_gpio_cw_on4);
          o->value((progdefaults.gpio_on >> 4) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[4]
        { Fl_Check_Button* o = btn_gpio_cw_on[5] = new Fl_Check_Button(422, 229, 40, 15, gettext("ON"));
          btn_gpio_cw_on[5]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[5]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[5]->labelfont(4);
          btn_gpio_cw_on[5]->callback((Fl_Callback*)cb_btn_gpio_cw_on5);
          o->value((progdefaults.gpio_cw_on >> 5) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[5]
        { Fl_Check_Button* o = btn_gpio_cw_on[6] = new Fl_Check_Button(422, 259, 40, 15, gettext("ON"));
          btn_gpio_cw_on[6]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[6]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[6]->labelfont(4);
          btn_gpio_cw_on[6]->callback((Fl_Callback*)cb_btn_gpio_cw_on6);
          o->value((progdefaults.gpio_cw_on >> 6) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[6]
        { Fl_Check_Button* o = btn_gpio_cw_on[7] = new Fl_Check_Button(422, 289, 40, 15, gettext("ON"));
          btn_gpio_cw_on[7]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[7]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[7]->labelfont(4);
          btn_gpio_cw_on[7]->callback((Fl_Callback*)cb_btn_gpio_cw_on7);
          o->value((progdefaults.gpio_cw_on >> 7) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[7]
        { Fl_Check_Button* o = btn_enable_gpio_cw[0] = new Fl_Check_Button(397, 80, 16, 15);
          btn_enable_gpio_cw[0]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[0]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[0]->labelfont(4);
          btn_enable_gpio_cw[0]->callback((Fl_Callback*)cb_btn_enable_gpio_cw);
          btn_enable_gpio_cw[0]->align(Fl_Align(292));
          o->value(progdefaults.enable_gpio_cw & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[0]
        { Fl_Check_Button* o = btn_enable_gpio_cw[1] = new Fl_Check_Button(397, 109, 16, 15);
          btn_enable_gpio_cw[1]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[1]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[1]->labelfont(4);
          btn_enable_gpio_cw[1]->callback((Fl_Callback*)cb_btn_enable_gpio_cw1);
          btn_enable_gpio_cw[1]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio >> 1) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[1]
        { Fl_Check_Button* o = btn_enable_gpio_cw[2] = new Fl_Check_Button(397, 139, 16, 15);
          btn_enable_gpio_cw[2]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[2]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[2]->labelfont(4);
          btn_enable_gpio_cw[2]->callback((Fl_Callback*)cb_btn_enable_gpio_cw2);
          btn_enable_gpio_cw[2]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 2) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[2]
        { Fl_Check_Button* o = btn_enable_gpio_cw[3] = new Fl_Check_Button(397, 169, 16, 15);
          btn_enable_gpio_cw[3]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[3]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[3]->labelfont(4);
          btn_enable_gpio_cw[3]->callback((Fl_Callback*)cb_btn_enable_gpio_cw3);
          btn_enable_gpio_cw[3]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 3) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[3]
        { Fl_Check_Button* o = btn_enable_gpio_cw[4] = new Fl_Check_Button(397, 199, 16, 15);
          btn_enable_gpio_cw[4]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[4]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[4]->labelfont(4);
          btn_enable_gpio_cw[4]->callback((Fl_Callback*)cb_btn_enable_gpio_cw4);
          btn_enable_gpio_cw[4]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 4) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[4]
        { Fl_Check_Button* o = btn_enable_gpio_cw[5] = new Fl_Check_Button(397, 229, 16, 15);
          btn_enable_gpio_cw[5]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[5]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[5]->labelfont(4);
          btn_enable_gpio_cw[5]->callback((Fl_Callback*)cb_btn_enable_gpio_cw5);
          btn_enable_gpio_cw[5]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 5) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[5]
        { Fl_Check_Button* o = btn_enable_gpio_cw[6] = new Fl_Check_Button(397, 259, 16, 15);
          btn_enable_gpio_cw[6]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[6]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[6]->labelfont(4);
          btn_enable_gpio_cw[6]->callback((Fl_Callback*)cb_btn_enable_gpio_cw6);
          btn_enable_gpio_cw[6]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 6) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[6]
        { Fl_Check_Button* o = btn_enable_gpio_cw[7] = new Fl_Check_Button(397, 289, 16, 15);
          btn_enable_gpio_cw[7]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[7]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[7]->labelfont(4);
          btn_enable_gpio_cw[7]->callback((Fl_Callback*)cb_btn_enable_gpio_cw7);
          btn_enable_gpio_cw[7]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 7) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[7]
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(478, 50, 185, 288, gettext("BCM  GPIO  PIN     PTT"));
        o->box(FL_THIN_DOWN_BOX);
        o->selection_color(FL_SELECTION_COLOR);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_enable_gpio[8] = new Fl_Check_Button(591, 74, 15, 15, gettext(" 5  21  29 "));
          btn_enable_gpio[8]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[8]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[8]->labelfont(4);
          btn_enable_gpio[8]->callback((Fl_Callback*)cb_btn_enable_gpio8);
          btn_enable_gpio[8]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 8) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[8]
        { Fl_Check_Button* o = btn_enable_gpio[9] = new Fl_Check_Button(591, 103, 15, 15, gettext(" 6  22  31 "));
          btn_enable_gpio[9]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[9]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[9]->labelfont(4);
          btn_enable_gpio[9]->callback((Fl_Callback*)cb_btn_enable_gpio9);
          btn_enable_gpio[9]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 9) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[9]
        { Fl_Check_Button* o = btn_enable_gpio[10] = new Fl_Check_Button(591, 133, 15, 15, gettext("13  23  33 "));
          btn_enable_gpio[10]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[10]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[10]->labelfont(4);
          btn_enable_gpio[10]->callback((Fl_Callback*)cb_btn_enable_gpioa);
          btn_enable_gpio[10]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 10) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[10]
        { Fl_Check_Button* o = btn_enable_gpio[11] = new Fl_Check_Button(591, 163, 15, 15, gettext("19  24  35 "));
          btn_enable_gpio[11]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[11]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[11]->labelfont(4);
          btn_enable_gpio[11]->callback((Fl_Callback*)cb_btn_enable_gpiob);
          btn_enable_gpio[11]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 11) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[11]
        { Fl_Check_Button* o = btn_enable_gpio[12] = new Fl_Check_Button(591, 193, 15, 15, gettext("26  25  37 "));
          btn_enable_gpio[12]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[12]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[12]->labelfont(4);
          btn_enable_gpio[12]->callback((Fl_Callback*)cb_btn_enable_gpioc);
          btn_enable_gpio[12]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 12) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[12]
        { Fl_Check_Button* o = btn_enable_gpio[13] = new Fl_Check_Button(591, 223, 15, 15, gettext("12  26  32 "));
          btn_enable_gpio[13]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[13]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[13]->labelfont(4);
          btn_enable_gpio[13]->callback((Fl_Callback*)cb_btn_enable_gpiod);
          btn_enable_gpio[13]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 13) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[13]
        { Fl_Check_Button* o = btn_enable_gpio[14] = new Fl_Check_Button(591, 253, 15, 15, gettext("16  27  36 "));
          btn_enable_gpio[14]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[14]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[14]->labelfont(4);
          btn_enable_gpio[14]->callback((Fl_Callback*)cb_btn_enable_gpioe);
          btn_enable_gpio[14]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 14) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[14]
        { Fl_Check_Button* o = btn_enable_gpio[15] = new Fl_Check_Button(591, 283, 15, 15, gettext("20  28  38 "));
          btn_enable_gpio[15]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[15]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[15]->labelfont(4);
          btn_enable_gpio[15]->callback((Fl_Callback*)cb_btn_enable_gpiof);
          btn_enable_gpio[15]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 15) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[15]
        { Fl_Check_Button* o = btn_enable_gpio[16] = new Fl_Check_Button(591, 313, 15, 15, gettext("21  29  40 "));
          btn_enable_gpio[16]->tooltip(gettext("Select pin number"));
          btn_enable_gpio[16]->down_box(FL_DOWN_BOX);
          btn_enable_gpio[16]->labelfont(4);
          btn_enable_gpio[16]->callback((Fl_Callback*)cb_btn_enable_gpio10);
          btn_enable_gpio[16]->align(Fl_Align(FL_ALIGN_LEFT));
          o->value((progdefaults.enable_gpio >> 16) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio[16]
        { Fl_Check_Button* o = btn_gpio_on[8] = new Fl_Check_Button(612, 74, 40, 15, gettext("ON"));
          btn_gpio_on[8]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[8]->down_box(FL_DOWN_BOX);
          btn_gpio_on[8]->labelfont(4);
          btn_gpio_on[8]->callback((Fl_Callback*)cb_btn_gpio_on8);
          o->value((progdefaults.gpio_on >> 8) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[8]
        { Fl_Check_Button* o = btn_gpio_on[9] = new Fl_Check_Button(612, 103, 40, 15, gettext("ON"));
          btn_gpio_on[9]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[9]->down_box(FL_DOWN_BOX);
          btn_gpio_on[9]->labelfont(4);
          btn_gpio_on[9]->callback((Fl_Callback*)cb_btn_gpio_on9);
          o->value((progdefaults.gpio_on >> 9) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[9]
        { Fl_Check_Button* o = btn_gpio_on[10] = new Fl_Check_Button(612, 133, 40, 15, gettext("ON"));
          btn_gpio_on[10]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[10]->down_box(FL_DOWN_BOX);
          btn_gpio_on[10]->labelfont(4);
          btn_gpio_on[10]->callback((Fl_Callback*)cb_btn_gpio_ona);
          o->value((progdefaults.gpio_on >> 10) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[10]
        { Fl_Check_Button* o = btn_gpio_on[11] = new Fl_Check_Button(612, 163, 40, 15, gettext("ON"));
          btn_gpio_on[11]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[11]->down_box(FL_DOWN_BOX);
          btn_gpio_on[11]->labelfont(4);
          btn_gpio_on[11]->callback((Fl_Callback*)cb_btn_gpio_onb);
          o->value((progdefaults.gpio_on >> 11) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[11]
        { Fl_Check_Button* o = btn_gpio_on[12] = new Fl_Check_Button(612, 193, 40, 15, gettext("ON"));
          btn_gpio_on[12]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[12]->down_box(FL_DOWN_BOX);
          btn_gpio_on[12]->labelfont(4);
          btn_gpio_on[12]->callback((Fl_Callback*)cb_btn_gpio_onc);
          o->value((progdefaults.gpio_on >> 12) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[12]
        { Fl_Check_Button* o = btn_gpio_on[13] = new Fl_Check_Button(612, 223, 40, 15, gettext("ON"));
          btn_gpio_on[13]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[13]->down_box(FL_DOWN_BOX);
          btn_gpio_on[13]->labelfont(4);
          btn_gpio_on[13]->callback((Fl_Callback*)cb_btn_gpio_ond);
          o->value((progdefaults.gpio_on >> 13) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[13]
        { Fl_Check_Button* o = btn_gpio_on[14] = new Fl_Check_Button(612, 253, 40, 15, gettext("ON"));
          btn_gpio_on[14]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[14]->down_box(FL_DOWN_BOX);
          btn_gpio_on[14]->labelfont(4);
          btn_gpio_on[14]->callback((Fl_Callback*)cb_btn_gpio_one);
          o->value((progdefaults.gpio_on >> 14) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[14]
        { Fl_Check_Button* o = btn_gpio_on[15] = new Fl_Check_Button(612, 283, 40, 15, gettext("ON"));
          btn_gpio_on[15]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[15]->down_box(FL_DOWN_BOX);
          btn_gpio_on[15]->labelfont(4);
          btn_gpio_on[15]->callback((Fl_Callback*)cb_btn_gpio_onf);
          o->value((progdefaults.gpio_on >> 15) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[15]
        { Fl_Check_Button* o = btn_gpio_on[16] = new Fl_Check_Button(612, 313, 40, 15, gettext("ON"));
          btn_gpio_on[16]->tooltip(gettext("Select PTT on state"));
          btn_gpio_on[16]->down_box(FL_DOWN_BOX);
          btn_gpio_on[16]->labelfont(4);
          btn_gpio_on[16]->callback((Fl_Callback*)cb_btn_gpio_on10);
          o->value((progdefaults.gpio_on >> 16) & 0x01);
        } // Fl_Check_Button* btn_gpio_on[16]
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(665, 50, 80, 288, gettext("KEY"));
        o->box(FL_THIN_DOWN_BOX);
        o->selection_color(FL_SELECTION_COLOR);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_gpio_cw_on[8] = new Fl_Check_Button(705, 74, 40, 15, gettext("ON"));
          btn_gpio_cw_on[8]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[8]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[8]->labelfont(4);
          btn_gpio_cw_on[8]->callback((Fl_Callback*)cb_btn_gpio_cw_on8);
          o->value(((progdefaults.gpio_cw_on) >> 8) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[8]
        { Fl_Check_Button* o = btn_gpio_cw_on[9] = new Fl_Check_Button(705, 103, 40, 15, gettext("ON"));
          btn_gpio_cw_on[9]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[9]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[9]->labelfont(4);
          btn_gpio_cw_on[9]->callback((Fl_Callback*)cb_btn_gpio_cw_on9);
          o->value((progdefaults.gpio_cw_on >> 1) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[9]
        { Fl_Check_Button* o = btn_gpio_cw_on[10] = new Fl_Check_Button(705, 133, 40, 15, gettext("ON"));
          btn_gpio_cw_on[10]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[10]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[10]->labelfont(4);
          btn_gpio_cw_on[10]->callback((Fl_Callback*)cb_btn_gpio_cw_ona);
          o->value((progdefaults.gpio_cw_on >> 2) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[10]
        { Fl_Check_Button* o = btn_gpio_cw_on[11] = new Fl_Check_Button(705, 163, 40, 15, gettext("ON"));
          btn_gpio_cw_on[11]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[11]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[11]->labelfont(4);
          btn_gpio_cw_on[11]->callback((Fl_Callback*)cb_btn_gpio_cw_onb);
          o->value((progdefaults.gpio_cw_on >> 3) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[11]
        { Fl_Check_Button* o = btn_gpio_cw_on[12] = new Fl_Check_Button(705, 193, 40, 15, gettext("ON"));
          btn_gpio_cw_on[12]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[12]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[12]->labelfont(4);
          btn_gpio_cw_on[12]->callback((Fl_Callback*)cb_btn_gpio_cw_onc);
          o->value((progdefaults.gpio_cw_on >> 4) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[12]
        { Fl_Check_Button* o = btn_gpio_cw_on[13] = new Fl_Check_Button(705, 223, 40, 15, gettext("ON"));
          btn_gpio_cw_on[13]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[13]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[13]->labelfont(4);
          btn_gpio_cw_on[13]->callback((Fl_Callback*)cb_btn_gpio_cw_ond);
          o->value((progdefaults.gpio_cw_on >> 13) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[13]
        { Fl_Check_Button* o = btn_gpio_cw_on[14] = new Fl_Check_Button(705, 253, 40, 15, gettext("ON"));
          btn_gpio_cw_on[14]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[14]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[14]->labelfont(4);
          btn_gpio_cw_on[14]->callback((Fl_Callback*)cb_btn_gpio_cw_one);
          o->value((progdefaults.gpio_cw_on >> 14) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[14]
        { Fl_Check_Button* o = btn_gpio_cw_on[15] = new Fl_Check_Button(705, 283, 40, 15, gettext("ON"));
          btn_gpio_cw_on[15]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[15]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[15]->labelfont(4);
          btn_gpio_cw_on[15]->callback((Fl_Callback*)cb_btn_gpio_cw_onf);
          o->value((progdefaults.gpio_cw_on >> 15) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[15]
        { Fl_Check_Button* o = btn_gpio_cw_on[16] = new Fl_Check_Button(705, 313, 40, 16, gettext("ON"));
          btn_gpio_cw_on[16]->tooltip(gettext("CW key down state"));
          btn_gpio_cw_on[16]->down_box(FL_DOWN_BOX);
          btn_gpio_cw_on[16]->labelfont(4);
          btn_gpio_cw_on[16]->callback((Fl_Callback*)cb_btn_gpio_cw_on10);
          o->value((progdefaults.gpio_cw_on >> 16) & 0x01);
        } // Fl_Check_Button* btn_gpio_cw_on[16]
        { Fl_Check_Button* o = btn_enable_gpio_cw[8] = new Fl_Check_Button(673, 74, 16, 15);
          btn_enable_gpio_cw[8]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[8]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[8]->labelfont(4);
          btn_enable_gpio_cw[8]->callback((Fl_Callback*)cb_btn_enable_gpio_cw8);
          btn_enable_gpio_cw[8]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 8) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[8]
        { Fl_Check_Button* o = btn_enable_gpio_cw[9] = new Fl_Check_Button(673, 103, 16, 15);
          btn_enable_gpio_cw[9]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[9]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[9]->labelfont(4);
          btn_enable_gpio_cw[9]->callback((Fl_Callback*)cb_btn_enable_gpio_cw9);
          btn_enable_gpio_cw[9]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 9) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[9]
        { Fl_Check_Button* o = btn_enable_gpio_cw[10] = new Fl_Check_Button(673, 133, 16, 15);
          btn_enable_gpio_cw[10]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[10]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[10]->labelfont(4);
          btn_enable_gpio_cw[10]->callback((Fl_Callback*)cb_btn_enable_gpio_cwa);
          btn_enable_gpio_cw[10]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 10) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[10]
        { Fl_Check_Button* o = btn_enable_gpio_cw[11] = new Fl_Check_Button(673, 163, 16, 15);
          btn_enable_gpio_cw[11]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[11]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[11]->labelfont(4);
          btn_enable_gpio_cw[11]->callback((Fl_Callback*)cb_btn_enable_gpio_cwb);
          btn_enable_gpio_cw[11]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 11) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[11]
        { Fl_Check_Button* o = btn_enable_gpio_cw[12] = new Fl_Check_Button(673, 193, 16, 15);
          btn_enable_gpio_cw[12]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[12]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[12]->labelfont(4);
          btn_enable_gpio_cw[12]->callback((Fl_Callback*)cb_btn_enable_gpio_cwc);
          btn_enable_gpio_cw[12]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 12) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[12]
        { Fl_Check_Button* o = btn_enable_gpio_cw[13] = new Fl_Check_Button(673, 223, 16, 15);
          btn_enable_gpio_cw[13]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[13]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[13]->labelfont(4);
          btn_enable_gpio_cw[13]->callback((Fl_Callback*)cb_btn_enable_gpio_cwd);
          btn_enable_gpio_cw[13]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 13) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[13]
        { Fl_Check_Button* o = btn_enable_gpio_cw[14] = new Fl_Check_Button(673, 253, 16, 15);
          btn_enable_gpio_cw[14]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[14]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[14]->labelfont(4);
          btn_enable_gpio_cw[14]->callback((Fl_Callback*)cb_btn_enable_gpio_cwe);
          btn_enable_gpio_cw[14]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 14) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[14]
        { Fl_Check_Button* o = btn_enable_gpio_cw[15] = new Fl_Check_Button(673, 283, 16, 15);
          btn_enable_gpio_cw[15]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[15]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[15]->labelfont(4);
          btn_enable_gpio_cw[15]->callback((Fl_Callback*)cb_btn_enable_gpio_cwf);
          btn_enable_gpio_cw[15]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 15) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[15]
        { Fl_Check_Button* o = btn_enable_gpio_cw[16] = new Fl_Check_Button(673, 313, 16, 15);
          btn_enable_gpio_cw[16]->tooltip(gettext("Select pin number"));
          btn_enable_gpio_cw[16]->down_box(FL_DOWN_BOX);
          btn_enable_gpio_cw[16]->labelfont(4);
          btn_enable_gpio_cw[16]->callback((Fl_Callback*)cb_btn_enable_gpio_cw10);
          btn_enable_gpio_cw[16]->align(Fl_Align(292));
          o->value((progdefaults.enable_gpio_cw >> 16) & 0x01);
        } // Fl_Check_Button* btn_enable_gpio_cw[16]
        o->end();
      } // Fl_Group* o
      { Fl_Counter* o = cnt_gpio_pulse_width = new Fl_Counter(256, 320, 80, 21, gettext("Pulse width (msec)"));
        cnt_gpio_pulse_width->tooltip(gettext("Set >0 if pulsed PTT used"));
        cnt_gpio_pulse_width->type(1);
        cnt_gpio_pulse_width->minimum(0);
        cnt_gpio_pulse_width->maximum(50);
        cnt_gpio_pulse_width->step(1);
        cnt_gpio_pulse_width->callback((Fl_Callback*)cb_cnt_gpio_pulse_width);
        cnt_gpio_pulse_width->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.gpio_pulse_width);
      } // Fl_Counter* cnt_gpio_pulse_width
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Rig Control/GPIO"));
      config_pages.push_back(p);
      tab_tree->add(_("Rig Control/GPIO"));
      grpRigGPIO->end();
    } // Fl_Group* grpRigGPIO
    { Fl_Group* o = grpRigHamlib = new Fl_Group(200, 0, 600, 350, gettext("Rig Control/Hamlib"));
      grpRigHamlib->box(FL_ENGRAVED_BOX);
      grpRigHamlib->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grpRigHamlib->hide();
      { chkUSEHAMLIB = new Fl_Check_Button(451, 21, 100, 20, gettext("Use Hamlib"));
        chkUSEHAMLIB->tooltip(gettext("Hamlib used for rig control"));
        chkUSEHAMLIB->down_box(FL_DOWN_BOX);
        chkUSEHAMLIB->callback((Fl_Callback*)cb_chkUSEHAMLIB);
      } // Fl_Check_Button* chkUSEHAMLIB
      { grpHamlib = new Fl_Group(206, 51, 585, 293);
        grpHamlib->box(FL_ENGRAVED_FRAME);
        { Fl_ListBox* o = cboHamlibRig = new Fl_ListBox(242, 61, 250, 22, gettext("Rig:"));
          cboHamlibRig->box(FL_DOWN_BOX);
          cboHamlibRig->color(FL_BACKGROUND2_COLOR);
          cboHamlibRig->selection_color(FL_BACKGROUND_COLOR);
          cboHamlibRig->labeltype(FL_NORMAL_LABEL);
          cboHamlibRig->labelfont(0);
          cboHamlibRig->labelsize(14);
          cboHamlibRig->labelcolor(FL_FOREGROUND_COLOR);
          cboHamlibRig->callback((Fl_Callback*)cb_cboHamlibRig);
          cboHamlibRig->align(Fl_Align(FL_ALIGN_LEFT));
          cboHamlibRig->when(FL_WHEN_RELEASE);
          o->labelsize(FL_NORMAL_SIZE);
          cboHamlibRig->end();
        } // Fl_ListBox* cboHamlibRig
        { Fl_ComboBox* o = inpRIGdev = new Fl_ComboBox(556, 61, 220, 22, gettext("Device:"));
          inpRIGdev->box(FL_DOWN_BOX);
          inpRIGdev->color(FL_BACKGROUND2_COLOR);
          inpRIGdev->selection_color(FL_BACKGROUND_COLOR);
          inpRIGdev->labeltype(FL_NORMAL_LABEL);
          inpRIGdev->labelfont(0);
          inpRIGdev->labelsize(14);
          inpRIGdev->labelcolor(FL_FOREGROUND_COLOR);
          inpRIGdev->callback((Fl_Callback*)cb_inpRIGdev);
          inpRIGdev->align(Fl_Align(FL_ALIGN_LEFT));
          inpRIGdev->when(FL_WHEN_RELEASE);
          o->value(progdefaults.HamRigDevice.c_str());
                       o->labelsize(FL_NORMAL_SIZE);
          inpRIGdev->end();
        } // Fl_ComboBox* inpRIGdev
        { Fl_Value_Input2* o = cntHamlibRetries = new Fl_Value_Input2(241, 101, 70, 24, gettext("Retries"));
          cntHamlibRetries->tooltip(gettext("# times to resend command before giving up"));
          cntHamlibRetries->box(FL_DOWN_BOX);
          cntHamlibRetries->color(FL_BACKGROUND2_COLOR);
          cntHamlibRetries->selection_color(FL_SELECTION_COLOR);
          cntHamlibRetries->labeltype(FL_NORMAL_LABEL);
          cntHamlibRetries->labelfont(0);
          cntHamlibRetries->labelsize(14);
          cntHamlibRetries->labelcolor(FL_FOREGROUND_COLOR);
          cntHamlibRetries->maximum(1000);
          cntHamlibRetries->step(1);
          cntHamlibRetries->callback((Fl_Callback*)cb_cntHamlibRetries);
          cntHamlibRetries->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntHamlibRetries->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HamlibRetries);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntHamlibRetries
        { Fl_Value_Input2* o = cntHamlibTimeout = new Fl_Value_Input2(381, 101, 70, 24, gettext("Timeout (msec)"));
          cntHamlibTimeout->tooltip(gettext("Hamlib read timeout"));
          cntHamlibTimeout->box(FL_DOWN_BOX);
          cntHamlibTimeout->color(FL_BACKGROUND2_COLOR);
          cntHamlibTimeout->selection_color(FL_SELECTION_COLOR);
          cntHamlibTimeout->labeltype(FL_NORMAL_LABEL);
          cntHamlibTimeout->labelfont(0);
          cntHamlibTimeout->labelsize(14);
          cntHamlibTimeout->labelcolor(FL_FOREGROUND_COLOR);
          cntHamlibTimeout->maximum(10000);
          cntHamlibTimeout->step(1);
          cntHamlibTimeout->callback((Fl_Callback*)cb_cntHamlibTimeout);
          cntHamlibTimeout->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntHamlibTimeout->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HamlibTimeout);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntHamlibTimeout
        { Fl_Value_Input2* o = cntHamlibWriteDelay = new Fl_Value_Input2(241, 144, 70, 24, gettext("Write delay (msec)"));
          cntHamlibWriteDelay->tooltip(gettext("Msec\'s between sequential commands"));
          cntHamlibWriteDelay->box(FL_DOWN_BOX);
          cntHamlibWriteDelay->color(FL_BACKGROUND2_COLOR);
          cntHamlibWriteDelay->selection_color(FL_SELECTION_COLOR);
          cntHamlibWriteDelay->labeltype(FL_NORMAL_LABEL);
          cntHamlibWriteDelay->labelfont(0);
          cntHamlibWriteDelay->labelsize(14);
          cntHamlibWriteDelay->labelcolor(FL_FOREGROUND_COLOR);
          cntHamlibWriteDelay->maximum(10000);
          cntHamlibWriteDelay->step(1);
          cntHamlibWriteDelay->callback((Fl_Callback*)cb_cntHamlibWriteDelay);
          cntHamlibWriteDelay->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntHamlibWriteDelay->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HamlibWriteDelay);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntHamlibWriteDelay
        { Fl_Value_Input2* o = cntHamlibWait = new Fl_Value_Input2(381, 144, 70, 24, gettext("Post write delay (msec)"));
          cntHamlibWait->tooltip(gettext("Wait interval (msecs) before reading response"));
          cntHamlibWait->box(FL_DOWN_BOX);
          cntHamlibWait->color(FL_BACKGROUND2_COLOR);
          cntHamlibWait->selection_color(FL_SELECTION_COLOR);
          cntHamlibWait->labeltype(FL_NORMAL_LABEL);
          cntHamlibWait->labelfont(0);
          cntHamlibWait->labelsize(14);
          cntHamlibWait->labelcolor(FL_FOREGROUND_COLOR);
          cntHamlibWait->maximum(10000);
          cntHamlibWait->step(1);
          cntHamlibWait->callback((Fl_Callback*)cb_cntHamlibWait);
          cntHamlibWait->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          cntHamlibWait->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HamlibWait);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Value_Input2* cntHamlibWait
        { Fl_ListBox* o = listbox_baudrate = new Fl_ListBox(677, 89, 99, 22, gettext("Baud rate:"));
          listbox_baudrate->box(FL_DOWN_BOX);
          listbox_baudrate->color(FL_BACKGROUND2_COLOR);
          listbox_baudrate->selection_color(FL_BACKGROUND_COLOR);
          listbox_baudrate->labeltype(FL_NORMAL_LABEL);
          listbox_baudrate->labelfont(0);
          listbox_baudrate->labelsize(14);
          listbox_baudrate->labelcolor(FL_FOREGROUND_COLOR);
          listbox_baudrate->callback((Fl_Callback*)cb_listbox_baudrate);
          listbox_baudrate->align(Fl_Align(FL_ALIGN_LEFT));
          listbox_baudrate->when(FL_WHEN_RELEASE);
          o->add(szBaudRates);
          o->index(progdefaults.HamRigBaudrate);
                       o->labelsize(FL_NORMAL_SIZE);
          listbox_baudrate->end();
        } // Fl_ListBox* listbox_baudrate
        { Fl_Counter2* o = valHamRigStopbits = new Fl_Counter2(681, 117, 95, 21, gettext("Stopbits"));
          valHamRigStopbits->type(1);
          valHamRigStopbits->box(FL_UP_BOX);
          valHamRigStopbits->color(FL_BACKGROUND_COLOR);
          valHamRigStopbits->selection_color(FL_INACTIVE_COLOR);
          valHamRigStopbits->labeltype(FL_NORMAL_LABEL);
          valHamRigStopbits->labelfont(0);
          valHamRigStopbits->labelsize(14);
          valHamRigStopbits->labelcolor(FL_FOREGROUND_COLOR);
          valHamRigStopbits->minimum(1);
          valHamRigStopbits->maximum(2);
          valHamRigStopbits->step(1);
          valHamRigStopbits->value(1);
          valHamRigStopbits->callback((Fl_Callback*)cb_valHamRigStopbits);
          valHamRigStopbits->align(Fl_Align(FL_ALIGN_LEFT));
          valHamRigStopbits->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HamRigStopbits);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* valHamRigStopbits
        { Fl_Counter2* o = valHamRigPollrate = new Fl_Counter2(681, 145, 95, 21, gettext("Polling Interval (msec)"));
          valHamRigPollrate->type(1);
          valHamRigPollrate->box(FL_UP_BOX);
          valHamRigPollrate->color(FL_BACKGROUND_COLOR);
          valHamRigPollrate->selection_color(FL_INACTIVE_COLOR);
          valHamRigPollrate->labeltype(FL_NORMAL_LABEL);
          valHamRigPollrate->labelfont(0);
          valHamRigPollrate->labelsize(14);
          valHamRigPollrate->labelcolor(FL_FOREGROUND_COLOR);
          valHamRigPollrate->minimum(100);
          valHamRigPollrate->maximum(2000);
          valHamRigPollrate->step(50);
          valHamRigPollrate->value(100);
          valHamRigPollrate->callback((Fl_Callback*)cb_valHamRigPollrate);
          valHamRigPollrate->align(Fl_Align(FL_ALIGN_LEFT));
          valHamRigPollrate->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HamRigPollrate);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* valHamRigPollrate
        { Fl_Check_Button* o = btnHamlibCMDptt = new Fl_Check_Button(256, 192, 215, 20, gettext("PTT via Hamlib command"));
          btnHamlibCMDptt->tooltip(gettext("PTT using hamlib command"));
          btnHamlibCMDptt->down_box(FL_DOWN_BOX);
          btnHamlibCMDptt->callback((Fl_Callback*)cb_btnHamlibCMDptt);
          o->value(progdefaults.HamlibCMDptt);
        } // Fl_Check_Button* btnHamlibCMDptt
        { Fl_Check_Button* o = btnHamlibPTT_ON_DATA = new Fl_Check_Button(256, 217, 215, 20, gettext("Audio on Auxiliary Port"));
          btnHamlibPTT_ON_DATA->tooltip(gettext("PTT enables auxiliary audio source"));
          btnHamlibPTT_ON_DATA->down_box(FL_DOWN_BOX);
          btnHamlibPTT_ON_DATA->callback((Fl_Callback*)cb_btnHamlibPTT_ON_DATA);
          o->value(progdefaults.hamlib_ptt_on_data);
        } // Fl_Check_Button* btnHamlibPTT_ON_DATA
        { Fl_Check_Button* o = btnHamlibDTRplus = new Fl_Check_Button(256, 243, 90, 20, gettext("DTR +12"));
          btnHamlibDTRplus->tooltip(gettext("Initial state of DTR"));
          btnHamlibDTRplus->down_box(FL_DOWN_BOX);
          btnHamlibDTRplus->callback((Fl_Callback*)cb_btnHamlibDTRplus);
          o->value(progdefaults.HamlibDTRplus);
        } // Fl_Check_Button* btnHamlibDTRplus
        { Fl_Check_Button* o = chkHamlibRTSplus = new Fl_Check_Button(446, 243, 85, 20, gettext("RTS +12"));
          chkHamlibRTSplus->tooltip(gettext("Initial state of RTS"));
          chkHamlibRTSplus->down_box(FL_DOWN_BOX);
          chkHamlibRTSplus->callback((Fl_Callback*)cb_chkHamlibRTSplus);
          o->value(progdefaults.HamlibRTSplus);
        } // Fl_Check_Button* chkHamlibRTSplus
        { Fl_Check_Button* o = chkHamlibRTSCTSflow = new Fl_Check_Button(256, 269, 170, 20, gettext("RTS/CTS flow control"));
          chkHamlibRTSCTSflow->tooltip(gettext("Rig requires RTS/CTS flow control"));
          chkHamlibRTSCTSflow->down_box(FL_DOWN_BOX);
          chkHamlibRTSCTSflow->callback((Fl_Callback*)cb_chkHamlibRTSCTSflow);
          o->value(progdefaults.HamlibRTSCTSflow);
          if (o->value()) chkHamlibRTSplus->deactivate();
        } // Fl_Check_Button* chkHamlibRTSCTSflow
        { Fl_Check_Button* o = chkHamlibXONXOFFflow = new Fl_Check_Button(446, 269, 185, 20, gettext("XON/XOFF flow control"));
          chkHamlibXONXOFFflow->tooltip(gettext("Rig requires Xon/Xoff flow control"));
          chkHamlibXONXOFFflow->down_box(FL_DOWN_BOX);
          chkHamlibXONXOFFflow->callback((Fl_Callback*)cb_chkHamlibXONXOFFflow);
          o->value(progdefaults.HamlibXONXOFFflow);
        } // Fl_Check_Button* chkHamlibXONXOFFflow
        { Fl_Check_Button* o = chk_hamlib_cw_is_lsb = new Fl_Check_Button(636, 243, 142, 20, gettext("CW is LSB mode"));
          chk_hamlib_cw_is_lsb->tooltip(gettext("Check if xcvr uses LSB for CW"));
          chk_hamlib_cw_is_lsb->down_box(FL_DOWN_BOX);
          chk_hamlib_cw_is_lsb->callback((Fl_Callback*)cb_chk_hamlib_cw_is_lsb);
          o->value(progdefaults.hamlib_cw_islsb);
        } // Fl_Check_Button* chk_hamlib_cw_is_lsb
        { Fl_Check_Button* o = chk_hamlib_rtty_is_usb = new Fl_Check_Button(636, 269, 152, 20, gettext("RTTY is USB mode"));
          chk_hamlib_rtty_is_usb->tooltip(gettext("Check if xcvr uses USB for RTTY"));
          chk_hamlib_rtty_is_usb->down_box(FL_DOWN_BOX);
          chk_hamlib_rtty_is_usb->callback((Fl_Callback*)cb_chk_hamlib_rtty_is_usb);
          o->value(progdefaults.hamlib_rtty_isusb);
        } // Fl_Check_Button* chk_hamlib_rtty_is_usb
        { Fl_Counter2* o = val_hamlib_mode_delay = new Fl_Counter2(681, 191, 95, 21, gettext("Mode delay (msec)"));
          val_hamlib_mode_delay->tooltip(gettext("Delay NN msec after executing mode change"));
          val_hamlib_mode_delay->type(1);
          val_hamlib_mode_delay->box(FL_UP_BOX);
          val_hamlib_mode_delay->color(FL_BACKGROUND_COLOR);
          val_hamlib_mode_delay->selection_color(FL_INACTIVE_COLOR);
          val_hamlib_mode_delay->labeltype(FL_NORMAL_LABEL);
          val_hamlib_mode_delay->labelfont(0);
          val_hamlib_mode_delay->labelsize(14);
          val_hamlib_mode_delay->labelcolor(FL_FOREGROUND_COLOR);
          val_hamlib_mode_delay->minimum(0);
          val_hamlib_mode_delay->maximum(2000);
          val_hamlib_mode_delay->step(100);
          val_hamlib_mode_delay->value(200);
          val_hamlib_mode_delay->callback((Fl_Callback*)cb_val_hamlib_mode_delay);
          val_hamlib_mode_delay->align(Fl_Align(FL_ALIGN_LEFT));
          val_hamlib_mode_delay->when(FL_WHEN_CHANGED);
          o->value(progdefaults.hamlib_mode_delay);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* val_hamlib_mode_delay
        { Fl_ListBox* o = listbox_sideband = new Fl_ListBox(632, 216, 144, 22, gettext("Sideband:"));
          listbox_sideband->box(FL_DOWN_BOX);
          listbox_sideband->color(FL_BACKGROUND2_COLOR);
          listbox_sideband->selection_color(FL_BACKGROUND_COLOR);
          listbox_sideband->labeltype(FL_NORMAL_LABEL);
          listbox_sideband->labelfont(0);
          listbox_sideband->labelsize(14);
          listbox_sideband->labelcolor(FL_FOREGROUND_COLOR);
          listbox_sideband->align(Fl_Align(FL_ALIGN_LEFT));
          listbox_sideband->when(FL_WHEN_RELEASE);
          o->labelsize(FL_NORMAL_SIZE);
          listbox_sideband->end();
        } // Fl_ListBox* listbox_sideband
        { inpHamlibConfig = new Fl_Input2(231, 313, 460, 24, gettext("Advanced configuration:"));
          inpHamlibConfig->tooltip(gettext("Optional configuration\nin format: param=val ..."));
          inpHamlibConfig->box(FL_DOWN_BOX);
          inpHamlibConfig->color(FL_BACKGROUND2_COLOR);
          inpHamlibConfig->selection_color(FL_SELECTION_COLOR);
          inpHamlibConfig->labeltype(FL_NORMAL_LABEL);
          inpHamlibConfig->labelfont(0);
          inpHamlibConfig->labelsize(14);
          inpHamlibConfig->labelcolor(FL_FOREGROUND_COLOR);
          inpHamlibConfig->callback((Fl_Callback*)cb_inpHamlibConfig);
          inpHamlibConfig->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          inpHamlibConfig->when(FL_WHEN_RELEASE);
          inpHamlibConfig->value(progdefaults.HamConfig.c_str());
          inpHamlibConfig->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inpHamlibConfig
        { btnInitHAMLIB = new Fl_Button(696, 313, 80, 24, gettext("Initialize"));
          btnInitHAMLIB->tooltip(gettext("Initialize hamlib interface"));
          btnInitHAMLIB->callback((Fl_Callback*)cb_btnInitHAMLIB);
        } // Fl_Button* btnInitHAMLIB
        grpHamlib->end();
      } // Fl_Group* grpHamlib
      { btn_hamlib_get_defaults = new Fl_Button(696, 19, 80, 24, gettext("Defaults"));
        btn_hamlib_get_defaults->callback((Fl_Callback*)cb_btn_hamlib_get_defaults);
      } // Fl_Button* btn_hamlib_get_defaults
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Rig Control/Hamlib"));
      config_pages.push_back(p);
      tab_tree->add(_("Rig Control/Hamlib"));
      grpRigHamlib->end();
    } // Fl_Group* grpRigHamlib
    { Fl_Group* o = grpRigHardware = new Fl_Group(200, 0, 600, 350, gettext("Rig Control/Hardware PTT"));
      grpRigHardware->box(FL_ENGRAVED_BOX);
      grpRigHardware->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grpRigHardware->hide();
      { Fl_Group* o = new Fl_Group(209, 27, 580, 38);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btnPTTrightchannel = new Fl_Check_Button(224, 36, 250, 20, gettext("PTT tone on right audio channel "));
          btnPTTrightchannel->tooltip(gettext("Can be used in lieu of or in addition to other PTT types"));
          btnPTTrightchannel->down_box(FL_DOWN_BOX);
          btnPTTrightchannel->callback((Fl_Callback*)cb_btnPTTrightchannel);
          o->value(progdefaults.PTTrightchannel);
        } // Fl_Check_Button* btnPTTrightchannel
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(209, 67, 580, 184, gettext("h/w ptt device-pin"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { btnTTYptt = new Fl_Round_Button(224, 94, 220, 20, gettext("Use separate serial port PTT"));
          btnTTYptt->down_box(FL_DOWN_BOX);
          btnTTYptt->selection_color((Fl_Color)1);
          btnTTYptt->callback((Fl_Callback*)cb_btnTTYptt);
        } // Fl_Round_Button* btnTTYptt
        { Fl_ComboBox* o = inpTTYdev = new Fl_ComboBox(217, 135, 350, 22, gettext("Device:"));
          inpTTYdev->box(FL_DOWN_BOX);
          inpTTYdev->color(FL_BACKGROUND2_COLOR);
          inpTTYdev->selection_color(FL_BACKGROUND_COLOR);
          inpTTYdev->labeltype(FL_NORMAL_LABEL);
          inpTTYdev->labelfont(0);
          inpTTYdev->labelsize(14);
          inpTTYdev->labelcolor(FL_FOREGROUND_COLOR);
          inpTTYdev->callback((Fl_Callback*)cb_inpTTYdev);
          inpTTYdev->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          inpTTYdev->when(FL_WHEN_RELEASE);
          o->labelsize(FL_NORMAL_SIZE);
          o->value(progdefaults.PTTdev.c_str());
          inpTTYdev->end();
        } // Fl_ComboBox* inpTTYdev
        { Fl_Round_Button* o = btnSCU_17 = new Fl_Round_Button(459, 94, 236, 20, gettext("Port is second SCU-17 device"));
          btnSCU_17->tooltip(gettext("Driver requires stop bits to be ZERO!"));
          btnSCU_17->down_box(FL_DOWN_BOX);
          btnSCU_17->selection_color((Fl_Color)1);
          btnSCU_17->callback((Fl_Callback*)cb_btnSCU_17);
          o->value(progdefaults.SCU_17);
        } // Fl_Round_Button* btnSCU_17
        { btnUsePPortPTT = new Fl_Round_Button(224, 168, 170, 20, gettext("Use parallel port PTT"));
          btnUsePPortPTT->down_box(FL_DOWN_BOX);
          btnUsePPortPTT->selection_color((Fl_Color)1);
          btnUsePPortPTT->callback((Fl_Callback*)cb_btnUsePPortPTT);
        } // Fl_Round_Button* btnUsePPortPTT
        { btnUseUHrouterPTT = new Fl_Round_Button(224, 194, 170, 20, gettext("Use uHRouter PTT"));
          btnUseUHrouterPTT->down_box(FL_DOWN_BOX);
          btnUseUHrouterPTT->selection_color((Fl_Color)1);
          btnUseUHrouterPTT->callback((Fl_Callback*)cb_btnUseUHrouterPTT);
        } // Fl_Round_Button* btnUseUHrouterPTT
        { btnRTSptt = new Fl_Round_Button(579, 123, 85, 20, gettext("Use RTS"));
          btnRTSptt->tooltip(gettext("RTS is PTT signal line"));
          btnRTSptt->down_box(FL_DOWN_BOX);
          btnRTSptt->callback((Fl_Callback*)cb_btnRTSptt);
        } // Fl_Round_Button* btnRTSptt
        { btnRTSplusV = new Fl_Round_Button(670, 123, 100, 20, gettext("RTS = +V"));
          btnRTSplusV->tooltip(gettext("Initial voltage on RTS"));
          btnRTSplusV->down_box(FL_DOWN_BOX);
          btnRTSplusV->callback((Fl_Callback*)cb_btnRTSplusV);
        } // Fl_Round_Button* btnRTSplusV
        { btnDTRptt = new Fl_Round_Button(579, 155, 85, 20, gettext("Use DTR"));
          btnDTRptt->tooltip(gettext("DTR is PTT signal line"));
          btnDTRptt->down_box(FL_DOWN_BOX);
          btnDTRptt->callback((Fl_Callback*)cb_btnDTRptt);
        } // Fl_Round_Button* btnDTRptt
        { btnDTRplusV = new Fl_Round_Button(670, 155, 100, 20, gettext("DTR = +V"));
          btnDTRplusV->tooltip(gettext("Initial voltage on DTR"));
          btnDTRplusV->down_box(FL_DOWN_BOX);
          btnDTRplusV->callback((Fl_Callback*)cb_btnDTRplusV);
        } // Fl_Round_Button* btnDTRplusV
        { Fl_Check_Button* o = btn_gpio_ptt = new Fl_Check_Button(224, 221, 278, 15, gettext("GPIO PTT (Pi specific controls)"));
          btn_gpio_ptt->tooltip(gettext("Select PTT on state"));
          btn_gpio_ptt->down_box(FL_DOWN_BOX);
          btn_gpio_ptt->labelfont(4);
          btn_gpio_ptt->callback((Fl_Callback*)cb_btn_gpio_ptt);
          o->value(progdefaults.gpio_ptt);
        } // Fl_Check_Button* btn_gpio_ptt
        { btnInitHWPTT = new Fl_Button(649, 212, 113, 24, gettext("Initialize"));
          btnInitHWPTT->tooltip(gettext("Initialize the H/W PTT interface"));
          btnInitHWPTT->callback((Fl_Callback*)cb_btnInitHWPTT);
        } // Fl_Button* btnInitHWPTT
        o->end();
      } // Fl_Group* o
      { grpPTTdelays = new Fl_Group(210, 252, 580, 91, gettext("PTT delays valid for all CAT/PTT types"));
        grpPTTdelays->box(FL_ENGRAVED_FRAME);
        grpPTTdelays->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cntPTT_on_delay = new Fl_Counter(274, 279, 100, 21, gettext("Start of transmit PTT delay"));
          cntPTT_on_delay->tooltip(gettext("Delay NN msec before starting audio"));
          cntPTT_on_delay->minimum(0);
          cntPTT_on_delay->maximum(5000);
          cntPTT_on_delay->step(10);
          cntPTT_on_delay->callback((Fl_Callback*)cb_cntPTT_on_delay);
          cntPTT_on_delay->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.PTT_on_delay);
          o->lstep(100);
        } // Fl_Counter* cntPTT_on_delay
        { Fl_Counter* o = cntPTT_off_delay = new Fl_Counter(274, 309, 100, 21, gettext("PTT end of transmit delay"));
          cntPTT_off_delay->tooltip(gettext("Delay NN msec before releasing PTT"));
          cntPTT_off_delay->minimum(0);
          cntPTT_off_delay->maximum(5000);
          cntPTT_off_delay->step(10);
          cntPTT_off_delay->callback((Fl_Callback*)cb_cntPTT_off_delay);
          cntPTT_off_delay->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.PTT_off_delay);
          o->lstep(100);
        } // Fl_Counter* cntPTT_off_delay
        grpPTTdelays->end();
      } // Fl_Group* grpPTTdelays
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Rig Control/Hardware PTT"));
      config_pages.push_back(p);
      tab_tree->add(_("Rig Control/Hardware PTT"));
      tab_tree->close(_("Rig Control"));
      grpRigHardware->end();
    } // Fl_Group* grpRigHardware
    { Fl_Group* o = grp_cmedia_ptt = new Fl_Group(200, 0, 600, 350, gettext("C-Media PTT"));
      grp_cmedia_ptt->box(FL_ENGRAVED_BOX);
      grp_cmedia_ptt->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grp_cmedia_ptt->hide();
      { Fl_Group* o = new Fl_Group(205, 30, 590, 173, gettext("C-Media audio codecs used in DRA Series have 8 user controllable GPIO pins. G"
"PIO signal line 3 (pin 13) is used for PTT control.\n\nFldigi accesses the GPI"
"O lines as a Human Interface Device (HID).  Discovered C-Media devices are enu"
"merated in the \'C-Media device\' list box.\n\nOn Linux: add a file named cmed"
"ia.rules to /etc/udev/rules.d/\nThe file should contain a single line\n\nKERNE"
"L==\"hidraw*\", SUBSYSTEM==\"hidraw\", MODE=\"0664\", GROUP=\"plugdev\""));
        o->align(Fl_Align(132|FL_ALIGN_INSIDE));
        o->end();
      } // Fl_Group* o
      { btn_use_cmedia_PTT = new Fl_Round_Button(235, 218, 220, 20, gettext("Use C-Media PTT"));
        btn_use_cmedia_PTT->down_box(FL_DOWN_BOX);
        btn_use_cmedia_PTT->selection_color((Fl_Color)1);
        btn_use_cmedia_PTT->callback((Fl_Callback*)cb_btn_use_cmedia_PTT);
      } // Fl_Round_Button* btn_use_cmedia_PTT
      { Fl_ComboBox* o = inp_cmedia_dev = new Fl_ComboBox(235, 261, 350, 22, gettext("C-Media device"));
        inp_cmedia_dev->box(FL_DOWN_BOX);
        inp_cmedia_dev->color(FL_BACKGROUND2_COLOR);
        inp_cmedia_dev->selection_color(FL_BACKGROUND_COLOR);
        inp_cmedia_dev->labeltype(FL_NORMAL_LABEL);
        inp_cmedia_dev->labelfont(0);
        inp_cmedia_dev->labelsize(14);
        inp_cmedia_dev->labelcolor(FL_FOREGROUND_COLOR);
        inp_cmedia_dev->callback((Fl_Callback*)cb_inp_cmedia_dev);
        inp_cmedia_dev->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        inp_cmedia_dev->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
        o->value(progdefaults.cmedia_device.c_str());
        inp_cmedia_dev->end();
      } // Fl_ComboBox* inp_cmedia_dev
      { Fl_ComboBox* o = inp_cmedia_GPIO_line = new Fl_ComboBox(235, 304, 114, 22, gettext("GPIO line"));
        inp_cmedia_GPIO_line->box(FL_DOWN_BOX);
        inp_cmedia_GPIO_line->color(FL_BACKGROUND2_COLOR);
        inp_cmedia_GPIO_line->selection_color(FL_BACKGROUND_COLOR);
        inp_cmedia_GPIO_line->labeltype(FL_NORMAL_LABEL);
        inp_cmedia_GPIO_line->labelfont(0);
        inp_cmedia_GPIO_line->labelsize(14);
        inp_cmedia_GPIO_line->labelcolor(FL_FOREGROUND_COLOR);
        inp_cmedia_GPIO_line->callback((Fl_Callback*)cb_inp_cmedia_GPIO_line);
        inp_cmedia_GPIO_line->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        inp_cmedia_GPIO_line->when(FL_WHEN_RELEASE);
        o->labelsize(FL_NORMAL_SIZE);
        o->value(progdefaults.cmedia_gpio_line);
        o->add("GPIO-1|GPIO-2|GPIO-3|GPIO-4");
        inp_cmedia_GPIO_line->end();
      } // Fl_ComboBox* inp_cmedia_GPIO_line
      { btn_init_cmedia_PTT = new Fl_Button(600, 261, 70, 22, gettext("Select"));
        btn_init_cmedia_PTT->tooltip(gettext("Select device & Initialize the H/W PTT interface"));
        btn_init_cmedia_PTT->callback((Fl_Callback*)cb_btn_init_cmedia_PTT);
      } // Fl_Button* btn_init_cmedia_PTT
      { btn_test_cmedia = new Fl_Button(695, 261, 70, 22, gettext("TEST"));
        btn_test_cmedia->tooltip(gettext("Toggles PTT line 20x; check DRA-30 ptt LED"));
        btn_test_cmedia->callback((Fl_Callback*)cb_btn_test_cmedia);
      } // Fl_Button* btn_test_cmedia
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("C-Media PTT"));
      config_pages.push_back(p);
      tab_tree->add(_("Rig Control/C-Media PTT"));
      tab_tree->close(_("Rig Control"));
      grp_cmedia_ptt->end();
    } // Fl_Group* grp_cmedia_ptt
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Soundcard/Alerts"));
      o->box(FL_ENGRAVED_BOX);
      o->color(FL_LIGHT1);
      o->selection_color(FL_LIGHT1);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(203, 18, 590, 64);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_File_Input* o = inp_wav_fname_regex = new Fl_File_Input(208, 41, 304, 35, gettext("REGEX detected wav"));
          inp_wav_fname_regex->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(progdefaults.BWSR_REGEX_MATCH.c_str());
        } // Fl_File_Input* inp_wav_fname_regex
        { btn_select_regex_wav = new Fl_Button(514, 52, 60, 24, gettext("Select"));
          btn_select_regex_wav->callback((Fl_Callback*)cb_btn_select_regex_wav);
        } // Fl_Button* btn_select_regex_wav
        { Fl_Choice* o = mnu_regex_alert_menu = new Fl_Choice(578, 52, 135, 24, gettext("Sound:"));
          mnu_regex_alert_menu->box(FL_DOWN_BOX);
          mnu_regex_alert_menu->down_box(FL_BORDER_BOX);
          mnu_regex_alert_menu->color((Fl_Color)53);
          mnu_regex_alert_menu->callback((Fl_Callback*)cb_mnu_regex_alert_menu);
          mnu_regex_alert_menu->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("wav file|bark|checkout|diesel|steam_train|doesnot|beeboo|phone|dinner_bell|rtty_bell|standard_tone");
          o->value(progdefaults.REGEX_ALERT_MENU);
        } // Fl_Choice* mnu_regex_alert_menu
        { Fl_Check_Button* o = btn_enable_regex_match_wa = new Fl_Check_Button(718, 31, 70, 15, gettext("Enable"));
          btn_enable_regex_match_wa->down_box(FL_DOWN_BOX);
          btn_enable_regex_match_wa->callback((Fl_Callback*)cb_btn_enable_regex_match_wa);
          o->value(progdefaults.ENABLE_BWSR_REGEX_MATCH);
        } // Fl_Check_Button* btn_enable_regex_match_wa
        { btn_test_regex_wav = new Fl_Button(718, 52, 60, 24, gettext("Test"));
          btn_test_regex_wav->callback((Fl_Callback*)cb_btn_test_regex_wav);
        } // Fl_Button* btn_test_regex_wav
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(203, 81, 590, 64);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_File_Input* o = inp_wav_fname_mycall = new Fl_File_Input(208, 103, 304, 35, gettext("MYCALL detected wav"));
          inp_wav_fname_mycall->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(progdefaults.BWSR_MYCALL_MATCH.c_str());
        } // Fl_File_Input* inp_wav_fname_mycall
        { btn_select_mycall_wav = new Fl_Button(514, 114, 60, 24, gettext("Select"));
          btn_select_mycall_wav->callback((Fl_Callback*)cb_btn_select_mycall_wav);
        } // Fl_Button* btn_select_mycall_wav
        { Fl_Choice* o = mnu_mycall_alert_menu = new Fl_Choice(578, 114, 135, 24, gettext("Sound:"));
          mnu_mycall_alert_menu->box(FL_DOWN_BOX);
          mnu_mycall_alert_menu->down_box(FL_BORDER_BOX);
          mnu_mycall_alert_menu->color((Fl_Color)53);
          mnu_mycall_alert_menu->callback((Fl_Callback*)cb_mnu_mycall_alert_menu);
          mnu_mycall_alert_menu->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("wav file|bark|checkout|diesel|steam_train|doesnot|beeboo|phone|dinner_bell|rtty_bell|standard_tone");
          o->value(progdefaults.MYCALL_ALERT_MENU);
        } // Fl_Choice* mnu_mycall_alert_menu
        { Fl_Check_Button* o = btn_enable_mycall_match_wav = new Fl_Check_Button(718, 92, 70, 15, gettext("Enable"));
          btn_enable_mycall_match_wav->down_box(FL_DOWN_BOX);
          btn_enable_mycall_match_wav->callback((Fl_Callback*)cb_btn_enable_mycall_match_wav);
          o->value(progdefaults.ENABLE_BWSR_MYCALL_MATCH);
        } // Fl_Check_Button* btn_enable_mycall_match_wav
        { btn_test_mycall_wav = new Fl_Button(718, 114, 60, 24, gettext("Test"));
          btn_test_mycall_wav->callback((Fl_Callback*)cb_btn_test_mycall_wav);
        } // Fl_Button* btn_test_mycall_wav
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(203, 144, 590, 64);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_File_Input* o = inp_wav_fname_rsid = new Fl_File_Input(208, 166, 304, 35, gettext("RsID audio alert wav"));
          inp_wav_fname_rsid->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(progdefaults.RSID_MATCH.c_str());
        } // Fl_File_Input* inp_wav_fname_rsid
        { btn_select_rsid_wav = new Fl_Button(514, 177, 60, 24, gettext("Select"));
          btn_select_rsid_wav->callback((Fl_Callback*)cb_btn_select_rsid_wav);
        } // Fl_Button* btn_select_rsid_wav
        { Fl_Choice* o = mnu_rsid_alert_menu = new Fl_Choice(578, 177, 135, 24, gettext("Sound:"));
          mnu_rsid_alert_menu->box(FL_DOWN_BOX);
          mnu_rsid_alert_menu->down_box(FL_BORDER_BOX);
          mnu_rsid_alert_menu->color((Fl_Color)53);
          mnu_rsid_alert_menu->callback((Fl_Callback*)cb_mnu_rsid_alert_menu);
          mnu_rsid_alert_menu->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("wav file|bark|checkout|diesel|steam_train|doesnot|beeboo|phone|dinner_bell|rtty_bell|standard_tone");
          o->value(progdefaults.RSID_ALERT_MENU);
        } // Fl_Choice* mnu_rsid_alert_menu
        { Fl_Check_Button* o = btn_enable_rsid_match_wav = new Fl_Check_Button(718, 156, 70, 15, gettext("Enable"));
          btn_enable_rsid_match_wav->down_box(FL_DOWN_BOX);
          btn_enable_rsid_match_wav->callback((Fl_Callback*)cb_btn_enable_rsid_match_wav);
          o->value(progdefaults.ENABLE_RSID_MATCH);
        } // Fl_Check_Button* btn_enable_rsid_match_wav
        { btn_test_rsid_wav = new Fl_Button(718, 177, 60, 24, gettext("Test"));
          btn_test_rsid_wav->callback((Fl_Callback*)cb_btn_test_rsid_wav);
        } // Fl_Button* btn_test_rsid_wav
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(203, 207, 590, 114);
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_File_Input* o = inp_wav_flmsg_rcvd = new Fl_File_Input(208, 227, 304, 35, gettext("flmsg received wav"));
          inp_wav_flmsg_rcvd->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(progdefaults.RX_EXTRACT_MSG_RCVD.c_str());
        } // Fl_File_Input* inp_wav_flmsg_rcvd
        { btn_select_rx_extract_msg = new Fl_Button(514, 238, 60, 24, gettext("Select"));
          btn_select_rx_extract_msg->callback((Fl_Callback*)cb_btn_select_rx_extract_msg);
        } // Fl_Button* btn_select_rx_extract_msg
        { Fl_Choice* o = mnu_rx_extract_alert_menu = new Fl_Choice(578, 238, 135, 24, gettext("Sound:"));
          mnu_rx_extract_alert_menu->box(FL_DOWN_BOX);
          mnu_rx_extract_alert_menu->down_box(FL_BORDER_BOX);
          mnu_rx_extract_alert_menu->color((Fl_Color)53);
          mnu_rx_extract_alert_menu->callback((Fl_Callback*)cb_mnu_rx_extract_alert_menu);
          mnu_rx_extract_alert_menu->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("wav file|bark|checkout|diesel|steam_train|doesnot|beeboo|phone|dinner_bell|rtty_bell|standard_tone");
          o->value(progdefaults.RX_EXTRACT_ALERT_MENU);
        } // Fl_Choice* mnu_rx_extract_alert_menu
        { Fl_Check_Button* o = btn_enable_flmsg_wav = new Fl_Check_Button(718, 216, 70, 15, gettext("Enable"));
          btn_enable_flmsg_wav->down_box(FL_DOWN_BOX);
          btn_enable_flmsg_wav->callback((Fl_Callback*)cb_btn_enable_flmsg_wav);
          o->value(progdefaults.ENABLE_RX_EXTRACT_MSG_RCVD);
        } // Fl_Check_Button* btn_enable_flmsg_wav
        { btn_test_flmsg_extract_wav = new Fl_Button(718, 238, 60, 24, gettext("Test"));
          btn_test_flmsg_extract_wav->callback((Fl_Callback*)cb_btn_test_flmsg_extract_wav);
        } // Fl_Button* btn_test_flmsg_extract_wav
        { Fl_File_Input* o = inp_wav_flmsg_timed_out = new Fl_File_Input(208, 282, 304, 35, gettext("flmsg timed out wav"));
          inp_wav_flmsg_timed_out->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(progdefaults.RX_EXTRACT_TIMED_OUT.c_str());
        } // Fl_File_Input* inp_wav_flmsg_timed_out
        { btn_select_rx_extract_timed_out = new Fl_Button(514, 293, 60, 24, gettext("Select"));
          btn_select_rx_extract_timed_out->callback((Fl_Callback*)cb_btn_select_rx_extract_timed_out);
        } // Fl_Button* btn_select_rx_extract_timed_out
        { Fl_Choice* o = mnu_rx_timed_out_alert_menu = new Fl_Choice(578, 293, 135, 24, gettext("Sound:"));
          mnu_rx_timed_out_alert_menu->box(FL_DOWN_BOX);
          mnu_rx_timed_out_alert_menu->down_box(FL_BORDER_BOX);
          mnu_rx_timed_out_alert_menu->color((Fl_Color)53);
          mnu_rx_timed_out_alert_menu->callback((Fl_Callback*)cb_mnu_rx_timed_out_alert_menu);
          mnu_rx_timed_out_alert_menu->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("wav file|bark|checkout|diesel|steam_train|doesnot|beeboo|phone|dinner_bell|rtty_bell|standard_tone");
          o->value(progdefaults.TIMED_OUT_ALERT_MENU);
        } // Fl_Choice* mnu_rx_timed_out_alert_menu
        { btn_test_rx_extract_timed_out = new Fl_Button(718, 293, 60, 24, gettext("Test"));
          btn_test_rx_extract_timed_out->callback((Fl_Callback*)cb_btn_test_rx_extract_timed_out);
        } // Fl_Button* btn_test_rx_extract_timed_out
        { Fl_Check_Button* o = btn_enable_flmsg_time_out_wav = new Fl_Check_Button(718, 271, 70, 15, gettext("Enable"));
          btn_enable_flmsg_time_out_wav->down_box(FL_DOWN_BOX);
          btn_enable_flmsg_time_out_wav->callback((Fl_Callback*)cb_btn_enable_flmsg_time_out_wav);
          o->value(progdefaults.ENABLE_RX_EXTRACT_TIMED_OUT);
        } // Fl_Check_Button* btn_enable_flmsg_time_out_wav
        o->end();
      } // Fl_Group* o
      { Fl_Value_Slider2* o = sldrAlertVolume = new Fl_Value_Slider2(256, 325, 403, 20, gettext("Alert volume"));
        sldrAlertVolume->type(1);
        sldrAlertVolume->box(FL_DOWN_BOX);
        sldrAlertVolume->color(FL_BACKGROUND_COLOR);
        sldrAlertVolume->selection_color(FL_BACKGROUND_COLOR);
        sldrAlertVolume->labeltype(FL_NORMAL_LABEL);
        sldrAlertVolume->labelfont(0);
        sldrAlertVolume->labelsize(14);
        sldrAlertVolume->labelcolor(FL_FOREGROUND_COLOR);
        sldrAlertVolume->maximum(100);
        sldrAlertVolume->step(1);
        sldrAlertVolume->value(20);
        sldrAlertVolume->textsize(14);
        sldrAlertVolume->callback((Fl_Callback*)cb_sldrAlertVolume);
        sldrAlertVolume->align(Fl_Align(FL_ALIGN_RIGHT));
        sldrAlertVolume->when(FL_WHEN_CHANGED);
        o->value(progdefaults.alert_volume);
        o->labelsize(FL_NORMAL_SIZE); o->textsize(FL_NORMAL_SIZE);
      } // Fl_Value_Slider2* sldrAlertVolume
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Soundcard/Alerts"));
      config_pages.push_back(p);
      tab_tree->add(_("Soundcard/Alerts"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = grpSoundDevices = new Fl_Group(200, -4, 600, 350, gettext("Soundcard/Devices"));
      grpSoundDevices->box(FL_ENGRAVED_BOX);
      grpSoundDevices->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      grpSoundDevices->hide();
      { AudioOSS = new Fl_Group(255, 20, 500, 45);
        AudioOSS->box(FL_ENGRAVED_FRAME);
        { btnAudioIO[0] = new Fl_Round_Button(267, 30, 53, 25, gettext("OSS"));
          btnAudioIO[0]->tooltip(gettext("Use OSS audio server"));
          btnAudioIO[0]->down_box(FL_DOWN_BOX);
          btnAudioIO[0]->selection_color((Fl_Color)1);
          btnAudioIO[0]->callback((Fl_Callback*)cb_btnAudioIO);
        } // Fl_Round_Button* btnAudioIO[0]
        { Fl_Input_Choice* o = menuOSSDev = new Fl_Input_Choice(572, 30, 165, 25, gettext("Device:"));
          menuOSSDev->tooltip(gettext("Select device"));
          menuOSSDev->callback((Fl_Callback*)cb_menuOSSDev);
          o->value(progdefaults.OSSdevice.c_str());
        } // Fl_Input_Choice* menuOSSDev
        AudioOSS->end();
      } // Fl_Group* AudioOSS
      { AudioPort = new Fl_Group(255, 65, 500, 79);
        AudioPort->box(FL_ENGRAVED_FRAME);
        { btnAudioIO[1] = new Fl_Round_Button(267, 93, 95, 25, gettext("PortAudio"));
          btnAudioIO[1]->tooltip(gettext("Use Port Audio server"));
          btnAudioIO[1]->down_box(FL_DOWN_BOX);
          btnAudioIO[1]->selection_color((Fl_Color)1);
          btnAudioIO[1]->callback((Fl_Callback*)cb_btnAudioIO1);
        } // Fl_Round_Button* btnAudioIO[1]
        { menuPortInDev = new Fl_Choice(427, 76, 310, 25, gettext("Capture:"));
          menuPortInDev->tooltip(gettext("Audio input device"));
          menuPortInDev->down_box(FL_BORDER_BOX);
          menuPortInDev->callback((Fl_Callback*)cb_menuPortInDev);
        } // Fl_Choice* menuPortInDev
        { menuPortOutDev = new Fl_Choice(427, 111, 310, 25, gettext("Playback:"));
          menuPortOutDev->tooltip(gettext("Audio output device"));
          menuPortOutDev->down_box(FL_BORDER_BOX);
          menuPortOutDev->callback((Fl_Callback*)cb_menuPortOutDev);
        } // Fl_Choice* menuPortOutDev
        AudioPort->end();
      } // Fl_Group* AudioPort
      { AudioPulse = new Fl_Group(255, 145, 500, 45);
        AudioPulse->box(FL_ENGRAVED_FRAME);
        { btnAudioIO[2] = new Fl_Round_Button(267, 156, 100, 25, gettext("PulseAudio"));
          btnAudioIO[2]->tooltip(gettext("Use Pulse Audio server"));
          btnAudioIO[2]->down_box(FL_DOWN_BOX);
          btnAudioIO[2]->selection_color((Fl_Color)1);
          btnAudioIO[2]->callback((Fl_Callback*)cb_btnAudioIO2);
        } // Fl_Round_Button* btnAudioIO[2]
        { Fl_Input2* o = inpPulseServer = new Fl_Input2(512, 156, 225, 24, gettext("Server string:"));
          inpPulseServer->tooltip(gettext("Leave this blank or refer to\nhttp://www.pulseaudio.org/wiki/ServerStrings"));
          inpPulseServer->box(FL_DOWN_BOX);
          inpPulseServer->color(FL_BACKGROUND2_COLOR);
          inpPulseServer->selection_color(FL_SELECTION_COLOR);
          inpPulseServer->labeltype(FL_NORMAL_LABEL);
          inpPulseServer->labelfont(0);
          inpPulseServer->labelsize(14);
          inpPulseServer->labelcolor(FL_FOREGROUND_COLOR);
          inpPulseServer->callback((Fl_Callback*)cb_inpPulseServer);
          inpPulseServer->align(Fl_Align(FL_ALIGN_LEFT));
          inpPulseServer->when(FL_WHEN_RELEASE);
          o->value(progdefaults.PulseServer.c_str());
          inpPulseServer->labelsize(FL_NORMAL_SIZE);
        } // Fl_Input2* inpPulseServer
        AudioPulse->end();
      } // Fl_Group* AudioPulse
      { AudioNull = new Fl_Group(255, 190, 135, 45);
        AudioNull->box(FL_ENGRAVED_FRAME);
        { btnAudioIO[3] = new Fl_Round_Button(268, 200, 100, 25, gettext("File I/O only"));
          btnAudioIO[3]->tooltip(gettext("NO AUDIO DEVICE AVAILABLE (or testing)"));
          btnAudioIO[3]->down_box(FL_DOWN_BOX);
          btnAudioIO[3]->selection_color((Fl_Color)1);
          btnAudioIO[3]->callback((Fl_Callback*)cb_btnAudioIO3);
        } // Fl_Round_Button* btnAudioIO[3]
        AudioNull->end();
      } // Fl_Group* AudioNull
      { AudioDuplex = new Fl_Group(390, 190, 365, 45);
        AudioDuplex->box(FL_ENGRAVED_FRAME);
        { Fl_Round_Button* o = btn_is_full_duplex = new Fl_Round_Button(433, 200, 225, 25, gettext("Device supports full duplex"));
          btn_is_full_duplex->tooltip(gettext("Capture/Playback supports full duplex operation"));
          btn_is_full_duplex->down_box(FL_DOWN_BOX);
          btn_is_full_duplex->value(1);
          btn_is_full_duplex->selection_color((Fl_Color)1);
          btn_is_full_duplex->callback((Fl_Callback*)cb_btn_is_full_duplex);
          o->value(progdefaults.is_full_duplex);
        } // Fl_Round_Button* btn_is_full_duplex
        AudioDuplex->end();
      } // Fl_Group* AudioDuplex
      { AudioAlerts = new Fl_Group(255, 235, 500, 90);
        AudioAlerts->box(FL_ENGRAVED_FRAME);
        AudioAlerts->align(Fl_Align(FL_ALIGN_CENTER));
        { menuAlertsDev = new Fl_Choice(265, 260, 365, 25, gettext("Audio device shared by Audio Alerts and Rx Monitor"));
          menuAlertsDev->tooltip(gettext("Audio output device"));
          menuAlertsDev->down_box(FL_BORDER_BOX);
          menuAlertsDev->callback((Fl_Callback*)cb_menuAlertsDev);
          menuAlertsDev->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Choice* menuAlertsDev
        { Fl_Round_Button* o = btn_enable_audio_alerts = new Fl_Round_Button(657, 260, 76, 25, gettext("Enable"));
          btn_enable_audio_alerts->tooltip(gettext("First select audio alert playback device"));
          btn_enable_audio_alerts->down_box(FL_DOWN_BOX);
          btn_enable_audio_alerts->selection_color((Fl_Color)1);
          btn_enable_audio_alerts->callback((Fl_Callback*)cb_btn_enable_audio_alerts);
          o->value(progdefaults.enable_audio_alerts);
        } // Fl_Round_Button* btn_enable_audio_alerts
        { Fl_Box* o = new Fl_Box(265, 295, 473, 22, gettext("Note: must be selected and enabled for Rx Audio monitoring!"));
          o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        AudioAlerts->end();
      } // Fl_Group* AudioAlerts
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Soundcard/Devices"));
      config_pages.push_back(p);
      tab_tree->add(_("Soundcard/Devices"));
      grpSoundDevices->end();
    } // Fl_Group* grpSoundDevices
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Soundcard/Right channel"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(236, 33, 550, 246, gettext("Transmit Usage"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { chkAudioStereoOut = new Fl_Check_Button(376, 54, 280, 20, gettext("Modem signal on left and right channels"));
          chkAudioStereoOut->tooltip(gettext("Left and right channels both contain modem audio"));
          chkAudioStereoOut->down_box(FL_DOWN_BOX);
          chkAudioStereoOut->callback((Fl_Callback*)cb_chkAudioStereoOut);
          chkAudioStereoOut->value(progdefaults.sig_on_right_channel);
        } // Fl_Check_Button* chkAudioStereoOut
        { Fl_Check_Button* o = chkReverseAudio = new Fl_Check_Button(376, 84, 270, 20, gettext("Reverse Left/Right channels"));
          chkReverseAudio->tooltip(gettext("Software reversal of left-right audio channels"));
          chkReverseAudio->down_box(FL_DOWN_BOX);
          chkReverseAudio->callback((Fl_Callback*)cb_chkReverseAudio);
          o->value(progdefaults.ReverseAudio);
        } // Fl_Check_Button* chkReverseAudio
        { Fl_Group* o = new Fl_Group(286, 107, 454, 162, gettext("...\nThese controls are on other tabs.\nThey are replicated here for convenie"
"nce.\nYou may change the state from either location.\n..."));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
          { Fl_Check_Button* o = btnPTTrightchannel2 = new Fl_Check_Button(376, 114, 250, 20, gettext("PTT tone on right audio channel "));
            btnPTTrightchannel2->tooltip(gettext("1000 Hz tone when PTT enabled\nCan be used in lieu of or in addition to other"
" PTT types"));
            btnPTTrightchannel2->down_box(FL_DOWN_BOX);
            btnPTTrightchannel2->callback((Fl_Callback*)cb_btnPTTrightchannel2);
            o->value(progdefaults.PTTrightchannel);
          } // Fl_Check_Button* btnPTTrightchannel2
          { Fl_Check_Button* o = btnQSK2 = new Fl_Check_Button(376, 144, 211, 20, gettext("CW QSK signal on right channel"));
            btnQSK2->tooltip(gettext("Generate 1000 Hz square wave signal on right channel"));
            btnQSK2->down_box(FL_DOWN_BOX);
            btnQSK2->callback((Fl_Callback*)cb_btnQSK2);
            o->value(progdefaults.QSK);
          } // Fl_Check_Button* btnQSK2
          { Fl_Check_Button* o = chkPseudoFSK2 = new Fl_Check_Button(376, 175, 270, 20, gettext("Pseudo-FSK on right audio channel"));
            chkPseudoFSK2->tooltip(gettext("Create 1000 Hz square wave on right channel"));
            chkPseudoFSK2->down_box(FL_DOWN_BOX);
            chkPseudoFSK2->callback((Fl_Callback*)cb_chkPseudoFSK2);
            o->value(progdefaults.PseudoFSK);
          } // Fl_Check_Button* chkPseudoFSK2
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(236, 282, 550, 60, gettext("Receive Usage"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chkReverseRxAudio = new Fl_Check_Button(376, 300, 270, 20, gettext("Reverse Left/Right channels"));
          chkReverseRxAudio->tooltip(gettext("Software reversal of left-right audio channels"));
          chkReverseRxAudio->down_box(FL_DOWN_BOX);
          chkReverseRxAudio->callback((Fl_Callback*)cb_chkReverseRxAudio);
          o->value(progdefaults.ReverseRxAudio);
        } // Fl_Check_Button* chkReverseRxAudio
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Soundcard/Right channel"));
      config_pages.push_back(p);
      tab_tree->add(_("Soundcard/Right channel"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Soundcard/Settings"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { grpAudioSampleRate = new Fl_Group(260, 48, 490, 90, gettext("Sample rate"));
        grpAudioSampleRate->box(FL_ENGRAVED_FRAME);
        grpAudioSampleRate->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_ListBox* o = menuInSampleRate = new Fl_ListBox(284, 77, 100, 22, gettext("Capture"));
          menuInSampleRate->tooltip(gettext("Force a specific sample rate. Select \"Native\" if \"Auto\"\ndoes not work we"
"ll with your audio device."));
          menuInSampleRate->box(FL_DOWN_BOX);
          menuInSampleRate->color(FL_BACKGROUND2_COLOR);
          menuInSampleRate->selection_color(FL_BACKGROUND_COLOR);
          menuInSampleRate->labeltype(FL_NORMAL_LABEL);
          menuInSampleRate->labelfont(0);
          menuInSampleRate->labelsize(14);
          menuInSampleRate->labelcolor(FL_FOREGROUND_COLOR);
          menuInSampleRate->callback((Fl_Callback*)cb_menuInSampleRate);
          menuInSampleRate->align(Fl_Align(FL_ALIGN_RIGHT));
          menuInSampleRate->when(FL_WHEN_RELEASE);
          o->clear_changed();
          o->labelsize(FL_NORMAL_SIZE);
          menuInSampleRate->end();
        } // Fl_ListBox* menuInSampleRate
        { Fl_ListBox* o = menuOutSampleRate = new Fl_ListBox(284, 107, 100, 22, gettext("Playback"));
          menuOutSampleRate->box(FL_DOWN_BOX);
          menuOutSampleRate->color(FL_BACKGROUND2_COLOR);
          menuOutSampleRate->selection_color(FL_BACKGROUND_COLOR);
          menuOutSampleRate->labeltype(FL_NORMAL_LABEL);
          menuOutSampleRate->labelfont(0);
          menuOutSampleRate->labelsize(14);
          menuOutSampleRate->labelcolor(FL_FOREGROUND_COLOR);
          menuOutSampleRate->callback((Fl_Callback*)cb_menuOutSampleRate);
          menuOutSampleRate->align(Fl_Align(FL_ALIGN_RIGHT));
          menuOutSampleRate->when(FL_WHEN_RELEASE);
          o->clear_changed();
          o->tooltip(menuInSampleRate->tooltip());
          o->labelsize(FL_NORMAL_SIZE);
          menuOutSampleRate->end();
        } // Fl_ListBox* menuOutSampleRate
        { Fl_ListBox* o = menuSampleConverter = new Fl_ListBox(524, 77, 216, 22, gettext("Converter"));
          menuSampleConverter->tooltip(gettext("Set the type of resampler used of offset correction"));
          menuSampleConverter->box(FL_DOWN_BOX);
          menuSampleConverter->color(FL_BACKGROUND2_COLOR);
          menuSampleConverter->selection_color(FL_BACKGROUND_COLOR);
          menuSampleConverter->labeltype(FL_NORMAL_LABEL);
          menuSampleConverter->labelfont(0);
          menuSampleConverter->labelsize(14);
          menuSampleConverter->labelcolor(FL_FOREGROUND_COLOR);
          menuSampleConverter->callback((Fl_Callback*)cb_menuSampleConverter);
          menuSampleConverter->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          menuSampleConverter->when(FL_WHEN_RELEASE);
          o->labelsize(FL_NORMAL_SIZE);
          menuSampleConverter->end();
        } // Fl_ListBox* menuSampleConverter
        grpAudioSampleRate->end();
      } // Fl_Group* grpAudioSampleRate
      { Fl_Group* o = new Fl_Group(260, 138, 490, 62, gettext("Corrections"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Spinner2* o = cntRxRateCorr = new Fl_Spinner2(284, 165, 85, 20, gettext("RX ppm"));
          cntRxRateCorr->tooltip(gettext("RX sound card correction"));
          cntRxRateCorr->box(FL_NO_BOX);
          cntRxRateCorr->color(FL_BACKGROUND_COLOR);
          cntRxRateCorr->selection_color(FL_BACKGROUND_COLOR);
          cntRxRateCorr->labeltype(FL_NORMAL_LABEL);
          cntRxRateCorr->labelfont(0);
          cntRxRateCorr->labelsize(14);
          cntRxRateCorr->labelcolor(FL_FOREGROUND_COLOR);
          cntRxRateCorr->callback((Fl_Callback*)cb_cntRxRateCorr);
          cntRxRateCorr->align(Fl_Align(FL_ALIGN_RIGHT));
          cntRxRateCorr->when(FL_WHEN_RELEASE);
          o->step(1);
          o->minimum(-50000);
          o->maximum(50000);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Spinner2* cntRxRateCorr
        { Fl_Spinner2* o = cntTxRateCorr = new Fl_Spinner2(431, 165, 85, 20, gettext("TX ppm"));
          cntTxRateCorr->tooltip(gettext("TX sound card correction"));
          cntTxRateCorr->box(FL_NO_BOX);
          cntTxRateCorr->color(FL_BACKGROUND_COLOR);
          cntTxRateCorr->selection_color(FL_BACKGROUND_COLOR);
          cntTxRateCorr->labeltype(FL_NORMAL_LABEL);
          cntTxRateCorr->labelfont(0);
          cntTxRateCorr->labelsize(14);
          cntTxRateCorr->labelcolor(FL_FOREGROUND_COLOR);
          cntTxRateCorr->callback((Fl_Callback*)cb_cntTxRateCorr);
          cntTxRateCorr->align(Fl_Align(FL_ALIGN_RIGHT));
          cntTxRateCorr->when(FL_WHEN_RELEASE);
          o->step(1);
          o->minimum(-50000);
          o->maximum(50000);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Spinner2* cntTxRateCorr
        { Fl_Spinner2* o = cntTxOffset = new Fl_Spinner2(591, 165, 85, 20, gettext("TX offset"));
          cntTxOffset->tooltip(gettext("Difference between Rx & Tx freq (rig offset)"));
          cntTxOffset->box(FL_NO_BOX);
          cntTxOffset->color(FL_BACKGROUND_COLOR);
          cntTxOffset->selection_color(FL_BACKGROUND_COLOR);
          cntTxOffset->labeltype(FL_NORMAL_LABEL);
          cntTxOffset->labelfont(0);
          cntTxOffset->labelsize(14);
          cntTxOffset->labelcolor(FL_FOREGROUND_COLOR);
          cntTxOffset->callback((Fl_Callback*)cb_cntTxOffset);
          cntTxOffset->align(Fl_Align(FL_ALIGN_RIGHT));
          cntTxOffset->when(FL_WHEN_RELEASE);
          o->value(progdefaults.TxOffset);
          o->step(1);
          o->minimum(-50); o->maximum(50);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Spinner2* cntTxOffset
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(260, 200, 490, 76, gettext("Frequency Analysis / FMT Rx Correction"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { bnt_dec_rit = new Fl_Button(285, 227, 18, 24, gettext("@|<"));
          bnt_dec_rit->labelsize(10);
          bnt_dec_rit->callback((Fl_Callback*)cb_bnt_dec_rit);
          bnt_dec_rit->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Button* bnt_dec_rit
        { Fl_Counter* o = cntRIT = new Fl_Counter(303, 227, 130, 24, gettext("Frequency Correction"));
          cntRIT->tooltip(gettext("Used ONLY for frequency analysis mode"));
          cntRIT->minimum(-5);
          cntRIT->maximum(5);
          cntRIT->step(0.001);
          cntRIT->callback((Fl_Callback*)cb_cntRIT);
          o->value(progdefaults.RIT);
          o->lstep(0.01);
        } // Fl_Counter* cntRIT
        { btn_incr_rit = new Fl_Button(433, 227, 18, 24, gettext("@>|"));
          btn_incr_rit->labelsize(10);
          btn_incr_rit->callback((Fl_Callback*)cb_btn_incr_rit);
          btn_incr_rit->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Button* btn_incr_rit
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Soundcard/Settings"));
      config_pages.push_back(p);
      tab_tree->add(_("Soundcard/Settings"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Signal Level"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { new Fl_Box(340, 39, 316, 21, gettext("Signal Levels"));
      } // Fl_Box* o
      { Fl_Box* o = lowcolor2 = new Fl_Box(365, 78, 21, 21);
        lowcolor2->box(FL_DIAMOND_DOWN_BOX);
        lowcolor2->color(FL_FOREGROUND_COLOR);
        o->color(RGBCOLOR(LowSignal));
      } // Fl_Box* lowcolor2
      { btnLowSignal2 = new Fl_Button(402, 78, 70, 21, gettext("Low"));
        btnLowSignal2->callback((Fl_Callback*)cb_btnLowSignal2);
      } // Fl_Button* btnLowSignal2
      { Fl_Box* o = normalcolor2 = new Fl_Box(365, 122, 21, 21);
        normalcolor2->box(FL_DIAMOND_DOWN_BOX);
        normalcolor2->color((Fl_Color)2);
        o->color(RGBCOLOR(NormSignal));
      } // Fl_Box* normalcolor2
      { Fl_Counter* o = cnt_normal_signal_level2 = new Fl_Counter(480, 100, 114, 21, gettext("Transition\nLevel (dB)"));
        cnt_normal_signal_level2->minimum(-90);
        cnt_normal_signal_level2->maximum(0);
        cnt_normal_signal_level2->callback((Fl_Callback*)cb_cnt_normal_signal_level2);
        cnt_normal_signal_level2->align(Fl_Align(FL_ALIGN_TOP));
        o->value(progdefaults.normal_signal_level);
        o->lstep(1.0);
      } // Fl_Counter* cnt_normal_signal_level2
      { btnNormalSignal2 = new Fl_Button(402, 122, 70, 21, gettext("Normal"));
        btnNormalSignal2->callback((Fl_Callback*)cb_btnNormalSignal2);
      } // Fl_Button* btnNormalSignal2
      { Fl_Box* o = highcolor2 = new Fl_Box(365, 166, 21, 21);
        highcolor2->box(FL_DIAMOND_DOWN_BOX);
        highcolor2->color((Fl_Color)3);
        o->color( RGBCOLOR( HighSignal ) );
      } // Fl_Box* highcolor2
      { Fl_Counter* o = cnt_high_signal_level2 = new Fl_Counter(480, 145, 114, 21);
        cnt_high_signal_level2->minimum(-90);
        cnt_high_signal_level2->maximum(0);
        cnt_high_signal_level2->callback((Fl_Callback*)cb_cnt_high_signal_level2);
        o->value(progdefaults.high_signal_level);
        o->lstep(1.0);
      } // Fl_Counter* cnt_high_signal_level2
      { btnHighSignal2 = new Fl_Button(402, 166, 70, 21, gettext("High"));
        btnHighSignal2->callback((Fl_Callback*)cb_btnHighSignal2);
      } // Fl_Button* btnHighSignal2
      { Fl_Box* o = overcolor2 = new Fl_Box(365, 210, 21, 21);
        overcolor2->box(FL_DIAMOND_DOWN_BOX);
        overcolor2->color((Fl_Color)1);
        o->color( RGBCOLOR( OverSignal ) );
      } // Fl_Box* overcolor2
      { Fl_Counter* o = cnt_over_signal_level2 = new Fl_Counter(480, 191, 114, 21);
        cnt_over_signal_level2->minimum(-90);
        cnt_over_signal_level2->maximum(0);
        cnt_over_signal_level2->callback((Fl_Callback*)cb_cnt_over_signal_level2);
        o->value(progdefaults.over_signal_level);
        o->lstep(1.0);
      } // Fl_Counter* cnt_over_signal_level2
      { btnOverSignal2 = new Fl_Button(402, 210, 70, 21, gettext("Over"));
        btnOverSignal2->callback((Fl_Callback*)cb_btnOverSignal2);
      } // Fl_Button* btnOverSignal2
      { Fl_Progress* o = new Fl_Progress(295, 289, 416, 25, gettext("label"));
        o->hide();
      } // Fl_Progress* o
      { sig_vumeter2 = new vumeter(322, 248, 360, 24, gettext("label"));
        sig_vumeter2->box(FL_DOWN_BOX);
        sig_vumeter2->color(FL_BACKGROUND2_COLOR);
        sig_vumeter2->selection_color(FL_YELLOW);
        sig_vumeter2->labeltype(FL_NORMAL_LABEL);
        sig_vumeter2->labelfont(0);
        sig_vumeter2->labelsize(14);
        sig_vumeter2->labelcolor(FL_FOREGROUND_COLOR);
        sig_vumeter2->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        sig_vumeter2->when(FL_WHEN_RELEASE);
      } // vumeter* sig_vumeter2
      { new Fl_Box(383, 275, 237, 17, gettext("Input signal level"));
      } // Fl_Box* o
      { btn_default_signal_levels2 = new Fl_Button(618, 145, 70, 20, gettext("Default"));
        btn_default_signal_levels2->callback((Fl_Callback*)cb_btn_default_signal_levels2);
      } // Fl_Button* btn_default_signal_levels2
      { Fl_Check_Button* o = btn_use_wsjtx_vumeter_scale2 = new Fl_Check_Button(322, 305, 70, 18, gettext("Use wsjtx scale"));
        btn_use_wsjtx_vumeter_scale2->tooltip(gettext("default scale is audo \"Vu Meter\"\nenable to emulate wsjtx scale"));
        btn_use_wsjtx_vumeter_scale2->down_box(FL_DOWN_BOX);
        btn_use_wsjtx_vumeter_scale2->callback((Fl_Callback*)cb_btn_use_wsjtx_vumeter_scale2);
        o->value(progdefaults.use_wsjtx_vumeter_scale);
      } // Fl_Check_Button* btn_use_wsjtx_vumeter_scale2
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Soundcard/Signal Level"));
      config_pages.push_back(p);
      tab_tree->add(_("Soundcard/Signal Level"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Soundcard/Wav file recording"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_ListBox* o = listbox_wav_samplerate = new Fl_ListBox(399, 91, 150, 24, gettext("Wav write sample rate"));
        listbox_wav_samplerate->tooltip(gettext("Pick baud rate from list"));
        listbox_wav_samplerate->box(FL_DOWN_BOX);
        listbox_wav_samplerate->color(FL_BACKGROUND2_COLOR);
        listbox_wav_samplerate->selection_color(FL_BACKGROUND_COLOR);
        listbox_wav_samplerate->labeltype(FL_NORMAL_LABEL);
        listbox_wav_samplerate->labelfont(0);
        listbox_wav_samplerate->labelsize(14);
        listbox_wav_samplerate->labelcolor(FL_FOREGROUND_COLOR);
        listbox_wav_samplerate->callback((Fl_Callback*)cb_listbox_wav_samplerate);
        listbox_wav_samplerate->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        listbox_wav_samplerate->when(FL_WHEN_RELEASE);
        o->add("8000|11025|16000|22050|24000|44100|48000");
        o->index(progdefaults.wavSampleRate);
        o->labelsize(FL_NORMAL_SIZE);
        listbox_wav_samplerate->end();
      } // Fl_ListBox* listbox_wav_samplerate
      { Fl_Check_Button* o = btn_record_both = new Fl_Check_Button(399, 140, 176, 15, gettext("Record both channels"));
        btn_record_both->down_box(FL_DOWN_BOX);
        btn_record_both->callback((Fl_Callback*)cb_btn_record_both);
        o->value(progdefaults.record_both_channels);
      } // Fl_Check_Button* btn_record_both
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Soundcard/Wav file recording"));
      config_pages.push_back(p);
      tab_tree->add(_("Soundcard/Wav file recording"));
      tab_tree->close(_("Soundcard"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("UI/Browser/Channels"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Spinner2* o = cntChannels = new Fl_Spinner2(278, 54, 50, 24, gettext("Channels, first channel starts at waterfall lower limit"));
        cntChannels->tooltip(gettext("Change # of psk viewer channels"));
        cntChannels->box(FL_NO_BOX);
        cntChannels->color(FL_BACKGROUND_COLOR);
        cntChannels->selection_color(FL_BACKGROUND_COLOR);
        cntChannels->labeltype(FL_NORMAL_LABEL);
        cntChannels->labelfont(0);
        cntChannels->labelsize(14);
        cntChannels->labelcolor(FL_FOREGROUND_COLOR);
        cntChannels->maximum(30);
        cntChannels->value(30);
        cntChannels->callback((Fl_Callback*)cb_cntChannels);
        cntChannels->align(Fl_Align(FL_ALIGN_RIGHT));
        cntChannels->when(FL_WHEN_RELEASE);
        o->minimum(5); o->maximum(30); o->step(1);
        o->value(progdefaults.VIEWERchannels);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Spinner2* cntChannels
      { Fl_Spinner2* o = cntTimeout = new Fl_Spinner2(278, 90, 50, 24, gettext("Inactivity timeout"));
        cntTimeout->tooltip(gettext("Clear channel text after\n# seconds of inactivity"));
        cntTimeout->box(FL_NO_BOX);
        cntTimeout->color(FL_BACKGROUND_COLOR);
        cntTimeout->selection_color(FL_BACKGROUND_COLOR);
        cntTimeout->labeltype(FL_NORMAL_LABEL);
        cntTimeout->labelfont(0);
        cntTimeout->labelsize(14);
        cntTimeout->labelcolor(FL_FOREGROUND_COLOR);
        cntTimeout->value(10);
        cntTimeout->callback((Fl_Callback*)cb_cntTimeout);
        cntTimeout->align(Fl_Align(FL_ALIGN_RIGHT));
        cntTimeout->when(FL_WHEN_RELEASE);
        o->minimum(1); o->maximum(180); o->step(1);
        o->value(progdefaults.VIEWERtimeout);
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Spinner2* cntTimeout
      { Fl_ListBox* o = listboxViewerLabel = new Fl_ListBox(278, 130, 150, 24, gettext("Channel label"));
        listboxViewerLabel->tooltip(gettext("Appearance of label on each channel"));
        listboxViewerLabel->box(FL_DOWN_BOX);
        listboxViewerLabel->color(FL_BACKGROUND2_COLOR);
        listboxViewerLabel->selection_color(FL_BACKGROUND_COLOR);
        listboxViewerLabel->labeltype(FL_NORMAL_LABEL);
        listboxViewerLabel->labelfont(0);
        listboxViewerLabel->labelsize(14);
        listboxViewerLabel->labelcolor(FL_FOREGROUND_COLOR);
        listboxViewerLabel->callback((Fl_Callback*)cb_listboxViewerLabel);
        listboxViewerLabel->align(Fl_Align(FL_ALIGN_RIGHT));
        listboxViewerLabel->when(FL_WHEN_RELEASE);
        listboxViewerLabel->add(_("None")); listboxViewerLabel->add(_("Audio frequency"));
        listboxViewerLabel->add(_("Radio frequency")); listboxViewerLabel->add(_("Channel number"));
        listboxViewerLabel->index(progdefaults.VIEWERlabeltype);
                       o->labelsize(FL_NORMAL_SIZE);
        listboxViewerLabel->end();
      } // Fl_ListBox* listboxViewerLabel
      { btnViewerFont = new Fl_Button(563, 130, 70, 24, gettext("Font..."));
        btnViewerFont->tooltip(gettext("select browser font"));
        btnViewerFont->callback((Fl_Callback*)cb_btnViewerFont);
      } // Fl_Button* btnViewerFont
      { Fl_Check_Button* o = btnFixedIntervals = new Fl_Check_Button(468, 92, 165, 20, gettext("Fixed Intervals"));
        btnFixedIntervals->tooltip(gettext("Force channel spacing to even 100 Hz increments"));
        btnFixedIntervals->down_box(FL_DOWN_BOX);
        btnFixedIntervals->value(1);
        btnFixedIntervals->callback((Fl_Callback*)cb_btnFixedIntervals);
        o->value(progdefaults.VIEWERfixed);
      } // Fl_Check_Button* btnFixedIntervals
      { Fl_Check_Button* o = btnMarquee = new Fl_Check_Button(278, 168, 165, 20, gettext("Continuous scrolling"));
        btnMarquee->tooltip(gettext("ON - Marquee style\nOFF - Clear & restart"));
        btnMarquee->down_box(FL_DOWN_BOX);
        btnMarquee->callback((Fl_Callback*)cb_btnMarquee);
        o->value(progdefaults.VIEWERmarquee);
      } // Fl_Check_Button* btnMarquee
      { Fl_Check_Button* o = btnAscend = new Fl_Check_Button(278, 192, 253, 20, gettext("Lowest freq on bottom of viewer"));
        btnAscend->tooltip(gettext("Change positions of low to high channels"));
        btnAscend->down_box(FL_DOWN_BOX);
        btnAscend->callback((Fl_Callback*)cb_btnAscend);
        o->value(progdefaults.VIEWERascend);
      } // Fl_Check_Button* btnAscend
      { Fl_Check_Button* o = btnBrowserHistory = new Fl_Check_Button(278, 217, 356, 20, gettext("Play back history when active channel selected"));
        btnBrowserHistory->tooltip(gettext("Audio stream history decoded on selected signal"));
        btnBrowserHistory->down_box(FL_DOWN_BOX);
        btnBrowserHistory->callback((Fl_Callback*)cb_btnBrowserHistory);
        o->value(progdefaults.VIEWERhistory);
      } // Fl_Check_Button* btnBrowserHistory
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("UI/Browser/Channels"));
      config_pages.push_back(p);
      tab_tree->add(_("UI/Browser/Channels"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("UI/Browser/Colors"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { bwsrHiLite_1_color = new Fl_Button(259, 113, 62, 22, gettext("HiLite 1"));
        bwsrHiLite_1_color->tooltip(gettext("PSK/RTTY Viewer HiLite Color 1"));
        bwsrHiLite_1_color->callback((Fl_Callback*)cb_bwsrHiLite_1_color);
        bwsrHiLite_1_color->align(Fl_Align(FL_ALIGN_TOP));
        bwsrHiLite_1_color->color((Fl_Color)progdefaults.bwsrHiLight1);
      } // Fl_Button* bwsrHiLite_1_color
      { bwsrHiLite_2_color = new Fl_Button(361, 113, 62, 22, gettext("HiLite 2"));
        bwsrHiLite_2_color->tooltip(gettext("PSK/RTTY Viewer HiLite Color 2"));
        bwsrHiLite_2_color->callback((Fl_Callback*)cb_bwsrHiLite_2_color);
        bwsrHiLite_2_color->align(Fl_Align(FL_ALIGN_TOP));
        bwsrHiLite_2_color->color((Fl_Color)progdefaults.bwsrHiLight2);
      } // Fl_Button* bwsrHiLite_2_color
      { bwsrHiLite_even_lines = new Fl_Button(464, 113, 62, 22, gettext("Even"));
        bwsrHiLite_even_lines->tooltip(gettext("Even lines"));
        bwsrHiLite_even_lines->callback((Fl_Callback*)cb_bwsrHiLite_even_lines);
        bwsrHiLite_even_lines->align(Fl_Align(FL_ALIGN_TOP));
        bwsrHiLite_even_lines->color((Fl_Color)progdefaults.bwsrBackgnd2);
      } // Fl_Button* bwsrHiLite_even_lines
      { bwsrHiLite_odd_lines = new Fl_Button(567, 113, 62, 22, gettext("Odd"));
        bwsrHiLite_odd_lines->tooltip(gettext("Odd lines"));
        bwsrHiLite_odd_lines->callback((Fl_Callback*)cb_bwsrHiLite_odd_lines);
        bwsrHiLite_odd_lines->align(Fl_Align(FL_ALIGN_TOP));
        bwsrHiLite_odd_lines->color((Fl_Color)progdefaults.bwsrBackgnd1);
      } // Fl_Button* bwsrHiLite_odd_lines
      { bwsrHiLite_select = new Fl_Button(671, 113, 62, 22, gettext("Select"));
        bwsrHiLite_select->tooltip(gettext("Select line"));
        bwsrHiLite_select->callback((Fl_Callback*)cb_bwsrHiLite_select);
        bwsrHiLite_select->align(Fl_Align(FL_ALIGN_TOP));
        bwsrHiLite_select->color((Fl_Color)progdefaults.bwsrSelect);
      } // Fl_Button* bwsrHiLite_select
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("UI/Browser/Colors"));
      config_pages.push_back(p);
      tab_tree->add(_("UI/Browser/Colors"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("UI/Browser/Detection Level"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { bwsrSliderColor = new Fl_Button(294, 118, 112, 24, gettext("Backgnd"));
        bwsrSliderColor->tooltip(gettext("Background color of signal viewer squelch control"));
        bwsrSliderColor->callback((Fl_Callback*)cb_bwsrSliderColor);
        bwsrSliderColor->align(Fl_Align(FL_ALIGN_TOP));
        bwsrSliderColor->color(RGBCOLOR(bwsrSliderColor));
      } // Fl_Button* bwsrSliderColor
      { bwsrSldrSelColor = new Fl_Button(545, 118, 112, 24, gettext("Button"));
        bwsrSldrSelColor->tooltip(gettext("Slider hilite color of signal viewer squelch control"));
        bwsrSldrSelColor->callback((Fl_Callback*)cb_bwsrSldrSelColor);
        bwsrSldrSelColor->align(Fl_Align(FL_ALIGN_TOP));
        bwsrSldrSelColor->color(RGBCOLOR(bwsrSldrSelColor));
      } // Fl_Button* bwsrSldrSelColor
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("UI/Browser/Detection Level"));
      config_pages.push_back(p);
      tab_tree->add(_("UI/Browser/Detection Level"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("UI/General"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(206, 21, 590, 76);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btnShowTooltips = new Fl_Check_Button(276, 34, 120, 20, gettext("Show tooltips"));
          btnShowTooltips->tooltip(gettext("Enable / disable tooltips"));
          btnShowTooltips->down_box(FL_DOWN_BOX);
          btnShowTooltips->value(1);
          btnShowTooltips->callback((Fl_Callback*)cb_btnShowTooltips);
          o->value(progdefaults.tooltips);
        } // Fl_Check_Button* btnShowTooltips
        { Fl_Check_Button* o = chkMenuIcons = new Fl_Check_Button(420, 34, 150, 20, gettext("Show menu icons"));
          chkMenuIcons->tooltip(gettext("Enable / disable icons on menus"));
          chkMenuIcons->down_box(FL_DOWN_BOX);
          chkMenuIcons->callback((Fl_Callback*)cb_chkMenuIcons);
          o->value(progdefaults.menuicons);
        } // Fl_Check_Button* chkMenuIcons
        { bVisibleModes = new Fl_Button(259, 63, 110, 20, gettext("Visible modes"));
          bVisibleModes->tooltip(gettext("Select modes for menu access"));
          bVisibleModes->callback((Fl_Callback*)cb_bVisibleModes);
        } // Fl_Button* bVisibleModes
        { Fl_ListBox* o = listbox_language = new Fl_ListBox(576, 63, 170, 20, gettext("UI language"));
          listbox_language->tooltip(gettext("Changes take effect on next program startup"));
          listbox_language->box(FL_DOWN_BOX);
          listbox_language->color(FL_BACKGROUND2_COLOR);
          listbox_language->selection_color(FL_BACKGROUND_COLOR);
          listbox_language->labeltype(FL_NORMAL_LABEL);
          listbox_language->labelfont(0);
          listbox_language->labelsize(12);
          listbox_language->labelcolor(FL_FOREGROUND_COLOR);
          listbox_language->callback((Fl_Callback*)cb_listbox_language);
          listbox_language->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          listbox_language->when(FL_WHEN_RELEASE);
          o->labelsize(FL_NORMAL_SIZE);
          listbox_language->end();
        } // Fl_ListBox* listbox_language
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(206, 103, 590, 34);
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_rx_lowercase = new Fl_Check_Button(246, 110, 441, 20, gettext("Print CW / RTTY / THROB / CONTESTIA in lowercase"));
          btn_rx_lowercase->down_box(FL_DOWN_BOX);
          btn_rx_lowercase->callback((Fl_Callback*)cb_btn_rx_lowercase);
          o->value(progdefaults.rx_lowercase);
        } // Fl_Check_Button* btn_rx_lowercase
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(206, 139, 294, 65);
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_tx_lowercase = new Fl_Check_Button(241, 148, 199, 20, gettext("Transmit lower case text"));
          btn_tx_lowercase->down_box(FL_DOWN_BOX);
          btn_tx_lowercase->callback((Fl_Callback*)cb_btn_tx_lowercase);
          o->value(progdefaults.tx_lowercase);
        } // Fl_Check_Button* btn_tx_lowercase
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(206, 206, 590, 76, gettext("Exit confirmations"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_save_config_on_exit = new Fl_Check_Button(246, 230, 264, 20, gettext("Save Configuration"));
          btn_save_config_on_exit->tooltip(gettext("Confirm (yes/no) to save the current configuration."));
          btn_save_config_on_exit->down_box(FL_DOWN_BOX);
          btn_save_config_on_exit->callback((Fl_Callback*)cb_btn_save_config_on_exit);
          o->value(progdefaults.SaveConfig);
        } // Fl_Check_Button* btn_save_config_on_exit
        { Fl_Check_Button* o = btn2_save_macros_on_exit = new Fl_Check_Button(246, 252, 264, 20, gettext("Save macro file"));
          btn2_save_macros_on_exit->tooltip(gettext("Confirm (yes/no) to save current macro definitions."));
          btn2_save_macros_on_exit->down_box(FL_DOWN_BOX);
          btn2_save_macros_on_exit->callback((Fl_Callback*)cb_btn2_save_macros_on_exit);
          o->value(progdefaults.SaveMacros);
        } // Fl_Check_Button* btn2_save_macros_on_exit
        { Fl_Check_Button* o = btn2NagMe = new Fl_Check_Button(523, 230, 188, 20, gettext("Save log"));
          btn2NagMe->tooltip(gettext("Confirm (yes/no) to save the log entries."));
          btn2NagMe->down_box(FL_DOWN_BOX);
          btn2NagMe->callback((Fl_Callback*)cb_btn2NagMe);
          o->value(progdefaults.NagMe);
        } // Fl_Check_Button* btn2NagMe
        { Fl_Check_Button* o = btn2_confirm_exit = new Fl_Check_Button(523, 252, 226, 20, gettext("Exit"));
          btn2_confirm_exit->tooltip(gettext("Confirm (yes/no) to end execution."));
          btn2_confirm_exit->down_box(FL_DOWN_BOX);
          btn2_confirm_exit->callback((Fl_Callback*)cb_btn2_confirm_exit);
          o->value(progdefaults.confirmExit);
        } // Fl_Check_Button* btn2_confirm_exit
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(206, 285, 590, 60, gettext("Check for updates"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_check_for_updates = new Fl_Check_Button(246, 308, 367, 20, gettext("Check for updates when starting program"));
          btn_check_for_updates->down_box(FL_DOWN_BOX);
          btn_check_for_updates->callback((Fl_Callback*)cb_btn_check_for_updates);
          o->value(progdefaults.check_for_updates);
        } // Fl_Check_Button* btn_check_for_updates
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(501, 139, 295, 65);
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_tx_show_timer = new Fl_Check_Button(520, 148, 219, 20, gettext("Show TX timer"));
          btn_tx_show_timer->down_box(FL_DOWN_BOX);
          btn_tx_show_timer->callback((Fl_Callback*)cb_btn_tx_show_timer);
          o->value(progdefaults.show_tx_timer);
        } // Fl_Check_Button* btn_tx_show_timer
        { Fl_Spinner* o = val_tx_timeout = new Fl_Spinner(521, 173, 45, 24, gettext("TX deadmen timeout (mins)"));
          val_tx_timeout->minimum(0);
          val_tx_timeout->maximum(60);
          val_tx_timeout->value(10);
          val_tx_timeout->callback((Fl_Callback*)cb_val_tx_timeout);
          val_tx_timeout->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.tx_timeout);
        } // Fl_Spinner* val_tx_timeout
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("UI/General"));
      config_pages.push_back(p);
      tab_tree->add(_("UI/General"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("UI/Macro buttons"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(205, 205, 590, 35);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btnMacroMouseWheel = new Fl_Check_Button(262, 213, 296, 20, gettext("Mouse wheel active on macro buttons"));
          btnMacroMouseWheel->tooltip(gettext("enable mouse wheel control of macro bar"));
          btnMacroMouseWheel->down_box(FL_DOWN_BOX);
          btnMacroMouseWheel->callback((Fl_Callback*)cb_btnMacroMouseWheel);
          o->value(progdefaults.macro_wheel);
        } // Fl_Check_Button* btnMacroMouseWheel
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 25, 590, 180, gettext("Number and position of macro bars"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cnt_macro_height = new Fl_Counter(415, 50, 89, 22, gettext("Button Height"));
          cnt_macro_height->tooltip(gettext("Height of macro bar"));
          cnt_macro_height->type(1);
          cnt_macro_height->minimum(18);
          cnt_macro_height->maximum(30);
          cnt_macro_height->step(1);
          cnt_macro_height->value(20);
          cnt_macro_height->callback((Fl_Callback*)cb_cnt_macro_height);
          cnt_macro_height->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.macro_height);
        } // Fl_Counter* cnt_macro_height
        { btn_scheme_0 = new Fl_Round_Button(261, 78, 144, 22, gettext("One above Rx/Tx"));
          btn_scheme_0->tooltip(gettext("Single macro bar below logging panel\nvariable height"));
          btn_scheme_0->type(102);
          btn_scheme_0->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_0->callback((Fl_Callback*)cb_btn_scheme_0);
        } // Fl_Round_Button* btn_scheme_0
        { btn_scheme_1 = new Fl_Round_Button(261, 103, 144, 22, gettext("One above waterfall"));
          btn_scheme_1->type(102);
          btn_scheme_1->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_1->callback((Fl_Callback*)cb_btn_scheme_1);
        } // Fl_Round_Button* btn_scheme_1
        { btn_scheme_2 = new Fl_Round_Button(261, 128, 144, 22, gettext("One below waterfall"));
          btn_scheme_2->type(102);
          btn_scheme_2->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_2->callback((Fl_Callback*)cb_btn_scheme_2);
        } // Fl_Round_Button* btn_scheme_2
        { btn_scheme_3 = new Fl_Round_Button(428, 78, 144, 22, gettext("Two scheme 1"));
          btn_scheme_3->type(102);
          btn_scheme_3->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_3->callback((Fl_Callback*)cb_btn_scheme_3);
        } // Fl_Round_Button* btn_scheme_3
        { btn_scheme_4 = new Fl_Round_Button(596, 78, 144, 22, gettext("Two scheme 2"));
          btn_scheme_4->type(102);
          btn_scheme_4->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_4->callback((Fl_Callback*)cb_btn_scheme_4);
        } // Fl_Round_Button* btn_scheme_4
        { btn_scheme_5 = new Fl_Round_Button(428, 103, 144, 22, gettext("Two scheme 3"));
          btn_scheme_5->type(102);
          btn_scheme_5->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_5->callback((Fl_Callback*)cb_btn_scheme_5);
        } // Fl_Round_Button* btn_scheme_5
        { btn_scheme_6 = new Fl_Round_Button(596, 103, 144, 22, gettext("Two scheme 4"));
          btn_scheme_6->type(102);
          btn_scheme_6->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_6->callback((Fl_Callback*)cb_btn_scheme_6);
        } // Fl_Round_Button* btn_scheme_6
        { btn_scheme_7 = new Fl_Round_Button(428, 128, 144, 22, gettext("Two scheme 5"));
          btn_scheme_7->type(102);
          btn_scheme_7->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_7->callback((Fl_Callback*)cb_btn_scheme_7);
        } // Fl_Round_Button* btn_scheme_7
        { btn_scheme_8 = new Fl_Round_Button(596, 128, 144, 22, gettext("Two scheme 6"));
          btn_scheme_8->type(102);
          btn_scheme_8->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_8->callback((Fl_Callback*)cb_btn_scheme_8);
        } // Fl_Round_Button* btn_scheme_8
        { btn_scheme_9 = new Fl_Round_Button(428, 153, 144, 22, gettext("Two scheme 7"));
          btn_scheme_9->type(102);
          btn_scheme_9->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_9->callback((Fl_Callback*)cb_btn_scheme_9);
        } // Fl_Round_Button* btn_scheme_9
        { btn_scheme_10 = new Fl_Round_Button(596, 153, 144, 22, gettext("Two scheme 8"));
          btn_scheme_10->type(102);
          btn_scheme_10->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_10->callback((Fl_Callback*)cb_btn_scheme_10);
        } // Fl_Round_Button* btn_scheme_10
        { btn_scheme_11 = new Fl_Round_Button(428, 178, 144, 22, gettext("Two scheme 9"));
          btn_scheme_11->type(102);
          btn_scheme_11->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_11->callback((Fl_Callback*)cb_btn_scheme_11);
        } // Fl_Round_Button* btn_scheme_11
        { btn_scheme_12 = new Fl_Round_Button(596, 178, 144, 22, gettext("Two scheme 10"));
          btn_scheme_12->type(102);
          btn_scheme_12->down_box(FL_ROUND_DOWN_BOX);
          btn_scheme_12->callback((Fl_Callback*)cb_btn_scheme_12);
        } // Fl_Round_Button* btn_scheme_12
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 240, 590, 55);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btnUseLastMacro = new Fl_Check_Button(262, 245, 277, 20, gettext("Load last used macro file at start"));
          btnUseLastMacro->tooltip(gettext("ON - use last set of macros\nOFF - use default set"));
          btnUseLastMacro->down_box(FL_DOWN_BOX);
          btnUseLastMacro->callback((Fl_Callback*)cb_btnUseLastMacro);
          o->value(progdefaults.UseLastMacro);
        } // Fl_Check_Button* btnUseLastMacro
        { Fl_Check_Button* o = btnDisplayMacroFilename = new Fl_Check_Button(262, 267, 277, 20, gettext("Display macro filename at start"));
          btnDisplayMacroFilename->tooltip(gettext("The filename is written to the RX text area"));
          btnDisplayMacroFilename->down_box(FL_DOWN_BOX);
          btnDisplayMacroFilename->callback((Fl_Callback*)cb_btnDisplayMacroFilename);
          o->value(progdefaults.DisplayMacroFilename);
        } // Fl_Check_Button* btnDisplayMacroFilename
        { Fl_Check_Button* o = btn_save_macros_on_exit = new Fl_Check_Button(545, 245, 216, 20, gettext("Prompt to save macro file"));
          btn_save_macros_on_exit->tooltip(gettext("Write current macro set on program exit"));
          btn_save_macros_on_exit->down_box(FL_DOWN_BOX);
          btn_save_macros_on_exit->callback((Fl_Callback*)cb_btn_save_macros_on_exit);
          o->value(progdefaults.SaveMacros);
        } // Fl_Check_Button* btn_save_macros_on_exit
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(205, 295, 295, 45);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btn_macro_post = new Fl_Check_Button(265, 307, 216, 20, gettext("Show macro control codes"));
          btn_macro_post->tooltip(gettext("print ^! execution codes in Rx panel"));
          btn_macro_post->down_box(FL_DOWN_BOX);
          btn_macro_post->callback((Fl_Callback*)cb_btn_macro_post);
          o->value(progdefaults.macro_post);
        } // Fl_Check_Button* btn_macro_post
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(500, 295, 295, 45);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btn_4bar_position = new Fl_Check_Button(532, 307, 216, 20, gettext("4 bar macro set below Tx"));
          btn_4bar_position->tooltip(gettext("Position the 4 bar macro set below Tx panel\nDefault above Rx panel"));
          btn_4bar_position->down_box(FL_DOWN_BOX);
          btn_4bar_position->callback((Fl_Callback*)cb_btn_4bar_position);
          o->value(progdefaults.four_bar_position);
        } // Fl_Check_Button* btn_4bar_position
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("UI/Macro buttons"));
      config_pages.push_back(p);
      tab_tree->add(_("UI/Macro buttons"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 2, 600, 350, gettext("UI/Rx Text"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Check_Button* o = btnRXClicks = new Fl_Check_Button(242, 118, 191, 20, gettext("Single-click to capture"));
        btnRXClicks->tooltip(gettext("Enable for single click capure of text in Rx panel"));
        btnRXClicks->down_box(FL_DOWN_BOX);
        btnRXClicks->callback((Fl_Callback*)cb_btnRXClicks);
        o->value(progdefaults.rxtext_clicks_qso_data);
      } // Fl_Check_Button* btnRXClicks
      { Fl_Check_Button* o = btnRXTooltips = new Fl_Check_Button(484, 118, 254, 20, gettext("callsign tooltips in received text"));
        btnRXTooltips->tooltip(gettext("Popup info after a 2 second hover on a callsign"));
        btnRXTooltips->down_box(FL_DOWN_BOX);
        btnRXTooltips->callback((Fl_Callback*)cb_btnRXTooltips);
        o->value(progdefaults.rxtext_tooltips);
      } // Fl_Check_Button* btnRXTooltips
      { Fl_Input2* o = inpNonword = new Fl_Input2(384, 84, 279, 24, gettext("Word delimiters"));
        inpNonword->tooltip(gettext("RX text QSO data entry is bounded by the non-word characters\ndefined here. T"
"ab and newline are automatically included."));
        inpNonword->box(FL_DOWN_BOX);
        inpNonword->color(FL_BACKGROUND2_COLOR);
        inpNonword->selection_color(FL_SELECTION_COLOR);
        inpNonword->labeltype(FL_NORMAL_LABEL);
        inpNonword->labelfont(0);
        inpNonword->labelsize(14);
        inpNonword->labelcolor(FL_FOREGROUND_COLOR);
        inpNonword->textfont(4);
        inpNonword->callback((Fl_Callback*)cb_inpNonword);
        inpNonword->align(Fl_Align(FL_ALIGN_LEFT));
        inpNonword->when(FL_WHEN_RELEASE);
        o->value(progdefaults.nonwordchars.c_str());
        o->labelsize(FL_NORMAL_SIZE);
      } // Fl_Input2* inpNonword
      { Fl_Check_Button* o = btnUSunits = new Fl_Check_Button(484, 147, 220, 20, gettext("US units of distance (QRB)"));
        btnUSunits->tooltip(gettext("Enable for single click capure of text in Rx panel"));
        btnUSunits->down_box(FL_DOWN_BOX);
        btnUSunits->callback((Fl_Callback*)cb_btnUSunits);
        o->value(progdefaults.us_units);
      } // Fl_Check_Button* btnUSunits
      { Fl_Check_Button* o = btn_clear_fields = new Fl_Check_Button(242, 147, 198, 20, gettext("Clear log fields - new CALL"));
        btn_clear_fields->down_box(FL_DOWN_BOX);
        btn_clear_fields->callback((Fl_Callback*)cb_btn_clear_fields);
        o->value(progdefaults.clear_fields);
      } // Fl_Check_Button* btn_clear_fields
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("UI/Rx Text"));
      config_pages.push_back(p);
      tab_tree->add(_("UI/Rx Text"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("UI/Touch"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Box* o = new Fl_Box(216, 44, 570, 52, gettext("Note:\nThese configuration items are useful for but not unique to using fldig"
"i on a\ntouch screen device such as a tablet."));
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Group* o = new Fl_Group(216, 110, 570, 102, gettext("Arrow Key Control of Frequency Entry"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Box* o = new Fl_Box(231, 135, 290, 74, gettext("Right/Left = 1 x LSD\nUp/Dn= 10 x LSD\nShift - Right/Left = 100 x LSD\nShift "
"- Up/Dn = 1000 x LSD"));
          o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Choice* o = sel_lsd = new Fl_Choice(621, 171, 90, 24, gettext("Right/Left\nSelect Least Signficant Digit"));
          sel_lsd->down_box(FL_BORDER_BOX);
          sel_lsd->callback((Fl_Callback*)cb_sel_lsd);
          sel_lsd->align(Fl_Align(FL_ALIGN_TOP));
          o->add("1 Hz|10 Hz|100 Hz|1 kHz");
          o->value(progdefaults.sel_lsd);
        } // Fl_Choice* sel_lsd
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(216, 221, 570, 64, gettext("Rx / Tx Panels"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_rxtx_swap = new Fl_Check_Button(336, 225, 116, 30, gettext("Tx above Rx"));
          btn_rxtx_swap->tooltip(gettext("Enable to put Tx panel above Rx panel"));
          btn_rxtx_swap->down_box(FL_DOWN_BOX);
          btn_rxtx_swap->callback((Fl_Callback*)cb_btn_rxtx_swap);
          o->value(progdefaults.rxtx_swap);
        } // Fl_Check_Button* btn_rxtx_swap
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("UI/Touch"));
      config_pages.push_back(p);
      tab_tree->add(_("UI/Touch"));
      tab_tree->close(_("UI"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Waterfall/Buttons & Controls"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Box* o = new Fl_Box(285, 70, 446, 25, gettext("Enable check box to show each respective operator control"));
        o->box(FL_FLAT_BOX);
        o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Check_Button* o = btnWF_UIrev = new Fl_Check_Button(312, 103, 150, 20, gettext("Reverse"));
        btnWF_UIrev->down_box(FL_DOWN_BOX);
        btnWF_UIrev->value(1);
        btnWF_UIrev->callback((Fl_Callback*)cb_btnWF_UIrev);
        o->value(progdefaults.WF_UIrev);
      } // Fl_Check_Button* btnWF_UIrev
      { Fl_Check_Button* o = btnWF_UIx1 = new Fl_Check_Button(531, 103, 162, 20, gettext("WF Magnification"));
        btnWF_UIx1->down_box(FL_DOWN_BOX);
        btnWF_UIx1->value(1);
        btnWF_UIx1->callback((Fl_Callback*)cb_btnWF_UIx1);
        o->value(progdefaults.WF_UIx1);
      } // Fl_Check_Button* btnWF_UIx1
      { Fl_Check_Button* o = btnWF_UIwfcarrier = new Fl_Check_Button(312, 134, 150, 20, gettext("WF carrier"));
        btnWF_UIwfcarrier->down_box(FL_DOWN_BOX);
        btnWF_UIwfcarrier->value(1);
        btnWF_UIwfcarrier->callback((Fl_Callback*)cb_btnWF_UIwfcarrier);
        o->value(progdefaults.WF_UIwfcarrier);
      } // Fl_Check_Button* btnWF_UIwfcarrier
      { Fl_Check_Button* o = btnWF_UIwfshift = new Fl_Check_Button(531, 134, 150, 20, gettext("WF Shift Controls"));
        btnWF_UIwfshift->down_box(FL_DOWN_BOX);
        btnWF_UIwfshift->value(1);
        btnWF_UIwfshift->callback((Fl_Callback*)cb_btnWF_UIwfshift);
        o->value(progdefaults.WF_UIwfshift);
      } // Fl_Check_Button* btnWF_UIwfshift
      { Fl_Check_Button* o = btnWF_UIwfreflevel = new Fl_Check_Button(312, 166, 150, 20, gettext("WF ref level"));
        btnWF_UIwfreflevel->down_box(FL_DOWN_BOX);
        btnWF_UIwfreflevel->value(1);
        btnWF_UIwfreflevel->callback((Fl_Callback*)cb_btnWF_UIwfreflevel);
        o->value(progdefaults.WF_UIwfreflevel);
      } // Fl_Check_Button* btnWF_UIwfreflevel
      { Fl_Check_Button* o = btnWF_UIwfdrop = new Fl_Check_Button(531, 166, 150, 20, gettext("WF drop rate"));
        btnWF_UIwfdrop->down_box(FL_DOWN_BOX);
        btnWF_UIwfdrop->value(1);
        btnWF_UIwfdrop->callback((Fl_Callback*)cb_btnWF_UIwfdrop);
        o->value(progdefaults.WF_UIwfdrop);
      } // Fl_Check_Button* btnWF_UIwfdrop
      { Fl_Check_Button* o = btnWF_UIwfampspan = new Fl_Check_Button(312, 198, 150, 20, gettext("WF amp span"));
        btnWF_UIwfampspan->down_box(FL_DOWN_BOX);
        btnWF_UIwfampspan->value(1);
        btnWF_UIwfampspan->callback((Fl_Callback*)cb_btnWF_UIwfampspan);
        o->value(progdefaults.WF_UIwfampspan);
      } // Fl_Check_Button* btnWF_UIwfampspan
      { Fl_Check_Button* o = btnWF_UIwfstore = new Fl_Check_Button(531, 198, 150, 20, gettext("WF Store"));
        btnWF_UIwfstore->down_box(FL_DOWN_BOX);
        btnWF_UIwfstore->value(1);
        btnWF_UIwfstore->callback((Fl_Callback*)cb_btnWF_UIwfstore);
        o->value(progdefaults.WF_UIwfstore);
      } // Fl_Check_Button* btnWF_UIwfstore
      { Fl_Check_Button* o = btnWF_UIwfmode = new Fl_Check_Button(312, 230, 150, 20, gettext("WF mode"));
        btnWF_UIwfmode->down_box(FL_DOWN_BOX);
        btnWF_UIwfmode->value(1);
        btnWF_UIwfmode->callback((Fl_Callback*)cb_btnWF_UIwfmode);
        o->value(progdefaults.WF_UIwfmode);
      } // Fl_Check_Button* btnWF_UIwfmode
      { Fl_Check_Button* o = btnWF_UIqsy = new Fl_Check_Button(531, 230, 150, 20, gettext("QSY"));
        btnWF_UIqsy->down_box(FL_DOWN_BOX);
        btnWF_UIqsy->value(1);
        btnWF_UIqsy->callback((Fl_Callback*)cb_btnWF_UIqsy);
        o->value(progdefaults.WF_UIqsy);
      } // Fl_Check_Button* btnWF_UIqsy
      { Fl_Check_Button* o = btnWF_UIxmtlock = new Fl_Check_Button(531, 262, 150, 20, gettext("XMT lock"));
        btnWF_UIxmtlock->down_box(FL_DOWN_BOX);
        btnWF_UIxmtlock->value(1);
        btnWF_UIxmtlock->callback((Fl_Callback*)cb_btnWF_UIxmtlock);
        o->value(progdefaults.WF_UIxmtlock);
      } // Fl_Check_Button* btnWF_UIxmtlock
      { btn_wf_enable_all = new Fl_Button(356, 285, 88, 20, gettext("Enable all"));
        btn_wf_enable_all->callback((Fl_Callback*)cb_btn_wf_enable_all);
      } // Fl_Button* btn_wf_enable_all
      { btn_wf_disable_all = new Fl_Button(555, 285, 88, 20, gettext("Disable all"));
        btn_wf_disable_all->callback((Fl_Callback*)cb_btn_wf_disable_all);
      } // Fl_Button* btn_wf_disable_all
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Waterfall/Buttons & Controls"));
      config_pages.push_back(p);
      tab_tree->add(_("Waterfall/Buttons & Controls"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Waterfall/Display"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(210, 32, 580, 190, gettext("Colors and cursors"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { colorbox* o = WF_Palette = new colorbox(219, 68, 380, 24, gettext("aa"));
          WF_Palette->box(FL_DOWN_BOX);
          WF_Palette->color(FL_FOREGROUND_COLOR);
          WF_Palette->selection_color(FL_BACKGROUND_COLOR);
          WF_Palette->labeltype(FL_NORMAL_LABEL);
          WF_Palette->labelfont(0);
          WF_Palette->labelsize(12);
          WF_Palette->labelcolor(FL_FOREGROUND_COLOR);
          WF_Palette->callback((Fl_Callback*)cb_WF_Palette);
          WF_Palette->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          WF_Palette->when(FL_WHEN_RELEASE);
          o->label(progdefaults.PaletteName.c_str());
          o->labelsize(FL_NORMAL_SIZE);
        } // colorbox* WF_Palette
        { btnColor[0] = new Fl_Button(219, 94, 20, 24);
          btnColor[0]->tooltip(gettext("Change color"));
          btnColor[0]->callback((Fl_Callback*)cb_btnColor);
        } // Fl_Button* btnColor[0]
        { btnColor[1] = new Fl_Button(264, 94, 20, 24);
          btnColor[1]->tooltip(gettext("Change color"));
          btnColor[1]->callback((Fl_Callback*)cb_btnColor1);
        } // Fl_Button* btnColor[1]
        { btnColor[2] = new Fl_Button(309, 94, 20, 24);
          btnColor[2]->tooltip(gettext("Change color"));
          btnColor[2]->callback((Fl_Callback*)cb_btnColor2);
        } // Fl_Button* btnColor[2]
        { btnColor[3] = new Fl_Button(354, 94, 20, 24);
          btnColor[3]->tooltip(gettext("Change color"));
          btnColor[3]->callback((Fl_Callback*)cb_btnColor3);
        } // Fl_Button* btnColor[3]
        { btnColor[4] = new Fl_Button(399, 94, 20, 24);
          btnColor[4]->tooltip(gettext("Change color"));
          btnColor[4]->callback((Fl_Callback*)cb_btnColor4);
        } // Fl_Button* btnColor[4]
        { btnColor[5] = new Fl_Button(444, 94, 20, 24);
          btnColor[5]->tooltip(gettext("Change color"));
          btnColor[5]->callback((Fl_Callback*)cb_btnColor5);
        } // Fl_Button* btnColor[5]
        { btnColor[6] = new Fl_Button(489, 94, 20, 24);
          btnColor[6]->tooltip(gettext("Change color"));
          btnColor[6]->callback((Fl_Callback*)cb_btnColor6);
        } // Fl_Button* btnColor[6]
        { btnColor[7] = new Fl_Button(534, 94, 20, 24);
          btnColor[7]->tooltip(gettext("Change color"));
          btnColor[7]->callback((Fl_Callback*)cb_btnColor7);
        } // Fl_Button* btnColor[7]
        { btnColor[8] = new Fl_Button(579, 94, 20, 24);
          btnColor[8]->tooltip(gettext("Change color"));
          btnColor[8]->callback((Fl_Callback*)cb_btnColor8);
        } // Fl_Button* btnColor[8]
        { btnLoadPalette = new Fl_Button(609, 68, 70, 24, gettext("Load..."));
          btnLoadPalette->tooltip(gettext("Load a new palette"));
          btnLoadPalette->callback((Fl_Callback*)cb_btnLoadPalette);
        } // Fl_Button* btnLoadPalette
        { btnSavePalette = new Fl_Button(609, 94, 70, 24, gettext("Save..."));
          btnSavePalette->tooltip(gettext("Save this palette"));
          btnSavePalette->callback((Fl_Callback*)cb_btnSavePalette);
        } // Fl_Button* btnSavePalette
        { Fl_Group* o = new Fl_Group(218, 122, 90, 96, gettext("Signal BW"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Check_Button* o = btnUseCursorLines = new Fl_Check_Button(220, 142, 56, 20, gettext("ON"));
            btnUseCursorLines->tooltip(gettext("Show cursor with bandwidth lines"));
            btnUseCursorLines->down_box(FL_DOWN_BOX);
            btnUseCursorLines->callback((Fl_Callback*)cb_btnUseCursorLines);
            o->value(progdefaults.UseCursorLines);
          } // Fl_Check_Button* btnUseCursorLines
          { Fl_Button* o = btnCursorBWcolor = new Fl_Button(220, 165, 20, 20, gettext("Color"));
            btnCursorBWcolor->tooltip(gettext("Change color"));
            btnCursorBWcolor->color((Fl_Color)3);
            btnCursorBWcolor->callback((Fl_Callback*)cb_btnCursorBWcolor);
            btnCursorBWcolor->align(Fl_Align(FL_ALIGN_RIGHT));
            o->color(RGBCOLOR(cursorLine));
          } // Fl_Button* btnCursorBWcolor
          { Fl_Check_Button* o = btnUseWideCursor = new Fl_Check_Button(220, 188, 62, 20, gettext("Wide"));
            btnUseWideCursor->down_box(FL_DOWN_BOX);
            btnUseWideCursor->callback((Fl_Callback*)cb_btnUseWideCursor);
            o->value(progdefaults.UseWideCursor);
          } // Fl_Check_Button* btnUseWideCursor
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(312, 122, 90, 96, gettext("Center line"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Check_Button* o = btnUseCursorCenterLine = new Fl_Check_Button(318, 142, 48, 20, gettext("ON"));
            btnUseCursorCenterLine->tooltip(gettext("Show cursor with center line"));
            btnUseCursorCenterLine->down_box(FL_DOWN_BOX);
            btnUseCursorCenterLine->callback((Fl_Callback*)cb_btnUseCursorCenterLine);
            o->value(progdefaults.UseCursorCenterLine);
          } // Fl_Check_Button* btnUseCursorCenterLine
          { Fl_Button* o = btnCursorCenterLineColor = new Fl_Button(318, 165, 20, 20, gettext("Color"));
            btnCursorCenterLineColor->tooltip(gettext("Change color"));
            btnCursorCenterLineColor->color(FL_BACKGROUND2_COLOR);
            btnCursorCenterLineColor->callback((Fl_Callback*)cb_btnCursorCenterLineColor);
            btnCursorCenterLineColor->align(Fl_Align(FL_ALIGN_RIGHT));
            o->color(RGBCOLOR(cursorCenter));
          } // Fl_Button* btnCursorCenterLineColor
          { Fl_Check_Button* o = btnUseWideCenter = new Fl_Check_Button(318, 190, 69, 20, gettext("Wide"));
            btnUseWideCenter->down_box(FL_DOWN_BOX);
            btnUseWideCenter->callback((Fl_Callback*)cb_btnUseWideCenter);
            o->value(progdefaults.UseWideCenter);
          } // Fl_Check_Button* btnUseWideCenter
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(406, 122, 90, 96, gettext("Signal trks"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Check_Button* o = btnUseBWTracks = new Fl_Check_Button(408, 141, 56, 20, gettext("ON"));
            btnUseBWTracks->tooltip(gettext("Show bandwidth tracks on waterfall"));
            btnUseBWTracks->down_box(FL_DOWN_BOX);
            btnUseBWTracks->callback((Fl_Callback*)cb_btnUseBWTracks);
            o->value(progdefaults.UseBWTracks);
          } // Fl_Check_Button* btnUseBWTracks
          { Fl_Button* o = btnBwTracksColor = new Fl_Button(408, 164, 20, 20, gettext("Color"));
            btnBwTracksColor->tooltip(gettext("Change color"));
            btnBwTracksColor->color((Fl_Color)1);
            btnBwTracksColor->callback((Fl_Callback*)cb_btnBwTracksColor);
            btnBwTracksColor->align(Fl_Align(FL_ALIGN_RIGHT));
            o->color(RGBCOLOR(bwTrack));
          } // Fl_Button* btnBwTracksColor
          { Fl_Check_Button* o = btnUseWideTracks = new Fl_Check_Button(408, 188, 74, 20, gettext("Wide"));
            btnUseWideTracks->down_box(FL_DOWN_BOX);
            btnUseWideTracks->callback((Fl_Callback*)cb_btnUseWideTracks);
            o->value(progdefaults.UseWideTracks);
          } // Fl_Check_Button* btnUseWideTracks
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(501, 122, 90, 96, gettext("Notch"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Button* o = btnNotchColor = new Fl_Button(503, 164, 20, 20, gettext("Color"));
            btnNotchColor->tooltip(gettext("Change color"));
            btnNotchColor->color((Fl_Color)1);
            btnNotchColor->callback((Fl_Callback*)cb_btnNotchColor);
            btnNotchColor->align(Fl_Align(FL_ALIGN_RIGHT));
            o->color(RGBCOLOR(notch));
          } // Fl_Button* btnNotchColor
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(595, 124, 90, 96, gettext("RsID Zone"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Button* o = btnRsIDZoneColor = new Fl_Button(597, 166, 20, 20, gettext("Color"));
            btnRsIDZoneColor->tooltip(gettext("Change color"));
            btnRsIDZoneColor->color((Fl_Color)1);
            btnRsIDZoneColor->callback((Fl_Callback*)cb_btnRsIDZoneColor);
            btnRsIDZoneColor->align(Fl_Align(FL_ALIGN_RIGHT));
            o->color( RGBCOLOR( rsid ) );
          } // Fl_Button* btnRsIDZoneColor
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(690, 122, 90, 96, gettext("Monitor"));
          o->tooltip(gettext("Audio monitor"));
          o->box(FL_ENGRAVED_FRAME);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
          { Fl_Button* o = btnMonitorColor = new Fl_Button(692, 164, 20, 20, gettext("Color"));
            btnMonitorColor->tooltip(gettext("Change color"));
            btnMonitorColor->color((Fl_Color)2);
            btnMonitorColor->callback((Fl_Callback*)cb_btnMonitorColor);
            btnMonitorColor->align(Fl_Align(FL_ALIGN_RIGHT));
            o->color( RGBCOLOR( monitor ) );
          } // Fl_Button* btnMonitorColor
          { Fl_Check_Button* o = btnUseWideMonitor = new Fl_Check_Button(692, 190, 74, 20, gettext("Wide"));
            btnUseWideMonitor->down_box(FL_DOWN_BOX);
            btnUseWideMonitor->callback((Fl_Callback*)cb_btnUseWideMonitor);
            o->value(progdefaults.mon_wide_tracks);
          } // Fl_Check_Button* btnUseWideMonitor
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(210, 223, 580, 55, gettext("Frequency scale"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = chkShowAudioScale = new Fl_Check_Button(219, 246, 241, 20, gettext("Always show audio frequencies"));
          chkShowAudioScale->tooltip(gettext("Audio or RF frequencies on waterfall scale"));
          chkShowAudioScale->down_box(FL_DOWN_BOX);
          chkShowAudioScale->callback((Fl_Callback*)cb_chkShowAudioScale);
          o->value(progdefaults.wf_audioscale);
        } // Fl_Check_Button* chkShowAudioScale
        { btnWaterfallFont = new Fl_Button(519, 246, 71, 24, gettext("Font..."));
          btnWaterfallFont->tooltip(gettext("Select waterfall scale font"));
          btnWaterfallFont->callback((Fl_Callback*)cb_btnWaterfallFont);
        } // Fl_Button* btnWaterfallFont
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(210, 279, 580, 65, gettext("Transmit signal"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnViewXmtSignal = new Fl_Check_Button(219, 305, 208, 20, gettext("Monitor transmitted signal"));
          btnViewXmtSignal->tooltip(gettext("Show transmit signal on waterfall"));
          btnViewXmtSignal->down_box(FL_DOWN_BOX);
          btnViewXmtSignal->callback((Fl_Callback*)cb_btnViewXmtSignal);
          o->value(progdefaults.viewXmtSignal);
        } // Fl_Check_Button* btnViewXmtSignal
        { Fl_Counter* o = valTxMonitorLevel = new Fl_Counter(497, 304, 114, 21, gettext("Signal Level (dB)"));
          valTxMonitorLevel->tooltip(gettext("Set level for good viewing"));
          valTxMonitorLevel->minimum(-80);
          valTxMonitorLevel->maximum(0);
          valTxMonitorLevel->step(1);
          valTxMonitorLevel->value(-20);
          valTxMonitorLevel->callback((Fl_Callback*)cb_valTxMonitorLevel);
          valTxMonitorLevel->align(Fl_Align(FL_ALIGN_TOP));
          o->value(20*log10(progdefaults.TxMonitorLevel));
          o->lstep(10);
        } // Fl_Counter* valTxMonitorLevel
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Waterfall/Display"));
      config_pages.push_back(p);
      tab_tree->add(_("Waterfall/Display"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Waterfall/FFT Processing"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(251, 25, 490, 135);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Counter2* o = cntLowFreqCutoff = new Fl_Counter2(296, 43, 70, 22, gettext("Lower limit"));
          cntLowFreqCutoff->tooltip(gettext("Low frequency limit in Hz"));
          cntLowFreqCutoff->type(1);
          cntLowFreqCutoff->box(FL_UP_BOX);
          cntLowFreqCutoff->color(FL_BACKGROUND_COLOR);
          cntLowFreqCutoff->selection_color(FL_INACTIVE_COLOR);
          cntLowFreqCutoff->labeltype(FL_NORMAL_LABEL);
          cntLowFreqCutoff->labelfont(0);
          cntLowFreqCutoff->labelsize(14);
          cntLowFreqCutoff->labelcolor(FL_FOREGROUND_COLOR);
          cntLowFreqCutoff->minimum(0);
          cntLowFreqCutoff->maximum(500);
          cntLowFreqCutoff->step(50);
          cntLowFreqCutoff->value(300);
          cntLowFreqCutoff->callback((Fl_Callback*)cb_cntLowFreqCutoff);
          cntLowFreqCutoff->align(Fl_Align(FL_ALIGN_RIGHT));
          cntLowFreqCutoff->when(FL_WHEN_CHANGED);
          o->value(progdefaults.LowFreqCutoff);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntLowFreqCutoff
        { Fl_Check_Button* o = btnWFaveraging = new Fl_Check_Button(296, 79, 120, 20, gettext("FFT averaging"));
          btnWFaveraging->tooltip(gettext("Use averaging to decrease waterfall noise"));
          btnWFaveraging->down_box(FL_DOWN_BOX);
          btnWFaveraging->callback((Fl_Callback*)cb_btnWFaveraging);
          o->value(progdefaults.WFaveraging);
        } // Fl_Check_Button* btnWFaveraging
        { Fl_ListBox* o = listboxFFTPrefilter = new Fl_ListBox(296, 109, 120, 24, gettext("FFT prefilter window function"));
          listboxFFTPrefilter->tooltip(gettext("Select the type of FFT prefilter"));
          listboxFFTPrefilter->box(FL_DOWN_BOX);
          listboxFFTPrefilter->color(FL_BACKGROUND2_COLOR);
          listboxFFTPrefilter->selection_color(FL_BACKGROUND_COLOR);
          listboxFFTPrefilter->labeltype(FL_NORMAL_LABEL);
          listboxFFTPrefilter->labelfont(0);
          listboxFFTPrefilter->labelsize(14);
          listboxFFTPrefilter->labelcolor(FL_FOREGROUND_COLOR);
          listboxFFTPrefilter->callback((Fl_Callback*)cb_listboxFFTPrefilter);
          listboxFFTPrefilter->align(Fl_Align(FL_ALIGN_RIGHT));
          listboxFFTPrefilter->when(FL_WHEN_RELEASE);
          listboxFFTPrefilter->add(_("Rectangular")); listboxFFTPrefilter->add("Blackman");
          listboxFFTPrefilter->add("Hamming"); listboxFFTPrefilter->add("Hanning");
          listboxFFTPrefilter->add(_("Triangular"));
          listboxFFTPrefilter->index(progdefaults.wfPreFilter);
                       o->labelsize(FL_NORMAL_SIZE);
          listboxFFTPrefilter->end();
        } // Fl_ListBox* listboxFFTPrefilter
        { Fl_Counter2* o = cntrWfwidth = new Fl_Counter2(519, 43, 95, 22, gettext("Upper limit"));
          cntrWfwidth->tooltip(gettext("High frequency limit in Hz"));
          cntrWfwidth->type(1);
          cntrWfwidth->box(FL_UP_BOX);
          cntrWfwidth->color(FL_BACKGROUND_COLOR);
          cntrWfwidth->selection_color(FL_INACTIVE_COLOR);
          cntrWfwidth->labeltype(FL_NORMAL_LABEL);
          cntrWfwidth->labelfont(0);
          cntrWfwidth->labelsize(14);
          cntrWfwidth->labelcolor(FL_FOREGROUND_COLOR);
          cntrWfwidth->minimum(2000);
          cntrWfwidth->maximum(4000);
          cntrWfwidth->step(100);
          cntrWfwidth->value(3000);
          cntrWfwidth->callback((Fl_Callback*)cb_cntrWfwidth);
          cntrWfwidth->align(Fl_Align(FL_ALIGN_RIGHT));
          cntrWfwidth->when(FL_WHEN_CHANGED);
          o->value(progdefaults.HighFreqCutoff);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntrWfwidth
        { Fl_Counter2* o = wf_latency = new Fl_Counter2(519, 78, 95, 22, gettext("Latency"));
          wf_latency->tooltip(gettext("Signal averaging over time\n0 - least\n4 - greatest"));
          wf_latency->type(1);
          wf_latency->box(FL_UP_BOX);
          wf_latency->color(FL_BACKGROUND_COLOR);
          wf_latency->selection_color(FL_INACTIVE_COLOR);
          wf_latency->labeltype(FL_NORMAL_LABEL);
          wf_latency->labelfont(0);
          wf_latency->labelsize(14);
          wf_latency->labelcolor(FL_FOREGROUND_COLOR);
          wf_latency->minimum(1);
          wf_latency->maximum(16);
          wf_latency->step(1);
          wf_latency->value(8);
          wf_latency->callback((Fl_Callback*)cb_wf_latency);
          wf_latency->align(Fl_Align(FL_ALIGN_RIGHT));
          wf_latency->when(FL_WHEN_CHANGED);
          o->value(progdefaults.wf_latency);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* wf_latency
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(251, 166, 490, 73);
        o->tooltip(gettext("Show me more or less waterfall"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Counter* o = cntr_drop_speed = new Fl_Counter(296, 188, 95, 22, gettext("Slow drop rate"));
          cntr_drop_speed->tooltip(gettext("Normal drop speed / value"));
          cntr_drop_speed->type(1);
          cntr_drop_speed->minimum(4);
          cntr_drop_speed->maximum(32);
          cntr_drop_speed->step(2);
          cntr_drop_speed->value(4);
          cntr_drop_speed->callback((Fl_Callback*)cb_cntr_drop_speed);
          cntr_drop_speed->align(Fl_Align(FL_ALIGN_RIGHT_TOP));
          o->value(progdefaults.drop_speed);
        } // Fl_Counter* cntr_drop_speed
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(251, 246, 490, 73, gettext("Changes take effect on next program startup"));
        o->tooltip(gettext("Show me more or less waterfall"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Counter2* o = cntrWfheight = new Fl_Counter2(296, 276, 120, 22, gettext("Waterfall height in pixels"));
          cntrWfheight->tooltip(gettext("CPU usage increases with waterfall height"));
          cntrWfheight->box(FL_UP_BOX);
          cntrWfheight->color(FL_BACKGROUND_COLOR);
          cntrWfheight->selection_color(FL_INACTIVE_COLOR);
          cntrWfheight->labeltype(FL_NORMAL_LABEL);
          cntrWfheight->labelfont(0);
          cntrWfheight->labelsize(14);
          cntrWfheight->labelcolor(FL_FOREGROUND_COLOR);
          cntrWfheight->minimum(100);
          cntrWfheight->maximum(500);
          cntrWfheight->step(5);
          cntrWfheight->value(120);
          cntrWfheight->callback((Fl_Callback*)cb_cntrWfheight);
          cntrWfheight->align(Fl_Align(FL_ALIGN_RIGHT));
          cntrWfheight->when(FL_WHEN_CHANGED);
          o->value(progdefaults.wfheight);
          o->labelsize(FL_NORMAL_SIZE);
          o->lstep(50);
        } // Fl_Counter2* cntrWfheight
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Waterfall/FFT Processing"));
      config_pages.push_back(p);
      tab_tree->add(_("Waterfall/FFT Processing"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Waterfall/Mouse usage"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(211, 50, 580, 170);
        o->box(FL_ENGRAVED_FRAME);
        { Fl_Check_Button* o = btnWaterfallHistoryDefault = new Fl_Check_Button(266, 65, 340, 20, gettext("Left or right click always replays audio history"));
          btnWaterfallHistoryDefault->tooltip(gettext("Replay trackline audio"));
          btnWaterfallHistoryDefault->down_box(FL_DOWN_BOX);
          btnWaterfallHistoryDefault->callback((Fl_Callback*)cb_btnWaterfallHistoryDefault);
          o->value(progdefaults.WaterfallHistoryDefault);
        } // Fl_Check_Button* btnWaterfallHistoryDefault
        { Fl_Check_Button* o = btnWaterfallQSY = new Fl_Check_Button(266, 95, 380, 20, gettext("Dragging on the waterfall scale changes frequency"));
          btnWaterfallQSY->tooltip(gettext("Enable drag cursor on waterfall scale"));
          btnWaterfallQSY->down_box(FL_DOWN_BOX);
          btnWaterfallQSY->callback((Fl_Callback*)cb_btnWaterfallQSY);
          o->value(progdefaults.WaterfallQSY);
        } // Fl_Check_Button* btnWaterfallQSY
        { Fl_Check_Button* o = btnWaterfallClickInsert = new Fl_Check_Button(266, 137, 225, 20, gettext("Insert text on single left click"));
          btnWaterfallClickInsert->tooltip(gettext("Insert special text in Rx panel\nwhen waterfall clicked"));
          btnWaterfallClickInsert->down_box(FL_DOWN_BOX);
          btnWaterfallClickInsert->callback((Fl_Callback*)cb_btnWaterfallClickInsert);
          o->value(progdefaults.WaterfallClickInsert);
        } // Fl_Check_Button* btnWaterfallClickInsert
        { inpWaterfallClickText = new Fl_Input2(552, 125, 180, 50);
          inpWaterfallClickText->tooltip(gettext("The string <FREQ> is replaced with\nthe current modem and frequency"));
          inpWaterfallClickText->box(FL_DOWN_BOX);
          inpWaterfallClickText->color(FL_BACKGROUND2_COLOR);
          inpWaterfallClickText->selection_color(FL_SELECTION_COLOR);
          inpWaterfallClickText->labeltype(FL_NORMAL_LABEL);
          inpWaterfallClickText->labelfont(0);
          inpWaterfallClickText->labelsize(14);
          inpWaterfallClickText->labelcolor(FL_FOREGROUND_COLOR);
          inpWaterfallClickText->callback((Fl_Callback*)cb_inpWaterfallClickText);
          inpWaterfallClickText->align(Fl_Align(FL_ALIGN_RIGHT));
          inpWaterfallClickText->when(FL_WHEN_RELEASE);
        } // Fl_Input2* inpWaterfallClickText
        { Fl_ListBox* o = listboxWaterfallWheelAction = new Fl_ListBox(266, 178, 150, 22, gettext("Wheel action"));
          listboxWaterfallWheelAction->tooltip(gettext("Select how the mouse wheel\nbehaves inside the waterfall"));
          listboxWaterfallWheelAction->box(FL_DOWN_BOX);
          listboxWaterfallWheelAction->color(FL_BACKGROUND2_COLOR);
          listboxWaterfallWheelAction->selection_color(FL_BACKGROUND_COLOR);
          listboxWaterfallWheelAction->labeltype(FL_NORMAL_LABEL);
          listboxWaterfallWheelAction->labelfont(0);
          listboxWaterfallWheelAction->labelsize(14);
          listboxWaterfallWheelAction->labelcolor(FL_FOREGROUND_COLOR);
          listboxWaterfallWheelAction->callback((Fl_Callback*)cb_listboxWaterfallWheelAction);
          listboxWaterfallWheelAction->align(Fl_Align(FL_ALIGN_RIGHT));
          listboxWaterfallWheelAction->when(FL_WHEN_RELEASE);
          o->labelsize(FL_NORMAL_SIZE);
          listboxWaterfallWheelAction->end();
        } // Fl_ListBox* listboxWaterfallWheelAction
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Waterfall/Mouse usage"));
      config_pages.push_back(p);
      tab_tree->add(_("Waterfall/Mouse usage"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Waterfall/Spectrum"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(210, 50, 580, 150, gettext("Spectrum Scope / Waterfall interaction"));
        o->box(FL_ENGRAVED_BOX);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btnWFspectrum_center = new Fl_Check_Button(275, 92, 365, 20, gettext("left click transfers frequency to scope center frequency"));
          btnWFspectrum_center->tooltip(gettext("left click on WF recenters spectrum scope"));
          btnWFspectrum_center->down_box(FL_DOWN_BOX);
          btnWFspectrum_center->callback((Fl_Callback*)cb_btnWFspectrum_center);
          o->value(progdefaults.wf_spectrum_center);
        } // Fl_Check_Button* btnWFspectrum_center
        { Fl_Check_Button* o = btnWFspectrum_dbvals = new Fl_Check_Button(275, 123, 221, 20, gettext("use waterfall range/limit values"));
          btnWFspectrum_dbvals->tooltip(gettext("values left/below waterfall"));
          btnWFspectrum_dbvals->down_box(FL_DOWN_BOX);
          btnWFspectrum_dbvals->callback((Fl_Callback*)cb_btnWFspectrum_dbvals);
          o->value(progdefaults.wf_spectrum_dbvals);
        } // Fl_Check_Button* btnWFspectrum_dbvals
        { Fl_Counter* o = cntr_spectrum_freq_scale = new Fl_Counter(275, 155, 75, 20, gettext("freq scale = N * modem bandwidth"));
          cntr_spectrum_freq_scale->type(1);
          cntr_spectrum_freq_scale->minimum(1);
          cntr_spectrum_freq_scale->maximum(10);
          cntr_spectrum_freq_scale->step(1);
          cntr_spectrum_freq_scale->value(5);
          cntr_spectrum_freq_scale->callback((Fl_Callback*)cb_cntr_spectrum_freq_scale);
          cntr_spectrum_freq_scale->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(progdefaults.wf_spectrum_scale_factor);
        } // Fl_Counter* cntr_spectrum_freq_scale
        { Fl_Check_Button* o = btn_spectrum_modem_scale = new Fl_Check_Button(585, 155, 55, 20, gettext("use"));
          btn_spectrum_modem_scale->tooltip(gettext("scale spectrum display linked to modem bandwidth"));
          btn_spectrum_modem_scale->down_box(FL_DOWN_BOX);
          btn_spectrum_modem_scale->callback((Fl_Callback*)cb_btn_spectrum_modem_scale);
          o->value(progdefaults.wf_spectrum_modem_scale);
        } // Fl_Check_Button* btn_spectrum_modem_scale
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Waterfall/Spectrum"));
      config_pages.push_back(p);
      tab_tree->add(_("Waterfall/Spectrum"));
      tab_tree->close(_("Waterfall"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Web/Pskmail"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Group* o = new Fl_Group(256, 52, 490, 174, gettext("Mail Server Attributes"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Counter2* o = cntServerCarrier = new Fl_Counter2(307, 80, 80, 20, gettext("Carrier frequency (Hz)"));
          cntServerCarrier->tooltip(gettext("Default listen / transmit frequency"));
          cntServerCarrier->type(1);
          cntServerCarrier->box(FL_UP_BOX);
          cntServerCarrier->color(FL_BACKGROUND_COLOR);
          cntServerCarrier->selection_color(FL_INACTIVE_COLOR);
          cntServerCarrier->labeltype(FL_NORMAL_LABEL);
          cntServerCarrier->labelfont(0);
          cntServerCarrier->labelsize(14);
          cntServerCarrier->labelcolor(FL_FOREGROUND_COLOR);
          cntServerCarrier->minimum(500);
          cntServerCarrier->maximum(2500);
          cntServerCarrier->step(25);
          cntServerCarrier->value(1500);
          cntServerCarrier->callback((Fl_Callback*)cb_cntServerCarrier);
          cntServerCarrier->align(Fl_Align(FL_ALIGN_RIGHT));
          cntServerCarrier->when(FL_WHEN_CHANGED);
          o->value(progdefaults.ServerCarrier);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntServerCarrier
        { Fl_Counter2* o = cntServerOffset = new Fl_Counter2(307, 117, 80, 20, gettext("Search range (Hz)"));
          cntServerOffset->tooltip(gettext("Listen for signals within this range"));
          cntServerOffset->type(1);
          cntServerOffset->box(FL_UP_BOX);
          cntServerOffset->color(FL_BACKGROUND_COLOR);
          cntServerOffset->selection_color(FL_INACTIVE_COLOR);
          cntServerOffset->labeltype(FL_NORMAL_LABEL);
          cntServerOffset->labelfont(0);
          cntServerOffset->labelsize(14);
          cntServerOffset->labelcolor(FL_FOREGROUND_COLOR);
          cntServerOffset->minimum(10);
          cntServerOffset->maximum(500);
          cntServerOffset->step(10);
          cntServerOffset->value(100);
          cntServerOffset->callback((Fl_Callback*)cb_cntServerOffset);
          cntServerOffset->align(Fl_Align(FL_ALIGN_RIGHT));
          cntServerOffset->when(FL_WHEN_CHANGED);
          o->value(progdefaults.SearchRange);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntServerOffset
        { Fl_Counter2* o = cntServerACQsn = new Fl_Counter2(307, 154, 80, 20, gettext("Acquisition S/N (dB)"));
          cntServerACQsn->tooltip(gettext("Capture signals over this threshold"));
          cntServerACQsn->type(1);
          cntServerACQsn->box(FL_UP_BOX);
          cntServerACQsn->color(FL_BACKGROUND_COLOR);
          cntServerACQsn->selection_color(FL_INACTIVE_COLOR);
          cntServerACQsn->labeltype(FL_NORMAL_LABEL);
          cntServerACQsn->labelfont(0);
          cntServerACQsn->labelsize(14);
          cntServerACQsn->labelcolor(FL_FOREGROUND_COLOR);
          cntServerACQsn->minimum(3);
          cntServerACQsn->maximum(20);
          cntServerACQsn->step(1);
          cntServerACQsn->value(6);
          cntServerACQsn->callback((Fl_Callback*)cb_cntServerACQsn);
          cntServerACQsn->align(Fl_Align(FL_ALIGN_RIGHT));
          cntServerACQsn->when(FL_WHEN_CHANGED);
          o->value(progdefaults.ServerACQsn);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntServerACQsn
        { Fl_Counter2* o = cntServerAFCrange = new Fl_Counter2(307, 191, 80, 20, gettext("AFC range (Hz)"));
          cntServerAFCrange->tooltip(gettext("Limit AFC movement to this range"));
          cntServerAFCrange->type(1);
          cntServerAFCrange->box(FL_UP_BOX);
          cntServerAFCrange->color(FL_BACKGROUND_COLOR);
          cntServerAFCrange->selection_color(FL_INACTIVE_COLOR);
          cntServerAFCrange->labeltype(FL_NORMAL_LABEL);
          cntServerAFCrange->labelfont(0);
          cntServerAFCrange->labelsize(14);
          cntServerAFCrange->labelcolor(FL_FOREGROUND_COLOR);
          cntServerAFCrange->minimum(10);
          cntServerAFCrange->maximum(500);
          cntServerAFCrange->step(10);
          cntServerAFCrange->value(25);
          cntServerAFCrange->callback((Fl_Callback*)cb_cntServerAFCrange);
          cntServerAFCrange->align(Fl_Align(FL_ALIGN_RIGHT));
          cntServerAFCrange->when(FL_WHEN_CHANGED);
          o->value(progdefaults.SearchRange);
          o->labelsize(FL_NORMAL_SIZE);
        } // Fl_Counter2* cntServerAFCrange
        { Fl_Check_Button* o = btnPSKmailSweetSpot = new Fl_Check_Button(562, 80, 142, 20, gettext("Reset to Carrier"));
          btnPSKmailSweetSpot->tooltip(gettext("When no signal present"));
          btnPSKmailSweetSpot->down_box(FL_DOWN_BOX);
          btnPSKmailSweetSpot->value(1);
          btnPSKmailSweetSpot->callback((Fl_Callback*)cb_btnPSKmailSweetSpot);
          o->value(progdefaults.PSKmailSweetSpot);
        } // Fl_Check_Button* btnPSKmailSweetSpot
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(256, 228, 490, 72, gettext("General"));
        o->box(FL_ENGRAVED_FRAME);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Check_Button* o = btn_arq_s2n_report = new Fl_Check_Button(281, 253, 250, 20, gettext("Report ARQ frames average S/N"));
          btn_arq_s2n_report->down_box(FL_DOWN_BOX);
          btn_arq_s2n_report->callback((Fl_Callback*)cb_btn_arq_s2n_report);
          o->value(progdefaults.Pskmails2nreport);
        } // Fl_Check_Button* btn_arq_s2n_report
        o->end();
      } // Fl_Group* o
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Web/Pskmail"));
      config_pages.push_back(p);
      tab_tree->add(_("Web/Pskmail"));
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(200, 0, 600, 350, gettext("Web/WX"));
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      o->hide();
      { Fl_Input* o = txt_wx_url = new Fl_Input(295, 63, 430, 25, gettext("Access URL"));
        txt_wx_url->tooltip(gettext("Enter METAR data internet URL"));
        txt_wx_url->callback((Fl_Callback*)cb_txt_wx_url);
        txt_wx_url->when(FL_WHEN_CHANGED);
        o->value(progdefaults.wx_url.c_str());
      } // Fl_Input* txt_wx_url
      { btn_default_wx_url = new Fl_Button(727, 63, 60, 25, gettext("Default"));
        btn_default_wx_url->tooltip(gettext("Default URL"));
        btn_default_wx_url->callback((Fl_Callback*)cb_btn_default_wx_url);
      } // Fl_Button* btn_default_wx_url
      { Fl_Input* o = inpWXsta = new Fl_Input(295, 99, 50, 24, gettext("METAR station ID code"));
        inpWXsta->tooltip(gettext("for example KMDQ for\nHuntsville-Madison Executive Airport, AL"));
        inpWXsta->callback((Fl_Callback*)cb_inpWXsta);
        inpWXsta->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(progdefaults.wx_sta.c_str());
      } // Fl_Input* inpWXsta
      { btn_metar_search = new Fl_Button(528, 99, 130, 24, gettext("Search on  web"));
        btn_metar_search->callback((Fl_Callback*)cb_btn_metar_search);
      } // Fl_Button* btn_metar_search
      { Fl_Check_Button* o = btn_wx_full = new Fl_Check_Button(303, 138, 70, 15, gettext("Full report"));
        btn_wx_full->tooltip(gettext("Insert full METAR report"));
        btn_wx_full->down_box(FL_DOWN_BOX);
        btn_wx_full->callback((Fl_Callback*)cb_btn_wx_full);
        o->value(progdefaults.wx_full);
      } // Fl_Check_Button* btn_wx_full
      { Fl_Check_Button* o = btn_wx_station_name = new Fl_Check_Button(303, 162, 70, 15, gettext("METAR station location"));
        btn_wx_station_name->tooltip(gettext("Add geopolitical name of METAR station"));
        btn_wx_station_name->down_box(FL_DOWN_BOX);
        btn_wx_station_name->callback((Fl_Callback*)cb_btn_wx_station_name);
        o->value(progdefaults.wx_station_name);
      } // Fl_Check_Button* btn_wx_station_name
      { Fl_Check_Button* o = btn_wx_condx = new Fl_Check_Button(303, 188, 70, 15, gettext("Conditions"));
        btn_wx_condx->tooltip(gettext("current wx conditions"));
        btn_wx_condx->down_box(FL_DOWN_BOX);
        btn_wx_condx->callback((Fl_Callback*)cb_btn_wx_condx);
        o->value(progdefaults.wx_condx);
      } // Fl_Check_Button* btn_wx_condx
      { Fl_Check_Button* o = btn_wx_fahrenheit = new Fl_Check_Button(303, 227, 70, 15, gettext("Fahrenheit"));
        btn_wx_fahrenheit->tooltip(gettext("report Fahrenheit"));
        btn_wx_fahrenheit->down_box(FL_DOWN_BOX);
        btn_wx_fahrenheit->callback((Fl_Callback*)cb_btn_wx_fahrenheit);
        o->value(progdefaults.wx_fahrenheit);
      } // Fl_Check_Button* btn_wx_fahrenheit
      { Fl_Check_Button* o = btn_wx_celsius = new Fl_Check_Button(522, 227, 70, 15, gettext("Celsius"));
        btn_wx_celsius->tooltip(gettext("report Celsius"));
        btn_wx_celsius->down_box(FL_DOWN_BOX);
        btn_wx_celsius->callback((Fl_Callback*)cb_btn_wx_celsius);
        o->value(progdefaults.wx_celsius);
      } // Fl_Check_Button* btn_wx_celsius
      { Fl_Check_Button* o = btn_wx_mph = new Fl_Check_Button(303, 253, 70, 15, gettext("Miles / Hour"));
        btn_wx_mph->tooltip(gettext("report miles per hour"));
        btn_wx_mph->down_box(FL_DOWN_BOX);
        btn_wx_mph->callback((Fl_Callback*)cb_btn_wx_mph);
        o->value(progdefaults.wx_mph);
      } // Fl_Check_Button* btn_wx_mph
      { Fl_Check_Button* o = btn_wx_kph = new Fl_Check_Button(521, 253, 70, 15, gettext("kilometers / hour"));
        btn_wx_kph->tooltip(gettext("report kilometers per hour"));
        btn_wx_kph->down_box(FL_DOWN_BOX);
        btn_wx_kph->callback((Fl_Callback*)cb_btn_wx_kph);
        o->value(progdefaults.wx_kph);
      } // Fl_Check_Button* btn_wx_kph
      { Fl_Check_Button* o = btn_wx_inches = new Fl_Check_Button(303, 280, 70, 15, gettext("Inches Hg."));
        btn_wx_inches->tooltip(gettext("report inches mercury"));
        btn_wx_inches->down_box(FL_DOWN_BOX);
        btn_wx_inches->callback((Fl_Callback*)cb_btn_wx_inches);
        o->value(progdefaults.wx_inches);
      } // Fl_Check_Button* btn_wx_inches
      { Fl_Check_Button* o = btn_wx_mbars = new Fl_Check_Button(522, 280, 70, 15, gettext("mbars"));
        btn_wx_mbars->tooltip(gettext("report millibars"));
        btn_wx_mbars->down_box(FL_DOWN_BOX);
        btn_wx_mbars->callback((Fl_Callback*)cb_btn_wx_mbars);
        o->value(progdefaults.wx_mbars);
      } // Fl_Check_Button* btn_wx_mbars
      { Fl_Check_Button* o = btn_wx_raw = new Fl_Check_Button(522, 138, 70, 15, gettext("Unprocessed METAR data"));
        btn_wx_raw->tooltip(gettext("Insert full METAR report"));
        btn_wx_raw->down_box(FL_DOWN_BOX);
        btn_wx_raw->callback((Fl_Callback*)cb_btn_wx_raw);
        o->value(progdefaults.wx_raw);
      } // Fl_Check_Button* btn_wx_raw
      CONFIG_PAGE *p = new CONFIG_PAGE(o, _("Web/WX"));
      config_pages.push_back(p);
      tab_tree->add(_("Web/WX"));
      tab_tree->close(_("Web"));
      o->end();
    } // Fl_Group* o
    { btnSaveConfig = new Fl_Button(492, 355, 130, 22, gettext("Save"));
      btnSaveConfig->callback((Fl_Callback*)cb_btnSaveConfig);
    } // Fl_Button* btnSaveConfig
    { btnCloseConfig = new Fl_Return_Button(665, 355, 130, 22, gettext("Close"));
      btnCloseConfig->callback((Fl_Callback*)cb_btnCloseConfig);
    } // Fl_Return_Button* btnCloseConfig
    { btnResetConfig = new Fl_Button(238, 355, 130, 22, gettext("Restore defaults"));
      btnResetConfig->tooltip(gettext("WARNING - this will over write ALL settings"));
      btnResetConfig->callback((Fl_Callback*)cb_btnResetConfig);
    } // Fl_Button* btnResetConfig
    o->size_range(750, 380, 0, 380);
    o->end();
  } // Fl_Double_Window* o
  return w;
}

void openConfig() {
  if (!dlgConfig) createConfig();
  progdefaults.loadDefaults();
}

void closeDialog() {
  if (dlgConfig) dlgConfig->hide();
}

void WefaxDestDirSet(Fl_File_Chooser *w, void *userdata) {
  /* http://www.fltk.org/documentation.php/doc-1.1/Fl_File_Chooser.html */
  if( ( w->value() != NULL ) && ( ! w->shown() ) ) {
  	btnWefaxSaveDir->value( w->value() );
  	btnWefaxSaveDir->redraw();
  	cb_btnWefaxSaveDir( btnWefaxSaveDir, NULL );
  }
}

void KmlDestDirSet(Fl_File_Chooser *w, void *userdata) {
  /* http://www.fltk.org/documentation.php/doc-1.1/Fl_File_Chooser.html */
  if( ( w->value() != NULL ) && ( ! w->shown() ) ) {
  	btnKmlSaveDir->value( w->value() );
  	btnKmlSaveDir->redraw();
  	cb_btnKmlSaveDir( btnKmlSaveDir, NULL );
  }
}
