<!-- THIS PART OF THIS FILE IS AUTOGENERATED. DO NOT MODIFY IT. See scripts/generate_docs.sh -->




# leakfind

## Description



Attempt to find a leak chain given a starting address.
Scans memory near the given address, looks for pointers, and continues that process to attempt to find leaks.

Example: leakfind $rsp --page_name=filename --max_offset=0x48 --max_depth=6. This would look for any chains of leaks that point to a section in filename which begin near $rsp, are never 0x48 bytes further from a known pointer, and are a maximum length of 6.

## Usage:


```bash
usage: leakfind [-h] [-p [PAGE_NAME]] [-o [MAX_OFFSET]] [-d [MAX_DEPTH]]
                [-s [STEP]] [--negative_offset [NEGATIVE_OFFSET]]
                [address]

```
## Positional Arguments

|Positional Argument|Help|
| :--- | :--- |
|`address`|Starting address to find a leak chain from (default: %(default)s)|

## Optional Arguments

|Short|Long|Default|Help|
| :--- | :--- | :--- | :--- |
|`-h`|`--help`||show this help message and exit|
|`-p`|`--page_name`|`None`|Substring required to be part of the name of any found pages|
|`-o`|`--max_offset`|`72`|Max offset to add to addresses when looking for leak (default: %(default)s)|
|`-d`|`--max_depth`|`4`|Maximum depth to follow pointers to (default: %(default)s)|
|`-s`|`--step`|`1`|Step to add between pointers so they are considered. For example, if this is 4 it would only consider pointers at an offset divisible by 4 from the starting pointer (default: %(default)s)|
||`--negative_offset`|`0`|Max negative offset to search before an address when looking for a leak (default: %(default)s)|

<!-- END OF AUTOGENERATED PART. Do not modify this line or the line below, they mark the end of the auto-generated part of the file. If you want to extend the documentation in a way which cannot easily be done by adding to the command help description, write below the following line. -->
<!-- ------------\>8---- ----\>8---- ----\>8------------ -->
