struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1169,
		.content =
			"Processor\t: ARMv7 Processor rev 3 (v7l)\n"
			"processor\t: 0\n"
			"model name\t: ARMv7 Processor rev 3 (v7l)\n"
			"BogoMIPS\t: 41.26\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 3\n"
			"\n"
			"processor\t: 1\n"
			"model name\t: ARMv7 Processor rev 3 (v7l)\n"
			"BogoMIPS\t: 41.26\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 3\n"
			"\n"
			"processor\t: 2\n"
			"model name\t: ARMv7 Processor rev 3 (v7l)\n"
			"BogoMIPS\t: 41.26\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 3\n"
			"\n"
			"processor\t: 3\n"
			"model name\t: ARMv7 Processor rev 3 (v7l)\n"
			"BogoMIPS\t: 41.26\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 3\n"
			"\n"
			"Hardware\t: MT6735\n"
			"Revision\t: 0000\n"
			"Serial\t\t: 0000000000000000\n",
	},
	{
		.path = "/system/build.prop",
		.size = 7269,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=MRA58K\n"
			"ro.build.display.id=alps-mp-m0.mp1-V2.39.1_blu6735.35gu.m0_P63\n"
			"ro.build.version.incremental=1466146428\n"
			"ro.tcustom.build.version=BLU_R0010UU_V6.1_GENERIC\n"
			"ro.custom.build.version=BLU_R0010UU_V6.1_GENERIC   17-06-2016 14:53\n"
			"ro.internal.build.version=P6607BN_6.0_BLU_AMZ_US_33\n"
			"ro.build.version.sdk=23\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=6.0\n"
			"ro.build.version.security_patch=2016-06-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Fri Jun 17 14:56:24 CST 2016\n"
			"ro.build.date.utc=1466146584\n"
			"ro.build.type=user\n"
			"ro.build.user=android\n"
			"ro.build.host=ubuntu\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=full_p6601-user\n"
			"ro.product.model=R1 HD\n"
			"ro.product.brand=BLU\n"
			"ro.product.name=R1_HD\n"
			"ro.product.device=R1_HD\n"
			"ro.product.board=R1_HD\n"
			"ro.custom.build.version.part=BLU_R0010UU_V6.1_GENERIC\n"
			"ro.fota.version.display=BLU_R0010UU_V6.1_GENERIC   17-06-2016 14:53\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=\n"
			"ro.product.manufacturer=BLU\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=mt6735\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=R1_HD\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=full_p6601-user 6.0 MRA58K 1466146428 release-keys\n"
			"ro.build.fingerprint=BLU/R1_HD/R1_HD:6.0/MRA58K/1466146428:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"#\n"
			"# from /home/android/.jenkins/jobs/P6607_6.0_BLU_US_AMZ_TSDS/workspace/baseline/vendor/tinno/p6601/blu_us/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for generic sdk\n"
			"#\n"
			"\n"
			"rild.libpath=mtk-ril.so\n"
			"rild.libargs=-d /dev/ttyC0\n"
			"\n"
			"\n"
			"# MTK, Infinity, 20090720 {\n"
			"wifi.interface=wlan0\n"
			"# MTK, Infinity, 20090720 }\n"
			"\n"
			"# MTK, mtk03034, 20101210 {\n"
			"ro.mediatek.wlan.wsc=1\n"
			"# MTK, mtk03034 20101210}\n"
			"# MTK, mtk03034, 20110318 {\n"
			"ro.mediatek.wlan.p2p=1\n"
			"# MTK, mtk03034 20110318}\n"
			"\n"
			"# MTK, mtk03034, 20101213 {\n"
			"mediatek.wlan.ctia=0\n"
			"# MTK, mtk03034 20101213}\n"
			"\n"
			"\n"
			"#\n"
			"wifi.tethering.interface=ap0\n"
			"#\n"
			"\n"
			"ro.opengles.version=196608\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"\n"
			"wifi.direct.interface=p2p0\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"\n"
			"# USB MTP WHQL\n"
			"ro.sys.usb.mtp.whql.enable=0\n"
			"\n"
			"# Power off opt in IPO\n"
			"sys.ipo.pwrdncap=2\n"
			"\n"
			"ro.sys.usb.storage.type=mtp,mass_storage\n"
			"\n"
			"# USB BICR function\n"
			"ro.sys.usb.bicr=yes\n"
			"\n"
			"# USB Charge only function\n"
			"ro.sys.usb.charging.only=yes\n"
			"\n"
			"# audio\n"
			"ro.camera.sound.forced=0\n"
			"ro.audio.silent=0\n"
			"\n"
			"ro.zygote.preload.enable=0\n"
			"\n"
			"# temporary enables NAV bar (soft keys)\n"
			"qemu.hw.mainkeys=0\n"
			"\n"
			"ro.kernel.zio=38,108,105,16\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"#ro.boot.selinux=disable\n"
			"\n"
			"# Disable dirty region for Mali\n"
			"debug.hwui.render_dirty_regions=false\n"
			"\n"
			"ro.sf.lcd_density=320\n"
			"\n"
			"# performance\n"
			"ro.mtk_perf_simple_start_win=1\n"
			"ro.mtk_perf_response_time=1\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.carrier=unknown\n"
			"ro.usb.mtp.default=true\n"
			"ro.blu.product=R1_HD_R0010UU_GENERIC\n"
			"persist.sys.timezone=America/Los_Angeles\n"
			"ro.com.android.dateformat=EE-MMM-d-yyyy\n"
			"ro.config.ringtone=BLU_Ringtone4.mp3\n"
			"ro.config.notification_sound=BLU_Message3.mp3\n"
			"ro.config.alarm_alert=alarmclock2.mp3\n"
			"ro.operator.optr=CUST\n"
			"ro.setupwizard.suppress_d2d=true\n"
			"ro.setupwizard.suppress_d2d_nfc=true\n"
			"ro.myos.version=3.0.0.r325\n"
			"ro.myos.releasetime=2016.06.17\n"
			"ro.project.pcb.version=P6607BN_MB_6L_1_HDI_V1.2\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"ro.mediatek.chip_ver=S01\n"
			"ro.mediatek.version.release=alps-mp-m0.mp1-V2.39.1_blu6735.35gu.m0_P63\n"
			"ro.mediatek.platform=MT6735\n"
			"ro.telephony.sim.count=2\n"
			"persist.radio.default.sim=0\n"
			"persist.radio.multisim.config=dsds\n"
			"persist.gemini.sim_num=2\n"
			"ro.gemini.smart_sim_switch=false\n"
			"ril.specific.sm_cause=0\n"
			"bgw.current3gband=0\n"
			"ril.external.md=0\n"
			"ro.mtk_cam_lomo_support=1\n"
			"ro.sf.hwrotation=0\n"
			"curlockscreen=0\n"
			"ro.mediatek.gemini_support=true\n"
			"persist.radio.fd.counter=15\n"
			"persist.radio.fd.off.counter=5\n"
			"persist.radio.fd.r8.counter=15\n"
			"persist.radio.fd.off.r8.counter=5\n"
			"drm.service.enabled=true\n"
			"fmradio.driver.enable=1\n"
			"ril.first.md=1\n"
			"ril.flightmode.poweroffMD=1\n"
			"ril.telephony.mode=0\n"
			"dalvik.vm.mtk-stack-trace-file=/data/anr/mtk_traces.txt\n"
			"mediatek.wlan.chip=CONSYS_MT6735\n"
			"mediatek.wlan.module.postfix=_consys_mt6735\n"
			"ril.read.imsi=1\n"
			"ril.radiooff.poweroffMD=0\n"
			"ro.frp.pst=/dev/block/platform/mtk-msdc.0/11230000.msdc0/by-name/frp\n"
			"ro.sys.usb.storage.type=mtp,mass_storage\n"
			"ro.mediatek.version.branch=alps-mp-m0.mp1\n"
			"ro.mediatek.version.sdk=4\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=6.0_r4\n"
			"ro.com.google.clientidbase=android-blu\n"
			"ro.com.google.clientidbase.ms=android-blu\n"
			"ro.com.google.clientidbase.yt=android-blu\n"
			"ro.com.google.clientidbase.am=android-blu\n"
			"ro.com.google.clientidbase.gmm=android-blu\n"
			"ro.mtk_gemini_support=1\n"
			"persist.radio.gemini_support=1\n"
			"ril.current.share_modem=2\n"
			"ro.mtk_audio_profiles=1\n"
			"ro.mtk_audenh_support=1\n"
			"ro.mtk_besloudness_support=1\n"
			"ro.mtk_bessurround_support=1\n"
			"ro.mtk_wapi_support=1\n"
			"ro.mtk_bt_support=1\n"
			"ro.mtk_wappush_support=1\n"
			"ro.mtk_agps_app=1\n"
			"ro.mtk_audio_tuning_tool_ver=V1\n"
			"ro.mtk_wlan_support=1\n"
			"ro.mtk_ipo_support=1\n"
			"ro.mtk_gps_support=1\n"
			"ro.mtk_omacp_support=1\n"
			"ro.mtk_search_db_support=1\n"
			"ro.mtk_dialer_search_support=1\n"
			"ro.mtk_dhcpv6c_wifi=1\n"
			"ro.have_aacencode_feature=1\n"
			"ro.mtk_fd_support=1\n"
			"ro.mtk_oma_drm_support=1\n"
			"ro.mtk_cta_drm_support=1\n"
			"ro.mtk_widevine_drm_l3_support=1\n"
			"ro.mtk_eap_sim_aka=1\n"
			"ro.mtk_fm_recording_support=1\n"
			"ro.mtk_audio_ape_support=1\n"
			"ro.mtk_flv_playback_support=1\n"
			"ro.mtk_wmv_playback_support=1\n"
			"ro.mtk_send_rr_support=1\n"
			"ro.mtk_emmc_support=1\n"
			"ro.mtk_tetheringipv6_support=1\n"
			"ro.mtk_shared_sdcard=1\n"
			"ro.mtk_2sdcard_swap=1\n"
			"ro.mtk_enable_md1=1\n"
			"ro.mtk_flight_mode_power_off_md=1\n"
			"ro.mtk_aal_support=1\n"
			"ro.mtk_pq_support=2\n"
			"ro.mtk_miravision_support=1\n"
			"ro.mtk_miravision_image_dc=1\n"
			"ro.mtk_wfd_support=1\n"
			"ro.mtk_wfd_sink_support=1\n"
			"ro.mtk_wfd_sink_uibc_support=1\n"
			"ro.mtk_wifi_mcc_support=1\n"
			"ro.mtk_thumbnail_play_support=1\n"
			"ro.mtk_bip_scws=1\n"
			"ro.mtk_world_phone_policy=0\n"
			"ro.mtk_perfservice_support=1\n"
			"ro.mtk_cta_set=1\n"
			"ro.mtk_mobile_management=1\n"
			"ro.mtk_antibricking_level=2\n"
			"ro.mtk_cam_mfb_support=3\n"
			"ro.mtk_slow_motion_support=1\n"
			"ro.mtk_lte_support=1\n"
			"ro.mtk_cam_vfb=1\n"
			"ro.mtk_rild_read_imsi=1\n"
			"ro.sim_refresh_reset_by_modem=1\n"
			"ro.mtk_bg_power_saving_support=1\n"
			"ro.mtk_bg_power_saving_ui=1\n"
			"ro.have_aee_feature=1\n"
			"ro.sim_me_lock_mode=0\n"
			"ro.mtk_dual_mic_support=0\n"
			"ro.mtk_is_tablet=0\n"
			"wfd.dummy.enable=1\n"
			"ro.mediatek.project.path=device/tinno/p6601\n"
			"persist.mtk.wcn.combo.chipid=-1\n"
			"service.wcn.driver.ready=no\n"
			"service.wcn.coredump.mode=2\n"
			"ro.com.android.mobiledata=false\n"
			"persist.radio.mobile.data=0,0\n"
			"persist.meta.dumpdata=0\n"
			"mtk.vdec.waitkeyframeforplay=1\n"
			"ro.myos.release.apk=1\n"
			"ro.project=blu_us\n"
			"ro.target=p6601\n"
			"ro.subproject=persist.sys.dalvik.vm.lib.2=libart\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"\n"
			"# begin fota properties\n"
			"ro.fota.platform=MTK6735_6.0\n"
			"ro.fota.type=phone\n"
			"ro.fota.app=5\n"
			"ro.fota.oem=tinno6735_6.0\n"
			"ro.fota.device=R1_HD_R0010UU_GENERIC\n"
			"ro.fota.version=BLU_R0010UU_V6.1_GENERIC_6.0_20160617-1456\n"
			"# end fota properties\n"
			"ro.expect.recovery_id=0x7ba5bb9dd9b238b42d7097670788f53a12aa6521000000000000000000000000\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 223,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n"
			   "299000\t\t665\t\t665\t\t665\t\t665\t\t\n"
			   "442000\t\t8\t\t8\t\t8\t\t8\t\t\n"
			   "598000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			   "819000\t\t42\t\t42\t\t42\t\t42\t\t\n"
			   "1040000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			   "1170000\t\t4\t\t4\t\t4\t\t4\t\t\n"
			   "1235000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			   "1300000\t\t362\t\t362\t\t362\t\t362\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 328,
		.content = "CPU0:1300000=0 1235000=0 1170000=0 1040000=0 819000=0 598000=0 442000=0 299000=0 \n"
			   "CPU1:1300000=0 1235000=0 1170000=0 1040000=0 819000=0 598000=0 442000=0 299000=0 \n"
			   "CPU2:1300000=0 1235000=0 1170000=0 1040000=0 819000=0 598000=0 442000=0 299000=0 \n"
			   "CPU3:1300000=0 1235000=0 1170000=0 1040000=0 819000=0 598000=0 442000=0 299000=0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 15,
		.content = "mt6735_cpuidle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 13,
		.content = "mtk_governor\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/cpus_per_cluster",
		.size = 12,
		.content = "cluster0: f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/glbinfo",
		.size = 58,
		.content = "big/little arch: no\n"
			   "nr_cups: 4\n"
			   "nr_clusters: 1\n"
			   "cluster0: f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_big_little",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_multi_cluster",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/nr_clusters",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "299000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 61,
		.content = "1300000 1235000 1170000 1040000 819000 598000 442000 299000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "299000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 81,
		.content = "1300000 470\n"
			   "1235000 0\n"
			   "1170000 4\n"
			   "1040000 0\n"
			   "819000 42\n"
			   "598000 0\n"
			   "442000 8\n"
			   "299000 665\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 3,
		.content = "16\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :   1300000   1235000   1170000   1040000    819000    598000    442000    299000 \n"
			"  1300000:         0         0         1         0         4         1         0         1 \n"
			"  1235000:         0         0         0         0         0         0         0         0 \n"
			"  1170000:         1         0         0         0         0         0         0         0 \n"
			"  1040000:         0         0         0         0         0         0         0         0 \n"
			"   819000:         5         0         0         0         0         0         0         0 \n"
			"   598000:         1         0         0         0         0         0         0         0 \n"
			"   442000:         1         0         0         0         0         0         0         0 \n"
			"   299000:         0         0         0         0         0         0         1         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "299000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 61,
		.content = "1300000 1235000 1170000 1040000 819000 598000 442000 299000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "299000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 81,
		.content = "1300000 693\n"
			   "1235000 0\n"
			   "1170000 4\n"
			   "1040000 2\n"
			   "819000 42\n"
			   "598000 0\n"
			   "442000 8\n"
			   "299000 665\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 3,
		.content = "18\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :   1300000   1235000   1170000   1040000    819000    598000    442000    299000 \n"
			"  1300000:         0         0         1         1         4         1         0         1 \n"
			"  1235000:         0         0         0         0         0         0         0         0 \n"
			"  1170000:         1         0         0         0         0         0         0         0 \n"
			"  1040000:         1         0         0         0         0         0         0         0 \n"
			"   819000:         5         0         0         0         0         0         0         0 \n"
			"   598000:         1         0         0         0         0         0         0         0 \n"
			"   442000:         1         0         0         0         0         0         0         0 \n"
			"   299000:         0         0         0         0         0         0         1         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "bgw.current3gband",
		.value = "0",
	},
	{
		.key = "camera.disable_zsl_mode",
		.value = "1",
	},
	{
		.key = "curlockscreen",
		.value = "0",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.mtk-stack-trace-file",
		.value = "/data/anr/mtk_traces.txt",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.MB.running",
		.value = "0",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.hwc.bq_count",
		.value = "4",
	},
	{
		.key = "debug.hwc.compose_level",
		.value = "0",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "false",
	},
	{
		.key = "debug.mtklog.netlog.Running",
		.value = "0",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "fmradio.driver.enable",
		.value = "1",
	},
	{
		.key = "init.svc.DMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.MtkCodecService",
		.value = "running",
	},
	{
		.key = "init.svc.NvRAMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.PPLAgent",
		.value = "running",
	},
	{
		.key = "init.svc.aal",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.agpsd",
		.value = "running",
	},
	{
		.key = "init.svc.batterywarning",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "running",
	},
	{
		.key = "init.svc.bootlogoupdater",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccci_fsd",
		.value = "running",
	},
	{
		.key = "init.svc.ccci_mdinit",
		.value = "running",
	},
	{
		.key = "init.svc.conn_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.emdlogger1",
		.value = "running",
	},
	{
		.key = "init.svc.emsvr_user",
		.value = "running",
	},
	{
		.key = "init.svc.enableswap",
		.value = "stopped",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "running",
	},
	{
		.key = "init.svc.fuelgauged",
		.value = "running",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.gsm0710muxd",
		.value = "running",
	},
	{
		.key = "init.svc.guiext-server",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mnld",
		.value = "running",
	},
	{
		.key = "init.svc.mobile_log_d",
		.value = "running",
	},
	{
		.key = "init.svc.msensord",
		.value = "stopped",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netdiag",
		.value = "running",
	},
	{
		.key = "init.svc.nvram_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.pq",
		.value = "running",
	},
	{
		.key = "init.svc.program_binary",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.slpd",
		.value = "running",
	},
	{
		.key = "init.svc.sn",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.terservice",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermal",
		.value = "running",
	},
	{
		.key = "init.svc.thermal_manager",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.vtservice",
		.value = "running",
	},
	{
		.key = "init.svc.wifi2agps",
		.value = "running",
	},
	{
		.key = "init.svc.wmtLoader",
		.value = "stopped",
	},
	{
		.key = "init.svc.xlogboot",
		.value = "stopped",
	},
	{
		.key = "init.svc.xlogdebugchanged",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "mediatek.wlan.chip",
		.value = "CONSYS_MT6735",
	},
	{
		.key = "mediatek.wlan.ctia",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.module.postfix",
		.value = "_consys_mt6735",
	},
	{
		.key = "mtk.md1.starttime",
		.value = "1s Fri Sep 22 15:10:34 2017\n",
	},
	{
		.key = "mtk.md1.status",
		.value = "ready",
	},
	{
		.key = "mtk.vdec.waitkeyframeforplay",
		.value = "1",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.tcp.default_init_rwnd",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "persist.af.hac_on",
		.value = "0",
	},
	{
		.key = "persist.dm.lock",
		.value = "false",
	},
	{
		.key = "persist.gemini.sim_num",
		.value = "2",
	},
	{
		.key = "persist.log.tag",
		.value = "I",
	},
	{
		.key = "persist.logd.size",
		.value = "",
	},
	{
		.key = "persist.meta.dumpdata",
		.value = "0",
	},
	{
		.key = "persist.mtk.wcn.combo.chipid",
		.value = "0x0321",
	},
	{
		.key = "persist.radio.airplane.mode.on",
		.value = "false",
	},
	{
		.key = "persist.radio.data.iccid",
		.value = "",
	},
	{
		.key = "persist.radio.default.sim",
		.value = "0",
	},
	{
		.key = "persist.radio.fd.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.fd.off.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.off.r8.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.r8.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.gemini_support",
		.value = "1",
	},
	{
		.key = "persist.radio.ia",
		.value = "",
	},
	{
		.key = "persist.radio.ia-apn",
		.value = "",
	},
	{
		.key = "persist.radio.mobile.data",
		.value = "0,0",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.new.sim.slot",
		.value = "",
	},
	{
		.key = "persist.radio.reset_on_switch",
		.value = "true",
	},
	{
		.key = "persist.radio.sim.status",
		.value = "",
	},
	{
		.key = "persist.radio.simswitch",
		.value = "1",
	},
	{
		.key = "persist.service.acm.enable",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "22:22:b0:8c:e2:a0",
	},
	{
		.key = "persist.service.stk.shutdown",
		.value = "0",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.first_time_boot",
		.value = "false",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.mute.state",
		.value = "1",
	},
	{
		.key = "persist.sys.pq.adl.idx",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.shp.idx",
		.value = "2",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.sd.defaultpath",
		.value = "/storage/emulated/0",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "0",
	},
	{
		.key = "ril.current.share_modem",
		.value = "2",
	},
	{
		.key = "ril.external.md",
		.value = "0",
	},
	{
		.key = "ril.first.md",
		.value = "1",
	},
	{
		.key = "ril.flightmode.poweroffMD",
		.value = "1",
	},
	{
		.key = "ril.mux.ee.md1",
		.value = "0",
	},
	{
		.key = "ril.radiooff.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.read.imsi",
		.value = "1",
	},
	{
		.key = "ril.specific.sm_cause",
		.value = "0",
	},
	{
		.key = "ril.telephony.mode",
		.value = "0",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/ttyC0",
	},
	{
		.key = "rild.libpath",
		.value = "mtk-ril.so",
	},
	{
		.key = "rild.mark_switchuser",
		.value = "0",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.silent",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.blu.product",
		.value = "R1_HD_R0010UU_GENERIC",
	},
	{
		.key = "ro.board.platform",
		.value = "mt6735",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "wdt_by_pass_pwk",
	},
	{
		.key = "ro.boot.hardware",
		.value = "mt6735",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.name",
		.value = "android",
	},
	{
		.key = "ro.boot.selinux",
		.value = "disabled",
	},
	{
		.key = "ro.boot.serialno",
		.value = "MNJFYPM7QSZ9RCLV",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Fri Jun 17 14:59:23 CST 2016",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1466146763",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "BLU/full_p6601/p6601:6.0/MRA58K/1466146428:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date",
		.value = "Fri Jun 17 14:56:24 CST 2016",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1466146584",
	},
	{
		.key = "ro.build.description",
		.value = "full_p6601-user 6.0 MRA58K 1466146428 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "alps-mp-m0.mp1-V2.39.1_blu6735.35gu.m0_P63",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "BLU/R1_HD/R1_HD:6.0/MRA58K/1466146428:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "full_p6601-user",
	},
	{
		.key = "ro.build.host",
		.value = "ubuntu",
	},
	{
		.key = "ro.build.id",
		.value = "MRA58K",
	},
	{
		.key = "ro.build.product",
		.value = "R1_HD",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "android",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "1466146428",
	},
	{
		.key = "ro.build.version.release",
		.value = "6.0",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "23",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-06-01",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "0",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "EE-MMM-d-yyyy",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-blu",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-blu",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-blu",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-blu",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-blu",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "6.0_r4",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "alarmclock2.mp3",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "BLU_Message3.mp3",
	},
	{
		.key = "ro.config.ringtone",
		.value = "BLU_Ringtone4.mp3",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.custom.build.version",
		.value = "BLU_R0010UU_V6.1_GENERIC   17-06-2016 14:53",
	},
	{
		.key = "ro.custom.build.version.part",
		.value = "BLU_R0010UU_V6.1_GENERIC",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x7ba5bb9dd9b238b42d7097670788f53a12aa6521000000000000000000000000",
	},
	{
		.key = "ro.fota.app",
		.value = "5",
	},
	{
		.key = "ro.fota.device",
		.value = "R1_HD_R0010UU_GENERIC",
	},
	{
		.key = "ro.fota.oem",
		.value = "tinno6735_6.0",
	},
	{
		.key = "ro.fota.platform",
		.value = "MTK6735_6.0",
	},
	{
		.key = "ro.fota.type",
		.value = "phone",
	},
	{
		.key = "ro.fota.version",
		.value = "BLU_R0010UU_V6.1_GENERIC_6.0_20160617-1456",
	},
	{
		.key = "ro.fota.version.display",
		.value = "BLU_R0010UU_V6.1_GENERIC   17-06-2016 14:53",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/platform/mtk-msdc.0/11230000.msdc0/by-name/frp",
	},
	{
		.key = "ro.gemini.smart_sim_switch",
		.value = "false",
	},
	{
		.key = "ro.hardware",
		.value = "mt6735",
	},
	{
		.key = "ro.have_aacencode_feature",
		.value = "1",
	},
	{
		.key = "ro.have_aee_feature",
		.value = "1",
	},
	{
		.key = "ro.internal.build.version",
		.value = "P6607BN_6.0_BLU_AMZ_US_33",
	},
	{
		.key = "ro.kernel.zio",
		.value = "38,108,105,16",
	},
	{
		.key = "ro.mediatek.chip_ver",
		.value = "S01",
	},
	{
		.key = "ro.mediatek.gemini_support",
		.value = "true",
	},
	{
		.key = "ro.mediatek.platform",
		.value = "MT6735",
	},
	{
		.key = "ro.mediatek.project.path",
		.value = "device/tinno/p6601",
	},
	{
		.key = "ro.mediatek.version.branch",
		.value = "alps-mp-m0.mp1",
	},
	{
		.key = "ro.mediatek.version.release",
		.value = "alps-mp-m0.mp1-V2.39.1_blu6735.35gu.m0_P63",
	},
	{
		.key = "ro.mediatek.version.sdk",
		.value = "4",
	},
	{
		.key = "ro.mediatek.wlan.p2p",
		.value = "1",
	},
	{
		.key = "ro.mediatek.wlan.wsc",
		.value = "1",
	},
	{
		.key = "ro.mount.fs",
		.value = "EXT4",
	},
	{
		.key = "ro.mtk_2sdcard_swap",
		.value = "1",
	},
	{
		.key = "ro.mtk_aal_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_agps_app",
		.value = "1",
	},
	{
		.key = "ro.mtk_antibricking_level",
		.value = "2",
	},
	{
		.key = "ro.mtk_audenh_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_ape_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_profiles",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_tuning_tool_ver",
		.value = "V1",
	},
	{
		.key = "ro.mtk_besloudness_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bessurround_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_ui",
		.value = "1",
	},
	{
		.key = "ro.mtk_bip_scws",
		.value = "1",
	},
	{
		.key = "ro.mtk_bt_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_lomo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_mfb_support",
		.value = "3",
	},
	{
		.key = "ro.mtk_cam_vfb",
		.value = "1",
	},
	{
		.key = "ro.mtk_cta_drm_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cta_set",
		.value = "1",
	},
	{
		.key = "ro.mtk_dhcpv6c_wifi",
		.value = "1",
	},
	{
		.key = "ro.mtk_dialer_search_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_dual_mic_support",
		.value = "0",
	},
	{
		.key = "ro.mtk_eap_sim_aka",
		.value = "1",
	},
	{
		.key = "ro.mtk_emmc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_enable_md1",
		.value = "1",
	},
	{
		.key = "ro.mtk_fd_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_flight_mode_power_off_md",
		.value = "1",
	},
	{
		.key = "ro.mtk_flv_playback_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_fm_recording_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_gemini_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_gps_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_ipo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_is_tablet",
		.value = "0",
	},
	{
		.key = "ro.mtk_lte_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_miravision_image_dc",
		.value = "1",
	},
	{
		.key = "ro.mtk_miravision_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_mobile_management",
		.value = "1",
	},
	{
		.key = "ro.mtk_oma_drm_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_omacp_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_response_time",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_simple_start_win",
		.value = "1",
	},
	{
		.key = "ro.mtk_perfservice_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_pq_support",
		.value = "2",
	},
	{
		.key = "ro.mtk_rild_read_imsi",
		.value = "1",
	},
	{
		.key = "ro.mtk_search_db_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_send_rr_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_shared_sdcard",
		.value = "1",
	},
	{
		.key = "ro.mtk_slow_motion_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_tetheringipv6_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_thumbnail_play_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wapi_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wappush_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_sink_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_sink_uibc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_widevine_drm_l3_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wifi_mcc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wlan_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wmv_playback_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_world_phone_policy",
		.value = "0",
	},
	{
		.key = "ro.myos.release.apk",
		.value = "1",
	},
	{
		.key = "ro.myos.releasetime",
		.value = "2016.06.17",
	},
	{
		.key = "ro.myos.version",
		.value = "3.0.0.r325",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.operator.optr",
		.value = "CUST",
	},
	{
		.key = "ro.product.board",
		.value = "R1_HD",
	},
	{
		.key = "ro.product.brand",
		.value = "BLU",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.device",
		.value = "R1_HD",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "BLU",
	},
	{
		.key = "ro.product.model",
		.value = "R1 HD",
	},
	{
		.key = "ro.product.name",
		.value = "R1_HD",
	},
	{
		.key = "ro.project",
		.value = "blu_us",
	},
	{
		.key = "ro.project.pcb.version",
		.value = "P6607BN_MB_6L_1_HDI_V1.2",
	},
	{
		.key = "ro.recovery_id",
		.value = "0x7ba5bb9dd9b238b42d7097670788f53a12aa6521000000000000000000000000",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "MNJFYPM7QSZ9RCLV",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.setupwizard.suppress_d2d",
		.value = "true",
	},
	{
		.key = "ro.setupwizard.suppress_d2d_nfc",
		.value = "true",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.sim_me_lock_mode",
		.value = "0",
	},
	{
		.key = "ro.sim_refresh_reset_by_modem",
		.value = "1",
	},
	{
		.key = "ro.subproject",
		.value = "persist.sys.dalvik.vm.lib.2=libart",
	},
	{
		.key = "ro.sys.usb.bicr",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.charging.only",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.mtp.whql.enable",
		.value = "0",
	},
	{
		.key = "ro.sys.usb.storage.type",
		.value = "mtp,mass_storage",
	},
	{
		.key = "ro.target",
		.value = "p6601",
	},
	{
		.key = "ro.tcustom.build.version",
		.value = "BLU_R0010UU_V6.1_GENERIC",
	},
	{
		.key = "ro.telephony.sim.count",
		.value = "2",
	},
	{
		.key = "ro.tinno.memory",
		.value = "size=946592",
	},
	{
		.key = "ro.tinno.memory.1G",
		.value = "true",
	},
	{
		.key = "ro.usb.mtp.default",
		.value = "true",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.wlan.mtk.wifi.5g",
		.value = "0",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "ro.zygote.preload.enable",
		.value = "0",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.nvram_init",
		.value = "Ready",
	},
	{
		.key = "service.wcn.coredump.mode",
		.value = "0",
	},
	{
		.key = "service.wcn.driver.ready",
		.value = "yes",
	},
	{
		.key = "sys.boot.reason",
		.value = "0",
	},
	{
		.key = "sys.ipo.pwrdncap",
		.value = "2",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.vid",
		.value = "0E8D",
	},
	{
		.key = "vold.has_adoptable",
		.value = "1",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vold.support_external_sd",
		.value = "1",
	},
	{
		.key = "wfd.dummy.enable",
		.value = "1",
	},
	{
		.key = "wifi.direct.interface",
		.value = "p2p0",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wifi.tethering.interface",
		.value = "ap0",
	},
	{NULL},
};
#endif /* __ANDROID__ */
