#include <cstring>
#include <iostream>
#include <string>

#include "Rivet/Tools/Exceptions.hh"

using namespace std;


void raiseError(const string& name) {
  if (name == "Error")       throw Rivet::Error("test");
  if (name == "RangeError")  throw Rivet::RangeError("test");
  if (name == "LogicError")  throw Rivet::LogicError("test");
  if (name == "PidError")    throw Rivet::PidError("test");
  if (name == "InfoError")   throw Rivet::InfoError("test");
  if (name == "BeamError")   throw Rivet::BeamError("test");
  if (name == "SmearError")  throw Rivet::SmearError("test");
  if (name == "WeightError") throw Rivet::WeightError("test");
  if (name == "UserError")   throw Rivet::UserError("test");
  if (name == "LookupError") throw Rivet::LookupError("test");
  if (name == "IOError")     throw Rivet::IOError("test");
  if (name == "ReadError")   throw Rivet::ReadError("test");
  if (name == "WriteError")  throw Rivet::WriteError("test");
}

bool testError(const string& name) {
  try {
    raiseError(name);
  }
  catch (const Rivet::Error& e) {
    if ( std::strcmp(e.what(), "test") == 0)  return false;
  }
  return true;
}

int main() {

  if ( testError("Error") )       return EXIT_FAILURE;
  if ( testError("RangeError") )  return EXIT_FAILURE;
  if ( testError("LogicError") )  return EXIT_FAILURE;
  if ( testError("PidError") )    return EXIT_FAILURE;
  if ( testError("InfoError") )   return EXIT_FAILURE;
  if ( testError("BeamError") )   return EXIT_FAILURE;
  if ( testError("SmearError") )  return EXIT_FAILURE;
  if ( testError("WeightError") ) return EXIT_FAILURE;
  if ( testError("UserError") )   return EXIT_FAILURE;
  if ( testError("LookupError") ) return EXIT_FAILURE;
  if ( testError("IOError") )     return EXIT_FAILURE;
  if ( testError("ReadError") )   return EXIT_FAILURE;
  if ( testError("WriteError") )  return EXIT_FAILURE;

  return EXIT_SUCCESS;
}
