package containerregistry

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"net/http"

	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
)

// BaseImageDependencyType enumerates the values for base image dependency type.
type BaseImageDependencyType string

const (
	// BuildTime ...
	BuildTime BaseImageDependencyType = "BuildTime"
	// RunTime ...
	RunTime BaseImageDependencyType = "RunTime"
)

// PossibleBaseImageDependencyTypeValues returns an array of possible values for the BaseImageDependencyType const type.
func PossibleBaseImageDependencyTypeValues() []BaseImageDependencyType {
	return []BaseImageDependencyType{BuildTime, RunTime}
}

// BaseImageTriggerType enumerates the values for base image trigger type.
type BaseImageTriggerType string

const (
	// None ...
	None BaseImageTriggerType = "None"
	// Runtime ...
	Runtime BaseImageTriggerType = "Runtime"
)

// PossibleBaseImageTriggerTypeValues returns an array of possible values for the BaseImageTriggerType const type.
func PossibleBaseImageTriggerTypeValues() []BaseImageTriggerType {
	return []BaseImageTriggerType{None, Runtime}
}

// BuildStatus enumerates the values for build status.
type BuildStatus string

const (
	// AbandonedAsSystemError ...
	AbandonedAsSystemError BuildStatus = "AbandonedAsSystemError"
	// Canceled ...
	Canceled BuildStatus = "Canceled"
	// Failed ...
	Failed BuildStatus = "Failed"
	// Queued ...
	Queued BuildStatus = "Queued"
	// Running ...
	Running BuildStatus = "Running"
	// Started ...
	Started BuildStatus = "Started"
	// Succeeded ...
	Succeeded BuildStatus = "Succeeded"
	// Timeout ...
	Timeout BuildStatus = "Timeout"
)

// PossibleBuildStatusValues returns an array of possible values for the BuildStatus const type.
func PossibleBuildStatusValues() []BuildStatus {
	return []BuildStatus{AbandonedAsSystemError, Canceled, Failed, Queued, Running, Started, Succeeded, Timeout}
}

// BuildTaskStatus enumerates the values for build task status.
type BuildTaskStatus string

const (
	// Disabled ...
	Disabled BuildTaskStatus = "Disabled"
	// Enabled ...
	Enabled BuildTaskStatus = "Enabled"
)

// PossibleBuildTaskStatusValues returns an array of possible values for the BuildTaskStatus const type.
func PossibleBuildTaskStatusValues() []BuildTaskStatus {
	return []BuildTaskStatus{Disabled, Enabled}
}

// BuildType enumerates the values for build type.
type BuildType string

const (
	// AutoBuild ...
	AutoBuild BuildType = "AutoBuild"
	// QuickBuild ...
	QuickBuild BuildType = "QuickBuild"
)

// PossibleBuildTypeValues returns an array of possible values for the BuildType const type.
func PossibleBuildTypeValues() []BuildType {
	return []BuildType{AutoBuild, QuickBuild}
}

// OsType enumerates the values for os type.
type OsType string

const (
	// Linux ...
	Linux OsType = "Linux"
	// Windows ...
	Windows OsType = "Windows"
)

// PossibleOsTypeValues returns an array of possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{Linux, Windows}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// Github ...
	Github SourceControlType = "Github"
	// VisualStudioTeamService ...
	VisualStudioTeamService SourceControlType = "VisualStudioTeamService"
)

// PossibleSourceControlTypeValues returns an array of possible values for the SourceControlType const type.
func PossibleSourceControlTypeValues() []SourceControlType {
	return []SourceControlType{Github, VisualStudioTeamService}
}

// TokenType enumerates the values for token type.
type TokenType string

const (
	// OAuth ...
	OAuth TokenType = "OAuth"
	// PAT ...
	PAT TokenType = "PAT"
)

// PossibleTokenTypeValues returns an array of possible values for the TokenType const type.
func PossibleTokenTypeValues() []TokenType {
	return []TokenType{OAuth, PAT}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeBuildStepProperties ...
	TypeBuildStepProperties Type = "BuildStepProperties"
	// TypeDocker ...
	TypeDocker Type = "Docker"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeBuildStepProperties, TypeDocker}
}

// TypeBasicBuildStepPropertiesUpdateParameters enumerates the values for type basic build step properties
// update parameters.
type TypeBasicBuildStepPropertiesUpdateParameters string

const (
	// TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters ...
	TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters TypeBasicBuildStepPropertiesUpdateParameters = "BuildStepPropertiesUpdateParameters"
	// TypeBasicBuildStepPropertiesUpdateParametersTypeDocker ...
	TypeBasicBuildStepPropertiesUpdateParametersTypeDocker TypeBasicBuildStepPropertiesUpdateParameters = "Docker"
)

// PossibleTypeBasicBuildStepPropertiesUpdateParametersValues returns an array of possible values for the TypeBasicBuildStepPropertiesUpdateParameters const type.
func PossibleTypeBasicBuildStepPropertiesUpdateParametersValues() []TypeBasicBuildStepPropertiesUpdateParameters {
	return []TypeBasicBuildStepPropertiesUpdateParameters{TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters, TypeBasicBuildStepPropertiesUpdateParametersTypeDocker}
}

// TypeBasicQueueBuildRequest enumerates the values for type basic queue build request.
type TypeBasicQueueBuildRequest string

const (
	// TypeBuildTask ...
	TypeBuildTask TypeBasicQueueBuildRequest = "BuildTask"
	// TypeQueueBuildRequest ...
	TypeQueueBuildRequest TypeBasicQueueBuildRequest = "QueueBuildRequest"
	// TypeQuickBuild ...
	TypeQuickBuild TypeBasicQueueBuildRequest = "QuickBuild"
)

// PossibleTypeBasicQueueBuildRequestValues returns an array of possible values for the TypeBasicQueueBuildRequest const type.
func PossibleTypeBasicQueueBuildRequestValues() []TypeBasicQueueBuildRequest {
	return []TypeBasicQueueBuildRequest{TypeBuildTask, TypeQueueBuildRequest, TypeQuickBuild}
}

// BaseImageDependency properties that describe a base image dependency.
type BaseImageDependency struct {
	// Type - The type of the base image dependency. Possible values include: 'BuildTime', 'RunTime'
	Type BaseImageDependencyType `json:"type,omitempty"`
	// IsAutoTriggerEnabled - The value of this flag indicates if build has to be auto triggered when this image is updated.
	IsAutoTriggerEnabled *bool `json:"isAutoTriggerEnabled,omitempty"`
	// RepositoryName - Name of the repository.
	RepositoryName *string `json:"repositoryName,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The image digest. Example: SHA256 based digest.
	Digest *string `json:"digest,omitempty"`
}

// Build build resource properties
type Build struct {
	autorest.Response `json:"-"`
	// BuildProperties - The properties of a build.
	*BuildProperties `json:"properties,omitempty"`
	// ID - The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Build.
func (b Build) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BuildProperties != nil {
		objectMap["properties"] = b.BuildProperties
	}
	if b.ID != nil {
		objectMap["id"] = b.ID
	}
	if b.Name != nil {
		objectMap["name"] = b.Name
	}
	if b.Type != nil {
		objectMap["type"] = b.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Build struct.
func (b *Build) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var buildProperties BuildProperties
				err = json.Unmarshal(*v, &buildProperties)
				if err != nil {
					return err
				}
				b.BuildProperties = &buildProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		}
	}

	return nil
}

// BuildArgument properties of a build argument.
type BuildArgument struct {
	// Type - The type of the argument.
	Type *string `json:"type,omitempty"`
	// Name - The name of the argument.
	Name *string `json:"name,omitempty"`
	// Value - The value of the argument.
	Value *string `json:"value,omitempty"`
	// IsSecret - Flag to indicate whether the argument represents a secret and want to be removed from build logs.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// BuildArgumentList ...
type BuildArgumentList struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]BuildArgument `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildArgumentListIterator provides access to a complete listing of BuildArgument values.
type BuildArgumentListIterator struct {
	i    int
	page BuildArgumentListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildArgumentListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildArgumentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildArgumentListIterator) Response() BuildArgumentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildArgumentListIterator) Value() BuildArgument {
	if !iter.page.NotDone() {
		return BuildArgument{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (bal BuildArgumentList) IsEmpty() bool {
	return bal.Value == nil || len(*bal.Value) == 0
}

// buildArgumentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bal BuildArgumentList) buildArgumentListPreparer() (*http.Request, error) {
	if bal.NextLink == nil || len(to.String(bal.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bal.NextLink)))
}

// BuildArgumentListPage contains a page of BuildArgument values.
type BuildArgumentListPage struct {
	fn  func(BuildArgumentList) (BuildArgumentList, error)
	bal BuildArgumentList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildArgumentListPage) Next() error {
	next, err := page.fn(page.bal)
	if err != nil {
		return err
	}
	page.bal = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildArgumentListPage) NotDone() bool {
	return !page.bal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildArgumentListPage) Response() BuildArgumentList {
	return page.bal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildArgumentListPage) Values() []BuildArgument {
	if page.bal.IsEmpty() {
		return nil
	}
	return *page.bal.Value
}

// BuildFilter properties that are enabled for Odata querying.
type BuildFilter struct {
	// BuildID - The unique identifier for the build.
	BuildID *string `json:"buildId,omitempty"`
	// BuildType - The type of build. Possible values include: 'AutoBuild', 'QuickBuild'
	BuildType BuildType `json:"buildType,omitempty"`
	// Status - The current status of the build. Possible values include: 'Queued', 'Started', 'Running', 'Succeeded', 'Failed', 'Canceled', 'AbandonedAsSystemError', 'Timeout'
	Status BuildStatus `json:"status,omitempty"`
	// CreateTime - The create time for a build.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// FinishTime - The time the build finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImageNames - The list of all images that were generated from the build.
	OutputImageNames *[]string `json:"outputImageNames,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// BuildTaskName - The name of the build task that the build corresponds to.
	BuildTaskName *string `json:"buildTaskName,omitempty"`
}

// BuildGetLogResult the result of get log link operation.
type BuildGetLogResult struct {
	autorest.Response `json:"-"`
	// LogLink - The link to logs for a azure container registry build.
	LogLink *string `json:"logLink,omitempty"`
}

// BuildListResult collection of builds.
type BuildListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]Build `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildListResultIterator provides access to a complete listing of Build values.
type BuildListResultIterator struct {
	i    int
	page BuildListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildListResultIterator) Response() BuildListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildListResultIterator) Value() Build {
	if !iter.page.NotDone() {
		return Build{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (blr BuildListResult) IsEmpty() bool {
	return blr.Value == nil || len(*blr.Value) == 0
}

// buildListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (blr BuildListResult) buildListResultPreparer() (*http.Request, error) {
	if blr.NextLink == nil || len(to.String(blr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(blr.NextLink)))
}

// BuildListResultPage contains a page of Build values.
type BuildListResultPage struct {
	fn  func(BuildListResult) (BuildListResult, error)
	blr BuildListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildListResultPage) Next() error {
	next, err := page.fn(page.blr)
	if err != nil {
		return err
	}
	page.blr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildListResultPage) NotDone() bool {
	return !page.blr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildListResultPage) Response() BuildListResult {
	return page.blr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildListResultPage) Values() []Build {
	if page.blr.IsEmpty() {
		return nil
	}
	return *page.blr.Value
}

// BuildProperties the properties for a build.
type BuildProperties struct {
	// BuildID - The unique identifier for the build.
	BuildID *string `json:"buildId,omitempty"`
	// Status - The current status of the build. Possible values include: 'Queued', 'Started', 'Running', 'Succeeded', 'Failed', 'Canceled', 'AbandonedAsSystemError', 'Timeout'
	Status BuildStatus `json:"status,omitempty"`
	// LastUpdatedTime - The last updated time for the build.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// BuildType - The type of build. Possible values include: 'AutoBuild', 'QuickBuild'
	BuildType BuildType `json:"buildType,omitempty"`
	// CreateTime - The time the build was created.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - The time the build started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// FinishTime - The time the build finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImages - The list of all images that were generated from the build.
	OutputImages *[]ImageDescriptor `json:"outputImages,omitempty"`
	// BuildTask - All the properties of the build task with which the build was started.
	BuildTask *string `json:"buildTask,omitempty"`
	// Trigger - The trigger that caused the build.
	Trigger *string `json:"trigger,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// Platform - The platform properties against which the build will happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// ProvisioningState - The provisioning state of a build. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// BuildsCancelFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildsCancelFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildsCancelFuture) Result(client BuildsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("containerregistry.BuildsCancelFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.CancelResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildsCancelFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsCancelFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.CancelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsCancelFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildStep build step resource properties
type BuildStep struct {
	autorest.Response `json:"-"`
	// BasicBuildStepProperties - The properties of a build step.
	BasicBuildStepProperties `json:"properties,omitempty"`
	// ID - The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildStep.
func (bs BuildStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = bs.BasicBuildStepProperties
	if bs.ID != nil {
		objectMap["id"] = bs.ID
	}
	if bs.Name != nil {
		objectMap["name"] = bs.Name
	}
	if bs.Type != nil {
		objectMap["type"] = bs.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildStep struct.
func (bs *BuildStep) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicBuildStepProperties, err := unmarshalBasicBuildStepProperties(*v)
				if err != nil {
					return err
				}
				bs.BasicBuildStepProperties = basicBuildStepProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = &typeVar
			}
		}
	}

	return nil
}

// BuildStepList the collection of build items.
type BuildStepList struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]BuildStep `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildStepListIterator provides access to a complete listing of BuildStep values.
type BuildStepListIterator struct {
	i    int
	page BuildStepListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildStepListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildStepListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildStepListIterator) Response() BuildStepList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildStepListIterator) Value() BuildStep {
	if !iter.page.NotDone() {
		return BuildStep{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (bsl BuildStepList) IsEmpty() bool {
	return bsl.Value == nil || len(*bsl.Value) == 0
}

// buildStepListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsl BuildStepList) buildStepListPreparer() (*http.Request, error) {
	if bsl.NextLink == nil || len(to.String(bsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsl.NextLink)))
}

// BuildStepListPage contains a page of BuildStep values.
type BuildStepListPage struct {
	fn  func(BuildStepList) (BuildStepList, error)
	bsl BuildStepList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildStepListPage) Next() error {
	next, err := page.fn(page.bsl)
	if err != nil {
		return err
	}
	page.bsl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildStepListPage) NotDone() bool {
	return !page.bsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildStepListPage) Response() BuildStepList {
	return page.bsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildStepListPage) Values() []BuildStep {
	if page.bsl.IsEmpty() {
		return nil
	}
	return *page.bsl.Value
}

// BasicBuildStepProperties base properties for any  build step.
type BasicBuildStepProperties interface {
	AsDockerBuildStep() (*DockerBuildStep, bool)
	AsBuildStepProperties() (*BuildStepProperties, bool)
}

// BuildStepProperties base properties for any  build step.
type BuildStepProperties struct {
	// ProvisioningState - The provisioning state of the build step. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Type - Possible values include: 'TypeBuildStepProperties', 'TypeDocker'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicBuildStepProperties(body []byte) (BasicBuildStepProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDocker):
		var dbs DockerBuildStep
		err := json.Unmarshal(body, &dbs)
		return dbs, err
	default:
		var bsp BuildStepProperties
		err := json.Unmarshal(body, &bsp)
		return bsp, err
	}
}

// MarshalJSON is the custom marshaler for BuildStepProperties.
func (bsp BuildStepProperties) MarshalJSON() ([]byte, error) {
	bsp.Type = TypeBuildStepProperties
	objectMap := make(map[string]interface{})
	if bsp.ProvisioningState != "" {
		objectMap["provisioningState"] = bsp.ProvisioningState
	}
	if bsp.Type != "" {
		objectMap["type"] = bsp.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicBuildStepProperties implementation for BuildStepProperties.
func (bsp BuildStepProperties) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsBuildStepProperties is the BasicBuildStepProperties implementation for BuildStepProperties.
func (bsp BuildStepProperties) AsBuildStepProperties() (*BuildStepProperties, bool) {
	return &bsp, true
}

// AsBasicBuildStepProperties is the BasicBuildStepProperties implementation for BuildStepProperties.
func (bsp BuildStepProperties) AsBasicBuildStepProperties() (BasicBuildStepProperties, bool) {
	return &bsp, true
}

// BasicBuildStepPropertiesUpdateParameters the properties for updating a build step.
type BasicBuildStepPropertiesUpdateParameters interface {
	AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool)
	AsBuildStepPropertiesUpdateParameters() (*BuildStepPropertiesUpdateParameters, bool)
}

// BuildStepPropertiesUpdateParameters the properties for updating a build step.
type BuildStepPropertiesUpdateParameters struct {
	// Type - Possible values include: 'TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters', 'TypeBasicBuildStepPropertiesUpdateParametersTypeDocker'
	Type TypeBasicBuildStepPropertiesUpdateParameters `json:"type,omitempty"`
}

func unmarshalBasicBuildStepPropertiesUpdateParameters(body []byte) (BasicBuildStepPropertiesUpdateParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicBuildStepPropertiesUpdateParametersTypeDocker):
		var dbsup DockerBuildStepUpdateParameters
		err := json.Unmarshal(body, &dbsup)
		return dbsup, err
	default:
		var bspup BuildStepPropertiesUpdateParameters
		err := json.Unmarshal(body, &bspup)
		return bspup, err
	}
}

// MarshalJSON is the custom marshaler for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	bspup.Type = TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters
	objectMap := make(map[string]interface{})
	if bspup.Type != "" {
		objectMap["type"] = bspup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) AsBuildStepPropertiesUpdateParameters() (*BuildStepPropertiesUpdateParameters, bool) {
	return &bspup, true
}

// AsBasicBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for BuildStepPropertiesUpdateParameters.
func (bspup BuildStepPropertiesUpdateParameters) AsBasicBuildStepPropertiesUpdateParameters() (BasicBuildStepPropertiesUpdateParameters, bool) {
	return &bspup, true
}

// BuildStepsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildStepsCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildStepsCreateFuture) Result(client BuildStepsClient) (bs BuildStep, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return bs, azure.NewAsyncOpIncompleteError("containerregistry.BuildStepsCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		bs, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	bs, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildStepsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildStepsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildStepsDeleteFuture) Result(client BuildStepsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("containerregistry.BuildStepsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildStepsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildStepsUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildStepsUpdateFuture) Result(client BuildStepsClient) (bs BuildStep, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return bs, azure.NewAsyncOpIncompleteError("containerregistry.BuildStepsUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		bs, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	bs, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildStepsUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildStepUpdateParameters the parameters for updating a build step.
type BuildStepUpdateParameters struct {
	// BasicBuildStepPropertiesUpdateParameters - The properties for updating a build step.
	BasicBuildStepPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BuildStepUpdateParameters.
func (bsup BuildStepUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = bsup.BasicBuildStepPropertiesUpdateParameters
	if bsup.Tags != nil {
		objectMap["tags"] = bsup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildStepUpdateParameters struct.
func (bsup *BuildStepUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicBuildStepPropertiesUpdateParameters, err := unmarshalBasicBuildStepPropertiesUpdateParameters(*v)
				if err != nil {
					return err
				}
				bsup.BasicBuildStepPropertiesUpdateParameters = basicBuildStepPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bsup.Tags = tags
			}
		}
	}

	return nil
}

// BuildsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildsUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildsUpdateFuture) Result(client BuildsClient) (b Build, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return b, azure.NewAsyncOpIncompleteError("containerregistry.BuildsUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		b, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildsUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	b, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildsUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildTask the build task that has the resource properties and all build items. The build task will have all
// information to schedule a build against it.
type BuildTask struct {
	autorest.Response `json:"-"`
	// BuildTaskProperties - The properties of a build task.
	*BuildTaskProperties `json:"properties,omitempty"`
	// ID - The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BuildTask.
func (bt BuildTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bt.BuildTaskProperties != nil {
		objectMap["properties"] = bt.BuildTaskProperties
	}
	if bt.ID != nil {
		objectMap["id"] = bt.ID
	}
	if bt.Name != nil {
		objectMap["name"] = bt.Name
	}
	if bt.Type != nil {
		objectMap["type"] = bt.Type
	}
	if bt.Location != nil {
		objectMap["location"] = bt.Location
	}
	if bt.Tags != nil {
		objectMap["tags"] = bt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildTask struct.
func (bt *BuildTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var buildTaskProperties BuildTaskProperties
				err = json.Unmarshal(*v, &buildTaskProperties)
				if err != nil {
					return err
				}
				bt.BuildTaskProperties = &buildTaskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bt.Tags = tags
			}
		}
	}

	return nil
}

// BuildTaskBuildRequest the queue build parameters based on a build task.
type BuildTaskBuildRequest struct {
	// BuildTaskName - The name of build task against which build has to be queued.
	BuildTaskName *string `json:"buildTaskName,omitempty"`
	// Type - Possible values include: 'TypeQueueBuildRequest', 'TypeBuildTask', 'TypeQuickBuild'
	Type TypeBasicQueueBuildRequest `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) MarshalJSON() ([]byte, error) {
	btbr.Type = TypeBuildTask
	objectMap := make(map[string]interface{})
	if btbr.BuildTaskName != nil {
		objectMap["buildTaskName"] = btbr.BuildTaskName
	}
	if btbr.Type != "" {
		objectMap["type"] = btbr.Type
	}
	return json.Marshal(objectMap)
}

// AsBuildTaskBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool) {
	return &btbr, true
}

// AsQuickBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsQuickBuildRequest() (*QuickBuildRequest, bool) {
	return nil, false
}

// AsQueueBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsQueueBuildRequest() (*QueueBuildRequest, bool) {
	return nil, false
}

// AsBasicQueueBuildRequest is the BasicQueueBuildRequest implementation for BuildTaskBuildRequest.
func (btbr BuildTaskBuildRequest) AsBasicQueueBuildRequest() (BasicQueueBuildRequest, bool) {
	return &btbr, true
}

// BuildTaskFilter the filter that can be used for listing build tasks.
type BuildTaskFilter struct {
	// Alias - The alternative name for build task.
	Alias *string `json:"alias,omitempty"`
}

// BuildTaskListResult the collection of build tasks.
type BuildTaskListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]BuildTask `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BuildTaskListResultIterator provides access to a complete listing of BuildTask values.
type BuildTaskListResultIterator struct {
	i    int
	page BuildTaskListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BuildTaskListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BuildTaskListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BuildTaskListResultIterator) Response() BuildTaskListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BuildTaskListResultIterator) Value() BuildTask {
	if !iter.page.NotDone() {
		return BuildTask{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (btlr BuildTaskListResult) IsEmpty() bool {
	return btlr.Value == nil || len(*btlr.Value) == 0
}

// buildTaskListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (btlr BuildTaskListResult) buildTaskListResultPreparer() (*http.Request, error) {
	if btlr.NextLink == nil || len(to.String(btlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(btlr.NextLink)))
}

// BuildTaskListResultPage contains a page of BuildTask values.
type BuildTaskListResultPage struct {
	fn   func(BuildTaskListResult) (BuildTaskListResult, error)
	btlr BuildTaskListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BuildTaskListResultPage) Next() error {
	next, err := page.fn(page.btlr)
	if err != nil {
		return err
	}
	page.btlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BuildTaskListResultPage) NotDone() bool {
	return !page.btlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BuildTaskListResultPage) Response() BuildTaskListResult {
	return page.btlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BuildTaskListResultPage) Values() []BuildTask {
	if page.btlr.IsEmpty() {
		return nil
	}
	return *page.btlr.Value
}

// BuildTaskProperties the properties of a build task.
type BuildTaskProperties struct {
	// ProvisioningState - The provisioning state of the build task. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationDate - The creation date of build task.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// Alias - The alternative updatable name for a build task.
	Alias *string `json:"alias,omitempty"`
	// Status - The current status of build task. Possible values include: 'Disabled', 'Enabled'
	Status BuildTaskStatus `json:"status,omitempty"`
	// SourceRepository - The properties that describes the source(code) for the build task.
	SourceRepository *SourceRepositoryProperties `json:"sourceRepository,omitempty"`
	// Platform - The platform properties against which the build has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// Timeout - Build timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
}

// BuildTaskPropertiesUpdateParameters the properties for updating a build task.
type BuildTaskPropertiesUpdateParameters struct {
	// Alias - The alternative updatable name for a build task.
	Alias *string `json:"alias,omitempty"`
	// Status - The current status of build task. Possible values include: 'Disabled', 'Enabled'
	Status BuildTaskStatus `json:"status,omitempty"`
	// Platform - The platform properties against which the build has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// Timeout - Build timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// SourceRepository - The properties that describes the source(code) for the build task.
	SourceRepository *SourceRepositoryUpdateParameters `json:"sourceRepository,omitempty"`
}

// BuildTasksCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildTasksCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildTasksCreateFuture) Result(client BuildTasksClient) (bt BuildTask, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return bt, azure.NewAsyncOpIncompleteError("containerregistry.BuildTasksCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		bt, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	bt, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildTasksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildTasksDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildTasksDeleteFuture) Result(client BuildTasksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("containerregistry.BuildTasksDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildTasksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BuildTasksUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future BuildTasksUpdateFuture) Result(client BuildTasksClient) (bt BuildTask, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return bt, azure.NewAsyncOpIncompleteError("containerregistry.BuildTasksUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		bt, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	bt, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.BuildTasksUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BuildTaskUpdateParameters the parameters for updating a build task.
type BuildTaskUpdateParameters struct {
	// BuildTaskPropertiesUpdateParameters - The properties for updating a build task.
	*BuildTaskPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BuildTaskUpdateParameters.
func (btup BuildTaskUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if btup.BuildTaskPropertiesUpdateParameters != nil {
		objectMap["properties"] = btup.BuildTaskPropertiesUpdateParameters
	}
	if btup.Tags != nil {
		objectMap["tags"] = btup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BuildTaskUpdateParameters struct.
func (btup *BuildTaskUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var buildTaskPropertiesUpdateParameters BuildTaskPropertiesUpdateParameters
				err = json.Unmarshal(*v, &buildTaskPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				btup.BuildTaskPropertiesUpdateParameters = &buildTaskPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				btup.Tags = tags
			}
		}
	}

	return nil
}

// BuildUpdateParameters the set of build properties that can be updated.
type BuildUpdateParameters struct {
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
}

// DockerBuildStep the Docker build step.
type DockerBuildStep struct {
	// Branch - The repository branch name.
	Branch *string `json:"branch,omitempty"`
	// ImageName - The full qualified names of the image including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicate whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// DockerFilePath - The Docker file path relative to the source control root.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// ContextPath - The relative context path for a docker build in the source.
	ContextPath *string `json:"contextPath,omitempty"`
	// BuildArguments - The custom arguments for building this build step.
	BuildArguments *[]BuildArgument `json:"buildArguments,omitempty"`
	// BaseImageDependencies - List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// BaseImageTrigger - The type of the auto trigger for base image dependency updates. Possible values include: 'Runtime', 'None'
	BaseImageTrigger BaseImageTriggerType `json:"baseImageTrigger,omitempty"`
	// ProvisioningState - The provisioning state of the build step. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Type - Possible values include: 'TypeBuildStepProperties', 'TypeDocker'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStep.
func (dbs DockerBuildStep) MarshalJSON() ([]byte, error) {
	dbs.Type = TypeDocker
	objectMap := make(map[string]interface{})
	if dbs.Branch != nil {
		objectMap["branch"] = dbs.Branch
	}
	if dbs.ImageNames != nil {
		objectMap["imageNames"] = dbs.ImageNames
	}
	if dbs.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbs.IsPushEnabled
	}
	if dbs.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbs.DockerFilePath
	}
	if dbs.ContextPath != nil {
		objectMap["contextPath"] = dbs.ContextPath
	}
	if dbs.BuildArguments != nil {
		objectMap["buildArguments"] = dbs.BuildArguments
	}
	if dbs.BaseImageDependencies != nil {
		objectMap["baseImageDependencies"] = dbs.BaseImageDependencies
	}
	if dbs.BaseImageTrigger != "" {
		objectMap["baseImageTrigger"] = dbs.BaseImageTrigger
	}
	if dbs.ProvisioningState != "" {
		objectMap["provisioningState"] = dbs.ProvisioningState
	}
	if dbs.Type != "" {
		objectMap["type"] = dbs.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicBuildStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return &dbs, true
}

// AsBuildStepProperties is the BasicBuildStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsBuildStepProperties() (*BuildStepProperties, bool) {
	return nil, false
}

// AsBasicBuildStepProperties is the BasicBuildStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsBasicBuildStepProperties() (BasicBuildStepProperties, bool) {
	return &dbs, true
}

// DockerBuildStepUpdateParameters the properties for updating a docker build step.
type DockerBuildStepUpdateParameters struct {
	// Branch - The repository branch name.
	Branch *string `json:"branch,omitempty"`
	// ImageName - The full qualified name of the image including the repository and tag.
	ImageName *string `json:"imageName,omitempty"`
	// IsPushEnabled - The value of this property indicate whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// DockerFilePath - The Docker file path relative to the source control root.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// ContextPath - The relative context path for a docker build in the source.
	ContextPath *string `json:"contextPath,omitempty"`
	// BuildArguments - The custom arguments for building this build step.
	BuildArguments *[]BuildArgument `json:"buildArguments,omitempty"`
	// BaseImageTrigger - The type of the auto trigger for base image dependency updates. Possible values include: 'Runtime', 'None'
	BaseImageTrigger BaseImageTriggerType `json:"baseImageTrigger,omitempty"`
	// Type - Possible values include: 'TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters', 'TypeBasicBuildStepPropertiesUpdateParametersTypeDocker'
	Type TypeBasicBuildStepPropertiesUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) MarshalJSON() ([]byte, error) {
	dbsup.Type = TypeBasicBuildStepPropertiesUpdateParametersTypeDocker
	objectMap := make(map[string]interface{})
	if dbsup.Branch != nil {
		objectMap["branch"] = dbsup.Branch
	}
	if dbsup.ImageName != nil {
		objectMap["imageName"] = dbsup.ImageName
	}
	if dbsup.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbsup.IsPushEnabled
	}
	if dbsup.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbsup.DockerFilePath
	}
	if dbsup.ContextPath != nil {
		objectMap["contextPath"] = dbsup.ContextPath
	}
	if dbsup.BuildArguments != nil {
		objectMap["buildArguments"] = dbsup.BuildArguments
	}
	if dbsup.BaseImageTrigger != "" {
		objectMap["baseImageTrigger"] = dbsup.BaseImageTrigger
	}
	if dbsup.Type != "" {
		objectMap["type"] = dbsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return &dbsup, true
}

// AsBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsBuildStepPropertiesUpdateParameters() (*BuildStepPropertiesUpdateParameters, bool) {
	return nil, false
}

// AsBasicBuildStepPropertiesUpdateParameters is the BasicBuildStepPropertiesUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsBasicBuildStepPropertiesUpdateParameters() (BasicBuildStepPropertiesUpdateParameters, bool) {
	return &dbsup, true
}

// Error azure container registry build API error object.
type Error struct {
	// Properties - Azure container registry build API error body.
	Properties *ErrorBody `json:"properties,omitempty"`
}

// ErrorBody azure container registry build API error body.
type ErrorBody struct {
	// Properties - Azure container registry build API error body.
	Properties *ErrorBodyProperties `json:"properties,omitempty"`
}

// ErrorBodyProperties azure container registry build API error body.
type ErrorBodyProperties struct {
	// Code - error code.
	Code *string `json:"code,omitempty"`
	// Message - error message.
	Message *string `json:"message,omitempty"`
}

// ImageDescriptor properties that describes a Docker image.
type ImageDescriptor struct {
	// RepositoryName - Name of the repository.
	RepositoryName *string `json:"repositoryName,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The image digest. Example: SHA256 based digest.
	Digest *string `json:"digest,omitempty"`
}

// PlatformProperties the platform properties against which the build has to happen.
type PlatformProperties struct {
	// OsType - The operating system type required for the build. Possible values include: 'Windows', 'Linux'
	OsType OsType `json:"osType,omitempty"`
	// CPU - The CPU configuration in terms of number of cores required for the build.
	CPU *int32 `json:"cpu,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags.
type ProxyResource struct {
	// ID - The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// BasicQueueBuildRequest the queue build request parameters.
type BasicQueueBuildRequest interface {
	AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool)
	AsQuickBuildRequest() (*QuickBuildRequest, bool)
	AsQueueBuildRequest() (*QueueBuildRequest, bool)
}

// QueueBuildRequest the queue build request parameters.
type QueueBuildRequest struct {
	// Type - Possible values include: 'TypeQueueBuildRequest', 'TypeBuildTask', 'TypeQuickBuild'
	Type TypeBasicQueueBuildRequest `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QueueBuildRequest.
func (qbr QueueBuildRequest) MarshalJSON() ([]byte, error) {
	qbr.Type = TypeQueueBuildRequest
	objectMap := make(map[string]interface{})
	if qbr.Type != "" {
		objectMap["type"] = qbr.Type
	}
	return json.Marshal(objectMap)
}

// AsBuildTaskBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool) {
	return nil, false
}

// AsQuickBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsQuickBuildRequest() (*QuickBuildRequest, bool) {
	return nil, false
}

// AsQueueBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsQueueBuildRequest() (*QueueBuildRequest, bool) {
	return &qbr, true
}

// AsBasicQueueBuildRequest is the BasicQueueBuildRequest implementation for QueueBuildRequest.
func (qbr QueueBuildRequest) AsBasicQueueBuildRequest() (BasicQueueBuildRequest, bool) {
	return &qbr, true
}

// QuickBuildRequest the queue build request parameters for a quick build.
type QuickBuildRequest struct {
	// ImageName - The fully qualified image names with the tag that the build tags it.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source that needs to be built. For Docker build, it can be an URL to a tar or github repository as supported by Docker.
	// If it is relative URL, the relative path should be obtained from calling getSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// BuildArguments - The collection of build arguments to be used.
	BuildArguments *[]BuildArgument `json:"buildArguments,omitempty"`
	// IsPushEnabled - The value of this property indicate whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// Timeout - Build timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the build will happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// DockerFilePath - The Docker file path relative to the source location.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Type - Possible values include: 'TypeQueueBuildRequest', 'TypeBuildTask', 'TypeQuickBuild'
	Type TypeBasicQueueBuildRequest `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QuickBuildRequest.
func (qbr QuickBuildRequest) MarshalJSON() ([]byte, error) {
	qbr.Type = TypeQuickBuild
	objectMap := make(map[string]interface{})
	if qbr.ImageNames != nil {
		objectMap["imageNames"] = qbr.ImageNames
	}
	if qbr.SourceLocation != nil {
		objectMap["sourceLocation"] = qbr.SourceLocation
	}
	if qbr.BuildArguments != nil {
		objectMap["buildArguments"] = qbr.BuildArguments
	}
	if qbr.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = qbr.IsPushEnabled
	}
	if qbr.Timeout != nil {
		objectMap["timeout"] = qbr.Timeout
	}
	if qbr.Platform != nil {
		objectMap["platform"] = qbr.Platform
	}
	if qbr.DockerFilePath != nil {
		objectMap["dockerFilePath"] = qbr.DockerFilePath
	}
	if qbr.Type != "" {
		objectMap["type"] = qbr.Type
	}
	return json.Marshal(objectMap)
}

// AsBuildTaskBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsBuildTaskBuildRequest() (*BuildTaskBuildRequest, bool) {
	return nil, false
}

// AsQuickBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsQuickBuildRequest() (*QuickBuildRequest, bool) {
	return &qbr, true
}

// AsQueueBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsQueueBuildRequest() (*QueueBuildRequest, bool) {
	return nil, false
}

// AsBasicQueueBuildRequest is the BasicQueueBuildRequest implementation for QuickBuildRequest.
func (qbr QuickBuildRequest) AsBasicQueueBuildRequest() (BasicQueueBuildRequest, bool) {
	return &qbr, true
}

// RegistriesQueueBuildFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RegistriesQueueBuildFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RegistriesQueueBuildFuture) Result(client RegistriesClient) (b Build, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesQueueBuildFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return b, azure.NewAsyncOpIncompleteError("containerregistry.RegistriesQueueBuildFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		b, err = client.QueueBuildResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesQueueBuildFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	req = autorest.ChangeToGet(future.req)
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesQueueBuildFuture", "Result", resp, "Failure sending request")
		return
	}
	b, err = client.QueueBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesQueueBuildFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Resource an Azure resource.
type Resource struct {
	// ID - The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SourceControlAuthInfo the authorization properties for accessing the source code repository.
type SourceControlAuthInfo struct {
	// TokenType - The type of Auth token. Possible values include: 'PAT', 'OAuth'
	TokenType TokenType `json:"tokenType,omitempty"`
	// Token - The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`
	// RefreshToken - The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - The scope of the access token.
	Scope *string `json:"scope,omitempty"`
	// ExpiresIn - Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
}

// SourceRepositoryProperties the properties of the source code repository.
type SourceRepositoryProperties struct {
	autorest.Response `json:"-"`
	// SourceControlType - The type of source control service. Possible values include: 'Github', 'VisualStudioTeamService'
	SourceControlType SourceControlType `json:"sourceControlType,omitempty"`
	// RepositoryURL - The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// IsCommitTriggerEnabled - The value of this property indicates whether the source control commit trigger is enabled or not.
	IsCommitTriggerEnabled *bool `json:"isCommitTriggerEnabled,omitempty"`
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository.
	SourceControlAuthProperties *SourceControlAuthInfo `json:"sourceControlAuthProperties,omitempty"`
}

// SourceRepositoryUpdateParameters the properties for updating the source code repository configuration.
type SourceRepositoryUpdateParameters struct {
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository.
	SourceControlAuthProperties *SourceControlAuthInfo `json:"sourceControlAuthProperties,omitempty"`
	// IsCommitTriggerEnabled - The value of this property indicates whether the source control commit trigger is enabled or not.
	IsCommitTriggerEnabled *bool `json:"isCommitTriggerEnabled,omitempty"`
}

// SourceUploadDefinition the properties of a response to source upload request.
type SourceUploadDefinition struct {
	autorest.Response `json:"-"`
	// UploadURL - The URL where the client can upload the source.
	UploadURL *string `json:"uploadUrl,omitempty"`
	// RelativePath - The relative path to the source. This is used to submit the subsequent queue build request.
	RelativePath *string `json:"relativePath,omitempty"`
}
