package eventgrid

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ChannelsClient is the azure EventGrid Management Client
type ChannelsClient struct {
	BaseClient
}

// NewChannelsClient creates an instance of the ChannelsClient client.
func NewChannelsClient(subscriptionID string) ChannelsClient {
	return NewChannelsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewChannelsClientWithBaseURI creates an instance of the ChannelsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewChannelsClientWithBaseURI(baseURI string, subscriptionID string) ChannelsClient {
	return ChannelsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate synchronously creates or updates a new channel with the specified parameters.
// Parameters:
// resourceGroupName - the name of the resource group within the partners subscription.
// partnerNamespaceName - name of the partner namespace.
// channelName - name of the channel.
// channelInfo - channel information.
func (client ChannelsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, channelInfo Channel) (result Channel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, partnerNamespaceName, channelName, channelInfo)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ChannelsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, channelInfo Channel) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"channelName":          autorest.Encode("path", channelName),
		"partnerNamespaceName": autorest.Encode("path", partnerNamespaceName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	channelInfo.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}", pathParameters),
		autorest.WithJSON(channelInfo),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ChannelsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ChannelsClient) CreateOrUpdateResponder(resp *http.Response) (result Channel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an existing channel.
// Parameters:
// resourceGroupName - the name of the resource group within the partners subscription.
// partnerNamespaceName - name of the partner namespace.
// channelName - name of the channel.
func (client ChannelsClient) Delete(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string) (result ChannelsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, partnerNamespaceName, channelName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ChannelsClient) DeletePreparer(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"channelName":          autorest.Encode("path", channelName),
		"partnerNamespaceName": autorest.Encode("path", partnerNamespaceName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ChannelsClient) DeleteSender(req *http.Request) (future ChannelsDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ChannelsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get properties of a channel.
// Parameters:
// resourceGroupName - the name of the resource group within the partners subscription.
// partnerNamespaceName - name of the partner namespace.
// channelName - name of the channel.
func (client ChannelsClient) Get(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string) (result Channel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, partnerNamespaceName, channelName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ChannelsClient) GetPreparer(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"channelName":          autorest.Encode("path", channelName),
		"partnerNamespaceName": autorest.Encode("path", partnerNamespaceName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ChannelsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ChannelsClient) GetResponder(resp *http.Response) (result Channel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFullURL get the full endpoint URL of a partner destination channel.
// Parameters:
// resourceGroupName - the name of the resource group within the partners subscription.
// partnerNamespaceName - name of the partner namespace.
// channelName - name of the Channel.
func (client ChannelsClient) GetFullURL(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string) (result EventSubscriptionFullURL, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelsClient.GetFullURL")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetFullURLPreparer(ctx, resourceGroupName, partnerNamespaceName, channelName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "GetFullURL", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFullURLSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "GetFullURL", resp, "Failure sending request")
		return
	}

	result, err = client.GetFullURLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "GetFullURL", resp, "Failure responding to request")
		return
	}

	return
}

// GetFullURLPreparer prepares the GetFullURL request.
func (client ChannelsClient) GetFullURLPreparer(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"channelName":          autorest.Encode("path", channelName),
		"partnerNamespaceName": autorest.Encode("path", partnerNamespaceName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}/getFullUrl", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetFullURLSender sends the GetFullURL request. The method will close the
// http.Response Body if it receives an error.
func (client ChannelsClient) GetFullURLSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetFullURLResponder handles the response to the GetFullURL request. The method always
// closes the http.Response Body.
func (client ChannelsClient) GetFullURLResponder(resp *http.Response) (result EventSubscriptionFullURL, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByPartnerNamespace list all the channels in a partner namespace.
// Parameters:
// resourceGroupName - the name of the resource group within the partners subscription.
// partnerNamespaceName - name of the partner namespace.
// filter - the query used to filter the search results using OData syntax. Filtering is permitted on the
// 'name' property only and with limited number of OData operations. These operations are: the 'contains'
// function as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal).
// No arithmetic operations are supported. The following is a valid filter example: $filter=contains(namE,
// 'PATTERN') and name ne 'PATTERN-1'. The following is not a valid filter example: $filter=location eq
// 'westus'.
// top - the number of results to return per page for the list operation. Valid range for top parameter is 1 to
// 100. If not specified, the default number of results to be returned is 20 items per page.
func (client ChannelsClient) ListByPartnerNamespace(ctx context.Context, resourceGroupName string, partnerNamespaceName string, filter string, top *int32) (result ChannelsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelsClient.ListByPartnerNamespace")
		defer func() {
			sc := -1
			if result.clr.Response.Response != nil {
				sc = result.clr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByPartnerNamespaceNextResults
	req, err := client.ListByPartnerNamespacePreparer(ctx, resourceGroupName, partnerNamespaceName, filter, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "ListByPartnerNamespace", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByPartnerNamespaceSender(req)
	if err != nil {
		result.clr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "ListByPartnerNamespace", resp, "Failure sending request")
		return
	}

	result.clr, err = client.ListByPartnerNamespaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "ListByPartnerNamespace", resp, "Failure responding to request")
		return
	}
	if result.clr.hasNextLink() && result.clr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByPartnerNamespacePreparer prepares the ListByPartnerNamespace request.
func (client ChannelsClient) ListByPartnerNamespacePreparer(ctx context.Context, resourceGroupName string, partnerNamespaceName string, filter string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"partnerNamespaceName": autorest.Encode("path", partnerNamespaceName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByPartnerNamespaceSender sends the ListByPartnerNamespace request. The method will close the
// http.Response Body if it receives an error.
func (client ChannelsClient) ListByPartnerNamespaceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByPartnerNamespaceResponder handles the response to the ListByPartnerNamespace request. The method always
// closes the http.Response Body.
func (client ChannelsClient) ListByPartnerNamespaceResponder(resp *http.Response) (result ChannelsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByPartnerNamespaceNextResults retrieves the next set of results, if any.
func (client ChannelsClient) listByPartnerNamespaceNextResults(ctx context.Context, lastResults ChannelsListResult) (result ChannelsListResult, err error) {
	req, err := lastResults.channelsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "listByPartnerNamespaceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByPartnerNamespaceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "listByPartnerNamespaceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByPartnerNamespaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "listByPartnerNamespaceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByPartnerNamespaceComplete enumerates all values, automatically crossing page boundaries as required.
func (client ChannelsClient) ListByPartnerNamespaceComplete(ctx context.Context, resourceGroupName string, partnerNamespaceName string, filter string, top *int32) (result ChannelsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelsClient.ListByPartnerNamespace")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByPartnerNamespace(ctx, resourceGroupName, partnerNamespaceName, filter, top)
	return
}

// Update synchronously updates a channel with the specified parameters.
// Parameters:
// resourceGroupName - the name of the resource group within the partners subscription.
// partnerNamespaceName - name of the partner namespace.
// channelName - name of the channel.
// channelUpdateParameters - channel update information.
func (client ChannelsClient) Update(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, channelUpdateParameters ChannelUpdateParameters) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChannelsClient.Update")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.ChannelsClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ChannelsClient) UpdatePreparer(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, channelUpdateParameters ChannelUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"channelName":          autorest.Encode("path", channelName),
		"partnerNamespaceName": autorest.Encode("path", partnerNamespaceName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}", pathParameters),
		autorest.WithJSON(channelUpdateParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ChannelsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ChannelsClient) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
