/*
 * Parser stuff
 *
 * Copyright (C) 2003, SuSE Linux AG
 * Written by okir@suse.de
 */

#ifndef AUDITD_PARSER_H
#define AUDITD_PARSER_H

#include <stdio.h>

typedef struct parser	parser_t;

#define EQUALS          '='
#define SEMICOLON       ';'
#define COMMA           ','
#define LEFT_BRACE      '{'
#define RIGHT_BRACE     '}'
#define LEFT_BRACKET    '('
#define RIGHT_BRACKET   ')'

extern int		parse_file(const char *, int (*parse_statement)(void));
extern int		parser_get_token_or_eof(char *, size_t);
extern void		parser_get(char *, size_t);
extern void		parser_unget(const char *);
extern void		parser_expect(char);
extern unsigned int	current_line(void);
extern const char *	current_file(void);
extern void		cf_error(const char *, ...);

#endif /* AUDITD_PARSER_H */
