/*
 * Photo Image Print System
 * Copyright (C) 2000-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>


#include "getstat.h"
#include "pips.h"
#include "paper.rsc"
#include "xMode.h"
#include "pipsError.h"
#include "rscCtl.h"

static PAPER_CONF*  get_paper_auto(MODEL_CONFIG_LIST* model, char* paper_list_name);
static PAPER_CONF*  get_paper_auto_trim_4(MODEL_CONFIG_LIST* model, char* paper_list_name);
static LINE_PARSING_RSLT parse_line(const char* _line, int* argc, Str100* argv);

static MODEL_CONFIG_LIST* add_item ( MODEL_CONFIG_LIST* list_pointer, MODEL_CONFIG data);
static short* filter_field(short* arr,int sizeIn);
static short* sort_field(short *arr,int sizeIn);
static short* trim_arr(short *arr);
static short* get_field(short *arr,int sizeIn);
static short* get_id_size_trim_4(MODEL_CONFIG_LIST* model,int* size);
static MODEL_CONFIG_LIST* get_model(char* printerID, char* prtOptname);
static short* get_id_size(MODEL_CONFIG_LIST* model,int* size);
static short* get_id_type(MODEL_CONFIG_LIST* model,int* size);
static short* get_id_level(MODEL_CONFIG_LIST* model,int* size);
static int check_format_failed(char* strInput, int); 
static void free_list_model(MODEL_CONFIG_LIST* model);
static char** get_mediaSizeEntry(MODEL_CONFIG_LIST* model);
static char** get_mediaTypeEntry(MODEL_CONFIG_LIST* model);
static char** get_levelEntry(MODEL_CONFIG_LIST* model);
static short* get_model_arr(MODEL_CONFIG_LIST* model);



/***********************************************************/
/*--------------------------------------------------*/
static MODEL_CONFIG_LIST*
add_item ( MODEL_CONFIG_LIST* listpointer, MODEL_CONFIG data)
{
	MODEL_CONFIG_LIST* lp = listpointer;

	if (listpointer != NULL) 
	{
        	while (listpointer -> link != NULL)
		{
        		listpointer = (  MODEL_CONFIG_LIST  *)listpointer->link;
		}
		listpointer->link = ( struct MODEL_CONFIG_LIST  *) malloc (sizeof( MODEL_CONFIG_LIST));
		if(listpointer->link==NULL)
		{
			pipsError(NULL,MEMORY_ERROR);
			exit(1);
		}	
		listpointer = (  MODEL_CONFIG_LIST  *) listpointer->link;
		listpointer->link = NULL;
		listpointer->dataitem= data;
		return lp;
        }
	else
	{
        	listpointer = (  MODEL_CONFIG_LIST  *) malloc (sizeof ( MODEL_CONFIG_LIST));
		if(listpointer==NULL)
		{
			pipsError(NULL,MEMORY_ERROR);
			exit(1);
		}
        	listpointer -> link = NULL;
        	listpointer -> dataitem = data;
        	return listpointer;
        }

}


static LINE_PARSING_RSLT 
parse_line(const char* _line, int* argc, Str100* argv)
{
	int	line_parsing_rslt = LPR_NULL;
	char	*s_char_adr = NULL;
	char	*e_char_adr = NULL;
	char	*token;
	char	line[MAX_LINE_LEN];
	char	seps[]   = ",\n";

	strcpy(line, _line);
	s_char_adr = line;
	

	if (s_char_adr[0] == '#')
	{
		line_parsing_rslt = LPR_COMMENT;
	}

	if (line_parsing_rslt == LPR_NULL)
	{		
		e_char_adr = strchr(line, ']');
		if (s_char_adr[0] == '[' && e_char_adr != NULL)
		{
			*e_char_adr = '\0';
			strcpy(argv[0], &s_char_adr[1]);
			*argc = 1;
			line_parsing_rslt = LPR_PRINTER_ID;
		}
	}

	if (line_parsing_rslt == LPR_NULL)
	{
		token = strtok(s_char_adr, seps);
		*argc = 0;
		while (token != NULL)
		{
			strcpy(argv[*argc], token);
			
			(*argc)++;
			token = strtok(NULL, seps);
		}
		if (*argc == PRTOPT_FIELD_NUM 
			&& isdigit(argv[PRTOPT_MEDIA_SIZE][0]) 
			&& isdigit(argv[PRTOPT_MEDIA_TYPE][0])
			&& isdigit(argv[PRTOPT_QUALITY][0]) 
			&& isdigit(argv[PRTOPT_FUCHINASI][0])
			&& atoi(argv[PRTOPT_QUALITY]) < QLT_NUM && atoi(argv[PRTOPT_FUCHINASI]) < FUCHI_NUM)
		{
			line_parsing_rslt = LPR_PRTOPT_ENTRY;
		}
		else if (*argc == PAPER_FIELD_NUM && isdigit(argv[PAPER_ID][0]) 
			&& isdigit(argv[PAPER_SIZE_WIDTH][0]) && isdigit(argv[PAPER_SIZE_HEIGHT][0]) 
			&& isdigit(argv[PAPER_MARGIN_LEFT][0]) && isdigit(argv[PAPER_MARGIN_TOP][0]) 
			&& isdigit(argv[PAPER_MARGIN_RIGHT][0]) && isdigit(argv[PAPER_MARGIN_BOTTOM][0]))
		{
			line_parsing_rslt = LPR_PAPERINFO_ENTRY;
		}
	}

	return line_parsing_rslt;
}

static MODEL_CONFIG_LIST*
get_model(char* printerID, char* prtOptname)
{

	FILE  *f;
        int argc, found;
        char str[MAX_LINE_LEN];
        Str100	argv[10];
        MODEL_CONFIG temp;
        MODEL_CONFIG_LIST *temp_model=NULL;

        f=fopen(prtOptname,"r");
        if(!f)
        {
		pipsError(NULL,FAILED_FILE_ERROR);
		return NULL;
	}
/*	find printerID		*/
	found=0;
        while(!feof(f))
        {
                fgets(str,MAX_LINE_LEN+1,f);
                if(parse_line(str,&argc,argv)== LPR_PRINTER_ID) 
                {
                	if(strcmp(argv[0],printerID) ==0)
                	{
                		found=1;
                		break;
                	}
		
                }
         }
	if (found==0)
	{
		pipsError(NULL,FAILED_FILE_ERROR);
		return NULL;
	}

/*	Read prtOpt Data	*/
	while(!feof(f))
        {
        	fgets(str,MAX_LINE_LEN+1,f);
                if(parse_line(str,&argc,argv)==LPR_PRTOPT_ENTRY) 
                {
                	temp.idSize=atoi(argv[0]);
                        temp.idType=atoi(argv[1]);
                        temp.idLevel=atoi(argv[2]);
                        temp.idT4=atoi(argv[3]);
                        temp_model=add_item(temp_model,temp);
			
                 } 
                 else
		 {
		 	break;
		 }
        }
	fclose(f);

        return temp_model;
}


static short*
get_id_size(MODEL_CONFIG_LIST* model,int* size)
{

	int i, count;
        short *arr, *temp;
        MODEL_CONFIG_LIST* temp_model;

        if(model==NULL)
	{
		return NULL;
	}
        count=0;
        temp_model=model;
        while(temp_model!=NULL)
        {
        	count++;
                temp_model=(MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr=(short*)malloc((count+1)*sizeof(short));
	if(arr==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
        temp_model=model;
        i=0;
        while(temp_model!=NULL)
        {
        	arr[i++]=temp_model->dataitem.idSize;
        	temp_model=( MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr[i]=-1;
	temp=get_field(arr,i+1);
	count=i=0;
        while(temp[i++]!=-1)
        {
        	count++;
        }
	*size=++count;
	free(arr);
        return temp;
}

static short*
get_id_type(MODEL_CONFIG_LIST* model,int* size)
{

	int i, count;
        short *arr, *temp;
        MODEL_CONFIG_LIST* temp_model;

        if(model==NULL)
	{
		return NULL;
	}
        count=0;
        temp_model=model;
        while(temp_model!=NULL)
        {
        	count++;
        	temp_model=(MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr=(short*)malloc((count+1)*sizeof(short));
	if(arr==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
        temp_model=model;
        i=0;
        while(temp_model!=NULL)
        {
        	arr[i++]=temp_model->dataitem.idType;  
        	temp_model=( MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr[i]=-1;
	temp=get_field(arr,i+1);
	count=i=0;
        while(temp[i++]!=-1)
        {
        	count++;
        }
	*size=++count;
	free(arr);
        return temp;
}

static short*
get_id_level(MODEL_CONFIG_LIST* model, int* size)
{

	int i, count;
        short *arr, *temp;
        MODEL_CONFIG_LIST* temp_model;

        if(model==NULL)
	{
		return NULL;
	}
        count=0;
        temp_model=model;
        while(temp_model!=NULL)
        {
        	count++;
        	temp_model=(MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr=(short*)malloc((count+1)*sizeof(short));
	if(arr==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
        temp_model=model;
        i=0;
        while(temp_model!=NULL)
        {
        	arr[i++]=temp_model->dataitem.idLevel;
        	temp_model=( MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr[i]=-1;
	temp=get_field(arr,i+1);
	count=i=0;
        while(temp[i++]!=-1)
        {
        	count++;
        }
	*size=++count;
	free(arr);
        return temp;
}

static short*
get_id_size_trim_4(MODEL_CONFIG_LIST* model,int* size)
{

	int i, count;
        short *arr, *temp;
        MODEL_CONFIG_LIST* temp_model;

        if(model==NULL)
	{
		return NULL;
	}
        count=0;
        temp_model=model;
        while(temp_model!=NULL)
        {
        	if(temp_model->dataitem.idT4==1)
		{
			count++;
		}
        	temp_model=(MODEL_CONFIG_LIST* )temp_model->link;
        }
	arr=(short*)malloc((count+1)*sizeof(short));
	if(arr==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
        temp_model=model;
        i=0;
        while(temp_model!=NULL)
        {
        	if(temp_model->dataitem.idT4==1)
		{
			arr[i++]=temp_model->dataitem.idSize;
		}
        	temp_model=( MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr[i]=-1;
	temp=get_field(arr,i+1);
	count=i=0;
        while(temp[i++]!=-1)
        {
        	count++;
        }
	*size=++count;
	free(arr);
        return temp;
}
static short*
filter_field(short* arr,int sizeIn)
{

	int i;
        short temp=-1;

        if(arr==NULL)
	{
		return NULL;
	}
	else
	{
        	for(i=0;i<sizeIn;i++)
        	{
        		if(arr[i]==temp)
			{
        			arr[i]=-1;
			}
        		if(arr[i]!=-1)
			{
				temp=arr[i];
			}
        	}
        	return arr;
	}

}

static short*
sort_field(short *arr,int sizeIn)
{
	int i, j;
        short temp;

        if(arr==NULL)
	{
		return NULL;
	}
	else
	{
        	for(i=0;i<sizeIn-1;i++)
		{
        		for(j=i;j<sizeIn;j++)
			{
        			if(arr[i]<arr[j])
        			{
        				temp=arr[i];
        				arr[i]=arr[j];
        				arr[j]=temp;
        			}
			}
		}
        	return arr;
	}

}

static short*
get_field(short *arr,int sizeIn)
{

	if(arr==NULL)
	{
		return NULL;
	}
	else
	{
		sort_field(arr,sizeIn);
        	filter_field(arr,sizeIn);
        	sort_field(arr,sizeIn);	
		return trim_arr(arr);
		
	}

}

static short*
trim_arr(short *arr)
{
	short *temp;
	short tg;
	int i, j, count;
	
	if(arr==NULL)
	{
		return NULL;
	}
	else
	{
		i=count=0;
		while(arr[i++]!=-1)
		{
			count++;
		}
		temp=(short*)malloc((count+1)*sizeof(short));
		if(temp==NULL)
		{
			pipsError(NULL,MEMORY_ERROR);
			exit(1);
		}
		i=0;
		while(arr[i]!=-1)
		{
			temp[i]=arr[i];
			i++;
		}
		temp[i]=-1;
		temp=sort_field(temp,i+1);
		count=i;
		for(i=0;i<count-1;i++)
			for(j=i;j<count;j++)
			{
				if(temp[i]>temp[j])
				{
					tg=temp[i];
					temp[i]=temp[j];
					temp[j]=tg;
				}
			}
		return temp;
	}

}

static int
check_format_failed(char* strInput,int size)
{
	int len,i;

	len=size;
	if(len==0)
	{
		return 1;
	}
	i=9;
	do
	{
        	if(strInput[i]!='S')
		{
			return 1;
		}
        	i+=2;
        	do
		{
                	if(strInput[i]!='T')
			{
				return 1;
			}
                	i+=3;
                	if(strInput[i++]!='/')
			{
				return 1;
			}
                }while(i<len && strInput[i]=='T');
		if(strInput[i++]!='/')
		{
			return 1;
		}
	}while(i<len && strInput[i]=='S');

	return 0;
}

static void
free_list_model(MODEL_CONFIG_LIST* model) 
{
	MODEL_CONFIG_LIST *tmp;

	while (model != NULL) 
        {
        	tmp = (MODEL_CONFIG_LIST *)model->link;
        	free(model);
        	model = tmp;
        }

 }

/*          load_printer_option */
/*--------------------------------------------------*/


static PAPER_CONF*
get_paper_auto(MODEL_CONFIG_LIST* model, char* paper_list_name)
{
	FILE  *f;
        int i, j, argc, count, s;
        short w, h, tm, lm, rm, bm;
        char str[MAX_LINE_LEN];
        Str100	argv[10];
	char* str_res;
        PAPER_CONF temp, END_ARR={NULL, -1, -1, -1, -1, -1, -1};
        PAPER_CONF *temp_paper;
        short *idSize;

        idSize=get_id_size(model,&s);
        if(idSize==NULL)
	{
		return NULL;
	}
        f=fopen(paper_list_name,"r");
        if(!f)
        {
		pipsError(NULL,FAILED_FILE_ERROR);
		free(idSize);
		return NULL;
	}
        i=j=count=0;
        while(idSize[i++]!=-1)
	{
		count++;
	}
        temp_paper=(PAPER_CONF *)malloc((count+1)*sizeof(PAPER_CONF));
	if(temp_paper==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		free(idSize);
		exit(1);
	}
        while( !feof(f))
	{
        	fgets(str,MAX_LINE_LEN+1,f);
        	if(parse_line(str,&argc,argv)==LPR_PAPERINFO_ENTRY)
        	{
        		for(i=0;i<count;i++)
        		{
        			if(idSize[i]==atoi(argv[1])) 
        			{
                        		w=atoi(argv[2]);
                        		h=atoi(argv[3]);
                        		lm=atoi(argv[4]);
                        		tm=atoi(argv[5]);
                        		rm=atoi(argv[6]);
                        		bm=atoi(argv[7]);
					str_res=getRscName(P_MEDIA_SIZE,idSize[i]);
                        		temp.res=(char *)malloc(strlen(str_res)+1);
					if(temp.res==NULL)
					{
						pipsError(NULL,MEMORY_ERROR);
						free(idSize);
						exit(1);
					}
					strcpy(temp.res,str_res);
                        		temp.size_x= w;
                        		temp.size_y= h;
                        		temp.area_x= w-(lm+rm);
                        		temp.area_y= h-(tm+bm);
                        		temp.margin_x= lm;
                        		temp.margin_y= tm;
                        		temp_paper[j++]=temp;

                  		};
                  	}
			
         	}
         strcpy(str,"");
         }
         temp_paper[j]=END_ARR;
         fclose(f);
	 free(idSize);	
         return temp_paper;
}


static short*
get_model_arr(MODEL_CONFIG_LIST* model)
{
	int i, count;
        short* arr;
        MODEL_CONFIG_LIST* temp_model;

        if(model==NULL)
	{
		return NULL;
	}
        count=0;
        temp_model=model;
        while(temp_model!=NULL)
        {
        	count++;
        	temp_model=(MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr=(short*)malloc((4*count+1)*sizeof(short));
	if(arr==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}	
        temp_model=model;
        i=0;
        while(temp_model!=NULL)
        {
        	arr[i++]=temp_model->dataitem.idSize;
                arr[i++]=temp_model->dataitem.idType;
                arr[i++]=temp_model->dataitem.idLevel;
                arr[i++]=temp_model->dataitem.idT4;
                temp_model=( MODEL_CONFIG_LIST* )temp_model->link;
        }
        arr[i]=-1;

        return arr;
}


static PAPER_CONF*
get_paper_auto_trim_4(MODEL_CONFIG_LIST* model, char* paper_list_name)
{

	FILE  *f;
        int i, j, argc, count, size;
        short w, h;
	short *idSize;
        char str[MAX_LINE_LEN];
        Str100	argv[10];
	char* str_res;
        PAPER_CONF temp, END_ARR={ NULL, -1, -1, -1, -1, -1, -1 };
        PAPER_CONF *temp_paper;

        idSize=get_id_size_trim_4(model,&size);
        if(idSize==NULL)
	{
		return NULL;
	}
        f=fopen(paper_list_name,"r");
        if(!f)
        {

		pipsError(NULL,FAILED_FILE_ERROR);
		free(idSize);
		return NULL;
	}
        i=j=count=0;
        while(idSize[i++]!=-1)
	{
		count++;
	}
        temp_paper=(PAPER_CONF *)malloc((count+1)*sizeof(PAPER_CONF));
	if(temp_paper==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		free(idSize);
		exit(1);
	}
        while( !feof(f))
        {
        	fgets(str,MAX_LINE_LEN+1,f);
                if(parse_line(str,&argc,argv)==LPR_PAPERINFO_ENTRY)
                {
                	for(i=0;i<count;i++)
                        {
                        	if(idSize[i]==atoi(argv[1])) 
                                {
                                	w=atoi(argv[2]);
                                	h=atoi(argv[3]);
                                	str_res=getRscName(P_MEDIA_SIZE,idSize[i]);
                        		temp.res=(char *)malloc(strlen(str_res)+1);
					if(temp.res==NULL)
					{
						pipsError(NULL,MEMORY_ERROR);
						free(idSize);
						exit(1);
					}
					strcpy(temp.res,str_res);
                                	temp.size_x= w;
                                	temp.size_y= h;
                                	temp.area_x= w+(36+36);
                                	temp.area_y= h+(70+42);
                                	temp.margin_x= 0;
                                	temp.margin_y= 0;
                                	temp_paper[j++]=temp;
                                }
                         }
			
                }
         	strcpy(str,"");
         }
         temp_paper[j]=END_ARR;
         fclose(f);
	 free(idSize);	
         return temp_paper;
}

static char**
get_mediaSizeEntry(MODEL_CONFIG_LIST* model)
{
	int i, size;
	short* arr;
	char** temp;
	char* str;

	if(model==NULL)
	{
		return NULL;
	}
	else
	{	
		arr=get_id_size(model,&size);
		
        	if(arr==NULL)
		{
			return NULL;
		}
		else
		{

			temp=(char**)malloc(size*sizeof(char *));
			if(temp==NULL)
			{
				pipsError(NULL,MEMORY_ERROR);
				free(arr);
				exit(1);
			}
			for(i=0;i<size;i++)
			{
				if(arr[i]==-1) break;
				str=getRscName(P_MEDIA_SIZE,arr[i]);
				*(temp+i)=(char *)malloc(strlen(str)+1);
				if(*(temp+i)==NULL)
	  			{
					pipsError(NULL,MEMORY_ERROR);
					free(arr);
					exit(1);
				}
        			strcpy(temp[i],str);
				
			}
			temp[i]=NULL;
			free(arr);
			return (char**)temp;
		}
		
	}
	
}


static char**
get_mediaTypeEntry(MODEL_CONFIG_LIST* model)
{
	int i, size;
	short* arr;
	char** temp;
	char* str;

	if(model==NULL)
	{
		return NULL;
	}
	else
	{	
		arr=get_id_type(model,&size);
        	if(arr==NULL)
		{
			return NULL;
		}
		else
		{

			temp=(char**)malloc(size*sizeof(char *));
			if(temp==NULL)
			{
				pipsError(NULL,MEMORY_ERROR);
				free(arr);
				exit(1);
			}
			for(i=0;i<size;i++)
			{
				if(arr[i]==-1) break;
				str=getRscName(P_MEDIA_TYPE,arr[i]);
				*(temp+i)=(char *)malloc(strlen(str)+1);
				if(*(temp+i)==NULL)
	  			{
					pipsError(NULL,MEMORY_ERROR);
					free(arr);
					exit(1);
				}
        			strcpy(temp[i],str);
				
			}
			temp[i]=NULL;
			free(arr);
			return (char**)temp;
		}
		
	}
	
	
}


static char**
get_levelEntry(MODEL_CONFIG_LIST* model)
{
	int i, size;
	short* arr;
	char** temp;
	char* str;

	if(model==NULL)
	{
		return NULL;
	}
	else
	{	
		arr=get_id_level(model,&size);
        	if(arr==NULL)
		{
			return NULL;
		}
		else
		{

			temp=(char**)malloc(size*sizeof(char *));
			if(temp==NULL)
			{
				pipsError(NULL,MEMORY_ERROR);
				free(arr);
				exit(1);
			}
			for(i=0;i<size;i++)
			{
				if(arr[i]==-1) break;
				str=getRscName(P_QUALITY_LEVEL,arr[i]);
				*(temp+i)=(char *)malloc(strlen(str)+1);
				if(*(temp+i)==NULL)
	  			{
					pipsError(NULL,MEMORY_ERROR);
					free(arr);
					exit(1);
				}
        			strcpy(temp[i],str);
				
			}
			temp[i]=NULL;
			free(arr);
			return (char**)temp;
		}
		
	}
	
	
}

/*--------------------------------------------------*/
/*         update_resource */
/*--------------------------------------------------*/
int 
update_resource(char* printer_id)
{

	FILE  *f;
	int argc, found, i, tempSize, tempType, tempT4, tempLevel, size;
	char str[MAX_LINE_LEN];
	Str100	argv[10];
        char buf[512]; /* printer peculiar max length */

	f=fopen(PRTOPT_PATH,"r");
	if(!f)
        {
		f=fopen(PRTOPT_PATH,"a+");
		if (!f)
		{
			fprintf (stderr, _("Resource file not found or resource not set. Do save with root.\n"));
			return 1;
		}
	}
/*	find printer_id;	*/
	found=0;
	while(!feof(f))
        {
        	fgets(str,MAX_LINE_LEN+1,f);
        	if(parse_line(str,&argc,argv)== LPR_PRINTER_ID) 
                {
                 	if(strcmp(argv[0],printer_id) ==0)
                        {
                        	found=1;
                        	break;
                        }
			
                }
        }
        fclose(f);
	if (found==1)
	{
		return 0;
	}
	if(get_printer_peculiar(buf,&size))
	{
		return 1;
	}
        if(check_format_failed(buf, size))
        {
		return 1;
        }
/*	Write into File		*/
	f=fopen(PRTOPT_PATH,"w+");
        if(!f)
        {
		pipsError(NULL,FAILED_FILE_ERROR);
		return 1;
	}
        fprintf(f,"[%s]\n",printer_id);
        
        for(i=9;i<size;i++)
        {
        	if(buf[i]=='S')
                {
                	tempSize=buf[i+1];
                        i+=2;
                        while(buf[i++]=='T') 
                        {
                        	tempType=buf[i++];
				if(tempType!=91 && tempType!=92)
				{
                        		if(buf[i]&0x80)
					{
						tempT4=1;
					}
                        		else
					{
						tempT4=0;
					}
                        		if(buf[i]&0x01) 
                        		{
                        			tempLevel=0;
                        			fprintf(f,"%d,%d,%d,%d\n",tempSize,tempType,tempLevel,tempT4);
                        		}
                        		if(buf[i]&0x02)
                        		{
                        			tempLevel=1;
                        			fprintf(f,"%d,%d,%d,%d\n",tempSize,tempType,tempLevel,tempT4);
                        		} 
                        		if(buf[i]&0x04)
                        		{
                        			tempLevel=2;
                        			fprintf(f,"%d,%d,%d,%d\n",tempSize,tempType,tempLevel,tempT4);
                        		}
				}
                        	i+=2;
                        }
			--i;
                }
        }
        fclose(f);

        return 0;
}
/*--------------------------------------------------*/
/*         get_default_printer_id */
/*--------------------------------------------------*/
int 
get_default_printer_id(char* printer_id)
{

	FILE  *f;
	int argc, found;
	char str[MAX_LINE_LEN];
	Str100	argv[10];

	f=fopen(PRTOPT_PATH,"r");
	if(!f)
        {
		return -1;
	}
	found=0;
	while(!feof(f))
        {
        	fgets(str,MAX_LINE_LEN+1,f);
        	if(parse_line(str,&argc,argv)== LPR_PRINTER_ID) 
                {
			strcpy(printer_id, argv[0]);
			found = 1;
			break;
			
                }
        }
        fclose(f);
	if (found==1)
	{
		return 0;
	}
        return -1;
}
/*--------------------------------------------------*/
/*          load_printer_option */
/*--------------------------------------------------*/
int
load_printer_option(char* printer_id)
{
	MODEL_CONFIG_LIST* model; 
	
	/* set resource flag */
	resource_alloc = 1;

 	model=get_model(printer_id,PRTOPT_PATH); 
	pMode=get_model_arr(model); 
 	levelEntry=get_levelEntry(model); 
 	mediaTypeEntry=get_mediaTypeEntry(model); 
 	mediaSizeEntry=get_mediaSizeEntry(model); 
        paper_auto=get_paper_auto(model,PAPER_PATH); 
        paper_auto_trim_4=get_paper_auto_trim_4(model,PAPER_PATH); 
 	free_list_model(model); 

	return 0;
}
/*--------------------------------------------------*/
/*          load_dummy_resource */
/*--------------------------------------------------*/
int
load_dummy_resource()
{
	PAPER_CONF temp_paper, END_ARR={NULL, -1, -1, -1, -1, -1, -1};
	/* set resource flag */
	resource_alloc = 1;

	/* Media Size */
	mediaSizeEntry = (char**) calloc (2,  sizeof(char*));
	if(mediaSizeEntry==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	mediaSizeEntry[0] = (char*) malloc (strlen ("A4") + 1);
	if(mediaSizeEntry[0]==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	strcpy (mediaSizeEntry[0], "A4");
	mediaSizeEntry[1] = NULL; 

	/* Media Type */
	mediaTypeEntry = (char**) calloc (2,  sizeof(char*));
	if(mediaTypeEntry==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	mediaTypeEntry[0] = (char*) malloc (strlen ("PLAIN") + 1);
	if(mediaTypeEntry[0]==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	strcpy (mediaTypeEntry[0], "PLAIN");
	mediaTypeEntry[1] = NULL; 

	/* Level Entry */
	levelEntry = (char**) calloc (2, sizeof(char*));
	if(levelEntry==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	levelEntry[0] = (char*) malloc (strlen ("NORMAL") +1 );
	if(levelEntry[0]==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	strcpy (levelEntry[0], "NORMAL");
	levelEntry[1] = NULL; 


	/* Mode Table */
	pMode = (short*) calloc (MODE_ITEM + 1, sizeof(short));
	if(pMode==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	pMode[MOFS_PAPER_SIZE] = PM_MSID_A4;
	pMode[MOFS_MEDIA]      = PM_MTID_PLAIN;
	pMode[MOFS_QUALITY]    = PIPS_LV_NORMAL;
	pMode[MOFS_BORDERLESS_PRINT] = PIPS_BL_OFF;
	pMode[MODE_ITEM]       = -1;  
	

	/* Paper Table */
	paper_auto        = (PAPER_CONF*) calloc(2,sizeof(PAPER_CONF));
	if(paper_auto==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	temp_paper.res = (char*) malloc(strlen("A4") + 1);
	if(temp_paper.res==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}

	strcpy(temp_paper.res, "A4");
	temp_paper.size_x = 2976;
	temp_paper.size_y = 4209;
	temp_paper.area_x = 2892;
	temp_paper.area_y = 3884;
	temp_paper.margin_x = 42;
	temp_paper.margin_y = 42;
	paper_auto[0] = temp_paper;

	paper_auto[1] = END_ARR;

	paper_auto_trim_4      = (PAPER_CONF*) malloc(2*sizeof(PAPER_CONF));
	if(paper_auto_trim_4==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	temp_paper.res = (char*) malloc(strlen("A4") + 1);
	if(temp_paper.res==NULL)
	{
		pipsError(NULL,MEMORY_ERROR);
		exit(1);
	}
	strcpy(temp_paper.res, "A4");
	temp_paper.size_x = 2976;
	temp_paper.size_y = 4209;
	temp_paper.area_x = 3048;
	temp_paper.area_y = 4308;
	temp_paper.margin_x = 0;
	temp_paper.margin_y = 0;
	paper_auto_trim_4[0] = temp_paper;

	paper_auto_trim_4[1] = END_ARR;
	
	return 0;
}



int
free_resource()
{
	int i;

	if (!resource_alloc)
		return 0;
	
	if(pMode!=NULL)
	{
		free(pMode);
		pMode=NULL;
	}
	
	if(mediaSizeEntry!=NULL) 
	{
		i=0;
		while(mediaSizeEntry[i]!=NULL)
		{
			free(mediaSizeEntry[i]);
			mediaSizeEntry[i]=NULL;
			i++;
		}
		free(mediaSizeEntry); 
		mediaSizeEntry=NULL;
		
	}
	if(mediaTypeEntry!=NULL) 
	{
		i=0;
		while(mediaTypeEntry[i]!=NULL)
		{
			free(mediaTypeEntry[i]);
			mediaTypeEntry[i]=NULL;
			i++;
		}
		free(mediaTypeEntry); 
		mediaTypeEntry=NULL;
	}
	if(levelEntry!=NULL) 
	{
		i=0;
		while(levelEntry[i]!=NULL)
		{
			free(levelEntry[i]);
			levelEntry[i]=NULL;
			i++;
		}
		free(levelEntry);
		levelEntry=NULL;
	}
	if(paper_auto!=NULL)
	{
		i=0;
		while(paper_auto[i].res!=NULL)
		{
			free(paper_auto[i].res);
			paper_auto[i].res=NULL;
			i++;
		}
        	free(paper_auto);
		paper_auto=NULL;
	}
        if(paper_auto_trim_4!=NULL)
	{
		i=0;
		while(paper_auto_trim_4[i].res!=NULL)
		{
			free(paper_auto_trim_4[i].res);
			paper_auto_trim_4[i].res=NULL;
			i++;
		}
		free(paper_auto_trim_4);
		paper_auto_trim_4=NULL;
	}
	/* reset resource flag */
	resource_alloc = 0;
	return 0;
}



