/*
 * Photo Image Print System
 * Copyright (C) 2000-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h>
#include "pfimg.h"
#include "pips.h"
#include "paper.h"
#include "getstat.h"

static BOOL
chenge_prtinfo (LP_PRT_STRUCT, SEP_INIT_PARAM*);
static char* chenge_resource (int, int);

int
graphics_converter_version2 (SEP_INIT_PARAM *lp_sepip, char* input, char* output)
{
	MKC_STRUCT mk_str;
	PRT_STRUCT prtinfo;

	char* input_files[] = { NULL, NULL };
	char lib_path[] = LIBPATH;

	if (strcmp (input, "STDIN"))
	{
		input_files[0]  = input;
		mk_str.input_files = input_files;
	}
	else
	{
		mk_str.input_files = NULL;
	}

	mk_str.output_file = output;
	mk_str.libprt_path = lib_path;
	
	if (chenge_prtinfo (&prtinfo, lp_sepip))
		return 1;
	mk_str.lp_prtinfo = &prtinfo;

	return (int)make_code_process (&mk_str);

}

static BOOL
chenge_prtinfo (LP_PRT_STRUCT lp_prtinfo, SEP_INIT_PARAM *lp_sepip)
{
	int resol;
	double area_y; /* $B2<C<(B3mm$B0u:~$G$N1i;;MQ(B */
	LP_PAPER_CONF lp_pconf;
	lp_prtinfo->paper         =  (int)lp_sepip->paper_id;								
	lp_prtinfo->ink           = lp_sepip->prt_format;
	lp_prtinfo->media_type    =  lp_sepip->media_type;								
	lp_prtinfo->qlevel        =  lp_sepip->qlevel;								
	lp_prtinfo->brightness    = lp_sepip->brightness;								
	lp_prtinfo->contrast      = lp_sepip->contrast;								
	lp_prtinfo->saturation    = lp_sepip->saturation;								
	lp_prtinfo->ratio.x       = lp_sepip->mag;								
	lp_prtinfo->ratio.y       = lp_prtinfo->ratio.x;								
	lp_prtinfo->borderless_print      = (int)lp_sepip->borderless_print;
	
	
	lp_pconf = call_paper_conf(lp_prtinfo->borderless_print, (char*) getRscName(P_MEDIA_SIZE,lp_prtinfo->paper));
	if (lp_pconf == NULL)						
		return 1;
	area_y = lp_pconf->area_y;
	resol = 360.0;
	

	if (strcmp (chenge_resource (P_FIT_PAGE, lp_sepip->fit_page), "ON"))
	{						
		if (MM_TO_DOT(lp_sepip->margin.x) >= (lp_pconf->margin_x + lp_pconf->area_x)) {
			lp_prtinfo->margin.x = (lp_pconf->margin_x + lp_pconf->area_x) * resol / 360 - 1;
		}
		else 
		{
			lp_prtinfo->margin.x = MM_TO_DOT(lp_sepip->margin.x) * resol / 360;
		}
		
		if (MM_TO_DOT(lp_sepip->margin.y) >= (lp_pconf->margin_y + area_y))
		{
			lp_prtinfo->margin.y = (lp_pconf->margin_y + area_y) * resol / 360 - 1;
		} else 
		{
			lp_prtinfo->margin.y = MM_TO_DOT(lp_sepip->margin.y) * resol / 360;
		}
		
		lp_prtinfo->fit_page = 0;
	}
	else
	{
		lp_prtinfo->margin.x = lp_pconf->margin_x * resol / 360;
		lp_prtinfo->margin.y = lp_pconf->margin_y * resol / 360;
		
		lp_prtinfo->fit_page = 1;
	}
	
	if (lp_sepip->borderless_print == 1)
	{					
		if ( lp_pconf->size_x < 4209 ) 
			lp_prtinfo->margin.x = -36;
		else
			lp_prtinfo->margin.x = -48;

		lp_prtinfo->margin.y = -42;
	}					
	lp_prtinfo->paper_size.x     = lp_pconf->size_x * resol / 360;
	lp_prtinfo->paper_size.y     = lp_pconf->size_y * resol / 360;
	lp_prtinfo->paper_area.x     = lp_pconf->area_x * resol / 360;
	lp_prtinfo->paper_area.y     = lp_pconf->area_y * resol / 360;
	lp_prtinfo->default_margin.x = lp_pconf->margin_x * resol / 360;
	lp_prtinfo->default_margin.y = lp_pconf->margin_y * resol / 360;
	
	return 0;
}

static char*
chenge_resource (int id, int val)
{
	OPTION_DATA* lp_data;
	
	lp_data = databasesCall (CALL_FOR_VALUE, id, (void*)(&val));
	return lp_data->rsc_name;
}
