/*
 * Photo Image Print System
 * Copyright (C) 2002-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "ppd_generator.h"
#include "definitions.h"
#include "support.h"

#ifndef PAPER_PATH
#define PAPER_PATH	"paper_list.csv"
#endif
#ifndef PRTOPT_PATH
#define PRTOPT_PATH		"prtopt.csv"
#endif

#define	MSG_CUPS001	_("PPD file need to be created for the printer to be registered to CUPS\nPlease make sure that the printer is connected to your computer and have it turned on!")
#define MSG_CUPS002	_("PPD file has been registered to /usr/share/cups/model\nPrinter name to be registered to CUPS is %s\nPlease register the printer to CUPS!")

#define	PPD_DIR		"/usr/share/cups/model/"

typedef struct MAIN_WINDOW_INFO
{
	char		model[100];
	char		prev_model[100];
	GtkWidget	*window;
	GtkButton	*continue_btn;
	GtkButton	*cancel_btn;
	GtkButton	*ok_btn;
	GtkHBox		*hbox;
	GtkVBox		*vbox;
	GtkLabel	*status_lbl;
	gint		onesec_tm;
	STATUS		status;
} MainWinNfo, *MainWinNfoHandle;

extern int get_printer_id(char* model);

extern int update_resource(char* id);

void on_continue_btn_clicked(GtkWidget* button, gpointer _hmain)
{
	MainWinNfoHandle hmain = (MainWinNfoHandle)_hmain;
	char	msg[255];
	hmain->status = ppd_generate(PPD_DIR);
	
	if (hmain->status == STS_SUCCESS)
	{
		/* show MSGCUPS002 message and exit */
		sprintf(msg, MSG_CUPS002, hmain->model);
		gtk_label_set_text(hmain->status_lbl, msg);
		gtk_widget_hide(GTK_WIDGET(hmain->continue_btn));
		gtk_widget_hide(GTK_WIDGET(hmain->cancel_btn));	
		gtk_widget_show(GTK_WIDGET(hmain->ok_btn));	
		gtk_timeout_remove(hmain->onesec_tm);
	}
	else
	{
		gtk_label_set_text(hmain->status_lbl, MSG_CUPS001);
		/* error happened, disable continue button */
		gtk_widget_set_sensitive(GTK_WIDGET(hmain->continue_btn), FALSE);
	}
}
 
gint on_timeout(gpointer _hmain)
{
	MainWinNfoHandle hmain = (MainWinNfoHandle)_hmain;
	
	if (get_printer_id(hmain->model) != 0)
	{
		hmain->model[0] = '\0';
		hmain->prev_model[0] = '\0';
		gtk_label_set_text(hmain->status_lbl, (gchar*)MSG_CUPS001);
		gtk_widget_set_sensitive(GTK_WIDGET(hmain->continue_btn), FALSE);
		return TRUE;
	}
	
	if (strcmp(hmain->prev_model, hmain->model) == 0)
		return TRUE;
	strcpy(hmain->prev_model, hmain->model);
	
	if (update_resource(hmain->model) != 0)
	{
		gtk_label_set_text(hmain->status_lbl, (gchar*)MSG_CUPS001);
		gtk_widget_set_sensitive(GTK_WIDGET(hmain->continue_btn), FALSE);
		return TRUE;
	}
	
	ppd_done();
	hmain->status = ppd_init(hmain->model, PAPER_PATH, PRTOPT_PATH);
	if (hmain->status != STS_SUCCESS)
	{
		gtk_label_set_text(hmain->status_lbl, MSG_CUPS001);
		gtk_widget_set_sensitive(GTK_WIDGET(hmain->continue_btn), FALSE);
		return TRUE;
	}
	gtk_label_set_text(hmain->status_lbl, _("Collected printer info required to build PPD file."));
	gtk_widget_set_sensitive(GTK_WIDGET(hmain->continue_btn), TRUE);
	
	return TRUE;
}

void on_close_app(GtkWidget* widget, gpointer _hmain)
{
	MainWinNfoHandle hmain = (MainWinNfoHandle)_hmain;
	gtk_timeout_remove(hmain->onesec_tm);
	ppd_done();
	gtk_main_quit();
}

int main(int argc, char* argv[])
{

	MainWinNfo mwnf;
	mwnf.prev_model[0]	= '\0';
	mwnf.model[0]		= '\0';
	mwnf.window		= NULL;
	mwnf.continue_btn	= NULL;
	mwnf.cancel_btn		= NULL;
	mwnf.hbox		= NULL;
	mwnf.vbox		= NULL;
	mwnf.status_lbl		= NULL;
	mwnf.onesec_tm		= 0;
	mwnf.status		= STS_SUCCESS;

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	gtk_set_locale ();
	gtk_init(&argc, &argv);

	/* create status label */
	mwnf.status_lbl = GTK_LABEL(gtk_label_new(_("Checking...\n")));

	/* create continue button */
	mwnf.continue_btn = GTK_BUTTON(gtk_button_new_with_label(_("Continue")));
	gtk_signal_connect(GTK_OBJECT(mwnf.continue_btn), "clicked",
		GTK_SIGNAL_FUNC(on_continue_btn_clicked), &mwnf);
	gtk_widget_set_sensitive(GTK_WIDGET(mwnf.continue_btn), FALSE);

	/* create cancel button */
	mwnf.cancel_btn = GTK_BUTTON(gtk_button_new_with_label(_("Cancel")));
	gtk_signal_connect(GTK_OBJECT(mwnf.cancel_btn), "clicked",
		GTK_SIGNAL_FUNC(on_close_app), &mwnf);

	/* create OK button */
	mwnf.ok_btn = GTK_BUTTON(gtk_button_new_with_label(_("OK")));
	gtk_signal_connect(GTK_OBJECT(mwnf.ok_btn), "clicked",
		GTK_SIGNAL_FUNC(on_close_app), &mwnf);
		
	/* create horizontal box */
	mwnf.hbox = GTK_HBOX(gtk_hbox_new(FALSE, 5));
	gtk_box_pack_start(GTK_BOX(mwnf.hbox), GTK_WIDGET(mwnf.continue_btn), TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(mwnf.hbox), GTK_WIDGET(mwnf.cancel_btn), TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(mwnf.hbox), GTK_WIDGET(mwnf.ok_btn), TRUE, TRUE, 5);

	/* create vertical box */
	mwnf.vbox = GTK_VBOX(gtk_vbox_new(FALSE, 5));
	gtk_box_pack_start(GTK_BOX(mwnf.vbox), GTK_WIDGET(mwnf.status_lbl), TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(mwnf.vbox), GTK_WIDGET(mwnf.hbox), TRUE, TRUE, 5);

	/* create main window */
	mwnf.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(mwnf.window), "destroy",
		GTK_SIGNAL_FUNC(on_close_app), &mwnf);
	gtk_window_set_position(GTK_WINDOW(mwnf.window), GTK_WIN_POS_CENTER);
	gtk_window_set_default_size(GTK_WINDOW(mwnf.window), 550, 100);
	gtk_container_add(GTK_CONTAINER(mwnf.window), GTK_WIDGET(mwnf.vbox));

	/* create timeout event */
	mwnf.onesec_tm = gtk_timeout_add(1000, on_timeout, &mwnf);

	/* show all windows */
	gtk_widget_show_all(mwnf.window);
	gtk_widget_hide(GTK_WIDGET(mwnf.ok_btn));

	/* main GTK process */
	gtk_main();
	
	return 0;
}

