/*
 * Photo Image Print System
 * Copyright (C) 2002-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */

#ifndef MAKEPPD_FILES_PARSER_H
#define MAKEPPD_FILES_PARSER_H
 
#include "utility.h"
#include "definitions.h"
#include "pips.h"

typedef char Str100[100];

typedef enum {
	FUCHI_NASI,
	FUCHI_ARI,
	FUCHI_NUM
} FUCHI;

typedef enum {
	QLT_DRAFT,
	QLT_NORMAL,
	QLT_HIGH,
	QLT_NUM
} QUALITY;


/* MediaTypeList class */
typedef struct MEDIATYPE_NODE {
	byte	media_type_id;
	bool	print_mode[FUCHI_NUM][QLT_NUM];
	struct MEDIATYPE_NODE	*next;
} MediaTypeNode, *MediaTypeNodeHandle;

PVOID* mediatype_getnext(PVOID item);
int mediatype_compare(const PVOID* item1, const PVOID* item2);
int mediatype_print(PVOID* item, PVOID user_data);
PVOID mediatype_init(byte _media_type_id);
void mediatype_done(PVOID* handle_adr);


/* PaperList class */


typedef struct PAPER_NODE {
	char		code[20];
	byte		id;
	Str100		name;
	PaperSize	size;
	PaperMargin	margin;
	struct PAPER_NODE	*next;
} PaperNode, *PaperNodeHandle;

PVOID* paper_getnext(PVOID item);
int paper_compare(const PVOID* item1, const PVOID* item2);
int paper_print(PVOID* item, PVOID user_data);
PaperNodeHandle paper_init(char* _code, byte _id, char* _name, 
	double _size_w, double _size_h, UNIT _size_u,
	double _margin_l, double _margin_t, double _margin_r, double _margin_b, UNIT _margin_u);
void paper_done(PVOID* handle_adr);


/* PrtOptList class */

typedef struct PRTOPT_NODE {
	byte	media_size_id;
	PaperNodeHandle	pnode;		/* pointer to a PaperNode having PaperNode::id = media_size_id */
	bool	borderless_supported;	/* be true in case at least one print-mode support fuchi-nasi */
	ListHandle	media_type_list;
	struct PRTOPT_NODE	*next;
} PrtOptNode, *PrtOptNodeHandle;

PVOID* prtopt_getnext(PVOID item);
int prtopt_compare(const PVOID* item1, const PVOID* item2);
int prtopt_print(PVOID* item, PVOID user_data);
PrtOptNodeHandle prtopt_init(byte _media_size_id, PaperNodeHandle _pnode);
void prtopt_done(PVOID* handle_adr);


/* Quality class */
typedef struct QUALITY_NODE {
	OPTION_DATA *opdat_handle;
	byte	quality_id;
	struct QUALITY_NODE	*next;
} QltyNode, *QltyNodeHandle;

PVOID* qlty_getnext(PVOID item);
int qlty_compare(const PVOID* item1, const PVOID* item2);
int qlty_print(PVOID* item, PVOID user_data);
QltyNodeHandle qlty_init(OPTION_DATA *_opdat_handle, byte _quality_id);
void qlty_done(PVOID* handle_adr);


/* File parsing functions */

STATUS parse_paperlist_file(const char	*paperlist_path, ListHandle paper_list);
STATUS parse_prtopt_file(const char *prtopt_path, const char* model, 
	const ListHandle paper_list, ListHandle	prtopt_list, ListHandle qlty_list);

#endif /* MAKEPPD_FILES_PARSER_H */

