/*
 * Photo Image Print System
 * Copyright (C) 2001-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2005.
 *
 * This file is part of the `ekpstm' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef INKBOX_H__
#define INKBOX_H__

#define INK_NUMBER 8	/* 2004.01.20 up to 8 */

enum Inkbox_Id
{
	INKBOX_K = 0,
	INKBOX_C,
	INKBOX_M,
	INKBOX_Y,
	INKBOX_LC,
	INKBOX_LM,
	INKBOX_DY,
	INKBOX_LK,
	INKBOX_MK,
	/* 2004.01.21 Added New Ink */
	INKBOX_R,	/* Red	    */
	INKBOX_V,	/* Violet   */
	INKBOX_CL	/* Clear    */
};

enum Inkset_Id
{
	INKSET_CMYKcmDY = 0,
	INKSET_CMYKcmLk
};

char ** inkbox_xpm_new (void);
void inkbox_xpm_ref (char **);
enum Inkset_Id inkbox_get_inkid( unsigned long id );
void inkbox_chenge_volume (char * [], unsigned long, int);
void inkbox_chenge_table (int);

#endif

