/*
 * Photo Image Print System Lite
 * Copyright (C) 2001-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2005.
 *
 * This file is part of the `ekpd' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __CBTD_WRAPPER_H__
#define __CBTD_WRAPPER_H__

#include "cbtd.h"

#define SID_CTRL 0x02		/* control channel */
#define SID_DATA 0x40		/* data channel */


int start_ecbt_engine (void);
int end_ecbt_engine (void);
int open_port_driver (P_CBTD_INFO);
int close_port_driver (P_CBTD_INFO);

int open_port_channel (P_CBTD_INFO, char);
int close_port_channel (P_CBTD_INFO, char);
int write_to_prt (P_CBTD_INFO, char, char*, int*);
int read_from_prt (P_CBTD_INFO, char, char*, int*);

#endif /* __CBTD_WRAPPER_H__ */
