/*
 * Photo Image Print System
 * Copyright (C) 2001-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2005.
 *
 * This file is part of the `ekpd' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission
 * to link the code of this program with the `cbt' library and
 * distribute linked combinations including the two.  You must obey
 * the GNU General Public License in all respects for all of the
 * code used other then `cbt'.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __CBTD_THREAD_H__
#define __CBTD_THREAD_H__

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <pthread.h>
#include "cbtd_def.h"
#include "cbtd.h"

/* information to do cleanup of a system */
typedef struct _CLEANUP_ARGS
{
  P_CBTD_INFO p_info;		/* ekpd infomation */
  int* p_max;			/* high limit of file descriptor */
  fd_set* p_fds;		/* Set of file descriptor */
} CARGS, *P_CARGS;

enum _SYS_FLAGS_WAIT_TYPES
{
  WAIT_SYS_OR = 0,  /* wait for even condition one if flags fill it */
  WAIT_SYS_AND		   /* wait if flags satisfy every condition */
};


HANDLE init_thread (int, void*, void*);
void delete_thread (HANDLE);
void wait_thread_down (void* , int);
void cancel_thread (void*);

HANDLE init_critical (void);
void enter_critical (HANDLE);
void leave_critical (HANDLE);
void delete_critical (HANDLE);

void set_sysflags (P_CBTD_INFO, int);
void reset_sysflags (P_CBTD_INFO, int);
int is_sysflags (P_CBTD_INFO, int);
int wait_sysflags (P_CBTD_INFO, int, int, int, int);


#endif /* __CBTD_THREAD_H__ */
